// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_CONTAINER_H
#define _GTKMM_CONTAINER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gtkmm/widget.h>


/** @defgroup Containers Container Widgets
 * These widgets can be used to group other widgets together.
 */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkContainer = struct _GtkContainer;
using GtkContainerClass = struct _GtkContainerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Container_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

class Adjustment;
class Label;

/** Abstract container class
 *
 * This is the abstract container from which all gtk+ widgets which hold
 * other items derive from.  It mainly houses virtual functions
 * used for inserting and removing children.  Containers in gtk+
 * may hold one item or many items depending on the implementation.
 *
 * This interface is used for all single item holding containers.
 * Multi-item containers provide their own unique interface as their
 * items are generally more complex.  The methods of the derived
 * classes should be prefered over these.
 *
 * @ingroup Widgets
 */

class Container : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Container CppObjectType;
  typedef Container_Class CppClassType;
  typedef GtkContainer BaseObjectType;
  typedef GtkContainerClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Container(Container&& src) noexcept;
  Container& operator=(Container&& src) noexcept;

  // noncopyable
  Container(const Container&) = delete;
  Container& operator=(const Container&) = delete;

  ~Container() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Container_Class;
  static CppClassType container_class_;

protected:
  explicit Container(const Glib::ConstructParams& construct_params);
  explicit Container(GtkContainer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkContainer*       gobj()       { return reinterpret_cast<GtkContainer*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkContainer* gobj() const { return reinterpret_cast<GtkContainer*>(gobject_); }

private:

public:

/* Application-level methods */

  
  /** Adds @a widget to @a container. Typically used for simple containers
   * such as Gtk::Window, Gtk::Frame, or Gtk::Button; for more complicated
   * layout containers such Gtk::Grid, this function will
   * pick default packing parameters that may not be correct.  So
   * consider functions such as Gtk::Grid::attach() as an alternative
   * to add() in those cases. A widget may be added to
   * only one container at a time; you can’t place the same widget
   * inside two different containers.
   * 
   * Note that some containers, such as Gtk::ScrolledWindow or Gtk::ListBox,
   * may add intermediate children between the added widget and the
   * container.
   * 
   * @param widget A widget to be placed inside @a container.
   */

  void add(Widget& widget);
  

  /** Removes @a widget from the container.
   * @a widget must be inside this container.
   * If @a widget is managed with Gtk::manage(), and you don't want to use @a widget
   * again, then you should delete it, because there will no longer be any parent
   * container to delete it automatically.
   *
   * What's said about ScrolledWindow in the documentation of Bin::remove()
   * applies also to Container::remove().
   *
   * @param widget A current child of the container.
   */
  void remove(Widget& widget);
  

  /** A slot to invoke with each child iterated over by foreach() or forall().
   * For instance,<br>
   * void on_foreach(Gtk::Widget& widget);
   */
  using ForeachSlot = sigc::slot<void(Widget&)>;

  /** Operate on contained items.
   *
   * Invokes the @a slot on each non-internal child of the container. See
   * forall() for details on what constitutes an
   * "internal" child.  Most applications should use foreach()
   * rather than forall().
   */
  void foreach(const ForeachSlot& slot);
  

  /** Operate on contained items, including internal children.
   *
   * Invokes the @a slot on each child of the container, including children
   * that are considered "internal" (implementation details of the
   * container). "Internal" children generally weren't added by the user
   * of the container, but were added by the container implementation
   * itself.  Most applications should use foreach(),
   * rather than forall().
   *
   * @newin{3,6}
   */
  void forall(const ForeachSlot& slot);
  

  /** Returns the container’s non-internal children. See
   * forall() for details on what constitutes an "internal" child.
   * 
   * @return A newly-allocated list of the container’s non-internal children.
   */
  std::vector<Widget*> get_children();
 

  /** Returns the container’s non-internal children. See
   * forall() for details on what constitutes an "internal" child.
   * 
   * @return A newly-allocated list of the container’s non-internal children.
   */
  std::vector<const Widget*> get_children() const;

/* Widget-level methods */

  
  /** Hooks up an adjustment to focus handling in a container, so when a
   * child of the container is focused, the adjustment is scrolled to
   * show that widget. This function sets the vertical alignment. See
   * Gtk::ScrolledWindow::get_vadjustment() for a typical way of obtaining
   * the adjustment and set_focus_hadjustment() for setting
   * the horizontal adjustment.
   * 
   * The adjustments have to be in pixel units and in the same coordinate
   * system as the allocation for immediate children of the container.
   * 
   * @param adjustment An adjustment which should be adjusted when the focus
   * is moved among the descendents of @a container.
   */
  void set_focus_vadjustment(const Glib::RefPtr<Adjustment>& adjustment);

  
  /** Retrieves the vertical focus adjustment for the container. See
   * set_focus_vadjustment().
   * 
   * @return The vertical focus adjustment, or
   * <tt>nullptr</tt> if none has been set.
   */
  Glib::RefPtr<Adjustment> get_focus_vadjustment();
  
  /** Retrieves the vertical focus adjustment for the container. See
   * set_focus_vadjustment().
   * 
   * @return The vertical focus adjustment, or
   * <tt>nullptr</tt> if none has been set.
   */
  Glib::RefPtr<const Adjustment> get_focus_vadjustment() const;

  
  /** Hooks up an adjustment to focus handling in a container, so when a child
   * of the container is focused, the adjustment is scrolled to show that
   * widget. This function sets the horizontal alignment.
   * See Gtk::ScrolledWindow::get_hadjustment() for a typical way of obtaining
   * the adjustment and set_focus_vadjustment() for setting
   * the vertical adjustment.
   * 
   * The adjustments have to be in pixel units and in the same coordinate
   * system as the allocation for immediate children of the container.
   * 
   * @param adjustment An adjustment which should be adjusted when the focus is
   * moved among the descendents of @a container.
   */
  void set_focus_hadjustment(const Glib::RefPtr<Adjustment>& adjustment);

  
  /** Retrieves the horizontal focus adjustment for the container. See
   * set_focus_hadjustment().
   * 
   * @return The horizontal focus adjustment, or <tt>nullptr</tt> if
   * none has been set.
   */
  Glib::RefPtr<Adjustment> get_focus_hadjustment();
  
  /** Retrieves the horizontal focus adjustment for the container. See
   * set_focus_hadjustment().
   * 
   * @return The horizontal focus adjustment, or <tt>nullptr</tt> if
   * none has been set.
   */
  Glib::RefPtr<const Adjustment> get_focus_hadjustment() const;

  
  /** Returns the type of the children supported by the container.
   * 
   * Note that this may return G_TYPE_NONE to indicate that no more
   * children can be added, e.g. for a Gtk::Paned which already has two
   * children.
   * 
   * @return A GType.
   */
  GType child_type() const;

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%add(Widget* widget)</tt>
   *
   * Flags: Run First
   *
   */

  Glib::SignalProxy<void(Widget*)> signal_add();


  //We use the optional custom_c_callback parameter with _WRAP_SIGNAL() here,
  //so that we can write special code to check for deleted child widget parameters:
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%remove(Widget* widget)</tt>
   *
   * Flags: Run First
   *
   */

  Glib::SignalProxy<void(Widget*)> signal_remove();


protected:
  Container();

  /** Implements child_type().
   *
   * The default implementation returns G_TYPE_NONE
   */
    virtual GType child_type_vfunc() const;


  /** Invokes a callback on all non-internal children of the container.
   *
   * "Internal" children generally weren't added by the user of the container,
   * but were added by the container implementation itself.
   *
   * %forall_vfunc() resembles foreach(): They don't invoke the callback for
   * internal children. forall() invokes it for all kinds of children.
   * Most applications should use foreach(), rather than forall().
   *
   * @param slot A slot to call for each non-internal child.
   */
    virtual void forall_vfunc(const ForeachSlot& slot);


  /** Sets the focused child of container.
   *
   * @param child The child widget.
   */
    virtual void set_focus_child_vfunc(Widget* child);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_add().
  virtual void on_add(Widget* widget);
  /// This is a default handler for the signal signal_remove().
  virtual void on_remove(Widget* widget);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Container
   */
  Gtk::Container* wrap(GtkContainer* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_CONTAINER_H */

