/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);
static GType vala_field_get_type_once (void);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	ValaSemanticAnalyzer* _tmp55_;
	ValaSemanticAnalyzer* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	ValaArrayType* _tmp74_;
	ValaExpression* _tmp86_;
	ValaExpression* _tmp87_;
	gboolean _tmp210_ = FALSE;
	ValaMemberBinding _tmp211_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp216_;
	ValaSymbol* _tmp217_;
	gboolean _tmp226_ = FALSE;
	gboolean _tmp227_ = FALSE;
	gboolean _tmp228_;
	gboolean _tmp229_;
	ValaSemanticAnalyzer* _tmp244_;
	ValaSemanticAnalyzer* _tmp245_;
	ValaSourceFile* _tmp246_;
	ValaSemanticAnalyzer* _tmp247_;
	ValaSemanticAnalyzer* _tmp248_;
	ValaSymbol* _tmp249_;
	gboolean _tmp250_;
	gboolean _tmp251_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("`%s' not supported as field type", _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp48_ = _tmp47_;
	vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
	_tmp49_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	if (!_tmp50_) {
		ValaSemanticAnalyzer* _tmp51_;
		ValaSemanticAnalyzer* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		_tmp51_ = vala_code_context_get_analyzer (context);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		vala_semantic_analyzer_check_type (_tmp52_, _tmp54_);
	}
	_tmp55_ = vala_code_context_get_analyzer (context);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp58_ = _tmp57_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp56_, (ValaSymbol*) self, _tmp58_)) {
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_code_node_to_string ((ValaCodeNode*) _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp64_, _tmp66_);
		_tmp68_ = _tmp67_;
		vala_report_error (_tmp60_, _tmp68_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp64_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp70_ = _tmp69_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp70_) ? ((ValaArrayType*) _tmp70_) : NULL;
	_tmp74_ = variable_array_type;
	if (_tmp74_ != NULL) {
		ValaArrayType* _tmp75_;
		gboolean _tmp76_;
		gboolean _tmp77_;
		_tmp75_ = variable_array_type;
		_tmp76_ = vala_array_type_get_fixed_length (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp73_ = _tmp77_;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp72_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp79_);
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		ValaExpression* _tmp80_;
		ValaExpression* _tmp81_;
		ValaInitializerList* _tmp82_;
		ValaInitializerList* _tmp83_;
		_tmp80_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp83_ = _tmp82_;
		_tmp71_ = _tmp83_ == NULL;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		ValaSourceReference* _tmp84_;
		ValaSourceReference* _tmp85_;
		_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp85_ = _tmp84_;
		vala_report_warning (_tmp85_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp87_ = _tmp86_;
	if (_tmp87_ != NULL) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp92_;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaExpression* _tmp101_;
		ValaDataType* _tmp102_;
		ValaDataType* _tmp103_;
		ValaExpression* _tmp106_;
		ValaExpression* _tmp107_;
		ValaDataType* _tmp108_;
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		ValaDataType* _tmp111_;
		gboolean _tmp126_ = FALSE;
		gboolean _tmp127_ = FALSE;
		gboolean _tmp128_ = FALSE;
		ValaArrayType* _tmp129_;
		gboolean _tmp143_ = FALSE;
		gboolean _tmp144_ = FALSE;
		ValaArrayType* _tmp145_;
		ValaExpression* _tmp155_;
		ValaExpression* _tmp156_;
		ValaDataType* _tmp157_;
		ValaDataType* _tmp158_;
		gboolean _tmp168_ = FALSE;
		ValaSymbol* _tmp169_;
		ValaSymbol* _tmp170_;
		gboolean _tmp175_ = FALSE;
		gboolean _tmp176_ = FALSE;
		ValaSymbol* _tmp177_;
		ValaSymbol* _tmp178_;
		gboolean _tmp192_ = FALSE;
		gboolean _tmp193_ = FALSE;
		gboolean _tmp194_ = FALSE;
		ValaMemberBinding _tmp195_;
		gboolean _tmp206_;
		gboolean _tmp207_;
		_tmp88_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp91_ = _tmp90_;
		vala_expression_set_target_type (_tmp89_, _tmp91_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp92_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp93_ = _tmp92_;
		if (VALA_IS_INITIALIZER_LIST (_tmp93_)) {
			ValaExpression* _tmp94_;
			ValaExpression* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			_tmp94_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp97_ = _tmp96_;
			initializer_size = _tmp97_;
			is_initializer_list = TRUE;
		}
		_tmp98_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp99_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp100_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_expression_get_value_type (_tmp101_);
		_tmp103_ = _tmp102_;
		if (_tmp103_ == NULL) {
			ValaSourceReference* _tmp104_;
			ValaSourceReference* _tmp105_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp105_ = _tmp104_;
			vala_report_error (_tmp105_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp106_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_expression_get_value_type (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp111_ = _tmp110_;
		if (!vala_data_type_compatible (_tmp109_, _tmp111_)) {
			ValaSourceReference* _tmp112_;
			ValaSourceReference* _tmp113_;
			ValaExpression* _tmp114_;
			ValaExpression* _tmp115_;
			ValaDataType* _tmp116_;
			ValaDataType* _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			ValaDataType* _tmp120_;
			ValaDataType* _tmp121_;
			gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_expression_get_value_type (_tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = vala_code_node_to_string ((ValaCodeNode*) _tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp121_ = _tmp120_;
			_tmp122_ = vala_code_node_to_string ((ValaCodeNode*) _tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp119_, _tmp123_);
			_tmp125_ = _tmp124_;
			vala_report_error (_tmp113_, _tmp125_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp123_);
			_g_free0 (_tmp119_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp129_ = variable_array_type;
		if (_tmp129_ != NULL) {
			ValaArrayType* _tmp130_;
			gboolean _tmp131_;
			gboolean _tmp132_;
			_tmp130_ = variable_array_type;
			_tmp131_ = vala_array_type_get_inline_allocated (_tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = _tmp132_;
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaArrayType* _tmp133_;
			gboolean _tmp134_;
			gboolean _tmp135_;
			_tmp133_ = variable_array_type;
			_tmp134_ = vala_array_type_get_fixed_length (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp127_ = !_tmp135_;
		} else {
			_tmp127_ = FALSE;
		}
		if (_tmp127_) {
			_tmp126_ = is_initializer_list;
		} else {
			_tmp126_ = FALSE;
		}
		if (_tmp126_) {
			ValaArrayType* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			ValaIntegerLiteral* _tmp139_;
			ValaIntegerLiteral* _tmp140_;
			ValaArrayType* _tmp141_;
			ValaArrayType* _tmp142_;
			_tmp136_ = variable_array_type;
			_tmp137_ = g_strdup_printf ("%i", initializer_size);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_integer_literal_new (_tmp138_, NULL);
			_tmp140_ = _tmp139_;
			vala_array_type_set_length (_tmp136_, (ValaExpression*) _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
			_g_free0 (_tmp138_);
			_tmp141_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp141_, TRUE);
			_tmp142_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp142_, FALSE);
		}
		_tmp145_ = variable_array_type;
		if (_tmp145_ != NULL) {
			ValaArrayType* _tmp146_;
			gboolean _tmp147_;
			gboolean _tmp148_;
			_tmp146_ = variable_array_type;
			_tmp147_ = vala_array_type_get_inline_allocated (_tmp146_);
			_tmp148_ = _tmp147_;
			_tmp144_ = _tmp148_;
		} else {
			_tmp144_ = FALSE;
		}
		if (_tmp144_) {
			ValaExpression* _tmp149_;
			ValaExpression* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			_tmp149_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_expression_get_value_type (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp143_ = !VALA_IS_ARRAY_TYPE (_tmp152_);
		} else {
			_tmp143_ = FALSE;
		}
		if (_tmp143_) {
			ValaSourceReference* _tmp153_;
			ValaSourceReference* _tmp154_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp154_ = _tmp153_;
			vala_report_error (_tmp154_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp155_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_expression_get_value_type (_tmp156_);
		_tmp158_ = _tmp157_;
		if (vala_data_type_is_disposable (_tmp158_)) {
			gboolean _tmp159_ = FALSE;
			ValaDataType* _tmp160_;
			ValaDataType* _tmp161_;
			_tmp160_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp161_ = _tmp160_;
			if (!VALA_IS_POINTER_TYPE (_tmp161_)) {
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				gboolean _tmp164_;
				gboolean _tmp165_;
				_tmp162_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_get_value_owned (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp159_ = !_tmp165_;
			} else {
				_tmp159_ = FALSE;
			}
			if (_tmp159_) {
				ValaSourceReference* _tmp166_;
				ValaSourceReference* _tmp167_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp167_ = _tmp166_;
				vala_report_error (_tmp167_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp169_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp170_ = _tmp169_;
		if (VALA_IS_NAMESPACE (_tmp170_)) {
			ValaExpression* _tmp171_;
			ValaExpression* _tmp172_;
			_tmp171_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp172_ = _tmp171_;
			_tmp168_ = !vala_expression_is_constant (_tmp172_);
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaSourceReference* _tmp173_;
			ValaSourceReference* _tmp174_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp174_ = _tmp173_;
			vala_report_error (_tmp174_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp177_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp178_ = _tmp177_;
		if (VALA_IS_NAMESPACE (_tmp178_)) {
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			_tmp179_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp180_ = _tmp179_;
			_tmp176_ = vala_expression_is_constant (_tmp180_);
		} else {
			_tmp176_ = FALSE;
		}
		if (_tmp176_) {
			ValaExpression* _tmp181_;
			ValaExpression* _tmp182_;
			_tmp181_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp182_ = _tmp181_;
			_tmp175_ = vala_expression_is_non_null (_tmp182_);
		} else {
			_tmp175_ = FALSE;
		}
		if (_tmp175_) {
			gboolean _tmp183_ = FALSE;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			_tmp184_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			if (vala_data_type_is_disposable (_tmp185_)) {
				ValaDataType* _tmp186_;
				ValaDataType* _tmp187_;
				gboolean _tmp188_;
				gboolean _tmp189_;
				_tmp186_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_data_type_get_value_owned (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp183_ = _tmp189_;
			} else {
				_tmp183_ = FALSE;
			}
			if (_tmp183_) {
				ValaSourceReference* _tmp190_;
				ValaSourceReference* _tmp191_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp191_ = _tmp190_;
				vala_report_error (_tmp191_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp195_ = self->priv->_binding;
		if (_tmp195_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp196_;
			ValaSymbol* _tmp197_;
			_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp197_ = _tmp196_;
			_tmp194_ = VALA_IS_CLASS (_tmp197_);
		} else {
			_tmp194_ = FALSE;
		}
		if (_tmp194_) {
			ValaSymbol* _tmp198_;
			ValaSymbol* _tmp199_;
			gboolean _tmp200_;
			gboolean _tmp201_;
			_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass));
			_tmp201_ = _tmp200_;
			_tmp193_ = _tmp201_;
		} else {
			_tmp193_ = FALSE;
		}
		if (_tmp193_) {
			ValaExpression* _tmp202_;
			ValaExpression* _tmp203_;
			_tmp202_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp203_ = _tmp202_;
			_tmp192_ = !vala_expression_is_constant (_tmp203_);
		} else {
			_tmp192_ = FALSE;
		}
		if (_tmp192_) {
			ValaSourceReference* _tmp204_;
			ValaSourceReference* _tmp205_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp205_ = _tmp204_;
			vala_report_error (_tmp205_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp206_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp207_ = _tmp206_;
		if (_tmp207_) {
			ValaSourceReference* _tmp208_;
			ValaSourceReference* _tmp209_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp209_ = _tmp208_;
			vala_report_error (_tmp209_, "External fields cannot use initializers");
		}
	}
	_tmp211_ = self->priv->_binding;
	if (_tmp211_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp212_;
		ValaSymbol* _tmp213_;
		_tmp212_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp213_ = _tmp212_;
		_tmp210_ = VALA_IS_INTERFACE (_tmp213_);
	} else {
		_tmp210_ = FALSE;
	}
	if (_tmp210_) {
		ValaSourceReference* _tmp214_;
		ValaSourceReference* _tmp215_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp215_ = _tmp214_;
		vala_report_error (_tmp215_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp216_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp217_ = _tmp216_;
	if (VALA_IS_CLASS (_tmp217_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp218_;
		ValaSymbol* _tmp219_;
		ValaClass* _tmp220_;
		gboolean _tmp221_ = FALSE;
		ValaClass* _tmp222_;
		gboolean _tmp223_;
		gboolean _tmp224_;
		_tmp218_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp219_ = _tmp218_;
		_tmp220_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp219_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp220_;
		_tmp222_ = cl;
		_tmp223_ = vala_class_get_is_compact (_tmp222_);
		_tmp224_ = _tmp223_;
		if (_tmp224_) {
			ValaClass* _tmp225_;
			_tmp225_ = cl;
			_tmp221_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp225_);
		} else {
			_tmp221_ = FALSE;
		}
		if (_tmp221_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp228_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp229_ = _tmp228_;
	if (!_tmp229_) {
		gboolean _tmp230_;
		gboolean _tmp231_;
		_tmp230_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp231_ = _tmp230_;
		_tmp227_ = !_tmp231_;
	} else {
		_tmp227_ = FALSE;
	}
	if (_tmp227_) {
		ValaSymbol* _tmp232_;
		ValaSymbol* _tmp233_;
		_tmp232_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp233_ = _tmp232_;
		_tmp226_ = _tmp233_ != NULL;
		_vala_code_node_unref0 (_tmp233_);
	} else {
		_tmp226_ = FALSE;
	}
	if (_tmp226_) {
		ValaSourceReference* _tmp234_;
		ValaSourceReference* _tmp235_;
		gchar* _tmp236_;
		gchar* _tmp237_;
		ValaSymbol* _tmp238_;
		ValaSymbol* _tmp239_;
		gchar* _tmp240_;
		gchar* _tmp241_;
		gchar* _tmp242_;
		gchar* _tmp243_;
		_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_symbol_get_full_name (_tmp239_);
		_tmp241_ = _tmp240_;
		_tmp242_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp237_, _tmp241_);
		_tmp243_ = _tmp242_;
		vala_report_warning (_tmp235_, _tmp243_);
		_g_free0 (_tmp243_);
		_g_free0 (_tmp241_);
		_vala_code_node_unref0 (_tmp239_);
		_g_free0 (_tmp237_);
	}
	_tmp244_ = vala_code_context_get_analyzer (context);
	_tmp245_ = _tmp244_;
	_tmp246_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp245_, _tmp246_);
	_tmp247_ = vala_code_context_get_analyzer (context);
	_tmp248_ = _tmp247_;
	_tmp249_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp248_, _tmp249_);
	_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp251_ = _tmp250_;
	result = !_tmp251_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
static GType
vala_field_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_field_type_id;
	vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
	g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
	return vala_field_type_id;
}

GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		GType vala_field_type_id;
		vala_field_type_id = vala_field_get_type_once ();
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

