/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_ != NULL;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp8_;
		}
	}
	_tmp9_ = self->priv->_is_compact;
	result = *_tmp9_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_ != NULL;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp8_;
		}
	}
	_tmp9_ = self->priv->_is_immutable;
	result = *_tmp9_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaLocalVariable* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		_tmp29_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			ValaScope* _tmp31_;
			ValaScope* _tmp32_;
			ValaLocalVariable* _tmp33_;
			ValaLocalVariable* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_scope_remove (_tmp32_, _tmp36_);
		}
		_tmp37_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_data_type_copy (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_local_variable_new (_tmp40_, "result", NULL, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
		_vala_code_node_unref0 (_tmp40_);
		_tmp45_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp46_ = _tmp45_;
		vala_local_variable_set_is_result (_tmp46_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp49_ = FALSE;
		ValaCreationMethod* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp47_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp50_ = cm;
		_tmp51_ = vala_creation_method_get_class_name (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ != NULL) {
			ValaCreationMethod* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			_tmp53_ = cm;
			_tmp54_ = vala_creation_method_get_class_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp57_ = _tmp56_;
			_tmp49_ = g_strcmp0 (_tmp55_, _tmp57_) != 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaSourceReference* _tmp58_;
			ValaSourceReference* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			ValaCreationMethod* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = cm;
			_tmp63_ = vala_creation_method_get_class_name (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp61_, _tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp59_, _tmp66_);
			_g_free0 (_tmp66_);
			_g_free0 (_tmp61_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp14_;
	ValaField* _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_parameter_new ("this", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		vala_property_set_this_parameter (prop, _tmp5_);
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_property_get_this_parameter (prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		vala_scope_add (_tmp7_, _tmp11_, (ValaSymbol*) _tmp13_);
	}
	_tmp14_ = vala_property_get_field (prop);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaField* _tmp16_;
		ValaField* _tmp17_;
		_tmp16_ = vala_property_get_field (prop);
		_tmp17_ = _tmp16_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp17_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_constructor_set_this_parameter (c, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_constructor_get_this_parameter (c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_constructor_get_this_parameter (c);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_destructor_set_this_parameter (d, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_destructor_get_this_parameter (d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_destructor_get_this_parameter (d);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp8_;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp12_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp16_;
	ValaConstructor* _tmp17_;
	ValaDestructor* _tmp20_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp24_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp28_;
	ValaDestructor* _tmp29_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp8_ = vala_class_get_constructor (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaConstructor* _tmp10_;
		ValaConstructor* _tmp11_;
		_tmp10_ = vala_class_get_constructor (self);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
	}
	_tmp12_ = vala_class_get_class_constructor (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaConstructor* _tmp14_;
		ValaConstructor* _tmp15_;
		_tmp14_ = vala_class_get_class_constructor (self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	}
	_tmp16_ = vala_class_get_static_constructor (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaConstructor* _tmp18_;
		ValaConstructor* _tmp19_;
		_tmp18_ = vala_class_get_static_constructor (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
	_tmp20_ = vala_class_get_destructor (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaDestructor* _tmp22_;
		ValaDestructor* _tmp23_;
		_tmp22_ = vala_class_get_destructor (self);
		_tmp23_ = _tmp22_;
		vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
	}
	_tmp24_ = vala_class_get_static_destructor (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaDestructor* _tmp26_;
		ValaDestructor* _tmp27_;
		_tmp26_ = vala_class_get_static_destructor (self);
		_tmp27_ = _tmp26_;
		vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
	}
	_tmp28_ = vala_class_get_class_destructor (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		ValaDestructor* _tmp30_;
		ValaDestructor* _tmp31_;
		_tmp30_ = vala_class_get_class_destructor (self);
		_tmp31_ = _tmp30_;
		vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp13_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prereq_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp5_ = _prereq_list;
			_tmp6_ = vala_list_get (_tmp5_, _prereq_index);
			prereq = (ValaDataType*) _tmp6_;
			_tmp7_ = prereq;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (_tmp9_);
			type = _tmp10_;
			_tmp11_ = type;
			if (_tmp11_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp12_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp12_);
			_tmp13_ = type;
			if (VALA_IS_INTERFACE (_tmp13_)) {
				ValaTypeSymbol* _tmp14_;
				_tmp14_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp7_ = base_type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (VALA_IS_CLASS (_tmp9_)) {
				ValaDataType* _tmp10_;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp10_ = base_type;
				_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
				_tmp12_ = _tmp11_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp7_ = base_type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp86_ = FALSE;
	ValaClass* _tmp87_;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	gboolean _tmp114_;
	ValaConstructor* _tmp203_;
	ValaConstructor* _tmp204_;
	ValaConstructor* _tmp207_;
	ValaConstructor* _tmp208_;
	ValaConstructor* _tmp211_;
	ValaConstructor* _tmp212_;
	ValaDestructor* _tmp215_;
	ValaDestructor* _tmp216_;
	ValaDestructor* _tmp219_;
	ValaDestructor* _tmp220_;
	ValaDestructor* _tmp223_;
	ValaDestructor* _tmp224_;
	gboolean _tmp259_;
	gboolean _tmp260_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp301_;
	ValaArrayList* _tmp302_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp317_;
	ValaArrayList* _tmp318_;
	ValaList* _tmp331_;
	gint _tmp332_;
	gint _tmp333_;
	ValaSourceFileType _tmp356_;
	ValaSourceFileType _tmp357_;
	ValaSemanticAnalyzer* _tmp578_;
	ValaSemanticAnalyzer* _tmp579_;
	ValaSourceFile* _tmp580_;
	ValaSemanticAnalyzer* _tmp581_;
	ValaSemanticAnalyzer* _tmp582_;
	ValaSymbol* _tmp583_;
	gboolean _tmp584_;
	gboolean _tmp585_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_base_type_reference_list = _tmp25_;
		_tmp26_ = _base_type_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_base_type_reference_size = _tmp28_;
		_base_type_reference_index = -1;
		while (TRUE) {
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp29_;
			gpointer _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaDataType* _tmp44_;
			gint n_type_args = 0;
			ValaDataType* _tmp54_;
			ValaList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint n_type_params = 0;
			ValaDataType* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			ValaList* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			_base_type_reference_index = _base_type_reference_index + 1;
			if (!(_base_type_reference_index < _base_type_reference_size)) {
				break;
			}
			_tmp29_ = _base_type_reference_list;
			_tmp30_ = vala_list_get (_tmp29_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp30_;
			_tmp31_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp31_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp32_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp32_)) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaDataType* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = base_type_reference;
				_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp37_, _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp34_, _tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp43_, (ValaSymbol*) self, _tmp44_)) {
				ValaSourceReference* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaDataType* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp46_ = _tmp45_;
				_tmp47_ = base_type_reference;
				_tmp48_ = vala_code_node_to_string ((ValaCodeNode*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp49_, _tmp51_);
				_tmp53_ = _tmp52_;
				vala_report_error (_tmp46_, _tmp53_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp54_ = base_type_reference;
			_tmp55_ = vala_data_type_get_type_arguments (_tmp54_);
			_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			n_type_args = _tmp57_;
			_tmp58_ = base_type_reference;
			_tmp59_ = vala_data_type_get_type_symbol (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
			_tmp63_ = _tmp62_;
			n_type_params = _tmp63_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp64_ = base_type_reference;
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
				_tmp66_ = _tmp65_;
				vala_report_error (_tmp66_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp67_;
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp67_ = base_type_reference;
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
					_tmp69_ = _tmp68_;
					vala_report_error (_tmp69_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp70_;
		ValaList* _tmp71_;
		gint _type_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _type_index = 0;
		_tmp70_ = self->priv->base_types;
		_tmp71_ = _vala_iterable_ref0 (_tmp70_);
		_type_list = _tmp71_;
		_tmp72_ = _type_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_type_size = _tmp74_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp75_;
			gpointer _tmp76_;
			ValaDataType* _tmp77_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp75_ = _type_list;
			_tmp76_ = vala_list_get (_tmp75_, _type_index);
			type = (ValaDataType*) _tmp76_;
			_tmp77_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp77_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp78_;
		ValaList* _tmp79_;
		gint _p_size = 0;
		ValaList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _p_index = 0;
		_tmp78_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp79_ = _vala_iterable_ref0 (_tmp78_);
		_p_list = _tmp79_;
		_tmp80_ = _p_list;
		_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_p_size = _tmp82_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp83_;
			gpointer _tmp84_;
			ValaTypeParameter* _tmp85_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp83_ = _p_list;
			_tmp84_ = vala_list_get (_tmp83_, _p_index);
			p = (ValaTypeParameter*) _tmp84_;
			_tmp85_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp85_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp87_ = self->priv->_base_class;
	if (_tmp87_ != NULL) {
		ValaClass* _tmp88_;
		gboolean _tmp89_;
		gboolean _tmp90_;
		_tmp88_ = self->priv->_base_class;
		_tmp89_ = vala_class_get_is_singleton (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp86_ = _tmp90_;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		ValaSourceReference* _tmp91_;
		ValaSourceReference* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		ValaClass* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = self->priv->_base_class;
		_tmp96_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp94_, _tmp97_);
		_tmp99_ = _tmp98_;
		vala_report_error (_tmp92_, _tmp99_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp94_);
	}
	_tmp101_ = vala_class_get_is_singleton (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_) {
		ValaSemanticAnalyzer* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaClass* _tmp105_;
		_tmp103_ = vala_code_context_get_analyzer (context);
		_tmp104_ = _tmp103_;
		_tmp105_ = _tmp104_->object_type;
		_tmp100_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp105_);
	} else {
		_tmp100_ = FALSE;
	}
	if (_tmp100_) {
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp109_);
		_tmp111_ = _tmp110_;
		vala_report_error (_tmp107_, _tmp111_);
		_g_free0 (_tmp111_);
		_g_free0 (_tmp109_);
	}
	_tmp113_ = vala_class_get_is_singleton (self);
	_tmp114_ = _tmp113_;
	if (_tmp114_) {
		ValaConstructor* _tmp115_;
		ValaConstructor* _tmp116_;
		_tmp115_ = vala_class_get_constructor (self);
		_tmp116_ = _tmp115_;
		_tmp112_ = _tmp116_ == NULL;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		ValaConstructor* _tmp119_;
		ValaConstructor* _tmp120_;
		ValaSourceReference* _tmp121_;
		ValaSourceReference* _tmp122_;
		ValaBlock* _tmp123_;
		ValaBlock* _tmp124_;
		ValaConstructor* _tmp125_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_constructor_new (_tmp118_);
		c = _tmp119_;
		_tmp120_ = c;
		_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_block_new (_tmp122_);
		_tmp124_ = _tmp123_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp120_, _tmp124_);
		_vala_code_node_unref0 (_tmp124_);
		_tmp125_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp125_);
		_vala_code_node_unref0 (c);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp126_;
		ValaList* _tmp127_;
		gint _en_size = 0;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gint _en_index = 0;
		_tmp126_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp127_ = _vala_iterable_ref0 (_tmp126_);
		_en_list = _tmp127_;
		_tmp128_ = _en_list;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		_en_size = _tmp130_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp131_;
			gpointer _tmp132_;
			ValaEnum* _tmp133_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp131_ = _en_list;
			_tmp132_ = vala_list_get (_tmp131_, _en_index);
			en = (ValaEnum*) _tmp132_;
			_tmp133_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp133_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp134_;
		ValaList* _tmp135_;
		gint _f_size = 0;
		ValaList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _f_index = 0;
		_tmp134_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp135_ = _vala_iterable_ref0 (_tmp134_);
		_f_list = _tmp135_;
		_tmp136_ = _f_list;
		_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_f_size = _tmp138_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp139_;
			gpointer _tmp140_;
			gboolean _tmp141_ = FALSE;
			gboolean _tmp142_;
			gboolean _tmp143_;
			ValaField* _tmp161_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp139_ = _f_list;
			_tmp140_ = vala_list_get (_tmp139_, _f_index);
			f = (ValaField*) _tmp140_;
			_tmp142_ = vala_class_get_is_compact (self);
			_tmp143_ = _tmp142_;
			if (_tmp143_) {
				ValaField* _tmp144_;
				ValaMemberBinding _tmp145_;
				ValaMemberBinding _tmp146_;
				_tmp144_ = f;
				_tmp145_ = vala_field_get_binding (_tmp144_);
				_tmp146_ = _tmp145_;
				_tmp141_ = _tmp146_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp141_ = FALSE;
			}
			if (_tmp141_) {
				gboolean _tmp147_ = FALSE;
				gboolean _tmp148_;
				gboolean _tmp149_;
				ValaField* _tmp155_;
				ValaMemberBinding _tmp156_;
				ValaMemberBinding _tmp157_;
				_tmp148_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp149_ = _tmp148_;
				if (!_tmp149_) {
					ValaField* _tmp150_;
					ValaSymbolAccessibility _tmp151_;
					ValaSymbolAccessibility _tmp152_;
					_tmp150_ = f;
					_tmp151_ = vala_symbol_get_access ((ValaSymbol*) _tmp150_);
					_tmp152_ = _tmp151_;
					_tmp147_ = _tmp152_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp147_ = FALSE;
				}
				if (_tmp147_) {
					ValaSourceReference* _tmp153_;
					ValaSourceReference* _tmp154_;
					_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp154_ = _tmp153_;
					vala_report_error (_tmp154_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp155_ = f;
				_tmp156_ = vala_field_get_binding (_tmp155_);
				_tmp157_ = _tmp156_;
				if (_tmp157_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp158_;
					ValaSourceReference* _tmp159_;
					ValaSourceReference* _tmp160_;
					_tmp158_ = f;
					_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp158_);
					_tmp160_ = _tmp159_;
					vala_report_error (_tmp160_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp161_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp161_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp162_;
		ValaList* _tmp163_;
		gint _c_size = 0;
		ValaList* _tmp164_;
		gint _tmp165_;
		gint _tmp166_;
		gint _c_index = 0;
		_tmp162_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp163_ = _vala_iterable_ref0 (_tmp162_);
		_c_list = _tmp163_;
		_tmp164_ = _c_list;
		_tmp165_ = vala_collection_get_size ((ValaCollection*) _tmp164_);
		_tmp166_ = _tmp165_;
		_c_size = _tmp166_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp167_;
			gpointer _tmp168_;
			ValaConstant* _tmp169_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp167_ = _c_list;
			_tmp168_ = vala_list_get (_tmp167_, _c_index);
			c = (ValaConstant*) _tmp168_;
			_tmp169_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp169_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp170_;
		ValaList* _tmp171_;
		gint _m_size = 0;
		ValaList* _tmp172_;
		gint _tmp173_;
		gint _tmp174_;
		gint _m_index = 0;
		_tmp170_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_tmp171_ = _vala_iterable_ref0 (_tmp170_);
		_m_list = _tmp171_;
		_tmp172_ = _m_list;
		_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
		_tmp174_ = _tmp173_;
		_m_size = _tmp174_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp175_;
			gpointer _tmp176_;
			ValaMethod* _tmp177_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp175_ = _m_list;
			_tmp176_ = vala_list_get (_tmp175_, _m_index);
			m = (ValaMethod*) _tmp176_;
			_tmp177_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp177_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp178_;
		ValaList* _tmp179_;
		gint _prop_size = 0;
		ValaList* _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _prop_index = 0;
		_tmp178_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_tmp179_ = _vala_iterable_ref0 (_tmp178_);
		_prop_list = _tmp179_;
		_tmp180_ = _prop_list;
		_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
		_tmp182_ = _tmp181_;
		_prop_size = _tmp182_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp183_;
			gpointer _tmp184_;
			gboolean _tmp185_ = FALSE;
			ValaProperty* _tmp186_;
			ValaAttribute* _tmp187_;
			ValaProperty* _tmp194_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp183_ = _prop_list;
			_tmp184_ = vala_list_get (_tmp183_, _prop_index);
			prop = (ValaProperty*) _tmp184_;
			_tmp186_ = prop;
			_tmp187_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp186_, "NoAccessorMethod");
			if (_tmp187_ != NULL) {
				ValaSemanticAnalyzer* _tmp188_;
				ValaSemanticAnalyzer* _tmp189_;
				ValaClass* _tmp190_;
				_tmp188_ = vala_code_context_get_analyzer (context);
				_tmp189_ = _tmp188_;
				_tmp190_ = _tmp189_->object_type;
				_tmp185_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp190_);
			} else {
				_tmp185_ = FALSE;
			}
			if (_tmp185_) {
				ValaProperty* _tmp191_;
				ValaSourceReference* _tmp192_;
				ValaSourceReference* _tmp193_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp191_ = prop;
				_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp191_);
				_tmp193_ = _tmp192_;
				vala_report_error (_tmp193_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp194_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp194_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp195_;
		ValaList* _tmp196_;
		gint _sig_size = 0;
		ValaList* _tmp197_;
		gint _tmp198_;
		gint _tmp199_;
		gint _sig_index = 0;
		_tmp195_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_tmp196_ = _vala_iterable_ref0 (_tmp195_);
		_sig_list = _tmp196_;
		_tmp197_ = _sig_list;
		_tmp198_ = vala_collection_get_size ((ValaCollection*) _tmp197_);
		_tmp199_ = _tmp198_;
		_sig_size = _tmp199_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp200_;
			gpointer _tmp201_;
			ValaSignal* _tmp202_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp200_ = _sig_list;
			_tmp201_ = vala_list_get (_tmp200_, _sig_index);
			sig = (ValaSignal*) _tmp201_;
			_tmp202_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp202_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp203_ = vala_class_get_constructor (self);
	_tmp204_ = _tmp203_;
	if (_tmp204_ != NULL) {
		ValaConstructor* _tmp205_;
		ValaConstructor* _tmp206_;
		_tmp205_ = vala_class_get_constructor (self);
		_tmp206_ = _tmp205_;
		vala_code_node_check ((ValaCodeNode*) _tmp206_, context);
	}
	_tmp207_ = vala_class_get_class_constructor (self);
	_tmp208_ = _tmp207_;
	if (_tmp208_ != NULL) {
		ValaConstructor* _tmp209_;
		ValaConstructor* _tmp210_;
		_tmp209_ = vala_class_get_class_constructor (self);
		_tmp210_ = _tmp209_;
		vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
	}
	_tmp211_ = vala_class_get_static_constructor (self);
	_tmp212_ = _tmp211_;
	if (_tmp212_ != NULL) {
		ValaConstructor* _tmp213_;
		ValaConstructor* _tmp214_;
		_tmp213_ = vala_class_get_static_constructor (self);
		_tmp214_ = _tmp213_;
		vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
	}
	_tmp215_ = vala_class_get_destructor (self);
	_tmp216_ = _tmp215_;
	if (_tmp216_ != NULL) {
		ValaDestructor* _tmp217_;
		ValaDestructor* _tmp218_;
		_tmp217_ = vala_class_get_destructor (self);
		_tmp218_ = _tmp217_;
		vala_code_node_check ((ValaCodeNode*) _tmp218_, context);
	}
	_tmp219_ = vala_class_get_static_destructor (self);
	_tmp220_ = _tmp219_;
	if (_tmp220_ != NULL) {
		ValaDestructor* _tmp221_;
		ValaDestructor* _tmp222_;
		_tmp221_ = vala_class_get_static_destructor (self);
		_tmp222_ = _tmp221_;
		vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
	}
	_tmp223_ = vala_class_get_class_destructor (self);
	_tmp224_ = _tmp223_;
	if (_tmp224_ != NULL) {
		ValaDestructor* _tmp225_;
		ValaDestructor* _tmp226_;
		_tmp225_ = vala_class_get_class_destructor (self);
		_tmp226_ = _tmp225_;
		vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp227_;
		ValaList* _tmp228_;
		gint _cl_size = 0;
		ValaList* _tmp229_;
		gint _tmp230_;
		gint _tmp231_;
		gint _cl_index = 0;
		_tmp227_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp228_ = _vala_iterable_ref0 (_tmp227_);
		_cl_list = _tmp228_;
		_tmp229_ = _cl_list;
		_tmp230_ = vala_collection_get_size ((ValaCollection*) _tmp229_);
		_tmp231_ = _tmp230_;
		_cl_size = _tmp231_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp232_;
			gpointer _tmp233_;
			ValaClass* _tmp234_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp232_ = _cl_list;
			_tmp233_ = vala_list_get (_tmp232_, _cl_index);
			cl = (ValaClass*) _tmp233_;
			_tmp234_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp234_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp235_;
		ValaList* _tmp236_;
		gint _iface_size = 0;
		ValaList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _iface_index = 0;
		_tmp235_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp236_ = _vala_iterable_ref0 (_tmp235_);
		_iface_list = _tmp236_;
		_tmp237_ = _iface_list;
		_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_iface_size = _tmp239_;
		_iface_index = -1;
		while (TRUE) {
			ValaInterface* iface = NULL;
			ValaList* _tmp240_;
			gpointer _tmp241_;
			ValaInterface* _tmp242_;
			_iface_index = _iface_index + 1;
			if (!(_iface_index < _iface_size)) {
				break;
			}
			_tmp240_ = _iface_list;
			_tmp241_ = vala_list_get (_tmp240_, _iface_index);
			iface = (ValaInterface*) _tmp241_;
			_tmp242_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp243_;
		ValaList* _tmp244_;
		gint _st_size = 0;
		ValaList* _tmp245_;
		gint _tmp246_;
		gint _tmp247_;
		gint _st_index = 0;
		_tmp243_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp244_ = _vala_iterable_ref0 (_tmp243_);
		_st_list = _tmp244_;
		_tmp245_ = _st_list;
		_tmp246_ = vala_collection_get_size ((ValaCollection*) _tmp245_);
		_tmp247_ = _tmp246_;
		_st_size = _tmp247_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp248_;
			gpointer _tmp249_;
			ValaStruct* _tmp250_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp248_ = _st_list;
			_tmp249_ = vala_list_get (_tmp248_, _st_index);
			st = (ValaStruct*) _tmp249_;
			_tmp250_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp250_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp251_;
		ValaList* _tmp252_;
		gint _d_size = 0;
		ValaList* _tmp253_;
		gint _tmp254_;
		gint _tmp255_;
		gint _d_index = 0;
		_tmp251_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp252_ = _vala_iterable_ref0 (_tmp251_);
		_d_list = _tmp252_;
		_tmp253_ = _d_list;
		_tmp254_ = vala_collection_get_size ((ValaCollection*) _tmp253_);
		_tmp255_ = _tmp254_;
		_d_size = _tmp255_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp256_;
			gpointer _tmp257_;
			ValaDelegate* _tmp258_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp256_ = _d_list;
			_tmp257_ = vala_list_get (_tmp256_, _d_index);
			d = (ValaDelegate*) _tmp257_;
			_tmp258_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp258_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp259_ = vala_class_get_is_compact (self);
	_tmp260_ = _tmp259_;
	if (_tmp260_) {
		gboolean _tmp277_ = FALSE;
		gboolean _tmp278_ = FALSE;
		gboolean _tmp279_ = FALSE;
		gboolean _tmp280_;
		gboolean _tmp281_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp261_;
			ValaList* _tmp262_;
			gint _base_type_size = 0;
			ValaList* _tmp263_;
			gint _tmp264_;
			gint _tmp265_;
			gint _base_type_index = 0;
			_tmp261_ = vala_class_get_base_types (self);
			_tmp262_ = _vala_iterable_ref0 (_tmp261_);
			_base_type_list = _tmp262_;
			_tmp263_ = _base_type_list;
			_tmp264_ = vala_collection_get_size ((ValaCollection*) _tmp263_);
			_tmp265_ = _tmp264_;
			_base_type_size = _tmp265_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp266_;
				gpointer _tmp267_;
				ValaDataType* _tmp268_;
				ValaTypeSymbol* _tmp269_;
				ValaTypeSymbol* _tmp270_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp266_ = _base_type_list;
				_tmp267_ = vala_list_get (_tmp266_, _base_type_index);
				base_type = (ValaDataType*) _tmp267_;
				_tmp268_ = base_type;
				_tmp269_ = vala_data_type_get_type_symbol (_tmp268_);
				_tmp270_ = _tmp269_;
				if (VALA_IS_INTERFACE (_tmp270_)) {
					ValaSourceReference* _tmp271_;
					ValaSourceReference* _tmp272_;
					gchar* _tmp273_;
					gchar* _tmp274_;
					gchar* _tmp275_;
					gchar* _tmp276_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp272_ = _tmp271_;
					_tmp273_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp274_ = _tmp273_;
					_tmp275_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp274_);
					_tmp276_ = _tmp275_;
					vala_report_error (_tmp272_, _tmp276_);
					_g_free0 (_tmp276_);
					_g_free0 (_tmp274_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp280_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp281_ = _tmp280_;
		if (!_tmp281_) {
			gboolean _tmp282_;
			gboolean _tmp283_;
			_tmp282_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp283_ = _tmp282_;
			_tmp279_ = !_tmp283_;
		} else {
			_tmp279_ = FALSE;
		}
		if (_tmp279_) {
			ValaClass* _tmp284_;
			_tmp284_ = self->priv->_base_class;
			_tmp278_ = _tmp284_ != NULL;
		} else {
			_tmp278_ = FALSE;
		}
		if (_tmp278_) {
			ValaClass* _tmp285_;
			ValaSemanticAnalyzer* _tmp286_;
			ValaSemanticAnalyzer* _tmp287_;
			ValaClass* _tmp288_;
			_tmp285_ = self->priv->_base_class;
			_tmp286_ = vala_code_context_get_analyzer (context);
			_tmp287_ = _tmp286_;
			_tmp288_ = _tmp287_->gsource_type;
			_tmp277_ = _tmp285_ != _tmp288_;
		} else {
			_tmp277_ = FALSE;
		}
		if (_tmp277_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp289_;
				ValaList* _tmp290_;
				gint _f_size = 0;
				ValaList* _tmp291_;
				gint _tmp292_;
				gint _tmp293_;
				gint _f_index = 0;
				_tmp289_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_tmp290_ = _vala_iterable_ref0 (_tmp289_);
				_f_list = _tmp290_;
				_tmp291_ = _f_list;
				_tmp292_ = vala_collection_get_size ((ValaCollection*) _tmp291_);
				_tmp293_ = _tmp292_;
				_f_size = _tmp293_;
				_f_index = -1;
				while (TRUE) {
					ValaField* f = NULL;
					ValaList* _tmp294_;
					gpointer _tmp295_;
					ValaField* _tmp296_;
					ValaMemberBinding _tmp297_;
					ValaMemberBinding _tmp298_;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp294_ = _f_list;
					_tmp295_ = vala_list_get (_tmp294_, _f_index);
					f = (ValaField*) _tmp295_;
					_tmp296_ = f;
					_tmp297_ = vala_field_get_binding (_tmp296_);
					_tmp298_ = _tmp297_;
					if (_tmp298_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp299_;
						ValaSourceReference* _tmp300_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp300_ = _tmp299_;
						vala_report_error (_tmp300_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp301_ = g_direct_equal;
	_tmp302_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp301_);
	prerequisites = (ValaList*) _tmp302_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp303_;
		ValaList* _tmp304_;
		gint _base_type_size = 0;
		ValaList* _tmp305_;
		gint _tmp306_;
		gint _tmp307_;
		gint _base_type_index = 0;
		_tmp303_ = vala_class_get_base_types (self);
		_tmp304_ = _vala_iterable_ref0 (_tmp303_);
		_base_type_list = _tmp304_;
		_tmp305_ = _base_type_list;
		_tmp306_ = vala_collection_get_size ((ValaCollection*) _tmp305_);
		_tmp307_ = _tmp306_;
		_base_type_size = _tmp307_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp308_;
			gpointer _tmp309_;
			ValaDataType* _tmp310_;
			ValaTypeSymbol* _tmp311_;
			ValaTypeSymbol* _tmp312_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp308_ = _base_type_list;
			_tmp309_ = vala_list_get (_tmp308_, _base_type_index);
			base_type = (ValaDataType*) _tmp309_;
			_tmp310_ = base_type;
			_tmp311_ = vala_data_type_get_type_symbol (_tmp310_);
			_tmp312_ = _tmp311_;
			if (VALA_IS_INTERFACE (_tmp312_)) {
				ValaDataType* _tmp313_;
				ValaTypeSymbol* _tmp314_;
				ValaTypeSymbol* _tmp315_;
				ValaList* _tmp316_;
				_tmp313_ = base_type;
				_tmp314_ = vala_data_type_get_type_symbol (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_INTERFACE, ValaInterface), _tmp316_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp317_ = g_direct_equal;
	_tmp318_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp317_);
	missing_prereqs = (ValaList*) _tmp318_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp319_;
		ValaList* _tmp320_;
		gint _prereq_size = 0;
		ValaList* _tmp321_;
		gint _tmp322_;
		gint _tmp323_;
		gint _prereq_index = 0;
		_tmp319_ = prerequisites;
		_tmp320_ = _vala_iterable_ref0 (_tmp319_);
		_prereq_list = _tmp320_;
		_tmp321_ = _prereq_list;
		_tmp322_ = vala_collection_get_size ((ValaCollection*) _tmp321_);
		_tmp323_ = _tmp322_;
		_prereq_size = _tmp323_;
		_prereq_index = -1;
		while (TRUE) {
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp324_;
			gpointer _tmp325_;
			ValaTypeSymbol* _tmp326_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp324_ = _prereq_list;
			_tmp325_ = vala_list_get (_tmp324_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp325_;
			_tmp326_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp327_;
				ValaTypeSymbol* _tmp328_;
				gchar* _tmp329_;
				gchar* _tmp330_;
				_tmp327_ = missing_prereqs;
				_tmp328_ = prereq;
				_tmp329_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp328_);
				_tmp330_ = _tmp329_;
				vala_list_insert (_tmp327_, 0, _tmp330_);
				_g_free0 (_tmp330_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp331_ = missing_prereqs;
	_tmp332_ = vala_collection_get_size ((ValaCollection*) _tmp331_);
	_tmp333_ = _tmp332_;
	if (_tmp333_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp334_;
		gchar* _tmp335_;
		gchar* _tmp336_;
		gchar* _tmp337_;
		gboolean first = FALSE;
		const gchar* _tmp351_;
		gchar* _tmp352_;
		ValaSourceReference* _tmp353_;
		ValaSourceReference* _tmp354_;
		const gchar* _tmp355_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp334_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp335_ = _tmp334_;
		_tmp336_ = g_strdup_printf ("%s: some prerequisites (", _tmp335_);
		_tmp337_ = _tmp336_;
		_g_free0 (_tmp335_);
		error_string = _tmp337_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp338_;
			ValaList* _tmp339_;
			gint _s_size = 0;
			ValaList* _tmp340_;
			gint _tmp341_;
			gint _tmp342_;
			gint _s_index = 0;
			_tmp338_ = missing_prereqs;
			_tmp339_ = _vala_iterable_ref0 (_tmp338_);
			_s_list = _tmp339_;
			_tmp340_ = _s_list;
			_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
			_tmp342_ = _tmp341_;
			_s_size = _tmp342_;
			_s_index = -1;
			while (TRUE) {
				gchar* s = NULL;
				ValaList* _tmp343_;
				gpointer _tmp344_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp343_ = _s_list;
				_tmp344_ = vala_list_get (_tmp343_, _s_index);
				s = (gchar*) _tmp344_;
				if (first) {
					const gchar* _tmp345_;
					const gchar* _tmp346_;
					gchar* _tmp347_;
					_tmp345_ = error_string;
					_tmp346_ = s;
					_tmp347_ = g_strdup_printf ("%s`%s'", _tmp345_, _tmp346_);
					_g_free0 (error_string);
					error_string = _tmp347_;
					first = FALSE;
				} else {
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					gchar* _tmp350_;
					_tmp348_ = error_string;
					_tmp349_ = s;
					_tmp350_ = g_strdup_printf ("%s, `%s'", _tmp348_, _tmp349_);
					_g_free0 (error_string);
					error_string = _tmp350_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp351_ = error_string;
		_tmp352_ = g_strconcat (_tmp351_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp352_;
		_tmp353_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp354_ = _tmp353_;
		_tmp355_ = error_string;
		vala_report_error (_tmp354_, _tmp355_);
		_g_free0 (error_string);
	}
	_tmp356_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp357_ = _tmp356_;
	if (_tmp357_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp510_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp358_;
			ValaList* _tmp359_;
			gint _base_type_size = 0;
			ValaList* _tmp360_;
			gint _tmp361_;
			gint _tmp362_;
			gint _base_type_index = 0;
			_tmp358_ = vala_class_get_base_types (self);
			_tmp359_ = _vala_iterable_ref0 (_tmp358_);
			_base_type_list = _tmp359_;
			_tmp360_ = _base_type_list;
			_tmp361_ = vala_collection_get_size ((ValaCollection*) _tmp360_);
			_tmp362_ = _tmp361_;
			_base_type_size = _tmp362_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp363_;
				gpointer _tmp364_;
				ValaDataType* _tmp365_;
				ValaTypeSymbol* _tmp366_;
				ValaTypeSymbol* _tmp367_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp363_ = _base_type_list;
				_tmp364_ = vala_list_get (_tmp363_, _base_type_index);
				base_type = (ValaDataType*) _tmp364_;
				_tmp365_ = base_type;
				_tmp366_ = vala_data_type_get_type_symbol (_tmp365_);
				_tmp367_ = _tmp366_;
				if (VALA_IS_INTERFACE (_tmp367_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp368_;
					ValaTypeSymbol* _tmp369_;
					ValaTypeSymbol* _tmp370_;
					gboolean _tmp371_ = FALSE;
					ValaClass* _tmp372_;
					_tmp368_ = base_type;
					_tmp369_ = vala_data_type_get_type_symbol (_tmp368_);
					_tmp370_ = _tmp369_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp372_ = self->priv->_base_class;
					if (_tmp372_ != NULL) {
						ValaClass* _tmp373_;
						ValaInterface* _tmp374_;
						_tmp373_ = self->priv->_base_class;
						_tmp374_ = iface;
						_tmp371_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp373_, (ValaTypeSymbol*) _tmp374_);
					} else {
						_tmp371_ = FALSE;
					}
					if (_tmp371_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp375_;
						ValaList* _tmp376_;
						ValaList* _tmp377_;
						gint _m_size = 0;
						ValaList* _tmp378_;
						gint _tmp379_;
						gint _tmp380_;
						gint _m_index = 0;
						_tmp375_ = iface;
						_tmp376_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp375_);
						_tmp377_ = _vala_iterable_ref0 (_tmp376_);
						_m_list = _tmp377_;
						_tmp378_ = _m_list;
						_tmp379_ = vala_collection_get_size ((ValaCollection*) _tmp378_);
						_tmp380_ = _tmp379_;
						_m_size = _tmp380_;
						_m_index = -1;
						while (TRUE) {
							ValaMethod* m = NULL;
							ValaList* _tmp381_;
							gpointer _tmp382_;
							ValaMethod* _tmp383_;
							gboolean _tmp384_;
							gboolean _tmp385_;
							_m_index = _m_index + 1;
							if (!(_m_index < _m_size)) {
								break;
							}
							_tmp381_ = _m_list;
							_tmp382_ = vala_list_get (_tmp381_, _m_index);
							m = (ValaMethod*) _tmp382_;
							_tmp383_ = m;
							_tmp384_ = vala_method_get_is_abstract (_tmp383_);
							_tmp385_ = _tmp384_;
							if (_tmp385_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp386_ = FALSE;
									ValaClass* _tmp387_;
									ValaClass* _tmp439_;
									ValaClass* _tmp440_;
									_tmp387_ = base_class;
									if (_tmp387_ != NULL) {
										_tmp386_ = !implemented;
									} else {
										_tmp386_ = FALSE;
									}
									if (!_tmp386_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp388_;
										ValaList* _tmp389_;
										ValaList* _tmp390_;
										gint _impl_size = 0;
										ValaList* _tmp391_;
										gint _tmp392_;
										gint _tmp393_;
										gint _impl_index = 0;
										_tmp388_ = base_class;
										_tmp389_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp388_);
										_tmp390_ = _vala_iterable_ref0 (_tmp389_);
										_impl_list = _tmp390_;
										_tmp391_ = _impl_list;
										_tmp392_ = vala_collection_get_size ((ValaCollection*) _tmp391_);
										_tmp393_ = _tmp392_;
										_impl_size = _tmp393_;
										_impl_index = -1;
										while (TRUE) {
											ValaMethod* impl = NULL;
											ValaList* _tmp394_;
											gpointer _tmp395_;
											gboolean _tmp396_ = FALSE;
											ValaMethod* _tmp397_;
											ValaMethod* _tmp398_;
											ValaMethod* _tmp399_;
											ValaMethod* _tmp400_;
											_impl_index = _impl_index + 1;
											if (!(_impl_index < _impl_size)) {
												break;
											}
											_tmp394_ = _impl_list;
											_tmp395_ = vala_list_get (_tmp394_, _impl_index);
											impl = (ValaMethod*) _tmp395_;
											_tmp397_ = impl;
											_tmp398_ = vala_method_get_base_interface_method (_tmp397_);
											_tmp399_ = _tmp398_;
											_tmp400_ = m;
											if (_tmp399_ == _tmp400_) {
												_tmp396_ = TRUE;
											} else {
												gboolean _tmp401_ = FALSE;
												gboolean _tmp402_ = FALSE;
												gboolean _tmp403_ = FALSE;
												gboolean _tmp404_ = FALSE;
												ValaClass* _tmp405_;
												_tmp405_ = base_class;
												if (_tmp405_ != self) {
													ValaMethod* _tmp406_;
													ValaMethod* _tmp407_;
													ValaMethod* _tmp408_;
													_tmp406_ = impl;
													_tmp407_ = vala_method_get_base_interface_method (_tmp406_);
													_tmp408_ = _tmp407_;
													_tmp404_ = _tmp408_ == NULL;
												} else {
													_tmp404_ = FALSE;
												}
												if (_tmp404_) {
													ValaMethod* _tmp409_;
													const gchar* _tmp410_;
													const gchar* _tmp411_;
													ValaMethod* _tmp412_;
													const gchar* _tmp413_;
													const gchar* _tmp414_;
													_tmp409_ = impl;
													_tmp410_ = vala_symbol_get_name ((ValaSymbol*) _tmp409_);
													_tmp411_ = _tmp410_;
													_tmp412_ = m;
													_tmp413_ = vala_symbol_get_name ((ValaSymbol*) _tmp412_);
													_tmp414_ = _tmp413_;
													_tmp403_ = g_strcmp0 (_tmp411_, _tmp414_) == 0;
												} else {
													_tmp403_ = FALSE;
												}
												if (_tmp403_) {
													gboolean _tmp415_ = FALSE;
													ValaMethod* _tmp416_;
													ValaDataType* _tmp417_;
													ValaDataType* _tmp418_;
													_tmp416_ = impl;
													_tmp417_ = vala_method_get_base_interface_type (_tmp416_);
													_tmp418_ = _tmp417_;
													if (_tmp418_ == NULL) {
														_tmp415_ = TRUE;
													} else {
														ValaMethod* _tmp419_;
														ValaDataType* _tmp420_;
														ValaDataType* _tmp421_;
														ValaTypeSymbol* _tmp422_;
														ValaTypeSymbol* _tmp423_;
														ValaInterface* _tmp424_;
														_tmp419_ = impl;
														_tmp420_ = vala_method_get_base_interface_type (_tmp419_);
														_tmp421_ = _tmp420_;
														_tmp422_ = vala_data_type_get_type_symbol (_tmp421_);
														_tmp423_ = _tmp422_;
														_tmp424_ = iface;
														_tmp415_ = _tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp424_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp402_ = _tmp415_;
												} else {
													_tmp402_ = FALSE;
												}
												if (_tmp402_) {
													ValaMethod* _tmp425_;
													ValaMethod* _tmp426_;
													_tmp425_ = impl;
													_tmp426_ = m;
													_tmp401_ = vala_method_compatible_no_error (_tmp425_, _tmp426_);
												} else {
													_tmp401_ = FALSE;
												}
												_tmp396_ = _tmp401_;
											}
											if (_tmp396_) {
												ValaMethod* _tmp427_;
												ValaVersionAttribute* _tmp428_;
												ValaVersionAttribute* _tmp429_;
												ValaSourceReference* _tmp430_;
												ValaSourceReference* _tmp431_;
												ValaMethod* _tmp432_;
												ValaMethod* _tmp433_;
												ValaMethod* _tmp434_;
												ValaMethod* _tmp435_;
												_tmp427_ = impl;
												_tmp428_ = vala_symbol_get_version ((ValaSymbol*) _tmp427_);
												_tmp429_ = _tmp428_;
												_tmp430_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp431_ = _tmp430_;
												vala_version_attribute_check (_tmp429_, _tmp431_);
												_tmp432_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp432_, TRUE);
												implemented = TRUE;
												_tmp433_ = impl;
												_tmp434_ = vala_method_get_base_interface_method (_tmp433_);
												_tmp435_ = _tmp434_;
												if (_tmp435_ == NULL) {
													ValaHashMap* _tmp436_;
													ValaMethod* _tmp437_;
													ValaMethod* _tmp438_;
													_tmp436_ = self->priv->implicit_implementations;
													_tmp437_ = m;
													_tmp438_ = impl;
													vala_map_set ((ValaMap*) _tmp436_, _tmp437_, _tmp438_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp439_ = base_class;
									_tmp440_ = _tmp439_->priv->_base_class;
									base_class = _tmp440_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp441_;
									ValaSourceReference* _tmp442_;
									gchar* _tmp443_;
									gchar* _tmp444_;
									ValaMethod* _tmp445_;
									gchar* _tmp446_;
									gchar* _tmp447_;
									gchar* _tmp448_;
									gchar* _tmp449_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp442_ = _tmp441_;
									_tmp443_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp444_ = _tmp443_;
									_tmp445_ = m;
									_tmp446_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp445_);
									_tmp447_ = _tmp446_;
									_tmp448_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp444_, _tmp447_);
									_tmp449_ = _tmp448_;
									vala_report_error (_tmp442_, _tmp449_);
									_g_free0 (_tmp449_);
									_g_free0 (_tmp447_);
									_g_free0 (_tmp444_);
								}
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp450_;
						ValaList* _tmp451_;
						ValaList* _tmp452_;
						gint _prop_size = 0;
						ValaList* _tmp453_;
						gint _tmp454_;
						gint _tmp455_;
						gint _prop_index = 0;
						_tmp450_ = iface;
						_tmp451_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp450_);
						_tmp452_ = _vala_iterable_ref0 (_tmp451_);
						_prop_list = _tmp452_;
						_tmp453_ = _prop_list;
						_tmp454_ = vala_collection_get_size ((ValaCollection*) _tmp453_);
						_tmp455_ = _tmp454_;
						_prop_size = _tmp455_;
						_prop_index = -1;
						while (TRUE) {
							ValaProperty* prop = NULL;
							ValaList* _tmp456_;
							gpointer _tmp457_;
							ValaProperty* _tmp458_;
							gboolean _tmp459_;
							gboolean _tmp460_;
							_prop_index = _prop_index + 1;
							if (!(_prop_index < _prop_size)) {
								break;
							}
							_tmp456_ = _prop_list;
							_tmp457_ = vala_list_get (_tmp456_, _prop_index);
							prop = (ValaProperty*) _tmp457_;
							_tmp458_ = prop;
							_tmp459_ = vala_property_get_is_abstract (_tmp458_);
							_tmp460_ = _tmp459_;
							if (_tmp460_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp473_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp461_ = FALSE;
									ValaClass* _tmp462_;
									ValaClass* _tmp464_;
									ValaScope* _tmp465_;
									ValaScope* _tmp466_;
									ValaProperty* _tmp467_;
									const gchar* _tmp468_;
									const gchar* _tmp469_;
									ValaSymbol* _tmp470_;
									ValaClass* _tmp471_;
									ValaClass* _tmp472_;
									_tmp462_ = base_class;
									if (_tmp462_ != NULL) {
										ValaSymbol* _tmp463_;
										_tmp463_ = sym;
										_tmp461_ = !VALA_IS_PROPERTY (_tmp463_);
									} else {
										_tmp461_ = FALSE;
									}
									if (!_tmp461_) {
										break;
									}
									_tmp464_ = base_class;
									_tmp465_ = vala_symbol_get_scope ((ValaSymbol*) _tmp464_);
									_tmp466_ = _tmp465_;
									_tmp467_ = prop;
									_tmp468_ = vala_symbol_get_name ((ValaSymbol*) _tmp467_);
									_tmp469_ = _tmp468_;
									_tmp470_ = vala_scope_lookup (_tmp466_, _tmp469_);
									_vala_code_node_unref0 (sym);
									sym = _tmp470_;
									_tmp471_ = base_class;
									_tmp472_ = _tmp471_->priv->_base_class;
									base_class = _tmp472_;
								}
								_tmp473_ = sym;
								if (VALA_IS_PROPERTY (_tmp473_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp474_;
									ValaProperty* _tmp475_;
									gchar* invalid_match = NULL;
									gboolean _tmp476_ = FALSE;
									ValaProperty* _tmp477_;
									gboolean _tmp478_;
									gboolean _tmp479_;
									ValaSymbol* _tmp495_;
									ValaVersionAttribute* _tmp496_;
									ValaVersionAttribute* _tmp497_;
									ValaSourceReference* _tmp498_;
									ValaSourceReference* _tmp499_;
									ValaSymbol* _tmp500_;
									_tmp474_ = sym;
									_tmp475_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp474_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp475_;
									invalid_match = NULL;
									_tmp477_ = base_prop;
									_tmp478_ = vala_symbol_get_hides ((ValaSymbol*) _tmp477_);
									_tmp479_ = _tmp478_;
									if (!_tmp479_) {
										ValaProperty* _tmp480_;
										ValaProperty* _tmp481_;
										gchar* _tmp482_ = NULL;
										gboolean _tmp483_;
										_tmp480_ = base_prop;
										_tmp481_ = prop;
										_tmp483_ = vala_property_compatible (_tmp480_, _tmp481_, &_tmp482_);
										_g_free0 (invalid_match);
										invalid_match = _tmp482_;
										_tmp476_ = !_tmp483_;
									} else {
										_tmp476_ = FALSE;
									}
									if (_tmp476_) {
										ValaSourceReference* _tmp484_;
										ValaSourceReference* _tmp485_;
										ValaProperty* _tmp486_;
										gchar* _tmp487_;
										gchar* _tmp488_;
										ValaProperty* _tmp489_;
										gchar* _tmp490_;
										gchar* _tmp491_;
										const gchar* _tmp492_;
										gchar* _tmp493_;
										gchar* _tmp494_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp485_ = _tmp484_;
										_tmp486_ = prop;
										_tmp487_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp486_);
										_tmp488_ = _tmp487_;
										_tmp489_ = base_prop;
										_tmp490_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp489_);
										_tmp491_ = _tmp490_;
										_tmp492_ = invalid_match;
										_tmp493_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp488_, _tmp491_, _tmp492_);
										_tmp494_ = _tmp493_;
										vala_report_error (_tmp485_, _tmp494_);
										_g_free0 (_tmp494_);
										_g_free0 (_tmp491_);
										_g_free0 (_tmp488_);
									}
									_tmp495_ = sym;
									_tmp496_ = vala_symbol_get_version (_tmp495_);
									_tmp497_ = _tmp496_;
									_tmp498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp499_ = _tmp498_;
									vala_version_attribute_check (_tmp497_, _tmp499_);
									_tmp500_ = sym;
									vala_symbol_set_used (_tmp500_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp501_;
									ValaSourceReference* _tmp502_;
									gchar* _tmp503_;
									gchar* _tmp504_;
									ValaProperty* _tmp505_;
									gchar* _tmp506_;
									gchar* _tmp507_;
									gchar* _tmp508_;
									gchar* _tmp509_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp501_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp502_ = _tmp501_;
									_tmp503_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp504_ = _tmp503_;
									_tmp505_ = prop;
									_tmp506_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp505_);
									_tmp507_ = _tmp506_;
									_tmp508_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp504_, _tmp507_);
									_tmp509_ = _tmp508_;
									vala_report_error (_tmp502_, _tmp509_);
									_g_free0 (_tmp509_);
									_g_free0 (_tmp507_);
									_g_free0 (_tmp504_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp510_ = self->priv->_is_abstract;
		if (!_tmp510_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp511_;
			_tmp511_ = self->priv->_base_class;
			base_class = _tmp511_;
			while (TRUE) {
				gboolean _tmp512_ = FALSE;
				ValaClass* _tmp513_;
				ValaClass* _tmp576_;
				ValaClass* _tmp577_;
				_tmp513_ = base_class;
				if (_tmp513_ != NULL) {
					ValaClass* _tmp514_;
					gboolean _tmp515_;
					_tmp514_ = base_class;
					_tmp515_ = _tmp514_->priv->_is_abstract;
					_tmp512_ = _tmp515_;
				} else {
					_tmp512_ = FALSE;
				}
				if (!_tmp512_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp516_;
					ValaList* _tmp517_;
					ValaList* _tmp518_;
					gint _base_method_size = 0;
					ValaList* _tmp519_;
					gint _tmp520_;
					gint _tmp521_;
					gint _base_method_index = 0;
					_tmp516_ = base_class;
					_tmp517_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp516_);
					_tmp518_ = _vala_iterable_ref0 (_tmp517_);
					_base_method_list = _tmp518_;
					_tmp519_ = _base_method_list;
					_tmp520_ = vala_collection_get_size ((ValaCollection*) _tmp519_);
					_tmp521_ = _tmp520_;
					_base_method_size = _tmp521_;
					_base_method_index = -1;
					while (TRUE) {
						ValaMethod* base_method = NULL;
						ValaList* _tmp522_;
						gpointer _tmp523_;
						ValaMethod* _tmp524_;
						gboolean _tmp525_;
						gboolean _tmp526_;
						_base_method_index = _base_method_index + 1;
						if (!(_base_method_index < _base_method_size)) {
							break;
						}
						_tmp522_ = _base_method_list;
						_tmp523_ = vala_list_get (_tmp522_, _base_method_index);
						base_method = (ValaMethod*) _tmp523_;
						_tmp524_ = base_method;
						_tmp525_ = vala_method_get_is_abstract (_tmp524_);
						_tmp526_ = _tmp525_;
						if (_tmp526_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp527_;
							const gchar* _tmp528_;
							const gchar* _tmp529_;
							ValaSymbol* _tmp530_;
							ValaMethod* _tmp531_;
							gboolean _tmp532_ = FALSE;
							ValaMethod* _tmp533_;
							_tmp527_ = base_method;
							_tmp528_ = vala_symbol_get_name ((ValaSymbol*) _tmp527_);
							_tmp529_ = _tmp528_;
							_tmp530_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp529_);
							_tmp531_ = VALA_IS_METHOD (_tmp530_) ? ((ValaMethod*) _tmp530_) : NULL;
							if (_tmp531_ == NULL) {
								_vala_code_node_unref0 (_tmp530_);
							}
							override_method = _tmp531_;
							_tmp533_ = override_method;
							if (_tmp533_ == NULL) {
								_tmp532_ = TRUE;
							} else {
								ValaMethod* _tmp534_;
								gboolean _tmp535_;
								gboolean _tmp536_;
								_tmp534_ = override_method;
								_tmp535_ = vala_method_get_overrides (_tmp534_);
								_tmp536_ = _tmp535_;
								_tmp532_ = !_tmp536_;
							}
							if (_tmp532_) {
								ValaSourceReference* _tmp537_;
								ValaSourceReference* _tmp538_;
								gchar* _tmp539_;
								gchar* _tmp540_;
								ValaMethod* _tmp541_;
								gchar* _tmp542_;
								gchar* _tmp543_;
								gchar* _tmp544_;
								gchar* _tmp545_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp538_ = _tmp537_;
								_tmp539_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp540_ = _tmp539_;
								_tmp541_ = base_method;
								_tmp542_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp541_);
								_tmp543_ = _tmp542_;
								_tmp544_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp540_, _tmp543_);
								_tmp545_ = _tmp544_;
								vala_report_error (_tmp538_, _tmp545_);
								_g_free0 (_tmp545_);
								_g_free0 (_tmp543_);
								_g_free0 (_tmp540_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp546_;
					ValaList* _tmp547_;
					ValaList* _tmp548_;
					gint _base_property_size = 0;
					ValaList* _tmp549_;
					gint _tmp550_;
					gint _tmp551_;
					gint _base_property_index = 0;
					_tmp546_ = base_class;
					_tmp547_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp546_);
					_tmp548_ = _vala_iterable_ref0 (_tmp547_);
					_base_property_list = _tmp548_;
					_tmp549_ = _base_property_list;
					_tmp550_ = vala_collection_get_size ((ValaCollection*) _tmp549_);
					_tmp551_ = _tmp550_;
					_base_property_size = _tmp551_;
					_base_property_index = -1;
					while (TRUE) {
						ValaProperty* base_property = NULL;
						ValaList* _tmp552_;
						gpointer _tmp553_;
						ValaProperty* _tmp554_;
						gboolean _tmp555_;
						gboolean _tmp556_;
						_base_property_index = _base_property_index + 1;
						if (!(_base_property_index < _base_property_size)) {
							break;
						}
						_tmp552_ = _base_property_list;
						_tmp553_ = vala_list_get (_tmp552_, _base_property_index);
						base_property = (ValaProperty*) _tmp553_;
						_tmp554_ = base_property;
						_tmp555_ = vala_property_get_is_abstract (_tmp554_);
						_tmp556_ = _tmp555_;
						if (_tmp556_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp557_;
							const gchar* _tmp558_;
							const gchar* _tmp559_;
							ValaSymbol* _tmp560_;
							ValaProperty* _tmp561_;
							gboolean _tmp562_ = FALSE;
							ValaProperty* _tmp563_;
							_tmp557_ = base_property;
							_tmp558_ = vala_symbol_get_name ((ValaSymbol*) _tmp557_);
							_tmp559_ = _tmp558_;
							_tmp560_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp559_);
							_tmp561_ = VALA_IS_PROPERTY (_tmp560_) ? ((ValaProperty*) _tmp560_) : NULL;
							if (_tmp561_ == NULL) {
								_vala_code_node_unref0 (_tmp560_);
							}
							override_property = _tmp561_;
							_tmp563_ = override_property;
							if (_tmp563_ == NULL) {
								_tmp562_ = TRUE;
							} else {
								ValaProperty* _tmp564_;
								gboolean _tmp565_;
								gboolean _tmp566_;
								_tmp564_ = override_property;
								_tmp565_ = vala_property_get_overrides (_tmp564_);
								_tmp566_ = _tmp565_;
								_tmp562_ = !_tmp566_;
							}
							if (_tmp562_) {
								ValaSourceReference* _tmp567_;
								ValaSourceReference* _tmp568_;
								gchar* _tmp569_;
								gchar* _tmp570_;
								ValaProperty* _tmp571_;
								gchar* _tmp572_;
								gchar* _tmp573_;
								gchar* _tmp574_;
								gchar* _tmp575_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp567_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp568_ = _tmp567_;
								_tmp569_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp570_ = _tmp569_;
								_tmp571_ = base_property;
								_tmp572_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp571_);
								_tmp573_ = _tmp572_;
								_tmp574_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp570_, _tmp573_);
								_tmp575_ = _tmp574_;
								vala_report_error (_tmp568_, _tmp575_);
								_g_free0 (_tmp575_);
								_g_free0 (_tmp573_);
								_g_free0 (_tmp570_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp576_ = base_class;
				_tmp577_ = _tmp576_->priv->_base_class;
				base_class = _tmp577_;
			}
		}
	}
	_tmp578_ = vala_code_context_get_analyzer (context);
	_tmp579_ = _tmp578_;
	_tmp580_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp579_, _tmp580_);
	_tmp581_ = vala_code_context_get_analyzer (context);
	_tmp582_ = _tmp581_;
	_tmp583_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp582_, _tmp583_);
	_tmp584_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp585_ = _tmp584_;
	result = !_tmp585_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->implicit_implementations = _tmp5_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

