/* valagobjectmodule.c generated by valac, the Vala compiler
 * generated from valagobjectmodule.vala, do not modify */

/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <glib.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))

struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};

static gint ValaGObjectModule_private_offset;
static gpointer vala_gobject_module_parent_class = NULL;

static void vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                           ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                                   ValaClass* cl);
static void vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                                 ValaSymbol* sym,
                                                 ValaCCodeExpression* expression);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self);
static void vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                                 ValaConstructor* c);
static gchar* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                          ValaDynamicSignal* node);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                         ValaDynamicSignal* sig);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                           ValaDynamicSignal* sig,
                                                           gboolean after);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                               ValaDynamicSignal* sig);
static void vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                              ValaProperty* prop);
static void vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static void vala_gobject_module_finalize (ValaCodeVisitor * obj);
static GType vala_gobject_module_get_type_once (void);

static inline gpointer
vala_gobject_module_get_instance_private (ValaGObjectModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGObjectModule_private_offset);
}

static void
vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                      ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), cl);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp2_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp3_) {
		vala_gobject_module_add_get_property_function (self, cl);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp4_) {
		vala_gobject_module_add_set_property_function (self, cl);
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                              ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaConstructor* _tmp32_;
	ValaConstructor* _tmp33_;
	gboolean _tmp52_ = FALSE;
	ValaList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	ValaList* props = NULL;
	ValaList* _tmp224_;
	ValaList* _tmp225_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2_);
	_tmp4_ = _tmp3_;
	_vala_ccode_node_unref0 (_tmp2_);
	ccall = _tmp4_;
	_tmp5_ = ccall;
	_tmp6_ = vala_ccode_identifier_new ("klass");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (_tmp5_, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp8_) {
		ValaCCodeFunction* _tmp9_;
		ValaCCodeFunction* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeMemberAccess* _tmp12_;
		ValaCCodeMemberAccess* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeIdentifier* _tmp19_;
		_tmp9_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = ccall;
		_tmp12_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp11_, "get_property");
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("_vala_%s_get_property", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_identifier_new (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_ccode_function_add_assignment (_tmp10_, (ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_vala_ccode_node_unref0 (_tmp13_);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp20_) {
		ValaCCodeFunction* _tmp21_;
		ValaCCodeFunction* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeMemberAccess* _tmp24_;
		ValaCCodeMemberAccess* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = ccall;
		_tmp24_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp23_, "set_property");
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("_vala_%s_set_property", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_ccode_function_add_assignment (_tmp22_, (ValaCCodeExpression*) _tmp25_, (ValaCCodeExpression*) _tmp31_);
		_vala_ccode_node_unref0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_vala_ccode_node_unref0 (_tmp25_);
	}
	_tmp32_ = vala_class_get_constructor (cl);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp34_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeFunctionCall* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunction* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunctionCall* _tmp43_;
		ValaCCodeMemberAccess* _tmp44_;
		ValaCCodeMemberAccess* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		ValaCCodeIdentifier* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		_tmp34_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
		_tmp37_ = _tmp36_;
		_vala_ccode_node_unref0 (_tmp35_);
		ccast = _tmp37_;
		_tmp38_ = ccast;
		_tmp39_ = vala_ccode_identifier_new ("klass");
		_tmp40_ = _tmp39_;
		vala_ccode_function_call_add_argument (_tmp38_, (ValaCCodeExpression*) _tmp40_);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = ccast;
		_tmp44_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp43_, "constructor");
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf ("%s_constructor", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_ccode_identifier_new (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_ccode_function_add_assignment (_tmp42_, (ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp51_);
		_vala_ccode_node_unref0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_vala_ccode_node_unref0 (_tmp45_);
		_vala_ccode_node_unref0 (ccast);
	}
	_tmp53_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) cl);
	_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ > 0) {
		_tmp52_ = TRUE;
	} else {
		ValaDestructor* _tmp56_;
		ValaDestructor* _tmp57_;
		_tmp56_ = vala_class_get_destructor (cl);
		_tmp57_ = _tmp56_;
		_tmp52_ = _tmp57_ != NULL;
	}
	if (_tmp52_) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeFunctionCall* _tmp60_;
		ValaCCodeFunctionCall* _tmp61_;
		ValaCCodeFunctionCall* _tmp62_;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunction* _tmp65_;
		ValaCCodeFunction* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeMemberAccess* _tmp68_;
		ValaCCodeMemberAccess* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeIdentifier* _tmp75_;
		_tmp58_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp59_);
		_tmp61_ = _tmp60_;
		_vala_ccode_node_unref0 (_tmp59_);
		ccast = _tmp61_;
		_tmp62_ = ccast;
		_tmp63_ = vala_ccode_identifier_new ("klass");
		_tmp64_ = _tmp63_;
		vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp64_);
		_vala_ccode_node_unref0 (_tmp64_);
		_tmp65_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = ccast;
		_tmp68_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp67_, "finalize");
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strdup_printf ("%s_finalize", _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_identifier_new (_tmp73_);
		_tmp75_ = _tmp74_;
		vala_ccode_function_add_assignment (_tmp66_, (ValaCCodeExpression*) _tmp69_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		_vala_ccode_node_unref0 (_tmp69_);
		_vala_ccode_node_unref0 (ccast);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp76_;
		ValaList* _tmp77_;
		gint _type_param_size = 0;
		ValaList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _type_param_index = 0;
		_tmp76_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp77_ = _vala_iterable_ref0 (_tmp76_);
		_type_param_list = _tmp77_;
		_tmp78_ = _type_param_list;
		_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_type_param_size = _tmp80_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp81_;
			gpointer _tmp82_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeConstant* func_name_constant = NULL;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeFunctionCall* cspec = NULL;
			gchar* name_prefix = NULL;
			ValaTypeParameter* _tmp83_;
			const gchar* _tmp84_;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* canonical_prefix = NULL;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			const gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			ValaCCodeConstant* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			const gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			ValaCCodeFunctionCall* _tmp106_;
			const gchar* _tmp107_;
			ValaCCodeConstant* _tmp108_;
			ValaCCodeConstant* _tmp109_;
			ValaCCodeIdentifier* _tmp110_;
			ValaCCodeIdentifier* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaCCodeFunctionCall* _tmp113_;
			ValaCCodeConstant* _tmp114_;
			ValaCCodeFunctionCall* _tmp115_;
			ValaCCodeConstant* _tmp116_;
			ValaCCodeConstant* _tmp117_;
			ValaCCodeFunctionCall* _tmp118_;
			ValaCCodeConstant* _tmp119_;
			ValaCCodeConstant* _tmp120_;
			ValaCCodeFunctionCall* _tmp121_;
			ValaCCodeIdentifier* _tmp122_;
			ValaCCodeIdentifier* _tmp123_;
			ValaCCodeFunctionCall* _tmp124_;
			ValaCCodeConstant* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeFunctionCall* _tmp127_;
			ValaCCodeFunctionCall* _tmp128_;
			ValaCCodeFunction* _tmp129_;
			ValaCCodeFunction* _tmp130_;
			ValaCCodeFunctionCall* _tmp131_;
			ValaCCodeEnum* _tmp132_;
			const gchar* _tmp133_;
			ValaCCodeEnumValue* _tmp134_;
			ValaCCodeEnumValue* _tmp135_;
			const gchar* _tmp136_;
			gchar* _tmp137_;
			const gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			ValaCCodeConstant* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			const gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			ValaCCodeIdentifier* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeFunctionCall* _tmp150_;
			ValaCCodeFunctionCall* _tmp151_;
			ValaCCodeFunctionCall* _tmp152_;
			ValaCCodeFunctionCall* _tmp153_;
			const gchar* _tmp154_;
			ValaCCodeConstant* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeIdentifier* _tmp157_;
			ValaCCodeIdentifier* _tmp158_;
			ValaCCodeFunctionCall* _tmp159_;
			ValaCCodeFunctionCall* _tmp160_;
			ValaCCodeConstant* _tmp161_;
			ValaCCodeFunctionCall* _tmp162_;
			ValaCCodeConstant* _tmp163_;
			ValaCCodeConstant* _tmp164_;
			ValaCCodeFunctionCall* _tmp165_;
			ValaCCodeConstant* _tmp166_;
			ValaCCodeConstant* _tmp167_;
			ValaCCodeFunctionCall* _tmp168_;
			ValaCCodeConstant* _tmp169_;
			ValaCCodeConstant* _tmp170_;
			ValaCCodeFunctionCall* _tmp171_;
			ValaCCodeFunctionCall* _tmp172_;
			ValaCCodeFunction* _tmp173_;
			ValaCCodeFunction* _tmp174_;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeEnum* _tmp176_;
			const gchar* _tmp177_;
			ValaCCodeEnumValue* _tmp178_;
			ValaCCodeEnumValue* _tmp179_;
			const gchar* _tmp180_;
			gchar* _tmp181_;
			const gchar* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			ValaCCodeConstant* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			const gchar* _tmp188_;
			gchar* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			ValaCCodeIdentifier* _tmp192_;
			ValaCCodeIdentifier* _tmp193_;
			ValaCCodeFunctionCall* _tmp194_;
			ValaCCodeFunctionCall* _tmp195_;
			ValaCCodeFunctionCall* _tmp196_;
			ValaCCodeFunctionCall* _tmp197_;
			const gchar* _tmp198_;
			ValaCCodeConstant* _tmp199_;
			ValaCCodeConstant* _tmp200_;
			ValaCCodeIdentifier* _tmp201_;
			ValaCCodeIdentifier* _tmp202_;
			ValaCCodeFunctionCall* _tmp203_;
			ValaCCodeFunctionCall* _tmp204_;
			ValaCCodeConstant* _tmp205_;
			ValaCCodeFunctionCall* _tmp206_;
			ValaCCodeConstant* _tmp207_;
			ValaCCodeConstant* _tmp208_;
			ValaCCodeFunctionCall* _tmp209_;
			ValaCCodeConstant* _tmp210_;
			ValaCCodeConstant* _tmp211_;
			ValaCCodeFunctionCall* _tmp212_;
			ValaCCodeConstant* _tmp213_;
			ValaCCodeConstant* _tmp214_;
			ValaCCodeFunctionCall* _tmp215_;
			ValaCCodeFunctionCall* _tmp216_;
			ValaCCodeFunction* _tmp217_;
			ValaCCodeFunction* _tmp218_;
			ValaCCodeFunctionCall* _tmp219_;
			ValaCCodeEnum* _tmp220_;
			const gchar* _tmp221_;
			ValaCCodeEnumValue* _tmp222_;
			ValaCCodeEnumValue* _tmp223_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp81_ = _type_param_list;
			_tmp82_ = vala_list_get (_tmp81_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp82_;
			_tmp83_ = type_param;
			_tmp84_ = vala_symbol_get_name ((ValaSymbol*) _tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_utf8_strdown (_tmp85_, (gssize) -1);
			name_prefix = _tmp86_;
			_tmp87_ = name_prefix;
			_tmp88_ = string_replace (_tmp87_, "_", "-");
			canonical_prefix = _tmp88_;
			_tmp89_ = name_prefix;
			_tmp90_ = g_strdup_printf ("%s_type", _tmp89_);
			_g_free0 (func_name);
			func_name = _tmp90_;
			_tmp91_ = canonical_prefix;
			_tmp92_ = g_strdup_printf ("\"%s-type\"", _tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = vala_ccode_constant_new (_tmp93_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp94_;
			_g_free0 (_tmp93_);
			_tmp95_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp96_ = _tmp95_;
			_tmp97_ = func_name;
			_tmp98_ = g_strdup_printf ("%s_%s", _tmp96_, _tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = g_ascii_strup (_tmp99_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp100_;
			_g_free0 (_tmp99_);
			_g_free0 (_tmp96_);
			_tmp101_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp103_;
			_vala_ccode_node_unref0 (_tmp102_);
			_tmp104_ = cinst;
			_tmp105_ = ccall;
			vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp105_);
			_tmp106_ = cinst;
			_tmp107_ = enum_value;
			_tmp108_ = vala_ccode_constant_new (_tmp107_);
			_tmp109_ = _tmp108_;
			vala_ccode_function_call_add_argument (_tmp106_, (ValaCCodeExpression*) _tmp109_);
			_vala_ccode_node_unref0 (_tmp109_);
			_tmp110_ = vala_ccode_identifier_new ("g_param_spec_gtype");
			_tmp111_ = _tmp110_;
			_tmp112_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp111_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp112_;
			_vala_ccode_node_unref0 (_tmp111_);
			_tmp113_ = cspec;
			_tmp114_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp114_);
			_tmp115_ = cspec;
			_tmp116_ = vala_ccode_constant_new ("\"type\"");
			_tmp117_ = _tmp116_;
			vala_ccode_function_call_add_argument (_tmp115_, (ValaCCodeExpression*) _tmp117_);
			_vala_ccode_node_unref0 (_tmp117_);
			_tmp118_ = cspec;
			_tmp119_ = vala_ccode_constant_new ("\"type\"");
			_tmp120_ = _tmp119_;
			vala_ccode_function_call_add_argument (_tmp118_, (ValaCCodeExpression*) _tmp120_);
			_vala_ccode_node_unref0 (_tmp120_);
			_tmp121_ = cspec;
			_tmp122_ = vala_ccode_identifier_new ("G_TYPE_NONE");
			_tmp123_ = _tmp122_;
			vala_ccode_function_call_add_argument (_tmp121_, (ValaCCodeExpression*) _tmp123_);
			_vala_ccode_node_unref0 (_tmp123_);
			_tmp124_ = cspec;
			_tmp125_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp126_ = _tmp125_;
			vala_ccode_function_call_add_argument (_tmp124_, (ValaCCodeExpression*) _tmp126_);
			_vala_ccode_node_unref0 (_tmp126_);
			_tmp127_ = cinst;
			_tmp128_ = cspec;
			vala_ccode_function_call_add_argument (_tmp127_, (ValaCCodeExpression*) _tmp128_);
			_tmp129_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = cinst;
			vala_ccode_function_add_expression (_tmp130_, (ValaCCodeExpression*) _tmp131_);
			_tmp132_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp133_ = enum_value;
			_tmp134_ = vala_ccode_enum_value_new (_tmp133_, NULL);
			_tmp135_ = _tmp134_;
			vala_ccode_enum_add_value (_tmp132_, _tmp135_);
			_vala_ccode_node_unref0 (_tmp135_);
			_tmp136_ = name_prefix;
			_tmp137_ = g_strdup_printf ("%s_dup_func", _tmp136_);
			_g_free0 (func_name);
			func_name = _tmp137_;
			_tmp138_ = canonical_prefix;
			_tmp139_ = g_strdup_printf ("\"%s-dup-func\"", _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_ccode_constant_new (_tmp140_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp141_;
			_g_free0 (_tmp140_);
			_tmp142_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp143_ = _tmp142_;
			_tmp144_ = func_name;
			_tmp145_ = g_strdup_printf ("%s_%s", _tmp143_, _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_ascii_strup (_tmp146_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp147_;
			_g_free0 (_tmp146_);
			_g_free0 (_tmp143_);
			_tmp148_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp149_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp150_;
			_vala_ccode_node_unref0 (_tmp149_);
			_tmp151_ = cinst;
			_tmp152_ = ccall;
			vala_ccode_function_call_add_argument (_tmp151_, (ValaCCodeExpression*) _tmp152_);
			_tmp153_ = cinst;
			_tmp154_ = enum_value;
			_tmp155_ = vala_ccode_constant_new (_tmp154_);
			_tmp156_ = _tmp155_;
			vala_ccode_function_call_add_argument (_tmp153_, (ValaCCodeExpression*) _tmp156_);
			_vala_ccode_node_unref0 (_tmp156_);
			_tmp157_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp158_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp159_;
			_vala_ccode_node_unref0 (_tmp158_);
			_tmp160_ = cspec;
			_tmp161_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp160_, (ValaCCodeExpression*) _tmp161_);
			_tmp162_ = cspec;
			_tmp163_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp164_ = _tmp163_;
			vala_ccode_function_call_add_argument (_tmp162_, (ValaCCodeExpression*) _tmp164_);
			_vala_ccode_node_unref0 (_tmp164_);
			_tmp165_ = cspec;
			_tmp166_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp167_ = _tmp166_;
			vala_ccode_function_call_add_argument (_tmp165_, (ValaCCodeExpression*) _tmp167_);
			_vala_ccode_node_unref0 (_tmp167_);
			_tmp168_ = cspec;
			_tmp169_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp170_ = _tmp169_;
			vala_ccode_function_call_add_argument (_tmp168_, (ValaCCodeExpression*) _tmp170_);
			_vala_ccode_node_unref0 (_tmp170_);
			_tmp171_ = cinst;
			_tmp172_ = cspec;
			vala_ccode_function_call_add_argument (_tmp171_, (ValaCCodeExpression*) _tmp172_);
			_tmp173_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp174_ = _tmp173_;
			_tmp175_ = cinst;
			vala_ccode_function_add_expression (_tmp174_, (ValaCCodeExpression*) _tmp175_);
			_tmp176_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp177_ = enum_value;
			_tmp178_ = vala_ccode_enum_value_new (_tmp177_, NULL);
			_tmp179_ = _tmp178_;
			vala_ccode_enum_add_value (_tmp176_, _tmp179_);
			_vala_ccode_node_unref0 (_tmp179_);
			_tmp180_ = name_prefix;
			_tmp181_ = g_strdup_printf ("%s_destroy_func", _tmp180_);
			_g_free0 (func_name);
			func_name = _tmp181_;
			_tmp182_ = canonical_prefix;
			_tmp183_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp182_);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_ccode_constant_new (_tmp184_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp185_;
			_g_free0 (_tmp184_);
			_tmp186_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp187_ = _tmp186_;
			_tmp188_ = func_name;
			_tmp189_ = g_strdup_printf ("%s_%s", _tmp187_, _tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = g_ascii_strup (_tmp190_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp191_;
			_g_free0 (_tmp190_);
			_g_free0 (_tmp187_);
			_tmp192_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp193_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp194_;
			_vala_ccode_node_unref0 (_tmp193_);
			_tmp195_ = cinst;
			_tmp196_ = ccall;
			vala_ccode_function_call_add_argument (_tmp195_, (ValaCCodeExpression*) _tmp196_);
			_tmp197_ = cinst;
			_tmp198_ = enum_value;
			_tmp199_ = vala_ccode_constant_new (_tmp198_);
			_tmp200_ = _tmp199_;
			vala_ccode_function_call_add_argument (_tmp197_, (ValaCCodeExpression*) _tmp200_);
			_vala_ccode_node_unref0 (_tmp200_);
			_tmp201_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp202_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp203_;
			_vala_ccode_node_unref0 (_tmp202_);
			_tmp204_ = cspec;
			_tmp205_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp204_, (ValaCCodeExpression*) _tmp205_);
			_tmp206_ = cspec;
			_tmp207_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp208_ = _tmp207_;
			vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp208_);
			_vala_ccode_node_unref0 (_tmp208_);
			_tmp209_ = cspec;
			_tmp210_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp211_ = _tmp210_;
			vala_ccode_function_call_add_argument (_tmp209_, (ValaCCodeExpression*) _tmp211_);
			_vala_ccode_node_unref0 (_tmp211_);
			_tmp212_ = cspec;
			_tmp213_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp214_ = _tmp213_;
			vala_ccode_function_call_add_argument (_tmp212_, (ValaCCodeExpression*) _tmp214_);
			_vala_ccode_node_unref0 (_tmp214_);
			_tmp215_ = cinst;
			_tmp216_ = cspec;
			vala_ccode_function_call_add_argument (_tmp215_, (ValaCCodeExpression*) _tmp216_);
			_tmp217_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp218_ = _tmp217_;
			_tmp219_ = cinst;
			vala_ccode_function_add_expression (_tmp218_, (ValaCCodeExpression*) _tmp219_);
			_tmp220_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp221_ = enum_value;
			_tmp222_ = vala_ccode_enum_value_new (_tmp221_, NULL);
			_tmp223_ = _tmp222_;
			vala_ccode_enum_add_value (_tmp220_, _tmp223_);
			_vala_ccode_node_unref0 (_tmp223_);
			_g_free0 (canonical_prefix);
			_g_free0 (name_prefix);
			_vala_ccode_node_unref0 (cspec);
			_vala_ccode_node_unref0 (cinst);
			_vala_ccode_node_unref0 (func_name_constant);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp224_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp225_ = _vala_iterable_ref0 (_tmp224_);
	props = _tmp225_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp226_;
		ValaList* _tmp227_;
		gint _prop_size = 0;
		ValaList* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gint _prop_index = 0;
		_tmp226_ = props;
		_tmp227_ = _vala_iterable_ref0 (_tmp226_);
		_prop_list = _tmp227_;
		_tmp228_ = _prop_list;
		_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
		_tmp230_ = _tmp229_;
		_prop_size = _tmp230_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp231_;
			gpointer _tmp232_;
			ValaCodeContext* _tmp233_;
			ValaCodeContext* _tmp234_;
			ValaSemanticAnalyzer* _tmp235_;
			ValaSemanticAnalyzer* _tmp236_;
			ValaProperty* _tmp237_;
			ValaProperty* _tmp255_;
			ValaComment* _tmp256_;
			ValaComment* _tmp257_;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeIdentifier* _tmp267_;
			ValaCCodeIdentifier* _tmp268_;
			ValaCCodeFunctionCall* _tmp269_;
			ValaCCodeFunctionCall* _tmp270_;
			ValaCCodeFunctionCall* _tmp271_;
			ValaCCodeFunctionCall* _tmp272_;
			ValaCCodeFunctionCall* _tmp273_;
			ValaProperty* _tmp274_;
			gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			ValaCCodeConstant* _tmp279_;
			ValaCCodeConstant* _tmp280_;
			ValaCCodeFunctionCall* _tmp281_;
			ValaProperty* _tmp282_;
			ValaCCodeExpression* _tmp283_;
			ValaCCodeExpression* _tmp284_;
			ValaCCodeFunction* _tmp285_;
			ValaCCodeFunction* _tmp286_;
			ValaCCodeFunctionCall* _tmp287_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp231_ = _prop_list;
			_tmp232_ = vala_list_get (_tmp231_, _prop_index);
			prop = (ValaProperty*) _tmp232_;
			_tmp233_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_code_context_get_analyzer (_tmp234_);
			_tmp236_ = _tmp235_;
			_tmp237_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp236_, _tmp237_)) {
				ValaCodeContext* _tmp238_;
				ValaCodeContext* _tmp239_;
				ValaSemanticAnalyzer* _tmp240_;
				ValaSemanticAnalyzer* _tmp241_;
				ValaProperty* _tmp242_;
				ValaDataType* _tmp243_;
				ValaDataType* _tmp244_;
				_tmp238_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_code_context_get_analyzer (_tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = prop;
				_tmp243_ = vala_property_get_property_type (_tmp242_);
				_tmp244_ = _tmp243_;
				if (!vala_semantic_analyzer_is_gobject_property_type (_tmp241_, _tmp244_)) {
					ValaProperty* _tmp245_;
					ValaSourceReference* _tmp246_;
					ValaSourceReference* _tmp247_;
					ValaProperty* _tmp248_;
					ValaDataType* _tmp249_;
					ValaDataType* _tmp250_;
					gchar* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					gchar* _tmp254_;
					_tmp245_ = prop;
					_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = prop;
					_tmp249_ = vala_property_get_property_type (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_data_type_to_qualified_string (_tmp250_, NULL);
					_tmp252_ = _tmp251_;
					_tmp253_ = g_strdup_printf ("Type `%s' can not be used for a GLib.Object property", _tmp252_);
					_tmp254_ = _tmp253_;
					vala_report_warning (_tmp247_, _tmp254_);
					_g_free0 (_tmp254_);
					_g_free0 (_tmp252_);
				}
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp255_ = prop;
			_tmp256_ = vala_symbol_get_comment ((ValaSymbol*) _tmp255_);
			_tmp257_ = _tmp256_;
			if (_tmp257_ != NULL) {
				ValaCCodeFunction* _tmp258_;
				ValaCCodeFunction* _tmp259_;
				ValaProperty* _tmp260_;
				ValaComment* _tmp261_;
				ValaComment* _tmp262_;
				const gchar* _tmp263_;
				const gchar* _tmp264_;
				ValaCCodeComment* _tmp265_;
				ValaCCodeComment* _tmp266_;
				_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp259_ = _tmp258_;
				_tmp260_ = prop;
				_tmp261_ = vala_symbol_get_comment ((ValaSymbol*) _tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_comment_get_content (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_ccode_comment_new (_tmp264_);
				_tmp266_ = _tmp265_;
				vala_ccode_function_add_statement (_tmp259_, (ValaCCodeNode*) _tmp266_);
				_vala_ccode_node_unref0 (_tmp266_);
			}
			_tmp267_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp268_ = _tmp267_;
			_tmp269_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp268_);
			_tmp270_ = _tmp269_;
			_vala_ccode_node_unref0 (_tmp268_);
			cinst = _tmp270_;
			_tmp271_ = cinst;
			_tmp272_ = ccall;
			vala_ccode_function_call_add_argument (_tmp271_, (ValaCCodeExpression*) _tmp272_);
			_tmp273_ = cinst;
			_tmp274_ = prop;
			_tmp275_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp274_, NULL);
			_tmp276_ = _tmp275_;
			_tmp277_ = g_strdup_printf ("%s_PROPERTY", _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_ccode_constant_new (_tmp278_);
			_tmp280_ = _tmp279_;
			vala_ccode_function_call_add_argument (_tmp273_, (ValaCCodeExpression*) _tmp280_);
			_vala_ccode_node_unref0 (_tmp280_);
			_g_free0 (_tmp278_);
			_g_free0 (_tmp276_);
			_tmp281_ = cinst;
			_tmp282_ = prop;
			_tmp283_ = vala_ccode_base_module_get_param_spec ((ValaCCodeBaseModule*) self, _tmp282_);
			_tmp284_ = _tmp283_;
			vala_ccode_function_call_add_argument (_tmp281_, _tmp284_);
			_vala_ccode_node_unref0 (_tmp284_);
			_tmp285_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp286_ = _tmp285_;
			_tmp287_ = cinst;
			vala_ccode_function_add_expression (_tmp286_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (cinst);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
}

static gboolean
vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaProperty* _tmp7_;
			ValaPropertyAccessor* _tmp8_;
			ValaPropertyAccessor* _tmp9_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp5_ = _prop_list;
			_tmp6_ = vala_list_get (_tmp5_, _prop_index);
			prop = (ValaProperty*) _tmp6_;
			_tmp7_ = prop;
			_tmp8_ = vala_property_get_get_accessor (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}

static gboolean
vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaProperty* _tmp7_;
			ValaPropertyAccessor* _tmp8_;
			ValaPropertyAccessor* _tmp9_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp5_ = _prop_list;
			_tmp6_ = vala_list_get (_tmp5_, _prop_index);
			prop = (ValaProperty*) _tmp6_;
			_tmp7_ = prop;
			_tmp8_ = vala_property_get_set_accessor (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}

static void
vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                            ValaSymbol* sym,
                                            ValaCCodeExpression* expression)
{
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (expression != NULL);
	_tmp0_ = vala_symbol_get_version (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_version_attribute_get_deprecated (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaCCodeGGnucSection* guard = NULL;
		ValaCCodeGGnucSection* _tmp4_;
		ValaCCodeFunction* _tmp5_;
		ValaCCodeFunction* _tmp6_;
		ValaCCodeGGnucSection* _tmp7_;
		ValaCCodeGGnucSection* _tmp8_;
		ValaCCodeExpressionStatement* _tmp9_;
		ValaCCodeExpressionStatement* _tmp10_;
		_tmp4_ = vala_ccode_ggnuc_section_new (VALA_GGNUC_SECTION_TYPE_IGNORE_DEPRECATIONS);
		guard = _tmp4_;
		_tmp5_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = guard;
		vala_ccode_function_add_statement (_tmp6_, (ValaCCodeNode*) _tmp7_);
		_tmp8_ = guard;
		_tmp9_ = vala_ccode_expression_statement_new (expression);
		_tmp10_ = _tmp9_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp8_, (ValaCCodeNode*) _tmp10_);
		_vala_ccode_node_unref0 (_tmp10_);
		_vala_ccode_node_unref0 (guard);
	} else {
		ValaCCodeFunction* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		_tmp11_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp12_ = _tmp11_;
		vala_ccode_function_add_expression (_tmp12_, expression);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* get_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaCCodeFunction* _tmp417_;
	ValaCCodeFunction* _tmp418_;
	ValaCCodeFunction* _tmp419_;
	ValaCCodeFunction* _tmp420_;
	ValaCCodeFunction* _tmp421_;
	ValaCCodeFunction* _tmp422_;
	ValaCCodeFile* _tmp423_;
	ValaCCodeFunction* _tmp424_;
	ValaCCodeFile* _tmp425_;
	ValaCCodeFunction* _tmp426_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_get_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	get_prop = _tmp5_;
	_tmp6_ = get_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = get_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = get_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = get_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = get_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = get_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _vala_iterable_ref0 (_tmp37_);
	props = _tmp38_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp39_;
		ValaList* _tmp40_;
		gint _prop_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _prop_index = 0;
		_tmp39_ = props;
		_tmp40_ = _vala_iterable_ref0 (_tmp39_);
		_prop_list = _tmp40_;
		_tmp41_ = _prop_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_prop_size = _tmp43_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp44_;
			gpointer _tmp45_;
			gboolean _tmp46_ = FALSE;
			ValaProperty* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaCodeContext* _tmp53_;
			ValaCodeContext* _tmp54_;
			ValaSemanticAnalyzer* _tmp55_;
			ValaSemanticAnalyzer* _tmp56_;
			ValaProperty* _tmp57_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp58_;
			ValaProperty* _tmp59_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp60_;
			ValaProperty* _tmp61_;
			ValaProperty* _tmp62_;
			ValaProperty* _tmp63_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp123_ = FALSE;
			ValaProperty* _tmp124_;
			ValaCCodeFunction* _tmp138_;
			ValaCCodeFunction* _tmp139_;
			ValaProperty* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeIdentifier* _tmp146_;
			ValaProperty* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaCCodeFunction* _tmp300_;
			ValaCCodeFunction* _tmp301_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp44_ = _prop_list;
			_tmp45_ = vala_list_get (_tmp44_, _prop_index);
			prop = (ValaProperty*) _tmp45_;
			_tmp47_ = prop;
			_tmp48_ = vala_property_get_get_accessor (_tmp47_);
			_tmp49_ = _tmp48_;
			if (_tmp49_ == NULL) {
				_tmp46_ = TRUE;
			} else {
				ValaProperty* _tmp50_;
				gboolean _tmp51_;
				gboolean _tmp52_;
				_tmp50_ = prop;
				_tmp51_ = vala_property_get_is_abstract (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp46_ = _tmp52_;
			}
			if (_tmp46_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp53_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_code_context_get_analyzer (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp56_, _tmp57_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp58_ = prop;
			_tmp59_ = _vala_code_node_ref0 (_tmp58_);
			base_prop = _tmp59_;
			_tmp60_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp60_;
			_tmp61_ = prop;
			_tmp62_ = vala_property_get_base_property (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp64_;
				ValaProperty* _tmp65_;
				ValaProperty* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				ValaClass* _tmp69_;
				ValaProperty* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaProperty* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaObjectType* _tmp75_;
				ValaCCodeExpression* _tmp76_;
				ValaGLibValue* _tmp77_;
				ValaGLibValue* _tmp78_;
				ValaClass* _tmp79_;
				ValaObjectType* _tmp80_;
				ValaObjectType* _tmp81_;
				ValaProperty* _tmp82_;
				ValaTargetValue* _tmp83_;
				ValaTargetValue* _tmp84_;
				ValaCCodeExpression* _tmp85_;
				ValaProperty* _tmp86_;
				ValaProperty* _tmp87_;
				ValaProperty* _tmp88_;
				ValaPropertyAccessor* _tmp89_;
				ValaPropertyAccessor* _tmp90_;
				ValaCCodeFile* _tmp91_;
				_tmp64_ = prop;
				_tmp65_ = vala_property_get_base_property (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp69_;
				_tmp70_ = prop;
				_tmp71_ = vala_property_get_base_property (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = _vala_code_node_ref0 (_tmp72_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp73_;
				_tmp74_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp75_ = _tmp74_;
				_tmp76_ = cself;
				_tmp77_ = vala_glib_value_new ((ValaDataType*) _tmp75_, _tmp76_, TRUE);
				_tmp78_ = _tmp77_;
				_tmp79_ = base_type;
				_tmp80_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = prop;
				_tmp83_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp78_, (ValaDataType*) _tmp81_, (ValaCodeNode*) _tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp84_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp85_;
				_vala_target_value_unref0 (_tmp84_);
				_vala_code_node_unref0 (_tmp81_);
				_vala_target_value_unref0 (_tmp78_);
				_vala_code_node_unref0 (_tmp75_);
				_tmp86_ = prop;
				_tmp87_ = vala_property_get_base_property (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_property_get_get_accessor (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp90_, _tmp91_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				ValaProperty* _tmp94_;
				_tmp92_ = prop;
				_tmp93_ = vala_property_get_base_interface_property (_tmp92_);
				_tmp94_ = _tmp93_;
				if (_tmp94_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaProperty* _tmp97_;
					ValaSymbol* _tmp98_;
					ValaSymbol* _tmp99_;
					ValaInterface* _tmp100_;
					ValaProperty* _tmp101_;
					ValaProperty* _tmp102_;
					ValaProperty* _tmp103_;
					ValaProperty* _tmp104_;
					ValaObjectType* _tmp105_;
					ValaObjectType* _tmp106_;
					ValaCCodeExpression* _tmp107_;
					ValaGLibValue* _tmp108_;
					ValaGLibValue* _tmp109_;
					ValaInterface* _tmp110_;
					ValaObjectType* _tmp111_;
					ValaObjectType* _tmp112_;
					ValaProperty* _tmp113_;
					ValaTargetValue* _tmp114_;
					ValaTargetValue* _tmp115_;
					ValaCCodeExpression* _tmp116_;
					ValaProperty* _tmp117_;
					ValaProperty* _tmp118_;
					ValaProperty* _tmp119_;
					ValaPropertyAccessor* _tmp120_;
					ValaPropertyAccessor* _tmp121_;
					ValaCCodeFile* _tmp122_;
					_tmp95_ = prop;
					_tmp96_ = vala_property_get_base_interface_property (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp100_;
					_tmp101_ = prop;
					_tmp102_ = vala_property_get_base_interface_property (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = _vala_code_node_ref0 (_tmp103_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp104_;
					_tmp105_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp106_ = _tmp105_;
					_tmp107_ = cself;
					_tmp108_ = vala_glib_value_new ((ValaDataType*) _tmp106_, _tmp107_, TRUE);
					_tmp109_ = _tmp108_;
					_tmp110_ = base_type;
					_tmp111_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = prop;
					_tmp114_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp109_, (ValaDataType*) _tmp112_, (ValaCodeNode*) _tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp115_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp116_;
					_vala_target_value_unref0 (_tmp115_);
					_vala_code_node_unref0 (_tmp112_);
					_vala_target_value_unref0 (_tmp109_);
					_vala_code_node_unref0 (_tmp106_);
					_tmp117_ = prop;
					_tmp118_ = vala_property_get_base_interface_property (_tmp117_);
					_tmp119_ = _tmp118_;
					_tmp120_ = vala_property_get_get_accessor (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp121_, _tmp122_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp124_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp124_)) {
				ValaProperty* _tmp125_;
				_tmp125_ = base_prop;
				_tmp123_ = !vala_get_ccode_concrete_accessor (_tmp125_);
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				ValaProperty* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				ValaPropertyAccessor* _tmp128_;
				gchar* _tmp129_;
				gchar* _tmp130_;
				ValaCCodeIdentifier* _tmp131_;
				_tmp126_ = base_prop;
				_tmp127_ = vala_property_get_get_accessor (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_get_ccode_name ((ValaCodeNode*) _tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_ccode_identifier_new (_tmp130_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp131_;
				_g_free0 (_tmp130_);
			} else {
				ValaProperty* _tmp132_;
				ValaPropertyAccessor* _tmp133_;
				ValaPropertyAccessor* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				ValaCCodeIdentifier* _tmp137_;
				_tmp132_ = prop;
				_tmp133_ = vala_property_get_get_accessor (_tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				_tmp136_ = _tmp135_;
				_tmp137_ = vala_ccode_identifier_new (_tmp136_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp137_;
				_g_free0 (_tmp136_);
			}
			_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = prop;
			_tmp141_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp140_, NULL);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("%s_PROPERTY", _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_ccode_identifier_new (_tmp144_);
			_tmp146_ = _tmp145_;
			vala_ccode_function_add_case (_tmp139_, (ValaCCodeExpression*) _tmp146_);
			_vala_ccode_node_unref0 (_tmp146_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_tmp147_ = prop;
			_tmp148_ = vala_property_get_property_type (_tmp147_);
			_tmp149_ = _tmp148_;
			if (vala_data_type_is_real_struct_type (_tmp149_)) {
				ValaCCodeFunction* _tmp150_;
				ValaCCodeFunction* _tmp151_;
				ValaCCodeFunction* _tmp152_;
				ValaCCodeFunction* _tmp153_;
				ValaProperty* _tmp154_;
				ValaDataType* _tmp155_;
				ValaDataType* _tmp156_;
				gchar* _tmp157_;
				gchar* _tmp158_;
				ValaCCodeVariableDeclarator* _tmp159_;
				ValaCCodeVariableDeclarator* _tmp160_;
				ValaCCodeExpression* _tmp161_;
				ValaCCodeFunctionCall* _tmp162_;
				ValaCCodeFunctionCall* _tmp163_;
				ValaCCodeExpression* _tmp164_;
				ValaProperty* _tmp165_;
				ValaDataType* _tmp166_;
				ValaDataType* _tmp167_;
				gboolean _tmp168_;
				gboolean _tmp169_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaProperty* _tmp185_;
				ValaDataType* _tmp186_;
				ValaDataType* _tmp187_;
				ValaCCodeIdentifier* _tmp188_;
				ValaCCodeIdentifier* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeIdentifier* _tmp191_;
				ValaCCodeIdentifier* _tmp192_;
				ValaProperty* _tmp193_;
				ValaDataType* _tmp194_;
				ValaDataType* _tmp195_;
				gboolean _tmp196_;
				gboolean _tmp197_;
				ValaProperty* _tmp206_;
				ValaCCodeFunctionCall* _tmp207_;
				ValaProperty* _tmp208_;
				ValaPropertyAccessor* _tmp209_;
				ValaPropertyAccessor* _tmp210_;
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				ValaCCodeFunction* _tmp226_;
				ValaCCodeFunction* _tmp227_;
				_tmp150_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp151_ = _tmp150_;
				vala_ccode_function_open_block (_tmp151_);
				_tmp152_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp153_ = _tmp152_;
				_tmp154_ = prop;
				_tmp155_ = vala_property_get_property_type (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_get_ccode_name ((ValaCodeNode*) _tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp160_ = _tmp159_;
				vala_ccode_function_add_declaration (_tmp153_, _tmp158_, (ValaCCodeDeclarator*) _tmp160_, 0);
				_vala_ccode_node_unref0 (_tmp160_);
				_g_free0 (_tmp158_);
				_tmp161_ = cfunc;
				_tmp162_ = vala_ccode_function_call_new (_tmp161_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp162_;
				_tmp163_ = ccall;
				_tmp164_ = cself;
				vala_ccode_function_call_add_argument (_tmp163_, _tmp164_);
				_tmp165_ = prop;
				_tmp166_ = vala_property_get_property_type (_tmp165_);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_data_type_get_nullable (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_) {
					ValaCCodeFunction* _tmp170_;
					ValaCCodeFunction* _tmp171_;
					ValaCCodeIdentifier* _tmp172_;
					ValaCCodeIdentifier* _tmp173_;
					ValaCCodeFunctionCall* _tmp174_;
					_tmp170_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_ccode_identifier_new ("boxed");
					_tmp173_ = _tmp172_;
					_tmp174_ = ccall;
					vala_ccode_function_add_assignment (_tmp171_, (ValaCCodeExpression*) _tmp173_, (ValaCCodeExpression*) _tmp174_);
					_vala_ccode_node_unref0 (_tmp173_);
				} else {
					ValaCCodeFunctionCall* _tmp175_;
					ValaCCodeIdentifier* _tmp176_;
					ValaCCodeIdentifier* _tmp177_;
					ValaCCodeUnaryExpression* _tmp178_;
					ValaCCodeUnaryExpression* _tmp179_;
					ValaCCodeFunction* _tmp180_;
					ValaCCodeFunction* _tmp181_;
					ValaCCodeFunctionCall* _tmp182_;
					_tmp175_ = ccall;
					_tmp176_ = vala_ccode_identifier_new ("boxed");
					_tmp177_ = _tmp176_;
					_tmp178_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp177_);
					_tmp179_ = _tmp178_;
					vala_ccode_function_call_add_argument (_tmp175_, (ValaCCodeExpression*) _tmp179_);
					_vala_ccode_node_unref0 (_tmp179_);
					_vala_ccode_node_unref0 (_tmp177_);
					_tmp180_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp181_ = _tmp180_;
					_tmp182_ = ccall;
					vala_ccode_function_add_expression (_tmp181_, (ValaCCodeExpression*) _tmp182_);
				}
				_tmp183_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp183_;
				_tmp184_ = csetcall;
				_tmp185_ = prop;
				_tmp186_ = vala_property_get_property_type (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp184_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_tmp190_ = csetcall;
				_tmp191_ = vala_ccode_identifier_new ("value");
				_tmp192_ = _tmp191_;
				vala_ccode_function_call_add_argument (_tmp190_, (ValaCCodeExpression*) _tmp192_);
				_vala_ccode_node_unref0 (_tmp192_);
				_tmp193_ = prop;
				_tmp194_ = vala_property_get_property_type (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_data_type_get_nullable (_tmp195_);
				_tmp197_ = _tmp196_;
				if (_tmp197_) {
					ValaCCodeFunctionCall* _tmp198_;
					ValaCCodeIdentifier* _tmp199_;
					ValaCCodeIdentifier* _tmp200_;
					_tmp198_ = csetcall;
					_tmp199_ = vala_ccode_identifier_new ("boxed");
					_tmp200_ = _tmp199_;
					vala_ccode_function_call_add_argument (_tmp198_, (ValaCCodeExpression*) _tmp200_);
					_vala_ccode_node_unref0 (_tmp200_);
				} else {
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeIdentifier* _tmp202_;
					ValaCCodeIdentifier* _tmp203_;
					ValaCCodeUnaryExpression* _tmp204_;
					ValaCCodeUnaryExpression* _tmp205_;
					_tmp201_ = csetcall;
					_tmp202_ = vala_ccode_identifier_new ("boxed");
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp203_);
					_tmp205_ = _tmp204_;
					vala_ccode_function_call_add_argument (_tmp201_, (ValaCCodeExpression*) _tmp205_);
					_vala_ccode_node_unref0 (_tmp205_);
					_vala_ccode_node_unref0 (_tmp203_);
				}
				_tmp206_ = prop;
				_tmp207_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp206_, (ValaCCodeExpression*) _tmp207_);
				_tmp208_ = prop;
				_tmp209_ = vala_property_get_get_accessor (_tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_property_accessor_get_value_type (_tmp210_);
				_tmp212_ = _tmp211_;
				if (vala_ccode_base_module_requires_destroy (_tmp212_)) {
					ValaCCodeFunction* _tmp213_;
					ValaCCodeFunction* _tmp214_;
					ValaProperty* _tmp215_;
					ValaPropertyAccessor* _tmp216_;
					ValaPropertyAccessor* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					ValaCCodeIdentifier* _tmp220_;
					ValaCCodeIdentifier* _tmp221_;
					ValaGLibValue* _tmp222_;
					ValaGLibValue* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					ValaCCodeExpression* _tmp225_;
					_tmp213_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp214_ = _tmp213_;
					_tmp215_ = prop;
					_tmp216_ = vala_property_get_get_accessor (_tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_property_accessor_get_value_type (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_ccode_identifier_new ("boxed");
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_glib_value_new (_tmp219_, (ValaCCodeExpression*) _tmp221_, TRUE);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp223_, FALSE);
					_tmp225_ = _tmp224_;
					vala_ccode_function_add_expression (_tmp214_, _tmp225_);
					_vala_ccode_node_unref0 (_tmp225_);
					_vala_target_value_unref0 (_tmp223_);
					_vala_ccode_node_unref0 (_tmp221_);
				}
				_tmp226_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp227_ = _tmp226_;
				vala_ccode_function_close (_tmp227_);
				_vala_ccode_node_unref0 (csetcall);
			} else {
				ValaCCodeExpression* _tmp228_;
				ValaCCodeFunctionCall* _tmp229_;
				ValaCCodeFunctionCall* _tmp230_;
				ValaCCodeExpression* _tmp231_;
				ValaArrayType* array_type = NULL;
				ValaProperty* _tmp232_;
				ValaDataType* _tmp233_;
				ValaDataType* _tmp234_;
				ValaArrayType* _tmp235_;
				gboolean _tmp236_ = FALSE;
				gboolean _tmp237_ = FALSE;
				ValaArrayType* _tmp238_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp259_;
				ValaProperty* _tmp260_;
				ValaPropertyAccessor* _tmp261_;
				ValaPropertyAccessor* _tmp262_;
				ValaDataType* _tmp263_;
				ValaDataType* _tmp264_;
				gboolean _tmp265_;
				gboolean _tmp266_;
				ValaCCodeFunctionCall* _tmp279_;
				ValaCCodeIdentifier* _tmp280_;
				ValaCCodeIdentifier* _tmp281_;
				ValaCCodeFunctionCall* _tmp282_;
				ValaCCodeFunctionCall* _tmp283_;
				ValaProperty* _tmp284_;
				ValaCCodeFunctionCall* _tmp285_;
				gboolean _tmp286_ = FALSE;
				gboolean _tmp287_ = FALSE;
				ValaArrayType* _tmp288_;
				_tmp228_ = cfunc;
				_tmp229_ = vala_ccode_function_call_new (_tmp228_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp229_;
				_tmp230_ = ccall;
				_tmp231_ = cself;
				vala_ccode_function_call_add_argument (_tmp230_, _tmp231_);
				_tmp232_ = prop;
				_tmp233_ = vala_property_get_property_type (_tmp232_);
				_tmp234_ = _tmp233_;
				_tmp235_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp234_) : NULL);
				array_type = _tmp235_;
				_tmp238_ = array_type;
				if (_tmp238_ != NULL) {
					ValaProperty* _tmp239_;
					_tmp239_ = prop;
					_tmp237_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp239_);
				} else {
					_tmp237_ = FALSE;
				}
				if (_tmp237_) {
					ValaArrayType* _tmp240_;
					ValaDataType* _tmp241_;
					ValaDataType* _tmp242_;
					ValaTypeSymbol* _tmp243_;
					ValaTypeSymbol* _tmp244_;
					ValaDataType* _tmp245_;
					ValaTypeSymbol* _tmp246_;
					ValaTypeSymbol* _tmp247_;
					_tmp240_ = array_type;
					_tmp241_ = vala_array_type_get_element_type (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_data_type_get_type_symbol (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp246_ = vala_data_type_get_type_symbol (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp236_ = _tmp244_ == _tmp247_;
				} else {
					_tmp236_ = FALSE;
				}
				if (_tmp236_) {
					ValaCCodeFunction* _tmp248_;
					ValaCCodeFunction* _tmp249_;
					ValaCCodeFunction* _tmp250_;
					ValaCCodeFunction* _tmp251_;
					ValaCCodeVariableDeclarator* _tmp252_;
					ValaCCodeVariableDeclarator* _tmp253_;
					ValaCCodeFunctionCall* _tmp254_;
					ValaCCodeIdentifier* _tmp255_;
					ValaCCodeIdentifier* _tmp256_;
					ValaCCodeUnaryExpression* _tmp257_;
					ValaCCodeUnaryExpression* _tmp258_;
					_tmp248_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp249_ = _tmp248_;
					vala_ccode_function_open_block (_tmp249_);
					_tmp250_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
					_tmp253_ = _tmp252_;
					vala_ccode_function_add_declaration (_tmp251_, "int", (ValaCCodeDeclarator*) _tmp253_, 0);
					_vala_ccode_node_unref0 (_tmp253_);
					_tmp254_ = ccall;
					_tmp255_ = vala_ccode_identifier_new ("length");
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp256_);
					_tmp258_ = _tmp257_;
					vala_ccode_function_call_add_argument (_tmp254_, (ValaCCodeExpression*) _tmp258_);
					_vala_ccode_node_unref0 (_tmp258_);
					_vala_ccode_node_unref0 (_tmp256_);
				}
				_tmp259_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp259_;
				_tmp260_ = prop;
				_tmp261_ = vala_property_get_get_accessor (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_property_accessor_get_value_type (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_data_type_get_value_owned (_tmp264_);
				_tmp266_ = _tmp265_;
				if (_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaProperty* _tmp268_;
					ValaDataType* _tmp269_;
					ValaDataType* _tmp270_;
					ValaCCodeIdentifier* _tmp271_;
					ValaCCodeIdentifier* _tmp272_;
					_tmp267_ = csetcall;
					_tmp268_ = prop;
					_tmp269_ = vala_property_get_property_type (_tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, _tmp270_);
					_tmp272_ = _tmp271_;
					vala_ccode_function_call_set_call (_tmp267_, (ValaCCodeExpression*) _tmp272_);
					_vala_ccode_node_unref0 (_tmp272_);
				} else {
					ValaCCodeFunctionCall* _tmp273_;
					ValaProperty* _tmp274_;
					ValaDataType* _tmp275_;
					ValaDataType* _tmp276_;
					ValaCCodeIdentifier* _tmp277_;
					ValaCCodeIdentifier* _tmp278_;
					_tmp273_ = csetcall;
					_tmp274_ = prop;
					_tmp275_ = vala_property_get_property_type (_tmp274_);
					_tmp276_ = _tmp275_;
					_tmp277_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp276_);
					_tmp278_ = _tmp277_;
					vala_ccode_function_call_set_call (_tmp273_, (ValaCCodeExpression*) _tmp278_);
					_vala_ccode_node_unref0 (_tmp278_);
				}
				_tmp279_ = csetcall;
				_tmp280_ = vala_ccode_identifier_new ("value");
				_tmp281_ = _tmp280_;
				vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp281_);
				_vala_ccode_node_unref0 (_tmp281_);
				_tmp282_ = csetcall;
				_tmp283_ = ccall;
				vala_ccode_function_call_add_argument (_tmp282_, (ValaCCodeExpression*) _tmp283_);
				_tmp284_ = prop;
				_tmp285_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp284_, (ValaCCodeExpression*) _tmp285_);
				_tmp288_ = array_type;
				if (_tmp288_ != NULL) {
					ValaProperty* _tmp289_;
					_tmp289_ = prop;
					_tmp287_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp289_);
				} else {
					_tmp287_ = FALSE;
				}
				if (_tmp287_) {
					ValaArrayType* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					ValaTypeSymbol* _tmp293_;
					ValaTypeSymbol* _tmp294_;
					ValaDataType* _tmp295_;
					ValaTypeSymbol* _tmp296_;
					ValaTypeSymbol* _tmp297_;
					_tmp290_ = array_type;
					_tmp291_ = vala_array_type_get_element_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_data_type_get_type_symbol (_tmp292_);
					_tmp294_ = _tmp293_;
					_tmp295_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp296_ = vala_data_type_get_type_symbol (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp286_ = _tmp294_ == _tmp297_;
				} else {
					_tmp286_ = FALSE;
				}
				if (_tmp286_) {
					ValaCCodeFunction* _tmp298_;
					ValaCCodeFunction* _tmp299_;
					_tmp298_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp299_ = _tmp298_;
					vala_ccode_function_close (_tmp299_);
				}
				_vala_ccode_node_unref0 (csetcall);
				_vala_code_node_unref0 (array_type);
			}
			_tmp300_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp301_ = _tmp300_;
			vala_ccode_function_add_break (_tmp301_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp302_;
		ValaList* _tmp303_;
		gint _type_param_size = 0;
		ValaList* _tmp304_;
		gint _tmp305_;
		gint _tmp306_;
		gint _type_param_index = 0;
		_tmp302_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp303_ = _vala_iterable_ref0 (_tmp302_);
		_type_param_list = _tmp303_;
		_tmp304_ = _type_param_list;
		_tmp305_ = vala_collection_get_size ((ValaCollection*) _tmp304_);
		_tmp306_ = _tmp305_;
		_type_param_size = _tmp306_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp307_;
			gpointer _tmp308_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* csetcall = NULL;
			ValaTypeParameter* _tmp309_;
			const gchar* _tmp310_;
			const gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			gchar* _tmp314_;
			gchar* _tmp315_;
			gchar* _tmp316_;
			const gchar* _tmp317_;
			gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			ValaCCodeFunction* _tmp321_;
			ValaCCodeFunction* _tmp322_;
			const gchar* _tmp323_;
			ValaCCodeIdentifier* _tmp324_;
			ValaCCodeIdentifier* _tmp325_;
			ValaCCodeIdentifier* _tmp326_;
			ValaCCodeIdentifier* _tmp327_;
			ValaCCodeMemberAccess* _tmp328_;
			ValaCCodeMemberAccess* _tmp329_;
			const gchar* _tmp330_;
			ValaCCodeMemberAccess* _tmp331_;
			ValaCCodeIdentifier* _tmp332_;
			ValaCCodeIdentifier* _tmp333_;
			ValaCCodeFunctionCall* _tmp334_;
			ValaCCodeFunctionCall* _tmp335_;
			ValaCCodeIdentifier* _tmp336_;
			ValaCCodeIdentifier* _tmp337_;
			ValaCCodeFunctionCall* _tmp338_;
			ValaCCodeMemberAccess* _tmp339_;
			ValaCCodeFunction* _tmp340_;
			ValaCCodeFunction* _tmp341_;
			ValaCCodeFunctionCall* _tmp342_;
			ValaCCodeFunction* _tmp343_;
			ValaCCodeFunction* _tmp344_;
			ValaTypeParameter* _tmp345_;
			const gchar* _tmp346_;
			const gchar* _tmp347_;
			gchar* _tmp348_;
			gchar* _tmp349_;
			gchar* _tmp350_;
			gchar* _tmp351_;
			gchar* _tmp352_;
			const gchar* _tmp353_;
			gchar* _tmp354_;
			gchar* _tmp355_;
			gchar* _tmp356_;
			ValaCCodeFunction* _tmp357_;
			ValaCCodeFunction* _tmp358_;
			const gchar* _tmp359_;
			ValaCCodeIdentifier* _tmp360_;
			ValaCCodeIdentifier* _tmp361_;
			ValaCCodeIdentifier* _tmp362_;
			ValaCCodeIdentifier* _tmp363_;
			ValaCCodeMemberAccess* _tmp364_;
			ValaCCodeMemberAccess* _tmp365_;
			const gchar* _tmp366_;
			ValaCCodeMemberAccess* _tmp367_;
			ValaCCodeIdentifier* _tmp368_;
			ValaCCodeIdentifier* _tmp369_;
			ValaCCodeFunctionCall* _tmp370_;
			ValaCCodeFunctionCall* _tmp371_;
			ValaCCodeIdentifier* _tmp372_;
			ValaCCodeIdentifier* _tmp373_;
			ValaCCodeFunctionCall* _tmp374_;
			ValaCCodeMemberAccess* _tmp375_;
			ValaCCodeFunction* _tmp376_;
			ValaCCodeFunction* _tmp377_;
			ValaCCodeFunctionCall* _tmp378_;
			ValaCCodeFunction* _tmp379_;
			ValaCCodeFunction* _tmp380_;
			ValaTypeParameter* _tmp381_;
			const gchar* _tmp382_;
			const gchar* _tmp383_;
			gchar* _tmp384_;
			gchar* _tmp385_;
			gchar* _tmp386_;
			gchar* _tmp387_;
			gchar* _tmp388_;
			const gchar* _tmp389_;
			gchar* _tmp390_;
			gchar* _tmp391_;
			gchar* _tmp392_;
			ValaCCodeFunction* _tmp393_;
			ValaCCodeFunction* _tmp394_;
			const gchar* _tmp395_;
			ValaCCodeIdentifier* _tmp396_;
			ValaCCodeIdentifier* _tmp397_;
			ValaCCodeIdentifier* _tmp398_;
			ValaCCodeIdentifier* _tmp399_;
			ValaCCodeMemberAccess* _tmp400_;
			ValaCCodeMemberAccess* _tmp401_;
			const gchar* _tmp402_;
			ValaCCodeMemberAccess* _tmp403_;
			ValaCCodeIdentifier* _tmp404_;
			ValaCCodeIdentifier* _tmp405_;
			ValaCCodeFunctionCall* _tmp406_;
			ValaCCodeFunctionCall* _tmp407_;
			ValaCCodeIdentifier* _tmp408_;
			ValaCCodeIdentifier* _tmp409_;
			ValaCCodeFunctionCall* _tmp410_;
			ValaCCodeMemberAccess* _tmp411_;
			ValaCCodeFunction* _tmp412_;
			ValaCCodeFunction* _tmp413_;
			ValaCCodeFunctionCall* _tmp414_;
			ValaCCodeFunction* _tmp415_;
			ValaCCodeFunction* _tmp416_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp307_ = _type_param_list;
			_tmp308_ = vala_list_get (_tmp307_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp308_;
			_tmp309_ = type_param;
			_tmp310_ = vala_symbol_get_name ((ValaSymbol*) _tmp309_);
			_tmp311_ = _tmp310_;
			_tmp312_ = g_ascii_strdown (_tmp311_, (gssize) -1);
			_tmp313_ = _tmp312_;
			_tmp314_ = g_strdup_printf ("%s_type", _tmp313_);
			_g_free0 (func_name);
			func_name = _tmp314_;
			_g_free0 (_tmp313_);
			_tmp315_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp316_ = _tmp315_;
			_tmp317_ = func_name;
			_tmp318_ = g_strdup_printf ("%s_%s", _tmp316_, _tmp317_);
			_tmp319_ = _tmp318_;
			_tmp320_ = g_ascii_strup (_tmp319_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp320_;
			_g_free0 (_tmp319_);
			_g_free0 (_tmp316_);
			_tmp321_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp322_ = _tmp321_;
			_tmp323_ = enum_value;
			_tmp324_ = vala_ccode_identifier_new (_tmp323_);
			_tmp325_ = _tmp324_;
			vala_ccode_function_add_case (_tmp322_, (ValaCCodeExpression*) _tmp325_);
			_vala_ccode_node_unref0 (_tmp325_);
			_tmp326_ = vala_ccode_identifier_new ("self");
			_tmp327_ = _tmp326_;
			_tmp328_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp327_, "priv");
			_tmp329_ = _tmp328_;
			_tmp330_ = func_name;
			_tmp331_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp329_, _tmp330_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp331_;
			_vala_ccode_node_unref0 (_tmp329_);
			_vala_ccode_node_unref0 (_tmp327_);
			_tmp332_ = vala_ccode_identifier_new ("g_value_set_gtype");
			_tmp333_ = _tmp332_;
			_tmp334_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp333_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp334_;
			_vala_ccode_node_unref0 (_tmp333_);
			_tmp335_ = csetcall;
			_tmp336_ = vala_ccode_identifier_new ("value");
			_tmp337_ = _tmp336_;
			vala_ccode_function_call_add_argument (_tmp335_, (ValaCCodeExpression*) _tmp337_);
			_vala_ccode_node_unref0 (_tmp337_);
			_tmp338_ = csetcall;
			_tmp339_ = cfield;
			vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp339_);
			_tmp340_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp341_ = _tmp340_;
			_tmp342_ = csetcall;
			vala_ccode_function_add_expression (_tmp341_, (ValaCCodeExpression*) _tmp342_);
			_tmp343_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp344_ = _tmp343_;
			vala_ccode_function_add_break (_tmp344_);
			_tmp345_ = type_param;
			_tmp346_ = vala_symbol_get_name ((ValaSymbol*) _tmp345_);
			_tmp347_ = _tmp346_;
			_tmp348_ = g_ascii_strdown (_tmp347_, (gssize) -1);
			_tmp349_ = _tmp348_;
			_tmp350_ = g_strdup_printf ("%s_dup_func", _tmp349_);
			_g_free0 (func_name);
			func_name = _tmp350_;
			_g_free0 (_tmp349_);
			_tmp351_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp352_ = _tmp351_;
			_tmp353_ = func_name;
			_tmp354_ = g_strdup_printf ("%s_%s", _tmp352_, _tmp353_);
			_tmp355_ = _tmp354_;
			_tmp356_ = g_ascii_strup (_tmp355_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp356_;
			_g_free0 (_tmp355_);
			_g_free0 (_tmp352_);
			_tmp357_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp358_ = _tmp357_;
			_tmp359_ = enum_value;
			_tmp360_ = vala_ccode_identifier_new (_tmp359_);
			_tmp361_ = _tmp360_;
			vala_ccode_function_add_case (_tmp358_, (ValaCCodeExpression*) _tmp361_);
			_vala_ccode_node_unref0 (_tmp361_);
			_tmp362_ = vala_ccode_identifier_new ("self");
			_tmp363_ = _tmp362_;
			_tmp364_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp363_, "priv");
			_tmp365_ = _tmp364_;
			_tmp366_ = func_name;
			_tmp367_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp365_, _tmp366_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp367_;
			_vala_ccode_node_unref0 (_tmp365_);
			_vala_ccode_node_unref0 (_tmp363_);
			_tmp368_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp369_ = _tmp368_;
			_tmp370_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp369_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp370_;
			_vala_ccode_node_unref0 (_tmp369_);
			_tmp371_ = csetcall;
			_tmp372_ = vala_ccode_identifier_new ("value");
			_tmp373_ = _tmp372_;
			vala_ccode_function_call_add_argument (_tmp371_, (ValaCCodeExpression*) _tmp373_);
			_vala_ccode_node_unref0 (_tmp373_);
			_tmp374_ = csetcall;
			_tmp375_ = cfield;
			vala_ccode_function_call_add_argument (_tmp374_, (ValaCCodeExpression*) _tmp375_);
			_tmp376_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp377_ = _tmp376_;
			_tmp378_ = csetcall;
			vala_ccode_function_add_expression (_tmp377_, (ValaCCodeExpression*) _tmp378_);
			_tmp379_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp380_ = _tmp379_;
			vala_ccode_function_add_break (_tmp380_);
			_tmp381_ = type_param;
			_tmp382_ = vala_symbol_get_name ((ValaSymbol*) _tmp381_);
			_tmp383_ = _tmp382_;
			_tmp384_ = g_ascii_strdown (_tmp383_, (gssize) -1);
			_tmp385_ = _tmp384_;
			_tmp386_ = g_strdup_printf ("%s_destroy_func", _tmp385_);
			_g_free0 (func_name);
			func_name = _tmp386_;
			_g_free0 (_tmp385_);
			_tmp387_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp388_ = _tmp387_;
			_tmp389_ = func_name;
			_tmp390_ = g_strdup_printf ("%s_%s", _tmp388_, _tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = g_ascii_strup (_tmp391_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp392_;
			_g_free0 (_tmp391_);
			_g_free0 (_tmp388_);
			_tmp393_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp394_ = _tmp393_;
			_tmp395_ = enum_value;
			_tmp396_ = vala_ccode_identifier_new (_tmp395_);
			_tmp397_ = _tmp396_;
			vala_ccode_function_add_case (_tmp394_, (ValaCCodeExpression*) _tmp397_);
			_vala_ccode_node_unref0 (_tmp397_);
			_tmp398_ = vala_ccode_identifier_new ("self");
			_tmp399_ = _tmp398_;
			_tmp400_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp399_, "priv");
			_tmp401_ = _tmp400_;
			_tmp402_ = func_name;
			_tmp403_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp401_, _tmp402_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp403_;
			_vala_ccode_node_unref0 (_tmp401_);
			_vala_ccode_node_unref0 (_tmp399_);
			_tmp404_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp405_ = _tmp404_;
			_tmp406_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp405_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp406_;
			_vala_ccode_node_unref0 (_tmp405_);
			_tmp407_ = csetcall;
			_tmp408_ = vala_ccode_identifier_new ("value");
			_tmp409_ = _tmp408_;
			vala_ccode_function_call_add_argument (_tmp407_, (ValaCCodeExpression*) _tmp409_);
			_vala_ccode_node_unref0 (_tmp409_);
			_tmp410_ = csetcall;
			_tmp411_ = cfield;
			vala_ccode_function_call_add_argument (_tmp410_, (ValaCCodeExpression*) _tmp411_);
			_tmp412_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp413_ = _tmp412_;
			_tmp414_ = csetcall;
			vala_ccode_function_add_expression (_tmp413_, (ValaCCodeExpression*) _tmp414_);
			_tmp415_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp416_ = _tmp415_;
			vala_ccode_function_add_break (_tmp416_);
			_vala_ccode_node_unref0 (csetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp417_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp418_ = _tmp417_;
	vala_ccode_function_add_default (_tmp418_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp419_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp420_ = _tmp419_;
	vala_ccode_function_add_break (_tmp420_);
	_tmp421_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp422_ = _tmp421_;
	vala_ccode_function_close (_tmp422_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp423_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp424_ = get_prop;
	vala_ccode_file_add_function_declaration (_tmp423_, _tmp424_);
	_tmp425_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp426_ = get_prop;
	vala_ccode_file_add_function (_tmp425_, _tmp426_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (get_prop);
}

static void
vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* set_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaCCodeFunction* _tmp352_;
	ValaCCodeFunction* _tmp353_;
	ValaCCodeFunction* _tmp354_;
	ValaCCodeFunction* _tmp355_;
	ValaCCodeFunction* _tmp356_;
	ValaCCodeFunction* _tmp357_;
	ValaCCodeFile* _tmp358_;
	ValaCCodeFunction* _tmp359_;
	ValaCCodeFile* _tmp360_;
	ValaCCodeFunction* _tmp361_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_set_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	set_prop = _tmp5_;
	_tmp6_ = set_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = set_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = set_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = set_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "const GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = set_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = set_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _vala_iterable_ref0 (_tmp37_);
	props = _tmp38_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp39_;
		ValaList* _tmp40_;
		gint _prop_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _prop_index = 0;
		_tmp39_ = props;
		_tmp40_ = _vala_iterable_ref0 (_tmp39_);
		_prop_list = _tmp40_;
		_tmp41_ = _prop_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_prop_size = _tmp43_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp44_;
			gpointer _tmp45_;
			gboolean _tmp46_ = FALSE;
			ValaProperty* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaCodeContext* _tmp53_;
			ValaCodeContext* _tmp54_;
			ValaSemanticAnalyzer* _tmp55_;
			ValaSemanticAnalyzer* _tmp56_;
			ValaProperty* _tmp57_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp58_;
			ValaProperty* _tmp59_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp60_;
			ValaProperty* _tmp61_;
			ValaProperty* _tmp62_;
			ValaProperty* _tmp63_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp123_ = FALSE;
			ValaProperty* _tmp124_;
			ValaCCodeFunction* _tmp138_;
			ValaCCodeFunction* _tmp139_;
			ValaProperty* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeIdentifier* _tmp146_;
			ValaCCodeExpression* _tmp147_;
			ValaCCodeFunctionCall* _tmp148_;
			ValaCCodeFunctionCall* _tmp149_;
			ValaCCodeExpression* _tmp150_;
			gboolean _tmp151_ = FALSE;
			ValaProperty* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			ValaCCodeFunction* _tmp238_;
			ValaCCodeFunction* _tmp239_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp44_ = _prop_list;
			_tmp45_ = vala_list_get (_tmp44_, _prop_index);
			prop = (ValaProperty*) _tmp45_;
			_tmp47_ = prop;
			_tmp48_ = vala_property_get_set_accessor (_tmp47_);
			_tmp49_ = _tmp48_;
			if (_tmp49_ == NULL) {
				_tmp46_ = TRUE;
			} else {
				ValaProperty* _tmp50_;
				gboolean _tmp51_;
				gboolean _tmp52_;
				_tmp50_ = prop;
				_tmp51_ = vala_property_get_is_abstract (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp46_ = _tmp52_;
			}
			if (_tmp46_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp53_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_code_context_get_analyzer (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp56_, _tmp57_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp58_ = prop;
			_tmp59_ = _vala_code_node_ref0 (_tmp58_);
			base_prop = _tmp59_;
			_tmp60_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp60_;
			_tmp61_ = prop;
			_tmp62_ = vala_property_get_base_property (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp64_;
				ValaProperty* _tmp65_;
				ValaProperty* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				ValaClass* _tmp69_;
				ValaProperty* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaProperty* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaObjectType* _tmp75_;
				ValaCCodeExpression* _tmp76_;
				ValaGLibValue* _tmp77_;
				ValaGLibValue* _tmp78_;
				ValaClass* _tmp79_;
				ValaObjectType* _tmp80_;
				ValaObjectType* _tmp81_;
				ValaProperty* _tmp82_;
				ValaTargetValue* _tmp83_;
				ValaTargetValue* _tmp84_;
				ValaCCodeExpression* _tmp85_;
				ValaProperty* _tmp86_;
				ValaProperty* _tmp87_;
				ValaProperty* _tmp88_;
				ValaPropertyAccessor* _tmp89_;
				ValaPropertyAccessor* _tmp90_;
				ValaCCodeFile* _tmp91_;
				_tmp64_ = prop;
				_tmp65_ = vala_property_get_base_property (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp69_;
				_tmp70_ = prop;
				_tmp71_ = vala_property_get_base_property (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = _vala_code_node_ref0 (_tmp72_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp73_;
				_tmp74_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp75_ = _tmp74_;
				_tmp76_ = cself;
				_tmp77_ = vala_glib_value_new ((ValaDataType*) _tmp75_, _tmp76_, TRUE);
				_tmp78_ = _tmp77_;
				_tmp79_ = base_type;
				_tmp80_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = prop;
				_tmp83_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp78_, (ValaDataType*) _tmp81_, (ValaCodeNode*) _tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp84_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp85_;
				_vala_target_value_unref0 (_tmp84_);
				_vala_code_node_unref0 (_tmp81_);
				_vala_target_value_unref0 (_tmp78_);
				_vala_code_node_unref0 (_tmp75_);
				_tmp86_ = prop;
				_tmp87_ = vala_property_get_base_property (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_property_get_set_accessor (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp90_, _tmp91_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				ValaProperty* _tmp94_;
				_tmp92_ = prop;
				_tmp93_ = vala_property_get_base_interface_property (_tmp92_);
				_tmp94_ = _tmp93_;
				if (_tmp94_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaProperty* _tmp97_;
					ValaSymbol* _tmp98_;
					ValaSymbol* _tmp99_;
					ValaInterface* _tmp100_;
					ValaProperty* _tmp101_;
					ValaProperty* _tmp102_;
					ValaProperty* _tmp103_;
					ValaProperty* _tmp104_;
					ValaObjectType* _tmp105_;
					ValaObjectType* _tmp106_;
					ValaCCodeExpression* _tmp107_;
					ValaGLibValue* _tmp108_;
					ValaGLibValue* _tmp109_;
					ValaInterface* _tmp110_;
					ValaObjectType* _tmp111_;
					ValaObjectType* _tmp112_;
					ValaProperty* _tmp113_;
					ValaTargetValue* _tmp114_;
					ValaTargetValue* _tmp115_;
					ValaCCodeExpression* _tmp116_;
					ValaProperty* _tmp117_;
					ValaProperty* _tmp118_;
					ValaProperty* _tmp119_;
					ValaPropertyAccessor* _tmp120_;
					ValaPropertyAccessor* _tmp121_;
					ValaCCodeFile* _tmp122_;
					_tmp95_ = prop;
					_tmp96_ = vala_property_get_base_interface_property (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp100_;
					_tmp101_ = prop;
					_tmp102_ = vala_property_get_base_interface_property (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = _vala_code_node_ref0 (_tmp103_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp104_;
					_tmp105_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp106_ = _tmp105_;
					_tmp107_ = cself;
					_tmp108_ = vala_glib_value_new ((ValaDataType*) _tmp106_, _tmp107_, TRUE);
					_tmp109_ = _tmp108_;
					_tmp110_ = base_type;
					_tmp111_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = prop;
					_tmp114_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp109_, (ValaDataType*) _tmp112_, (ValaCodeNode*) _tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp115_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp116_;
					_vala_target_value_unref0 (_tmp115_);
					_vala_code_node_unref0 (_tmp112_);
					_vala_target_value_unref0 (_tmp109_);
					_vala_code_node_unref0 (_tmp106_);
					_tmp117_ = prop;
					_tmp118_ = vala_property_get_base_interface_property (_tmp117_);
					_tmp119_ = _tmp118_;
					_tmp120_ = vala_property_get_set_accessor (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp121_, _tmp122_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp124_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp124_)) {
				ValaProperty* _tmp125_;
				_tmp125_ = base_prop;
				_tmp123_ = !vala_get_ccode_concrete_accessor (_tmp125_);
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				ValaProperty* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				ValaPropertyAccessor* _tmp128_;
				gchar* _tmp129_;
				gchar* _tmp130_;
				ValaCCodeIdentifier* _tmp131_;
				_tmp126_ = base_prop;
				_tmp127_ = vala_property_get_set_accessor (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_get_ccode_name ((ValaCodeNode*) _tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_ccode_identifier_new (_tmp130_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp131_;
				_g_free0 (_tmp130_);
			} else {
				ValaProperty* _tmp132_;
				ValaPropertyAccessor* _tmp133_;
				ValaPropertyAccessor* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				ValaCCodeIdentifier* _tmp137_;
				_tmp132_ = prop;
				_tmp133_ = vala_property_get_set_accessor (_tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				_tmp136_ = _tmp135_;
				_tmp137_ = vala_ccode_identifier_new (_tmp136_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp137_;
				_g_free0 (_tmp136_);
			}
			_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = prop;
			_tmp141_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp140_, NULL);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("%s_PROPERTY", _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_ccode_identifier_new (_tmp144_);
			_tmp146_ = _tmp145_;
			vala_ccode_function_add_case (_tmp139_, (ValaCCodeExpression*) _tmp146_);
			_vala_ccode_node_unref0 (_tmp146_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_tmp147_ = cfunc;
			_tmp148_ = vala_ccode_function_call_new (_tmp147_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp148_;
			_tmp149_ = ccall;
			_tmp150_ = cself;
			vala_ccode_function_call_add_argument (_tmp149_, _tmp150_);
			_tmp152_ = prop;
			_tmp153_ = vala_property_get_property_type (_tmp152_);
			_tmp154_ = _tmp153_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp154_, VALA_TYPE_ARRAY_TYPE)) {
				ValaProperty* _tmp155_;
				ValaDataType* _tmp156_;
				ValaDataType* _tmp157_;
				ValaDataType* _tmp158_;
				ValaDataType* _tmp159_;
				ValaTypeSymbol* _tmp160_;
				ValaTypeSymbol* _tmp161_;
				ValaDataType* _tmp162_;
				ValaTypeSymbol* _tmp163_;
				ValaTypeSymbol* _tmp164_;
				_tmp155_ = prop;
				_tmp156_ = vala_property_get_property_type (_tmp155_);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_data_type_get_type_symbol (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp163_ = vala_data_type_get_type_symbol (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp151_ = _tmp161_ == _tmp164_;
			} else {
				_tmp151_ = FALSE;
			}
			if (_tmp151_) {
				ValaCCodeFunction* _tmp165_;
				ValaCCodeFunction* _tmp166_;
				ValaCCodeFunction* _tmp167_;
				ValaCCodeFunction* _tmp168_;
				ValaCCodeVariableDeclarator* _tmp169_;
				ValaCCodeVariableDeclarator* _tmp170_;
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeIdentifier* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaCCodeFunctionCall* _tmp175_;
				ValaCCodeIdentifier* _tmp176_;
				ValaCCodeIdentifier* _tmp177_;
				ValaCCodeFunction* _tmp178_;
				ValaCCodeFunction* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeFunctionCall* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeIdentifier* _tmp184_;
				ValaCCodeIdentifier* _tmp185_;
				ValaProperty* _tmp186_;
				ValaProperty* _tmp208_;
				ValaCCodeFunctionCall* _tmp209_;
				ValaCCodeFunction* _tmp210_;
				ValaCCodeFunction* _tmp211_;
				_tmp165_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp166_ = _tmp165_;
				vala_ccode_function_open_block (_tmp166_);
				_tmp167_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp170_ = _tmp169_;
				vala_ccode_function_add_declaration (_tmp168_, "gpointer", (ValaCCodeDeclarator*) _tmp170_, 0);
				_vala_ccode_node_unref0 (_tmp170_);
				_tmp171_ = vala_ccode_identifier_new ("g_value_get_boxed");
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp172_);
				_tmp174_ = _tmp173_;
				_vala_ccode_node_unref0 (_tmp172_);
				cgetcall = _tmp174_;
				_tmp175_ = cgetcall;
				_tmp176_ = vala_ccode_identifier_new ("value");
				_tmp177_ = _tmp176_;
				vala_ccode_function_call_add_argument (_tmp175_, (ValaCCodeExpression*) _tmp177_);
				_vala_ccode_node_unref0 (_tmp177_);
				_tmp178_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_ccode_identifier_new ("boxed");
				_tmp181_ = _tmp180_;
				_tmp182_ = cgetcall;
				vala_ccode_function_add_assignment (_tmp179_, (ValaCCodeExpression*) _tmp181_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp181_);
				_tmp183_ = ccall;
				_tmp184_ = vala_ccode_identifier_new ("boxed");
				_tmp185_ = _tmp184_;
				vala_ccode_function_call_add_argument (_tmp183_, (ValaCCodeExpression*) _tmp185_);
				_vala_ccode_node_unref0 (_tmp185_);
				_tmp186_ = prop;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp186_)) {
					ValaCCodeBinaryExpression* cisnull = NULL;
					ValaCCodeIdentifier* _tmp187_;
					ValaCCodeIdentifier* _tmp188_;
					ValaCCodeConstant* _tmp189_;
					ValaCCodeConstant* _tmp190_;
					ValaCCodeBinaryExpression* _tmp191_;
					ValaCCodeBinaryExpression* _tmp192_;
					ValaCCodeFunctionCall* cstrvlen = NULL;
					ValaCCodeIdentifier* _tmp193_;
					ValaCCodeIdentifier* _tmp194_;
					ValaCCodeFunctionCall* _tmp195_;
					ValaCCodeFunctionCall* _tmp196_;
					ValaCCodeFunctionCall* _tmp197_;
					ValaCCodeIdentifier* _tmp198_;
					ValaCCodeIdentifier* _tmp199_;
					ValaCCodeConditionalExpression* ccond = NULL;
					ValaCCodeBinaryExpression* _tmp200_;
					ValaCCodeConstant* _tmp201_;
					ValaCCodeConstant* _tmp202_;
					ValaCCodeFunctionCall* _tmp203_;
					ValaCCodeConditionalExpression* _tmp204_;
					ValaCCodeConditionalExpression* _tmp205_;
					ValaCCodeFunctionCall* _tmp206_;
					ValaCCodeConditionalExpression* _tmp207_;
					_tmp187_ = vala_ccode_identifier_new ("boxed");
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_ccode_constant_new ("NULL");
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp188_, (ValaCCodeExpression*) _tmp190_);
					_tmp192_ = _tmp191_;
					_vala_ccode_node_unref0 (_tmp190_);
					_vala_ccode_node_unref0 (_tmp188_);
					cisnull = _tmp192_;
					_tmp193_ = vala_ccode_identifier_new ("g_strv_length");
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp194_);
					_tmp196_ = _tmp195_;
					_vala_ccode_node_unref0 (_tmp194_);
					cstrvlen = _tmp196_;
					_tmp197_ = cstrvlen;
					_tmp198_ = vala_ccode_identifier_new ("boxed");
					_tmp199_ = _tmp198_;
					vala_ccode_function_call_add_argument (_tmp197_, (ValaCCodeExpression*) _tmp199_);
					_vala_ccode_node_unref0 (_tmp199_);
					_tmp200_ = cisnull;
					_tmp201_ = vala_ccode_constant_new ("0");
					_tmp202_ = _tmp201_;
					_tmp203_ = cstrvlen;
					_tmp204_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp200_, (ValaCCodeExpression*) _tmp202_, (ValaCCodeExpression*) _tmp203_);
					_tmp205_ = _tmp204_;
					_vala_ccode_node_unref0 (_tmp202_);
					ccond = _tmp205_;
					_tmp206_ = ccall;
					_tmp207_ = ccond;
					vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp207_);
					_vala_ccode_node_unref0 (ccond);
					_vala_ccode_node_unref0 (cstrvlen);
					_vala_ccode_node_unref0 (cisnull);
				}
				_tmp208_ = prop;
				_tmp209_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp208_, (ValaCCodeExpression*) _tmp209_);
				_tmp210_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp211_ = _tmp210_;
				vala_ccode_function_close (_tmp211_);
				_vala_ccode_node_unref0 (cgetcall);
			} else {
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeFunctionCall* _tmp212_;
				ValaProperty* _tmp213_;
				ValaDataType* _tmp214_;
				ValaDataType* _tmp215_;
				ValaTypeSymbol* _tmp216_;
				ValaTypeSymbol* _tmp217_;
				ValaCCodeFunctionCall* _tmp231_;
				ValaCCodeIdentifier* _tmp232_;
				ValaCCodeIdentifier* _tmp233_;
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeFunctionCall* _tmp235_;
				ValaProperty* _tmp236_;
				ValaCCodeFunctionCall* _tmp237_;
				_tmp212_ = vala_ccode_function_call_new (NULL);
				cgetcall = _tmp212_;
				_tmp213_ = prop;
				_tmp214_ = vala_property_get_property_type (_tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = vala_data_type_get_type_symbol (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaCCodeFunctionCall* _tmp218_;
					ValaProperty* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaTypeSymbol* _tmp222_;
					ValaTypeSymbol* _tmp223_;
					gchar* _tmp224_;
					gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					_tmp218_ = cgetcall;
					_tmp219_ = prop;
					_tmp220_ = vala_property_get_property_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_data_type_get_type_symbol (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					vala_ccode_function_call_set_call (_tmp218_, (ValaCCodeExpression*) _tmp227_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (_tmp225_);
				} else {
					ValaCCodeFunctionCall* _tmp228_;
					ValaCCodeIdentifier* _tmp229_;
					ValaCCodeIdentifier* _tmp230_;
					_tmp228_ = cgetcall;
					_tmp229_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp230_ = _tmp229_;
					vala_ccode_function_call_set_call (_tmp228_, (ValaCCodeExpression*) _tmp230_);
					_vala_ccode_node_unref0 (_tmp230_);
				}
				_tmp231_ = cgetcall;
				_tmp232_ = vala_ccode_identifier_new ("value");
				_tmp233_ = _tmp232_;
				vala_ccode_function_call_add_argument (_tmp231_, (ValaCCodeExpression*) _tmp233_);
				_vala_ccode_node_unref0 (_tmp233_);
				_tmp234_ = ccall;
				_tmp235_ = cgetcall;
				vala_ccode_function_call_add_argument (_tmp234_, (ValaCCodeExpression*) _tmp235_);
				_tmp236_ = prop;
				_tmp237_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp236_, (ValaCCodeExpression*) _tmp237_);
				_vala_ccode_node_unref0 (cgetcall);
			}
			_tmp238_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp239_ = _tmp238_;
			vala_ccode_function_add_break (_tmp239_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp240_;
		ValaList* _tmp241_;
		gint _type_param_size = 0;
		ValaList* _tmp242_;
		gint _tmp243_;
		gint _tmp244_;
		gint _type_param_index = 0;
		_tmp240_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp241_ = _vala_iterable_ref0 (_tmp240_);
		_type_param_list = _tmp241_;
		_tmp242_ = _type_param_list;
		_tmp243_ = vala_collection_get_size ((ValaCollection*) _tmp242_);
		_tmp244_ = _tmp243_;
		_type_param_size = _tmp244_;
		_type_param_index = -1;
		while (TRUE) {
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp245_;
			gpointer _tmp246_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* cgetcall = NULL;
			ValaTypeParameter* _tmp247_;
			const gchar* _tmp248_;
			const gchar* _tmp249_;
			gchar* _tmp250_;
			gchar* _tmp251_;
			gchar* _tmp252_;
			gchar* _tmp253_;
			gchar* _tmp254_;
			const gchar* _tmp255_;
			gchar* _tmp256_;
			gchar* _tmp257_;
			gchar* _tmp258_;
			ValaCCodeFunction* _tmp259_;
			ValaCCodeFunction* _tmp260_;
			const gchar* _tmp261_;
			ValaCCodeIdentifier* _tmp262_;
			ValaCCodeIdentifier* _tmp263_;
			ValaCCodeIdentifier* _tmp264_;
			ValaCCodeIdentifier* _tmp265_;
			ValaCCodeMemberAccess* _tmp266_;
			ValaCCodeMemberAccess* _tmp267_;
			const gchar* _tmp268_;
			ValaCCodeMemberAccess* _tmp269_;
			ValaCCodeIdentifier* _tmp270_;
			ValaCCodeIdentifier* _tmp271_;
			ValaCCodeFunctionCall* _tmp272_;
			ValaCCodeFunctionCall* _tmp273_;
			ValaCCodeIdentifier* _tmp274_;
			ValaCCodeIdentifier* _tmp275_;
			ValaCCodeFunction* _tmp276_;
			ValaCCodeFunction* _tmp277_;
			ValaCCodeMemberAccess* _tmp278_;
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeFunction* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaTypeParameter* _tmp282_;
			const gchar* _tmp283_;
			const gchar* _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			gchar* _tmp287_;
			gchar* _tmp288_;
			gchar* _tmp289_;
			const gchar* _tmp290_;
			gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			ValaCCodeFunction* _tmp294_;
			ValaCCodeFunction* _tmp295_;
			const gchar* _tmp296_;
			ValaCCodeIdentifier* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeIdentifier* _tmp300_;
			ValaCCodeMemberAccess* _tmp301_;
			ValaCCodeMemberAccess* _tmp302_;
			const gchar* _tmp303_;
			ValaCCodeMemberAccess* _tmp304_;
			ValaCCodeIdentifier* _tmp305_;
			ValaCCodeIdentifier* _tmp306_;
			ValaCCodeFunctionCall* _tmp307_;
			ValaCCodeFunctionCall* _tmp308_;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeFunction* _tmp311_;
			ValaCCodeFunction* _tmp312_;
			ValaCCodeMemberAccess* _tmp313_;
			ValaCCodeFunctionCall* _tmp314_;
			ValaCCodeFunction* _tmp315_;
			ValaCCodeFunction* _tmp316_;
			ValaTypeParameter* _tmp317_;
			const gchar* _tmp318_;
			const gchar* _tmp319_;
			gchar* _tmp320_;
			gchar* _tmp321_;
			gchar* _tmp322_;
			gchar* _tmp323_;
			gchar* _tmp324_;
			const gchar* _tmp325_;
			gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			ValaCCodeFunction* _tmp329_;
			ValaCCodeFunction* _tmp330_;
			const gchar* _tmp331_;
			ValaCCodeIdentifier* _tmp332_;
			ValaCCodeIdentifier* _tmp333_;
			ValaCCodeIdentifier* _tmp334_;
			ValaCCodeIdentifier* _tmp335_;
			ValaCCodeMemberAccess* _tmp336_;
			ValaCCodeMemberAccess* _tmp337_;
			const gchar* _tmp338_;
			ValaCCodeMemberAccess* _tmp339_;
			ValaCCodeIdentifier* _tmp340_;
			ValaCCodeIdentifier* _tmp341_;
			ValaCCodeFunctionCall* _tmp342_;
			ValaCCodeFunctionCall* _tmp343_;
			ValaCCodeIdentifier* _tmp344_;
			ValaCCodeIdentifier* _tmp345_;
			ValaCCodeFunction* _tmp346_;
			ValaCCodeFunction* _tmp347_;
			ValaCCodeMemberAccess* _tmp348_;
			ValaCCodeFunctionCall* _tmp349_;
			ValaCCodeFunction* _tmp350_;
			ValaCCodeFunction* _tmp351_;
			_type_param_index = _type_param_index + 1;
			if (!(_type_param_index < _type_param_size)) {
				break;
			}
			_tmp245_ = _type_param_list;
			_tmp246_ = vala_list_get (_tmp245_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp246_;
			_tmp247_ = type_param;
			_tmp248_ = vala_symbol_get_name ((ValaSymbol*) _tmp247_);
			_tmp249_ = _tmp248_;
			_tmp250_ = g_ascii_strdown (_tmp249_, (gssize) -1);
			_tmp251_ = _tmp250_;
			_tmp252_ = g_strdup_printf ("%s_type", _tmp251_);
			_g_free0 (func_name);
			func_name = _tmp252_;
			_g_free0 (_tmp251_);
			_tmp253_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp254_ = _tmp253_;
			_tmp255_ = func_name;
			_tmp256_ = g_strdup_printf ("%s_%s", _tmp254_, _tmp255_);
			_tmp257_ = _tmp256_;
			_tmp258_ = g_ascii_strup (_tmp257_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp258_;
			_g_free0 (_tmp257_);
			_g_free0 (_tmp254_);
			_tmp259_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp260_ = _tmp259_;
			_tmp261_ = enum_value;
			_tmp262_ = vala_ccode_identifier_new (_tmp261_);
			_tmp263_ = _tmp262_;
			vala_ccode_function_add_case (_tmp260_, (ValaCCodeExpression*) _tmp263_);
			_vala_ccode_node_unref0 (_tmp263_);
			_tmp264_ = vala_ccode_identifier_new ("self");
			_tmp265_ = _tmp264_;
			_tmp266_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp265_, "priv");
			_tmp267_ = _tmp266_;
			_tmp268_ = func_name;
			_tmp269_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp267_, _tmp268_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp269_;
			_vala_ccode_node_unref0 (_tmp267_);
			_vala_ccode_node_unref0 (_tmp265_);
			_tmp270_ = vala_ccode_identifier_new ("g_value_get_gtype");
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp271_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp272_;
			_vala_ccode_node_unref0 (_tmp271_);
			_tmp273_ = cgetcall;
			_tmp274_ = vala_ccode_identifier_new ("value");
			_tmp275_ = _tmp274_;
			vala_ccode_function_call_add_argument (_tmp273_, (ValaCCodeExpression*) _tmp275_);
			_vala_ccode_node_unref0 (_tmp275_);
			_tmp276_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp277_ = _tmp276_;
			_tmp278_ = cfield;
			_tmp279_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp277_, (ValaCCodeExpression*) _tmp278_, (ValaCCodeExpression*) _tmp279_);
			_tmp280_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp281_ = _tmp280_;
			vala_ccode_function_add_break (_tmp281_);
			_tmp282_ = type_param;
			_tmp283_ = vala_symbol_get_name ((ValaSymbol*) _tmp282_);
			_tmp284_ = _tmp283_;
			_tmp285_ = g_ascii_strdown (_tmp284_, (gssize) -1);
			_tmp286_ = _tmp285_;
			_tmp287_ = g_strdup_printf ("%s_dup_func", _tmp286_);
			_g_free0 (func_name);
			func_name = _tmp287_;
			_g_free0 (_tmp286_);
			_tmp288_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp289_ = _tmp288_;
			_tmp290_ = func_name;
			_tmp291_ = g_strdup_printf ("%s_%s", _tmp289_, _tmp290_);
			_tmp292_ = _tmp291_;
			_tmp293_ = g_ascii_strup (_tmp292_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp293_;
			_g_free0 (_tmp292_);
			_g_free0 (_tmp289_);
			_tmp294_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp295_ = _tmp294_;
			_tmp296_ = enum_value;
			_tmp297_ = vala_ccode_identifier_new (_tmp296_);
			_tmp298_ = _tmp297_;
			vala_ccode_function_add_case (_tmp295_, (ValaCCodeExpression*) _tmp298_);
			_vala_ccode_node_unref0 (_tmp298_);
			_tmp299_ = vala_ccode_identifier_new ("self");
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp300_, "priv");
			_tmp302_ = _tmp301_;
			_tmp303_ = func_name;
			_tmp304_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp302_, _tmp303_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp304_;
			_vala_ccode_node_unref0 (_tmp302_);
			_vala_ccode_node_unref0 (_tmp300_);
			_tmp305_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp306_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp307_;
			_vala_ccode_node_unref0 (_tmp306_);
			_tmp308_ = cgetcall;
			_tmp309_ = vala_ccode_identifier_new ("value");
			_tmp310_ = _tmp309_;
			vala_ccode_function_call_add_argument (_tmp308_, (ValaCCodeExpression*) _tmp310_);
			_vala_ccode_node_unref0 (_tmp310_);
			_tmp311_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp312_ = _tmp311_;
			_tmp313_ = cfield;
			_tmp314_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp312_, (ValaCCodeExpression*) _tmp313_, (ValaCCodeExpression*) _tmp314_);
			_tmp315_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp316_ = _tmp315_;
			vala_ccode_function_add_break (_tmp316_);
			_tmp317_ = type_param;
			_tmp318_ = vala_symbol_get_name ((ValaSymbol*) _tmp317_);
			_tmp319_ = _tmp318_;
			_tmp320_ = g_ascii_strdown (_tmp319_, (gssize) -1);
			_tmp321_ = _tmp320_;
			_tmp322_ = g_strdup_printf ("%s_destroy_func", _tmp321_);
			_g_free0 (func_name);
			func_name = _tmp322_;
			_g_free0 (_tmp321_);
			_tmp323_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp324_ = _tmp323_;
			_tmp325_ = func_name;
			_tmp326_ = g_strdup_printf ("%s_%s", _tmp324_, _tmp325_);
			_tmp327_ = _tmp326_;
			_tmp328_ = g_ascii_strup (_tmp327_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp328_;
			_g_free0 (_tmp327_);
			_g_free0 (_tmp324_);
			_tmp329_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp330_ = _tmp329_;
			_tmp331_ = enum_value;
			_tmp332_ = vala_ccode_identifier_new (_tmp331_);
			_tmp333_ = _tmp332_;
			vala_ccode_function_add_case (_tmp330_, (ValaCCodeExpression*) _tmp333_);
			_vala_ccode_node_unref0 (_tmp333_);
			_tmp334_ = vala_ccode_identifier_new ("self");
			_tmp335_ = _tmp334_;
			_tmp336_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp335_, "priv");
			_tmp337_ = _tmp336_;
			_tmp338_ = func_name;
			_tmp339_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp337_, _tmp338_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp339_;
			_vala_ccode_node_unref0 (_tmp337_);
			_vala_ccode_node_unref0 (_tmp335_);
			_tmp340_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp341_ = _tmp340_;
			_tmp342_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp341_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp342_;
			_vala_ccode_node_unref0 (_tmp341_);
			_tmp343_ = cgetcall;
			_tmp344_ = vala_ccode_identifier_new ("value");
			_tmp345_ = _tmp344_;
			vala_ccode_function_call_add_argument (_tmp343_, (ValaCCodeExpression*) _tmp345_);
			_vala_ccode_node_unref0 (_tmp345_);
			_tmp346_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp347_ = _tmp346_;
			_tmp348_ = cfield;
			_tmp349_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp347_, (ValaCCodeExpression*) _tmp348_, (ValaCCodeExpression*) _tmp349_);
			_tmp350_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp351_ = _tmp350_;
			vala_ccode_function_add_break (_tmp351_);
			_vala_ccode_node_unref0 (cgetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp352_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp353_ = _tmp352_;
	vala_ccode_function_add_default (_tmp353_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp354_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp355_ = _tmp354_;
	vala_ccode_function_add_break (_tmp355_);
	_tmp356_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp357_ = _tmp356_;
	vala_ccode_function_close (_tmp357_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp358_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp359_ = set_prop;
	vala_ccode_file_add_function_declaration (_tmp358_, _tmp359_);
	_tmp360_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp361_ = set_prop;
	vala_ccode_file_add_function (_tmp360_, _tmp361_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (set_prop);
}

static void
vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self)
{
	ValaCCodeFunctionCall* cwarn = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cwarn = _tmp3_;
	_tmp4_ = vala_ccode_identifier_new ("object");
	_tmp5_ = _tmp4_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp5_);
	_vala_ccode_node_unref0 (_tmp5_);
	_tmp6_ = vala_ccode_identifier_new ("property_id");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_identifier_new ("pspec");
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_expression (_tmp11_, (ValaCCodeExpression*) cwarn);
	_vala_ccode_node_unref0 (cwarn);
}

static void
vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                            ValaConstructor* c)
{
	ValaGObjectModule * self;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaClass* _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaMemberBinding _tmp6_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
	cl = _tmp4_;
	_tmp5_ = vala_constructor_get_binding (c);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaClass* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaCCodeBaseModuleEmitContext* _tmp11_;
		ValaCCodeBaseModuleEmitContext* _tmp12_;
		ValaCCodeFunction* function = NULL;
		ValaClass* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeFunction* _tmp18_;
		ValaCCodeFunction* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeParameter* _tmp22_;
		ValaCCodeParameter* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeParameter* _tmp25_;
		ValaCCodeParameter* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeParameter* _tmp28_;
		ValaCCodeParameter* _tmp29_;
		ValaCCodeFile* _tmp30_;
		ValaCCodeFunction* _tmp31_;
		ValaCCodeFunction* _tmp32_;
		ValaCCodeFunction* _tmp33_;
		ValaCCodeFunction* _tmp34_;
		ValaCCodeVariableDeclarator* _tmp35_;
		ValaCCodeVariableDeclarator* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeFunction* _tmp38_;
		ValaCCodeVariableDeclarator* _tmp39_;
		ValaCCodeVariableDeclarator* _tmp40_;
		ValaClass* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp199_;
		ValaCCodeIdentifier* _tmp200_;
		ValaCCodeFunctionCall* _tmp201_;
		ValaCCodeFunctionCall* _tmp202_;
		ValaCCodeFunctionCall* _tmp203_;
		ValaClass* _tmp204_;
		gchar* _tmp205_;
		gchar* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		ValaCCodeIdentifier* _tmp209_;
		ValaCCodeIdentifier* _tmp210_;
		ValaCCodeFunction* _tmp211_;
		ValaCCodeFunction* _tmp212_;
		ValaCCodeIdentifier* _tmp213_;
		ValaCCodeIdentifier* _tmp214_;
		ValaCCodeFunctionCall* _tmp215_;
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp216_;
		ValaCCodeIdentifier* _tmp217_;
		ValaCCodeMemberAccess* _tmp218_;
		ValaCCodeMemberAccess* _tmp219_;
		ValaCCodeFunctionCall* _tmp220_;
		ValaCCodeFunctionCall* _tmp221_;
		ValaCCodeFunctionCall* _tmp222_;
		ValaCCodeIdentifier* _tmp223_;
		ValaCCodeIdentifier* _tmp224_;
		ValaCCodeFunctionCall* _tmp225_;
		ValaCCodeIdentifier* _tmp226_;
		ValaCCodeIdentifier* _tmp227_;
		ValaCCodeFunctionCall* _tmp228_;
		ValaCCodeIdentifier* _tmp229_;
		ValaCCodeIdentifier* _tmp230_;
		ValaCCodeFunction* _tmp231_;
		ValaCCodeFunction* _tmp232_;
		ValaCCodeIdentifier* _tmp233_;
		ValaCCodeIdentifier* _tmp234_;
		ValaCCodeFunctionCall* _tmp235_;
		ValaCCodeIdentifier* _tmp236_;
		ValaCCodeIdentifier* _tmp237_;
		ValaClass* _tmp238_;
		ValaCCodeFunctionCall* _tmp239_;
		ValaCCodeFunction* _tmp240_;
		ValaCCodeFunction* _tmp241_;
		ValaClass* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		ValaCCodeVariableDeclarator* _tmp247_;
		ValaCCodeVariableDeclarator* _tmp248_;
		ValaCCodeFunction* _tmp249_;
		ValaCCodeFunction* _tmp250_;
		ValaCCodeIdentifier* _tmp251_;
		ValaCCodeIdentifier* _tmp252_;
		ValaCCodeFunctionCall* _tmp253_;
		ValaBlock* _tmp254_;
		ValaBlock* _tmp255_;
		gboolean _tmp256_;
		gboolean _tmp257_;
		ValaClass* _tmp268_;
		gboolean _tmp269_;
		gboolean _tmp270_;
		ValaCCodeFunction* _tmp324_;
		ValaCCodeFunction* _tmp325_;
		ValaCCodeIdentifier* _tmp326_;
		ValaCCodeIdentifier* _tmp327_;
		ValaCCodeFile* _tmp328_;
		ValaCCodeFunction* _tmp329_;
		_tmp7_ = cl;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp7_, _tmp8_)) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "construct blocks require GLib.Object");
			vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
			_vala_code_node_unref0 (cl);
			return;
		}
		_tmp11_ = vala_ccode_base_module_emit_context_new ((ValaSymbol*) c);
		_tmp12_ = _tmp11_;
		vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp12_);
		_vala_ccode_base_module_emit_context_unref0 (_tmp12_);
		_tmp13_ = cl;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s_constructor", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_function_new (_tmp17_, "GObject *");
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		function = _tmp19_;
		_tmp20_ = function;
		vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp20_, VALA_CCODE_MODIFIERS_STATIC);
		_tmp21_ = function;
		_tmp22_ = vala_ccode_parameter_new ("type", "GType");
		_tmp23_ = _tmp22_;
		vala_ccode_function_add_parameter (_tmp21_, _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = function;
		_tmp25_ = vala_ccode_parameter_new ("n_construct_properties", "guint");
		_tmp26_ = _tmp25_;
		vala_ccode_function_add_parameter (_tmp24_, _tmp26_);
		_vala_ccode_node_unref0 (_tmp26_);
		_tmp27_ = function;
		_tmp28_ = vala_ccode_parameter_new ("construct_properties", "GObjectConstructParam *");
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_parameter (_tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp31_ = function;
		vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
		_tmp32_ = function;
		vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp32_);
		_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_variable_declarator_new ("obj", NULL, NULL);
		_tmp36_ = _tmp35_;
		vala_ccode_function_add_declaration (_tmp34_, "GObject *", (ValaCCodeDeclarator*) _tmp36_, 0);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_ccode_variable_declarator_new ("parent_class", NULL, NULL);
		_tmp40_ = _tmp39_;
		vala_ccode_function_add_declaration (_tmp38_, "GObjectClass *", (ValaCCodeDeclarator*) _tmp40_, 0);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = cl;
		_tmp42_ = vala_class_get_is_singleton (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* singleton_once_name = NULL;
			ValaClass* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaCCodeDeclaration* singleton_ref = NULL;
			ValaCCodeDeclaration* _tmp59_;
			ValaCCodeDeclaration* _tmp60_;
			const gchar* _tmp61_;
			ValaCCodeConstant* _tmp62_;
			ValaCCodeConstant* _tmp63_;
			ValaCCodeVariableDeclarator* _tmp64_;
			ValaCCodeVariableDeclarator* _tmp65_;
			ValaCCodeDeclaration* _tmp66_;
			ValaCCodeFunction* _tmp67_;
			ValaCCodeFunction* _tmp68_;
			ValaCCodeDeclaration* _tmp69_;
			ValaCCodeDeclaration* mutex_lock = NULL;
			ValaCCodeDeclaration* _tmp70_;
			ValaCCodeDeclaration* _tmp71_;
			const gchar* _tmp72_;
			ValaCCodeVariableDeclarator* _tmp73_;
			ValaCCodeVariableDeclarator* _tmp74_;
			ValaCCodeDeclaration* _tmp75_;
			ValaCCodeFunction* _tmp76_;
			ValaCCodeFunction* _tmp77_;
			ValaCCodeDeclaration* _tmp78_;
			ValaCCodeDeclaration* once_lock = NULL;
			ValaCCodeDeclaration* _tmp79_;
			ValaCCodeDeclaration* _tmp80_;
			const gchar* _tmp81_;
			ValaCCodeConstant* _tmp82_;
			ValaCCodeConstant* _tmp83_;
			ValaCCodeVariableDeclarator* _tmp84_;
			ValaCCodeVariableDeclarator* _tmp85_;
			ValaCCodeDeclaration* _tmp86_;
			ValaCCodeFunction* _tmp87_;
			ValaCCodeFunction* _tmp88_;
			ValaCCodeDeclaration* _tmp89_;
			ValaCCodeFunctionCall* once_init = NULL;
			ValaCCodeIdentifier* _tmp90_;
			ValaCCodeIdentifier* _tmp91_;
			ValaCCodeFunctionCall* _tmp92_;
			ValaCCodeFunctionCall* _tmp93_;
			ValaCCodeFunctionCall* _tmp94_;
			const gchar* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeIdentifier* _tmp97_;
			ValaCCodeUnaryExpression* _tmp98_;
			ValaCCodeUnaryExpression* _tmp99_;
			ValaCCodeBlock* once_block = NULL;
			ValaCCodeBlock* _tmp100_;
			ValaCCodeFunctionCall* singleton_mutex_init = NULL;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			const gchar* _tmp106_;
			ValaCCodeIdentifier* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeUnaryExpression* _tmp109_;
			ValaCCodeUnaryExpression* _tmp110_;
			ValaCCodeBlock* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaCCodeExpressionStatement* _tmp113_;
			ValaCCodeExpressionStatement* _tmp114_;
			ValaCCodeFunctionCall* once_leave = NULL;
			ValaCCodeIdentifier* _tmp115_;
			ValaCCodeIdentifier* _tmp116_;
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeFunctionCall* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			const gchar* _tmp120_;
			ValaCCodeIdentifier* _tmp121_;
			ValaCCodeIdentifier* _tmp122_;
			ValaCCodeUnaryExpression* _tmp123_;
			ValaCCodeUnaryExpression* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeBlock* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeExpressionStatement* _tmp130_;
			ValaCCodeExpressionStatement* _tmp131_;
			ValaCCodeIfStatement* if_once = NULL;
			ValaCCodeFunctionCall* _tmp132_;
			ValaCCodeBlock* _tmp133_;
			ValaCCodeIfStatement* _tmp134_;
			ValaCCodeFunction* _tmp135_;
			ValaCCodeFunction* _tmp136_;
			ValaCCodeIfStatement* _tmp137_;
			ValaCCodeFunctionCall* singleton_mutex_lock = NULL;
			ValaCCodeIdentifier* _tmp138_;
			ValaCCodeIdentifier* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaCCodeFunctionCall* _tmp142_;
			const gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeUnaryExpression* _tmp146_;
			ValaCCodeUnaryExpression* _tmp147_;
			ValaCCodeFunction* _tmp148_;
			ValaCCodeFunction* _tmp149_;
			ValaCCodeFunctionCall* _tmp150_;
			ValaCCodeExpressionStatement* _tmp151_;
			ValaCCodeExpressionStatement* _tmp152_;
			ValaCCodeBinaryExpression* check_existance = NULL;
			const gchar* _tmp153_;
			ValaCCodeIdentifier* _tmp154_;
			ValaCCodeIdentifier* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeBinaryExpression* _tmp158_;
			ValaCCodeBinaryExpression* _tmp159_;
			ValaCCodeBlock* return_singleton = NULL;
			ValaCCodeBlock* _tmp160_;
			ValaCCodeFunctionCall* ref_object = NULL;
			ValaCCodeIdentifier* _tmp161_;
			ValaCCodeIdentifier* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeFunctionCall* _tmp164_;
			ValaCCodeFunctionCall* _tmp165_;
			const gchar* _tmp166_;
			ValaCCodeIdentifier* _tmp167_;
			ValaCCodeIdentifier* _tmp168_;
			ValaCCodeBlock* _tmp169_;
			ValaCCodeFunctionCall* _tmp170_;
			ValaCCodeExpressionStatement* _tmp171_;
			ValaCCodeExpressionStatement* _tmp172_;
			ValaCCodeFunctionCall* singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp173_;
			ValaCCodeIdentifier* _tmp174_;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeFunctionCall* _tmp177_;
			const gchar* _tmp178_;
			ValaCCodeIdentifier* _tmp179_;
			ValaCCodeIdentifier* _tmp180_;
			ValaCCodeUnaryExpression* _tmp181_;
			ValaCCodeUnaryExpression* _tmp182_;
			ValaCCodeBlock* _tmp183_;
			ValaCCodeFunctionCall* _tmp184_;
			ValaCCodeExpressionStatement* _tmp185_;
			ValaCCodeExpressionStatement* _tmp186_;
			ValaCCodeBlock* _tmp187_;
			const gchar* _tmp188_;
			ValaCCodeIdentifier* _tmp189_;
			ValaCCodeIdentifier* _tmp190_;
			ValaCCodeReturnStatement* _tmp191_;
			ValaCCodeReturnStatement* _tmp192_;
			ValaCCodeIfStatement* if_singleton_alive = NULL;
			ValaCCodeBinaryExpression* _tmp193_;
			ValaCCodeBlock* _tmp194_;
			ValaCCodeIfStatement* _tmp195_;
			ValaCCodeFunction* _tmp196_;
			ValaCCodeFunction* _tmp197_;
			ValaCCodeIfStatement* _tmp198_;
			_tmp44_ = cl;
			_tmp45_ = vala_get_ccode_name ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf ("%s_singleton__ref", _tmp46_);
			_tmp48_ = _tmp47_;
			_g_free0 (_tmp46_);
			singleton_ref_name = _tmp48_;
			_tmp49_ = cl;
			_tmp50_ = vala_get_ccode_name ((ValaCodeNode*) _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strdup_printf ("%s_singleton__lock", _tmp51_);
			_tmp53_ = _tmp52_;
			_g_free0 (_tmp51_);
			singleton_lock_name = _tmp53_;
			_tmp54_ = cl;
			_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("%s_singleton__volatile", _tmp56_);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp56_);
			singleton_once_name = _tmp58_;
			_tmp59_ = vala_ccode_declaration_new ("GObject *");
			singleton_ref = _tmp59_;
			_tmp60_ = singleton_ref;
			_tmp61_ = singleton_ref_name;
			_tmp62_ = vala_ccode_constant_new ("NULL");
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_ccode_variable_declarator_new (_tmp61_, (ValaCCodeExpression*) _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			vala_ccode_declaration_add_declarator (_tmp60_, (ValaCCodeDeclarator*) _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
			_vala_ccode_node_unref0 (_tmp63_);
			_tmp66_ = singleton_ref;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp66_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = singleton_ref;
			vala_ccode_function_add_statement (_tmp68_, (ValaCCodeNode*) _tmp69_);
			_tmp70_ = vala_ccode_declaration_new ("GMutex");
			mutex_lock = _tmp70_;
			_tmp71_ = mutex_lock;
			_tmp72_ = singleton_lock_name;
			_tmp73_ = vala_ccode_variable_declarator_new (_tmp72_, NULL, NULL);
			_tmp74_ = _tmp73_;
			vala_ccode_declaration_add_declarator (_tmp71_, (ValaCCodeDeclarator*) _tmp74_);
			_vala_ccode_node_unref0 (_tmp74_);
			_tmp75_ = mutex_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp75_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp76_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = mutex_lock;
			vala_ccode_function_add_statement (_tmp77_, (ValaCCodeNode*) _tmp78_);
			_tmp79_ = vala_ccode_declaration_new ("gsize");
			once_lock = _tmp79_;
			_tmp80_ = once_lock;
			_tmp81_ = singleton_once_name;
			_tmp82_ = vala_ccode_constant_new ("0");
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_ccode_variable_declarator_new (_tmp81_, (ValaCCodeExpression*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			vala_ccode_declaration_add_declarator (_tmp80_, (ValaCCodeDeclarator*) _tmp85_);
			_vala_ccode_node_unref0 (_tmp85_);
			_vala_ccode_node_unref0 (_tmp83_);
			_tmp86_ = once_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp86_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
			_tmp87_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = once_lock;
			vala_ccode_function_add_statement (_tmp88_, (ValaCCodeNode*) _tmp89_);
			_tmp90_ = vala_ccode_identifier_new ("g_once_init_enter");
			_tmp91_ = _tmp90_;
			_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp91_);
			_tmp93_ = _tmp92_;
			_vala_ccode_node_unref0 (_tmp91_);
			once_init = _tmp93_;
			_tmp94_ = once_init;
			_tmp95_ = singleton_once_name;
			_tmp96_ = vala_ccode_identifier_new (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp97_);
			_tmp99_ = _tmp98_;
			vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp99_);
			_vala_ccode_node_unref0 (_tmp99_);
			_vala_ccode_node_unref0 (_tmp97_);
			_tmp100_ = vala_ccode_block_new ();
			once_block = _tmp100_;
			_tmp101_ = vala_ccode_identifier_new ("g_mutex_init");
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
			_tmp104_ = _tmp103_;
			_vala_ccode_node_unref0 (_tmp102_);
			singleton_mutex_init = _tmp104_;
			_tmp105_ = singleton_mutex_init;
			_tmp106_ = singleton_lock_name;
			_tmp107_ = vala_ccode_identifier_new (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp108_);
			_tmp110_ = _tmp109_;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp110_);
			_vala_ccode_node_unref0 (_tmp110_);
			_vala_ccode_node_unref0 (_tmp108_);
			_tmp111_ = once_block;
			_tmp112_ = singleton_mutex_init;
			_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp112_);
			_tmp114_ = _tmp113_;
			vala_ccode_block_add_statement (_tmp111_, (ValaCCodeNode*) _tmp114_);
			_vala_ccode_node_unref0 (_tmp114_);
			_tmp115_ = vala_ccode_identifier_new ("g_once_init_leave");
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp116_);
			_tmp118_ = _tmp117_;
			_vala_ccode_node_unref0 (_tmp116_);
			once_leave = _tmp118_;
			_tmp119_ = once_leave;
			_tmp120_ = singleton_once_name;
			_tmp121_ = vala_ccode_identifier_new (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (_tmp124_);
			_vala_ccode_node_unref0 (_tmp122_);
			_tmp125_ = once_leave;
			_tmp126_ = vala_ccode_constant_new ("42");
			_tmp127_ = _tmp126_;
			vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = once_block;
			_tmp129_ = once_leave;
			_tmp130_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp129_);
			_tmp131_ = _tmp130_;
			vala_ccode_block_add_statement (_tmp128_, (ValaCCodeNode*) _tmp131_);
			_vala_ccode_node_unref0 (_tmp131_);
			_tmp132_ = once_init;
			_tmp133_ = once_block;
			_tmp134_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp132_, (ValaCCodeStatement*) _tmp133_, NULL);
			if_once = _tmp134_;
			_tmp135_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = if_once;
			vala_ccode_function_add_statement (_tmp136_, (ValaCCodeNode*) _tmp137_);
			_tmp138_ = vala_ccode_identifier_new ("g_mutex_lock");
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp139_);
			_tmp141_ = _tmp140_;
			_vala_ccode_node_unref0 (_tmp139_);
			singleton_mutex_lock = _tmp141_;
			_tmp142_ = singleton_mutex_lock;
			_tmp143_ = singleton_lock_name;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp145_);
			_tmp147_ = _tmp146_;
			vala_ccode_function_call_add_argument (_tmp142_, (ValaCCodeExpression*) _tmp147_);
			_vala_ccode_node_unref0 (_tmp147_);
			_vala_ccode_node_unref0 (_tmp145_);
			_tmp148_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = singleton_mutex_lock;
			_tmp151_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			vala_ccode_function_add_statement (_tmp149_, (ValaCCodeNode*) _tmp152_);
			_vala_ccode_node_unref0 (_tmp152_);
			_tmp153_ = singleton_ref_name;
			_tmp154_ = vala_ccode_identifier_new (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_ccode_constant_new ("NULL");
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp155_, (ValaCCodeExpression*) _tmp157_);
			_tmp159_ = _tmp158_;
			_vala_ccode_node_unref0 (_tmp157_);
			_vala_ccode_node_unref0 (_tmp155_);
			check_existance = _tmp159_;
			_tmp160_ = vala_ccode_block_new ();
			return_singleton = _tmp160_;
			_tmp161_ = vala_ccode_identifier_new ("g_object_ref");
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp162_);
			_tmp164_ = _tmp163_;
			_vala_ccode_node_unref0 (_tmp162_);
			ref_object = _tmp164_;
			_tmp165_ = ref_object;
			_tmp166_ = singleton_ref_name;
			_tmp167_ = vala_ccode_identifier_new (_tmp166_);
			_tmp168_ = _tmp167_;
			vala_ccode_function_call_add_argument (_tmp165_, (ValaCCodeExpression*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_tmp169_ = return_singleton;
			_tmp170_ = ref_object;
			_tmp171_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp170_);
			_tmp172_ = _tmp171_;
			vala_ccode_block_add_statement (_tmp169_, (ValaCCodeNode*) _tmp172_);
			_vala_ccode_node_unref0 (_tmp172_);
			_tmp173_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp174_);
			_tmp176_ = _tmp175_;
			_vala_ccode_node_unref0 (_tmp174_);
			singleton_mutex_unlock = _tmp176_;
			_tmp177_ = singleton_mutex_unlock;
			_tmp178_ = singleton_lock_name;
			_tmp179_ = vala_ccode_identifier_new (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp180_);
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp183_ = return_singleton;
			_tmp184_ = singleton_mutex_unlock;
			_tmp185_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp184_);
			_tmp186_ = _tmp185_;
			vala_ccode_block_add_statement (_tmp183_, (ValaCCodeNode*) _tmp186_);
			_vala_ccode_node_unref0 (_tmp186_);
			_tmp187_ = return_singleton;
			_tmp188_ = singleton_ref_name;
			_tmp189_ = vala_ccode_identifier_new (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) _tmp190_);
			_tmp192_ = _tmp191_;
			vala_ccode_block_add_statement (_tmp187_, (ValaCCodeNode*) _tmp192_);
			_vala_ccode_node_unref0 (_tmp192_);
			_vala_ccode_node_unref0 (_tmp190_);
			_tmp193_ = check_existance;
			_tmp194_ = return_singleton;
			_tmp195_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp193_, (ValaCCodeStatement*) _tmp194_, NULL);
			if_singleton_alive = _tmp195_;
			_tmp196_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp197_ = _tmp196_;
			_tmp198_ = if_singleton_alive;
			vala_ccode_function_add_statement (_tmp197_, (ValaCCodeNode*) _tmp198_);
			_vala_ccode_node_unref0 (if_singleton_alive);
			_vala_ccode_node_unref0 (singleton_mutex_unlock);
			_vala_ccode_node_unref0 (ref_object);
			_vala_ccode_node_unref0 (return_singleton);
			_vala_ccode_node_unref0 (check_existance);
			_vala_ccode_node_unref0 (singleton_mutex_lock);
			_vala_ccode_node_unref0 (if_once);
			_vala_ccode_node_unref0 (once_leave);
			_vala_ccode_node_unref0 (singleton_mutex_init);
			_vala_ccode_node_unref0 (once_block);
			_vala_ccode_node_unref0 (once_init);
			_vala_ccode_node_unref0 (once_lock);
			_vala_ccode_node_unref0 (mutex_lock);
			_vala_ccode_node_unref0 (singleton_ref);
			_g_free0 (singleton_once_name);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp199_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp200_);
		_tmp202_ = _tmp201_;
		_vala_ccode_node_unref0 (_tmp200_);
		ccast = _tmp202_;
		_tmp203_ = ccast;
		_tmp204_ = cl;
		_tmp205_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp204_, NULL);
		_tmp206_ = _tmp205_;
		_tmp207_ = g_strdup_printf ("%s_parent_class", _tmp206_);
		_tmp208_ = _tmp207_;
		_tmp209_ = vala_ccode_identifier_new (_tmp208_);
		_tmp210_ = _tmp209_;
		vala_ccode_function_call_add_argument (_tmp203_, (ValaCCodeExpression*) _tmp210_);
		_vala_ccode_node_unref0 (_tmp210_);
		_g_free0 (_tmp208_);
		_g_free0 (_tmp206_);
		_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_ccode_identifier_new ("parent_class");
		_tmp214_ = _tmp213_;
		_tmp215_ = ccast;
		vala_ccode_function_add_assignment (_tmp212_, (ValaCCodeExpression*) _tmp214_, (ValaCCodeExpression*) _tmp215_);
		_vala_ccode_node_unref0 (_tmp214_);
		_tmp216_ = vala_ccode_identifier_new ("parent_class");
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp217_, "constructor");
		_tmp219_ = _tmp218_;
		_tmp220_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp219_);
		_tmp221_ = _tmp220_;
		_vala_ccode_node_unref0 (_tmp219_);
		_vala_ccode_node_unref0 (_tmp217_);
		ccall = _tmp221_;
		_tmp222_ = ccall;
		_tmp223_ = vala_ccode_identifier_new ("type");
		_tmp224_ = _tmp223_;
		vala_ccode_function_call_add_argument (_tmp222_, (ValaCCodeExpression*) _tmp224_);
		_vala_ccode_node_unref0 (_tmp224_);
		_tmp225_ = ccall;
		_tmp226_ = vala_ccode_identifier_new ("n_construct_properties");
		_tmp227_ = _tmp226_;
		vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp227_);
		_vala_ccode_node_unref0 (_tmp227_);
		_tmp228_ = ccall;
		_tmp229_ = vala_ccode_identifier_new ("construct_properties");
		_tmp230_ = _tmp229_;
		vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp230_);
		_vala_ccode_node_unref0 (_tmp230_);
		_tmp231_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp232_ = _tmp231_;
		_tmp233_ = vala_ccode_identifier_new ("obj");
		_tmp234_ = _tmp233_;
		_tmp235_ = ccall;
		vala_ccode_function_add_assignment (_tmp232_, (ValaCCodeExpression*) _tmp234_, (ValaCCodeExpression*) _tmp235_);
		_vala_ccode_node_unref0 (_tmp234_);
		_tmp236_ = vala_ccode_identifier_new ("obj");
		_tmp237_ = _tmp236_;
		_tmp238_ = cl;
		_tmp239_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp237_, (ValaTypeSymbol*) _tmp238_);
		_vala_ccode_node_unref0 (ccall);
		ccall = _tmp239_;
		_vala_ccode_node_unref0 (_tmp237_);
		_tmp240_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp241_ = _tmp240_;
		_tmp242_ = cl;
		_tmp243_ = vala_get_ccode_name ((ValaCodeNode*) _tmp242_);
		_tmp244_ = _tmp243_;
		_tmp245_ = g_strdup_printf ("%s *", _tmp244_);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
		_tmp248_ = _tmp247_;
		vala_ccode_function_add_declaration (_tmp241_, _tmp246_, (ValaCCodeDeclarator*) _tmp248_, 0);
		_vala_ccode_node_unref0 (_tmp248_);
		_g_free0 (_tmp246_);
		_g_free0 (_tmp244_);
		_tmp249_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_ccode_identifier_new ("self");
		_tmp252_ = _tmp251_;
		_tmp253_ = ccall;
		vala_ccode_function_add_assignment (_tmp250_, (ValaCCodeExpression*) _tmp252_, (ValaCCodeExpression*) _tmp253_);
		_vala_ccode_node_unref0 (_tmp252_);
		_tmp254_ = vala_subroutine_get_body ((ValaSubroutine*) c);
		_tmp255_ = _tmp254_;
		vala_code_node_emit ((ValaCodeNode*) _tmp255_, (ValaCodeGenerator*) self);
		_tmp256_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
		_tmp257_ = _tmp256_;
		if (_tmp257_) {
			ValaCCodeFunction* _tmp258_;
			ValaCCodeFunction* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			ValaCCodeConstant* _tmp264_;
			ValaCCodeConstant* _tmp265_;
			ValaCCodeVariableDeclarator* _tmp266_;
			ValaCCodeVariableDeclarator* _tmp267_;
			_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_strdup_printf ("_inner_error%d_", _tmp261_);
			_tmp263_ = _tmp262_;
			_tmp264_ = vala_ccode_constant_new ("NULL");
			_tmp265_ = _tmp264_;
			_tmp266_ = vala_ccode_variable_declarator_new_zero (_tmp263_, (ValaCCodeExpression*) _tmp265_, NULL);
			_tmp267_ = _tmp266_;
			vala_ccode_function_add_declaration (_tmp259_, "GError*", (ValaCCodeDeclarator*) _tmp267_, 0);
			_vala_ccode_node_unref0 (_tmp267_);
			_vala_ccode_node_unref0 (_tmp265_);
			_g_free0 (_tmp263_);
		}
		_tmp268_ = cl;
		_tmp269_ = vala_class_get_is_singleton (_tmp268_);
		_tmp270_ = _tmp269_;
		if (_tmp270_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp271_;
			gchar* _tmp272_;
			gchar* _tmp273_;
			gchar* _tmp274_;
			gchar* _tmp275_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaCCodeFunction* _tmp282_;
			const gchar* _tmp283_;
			ValaCCodeIdentifier* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeIdentifier* _tmp286_;
			ValaCCodeIdentifier* _tmp287_;
			ValaCCodeFunctionCall* set_weak_ref_to_volatile = NULL;
			ValaCCodeIdentifier* _tmp288_;
			ValaCCodeIdentifier* _tmp289_;
			ValaCCodeFunctionCall* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			ValaCCodeFunctionCall* _tmp292_;
			const gchar* _tmp293_;
			ValaCCodeIdentifier* _tmp294_;
			ValaCCodeIdentifier* _tmp295_;
			ValaCCodeFunctionCall* _tmp296_;
			const gchar* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeUnaryExpression* _tmp300_;
			ValaCCodeUnaryExpression* _tmp301_;
			ValaCCodeCastExpression* _tmp302_;
			ValaCCodeCastExpression* _tmp303_;
			ValaCCodeFunction* _tmp304_;
			ValaCCodeFunction* _tmp305_;
			ValaCCodeFunctionCall* _tmp306_;
			ValaCCodeExpressionStatement* _tmp307_;
			ValaCCodeExpressionStatement* _tmp308_;
			ValaCCodeFunctionCall* final_singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeFunctionCall* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			const gchar* _tmp314_;
			ValaCCodeIdentifier* _tmp315_;
			ValaCCodeIdentifier* _tmp316_;
			ValaCCodeUnaryExpression* _tmp317_;
			ValaCCodeUnaryExpression* _tmp318_;
			ValaCCodeFunction* _tmp319_;
			ValaCCodeFunction* _tmp320_;
			ValaCCodeFunctionCall* _tmp321_;
			ValaCCodeExpressionStatement* _tmp322_;
			ValaCCodeExpressionStatement* _tmp323_;
			_tmp271_ = cl;
			_tmp272_ = vala_get_ccode_name ((ValaCodeNode*) _tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = g_strdup_printf ("%s_singleton__ref", _tmp273_);
			_tmp275_ = _tmp274_;
			_g_free0 (_tmp273_);
			singleton_ref_name = _tmp275_;
			_tmp276_ = cl;
			_tmp277_ = vala_get_ccode_name ((ValaCodeNode*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = g_strdup_printf ("%s_singleton__lock", _tmp278_);
			_tmp280_ = _tmp279_;
			_g_free0 (_tmp278_);
			singleton_lock_name = _tmp280_;
			_tmp281_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp282_ = _tmp281_;
			_tmp283_ = singleton_ref_name;
			_tmp284_ = vala_ccode_identifier_new (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_identifier_new ("obj");
			_tmp287_ = _tmp286_;
			vala_ccode_function_add_assignment (_tmp282_, (ValaCCodeExpression*) _tmp285_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (_tmp287_);
			_vala_ccode_node_unref0 (_tmp285_);
			_tmp288_ = vala_ccode_identifier_new ("g_object_add_weak_pointer");
			_tmp289_ = _tmp288_;
			_tmp290_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp289_);
			_tmp291_ = _tmp290_;
			_vala_ccode_node_unref0 (_tmp289_);
			set_weak_ref_to_volatile = _tmp291_;
			_tmp292_ = set_weak_ref_to_volatile;
			_tmp293_ = singleton_ref_name;
			_tmp294_ = vala_ccode_identifier_new (_tmp293_);
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp292_, (ValaCCodeExpression*) _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
			_tmp296_ = set_weak_ref_to_volatile;
			_tmp297_ = singleton_ref_name;
			_tmp298_ = vala_ccode_identifier_new (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp301_, "gpointer");
			_tmp303_ = _tmp302_;
			vala_ccode_function_call_add_argument (_tmp296_, (ValaCCodeExpression*) _tmp303_);
			_vala_ccode_node_unref0 (_tmp303_);
			_vala_ccode_node_unref0 (_tmp301_);
			_vala_ccode_node_unref0 (_tmp299_);
			_tmp304_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp305_ = _tmp304_;
			_tmp306_ = set_weak_ref_to_volatile;
			_tmp307_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp306_);
			_tmp308_ = _tmp307_;
			vala_ccode_function_add_statement (_tmp305_, (ValaCCodeNode*) _tmp308_);
			_vala_ccode_node_unref0 (_tmp308_);
			_tmp309_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp310_);
			_tmp312_ = _tmp311_;
			_vala_ccode_node_unref0 (_tmp310_);
			final_singleton_mutex_unlock = _tmp312_;
			_tmp313_ = final_singleton_mutex_unlock;
			_tmp314_ = singleton_lock_name;
			_tmp315_ = vala_ccode_identifier_new (_tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp316_);
			_tmp318_ = _tmp317_;
			vala_ccode_function_call_add_argument (_tmp313_, (ValaCCodeExpression*) _tmp318_);
			_vala_ccode_node_unref0 (_tmp318_);
			_vala_ccode_node_unref0 (_tmp316_);
			_tmp319_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp320_ = _tmp319_;
			_tmp321_ = final_singleton_mutex_unlock;
			_tmp322_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp321_);
			_tmp323_ = _tmp322_;
			vala_ccode_function_add_statement (_tmp320_, (ValaCCodeNode*) _tmp323_);
			_vala_ccode_node_unref0 (_tmp323_);
			_vala_ccode_node_unref0 (final_singleton_mutex_unlock);
			_vala_ccode_node_unref0 (set_weak_ref_to_volatile);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp324_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_ccode_identifier_new ("obj");
		_tmp327_ = _tmp326_;
		vala_ccode_function_add_return (_tmp325_, (ValaCCodeExpression*) _tmp327_);
		_vala_ccode_node_unref0 (_tmp327_);
		vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
		_tmp328_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp329_ = function;
		vala_ccode_file_add_function (_tmp328_, _tmp329_);
		vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (ccast);
		_vala_ccode_node_unref0 (function);
	} else {
		ValaMemberBinding _tmp330_;
		ValaMemberBinding _tmp331_;
		_tmp330_ = vala_constructor_get_binding (c);
		_tmp331_ = _tmp330_;
		if (_tmp331_ == VALA_MEMBER_BINDING_CLASS) {
			ValaClass* _tmp332_;
			gboolean _tmp333_;
			gboolean _tmp334_;
			ValaCCodeBaseModuleEmitContext* _tmp337_;
			ValaBlock* _tmp338_;
			ValaBlock* _tmp339_;
			gboolean _tmp340_;
			gboolean _tmp341_;
			_tmp332_ = cl;
			_tmp333_ = vala_class_get_is_compact (_tmp332_);
			_tmp334_ = _tmp333_;
			if (_tmp334_) {
				ValaSourceReference* _tmp335_;
				ValaSourceReference* _tmp336_;
				_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp336_ = _tmp335_;
				vala_report_error (_tmp336_, "class constructors are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
				_vala_code_node_unref0 (cl);
				return;
			}
			_tmp337_ = ((ValaCCodeBaseModule*) self)->base_init_context;
			vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp337_);
			_tmp338_ = vala_subroutine_get_body ((ValaSubroutine*) c);
			_tmp339_ = _tmp338_;
			vala_code_node_emit ((ValaCodeNode*) _tmp339_, (ValaCodeGenerator*) self);
			_tmp340_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
			_tmp341_ = _tmp340_;
			if (_tmp341_) {
				ValaCCodeFunction* _tmp342_;
				ValaCCodeFunction* _tmp343_;
				gint _tmp344_;
				gint _tmp345_;
				gchar* _tmp346_;
				gchar* _tmp347_;
				ValaCCodeConstant* _tmp348_;
				ValaCCodeConstant* _tmp349_;
				ValaCCodeVariableDeclarator* _tmp350_;
				ValaCCodeVariableDeclarator* _tmp351_;
				_tmp342_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
				_tmp345_ = _tmp344_;
				_tmp346_ = g_strdup_printf ("_inner_error%d_", _tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_ccode_constant_new ("NULL");
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_ccode_variable_declarator_new_zero (_tmp347_, (ValaCCodeExpression*) _tmp349_, NULL);
				_tmp351_ = _tmp350_;
				vala_ccode_function_add_declaration (_tmp343_, "GError*", (ValaCCodeDeclarator*) _tmp351_, 0);
				_vala_ccode_node_unref0 (_tmp351_);
				_vala_ccode_node_unref0 (_tmp349_);
				_g_free0 (_tmp347_);
			}
			vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		} else {
			ValaMemberBinding _tmp352_;
			ValaMemberBinding _tmp353_;
			_tmp352_ = vala_constructor_get_binding (c);
			_tmp353_ = _tmp352_;
			if (_tmp353_ == VALA_MEMBER_BINDING_STATIC) {
				ValaClass* _tmp354_;
				gboolean _tmp355_;
				gboolean _tmp356_;
				ValaCCodeBaseModuleEmitContext* _tmp359_;
				ValaBlock* _tmp360_;
				ValaBlock* _tmp361_;
				gboolean _tmp362_;
				gboolean _tmp363_;
				_tmp354_ = cl;
				_tmp355_ = vala_class_get_is_compact (_tmp354_);
				_tmp356_ = _tmp355_;
				if (_tmp356_) {
					ValaSourceReference* _tmp357_;
					ValaSourceReference* _tmp358_;
					_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
					_tmp358_ = _tmp357_;
					vala_report_error (_tmp358_, "static constructors are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
					_vala_code_node_unref0 (cl);
					return;
				}
				_tmp359_ = ((ValaCCodeBaseModule*) self)->class_init_context;
				vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp359_);
				_tmp360_ = vala_subroutine_get_body ((ValaSubroutine*) c);
				_tmp361_ = _tmp360_;
				vala_code_node_emit ((ValaCodeNode*) _tmp361_, (ValaCodeGenerator*) self);
				_tmp362_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
				_tmp363_ = _tmp362_;
				if (_tmp363_) {
					ValaCCodeFunction* _tmp364_;
					ValaCCodeFunction* _tmp365_;
					gint _tmp366_;
					gint _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					ValaCCodeConstant* _tmp370_;
					ValaCCodeConstant* _tmp371_;
					ValaCCodeVariableDeclarator* _tmp372_;
					ValaCCodeVariableDeclarator* _tmp373_;
					_tmp364_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
					_tmp367_ = _tmp366_;
					_tmp368_ = g_strdup_printf ("_inner_error%d_", _tmp367_);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_ccode_constant_new ("NULL");
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_ccode_variable_declarator_new_zero (_tmp369_, (ValaCCodeExpression*) _tmp371_, NULL);
					_tmp373_ = _tmp372_;
					vala_ccode_function_add_declaration (_tmp365_, "GError*", (ValaCCodeDeclarator*) _tmp373_, 0);
					_vala_ccode_node_unref0 (_tmp373_);
					_vala_ccode_node_unref0 (_tmp371_);
					_g_free0 (_tmp369_);
				}
				vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
			} else {
				ValaSourceReference* _tmp374_;
				ValaSourceReference* _tmp375_;
				_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp375_ = _tmp374_;
				vala_report_error (_tmp375_, "internal error: constructors must have instance, class, or static bind" \
"ing");
			}
		}
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (cl);
}

static gchar*
vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* getter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeModifiers _tmp24_;
	ValaCCodeModifiers _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeParameter* _tmp31_;
	ValaCCodeParameter* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeVariableDeclarator* _tmp41_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeUnaryExpression* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeFile* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeFile* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_get_%s%d", _tmp12_, _tmp13_);
	getter_cname = _tmp14_;
	_tmp15_ = getter_cname;
	_tmp16_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_function_new (_tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	func = _tmp21_;
	_tmp22_ = func;
	_tmp23_ = func;
	_tmp24_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp23_, _tmp25_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp26_ = func;
	_tmp27_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_parameter_new ("obj", _tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp33_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_declaration (_tmp35_, _tmp39_, (ValaCCodeDeclarator*) _tmp41_, 0);
	_vala_ccode_node_unref0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp42_ = vala_ccode_identifier_new ("g_object_get");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	call = _tmp45_;
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("obj");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = call;
	_tmp53_ = vala_ccode_identifier_new ("result");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp57_ = call;
	_tmp58_ = vala_ccode_constant_new ("NULL");
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (_tmp57_, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = call;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) _tmp62_);
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_identifier_new ("result");
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_return (_tmp64_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp67_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp68_ = func;
	vala_ccode_file_add_function_declaration (_tmp67_, _tmp68_);
	_tmp69_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp70_ = func;
	vala_ccode_file_add_function (_tmp69_, _tmp70_);
	result = getter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* setter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeFunction* _tmp18_;
	ValaCCodeModifiers _tmp19_;
	ValaCCodeModifiers _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaCCodeParameter* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeParameter* _tmp33_;
	ValaCCodeParameter* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeFile* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_set_%s%d", _tmp12_, _tmp13_);
	setter_cname = _tmp14_;
	_tmp15_ = setter_cname;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "void");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = func;
	_tmp19_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp18_, _tmp20_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp21_ = func;
	_tmp22_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_get_ccode_name ((ValaCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_parameter_new ("obj", _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_add_parameter (_tmp21_, _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = func;
	_tmp29_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_parameter_new ("value", _tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_parameter (_tmp28_, _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp35_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp36_ = vala_ccode_identifier_new ("g_object_set");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_ccode_node_unref0 (_tmp37_);
	call = _tmp39_;
	_tmp40_ = call;
	_tmp41_ = vala_ccode_identifier_new ("obj");
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = call;
	_tmp44_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("value");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = call;
	vala_ccode_function_add_expression (_tmp53_, (ValaCCodeExpression*) _tmp54_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = func;
	vala_ccode_file_add_function_declaration (_tmp55_, _tmp56_);
	_tmp57_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp58_ = func;
	vala_ccode_file_add_function (_tmp57_, _tmp58_);
	result = setter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                   ValaDynamicSignal* node)
{
	ValaGObjectModule * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) node);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->signal_wrapper_id;
	self->priv->signal_wrapper_id = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf ("dynamic_%s%d_", _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                  ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, FALSE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                        ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect_after", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, TRUE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static void
vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                      ValaDynamicSignal* sig,
                                                      gboolean after)
{
	ValaMethod* m = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* _tmp4_;
	gchar* connect_func = NULL;
	gchar* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	ValaCCodeFunctionCall* call = NULL;
	const gchar* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMemberBinding _tmp29_;
	ValaMemberBinding _tmp30_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_dynamic_signal_get_handler (sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp5_ = g_strdup ("g_signal_connect_object");
	connect_func = _tmp5_;
	_tmp6_ = m;
	_tmp7_ = vala_method_get_binding (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("g_signal_connect");
			_g_free0 (connect_func);
			connect_func = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("g_signal_connect_after");
			_g_free0 (connect_func);
			connect_func = _tmp10_;
		}
	}
	_tmp11_ = connect_func;
	_tmp12_ = vala_ccode_identifier_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	call = _tmp15_;
	_tmp16_ = call;
	_tmp17_ = vala_ccode_identifier_new ("obj");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = call;
	_tmp20_ = vala_ccode_identifier_new ("signal_name");
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, (ValaCCodeExpression*) _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = call;
	_tmp23_ = vala_ccode_identifier_new ("handler");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = call;
	_tmp26_ = vala_ccode_identifier_new ("data");
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = m;
	_tmp29_ = vala_method_get_binding (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeConstant* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			_tmp31_ = call;
			_tmp32_ = vala_ccode_constant_new ("0");
			_tmp33_ = _tmp32_;
			vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
		} else {
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeConstant* _tmp35_;
			ValaCCodeConstant* _tmp36_;
			_tmp34_ = call;
			_tmp35_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp36_ = _tmp35_;
			vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
		}
	}
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = call;
	vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (connect_func);
	_vala_code_node_unref0 (m);
}

static void
vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                         ValaProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaSemanticAnalyzer* _tmp3_;
	ValaSemanticAnalyzer* _tmp4_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (prop != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
	_tmp1_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_analyzer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (vala_semantic_analyzer_is_gobject_property (_tmp4_, prop)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValaCCodeEnumValue* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		_tmp7_ = ((ValaCCodeBaseModule*) self)->prop_enum;
		_tmp8_ = vala_get_ccode_upper_case_name ((ValaSymbol*) prop, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s_PROPERTY", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_enum_value_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_ccode_enum_add_value (_tmp7_, _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
}

static void
vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGObjectModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaMemberAccess* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp3_);
		_tmp4_ = vala_method_call_get_call (expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
		ma = _tmp6_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaMemberAccess* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			_tmp12_ = ma;
			_tmp13_ = vala_member_access_get_inner (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			_tmp8_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_SYMBOL, ValaSymbol);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			ValaMemberAccess* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = ma;
			_tmp22_ = vala_member_access_get_member_name (_tmp21_);
			_tmp23_ = _tmp22_;
			if (g_strcmp0 (_tmp23_, "new") == 0) {
				_tmp20_ = TRUE;
			} else {
				ValaMemberAccess* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = ma;
				_tmp25_ = vala_member_access_get_member_name (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = g_strcmp0 (_tmp26_, "newv") == 0;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp19_ = g_strcmp0 (_tmp29_, "new_valist") == 0;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				ValaMemberAccess* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = ma;
				_tmp31_ = vala_member_access_get_member_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp18_ = g_strcmp0 (_tmp32_, "new_with_properties") == 0;
			}
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaCCodeFunctionCall* initiallyunowned_ccall = NULL;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeExpression* _tmp38_;
			ValaCCodeExpression* _tmp39_;
			ValaCCodeFunctionCall* sink_ref_ccall = NULL;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeFunctionCall* _tmp44_;
			ValaCCodeExpression* _tmp45_;
			ValaCCodeExpression* _tmp46_;
			ValaCCodeConditionalExpression* cexpr = NULL;
			ValaCCodeFunctionCall* _tmp47_;
			ValaCCodeFunctionCall* _tmp48_;
			ValaCCodeExpression* _tmp49_;
			ValaCCodeExpression* _tmp50_;
			ValaCCodeConditionalExpression* _tmp51_;
			ValaCCodeConditionalExpression* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaCCodeConditionalExpression* _tmp55_;
			ValaGLibValue* _tmp56_;
			ValaGLibValue* _tmp57_;
			ValaTargetValue* _tmp58_;
			ValaTargetValue* _tmp59_;
			VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
			_tmp33_ = vala_ccode_identifier_new ("G_IS_INITIALLY_UNOWNED");
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			initiallyunowned_ccall = _tmp36_;
			_tmp37_ = initiallyunowned_ccall;
			_tmp38_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp39_ = _tmp38_;
			vala_ccode_function_call_add_argument (_tmp37_, _tmp39_);
			_vala_ccode_node_unref0 (_tmp39_);
			_tmp40_ = vala_ccode_identifier_new ("g_object_ref_sink");
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp41_);
			_tmp43_ = _tmp42_;
			_vala_ccode_node_unref0 (_tmp41_);
			sink_ref_ccall = _tmp43_;
			_tmp44_ = sink_ref_ccall;
			_tmp45_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp46_ = _tmp45_;
			vala_ccode_function_call_add_argument (_tmp44_, _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_tmp47_ = initiallyunowned_ccall;
			_tmp48_ = sink_ref_ccall;
			_tmp49_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_, _tmp50_);
			_tmp52_ = _tmp51_;
			_vala_ccode_node_unref0 (_tmp50_);
			cexpr = _tmp52_;
			_tmp53_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp54_ = _tmp53_;
			_tmp55_ = cexpr;
			_tmp56_ = vala_glib_value_new (_tmp54_, (ValaCCodeExpression*) _tmp55_, FALSE);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp57_, (ValaCodeNode*) expr, NULL);
			_tmp59_ = _tmp58_;
			vala_expression_set_target_value ((ValaExpression*) expr, _tmp59_);
			_vala_target_value_unref0 (_tmp59_);
			_vala_target_value_unref0 (_tmp57_);
			_vala_ccode_node_unref0 (cexpr);
			_vala_ccode_node_unref0 (sink_ref_ccall);
			_vala_ccode_node_unref0 (initiallyunowned_ccall);
			_vala_code_node_unref0 (ma);
			return;
		} else {
			ValaMemberAccess* _tmp60_;
			ValaSymbol* _tmp61_;
			ValaSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			_tmp60_ = ma;
			_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			if (_tmp62_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				{
					ValaList* _arg_list = NULL;
					ValaList* _tmp64_;
					ValaList* _tmp65_;
					gint _arg_size = 0;
					ValaList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gint _arg_index = 0;
					_tmp64_ = vala_method_call_get_argument_list (expr);
					_tmp65_ = _vala_iterable_ref0 (_tmp64_);
					_arg_list = _tmp65_;
					_tmp66_ = _arg_list;
					_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_arg_size = _tmp68_;
					_arg_index = -1;
					while (TRUE) {
						ValaExpression* arg = NULL;
						ValaList* _tmp69_;
						gpointer _tmp70_;
						ValaNamedArgument* named_argument = NULL;
						ValaExpression* _tmp71_;
						ValaNamedArgument* _tmp72_;
						ValaNamedArgument* _tmp73_;
						ValaProperty* prop = NULL;
						ValaClass* _tmp77_;
						ValaClass* _tmp78_;
						ValaNamedArgument* _tmp79_;
						const gchar* _tmp80_;
						const gchar* _tmp81_;
						ValaSymbol* _tmp82_;
						ValaProperty* _tmp83_;
						ValaProperty* _tmp84_;
						ValaCodeContext* _tmp97_;
						ValaCodeContext* _tmp98_;
						ValaSemanticAnalyzer* _tmp99_;
						ValaSemanticAnalyzer* _tmp100_;
						ValaProperty* _tmp101_;
						ValaExpression* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaProperty* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						_arg_index = _arg_index + 1;
						if (!(_arg_index < _arg_size)) {
							break;
						}
						_tmp69_ = _arg_list;
						_tmp70_ = vala_list_get (_tmp69_, _arg_index);
						arg = (ValaExpression*) _tmp70_;
						_tmp71_ = arg;
						_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_NAMED_ARGUMENT) ? ((ValaNamedArgument*) _tmp71_) : NULL);
						named_argument = _tmp72_;
						_tmp73_ = named_argument;
						if (_tmp73_ == NULL) {
							ValaExpression* _tmp74_;
							ValaSourceReference* _tmp75_;
							ValaSourceReference* _tmp76_;
							_tmp74_ = arg;
							_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp74_);
							_tmp76_ = _tmp75_;
							vala_report_error (_tmp76_, "Named argument expected");
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp77_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp78_ = _tmp77_;
						_tmp79_ = named_argument;
						_tmp80_ = vala_named_argument_get_name (_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp78_, _tmp81_);
						_tmp83_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp82_) : NULL;
						if (_tmp83_ == NULL) {
							_vala_code_node_unref0 (_tmp82_);
						}
						prop = _tmp83_;
						_tmp84_ = prop;
						if (_tmp84_ == NULL) {
							ValaExpression* _tmp85_;
							ValaSourceReference* _tmp86_;
							ValaSourceReference* _tmp87_;
							ValaNamedArgument* _tmp88_;
							const gchar* _tmp89_;
							const gchar* _tmp90_;
							ValaClass* _tmp91_;
							ValaClass* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							_tmp85_ = arg;
							_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = named_argument;
							_tmp89_ = vala_named_argument_get_name (_tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp92_ = _tmp91_;
							_tmp93_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp92_);
							_tmp94_ = _tmp93_;
							_tmp95_ = g_strdup_printf ("Property `%s' not found in `%s'", _tmp90_, _tmp94_);
							_tmp96_ = _tmp95_;
							vala_report_error (_tmp87_, _tmp96_);
							_g_free0 (_tmp96_);
							_g_free0 (_tmp94_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp97_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
						_tmp98_ = _tmp97_;
						_tmp99_ = vala_code_context_get_analyzer (_tmp98_);
						_tmp100_ = _tmp99_;
						_tmp101_ = prop;
						if (!vala_semantic_analyzer_is_gobject_property (_tmp100_, _tmp101_)) {
							ValaExpression* _tmp102_;
							ValaSourceReference* _tmp103_;
							ValaSourceReference* _tmp104_;
							ValaNamedArgument* _tmp105_;
							const gchar* _tmp106_;
							const gchar* _tmp107_;
							gchar* _tmp108_;
							gchar* _tmp109_;
							_tmp102_ = arg;
							_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp102_);
							_tmp104_ = _tmp103_;
							_tmp105_ = named_argument;
							_tmp106_ = vala_named_argument_get_name (_tmp105_);
							_tmp107_ = _tmp106_;
							_tmp108_ = g_strdup_printf ("Property `%s' not supported in Object (property: value) constructor ch" \
"ain up", _tmp107_);
							_tmp109_ = _tmp108_;
							vala_report_error (_tmp104_, _tmp109_);
							_g_free0 (_tmp109_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp110_ = arg;
						_tmp111_ = vala_expression_get_value_type (_tmp110_);
						_tmp112_ = _tmp111_;
						_tmp113_ = prop;
						_tmp114_ = vala_property_get_property_type (_tmp113_);
						_tmp115_ = _tmp114_;
						if (!vala_data_type_compatible (_tmp112_, _tmp115_)) {
							ValaExpression* _tmp116_;
							ValaSourceReference* _tmp117_;
							ValaSourceReference* _tmp118_;
							ValaExpression* _tmp119_;
							ValaDataType* _tmp120_;
							ValaDataType* _tmp121_;
							gchar* _tmp122_;
							gchar* _tmp123_;
							ValaProperty* _tmp124_;
							ValaDataType* _tmp125_;
							ValaDataType* _tmp126_;
							gchar* _tmp127_;
							gchar* _tmp128_;
							gchar* _tmp129_;
							gchar* _tmp130_;
							_tmp116_ = arg;
							_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp116_);
							_tmp118_ = _tmp117_;
							_tmp119_ = arg;
							_tmp120_ = vala_expression_get_value_type (_tmp119_);
							_tmp121_ = _tmp120_;
							_tmp122_ = vala_code_node_to_string ((ValaCodeNode*) _tmp121_);
							_tmp123_ = _tmp122_;
							_tmp124_ = prop;
							_tmp125_ = vala_property_get_property_type (_tmp124_);
							_tmp126_ = _tmp125_;
							_tmp127_ = vala_code_node_to_string ((ValaCodeNode*) _tmp126_);
							_tmp128_ = _tmp127_;
							_tmp129_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp123_, _tmp128_);
							_tmp130_ = _tmp129_;
							vala_report_error (_tmp118_, _tmp130_);
							_g_free0 (_tmp130_);
							_g_free0 (_tmp128_);
							_g_free0 (_tmp123_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (named_argument);
						_vala_code_node_unref0 (arg);
					}
					_vala_iterable_unref0 (_arg_list);
				}
			}
		}
		vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
		_vala_code_node_unref0 (ma);
	}
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
}

ValaGObjectModule*
vala_gobject_module_construct (GType object_type)
{
	ValaGObjectModule* self = NULL;
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type);
	return self;
}

ValaGObjectModule*
vala_gobject_module_new (void)
{
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE);
}

static void
vala_gobject_module_class_init (ValaGObjectModuleClass * klass,
                                gpointer klass_data)
{
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gobject_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGObjectModule_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gobject_module_real_visit_class;
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gobject_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor*, ValaConstructor*)) vala_gobject_module_real_visit_constructor;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_getter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_getter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_setter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_setter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_after_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gobject_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gobject_module_real_visit_method_call;
}

static void
vala_gobject_module_instance_init (ValaGObjectModule * self,
                                   gpointer klass)
{
	self->priv = vala_gobject_module_get_instance_private (self);
}

static void
vala_gobject_module_finalize (ValaCodeVisitor * obj)
{
	ValaGObjectModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}

static GType
vala_gobject_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
	GType vala_gobject_module_type_id;
	vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
	ValaGObjectModule_private_offset = g_type_add_instance_private (vala_gobject_module_type_id, sizeof (ValaGObjectModulePrivate));
	return vala_gobject_module_type_id;
}

GType
vala_gobject_module_get_type (void)
{
	static volatile gsize vala_gobject_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gobject_module_type_id__volatile)) {
		GType vala_gobject_module_type_id;
		vala_gobject_module_type_id = vala_gobject_module_get_type_once ();
		g_once_init_leave (&vala_gobject_module_type_id__volatile, vala_gobject_module_type_id);
	}
	return vala_gobject_module_type_id__volatile;
}

