// Generated by gmmproc 2.61.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/surface.h>
#include <gdkmm/private/surface_p.h>


/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdk/gdk.h>
#include <gdkmm/cairoutils.h>
#include <gdkmm/contentprovider.h>
#include <gdkmm/cursor.h>
#include <gdkmm/device.h>
#include <gdkmm/types.h>
#include <gdkmm/cairocontext.h>
#include <gdkmm/glcontext.h>
#include <gdkmm/drawcontext.h>
#include <gdkmm/frameclock.h>
#include <gdkmm/monitor.h>

using Type = Gdk::Surface::Type;
using State = Gdk::Surface::State;
using TypeHint = Gdk::Surface::TypeHint;
using CairoRegion = cairo_region_t;

namespace Gdk
{

void Surface::set_cursor()
{
  gdk_surface_set_cursor(gobj(), nullptr);
}

void Surface::unset_icon()
{
  gdk_surface_set_icon_name(gobj(), nullptr); /* See GDK docs */
}

void Surface::restack(bool above)
{
  gdk_surface_restack(gobj(), nullptr, above);
}

} // namespace Gdk

namespace
{


static void Surface_signal_moved_to_rect_callback(GdkSurface* self, gpointer p0,gpointer p1,gboolean p2,gboolean p3,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<void(const Gdk::Rectangle&, const Gdk::Rectangle&, bool, bool)>;

  auto obj = dynamic_cast<Surface*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap((GdkRectangle*)p0)
, Glib::wrap((GdkRectangle*)p1)
, p2
, p3
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Surface_signal_moved_to_rect_info =
{
  "moved-to-rect",
  (GCallback) &Surface_signal_moved_to_rect_callback,
  (GCallback) &Surface_signal_moved_to_rect_callback
};


static void Surface_signal_size_changed_callback(GdkSurface* self, gint p0,gint p1,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<void(int, int)>;

  auto obj = dynamic_cast<Surface*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, p1
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Surface_signal_size_changed_info =
{
  "size-changed",
  (GCallback) &Surface_signal_size_changed_callback,
  (GCallback) &Surface_signal_size_changed_callback
};


static gboolean Surface_signal_render_callback(GdkSurface* self, CairoRegion* p0,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<bool(const ::Cairo::RefPtr<const ::Cairo::Region>&)>;

  auto obj = dynamic_cast<Surface*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::Cairo::wrap(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Surface_signal_render_notify_callback(GdkSurface* self, CairoRegion* p0, void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<void(const ::Cairo::RefPtr<const ::Cairo::Region>&)>;

  auto obj = dynamic_cast<Surface*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::Cairo::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Surface_signal_render_info =
{
  "render",
  (GCallback) &Surface_signal_render_callback,
  (GCallback) &Surface_signal_render_notify_callback
};


static gboolean Surface_signal_event_callback(GdkSurface* self, GdkEvent* p0,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<bool(const Glib::RefPtr<const Event>&)>;

  auto obj = dynamic_cast<Surface*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Surface_signal_event_notify_callback(GdkSurface* self, GdkEvent* p0, void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<const Event>&)>;

  auto obj = dynamic_cast<Surface*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Surface_signal_event_info =
{
  "event",
  (GCallback) &Surface_signal_event_callback,
  (GCallback) &Surface_signal_event_notify_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gdk::WMDecoration>::value_type()
{
  return gdk_wm_decoration_get_type();
}

// static
GType Glib::Value<Gdk::WMFunction>::value_type()
{
  return gdk_wm_function_get_type();
}

// static
GType Glib::Value<Gdk::SurfaceEdge>::value_type()
{
  return gdk_surface_edge_get_type();
}

// static
GType Glib::Value<Gdk::Gravity>::value_type()
{
  return gdk_gravity_get_type();
}

// static
GType Glib::Value<Gdk::AnchorHints>::value_type()
{
  return gdk_anchor_hints_get_type();
}

// static
GType Glib::Value<Gdk::FullscreenMode>::value_type()
{
  return gdk_fullscreen_mode_get_type();
}

// static
GType Glib::Value<Gdk::Surface::Type>::value_type()
{
  return gdk_surface_type_get_type();
}

// static
GType Glib::Value<Gdk::Surface::State>::value_type()
{
  return gdk_surface_state_get_type();
}

// static
GType Glib::Value<Gdk::Surface::Hints>::value_type()
{
  return gdk_surface_hints_get_type();
}

// static
GType Glib::Value<Gdk::Surface::TypeHint>::value_type()
{
  return gdk_surface_type_hint_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Surface> wrap(GdkSurface* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gdk::Surface>( dynamic_cast<Gdk::Surface*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Surface_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Surface_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_surface_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Surface_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Surface_Class::wrap_new(GObject* object)
{
  return new Surface((GdkSurface*)object);
}


/* The implementation: */

GdkSurface* Surface::gobj_copy()
{
  reference();
  return gobj();
}

Surface::Surface(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Surface::Surface(GdkSurface* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Surface::Surface(Surface&& src) noexcept
: Glib::Object(std::move(src))
{}

Surface& Surface::operator=(Surface&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


Surface::~Surface() noexcept
{}


Surface::CppClassType Surface::surface_class_; // initialize static member

GType Surface::get_type()
{
  return surface_class_.init().get_type();
}


GType Surface::get_base_type()
{
  return gdk_surface_get_type();
}


Glib::RefPtr<Surface> Surface::create_toplevel(const Glib::RefPtr<Display>& display, int width, int height)
{
  return Glib::wrap(gdk_surface_new_toplevel(Glib::unwrap(display), width, height));
}

Glib::RefPtr<Surface> Surface::create_popup(const Glib::RefPtr<Display>& display, const Rectangle& position)
{
  return Glib::wrap(gdk_surface_new_popup(Glib::unwrap(display), (position).gobj()));
}

Glib::RefPtr<Surface> Surface::create_child(const Glib::RefPtr<Surface>& parent, const Rectangle& position)
{
  return Glib::wrap(gdk_surface_new_child(Glib::unwrap(parent), (position).gobj()));
}

Type Surface::get_surface_type() const
{
  return static_cast<Type>(gdk_surface_get_surface_type(const_cast<GdkSurface*>(gobj())));
}

Glib::RefPtr<Display> Surface::get_display()
{
  auto retvalue = Glib::wrap(gdk_surface_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Display> Surface::get_display() const
{
  return const_cast<Surface*>(this)->get_display();
}

void Surface::show()
{
  gdk_surface_show(gobj());
}

void Surface::hide()
{
  gdk_surface_hide(gobj());
}

void Surface::show_unraised()
{
  gdk_surface_show_unraised(gobj());
}

void Surface::move(int x, int y)
{
  gdk_surface_move(gobj(), x, y);
}

void Surface::resize(int width, int height)
{
  gdk_surface_resize(gobj(), width, height);
}

void Surface::move_resize(int x, int y, int width, int height)
{
  gdk_surface_move_resize(gobj(), x, y, width, height);
}

void Surface::move_to_rect(const Rectangle& rect, Gravity rect_anchor, Gravity surface_anchor, AnchorHints anchor_hints, int rect_anchor_dx, int rect_anchor_dy)
{
  gdk_surface_move_to_rect(gobj(), (rect).gobj(), static_cast<GdkGravity>(rect_anchor), static_cast<GdkGravity>(surface_anchor), static_cast<GdkAnchorHints>(anchor_hints), rect_anchor_dx, rect_anchor_dy);
}

void Surface::raise()
{
  gdk_surface_raise(gobj());
}

void Surface::lower()
{
  gdk_surface_lower(gobj());
}

void Surface::restack(const Glib::RefPtr<Surface>& sibling, bool above)
{
  gdk_surface_restack(gobj(), Glib::unwrap(sibling), static_cast<int>(above));
}

void Surface::focus(guint32 timestamp)
{
  gdk_surface_focus(gobj(), timestamp);
}

void Surface::input_shape_combine_region(const ::Cairo::RefPtr< ::Cairo::Region>& shape_region, int offset_x, int offset_y)
{
  gdk_surface_input_shape_combine_region(gobj(), ((shape_region) ? (shape_region)->cobj() : nullptr), offset_x, offset_y);
}

void Surface::set_child_input_shapes()
{
  gdk_surface_set_child_input_shapes(gobj());
}

void Surface::merge_child_input_shapes()
{
  gdk_surface_merge_child_input_shapes(gobj());
}

void Surface::set_pass_through(bool pass_through)
{
  gdk_surface_set_pass_through(gobj(), static_cast<int>(pass_through));
}

bool Surface::get_pass_through() const
{
  return gdk_surface_get_pass_through(const_cast<GdkSurface*>(gobj()));
}

bool Surface::is_visible() const
{
  return gdk_surface_is_visible(const_cast<GdkSurface*>(gobj()));
}

bool Surface::is_viewable() const
{
  return gdk_surface_is_viewable(const_cast<GdkSurface*>(gobj()));
}

bool Surface::is_input_only() const
{
  return gdk_surface_is_input_only(const_cast<GdkSurface*>(gobj()));
}

State Surface::get_state() const
{
  return static_cast<State>(gdk_surface_get_state(const_cast<GdkSurface*>(gobj())));
}

bool Surface::has_native() const
{
  return gdk_surface_has_native(const_cast<GdkSurface*>(gobj()));
}

void Surface::set_type_hint(TypeHint hint)
{
  gdk_surface_set_type_hint(gobj(), static_cast<GdkSurfaceTypeHint>(hint));
}

TypeHint Surface::get_type_hint()
{
  return static_cast<TypeHint>(gdk_surface_get_type_hint(gobj()));
}

bool Surface::get_modal_hint() const
{
  return gdk_surface_get_modal_hint(const_cast<GdkSurface*>(gobj()));
}

void Surface::set_modal_hint(bool modal)
{
  gdk_surface_set_modal_hint(gobj(), static_cast<int>(modal));
}

void Surface::set_geometry_hints(const Geometry& geometry, Hints geom_mask)
{
  gdk_surface_set_geometry_hints(gobj(), &(geometry), static_cast<GdkSurfaceHints>(geom_mask));
}

void Surface::set_title(const Glib::ustring& title)
{
  gdk_surface_set_title(gobj(), title.c_str());
}

void Surface::set_startup_id(const Glib::ustring& startup_id)
{
  gdk_surface_set_startup_id(gobj(), startup_id.c_str());
}

void Surface::set_transient_for(const Glib::RefPtr<Surface>& parent)
{
  gdk_surface_set_transient_for(gobj(), Glib::unwrap(parent));
}

void Surface::set_cursor(const Glib::RefPtr<Cursor>& cursor)
{
  gdk_surface_set_cursor(gobj(), Glib::unwrap(cursor));
}

void Surface::set_device_cursor(const Glib::RefPtr<Device>& device, const Glib::RefPtr<Cursor>& cursor)
{
  gdk_surface_set_device_cursor(gobj(), Glib::unwrap(device), Glib::unwrap(cursor));
}

Glib::RefPtr<Cursor> Surface::get_device_cursor(const Glib::RefPtr<Device>& device)
{
  auto retvalue = Glib::wrap(gdk_surface_get_device_cursor(gobj(), Glib::unwrap(device)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Cursor> Surface::get_device_cursor(const Glib::RefPtr<const Device>& device) const
{
  auto retvalue = Glib::wrap(gdk_surface_get_device_cursor(const_cast<GdkSurface*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Cursor> Surface::get_cursor()
{
  auto retvalue = Glib::wrap(gdk_surface_get_cursor(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Cursor> Surface::get_cursor() const
{
  return const_cast<Surface*>(this)->get_cursor();
}

void Surface::get_geometry(int& x, int& y, int& width, int& height) const
{
  gdk_surface_get_geometry(const_cast<GdkSurface*>(gobj()), &(x), &(y), &(width), &(height));
}

int Surface::get_width() const
{
  return gdk_surface_get_width(const_cast<GdkSurface*>(gobj()));
}

int Surface::get_height() const
{
  return gdk_surface_get_height(const_cast<GdkSurface*>(gobj()));
}

void Surface::get_position(int& x, int& y) const
{
  gdk_surface_get_position(const_cast<GdkSurface*>(gobj()), &(x), &(y));
}

int Surface::get_origin(int& x, int& y) const
{
  return gdk_surface_get_origin(const_cast<GdkSurface*>(gobj()), &(x), &(y));
}

void Surface::get_root_coords(int x, int y, int& root_x, int& root_y)
{
  gdk_surface_get_root_coords(gobj(), x, y, &(root_x), &(root_y));
}

void Surface::coords_to_parent(double x, double y, double& parent_x, double& parent_y)
{
  gdk_surface_coords_to_parent(gobj(), x, y, &(parent_x), &(parent_y));
}

void Surface::coords_from_parent(double parent_x, double parent_y, double& x, double& y)
{
  gdk_surface_coords_from_parent(gobj(), parent_x, parent_y, &(x), &(y));
}

void Surface::get_root_origin(int& x, int& y) const
{
  gdk_surface_get_root_origin(const_cast<GdkSurface*>(gobj()), &(x), &(y));
}

void Surface::get_frame_extents(Rectangle& rect) const
{
  gdk_surface_get_frame_extents(const_cast<GdkSurface*>(gobj()), (rect).gobj());
}

int Surface::get_scale_factor() const
{
  return gdk_surface_get_scale_factor(const_cast<GdkSurface*>(gobj()));
}

Glib::RefPtr<Surface> Surface::get_parent()
{
  auto retvalue = Glib::wrap(gdk_surface_get_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Surface> Surface::get_parent() const
{
  return const_cast<Surface*>(this)->get_parent();
}

Glib::RefPtr<Surface> Surface::get_toplevel()
{
  auto retvalue = Glib::wrap(gdk_surface_get_toplevel(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Surface> Surface::get_toplevel() const
{
  return const_cast<Surface*>(this)->get_toplevel();
}

Glib::RefPtr<Surface> Surface::get_device_position(const Glib::RefPtr<const Device>& device, double& x, double& y, ModifierType& mask) const
{
  auto retvalue = Glib::wrap(gdk_surface_get_device_position(const_cast<GdkSurface*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)), &(x), &(y), ((GdkModifierType*) &(mask))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::vector< Glib::RefPtr<Surface> > Surface::get_children()
{
  return Glib::ListHandler<Glib::RefPtr<Surface> >::list_to_vector(gdk_surface_get_children(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector< Glib::RefPtr<const Surface> > Surface::get_children() const
{
  return Glib::ListHandler<Glib::RefPtr<const Surface> >::list_to_vector(gdk_surface_get_children(const_cast<GdkSurface*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Surface::set_icon_list(const std::vector<Glib::RefPtr<Texture>>& textures)
{
  gdk_surface_set_icon_list(gobj(), Glib::ListHandler<Glib::RefPtr<Texture>>::vector_to_list(textures).data());
}

void Surface::set_icon_name(const Glib::ustring& name)
{
  gdk_surface_set_icon_name(gobj(), name.c_str());
}

void Surface::set_decorations(WMDecoration decorations)
{
  gdk_surface_set_decorations(gobj(), static_cast<GdkWMDecoration>(decorations));
}

bool Surface::get_decorations(WMDecoration& decorations) const
{
  return gdk_surface_get_decorations(const_cast<GdkSurface*>(gobj()), ((GdkWMDecoration*) &(decorations)));
}

void Surface::set_functions(WMFunction functions)
{
  gdk_surface_set_functions(gobj(), static_cast<GdkWMFunction>(functions));
}

::Cairo::RefPtr< ::Cairo::Surface> Surface::create_similar_surface(::Cairo::Content content, int width, int height)
{
  return Gdk::Cairo::wrap(gdk_surface_create_similar_surface(gobj(), (cairo_content_t)(content), width, height));
}

void Surface::beep()
{
  gdk_surface_beep(gobj());
}

void Surface::iconify()
{
  gdk_surface_iconify(gobj());
}

void Surface::deiconify()
{
  gdk_surface_deiconify(gobj());
}

void Surface::stick()
{
  gdk_surface_stick(gobj());
}

void Surface::unstick()
{
  gdk_surface_unstick(gobj());
}

void Surface::maximize()
{
  gdk_surface_maximize(gobj());
}

void Surface::unmaximize()
{
  gdk_surface_unmaximize(gobj());
}

void Surface::register_dnd()
{
  gdk_surface_register_dnd(gobj());
}

void Surface::begin_resize_drag(SurfaceEdge edge, int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_surface_begin_resize_drag(gobj(), static_cast<GdkSurfaceEdge>(edge), button, root_x, root_y, timestamp);
}

void Surface::resize_drag(SurfaceEdge edge, const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_surface_begin_resize_drag_for_device(gobj(), static_cast<GdkSurfaceEdge>(edge), Glib::unwrap(device), button, root_x, root_y, timestamp);
}

void Surface::begin_move_drag(int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_surface_begin_move_drag(gobj(), button, root_x, root_y, timestamp);
}

void Surface::begin_move_drag(const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_surface_begin_move_drag_for_device(gobj(), Glib::unwrap(device), button, root_x, root_y, timestamp);
}

Glib::RefPtr<Drag> Surface::drag_begin_from_point(const Glib::RefPtr<Device>& device, const Glib::RefPtr<ContentProvider>& content, DragAction actions, int dx, int dy)
{
  return Glib::wrap(gdk_drag_begin(gobj(), Glib::unwrap(device), Glib::unwrap(content), static_cast<GdkDragAction>(actions), dx, dy));
}

void Surface::queue_expose()
{
  gdk_surface_queue_expose(gobj());
}

void Surface::freeze_updates()
{
  gdk_surface_freeze_updates(gobj());
}

void Surface::thaw_updates()
{
  gdk_surface_thaw_updates(gobj());
}

void Surface::constrain_size(const Geometry& geometry, Hints flags, int width, int height, int& new_width, int& new_height)
{
  gdk_surface_constrain_size(const_cast<GdkGeometry*>(&(geometry)), static_cast<GdkSurfaceHints>(flags), width, height, &(new_width), &(new_height));
}

void Surface::fullscreen()
{
  gdk_surface_fullscreen(gobj());
}

void Surface::fullscreen_on_monitor(const Glib::RefPtr<Monitor>& monitor)
{
  gdk_surface_fullscreen_on_monitor(gobj(), Glib::unwrap(monitor));
}

void Surface::set_fullscreen_mode(FullscreenMode mode)
{
  gdk_surface_set_fullscreen_mode(gobj(), static_cast<GdkFullscreenMode>(mode));
}

FullscreenMode Surface::get_fullscreen_mode() const
{
  return static_cast<FullscreenMode>(gdk_surface_get_fullscreen_mode(const_cast<GdkSurface*>(gobj())));
}

void Surface::unfullscreen()
{
  gdk_surface_unfullscreen(gobj());
}

void Surface::set_keep_above(bool setting)
{
  gdk_surface_set_keep_above(gobj(), static_cast<int>(setting));
}

void Surface::set_keep_below(bool setting)
{
  gdk_surface_set_keep_below(gobj(), static_cast<int>(setting));
}

void Surface::set_opacity(double opacity)
{
  gdk_surface_set_opacity(gobj(), opacity);
}

bool Surface::get_accept_focus() const
{
  return gdk_surface_get_accept_focus(const_cast<GdkSurface*>(gobj()));
}

void Surface::set_accept_focus(bool accept_focus)
{
  gdk_surface_set_accept_focus(gobj(), static_cast<int>(accept_focus));
}

bool Surface::get_focus_on_map() const
{
  return gdk_surface_get_focus_on_map(const_cast<GdkSurface*>(gobj()));
}

void Surface::set_focus_on_map(bool focus_on_map)
{
  gdk_surface_set_focus_on_map(gobj(), static_cast<int>(focus_on_map));
}

void Surface::set_support_multidevice(bool support_multidevice)
{
  gdk_surface_set_support_multidevice(gobj(), static_cast<int>(support_multidevice));
}

bool Surface::get_support_multidevice()
{
  return gdk_surface_get_support_multidevice(gobj());
}

Glib::RefPtr<FrameClock> Surface::get_frame_clock()
{
  auto retvalue = Glib::wrap(gdk_surface_get_frame_clock(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const FrameClock> Surface::get_frame_clock() const
{
  return const_cast<Surface*>(this)->get_frame_clock();
}

void Surface::set_opaque_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gdk_surface_set_opaque_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

void Surface::set_shadow_width(int left, int right, int top, int bottom)
{
  gdk_surface_set_shadow_width(gobj(), left, right, top, bottom);
}

bool Surface::show_window_menu(const Glib::RefPtr<const Event>& event)
{
  return gdk_surface_show_window_menu(gobj(), const_cast<GdkEvent*>(Glib::unwrap(event)));
}

Glib::RefPtr<Gdk::GLContext> Surface::create_gl_context()
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(gdk_surface_create_gl_context(gobj(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Gdk::CairoContext> Surface::create_cairo_context()
{
  return Glib::wrap(gdk_surface_create_cairo_context(gobj()));
}


Glib::SignalProxy<void(const Gdk::Rectangle&, const Gdk::Rectangle&, bool, bool)> Surface::signal_moved_to_rect()
{
  return Glib::SignalProxy<void(const Gdk::Rectangle&, const Gdk::Rectangle&, bool, bool) >(this, &Surface_signal_moved_to_rect_info);
}


Glib::SignalProxy<void(int, int)> Surface::signal_size_changed()
{
  return Glib::SignalProxy<void(int, int) >(this, &Surface_signal_size_changed_info);
}


Glib::SignalProxy<bool(const ::Cairo::RefPtr<const ::Cairo::Region>&)> Surface::signal_render()
{
  return Glib::SignalProxy<bool(const ::Cairo::RefPtr<const ::Cairo::Region>&) >(this, &Surface_signal_render_info);
}


Glib::SignalProxy<bool(const Glib::RefPtr<const Event>&)> Surface::signal_event()
{
  return Glib::SignalProxy<bool(const Glib::RefPtr<const Event>&) >(this, &Surface_signal_event_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Cursor>>::value,
  "Type Glib::RefPtr<Cursor> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Cursor> > Surface::property_cursor() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Cursor> >(this, "cursor");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Cursor> > Surface::property_cursor() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Cursor> >(this, "cursor");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Display>>::value,
  "Type Glib::RefPtr<Display> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > Surface::property_display() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> >(this, "display");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<FrameClock>>::value,
  "Type Glib::RefPtr<FrameClock> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FrameClock> > Surface::property_frame_clock() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FrameClock> >(this, "frame-clock");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<State>::value,
  "Type State cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< State > Surface::property_state() const
{
  return Glib::PropertyProxy_ReadOnly< State >(this, "state");
}

Glib::PropertyProxy_ReadOnly< bool > Surface::property_mapped() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "mapped");
}


} // namespace Gdk


