/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp596_ = FALSE;
	gboolean _tmp597_ = FALSE;
	gboolean _tmp598_ = FALSE;
	ValaExpression* _tmp599_;
	ValaExpression* _tmp600_;
	ValaSymbol* _tmp626_;
	ValaSymbol* _tmp627_;
	ValaSymbol* _tmp656_;
	ValaSymbol* _tmp657_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp696_;
	ValaSymbol* _tmp697_;
	ValaSymbol* _tmp698_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp699_;
	ValaSymbol* _tmp700_;
	ValaSymbol* _tmp1122_;
	ValaSymbol* _tmp1123_;
	ValaVersionAttribute* _tmp1124_;
	ValaVersionAttribute* _tmp1125_;
	ValaSourceReference* _tmp1126_;
	ValaSourceReference* _tmp1127_;
	gboolean _tmp1128_ = FALSE;
	ValaSymbolAccessibility _tmp1129_;
	gboolean _tmp1188_ = FALSE;
	gboolean _tmp1219_ = FALSE;
	gboolean _tmp1220_ = FALSE;
	ValaDataType* _tmp1500_;
	ValaDataType* _tmp1501_;
	gboolean _tmp1504_;
	gboolean _tmp1505_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (VALA_IS_PROPERTY (_tmp54_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp67_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp77_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (VALA_IS_METHOD (_tmp87_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = VALA_IS_TYPESYMBOL (_tmp108_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp147_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaUsingDirective* _tmp167_;
						gboolean _tmp168_;
						gboolean _tmp169_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaScope* _tmp173_;
						ValaScope* _tmp174_;
						const gchar* _tmp175_;
						ValaSymbol* _tmp176_;
						ValaSymbol* _tmp177_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_code_node_get_error ((ValaCodeNode*) _tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp169_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp170_ = ns;
						_tmp171_ = vala_using_directive_get_namespace_symbol (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = vala_symbol_get_scope (_tmp172_);
						_tmp174_ = _tmp173_;
						_tmp175_ = self->priv->_member_name;
						_tmp176_ = vala_scope_lookup (_tmp174_, _tmp175_);
						local_sym = _tmp176_;
						_tmp177_ = local_sym;
						if (_tmp177_ != NULL) {
							gboolean _tmp178_ = FALSE;
							ValaSymbol* _tmp179_;
							ValaSymbol* _tmp180_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp196_;
							ValaSymbol* _tmp197_;
							ValaSymbol* _tmp198_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp218_;
							ValaExpression* _tmp219_;
							ValaExpression* _tmp220_;
							ValaSymbol* _tmp221_;
							_tmp179_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp180_ = _tmp179_;
							if (_tmp180_ != NULL) {
								ValaSymbol* _tmp181_;
								ValaSymbol* _tmp182_;
								ValaSymbol* _tmp183_;
								_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = local_sym;
								_tmp178_ = _tmp182_ != _tmp183_;
							} else {
								_tmp178_ = FALSE;
							}
							if (_tmp178_) {
								ValaSourceReference* _tmp184_;
								ValaSourceReference* _tmp185_;
								const gchar* _tmp186_;
								ValaSymbol* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								ValaSymbol* _tmp191_;
								gchar* _tmp192_;
								gchar* _tmp193_;
								gchar* _tmp194_;
								gchar* _tmp195_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = self->priv->_member_name;
								_tmp187_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp188_ = _tmp187_;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = local_sym;
								_tmp192_ = vala_symbol_get_full_name (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp186_, _tmp190_, _tmp193_);
								_tmp195_ = _tmp194_;
								vala_report_error (_tmp185_, _tmp195_);
								_g_free0 (_tmp195_);
								_g_free0 (_tmp193_);
								_g_free0 (_tmp190_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp196_ = local_sym;
							_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
							_tmp198_ = _tmp197_;
							inner_sym = _tmp198_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp199_ = FALSE;
								ValaSymbol* _tmp200_;
								ValaMemberAccess* _tmp204_;
								ValaSymbol* _tmp205_;
								const gchar* _tmp206_;
								const gchar* _tmp207_;
								ValaSourceReference* _tmp208_;
								ValaSourceReference* _tmp209_;
								ValaMemberAccess* _tmp210_;
								ValaMemberAccess* _tmp211_;
								ValaMemberAccess* _tmp212_;
								ValaExpression* _tmp213_;
								ValaExpression* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								ValaSymbol* _tmp217_;
								_tmp200_ = inner_sym;
								if (_tmp200_ != NULL) {
									ValaSymbol* _tmp201_;
									const gchar* _tmp202_;
									const gchar* _tmp203_;
									_tmp201_ = inner_sym;
									_tmp202_ = vala_symbol_get_name (_tmp201_);
									_tmp203_ = _tmp202_;
									_tmp199_ = _tmp203_ != NULL;
								} else {
									_tmp199_ = FALSE;
								}
								if (!_tmp199_) {
									break;
								}
								_tmp204_ = inner_ma;
								_tmp205_ = inner_sym;
								_tmp206_ = vala_symbol_get_name (_tmp205_);
								_tmp207_ = _tmp206_;
								_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp209_ = _tmp208_;
								_tmp210_ = vala_member_access_new (NULL, _tmp207_, _tmp209_);
								_tmp211_ = _tmp210_;
								vala_member_access_set_inner (_tmp204_, (ValaExpression*) _tmp211_);
								_vala_code_node_unref0 (_tmp211_);
								_tmp212_ = inner_ma;
								_tmp213_ = vala_member_access_get_inner (_tmp212_);
								_tmp214_ = _tmp213_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp214_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp215_ = inner_sym;
								_tmp216_ = vala_symbol_get_parent_symbol (_tmp215_);
								_tmp217_ = _tmp216_;
								inner_sym = _tmp217_;
							}
							_tmp218_ = inner_ma;
							vala_member_access_set_qualified (_tmp218_, TRUE);
							_tmp219_ = vala_member_access_get_inner (self);
							_tmp220_ = _tmp219_;
							vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
							_tmp221_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp221_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp222_;
			ValaExpression* _tmp223_;
			gboolean _tmp224_;
			gboolean _tmp225_;
			ValaExpression* _tmp226_;
			ValaExpression* _tmp227_;
			ValaDataType* _tmp228_;
			ValaDataType* _tmp229_;
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp265_ = FALSE;
			ValaExpression* _tmp266_;
			ValaExpression* _tmp267_;
			gboolean _tmp289_ = FALSE;
			ValaSymbol* _tmp290_;
			ValaSymbol* _tmp291_;
			gboolean _tmp326_ = FALSE;
			gboolean _tmp327_ = FALSE;
			ValaSymbol* _tmp328_;
			ValaSymbol* _tmp329_;
			gboolean _tmp567_ = FALSE;
			ValaSymbol* _tmp568_;
			ValaSymbol* _tmp569_;
			_tmp222_ = vala_member_access_get_inner (self);
			_tmp223_ = _tmp222_;
			_tmp224_ = vala_code_node_get_error ((ValaCodeNode*) _tmp223_);
			_tmp225_ = _tmp224_;
			if (_tmp225_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp226_ = vala_member_access_get_inner (self);
			_tmp227_ = _tmp226_;
			_tmp228_ = vala_expression_get_value_type (_tmp227_);
			_tmp229_ = _tmp228_;
			if (VALA_IS_POINTER_TYPE (_tmp229_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp230_;
				ValaExpression* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				ValaPointerType* _tmp234_;
				gboolean _tmp235_ = FALSE;
				ValaPointerType* _tmp236_;
				_tmp230_ = vala_member_access_get_inner (self);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_expression_get_value_type (_tmp231_);
				_tmp233_ = _tmp232_;
				_tmp234_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp233_) ? ((ValaPointerType*) _tmp233_) : NULL);
				pointer_type = _tmp234_;
				_tmp236_ = pointer_type;
				if (_tmp236_ != NULL) {
					ValaPointerType* _tmp237_;
					ValaDataType* _tmp238_;
					ValaDataType* _tmp239_;
					_tmp237_ = pointer_type;
					_tmp238_ = vala_pointer_type_get_base_type (_tmp237_);
					_tmp239_ = _tmp238_;
					_tmp235_ = VALA_IS_VALUE_TYPE (_tmp239_);
				} else {
					_tmp235_ = FALSE;
				}
				if (_tmp235_) {
					ValaExpression* _tmp240_;
					ValaExpression* _tmp241_;
					ValaSourceReference* _tmp242_;
					ValaSourceReference* _tmp243_;
					ValaPointerIndirection* _tmp244_;
					ValaPointerIndirection* _tmp245_;
					ValaExpression* _tmp246_;
					ValaExpression* _tmp247_;
					_tmp240_ = vala_member_access_get_inner (self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_pointer_indirection_new (_tmp241_, _tmp243_);
					_tmp245_ = _tmp244_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp245_);
					_vala_code_node_unref0 (_tmp245_);
					_tmp246_ = vala_member_access_get_inner (self);
					_tmp247_ = _tmp246_;
					vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			if (VALA_IS_MEMBER_ACCESS (_tmp249_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaMemberAccess* _tmp252_;
				ValaMemberAccess* _tmp253_;
				gboolean _tmp254_;
				_tmp250_ = vala_member_access_get_inner (self);
				_tmp251_ = _tmp250_;
				_tmp252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp251_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp252_;
				_tmp253_ = ma;
				_tmp254_ = _tmp253_->priv->_prototype_access;
				if (_tmp254_) {
					ValaSourceReference* _tmp255_;
					ValaSourceReference* _tmp256_;
					ValaExpression* _tmp257_;
					ValaExpression* _tmp258_;
					ValaSymbol* _tmp259_;
					ValaSymbol* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_member_access_get_inner (self);
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_expression_get_symbol_reference (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = vala_symbol_get_full_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp262_);
					_tmp264_ = _tmp263_;
					vala_report_error (_tmp256_, _tmp264_);
					_g_free0 (_tmp264_);
					_g_free0 (_tmp262_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp266_ = vala_member_access_get_inner (self);
			_tmp267_ = _tmp266_;
			if (VALA_IS_MEMBER_ACCESS (_tmp267_)) {
				_tmp265_ = TRUE;
			} else {
				ValaExpression* _tmp268_;
				ValaExpression* _tmp269_;
				_tmp268_ = vala_member_access_get_inner (self);
				_tmp269_ = _tmp268_;
				_tmp265_ = VALA_IS_BASE_ACCESS (_tmp269_);
			}
			if (_tmp265_) {
				ValaExpression* _tmp270_;
				ValaExpression* _tmp271_;
				ValaSymbol* _tmp272_;
				ValaSymbol* _tmp273_;
				ValaSymbol* _tmp274_;
				gboolean _tmp275_ = FALSE;
				ValaSymbol* _tmp276_;
				ValaSymbol* _tmp277_;
				_tmp270_ = vala_member_access_get_inner (self);
				_tmp271_ = _tmp270_;
				_tmp272_ = vala_expression_get_symbol_reference (_tmp271_);
				_tmp273_ = _tmp272_;
				_tmp274_ = _vala_code_node_ref0 (_tmp273_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp274_;
				_tmp276_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp277_ = _tmp276_;
				if (_tmp277_ == NULL) {
					gboolean _tmp278_ = FALSE;
					ValaSymbol* _tmp279_;
					_tmp279_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp279_)) {
						_tmp278_ = TRUE;
					} else {
						ValaSymbol* _tmp280_;
						_tmp280_ = base_symbol;
						_tmp278_ = VALA_IS_TYPESYMBOL (_tmp280_);
					}
					_tmp275_ = _tmp278_;
				} else {
					_tmp275_ = FALSE;
				}
				if (_tmp275_) {
					ValaSymbol* _tmp281_;
					ValaScope* _tmp282_;
					ValaScope* _tmp283_;
					const gchar* _tmp284_;
					ValaSymbol* _tmp285_;
					ValaSymbol* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp281_ = base_symbol;
					_tmp282_ = vala_symbol_get_scope (_tmp281_);
					_tmp283_ = _tmp282_;
					_tmp284_ = self->priv->_member_name;
					_tmp285_ = vala_scope_lookup (_tmp283_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					if (VALA_IS_BASE_ACCESS (_tmp288_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp290_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp291_ = _tmp290_;
			if (_tmp291_ == NULL) {
				ValaExpression* _tmp292_;
				ValaExpression* _tmp293_;
				ValaDataType* _tmp294_;
				ValaDataType* _tmp295_;
				_tmp292_ = vala_member_access_get_inner (self);
				_tmp293_ = _tmp292_;
				_tmp294_ = vala_expression_get_value_type (_tmp293_);
				_tmp295_ = _tmp294_;
				_tmp289_ = _tmp295_ != NULL;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				gboolean _tmp296_;
				ValaSymbol* _tmp324_;
				ValaSymbol* _tmp325_;
				_tmp296_ = self->priv->_pointer_member_access;
				if (_tmp296_) {
					ValaExpression* _tmp297_;
					ValaExpression* _tmp298_;
					ValaDataType* _tmp299_;
					ValaDataType* _tmp300_;
					const gchar* _tmp301_;
					ValaSymbol* _tmp302_;
					ValaSymbol* _tmp303_;
					_tmp297_ = vala_member_access_get_inner (self);
					_tmp298_ = _tmp297_;
					_tmp299_ = vala_expression_get_value_type (_tmp298_);
					_tmp300_ = _tmp299_;
					_tmp301_ = self->priv->_member_name;
					_tmp302_ = vala_data_type_get_pointer_member (_tmp300_, _tmp301_);
					_tmp303_ = _tmp302_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp303_);
					_vala_code_node_unref0 (_tmp303_);
				} else {
					ValaExpression* _tmp304_;
					ValaExpression* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					ValaTypeSymbol* _tmp308_;
					ValaTypeSymbol* _tmp309_;
					ValaExpression* _tmp317_;
					ValaExpression* _tmp318_;
					ValaDataType* _tmp319_;
					ValaDataType* _tmp320_;
					const gchar* _tmp321_;
					ValaSymbol* _tmp322_;
					ValaSymbol* _tmp323_;
					_tmp304_ = vala_member_access_get_inner (self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_expression_get_value_type (_tmp305_);
					_tmp307_ = _tmp306_;
					_tmp308_ = vala_data_type_get_data_type (_tmp307_);
					_tmp309_ = _tmp308_;
					if (_tmp309_ != NULL) {
						ValaExpression* _tmp310_;
						ValaExpression* _tmp311_;
						ValaDataType* _tmp312_;
						ValaDataType* _tmp313_;
						ValaTypeSymbol* _tmp314_;
						ValaTypeSymbol* _tmp315_;
						ValaSymbol* _tmp316_;
						_tmp310_ = vala_member_access_get_inner (self);
						_tmp311_ = _tmp310_;
						_tmp312_ = vala_expression_get_value_type (_tmp311_);
						_tmp313_ = _tmp312_;
						_tmp314_ = vala_data_type_get_data_type (_tmp313_);
						_tmp315_ = _tmp314_;
						_tmp316_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp315_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp316_;
					}
					_tmp317_ = vala_member_access_get_inner (self);
					_tmp318_ = _tmp317_;
					_tmp319_ = vala_expression_get_value_type (_tmp318_);
					_tmp320_ = _tmp319_;
					_tmp321_ = self->priv->_member_name;
					_tmp322_ = vala_data_type_get_member (_tmp320_, _tmp321_);
					_tmp323_ = _tmp322_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp323_);
					_vala_code_node_unref0 (_tmp323_);
				}
				_tmp324_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp325_ = _tmp324_;
				if (_tmp325_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp328_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp329_ = _tmp328_;
			if (_tmp329_ == NULL) {
				ValaExpression* _tmp330_;
				ValaExpression* _tmp331_;
				ValaDataType* _tmp332_;
				ValaDataType* _tmp333_;
				_tmp330_ = vala_member_access_get_inner (self);
				_tmp331_ = _tmp330_;
				_tmp332_ = vala_expression_get_value_type (_tmp331_);
				_tmp333_ = _tmp332_;
				_tmp327_ = _tmp333_ != NULL;
			} else {
				_tmp327_ = FALSE;
			}
			if (_tmp327_) {
				ValaExpression* _tmp334_;
				ValaExpression* _tmp335_;
				ValaDataType* _tmp336_;
				ValaDataType* _tmp337_;
				gboolean _tmp338_;
				gboolean _tmp339_;
				_tmp334_ = vala_member_access_get_inner (self);
				_tmp335_ = _tmp334_;
				_tmp336_ = vala_expression_get_value_type (_tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = vala_data_type_get_is_dynamic (_tmp337_);
				_tmp339_ = _tmp338_;
				_tmp326_ = _tmp339_;
			} else {
				_tmp326_ = FALSE;
			}
			if (_tmp326_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaDataType* _tmp342_;
				ValaDataType* _tmp343_;
				ValaObjectType* _tmp344_;
				ValaCodeNode* _tmp345_;
				ValaCodeNode* _tmp346_;
				ValaSymbol* _tmp515_;
				ValaSymbol* _tmp516_;
				ValaSymbol* _tmp565_;
				ValaSymbol* _tmp566_;
				_tmp340_ = vala_member_access_get_inner (self);
				_tmp341_ = _tmp340_;
				_tmp342_ = vala_expression_get_value_type (_tmp341_);
				_tmp343_ = _tmp342_;
				_tmp344_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp343_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp344_;
				_tmp345_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp346_ = _tmp345_;
				if (VALA_IS_METHOD_CALL (_tmp346_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp347_;
					ValaCodeNode* _tmp348_;
					ValaMethodCall* _tmp349_;
					ValaMethodCall* _tmp350_;
					ValaExpression* _tmp351_;
					ValaExpression* _tmp352_;
					_tmp347_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp348_ = _tmp347_;
					_tmp349_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp349_;
					_tmp350_ = invoc;
					_tmp351_ = vala_method_call_get_call (_tmp350_);
					_tmp352_ = _tmp351_;
					if (_tmp352_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp353_;
						ValaDataType* _tmp354_;
						ValaDataType* _tmp355_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp370_;
						ValaExpression* _tmp371_;
						ValaDataType* _tmp372_;
						ValaDataType* _tmp373_;
						const gchar* _tmp374_;
						ValaDataType* _tmp375_;
						ValaSourceReference* _tmp376_;
						ValaSourceReference* _tmp377_;
						ValaDynamicMethod* _tmp378_;
						ValaDynamicMethod* _tmp379_;
						ValaMethodCall* _tmp380_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp381_;
						ValaErrorType* _tmp382_;
						ValaDynamicMethod* _tmp383_;
						ValaErrorType* _tmp384_;
						ValaDynamicMethod* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						ValaParameter* _tmp387_;
						ValaParameter* _tmp388_;
						ValaDynamicMethod* _tmp389_;
						ValaObjectType* _tmp390_;
						ValaDataType* _tmp391_;
						ValaDataType* _tmp392_;
						ValaParameter* _tmp393_;
						ValaParameter* _tmp394_;
						ValaObjectType* _tmp395_;
						ValaObjectTypeSymbol* _tmp396_;
						ValaObjectTypeSymbol* _tmp397_;
						ValaScope* _tmp398_;
						ValaScope* _tmp399_;
						ValaDynamicMethod* _tmp400_;
						ValaDynamicMethod* _tmp401_;
						_tmp353_ = invoc;
						_tmp354_ = vala_expression_get_target_type ((ValaExpression*) _tmp353_);
						_tmp355_ = _tmp354_;
						if (_tmp355_ != NULL) {
							ValaMethodCall* _tmp356_;
							ValaDataType* _tmp357_;
							ValaDataType* _tmp358_;
							ValaDataType* _tmp359_;
							ValaDataType* _tmp360_;
							_tmp356_ = invoc;
							_tmp357_ = vala_expression_get_target_type ((ValaExpression*) _tmp356_);
							_tmp358_ = _tmp357_;
							_tmp359_ = vala_data_type_copy (_tmp358_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp359_;
							_tmp360_ = ret_type;
							vala_data_type_set_value_owned (_tmp360_, TRUE);
						} else {
							ValaMethodCall* _tmp361_;
							ValaCodeNode* _tmp362_;
							ValaCodeNode* _tmp363_;
							_tmp361_ = invoc;
							_tmp362_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp361_);
							_tmp363_ = _tmp362_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp363_)) {
								ValaVoidType* _tmp364_;
								_tmp364_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp364_;
							} else {
								ValaExpression* _tmp365_;
								ValaExpression* _tmp366_;
								ValaDataType* _tmp367_;
								ValaDataType* _tmp368_;
								ValaDataType* _tmp369_;
								_tmp365_ = vala_member_access_get_inner (self);
								_tmp366_ = _tmp365_;
								_tmp367_ = vala_expression_get_value_type (_tmp366_);
								_tmp368_ = _tmp367_;
								_tmp369_ = vala_data_type_copy (_tmp368_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp369_;
							}
						}
						_tmp370_ = vala_member_access_get_inner (self);
						_tmp371_ = _tmp370_;
						_tmp372_ = vala_expression_get_value_type (_tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = self->priv->_member_name;
						_tmp375_ = ret_type;
						_tmp376_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_dynamic_method_new (_tmp373_, _tmp374_, _tmp375_, _tmp377_, NULL);
						m = _tmp378_;
						_tmp379_ = m;
						_tmp380_ = invoc;
						vala_dynamic_method_set_invocation (_tmp379_, _tmp380_);
						_tmp381_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp381_;
						_tmp382_ = err;
						vala_error_type_set_dynamic_error (_tmp382_, TRUE);
						_tmp383_ = m;
						_tmp384_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp383_, (ValaDataType*) _tmp384_);
						_tmp385_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp385_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp386_ = m;
						_tmp387_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp388_ = _tmp387_;
						vala_callable_add_parameter ((ValaCallable*) _tmp386_, _tmp388_);
						_vala_code_node_unref0 (_tmp388_);
						_tmp389_ = m;
						_tmp390_ = dynamic_object_type;
						_tmp391_ = vala_data_type_copy ((ValaDataType*) _tmp390_);
						_tmp392_ = _tmp391_;
						_tmp393_ = vala_parameter_new ("this", _tmp392_, NULL);
						_tmp394_ = _tmp393_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp389_, _tmp394_);
						_vala_code_node_unref0 (_tmp394_);
						_vala_code_node_unref0 (_tmp392_);
						_tmp395_ = dynamic_object_type;
						_tmp396_ = vala_object_type_get_type_symbol (_tmp395_);
						_tmp397_ = _tmp396_;
						_tmp398_ = vala_symbol_get_scope ((ValaSymbol*) _tmp397_);
						_tmp399_ = _tmp398_;
						_tmp400_ = m;
						vala_scope_add (_tmp399_, NULL, (ValaSymbol*) _tmp400_);
						_tmp401_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp401_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp402_;
					ValaCodeNode* _tmp403_;
					_tmp402_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp403_ = _tmp402_;
					if (VALA_IS_ASSIGNMENT (_tmp403_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp404_;
						ValaCodeNode* _tmp405_;
						ValaAssignment* _tmp406_;
						ValaAssignment* _tmp407_;
						ValaExpression* _tmp408_;
						ValaExpression* _tmp409_;
						_tmp404_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp405_ = _tmp404_;
						_tmp406_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp405_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp406_;
						_tmp407_ = a;
						_tmp408_ = vala_assignment_get_left (_tmp407_);
						_tmp409_ = _tmp408_;
						if (_tmp409_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp410_;
							ValaExpression* _tmp411_;
							ValaDataType* _tmp412_;
							ValaDataType* _tmp413_;
							const gchar* _tmp414_;
							ValaSourceReference* _tmp415_;
							ValaSourceReference* _tmp416_;
							ValaDynamicProperty* _tmp417_;
							ValaDynamicProperty* _tmp418_;
							ValaDynamicProperty* _tmp419_;
							ValaDynamicProperty* _tmp420_;
							ValaSourceReference* _tmp421_;
							ValaSourceReference* _tmp422_;
							ValaPropertyAccessor* _tmp423_;
							ValaPropertyAccessor* _tmp424_;
							ValaDynamicProperty* _tmp425_;
							ValaExpression* _tmp426_;
							ValaExpression* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							ValaTypeSymbol* _tmp430_;
							ValaTypeSymbol* _tmp431_;
							ValaScope* _tmp432_;
							ValaScope* _tmp433_;
							ValaObjectType* _tmp434_;
							ValaObjectTypeSymbol* _tmp435_;
							ValaObjectTypeSymbol* _tmp436_;
							ValaScope* _tmp437_;
							ValaScope* _tmp438_;
							ValaDynamicProperty* _tmp439_;
							ValaDynamicProperty* _tmp440_;
							_tmp410_ = vala_member_access_get_inner (self);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_expression_get_value_type (_tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = self->priv->_member_name;
							_tmp415_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp416_ = _tmp415_;
							_tmp417_ = vala_dynamic_property_new (_tmp413_, _tmp414_, _tmp416_, NULL);
							prop = _tmp417_;
							_tmp418_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp418_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp419_ = prop;
							_tmp420_ = prop;
							_tmp421_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp420_);
							_tmp422_ = _tmp421_;
							_tmp423_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp422_, NULL);
							_tmp424_ = _tmp423_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp419_, _tmp424_);
							_vala_code_node_unref0 (_tmp424_);
							_tmp425_ = prop;
							_tmp426_ = vala_member_access_get_inner (self);
							_tmp427_ = _tmp426_;
							_tmp428_ = vala_expression_get_value_type (_tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = vala_data_type_get_data_type (_tmp429_);
							_tmp431_ = _tmp430_;
							_tmp432_ = vala_symbol_get_scope ((ValaSymbol*) _tmp431_);
							_tmp433_ = _tmp432_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp425_, _tmp433_);
							_tmp434_ = dynamic_object_type;
							_tmp435_ = vala_object_type_get_type_symbol (_tmp434_);
							_tmp436_ = _tmp435_;
							_tmp437_ = vala_symbol_get_scope ((ValaSymbol*) _tmp436_);
							_tmp438_ = _tmp437_;
							_tmp439_ = prop;
							vala_scope_add (_tmp438_, NULL, (ValaSymbol*) _tmp439_);
							_tmp440_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp440_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp441_ = FALSE;
						gboolean _tmp442_ = FALSE;
						ValaCodeNode* _tmp443_;
						ValaCodeNode* _tmp444_;
						_tmp443_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp444_ = _tmp443_;
						if (VALA_IS_MEMBER_ACCESS (_tmp444_)) {
							ValaExpression* _tmp445_;
							ValaExpression* _tmp446_;
							_tmp445_ = vala_member_access_get_inner (self);
							_tmp446_ = _tmp445_;
							_tmp442_ = VALA_IS_MEMBER_ACCESS (_tmp446_);
						} else {
							_tmp442_ = FALSE;
						}
						if (_tmp442_) {
							ValaCodeNode* _tmp447_;
							ValaCodeNode* _tmp448_;
							ValaCodeNode* _tmp449_;
							ValaCodeNode* _tmp450_;
							_tmp447_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp448_ = _tmp447_;
							_tmp449_ = vala_code_node_get_parent_node (_tmp448_);
							_tmp450_ = _tmp449_;
							_tmp441_ = VALA_IS_METHOD_CALL (_tmp450_);
						} else {
							_tmp441_ = FALSE;
						}
						if (_tmp441_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp451_;
							ValaCodeNode* _tmp452_;
							ValaMemberAccess* _tmp453_;
							gboolean _tmp454_ = FALSE;
							ValaMemberAccess* _tmp455_;
							const gchar* _tmp456_;
							_tmp451_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp452_ = _tmp451_;
							_tmp453_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp452_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp453_;
							_tmp455_ = ma;
							_tmp456_ = _tmp455_->priv->_member_name;
							if (g_strcmp0 (_tmp456_, "connect") == 0) {
								_tmp454_ = TRUE;
							} else {
								ValaMemberAccess* _tmp457_;
								const gchar* _tmp458_;
								_tmp457_ = ma;
								_tmp458_ = _tmp457_->priv->_member_name;
								_tmp454_ = g_strcmp0 (_tmp458_, "connect_after") == 0;
							}
							if (_tmp454_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp459_;
								ValaExpression* _tmp460_;
								ValaDataType* _tmp461_;
								ValaDataType* _tmp462_;
								const gchar* _tmp463_;
								ValaVoidType* _tmp464_;
								ValaVoidType* _tmp465_;
								ValaSourceReference* _tmp466_;
								ValaSourceReference* _tmp467_;
								ValaDynamicSignal* _tmp468_;
								ValaDynamicSignal* _tmp469_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp470_;
								ValaCodeNode* _tmp471_;
								ValaCodeNode* _tmp472_;
								ValaCodeNode* _tmp473_;
								ValaMethodCall* _tmp474_;
								ValaMethodCall* _tmp475_;
								ValaList* _tmp476_;
								ValaList* _tmp477_;
								gint _tmp478_;
								gint _tmp479_;
								gboolean _tmp480_;
								ValaDynamicSignal* _tmp507_;
								ValaObjectType* _tmp508_;
								ValaObjectTypeSymbol* _tmp509_;
								ValaObjectTypeSymbol* _tmp510_;
								ValaScope* _tmp511_;
								ValaScope* _tmp512_;
								ValaDynamicSignal* _tmp513_;
								ValaDynamicSignal* _tmp514_;
								_tmp459_ = vala_member_access_get_inner (self);
								_tmp460_ = _tmp459_;
								_tmp461_ = vala_expression_get_value_type (_tmp460_);
								_tmp462_ = _tmp461_;
								_tmp463_ = self->priv->_member_name;
								_tmp464_ = vala_void_type_new (NULL);
								_tmp465_ = _tmp464_;
								_tmp466_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp467_ = _tmp466_;
								_tmp468_ = vala_dynamic_signal_new (_tmp462_, _tmp463_, (ValaDataType*) _tmp465_, _tmp467_, NULL);
								_tmp469_ = _tmp468_;
								_vala_code_node_unref0 (_tmp465_);
								s = _tmp469_;
								_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp471_ = _tmp470_;
								_tmp472_ = vala_code_node_get_parent_node (_tmp471_);
								_tmp473_ = _tmp472_;
								_tmp474_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp473_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp474_;
								_tmp475_ = mcall;
								_tmp476_ = vala_method_call_get_argument_list (_tmp475_);
								_tmp477_ = _tmp476_;
								_tmp478_ = vala_collection_get_size ((ValaCollection*) _tmp477_);
								_tmp479_ = _tmp478_;
								_tmp480_ = _tmp479_ > 0;
								_vala_iterable_unref0 (_tmp477_);
								if (_tmp480_) {
									ValaDynamicSignal* _tmp481_;
									ValaMethodCall* _tmp482_;
									ValaList* _tmp483_;
									ValaList* _tmp484_;
									gpointer _tmp485_;
									ValaExpression* _tmp486_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp487_;
									ValaExpression* _tmp488_;
									ValaExpression* _tmp489_;
									gboolean _tmp490_ = FALSE;
									gboolean _tmp491_ = FALSE;
									ValaMemberAccess* _tmp492_;
									_tmp481_ = s;
									_tmp482_ = mcall;
									_tmp483_ = vala_method_call_get_argument_list (_tmp482_);
									_tmp484_ = _tmp483_;
									_tmp485_ = vala_list_get (_tmp484_, 0);
									_tmp486_ = (ValaExpression*) _tmp485_;
									vala_dynamic_signal_set_handler (_tmp481_, _tmp486_);
									_vala_code_node_unref0 (_tmp486_);
									_vala_iterable_unref0 (_tmp484_);
									_tmp487_ = s;
									_tmp488_ = vala_dynamic_signal_get_handler (_tmp487_);
									_tmp489_ = _tmp488_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp489_) ? ((ValaMemberAccess*) _tmp489_) : NULL;
									_tmp492_ = arg;
									if (_tmp492_ == NULL) {
										_tmp491_ = TRUE;
									} else {
										ValaMemberAccess* _tmp493_;
										_tmp493_ = arg;
										_tmp491_ = !vala_code_node_check ((ValaCodeNode*) _tmp493_, context);
									}
									if (_tmp491_) {
										_tmp490_ = TRUE;
									} else {
										ValaMemberAccess* _tmp494_;
										ValaSymbol* _tmp495_;
										ValaSymbol* _tmp496_;
										_tmp494_ = arg;
										_tmp495_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp494_);
										_tmp496_ = _tmp495_;
										_tmp490_ = !VALA_IS_METHOD (_tmp496_);
									}
									if (_tmp490_) {
										ValaDynamicSignal* _tmp497_;
										ValaExpression* _tmp498_;
										ValaExpression* _tmp499_;
										ValaSourceReference* _tmp500_;
										ValaSourceReference* _tmp501_;
										ValaDynamicSignal* _tmp502_;
										gchar* _tmp503_;
										gchar* _tmp504_;
										gchar* _tmp505_;
										gchar* _tmp506_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp497_ = s;
										_tmp498_ = vala_dynamic_signal_get_handler (_tmp497_);
										_tmp499_ = _tmp498_;
										_tmp500_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp499_);
										_tmp501_ = _tmp500_;
										_tmp502_ = s;
										_tmp503_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp502_);
										_tmp504_ = _tmp503_;
										_tmp505_ = g_strdup_printf ("Invalid handler for `%s'", _tmp504_);
										_tmp506_ = _tmp505_;
										vala_report_error (_tmp501_, _tmp506_);
										_g_free0 (_tmp506_);
										_g_free0 (_tmp504_);
									}
								}
								_tmp507_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp507_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp508_ = dynamic_object_type;
								_tmp509_ = vala_object_type_get_type_symbol (_tmp508_);
								_tmp510_ = _tmp509_;
								_tmp511_ = vala_symbol_get_scope ((ValaSymbol*) _tmp510_);
								_tmp512_ = _tmp511_;
								_tmp513_ = s;
								vala_scope_add (_tmp512_, NULL, (ValaSymbol*) _tmp513_);
								_tmp514_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp514_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp515_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp516_ = _tmp515_;
				if (_tmp516_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp517_;
					ValaExpression* _tmp518_;
					ValaDataType* _tmp519_;
					ValaDataType* _tmp520_;
					const gchar* _tmp521_;
					ValaSourceReference* _tmp522_;
					ValaSourceReference* _tmp523_;
					ValaDynamicProperty* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDataType* _tmp526_;
					ValaDynamicProperty* _tmp537_;
					ValaDynamicProperty* _tmp538_;
					ValaDynamicProperty* _tmp539_;
					ValaDataType* _tmp540_;
					ValaDataType* _tmp541_;
					ValaDataType* _tmp542_;
					ValaDataType* _tmp543_;
					ValaDynamicProperty* _tmp544_;
					ValaSourceReference* _tmp545_;
					ValaSourceReference* _tmp546_;
					ValaPropertyAccessor* _tmp547_;
					ValaPropertyAccessor* _tmp548_;
					ValaDynamicProperty* _tmp549_;
					ValaExpression* _tmp550_;
					ValaExpression* _tmp551_;
					ValaDataType* _tmp552_;
					ValaDataType* _tmp553_;
					ValaTypeSymbol* _tmp554_;
					ValaTypeSymbol* _tmp555_;
					ValaScope* _tmp556_;
					ValaScope* _tmp557_;
					ValaObjectType* _tmp558_;
					ValaObjectTypeSymbol* _tmp559_;
					ValaObjectTypeSymbol* _tmp560_;
					ValaScope* _tmp561_;
					ValaScope* _tmp562_;
					ValaDynamicProperty* _tmp563_;
					ValaDynamicProperty* _tmp564_;
					_tmp517_ = vala_member_access_get_inner (self);
					_tmp518_ = _tmp517_;
					_tmp519_ = vala_expression_get_value_type (_tmp518_);
					_tmp520_ = _tmp519_;
					_tmp521_ = self->priv->_member_name;
					_tmp522_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp523_ = _tmp522_;
					_tmp524_ = vala_dynamic_property_new (_tmp520_, _tmp521_, _tmp523_, NULL);
					prop = _tmp524_;
					_tmp525_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp526_ = _tmp525_;
					if (_tmp526_ != NULL) {
						ValaDynamicProperty* _tmp527_;
						ValaDataType* _tmp528_;
						ValaDataType* _tmp529_;
						_tmp527_ = prop;
						_tmp528_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp529_ = _tmp528_;
						vala_property_set_property_type ((ValaProperty*) _tmp527_, _tmp529_);
					} else {
						ValaDynamicProperty* _tmp530_;
						ValaExpression* _tmp531_;
						ValaExpression* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						ValaDataType* _tmp535_;
						ValaDataType* _tmp536_;
						_tmp530_ = prop;
						_tmp531_ = vala_member_access_get_inner (self);
						_tmp532_ = _tmp531_;
						_tmp533_ = vala_expression_get_value_type (_tmp532_);
						_tmp534_ = _tmp533_;
						_tmp535_ = vala_data_type_copy (_tmp534_);
						_tmp536_ = _tmp535_;
						vala_property_set_property_type ((ValaProperty*) _tmp530_, _tmp536_);
						_vala_code_node_unref0 (_tmp536_);
					}
					_tmp537_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp537_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp538_ = prop;
					_tmp539_ = prop;
					_tmp540_ = vala_property_get_property_type ((ValaProperty*) _tmp539_);
					_tmp541_ = _tmp540_;
					_tmp542_ = vala_data_type_copy (_tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = prop;
					_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp544_);
					_tmp546_ = _tmp545_;
					_tmp547_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp543_, NULL, _tmp546_, NULL);
					_tmp548_ = _tmp547_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp538_, _tmp548_);
					_vala_code_node_unref0 (_tmp548_);
					_vala_code_node_unref0 (_tmp543_);
					_tmp549_ = prop;
					_tmp550_ = vala_member_access_get_inner (self);
					_tmp551_ = _tmp550_;
					_tmp552_ = vala_expression_get_value_type (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = vala_data_type_get_data_type (_tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = vala_symbol_get_scope ((ValaSymbol*) _tmp555_);
					_tmp557_ = _tmp556_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp549_, _tmp557_);
					_tmp558_ = dynamic_object_type;
					_tmp559_ = vala_object_type_get_type_symbol (_tmp558_);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_symbol_get_scope ((ValaSymbol*) _tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = prop;
					vala_scope_add (_tmp562_, NULL, (ValaSymbol*) _tmp563_);
					_tmp564_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp564_);
					_vala_code_node_unref0 (prop);
				}
				_tmp565_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp566_ = _tmp565_;
				if (_tmp566_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp568_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp569_ = _tmp568_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp569_)) {
				ValaExpression* _tmp570_;
				ValaExpression* _tmp571_;
				ValaSymbol* _tmp572_;
				ValaSymbol* _tmp573_;
				_tmp570_ = vala_member_access_get_inner (self);
				_tmp571_ = _tmp570_;
				_tmp572_ = vala_expression_get_symbol_reference (_tmp571_);
				_tmp573_ = _tmp572_;
				_tmp567_ = VALA_IS_VARIABLE (_tmp573_);
			} else {
				_tmp567_ = FALSE;
			}
			if (_tmp567_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp574_;
				ValaSemanticAnalyzer* _tmp575_;
				ValaExpression* _tmp576_;
				ValaExpression* _tmp577_;
				ValaSymbol* _tmp578_;
				ValaSymbol* _tmp579_;
				ValaDataType* _tmp580_;
				ValaArrayType* _tmp581_;
				gboolean _tmp582_ = FALSE;
				ValaArrayType* _tmp583_;
				_tmp574_ = vala_code_context_get_analyzer (context);
				_tmp575_ = _tmp574_;
				_tmp576_ = vala_member_access_get_inner (self);
				_tmp577_ = _tmp576_;
				_tmp578_ = vala_expression_get_symbol_reference (_tmp577_);
				_tmp579_ = _tmp578_;
				_tmp580_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp575_, _tmp579_, TRUE);
				_tmp581_ = VALA_IS_ARRAY_TYPE (_tmp580_) ? ((ValaArrayType*) _tmp580_) : NULL;
				if (_tmp581_ == NULL) {
					_vala_code_node_unref0 (_tmp580_);
				}
				inner_type = _tmp581_;
				_tmp583_ = inner_type;
				if (_tmp583_ != NULL) {
					ValaArrayType* _tmp584_;
					gboolean _tmp585_;
					gboolean _tmp586_;
					_tmp584_ = inner_type;
					_tmp585_ = vala_array_type_get_inline_allocated (_tmp584_);
					_tmp586_ = _tmp585_;
					_tmp582_ = _tmp586_;
				} else {
					_tmp582_ = FALSE;
				}
				if (_tmp582_) {
					ValaSourceReference* _tmp587_;
					ValaSourceReference* _tmp588_;
					_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp588_ = _tmp587_;
					vala_report_error (_tmp588_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp589_ = FALSE;
					ValaArrayType* _tmp590_;
					_tmp590_ = inner_type;
					if (_tmp590_ != NULL) {
						ValaArrayType* _tmp591_;
						gboolean _tmp592_;
						gboolean _tmp593_;
						_tmp591_ = inner_type;
						_tmp592_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp591_);
						_tmp593_ = _tmp592_;
						_tmp589_ = !_tmp593_;
					} else {
						_tmp589_ = FALSE;
					}
					if (_tmp589_) {
						ValaSourceReference* _tmp594_;
						ValaSourceReference* _tmp595_;
						_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp595_ = _tmp594_;
						vala_report_error (_tmp595_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp599_ = vala_member_access_get_inner (self);
	_tmp600_ = _tmp599_;
	if (_tmp600_ == NULL) {
		ValaSymbol* _tmp601_;
		ValaSymbol* _tmp602_;
		_tmp601_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp602_ = _tmp601_;
		_tmp598_ = _tmp602_ == NULL;
	} else {
		_tmp598_ = FALSE;
	}
	if (_tmp598_) {
		ValaDataType* _tmp603_;
		ValaDataType* _tmp604_;
		_tmp603_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp604_ = _tmp603_;
		_tmp597_ = _tmp604_ != NULL;
	} else {
		_tmp597_ = FALSE;
	}
	if (_tmp597_) {
		ValaDataType* _tmp605_;
		ValaDataType* _tmp606_;
		ValaTypeSymbol* _tmp607_;
		ValaTypeSymbol* _tmp608_;
		_tmp605_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp606_ = _tmp605_;
		_tmp607_ = vala_data_type_get_data_type (_tmp606_);
		_tmp608_ = _tmp607_;
		_tmp596_ = VALA_IS_ENUM (_tmp608_);
	} else {
		_tmp596_ = FALSE;
	}
	if (_tmp596_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp609_;
		ValaDataType* _tmp610_;
		ValaTypeSymbol* _tmp611_;
		ValaTypeSymbol* _tmp612_;
		ValaEnum* _tmp613_;
		_tmp609_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp610_ = _tmp609_;
		_tmp611_ = vala_data_type_get_data_type (_tmp610_);
		_tmp612_ = _tmp611_;
		_tmp613_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp612_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp613_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp614_;
			ValaList* _tmp615_;
			gint _val_size = 0;
			ValaList* _tmp616_;
			gint _tmp617_;
			gint _tmp618_;
			gint _val_index = 0;
			_tmp614_ = enum_type;
			_tmp615_ = vala_enum_get_values (_tmp614_);
			_val_list = _tmp615_;
			_tmp616_ = _val_list;
			_tmp617_ = vala_collection_get_size ((ValaCollection*) _tmp616_);
			_tmp618_ = _tmp617_;
			_val_size = _tmp618_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp619_;
				gpointer _tmp620_;
				const gchar* _tmp621_;
				ValaEnumValue* _tmp622_;
				const gchar* _tmp623_;
				const gchar* _tmp624_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp619_ = _val_list;
				_tmp620_ = vala_list_get (_tmp619_, _val_index);
				val = (ValaEnumValue*) _tmp620_;
				_tmp621_ = self->priv->_member_name;
				_tmp622_ = val;
				_tmp623_ = vala_symbol_get_name ((ValaSymbol*) _tmp622_);
				_tmp624_ = _tmp623_;
				if (g_strcmp0 (_tmp621_, _tmp624_) == 0) {
					ValaEnumValue* _tmp625_;
					_tmp625_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp625_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp626_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp627_ = _tmp626_;
	if (_tmp627_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp628_;
		gboolean _tmp629_ = FALSE;
		ValaExpression* _tmp630_;
		ValaExpression* _tmp631_;
		ValaSourceReference* _tmp644_;
		ValaSourceReference* _tmp645_;
		const gchar* _tmp646_;
		const gchar* _tmp647_;
		gchar* _tmp648_;
		gchar* _tmp649_;
		ValaInvalidType* _tmp650_;
		ValaInvalidType* _tmp651_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp628_ = g_strdup ("(null)");
		base_type_name = _tmp628_;
		_tmp630_ = vala_member_access_get_inner (self);
		_tmp631_ = _tmp630_;
		if (_tmp631_ != NULL) {
			ValaExpression* _tmp632_;
			ValaExpression* _tmp633_;
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			_tmp632_ = vala_member_access_get_inner (self);
			_tmp633_ = _tmp632_;
			_tmp634_ = vala_expression_get_value_type (_tmp633_);
			_tmp635_ = _tmp634_;
			_tmp629_ = _tmp635_ != NULL;
		} else {
			_tmp629_ = FALSE;
		}
		if (_tmp629_) {
			ValaExpression* _tmp636_;
			ValaExpression* _tmp637_;
			ValaDataType* _tmp638_;
			ValaDataType* _tmp639_;
			gchar* _tmp640_;
			_tmp636_ = vala_member_access_get_inner (self);
			_tmp637_ = _tmp636_;
			_tmp638_ = vala_expression_get_value_type (_tmp637_);
			_tmp639_ = _tmp638_;
			_tmp640_ = vala_code_node_to_string ((ValaCodeNode*) _tmp639_);
			_g_free0 (base_type_name);
			base_type_name = _tmp640_;
		} else {
			ValaSymbol* _tmp641_;
			_tmp641_ = base_symbol;
			if (_tmp641_ != NULL) {
				ValaSymbol* _tmp642_;
				gchar* _tmp643_;
				_tmp642_ = base_symbol;
				_tmp643_ = vala_symbol_get_full_name (_tmp642_);
				_g_free0 (base_type_name);
				base_type_name = _tmp643_;
			}
		}
		_tmp644_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp645_ = _tmp644_;
		_tmp646_ = self->priv->_member_name;
		_tmp647_ = base_type_name;
		_tmp648_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp646_, _tmp647_);
		_tmp649_ = _tmp648_;
		vala_report_error (_tmp645_, _tmp649_);
		_g_free0 (_tmp649_);
		_tmp650_ = vala_invalid_type_new ();
		_tmp651_ = _tmp650_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp651_);
		_vala_code_node_unref0 (_tmp651_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp652_;
		ValaSymbol* _tmp653_;
		gboolean _tmp654_;
		gboolean _tmp655_;
		_tmp652_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp653_ = _tmp652_;
		_tmp654_ = vala_code_node_get_error ((ValaCodeNode*) _tmp653_);
		_tmp655_ = _tmp654_;
		if (_tmp655_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp656_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp657_ = _tmp656_;
	if (VALA_IS_SIGNAL (_tmp657_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp658_;
		ValaSymbol* _tmp659_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp666_;
		ValaCodeNode* _tmp667_;
		ValaCodeNode* _tmp668_;
		gboolean _tmp669_ = FALSE;
		gboolean _tmp670_ = FALSE;
		gboolean _tmp671_ = FALSE;
		ValaCodeNode* _tmp672_;
		_tmp658_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp659_ = _tmp658_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp659_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp660_;
			ValaCodeNode* _tmp661_;
			ValaCodeNode* _tmp662_;
			ValaCodeNode* _tmp663_;
			ValaCodeNode* _tmp664_;
			ValaCodeNode* _tmp665_;
			_tmp660_ = ma;
			_tmp661_ = vala_code_node_get_parent_node (_tmp660_);
			_tmp662_ = _tmp661_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp662_)) {
				break;
			}
			_tmp663_ = ma;
			_tmp664_ = vala_code_node_get_parent_node (_tmp663_);
			_tmp665_ = _tmp664_;
			ma = _tmp665_;
		}
		_tmp666_ = ma;
		_tmp667_ = vala_code_node_get_parent_node (_tmp666_);
		_tmp668_ = _tmp667_;
		parent = _tmp668_;
		_tmp672_ = parent;
		if (_tmp672_ != NULL) {
			ValaCodeNode* _tmp673_;
			_tmp673_ = parent;
			_tmp671_ = !VALA_IS_ELEMENT_ACCESS (_tmp673_);
		} else {
			_tmp671_ = FALSE;
		}
		if (_tmp671_) {
			ValaCodeNode* _tmp674_;
			ValaExpression* _tmp675_;
			ValaExpression* _tmp676_;
			_tmp674_ = ma;
			_tmp675_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp674_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp676_ = _tmp675_;
			_tmp670_ = !VALA_IS_BASE_ACCESS (_tmp676_);
		} else {
			_tmp670_ = FALSE;
		}
		if (_tmp670_) {
			gboolean _tmp677_ = FALSE;
			ValaCodeNode* _tmp678_;
			_tmp678_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp678_)) {
				_tmp677_ = TRUE;
			} else {
				ValaCodeNode* _tmp679_;
				ValaList* _tmp680_;
				ValaList* _tmp681_;
				_tmp679_ = parent;
				_tmp680_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp679_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp681_ = _tmp680_;
				_tmp677_ = vala_collection_contains ((ValaCollection*) _tmp681_, (ValaExpression*) self);
				_vala_iterable_unref0 (_tmp681_);
			}
			_tmp669_ = _tmp677_;
		} else {
			_tmp669_ = FALSE;
		}
		if (_tmp669_) {
			ValaSignal* _tmp682_;
			ValaAttribute* _tmp683_;
			_tmp682_ = sig;
			_tmp683_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp682_, "HasEmitter");
			if (_tmp683_ != NULL) {
				ValaSignal* _tmp684_;
				ValaSignal* _tmp685_;
				ValaMethod* _tmp686_;
				ValaMethod* _tmp687_;
				_tmp684_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp684_, context)) {
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_tmp685_ = sig;
				_tmp686_ = vala_signal_get_emitter (_tmp685_);
				_tmp687_ = _tmp686_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp687_);
			} else {
				ValaSourceReference* _tmp688_;
				ValaSourceReference* _tmp689_;
				ValaSymbol* _tmp690_;
				ValaSymbol* _tmp691_;
				gchar* _tmp692_;
				gchar* _tmp693_;
				gchar* _tmp694_;
				gchar* _tmp695_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp688_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp691_ = _tmp690_;
				_tmp692_ = vala_symbol_get_full_name (_tmp691_);
				_tmp693_ = _tmp692_;
				_tmp694_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp693_);
				_tmp695_ = _tmp694_;
				vala_report_error (_tmp689_, _tmp695_);
				_g_free0 (_tmp695_);
				_g_free0 (_tmp693_);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
		}
	}
	_tmp696_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp697_ = _tmp696_;
	_tmp698_ = _vala_code_node_ref0 (_tmp697_);
	member = _tmp698_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp699_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp699_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp700_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp700_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp701_;
		ValaLocalVariable* _tmp702_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp703_;
		ValaSymbol* _tmp704_;
		ValaSymbol* _tmp705_;
		ValaBlock* _tmp706_;
		gboolean _tmp707_ = FALSE;
		ValaBlock* _tmp708_;
		_tmp701_ = member;
		_tmp702_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp701_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp702_;
		_tmp703_ = local;
		_tmp704_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp705_) ? ((ValaBlock*) _tmp705_) : NULL);
		block = _tmp706_;
		_tmp708_ = block;
		if (_tmp708_ != NULL) {
			ValaSemanticAnalyzer* _tmp709_;
			ValaSemanticAnalyzer* _tmp710_;
			ValaBlock* _tmp711_;
			ValaSymbol* _tmp712_;
			ValaSymbol* _tmp713_;
			ValaSemanticAnalyzer* _tmp714_;
			ValaSemanticAnalyzer* _tmp715_;
			ValaSymbol* _tmp716_;
			ValaSymbol* _tmp717_;
			_tmp709_ = vala_code_context_get_analyzer (context);
			_tmp710_ = _tmp709_;
			_tmp711_ = block;
			_tmp712_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp710_, (ValaSymbol*) _tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_code_context_get_analyzer (context);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp715_);
			_tmp717_ = _tmp716_;
			_tmp707_ = _tmp713_ != _tmp717_;
			_vala_code_node_unref0 (_tmp713_);
		} else {
			_tmp707_ = FALSE;
		}
		if (_tmp707_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp718_;
			ValaSemanticAnalyzer* _tmp719_;
			ValaSymbol* _tmp720_;
			ValaSymbol* _tmp721_;
			ValaSymbol* _tmp722_;
			ValaLocalVariable* _tmp735_;
			ValaBlock* _tmp736_;
			_tmp718_ = vala_code_context_get_analyzer (context);
			_tmp719_ = _tmp718_;
			_tmp720_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp719_);
			_tmp721_ = _tmp720_;
			_tmp722_ = _vala_code_node_ref0 (_tmp721_);
			sym = _tmp722_;
			while (TRUE) {
				ValaSymbol* _tmp723_;
				ValaBlock* _tmp724_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp725_;
				ValaMethod* _tmp726_;
				ValaMethod* _tmp727_;
				ValaSymbol* _tmp731_;
				ValaSymbol* _tmp732_;
				ValaSymbol* _tmp733_;
				ValaSymbol* _tmp734_;
				_tmp723_ = sym;
				_tmp724_ = block;
				if (!(_tmp723_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp724_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp725_ = sym;
				_tmp726_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp725_) ? ((ValaMethod*) _tmp725_) : NULL);
				method = _tmp726_;
				_tmp727_ = method;
				if (_tmp727_ != NULL) {
					ValaMethod* _tmp728_;
					ValaMethod* _tmp729_;
					ValaLocalVariable* _tmp730_;
					_tmp728_ = method;
					vala_method_set_closure (_tmp728_, TRUE);
					_tmp729_ = method;
					_tmp730_ = local;
					vala_method_add_captured_variable (_tmp729_, _tmp730_);
				}
				_tmp731_ = sym;
				_tmp732_ = vala_symbol_get_parent_symbol (_tmp731_);
				_tmp733_ = _tmp732_;
				_tmp734_ = _vala_code_node_ref0 (_tmp733_);
				_vala_code_node_unref0 (sym);
				sym = _tmp734_;
				_vala_code_node_unref0 (method);
			}
			_tmp735_ = local;
			vala_local_variable_set_captured (_tmp735_, TRUE);
			_tmp736_ = block;
			vala_block_set_captured (_tmp736_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp737_;
		_tmp737_ = member;
		if (VALA_IS_PARAMETER (_tmp737_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp738_;
			ValaParameter* _tmp739_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp740_;
			ValaSymbol* _tmp741_;
			ValaSymbol* _tmp742_;
			ValaMethod* _tmp743_;
			gboolean _tmp744_ = FALSE;
			gboolean _tmp745_ = FALSE;
			ValaMethod* _tmp746_;
			_tmp738_ = member;
			_tmp739_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp738_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp739_;
			_tmp740_ = param;
			_tmp741_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp740_);
			_tmp742_ = _tmp741_;
			_tmp743_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp742_) ? ((ValaMethod*) _tmp742_) : NULL);
			m = _tmp743_;
			_tmp746_ = m;
			if (_tmp746_ != NULL) {
				ValaMethod* _tmp747_;
				ValaSemanticAnalyzer* _tmp748_;
				ValaSemanticAnalyzer* _tmp749_;
				ValaSymbol* _tmp750_;
				ValaSymbol* _tmp751_;
				_tmp747_ = m;
				_tmp748_ = vala_code_context_get_analyzer (context);
				_tmp749_ = _tmp748_;
				_tmp750_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp749_);
				_tmp751_ = _tmp750_;
				_tmp745_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp747_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp751_;
			} else {
				_tmp745_ = FALSE;
			}
			if (_tmp745_) {
				ValaParameter* _tmp752_;
				ValaMethod* _tmp753_;
				ValaParameter* _tmp754_;
				ValaParameter* _tmp755_;
				_tmp752_ = param;
				_tmp753_ = m;
				_tmp754_ = vala_method_get_this_parameter (_tmp753_);
				_tmp755_ = _tmp754_;
				_tmp744_ = _tmp752_ != _tmp755_;
			} else {
				_tmp744_ = FALSE;
			}
			if (_tmp744_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp756_;
				ValaSemanticAnalyzer* _tmp757_;
				ValaSymbol* _tmp758_;
				ValaSymbol* _tmp759_;
				ValaSymbol* _tmp760_;
				ValaParameter* _tmp771_;
				ValaMethod* _tmp772_;
				ValaBlock* _tmp773_;
				ValaBlock* _tmp774_;
				ValaParameter* _tmp775_;
				ValaParameterDirection _tmp776_;
				ValaParameterDirection _tmp777_;
				_tmp756_ = vala_code_context_get_analyzer (context);
				_tmp757_ = _tmp756_;
				_tmp758_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp757_);
				_tmp759_ = _tmp758_;
				_tmp760_ = _vala_code_node_ref0 (_tmp759_);
				sym = _tmp760_;
				while (TRUE) {
					ValaSymbol* _tmp761_;
					ValaMethod* _tmp762_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp763_;
					ValaMethod* _tmp764_;
					ValaMethod* _tmp765_;
					ValaSymbol* _tmp767_;
					ValaSymbol* _tmp768_;
					ValaSymbol* _tmp769_;
					ValaSymbol* _tmp770_;
					_tmp761_ = sym;
					_tmp762_ = m;
					if (!(_tmp761_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp762_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp763_ = sym;
					_tmp764_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp763_) ? ((ValaMethod*) _tmp763_) : NULL);
					method = _tmp764_;
					_tmp765_ = method;
					if (_tmp765_ != NULL) {
						ValaMethod* _tmp766_;
						_tmp766_ = method;
						vala_method_set_closure (_tmp766_, TRUE);
					}
					_tmp767_ = sym;
					_tmp768_ = vala_symbol_get_parent_symbol (_tmp767_);
					_tmp769_ = _tmp768_;
					_tmp770_ = _vala_code_node_ref0 (_tmp769_);
					_vala_code_node_unref0 (sym);
					sym = _tmp770_;
					_vala_code_node_unref0 (method);
				}
				_tmp771_ = param;
				vala_parameter_set_captured (_tmp771_, TRUE);
				_tmp772_ = m;
				_tmp773_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp772_);
				_tmp774_ = _tmp773_;
				vala_block_set_captured (_tmp774_, TRUE);
				_tmp775_ = param;
				_tmp776_ = vala_parameter_get_direction (_tmp775_);
				_tmp777_ = _tmp776_;
				if (_tmp777_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp778_;
					ValaSourceReference* _tmp779_;
					ValaParameter* _tmp780_;
					gchar* _tmp781_;
					gchar* _tmp782_;
					gchar* _tmp783_;
					gchar* _tmp784_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp778_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp779_ = _tmp778_;
					_tmp780_ = param;
					_tmp781_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp780_);
					_tmp782_ = _tmp781_;
					_tmp783_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp782_);
					_tmp784_ = _tmp783_;
					vala_report_error (_tmp779_, _tmp784_);
					_g_free0 (_tmp784_);
					_g_free0 (_tmp782_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp785_;
				ValaSymbol* _tmp786_;
				ValaSymbol* _tmp787_;
				ValaSymbol* _tmp788_;
				ValaSymbol* _tmp789_;
				ValaPropertyAccessor* _tmp790_;
				gboolean _tmp791_ = FALSE;
				gboolean _tmp792_ = FALSE;
				ValaPropertyAccessor* _tmp793_;
				_tmp785_ = param;
				_tmp786_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp785_);
				_tmp787_ = _tmp786_;
				_tmp788_ = vala_symbol_get_parent_symbol (_tmp787_);
				_tmp789_ = _tmp788_;
				_tmp790_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp789_) ? ((ValaPropertyAccessor*) _tmp789_) : NULL);
				acc = _tmp790_;
				_tmp793_ = acc;
				if (_tmp793_ != NULL) {
					ValaPropertyAccessor* _tmp794_;
					ValaSemanticAnalyzer* _tmp795_;
					ValaSemanticAnalyzer* _tmp796_;
					ValaSymbol* _tmp797_;
					ValaSymbol* _tmp798_;
					_tmp794_ = acc;
					_tmp795_ = vala_code_context_get_analyzer (context);
					_tmp796_ = _tmp795_;
					_tmp797_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp796_);
					_tmp798_ = _tmp797_;
					_tmp792_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp794_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp798_;
				} else {
					_tmp792_ = FALSE;
				}
				if (_tmp792_) {
					ValaParameter* _tmp799_;
					ValaPropertyAccessor* _tmp800_;
					ValaProperty* _tmp801_;
					ValaProperty* _tmp802_;
					ValaParameter* _tmp803_;
					ValaParameter* _tmp804_;
					_tmp799_ = param;
					_tmp800_ = acc;
					_tmp801_ = vala_property_accessor_get_prop (_tmp800_);
					_tmp802_ = _tmp801_;
					_tmp803_ = vala_property_get_this_parameter (_tmp802_);
					_tmp804_ = _tmp803_;
					_tmp791_ = _tmp799_ != _tmp804_;
				} else {
					_tmp791_ = FALSE;
				}
				if (_tmp791_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp805_;
					ValaSemanticAnalyzer* _tmp806_;
					ValaSymbol* _tmp807_;
					ValaSymbol* _tmp808_;
					ValaSymbol* _tmp809_;
					ValaParameter* _tmp820_;
					ValaPropertyAccessor* _tmp821_;
					ValaBlock* _tmp822_;
					ValaBlock* _tmp823_;
					_tmp805_ = vala_code_context_get_analyzer (context);
					_tmp806_ = _tmp805_;
					_tmp807_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp806_);
					_tmp808_ = _tmp807_;
					_tmp809_ = _vala_code_node_ref0 (_tmp808_);
					sym = _tmp809_;
					while (TRUE) {
						ValaSymbol* _tmp810_;
						ValaMethod* _tmp811_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp812_;
						ValaMethod* _tmp813_;
						ValaMethod* _tmp814_;
						ValaSymbol* _tmp816_;
						ValaSymbol* _tmp817_;
						ValaSymbol* _tmp818_;
						ValaSymbol* _tmp819_;
						_tmp810_ = sym;
						_tmp811_ = m;
						if (!(_tmp810_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp811_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp812_ = sym;
						_tmp813_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp812_) ? ((ValaMethod*) _tmp812_) : NULL);
						method = _tmp813_;
						_tmp814_ = method;
						if (_tmp814_ != NULL) {
							ValaMethod* _tmp815_;
							_tmp815_ = method;
							vala_method_set_closure (_tmp815_, TRUE);
						}
						_tmp816_ = sym;
						_tmp817_ = vala_symbol_get_parent_symbol (_tmp816_);
						_tmp818_ = _tmp817_;
						_tmp819_ = _vala_code_node_ref0 (_tmp818_);
						_vala_code_node_unref0 (sym);
						sym = _tmp819_;
						_vala_code_node_unref0 (method);
					}
					_tmp820_ = param;
					vala_parameter_set_captured (_tmp820_, TRUE);
					_tmp821_ = acc;
					_tmp822_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp821_);
					_tmp823_ = _tmp822_;
					vala_block_set_captured (_tmp823_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp824_;
			_tmp824_ = member;
			if (VALA_IS_FIELD (_tmp824_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp825_;
				ValaField* _tmp826_;
				ValaField* _tmp827_;
				ValaSymbolAccessibility _tmp828_;
				ValaSymbolAccessibility _tmp829_;
				ValaField* _tmp830_;
				ValaMemberBinding _tmp831_;
				ValaMemberBinding _tmp832_;
				ValaField* _tmp833_;
				ValaMemberBinding _tmp834_;
				ValaMemberBinding _tmp835_;
				ValaField* _tmp836_;
				ValaDataType* _tmp837_;
				ValaDataType* _tmp838_;
				_tmp825_ = member;
				_tmp826_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp825_, VALA_TYPE_FIELD, ValaField));
				f = _tmp826_;
				_tmp827_ = f;
				_tmp828_ = vala_symbol_get_access ((ValaSymbol*) _tmp827_);
				_tmp829_ = _tmp828_;
				access = _tmp829_;
				_tmp830_ = f;
				_tmp831_ = vala_field_get_binding (_tmp830_);
				_tmp832_ = _tmp831_;
				instance = _tmp832_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp833_ = f;
				_tmp834_ = vala_field_get_binding (_tmp833_);
				_tmp835_ = _tmp834_;
				klass = _tmp835_ == VALA_MEMBER_BINDING_CLASS;
				_tmp836_ = f;
				_tmp837_ = vala_variable_get_variable_type ((ValaVariable*) _tmp836_);
				_tmp838_ = _tmp837_;
				if (VALA_IS_GENERIC_TYPE (_tmp838_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp839_;
				_tmp839_ = member;
				if (VALA_IS_CONSTANT (_tmp839_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp840_;
					ValaConstant* _tmp841_;
					ValaConstant* _tmp842_;
					ValaSymbolAccessibility _tmp843_;
					ValaSymbolAccessibility _tmp844_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp845_;
					ValaSymbol* _tmp846_;
					ValaSymbol* _tmp847_;
					ValaBlock* _tmp848_;
					gboolean _tmp849_ = FALSE;
					ValaBlock* _tmp850_;
					_tmp840_ = member;
					_tmp841_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp840_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp841_;
					_tmp842_ = c;
					_tmp843_ = vala_symbol_get_access ((ValaSymbol*) _tmp842_);
					_tmp844_ = _tmp843_;
					access = _tmp844_;
					_tmp845_ = c;
					_tmp846_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp845_);
					_tmp847_ = _tmp846_;
					_tmp848_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp847_) ? ((ValaBlock*) _tmp847_) : NULL);
					block = _tmp848_;
					_tmp850_ = block;
					if (_tmp850_ != NULL) {
						ValaSemanticAnalyzer* _tmp851_;
						ValaSemanticAnalyzer* _tmp852_;
						ValaBlock* _tmp853_;
						ValaSymbol* _tmp854_;
						ValaSymbol* _tmp855_;
						ValaSemanticAnalyzer* _tmp856_;
						ValaSemanticAnalyzer* _tmp857_;
						ValaSymbol* _tmp858_;
						ValaSymbol* _tmp859_;
						_tmp851_ = vala_code_context_get_analyzer (context);
						_tmp852_ = _tmp851_;
						_tmp853_ = block;
						_tmp854_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp852_, (ValaSymbol*) _tmp853_);
						_tmp855_ = _tmp854_;
						_tmp856_ = vala_code_context_get_analyzer (context);
						_tmp857_ = _tmp856_;
						_tmp858_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp857_);
						_tmp859_ = _tmp858_;
						_tmp849_ = _tmp855_ != _tmp859_;
						_vala_code_node_unref0 (_tmp855_);
					} else {
						_tmp849_ = FALSE;
					}
					if (_tmp849_) {
						ValaSourceReference* _tmp860_;
						ValaSourceReference* _tmp861_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp860_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp861_ = _tmp860_;
						vala_report_error (_tmp861_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp862_;
					_tmp862_ = member;
					if (VALA_IS_METHOD (_tmp862_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp863_;
						ValaMethod* _tmp864_;
						ValaMethod* _tmp865_;
						gboolean _tmp866_;
						gboolean _tmp867_;
						ValaMethod* _tmp969_;
						ValaSymbolAccessibility _tmp970_;
						ValaSymbolAccessibility _tmp971_;
						ValaMethod* _tmp972_;
						ValaMethod* _tmp976_;
						ValaMemberBinding _tmp977_;
						ValaMemberBinding _tmp978_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp997_;
						ValaDataType* _tmp998_;
						ValaDataType* _tmp999_;
						ValaGenericType* _tmp1000_;
						gboolean _tmp1001_ = FALSE;
						ValaGenericType* _tmp1002_;
						_tmp863_ = member;
						_tmp864_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp863_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp864_;
						_tmp865_ = m;
						_tmp866_ = vala_method_get_is_async_callback (_tmp865_);
						_tmp867_ = _tmp866_;
						if (_tmp867_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp868_;
							ValaSemanticAnalyzer* _tmp869_;
							ValaMethod* _tmp870_;
							ValaMethod* _tmp871_;
							ValaMethod* _tmp872_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp873_;
							ValaMethod* _tmp906_;
							ValaSemanticAnalyzer* _tmp907_;
							ValaSemanticAnalyzer* _tmp908_;
							ValaMethod* _tmp909_;
							ValaMethod* _tmp910_;
							ValaMethod* _tmp929_;
							ValaMethod* _tmp930_;
							ValaMethod* _tmp931_;
							ValaSymbol* _tmp932_;
							ValaSymbol* _tmp933_;
							ValaSymbol* _tmp934_;
							_tmp868_ = vala_code_context_get_analyzer (context);
							_tmp869_ = _tmp868_;
							_tmp870_ = vala_semantic_analyzer_get_current_async_method (_tmp869_);
							_tmp871_ = _tmp870_;
							_tmp872_ = _vala_code_node_ref0 (_tmp871_);
							async_method = _tmp872_;
							is_valid_access = FALSE;
							_tmp873_ = async_method;
							if (_tmp873_ != NULL) {
								ValaMethod* _tmp874_;
								ValaMethod* _tmp875_;
								ValaMethod* _tmp876_;
								ValaMethod* _tmp877_;
								gboolean _tmp878_;
								_tmp874_ = m;
								_tmp875_ = async_method;
								_tmp876_ = vala_method_get_callback_method (_tmp875_);
								_tmp877_ = _tmp876_;
								_tmp878_ = _tmp874_ == _tmp877_;
								_vala_code_node_unref0 (_tmp877_);
								if (_tmp878_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp879_ = FALSE;
									ValaMethod* _tmp880_;
									ValaMethod* _tmp881_;
									ValaMethod* _tmp882_;
									_tmp880_ = async_method;
									_tmp881_ = vala_method_get_base_method (_tmp880_);
									_tmp882_ = _tmp881_;
									if (_tmp882_ != NULL) {
										ValaMethod* _tmp883_;
										ValaMethod* _tmp884_;
										ValaMethod* _tmp885_;
										ValaMethod* _tmp886_;
										ValaMethod* _tmp887_;
										ValaMethod* _tmp888_;
										_tmp883_ = m;
										_tmp884_ = async_method;
										_tmp885_ = vala_method_get_base_method (_tmp884_);
										_tmp886_ = _tmp885_;
										_tmp887_ = vala_method_get_callback_method (_tmp886_);
										_tmp888_ = _tmp887_;
										_tmp879_ = _tmp883_ == _tmp888_;
										_vala_code_node_unref0 (_tmp888_);
									} else {
										_tmp879_ = FALSE;
									}
									if (_tmp879_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp889_ = FALSE;
										ValaMethod* _tmp890_;
										ValaMethod* _tmp891_;
										ValaMethod* _tmp892_;
										_tmp890_ = async_method;
										_tmp891_ = vala_method_get_base_interface_method (_tmp890_);
										_tmp892_ = _tmp891_;
										if (_tmp892_ != NULL) {
											ValaMethod* _tmp893_;
											ValaMethod* _tmp894_;
											ValaMethod* _tmp895_;
											ValaMethod* _tmp896_;
											ValaMethod* _tmp897_;
											ValaMethod* _tmp898_;
											_tmp893_ = m;
											_tmp894_ = async_method;
											_tmp895_ = vala_method_get_base_interface_method (_tmp894_);
											_tmp896_ = _tmp895_;
											_tmp897_ = vala_method_get_callback_method (_tmp896_);
											_tmp898_ = _tmp897_;
											_tmp889_ = _tmp893_ == _tmp898_;
											_vala_code_node_unref0 (_tmp898_);
										} else {
											_tmp889_ = FALSE;
										}
										if (_tmp889_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp899_;
								ValaSourceReference* _tmp900_;
								ValaMethod* _tmp901_;
								gchar* _tmp902_;
								gchar* _tmp903_;
								gchar* _tmp904_;
								gchar* _tmp905_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp899_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp900_ = _tmp899_;
								_tmp901_ = m;
								_tmp902_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp901_);
								_tmp903_ = _tmp902_;
								_tmp904_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp903_);
								_tmp905_ = _tmp904_;
								vala_report_error (_tmp900_, _tmp905_);
								_g_free0 (_tmp905_);
								_g_free0 (_tmp903_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp906_ = async_method;
							_tmp907_ = vala_code_context_get_analyzer (context);
							_tmp908_ = _tmp907_;
							_tmp909_ = vala_semantic_analyzer_get_current_method (_tmp908_);
							_tmp910_ = _tmp909_;
							if (_tmp906_ != _tmp910_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp911_;
								ValaSemanticAnalyzer* _tmp912_;
								ValaMethod* _tmp913_;
								ValaMethod* _tmp914_;
								ValaSymbol* _tmp915_;
								ValaMethod* _tmp926_;
								ValaBlock* _tmp927_;
								ValaBlock* _tmp928_;
								_tmp911_ = vala_code_context_get_analyzer (context);
								_tmp912_ = _tmp911_;
								_tmp913_ = vala_semantic_analyzer_get_current_method (_tmp912_);
								_tmp914_ = _tmp913_;
								_tmp915_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp914_);
								sym = _tmp915_;
								while (TRUE) {
									ValaSymbol* _tmp916_;
									ValaMethod* _tmp917_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp918_;
									ValaMethod* _tmp919_;
									ValaMethod* _tmp920_;
									ValaSymbol* _tmp922_;
									ValaSymbol* _tmp923_;
									ValaSymbol* _tmp924_;
									ValaSymbol* _tmp925_;
									_tmp916_ = sym;
									_tmp917_ = async_method;
									if (!(_tmp916_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp917_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp918_ = sym;
									_tmp919_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp918_) ? ((ValaMethod*) _tmp918_) : NULL);
									method = _tmp919_;
									_tmp920_ = method;
									if (_tmp920_ != NULL) {
										ValaMethod* _tmp921_;
										_tmp921_ = method;
										vala_method_set_closure (_tmp921_, TRUE);
									}
									_tmp922_ = sym;
									_tmp923_ = vala_symbol_get_parent_symbol (_tmp922_);
									_tmp924_ = _tmp923_;
									_tmp925_ = _vala_code_node_ref0 (_tmp924_);
									_vala_code_node_unref0 (sym);
									sym = _tmp925_;
									_vala_code_node_unref0 (method);
								}
								_tmp926_ = async_method;
								_tmp927_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp926_);
								_tmp928_ = _tmp927_;
								vala_block_set_captured (_tmp928_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp929_ = async_method;
							_tmp930_ = vala_method_get_callback_method (_tmp929_);
							_vala_code_node_unref0 (m);
							m = _tmp930_;
							_tmp931_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp931_);
							_tmp932_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp933_ = _tmp932_;
							_tmp934_ = _vala_code_node_ref0 (_tmp933_);
							_vala_code_node_unref0 (member);
							member = _tmp934_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp935_;
							ValaMethod* _tmp936_;
							ValaMethod* _tmp937_;
							_tmp935_ = m;
							_tmp936_ = vala_method_get_base_method (_tmp935_);
							_tmp937_ = _tmp936_;
							if (_tmp937_ != NULL) {
								ValaMethod* _tmp938_;
								ValaMethod* _tmp939_;
								ValaMethod* _tmp940_;
								ValaMethod* _tmp941_;
								ValaMethod* _tmp942_;
								ValaSignal* _tmp943_;
								ValaSignal* _tmp944_;
								ValaSymbol* _tmp949_;
								ValaSymbol* _tmp950_;
								ValaSymbol* _tmp951_;
								_tmp938_ = m;
								_tmp939_ = vala_method_get_base_method (_tmp938_);
								_tmp940_ = _tmp939_;
								_tmp941_ = _vala_code_node_ref0 (_tmp940_);
								_vala_code_node_unref0 (m);
								m = _tmp941_;
								_tmp942_ = m;
								_tmp943_ = vala_method_get_signal_reference (_tmp942_);
								_tmp944_ = _tmp943_;
								if (_tmp944_ != NULL) {
									ValaMethod* _tmp945_;
									ValaSignal* _tmp946_;
									ValaSignal* _tmp947_;
									_tmp945_ = m;
									_tmp946_ = vala_method_get_signal_reference (_tmp945_);
									_tmp947_ = _tmp946_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp947_);
								} else {
									ValaMethod* _tmp948_;
									_tmp948_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp948_);
								}
								_tmp949_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp950_ = _tmp949_;
								_tmp951_ = _vala_code_node_ref0 (_tmp950_);
								_vala_code_node_unref0 (member);
								member = _tmp951_;
							} else {
								ValaMethod* _tmp952_;
								ValaMethod* _tmp953_;
								ValaMethod* _tmp954_;
								_tmp952_ = m;
								_tmp953_ = vala_method_get_base_interface_method (_tmp952_);
								_tmp954_ = _tmp953_;
								if (_tmp954_ != NULL) {
									ValaMethod* _tmp955_;
									ValaMethod* _tmp956_;
									ValaMethod* _tmp957_;
									ValaMethod* _tmp958_;
									ValaMethod* _tmp959_;
									ValaSignal* _tmp960_;
									ValaSignal* _tmp961_;
									ValaSymbol* _tmp966_;
									ValaSymbol* _tmp967_;
									ValaSymbol* _tmp968_;
									_tmp955_ = m;
									_tmp956_ = vala_method_get_base_interface_method (_tmp955_);
									_tmp957_ = _tmp956_;
									_tmp958_ = _vala_code_node_ref0 (_tmp957_);
									_vala_code_node_unref0 (m);
									m = _tmp958_;
									_tmp959_ = m;
									_tmp960_ = vala_method_get_signal_reference (_tmp959_);
									_tmp961_ = _tmp960_;
									if (_tmp961_ != NULL) {
										ValaMethod* _tmp962_;
										ValaSignal* _tmp963_;
										ValaSignal* _tmp964_;
										_tmp962_ = m;
										_tmp963_ = vala_method_get_signal_reference (_tmp962_);
										_tmp964_ = _tmp963_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp964_);
									} else {
										ValaMethod* _tmp965_;
										_tmp965_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp965_);
									}
									_tmp966_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp967_ = _tmp966_;
									_tmp968_ = _vala_code_node_ref0 (_tmp967_);
									_vala_code_node_unref0 (member);
									member = _tmp968_;
								}
							}
						}
						_tmp969_ = m;
						_tmp970_ = vala_symbol_get_access ((ValaSymbol*) _tmp969_);
						_tmp971_ = _tmp970_;
						access = _tmp971_;
						_tmp972_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp972_)) {
							ValaMethod* _tmp973_;
							ValaMemberBinding _tmp974_;
							ValaMemberBinding _tmp975_;
							_tmp973_ = m;
							_tmp974_ = vala_method_get_binding (_tmp973_);
							_tmp975_ = _tmp974_;
							instance = _tmp975_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp976_ = m;
						_tmp977_ = vala_method_get_binding (_tmp976_);
						_tmp978_ = _tmp977_;
						klass = _tmp978_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp979_;
							ValaList* _tmp980_;
							gint _param_size = 0;
							ValaList* _tmp981_;
							gint _tmp982_;
							gint _tmp983_;
							gint _param_index = 0;
							_tmp979_ = m;
							_tmp980_ = vala_callable_get_parameters ((ValaCallable*) _tmp979_);
							_param_list = _tmp980_;
							_tmp981_ = _param_list;
							_tmp982_ = vala_collection_get_size ((ValaCollection*) _tmp981_);
							_tmp983_ = _tmp982_;
							_param_size = _tmp983_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp984_;
								gpointer _tmp985_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp986_;
								ValaDataType* _tmp987_;
								ValaDataType* _tmp988_;
								ValaGenericType* _tmp989_;
								gboolean _tmp990_ = FALSE;
								ValaGenericType* _tmp991_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp984_ = _param_list;
								_tmp985_ = vala_list_get (_tmp984_, _param_index);
								param = (ValaParameter*) _tmp985_;
								_tmp986_ = param;
								_tmp987_ = vala_variable_get_variable_type ((ValaVariable*) _tmp986_);
								_tmp988_ = _tmp987_;
								_tmp989_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp988_) ? ((ValaGenericType*) _tmp988_) : NULL);
								generic_type = _tmp989_;
								_tmp991_ = generic_type;
								if (_tmp991_ != NULL) {
									ValaGenericType* _tmp992_;
									ValaTypeParameter* _tmp993_;
									ValaTypeParameter* _tmp994_;
									ValaSymbol* _tmp995_;
									ValaSymbol* _tmp996_;
									_tmp992_ = generic_type;
									_tmp993_ = vala_generic_type_get_type_parameter (_tmp992_);
									_tmp994_ = _tmp993_;
									_tmp995_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp994_);
									_tmp996_ = _tmp995_;
									_tmp990_ = VALA_IS_TYPESYMBOL (_tmp996_);
								} else {
									_tmp990_ = FALSE;
								}
								if (_tmp990_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp997_ = m;
						_tmp998_ = vala_callable_get_return_type ((ValaCallable*) _tmp997_);
						_tmp999_ = _tmp998_;
						_tmp1000_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp999_) ? ((ValaGenericType*) _tmp999_) : NULL);
						generic_type = _tmp1000_;
						_tmp1002_ = generic_type;
						if (_tmp1002_ != NULL) {
							ValaGenericType* _tmp1003_;
							ValaTypeParameter* _tmp1004_;
							ValaTypeParameter* _tmp1005_;
							ValaSymbol* _tmp1006_;
							ValaSymbol* _tmp1007_;
							_tmp1003_ = generic_type;
							_tmp1004_ = vala_generic_type_get_type_parameter (_tmp1003_);
							_tmp1005_ = _tmp1004_;
							_tmp1006_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1005_);
							_tmp1007_ = _tmp1006_;
							_tmp1001_ = VALA_IS_TYPESYMBOL (_tmp1007_);
						} else {
							_tmp1001_ = FALSE;
						}
						if (_tmp1001_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp1008_;
						_tmp1008_ = member;
						if (VALA_IS_PROPERTY (_tmp1008_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1009_;
							ValaProperty* _tmp1010_;
							ValaProperty* _tmp1011_;
							ValaProperty* _tmp1012_;
							ValaProperty* _tmp1013_;
							ValaProperty* _tmp1014_;
							ValaProperty* _tmp1034_;
							ValaSymbolAccessibility _tmp1035_;
							ValaSymbolAccessibility _tmp1036_;
							gboolean _tmp1037_;
							gboolean _tmp1038_;
							ValaProperty* _tmp1103_;
							ValaMemberBinding _tmp1104_;
							ValaMemberBinding _tmp1105_;
							ValaProperty* _tmp1106_;
							ValaDataType* _tmp1107_;
							ValaDataType* _tmp1108_;
							_tmp1009_ = member;
							_tmp1010_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1009_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp1010_;
							_tmp1011_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1011_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp1012_ = prop;
							_tmp1013_ = vala_property_get_base_property (_tmp1012_);
							_tmp1014_ = _tmp1013_;
							if (_tmp1014_ != NULL) {
								ValaProperty* _tmp1015_;
								ValaProperty* _tmp1016_;
								ValaProperty* _tmp1017_;
								ValaProperty* _tmp1018_;
								ValaProperty* _tmp1019_;
								ValaSymbol* _tmp1020_;
								ValaSymbol* _tmp1021_;
								ValaSymbol* _tmp1022_;
								_tmp1015_ = prop;
								_tmp1016_ = vala_property_get_base_property (_tmp1015_);
								_tmp1017_ = _tmp1016_;
								_tmp1018_ = _vala_code_node_ref0 (_tmp1017_);
								_vala_code_node_unref0 (prop);
								prop = _tmp1018_;
								_tmp1019_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1019_);
								_tmp1020_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1021_ = _tmp1020_;
								_tmp1022_ = _vala_code_node_ref0 (_tmp1021_);
								_vala_code_node_unref0 (member);
								member = _tmp1022_;
							} else {
								ValaProperty* _tmp1023_;
								ValaProperty* _tmp1024_;
								ValaProperty* _tmp1025_;
								_tmp1023_ = prop;
								_tmp1024_ = vala_property_get_base_interface_property (_tmp1023_);
								_tmp1025_ = _tmp1024_;
								if (_tmp1025_ != NULL) {
									ValaProperty* _tmp1026_;
									ValaProperty* _tmp1027_;
									ValaProperty* _tmp1028_;
									ValaProperty* _tmp1029_;
									ValaProperty* _tmp1030_;
									ValaSymbol* _tmp1031_;
									ValaSymbol* _tmp1032_;
									ValaSymbol* _tmp1033_;
									_tmp1026_ = prop;
									_tmp1027_ = vala_property_get_base_interface_property (_tmp1026_);
									_tmp1028_ = _tmp1027_;
									_tmp1029_ = _vala_code_node_ref0 (_tmp1028_);
									_vala_code_node_unref0 (prop);
									prop = _tmp1029_;
									_tmp1030_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1030_);
									_tmp1031_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1032_ = _tmp1031_;
									_tmp1033_ = _vala_code_node_ref0 (_tmp1032_);
									_vala_code_node_unref0 (member);
									member = _tmp1033_;
								}
							}
							_tmp1034_ = prop;
							_tmp1035_ = vala_symbol_get_access ((ValaSymbol*) _tmp1034_);
							_tmp1036_ = _tmp1035_;
							access = _tmp1036_;
							_tmp1037_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1038_ = _tmp1037_;
							if (_tmp1038_) {
								ValaProperty* _tmp1039_;
								ValaPropertyAccessor* _tmp1040_;
								ValaPropertyAccessor* _tmp1041_;
								ValaProperty* _tmp1049_;
								ValaSymbolAccessibility _tmp1050_;
								ValaSymbolAccessibility _tmp1051_;
								_tmp1039_ = prop;
								_tmp1040_ = vala_property_get_set_accessor (_tmp1039_);
								_tmp1041_ = _tmp1040_;
								if (_tmp1041_ == NULL) {
									ValaSourceReference* _tmp1042_;
									ValaSourceReference* _tmp1043_;
									ValaProperty* _tmp1044_;
									gchar* _tmp1045_;
									gchar* _tmp1046_;
									gchar* _tmp1047_;
									gchar* _tmp1048_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1042_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1043_ = _tmp1042_;
									_tmp1044_ = prop;
									_tmp1045_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1044_);
									_tmp1046_ = _tmp1045_;
									_tmp1047_ = g_strdup_printf ("Property `%s' is read-only", _tmp1046_);
									_tmp1048_ = _tmp1047_;
									vala_report_error (_tmp1043_, _tmp1048_);
									_g_free0 (_tmp1048_);
									_g_free0 (_tmp1046_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1049_ = prop;
								_tmp1050_ = vala_symbol_get_access ((ValaSymbol*) _tmp1049_);
								_tmp1051_ = _tmp1050_;
								if (_tmp1051_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1052_;
									ValaPropertyAccessor* _tmp1053_;
									ValaPropertyAccessor* _tmp1054_;
									ValaSymbolAccessibility _tmp1055_;
									ValaSymbolAccessibility _tmp1056_;
									_tmp1052_ = prop;
									_tmp1053_ = vala_property_get_set_accessor (_tmp1052_);
									_tmp1054_ = _tmp1053_;
									_tmp1055_ = vala_symbol_get_access ((ValaSymbol*) _tmp1054_);
									_tmp1056_ = _tmp1055_;
									access = _tmp1056_;
								} else {
									gboolean _tmp1057_ = FALSE;
									ValaProperty* _tmp1058_;
									ValaSymbolAccessibility _tmp1059_;
									ValaSymbolAccessibility _tmp1060_;
									_tmp1058_ = prop;
									_tmp1059_ = vala_symbol_get_access ((ValaSymbol*) _tmp1058_);
									_tmp1060_ = _tmp1059_;
									if (_tmp1060_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1061_;
										ValaPropertyAccessor* _tmp1062_;
										ValaPropertyAccessor* _tmp1063_;
										ValaSymbolAccessibility _tmp1064_;
										ValaSymbolAccessibility _tmp1065_;
										_tmp1061_ = prop;
										_tmp1062_ = vala_property_get_set_accessor (_tmp1061_);
										_tmp1063_ = _tmp1062_;
										_tmp1064_ = vala_symbol_get_access ((ValaSymbol*) _tmp1063_);
										_tmp1065_ = _tmp1064_;
										_tmp1057_ = _tmp1065_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1057_ = FALSE;
									}
									if (_tmp1057_) {
										ValaProperty* _tmp1066_;
										ValaPropertyAccessor* _tmp1067_;
										ValaPropertyAccessor* _tmp1068_;
										ValaSymbolAccessibility _tmp1069_;
										ValaSymbolAccessibility _tmp1070_;
										_tmp1066_ = prop;
										_tmp1067_ = vala_property_get_set_accessor (_tmp1066_);
										_tmp1068_ = _tmp1067_;
										_tmp1069_ = vala_symbol_get_access ((ValaSymbol*) _tmp1068_);
										_tmp1070_ = _tmp1069_;
										access = _tmp1070_;
									}
								}
							} else {
								ValaProperty* _tmp1071_;
								ValaPropertyAccessor* _tmp1072_;
								ValaPropertyAccessor* _tmp1073_;
								ValaProperty* _tmp1081_;
								ValaSymbolAccessibility _tmp1082_;
								ValaSymbolAccessibility _tmp1083_;
								_tmp1071_ = prop;
								_tmp1072_ = vala_property_get_get_accessor (_tmp1071_);
								_tmp1073_ = _tmp1072_;
								if (_tmp1073_ == NULL) {
									ValaSourceReference* _tmp1074_;
									ValaSourceReference* _tmp1075_;
									ValaProperty* _tmp1076_;
									gchar* _tmp1077_;
									gchar* _tmp1078_;
									gchar* _tmp1079_;
									gchar* _tmp1080_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1074_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1075_ = _tmp1074_;
									_tmp1076_ = prop;
									_tmp1077_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1076_);
									_tmp1078_ = _tmp1077_;
									_tmp1079_ = g_strdup_printf ("Property `%s' is write-only", _tmp1078_);
									_tmp1080_ = _tmp1079_;
									vala_report_error (_tmp1075_, _tmp1080_);
									_g_free0 (_tmp1080_);
									_g_free0 (_tmp1078_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1081_ = prop;
								_tmp1082_ = vala_symbol_get_access ((ValaSymbol*) _tmp1081_);
								_tmp1083_ = _tmp1082_;
								if (_tmp1083_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1084_;
									ValaPropertyAccessor* _tmp1085_;
									ValaPropertyAccessor* _tmp1086_;
									ValaSymbolAccessibility _tmp1087_;
									ValaSymbolAccessibility _tmp1088_;
									_tmp1084_ = prop;
									_tmp1085_ = vala_property_get_get_accessor (_tmp1084_);
									_tmp1086_ = _tmp1085_;
									_tmp1087_ = vala_symbol_get_access ((ValaSymbol*) _tmp1086_);
									_tmp1088_ = _tmp1087_;
									access = _tmp1088_;
								} else {
									gboolean _tmp1089_ = FALSE;
									ValaProperty* _tmp1090_;
									ValaSymbolAccessibility _tmp1091_;
									ValaSymbolAccessibility _tmp1092_;
									_tmp1090_ = prop;
									_tmp1091_ = vala_symbol_get_access ((ValaSymbol*) _tmp1090_);
									_tmp1092_ = _tmp1091_;
									if (_tmp1092_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1093_;
										ValaPropertyAccessor* _tmp1094_;
										ValaPropertyAccessor* _tmp1095_;
										ValaSymbolAccessibility _tmp1096_;
										ValaSymbolAccessibility _tmp1097_;
										_tmp1093_ = prop;
										_tmp1094_ = vala_property_get_get_accessor (_tmp1093_);
										_tmp1095_ = _tmp1094_;
										_tmp1096_ = vala_symbol_get_access ((ValaSymbol*) _tmp1095_);
										_tmp1097_ = _tmp1096_;
										_tmp1089_ = _tmp1097_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1089_ = FALSE;
									}
									if (_tmp1089_) {
										ValaProperty* _tmp1098_;
										ValaPropertyAccessor* _tmp1099_;
										ValaPropertyAccessor* _tmp1100_;
										ValaSymbolAccessibility _tmp1101_;
										ValaSymbolAccessibility _tmp1102_;
										_tmp1098_ = prop;
										_tmp1099_ = vala_property_get_get_accessor (_tmp1098_);
										_tmp1100_ = _tmp1099_;
										_tmp1101_ = vala_symbol_get_access ((ValaSymbol*) _tmp1100_);
										_tmp1102_ = _tmp1101_;
										access = _tmp1102_;
									}
								}
							}
							_tmp1103_ = prop;
							_tmp1104_ = vala_property_get_binding (_tmp1103_);
							_tmp1105_ = _tmp1104_;
							instance = _tmp1105_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1106_ = prop;
							_tmp1107_ = vala_property_get_property_type (_tmp1106_);
							_tmp1108_ = _tmp1107_;
							if (VALA_IS_GENERIC_TYPE (_tmp1108_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1109_;
							_tmp1109_ = member;
							if (VALA_IS_SIGNAL (_tmp1109_)) {
								ValaSymbol* _tmp1110_;
								ValaSymbolAccessibility _tmp1111_;
								ValaSymbolAccessibility _tmp1112_;
								instance = TRUE;
								_tmp1110_ = member;
								_tmp1111_ = vala_symbol_get_access (_tmp1110_);
								_tmp1112_ = _tmp1111_;
								access = _tmp1112_;
							} else {
								gboolean _tmp1113_ = FALSE;
								gboolean _tmp1114_;
								_tmp1114_ = self->priv->_creation_member;
								if (!_tmp1114_) {
									ValaSymbol* _tmp1115_;
									_tmp1115_ = member;
									_tmp1113_ = VALA_IS_ERROR_CODE (_tmp1115_);
								} else {
									_tmp1113_ = FALSE;
								}
								if (_tmp1113_) {
									ValaSymbol* _tmp1116_;
									ValaConstant* _tmp1117_;
									ValaConstant* _tmp1118_;
									ValaSymbol* _tmp1119_;
									ValaSymbol* _tmp1120_;
									ValaSymbol* _tmp1121_;
									_tmp1116_ = member;
									_tmp1117_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1116_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1118_ = _tmp1117_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1118_);
									_tmp1119_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1120_ = _tmp1119_;
									_tmp1121_ = _vala_code_node_ref0 (_tmp1120_);
									_vala_code_node_unref0 (member);
									member = _tmp1121_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1122_ = member;
	vala_symbol_set_used (_tmp1122_, TRUE);
	_tmp1123_ = member;
	_tmp1124_ = vala_symbol_get_version (_tmp1123_);
	_tmp1125_ = _tmp1124_;
	_tmp1126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1127_ = _tmp1126_;
	vala_version_attribute_check (_tmp1125_, _tmp1127_);
	_tmp1129_ = access;
	if (_tmp1129_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1130_;
		ValaSymbol* _tmp1131_;
		ValaSymbol* _tmp1132_;
		_tmp1130_ = member;
		_tmp1131_ = vala_symbol_get_parent_symbol (_tmp1130_);
		_tmp1132_ = _tmp1131_;
		_tmp1128_ = VALA_IS_TYPESYMBOL (_tmp1132_);
	} else {
		_tmp1128_ = FALSE;
	}
	if (_tmp1128_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1133_;
		ValaSymbol* _tmp1134_;
		ValaSymbol* _tmp1135_;
		ValaTypeSymbol* _tmp1136_;
		gboolean in_subtype = FALSE;
		_tmp1133_ = member;
		_tmp1134_ = vala_symbol_get_parent_symbol (_tmp1133_);
		_tmp1135_ = _tmp1134_;
		_tmp1136_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1135_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1136_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1137_;
			ValaSemanticAnalyzer* _tmp1138_;
			ValaSymbol* _tmp1139_;
			ValaSymbol* _tmp1140_;
			ValaSymbol* _tmp1141_;
			_tmp1137_ = vala_code_context_get_analyzer (context);
			_tmp1138_ = _tmp1137_;
			_tmp1139_ = vala_semantic_analyzer_get_current_symbol (_tmp1138_);
			_tmp1140_ = _tmp1139_;
			_tmp1141_ = _vala_code_node_ref0 (_tmp1140_);
			this_symbol = _tmp1141_;
			{
				gboolean _tmp1142_ = FALSE;
				_tmp1142_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1147_;
					ValaSymbol* _tmp1148_;
					ValaTypeSymbol* _tmp1149_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1150_;
					ValaClass* _tmp1151_;
					gboolean _tmp1152_ = FALSE;
					ValaClass* _tmp1153_;
					if (!_tmp1142_) {
						ValaSymbol* _tmp1143_;
						ValaSymbol* _tmp1144_;
						ValaSymbol* _tmp1145_;
						ValaSymbol* _tmp1146_;
						_tmp1143_ = this_symbol;
						_tmp1144_ = vala_symbol_get_parent_symbol (_tmp1143_);
						_tmp1145_ = _tmp1144_;
						_tmp1146_ = _vala_code_node_ref0 (_tmp1145_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1146_;
					}
					_tmp1142_ = FALSE;
					_tmp1147_ = this_symbol;
					if (!(_tmp1147_ != NULL)) {
						break;
					}
					_tmp1148_ = this_symbol;
					_tmp1149_ = target_type;
					if (_tmp1148_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1149_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1150_ = this_symbol;
					_tmp1151_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1150_) ? ((ValaClass*) _tmp1150_) : NULL);
					cl = _tmp1151_;
					_tmp1153_ = cl;
					if (_tmp1153_ != NULL) {
						ValaClass* _tmp1154_;
						ValaTypeSymbol* _tmp1155_;
						_tmp1154_ = cl;
						_tmp1155_ = target_type;
						_tmp1152_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1154_, _tmp1155_);
					} else {
						_tmp1152_ = FALSE;
					}
					if (_tmp1152_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1156_;
			ValaSourceReference* _tmp1157_;
			ValaSymbol* _tmp1158_;
			gchar* _tmp1159_;
			gchar* _tmp1160_;
			gchar* _tmp1161_;
			gchar* _tmp1162_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1157_ = _tmp1156_;
			_tmp1158_ = member;
			_tmp1159_ = vala_symbol_get_full_name (_tmp1158_);
			_tmp1160_ = _tmp1159_;
			_tmp1161_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1160_);
			_tmp1162_ = _tmp1161_;
			vala_report_error (_tmp1157_, _tmp1162_);
			_g_free0 (_tmp1162_);
			_g_free0 (_tmp1160_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1163_;
		_tmp1163_ = access;
		if (_tmp1163_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1164_;
			ValaSymbol* _tmp1165_;
			ValaSymbol* _tmp1166_;
			ValaSymbol* _tmp1167_;
			gboolean in_target_type = FALSE;
			_tmp1164_ = member;
			_tmp1165_ = vala_symbol_get_parent_symbol (_tmp1164_);
			_tmp1166_ = _tmp1165_;
			_tmp1167_ = _vala_code_node_ref0 (_tmp1166_);
			target_type = _tmp1167_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1168_;
				ValaSemanticAnalyzer* _tmp1169_;
				ValaSymbol* _tmp1170_;
				ValaSymbol* _tmp1171_;
				ValaSymbol* _tmp1172_;
				_tmp1168_ = vala_code_context_get_analyzer (context);
				_tmp1169_ = _tmp1168_;
				_tmp1170_ = vala_semantic_analyzer_get_current_symbol (_tmp1169_);
				_tmp1171_ = _tmp1170_;
				_tmp1172_ = _vala_code_node_ref0 (_tmp1171_);
				this_symbol = _tmp1172_;
				{
					gboolean _tmp1173_ = FALSE;
					_tmp1173_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1178_;
						ValaSymbol* _tmp1179_;
						ValaSymbol* _tmp1180_;
						if (!_tmp1173_) {
							ValaSymbol* _tmp1174_;
							ValaSymbol* _tmp1175_;
							ValaSymbol* _tmp1176_;
							ValaSymbol* _tmp1177_;
							_tmp1174_ = this_symbol;
							_tmp1175_ = vala_symbol_get_parent_symbol (_tmp1174_);
							_tmp1176_ = _tmp1175_;
							_tmp1177_ = _vala_code_node_ref0 (_tmp1176_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1177_;
						}
						_tmp1173_ = FALSE;
						_tmp1178_ = this_symbol;
						if (!(_tmp1178_ != NULL)) {
							break;
						}
						_tmp1179_ = target_type;
						_tmp1180_ = this_symbol;
						if (_tmp1179_ == _tmp1180_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1181_;
				ValaSourceReference* _tmp1182_;
				ValaSymbol* _tmp1183_;
				gchar* _tmp1184_;
				gchar* _tmp1185_;
				gchar* _tmp1186_;
				gchar* _tmp1187_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1182_ = _tmp1181_;
				_tmp1183_ = member;
				_tmp1184_ = vala_symbol_get_full_name (_tmp1183_);
				_tmp1185_ = _tmp1184_;
				_tmp1186_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1185_);
				_tmp1187_ = _tmp1186_;
				vala_report_error (_tmp1182_, _tmp1187_);
				_g_free0 (_tmp1187_);
				_g_free0 (_tmp1185_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1189_;
		ValaExpression* _tmp1190_;
		_tmp1189_ = vala_member_access_get_inner (self);
		_tmp1190_ = _tmp1189_;
		_tmp1188_ = _tmp1190_ != NULL;
	} else {
		_tmp1188_ = FALSE;
	}
	if (_tmp1188_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1191_;
		ValaExpression* _tmp1192_;
		ValaDataType* _tmp1193_;
		ValaDataType* _tmp1194_;
		ValaDataType* _tmp1195_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1196_;
		ValaExpression* _tmp1197_;
		ValaDataType* _tmp1198_;
		ValaDataType* _tmp1199_;
		ValaPointerType* _tmp1200_;
		ValaPointerType* _tmp1201_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1206_;
		ValaObjectType* _tmp1207_;
		gboolean _tmp1208_ = FALSE;
		gboolean _tmp1209_ = FALSE;
		ValaObjectType* _tmp1210_;
		_tmp1191_ = vala_member_access_get_inner (self);
		_tmp1192_ = _tmp1191_;
		_tmp1193_ = vala_expression_get_value_type (_tmp1192_);
		_tmp1194_ = _tmp1193_;
		_tmp1195_ = _vala_code_node_ref0 (_tmp1194_);
		instance_type = _tmp1195_;
		_tmp1196_ = vala_member_access_get_inner (self);
		_tmp1197_ = _tmp1196_;
		_tmp1198_ = vala_expression_get_value_type (_tmp1197_);
		_tmp1199_ = _tmp1198_;
		_tmp1200_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1199_) ? ((ValaPointerType*) _tmp1199_) : NULL);
		pointer_type = _tmp1200_;
		_tmp1201_ = pointer_type;
		if (_tmp1201_ != NULL) {
			ValaPointerType* _tmp1202_;
			ValaDataType* _tmp1203_;
			ValaDataType* _tmp1204_;
			ValaDataType* _tmp1205_;
			_tmp1202_ = pointer_type;
			_tmp1203_ = vala_pointer_type_get_base_type (_tmp1202_);
			_tmp1204_ = _tmp1203_;
			_tmp1205_ = _vala_code_node_ref0 (_tmp1204_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1205_;
		}
		_tmp1206_ = instance_type;
		_tmp1207_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1206_) ? ((ValaObjectType*) _tmp1206_) : NULL);
		object_type = _tmp1207_;
		_tmp1210_ = object_type;
		if (_tmp1210_ != NULL) {
			ValaObjectType* _tmp1211_;
			ValaObjectTypeSymbol* _tmp1212_;
			ValaObjectTypeSymbol* _tmp1213_;
			_tmp1211_ = object_type;
			_tmp1212_ = vala_object_type_get_type_symbol (_tmp1211_);
			_tmp1213_ = _tmp1212_;
			_tmp1209_ = vala_object_type_symbol_has_type_parameters (_tmp1213_);
		} else {
			_tmp1209_ = FALSE;
		}
		if (_tmp1209_) {
			ValaDataType* _tmp1214_;
			_tmp1214_ = instance_type;
			_tmp1208_ = !vala_data_type_has_type_arguments (_tmp1214_);
		} else {
			_tmp1208_ = FALSE;
		}
		if (_tmp1208_) {
			ValaExpression* _tmp1215_;
			ValaExpression* _tmp1216_;
			ValaSourceReference* _tmp1217_;
			ValaSourceReference* _tmp1218_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1215_ = vala_member_access_get_inner (self);
			_tmp1216_ = _tmp1215_;
			_tmp1217_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1216_);
			_tmp1218_ = _tmp1217_;
			vala_report_error (_tmp1218_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1220_ = !may_access_instance_members;
	} else {
		_tmp1220_ = FALSE;
	}
	if (_tmp1220_) {
		_tmp1219_ = TRUE;
	} else {
		gboolean _tmp1221_ = FALSE;
		if (klass) {
			_tmp1221_ = !may_access_klass_members;
		} else {
			_tmp1221_ = FALSE;
		}
		_tmp1219_ = _tmp1221_;
	}
	if (_tmp1219_) {
		ValaSymbol* _tmp1222_;
		ValaSymbol* _tmp1223_;
		ValaDataType* _tmp1246_;
		ValaDataType* _tmp1247_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1222_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1223_ = _tmp1222_;
		if (VALA_IS_METHOD (_tmp1223_)) {
			ValaSemanticAnalyzer* _tmp1224_;
			ValaSemanticAnalyzer* _tmp1225_;
			ValaSymbol* _tmp1226_;
			ValaSymbol* _tmp1227_;
			gboolean _tmp1228_;
			gboolean _tmp1229_;
			ValaDataType* _tmp1230_;
			ValaDataType* _tmp1231_;
			_tmp1224_ = vala_code_context_get_analyzer (context);
			_tmp1225_ = _tmp1224_;
			_tmp1226_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1227_ = _tmp1226_;
			_tmp1228_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1229_ = _tmp1228_;
			_tmp1230_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1225_, _tmp1227_, _tmp1229_);
			_tmp1231_ = _tmp1230_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1231_);
			_vala_code_node_unref0 (_tmp1231_);
		} else {
			ValaSymbol* _tmp1232_;
			ValaSymbol* _tmp1233_;
			_tmp1232_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1233_ = _tmp1232_;
			if (VALA_IS_FIELD (_tmp1233_)) {
				ValaSymbol* _tmp1234_;
				ValaSymbol* _tmp1235_;
				ValaFieldPrototype* _tmp1236_;
				ValaFieldPrototype* _tmp1237_;
				_tmp1234_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1235_ = _tmp1234_;
				_tmp1236_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1235_, VALA_TYPE_FIELD, ValaField));
				_tmp1237_ = _tmp1236_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1237_);
				_vala_code_node_unref0 (_tmp1237_);
			} else {
				ValaSymbol* _tmp1238_;
				ValaSymbol* _tmp1239_;
				_tmp1238_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1239_ = _tmp1238_;
				if (VALA_IS_PROPERTY (_tmp1239_)) {
					ValaSymbol* _tmp1240_;
					ValaSymbol* _tmp1241_;
					ValaPropertyPrototype* _tmp1242_;
					ValaPropertyPrototype* _tmp1243_;
					_tmp1240_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1241_ = _tmp1240_;
					_tmp1242_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1241_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1243_ = _tmp1242_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1243_);
					_vala_code_node_unref0 (_tmp1243_);
				} else {
					ValaInvalidType* _tmp1244_;
					ValaInvalidType* _tmp1245_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1244_ = vala_invalid_type_new ();
					_tmp1245_ = _tmp1244_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1245_);
					_vala_code_node_unref0 (_tmp1245_);
				}
			}
		}
		_tmp1246_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1247_ = _tmp1246_;
		if (_tmp1247_ != NULL) {
			ValaDataType* _tmp1248_;
			ValaDataType* _tmp1249_;
			ValaDataType* _tmp1250_;
			ValaDataType* _tmp1251_;
			gboolean _tmp1252_;
			gboolean _tmp1253_;
			_tmp1248_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1249_ = _tmp1248_;
			_tmp1250_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1251_ = _tmp1250_;
			_tmp1252_ = vala_data_type_get_value_owned (_tmp1251_);
			_tmp1253_ = _tmp1252_;
			vala_data_type_set_value_owned (_tmp1249_, _tmp1253_);
		}
	} else {
		gboolean _tmp1254_ = FALSE;
		gboolean _tmp1275_ = FALSE;
		gboolean _tmp1276_ = FALSE;
		gboolean _tmp1277_ = FALSE;
		gboolean _tmp1278_ = FALSE;
		gboolean _tmp1320_ = FALSE;
		gboolean _tmp1321_ = FALSE;
		gboolean _tmp1322_ = FALSE;
		gboolean _tmp1323_ = FALSE;
		gboolean _tmp1324_ = FALSE;
		gboolean _tmp1325_;
		gboolean _tmp1326_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1353_;
		ValaSymbol* _tmp1354_;
		ValaMethod* _tmp1355_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1356_;
		ValaExpression* _tmp1357_;
		ValaMemberAccess* _tmp1358_;
		gboolean _tmp1359_ = FALSE;
		gboolean _tmp1360_ = FALSE;
		gboolean _tmp1361_ = FALSE;
		gboolean _tmp1362_ = FALSE;
		gboolean _tmp1363_ = FALSE;
		ValaMethod* _tmp1364_;
		ValaSemanticAnalyzer* _tmp1401_;
		ValaSemanticAnalyzer* _tmp1402_;
		ValaSymbol* _tmp1403_;
		ValaSymbol* _tmp1404_;
		gboolean _tmp1405_;
		gboolean _tmp1406_;
		ValaDataType* _tmp1407_;
		ValaDataType* _tmp1408_;
		gboolean _tmp1409_ = FALSE;
		ValaExpression* _tmp1410_;
		ValaExpression* _tmp1411_;
		ValaSymbol* _tmp1424_;
		ValaSymbol* _tmp1425_;
		if (instance) {
			ValaExpression* _tmp1255_;
			ValaExpression* _tmp1256_;
			_tmp1255_ = vala_member_access_get_inner (self);
			_tmp1256_ = _tmp1255_;
			_tmp1254_ = _tmp1256_ == NULL;
		} else {
			_tmp1254_ = FALSE;
		}
		if (_tmp1254_) {
			ValaSourceReference* _tmp1257_;
			ValaSourceReference* _tmp1258_;
			ValaMemberAccess* _tmp1259_;
			ValaMemberAccess* _tmp1260_;
			ValaExpression* _tmp1261_;
			ValaExpression* _tmp1262_;
			ValaParameter* _tmp1263_;
			ValaDataType* _tmp1264_;
			ValaDataType* _tmp1265_;
			ValaDataType* _tmp1266_;
			ValaDataType* _tmp1267_;
			ValaExpression* _tmp1268_;
			ValaExpression* _tmp1269_;
			ValaDataType* _tmp1270_;
			ValaDataType* _tmp1271_;
			ValaExpression* _tmp1272_;
			ValaExpression* _tmp1273_;
			ValaParameter* _tmp1274_;
			_tmp1257_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1258_ = _tmp1257_;
			_tmp1259_ = vala_member_access_new (NULL, "this", _tmp1258_);
			_tmp1260_ = _tmp1259_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1260_);
			_vala_code_node_unref0 (_tmp1260_);
			_tmp1261_ = vala_member_access_get_inner (self);
			_tmp1262_ = _tmp1261_;
			_tmp1263_ = this_parameter;
			_tmp1264_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1263_);
			_tmp1265_ = _tmp1264_;
			_tmp1266_ = vala_data_type_copy (_tmp1265_);
			_tmp1267_ = _tmp1266_;
			vala_expression_set_value_type (_tmp1262_, _tmp1267_);
			_vala_code_node_unref0 (_tmp1267_);
			_tmp1268_ = vala_member_access_get_inner (self);
			_tmp1269_ = _tmp1268_;
			_tmp1270_ = vala_expression_get_value_type (_tmp1269_);
			_tmp1271_ = _tmp1270_;
			vala_data_type_set_value_owned (_tmp1271_, FALSE);
			_tmp1272_ = vala_member_access_get_inner (self);
			_tmp1273_ = _tmp1272_;
			_tmp1274_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1273_, (ValaSymbol*) _tmp1274_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1278_ = !klass;
		} else {
			_tmp1278_ = FALSE;
		}
		if (_tmp1278_) {
			ValaSymbol* _tmp1279_;
			ValaSymbol* _tmp1280_;
			_tmp1279_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1280_ = _tmp1279_;
			_tmp1277_ = !VALA_IS_CREATION_METHOD (_tmp1280_);
		} else {
			_tmp1277_ = FALSE;
		}
		if (_tmp1277_) {
			_tmp1276_ = may_access_instance_members;
		} else {
			_tmp1276_ = FALSE;
		}
		if (_tmp1276_) {
			ValaExpression* _tmp1281_;
			ValaExpression* _tmp1282_;
			_tmp1281_ = vala_member_access_get_inner (self);
			_tmp1282_ = _tmp1281_;
			_tmp1275_ = _tmp1282_ != NULL;
		} else {
			_tmp1275_ = FALSE;
		}
		if (_tmp1275_) {
			ValaExpression* _tmp1283_;
			ValaExpression* _tmp1284_;
			ValaSymbol* _tmp1285_;
			ValaSymbol* _tmp1286_;
			_tmp1283_ = vala_member_access_get_inner (self);
			_tmp1284_ = _tmp1283_;
			_tmp1285_ = vala_expression_get_symbol_reference (_tmp1284_);
			_tmp1286_ = _tmp1285_;
			if (VALA_IS_METHOD (_tmp1286_)) {
			} else {
				ValaSourceReference* _tmp1287_;
				ValaSourceReference* _tmp1288_;
				ValaSymbol* _tmp1289_;
				ValaSymbol* _tmp1290_;
				gchar* _tmp1291_;
				gchar* _tmp1292_;
				gchar* _tmp1293_;
				gchar* _tmp1294_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1295_;
				ValaSymbol* _tmp1296_;
				ValaSymbol* _tmp1297_;
				ValaSymbol* _tmp1298_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1318_;
				ValaExpression* _tmp1319_;
				_tmp1287_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1288_ = _tmp1287_;
				_tmp1289_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1290_ = _tmp1289_;
				_tmp1291_ = vala_symbol_get_full_name (_tmp1290_);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1292_);
				_tmp1294_ = _tmp1293_;
				vala_report_warning (_tmp1288_, _tmp1294_);
				_g_free0 (_tmp1294_);
				_g_free0 (_tmp1292_);
				_tmp1295_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1296_ = _tmp1295_;
				_tmp1297_ = vala_symbol_get_parent_symbol (_tmp1296_);
				_tmp1298_ = _tmp1297_;
				inner_sym = _tmp1298_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1299_ = FALSE;
					ValaSymbol* _tmp1300_;
					ValaMemberAccess* _tmp1304_;
					ValaSymbol* _tmp1305_;
					const gchar* _tmp1306_;
					const gchar* _tmp1307_;
					ValaSourceReference* _tmp1308_;
					ValaSourceReference* _tmp1309_;
					ValaMemberAccess* _tmp1310_;
					ValaMemberAccess* _tmp1311_;
					ValaMemberAccess* _tmp1312_;
					ValaExpression* _tmp1313_;
					ValaExpression* _tmp1314_;
					ValaSymbol* _tmp1315_;
					ValaSymbol* _tmp1316_;
					ValaSymbol* _tmp1317_;
					_tmp1300_ = inner_sym;
					if (_tmp1300_ != NULL) {
						ValaSymbol* _tmp1301_;
						const gchar* _tmp1302_;
						const gchar* _tmp1303_;
						_tmp1301_ = inner_sym;
						_tmp1302_ = vala_symbol_get_name (_tmp1301_);
						_tmp1303_ = _tmp1302_;
						_tmp1299_ = _tmp1303_ != NULL;
					} else {
						_tmp1299_ = FALSE;
					}
					if (!_tmp1299_) {
						break;
					}
					_tmp1304_ = inner_ma;
					_tmp1305_ = inner_sym;
					_tmp1306_ = vala_symbol_get_name (_tmp1305_);
					_tmp1307_ = _tmp1306_;
					_tmp1308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1309_ = _tmp1308_;
					_tmp1310_ = vala_member_access_new (NULL, _tmp1307_, _tmp1309_);
					_tmp1311_ = _tmp1310_;
					vala_member_access_set_inner (_tmp1304_, (ValaExpression*) _tmp1311_);
					_vala_code_node_unref0 (_tmp1311_);
					_tmp1312_ = inner_ma;
					_tmp1313_ = vala_member_access_get_inner (_tmp1312_);
					_tmp1314_ = _tmp1313_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1314_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1315_ = inner_sym;
					_tmp1316_ = vala_symbol_get_parent_symbol (_tmp1315_);
					_tmp1317_ = _tmp1316_;
					inner_sym = _tmp1317_;
				}
				_tmp1318_ = vala_member_access_get_inner (self);
				_tmp1319_ = _tmp1318_;
				vala_code_node_check ((ValaCodeNode*) _tmp1319_, context);
			}
		}
		_tmp1325_ = vala_code_context_get_experimental_non_null (context);
		_tmp1326_ = _tmp1325_;
		if (_tmp1326_) {
			_tmp1324_ = instance;
		} else {
			_tmp1324_ = FALSE;
		}
		if (_tmp1324_) {
			ValaExpression* _tmp1327_;
			ValaExpression* _tmp1328_;
			ValaDataType* _tmp1329_;
			ValaDataType* _tmp1330_;
			gboolean _tmp1331_;
			gboolean _tmp1332_;
			_tmp1327_ = vala_member_access_get_inner (self);
			_tmp1328_ = _tmp1327_;
			_tmp1329_ = vala_expression_get_value_type (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			_tmp1331_ = vala_data_type_get_nullable (_tmp1330_);
			_tmp1332_ = _tmp1331_;
			_tmp1323_ = _tmp1332_;
		} else {
			_tmp1323_ = FALSE;
		}
		if (_tmp1323_) {
			ValaExpression* _tmp1333_;
			ValaExpression* _tmp1334_;
			ValaDataType* _tmp1335_;
			ValaDataType* _tmp1336_;
			_tmp1333_ = vala_member_access_get_inner (self);
			_tmp1334_ = _tmp1333_;
			_tmp1335_ = vala_expression_get_value_type (_tmp1334_);
			_tmp1336_ = _tmp1335_;
			_tmp1322_ = !VALA_IS_POINTER_TYPE (_tmp1336_);
		} else {
			_tmp1322_ = FALSE;
		}
		if (_tmp1322_) {
			ValaExpression* _tmp1337_;
			ValaExpression* _tmp1338_;
			ValaDataType* _tmp1339_;
			ValaDataType* _tmp1340_;
			_tmp1337_ = vala_member_access_get_inner (self);
			_tmp1338_ = _tmp1337_;
			_tmp1339_ = vala_expression_get_value_type (_tmp1338_);
			_tmp1340_ = _tmp1339_;
			_tmp1321_ = !VALA_IS_GENERIC_TYPE (_tmp1340_);
		} else {
			_tmp1321_ = FALSE;
		}
		if (_tmp1321_) {
			ValaExpression* _tmp1341_;
			ValaExpression* _tmp1342_;
			ValaDataType* _tmp1343_;
			ValaDataType* _tmp1344_;
			_tmp1341_ = vala_member_access_get_inner (self);
			_tmp1342_ = _tmp1341_;
			_tmp1343_ = vala_expression_get_value_type (_tmp1342_);
			_tmp1344_ = _tmp1343_;
			_tmp1320_ = !VALA_IS_ARRAY_TYPE (_tmp1344_);
		} else {
			_tmp1320_ = FALSE;
		}
		if (_tmp1320_) {
			ValaSourceReference* _tmp1345_;
			ValaSourceReference* _tmp1346_;
			ValaSymbol* _tmp1347_;
			ValaSymbol* _tmp1348_;
			gchar* _tmp1349_;
			gchar* _tmp1350_;
			gchar* _tmp1351_;
			gchar* _tmp1352_;
			_tmp1345_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1346_ = _tmp1345_;
			_tmp1347_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1348_ = _tmp1347_;
			_tmp1349_ = vala_symbol_get_full_name (_tmp1348_);
			_tmp1350_ = _tmp1349_;
			_tmp1351_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1350_);
			_tmp1352_ = _tmp1351_;
			vala_report_error (_tmp1346_, _tmp1352_);
			_g_free0 (_tmp1352_);
			_g_free0 (_tmp1350_);
		}
		_tmp1353_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1354_ = _tmp1353_;
		_tmp1355_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1354_) ? ((ValaMethod*) _tmp1354_) : NULL);
		m = _tmp1355_;
		_tmp1356_ = vala_member_access_get_inner (self);
		_tmp1357_ = _tmp1356_;
		_tmp1358_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1357_) ? ((ValaMemberAccess*) _tmp1357_) : NULL);
		inner_ma = _tmp1358_;
		_tmp1364_ = m;
		if (_tmp1364_ != NULL) {
			ValaMethod* _tmp1365_;
			ValaMemberBinding _tmp1366_;
			ValaMemberBinding _tmp1367_;
			_tmp1365_ = m;
			_tmp1366_ = vala_method_get_binding (_tmp1365_);
			_tmp1367_ = _tmp1366_;
			_tmp1363_ = _tmp1367_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1363_ = FALSE;
		}
		if (_tmp1363_) {
			ValaMethod* _tmp1368_;
			ValaSymbol* _tmp1369_;
			ValaSymbol* _tmp1370_;
			_tmp1368_ = m;
			_tmp1369_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1368_);
			_tmp1370_ = _tmp1369_;
			_tmp1362_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1370_);
		} else {
			_tmp1362_ = FALSE;
		}
		if (_tmp1362_) {
			ValaExpression* _tmp1371_;
			ValaExpression* _tmp1372_;
			_tmp1371_ = vala_member_access_get_inner (self);
			_tmp1372_ = _tmp1371_;
			_tmp1361_ = _tmp1372_ != NULL;
		} else {
			_tmp1361_ = FALSE;
		}
		if (_tmp1361_) {
			ValaExpression* _tmp1373_;
			ValaExpression* _tmp1374_;
			ValaDataType* _tmp1375_;
			ValaDataType* _tmp1376_;
			_tmp1373_ = vala_member_access_get_inner (self);
			_tmp1374_ = _tmp1373_;
			_tmp1375_ = vala_expression_get_value_type (_tmp1374_);
			_tmp1376_ = _tmp1375_;
			_tmp1360_ = _tmp1376_ == NULL;
		} else {
			_tmp1360_ = FALSE;
		}
		if (_tmp1360_) {
			ValaMemberAccess* _tmp1377_;
			ValaList* _tmp1378_;
			gint _tmp1379_;
			gint _tmp1380_;
			_tmp1377_ = inner_ma;
			_tmp1378_ = _tmp1377_->priv->type_argument_list;
			_tmp1379_ = vala_collection_get_size ((ValaCollection*) _tmp1378_);
			_tmp1380_ = _tmp1379_;
			_tmp1359_ = _tmp1380_ > 0;
		} else {
			_tmp1359_ = FALSE;
		}
		if (_tmp1359_) {
			ValaExpression* _tmp1381_;
			ValaExpression* _tmp1382_;
			ValaMethod* _tmp1383_;
			ValaSymbol* _tmp1384_;
			ValaSymbol* _tmp1385_;
			ValaObjectType* _tmp1386_;
			ValaObjectType* _tmp1387_;
			_tmp1381_ = vala_member_access_get_inner (self);
			_tmp1382_ = _tmp1381_;
			_tmp1383_ = m;
			_tmp1384_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1383_);
			_tmp1385_ = _tmp1384_;
			_tmp1386_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1385_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1387_ = _tmp1386_;
			vala_expression_set_value_type (_tmp1382_, (ValaDataType*) _tmp1387_);
			_vala_code_node_unref0 (_tmp1387_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1388_;
				ValaList* _tmp1389_;
				ValaList* _tmp1390_;
				gint _type_argument_size = 0;
				ValaList* _tmp1391_;
				gint _tmp1392_;
				gint _tmp1393_;
				gint _type_argument_index = 0;
				_tmp1388_ = inner_ma;
				_tmp1389_ = _tmp1388_->priv->type_argument_list;
				_tmp1390_ = _vala_iterable_ref0 (_tmp1389_);
				_type_argument_list = _tmp1390_;
				_tmp1391_ = _type_argument_list;
				_tmp1392_ = vala_collection_get_size ((ValaCollection*) _tmp1391_);
				_tmp1393_ = _tmp1392_;
				_type_argument_size = _tmp1393_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1394_;
					gpointer _tmp1395_;
					ValaExpression* _tmp1396_;
					ValaExpression* _tmp1397_;
					ValaDataType* _tmp1398_;
					ValaDataType* _tmp1399_;
					ValaDataType* _tmp1400_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1394_ = _type_argument_list;
					_tmp1395_ = vala_list_get (_tmp1394_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1395_;
					_tmp1396_ = vala_member_access_get_inner (self);
					_tmp1397_ = _tmp1396_;
					_tmp1398_ = vala_expression_get_value_type (_tmp1397_);
					_tmp1399_ = _tmp1398_;
					_tmp1400_ = type_argument;
					vala_data_type_add_type_argument (_tmp1399_, _tmp1400_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1401_ = vala_code_context_get_analyzer (context);
		_tmp1402_ = _tmp1401_;
		_tmp1403_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1404_ = _tmp1403_;
		_tmp1405_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1406_ = _tmp1405_;
		_tmp1407_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1402_, _tmp1404_, _tmp1406_);
		_tmp1408_ = _tmp1407_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1408_);
		_vala_code_node_unref0 (_tmp1408_);
		_tmp1410_ = vala_member_access_get_inner (self);
		_tmp1411_ = _tmp1410_;
		if (_tmp1411_ != NULL) {
			ValaDataType* _tmp1412_;
			ValaDataType* _tmp1413_;
			_tmp1412_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1413_ = _tmp1412_;
			_tmp1409_ = _tmp1413_ != NULL;
		} else {
			_tmp1409_ = FALSE;
		}
		if (_tmp1409_) {
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			ValaExpression* _tmp1416_;
			ValaExpression* _tmp1417_;
			ValaDataType* _tmp1418_;
			ValaDataType* _tmp1419_;
			ValaDataType* _tmp1420_;
			ValaDataType* _tmp1421_;
			_tmp1414_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1415_ = _tmp1414_;
			_tmp1416_ = vala_member_access_get_inner (self);
			_tmp1417_ = _tmp1416_;
			_tmp1418_ = vala_expression_get_value_type (_tmp1417_);
			_tmp1419_ = _tmp1418_;
			_tmp1420_ = vala_data_type_get_actual_type (_tmp1415_, _tmp1419_, NULL, (ValaCodeNode*) self);
			_tmp1421_ = _tmp1420_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1421_);
			_vala_code_node_unref0 (_tmp1421_);
		} else {
			ValaDataType* _tmp1422_;
			ValaDataType* _tmp1423_;
			_tmp1422_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1423_ = _tmp1422_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1423_);
		}
		_tmp1424_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1425_ = _tmp1424_;
		if (VALA_IS_METHOD (_tmp1425_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1426_;
			ValaSymbol* _tmp1427_;
			ValaMethod* _tmp1428_;
			ValaDataType* _tmp1429_;
			ValaDataType* _tmp1430_;
			gboolean _tmp1437_ = FALSE;
			_tmp1426_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1427_ = _tmp1426_;
			_tmp1428_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1427_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1428_;
			_tmp1429_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1430_ = _tmp1429_;
			if (_tmp1430_ != NULL) {
				ValaDataType* _tmp1431_;
				ValaDataType* _tmp1432_;
				ValaDataType* _tmp1433_;
				ValaDataType* _tmp1434_;
				gboolean _tmp1435_;
				gboolean _tmp1436_;
				_tmp1431_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1432_ = _tmp1431_;
				_tmp1433_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1434_ = _tmp1433_;
				_tmp1435_ = vala_data_type_get_value_owned (_tmp1434_);
				_tmp1436_ = _tmp1435_;
				vala_data_type_set_value_owned (_tmp1432_, _tmp1436_);
			}
			if (instance) {
				ValaMethod* _tmp1438_;
				ValaSymbol* _tmp1439_;
				ValaSymbol* _tmp1440_;
				_tmp1438_ = method;
				_tmp1439_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1438_);
				_tmp1440_ = _tmp1439_;
				_tmp1437_ = VALA_IS_TYPESYMBOL (_tmp1440_);
			} else {
				_tmp1437_ = FALSE;
			}
			if (_tmp1437_) {
				ValaExpression* _tmp1441_;
				ValaExpression* _tmp1442_;
				ValaMethod* _tmp1443_;
				ValaSymbol* _tmp1444_;
				ValaSymbol* _tmp1445_;
				ValaDataType* _tmp1446_;
				ValaDataType* _tmp1447_;
				ValaExpression* _tmp1448_;
				ValaExpression* _tmp1449_;
				ValaDataType* _tmp1450_;
				ValaDataType* _tmp1451_;
				ValaMethod* _tmp1452_;
				ValaParameter* _tmp1453_;
				ValaParameter* _tmp1454_;
				ValaDataType* _tmp1455_;
				ValaDataType* _tmp1456_;
				gboolean _tmp1457_;
				gboolean _tmp1458_;
				_tmp1441_ = vala_member_access_get_inner (self);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = method;
				_tmp1444_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1443_);
				_tmp1445_ = _tmp1444_;
				_tmp1446_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1445_);
				_tmp1447_ = _tmp1446_;
				vala_expression_set_target_type (_tmp1442_, _tmp1447_);
				_vala_code_node_unref0 (_tmp1447_);
				_tmp1448_ = vala_member_access_get_inner (self);
				_tmp1449_ = _tmp1448_;
				_tmp1450_ = vala_expression_get_target_type (_tmp1449_);
				_tmp1451_ = _tmp1450_;
				_tmp1452_ = method;
				_tmp1453_ = vala_method_get_this_parameter (_tmp1452_);
				_tmp1454_ = _tmp1453_;
				_tmp1455_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1454_);
				_tmp1456_ = _tmp1455_;
				_tmp1457_ = vala_data_type_get_value_owned (_tmp1456_);
				_tmp1458_ = _tmp1457_;
				vala_data_type_set_value_owned (_tmp1451_, _tmp1458_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1459_;
			ValaSymbol* _tmp1460_;
			_tmp1459_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1460_ = _tmp1459_;
			if (VALA_IS_PROPERTY (_tmp1460_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1461_;
				ValaSymbol* _tmp1462_;
				ValaProperty* _tmp1463_;
				gboolean _tmp1464_ = FALSE;
				_tmp1461_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1462_ = _tmp1461_;
				_tmp1463_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1462_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1463_;
				if (instance) {
					ValaProperty* _tmp1465_;
					ValaSymbol* _tmp1466_;
					ValaSymbol* _tmp1467_;
					_tmp1465_ = prop;
					_tmp1466_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1465_);
					_tmp1467_ = _tmp1466_;
					_tmp1464_ = _tmp1467_ != NULL;
				} else {
					_tmp1464_ = FALSE;
				}
				if (_tmp1464_) {
					ValaExpression* _tmp1468_;
					ValaExpression* _tmp1469_;
					ValaProperty* _tmp1470_;
					ValaSymbol* _tmp1471_;
					ValaSymbol* _tmp1472_;
					ValaDataType* _tmp1473_;
					ValaDataType* _tmp1474_;
					_tmp1468_ = vala_member_access_get_inner (self);
					_tmp1469_ = _tmp1468_;
					_tmp1470_ = prop;
					_tmp1471_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1470_);
					_tmp1472_ = _tmp1471_;
					_tmp1473_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1472_);
					_tmp1474_ = _tmp1473_;
					vala_expression_set_target_type (_tmp1469_, _tmp1474_);
					_vala_code_node_unref0 (_tmp1474_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1475_ = FALSE;
				gboolean _tmp1476_ = FALSE;
				gboolean _tmp1477_ = FALSE;
				ValaSymbol* _tmp1478_;
				ValaSymbol* _tmp1479_;
				_tmp1478_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1479_ = _tmp1478_;
				if (VALA_IS_FIELD (_tmp1479_)) {
					_tmp1477_ = TRUE;
				} else {
					ValaSymbol* _tmp1480_;
					ValaSymbol* _tmp1481_;
					_tmp1480_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1481_ = _tmp1480_;
					_tmp1477_ = VALA_IS_SIGNAL (_tmp1481_);
				}
				if (_tmp1477_) {
					_tmp1476_ = instance;
				} else {
					_tmp1476_ = FALSE;
				}
				if (_tmp1476_) {
					ValaSymbol* _tmp1482_;
					ValaSymbol* _tmp1483_;
					ValaSymbol* _tmp1484_;
					ValaSymbol* _tmp1485_;
					_tmp1482_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1483_ = _tmp1482_;
					_tmp1484_ = vala_symbol_get_parent_symbol (_tmp1483_);
					_tmp1485_ = _tmp1484_;
					_tmp1475_ = _tmp1485_ != NULL;
				} else {
					_tmp1475_ = FALSE;
				}
				if (_tmp1475_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1486_;
					ValaSymbol* _tmp1487_;
					ValaSymbol* _tmp1488_;
					ValaSymbol* _tmp1489_;
					ValaDataType* _tmp1490_;
					ValaExpression* _tmp1491_;
					ValaExpression* _tmp1492_;
					ValaDataType* _tmp1493_;
					ValaExpression* _tmp1494_;
					ValaExpression* _tmp1495_;
					ValaDataType* _tmp1496_;
					ValaDataType* _tmp1497_;
					ValaDataType* _tmp1498_;
					ValaDataType* _tmp1499_;
					_tmp1486_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1487_ = _tmp1486_;
					_tmp1488_ = vala_symbol_get_parent_symbol (_tmp1487_);
					_tmp1489_ = _tmp1488_;
					_tmp1490_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1489_);
					parent_type = _tmp1490_;
					_tmp1491_ = vala_member_access_get_inner (self);
					_tmp1492_ = _tmp1491_;
					_tmp1493_ = parent_type;
					_tmp1494_ = vala_member_access_get_inner (self);
					_tmp1495_ = _tmp1494_;
					_tmp1496_ = vala_expression_get_value_type (_tmp1495_);
					_tmp1497_ = _tmp1496_;
					_tmp1498_ = vala_data_type_get_actual_type (_tmp1493_, _tmp1497_, NULL, (ValaCodeNode*) self);
					_tmp1499_ = _tmp1498_;
					vala_expression_set_target_type (_tmp1492_, _tmp1499_);
					_vala_code_node_unref0 (_tmp1499_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1500_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1501_ = _tmp1500_;
	if (_tmp1501_ != NULL) {
		ValaDataType* _tmp1502_;
		ValaDataType* _tmp1503_;
		_tmp1502_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1503_ = _tmp1502_;
		vala_code_node_check ((ValaCodeNode*) _tmp1503_, context);
	}
	_tmp1504_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1505_ = _tmp1504_;
	result = !_tmp1505_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = VALA_IS_ARRAY_TYPE (_tmp55_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp57_) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = VALA_IS_POINTER_INDIRECTION (_tmp63_);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp67_) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (VALA_IS_METHOD (_tmp75_)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = VALA_IS_VARIABLE (_tmp83_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = VALA_IS_ELEMENT_ACCESS (_tmp85_);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaClass* _tmp103_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_METHOD, ValaMethod));
		_tmp100_ = _tmp99_;
		cl = VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp103_ = cl;
		if (_tmp103_ != NULL) {
			ValaClass* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			_tmp104_ = cl;
			_tmp105_ = vala_class_get_is_compact (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp102_ = _tmp106_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp107_;
			_tmp107_ = ma;
			_tmp101_ = _tmp107_ != NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaMemberAccess* _tmp108_;
			ValaMemberAccess* _tmp109_;
			_tmp108_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp108_, TRUE);
			_tmp109_ = ma;
			vala_member_access_check_lvalue_access (_tmp109_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

