/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp26_ = FALSE;
	ValaExpression* _tmp27_;
	ValaExpression* _tmp28_;
	ValaSemanticAnalyzer* _tmp43_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSymbol* _tmp45_;
	ValaSymbol* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	gboolean _tmp102_;
	gboolean _tmp103_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	ValaArrayType* _tmp121_;
	gboolean _tmp133_ = FALSE;
	gboolean _tmp134_ = FALSE;
	gboolean _tmp135_ = FALSE;
	ValaArrayType* _tmp136_;
	gboolean _tmp147_ = FALSE;
	ValaExpression* _tmp148_;
	ValaExpression* _tmp149_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp265_;
	ValaSemanticAnalyzer* _tmp266_;
	ValaSymbol* _tmp267_;
	ValaSymbol* _tmp268_;
	ValaBlock* _tmp269_;
	ValaBlock* _tmp270_;
	gboolean _tmp272_;
	gboolean _tmp273_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_experimental_non_null (context);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_REFERENCE_TYPE (_tmp7_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp9_) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp17_ = _tmp16_;
				vala_data_type_set_nullable (_tmp17_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp21_ = _tmp20_;
		if (VALA_IS_VOID_TYPE (_tmp21_)) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp24_;
			ValaDataType* _tmp25_;
			_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp25_ = _tmp24_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp25_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp27_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp29_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp30_ = _tmp29_;
		_tmp26_ = !_tmp30_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaExpression* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp41_;
		ValaExpression* _tmp42_;
		_tmp31_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp34_ = _tmp33_;
		vala_expression_set_target_type (_tmp32_, _tmp34_);
		_tmp35_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp36_ = _tmp35_;
		if (VALA_IS_INITIALIZER_LIST (_tmp36_)) {
			ValaExpression* _tmp37_;
			ValaExpression* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp37_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp40_ = _tmp39_;
			initializer_size = _tmp40_;
			is_initializer_list = TRUE;
		}
		_tmp41_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp42_ = _tmp41_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp42_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	_tmp43_ = vala_code_context_get_analyzer (context);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_semantic_analyzer_get_current_symbol (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_symbol_get_scope (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	vala_scope_add (_tmp48_, _tmp50_, (ValaSymbol*) self);
	_tmp51_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp52_ = _tmp51_;
	if (_tmp52_) {
		result = FALSE;
		return result;
	}
	_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp54_ = _tmp53_;
	if (_tmp54_ == NULL) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		gboolean _tmp65_ = FALSE;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaDataType* _tmp88_;
		ValaDataType* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		ValaDataType* _tmp95_;
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		ValaDataType* _tmp98_;
		ValaDataType* _tmp99_;
		ValaDataType* _tmp100_;
		ValaDataType* _tmp101_;
		_tmp55_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		if (_tmp56_ == NULL) {
			ValaSourceReference* _tmp57_;
			ValaSourceReference* _tmp58_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp58_ = _tmp57_;
			vala_report_error (_tmp58_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_expression_get_value_type (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp62_ == NULL) {
			ValaSourceReference* _tmp63_;
			ValaSourceReference* _tmp64_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp64_ = _tmp63_;
			vala_report_error (_tmp64_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp66_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_expression_get_value_type (_tmp67_);
		_tmp69_ = _tmp68_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp69_)) {
			_tmp65_ = TRUE;
		} else {
			ValaExpression* _tmp70_;
			ValaExpression* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			_tmp70_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_expression_get_value_type (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp65_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp73_);
		}
		if (_tmp65_) {
			ValaExpression* _tmp74_;
			ValaExpression* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaSourceReference* _tmp77_;
			ValaExpression* _tmp78_;
			ValaExpression* _tmp79_;
			ValaSymbol* _tmp80_;
			ValaSymbol* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_expression_get_symbol_reference (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_symbol_get_full_name (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp83_);
			_tmp85_ = _tmp84_;
			vala_report_error (_tmp77_, _tmp85_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp83_);
			result = FALSE;
			return result;
		}
		_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_expression_get_value_type (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_data_type_copy (_tmp89_);
		_tmp91_ = _tmp90_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp91_);
		_vala_code_node_unref0 (_tmp91_);
		_tmp92_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp93_ = _tmp92_;
		vala_data_type_set_value_owned (_tmp93_, TRUE);
		_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp95_ = _tmp94_;
		vala_data_type_set_floating_reference (_tmp95_, FALSE);
		_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		vala_expression_set_target_type (_tmp97_, _tmp99_);
		_tmp100_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
	}
	_tmp102_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp103_ = _tmp102_;
	if (!_tmp103_) {
		ValaDataType* _tmp104_;
		ValaDataType* _tmp105_;
		ValaTypeSymbol* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		_tmp104_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_data_type_get_data_type (_tmp105_);
		_tmp107_ = _tmp106_;
		if (_tmp107_ != NULL) {
			ValaDataType* _tmp108_;
			ValaDataType* _tmp109_;
			ValaTypeSymbol* _tmp110_;
			ValaTypeSymbol* _tmp111_;
			ValaVersionAttribute* _tmp112_;
			ValaVersionAttribute* _tmp113_;
			ValaSourceReference* _tmp114_;
			ValaSourceReference* _tmp115_;
			_tmp108_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp109_ = _tmp108_;
			_tmp110_ = vala_data_type_get_data_type (_tmp109_);
			_tmp111_ = _tmp110_;
			_tmp112_ = vala_symbol_get_version ((ValaSymbol*) _tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp115_ = _tmp114_;
			vala_version_attribute_check (_tmp113_, _tmp115_);
		}
	}
	_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp117_ = _tmp116_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp117_) ? ((ValaArrayType*) _tmp117_) : NULL;
	_tmp121_ = variable_array_type;
	if (_tmp121_ != NULL) {
		ValaArrayType* _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp124_;
		_tmp122_ = variable_array_type;
		_tmp123_ = vala_array_type_get_inline_allocated (_tmp122_);
		_tmp124_ = _tmp123_;
		_tmp120_ = _tmp124_;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp126_ = _tmp125_;
		_tmp119_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp126_);
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaInitializerList* _tmp129_;
		ValaInitializerList* _tmp130_;
		_tmp127_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp130_ = _tmp129_;
		_tmp118_ = _tmp130_ == NULL;
	} else {
		_tmp118_ = FALSE;
	}
	if (_tmp118_) {
		ValaSourceReference* _tmp131_;
		ValaSourceReference* _tmp132_;
		_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp132_ = _tmp131_;
		vala_report_warning (_tmp132_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp136_ = variable_array_type;
	if (_tmp136_ != NULL) {
		ValaArrayType* _tmp137_;
		gboolean _tmp138_;
		gboolean _tmp139_;
		_tmp137_ = variable_array_type;
		_tmp138_ = vala_array_type_get_inline_allocated (_tmp137_);
		_tmp139_ = _tmp138_;
		_tmp135_ = _tmp139_;
	} else {
		_tmp135_ = FALSE;
	}
	if (_tmp135_) {
		ValaArrayType* _tmp140_;
		ValaExpression* _tmp141_;
		ValaExpression* _tmp142_;
		_tmp140_ = variable_array_type;
		_tmp141_ = vala_array_type_get_length (_tmp140_);
		_tmp142_ = _tmp141_;
		_tmp134_ = _tmp142_ == NULL;
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		ValaExpression* _tmp143_;
		ValaExpression* _tmp144_;
		_tmp143_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp144_ = _tmp143_;
		_tmp133_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp144_);
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaSourceReference* _tmp145_;
		ValaSourceReference* _tmp146_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp146_ = _tmp145_;
		vala_report_error (_tmp146_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp148_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp149_ = _tmp148_;
	if (_tmp149_ != NULL) {
		ValaExpression* _tmp150_;
		ValaExpression* _tmp151_;
		gboolean _tmp152_;
		gboolean _tmp153_;
		_tmp150_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_code_node_get_error ((ValaCodeNode*) _tmp151_);
		_tmp153_ = _tmp152_;
		_tmp147_ = !_tmp153_;
	} else {
		_tmp147_ = FALSE;
	}
	if (_tmp147_) {
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		ValaDataType* _tmp156_;
		ValaDataType* _tmp157_;
		ValaExpression* _tmp203_;
		ValaExpression* _tmp204_;
		ValaDataType* _tmp205_;
		ValaDataType* _tmp206_;
		ValaDataType* _tmp207_;
		ValaDataType* _tmp208_;
		gboolean _tmp223_ = FALSE;
		gboolean _tmp224_ = FALSE;
		gboolean _tmp225_ = FALSE;
		ValaArrayType* _tmp226_;
		gboolean _tmp240_ = FALSE;
		gboolean _tmp241_ = FALSE;
		ValaArrayType* _tmp242_;
		ValaExpression* _tmp252_;
		ValaExpression* _tmp253_;
		ValaDataType* _tmp254_;
		ValaDataType* _tmp255_;
		_tmp154_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp155_ = _tmp154_;
		_tmp156_ = vala_expression_get_value_type (_tmp155_);
		_tmp157_ = _tmp156_;
		if (_tmp157_ == NULL) {
			gboolean _tmp158_ = FALSE;
			ValaExpression* _tmp159_;
			ValaExpression* _tmp160_;
			gboolean _tmp165_ = FALSE;
			ValaExpression* _tmp166_;
			ValaExpression* _tmp167_;
			ValaSymbol* _tmp168_;
			ValaSymbol* _tmp169_;
			_tmp159_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp160_ = _tmp159_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp160_)) {
				ValaExpression* _tmp161_;
				ValaExpression* _tmp162_;
				_tmp161_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp162_ = _tmp161_;
				_tmp158_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp162_);
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				ValaSourceReference* _tmp163_;
				ValaSourceReference* _tmp164_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp164_ = _tmp163_;
				vala_report_error (_tmp164_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp166_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_expression_get_symbol_reference (_tmp167_);
			_tmp169_ = _tmp168_;
			if (VALA_IS_METHOD (_tmp169_)) {
				ValaDataType* _tmp170_;
				ValaDataType* _tmp171_;
				_tmp170_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp171_ = _tmp170_;
				_tmp165_ = VALA_IS_DELEGATE_TYPE (_tmp171_);
			} else {
				_tmp165_ = FALSE;
			}
			if (_tmp165_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp172_;
				ValaExpression* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaMethod* _tmp176_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDelegateType* _tmp179_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp180_;
				ValaDelegate* _tmp181_;
				ValaDelegate* _tmp182_;
				ValaDelegate* _tmp183_;
				ValaDelegate* _tmp184_;
				ValaMethod* _tmp185_;
				ValaDelegateType* _tmp186_;
				ValaExpression* _tmp197_;
				ValaExpression* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				_tmp172_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_expression_get_symbol_reference (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp175_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp176_;
				_tmp177_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp178_ = _tmp177_;
				_tmp179_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp178_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp179_;
				_tmp180_ = dt;
				_tmp181_ = vala_delegate_type_get_delegate_symbol (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = _vala_code_node_ref0 (_tmp182_);
				cb = _tmp183_;
				_tmp184_ = cb;
				_tmp185_ = m;
				_tmp186_ = dt;
				if (!vala_delegate_matches_method (_tmp184_, _tmp185_, (ValaDataType*) _tmp186_)) {
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaMethod* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					ValaDelegate* _tmp192_;
					gchar* _tmp193_;
					gchar* _tmp194_;
					gchar* _tmp195_;
					gchar* _tmp196_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = m;
					_tmp190_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp189_);
					_tmp191_ = _tmp190_;
					_tmp192_ = cb;
					_tmp193_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp191_, _tmp194_);
					_tmp196_ = _tmp195_;
					vala_report_error (_tmp188_, _tmp196_);
					_g_free0 (_tmp196_);
					_g_free0 (_tmp194_);
					_g_free0 (_tmp191_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp197_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp200_ = _tmp199_;
				vala_expression_set_value_type (_tmp198_, _tmp200_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp201_;
				ValaSourceReference* _tmp202_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp202_ = _tmp201_;
				vala_report_error (_tmp202_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp203_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp204_ = _tmp203_;
		_tmp205_ = vala_expression_get_value_type (_tmp204_);
		_tmp206_ = _tmp205_;
		_tmp207_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp208_ = _tmp207_;
		if (!vala_data_type_compatible (_tmp206_, _tmp208_)) {
			ValaSourceReference* _tmp209_;
			ValaSourceReference* _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaDataType* _tmp213_;
			ValaDataType* _tmp214_;
			gchar* _tmp215_;
			gchar* _tmp216_;
			ValaDataType* _tmp217_;
			ValaDataType* _tmp218_;
			gchar* _tmp219_;
			gchar* _tmp220_;
			gchar* _tmp221_;
			gchar* _tmp222_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_value_type (_tmp212_);
			_tmp214_ = _tmp213_;
			_tmp215_ = vala_code_node_to_string ((ValaCodeNode*) _tmp214_);
			_tmp216_ = _tmp215_;
			_tmp217_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp218_ = _tmp217_;
			_tmp219_ = vala_code_node_to_string ((ValaCodeNode*) _tmp218_);
			_tmp220_ = _tmp219_;
			_tmp221_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp216_, _tmp220_);
			_tmp222_ = _tmp221_;
			vala_report_error (_tmp210_, _tmp222_);
			_g_free0 (_tmp222_);
			_g_free0 (_tmp220_);
			_g_free0 (_tmp216_);
			result = FALSE;
			return result;
		}
		_tmp226_ = variable_array_type;
		if (_tmp226_ != NULL) {
			ValaArrayType* _tmp227_;
			gboolean _tmp228_;
			gboolean _tmp229_;
			_tmp227_ = variable_array_type;
			_tmp228_ = vala_array_type_get_inline_allocated (_tmp227_);
			_tmp229_ = _tmp228_;
			_tmp225_ = _tmp229_;
		} else {
			_tmp225_ = FALSE;
		}
		if (_tmp225_) {
			ValaArrayType* _tmp230_;
			gboolean _tmp231_;
			gboolean _tmp232_;
			_tmp230_ = variable_array_type;
			_tmp231_ = vala_array_type_get_fixed_length (_tmp230_);
			_tmp232_ = _tmp231_;
			_tmp224_ = !_tmp232_;
		} else {
			_tmp224_ = FALSE;
		}
		if (_tmp224_) {
			_tmp223_ = is_initializer_list;
		} else {
			_tmp223_ = FALSE;
		}
		if (_tmp223_) {
			ValaArrayType* _tmp233_;
			gchar* _tmp234_;
			gchar* _tmp235_;
			ValaIntegerLiteral* _tmp236_;
			ValaIntegerLiteral* _tmp237_;
			ValaArrayType* _tmp238_;
			ValaArrayType* _tmp239_;
			_tmp233_ = variable_array_type;
			_tmp234_ = g_strdup_printf ("%i", initializer_size);
			_tmp235_ = _tmp234_;
			_tmp236_ = vala_integer_literal_new (_tmp235_, NULL);
			_tmp237_ = _tmp236_;
			vala_array_type_set_length (_tmp233_, (ValaExpression*) _tmp237_);
			_vala_code_node_unref0 (_tmp237_);
			_g_free0 (_tmp235_);
			_tmp238_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp238_, TRUE);
			_tmp239_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp239_, FALSE);
		}
		_tmp242_ = variable_array_type;
		if (_tmp242_ != NULL) {
			ValaArrayType* _tmp243_;
			gboolean _tmp244_;
			gboolean _tmp245_;
			_tmp243_ = variable_array_type;
			_tmp244_ = vala_array_type_get_inline_allocated (_tmp243_);
			_tmp245_ = _tmp244_;
			_tmp241_ = _tmp245_;
		} else {
			_tmp241_ = FALSE;
		}
		if (_tmp241_) {
			ValaExpression* _tmp246_;
			ValaExpression* _tmp247_;
			ValaDataType* _tmp248_;
			ValaDataType* _tmp249_;
			_tmp246_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp247_ = _tmp246_;
			_tmp248_ = vala_expression_get_value_type (_tmp247_);
			_tmp249_ = _tmp248_;
			_tmp240_ = VALA_IS_ARRAY_TYPE (_tmp249_) == FALSE;
		} else {
			_tmp240_ = FALSE;
		}
		if (_tmp240_) {
			ValaSourceReference* _tmp250_;
			ValaSourceReference* _tmp251_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp251_ = _tmp250_;
			vala_report_error (_tmp251_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp252_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp253_ = _tmp252_;
		_tmp254_ = vala_expression_get_value_type (_tmp253_);
		_tmp255_ = _tmp254_;
		if (vala_data_type_is_disposable (_tmp255_)) {
			gboolean _tmp256_ = FALSE;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			_tmp257_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp258_ = _tmp257_;
			if (!VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaDataType* _tmp259_;
				ValaDataType* _tmp260_;
				gboolean _tmp261_;
				gboolean _tmp262_;
				_tmp259_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_data_type_get_value_owned (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp256_ = !_tmp262_;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaSourceReference* _tmp263_;
				ValaSourceReference* _tmp264_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp264_ = _tmp263_;
				vala_report_error (_tmp264_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp265_ = vala_code_context_get_analyzer (context);
	_tmp266_ = _tmp265_;
	_tmp267_ = vala_semantic_analyzer_get_current_symbol (_tmp266_);
	_tmp268_ = _tmp267_;
	_tmp269_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp268_) ? ((ValaBlock*) _tmp268_) : NULL);
	block = _tmp269_;
	_tmp270_ = block;
	if (_tmp270_ != NULL) {
		ValaBlock* _tmp271_;
		_tmp271_ = block;
		vala_block_add_local_variable (_tmp271_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp272_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp273_ = _tmp272_;
	result = !_tmp273_;
	_vala_code_node_unref0 (block);
	return result;
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

