/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	ValaSemanticAnalyzer* _tmp63_;
	ValaSemanticAnalyzer* _tmp64_;
	ValaDataType* _tmp65_;
	ValaDataType* _tmp66_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp77_;
	ValaDataType* _tmp78_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	ValaArrayType* _tmp82_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	ValaArrayType* _tmp96_;
	ValaExpression* _tmp105_;
	ValaExpression* _tmp106_;
	gboolean _tmp229_ = FALSE;
	ValaMemberBinding _tmp230_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp235_;
	ValaSymbol* _tmp236_;
	gboolean _tmp245_ = FALSE;
	gboolean _tmp246_ = FALSE;
	gboolean _tmp247_;
	gboolean _tmp248_;
	ValaSemanticAnalyzer* _tmp263_;
	ValaSemanticAnalyzer* _tmp264_;
	ValaSourceFile* _tmp265_;
	ValaSemanticAnalyzer* _tmp266_;
	ValaSemanticAnalyzer* _tmp267_;
	ValaSymbol* _tmp268_;
	gboolean _tmp269_;
	gboolean _tmp270_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_data_type (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_data_type (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_data_type (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("`%s' not supported as field type", _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp48_ = _tmp47_;
	vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
	_tmp49_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	if (!_tmp50_) {
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		ValaTypeSymbol* _tmp53_;
		ValaTypeSymbol* _tmp54_;
		_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_data_type_get_data_type (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaDataType* _tmp55_;
			ValaDataType* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaVersionAttribute* _tmp59_;
			ValaVersionAttribute* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_data_type_get_data_type (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_symbol_get_version ((ValaSymbol*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp62_ = _tmp61_;
			vala_version_attribute_check (_tmp60_, _tmp62_);
		}
	}
	_tmp63_ = vala_code_context_get_analyzer (context);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp66_ = _tmp65_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp64_, (ValaSymbol*) self, _tmp66_)) {
		ValaSourceReference* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_code_node_to_string ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp72_, _tmp74_);
		_tmp76_ = _tmp75_;
		vala_report_error (_tmp68_, _tmp76_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp78_ = _tmp77_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp78_) ? ((ValaArrayType*) _tmp78_) : NULL;
	_tmp82_ = variable_array_type;
	if (_tmp82_ != NULL) {
		ValaArrayType* _tmp83_;
		gboolean _tmp84_;
		gboolean _tmp85_;
		_tmp83_ = variable_array_type;
		_tmp84_ = vala_array_type_get_inline_allocated (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp81_ = _tmp85_;
	} else {
		_tmp81_ = FALSE;
	}
	if (_tmp81_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		_tmp80_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp87_);
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaInitializerList* _tmp90_;
		ValaInitializerList* _tmp91_;
		_tmp88_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp91_ = _tmp90_;
		_tmp79_ = _tmp91_ == NULL;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		ValaSourceReference* _tmp92_;
		ValaSourceReference* _tmp93_;
		_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp93_ = _tmp92_;
		vala_report_warning (_tmp93_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp96_ = variable_array_type;
	if (_tmp96_ != NULL) {
		ValaArrayType* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		_tmp97_ = variable_array_type;
		_tmp98_ = vala_array_type_get_inline_allocated (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp95_ = _tmp99_;
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		ValaArrayType* _tmp100_;
		gboolean _tmp101_;
		gboolean _tmp102_;
		_tmp100_ = variable_array_type;
		_tmp101_ = vala_array_type_get_fixed_length (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp94_ = !_tmp102_;
	} else {
		_tmp94_ = FALSE;
	}
	if (_tmp94_) {
		ValaSourceReference* _tmp103_;
		ValaSourceReference* _tmp104_;
		_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp104_ = _tmp103_;
		vala_report_error (_tmp104_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp106_ = _tmp105_;
	if (_tmp106_ != NULL) {
		ValaExpression* _tmp107_;
		ValaExpression* _tmp108_;
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		gboolean _tmp145_ = FALSE;
		gboolean _tmp146_ = FALSE;
		gboolean _tmp147_ = FALSE;
		ValaArrayType* _tmp148_;
		gboolean _tmp162_ = FALSE;
		gboolean _tmp163_ = FALSE;
		ValaArrayType* _tmp164_;
		ValaExpression* _tmp174_;
		ValaExpression* _tmp175_;
		ValaDataType* _tmp176_;
		ValaDataType* _tmp177_;
		gboolean _tmp187_ = FALSE;
		ValaSymbol* _tmp188_;
		ValaSymbol* _tmp189_;
		gboolean _tmp194_ = FALSE;
		gboolean _tmp195_ = FALSE;
		ValaSymbol* _tmp196_;
		ValaSymbol* _tmp197_;
		gboolean _tmp211_ = FALSE;
		gboolean _tmp212_ = FALSE;
		gboolean _tmp213_ = FALSE;
		ValaMemberBinding _tmp214_;
		gboolean _tmp225_;
		gboolean _tmp226_;
		_tmp107_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp110_ = _tmp109_;
		vala_expression_set_target_type (_tmp108_, _tmp110_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		if (VALA_IS_INITIALIZER_LIST (_tmp112_)) {
			ValaExpression* _tmp113_;
			ValaExpression* _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp116_ = _tmp115_;
			initializer_size = _tmp116_;
			is_initializer_list = TRUE;
		}
		_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp118_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_value_type (_tmp120_);
		_tmp122_ = _tmp121_;
		if (_tmp122_ == NULL) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp124_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_expression_get_value_type (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		if (!vala_data_type_compatible (_tmp128_, _tmp130_)) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			ValaExpression* _tmp133_;
			ValaExpression* _tmp134_;
			ValaDataType* _tmp135_;
			ValaDataType* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp134_ = _tmp133_;
			_tmp135_ = vala_expression_get_value_type (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_code_node_to_string ((ValaCodeNode*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_code_node_to_string ((ValaCodeNode*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp138_, _tmp142_);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp132_, _tmp144_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp138_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp148_ = variable_array_type;
		if (_tmp148_ != NULL) {
			ValaArrayType* _tmp149_;
			gboolean _tmp150_;
			gboolean _tmp151_;
			_tmp149_ = variable_array_type;
			_tmp150_ = vala_array_type_get_inline_allocated (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp147_ = _tmp151_;
		} else {
			_tmp147_ = FALSE;
		}
		if (_tmp147_) {
			ValaArrayType* _tmp152_;
			gboolean _tmp153_;
			gboolean _tmp154_;
			_tmp152_ = variable_array_type;
			_tmp153_ = vala_array_type_get_fixed_length (_tmp152_);
			_tmp154_ = _tmp153_;
			_tmp146_ = !_tmp154_;
		} else {
			_tmp146_ = FALSE;
		}
		if (_tmp146_) {
			_tmp145_ = is_initializer_list;
		} else {
			_tmp145_ = FALSE;
		}
		if (_tmp145_) {
			ValaArrayType* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			ValaIntegerLiteral* _tmp158_;
			ValaIntegerLiteral* _tmp159_;
			ValaArrayType* _tmp160_;
			ValaArrayType* _tmp161_;
			_tmp155_ = variable_array_type;
			_tmp156_ = g_strdup_printf ("%i", initializer_size);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_integer_literal_new (_tmp157_, NULL);
			_tmp159_ = _tmp158_;
			vala_array_type_set_length (_tmp155_, (ValaExpression*) _tmp159_);
			_vala_code_node_unref0 (_tmp159_);
			_g_free0 (_tmp157_);
			_tmp160_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp160_, TRUE);
			_tmp161_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp161_, FALSE);
		}
		_tmp164_ = variable_array_type;
		if (_tmp164_ != NULL) {
			ValaArrayType* _tmp165_;
			gboolean _tmp166_;
			gboolean _tmp167_;
			_tmp165_ = variable_array_type;
			_tmp166_ = vala_array_type_get_inline_allocated (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp163_ = _tmp167_;
		} else {
			_tmp163_ = FALSE;
		}
		if (_tmp163_) {
			ValaExpression* _tmp168_;
			ValaExpression* _tmp169_;
			ValaDataType* _tmp170_;
			ValaDataType* _tmp171_;
			_tmp168_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_expression_get_value_type (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp162_ = !VALA_IS_ARRAY_TYPE (_tmp171_);
		} else {
			_tmp162_ = FALSE;
		}
		if (_tmp162_) {
			ValaSourceReference* _tmp172_;
			ValaSourceReference* _tmp173_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp172_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp173_ = _tmp172_;
			vala_report_error (_tmp173_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp174_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp175_ = _tmp174_;
		_tmp176_ = vala_expression_get_value_type (_tmp175_);
		_tmp177_ = _tmp176_;
		if (vala_data_type_is_disposable (_tmp177_)) {
			gboolean _tmp178_ = FALSE;
			ValaDataType* _tmp179_;
			ValaDataType* _tmp180_;
			_tmp179_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp180_ = _tmp179_;
			if (!VALA_IS_POINTER_TYPE (_tmp180_)) {
				ValaDataType* _tmp181_;
				ValaDataType* _tmp182_;
				gboolean _tmp183_;
				gboolean _tmp184_;
				_tmp181_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_data_type_get_value_owned (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp178_ = !_tmp184_;
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				vala_report_error (_tmp186_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp188_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp189_ = _tmp188_;
		if (VALA_IS_NAMESPACE (_tmp189_)) {
			ValaExpression* _tmp190_;
			ValaExpression* _tmp191_;
			_tmp190_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp191_ = _tmp190_;
			_tmp187_ = !vala_expression_is_constant (_tmp191_);
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			ValaSourceReference* _tmp192_;
			ValaSourceReference* _tmp193_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp193_ = _tmp192_;
			vala_report_error (_tmp193_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp197_ = _tmp196_;
		if (VALA_IS_NAMESPACE (_tmp197_)) {
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			_tmp198_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp199_ = _tmp198_;
			_tmp195_ = vala_expression_is_constant (_tmp199_);
		} else {
			_tmp195_ = FALSE;
		}
		if (_tmp195_) {
			ValaExpression* _tmp200_;
			ValaExpression* _tmp201_;
			_tmp200_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp201_ = _tmp200_;
			_tmp194_ = vala_expression_is_non_null (_tmp201_);
		} else {
			_tmp194_ = FALSE;
		}
		if (_tmp194_) {
			gboolean _tmp202_ = FALSE;
			ValaDataType* _tmp203_;
			ValaDataType* _tmp204_;
			_tmp203_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp204_ = _tmp203_;
			if (vala_data_type_is_disposable (_tmp204_)) {
				ValaDataType* _tmp205_;
				ValaDataType* _tmp206_;
				gboolean _tmp207_;
				gboolean _tmp208_;
				_tmp205_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_data_type_get_value_owned (_tmp206_);
				_tmp208_ = _tmp207_;
				_tmp202_ = _tmp208_;
			} else {
				_tmp202_ = FALSE;
			}
			if (_tmp202_) {
				ValaSourceReference* _tmp209_;
				ValaSourceReference* _tmp210_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp210_ = _tmp209_;
				vala_report_error (_tmp210_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp214_ = self->priv->_binding;
		if (_tmp214_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp215_;
			ValaSymbol* _tmp216_;
			_tmp215_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp216_ = _tmp215_;
			_tmp213_ = VALA_IS_CLASS (_tmp216_);
		} else {
			_tmp213_ = FALSE;
		}
		if (_tmp213_) {
			ValaSymbol* _tmp217_;
			ValaSymbol* _tmp218_;
			gboolean _tmp219_;
			gboolean _tmp220_;
			_tmp217_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp218_ = _tmp217_;
			_tmp219_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp218_, VALA_TYPE_CLASS, ValaClass));
			_tmp220_ = _tmp219_;
			_tmp212_ = _tmp220_;
		} else {
			_tmp212_ = FALSE;
		}
		if (_tmp212_) {
			ValaExpression* _tmp221_;
			ValaExpression* _tmp222_;
			_tmp221_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp222_ = _tmp221_;
			_tmp211_ = !vala_expression_is_constant (_tmp222_);
		} else {
			_tmp211_ = FALSE;
		}
		if (_tmp211_) {
			ValaSourceReference* _tmp223_;
			ValaSourceReference* _tmp224_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp224_ = _tmp223_;
			vala_report_error (_tmp224_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp225_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp226_ = _tmp225_;
		if (_tmp226_) {
			ValaSourceReference* _tmp227_;
			ValaSourceReference* _tmp228_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp228_ = _tmp227_;
			vala_report_error (_tmp228_, "External fields cannot use initializers");
		}
	}
	_tmp230_ = self->priv->_binding;
	if (_tmp230_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp231_;
		ValaSymbol* _tmp232_;
		_tmp231_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp232_ = _tmp231_;
		_tmp229_ = VALA_IS_INTERFACE (_tmp232_);
	} else {
		_tmp229_ = FALSE;
	}
	if (_tmp229_) {
		ValaSourceReference* _tmp233_;
		ValaSourceReference* _tmp234_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp234_ = _tmp233_;
		vala_report_error (_tmp234_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp235_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp236_ = _tmp235_;
	if (VALA_IS_CLASS (_tmp236_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp237_;
		ValaSymbol* _tmp238_;
		ValaClass* _tmp239_;
		gboolean _tmp240_ = FALSE;
		ValaClass* _tmp241_;
		gboolean _tmp242_;
		gboolean _tmp243_;
		_tmp237_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp238_ = _tmp237_;
		_tmp239_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp238_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp239_;
		_tmp241_ = cl;
		_tmp242_ = vala_class_get_is_compact (_tmp241_);
		_tmp243_ = _tmp242_;
		if (_tmp243_) {
			ValaClass* _tmp244_;
			_tmp244_ = cl;
			_tmp240_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp244_);
		} else {
			_tmp240_ = FALSE;
		}
		if (_tmp240_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp247_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp248_ = _tmp247_;
	if (!_tmp248_) {
		gboolean _tmp249_;
		gboolean _tmp250_;
		_tmp249_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp250_ = _tmp249_;
		_tmp246_ = !_tmp250_;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		ValaSymbol* _tmp251_;
		ValaSymbol* _tmp252_;
		_tmp251_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp252_ = _tmp251_;
		_tmp245_ = _tmp252_ != NULL;
		_vala_code_node_unref0 (_tmp252_);
	} else {
		_tmp245_ = FALSE;
	}
	if (_tmp245_) {
		ValaSourceReference* _tmp253_;
		ValaSourceReference* _tmp254_;
		gchar* _tmp255_;
		gchar* _tmp256_;
		ValaSymbol* _tmp257_;
		ValaSymbol* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		gchar* _tmp262_;
		_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp254_ = _tmp253_;
		_tmp255_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp256_ = _tmp255_;
		_tmp257_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_symbol_get_full_name (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp256_, _tmp260_);
		_tmp262_ = _tmp261_;
		vala_report_warning (_tmp254_, _tmp262_);
		_g_free0 (_tmp262_);
		_g_free0 (_tmp260_);
		_vala_code_node_unref0 (_tmp258_);
		_g_free0 (_tmp256_);
	}
	_tmp263_ = vala_code_context_get_analyzer (context);
	_tmp264_ = _tmp263_;
	_tmp265_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp264_, _tmp265_);
	_tmp266_ = vala_code_context_get_analyzer (context);
	_tmp267_ = _tmp266_;
	_tmp268_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp267_, _tmp268_);
	_tmp269_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp270_ = _tmp269_;
	result = !_tmp270_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

