/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGLibValue, vala_target_value_unref)
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp288_ = FALSE;
	ValaMethod* _tmp289_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp452_;
	ValaCCodeExpression* _tmp453_;
	ValaMethod* _tmp454_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp478_ = FALSE;
	ValaMethod* _tmp479_;
	gboolean _tmp633_ = FALSE;
	ValaMethod* _tmp634_;
	ValaMethod* _tmp682_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp867_;
	ValaIterator* _tmp868_;
	ValaIterator* _tmp1241_;
	gboolean _tmp1251_ = FALSE;
	gboolean _tmp1252_ = FALSE;
	ValaMethod* _tmp1253_;
	gboolean _tmp1375_ = FALSE;
	ValaDelegate* _tmp1376_;
	gboolean _tmp1473_ = FALSE;
	ValaMethod* _tmp1474_;
	gboolean _tmp1490_;
	gboolean _tmp1491_;
	ValaDataType* _tmp1534_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1558_;
	ValaDataType* _tmp1559_;
	ValaDataType* _tmp1560_;
	gboolean _tmp1561_;
	gboolean _tmp1562_ = FALSE;
	ValaDataType* _tmp1563_;
	ValaCCodeFunctionCall* _tmp1592_;
	ValaCCodeFunctionCall* _tmp1593_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1608_;
	ValaCCodeFunctionCall* _tmp1609_;
	ValaCCodeFunctionCall* _tmp1624_;
	gboolean _tmp1639_;
	gboolean _tmp1640_;
	gboolean _tmp1664_;
	gboolean _tmp1665_;
	gboolean _tmp1700_ = FALSE;
	gboolean _tmp1701_ = FALSE;
	ValaMethod* _tmp1702_;
	gboolean _tmp1740_ = FALSE;
	gboolean _tmp1741_ = FALSE;
	gboolean _tmp1742_ = FALSE;
	gboolean _tmp1743_ = FALSE;
	gboolean _tmp1744_ = FALSE;
	ValaMethod* _tmp1745_;
	gboolean _tmp1762_ = FALSE;
	gboolean _tmp1763_ = FALSE;
	ValaMethod* _tmp1764_;
	ValaMethod* _tmp1783_;
	gboolean _tmp1900_ = FALSE;
	ValaCodeNode* _tmp1901_;
	ValaCodeNode* _tmp1902_;
	ValaList* _tmp1975_;
	ValaIterator* _tmp1976_;
	gboolean _tmp2124_ = FALSE;
	gboolean _tmp2125_ = FALSE;
	ValaMethod* _tmp2126_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp238_ = FALSE;
		ValaMemberAccess* _tmp239_;
		const gchar* _tmp240_;
		const gchar* _tmp241_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			ValaCCodeExpression* _tmp223_;
			vcast = NULL;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				ValaCCodeIdentifier* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeFunctionCall* _tmp203_;
				ValaCCodeExpression* _tmp204_;
				ValaClass* _tmp205_;
				ValaClass* _tmp206_;
				gchar* _tmp207_;
				gchar* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				ValaCCodeIdentifier* _tmp211_;
				ValaCCodeIdentifier* _tmp212_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass);
				_tmp198_ = base_class;
				_tmp199_ = vala_get_ccode_class_type_function (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_ccode_identifier_new (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp202_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp203_;
				_vala_ccode_node_unref0 (_tmp202_);
				_g_free0 (_tmp200_);
				_tmp204_ = vcast;
				_tmp205_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp206_, NULL);
				_tmp208_ = _tmp207_;
				_tmp209_ = g_strdup_printf ("%s_parent_class", _tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_ccode_identifier_new (_tmp210_);
				_tmp212_ = _tmp211_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp212_);
				_vala_ccode_node_unref0 (_tmp212_);
				_g_free0 (_tmp210_);
				_g_free0 (_tmp208_);
			} else {
				ValaMethod* _tmp213_;
				ValaMethod* _tmp214_;
				ValaMethod* _tmp215_;
				_tmp213_ = m;
				_tmp214_ = vala_method_get_base_interface_method (_tmp213_);
				_tmp215_ = _tmp214_;
				if (_tmp215_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp216_;
					ValaMethod* _tmp217_;
					ValaMethod* _tmp218_;
					ValaSymbol* _tmp219_;
					ValaSymbol* _tmp220_;
					ValaInterface* _tmp221_;
					ValaCCodeExpression* _tmp222_;
					_tmp216_ = m;
					_tmp217_ = vala_method_get_base_interface_method (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp218_);
					_tmp220_ = _tmp219_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp221_ = base_iface;
					_tmp222_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp221_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp222_;
				}
			}
			_tmp223_ = vcast;
			if (_tmp223_ != NULL) {
				ValaCCodeFunctionCall* _tmp224_;
				ValaCCodeExpression* _tmp225_;
				ValaMethod* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				ValaCCodeMemberAccess* _tmp229_;
				ValaCCodeMemberAccess* _tmp230_;
				ValaCCodeFunctionCall* _tmp231_;
				ValaCCodeExpression* _tmp232_;
				ValaMethod* _tmp233_;
				gchar* _tmp234_;
				gchar* _tmp235_;
				ValaCCodeMemberAccess* _tmp236_;
				ValaCCodeMemberAccess* _tmp237_;
				_tmp224_ = async_call;
				_tmp225_ = vcast;
				_tmp226_ = m;
				_tmp227_ = vala_get_ccode_vfunc_name (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_ccode_member_access_new_pointer (_tmp225_, _tmp228_);
				_tmp230_ = _tmp229_;
				vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp230_);
				_vala_ccode_node_unref0 (_tmp230_);
				_g_free0 (_tmp228_);
				_tmp231_ = finish_call;
				_tmp232_ = vcast;
				_tmp233_ = m;
				_tmp234_ = vala_get_ccode_finish_vfunc_name (_tmp233_);
				_tmp235_ = _tmp234_;
				_tmp236_ = vala_ccode_member_access_new_pointer (_tmp232_, _tmp235_);
				_tmp237_ = _tmp236_;
				vala_ccode_function_call_set_call (_tmp231_, (ValaCCodeExpression*) _tmp237_);
				_vala_ccode_node_unref0 (_tmp237_);
				_g_free0 (_tmp235_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp239_ = ma;
		_tmp240_ = vala_member_access_get_member_name (_tmp239_);
		_tmp241_ = _tmp240_;
		if (g_strcmp0 (_tmp241_, "begin") == 0) {
			ValaMemberAccess* _tmp242_;
			ValaExpression* _tmp243_;
			ValaExpression* _tmp244_;
			ValaSymbol* _tmp245_;
			ValaSymbol* _tmp246_;
			ValaMemberAccess* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaSymbol* _tmp249_;
			_tmp242_ = ma;
			_tmp243_ = vala_member_access_get_inner (_tmp242_);
			_tmp244_ = _tmp243_;
			_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = ma;
			_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp247_);
			_tmp249_ = _tmp248_;
			_tmp238_ = _tmp246_ == _tmp249_;
		} else {
			_tmp238_ = FALSE;
		}
		if (_tmp238_) {
			ValaCCodeFunctionCall* _tmp250_;
			ValaCCodeFunctionCall* _tmp251_;
			ValaMethod* _tmp252_;
			ValaList* _tmp253_;
			_tmp250_ = async_call;
			_tmp251_ = _vala_ccode_node_ref0 (_tmp250_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp251_;
			_tmp252_ = m;
			_tmp253_ = vala_method_get_async_begin_parameters (_tmp252_);
			_vala_iterable_unref0 (params);
			params = _tmp253_;
		} else {
			gboolean _tmp254_ = FALSE;
			ValaMemberAccess* _tmp255_;
			const gchar* _tmp256_;
			const gchar* _tmp257_;
			_tmp255_ = ma;
			_tmp256_ = vala_member_access_get_member_name (_tmp255_);
			_tmp257_ = _tmp256_;
			if (g_strcmp0 (_tmp257_, "end") == 0) {
				ValaMemberAccess* _tmp258_;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				ValaMemberAccess* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				_tmp258_ = ma;
				_tmp259_ = vala_member_access_get_inner (_tmp258_);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = ma;
				_tmp264_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp263_);
				_tmp265_ = _tmp264_;
				_tmp254_ = _tmp262_ == _tmp265_;
			} else {
				_tmp254_ = FALSE;
			}
			if (_tmp254_) {
				ValaCCodeFunctionCall* _tmp266_;
				ValaCCodeFunctionCall* _tmp267_;
				ValaMethod* _tmp268_;
				ValaList* _tmp269_;
				_tmp266_ = finish_call;
				_tmp267_ = _vala_ccode_node_ref0 (_tmp266_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp267_;
				_tmp268_ = m;
				_tmp269_ = vala_method_get_async_end_parameters (_tmp268_);
				_vala_iterable_unref0 (params);
				params = _tmp269_;
			} else {
				gboolean _tmp270_;
				gboolean _tmp271_;
				_tmp270_ = vala_method_call_get_is_yield_expression (expr);
				_tmp271_ = _tmp270_;
				if (!_tmp271_) {
					ValaCCodeFunctionCall* _tmp272_;
					ValaCCodeFunctionCall* _tmp273_;
					ValaMethod* _tmp274_;
					ValaList* _tmp275_;
					_tmp272_ = async_call;
					_tmp273_ = _vala_ccode_node_ref0 (_tmp272_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp273_;
					_tmp274_ = m;
					_tmp275_ = vala_method_get_async_begin_parameters (_tmp274_);
					_vala_iterable_unref0 (params);
					params = _tmp275_;
				} else {
					ValaCCodeFunctionCall* _tmp276_;
					ValaCCodeFunctionCall* _tmp277_;
					GHashFunc _tmp278_;
					GEqualFunc _tmp279_;
					GEqualFunc _tmp280_;
					ValaHashMap* _tmp281_;
					ValaHashMap* _tmp282_;
					ValaMethod* _tmp283_;
					ValaCCodeIdentifier* _tmp284_;
					ValaCCodeIdentifier* _tmp285_;
					ValaCCodeMemberAccess* _tmp286_;
					ValaCCodeMemberAccess* _tmp287_;
					_tmp276_ = finish_call;
					_tmp277_ = _vala_ccode_node_ref0 (_tmp276_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp277_;
					_tmp278_ = g_direct_hash;
					_tmp279_ = g_direct_equal;
					_tmp280_ = g_direct_equal;
					_tmp281_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp278_, _tmp279_, _tmp280_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp281_;
					_tmp282_ = out_arg_map;
					_tmp283_ = m;
					_tmp284_ = vala_ccode_identifier_new ("_data_");
					_tmp285_ = _tmp284_;
					_tmp286_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp285_, "_res_");
					_tmp287_ = _tmp286_;
					vala_map_set ((ValaMap*) _tmp282_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp283_), FALSE)), (ValaCCodeExpression*) _tmp287_);
					_vala_ccode_node_unref0 (_tmp287_);
					_vala_ccode_node_unref0 (_tmp285_);
				}
			}
		}
	}
	_tmp289_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp289_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp290_;
		ValaSymbol* _tmp291_;
		ValaSymbol* _tmp292_;
		_tmp290_ = m;
		_tmp291_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp288_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_CLASS);
	} else {
		_tmp288_ = FALSE;
	}
	if (_tmp288_) {
		ValaCodeContext* _tmp293_;
		ValaCodeContext* _tmp294_;
		ValaProfile _tmp295_;
		ValaProfile _tmp296_;
		ValaClass* _tmp308_;
		ValaClass* _tmp309_;
		gboolean _tmp310_;
		gboolean _tmp311_;
		_tmp293_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_code_context_get_profile (_tmp294_);
		_tmp296_ = _tmp295_;
		if (_tmp296_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaSymbol* _tmp299_;
			gboolean _tmp300_;
			gboolean _tmp301_;
			_tmp297_ = m;
			_tmp298_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp299_, VALA_TYPE_CLASS, ValaClass));
			_tmp301_ = _tmp300_;
			if (!_tmp301_) {
				ValaCCodeFunctionCall* _tmp302_;
				ValaCCodeExpression* _tmp303_;
				ValaCCodeExpression* _tmp304_;
				_tmp302_ = ccall;
				_tmp303_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp304_ = _tmp303_;
				vala_ccode_function_call_add_argument (_tmp302_, _tmp304_);
				_vala_ccode_node_unref0 (_tmp304_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp305_;
			ValaCCodeExpression* _tmp306_;
			ValaCCodeExpression* _tmp307_;
			_tmp305_ = ccall;
			_tmp306_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp307_ = _tmp306_;
			vala_ccode_function_call_add_argument (_tmp305_, _tmp307_);
			_vala_ccode_node_unref0 (_tmp307_);
		}
		_tmp308_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp309_ = _tmp308_;
		_tmp310_ = vala_class_get_is_compact (_tmp309_);
		_tmp311_ = _tmp310_;
		if (!_tmp311_) {
			ValaClass* _tmp312_;
			ValaClass* _tmp313_;
			ValaMethod* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp312_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp313_ = _tmp312_;
			_tmp314_ = m;
			_tmp315_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp314_);
			_tmp316_ = _tmp315_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp313_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp316_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp317_;
					ValaClass* _tmp318_;
					ValaList* _tmp319_;
					gint _base_type_size = 0;
					ValaList* _tmp320_;
					gint _tmp321_;
					gint _tmp322_;
					gint _base_type_index = 0;
					_tmp317_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp318_ = _tmp317_;
					_tmp319_ = vala_class_get_base_types (_tmp318_);
					_base_type_list = _tmp319_;
					_tmp320_ = _base_type_list;
					_tmp321_ = vala_collection_get_size ((ValaCollection*) _tmp320_);
					_tmp322_ = _tmp321_;
					_base_type_size = _tmp322_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp323_;
						gpointer _tmp324_;
						ValaDataType* _tmp325_;
						ValaTypeSymbol* _tmp326_;
						ValaTypeSymbol* _tmp327_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp323_ = _base_type_list;
						_tmp324_ = vala_list_get (_tmp323_, _base_type_index);
						base_type = (ValaDataType*) _tmp324_;
						_tmp325_ = base_type;
						_tmp326_ = vala_data_type_get_data_type (_tmp325_);
						_tmp327_ = _tmp326_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp327_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp328_;
							gchar* _tmp329_;
							gchar* _tmp330_;
							gboolean _tmp331_;
							ValaHashMap* _tmp336_;
							ValaDataType* _tmp337_;
							ValaList* _tmp338_;
							ValaList* _tmp339_;
							ValaList* _tmp340_;
							type_parameters = NULL;
							_tmp328_ = m;
							_tmp329_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = g_strcmp0 (_tmp330_, "g_object_new") == 0;
							_g_free0 (_tmp330_);
							if (_tmp331_) {
								ValaDataType* _tmp332_;
								ValaTypeSymbol* _tmp333_;
								ValaTypeSymbol* _tmp334_;
								ValaList* _tmp335_;
								_tmp332_ = base_type;
								_tmp333_ = vala_data_type_get_data_type (_tmp332_);
								_tmp334_ = _tmp333_;
								_tmp335_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp335_;
							}
							_tmp336_ = in_arg_map;
							_tmp337_ = base_type;
							_tmp338_ = vala_data_type_get_type_arguments (_tmp337_);
							_tmp339_ = _tmp338_;
							_tmp340_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp336_, _tmp339_, (ValaCodeNode*) expr, TRUE, _tmp340_);
							_vala_iterable_unref0 (_tmp339_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp341_;
				ValaSymbol* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaClass* _tmp344_;
				type_param_index = 0;
				_tmp341_ = m;
				_tmp342_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp341_);
				_tmp343_ = _tmp342_;
				_tmp344_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp343_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp344_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp345_;
					ValaList* _tmp346_;
					gint _type_param_size = 0;
					ValaList* _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _type_param_index = 0;
					_tmp345_ = cl;
					_tmp346_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp345_);
					_type_param_list = _tmp346_;
					_tmp347_ = _type_param_list;
					_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
					_tmp349_ = _tmp348_;
					_type_param_size = _tmp349_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp350_;
						gpointer _tmp351_;
						ValaHashMap* _tmp352_;
						ValaTypeParameter* _tmp353_;
						const gchar* _tmp354_;
						const gchar* _tmp355_;
						gchar* _tmp356_;
						gchar* _tmp357_;
						gchar* _tmp358_;
						gchar* _tmp359_;
						ValaCCodeIdentifier* _tmp360_;
						ValaCCodeIdentifier* _tmp361_;
						ValaHashMap* _tmp362_;
						ValaTypeParameter* _tmp363_;
						const gchar* _tmp364_;
						const gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						gchar* _tmp368_;
						gchar* _tmp369_;
						ValaCCodeIdentifier* _tmp370_;
						ValaCCodeIdentifier* _tmp371_;
						ValaHashMap* _tmp372_;
						ValaTypeParameter* _tmp373_;
						const gchar* _tmp374_;
						const gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						gchar* _tmp378_;
						gchar* _tmp379_;
						ValaCCodeIdentifier* _tmp380_;
						ValaCCodeIdentifier* _tmp381_;
						gint _tmp382_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp350_ = _type_param_list;
						_tmp351_ = vala_list_get (_tmp350_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp351_;
						_tmp352_ = in_arg_map;
						_tmp353_ = type_param;
						_tmp354_ = vala_symbol_get_name ((ValaSymbol*) _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = g_utf8_strdown (_tmp355_, (gssize) -1);
						_tmp357_ = _tmp356_;
						_tmp358_ = g_strdup_printf ("%s_type", _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = vala_ccode_identifier_new (_tmp359_);
						_tmp361_ = _tmp360_;
						vala_map_set ((ValaMap*) _tmp352_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp361_);
						_vala_ccode_node_unref0 (_tmp361_);
						_g_free0 (_tmp359_);
						_g_free0 (_tmp357_);
						_tmp362_ = in_arg_map;
						_tmp363_ = type_param;
						_tmp364_ = vala_symbol_get_name ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_utf8_strdown (_tmp365_, (gssize) -1);
						_tmp367_ = _tmp366_;
						_tmp368_ = g_strdup_printf ("%s_dup_func", _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = vala_ccode_identifier_new (_tmp369_);
						_tmp371_ = _tmp370_;
						vala_map_set ((ValaMap*) _tmp362_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp371_);
						_vala_ccode_node_unref0 (_tmp371_);
						_g_free0 (_tmp369_);
						_g_free0 (_tmp367_);
						_tmp372_ = in_arg_map;
						_tmp373_ = type_param;
						_tmp374_ = vala_symbol_get_name ((ValaSymbol*) _tmp373_);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_utf8_strdown (_tmp375_, (gssize) -1);
						_tmp377_ = _tmp376_;
						_tmp378_ = g_strdup_printf ("%s_destroy_func", _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = vala_ccode_identifier_new (_tmp379_);
						_tmp381_ = _tmp380_;
						vala_map_set ((ValaMap*) _tmp372_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp381_);
						_vala_ccode_node_unref0 (_tmp381_);
						_g_free0 (_tmp379_);
						_g_free0 (_tmp377_);
						_tmp382_ = type_param_index;
						type_param_index = _tmp382_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			ValaClass* _tmp386_;
			ValaClass* _tmp387_;
			_tmp383_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_class_get_base_class (_tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp386_ == _tmp387_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp388_;
				ValaClass* _tmp389_;
				gchar* _tmp390_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp391_;
				ValaCCodeDeclaration* _tmp392_;
				ValaCCodeDeclaration* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				const gchar* _tmp396_;
				const gchar* _tmp397_;
				gchar* _tmp398_;
				gchar* _tmp399_;
				ValaCCodeConstant* _tmp400_;
				ValaCCodeConstant* _tmp401_;
				ValaCCodeVariableDeclarator* _tmp402_;
				ValaCCodeVariableDeclarator* _tmp403_;
				ValaCCodeFunction* _tmp404_;
				ValaCCodeFunction* _tmp405_;
				ValaCCodeDeclaration* _tmp406_;
				ValaCCodeFunctionCall* _tmp407_;
				ValaCCodeIdentifier* _tmp408_;
				ValaCCodeIdentifier* _tmp409_;
				ValaCCodeUnaryExpression* _tmp410_;
				ValaCCodeUnaryExpression* _tmp411_;
				ValaCCodeCastExpression* _tmp412_;
				ValaCCodeCastExpression* _tmp413_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeIdentifier* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaCCodeFunctionCall* _tmp417_;
				ValaCCodeFunctionCall* _tmp418_;
				ValaClass* _tmp419_;
				ValaClass* _tmp420_;
				gchar* _tmp421_;
				gchar* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeIdentifier* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				ValaCCodeFunctionCall* _tmp426_;
				_tmp388_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp389_, NULL);
				class_prefix = _tmp390_;
				_tmp391_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp391_;
				_tmp392_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp392_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp393_ = funcs;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = class_prefix;
				_tmp397_ = class_prefix;
				_tmp398_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp394_, _tmp395_, _tmp396_, _tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_constant_new (_tmp399_);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp401_, NULL);
				_tmp403_ = _tmp402_;
				vala_ccode_declaration_add_declarator (_tmp393_, (ValaCCodeDeclarator*) _tmp403_);
				_vala_ccode_node_unref0 (_tmp403_);
				_vala_ccode_node_unref0 (_tmp401_);
				_g_free0 (_tmp399_);
				_tmp404_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp405_ = _tmp404_;
				_tmp406_ = funcs;
				vala_ccode_function_add_statement (_tmp405_, (ValaCCodeNode*) _tmp406_);
				_tmp407_ = ccall;
				_tmp408_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp409_);
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp411_, "GSourceFuncs *");
				_tmp413_ = _tmp412_;
				vala_ccode_function_call_add_argument (_tmp407_, (ValaCCodeExpression*) _tmp413_);
				_vala_ccode_node_unref0 (_tmp413_);
				_vala_ccode_node_unref0 (_tmp411_);
				_vala_ccode_node_unref0 (_tmp409_);
				_tmp414_ = vala_ccode_identifier_new ("sizeof");
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp415_);
				_tmp417_ = _tmp416_;
				_vala_ccode_node_unref0 (_tmp415_);
				csizeof = _tmp417_;
				_tmp418_ = csizeof;
				_tmp419_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp420_ = _tmp419_;
				_tmp421_ = vala_get_ccode_name ((ValaCodeNode*) _tmp420_);
				_tmp422_ = _tmp421_;
				_tmp423_ = vala_ccode_identifier_new (_tmp422_);
				_tmp424_ = _tmp423_;
				vala_ccode_function_call_add_argument (_tmp418_, (ValaCCodeExpression*) _tmp424_);
				_vala_ccode_node_unref0 (_tmp424_);
				_g_free0 (_tmp422_);
				_tmp425_ = ccall;
				_tmp426_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp425_, (ValaCCodeExpression*) _tmp426_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp427_ = FALSE;
		ValaMethod* _tmp428_;
		_tmp428_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp428_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp429_;
			ValaSymbol* _tmp430_;
			ValaSymbol* _tmp431_;
			_tmp429_ = m;
			_tmp430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp427_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp431_, VALA_TYPE_STRUCT);
		} else {
			_tmp427_ = FALSE;
		}
		if (_tmp427_) {
			ValaCCodeFunctionCall* _tmp432_;
			ValaCCodeExpression* _tmp433_;
			ValaCCodeExpression* _tmp434_;
			_tmp432_ = ccall;
			_tmp433_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp434_ = _tmp433_;
			vala_ccode_function_call_add_argument (_tmp432_, _tmp434_);
			_vala_ccode_node_unref0 (_tmp434_);
		} else {
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			gboolean _tmp437_ = FALSE;
			gboolean _tmp438_ = FALSE;
			ValaMethod* _tmp439_;
			_tmp439_ = m;
			if (_tmp439_ != NULL) {
				ValaMethod* _tmp440_;
				_tmp440_ = m;
				_tmp438_ = vala_method_has_type_parameters (_tmp440_);
			} else {
				_tmp438_ = FALSE;
			}
			if (_tmp438_) {
				ValaMethod* _tmp441_;
				_tmp441_ = m;
				_tmp437_ = !vala_get_ccode_has_generic_type_parameter (_tmp441_);
			} else {
				_tmp437_ = FALSE;
			}
			if (_tmp437_) {
				ValaMethod* _tmp442_;
				_tmp442_ = m;
				_tmp436_ = !vala_get_ccode_simple_generics (_tmp442_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				gboolean _tmp443_ = FALSE;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				_tmp444_ = ccall;
				_tmp445_ = finish_call;
				if (_tmp444_ != _tmp445_) {
					_tmp443_ = TRUE;
				} else {
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp446_ = vala_method_call_get_is_yield_expression (expr);
					_tmp447_ = _tmp446_;
					_tmp443_ = _tmp447_;
				}
				_tmp435_ = _tmp443_;
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				ValaHashMap* _tmp448_;
				ValaMemberAccess* _tmp449_;
				ValaList* _tmp450_;
				ValaList* _tmp451_;
				_tmp448_ = in_arg_map;
				_tmp449_ = ma;
				_tmp450_ = vala_member_access_get_type_arguments (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp448_, _tmp451_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp451_);
			}
		}
	}
	_tmp452_ = ccall;
	_tmp453_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp452_);
	ccall_expr = _tmp453_;
	_tmp454_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp455_;
		ValaExpression* _tmp456_;
		ValaExpression* _tmp457_;
		ValaDataType* _tmp458_;
		ValaDataType* _tmp459_;
		ValaArrayType* _tmp460_;
		ValaHashMap* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaDataType* _tmp463_;
		ValaDataType* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		ValaCCodeIdentifier* _tmp467_;
		ValaCCodeIdentifier* _tmp468_;
		_tmp455_ = ma;
		_tmp456_ = vala_member_access_get_inner (_tmp455_);
		_tmp457_ = _tmp456_;
		_tmp458_ = vala_expression_get_value_type (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp460_;
		_tmp461_ = in_arg_map;
		_tmp462_ = array_type;
		_tmp463_ = vala_array_type_get_element_type (_tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_get_ccode_name ((ValaCodeNode*) _tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_ccode_identifier_new (_tmp466_);
		_tmp468_ = _tmp467_;
		vala_map_set ((ValaMap*) _tmp461_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp468_);
		_vala_ccode_node_unref0 (_tmp468_);
		_g_free0 (_tmp466_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp469_;
		_tmp469_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp469_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp470_;
			_tmp470_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp471_;
				ValaExpression* _tmp472_;
				ValaExpression* _tmp473_;
				ValaTargetValue* _tmp474_;
				ValaTargetValue* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				_tmp471_ = ma;
				_tmp472_ = vala_member_access_get_inner (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_expression_get_target_value (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp475_, (ValaCodeNode*) expr);
				_tmp477_ = _tmp476_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp477_);
				_vala_target_value_unref0 (_tmp477_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp479_ = m;
	if (_tmp479_ != NULL) {
		ValaMethod* _tmp480_;
		gboolean _tmp481_;
		gboolean _tmp482_;
		_tmp480_ = m;
		_tmp481_ = vala_method_get_is_async_callback (_tmp480_);
		_tmp482_ = _tmp481_;
		_tmp478_ = _tmp482_;
	} else {
		_tmp478_ = FALSE;
	}
	if (_tmp478_) {
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		ValaHashMap* _tmp500_;
		ValaMethod* _tmp501_;
		ValaCCodeExpression* _tmp502_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		_tmp483_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_closure (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp487_;
			ValaSymbol* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaBlock* _tmp490_;
			ValaBlock* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			gchar* _tmp494_;
			gchar* _tmp495_;
			ValaCCodeExpression* _tmp496_;
			ValaCCodeExpression* _tmp497_;
			ValaCCodeMemberAccess* _tmp498_;
			_tmp487_ = m;
			_tmp488_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD, ValaMethod));
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_code_node_ref0 (_tmp491_);
			block = _tmp492_;
			_tmp493_ = block;
			_tmp494_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp493_));
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_member_access_new_pointer (_tmp497_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp498_;
			_vala_ccode_node_unref0 (_tmp497_);
			_g_free0 (_tmp495_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp499_;
			_tmp499_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp499_;
		}
		_tmp500_ = in_arg_map;
		_tmp501_ = m;
		_tmp502_ = instance;
		vala_map_set ((ValaMap*) _tmp500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp501_), FALSE)), _tmp502_);
		_tmp503_ = out_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
	} else {
		gboolean _tmp506_ = FALSE;
		gboolean _tmp507_ = FALSE;
		ValaMethod* _tmp508_;
		_tmp508_ = m;
		if (_tmp508_ != NULL) {
			ValaMethod* _tmp509_;
			ValaMemberBinding _tmp510_;
			ValaMemberBinding _tmp511_;
			_tmp509_ = m;
			_tmp510_ = vala_method_get_binding (_tmp509_);
			_tmp511_ = _tmp510_;
			_tmp507_ = _tmp511_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaMethod* _tmp512_;
			_tmp512_ = m;
			_tmp506_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaTargetValue* _tmp516_;
			ValaTargetValue* _tmp517_;
			ValaTargetValue* _tmp518_;
			gboolean _tmp519_ = FALSE;
			gboolean _tmp520_ = FALSE;
			ValaMemberAccess* _tmp521_;
			const gchar* _tmp522_;
			const gchar* _tmp523_;
			ValaTargetValue* _tmp545_;
			ValaCCodeExpression* _tmp546_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaStruct* _tmp550_;
			gboolean _tmp551_ = FALSE;
			ValaStruct* _tmp552_;
			gboolean _tmp561_;
			gboolean _tmp562_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_inner (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_expression_get_target_value (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_target_value_ref0 (_tmp517_);
			instance_value = _tmp518_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_member_name (_tmp521_);
			_tmp523_ = _tmp522_;
			if (g_strcmp0 (_tmp523_, "begin") == 0) {
				_tmp520_ = TRUE;
			} else {
				ValaMemberAccess* _tmp524_;
				const gchar* _tmp525_;
				const gchar* _tmp526_;
				_tmp524_ = ma;
				_tmp525_ = vala_member_access_get_member_name (_tmp524_);
				_tmp526_ = _tmp525_;
				_tmp520_ = g_strcmp0 (_tmp526_, "end") == 0;
			}
			if (_tmp520_) {
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaSymbol* _tmp530_;
				ValaSymbol* _tmp531_;
				ValaMemberAccess* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_symbol_reference (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = ma;
				_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp519_ = _tmp531_ == _tmp534_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaTargetValue* _tmp542_;
				ValaTargetValue* _tmp543_;
				ValaTargetValue* _tmp544_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp537_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp538_;
				_tmp539_ = inner_ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_target_value (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = _vala_target_value_ref0 (_tmp543_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp544_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp545_ = instance_value;
			_tmp546_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp545_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp546_;
			_tmp547_ = m;
			_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp549_) : NULL);
			st = _tmp550_;
			_tmp552_ = st;
			if (_tmp552_ != NULL) {
				ValaStruct* _tmp553_;
				_tmp553_ = st;
				_tmp551_ = !vala_struct_is_simple_type (_tmp553_);
			} else {
				_tmp551_ = FALSE;
			}
			if (_tmp551_) {
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp557_;
				ValaCCodeExpression* _tmp558_;
				ValaCCodeExpression* _tmp559_;
				ValaCCodeUnaryExpression* _tmp560_;
				_tmp554_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp554_)) {
					ValaTargetValue* _tmp555_;
					ValaTargetValue* _tmp556_;
					_tmp555_ = instance_value;
					_tmp556_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp555_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp556_;
				}
				_tmp557_ = instance_value;
				_tmp558_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp559_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp560_;
				_vala_ccode_node_unref0 (_tmp559_);
			}
			_tmp561_ = vala_method_call_get_is_yield_expression (expr);
			_tmp562_ = _tmp561_;
			if (_tmp562_) {
				ValaHashMap* _tmp563_;
				ValaMethod* _tmp564_;
				ValaCCodeExpression* _tmp565_;
				ValaMethod* _tmp566_;
				_tmp563_ = in_arg_map;
				_tmp564_ = m;
				_tmp565_ = instance;
				vala_map_set ((ValaMap*) _tmp563_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp564_), FALSE)), _tmp565_);
				_tmp566_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp566_)) {
					ValaHashMap* _tmp567_;
					ValaMethod* _tmp568_;
					ValaCCodeExpression* _tmp569_;
					_tmp567_ = out_arg_map;
					_tmp568_ = m;
					_tmp569_ = instance;
					vala_map_set ((ValaMap*) _tmp567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp568_), FALSE)), _tmp569_);
				}
			} else {
				gboolean _tmp570_ = FALSE;
				ValaMemberAccess* _tmp571_;
				const gchar* _tmp572_;
				const gchar* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_member_name (_tmp571_);
				_tmp573_ = _tmp572_;
				if (g_strcmp0 (_tmp573_, "end") != 0) {
					_tmp570_ = TRUE;
				} else {
					ValaMethod* _tmp574_;
					_tmp574_ = m;
					_tmp570_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_);
				}
				if (_tmp570_) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
					_tmp578_ = in_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp581_ = FALSE;
			ValaMethod* _tmp582_;
			_tmp582_ = m;
			if (_tmp582_ != NULL) {
				ValaMethod* _tmp583_;
				ValaMemberBinding _tmp584_;
				ValaMemberBinding _tmp585_;
				_tmp583_ = m;
				_tmp584_ = vala_method_get_binding (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp581_ = _tmp585_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp581_ = FALSE;
			}
			if (_tmp581_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp586_;
				ValaSymbol* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaClass* _tmp589_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp590_;
				gchar* _tmp591_;
				gchar* _tmp592_;
				ValaCCodeIdentifier* _tmp593_;
				ValaCCodeIdentifier* _tmp594_;
				ValaCCodeFunctionCall* _tmp595_;
				ValaCCodeFunctionCall* _tmp596_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				ValaCCodeFunctionCall* _tmp625_;
				ValaCCodeExpression* _tmp626_;
				ValaHashMap* _tmp627_;
				ValaMethod* _tmp628_;
				ValaCCodeFunctionCall* _tmp629_;
				ValaHashMap* _tmp630_;
				ValaMethod* _tmp631_;
				ValaCCodeFunctionCall* _tmp632_;
				_tmp586_ = m;
				_tmp587_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp586_);
				_tmp588_ = _tmp587_;
				_tmp589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp589_;
				_tmp590_ = cl;
				_tmp591_ = vala_get_ccode_class_type_function (_tmp590_);
				_tmp592_ = _tmp591_;
				_tmp593_ = vala_ccode_identifier_new (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp594_);
				_tmp596_ = _tmp595_;
				_vala_ccode_node_unref0 (_tmp594_);
				_g_free0 (_tmp592_);
				cast = _tmp596_;
				_tmp597_ = ma;
				_tmp598_ = vala_member_access_get_inner (_tmp597_);
				_tmp599_ = _tmp598_;
				if (_tmp599_ == NULL) {
					ValaDataType* _tmp600_;
					ValaDataType* _tmp601_;
					gboolean _tmp602_;
					_tmp600_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp601_ = _tmp600_;
					_tmp602_ = _tmp601_ == NULL;
					_vala_code_node_unref0 (_tmp601_);
					if (_tmp602_) {
						ValaCCodeIdentifier* _tmp603_;
						_tmp603_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp603_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp604_;
						ValaCCodeIdentifier* _tmp605_;
						ValaCCodeFunctionCall* _tmp606_;
						ValaCCodeFunctionCall* _tmp607_;
						ValaCCodeFunctionCall* _tmp608_;
						ValaCCodeExpression* _tmp609_;
						ValaCCodeExpression* _tmp610_;
						ValaCCodeFunctionCall* _tmp611_;
						ValaCCodeExpression* _tmp612_;
						_tmp604_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp605_ = _tmp604_;
						_tmp606_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp605_);
						_tmp607_ = _tmp606_;
						_vala_ccode_node_unref0 (_tmp605_);
						k = _tmp607_;
						_tmp608_ = k;
						_tmp609_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp610_ = _tmp609_;
						vala_ccode_function_call_add_argument (_tmp608_, _tmp610_);
						_vala_ccode_node_unref0 (_tmp610_);
						_tmp611_ = k;
						_tmp612_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp611_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp612_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp613_;
					ValaCCodeIdentifier* _tmp614_;
					ValaCCodeFunctionCall* _tmp615_;
					ValaCCodeFunctionCall* _tmp616_;
					ValaCCodeFunctionCall* _tmp617_;
					ValaMemberAccess* _tmp618_;
					ValaExpression* _tmp619_;
					ValaExpression* _tmp620_;
					ValaCCodeExpression* _tmp621_;
					ValaCCodeExpression* _tmp622_;
					ValaCCodeFunctionCall* _tmp623_;
					ValaCCodeExpression* _tmp624_;
					_tmp613_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp614_);
					_tmp616_ = _tmp615_;
					_vala_ccode_node_unref0 (_tmp614_);
					k = _tmp616_;
					_tmp617_ = k;
					_tmp618_ = ma;
					_tmp619_ = vala_member_access_get_inner (_tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp620_);
					_tmp622_ = _tmp621_;
					vala_ccode_function_call_add_argument (_tmp617_, _tmp622_);
					_vala_ccode_node_unref0 (_tmp622_);
					_tmp623_ = k;
					_tmp624_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp623_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp624_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp625_ = cast;
				_tmp626_ = klass;
				vala_ccode_function_call_add_argument (_tmp625_, _tmp626_);
				_tmp627_ = in_arg_map;
				_tmp628_ = m;
				_tmp629_ = cast;
				vala_map_set ((ValaMap*) _tmp627_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp628_), FALSE)), (ValaCCodeExpression*) _tmp629_);
				_tmp630_ = out_arg_map;
				_tmp631_ = m;
				_tmp632_ = cast;
				vala_map_set ((ValaMap*) _tmp630_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp631_), FALSE)), (ValaCCodeExpression*) _tmp632_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp634_ = m;
	if (_tmp634_ != NULL) {
		ValaMethod* _tmp635_;
		_tmp635_ = m;
		_tmp633_ = vala_get_ccode_has_generic_type_parameter (_tmp635_);
	} else {
		_tmp633_ = FALSE;
	}
	if (_tmp633_) {
		ValaMethod* _tmp636_;
		_tmp636_ = m;
		if (vala_method_has_type_parameters (_tmp636_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp637_;
				ValaList* _tmp638_;
				gint _type_arg_size = 0;
				ValaList* _tmp639_;
				gint _tmp640_;
				gint _tmp641_;
				gint _type_arg_index = 0;
				_tmp637_ = ma;
				_tmp638_ = vala_member_access_get_type_arguments (_tmp637_);
				_type_arg_list = _tmp638_;
				_tmp639_ = _type_arg_list;
				_tmp640_ = vala_collection_get_size ((ValaCollection*) _tmp639_);
				_tmp641_ = _tmp640_;
				_type_arg_size = _tmp641_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp642_;
					gpointer _tmp643_;
					gboolean _tmp644_ = FALSE;
					gboolean _tmp645_ = FALSE;
					gboolean _tmp646_ = FALSE;
					ValaMethod* _tmp647_;
					ValaHashMap* _tmp655_;
					ValaMethod* _tmp656_;
					ValaDataType* _tmp657_;
					gchar* _tmp658_;
					gchar* _tmp659_;
					ValaCCodeIdentifier* _tmp660_;
					ValaCCodeIdentifier* _tmp661_;
					gint _tmp662_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp642_ = _type_arg_list;
					_tmp643_ = vala_list_get (_tmp642_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp643_;
					_tmp647_ = m;
					if (vala_get_ccode_simple_generics (_tmp647_)) {
						ValaDataType* _tmp648_;
						_tmp648_ = type_arg;
						_tmp646_ = vala_data_type_is_real_struct_type (_tmp648_);
					} else {
						_tmp646_ = FALSE;
					}
					if (_tmp646_) {
						ValaDataType* _tmp649_;
						gboolean _tmp650_;
						gboolean _tmp651_;
						_tmp649_ = type_arg;
						_tmp650_ = vala_data_type_get_nullable (_tmp649_);
						_tmp651_ = _tmp650_;
						_tmp645_ = !_tmp651_;
					} else {
						_tmp645_ = FALSE;
					}
					if (_tmp645_) {
						ValaDataType* _tmp652_;
						_tmp652_ = type_arg;
						_tmp644_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp652_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp644_ = FALSE;
					}
					if (_tmp644_) {
						ValaDataType* _tmp653_;
						ValaPointerType* _tmp654_;
						_tmp653_ = type_arg;
						_tmp654_ = vala_pointer_type_new (_tmp653_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp654_;
					}
					_tmp655_ = in_arg_map;
					_tmp656_ = m;
					_tmp657_ = type_arg;
					_tmp658_ = vala_get_ccode_name ((ValaCodeNode*) _tmp657_);
					_tmp659_ = _tmp658_;
					_tmp660_ = vala_ccode_identifier_new (_tmp659_);
					_tmp661_ = _tmp660_;
					vala_map_set ((ValaMap*) _tmp655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp656_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp661_);
					_vala_ccode_node_unref0 (_tmp661_);
					_g_free0 (_tmp659_);
					_tmp662_ = type_param_index;
					type_param_index = _tmp662_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp663_;
				ValaExpression* _tmp664_;
				ValaExpression* _tmp665_;
				ValaDataType* _tmp666_;
				ValaDataType* _tmp667_;
				ValaList* _tmp668_;
				gint _type_arg_size = 0;
				ValaList* _tmp669_;
				gint _tmp670_;
				gint _tmp671_;
				gint _type_arg_index = 0;
				_tmp663_ = ma;
				_tmp664_ = vala_member_access_get_inner (_tmp663_);
				_tmp665_ = _tmp664_;
				_tmp666_ = vala_expression_get_value_type (_tmp665_);
				_tmp667_ = _tmp666_;
				_tmp668_ = vala_data_type_get_type_arguments (_tmp667_);
				_type_arg_list = _tmp668_;
				_tmp669_ = _type_arg_list;
				_tmp670_ = vala_collection_get_size ((ValaCollection*) _tmp669_);
				_tmp671_ = _tmp670_;
				_type_arg_size = _tmp671_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp672_;
					gpointer _tmp673_;
					ValaHashMap* _tmp674_;
					ValaMethod* _tmp675_;
					ValaDataType* _tmp676_;
					gchar* _tmp677_;
					gchar* _tmp678_;
					ValaCCodeIdentifier* _tmp679_;
					ValaCCodeIdentifier* _tmp680_;
					gint _tmp681_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp672_ = _type_arg_list;
					_tmp673_ = vala_list_get (_tmp672_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp673_;
					_tmp674_ = in_arg_map;
					_tmp675_ = m;
					_tmp676_ = type_arg;
					_tmp677_ = vala_get_ccode_name ((ValaCodeNode*) _tmp676_);
					_tmp678_ = _tmp677_;
					_tmp679_ = vala_ccode_identifier_new (_tmp678_);
					_tmp680_ = _tmp679_;
					vala_map_set ((ValaMap*) _tmp674_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp675_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp680_);
					_vala_ccode_node_unref0 (_tmp680_);
					_g_free0 (_tmp678_);
					_tmp681_ = type_param_index;
					type_param_index = _tmp681_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp682_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp682_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp683_;
		ValaExpression* _tmp684_;
		ValaExpression* _tmp685_;
		ValaDataType* _tmp686_;
		ValaDataType* _tmp687_;
		ValaArrayType* _tmp688_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp689_;
		ValaCCodeIdentifier* _tmp690_;
		ValaCCodeFunctionCall* _tmp691_;
		ValaCCodeFunctionCall* _tmp692_;
		ValaCCodeFunctionCall* _tmp693_;
		ValaArrayType* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		gchar* _tmp697_;
		gchar* _tmp698_;
		ValaCCodeIdentifier* _tmp699_;
		ValaCCodeIdentifier* _tmp700_;
		ValaHashMap* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		_tmp683_ = ma;
		_tmp684_ = vala_member_access_get_inner (_tmp683_);
		_tmp685_ = _tmp684_;
		_tmp686_ = vala_expression_get_value_type (_tmp685_);
		_tmp687_ = _tmp686_;
		_tmp688_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp687_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp688_;
		_tmp689_ = vala_ccode_identifier_new ("sizeof");
		_tmp690_ = _tmp689_;
		_tmp691_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp690_);
		_tmp692_ = _tmp691_;
		_vala_ccode_node_unref0 (_tmp690_);
		csizeof = _tmp692_;
		_tmp693_ = csizeof;
		_tmp694_ = array_type;
		_tmp695_ = vala_array_type_get_element_type (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_get_ccode_name ((ValaCodeNode*) _tmp696_);
		_tmp698_ = _tmp697_;
		_tmp699_ = vala_ccode_identifier_new (_tmp698_);
		_tmp700_ = _tmp699_;
		vala_ccode_function_call_add_argument (_tmp693_, (ValaCCodeExpression*) _tmp700_);
		_vala_ccode_node_unref0 (_tmp700_);
		_g_free0 (_tmp698_);
		_tmp701_ = in_arg_map;
		_tmp702_ = csizeof;
		vala_map_set ((ValaMap*) _tmp701_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp702_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp703_;
		_tmp703_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp703_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp704_;
			ValaMethod* _tmp705_;
			ValaMethod* _tmp706_;
			gint param_nr = 0;
			ValaMethod* _tmp766_;
			ValaCCodeBaseModuleEmitContext* _tmp767_;
			_tmp704_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp705_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp704_, (ValaSymbol*) _tmp705_);
			_tmp706_ = m;
			vala_method_clear_parameters (_tmp706_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp707_;
				gint _arg_size = 0;
				ValaList* _tmp708_;
				gint _tmp709_;
				gint _tmp710_;
				gint _arg_index = 0;
				_tmp707_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp707_;
				_tmp708_ = _arg_list;
				_tmp709_ = vala_collection_get_size ((ValaCollection*) _tmp708_);
				_tmp710_ = _tmp709_;
				_arg_size = _tmp710_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp711_;
					gpointer _tmp712_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp713_;
					ValaUnaryExpression* _tmp714_;
					gboolean _tmp715_ = FALSE;
					ValaUnaryExpression* _tmp716_;
					gint _tmp757_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp711_ = _arg_list;
					_tmp712_ = vala_list_get (_tmp711_, _arg_index);
					arg = (ValaExpression*) _tmp712_;
					_tmp713_ = arg;
					_tmp714_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp713_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp713_) : NULL);
					unary = _tmp714_;
					_tmp716_ = unary;
					if (_tmp716_ != NULL) {
						ValaUnaryExpression* _tmp717_;
						ValaUnaryOperator _tmp718_;
						ValaUnaryOperator _tmp719_;
						_tmp717_ = unary;
						_tmp718_ = vala_unary_expression_get_operator (_tmp717_);
						_tmp719_ = _tmp718_;
						_tmp715_ = _tmp719_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp715_ = FALSE;
					}
					if (_tmp715_) {
						ValaParameter* param = NULL;
						gchar* _tmp720_;
						gchar* _tmp721_;
						ValaUnaryExpression* _tmp722_;
						ValaExpression* _tmp723_;
						ValaExpression* _tmp724_;
						ValaDataType* _tmp725_;
						ValaDataType* _tmp726_;
						ValaParameter* _tmp727_;
						ValaParameter* _tmp728_;
						ValaParameter* _tmp729_;
						ValaMethod* _tmp730_;
						ValaParameter* _tmp731_;
						_tmp720_ = g_strdup_printf ("param%d", param_nr);
						_tmp721_ = _tmp720_;
						_tmp722_ = unary;
						_tmp723_ = vala_unary_expression_get_inner (_tmp722_);
						_tmp724_ = _tmp723_;
						_tmp725_ = vala_expression_get_value_type (_tmp724_);
						_tmp726_ = _tmp725_;
						_tmp727_ = vala_parameter_new (_tmp721_, _tmp726_, NULL);
						_tmp728_ = _tmp727_;
						_g_free0 (_tmp721_);
						param = _tmp728_;
						_tmp729_ = param;
						vala_parameter_set_direction (_tmp729_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp730_ = m;
						_tmp731_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp730_, _tmp731_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp732_ = FALSE;
						ValaUnaryExpression* _tmp733_;
						_tmp733_ = unary;
						if (_tmp733_ != NULL) {
							ValaUnaryExpression* _tmp734_;
							ValaUnaryOperator _tmp735_;
							ValaUnaryOperator _tmp736_;
							_tmp734_ = unary;
							_tmp735_ = vala_unary_expression_get_operator (_tmp734_);
							_tmp736_ = _tmp735_;
							_tmp732_ = _tmp736_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp732_ = FALSE;
						}
						if (_tmp732_) {
							ValaParameter* param = NULL;
							gchar* _tmp737_;
							gchar* _tmp738_;
							ValaUnaryExpression* _tmp739_;
							ValaExpression* _tmp740_;
							ValaExpression* _tmp741_;
							ValaDataType* _tmp742_;
							ValaDataType* _tmp743_;
							ValaParameter* _tmp744_;
							ValaParameter* _tmp745_;
							ValaParameter* _tmp746_;
							ValaMethod* _tmp747_;
							ValaParameter* _tmp748_;
							_tmp737_ = g_strdup_printf ("param%d", param_nr);
							_tmp738_ = _tmp737_;
							_tmp739_ = unary;
							_tmp740_ = vala_unary_expression_get_inner (_tmp739_);
							_tmp741_ = _tmp740_;
							_tmp742_ = vala_expression_get_value_type (_tmp741_);
							_tmp743_ = _tmp742_;
							_tmp744_ = vala_parameter_new (_tmp738_, _tmp743_, NULL);
							_tmp745_ = _tmp744_;
							_g_free0 (_tmp738_);
							param = _tmp745_;
							_tmp746_ = param;
							vala_parameter_set_direction (_tmp746_, VALA_PARAMETER_DIRECTION_REF);
							_tmp747_ = m;
							_tmp748_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp747_, _tmp748_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp749_;
							gchar* _tmp750_;
							gchar* _tmp751_;
							ValaExpression* _tmp752_;
							ValaDataType* _tmp753_;
							ValaDataType* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							_tmp749_ = m;
							_tmp750_ = g_strdup_printf ("param%d", param_nr);
							_tmp751_ = _tmp750_;
							_tmp752_ = arg;
							_tmp753_ = vala_expression_get_value_type (_tmp752_);
							_tmp754_ = _tmp753_;
							_tmp755_ = vala_parameter_new (_tmp751_, _tmp754_, NULL);
							_tmp756_ = _tmp755_;
							vala_callable_add_parameter ((ValaCallable*) _tmp749_, _tmp756_);
							_vala_code_node_unref0 (_tmp756_);
							_g_free0 (_tmp751_);
						}
					}
					_tmp757_ = param_nr;
					param_nr = _tmp757_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp758_;
				ValaList* _tmp759_;
				gint _param_size = 0;
				ValaList* _tmp760_;
				gint _tmp761_;
				gint _tmp762_;
				gint _param_index = 0;
				_tmp758_ = m;
				_tmp759_ = vala_callable_get_parameters ((ValaCallable*) _tmp758_);
				_param_list = _tmp759_;
				_tmp760_ = _param_list;
				_tmp761_ = vala_collection_get_size ((ValaCollection*) _tmp760_);
				_tmp762_ = _tmp761_;
				_param_size = _tmp762_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp763_;
					gpointer _tmp764_;
					ValaParameter* _tmp765_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp763_ = _param_list;
					_tmp764_ = vala_list_get (_tmp763_, _param_index);
					param = (ValaParameter*) _tmp764_;
					_tmp765_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp765_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp766_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp766_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp767_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp767_);
		} else {
			gboolean _tmp768_ = FALSE;
			gboolean _tmp769_ = FALSE;
			ValaMethod* _tmp770_;
			_tmp770_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp770_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp771_;
				ValaCodeContext* _tmp772_;
				ValaProfile _tmp773_;
				ValaProfile _tmp774_;
				_tmp771_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp772_ = _tmp771_;
				_tmp773_ = vala_code_context_get_profile (_tmp772_);
				_tmp774_ = _tmp773_;
				_tmp769_ = _tmp774_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp769_ = FALSE;
			}
			if (_tmp769_) {
				ValaMethod* _tmp775_;
				ValaSymbol* _tmp776_;
				ValaSymbol* _tmp777_;
				_tmp775_ = m;
				_tmp776_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp775_);
				_tmp777_ = _tmp776_;
				_tmp768_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp777_, VALA_TYPE_CLASS);
			} else {
				_tmp768_ = FALSE;
			}
			if (_tmp768_) {
				ValaCCodeFunction* _tmp778_;
				ValaCCodeFunction* _tmp779_;
				ValaCCodeExpression* _tmp780_;
				ValaCCodeExpression* _tmp781_;
				ValaCCodeFunctionCall* _tmp782_;
				ValaClass* _tmp783_;
				ValaClass* _tmp784_;
				gchar* _tmp785_;
				gchar* _tmp786_;
				gchar* _tmp787_;
				gchar* _tmp788_;
				ValaCCodeCastExpression* _tmp789_;
				ValaCCodeCastExpression* _tmp790_;
				ValaMethod* _tmp791_;
				ValaMethod* _tmp792_;
				ValaBlock* _tmp793_;
				ValaBlock* _tmp794_;
				gboolean _tmp795_;
				gboolean _tmp796_;
				gboolean _tmp823_ = FALSE;
				ValaClass* _tmp824_;
				ValaClass* _tmp825_;
				gboolean _tmp826_;
				gboolean _tmp827_;
				_tmp778_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp779_ = _tmp778_;
				_tmp780_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp781_ = _tmp780_;
				_tmp782_ = ccall;
				_tmp783_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp784_ = _tmp783_;
				_tmp785_ = vala_get_ccode_name ((ValaCodeNode*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp787_ = g_strconcat (_tmp786_, "*", NULL);
				_tmp788_ = _tmp787_;
				_tmp789_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp782_, _tmp788_);
				_tmp790_ = _tmp789_;
				vala_ccode_function_add_assignment (_tmp779_, _tmp781_, (ValaCCodeExpression*) _tmp790_);
				_vala_ccode_node_unref0 (_tmp790_);
				_g_free0 (_tmp788_);
				_g_free0 (_tmp786_);
				_vala_ccode_node_unref0 (_tmp781_);
				_tmp791_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp792_);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_block_get_captured (_tmp794_);
				_tmp796_ = _tmp795_;
				if (_tmp796_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp797_;
					ValaClass* _tmp798_;
					ValaObjectType* _tmp799_;
					ValaObjectType* _tmp800_;
					ValaSourceReference* _tmp801_;
					ValaSourceReference* _tmp802_;
					ValaCCodeExpression* _tmp803_;
					ValaCCodeExpression* _tmp804_;
					ValaCCodeFunctionCall* _tmp805_;
					ValaCCodeFunctionCall* _tmp806_;
					ValaCCodeFunctionCall* _tmp807_;
					ValaCCodeExpression* _tmp808_;
					ValaCCodeExpression* _tmp809_;
					ValaCCodeFunction* _tmp810_;
					ValaCCodeFunction* _tmp811_;
					ValaMethod* _tmp812_;
					ValaMethod* _tmp813_;
					ValaBlock* _tmp814_;
					ValaBlock* _tmp815_;
					gchar* _tmp816_;
					gchar* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeExpression* _tmp819_;
					ValaCCodeMemberAccess* _tmp820_;
					ValaCCodeMemberAccess* _tmp821_;
					ValaCCodeFunctionCall* _tmp822_;
					_tmp797_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp798_ = _tmp797_;
					_tmp799_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp798_);
					_tmp800_ = _tmp799_;
					_tmp801_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp802_ = _tmp801_;
					_tmp803_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp800_, _tmp802_, FALSE);
					_tmp804_ = _tmp803_;
					_tmp805_ = vala_ccode_function_call_new (_tmp804_);
					_tmp806_ = _tmp805_;
					_vala_ccode_node_unref0 (_tmp804_);
					_vala_code_node_unref0 (_tmp800_);
					ref_call = _tmp806_;
					_tmp807_ = ref_call;
					_tmp808_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp809_ = _tmp808_;
					vala_ccode_function_call_add_argument (_tmp807_, _tmp809_);
					_vala_ccode_node_unref0 (_tmp809_);
					_tmp810_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp813_);
					_tmp815_ = _tmp814_;
					_tmp816_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp815_));
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp817_);
					_tmp819_ = _tmp818_;
					_tmp820_ = vala_ccode_member_access_new_pointer (_tmp819_, "self");
					_tmp821_ = _tmp820_;
					_tmp822_ = ref_call;
					vala_ccode_function_add_assignment (_tmp811_, (ValaCCodeExpression*) _tmp821_, (ValaCCodeExpression*) _tmp822_);
					_vala_ccode_node_unref0 (_tmp821_);
					_vala_ccode_node_unref0 (_tmp819_);
					_g_free0 (_tmp817_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp824_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp825_ = _tmp824_;
				_tmp826_ = vala_class_get_is_compact (_tmp825_);
				_tmp827_ = _tmp826_;
				if (!_tmp827_) {
					ValaClass* _tmp828_;
					ValaClass* _tmp829_;
					_tmp828_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp829_ = _tmp828_;
					_tmp823_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp829_);
				} else {
					_tmp823_ = FALSE;
				}
				if (_tmp823_) {
					gchar** suffices = NULL;
					gchar* _tmp830_;
					gchar* _tmp831_;
					gchar* _tmp832_;
					gchar** _tmp833_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp830_ = g_strdup ("type");
					_tmp831_ = g_strdup ("dup_func");
					_tmp832_ = g_strdup ("destroy_func");
					_tmp833_ = g_new0 (gchar*, 3 + 1);
					_tmp833_[0] = _tmp830_;
					_tmp833_[1] = _tmp831_;
					_tmp833_[2] = _tmp832_;
					suffices = _tmp833_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp834_;
						ValaClass* _tmp835_;
						ValaList* _tmp836_;
						gint _type_param_size = 0;
						ValaList* _tmp837_;
						gint _tmp838_;
						gint _tmp839_;
						gint _type_param_index = 0;
						_tmp834_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp835_ = _tmp834_;
						_tmp836_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp835_);
						_type_param_list = _tmp836_;
						_tmp837_ = _type_param_list;
						_tmp838_ = vala_collection_get_size ((ValaCollection*) _tmp837_);
						_tmp839_ = _tmp838_;
						_type_param_size = _tmp839_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp840_;
							gpointer _tmp841_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp842_;
							ValaCCodeIdentifier* _tmp843_;
							ValaCCodeMemberAccess* _tmp844_;
							ValaCCodeMemberAccess* _tmp845_;
							gchar** _tmp846_;
							gint _tmp846__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp840_ = _type_param_list;
							_tmp841_ = vala_list_get (_tmp840_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp841_;
							_tmp842_ = vala_ccode_identifier_new ("self");
							_tmp843_ = _tmp842_;
							_tmp844_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp843_, "priv");
							_tmp845_ = _tmp844_;
							_vala_ccode_node_unref0 (_tmp843_);
							priv_access = _tmp845_;
							_tmp846_ = suffices;
							_tmp846__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp846_;
								suffix_collection_length1 = _tmp846__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp847_;
									gchar* suffix = NULL;
									_tmp847_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp847_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp848_;
										const gchar* _tmp849_;
										const gchar* _tmp850_;
										gchar* _tmp851_;
										gchar* _tmp852_;
										const gchar* _tmp853_;
										gchar* _tmp854_;
										gchar* _tmp855_;
										ValaCCodeIdentifier* _tmp856_;
										ValaCCodeIdentifier* _tmp857_;
										ValaCCodeFunction* _tmp858_;
										ValaCCodeFunction* _tmp859_;
										ValaCCodeMemberAccess* _tmp860_;
										ValaCCodeIdentifier* _tmp861_;
										const gchar* _tmp862_;
										const gchar* _tmp863_;
										ValaCCodeMemberAccess* _tmp864_;
										ValaCCodeMemberAccess* _tmp865_;
										ValaCCodeIdentifier* _tmp866_;
										_tmp848_ = type_param;
										_tmp849_ = vala_symbol_get_name ((ValaSymbol*) _tmp848_);
										_tmp850_ = _tmp849_;
										_tmp851_ = g_utf8_strdown (_tmp850_, (gssize) -1);
										_tmp852_ = _tmp851_;
										_tmp853_ = suffix;
										_tmp854_ = g_strdup_printf ("%s_%s", _tmp852_, _tmp853_);
										_tmp855_ = _tmp854_;
										_tmp856_ = vala_ccode_identifier_new (_tmp855_);
										_tmp857_ = _tmp856_;
										_g_free0 (_tmp855_);
										_g_free0 (_tmp852_);
										param_name = _tmp857_;
										_tmp858_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp859_ = _tmp858_;
										_tmp860_ = priv_access;
										_tmp861_ = param_name;
										_tmp862_ = vala_ccode_identifier_get_name (_tmp861_);
										_tmp863_ = _tmp862_;
										_tmp864_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp860_, _tmp863_);
										_tmp865_ = _tmp864_;
										_tmp866_ = param_name;
										vala_ccode_function_add_assignment (_tmp859_, (ValaCCodeExpression*) _tmp865_, (ValaCCodeExpression*) _tmp866_);
										_vala_ccode_node_unref0 (_tmp865_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp867_ = params;
	_tmp868_ = vala_iterable_iterator ((ValaIterable*) _tmp867_);
	params_it = _tmp868_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp869_;
		gint _arg_size = 0;
		ValaList* _tmp870_;
		gint _tmp871_;
		gint _tmp872_;
		gint _arg_index = 0;
		_tmp869_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp869_;
		_tmp870_ = _arg_list;
		_tmp871_ = vala_collection_get_size ((ValaCollection*) _tmp870_);
		_tmp872_ = _tmp871_;
		_arg_size = _tmp872_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp873_;
			gpointer _tmp874_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp875_;
			ValaCCodeExpression* _tmp876_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp877_;
			ValaHashMap* _tmp878_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp879_;
			gboolean _tmp889_ = FALSE;
			ValaParameter* _tmp890_;
			gdouble _tmp1216_ = 0.0;
			gboolean _tmp1217_ = FALSE;
			ValaParameter* _tmp1218_;
			ValaHashMap* _tmp1220_;
			ValaCCodeExpression* _tmp1221_;
			gboolean _tmp1222_ = FALSE;
			ValaExpression* _tmp1223_;
			gint _tmp1240_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp873_ = _arg_list;
			_tmp874_ = vala_list_get (_tmp873_, _arg_index);
			arg = (ValaExpression*) _tmp874_;
			_tmp875_ = arg;
			_tmp876_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp875_);
			cexpr = _tmp876_;
			_tmp877_ = in_arg_map;
			_tmp878_ = _vala_map_ref0 (_tmp877_);
			carg_map = _tmp878_;
			param = NULL;
			_tmp879_ = params_it;
			if (vala_iterator_next (_tmp879_)) {
				ValaIterator* _tmp880_;
				gpointer _tmp881_;
				gboolean _tmp882_ = FALSE;
				ValaParameter* _tmp883_;
				gboolean _tmp884_;
				gboolean _tmp885_;
				_tmp880_ = params_it;
				_tmp881_ = vala_iterator_get (_tmp880_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp881_;
				_tmp883_ = param;
				_tmp884_ = vala_parameter_get_params_array (_tmp883_);
				_tmp885_ = _tmp884_;
				if (_tmp885_) {
					_tmp882_ = TRUE;
				} else {
					ValaParameter* _tmp886_;
					gboolean _tmp887_;
					gboolean _tmp888_;
					_tmp886_ = param;
					_tmp887_ = vala_parameter_get_ellipsis (_tmp886_);
					_tmp888_ = _tmp887_;
					_tmp882_ = _tmp888_;
				}
				ellipsis = _tmp882_;
			}
			_tmp890_ = param;
			if (_tmp890_ != NULL) {
				_tmp889_ = !ellipsis;
			} else {
				_tmp889_ = FALSE;
			}
			if (_tmp889_) {
				ValaParameter* _tmp891_;
				ValaParameterDirection _tmp892_;
				ValaParameterDirection _tmp893_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp896_;
				ValaUnaryExpression* _tmp897_;
				gboolean _tmp898_ = FALSE;
				ValaUnaryExpression* _tmp899_;
				ValaParameter* _tmp1167_;
				gchar* _tmp1168_;
				gchar* _tmp1169_;
				gboolean _tmp1170_;
				_tmp891_ = param;
				_tmp892_ = vala_parameter_get_direction (_tmp891_);
				_tmp893_ = _tmp892_;
				if (_tmp893_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp894_;
					ValaHashMap* _tmp895_;
					_tmp894_ = out_arg_map;
					_tmp895_ = _vala_map_ref0 (_tmp894_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp895_;
				}
				_tmp896_ = arg;
				_tmp897_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp896_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp896_) : NULL);
				unary = _tmp897_;
				_tmp899_ = unary;
				if (_tmp899_ == NULL) {
					_tmp898_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp900_;
					ValaUnaryOperator _tmp901_;
					ValaUnaryOperator _tmp902_;
					_tmp900_ = unary;
					_tmp901_ = vala_unary_expression_get_operator (_tmp900_);
					_tmp902_ = _tmp901_;
					_tmp898_ = _tmp902_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp898_) {
					gboolean _tmp903_ = FALSE;
					gboolean _tmp904_ = FALSE;
					ValaParameter* _tmp905_;
					ValaParameter* _tmp1041_;
					ValaExpression* _tmp1042_;
					ValaCCodeExpression* _tmp1043_;
					ValaCCodeExpression* _tmp1044_;
					_tmp905_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp905_)) {
						ValaParameter* _tmp906_;
						ValaDataType* _tmp907_;
						ValaDataType* _tmp908_;
						_tmp906_ = param;
						_tmp907_ = vala_variable_get_variable_type ((ValaVariable*) _tmp906_);
						_tmp908_ = _tmp907_;
						_tmp904_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp908_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp904_ = FALSE;
					}
					if (_tmp904_) {
						ValaParameter* _tmp909_;
						ValaDataType* _tmp910_;
						ValaDataType* _tmp911_;
						gboolean _tmp912_;
						gboolean _tmp913_;
						_tmp909_ = param;
						_tmp910_ = vala_variable_get_variable_type ((ValaVariable*) _tmp909_);
						_tmp911_ = _tmp910_;
						_tmp912_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp911_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp913_ = _tmp912_;
						_tmp903_ = !_tmp913_;
					} else {
						_tmp903_ = FALSE;
					}
					if (_tmp903_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp914_;
						ValaDataType* _tmp915_;
						ValaDataType* _tmp916_;
						ValaArrayType* _tmp917_;
						gchar* _tmp918_ = NULL;
						ValaParameter* _tmp919_;
						gchar* _tmp920_;
						gchar* length_ctype = NULL;
						gchar* _tmp923_;
						gboolean _tmp924_ = FALSE;
						ValaUnaryExpression* _tmp925_;
						_tmp914_ = param;
						_tmp915_ = vala_variable_get_variable_type ((ValaVariable*) _tmp914_);
						_tmp916_ = _tmp915_;
						_tmp917_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp916_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp917_;
						_tmp919_ = param;
						_tmp920_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp919_);
						_tmp918_ = _tmp920_;
						if (_tmp918_ == NULL) {
							ValaArrayType* _tmp921_;
							gchar* _tmp922_;
							_tmp921_ = array_type;
							_tmp922_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp921_);
							_g_free0 (_tmp918_);
							_tmp918_ = _tmp922_;
						}
						_tmp923_ = g_strdup (_tmp918_);
						length_ctype = _tmp923_;
						_tmp925_ = unary;
						if (_tmp925_ != NULL) {
							ValaUnaryExpression* _tmp926_;
							ValaUnaryOperator _tmp927_;
							ValaUnaryOperator _tmp928_;
							_tmp926_ = unary;
							_tmp927_ = vala_unary_expression_get_operator (_tmp926_);
							_tmp928_ = _tmp927_;
							_tmp924_ = _tmp928_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp924_ = FALSE;
						}
						if (_tmp924_) {
							const gchar* _tmp929_;
							gchar* _tmp930_;
							_tmp929_ = length_ctype;
							_tmp930_ = g_strdup_printf ("%s*", _tmp929_);
							_g_free0 (length_ctype);
							length_ctype = _tmp930_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp931_ = FALSE;
								_tmp931_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp933_;
									gint _tmp934_;
									gint _tmp935_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp936_;
									ValaCCodeExpression* _tmp937_;
									ValaCCodeExpression* _tmp938_;
									const gchar* _tmp939_;
									ValaCCodeCastExpression* _tmp940_;
									ValaCCodeCastExpression* _tmp941_;
									ValaHashMap* _tmp942_;
									ValaParameter* _tmp943_;
									ValaCCodeCastExpression* _tmp944_;
									if (!_tmp931_) {
										gint _tmp932_;
										_tmp932_ = dim;
										dim = _tmp932_ + 1;
									}
									_tmp931_ = FALSE;
									_tmp933_ = array_type;
									_tmp934_ = vala_array_type_get_rank (_tmp933_);
									_tmp935_ = _tmp934_;
									if (!(dim <= _tmp935_)) {
										break;
									}
									_tmp936_ = arg;
									_tmp937_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp936_, dim);
									_tmp938_ = _tmp937_;
									_tmp939_ = length_ctype;
									_tmp940_ = vala_ccode_cast_expression_new (_tmp938_, _tmp939_);
									_tmp941_ = _tmp940_;
									_vala_ccode_node_unref0 (_tmp938_);
									array_length_expr = _tmp941_;
									_tmp942_ = carg_map;
									_tmp943_ = param;
									_tmp944_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp942_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp943_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp944_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp918_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp945_;
						ValaDataType* _tmp946_;
						ValaDataType* _tmp947_;
						_tmp945_ = param;
						_tmp946_ = vala_variable_get_variable_type ((ValaVariable*) _tmp945_);
						_tmp947_ = _tmp946_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp947_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp948_;
							ValaDataType* _tmp949_;
							ValaDataType* _tmp950_;
							ValaDelegateType* _tmp951_;
							ValaDelegateType* _tmp952_;
							ValaDelegate* _tmp953_;
							ValaDelegate* _tmp954_;
							gboolean _tmp955_;
							gboolean _tmp956_;
							_tmp948_ = param;
							_tmp949_ = vala_variable_get_variable_type ((ValaVariable*) _tmp948_);
							_tmp950_ = _tmp949_;
							_tmp951_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp950_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp951_;
							_tmp952_ = deleg_type;
							_tmp953_ = vala_delegate_type_get_delegate_symbol (_tmp952_);
							_tmp954_ = _tmp953_;
							_tmp955_ = vala_delegate_get_has_target (_tmp954_);
							_tmp956_ = _tmp955_;
							if (_tmp956_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp957_;
								ValaCCodeExpression* _tmp958_ = NULL;
								ValaCCodeExpression* _tmp959_;
								ValaCCodeExpression* _tmp960_;
								ValaParameter* _tmp961_;
								gchar* _tmp962_;
								gchar* _tmp963_;
								gboolean _tmp964_;
								_tmp957_ = arg;
								_tmp959_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp957_, &_tmp958_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp958_;
								delegate_target = _tmp959_;
								_tmp960_ = delegate_target;
								_vala_assert (_tmp960_ != NULL, "delegate_target != null");
								_tmp961_ = param;
								_tmp962_ = vala_get_ccode_type ((ValaCodeNode*) _tmp961_);
								_tmp963_ = _tmp962_;
								_tmp964_ = g_strcmp0 (_tmp963_, "GClosure*") == 0;
								_g_free0 (_tmp963_);
								if (_tmp964_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp965_;
									ValaCCodeIdentifier* _tmp966_;
									ValaCCodeFunctionCall* _tmp967_;
									ValaCCodeFunctionCall* _tmp968_;
									ValaCCodeFunctionCall* _tmp969_;
									ValaCCodeExpression* _tmp970_;
									ValaCCodeCastExpression* _tmp971_;
									ValaCCodeCastExpression* _tmp972_;
									ValaCCodeFunctionCall* _tmp973_;
									ValaCCodeExpression* _tmp974_;
									ValaCCodeFunctionCall* _tmp975_;
									ValaCCodeExpression* _tmp976_;
									ValaCCodeCastExpression* _tmp977_;
									ValaCCodeCastExpression* _tmp978_;
									ValaCCodeExpression* _tmp979_;
									ValaCCodeIdentifier* _tmp980_;
									ValaCCodeIdentifier* _tmp981_;
									ValaCCodeBinaryExpression* _tmp982_;
									ValaCCodeBinaryExpression* _tmp983_;
									ValaCCodeIdentifier* _tmp984_;
									ValaCCodeIdentifier* _tmp985_;
									ValaCCodeFunctionCall* _tmp986_;
									ValaCCodeConditionalExpression* _tmp987_;
									_tmp965_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp966_ = _tmp965_;
									_tmp967_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp966_);
									_tmp968_ = _tmp967_;
									_vala_ccode_node_unref0 (_tmp966_);
									closure_new = _tmp968_;
									_tmp969_ = closure_new;
									_tmp970_ = cexpr;
									_tmp971_ = vala_ccode_cast_expression_new (_tmp970_, "GCallback");
									_tmp972_ = _tmp971_;
									vala_ccode_function_call_add_argument (_tmp969_, (ValaCCodeExpression*) _tmp972_);
									_vala_ccode_node_unref0 (_tmp972_);
									_tmp973_ = closure_new;
									_tmp974_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp973_, _tmp974_);
									_tmp975_ = closure_new;
									_tmp976_ = delegate_target_destroy_notify;
									_tmp977_ = vala_ccode_cast_expression_new (_tmp976_, "GClosureNotify");
									_tmp978_ = _tmp977_;
									vala_ccode_function_call_add_argument (_tmp975_, (ValaCCodeExpression*) _tmp978_);
									_vala_ccode_node_unref0 (_tmp978_);
									_tmp979_ = cexpr;
									_tmp980_ = vala_ccode_identifier_new ("NULL");
									_tmp981_ = _tmp980_;
									_tmp982_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp979_, (ValaCCodeExpression*) _tmp981_);
									_tmp983_ = _tmp982_;
									_tmp984_ = vala_ccode_identifier_new ("NULL");
									_tmp985_ = _tmp984_;
									_tmp986_ = closure_new;
									_tmp987_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp983_, (ValaCCodeExpression*) _tmp985_, (ValaCCodeExpression*) _tmp986_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp987_;
									_vala_ccode_node_unref0 (_tmp985_);
									_vala_ccode_node_unref0 (_tmp983_);
									_vala_ccode_node_unref0 (_tmp981_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp988_;
									ValaParameter* _tmp989_;
									ValaCCodeExpression* _tmp990_;
									ValaDelegateType* _tmp991_;
									_tmp988_ = carg_map;
									_tmp989_ = param;
									_tmp990_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp988_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp989_), FALSE)), _tmp990_);
									_tmp991_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp991_)) {
										ValaCCodeExpression* _tmp992_;
										ValaHashMap* _tmp993_;
										ValaParameter* _tmp994_;
										ValaCCodeExpression* _tmp995_;
										_tmp992_ = delegate_target_destroy_notify;
										_vala_assert (_tmp992_ != NULL, "delegate_target_destroy_notify != null");
										_tmp993_ = carg_map;
										_tmp994_ = param;
										_tmp995_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp993_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp994_) + 0.01, FALSE)), _tmp995_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp996_;
							ValaDataType* _tmp997_;
							ValaDataType* _tmp998_;
							_tmp996_ = param;
							_tmp997_ = vala_variable_get_variable_type ((ValaVariable*) _tmp996_);
							_tmp998_ = _tmp997_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp998_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp999_;
								ValaParameter* _tmp1000_;
								ValaExpression* _tmp1001_;
								ValaCCodeExpression* _tmp1002_ = NULL;
								ValaCCodeExpression* _tmp1003_;
								ValaCCodeExpression* _tmp1004_;
								_tmp999_ = carg_map;
								_tmp1000_ = param;
								_tmp1001_ = arg;
								_tmp1003_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1001_, &_tmp1002_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1002_;
								_tmp1004_ = _tmp1003_;
								vala_map_set ((ValaMap*) _tmp999_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1000_), FALSE)), _tmp1004_);
								_vala_ccode_node_unref0 (_tmp1004_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1005_;
								ValaDataType* _tmp1006_;
								ValaDataType* _tmp1007_;
								_tmp1005_ = param;
								_tmp1006_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1005_);
								_tmp1007_ = _tmp1006_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1007_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1008_ = FALSE;
									ValaMethod* _tmp1009_;
									_tmp1009_ = m;
									if (_tmp1009_ != NULL) {
										ValaMethod* _tmp1010_;
										_tmp1010_ = m;
										_tmp1008_ = vala_get_ccode_simple_generics (_tmp1010_);
									} else {
										_tmp1008_ = FALSE;
									}
									if (_tmp1008_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1011_;
										ValaDataType* _tmp1012_;
										ValaDataType* _tmp1013_;
										ValaGenericType* _tmp1014_;
										gint type_param_index = 0;
										ValaMethod* _tmp1015_;
										ValaGenericType* _tmp1016_;
										ValaTypeParameter* _tmp1017_;
										ValaTypeParameter* _tmp1018_;
										const gchar* _tmp1019_;
										const gchar* _tmp1020_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1021_;
										ValaList* _tmp1022_;
										ValaList* _tmp1023_;
										gpointer _tmp1024_;
										ValaDataType* _tmp1025_;
										ValaParameter* _tmp1026_;
										ValaDataType* _tmp1027_;
										ValaDataType* _tmp1028_;
										gboolean _tmp1029_;
										gboolean _tmp1030_;
										_tmp1011_ = param;
										_tmp1012_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1011_);
										_tmp1013_ = _tmp1012_;
										_tmp1014_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1013_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1014_;
										_tmp1015_ = m;
										_tmp1016_ = generic_type;
										_tmp1017_ = vala_generic_type_get_type_parameter (_tmp1016_);
										_tmp1018_ = _tmp1017_;
										_tmp1019_ = vala_symbol_get_name ((ValaSymbol*) _tmp1018_);
										_tmp1020_ = _tmp1019_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1015_, _tmp1020_);
										_tmp1021_ = ma;
										_tmp1022_ = vala_member_access_get_type_arguments (_tmp1021_);
										_tmp1023_ = _tmp1022_;
										_tmp1024_ = vala_list_get (_tmp1023_, type_param_index);
										_tmp1025_ = (ValaDataType*) _tmp1024_;
										_vala_iterable_unref0 (_tmp1023_);
										type_arg = _tmp1025_;
										_tmp1026_ = param;
										_tmp1027_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1026_);
										_tmp1028_ = _tmp1027_;
										_tmp1029_ = vala_data_type_get_value_owned (_tmp1028_);
										_tmp1030_ = _tmp1029_;
										if (_tmp1030_) {
											ValaDataType* _tmp1031_;
											_tmp1031_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1031_)) {
												ValaHashMap* _tmp1032_;
												ValaParameter* _tmp1033_;
												ValaDataType* _tmp1034_;
												ValaCCodeExpression* _tmp1035_;
												ValaCCodeExpression* _tmp1036_;
												_tmp1032_ = carg_map;
												_tmp1033_ = param;
												_tmp1034_ = type_arg;
												_tmp1035_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1034_, FALSE);
												_tmp1036_ = _tmp1035_;
												vala_map_set ((ValaMap*) _tmp1032_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1033_), FALSE)), _tmp1036_);
												_vala_ccode_node_unref0 (_tmp1036_);
											} else {
												ValaHashMap* _tmp1037_;
												ValaParameter* _tmp1038_;
												ValaCCodeConstant* _tmp1039_;
												ValaCCodeConstant* _tmp1040_;
												_tmp1037_ = carg_map;
												_tmp1038_ = param;
												_tmp1039_ = vala_ccode_constant_new ("NULL");
												_tmp1040_ = _tmp1039_;
												vala_map_set ((ValaMap*) _tmp1037_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1038_), FALSE)), (ValaCCodeExpression*) _tmp1040_);
												_vala_ccode_node_unref0 (_tmp1040_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1041_ = param;
					_tmp1042_ = arg;
					_tmp1043_ = cexpr;
					_tmp1044_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1041_, _tmp1042_, _tmp1043_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1044_;
				} else {
					ValaExpression* _tmp1045_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1046_;
					ValaDataType* _tmp1047_;
					ValaDataType* _tmp1048_;
					ValaParameter* _tmp1049_;
					ValaDataType* _tmp1050_;
					ValaDataType* _tmp1051_;
					gboolean _tmp1052_;
					gboolean _tmp1053_;
					ValaLocalVariable* _tmp1054_;
					ValaLocalVariable* _tmp1055_;
					ValaExpression* _tmp1056_;
					ValaLocalVariable* _tmp1057_;
					const gchar* _tmp1058_;
					const gchar* _tmp1059_;
					ValaCCodeExpression* _tmp1060_;
					ValaCCodeExpression* _tmp1061_;
					ValaExpression* _tmp1062_;
					ValaTargetValue* _tmp1063_;
					ValaTargetValue* _tmp1064_;
					ValaExpression* _tmp1065_;
					ValaDataType* _tmp1066_;
					ValaDataType* _tmp1067_;
					ValaExpression* _tmp1068_;
					ValaCCodeExpression* _tmp1069_;
					ValaCCodeExpression* _tmp1070_;
					ValaCCodeUnaryExpression* _tmp1071_;
					gboolean _tmp1072_ = FALSE;
					gboolean _tmp1073_ = FALSE;
					ValaParameter* _tmp1074_;
					_tmp1045_ = arg;
					vala_expression_set_target_value (_tmp1045_, NULL);
					_tmp1046_ = param;
					_tmp1047_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1046_);
					_tmp1048_ = _tmp1047_;
					_tmp1049_ = param;
					_tmp1050_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1049_);
					_tmp1051_ = _tmp1050_;
					_tmp1052_ = vala_data_type_get_value_owned (_tmp1051_);
					_tmp1053_ = _tmp1052_;
					_tmp1054_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1048_, _tmp1053_, NULL, TRUE);
					temp_var = _tmp1054_;
					_tmp1055_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1055_, FALSE);
					_tmp1056_ = arg;
					_tmp1057_ = temp_var;
					_tmp1058_ = vala_symbol_get_name ((ValaSymbol*) _tmp1057_);
					_tmp1059_ = _tmp1058_;
					_tmp1060_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1059_);
					_tmp1061_ = _tmp1060_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1056_, _tmp1061_);
					_vala_ccode_node_unref0 (_tmp1061_);
					_tmp1062_ = arg;
					_tmp1063_ = vala_expression_get_target_value (_tmp1062_);
					_tmp1064_ = _tmp1063_;
					_tmp1065_ = arg;
					_tmp1066_ = vala_expression_get_target_type (_tmp1065_);
					_tmp1067_ = _tmp1066_;
					vala_target_value_set_value_type (_tmp1064_, _tmp1067_);
					_tmp1068_ = arg;
					_tmp1069_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1068_);
					_tmp1070_ = _tmp1069_;
					_tmp1071_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1070_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1071_;
					_vala_ccode_node_unref0 (_tmp1070_);
					_tmp1074_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1074_)) {
						ValaParameter* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						_tmp1075_ = param;
						_tmp1076_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1073_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1077_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1073_ = FALSE;
					}
					if (_tmp1073_) {
						ValaParameter* _tmp1078_;
						ValaDataType* _tmp1079_;
						ValaDataType* _tmp1080_;
						gboolean _tmp1081_;
						gboolean _tmp1082_;
						_tmp1078_ = param;
						_tmp1079_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1078_);
						_tmp1080_ = _tmp1079_;
						_tmp1081_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1080_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1082_ = _tmp1081_;
						_tmp1072_ = !_tmp1082_;
					} else {
						_tmp1072_ = FALSE;
					}
					if (_tmp1072_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1083_;
						ValaDataType* _tmp1084_;
						ValaDataType* _tmp1085_;
						ValaArrayType* _tmp1086_;
						gchar* _tmp1087_ = NULL;
						ValaParameter* _tmp1088_;
						gchar* _tmp1089_;
						gchar* length_ctype = NULL;
						gchar* _tmp1092_;
						_tmp1083_ = param;
						_tmp1084_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1083_);
						_tmp1085_ = _tmp1084_;
						_tmp1086_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1085_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1086_;
						_tmp1088_ = param;
						_tmp1089_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1088_);
						_tmp1087_ = _tmp1089_;
						if (_tmp1087_ == NULL) {
							ValaArrayType* _tmp1090_;
							gchar* _tmp1091_;
							_tmp1090_ = array_type;
							_tmp1091_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1090_);
							_g_free0 (_tmp1087_);
							_tmp1087_ = _tmp1091_;
						}
						_tmp1092_ = g_strdup (_tmp1087_);
						length_ctype = _tmp1092_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1093_ = FALSE;
								_tmp1093_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1095_;
									gint _tmp1096_;
									gint _tmp1097_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1098_;
									ValaCType* _tmp1099_;
									ValaCType* _tmp1100_;
									ValaLocalVariable* _tmp1101_;
									ValaLocalVariable* _tmp1102_;
									ValaLocalVariable* _tmp1103_;
									ValaExpression* _tmp1104_;
									ValaLocalVariable* _tmp1105_;
									const gchar* _tmp1106_;
									const gchar* _tmp1107_;
									ValaCCodeExpression* _tmp1108_;
									ValaCCodeExpression* _tmp1109_;
									ValaHashMap* _tmp1110_;
									ValaParameter* _tmp1111_;
									ValaExpression* _tmp1112_;
									ValaList* _tmp1113_;
									ValaList* _tmp1114_;
									gpointer _tmp1115_;
									ValaCCodeExpression* _tmp1116_;
									ValaCCodeUnaryExpression* _tmp1117_;
									ValaCCodeUnaryExpression* _tmp1118_;
									if (!_tmp1093_) {
										gint _tmp1094_;
										_tmp1094_ = dim;
										dim = _tmp1094_ + 1;
									}
									_tmp1093_ = FALSE;
									_tmp1095_ = array_type;
									_tmp1096_ = vala_array_type_get_rank (_tmp1095_);
									_tmp1097_ = _tmp1096_;
									if (!(dim <= _tmp1097_)) {
										break;
									}
									_tmp1098_ = length_ctype;
									_tmp1099_ = vala_ctype_new (_tmp1098_, "0");
									_tmp1100_ = _tmp1099_;
									_tmp1101_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1100_, TRUE, NULL, TRUE);
									_tmp1102_ = _tmp1101_;
									_vala_code_node_unref0 (_tmp1100_);
									temp_array_length = _tmp1102_;
									_tmp1103_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1103_, FALSE);
									_tmp1104_ = arg;
									_tmp1105_ = temp_array_length;
									_tmp1106_ = vala_symbol_get_name ((ValaSymbol*) _tmp1105_);
									_tmp1107_ = _tmp1106_;
									_tmp1108_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1107_);
									_tmp1109_ = _tmp1108_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1104_, _tmp1109_);
									_vala_ccode_node_unref0 (_tmp1109_);
									_tmp1110_ = carg_map;
									_tmp1111_ = param;
									_tmp1112_ = arg;
									_tmp1113_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1112_);
									_tmp1114_ = _tmp1113_;
									_tmp1115_ = vala_list_get (_tmp1114_, dim - 1);
									_tmp1116_ = (ValaCCodeExpression*) _tmp1115_;
									_tmp1117_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1116_);
									_tmp1118_ = _tmp1117_;
									vala_map_set ((ValaMap*) _tmp1110_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1111_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1118_);
									_vala_ccode_node_unref0 (_tmp1118_);
									_vala_ccode_node_unref0 (_tmp1116_);
									_vala_iterable_unref0 (_tmp1114_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1087_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1119_;
						ValaDataType* _tmp1120_;
						ValaDataType* _tmp1121_;
						_tmp1119_ = param;
						_tmp1120_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1119_);
						_tmp1121_ = _tmp1120_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1121_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1122_;
							ValaDataType* _tmp1123_;
							ValaDataType* _tmp1124_;
							ValaDelegateType* _tmp1125_;
							ValaDelegateType* _tmp1126_;
							ValaDelegate* _tmp1127_;
							ValaDelegate* _tmp1128_;
							gboolean _tmp1129_;
							gboolean _tmp1130_;
							_tmp1122_ = param;
							_tmp1123_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1122_);
							_tmp1124_ = _tmp1123_;
							_tmp1125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1124_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1125_;
							_tmp1126_ = deleg_type;
							_tmp1127_ = vala_delegate_type_get_delegate_symbol (_tmp1126_);
							_tmp1128_ = _tmp1127_;
							_tmp1129_ = vala_delegate_get_has_target (_tmp1128_);
							_tmp1130_ = _tmp1129_;
							if (_tmp1130_) {
								ValaVoidType* _tmp1131_;
								ValaVoidType* _tmp1132_;
								ValaPointerType* _tmp1133_;
								ValaPointerType* _tmp1134_;
								ValaLocalVariable* _tmp1135_;
								ValaLocalVariable* _tmp1136_;
								ValaExpression* _tmp1137_;
								ValaLocalVariable* _tmp1138_;
								const gchar* _tmp1139_;
								const gchar* _tmp1140_;
								ValaCCodeExpression* _tmp1141_;
								ValaCCodeExpression* _tmp1142_;
								ValaHashMap* _tmp1143_;
								ValaParameter* _tmp1144_;
								ValaExpression* _tmp1145_;
								ValaCCodeExpression* _tmp1146_;
								ValaCCodeExpression* _tmp1147_;
								ValaCCodeUnaryExpression* _tmp1148_;
								ValaCCodeUnaryExpression* _tmp1149_;
								ValaDelegateType* _tmp1150_;
								_tmp1131_ = vala_void_type_new (NULL);
								_tmp1132_ = _tmp1131_;
								_tmp1133_ = vala_pointer_type_new ((ValaDataType*) _tmp1132_, NULL);
								_tmp1134_ = _tmp1133_;
								_tmp1135_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1134_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1135_;
								_vala_code_node_unref0 (_tmp1134_);
								_vala_code_node_unref0 (_tmp1132_);
								_tmp1136_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1136_, FALSE);
								_tmp1137_ = arg;
								_tmp1138_ = temp_var;
								_tmp1139_ = vala_symbol_get_name ((ValaSymbol*) _tmp1138_);
								_tmp1140_ = _tmp1139_;
								_tmp1141_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1140_);
								_tmp1142_ = _tmp1141_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1137_, _tmp1142_);
								_vala_ccode_node_unref0 (_tmp1142_);
								_tmp1143_ = carg_map;
								_tmp1144_ = param;
								_tmp1145_ = arg;
								_tmp1146_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1145_);
								_tmp1147_ = _tmp1146_;
								_tmp1148_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1147_);
								_tmp1149_ = _tmp1148_;
								vala_map_set ((ValaMap*) _tmp1143_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1144_), FALSE)), (ValaCCodeExpression*) _tmp1149_);
								_vala_ccode_node_unref0 (_tmp1149_);
								_vala_ccode_node_unref0 (_tmp1147_);
								_tmp1150_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1150_)) {
									ValaDataType* _tmp1151_;
									ValaLocalVariable* _tmp1152_;
									ValaLocalVariable* _tmp1153_;
									ValaExpression* _tmp1154_;
									ValaLocalVariable* _tmp1155_;
									const gchar* _tmp1156_;
									const gchar* _tmp1157_;
									ValaCCodeExpression* _tmp1158_;
									ValaCCodeExpression* _tmp1159_;
									ValaHashMap* _tmp1160_;
									ValaParameter* _tmp1161_;
									ValaExpression* _tmp1162_;
									ValaCCodeExpression* _tmp1163_;
									ValaCCodeExpression* _tmp1164_;
									ValaCCodeUnaryExpression* _tmp1165_;
									ValaCCodeUnaryExpression* _tmp1166_;
									_tmp1151_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1152_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1151_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1152_;
									_tmp1153_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1153_, FALSE);
									_tmp1154_ = arg;
									_tmp1155_ = temp_var;
									_tmp1156_ = vala_symbol_get_name ((ValaSymbol*) _tmp1155_);
									_tmp1157_ = _tmp1156_;
									_tmp1158_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1157_);
									_tmp1159_ = _tmp1158_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1154_, _tmp1159_);
									_vala_ccode_node_unref0 (_tmp1159_);
									_tmp1160_ = carg_map;
									_tmp1161_ = param;
									_tmp1162_ = arg;
									_tmp1163_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1162_);
									_tmp1164_ = _tmp1163_;
									_tmp1165_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1164_);
									_tmp1166_ = _tmp1165_;
									vala_map_set ((ValaMap*) _tmp1160_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1161_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1166_);
									_vala_ccode_node_unref0 (_tmp1166_);
									_vala_ccode_node_unref0 (_tmp1164_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1167_ = param;
				_tmp1168_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1167_);
				_tmp1169_ = _tmp1168_;
				_tmp1170_ = _tmp1169_ != NULL;
				_g_free0 (_tmp1169_);
				if (_tmp1170_) {
					ValaCCodeExpression* _tmp1171_;
					ValaParameter* _tmp1172_;
					gchar* _tmp1173_;
					gchar* _tmp1174_;
					ValaCCodeCastExpression* _tmp1175_;
					_tmp1171_ = cexpr;
					_tmp1172_ = param;
					_tmp1173_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1172_);
					_tmp1174_ = _tmp1173_;
					_tmp1175_ = vala_ccode_cast_expression_new (_tmp1171_, _tmp1174_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1175_;
					_g_free0 (_tmp1174_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1176_;
				ValaUnaryExpression* _tmp1177_;
				gboolean _tmp1178_ = FALSE;
				gboolean _tmp1179_ = FALSE;
				_tmp1176_ = arg;
				_tmp1177_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1176_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1176_) : NULL);
				unary = _tmp1177_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1180_;
					_tmp1180_ = unary;
					_tmp1179_ = _tmp1180_ != NULL;
				} else {
					_tmp1179_ = FALSE;
				}
				if (_tmp1179_) {
					ValaUnaryExpression* _tmp1181_;
					ValaUnaryOperator _tmp1182_;
					ValaUnaryOperator _tmp1183_;
					_tmp1181_ = unary;
					_tmp1182_ = vala_unary_expression_get_operator (_tmp1181_);
					_tmp1183_ = _tmp1182_;
					_tmp1178_ = _tmp1183_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1178_ = FALSE;
				}
				if (_tmp1178_) {
					ValaHashMap* _tmp1184_;
					ValaHashMap* _tmp1185_;
					ValaExpression* _tmp1186_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1187_;
					ValaDataType* _tmp1188_;
					ValaDataType* _tmp1189_;
					ValaExpression* _tmp1190_;
					ValaDataType* _tmp1191_;
					ValaDataType* _tmp1192_;
					gboolean _tmp1193_;
					gboolean _tmp1194_;
					ValaLocalVariable* _tmp1195_;
					ValaLocalVariable* _tmp1196_;
					ValaExpression* _tmp1197_;
					ValaLocalVariable* _tmp1198_;
					const gchar* _tmp1199_;
					const gchar* _tmp1200_;
					ValaCCodeExpression* _tmp1201_;
					ValaCCodeExpression* _tmp1202_;
					ValaExpression* _tmp1203_;
					ValaTargetValue* _tmp1204_;
					ValaTargetValue* _tmp1205_;
					ValaExpression* _tmp1206_;
					ValaDataType* _tmp1207_;
					ValaDataType* _tmp1208_;
					ValaExpression* _tmp1209_;
					ValaCCodeExpression* _tmp1210_;
					ValaCCodeExpression* _tmp1211_;
					ValaCCodeUnaryExpression* _tmp1212_;
					_tmp1184_ = out_arg_map;
					_tmp1185_ = _vala_map_ref0 (_tmp1184_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1185_;
					_tmp1186_ = arg;
					vala_expression_set_target_value (_tmp1186_, NULL);
					_tmp1187_ = arg;
					_tmp1188_ = vala_expression_get_value_type (_tmp1187_);
					_tmp1189_ = _tmp1188_;
					_tmp1190_ = arg;
					_tmp1191_ = vala_expression_get_value_type (_tmp1190_);
					_tmp1192_ = _tmp1191_;
					_tmp1193_ = vala_data_type_get_value_owned (_tmp1192_);
					_tmp1194_ = _tmp1193_;
					_tmp1195_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1189_, _tmp1194_, NULL, TRUE);
					temp_var = _tmp1195_;
					_tmp1196_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1196_, FALSE);
					_tmp1197_ = arg;
					_tmp1198_ = temp_var;
					_tmp1199_ = vala_symbol_get_name ((ValaSymbol*) _tmp1198_);
					_tmp1200_ = _tmp1199_;
					_tmp1201_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1200_);
					_tmp1202_ = _tmp1201_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1197_, _tmp1202_);
					_vala_ccode_node_unref0 (_tmp1202_);
					_tmp1203_ = arg;
					_tmp1204_ = vala_expression_get_target_value (_tmp1203_);
					_tmp1205_ = _tmp1204_;
					_tmp1206_ = arg;
					_tmp1207_ = vala_expression_get_value_type (_tmp1206_);
					_tmp1208_ = _tmp1207_;
					vala_target_value_set_value_type (_tmp1205_, _tmp1208_);
					_tmp1209_ = arg;
					_tmp1210_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1209_);
					_tmp1211_ = _tmp1210_;
					_tmp1212_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1211_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1212_;
					_vala_ccode_node_unref0 (_tmp1211_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1213_;
					ValaCCodeExpression* _tmp1214_;
					ValaCCodeExpression* _tmp1215_;
					_tmp1213_ = arg;
					_tmp1214_ = cexpr;
					_tmp1215_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1213_, _tmp1214_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1215_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1218_ = param;
			if (_tmp1218_ != NULL) {
				_tmp1217_ = !ellipsis;
			} else {
				_tmp1217_ = FALSE;
			}
			if (_tmp1217_) {
				ValaParameter* _tmp1219_;
				_tmp1219_ = param;
				_tmp1216_ = vala_get_ccode_pos (_tmp1219_);
			} else {
				_tmp1216_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1216_, ellipsis);
			_tmp1220_ = carg_map;
			_tmp1221_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1220_, (gpointer) ((gintptr) arg_pos), _tmp1221_);
			_tmp1223_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1223_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1222_ = ellipsis;
			} else {
				_tmp1222_ = FALSE;
			}
			if (_tmp1222_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1224_;
				ValaNamedArgument* _tmp1225_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1226_;
				const gchar* _tmp1227_;
				const gchar* _tmp1228_;
				gchar** _tmp1229_;
				gchar** _tmp1230_;
				gchar** _tmp1231_;
				gint _tmp1231__length1;
				gchar* _tmp1232_;
				gchar* _tmp1233_;
				ValaHashMap* _tmp1234_;
				const gchar* _tmp1235_;
				gchar* _tmp1236_;
				gchar* _tmp1237_;
				ValaCCodeConstant* _tmp1238_;
				ValaCCodeConstant* _tmp1239_;
				_tmp1224_ = arg;
				_tmp1225_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1224_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1225_;
				_tmp1226_ = named_arg;
				_tmp1227_ = vala_named_argument_get_name (_tmp1226_);
				_tmp1228_ = _tmp1227_;
				_tmp1230_ = _tmp1229_ = g_strsplit (_tmp1228_, "_", 0);
				_tmp1231_ = _tmp1230_;
				_tmp1231__length1 = _vala_array_length (_tmp1229_);
				_tmp1232_ = _vala_g_strjoinv ("-", _tmp1231_, (gint) _vala_array_length (_tmp1229_));
				_tmp1233_ = _tmp1232_;
				_tmp1231_ = (_vala_array_free (_tmp1231_, _tmp1231__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1233_;
				_tmp1234_ = carg_map;
				_tmp1235_ = name;
				_tmp1236_ = g_strdup_printf ("\"%s\"", _tmp1235_);
				_tmp1237_ = _tmp1236_;
				_tmp1238_ = vala_ccode_constant_new (_tmp1237_);
				_tmp1239_ = _tmp1238_;
				vala_map_set ((ValaMap*) _tmp1234_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1239_);
				_vala_ccode_node_unref0 (_tmp1239_);
				_g_free0 (_tmp1237_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1240_ = i;
			i = _tmp1240_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1241_ = params_it;
	if (vala_iterator_next (_tmp1241_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1242_;
		gpointer _tmp1243_;
		gboolean _tmp1244_ = FALSE;
		ValaParameter* _tmp1245_;
		gboolean _tmp1246_;
		gboolean _tmp1247_;
		_tmp1242_ = params_it;
		_tmp1243_ = vala_iterator_get (_tmp1242_);
		param = (ValaParameter*) _tmp1243_;
		_tmp1245_ = param;
		_tmp1246_ = vala_parameter_get_params_array (_tmp1245_);
		_tmp1247_ = _tmp1246_;
		if (_tmp1247_) {
			_tmp1244_ = TRUE;
		} else {
			ValaParameter* _tmp1248_;
			gboolean _tmp1249_;
			gboolean _tmp1250_;
			_tmp1248_ = param;
			_tmp1249_ = vala_parameter_get_ellipsis (_tmp1248_);
			_tmp1250_ = _tmp1249_;
			_tmp1244_ = _tmp1250_;
		}
		_vala_assert (_tmp1244_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1253_ = m;
	if (_tmp1253_ != NULL) {
		ValaMethod* _tmp1254_;
		ValaDataType* _tmp1255_;
		ValaDataType* _tmp1256_;
		_tmp1254_ = m;
		_tmp1255_ = vala_callable_get_return_type ((ValaCallable*) _tmp1254_);
		_tmp1256_ = _tmp1255_;
		_tmp1252_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1256_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1252_ = FALSE;
	}
	if (_tmp1252_) {
		ValaCCodeFunctionCall* _tmp1257_;
		ValaCCodeFunctionCall* _tmp1258_;
		_tmp1257_ = async_call;
		_tmp1258_ = ccall;
		_tmp1251_ = _tmp1257_ != _tmp1258_;
	} else {
		_tmp1251_ = FALSE;
	}
	if (_tmp1251_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1259_;
		ValaDataType* _tmp1260_;
		ValaDataType* _tmp1261_;
		ValaArrayType* _tmp1262_;
		_tmp1259_ = m;
		_tmp1260_ = vala_callable_get_return_type ((ValaCallable*) _tmp1259_);
		_tmp1261_ = _tmp1260_;
		_tmp1262_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1261_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1262_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1263_ = FALSE;
				_tmp1263_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1265_;
					gint _tmp1266_;
					gint _tmp1267_;
					ValaMethod* _tmp1268_;
					if (!_tmp1263_) {
						gint _tmp1264_;
						_tmp1264_ = dim;
						dim = _tmp1264_ + 1;
					}
					_tmp1263_ = FALSE;
					_tmp1265_ = array_type;
					_tmp1266_ = vala_array_type_get_rank (_tmp1265_);
					_tmp1267_ = _tmp1266_;
					if (!(dim <= _tmp1267_)) {
						break;
					}
					_tmp1268_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1268_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1269_;
						ValaDataType* _tmp1270_;
						ValaDataType* _tmp1271_;
						ValaLocalVariable* _tmp1272_;
						ValaLocalVariable* _tmp1273_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1274_;
						const gchar* _tmp1275_;
						const gchar* _tmp1276_;
						ValaCCodeExpression* _tmp1277_;
						ValaLocalVariable* _tmp1278_;
						ValaCCodeExpression* _tmp1279_;
						ValaCCodeExpression* _tmp1280_;
						ValaCCodeAssignment* _tmp1281_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1282_;
						ValaCCodeIdentifier* _tmp1283_;
						ValaCCodeFunctionCall* _tmp1284_;
						ValaCCodeFunctionCall* _tmp1285_;
						ValaCCodeFunctionCall* _tmp1286_;
						ValaCCodeExpression* _tmp1287_;
						ValaCCodeFunctionCall* _tmp1288_;
						_tmp1269_ = itype;
						_tmp1270_ = vala_data_type_get_return_type (_tmp1269_);
						_tmp1271_ = _tmp1270_;
						_tmp1272_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1271_, TRUE, NULL, FALSE);
						_tmp1273_ = _tmp1272_;
						_vala_code_node_unref0 (_tmp1271_);
						temp_var = _tmp1273_;
						_tmp1274_ = temp_var;
						_tmp1275_ = vala_symbol_get_name ((ValaSymbol*) _tmp1274_);
						_tmp1276_ = _tmp1275_;
						_tmp1277_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1276_);
						temp_ref = _tmp1277_;
						_tmp1278_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1278_, FALSE);
						_tmp1279_ = temp_ref;
						_tmp1280_ = ccall_expr;
						_tmp1281_ = vala_ccode_assignment_new (_tmp1279_, _tmp1280_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1281_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1282_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1283_ = _tmp1282_;
						_tmp1284_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1283_);
						_tmp1285_ = _tmp1284_;
						_vala_ccode_node_unref0 (_tmp1283_);
						len_call = _tmp1285_;
						_tmp1286_ = len_call;
						_tmp1287_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1286_, _tmp1287_);
						_tmp1288_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1288_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1289_;
						_tmp1289_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1289_)) {
							gchar* _tmp1290_ = NULL;
							ValaMethod* _tmp1291_;
							gchar* _tmp1292_;
							gchar* length_ctype = NULL;
							gchar* _tmp1295_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1296_;
							ValaCType* _tmp1297_;
							ValaCType* _tmp1298_;
							ValaLocalVariable* _tmp1299_;
							ValaLocalVariable* _tmp1300_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1301_;
							const gchar* _tmp1302_;
							const gchar* _tmp1303_;
							ValaCCodeExpression* _tmp1304_;
							ValaLocalVariable* _tmp1305_;
							ValaHashMap* _tmp1306_;
							ValaMethod* _tmp1307_;
							ValaCCodeExpression* _tmp1308_;
							ValaCCodeUnaryExpression* _tmp1309_;
							ValaCCodeUnaryExpression* _tmp1310_;
							ValaCCodeExpression* _tmp1311_;
							_tmp1291_ = m;
							_tmp1292_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1291_);
							_tmp1290_ = _tmp1292_;
							if (_tmp1290_ == NULL) {
								ValaArrayType* _tmp1293_;
								gchar* _tmp1294_;
								_tmp1293_ = array_type;
								_tmp1294_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1293_);
								_g_free0 (_tmp1290_);
								_tmp1290_ = _tmp1294_;
							}
							_tmp1295_ = g_strdup (_tmp1290_);
							length_ctype = _tmp1295_;
							_tmp1296_ = length_ctype;
							_tmp1297_ = vala_ctype_new (_tmp1296_, "0");
							_tmp1298_ = _tmp1297_;
							_tmp1299_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1298_, TRUE, NULL, TRUE);
							_tmp1300_ = _tmp1299_;
							_vala_code_node_unref0 (_tmp1298_);
							temp_var = _tmp1300_;
							_tmp1301_ = temp_var;
							_tmp1302_ = vala_symbol_get_name ((ValaSymbol*) _tmp1301_);
							_tmp1303_ = _tmp1302_;
							_tmp1304_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1303_);
							temp_ref = _tmp1304_;
							_tmp1305_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1305_, FALSE);
							_tmp1306_ = out_arg_map;
							_tmp1307_ = m;
							_tmp1308_ = temp_ref;
							_tmp1309_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1308_);
							_tmp1310_ = _tmp1309_;
							vala_map_set ((ValaMap*) _tmp1306_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1307_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1310_);
							_vala_ccode_node_unref0 (_tmp1310_);
							_tmp1311_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1311_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1290_);
						} else {
							ValaMethod* _tmp1312_;
							gchar* _tmp1313_;
							gchar* _tmp1314_;
							gboolean _tmp1315_;
							_tmp1312_ = m;
							_tmp1313_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1312_);
							_tmp1314_ = _tmp1313_;
							_tmp1315_ = _tmp1314_ != NULL;
							_g_free0 (_tmp1314_);
							if (_tmp1315_) {
								ValaMethod* _tmp1316_;
								gchar* _tmp1317_;
								gchar* _tmp1318_;
								ValaCCodeConstant* _tmp1319_;
								ValaCCodeConstant* _tmp1320_;
								_tmp1316_ = m;
								_tmp1317_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1316_);
								_tmp1318_ = _tmp1317_;
								_tmp1319_ = vala_ccode_constant_new (_tmp1318_);
								_tmp1320_ = _tmp1319_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1320_);
								_vala_ccode_node_unref0 (_tmp1320_);
								_g_free0 (_tmp1318_);
							} else {
								ValaCCodeConstant* _tmp1321_;
								ValaCCodeConstant* _tmp1322_;
								_tmp1321_ = vala_ccode_constant_new ("-1");
								_tmp1322_ = _tmp1321_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1322_);
								_vala_ccode_node_unref0 (_tmp1322_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1323_ = FALSE;
		gboolean _tmp1324_ = FALSE;
		ValaMethod* _tmp1325_;
		_tmp1325_ = m;
		if (_tmp1325_ != NULL) {
			ValaMethod* _tmp1326_;
			ValaDataType* _tmp1327_;
			ValaDataType* _tmp1328_;
			_tmp1326_ = m;
			_tmp1327_ = vala_callable_get_return_type ((ValaCallable*) _tmp1326_);
			_tmp1328_ = _tmp1327_;
			_tmp1324_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1328_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1324_ = FALSE;
		}
		if (_tmp1324_) {
			ValaCCodeFunctionCall* _tmp1329_;
			ValaCCodeFunctionCall* _tmp1330_;
			_tmp1329_ = async_call;
			_tmp1330_ = ccall;
			_tmp1323_ = _tmp1329_ != _tmp1330_;
		} else {
			_tmp1323_ = FALSE;
		}
		if (_tmp1323_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1331_;
			ValaDataType* _tmp1332_;
			ValaDataType* _tmp1333_;
			ValaDelegateType* _tmp1334_;
			ValaDelegateType* _tmp1335_;
			ValaDelegate* _tmp1336_;
			ValaDelegate* _tmp1337_;
			gboolean _tmp1338_;
			gboolean _tmp1339_;
			_tmp1331_ = m;
			_tmp1332_ = vala_callable_get_return_type ((ValaCallable*) _tmp1331_);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1333_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1334_;
			_tmp1335_ = deleg_type;
			_tmp1336_ = vala_delegate_type_get_delegate_symbol (_tmp1335_);
			_tmp1337_ = _tmp1336_;
			_tmp1338_ = vala_delegate_get_has_target (_tmp1337_);
			_tmp1339_ = _tmp1338_;
			if (_tmp1339_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1340_;
				ValaVoidType* _tmp1341_;
				ValaPointerType* _tmp1342_;
				ValaPointerType* _tmp1343_;
				ValaLocalVariable* _tmp1344_;
				ValaLocalVariable* _tmp1345_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1346_;
				const gchar* _tmp1347_;
				const gchar* _tmp1348_;
				ValaCCodeExpression* _tmp1349_;
				ValaLocalVariable* _tmp1350_;
				ValaHashMap* _tmp1351_;
				ValaMethod* _tmp1352_;
				ValaCCodeExpression* _tmp1353_;
				ValaCCodeUnaryExpression* _tmp1354_;
				ValaCCodeUnaryExpression* _tmp1355_;
				ValaCCodeExpression* _tmp1356_;
				ValaDelegateType* _tmp1357_;
				_tmp1340_ = vala_void_type_new (NULL);
				_tmp1341_ = _tmp1340_;
				_tmp1342_ = vala_pointer_type_new ((ValaDataType*) _tmp1341_, NULL);
				_tmp1343_ = _tmp1342_;
				_tmp1344_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1343_, TRUE, NULL, TRUE);
				_tmp1345_ = _tmp1344_;
				_vala_code_node_unref0 (_tmp1343_);
				_vala_code_node_unref0 (_tmp1341_);
				temp_var = _tmp1345_;
				_tmp1346_ = temp_var;
				_tmp1347_ = vala_symbol_get_name ((ValaSymbol*) _tmp1346_);
				_tmp1348_ = _tmp1347_;
				_tmp1349_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1348_);
				temp_ref = _tmp1349_;
				_tmp1350_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1350_, FALSE);
				_tmp1351_ = out_arg_map;
				_tmp1352_ = m;
				_tmp1353_ = temp_ref;
				_tmp1354_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1353_);
				_tmp1355_ = _tmp1354_;
				vala_map_set ((ValaMap*) _tmp1351_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1352_), FALSE)), (ValaCCodeExpression*) _tmp1355_);
				_vala_ccode_node_unref0 (_tmp1355_);
				_tmp1356_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1356_);
				_tmp1357_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1357_)) {
					ValaDataType* _tmp1358_;
					ValaLocalVariable* _tmp1359_;
					ValaLocalVariable* _tmp1360_;
					const gchar* _tmp1361_;
					const gchar* _tmp1362_;
					ValaCCodeExpression* _tmp1363_;
					ValaLocalVariable* _tmp1364_;
					ValaHashMap* _tmp1365_;
					ValaMethod* _tmp1366_;
					ValaCCodeExpression* _tmp1367_;
					ValaCCodeUnaryExpression* _tmp1368_;
					ValaCCodeUnaryExpression* _tmp1369_;
					ValaCCodeExpression* _tmp1370_;
					_tmp1358_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1359_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1358_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1359_;
					_tmp1360_ = temp_var;
					_tmp1361_ = vala_symbol_get_name ((ValaSymbol*) _tmp1360_);
					_tmp1362_ = _tmp1361_;
					_tmp1363_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1362_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1363_;
					_tmp1364_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1364_, FALSE);
					_tmp1365_ = out_arg_map;
					_tmp1366_ = m;
					_tmp1367_ = temp_ref;
					_tmp1368_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1367_);
					_tmp1369_ = _tmp1368_;
					vala_map_set ((ValaMap*) _tmp1365_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1366_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1369_);
					_vala_ccode_node_unref0 (_tmp1369_);
					_tmp1370_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1370_);
				} else {
					ValaCCodeConstant* _tmp1371_;
					ValaCCodeConstant* _tmp1372_;
					_tmp1371_ = vala_ccode_constant_new ("NULL");
					_tmp1372_ = _tmp1371_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1372_);
					_vala_ccode_node_unref0 (_tmp1372_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1373_;
				ValaCCodeConstant* _tmp1374_;
				_tmp1373_ = vala_ccode_constant_new ("NULL");
				_tmp1374_ = _tmp1373_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1374_);
				_vala_ccode_node_unref0 (_tmp1374_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1376_ = deleg;
	if (_tmp1376_ != NULL) {
		ValaDelegate* _tmp1377_;
		ValaDataType* _tmp1378_;
		ValaDataType* _tmp1379_;
		_tmp1377_ = deleg;
		_tmp1378_ = vala_callable_get_return_type ((ValaCallable*) _tmp1377_);
		_tmp1379_ = _tmp1378_;
		_tmp1375_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1379_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1375_ = FALSE;
	}
	if (_tmp1375_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1380_;
		ValaDataType* _tmp1381_;
		ValaDataType* _tmp1382_;
		ValaArrayType* _tmp1383_;
		_tmp1380_ = deleg;
		_tmp1381_ = vala_callable_get_return_type ((ValaCallable*) _tmp1380_);
		_tmp1382_ = _tmp1381_;
		_tmp1383_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1382_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1383_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1384_ = FALSE;
				_tmp1384_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1386_;
					gint _tmp1387_;
					gint _tmp1388_;
					ValaDelegate* _tmp1389_;
					if (!_tmp1384_) {
						gint _tmp1385_;
						_tmp1385_ = dim;
						dim = _tmp1385_ + 1;
					}
					_tmp1384_ = FALSE;
					_tmp1386_ = array_type;
					_tmp1387_ = vala_array_type_get_rank (_tmp1386_);
					_tmp1388_ = _tmp1387_;
					if (!(dim <= _tmp1388_)) {
						break;
					}
					_tmp1389_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1389_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1390_;
						ValaDataType* _tmp1391_;
						ValaDataType* _tmp1392_;
						ValaLocalVariable* _tmp1393_;
						ValaLocalVariable* _tmp1394_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1395_;
						const gchar* _tmp1396_;
						const gchar* _tmp1397_;
						ValaCCodeExpression* _tmp1398_;
						ValaLocalVariable* _tmp1399_;
						ValaCCodeExpression* _tmp1400_;
						ValaCCodeExpression* _tmp1401_;
						ValaCCodeAssignment* _tmp1402_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1403_;
						ValaCCodeIdentifier* _tmp1404_;
						ValaCCodeFunctionCall* _tmp1405_;
						ValaCCodeFunctionCall* _tmp1406_;
						ValaCCodeFunctionCall* _tmp1407_;
						ValaCCodeExpression* _tmp1408_;
						ValaCCodeFunctionCall* _tmp1409_;
						_tmp1390_ = itype;
						_tmp1391_ = vala_data_type_get_return_type (_tmp1390_);
						_tmp1392_ = _tmp1391_;
						_tmp1393_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1392_, TRUE, NULL, FALSE);
						_tmp1394_ = _tmp1393_;
						_vala_code_node_unref0 (_tmp1392_);
						temp_var = _tmp1394_;
						_tmp1395_ = temp_var;
						_tmp1396_ = vala_symbol_get_name ((ValaSymbol*) _tmp1395_);
						_tmp1397_ = _tmp1396_;
						_tmp1398_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1397_);
						temp_ref = _tmp1398_;
						_tmp1399_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1399_, FALSE);
						_tmp1400_ = temp_ref;
						_tmp1401_ = ccall_expr;
						_tmp1402_ = vala_ccode_assignment_new (_tmp1400_, _tmp1401_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1402_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1403_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1404_ = _tmp1403_;
						_tmp1405_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1404_);
						_tmp1406_ = _tmp1405_;
						_vala_ccode_node_unref0 (_tmp1404_);
						len_call = _tmp1406_;
						_tmp1407_ = len_call;
						_tmp1408_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1407_, _tmp1408_);
						_tmp1409_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1409_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1410_;
						_tmp1410_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1410_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1411_;
							ValaDataType* _tmp1412_;
							ValaDataType* _tmp1413_;
							ValaLocalVariable* _tmp1414_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1415_;
							const gchar* _tmp1416_;
							const gchar* _tmp1417_;
							ValaCCodeExpression* _tmp1418_;
							ValaLocalVariable* _tmp1419_;
							ValaHashMap* _tmp1420_;
							ValaDelegate* _tmp1421_;
							ValaCCodeExpression* _tmp1422_;
							ValaCCodeUnaryExpression* _tmp1423_;
							ValaCCodeUnaryExpression* _tmp1424_;
							ValaCCodeExpression* _tmp1425_;
							_tmp1411_ = array_type;
							_tmp1412_ = vala_array_type_get_length_type (_tmp1411_);
							_tmp1413_ = _tmp1412_;
							_tmp1414_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1413_, TRUE, NULL, TRUE);
							temp_var = _tmp1414_;
							_tmp1415_ = temp_var;
							_tmp1416_ = vala_symbol_get_name ((ValaSymbol*) _tmp1415_);
							_tmp1417_ = _tmp1416_;
							_tmp1418_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1417_);
							temp_ref = _tmp1418_;
							_tmp1419_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1419_, FALSE);
							_tmp1420_ = out_arg_map;
							_tmp1421_ = deleg;
							_tmp1422_ = temp_ref;
							_tmp1423_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1422_);
							_tmp1424_ = _tmp1423_;
							vala_map_set ((ValaMap*) _tmp1420_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1421_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1424_);
							_vala_ccode_node_unref0 (_tmp1424_);
							_tmp1425_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1425_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1426_;
							ValaCCodeConstant* _tmp1427_;
							_tmp1426_ = vala_ccode_constant_new ("-1");
							_tmp1427_ = _tmp1426_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1427_);
							_vala_ccode_node_unref0 (_tmp1427_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1428_ = FALSE;
		ValaDelegate* _tmp1429_;
		_tmp1429_ = deleg;
		if (_tmp1429_ != NULL) {
			ValaDelegate* _tmp1430_;
			ValaDataType* _tmp1431_;
			ValaDataType* _tmp1432_;
			_tmp1430_ = deleg;
			_tmp1431_ = vala_callable_get_return_type ((ValaCallable*) _tmp1430_);
			_tmp1432_ = _tmp1431_;
			_tmp1428_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1432_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1428_ = FALSE;
		}
		if (_tmp1428_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1433_;
			ValaDataType* _tmp1434_;
			ValaDataType* _tmp1435_;
			ValaDelegateType* _tmp1436_;
			ValaDelegateType* _tmp1437_;
			ValaDelegate* _tmp1438_;
			ValaDelegate* _tmp1439_;
			gboolean _tmp1440_;
			gboolean _tmp1441_;
			_tmp1433_ = deleg;
			_tmp1434_ = vala_callable_get_return_type ((ValaCallable*) _tmp1433_);
			_tmp1435_ = _tmp1434_;
			_tmp1436_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1435_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1436_;
			_tmp1437_ = deleg_type;
			_tmp1438_ = vala_delegate_type_get_delegate_symbol (_tmp1437_);
			_tmp1439_ = _tmp1438_;
			_tmp1440_ = vala_delegate_get_has_target (_tmp1439_);
			_tmp1441_ = _tmp1440_;
			if (_tmp1441_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1442_;
				ValaVoidType* _tmp1443_;
				ValaPointerType* _tmp1444_;
				ValaPointerType* _tmp1445_;
				ValaLocalVariable* _tmp1446_;
				ValaLocalVariable* _tmp1447_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1448_;
				const gchar* _tmp1449_;
				const gchar* _tmp1450_;
				ValaCCodeExpression* _tmp1451_;
				ValaLocalVariable* _tmp1452_;
				ValaHashMap* _tmp1453_;
				ValaDelegate* _tmp1454_;
				ValaCCodeExpression* _tmp1455_;
				ValaCCodeUnaryExpression* _tmp1456_;
				ValaCCodeUnaryExpression* _tmp1457_;
				ValaCCodeExpression* _tmp1458_;
				ValaDelegateType* _tmp1459_;
				_tmp1442_ = vala_void_type_new (NULL);
				_tmp1443_ = _tmp1442_;
				_tmp1444_ = vala_pointer_type_new ((ValaDataType*) _tmp1443_, NULL);
				_tmp1445_ = _tmp1444_;
				_tmp1446_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1445_, TRUE, NULL, TRUE);
				_tmp1447_ = _tmp1446_;
				_vala_code_node_unref0 (_tmp1445_);
				_vala_code_node_unref0 (_tmp1443_);
				temp_var = _tmp1447_;
				_tmp1448_ = temp_var;
				_tmp1449_ = vala_symbol_get_name ((ValaSymbol*) _tmp1448_);
				_tmp1450_ = _tmp1449_;
				_tmp1451_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1450_);
				temp_ref = _tmp1451_;
				_tmp1452_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1452_, FALSE);
				_tmp1453_ = out_arg_map;
				_tmp1454_ = deleg;
				_tmp1455_ = temp_ref;
				_tmp1456_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1455_);
				_tmp1457_ = _tmp1456_;
				vala_map_set ((ValaMap*) _tmp1453_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1454_), FALSE)), (ValaCCodeExpression*) _tmp1457_);
				_vala_ccode_node_unref0 (_tmp1457_);
				_tmp1458_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1458_);
				_tmp1459_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1459_)) {
					ValaDataType* _tmp1460_;
					ValaLocalVariable* _tmp1461_;
					ValaLocalVariable* _tmp1462_;
					const gchar* _tmp1463_;
					const gchar* _tmp1464_;
					ValaCCodeExpression* _tmp1465_;
					ValaLocalVariable* _tmp1466_;
					ValaHashMap* _tmp1467_;
					ValaDelegate* _tmp1468_;
					ValaCCodeExpression* _tmp1469_;
					ValaCCodeUnaryExpression* _tmp1470_;
					ValaCCodeUnaryExpression* _tmp1471_;
					ValaCCodeExpression* _tmp1472_;
					_tmp1460_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1461_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1460_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1461_;
					_tmp1462_ = temp_var;
					_tmp1463_ = vala_symbol_get_name ((ValaSymbol*) _tmp1462_);
					_tmp1464_ = _tmp1463_;
					_tmp1465_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1464_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1465_;
					_tmp1466_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1466_, FALSE);
					_tmp1467_ = out_arg_map;
					_tmp1468_ = deleg;
					_tmp1469_ = temp_ref;
					_tmp1470_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1469_);
					_tmp1471_ = _tmp1470_;
					vala_map_set ((ValaMap*) _tmp1467_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1468_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1471_);
					_vala_ccode_node_unref0 (_tmp1471_);
					_tmp1472_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1472_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1474_ = m;
	if (_tmp1474_ != NULL) {
		ValaMethod* _tmp1475_;
		gboolean _tmp1476_;
		gboolean _tmp1477_;
		_tmp1475_ = m;
		_tmp1476_ = vala_method_get_coroutine (_tmp1475_);
		_tmp1477_ = _tmp1476_;
		_tmp1473_ = _tmp1477_;
	} else {
		_tmp1473_ = FALSE;
	}
	if (_tmp1473_) {
		gboolean _tmp1478_;
		gboolean _tmp1479_;
		_tmp1478_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1479_ = _tmp1478_;
		if (_tmp1479_) {
			ValaHashMap* _tmp1480_;
			ValaMethod* _tmp1481_;
			ValaMethod* _tmp1482_;
			gchar* _tmp1483_;
			gchar* _tmp1484_;
			ValaCCodeIdentifier* _tmp1485_;
			ValaCCodeIdentifier* _tmp1486_;
			ValaHashMap* _tmp1487_;
			ValaCCodeIdentifier* _tmp1488_;
			ValaCCodeIdentifier* _tmp1489_;
			_tmp1480_ = in_arg_map;
			_tmp1481_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1482_ = _tmp1481_;
			_tmp1483_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1482_);
			_tmp1484_ = _tmp1483_;
			_tmp1485_ = vala_ccode_identifier_new (_tmp1484_);
			_tmp1486_ = _tmp1485_;
			vala_map_set ((ValaMap*) _tmp1480_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1486_);
			_vala_ccode_node_unref0 (_tmp1486_);
			_g_free0 (_tmp1484_);
			_tmp1487_ = in_arg_map;
			_tmp1488_ = vala_ccode_identifier_new ("_data_");
			_tmp1489_ = _tmp1488_;
			vala_map_set ((ValaMap*) _tmp1487_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1489_);
			_vala_ccode_node_unref0 (_tmp1489_);
		}
	}
	_tmp1490_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1491_ = _tmp1490_;
	if (_tmp1491_) {
		ValaCallable* _tmp1492_ = NULL;
		ValaMethod* _tmp1493_;
		ValaHashMap* _tmp1495_;
		ValaCCodeExpression* _tmp1496_;
		ValaCCodeExpression* _tmp1497_;
		ValaCCodeUnaryExpression* _tmp1498_;
		ValaCCodeUnaryExpression* _tmp1499_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1493_ = m;
		_tmp1492_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1493_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1492_ == NULL) {
			ValaDelegate* _tmp1494_;
			_tmp1494_ = deleg;
			_tmp1492_ = (ValaCallable*) _tmp1494_;
		}
		_tmp1495_ = out_arg_map;
		_tmp1496_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1497_ = _tmp1496_;
		_tmp1498_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1497_);
		_tmp1499_ = _tmp1498_;
		vala_map_set ((ValaMap*) _tmp1495_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1492_), FALSE)), (ValaCCodeExpression*) _tmp1499_);
		_vala_ccode_node_unref0 (_tmp1499_);
		_vala_ccode_node_unref0 (_tmp1497_);
	} else {
		gboolean _tmp1500_ = FALSE;
		gboolean _tmp1501_ = FALSE;
		ValaMethod* _tmp1502_;
		_tmp1502_ = m;
		if (_tmp1502_ != NULL) {
			ValaMethod* _tmp1503_;
			_tmp1503_ = m;
			_tmp1501_ = vala_method_has_error_type_parameter (_tmp1503_);
		} else {
			_tmp1501_ = FALSE;
		}
		if (_tmp1501_) {
			ValaCCodeFunctionCall* _tmp1504_;
			ValaCCodeFunctionCall* _tmp1505_;
			_tmp1504_ = async_call;
			_tmp1505_ = ccall;
			_tmp1500_ = _tmp1504_ != _tmp1505_;
		} else {
			_tmp1500_ = FALSE;
		}
		if (_tmp1500_) {
			ValaHashMap* _tmp1506_;
			ValaMethod* _tmp1507_;
			ValaCCodeConstant* _tmp1508_;
			ValaCCodeConstant* _tmp1509_;
			_tmp1506_ = out_arg_map;
			_tmp1507_ = m;
			_tmp1508_ = vala_ccode_constant_new ("NULL");
			_tmp1509_ = _tmp1508_;
			vala_map_set ((ValaMap*) _tmp1506_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1507_), FALSE)), (ValaCCodeExpression*) _tmp1509_);
			_vala_ccode_node_unref0 (_tmp1509_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1510_;
		_tmp1510_ = m;
		if (_tmp1510_ == NULL) {
			ValaHashMap* _tmp1511_;
			ValaCCodeConstant* _tmp1512_;
			ValaCCodeConstant* _tmp1513_;
			_tmp1511_ = in_arg_map;
			_tmp1512_ = vala_ccode_constant_new ("NULL");
			_tmp1513_ = _tmp1512_;
			vala_map_set ((ValaMap*) _tmp1511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1513_);
			_vala_ccode_node_unref0 (_tmp1513_);
		} else {
			gboolean _tmp1514_ = FALSE;
			gboolean _tmp1515_ = FALSE;
			gboolean _tmp1516_ = FALSE;
			ValaMethod* _tmp1517_;
			gboolean _tmp1518_;
			gboolean _tmp1519_;
			_tmp1517_ = m;
			_tmp1518_ = vala_method_get_printf_format (_tmp1517_);
			_tmp1519_ = _tmp1518_;
			if (!_tmp1519_) {
				ValaMethod* _tmp1520_;
				gboolean _tmp1521_;
				gboolean _tmp1522_;
				_tmp1520_ = m;
				_tmp1521_ = vala_method_get_scanf_format (_tmp1520_);
				_tmp1522_ = _tmp1521_;
				_tmp1516_ = !_tmp1522_;
			} else {
				_tmp1516_ = FALSE;
			}
			if (_tmp1516_) {
				ValaMethod* _tmp1523_;
				gchar* _tmp1524_;
				gchar* _tmp1525_;
				_tmp1523_ = m;
				_tmp1524_ = vala_get_ccode_sentinel (_tmp1523_);
				_tmp1525_ = _tmp1524_;
				_tmp1515_ = g_strcmp0 (_tmp1525_, "") != 0;
				_g_free0 (_tmp1525_);
			} else {
				_tmp1515_ = FALSE;
			}
			if (_tmp1515_) {
				gboolean _tmp1526_;
				gboolean _tmp1527_;
				_tmp1526_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1527_ = _tmp1526_;
				_tmp1514_ = !_tmp1527_;
			} else {
				_tmp1514_ = FALSE;
			}
			if (_tmp1514_) {
				ValaHashMap* _tmp1528_;
				ValaMethod* _tmp1529_;
				gchar* _tmp1530_;
				gchar* _tmp1531_;
				ValaCCodeConstant* _tmp1532_;
				ValaCCodeConstant* _tmp1533_;
				_tmp1528_ = in_arg_map;
				_tmp1529_ = m;
				_tmp1530_ = vala_get_ccode_sentinel (_tmp1529_);
				_tmp1531_ = _tmp1530_;
				_tmp1532_ = vala_ccode_constant_new (_tmp1531_);
				_tmp1533_ = _tmp1532_;
				vala_map_set ((ValaMap*) _tmp1528_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1533_);
				_vala_ccode_node_unref0 (_tmp1533_);
				_g_free0 (_tmp1531_);
			}
		}
	}
	_tmp1534_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1534_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1535_;
		ValaDelegateType* _tmp1536_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1537_;
		ValaDelegate* _tmp1538_;
		ValaDelegate* _tmp1539_;
		ValaDelegate* _tmp1540_;
		ValaDelegate* _tmp1541_;
		gboolean _tmp1542_;
		gboolean _tmp1543_;
		_tmp1535_ = itype;
		_tmp1536_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1535_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1536_;
		_tmp1537_ = deleg_type;
		_tmp1538_ = vala_delegate_type_get_delegate_symbol (_tmp1537_);
		_tmp1539_ = _tmp1538_;
		_tmp1540_ = _vala_code_node_ref0 (_tmp1539_);
		d = _tmp1540_;
		_tmp1541_ = d;
		_tmp1542_ = vala_delegate_get_has_target (_tmp1541_);
		_tmp1543_ = _tmp1542_;
		if (_tmp1543_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1544_;
			ValaDelegate* _tmp1545_;
			ValaExpression* _tmp1546_;
			ValaExpression* _tmp1547_;
			ValaCCodeExpression* _tmp1548_ = NULL;
			ValaCCodeExpression* _tmp1549_;
			ValaCCodeExpression* _tmp1550_;
			ValaHashMap* _tmp1551_;
			ValaDelegate* _tmp1552_;
			ValaExpression* _tmp1553_;
			ValaExpression* _tmp1554_;
			ValaCCodeExpression* _tmp1555_ = NULL;
			ValaCCodeExpression* _tmp1556_;
			ValaCCodeExpression* _tmp1557_;
			_tmp1544_ = in_arg_map;
			_tmp1545_ = d;
			_tmp1546_ = vala_method_call_get_call (expr);
			_tmp1547_ = _tmp1546_;
			_tmp1549_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1547_, &_tmp1548_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1548_;
			_tmp1550_ = _tmp1549_;
			vala_map_set ((ValaMap*) _tmp1544_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1545_), FALSE)), _tmp1550_);
			_vala_ccode_node_unref0 (_tmp1550_);
			_tmp1551_ = out_arg_map;
			_tmp1552_ = d;
			_tmp1553_ = vala_method_call_get_call (expr);
			_tmp1554_ = _tmp1553_;
			_tmp1556_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1554_, &_tmp1555_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1555_;
			_tmp1557_ = _tmp1556_;
			vala_map_set ((ValaMap*) _tmp1551_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1552_), FALSE)), _tmp1557_);
			_vala_ccode_node_unref0 (_tmp1557_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1558_ = itype;
	_tmp1559_ = vala_data_type_get_return_type (_tmp1558_);
	_tmp1560_ = _tmp1559_;
	_tmp1561_ = vala_data_type_is_real_non_null_struct_type (_tmp1560_);
	_vala_code_node_unref0 (_tmp1560_);
	return_result_via_out_param = _tmp1561_;
	_tmp1563_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1563_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1564_;
		ValaDataType* _tmp1565_;
		ValaDataType* _tmp1566_;
		_tmp1564_ = itype;
		_tmp1565_ = vala_data_type_get_return_type (_tmp1564_);
		_tmp1566_ = _tmp1565_;
		_tmp1562_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1566_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1566_);
	} else {
		_tmp1562_ = FALSE;
	}
	if (_tmp1562_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1567_;
		ValaSignal* _tmp1568_;
		ValaSignal* _tmp1569_;
		ValaSignal* _tmp1570_;
		gboolean _tmp1571_ = FALSE;
		gboolean _tmp1572_ = FALSE;
		ValaMemberAccess* _tmp1573_;
		_tmp1567_ = itype;
		_tmp1568_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1567_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1569_ = _tmp1568_;
		_tmp1570_ = _vala_code_node_ref0 (_tmp1569_);
		sig = _tmp1570_;
		_tmp1573_ = ma;
		if (_tmp1573_ != NULL) {
			ValaMemberAccess* _tmp1574_;
			ValaExpression* _tmp1575_;
			ValaExpression* _tmp1576_;
			_tmp1574_ = ma;
			_tmp1575_ = vala_member_access_get_inner (_tmp1574_);
			_tmp1576_ = _tmp1575_;
			_tmp1572_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1576_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1572_ = FALSE;
		}
		if (_tmp1572_) {
			ValaSignal* _tmp1577_;
			gboolean _tmp1578_;
			gboolean _tmp1579_;
			_tmp1577_ = sig;
			_tmp1578_ = vala_signal_get_is_virtual (_tmp1577_);
			_tmp1579_ = _tmp1578_;
			_tmp1571_ = _tmp1579_;
		} else {
			_tmp1571_ = FALSE;
		}
		if (_tmp1571_) {
		} else {
			gboolean _tmp1580_ = FALSE;
			ValaSignal* _tmp1581_;
			_tmp1581_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1581_)) {
				_tmp1580_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1582_;
				ValaSourceReference* _tmp1583_;
				ValaSourceReference* _tmp1584_;
				ValaSourceFile* _tmp1585_;
				ValaSourceFile* _tmp1586_;
				ValaSignal* _tmp1587_;
				ValaSourceReference* _tmp1588_;
				ValaSourceReference* _tmp1589_;
				ValaSourceFile* _tmp1590_;
				ValaSourceFile* _tmp1591_;
				_tmp1582_ = ma;
				_tmp1583_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1582_);
				_tmp1584_ = _tmp1583_;
				_tmp1585_ = vala_source_reference_get_file (_tmp1584_);
				_tmp1586_ = _tmp1585_;
				_tmp1587_ = sig;
				_tmp1588_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1587_);
				_tmp1589_ = _tmp1588_;
				_tmp1590_ = vala_source_reference_get_file (_tmp1589_);
				_tmp1591_ = _tmp1590_;
				_tmp1580_ = _tmp1586_ == _tmp1591_;
			}
			if (_tmp1580_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1592_ = async_call;
	_tmp1593_ = ccall;
	if (_tmp1592_ == _tmp1593_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1594_;
		ValaDataType* _tmp1595_;
		ValaDataType* _tmp1596_;
		ValaLocalVariable* _tmp1597_;
		ValaLocalVariable* _tmp1598_;
		ValaLocalVariable* _tmp1599_;
		const gchar* _tmp1600_;
		const gchar* _tmp1601_;
		ValaCCodeExpression* _tmp1602_;
		ValaLocalVariable* _tmp1603_;
		ValaHashMap* _tmp1604_;
		ValaCCodeExpression* _tmp1605_;
		ValaCCodeUnaryExpression* _tmp1606_;
		ValaCCodeUnaryExpression* _tmp1607_;
		_tmp1594_ = itype;
		_tmp1595_ = vala_data_type_get_return_type (_tmp1594_);
		_tmp1596_ = _tmp1595_;
		_tmp1597_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1596_, TRUE, NULL, TRUE);
		_tmp1598_ = _tmp1597_;
		_vala_code_node_unref0 (_tmp1596_);
		out_param_var = _tmp1598_;
		_tmp1599_ = out_param_var;
		_tmp1600_ = vala_symbol_get_name ((ValaSymbol*) _tmp1599_);
		_tmp1601_ = _tmp1600_;
		_tmp1602_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1601_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1602_;
		_tmp1603_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1603_, FALSE);
		_tmp1604_ = out_arg_map;
		_tmp1605_ = out_param_ref;
		_tmp1606_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1605_);
		_tmp1607_ = _tmp1606_;
		vala_map_set ((ValaMap*) _tmp1604_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1607_);
		_vala_ccode_node_unref0 (_tmp1607_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1608_ = async_call;
	_tmp1609_ = ccall;
	if (_tmp1608_ != _tmp1609_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1620_;
			ValaHashMap* _tmp1621_;
			gpointer _tmp1622_;
			ValaCCodeExpression* _tmp1623_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1610_;
				ValaSet* _tmp1611_;
				ValaSet* _tmp1612_;
				ValaIterator* _tmp1613_;
				ValaIterator* _tmp1614_;
				_tmp1610_ = out_arg_map;
				_tmp1611_ = vala_map_get_keys ((ValaMap*) _tmp1610_);
				_tmp1612_ = _tmp1611_;
				_tmp1613_ = vala_iterable_iterator ((ValaIterable*) _tmp1612_);
				_tmp1614_ = _tmp1613_;
				_vala_iterable_unref0 (_tmp1612_);
				_pos_it = _tmp1614_;
				while (TRUE) {
					ValaIterator* _tmp1615_;
					gint pos = 0;
					ValaIterator* _tmp1616_;
					gpointer _tmp1617_;
					gboolean _tmp1618_ = FALSE;
					_tmp1615_ = _pos_it;
					if (!vala_iterator_next (_tmp1615_)) {
						break;
					}
					_tmp1616_ = _pos_it;
					_tmp1617_ = vala_iterator_get (_tmp1616_);
					pos = (gint) ((gintptr) _tmp1617_);
					if (pos > last_pos) {
						gboolean _tmp1619_ = FALSE;
						if (min_pos == -1) {
							_tmp1619_ = TRUE;
						} else {
							_tmp1619_ = pos < min_pos;
						}
						_tmp1618_ = _tmp1619_;
					} else {
						_tmp1618_ = FALSE;
					}
					if (_tmp1618_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1620_ = ccall;
			_tmp1621_ = out_arg_map;
			_tmp1622_ = vala_map_get ((ValaMap*) _tmp1621_, (gpointer) ((gintptr) min_pos));
			_tmp1623_ = (ValaCCodeExpression*) _tmp1622_;
			vala_ccode_function_call_add_argument (_tmp1620_, _tmp1623_);
			_vala_ccode_node_unref0 (_tmp1623_);
			last_pos = min_pos;
		}
	}
	_tmp1624_ = async_call;
	if (_tmp1624_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1635_;
			ValaHashMap* _tmp1636_;
			gpointer _tmp1637_;
			ValaCCodeExpression* _tmp1638_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1625_;
				ValaSet* _tmp1626_;
				ValaSet* _tmp1627_;
				ValaIterator* _tmp1628_;
				ValaIterator* _tmp1629_;
				_tmp1625_ = in_arg_map;
				_tmp1626_ = vala_map_get_keys ((ValaMap*) _tmp1625_);
				_tmp1627_ = _tmp1626_;
				_tmp1628_ = vala_iterable_iterator ((ValaIterable*) _tmp1627_);
				_tmp1629_ = _tmp1628_;
				_vala_iterable_unref0 (_tmp1627_);
				_pos_it = _tmp1629_;
				while (TRUE) {
					ValaIterator* _tmp1630_;
					gint pos = 0;
					ValaIterator* _tmp1631_;
					gpointer _tmp1632_;
					gboolean _tmp1633_ = FALSE;
					_tmp1630_ = _pos_it;
					if (!vala_iterator_next (_tmp1630_)) {
						break;
					}
					_tmp1631_ = _pos_it;
					_tmp1632_ = vala_iterator_get (_tmp1631_);
					pos = (gint) ((gintptr) _tmp1632_);
					if (pos > last_pos) {
						gboolean _tmp1634_ = FALSE;
						if (min_pos == -1) {
							_tmp1634_ = TRUE;
						} else {
							_tmp1634_ = pos < min_pos;
						}
						_tmp1633_ = _tmp1634_;
					} else {
						_tmp1633_ = FALSE;
					}
					if (_tmp1633_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1635_ = async_call;
			_tmp1636_ = in_arg_map;
			_tmp1637_ = vala_map_get ((ValaMap*) _tmp1636_, (gpointer) ((gintptr) min_pos));
			_tmp1638_ = (ValaCCodeExpression*) _tmp1637_;
			vala_ccode_function_call_add_argument (_tmp1635_, _tmp1638_);
			_vala_ccode_node_unref0 (_tmp1638_);
			last_pos = min_pos;
		}
	}
	_tmp1639_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1640_ = _tmp1639_;
	if (_tmp1640_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1641_;
		gint _tmp1642_;
		ValaCCodeFunction* _tmp1643_;
		ValaCCodeFunction* _tmp1644_;
		ValaCCodeIdentifier* _tmp1645_;
		ValaCCodeIdentifier* _tmp1646_;
		ValaCCodeMemberAccess* _tmp1647_;
		ValaCCodeMemberAccess* _tmp1648_;
		gchar* _tmp1649_;
		gchar* _tmp1650_;
		ValaCCodeConstant* _tmp1651_;
		ValaCCodeConstant* _tmp1652_;
		ValaCCodeFunction* _tmp1653_;
		ValaCCodeFunction* _tmp1654_;
		ValaCCodeFunctionCall* _tmp1655_;
		ValaCCodeFunction* _tmp1656_;
		ValaCCodeFunction* _tmp1657_;
		ValaCCodeConstant* _tmp1658_;
		ValaCCodeConstant* _tmp1659_;
		ValaCCodeFunction* _tmp1660_;
		ValaCCodeFunction* _tmp1661_;
		gchar* _tmp1662_;
		gchar* _tmp1663_;
		_tmp1641_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1642_ = _tmp1641_->next_coroutine_state;
		_tmp1641_->next_coroutine_state = _tmp1642_ + 1;
		state = _tmp1642_;
		_tmp1643_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1644_ = _tmp1643_;
		_tmp1645_ = vala_ccode_identifier_new ("_data_");
		_tmp1646_ = _tmp1645_;
		_tmp1647_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1646_, "_state_");
		_tmp1648_ = _tmp1647_;
		_tmp1649_ = g_strdup_printf ("%i", state);
		_tmp1650_ = _tmp1649_;
		_tmp1651_ = vala_ccode_constant_new (_tmp1650_);
		_tmp1652_ = _tmp1651_;
		vala_ccode_function_add_assignment (_tmp1644_, (ValaCCodeExpression*) _tmp1648_, (ValaCCodeExpression*) _tmp1652_);
		_vala_ccode_node_unref0 (_tmp1652_);
		_g_free0 (_tmp1650_);
		_vala_ccode_node_unref0 (_tmp1648_);
		_vala_ccode_node_unref0 (_tmp1646_);
		_tmp1653_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1654_ = _tmp1653_;
		_tmp1655_ = async_call;
		vala_ccode_function_add_expression (_tmp1654_, (ValaCCodeExpression*) _tmp1655_);
		_tmp1656_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1657_ = _tmp1656_;
		_tmp1658_ = vala_ccode_constant_new ("FALSE");
		_tmp1659_ = _tmp1658_;
		vala_ccode_function_add_return (_tmp1657_, (ValaCCodeExpression*) _tmp1659_);
		_vala_ccode_node_unref0 (_tmp1659_);
		_tmp1660_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1661_ = _tmp1660_;
		_tmp1662_ = g_strdup_printf ("_state_%d", state);
		_tmp1663_ = _tmp1662_;
		vala_ccode_function_add_label (_tmp1661_, _tmp1663_);
		_g_free0 (_tmp1663_);
	}
	_tmp1664_ = vala_method_call_get_is_assert (expr);
	_tmp1665_ = _tmp1664_;
	if (_tmp1665_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1666_;
		ValaSourceReference* _tmp1667_;
		ValaSourceLocation _tmp1668_ = {0};
		ValaSourceLocation _tmp1669_;
		gchar* _tmp1670_;
		ValaSourceReference* _tmp1671_;
		ValaSourceReference* _tmp1672_;
		ValaSourceLocation _tmp1673_ = {0};
		ValaSourceLocation _tmp1674_;
		gchar* _tmp1675_;
		ValaSourceReference* _tmp1676_;
		ValaSourceReference* _tmp1677_;
		ValaSourceLocation _tmp1678_ = {0};
		ValaSourceLocation _tmp1679_;
		gchar* _tmp1680_;
		gchar* _tmp1681_;
		ValaCCodeFunctionCall* _tmp1682_;
		ValaCCodeIdentifier* _tmp1683_;
		ValaCCodeIdentifier* _tmp1684_;
		ValaCCodeFunctionCall* _tmp1685_;
		const gchar* _tmp1686_;
		gchar* _tmp1687_;
		gchar* _tmp1688_;
		gchar* _tmp1689_;
		gchar* _tmp1690_;
		gchar* _tmp1691_;
		gchar* _tmp1692_;
		ValaCCodeConstant* _tmp1693_;
		ValaCCodeConstant* _tmp1694_;
		_tmp1666_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1667_ = _tmp1666_;
		vala_source_reference_get_begin (_tmp1667_, &_tmp1668_);
		_tmp1669_ = _tmp1668_;
		_tmp1670_ = _tmp1669_.pos;
		_tmp1671_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1672_ = _tmp1671_;
		vala_source_reference_get_end (_tmp1672_, &_tmp1673_);
		_tmp1674_ = _tmp1673_;
		_tmp1675_ = _tmp1674_.pos;
		_tmp1676_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1677_ = _tmp1676_;
		vala_source_reference_get_begin (_tmp1677_, &_tmp1678_);
		_tmp1679_ = _tmp1678_;
		_tmp1680_ = _tmp1679_.pos;
		_tmp1681_ = string_substring ((const gchar*) _tmp1670_, (glong) 0, (glong) ((gint) (_tmp1675_ - _tmp1680_)));
		message = _tmp1681_;
		_tmp1682_ = ccall;
		_tmp1683_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1684_ = _tmp1683_;
		vala_ccode_function_call_set_call (_tmp1682_, (ValaCCodeExpression*) _tmp1684_);
		_vala_ccode_node_unref0 (_tmp1684_);
		_tmp1685_ = ccall;
		_tmp1686_ = message;
		_tmp1687_ = string_replace (_tmp1686_, "\n", " ");
		_tmp1688_ = _tmp1687_;
		_tmp1689_ = g_strescape (_tmp1688_, "");
		_tmp1690_ = _tmp1689_;
		_tmp1691_ = g_strdup_printf ("\"%s\"", _tmp1690_);
		_tmp1692_ = _tmp1691_;
		_tmp1693_ = vala_ccode_constant_new (_tmp1692_);
		_tmp1694_ = _tmp1693_;
		vala_ccode_function_call_add_argument (_tmp1685_, (ValaCCodeExpression*) _tmp1694_);
		_vala_ccode_node_unref0 (_tmp1694_);
		_g_free0 (_tmp1692_);
		_g_free0 (_tmp1690_);
		_g_free0 (_tmp1688_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1695_;
		ValaCCodeFunction* _tmp1696_;
		ValaCCodeExpression* _tmp1697_;
		ValaCCodeExpression* _tmp1698_;
		ValaCCodeExpression* _tmp1699_;
		_tmp1695_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1696_ = _tmp1695_;
		_tmp1697_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1696_, _tmp1697_);
		_tmp1698_ = out_param_ref;
		_tmp1699_ = _vala_ccode_node_ref0 (_tmp1698_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1699_;
	}
	_tmp1702_ = m;
	if (_tmp1702_ != NULL) {
		ValaMethod* _tmp1703_;
		ValaMemberBinding _tmp1704_;
		ValaMemberBinding _tmp1705_;
		_tmp1703_ = m;
		_tmp1704_ = vala_method_get_binding (_tmp1703_);
		_tmp1705_ = _tmp1704_;
		_tmp1701_ = _tmp1705_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1701_ = FALSE;
	}
	if (_tmp1701_) {
		ValaMethod* _tmp1706_;
		gboolean _tmp1707_;
		gboolean _tmp1708_;
		_tmp1706_ = m;
		_tmp1707_ = vala_method_get_returns_modified_pointer (_tmp1706_);
		_tmp1708_ = _tmp1707_;
		_tmp1700_ = _tmp1708_;
	} else {
		_tmp1700_ = FALSE;
	}
	if (_tmp1700_) {
		gboolean _tmp1709_ = FALSE;
		gboolean _tmp1710_ = FALSE;
		ValaMemberAccess* _tmp1711_;
		_tmp1711_ = ma;
		if (_tmp1711_ != NULL) {
			ValaMemberAccess* _tmp1712_;
			ValaExpression* _tmp1713_;
			ValaExpression* _tmp1714_;
			ValaSymbol* _tmp1715_;
			ValaSymbol* _tmp1716_;
			_tmp1712_ = ma;
			_tmp1713_ = vala_member_access_get_inner (_tmp1712_);
			_tmp1714_ = _tmp1713_;
			_tmp1715_ = vala_expression_get_symbol_reference (_tmp1714_);
			_tmp1716_ = _tmp1715_;
			_tmp1710_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1716_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1710_ = FALSE;
		}
		if (_tmp1710_) {
			ValaMemberAccess* _tmp1717_;
			ValaExpression* _tmp1718_;
			ValaExpression* _tmp1719_;
			_tmp1717_ = ma;
			_tmp1718_ = vala_member_access_get_inner (_tmp1717_);
			_tmp1719_ = _tmp1718_;
			_tmp1709_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1719_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1709_ = FALSE;
		}
		if (_tmp1709_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1720_;
			ValaExpression* _tmp1721_;
			ValaExpression* _tmp1722_;
			ValaSymbol* _tmp1723_;
			ValaSymbol* _tmp1724_;
			ValaProperty* _tmp1725_;
			ValaProperty* _tmp1726_;
			ValaMemberAccess* _tmp1727_;
			ValaExpression* _tmp1728_;
			ValaExpression* _tmp1729_;
			ValaExpression* _tmp1730_;
			ValaExpression* _tmp1731_;
			ValaDataType* _tmp1732_;
			ValaDataType* _tmp1733_;
			ValaCCodeExpression* _tmp1734_;
			ValaGLibValue* _tmp1735_;
			ValaGLibValue* _tmp1736_;
			_tmp1720_ = ma;
			_tmp1721_ = vala_member_access_get_inner (_tmp1720_);
			_tmp1722_ = _tmp1721_;
			_tmp1723_ = vala_expression_get_symbol_reference (_tmp1722_);
			_tmp1724_ = _tmp1723_;
			_tmp1725_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1724_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1725_;
			_tmp1726_ = prop;
			_tmp1727_ = ma;
			_tmp1728_ = vala_member_access_get_inner (_tmp1727_);
			_tmp1729_ = _tmp1728_;
			_tmp1730_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1729_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1731_ = _tmp1730_;
			_tmp1732_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1733_ = _tmp1732_;
			_tmp1734_ = ccall_expr;
			_tmp1735_ = vala_glib_value_new (_tmp1733_, _tmp1734_, FALSE);
			_tmp1736_ = _tmp1735_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1726_, _tmp1731_, (ValaTargetValue*) _tmp1736_);
			_vala_target_value_unref0 (_tmp1736_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1737_;
			ValaCCodeExpression* _tmp1738_;
			ValaCCodeAssignment* _tmp1739_;
			_tmp1737_ = instance;
			_tmp1738_ = ccall_expr;
			_tmp1739_ = vala_ccode_assignment_new (_tmp1737_, _tmp1738_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1739_;
		}
	}
	_tmp1745_ = m;
	if (_tmp1745_ != NULL) {
		ValaMethod* _tmp1746_;
		_tmp1746_ = m;
		_tmp1744_ = vala_get_ccode_simple_generics (_tmp1746_);
	} else {
		_tmp1744_ = FALSE;
	}
	if (_tmp1744_) {
		ValaMethod* _tmp1747_;
		ValaDataType* _tmp1748_;
		ValaDataType* _tmp1749_;
		_tmp1747_ = m;
		_tmp1748_ = vala_callable_get_return_type ((ValaCallable*) _tmp1747_);
		_tmp1749_ = _tmp1748_;
		_tmp1743_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1749_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1743_ = FALSE;
	}
	if (_tmp1743_) {
		ValaDataType* _tmp1750_;
		ValaDataType* _tmp1751_;
		_tmp1750_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1751_ = _tmp1750_;
		_tmp1742_ = vala_data_type_is_real_struct_type (_tmp1751_);
	} else {
		_tmp1742_ = FALSE;
	}
	if (_tmp1742_) {
		ValaDataType* _tmp1752_;
		ValaDataType* _tmp1753_;
		gboolean _tmp1754_;
		gboolean _tmp1755_;
		_tmp1752_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1753_ = _tmp1752_;
		_tmp1754_ = vala_data_type_get_nullable (_tmp1753_);
		_tmp1755_ = _tmp1754_;
		_tmp1741_ = !_tmp1755_;
	} else {
		_tmp1741_ = FALSE;
	}
	if (_tmp1741_) {
		ValaDataType* _tmp1756_;
		ValaDataType* _tmp1757_;
		_tmp1756_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1757_ = _tmp1756_;
		_tmp1740_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1757_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1740_ = FALSE;
	}
	if (_tmp1740_) {
		ValaCCodeExpression* _tmp1758_;
		ValaCCodeParenthesizedExpression* _tmp1759_;
		ValaCCodeParenthesizedExpression* _tmp1760_;
		ValaCCodeUnaryExpression* _tmp1761_;
		_tmp1758_ = ccall_expr;
		_tmp1759_ = vala_ccode_parenthesized_expression_new (_tmp1758_);
		_tmp1760_ = _tmp1759_;
		_tmp1761_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1760_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1761_;
		_vala_ccode_node_unref0 (_tmp1760_);
	}
	_tmp1764_ = m;
	if (_tmp1764_ != NULL) {
		ValaMethod* _tmp1765_;
		gchar* _tmp1766_;
		gchar* _tmp1767_;
		_tmp1765_ = m;
		_tmp1766_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1765_);
		_tmp1767_ = _tmp1766_;
		_tmp1763_ = _tmp1767_ != NULL;
		_g_free0 (_tmp1767_);
	} else {
		_tmp1763_ = FALSE;
	}
	if (_tmp1763_) {
		ValaMethod* _tmp1768_;
		gchar* _tmp1769_;
		gchar* _tmp1770_;
		ValaMethod* _tmp1771_;
		ValaDataType* _tmp1772_;
		ValaDataType* _tmp1773_;
		gchar* _tmp1774_;
		gchar* _tmp1775_;
		_tmp1768_ = m;
		_tmp1769_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1768_);
		_tmp1770_ = _tmp1769_;
		_tmp1771_ = m;
		_tmp1772_ = vala_callable_get_return_type ((ValaCallable*) _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_tmp1774_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1773_);
		_tmp1775_ = _tmp1774_;
		_tmp1762_ = g_strcmp0 (_tmp1770_, _tmp1775_) != 0;
		_g_free0 (_tmp1775_);
		_g_free0 (_tmp1770_);
	} else {
		_tmp1762_ = FALSE;
	}
	if (_tmp1762_) {
		ValaCCodeExpression* _tmp1776_;
		ValaMethod* _tmp1777_;
		ValaDataType* _tmp1778_;
		ValaDataType* _tmp1779_;
		gchar* _tmp1780_;
		gchar* _tmp1781_;
		ValaCCodeCastExpression* _tmp1782_;
		_tmp1776_ = ccall_expr;
		_tmp1777_ = m;
		_tmp1778_ = vala_callable_get_return_type ((ValaCallable*) _tmp1777_);
		_tmp1779_ = _tmp1778_;
		_tmp1780_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1779_);
		_tmp1781_ = _tmp1780_;
		_tmp1782_ = vala_ccode_cast_expression_new (_tmp1776_, _tmp1781_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1782_;
		_g_free0 (_tmp1781_);
	}
	_tmp1783_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1783_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1784_;
		ValaList* _tmp1785_;
		ValaIterator* _tmp1786_;
		ValaIterator* _tmp1787_;
		ValaIterator* _tmp1788_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1789_;
		gpointer _tmp1790_;
		ValaExpression* _tmp1791_;
		ValaCCodeExpression* _tmp1792_;
		ValaCCodeExpression* _tmp1793_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1794_;
		ValaLocalVariable* _tmp1795_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1796_;
		const gchar* _tmp1797_;
		const gchar* _tmp1798_;
		ValaCCodeExpression* _tmp1799_;
		ValaLocalVariable* _tmp1800_;
		ValaCCodeFile* _tmp1801_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1802_;
		ValaExpression* _tmp1803_;
		ValaExpression* _tmp1804_;
		ValaCCodeExpression* _tmp1805_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1806_;
		ValaExpression* _tmp1807_;
		ValaExpression* _tmp1808_;
		ValaCCodeExpression* _tmp1809_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1810_;
		ValaExpression* _tmp1811_;
		ValaExpression* _tmp1812_;
		ValaDataType* _tmp1813_;
		ValaDataType* _tmp1814_;
		ValaArrayType* _tmp1815_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1816_;
		ValaDataType* _tmp1817_;
		ValaDataType* _tmp1818_;
		gchar* _tmp1819_;
		gchar* _tmp1820_;
		gchar* _tmp1821_;
		gchar* _tmp1822_;
		ValaCCodeIdentifier* _tmp1823_;
		ValaCCodeIdentifier* _tmp1824_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1825_;
		ValaCCodeExpression* _tmp1826_;
		ValaCCodeBinaryExpression* _tmp1827_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1828_;
		ValaCCodeExpression* _tmp1829_;
		ValaCCodeBinaryExpression* _tmp1830_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1831_;
		ValaCCodeIdentifier* _tmp1832_;
		ValaCCodeFunctionCall* _tmp1833_;
		ValaCCodeFunctionCall* _tmp1834_;
		ValaCCodeFunctionCall* _tmp1835_;
		ValaCCodeExpression* _tmp1836_;
		ValaCCodeExpression* _tmp1837_;
		ValaCCodeBinaryExpression* _tmp1838_;
		ValaCCodeBinaryExpression* _tmp1839_;
		ValaCCodeFunctionCall* _tmp1840_;
		ValaCCodeConstant* _tmp1841_;
		ValaCCodeConstant* _tmp1842_;
		ValaCCodeFunctionCall* _tmp1843_;
		ValaCCodeIdentifier* _tmp1844_;
		ValaCCodeBinaryExpression* _tmp1845_;
		ValaCCodeBinaryExpression* _tmp1846_;
		ValaCCodeBinaryExpression* _tmp1847_;
		ValaCCodeFunction* _tmp1848_;
		ValaCCodeFunction* _tmp1849_;
		ValaCCodeExpression* _tmp1850_;
		ValaCCodeExpression* _tmp1851_;
		ValaCCodeFunction* _tmp1852_;
		ValaCCodeFunction* _tmp1853_;
		ValaCCodeExpression* _tmp1854_;
		ValaCCodeFunction* _tmp1855_;
		ValaCCodeFunction* _tmp1856_;
		ValaCCodeBinaryExpression* _tmp1857_;
		ValaCCodeFunctionCall* _tmp1858_;
		ValaCCodeConstant* _tmp1859_;
		ValaCCodeConstant* _tmp1860_;
		ValaCCodeConditionalExpression* _tmp1861_;
		ValaCCodeConditionalExpression* _tmp1862_;
		ValaCCodeFunction* _tmp1863_;
		ValaCCodeFunction* _tmp1864_;
		ValaMemberAccess* _tmp1865_;
		ValaExpression* _tmp1866_;
		ValaExpression* _tmp1867_;
		ValaCCodeExpression* _tmp1868_;
		ValaCCodeExpression* _tmp1869_;
		ValaCCodeExpression* _tmp1870_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1871_;
		ValaExpression* _tmp1872_;
		ValaExpression* _tmp1873_;
		ValaSymbol* _tmp1874_;
		ValaSymbol* _tmp1875_;
		ValaSymbol* _tmp1876_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1877_;
		ValaLocalVariable* _tmp1878_;
		gboolean _tmp1879_ = FALSE;
		gboolean _tmp1880_ = FALSE;
		ValaSymbol* _tmp1881_;
		_tmp1784_ = vala_method_call_get_argument_list (expr);
		_tmp1785_ = _tmp1784_;
		_tmp1786_ = vala_iterable_iterator ((ValaIterable*) _tmp1785_);
		_tmp1787_ = _tmp1786_;
		_vala_iterable_unref0 (_tmp1785_);
		arg_it = _tmp1787_;
		_tmp1788_ = arg_it;
		vala_iterator_next (_tmp1788_);
		_tmp1789_ = arg_it;
		_tmp1790_ = vala_iterator_get (_tmp1789_);
		_tmp1791_ = (ValaExpression*) _tmp1790_;
		_tmp1792_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1791_);
		_tmp1793_ = _tmp1792_;
		_vala_code_node_unref0 (_tmp1791_);
		new_size = _tmp1793_;
		_tmp1794_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1795_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1794_, TRUE, NULL, FALSE);
		temp_decl = _tmp1795_;
		_tmp1796_ = temp_decl;
		_tmp1797_ = vala_symbol_get_name ((ValaSymbol*) _tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1798_);
		temp_ref = _tmp1799_;
		_tmp1800_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1800_, FALSE);
		_tmp1801_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1801_, "string.h", FALSE);
		_tmp1802_ = ma;
		_tmp1803_ = vala_member_access_get_inner (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1804_, 1);
		clen = _tmp1805_;
		_tmp1806_ = ma;
		_tmp1807_ = vala_member_access_get_inner (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1808_);
		celems = _tmp1809_;
		_tmp1810_ = ma;
		_tmp1811_ = vala_member_access_get_inner (_tmp1810_);
		_tmp1812_ = _tmp1811_;
		_tmp1813_ = vala_expression_get_value_type (_tmp1812_);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1814_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1815_;
		_tmp1816_ = array_type;
		_tmp1817_ = vala_array_type_get_element_type (_tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = g_strdup_printf ("sizeof (%s)", _tmp1820_);
		_tmp1822_ = _tmp1821_;
		_tmp1823_ = vala_ccode_identifier_new (_tmp1822_);
		_tmp1824_ = _tmp1823_;
		_g_free0 (_tmp1822_);
		_g_free0 (_tmp1820_);
		csizeof = _tmp1824_;
		_tmp1825_ = temp_ref;
		_tmp1826_ = clen;
		_tmp1827_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1825_, _tmp1826_);
		cdelta = _tmp1827_;
		_tmp1828_ = temp_ref;
		_tmp1829_ = clen;
		_tmp1830_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1828_, _tmp1829_);
		ccheck = _tmp1830_;
		_tmp1831_ = vala_ccode_identifier_new ("memset");
		_tmp1832_ = _tmp1831_;
		_tmp1833_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1832_);
		_tmp1834_ = _tmp1833_;
		_vala_ccode_node_unref0 (_tmp1832_);
		czero = _tmp1834_;
		_tmp1835_ = czero;
		_tmp1836_ = celems;
		_tmp1837_ = clen;
		_tmp1838_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1836_, _tmp1837_);
		_tmp1839_ = _tmp1838_;
		vala_ccode_function_call_add_argument (_tmp1835_, (ValaCCodeExpression*) _tmp1839_);
		_vala_ccode_node_unref0 (_tmp1839_);
		_tmp1840_ = czero;
		_tmp1841_ = vala_ccode_constant_new ("0");
		_tmp1842_ = _tmp1841_;
		vala_ccode_function_call_add_argument (_tmp1840_, (ValaCCodeExpression*) _tmp1842_);
		_vala_ccode_node_unref0 (_tmp1842_);
		_tmp1843_ = czero;
		_tmp1844_ = csizeof;
		_tmp1845_ = cdelta;
		_tmp1846_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1844_, (ValaCCodeExpression*) _tmp1845_);
		_tmp1847_ = _tmp1846_;
		vala_ccode_function_call_add_argument (_tmp1843_, (ValaCCodeExpression*) _tmp1847_);
		_vala_ccode_node_unref0 (_tmp1847_);
		_tmp1848_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1849_ = _tmp1848_;
		_tmp1850_ = temp_ref;
		_tmp1851_ = new_size;
		vala_ccode_function_add_assignment (_tmp1849_, _tmp1850_, _tmp1851_);
		_tmp1852_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1853_ = _tmp1852_;
		_tmp1854_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1853_, _tmp1854_);
		_tmp1855_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1856_ = _tmp1855_;
		_tmp1857_ = ccheck;
		_tmp1858_ = czero;
		_tmp1859_ = vala_ccode_constant_new ("NULL");
		_tmp1860_ = _tmp1859_;
		_tmp1861_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1857_, (ValaCCodeExpression*) _tmp1858_, (ValaCCodeExpression*) _tmp1860_);
		_tmp1862_ = _tmp1861_;
		vala_ccode_function_add_expression (_tmp1856_, (ValaCCodeExpression*) _tmp1862_);
		_vala_ccode_node_unref0 (_tmp1862_);
		_vala_ccode_node_unref0 (_tmp1860_);
		_tmp1863_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1864_ = _tmp1863_;
		_tmp1865_ = ma;
		_tmp1866_ = vala_member_access_get_inner (_tmp1865_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1867_, 1);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1864_, _tmp1869_, _tmp1870_);
		_vala_ccode_node_unref0 (_tmp1869_);
		_tmp1871_ = ma;
		_tmp1872_ = vala_member_access_get_inner (_tmp1871_);
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = vala_expression_get_symbol_reference (_tmp1873_);
		_tmp1875_ = _tmp1874_;
		_tmp1876_ = _vala_code_node_ref0 (_tmp1875_);
		array_var = _tmp1876_;
		_tmp1877_ = array_var;
		_tmp1878_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1877_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1877_) : NULL);
		array_local = _tmp1878_;
		_tmp1881_ = array_var;
		if (_tmp1881_ != NULL) {
			ValaSymbol* _tmp1882_;
			_tmp1882_ = array_var;
			_tmp1880_ = vala_symbol_is_internal_symbol (_tmp1882_);
		} else {
			_tmp1880_ = FALSE;
		}
		if (_tmp1880_) {
			gboolean _tmp1883_ = FALSE;
			gboolean _tmp1884_ = FALSE;
			ValaSymbol* _tmp1885_;
			_tmp1885_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1885_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1886_;
				gboolean _tmp1887_;
				gboolean _tmp1888_;
				_tmp1886_ = array_local;
				_tmp1887_ = vala_local_variable_get_captured (_tmp1886_);
				_tmp1888_ = _tmp1887_;
				_tmp1884_ = !_tmp1888_;
			} else {
				_tmp1884_ = FALSE;
			}
			if (_tmp1884_) {
				_tmp1883_ = TRUE;
			} else {
				ValaSymbol* _tmp1889_;
				_tmp1889_ = array_var;
				_tmp1883_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1889_, VALA_TYPE_FIELD);
			}
			_tmp1879_ = _tmp1883_;
		} else {
			_tmp1879_ = FALSE;
		}
		if (_tmp1879_) {
			ValaCCodeFunction* _tmp1890_;
			ValaCCodeFunction* _tmp1891_;
			ValaMemberAccess* _tmp1892_;
			ValaExpression* _tmp1893_;
			ValaExpression* _tmp1894_;
			ValaTargetValue* _tmp1895_;
			ValaTargetValue* _tmp1896_;
			ValaCCodeExpression* _tmp1897_;
			ValaCCodeExpression* _tmp1898_;
			ValaCCodeExpression* _tmp1899_;
			_tmp1890_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1891_ = _tmp1890_;
			_tmp1892_ = ma;
			_tmp1893_ = vala_member_access_get_inner (_tmp1892_);
			_tmp1894_ = _tmp1893_;
			_tmp1895_ = vala_expression_get_target_value (_tmp1894_);
			_tmp1896_ = _tmp1895_;
			_tmp1897_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1896_);
			_tmp1898_ = _tmp1897_;
			_tmp1899_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1891_, _tmp1898_, _tmp1899_);
			_vala_ccode_node_unref0 (_tmp1898_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1901_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1902_ = _tmp1901_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1902_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1903_;
		ValaDataType* _tmp1904_;
		_tmp1903_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1904_ = _tmp1903_;
		_tmp1900_ = !vala_data_type_is_disposable (_tmp1904_);
	} else {
		_tmp1900_ = FALSE;
	}
	if (_tmp1900_) {
		gboolean _tmp1905_ = FALSE;
		ValaCCodeExpression* _tmp1906_;
		_tmp1906_ = ccall_expr;
		if (_tmp1906_ != NULL) {
			_tmp1905_ = !return_result_via_out_param;
		} else {
			_tmp1905_ = FALSE;
		}
		if (_tmp1905_) {
			ValaCCodeFunction* _tmp1907_;
			ValaCCodeFunction* _tmp1908_;
			ValaCCodeExpression* _tmp1909_;
			_tmp1907_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1908_ = _tmp1907_;
			_tmp1909_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1908_, _tmp1909_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1910_;
		ValaDataType* _tmp1911_;
		gboolean _tmp1912_ = FALSE;
		ValaDataType* _tmp1913_;
		ValaDataType* _tmp1914_;
		gboolean _tmp1941_ = FALSE;
		ValaMethod* _tmp1942_;
		_tmp1910_ = itype;
		_tmp1911_ = vala_data_type_get_return_type (_tmp1910_);
		result_type = _tmp1911_;
		_tmp1913_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1914_ = _tmp1913_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1914_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1915_;
			ValaDataType* _tmp1916_;
			_tmp1915_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1916_ = _tmp1915_;
			_tmp1912_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1916_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1912_ = FALSE;
		}
		if (_tmp1912_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1917_;
			ValaDataType* _tmp1918_;
			ValaTypeParameter* _tmp1919_;
			ValaTypeParameter* _tmp1920_;
			ValaTypeParameter* _tmp1921_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1922_;
			ValaSymbol* _tmp1923_;
			ValaSymbol* _tmp1924_;
			ValaSymbol* _tmp1925_;
			ValaSymbol* _tmp1926_;
			ValaStruct* _tmp1927_;
			gboolean _tmp1928_ = FALSE;
			ValaTypeParameter* _tmp1929_;
			ValaSymbol* _tmp1930_;
			ValaSymbol* _tmp1931_;
			ValaTypeSymbol* _tmp1932_;
			_tmp1917_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1918_ = _tmp1917_;
			_tmp1919_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1918_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1920_ = _tmp1919_;
			_tmp1921_ = _vala_code_node_ref0 (_tmp1920_);
			type_parameter = _tmp1921_;
			_tmp1922_ = type_parameter;
			_tmp1923_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1922_);
			_tmp1924_ = _tmp1923_;
			_tmp1925_ = vala_symbol_get_parent_symbol (_tmp1924_);
			_tmp1926_ = _tmp1925_;
			_tmp1927_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1926_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1926_) : NULL);
			st = _tmp1927_;
			_tmp1929_ = type_parameter;
			_tmp1930_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1929_);
			_tmp1931_ = _tmp1930_;
			_tmp1932_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1931_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1932_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1928_ = TRUE;
			} else {
				gboolean _tmp1933_ = FALSE;
				ValaStruct* _tmp1934_;
				_tmp1934_ = st;
				if (_tmp1934_ != NULL) {
					ValaStruct* _tmp1935_;
					gchar* _tmp1936_;
					gchar* _tmp1937_;
					_tmp1935_ = st;
					_tmp1936_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1935_);
					_tmp1937_ = _tmp1936_;
					_tmp1933_ = g_strcmp0 (_tmp1937_, "va_list") == 0;
					_g_free0 (_tmp1937_);
				} else {
					_tmp1933_ = FALSE;
				}
				_tmp1928_ = _tmp1933_;
			}
			if (_tmp1928_) {
				ValaDataType* _tmp1938_;
				ValaDataType* _tmp1939_;
				ValaDataType* _tmp1940_;
				_tmp1938_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1939_ = _tmp1938_;
				_tmp1940_ = _vala_code_node_ref0 (_tmp1939_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1940_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1942_ = m;
		if (_tmp1942_ != NULL) {
			ValaMethod* _tmp1943_;
			_tmp1943_ = m;
			_tmp1941_ = vala_method_get_format_arg_index (_tmp1943_) >= 0;
		} else {
			_tmp1941_ = FALSE;
		}
		if (_tmp1941_) {
			ValaCCodeExpression* _tmp1944_;
			_tmp1944_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1944_);
		} else {
			gboolean _tmp1945_ = FALSE;
			ValaMethod* _tmp1946_;
			_tmp1946_ = m;
			if (_tmp1946_ != NULL) {
				ValaMethod* _tmp1947_;
				_tmp1947_ = m;
				_tmp1945_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1947_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1945_ = FALSE;
			}
			if (_tmp1945_) {
				ValaCCodeExpression* _tmp1948_;
				_tmp1948_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1948_);
			} else {
				gboolean _tmp1949_ = FALSE;
				gboolean _tmp1950_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp1950_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1950_ = FALSE;
				}
				if (_tmp1950_) {
					gboolean _tmp1951_ = FALSE;
					ValaDataType* _tmp1952_;
					_tmp1952_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1952_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1953_;
						_tmp1953_ = result_type;
						_tmp1951_ = !vala_data_type_is_disposable (_tmp1953_);
					} else {
						_tmp1951_ = FALSE;
					}
					_tmp1949_ = _tmp1951_;
				} else {
					_tmp1949_ = FALSE;
				}
				if (_tmp1949_) {
					ValaCCodeExpression* _tmp1954_;
					_tmp1954_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1954_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1955_;
						ValaDataType* _tmp1956_;
						gboolean _tmp1957_;
						gboolean _tmp1958_;
						ValaLocalVariable* _tmp1959_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1960_;
						const gchar* _tmp1961_;
						const gchar* _tmp1962_;
						ValaCCodeExpression* _tmp1963_;
						ValaLocalVariable* _tmp1964_;
						ValaCCodeFunction* _tmp1965_;
						ValaCCodeFunction* _tmp1966_;
						ValaCCodeExpression* _tmp1967_;
						ValaCCodeExpression* _tmp1968_;
						ValaCCodeExpression* _tmp1969_;
						ValaTargetValue* _tmp1970_;
						ValaTargetValue* _tmp1971_;
						_tmp1955_ = result_type;
						_tmp1956_ = result_type;
						_tmp1957_ = vala_data_type_get_value_owned (_tmp1956_);
						_tmp1958_ = _tmp1957_;
						_tmp1959_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1955_, _tmp1958_, NULL, FALSE);
						temp_var = _tmp1959_;
						_tmp1960_ = temp_var;
						_tmp1961_ = vala_symbol_get_name ((ValaSymbol*) _tmp1960_);
						_tmp1962_ = _tmp1961_;
						_tmp1963_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1962_);
						temp_ref = _tmp1963_;
						_tmp1964_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1964_, FALSE);
						_tmp1965_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1966_ = _tmp1965_;
						_tmp1967_ = temp_ref;
						_tmp1968_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1966_, _tmp1967_, _tmp1968_);
						_tmp1969_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1969_);
						_tmp1970_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1971_ = _tmp1970_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1971_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1972_;
						ValaTargetValue* _tmp1973_;
						ValaTargetValue* _tmp1974_;
						_tmp1972_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1972_);
						_tmp1973_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1974_ = _tmp1973_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1974_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1975_ = params;
	_tmp1976_ = vala_iterable_iterator ((ValaIterable*) _tmp1975_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1976_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1977_;
		gint _arg_size = 0;
		ValaList* _tmp1978_;
		gint _tmp1979_;
		gint _tmp1980_;
		gint _arg_index = 0;
		_tmp1977_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1977_;
		_tmp1978_ = _arg_list;
		_tmp1979_ = vala_collection_get_size ((ValaCollection*) _tmp1978_);
		_tmp1980_ = _tmp1979_;
		_arg_size = _tmp1980_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp1981_;
			gpointer _tmp1982_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1983_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1986_;
			ValaUnaryExpression* _tmp1987_;
			gboolean _tmp1988_ = FALSE;
			ValaUnaryExpression* _tmp1989_;
			gboolean _tmp2043_ = FALSE;
			ValaUnaryExpression* _tmp2044_;
			ValaUnaryExpression* _tmp2048_;
			ValaExpression* _tmp2049_;
			ValaExpression* _tmp2050_;
			ValaDataType* _tmp2051_;
			ValaDataType* _tmp2052_;
			gboolean _tmp2062_ = FALSE;
			ValaMemberAccess* _tmp2063_;
			ValaSymbol* _tmp2064_;
			ValaSymbol* _tmp2065_;
			ValaUnaryExpression* _tmp2081_;
			ValaExpression* _tmp2082_;
			ValaExpression* _tmp2083_;
			ValaTargetValue* _tmp2084_;
			ValaTargetValue* _tmp2085_;
			ValaUnaryExpression* _tmp2086_;
			ValaTargetValue* _tmp2087_;
			ValaTargetValue* _tmp2088_;
			ValaUnaryExpression* _tmp2089_;
			ValaExpression* _tmp2090_;
			ValaExpression* _tmp2091_;
			ValaDataType* _tmp2092_;
			ValaDataType* _tmp2093_;
			ValaExpression* _tmp2094_;
			ValaTargetValue* _tmp2095_;
			ValaTargetValue* _tmp2096_;
			ValaSourceReference* _tmp2097_;
			ValaSourceReference* _tmp2098_;
			gboolean _tmp2099_ = FALSE;
			ValaParameter* _tmp2100_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp1981_ = _arg_list;
			_tmp1982_ = vala_list_get (_tmp1981_, _arg_index);
			arg = (ValaExpression*) _tmp1982_;
			param = NULL;
			_tmp1983_ = params_it;
			if (vala_iterator_next (_tmp1983_)) {
				ValaIterator* _tmp1984_;
				gpointer _tmp1985_;
				_tmp1984_ = params_it;
				_tmp1985_ = vala_iterator_get (_tmp1984_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1985_;
			}
			_tmp1986_ = arg;
			_tmp1987_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1986_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1986_) : NULL);
			unary = _tmp1987_;
			_tmp1989_ = unary;
			if (_tmp1989_ != NULL) {
				ValaUnaryExpression* _tmp1990_;
				ValaUnaryOperator _tmp1991_;
				ValaUnaryOperator _tmp1992_;
				_tmp1990_ = unary;
				_tmp1991_ = vala_unary_expression_get_operator (_tmp1990_);
				_tmp1992_ = _tmp1991_;
				_tmp1988_ = _tmp1992_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp1988_ = FALSE;
			}
			if (_tmp1988_) {
				gboolean _tmp1993_ = FALSE;
				gboolean _tmp1994_ = FALSE;
				gboolean _tmp1995_ = FALSE;
				ValaParameter* _tmp1996_;
				_tmp1996_ = param;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1996_)) {
					ValaParameter* _tmp1997_;
					ValaDataType* _tmp1998_;
					ValaDataType* _tmp1999_;
					_tmp1997_ = param;
					_tmp1998_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1997_);
					_tmp1999_ = _tmp1998_;
					_tmp1995_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1999_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp1995_ = FALSE;
				}
				if (_tmp1995_) {
					ValaParameter* _tmp2000_;
					ValaDataType* _tmp2001_;
					ValaDataType* _tmp2002_;
					gboolean _tmp2003_;
					gboolean _tmp2004_;
					_tmp2000_ = param;
					_tmp2001_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2000_);
					_tmp2002_ = _tmp2001_;
					_tmp2003_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2002_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2004_ = _tmp2003_;
					_tmp1994_ = !_tmp2004_;
				} else {
					_tmp1994_ = FALSE;
				}
				if (_tmp1994_) {
					ValaParameter* _tmp2005_;
					ValaDataType* _tmp2006_;
					ValaDataType* _tmp2007_;
					gint _tmp2008_;
					gint _tmp2009_;
					_tmp2005_ = param;
					_tmp2006_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2005_);
					_tmp2007_ = _tmp2006_;
					_tmp2008_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2007_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2009_ = _tmp2008_;
					_tmp1993_ = _tmp2009_ == 1;
				} else {
					_tmp1993_ = FALSE;
				}
				if (_tmp1993_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2010_;
					ValaExpression* _tmp2011_;
					ValaExpression* _tmp2012_;
					ValaSymbol* _tmp2013_;
					ValaSymbol* _tmp2014_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2015_;
					gboolean _tmp2016_ = FALSE;
					gboolean _tmp2017_ = FALSE;
					ValaSymbol* _tmp2018_;
					_tmp2010_ = unary;
					_tmp2011_ = vala_unary_expression_get_inner (_tmp2010_);
					_tmp2012_ = _tmp2011_;
					_tmp2013_ = vala_expression_get_symbol_reference (_tmp2012_);
					_tmp2014_ = _tmp2013_;
					array_var = _tmp2014_;
					_tmp2015_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2015_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2015_) : NULL;
					_tmp2018_ = array_var;
					if (_tmp2018_ != NULL) {
						ValaSymbol* _tmp2019_;
						_tmp2019_ = array_var;
						_tmp2017_ = vala_symbol_is_internal_symbol (_tmp2019_);
					} else {
						_tmp2017_ = FALSE;
					}
					if (_tmp2017_) {
						gboolean _tmp2020_ = FALSE;
						gboolean _tmp2021_ = FALSE;
						ValaLocalVariable* _tmp2022_;
						_tmp2022_ = array_local;
						if (_tmp2022_ != NULL) {
							ValaLocalVariable* _tmp2023_;
							gboolean _tmp2024_;
							gboolean _tmp2025_;
							_tmp2023_ = array_local;
							_tmp2024_ = vala_local_variable_get_captured (_tmp2023_);
							_tmp2025_ = _tmp2024_;
							_tmp2021_ = !_tmp2025_;
						} else {
							_tmp2021_ = FALSE;
						}
						if (_tmp2021_) {
							_tmp2020_ = TRUE;
						} else {
							ValaSymbol* _tmp2026_;
							_tmp2026_ = array_var;
							_tmp2020_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2026_, VALA_TYPE_FIELD);
						}
						_tmp2016_ = _tmp2020_;
					} else {
						_tmp2016_ = FALSE;
					}
					if (_tmp2016_) {
						ValaCCodeFunction* _tmp2027_;
						ValaCCodeFunction* _tmp2028_;
						ValaUnaryExpression* _tmp2029_;
						ValaExpression* _tmp2030_;
						ValaExpression* _tmp2031_;
						ValaTargetValue* _tmp2032_;
						ValaTargetValue* _tmp2033_;
						ValaCCodeExpression* _tmp2034_;
						ValaCCodeExpression* _tmp2035_;
						ValaUnaryExpression* _tmp2036_;
						ValaExpression* _tmp2037_;
						ValaExpression* _tmp2038_;
						ValaTargetValue* _tmp2039_;
						ValaTargetValue* _tmp2040_;
						ValaCCodeExpression* _tmp2041_;
						ValaCCodeExpression* _tmp2042_;
						_tmp2027_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2028_ = _tmp2027_;
						_tmp2029_ = unary;
						_tmp2030_ = vala_unary_expression_get_inner (_tmp2029_);
						_tmp2031_ = _tmp2030_;
						_tmp2032_ = vala_expression_get_target_value (_tmp2031_);
						_tmp2033_ = _tmp2032_;
						_tmp2034_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp2033_);
						_tmp2035_ = _tmp2034_;
						_tmp2036_ = unary;
						_tmp2037_ = vala_unary_expression_get_inner (_tmp2036_);
						_tmp2038_ = _tmp2037_;
						_tmp2039_ = vala_expression_get_target_value (_tmp2038_);
						_tmp2040_ = _tmp2039_;
						_tmp2041_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2040_, 1);
						_tmp2042_ = _tmp2041_;
						vala_ccode_function_add_assignment (_tmp2028_, _tmp2035_, _tmp2042_);
						_vala_ccode_node_unref0 (_tmp2042_);
						_vala_ccode_node_unref0 (_tmp2035_);
					}
				}
			}
			_tmp2044_ = unary;
			if (_tmp2044_ == NULL) {
				_tmp2043_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2045_;
				ValaUnaryOperator _tmp2046_;
				ValaUnaryOperator _tmp2047_;
				_tmp2045_ = unary;
				_tmp2046_ = vala_unary_expression_get_operator (_tmp2045_);
				_tmp2047_ = _tmp2046_;
				_tmp2043_ = _tmp2047_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2043_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2048_ = unary;
			_tmp2049_ = vala_unary_expression_get_inner (_tmp2048_);
			_tmp2050_ = _tmp2049_;
			_tmp2051_ = vala_expression_get_value_type (_tmp2050_);
			_tmp2052_ = _tmp2051_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2052_)) {
				ValaCCodeFunction* _tmp2053_;
				ValaCCodeFunction* _tmp2054_;
				ValaUnaryExpression* _tmp2055_;
				ValaExpression* _tmp2056_;
				ValaExpression* _tmp2057_;
				ValaTargetValue* _tmp2058_;
				ValaTargetValue* _tmp2059_;
				ValaCCodeExpression* _tmp2060_;
				ValaCCodeExpression* _tmp2061_;
				_tmp2053_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2054_ = _tmp2053_;
				_tmp2055_ = unary;
				_tmp2056_ = vala_unary_expression_get_inner (_tmp2055_);
				_tmp2057_ = _tmp2056_;
				_tmp2058_ = vala_expression_get_target_value (_tmp2057_);
				_tmp2059_ = _tmp2058_;
				_tmp2060_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2059_, FALSE);
				_tmp2061_ = _tmp2060_;
				vala_ccode_function_add_expression (_tmp2054_, _tmp2061_);
				_vala_ccode_node_unref0 (_tmp2061_);
			}
			_tmp2063_ = ma;
			_tmp2064_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2063_);
			_tmp2065_ = _tmp2064_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2065_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2066_;
				ValaTargetValue* _tmp2067_;
				ValaTargetValue* _tmp2068_;
				ValaDataType* _tmp2069_;
				ValaDataType* _tmp2070_;
				_tmp2066_ = unary;
				_tmp2067_ = vala_expression_get_target_value ((ValaExpression*) _tmp2066_);
				_tmp2068_ = _tmp2067_;
				_tmp2069_ = vala_target_value_get_value_type (_tmp2068_);
				_tmp2070_ = _tmp2069_;
				_tmp2062_ = _tmp2070_ == NULL;
			} else {
				_tmp2062_ = FALSE;
			}
			if (_tmp2062_) {
				ValaUnaryExpression* _tmp2071_;
				ValaTargetValue* _tmp2072_;
				ValaTargetValue* _tmp2073_;
				ValaUnaryExpression* _tmp2074_;
				ValaExpression* _tmp2075_;
				ValaExpression* _tmp2076_;
				ValaDataType* _tmp2077_;
				ValaDataType* _tmp2078_;
				ValaDataType* _tmp2079_;
				ValaDataType* _tmp2080_;
				_tmp2071_ = unary;
				_tmp2072_ = vala_expression_get_target_value ((ValaExpression*) _tmp2071_);
				_tmp2073_ = _tmp2072_;
				_tmp2074_ = unary;
				_tmp2075_ = vala_unary_expression_get_inner (_tmp2074_);
				_tmp2076_ = _tmp2075_;
				_tmp2077_ = vala_expression_get_value_type (_tmp2076_);
				_tmp2078_ = _tmp2077_;
				_tmp2079_ = vala_data_type_copy (_tmp2078_);
				_tmp2080_ = _tmp2079_;
				vala_target_value_set_value_type (_tmp2073_, _tmp2080_);
				_vala_code_node_unref0 (_tmp2080_);
			}
			_tmp2081_ = unary;
			_tmp2082_ = vala_unary_expression_get_inner (_tmp2081_);
			_tmp2083_ = _tmp2082_;
			_tmp2084_ = vala_expression_get_target_value (_tmp2083_);
			_tmp2085_ = _tmp2084_;
			_tmp2086_ = unary;
			_tmp2087_ = vala_expression_get_target_value ((ValaExpression*) _tmp2086_);
			_tmp2088_ = _tmp2087_;
			_tmp2089_ = unary;
			_tmp2090_ = vala_unary_expression_get_inner (_tmp2089_);
			_tmp2091_ = _tmp2090_;
			_tmp2092_ = vala_expression_get_value_type (_tmp2091_);
			_tmp2093_ = _tmp2092_;
			_tmp2094_ = arg;
			_tmp2095_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2088_, _tmp2093_, (ValaCodeNode*) _tmp2094_);
			_tmp2096_ = _tmp2095_;
			_tmp2097_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2098_ = _tmp2097_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2085_, _tmp2096_, _tmp2098_);
			_vala_target_value_unref0 (_tmp2096_);
			_tmp2100_ = param;
			if (_tmp2100_ != NULL) {
				ValaParameter* _tmp2101_;
				_tmp2101_ = param;
				_tmp2099_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2101_);
			} else {
				_tmp2099_ = FALSE;
			}
			if (_tmp2099_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2102_;
				ValaCCodeIdentifier* _tmp2103_;
				ValaCCodeFunctionCall* _tmp2104_;
				ValaCCodeFunctionCall* _tmp2105_;
				ValaCCodeFunctionCall* _tmp2106_;
				ValaUnaryExpression* _tmp2107_;
				ValaExpression* _tmp2108_;
				ValaExpression* _tmp2109_;
				ValaTargetValue* _tmp2110_;
				ValaTargetValue* _tmp2111_;
				ValaCCodeExpression* _tmp2112_;
				ValaCCodeExpression* _tmp2113_;
				ValaCCodeFunction* _tmp2114_;
				ValaCCodeFunction* _tmp2115_;
				ValaUnaryExpression* _tmp2116_;
				ValaExpression* _tmp2117_;
				ValaExpression* _tmp2118_;
				ValaTargetValue* _tmp2119_;
				ValaTargetValue* _tmp2120_;
				ValaCCodeExpression* _tmp2121_;
				ValaCCodeExpression* _tmp2122_;
				ValaCCodeFunctionCall* _tmp2123_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2102_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2103_ = _tmp2102_;
				_tmp2104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2103_);
				_tmp2105_ = _tmp2104_;
				_vala_ccode_node_unref0 (_tmp2103_);
				len_call = _tmp2105_;
				_tmp2106_ = len_call;
				_tmp2107_ = unary;
				_tmp2108_ = vala_unary_expression_get_inner (_tmp2107_);
				_tmp2109_ = _tmp2108_;
				_tmp2110_ = vala_expression_get_target_value (_tmp2109_);
				_tmp2111_ = _tmp2110_;
				_tmp2112_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2111_);
				_tmp2113_ = _tmp2112_;
				vala_ccode_function_call_add_argument (_tmp2106_, _tmp2113_);
				_vala_ccode_node_unref0 (_tmp2113_);
				_tmp2114_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2115_ = _tmp2114_;
				_tmp2116_ = unary;
				_tmp2117_ = vala_unary_expression_get_inner (_tmp2116_);
				_tmp2118_ = _tmp2117_;
				_tmp2119_ = vala_expression_get_target_value (_tmp2118_);
				_tmp2120_ = _tmp2119_;
				_tmp2121_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2120_, 1);
				_tmp2122_ = _tmp2121_;
				_tmp2123_ = len_call;
				vala_ccode_function_add_assignment (_tmp2115_, _tmp2122_, (ValaCCodeExpression*) _tmp2123_);
				_vala_ccode_node_unref0 (_tmp2122_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2126_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2126_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2127_;
		ValaSymbol* _tmp2128_;
		ValaSymbol* _tmp2129_;
		_tmp2127_ = m;
		_tmp2128_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2127_);
		_tmp2129_ = _tmp2128_;
		_tmp2125_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2129_, VALA_TYPE_CLASS);
	} else {
		_tmp2125_ = FALSE;
	}
	if (_tmp2125_) {
		gboolean _tmp2130_ = FALSE;
		gboolean _tmp2131_ = FALSE;
		ValaClass* _tmp2132_;
		ValaClass* _tmp2133_;
		gboolean _tmp2134_;
		gboolean _tmp2135_;
		_tmp2132_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2133_ = _tmp2132_;
		_tmp2134_ = vala_class_get_is_compact (_tmp2133_);
		_tmp2135_ = _tmp2134_;
		if (_tmp2135_) {
			ValaClass* _tmp2136_;
			ValaClass* _tmp2137_;
			ValaClass* _tmp2138_;
			ValaClass* _tmp2139_;
			_tmp2136_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2137_ = _tmp2136_;
			_tmp2138_ = vala_class_get_base_class (_tmp2137_);
			_tmp2139_ = _tmp2138_;
			_tmp2131_ = _tmp2139_ != NULL;
		} else {
			_tmp2131_ = FALSE;
		}
		if (_tmp2131_) {
			_tmp2130_ = TRUE;
		} else {
			ValaClass* _tmp2140_;
			ValaClass* _tmp2141_;
			ValaClass* _tmp2142_;
			ValaClass* _tmp2143_;
			ValaClass* _tmp2144_;
			_tmp2140_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2141_ = _tmp2140_;
			_tmp2142_ = vala_class_get_base_class (_tmp2141_);
			_tmp2143_ = _tmp2142_;
			_tmp2144_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2130_ = _tmp2143_ == _tmp2144_;
		}
		_tmp2124_ = _tmp2130_;
	} else {
		_tmp2124_ = FALSE;
	}
	if (_tmp2124_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2145_;
		ValaClass* _tmp2146_;
		gchar* _tmp2147_;
		gchar* _tmp2148_;
		gchar* _tmp2149_;
		gchar* _tmp2150_;
		ValaCCodeIdentifier* _tmp2151_;
		ValaCCodeIdentifier* _tmp2152_;
		ValaCCodeFunctionCall* _tmp2153_;
		ValaCCodeFunctionCall* _tmp2154_;
		ValaCCodeFunctionCall* _tmp2155_;
		ValaCCodeExpression* _tmp2156_;
		ValaCCodeExpression* _tmp2157_;
		ValaClass* _tmp2158_;
		ValaClass* _tmp2159_;
		gboolean _tmp2160_;
		gboolean _tmp2161_;
		ValaCCodeFunction* _tmp2165_;
		ValaCCodeFunction* _tmp2166_;
		ValaCCodeFunctionCall* _tmp2167_;
		_tmp2145_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2146_ = _tmp2145_;
		_tmp2147_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2146_, NULL);
		_tmp2148_ = _tmp2147_;
		_tmp2149_ = g_strdup_printf ("%s_instance_init", _tmp2148_);
		_tmp2150_ = _tmp2149_;
		_tmp2151_ = vala_ccode_identifier_new (_tmp2150_);
		_tmp2152_ = _tmp2151_;
		_tmp2153_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2152_);
		_tmp2154_ = _tmp2153_;
		_vala_ccode_node_unref0 (_tmp2152_);
		_g_free0 (_tmp2150_);
		_g_free0 (_tmp2148_);
		cinitcall = _tmp2154_;
		_tmp2155_ = cinitcall;
		_tmp2156_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2157_ = _tmp2156_;
		vala_ccode_function_call_add_argument (_tmp2155_, _tmp2157_);
		_vala_ccode_node_unref0 (_tmp2157_);
		_tmp2158_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2159_ = _tmp2158_;
		_tmp2160_ = vala_class_get_is_compact (_tmp2159_);
		_tmp2161_ = _tmp2160_;
		if (!_tmp2161_) {
			ValaCCodeFunctionCall* _tmp2162_;
			ValaCCodeConstant* _tmp2163_;
			ValaCCodeConstant* _tmp2164_;
			_tmp2162_ = cinitcall;
			_tmp2163_ = vala_ccode_constant_new ("NULL");
			_tmp2164_ = _tmp2163_;
			vala_ccode_function_call_add_argument (_tmp2162_, (ValaCCodeExpression*) _tmp2164_);
			_vala_ccode_node_unref0 (_tmp2164_);
		}
		_tmp2165_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2166_ = _tmp2165_;
		_tmp2167_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2166_, (ValaCCodeExpression*) _tmp2167_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaUnaryExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp4_ = _arg_list;
			_tmp5_ = vala_list_get (_tmp4_, _arg_index);
			arg = (ValaExpression*) _tmp5_;
			_tmp6_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp6_) : NULL;
			_tmp8_ = unary;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_ = FALSE;
				ValaUnaryExpression* _tmp10_;
				ValaUnaryOperator _tmp11_;
				ValaUnaryOperator _tmp12_;
				_tmp10_ = unary;
				_tmp11_ = vala_unary_expression_get_operator (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp9_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp13_;
					ValaUnaryOperator _tmp14_;
					ValaUnaryOperator _tmp15_;
					_tmp13_ = unary;
					_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp7_ = _tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

