/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp540_ = FALSE;
	gboolean _tmp541_ = FALSE;
	gboolean _tmp542_ = FALSE;
	ValaExpression* _tmp543_;
	ValaExpression* _tmp544_;
	ValaSymbol* _tmp570_;
	ValaSymbol* _tmp571_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp598_;
	ValaSymbol* _tmp599_;
	ValaSymbol* _tmp600_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp601_;
	ValaSymbol* _tmp602_;
	ValaSymbol* _tmp1024_;
	ValaSymbol* _tmp1025_;
	ValaVersionAttribute* _tmp1026_;
	ValaVersionAttribute* _tmp1027_;
	ValaSourceReference* _tmp1028_;
	ValaSourceReference* _tmp1029_;
	gboolean _tmp1030_ = FALSE;
	ValaSymbolAccessibility _tmp1031_;
	gboolean _tmp1090_ = FALSE;
	gboolean _tmp1121_ = FALSE;
	gboolean _tmp1122_ = FALSE;
	ValaDataType* _tmp1377_;
	ValaDataType* _tmp1378_;
	gboolean _tmp1381_;
	gboolean _tmp1382_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (VALA_IS_PROPERTY (_tmp54_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp67_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp77_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (VALA_IS_METHOD (_tmp87_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = VALA_IS_TYPESYMBOL (_tmp108_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp147_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaUsingDirective* _tmp167_;
						gboolean _tmp168_;
						gboolean _tmp169_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaScope* _tmp173_;
						ValaScope* _tmp174_;
						const gchar* _tmp175_;
						ValaSymbol* _tmp176_;
						ValaSymbol* _tmp177_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_code_node_get_error ((ValaCodeNode*) _tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp169_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp170_ = ns;
						_tmp171_ = vala_using_directive_get_namespace_symbol (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = vala_symbol_get_scope (_tmp172_);
						_tmp174_ = _tmp173_;
						_tmp175_ = self->priv->_member_name;
						_tmp176_ = vala_scope_lookup (_tmp174_, _tmp175_);
						local_sym = _tmp176_;
						_tmp177_ = local_sym;
						if (_tmp177_ != NULL) {
							gboolean _tmp178_ = FALSE;
							ValaSymbol* _tmp179_;
							ValaSymbol* _tmp180_;
							ValaSymbol* _tmp196_;
							_tmp179_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp180_ = _tmp179_;
							if (_tmp180_ != NULL) {
								ValaSymbol* _tmp181_;
								ValaSymbol* _tmp182_;
								ValaSymbol* _tmp183_;
								_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = local_sym;
								_tmp178_ = _tmp182_ != _tmp183_;
							} else {
								_tmp178_ = FALSE;
							}
							if (_tmp178_) {
								ValaSourceReference* _tmp184_;
								ValaSourceReference* _tmp185_;
								const gchar* _tmp186_;
								ValaSymbol* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								ValaSymbol* _tmp191_;
								gchar* _tmp192_;
								gchar* _tmp193_;
								gchar* _tmp194_;
								gchar* _tmp195_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = self->priv->_member_name;
								_tmp187_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp188_ = _tmp187_;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = local_sym;
								_tmp192_ = vala_symbol_get_full_name (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp186_, _tmp190_, _tmp193_);
								_tmp195_ = _tmp194_;
								vala_report_error (_tmp185_, _tmp195_);
								_g_free0 (_tmp195_);
								_g_free0 (_tmp193_);
								_g_free0 (_tmp190_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp196_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp196_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp197_;
			ValaExpression* _tmp198_;
			gboolean _tmp199_;
			gboolean _tmp200_;
			ValaExpression* _tmp201_;
			ValaExpression* _tmp202_;
			ValaDataType* _tmp203_;
			ValaDataType* _tmp204_;
			ValaExpression* _tmp223_;
			ValaExpression* _tmp224_;
			gboolean _tmp240_ = FALSE;
			ValaExpression* _tmp241_;
			ValaExpression* _tmp242_;
			gboolean _tmp264_ = FALSE;
			ValaSymbol* _tmp265_;
			ValaSymbol* _tmp266_;
			gboolean _tmp301_ = FALSE;
			gboolean _tmp302_ = FALSE;
			ValaSymbol* _tmp303_;
			ValaSymbol* _tmp304_;
			gboolean _tmp522_ = FALSE;
			ValaSymbol* _tmp523_;
			ValaSymbol* _tmp524_;
			_tmp197_ = vala_member_access_get_inner (self);
			_tmp198_ = _tmp197_;
			_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
			_tmp200_ = _tmp199_;
			if (_tmp200_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp201_ = vala_member_access_get_inner (self);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_expression_get_value_type (_tmp202_);
			_tmp204_ = _tmp203_;
			if (VALA_IS_POINTER_TYPE (_tmp204_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp205_;
				ValaExpression* _tmp206_;
				ValaDataType* _tmp207_;
				ValaDataType* _tmp208_;
				ValaPointerType* _tmp209_;
				gboolean _tmp210_ = FALSE;
				ValaPointerType* _tmp211_;
				_tmp205_ = vala_member_access_get_inner (self);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_expression_get_value_type (_tmp206_);
				_tmp208_ = _tmp207_;
				_tmp209_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp208_) ? ((ValaPointerType*) _tmp208_) : NULL);
				pointer_type = _tmp209_;
				_tmp211_ = pointer_type;
				if (_tmp211_ != NULL) {
					ValaPointerType* _tmp212_;
					ValaDataType* _tmp213_;
					ValaDataType* _tmp214_;
					_tmp212_ = pointer_type;
					_tmp213_ = vala_pointer_type_get_base_type (_tmp212_);
					_tmp214_ = _tmp213_;
					_tmp210_ = VALA_IS_VALUE_TYPE (_tmp214_);
				} else {
					_tmp210_ = FALSE;
				}
				if (_tmp210_) {
					ValaExpression* _tmp215_;
					ValaExpression* _tmp216_;
					ValaSourceReference* _tmp217_;
					ValaSourceReference* _tmp218_;
					ValaPointerIndirection* _tmp219_;
					ValaPointerIndirection* _tmp220_;
					ValaExpression* _tmp221_;
					ValaExpression* _tmp222_;
					_tmp215_ = vala_member_access_get_inner (self);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_pointer_indirection_new (_tmp216_, _tmp218_);
					_tmp220_ = _tmp219_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp220_);
					_vala_code_node_unref0 (_tmp220_);
					_tmp221_ = vala_member_access_get_inner (self);
					_tmp222_ = _tmp221_;
					vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp223_ = vala_member_access_get_inner (self);
			_tmp224_ = _tmp223_;
			if (VALA_IS_MEMBER_ACCESS (_tmp224_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp225_;
				ValaExpression* _tmp226_;
				ValaMemberAccess* _tmp227_;
				ValaMemberAccess* _tmp228_;
				gboolean _tmp229_;
				_tmp225_ = vala_member_access_get_inner (self);
				_tmp226_ = _tmp225_;
				_tmp227_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp227_;
				_tmp228_ = ma;
				_tmp229_ = _tmp228_->priv->_prototype_access;
				if (_tmp229_) {
					ValaSourceReference* _tmp230_;
					ValaSourceReference* _tmp231_;
					ValaExpression* _tmp232_;
					ValaExpression* _tmp233_;
					ValaSymbol* _tmp234_;
					ValaSymbol* _tmp235_;
					gchar* _tmp236_;
					gchar* _tmp237_;
					gchar* _tmp238_;
					gchar* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp231_ = _tmp230_;
					_tmp232_ = vala_member_access_get_inner (self);
					_tmp233_ = _tmp232_;
					_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_symbol_get_full_name (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp237_);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp231_, _tmp239_);
					_g_free0 (_tmp239_);
					_g_free0 (_tmp237_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp241_ = vala_member_access_get_inner (self);
			_tmp242_ = _tmp241_;
			if (VALA_IS_MEMBER_ACCESS (_tmp242_)) {
				_tmp240_ = TRUE;
			} else {
				ValaExpression* _tmp243_;
				ValaExpression* _tmp244_;
				_tmp243_ = vala_member_access_get_inner (self);
				_tmp244_ = _tmp243_;
				_tmp240_ = VALA_IS_BASE_ACCESS (_tmp244_);
			}
			if (_tmp240_) {
				ValaExpression* _tmp245_;
				ValaExpression* _tmp246_;
				ValaSymbol* _tmp247_;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				gboolean _tmp250_ = FALSE;
				ValaSymbol* _tmp251_;
				ValaSymbol* _tmp252_;
				_tmp245_ = vala_member_access_get_inner (self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
				_tmp248_ = _tmp247_;
				_tmp249_ = _vala_code_node_ref0 (_tmp248_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp249_;
				_tmp251_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp252_ = _tmp251_;
				if (_tmp252_ == NULL) {
					gboolean _tmp253_ = FALSE;
					ValaSymbol* _tmp254_;
					_tmp254_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp254_)) {
						_tmp253_ = TRUE;
					} else {
						ValaSymbol* _tmp255_;
						_tmp255_ = base_symbol;
						_tmp253_ = VALA_IS_TYPESYMBOL (_tmp255_);
					}
					_tmp250_ = _tmp253_;
				} else {
					_tmp250_ = FALSE;
				}
				if (_tmp250_) {
					ValaSymbol* _tmp256_;
					ValaScope* _tmp257_;
					ValaScope* _tmp258_;
					const gchar* _tmp259_;
					ValaSymbol* _tmp260_;
					ValaSymbol* _tmp261_;
					ValaExpression* _tmp262_;
					ValaExpression* _tmp263_;
					_tmp256_ = base_symbol;
					_tmp257_ = vala_symbol_get_scope (_tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = self->priv->_member_name;
					_tmp260_ = vala_scope_lookup (_tmp258_, _tmp259_);
					_tmp261_ = _tmp260_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp261_);
					_vala_code_node_unref0 (_tmp261_);
					_tmp262_ = vala_member_access_get_inner (self);
					_tmp263_ = _tmp262_;
					if (VALA_IS_BASE_ACCESS (_tmp263_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp265_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp266_ = _tmp265_;
			if (_tmp266_ == NULL) {
				ValaExpression* _tmp267_;
				ValaExpression* _tmp268_;
				ValaDataType* _tmp269_;
				ValaDataType* _tmp270_;
				_tmp267_ = vala_member_access_get_inner (self);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_expression_get_value_type (_tmp268_);
				_tmp270_ = _tmp269_;
				_tmp264_ = _tmp270_ != NULL;
			} else {
				_tmp264_ = FALSE;
			}
			if (_tmp264_) {
				gboolean _tmp271_;
				ValaSymbol* _tmp299_;
				ValaSymbol* _tmp300_;
				_tmp271_ = self->priv->_pointer_member_access;
				if (_tmp271_) {
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaDataType* _tmp274_;
					ValaDataType* _tmp275_;
					const gchar* _tmp276_;
					ValaSymbol* _tmp277_;
					ValaSymbol* _tmp278_;
					_tmp272_ = vala_member_access_get_inner (self);
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_expression_get_value_type (_tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = self->priv->_member_name;
					_tmp277_ = vala_data_type_get_pointer_member (_tmp275_, _tmp276_);
					_tmp278_ = _tmp277_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp278_);
					_vala_code_node_unref0 (_tmp278_);
				} else {
					ValaExpression* _tmp279_;
					ValaExpression* _tmp280_;
					ValaDataType* _tmp281_;
					ValaDataType* _tmp282_;
					ValaTypeSymbol* _tmp283_;
					ValaTypeSymbol* _tmp284_;
					ValaExpression* _tmp292_;
					ValaExpression* _tmp293_;
					ValaDataType* _tmp294_;
					ValaDataType* _tmp295_;
					const gchar* _tmp296_;
					ValaSymbol* _tmp297_;
					ValaSymbol* _tmp298_;
					_tmp279_ = vala_member_access_get_inner (self);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_expression_get_value_type (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_data_type_get_data_type (_tmp282_);
					_tmp284_ = _tmp283_;
					if (_tmp284_ != NULL) {
						ValaExpression* _tmp285_;
						ValaExpression* _tmp286_;
						ValaDataType* _tmp287_;
						ValaDataType* _tmp288_;
						ValaTypeSymbol* _tmp289_;
						ValaTypeSymbol* _tmp290_;
						ValaSymbol* _tmp291_;
						_tmp285_ = vala_member_access_get_inner (self);
						_tmp286_ = _tmp285_;
						_tmp287_ = vala_expression_get_value_type (_tmp286_);
						_tmp288_ = _tmp287_;
						_tmp289_ = vala_data_type_get_data_type (_tmp288_);
						_tmp290_ = _tmp289_;
						_tmp291_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp290_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp291_;
					}
					_tmp292_ = vala_member_access_get_inner (self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_expression_get_value_type (_tmp293_);
					_tmp295_ = _tmp294_;
					_tmp296_ = self->priv->_member_name;
					_tmp297_ = vala_data_type_get_member (_tmp295_, _tmp296_);
					_tmp298_ = _tmp297_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp298_);
					_vala_code_node_unref0 (_tmp298_);
				}
				_tmp299_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp300_ = _tmp299_;
				if (_tmp300_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp303_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp304_ = _tmp303_;
			if (_tmp304_ == NULL) {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_expression_get_value_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp302_ = _tmp308_ != NULL;
			} else {
				_tmp302_ = FALSE;
			}
			if (_tmp302_) {
				ValaExpression* _tmp309_;
				ValaExpression* _tmp310_;
				ValaDataType* _tmp311_;
				ValaDataType* _tmp312_;
				gboolean _tmp313_;
				gboolean _tmp314_;
				_tmp309_ = vala_member_access_get_inner (self);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_expression_get_value_type (_tmp310_);
				_tmp312_ = _tmp311_;
				_tmp313_ = vala_data_type_get_is_dynamic (_tmp312_);
				_tmp314_ = _tmp313_;
				_tmp301_ = _tmp314_;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaObjectType* _tmp319_;
				ValaCodeNode* _tmp320_;
				ValaCodeNode* _tmp321_;
				ValaSymbol* _tmp470_;
				ValaSymbol* _tmp471_;
				ValaSymbol* _tmp520_;
				ValaSymbol* _tmp521_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_expression_get_value_type (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp319_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp318_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp319_;
				_tmp320_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				if (VALA_IS_METHOD_CALL (_tmp321_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp322_;
					ValaCodeNode* _tmp323_;
					ValaMethodCall* _tmp324_;
					ValaMethodCall* _tmp325_;
					ValaExpression* _tmp326_;
					ValaExpression* _tmp327_;
					_tmp322_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp323_ = _tmp322_;
					_tmp324_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp324_;
					_tmp325_ = invoc;
					_tmp326_ = vala_method_call_get_call (_tmp325_);
					_tmp327_ = _tmp326_;
					if (_tmp327_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp328_;
						ValaDataType* _tmp329_;
						ValaDataType* _tmp330_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp345_;
						ValaExpression* _tmp346_;
						ValaDataType* _tmp347_;
						ValaDataType* _tmp348_;
						const gchar* _tmp349_;
						ValaDataType* _tmp350_;
						ValaSourceReference* _tmp351_;
						ValaSourceReference* _tmp352_;
						ValaDynamicMethod* _tmp353_;
						ValaDynamicMethod* _tmp354_;
						ValaMethodCall* _tmp355_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp356_;
						ValaErrorType* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaErrorType* _tmp359_;
						ValaDynamicMethod* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaParameter* _tmp362_;
						ValaParameter* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaObjectType* _tmp365_;
						ValaDataType* _tmp366_;
						ValaDataType* _tmp367_;
						ValaParameter* _tmp368_;
						ValaParameter* _tmp369_;
						ValaObjectType* _tmp370_;
						ValaObjectTypeSymbol* _tmp371_;
						ValaObjectTypeSymbol* _tmp372_;
						ValaScope* _tmp373_;
						ValaScope* _tmp374_;
						ValaDynamicMethod* _tmp375_;
						ValaDynamicMethod* _tmp376_;
						_tmp328_ = invoc;
						_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
						_tmp330_ = _tmp329_;
						if (_tmp330_ != NULL) {
							ValaMethodCall* _tmp331_;
							ValaDataType* _tmp332_;
							ValaDataType* _tmp333_;
							ValaDataType* _tmp334_;
							ValaDataType* _tmp335_;
							_tmp331_ = invoc;
							_tmp332_ = vala_expression_get_target_type ((ValaExpression*) _tmp331_);
							_tmp333_ = _tmp332_;
							_tmp334_ = vala_data_type_copy (_tmp333_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp334_;
							_tmp335_ = ret_type;
							vala_data_type_set_value_owned (_tmp335_, TRUE);
						} else {
							ValaMethodCall* _tmp336_;
							ValaCodeNode* _tmp337_;
							ValaCodeNode* _tmp338_;
							_tmp336_ = invoc;
							_tmp337_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp336_);
							_tmp338_ = _tmp337_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp338_)) {
								ValaVoidType* _tmp339_;
								_tmp339_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp339_;
							} else {
								ValaExpression* _tmp340_;
								ValaExpression* _tmp341_;
								ValaDataType* _tmp342_;
								ValaDataType* _tmp343_;
								ValaDataType* _tmp344_;
								_tmp340_ = vala_member_access_get_inner (self);
								_tmp341_ = _tmp340_;
								_tmp342_ = vala_expression_get_value_type (_tmp341_);
								_tmp343_ = _tmp342_;
								_tmp344_ = vala_data_type_copy (_tmp343_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp344_;
							}
						}
						_tmp345_ = vala_member_access_get_inner (self);
						_tmp346_ = _tmp345_;
						_tmp347_ = vala_expression_get_value_type (_tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = self->priv->_member_name;
						_tmp350_ = ret_type;
						_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp352_ = _tmp351_;
						_tmp353_ = vala_dynamic_method_new (_tmp348_, _tmp349_, _tmp350_, _tmp352_, NULL);
						m = _tmp353_;
						_tmp354_ = m;
						_tmp355_ = invoc;
						vala_dynamic_method_set_invocation (_tmp354_, _tmp355_);
						_tmp356_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp356_;
						_tmp357_ = err;
						vala_error_type_set_dynamic_error (_tmp357_, TRUE);
						_tmp358_ = m;
						_tmp359_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp358_, (ValaDataType*) _tmp359_);
						_tmp360_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp360_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp361_ = m;
						_tmp362_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp363_ = _tmp362_;
						vala_callable_add_parameter ((ValaCallable*) _tmp361_, _tmp363_);
						_vala_code_node_unref0 (_tmp363_);
						_tmp364_ = m;
						_tmp365_ = dynamic_object_type;
						_tmp366_ = vala_data_type_copy ((ValaDataType*) _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_parameter_new ("this", _tmp367_, NULL);
						_tmp369_ = _tmp368_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp364_, _tmp369_);
						_vala_code_node_unref0 (_tmp369_);
						_vala_code_node_unref0 (_tmp367_);
						_tmp370_ = dynamic_object_type;
						_tmp371_ = vala_object_type_get_type_symbol (_tmp370_);
						_tmp372_ = _tmp371_;
						_tmp373_ = vala_symbol_get_scope ((ValaSymbol*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = m;
						vala_scope_add (_tmp374_, NULL, (ValaSymbol*) _tmp375_);
						_tmp376_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp376_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp377_;
					ValaCodeNode* _tmp378_;
					_tmp377_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp378_ = _tmp377_;
					if (VALA_IS_ASSIGNMENT (_tmp378_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp379_;
						ValaCodeNode* _tmp380_;
						ValaAssignment* _tmp381_;
						ValaAssignment* _tmp382_;
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						_tmp379_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp380_ = _tmp379_;
						_tmp381_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp380_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp381_;
						_tmp382_ = a;
						_tmp383_ = vala_assignment_get_left (_tmp382_);
						_tmp384_ = _tmp383_;
						if (_tmp384_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp385_;
							ValaExpression* _tmp386_;
							ValaDataType* _tmp387_;
							ValaDataType* _tmp388_;
							const gchar* _tmp389_;
							ValaSourceReference* _tmp390_;
							ValaSourceReference* _tmp391_;
							ValaDynamicProperty* _tmp392_;
							ValaDynamicProperty* _tmp393_;
							ValaDynamicProperty* _tmp394_;
							ValaDynamicProperty* _tmp395_;
							ValaSourceReference* _tmp396_;
							ValaSourceReference* _tmp397_;
							ValaPropertyAccessor* _tmp398_;
							ValaPropertyAccessor* _tmp399_;
							ValaDynamicProperty* _tmp400_;
							ValaExpression* _tmp401_;
							ValaExpression* _tmp402_;
							ValaDataType* _tmp403_;
							ValaDataType* _tmp404_;
							ValaTypeSymbol* _tmp405_;
							ValaTypeSymbol* _tmp406_;
							ValaScope* _tmp407_;
							ValaScope* _tmp408_;
							ValaObjectType* _tmp409_;
							ValaObjectTypeSymbol* _tmp410_;
							ValaObjectTypeSymbol* _tmp411_;
							ValaScope* _tmp412_;
							ValaScope* _tmp413_;
							ValaDynamicProperty* _tmp414_;
							ValaDynamicProperty* _tmp415_;
							_tmp385_ = vala_member_access_get_inner (self);
							_tmp386_ = _tmp385_;
							_tmp387_ = vala_expression_get_value_type (_tmp386_);
							_tmp388_ = _tmp387_;
							_tmp389_ = self->priv->_member_name;
							_tmp390_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp391_ = _tmp390_;
							_tmp392_ = vala_dynamic_property_new (_tmp388_, _tmp389_, _tmp391_, NULL);
							prop = _tmp392_;
							_tmp393_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp393_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp394_ = prop;
							_tmp395_ = prop;
							_tmp396_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp395_);
							_tmp397_ = _tmp396_;
							_tmp398_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp397_, NULL);
							_tmp399_ = _tmp398_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp394_, _tmp399_);
							_vala_code_node_unref0 (_tmp399_);
							_tmp400_ = prop;
							_tmp401_ = vala_member_access_get_inner (self);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_expression_get_value_type (_tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = vala_data_type_get_data_type (_tmp404_);
							_tmp406_ = _tmp405_;
							_tmp407_ = vala_symbol_get_scope ((ValaSymbol*) _tmp406_);
							_tmp408_ = _tmp407_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp400_, _tmp408_);
							_tmp409_ = dynamic_object_type;
							_tmp410_ = vala_object_type_get_type_symbol (_tmp409_);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_symbol_get_scope ((ValaSymbol*) _tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = prop;
							vala_scope_add (_tmp413_, NULL, (ValaSymbol*) _tmp414_);
							_tmp415_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp415_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp416_ = FALSE;
						gboolean _tmp417_ = FALSE;
						ValaCodeNode* _tmp418_;
						ValaCodeNode* _tmp419_;
						_tmp418_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp419_ = _tmp418_;
						if (VALA_IS_MEMBER_ACCESS (_tmp419_)) {
							ValaExpression* _tmp420_;
							ValaExpression* _tmp421_;
							_tmp420_ = vala_member_access_get_inner (self);
							_tmp421_ = _tmp420_;
							_tmp417_ = VALA_IS_MEMBER_ACCESS (_tmp421_);
						} else {
							_tmp417_ = FALSE;
						}
						if (_tmp417_) {
							ValaCodeNode* _tmp422_;
							ValaCodeNode* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp422_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp423_ = _tmp422_;
							_tmp424_ = vala_code_node_get_parent_node (_tmp423_);
							_tmp425_ = _tmp424_;
							_tmp416_ = VALA_IS_METHOD_CALL (_tmp425_);
						} else {
							_tmp416_ = FALSE;
						}
						if (_tmp416_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp426_;
							ValaCodeNode* _tmp427_;
							ValaMemberAccess* _tmp428_;
							gboolean _tmp429_ = FALSE;
							ValaMemberAccess* _tmp430_;
							const gchar* _tmp431_;
							_tmp426_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp427_ = _tmp426_;
							_tmp428_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp427_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp428_;
							_tmp430_ = ma;
							_tmp431_ = _tmp430_->priv->_member_name;
							if (g_strcmp0 (_tmp431_, "connect") == 0) {
								_tmp429_ = TRUE;
							} else {
								ValaMemberAccess* _tmp432_;
								const gchar* _tmp433_;
								_tmp432_ = ma;
								_tmp433_ = _tmp432_->priv->_member_name;
								_tmp429_ = g_strcmp0 (_tmp433_, "connect_after") == 0;
							}
							if (_tmp429_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp434_;
								ValaExpression* _tmp435_;
								ValaDataType* _tmp436_;
								ValaDataType* _tmp437_;
								const gchar* _tmp438_;
								ValaVoidType* _tmp439_;
								ValaVoidType* _tmp440_;
								ValaSourceReference* _tmp441_;
								ValaSourceReference* _tmp442_;
								ValaDynamicSignal* _tmp443_;
								ValaDynamicSignal* _tmp444_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp445_;
								ValaCodeNode* _tmp446_;
								ValaCodeNode* _tmp447_;
								ValaCodeNode* _tmp448_;
								ValaMethodCall* _tmp449_;
								ValaMethodCall* _tmp450_;
								ValaList* _tmp451_;
								ValaList* _tmp452_;
								gint _tmp453_;
								gint _tmp454_;
								gboolean _tmp455_;
								ValaDynamicSignal* _tmp462_;
								ValaObjectType* _tmp463_;
								ValaObjectTypeSymbol* _tmp464_;
								ValaObjectTypeSymbol* _tmp465_;
								ValaScope* _tmp466_;
								ValaScope* _tmp467_;
								ValaDynamicSignal* _tmp468_;
								ValaDynamicSignal* _tmp469_;
								_tmp434_ = vala_member_access_get_inner (self);
								_tmp435_ = _tmp434_;
								_tmp436_ = vala_expression_get_value_type (_tmp435_);
								_tmp437_ = _tmp436_;
								_tmp438_ = self->priv->_member_name;
								_tmp439_ = vala_void_type_new (NULL);
								_tmp440_ = _tmp439_;
								_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp442_ = _tmp441_;
								_tmp443_ = vala_dynamic_signal_new (_tmp437_, _tmp438_, (ValaDataType*) _tmp440_, _tmp442_, NULL);
								_tmp444_ = _tmp443_;
								_vala_code_node_unref0 (_tmp440_);
								s = _tmp444_;
								_tmp445_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_code_node_get_parent_node (_tmp446_);
								_tmp448_ = _tmp447_;
								_tmp449_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp448_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp449_;
								_tmp450_ = mcall;
								_tmp451_ = vala_method_call_get_argument_list (_tmp450_);
								_tmp452_ = _tmp451_;
								_tmp453_ = vala_collection_get_size ((ValaCollection*) _tmp452_);
								_tmp454_ = _tmp453_;
								_tmp455_ = _tmp454_ > 0;
								_vala_iterable_unref0 (_tmp452_);
								if (_tmp455_) {
									ValaDynamicSignal* _tmp456_;
									ValaMethodCall* _tmp457_;
									ValaList* _tmp458_;
									ValaList* _tmp459_;
									gpointer _tmp460_;
									ValaExpression* _tmp461_;
									_tmp456_ = s;
									_tmp457_ = mcall;
									_tmp458_ = vala_method_call_get_argument_list (_tmp457_);
									_tmp459_ = _tmp458_;
									_tmp460_ = vala_list_get (_tmp459_, 0);
									_tmp461_ = (ValaExpression*) _tmp460_;
									vala_dynamic_signal_set_handler (_tmp456_, _tmp461_);
									_vala_code_node_unref0 (_tmp461_);
									_vala_iterable_unref0 (_tmp459_);
								}
								_tmp462_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp462_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp463_ = dynamic_object_type;
								_tmp464_ = vala_object_type_get_type_symbol (_tmp463_);
								_tmp465_ = _tmp464_;
								_tmp466_ = vala_symbol_get_scope ((ValaSymbol*) _tmp465_);
								_tmp467_ = _tmp466_;
								_tmp468_ = s;
								vala_scope_add (_tmp467_, NULL, (ValaSymbol*) _tmp468_);
								_tmp469_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp469_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp470_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp471_ = _tmp470_;
				if (_tmp471_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp472_;
					ValaExpression* _tmp473_;
					ValaDataType* _tmp474_;
					ValaDataType* _tmp475_;
					const gchar* _tmp476_;
					ValaSourceReference* _tmp477_;
					ValaSourceReference* _tmp478_;
					ValaDynamicProperty* _tmp479_;
					ValaDataType* _tmp480_;
					ValaDataType* _tmp481_;
					ValaDynamicProperty* _tmp492_;
					ValaDynamicProperty* _tmp493_;
					ValaDynamicProperty* _tmp494_;
					ValaDataType* _tmp495_;
					ValaDataType* _tmp496_;
					ValaDataType* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDynamicProperty* _tmp499_;
					ValaSourceReference* _tmp500_;
					ValaSourceReference* _tmp501_;
					ValaPropertyAccessor* _tmp502_;
					ValaPropertyAccessor* _tmp503_;
					ValaDynamicProperty* _tmp504_;
					ValaExpression* _tmp505_;
					ValaExpression* _tmp506_;
					ValaDataType* _tmp507_;
					ValaDataType* _tmp508_;
					ValaTypeSymbol* _tmp509_;
					ValaTypeSymbol* _tmp510_;
					ValaScope* _tmp511_;
					ValaScope* _tmp512_;
					ValaObjectType* _tmp513_;
					ValaObjectTypeSymbol* _tmp514_;
					ValaObjectTypeSymbol* _tmp515_;
					ValaScope* _tmp516_;
					ValaScope* _tmp517_;
					ValaDynamicProperty* _tmp518_;
					ValaDynamicProperty* _tmp519_;
					_tmp472_ = vala_member_access_get_inner (self);
					_tmp473_ = _tmp472_;
					_tmp474_ = vala_expression_get_value_type (_tmp473_);
					_tmp475_ = _tmp474_;
					_tmp476_ = self->priv->_member_name;
					_tmp477_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp478_ = _tmp477_;
					_tmp479_ = vala_dynamic_property_new (_tmp475_, _tmp476_, _tmp478_, NULL);
					prop = _tmp479_;
					_tmp480_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp481_ = _tmp480_;
					if (_tmp481_ != NULL) {
						ValaDynamicProperty* _tmp482_;
						ValaDataType* _tmp483_;
						ValaDataType* _tmp484_;
						_tmp482_ = prop;
						_tmp483_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp484_ = _tmp483_;
						vala_property_set_property_type ((ValaProperty*) _tmp482_, _tmp484_);
					} else {
						ValaDynamicProperty* _tmp485_;
						ValaExpression* _tmp486_;
						ValaExpression* _tmp487_;
						ValaDataType* _tmp488_;
						ValaDataType* _tmp489_;
						ValaDataType* _tmp490_;
						ValaDataType* _tmp491_;
						_tmp485_ = prop;
						_tmp486_ = vala_member_access_get_inner (self);
						_tmp487_ = _tmp486_;
						_tmp488_ = vala_expression_get_value_type (_tmp487_);
						_tmp489_ = _tmp488_;
						_tmp490_ = vala_data_type_copy (_tmp489_);
						_tmp491_ = _tmp490_;
						vala_property_set_property_type ((ValaProperty*) _tmp485_, _tmp491_);
						_vala_code_node_unref0 (_tmp491_);
					}
					_tmp492_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp492_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp493_ = prop;
					_tmp494_ = prop;
					_tmp495_ = vala_property_get_property_type ((ValaProperty*) _tmp494_);
					_tmp496_ = _tmp495_;
					_tmp497_ = vala_data_type_copy (_tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = prop;
					_tmp500_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp498_, NULL, _tmp501_, NULL);
					_tmp503_ = _tmp502_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp493_, _tmp503_);
					_vala_code_node_unref0 (_tmp503_);
					_vala_code_node_unref0 (_tmp498_);
					_tmp504_ = prop;
					_tmp505_ = vala_member_access_get_inner (self);
					_tmp506_ = _tmp505_;
					_tmp507_ = vala_expression_get_value_type (_tmp506_);
					_tmp508_ = _tmp507_;
					_tmp509_ = vala_data_type_get_data_type (_tmp508_);
					_tmp510_ = _tmp509_;
					_tmp511_ = vala_symbol_get_scope ((ValaSymbol*) _tmp510_);
					_tmp512_ = _tmp511_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp504_, _tmp512_);
					_tmp513_ = dynamic_object_type;
					_tmp514_ = vala_object_type_get_type_symbol (_tmp513_);
					_tmp515_ = _tmp514_;
					_tmp516_ = vala_symbol_get_scope ((ValaSymbol*) _tmp515_);
					_tmp517_ = _tmp516_;
					_tmp518_ = prop;
					vala_scope_add (_tmp517_, NULL, (ValaSymbol*) _tmp518_);
					_tmp519_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp519_);
					_vala_code_node_unref0 (prop);
				}
				_tmp520_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp521_ = _tmp520_;
				if (_tmp521_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp523_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp524_ = _tmp523_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp524_)) {
				ValaExpression* _tmp525_;
				ValaExpression* _tmp526_;
				ValaDataType* _tmp527_;
				ValaDataType* _tmp528_;
				_tmp525_ = vala_member_access_get_inner (self);
				_tmp526_ = _tmp525_;
				_tmp527_ = vala_expression_get_value_type (_tmp526_);
				_tmp528_ = _tmp527_;
				_tmp522_ = VALA_IS_ARRAY_TYPE (_tmp528_);
			} else {
				_tmp522_ = FALSE;
			}
			if (_tmp522_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp529_;
				ValaExpression* _tmp530_;
				ValaDataType* _tmp531_;
				ValaDataType* _tmp532_;
				gboolean _tmp533_ = FALSE;
				ValaArrayType* _tmp534_;
				_tmp529_ = vala_member_access_get_inner (self);
				_tmp530_ = _tmp529_;
				_tmp531_ = vala_expression_get_value_type (_tmp530_);
				_tmp532_ = _tmp531_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp532_) ? ((ValaArrayType*) _tmp532_) : NULL;
				_tmp534_ = value_array_type;
				if (_tmp534_ != NULL) {
					ValaArrayType* _tmp535_;
					gboolean _tmp536_;
					gboolean _tmp537_;
					_tmp535_ = value_array_type;
					_tmp536_ = vala_array_type_get_inline_allocated (_tmp535_);
					_tmp537_ = _tmp536_;
					_tmp533_ = _tmp537_;
				} else {
					_tmp533_ = FALSE;
				}
				if (_tmp533_) {
					ValaSourceReference* _tmp538_;
					ValaSourceReference* _tmp539_;
					_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp539_ = _tmp538_;
					vala_report_error (_tmp539_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp543_ = vala_member_access_get_inner (self);
	_tmp544_ = _tmp543_;
	if (_tmp544_ == NULL) {
		ValaSymbol* _tmp545_;
		ValaSymbol* _tmp546_;
		_tmp545_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp546_ = _tmp545_;
		_tmp542_ = _tmp546_ == NULL;
	} else {
		_tmp542_ = FALSE;
	}
	if (_tmp542_) {
		ValaDataType* _tmp547_;
		ValaDataType* _tmp548_;
		_tmp547_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp548_ = _tmp547_;
		_tmp541_ = _tmp548_ != NULL;
	} else {
		_tmp541_ = FALSE;
	}
	if (_tmp541_) {
		ValaDataType* _tmp549_;
		ValaDataType* _tmp550_;
		ValaTypeSymbol* _tmp551_;
		ValaTypeSymbol* _tmp552_;
		_tmp549_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp550_ = _tmp549_;
		_tmp551_ = vala_data_type_get_data_type (_tmp550_);
		_tmp552_ = _tmp551_;
		_tmp540_ = VALA_IS_ENUM (_tmp552_);
	} else {
		_tmp540_ = FALSE;
	}
	if (_tmp540_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp553_;
		ValaDataType* _tmp554_;
		ValaTypeSymbol* _tmp555_;
		ValaTypeSymbol* _tmp556_;
		ValaEnum* _tmp557_;
		_tmp553_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp554_ = _tmp553_;
		_tmp555_ = vala_data_type_get_data_type (_tmp554_);
		_tmp556_ = _tmp555_;
		_tmp557_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp556_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp557_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp558_;
			ValaList* _tmp559_;
			gint _val_size = 0;
			ValaList* _tmp560_;
			gint _tmp561_;
			gint _tmp562_;
			gint _val_index = 0;
			_tmp558_ = enum_type;
			_tmp559_ = vala_enum_get_values (_tmp558_);
			_val_list = _tmp559_;
			_tmp560_ = _val_list;
			_tmp561_ = vala_collection_get_size ((ValaCollection*) _tmp560_);
			_tmp562_ = _tmp561_;
			_val_size = _tmp562_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp563_;
				gpointer _tmp564_;
				const gchar* _tmp565_;
				ValaEnumValue* _tmp566_;
				const gchar* _tmp567_;
				const gchar* _tmp568_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp563_ = _val_list;
				_tmp564_ = vala_list_get (_tmp563_, _val_index);
				val = (ValaEnumValue*) _tmp564_;
				_tmp565_ = self->priv->_member_name;
				_tmp566_ = val;
				_tmp567_ = vala_symbol_get_name ((ValaSymbol*) _tmp566_);
				_tmp568_ = _tmp567_;
				if (g_strcmp0 (_tmp565_, _tmp568_) == 0) {
					ValaEnumValue* _tmp569_;
					_tmp569_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp569_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp570_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp571_ = _tmp570_;
	if (_tmp571_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp572_;
		gboolean _tmp573_ = FALSE;
		ValaExpression* _tmp574_;
		ValaExpression* _tmp575_;
		ValaSourceReference* _tmp588_;
		ValaSourceReference* _tmp589_;
		const gchar* _tmp590_;
		const gchar* _tmp591_;
		gchar* _tmp592_;
		gchar* _tmp593_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp572_ = g_strdup ("(null)");
		base_type_name = _tmp572_;
		_tmp574_ = vala_member_access_get_inner (self);
		_tmp575_ = _tmp574_;
		if (_tmp575_ != NULL) {
			ValaExpression* _tmp576_;
			ValaExpression* _tmp577_;
			ValaDataType* _tmp578_;
			ValaDataType* _tmp579_;
			_tmp576_ = vala_member_access_get_inner (self);
			_tmp577_ = _tmp576_;
			_tmp578_ = vala_expression_get_value_type (_tmp577_);
			_tmp579_ = _tmp578_;
			_tmp573_ = _tmp579_ != NULL;
		} else {
			_tmp573_ = FALSE;
		}
		if (_tmp573_) {
			ValaExpression* _tmp580_;
			ValaExpression* _tmp581_;
			ValaDataType* _tmp582_;
			ValaDataType* _tmp583_;
			gchar* _tmp584_;
			_tmp580_ = vala_member_access_get_inner (self);
			_tmp581_ = _tmp580_;
			_tmp582_ = vala_expression_get_value_type (_tmp581_);
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_code_node_to_string ((ValaCodeNode*) _tmp583_);
			_g_free0 (base_type_name);
			base_type_name = _tmp584_;
		} else {
			ValaSymbol* _tmp585_;
			_tmp585_ = base_symbol;
			if (_tmp585_ != NULL) {
				ValaSymbol* _tmp586_;
				gchar* _tmp587_;
				_tmp586_ = base_symbol;
				_tmp587_ = vala_symbol_get_full_name (_tmp586_);
				_g_free0 (base_type_name);
				base_type_name = _tmp587_;
			}
		}
		_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp589_ = _tmp588_;
		_tmp590_ = self->priv->_member_name;
		_tmp591_ = base_type_name;
		_tmp592_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp590_, _tmp591_);
		_tmp593_ = _tmp592_;
		vala_report_error (_tmp589_, _tmp593_);
		_g_free0 (_tmp593_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp594_;
		ValaSymbol* _tmp595_;
		gboolean _tmp596_;
		gboolean _tmp597_;
		_tmp594_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp595_ = _tmp594_;
		_tmp596_ = vala_code_node_get_error ((ValaCodeNode*) _tmp595_);
		_tmp597_ = _tmp596_;
		if (_tmp597_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp598_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp599_ = _tmp598_;
	_tmp600_ = _vala_code_node_ref0 (_tmp599_);
	member = _tmp600_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp601_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp601_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp602_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp602_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp603_;
		ValaLocalVariable* _tmp604_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp605_;
		ValaSymbol* _tmp606_;
		ValaSymbol* _tmp607_;
		ValaBlock* _tmp608_;
		gboolean _tmp609_ = FALSE;
		ValaBlock* _tmp610_;
		_tmp603_ = member;
		_tmp604_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp603_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp604_;
		_tmp605_ = local;
		_tmp606_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp605_);
		_tmp607_ = _tmp606_;
		_tmp608_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp607_) ? ((ValaBlock*) _tmp607_) : NULL);
		block = _tmp608_;
		_tmp610_ = block;
		if (_tmp610_ != NULL) {
			ValaSemanticAnalyzer* _tmp611_;
			ValaSemanticAnalyzer* _tmp612_;
			ValaBlock* _tmp613_;
			ValaSymbol* _tmp614_;
			ValaSymbol* _tmp615_;
			ValaSemanticAnalyzer* _tmp616_;
			ValaSemanticAnalyzer* _tmp617_;
			ValaSymbol* _tmp618_;
			ValaSymbol* _tmp619_;
			_tmp611_ = vala_code_context_get_analyzer (context);
			_tmp612_ = _tmp611_;
			_tmp613_ = block;
			_tmp614_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp612_, (ValaSymbol*) _tmp613_);
			_tmp615_ = _tmp614_;
			_tmp616_ = vala_code_context_get_analyzer (context);
			_tmp617_ = _tmp616_;
			_tmp618_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp617_);
			_tmp619_ = _tmp618_;
			_tmp609_ = _tmp615_ != _tmp619_;
			_vala_code_node_unref0 (_tmp615_);
		} else {
			_tmp609_ = FALSE;
		}
		if (_tmp609_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp620_;
			ValaSemanticAnalyzer* _tmp621_;
			ValaSymbol* _tmp622_;
			ValaSymbol* _tmp623_;
			ValaSymbol* _tmp624_;
			ValaLocalVariable* _tmp637_;
			ValaBlock* _tmp638_;
			_tmp620_ = vala_code_context_get_analyzer (context);
			_tmp621_ = _tmp620_;
			_tmp622_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp621_);
			_tmp623_ = _tmp622_;
			_tmp624_ = _vala_code_node_ref0 (_tmp623_);
			sym = _tmp624_;
			while (TRUE) {
				ValaSymbol* _tmp625_;
				ValaBlock* _tmp626_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp627_;
				ValaMethod* _tmp628_;
				ValaMethod* _tmp629_;
				ValaSymbol* _tmp633_;
				ValaSymbol* _tmp634_;
				ValaSymbol* _tmp635_;
				ValaSymbol* _tmp636_;
				_tmp625_ = sym;
				_tmp626_ = block;
				if (!(_tmp625_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp626_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp627_ = sym;
				_tmp628_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp627_) ? ((ValaMethod*) _tmp627_) : NULL);
				method = _tmp628_;
				_tmp629_ = method;
				if (_tmp629_ != NULL) {
					ValaMethod* _tmp630_;
					ValaMethod* _tmp631_;
					ValaLocalVariable* _tmp632_;
					_tmp630_ = method;
					vala_method_set_closure (_tmp630_, TRUE);
					_tmp631_ = method;
					_tmp632_ = local;
					vala_method_add_captured_variable (_tmp631_, _tmp632_);
				}
				_tmp633_ = sym;
				_tmp634_ = vala_symbol_get_parent_symbol (_tmp633_);
				_tmp635_ = _tmp634_;
				_tmp636_ = _vala_code_node_ref0 (_tmp635_);
				_vala_code_node_unref0 (sym);
				sym = _tmp636_;
				_vala_code_node_unref0 (method);
			}
			_tmp637_ = local;
			vala_local_variable_set_captured (_tmp637_, TRUE);
			_tmp638_ = block;
			vala_block_set_captured (_tmp638_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp639_;
		_tmp639_ = member;
		if (VALA_IS_PARAMETER (_tmp639_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp640_;
			ValaParameter* _tmp641_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp642_;
			ValaSymbol* _tmp643_;
			ValaSymbol* _tmp644_;
			ValaMethod* _tmp645_;
			gboolean _tmp646_ = FALSE;
			gboolean _tmp647_ = FALSE;
			ValaMethod* _tmp648_;
			_tmp640_ = member;
			_tmp641_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp640_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp641_;
			_tmp642_ = param;
			_tmp643_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp642_);
			_tmp644_ = _tmp643_;
			_tmp645_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp644_) ? ((ValaMethod*) _tmp644_) : NULL);
			m = _tmp645_;
			_tmp648_ = m;
			if (_tmp648_ != NULL) {
				ValaMethod* _tmp649_;
				ValaSemanticAnalyzer* _tmp650_;
				ValaSemanticAnalyzer* _tmp651_;
				ValaSymbol* _tmp652_;
				ValaSymbol* _tmp653_;
				_tmp649_ = m;
				_tmp650_ = vala_code_context_get_analyzer (context);
				_tmp651_ = _tmp650_;
				_tmp652_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp651_);
				_tmp653_ = _tmp652_;
				_tmp647_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp649_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp653_;
			} else {
				_tmp647_ = FALSE;
			}
			if (_tmp647_) {
				ValaParameter* _tmp654_;
				ValaMethod* _tmp655_;
				ValaParameter* _tmp656_;
				ValaParameter* _tmp657_;
				_tmp654_ = param;
				_tmp655_ = m;
				_tmp656_ = vala_method_get_this_parameter (_tmp655_);
				_tmp657_ = _tmp656_;
				_tmp646_ = _tmp654_ != _tmp657_;
			} else {
				_tmp646_ = FALSE;
			}
			if (_tmp646_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp658_;
				ValaSemanticAnalyzer* _tmp659_;
				ValaSymbol* _tmp660_;
				ValaSymbol* _tmp661_;
				ValaSymbol* _tmp662_;
				ValaParameter* _tmp673_;
				ValaMethod* _tmp674_;
				ValaBlock* _tmp675_;
				ValaBlock* _tmp676_;
				ValaParameter* _tmp677_;
				ValaParameterDirection _tmp678_;
				ValaParameterDirection _tmp679_;
				_tmp658_ = vala_code_context_get_analyzer (context);
				_tmp659_ = _tmp658_;
				_tmp660_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp659_);
				_tmp661_ = _tmp660_;
				_tmp662_ = _vala_code_node_ref0 (_tmp661_);
				sym = _tmp662_;
				while (TRUE) {
					ValaSymbol* _tmp663_;
					ValaMethod* _tmp664_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp665_;
					ValaMethod* _tmp666_;
					ValaMethod* _tmp667_;
					ValaSymbol* _tmp669_;
					ValaSymbol* _tmp670_;
					ValaSymbol* _tmp671_;
					ValaSymbol* _tmp672_;
					_tmp663_ = sym;
					_tmp664_ = m;
					if (!(_tmp663_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp664_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp665_ = sym;
					_tmp666_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp665_) ? ((ValaMethod*) _tmp665_) : NULL);
					method = _tmp666_;
					_tmp667_ = method;
					if (_tmp667_ != NULL) {
						ValaMethod* _tmp668_;
						_tmp668_ = method;
						vala_method_set_closure (_tmp668_, TRUE);
					}
					_tmp669_ = sym;
					_tmp670_ = vala_symbol_get_parent_symbol (_tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = _vala_code_node_ref0 (_tmp671_);
					_vala_code_node_unref0 (sym);
					sym = _tmp672_;
					_vala_code_node_unref0 (method);
				}
				_tmp673_ = param;
				vala_parameter_set_captured (_tmp673_, TRUE);
				_tmp674_ = m;
				_tmp675_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp674_);
				_tmp676_ = _tmp675_;
				vala_block_set_captured (_tmp676_, TRUE);
				_tmp677_ = param;
				_tmp678_ = vala_parameter_get_direction (_tmp677_);
				_tmp679_ = _tmp678_;
				if (_tmp679_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp680_;
					ValaSourceReference* _tmp681_;
					ValaParameter* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					gchar* _tmp685_;
					gchar* _tmp686_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp680_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp681_ = _tmp680_;
					_tmp682_ = param;
					_tmp683_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp682_);
					_tmp684_ = _tmp683_;
					_tmp685_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp684_);
					_tmp686_ = _tmp685_;
					vala_report_error (_tmp681_, _tmp686_);
					_g_free0 (_tmp686_);
					_g_free0 (_tmp684_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp687_;
				ValaSymbol* _tmp688_;
				ValaSymbol* _tmp689_;
				ValaSymbol* _tmp690_;
				ValaSymbol* _tmp691_;
				ValaPropertyAccessor* _tmp692_;
				gboolean _tmp693_ = FALSE;
				gboolean _tmp694_ = FALSE;
				ValaPropertyAccessor* _tmp695_;
				_tmp687_ = param;
				_tmp688_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp687_);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_symbol_get_parent_symbol (_tmp689_);
				_tmp691_ = _tmp690_;
				_tmp692_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp691_) ? ((ValaPropertyAccessor*) _tmp691_) : NULL);
				acc = _tmp692_;
				_tmp695_ = acc;
				if (_tmp695_ != NULL) {
					ValaPropertyAccessor* _tmp696_;
					ValaSemanticAnalyzer* _tmp697_;
					ValaSemanticAnalyzer* _tmp698_;
					ValaSymbol* _tmp699_;
					ValaSymbol* _tmp700_;
					_tmp696_ = acc;
					_tmp697_ = vala_code_context_get_analyzer (context);
					_tmp698_ = _tmp697_;
					_tmp699_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp698_);
					_tmp700_ = _tmp699_;
					_tmp694_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp700_;
				} else {
					_tmp694_ = FALSE;
				}
				if (_tmp694_) {
					ValaParameter* _tmp701_;
					ValaPropertyAccessor* _tmp702_;
					ValaProperty* _tmp703_;
					ValaProperty* _tmp704_;
					ValaParameter* _tmp705_;
					ValaParameter* _tmp706_;
					_tmp701_ = param;
					_tmp702_ = acc;
					_tmp703_ = vala_property_accessor_get_prop (_tmp702_);
					_tmp704_ = _tmp703_;
					_tmp705_ = vala_property_get_this_parameter (_tmp704_);
					_tmp706_ = _tmp705_;
					_tmp693_ = _tmp701_ != _tmp706_;
				} else {
					_tmp693_ = FALSE;
				}
				if (_tmp693_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp707_;
					ValaSemanticAnalyzer* _tmp708_;
					ValaSymbol* _tmp709_;
					ValaSymbol* _tmp710_;
					ValaSymbol* _tmp711_;
					ValaParameter* _tmp722_;
					ValaPropertyAccessor* _tmp723_;
					ValaBlock* _tmp724_;
					ValaBlock* _tmp725_;
					_tmp707_ = vala_code_context_get_analyzer (context);
					_tmp708_ = _tmp707_;
					_tmp709_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp708_);
					_tmp710_ = _tmp709_;
					_tmp711_ = _vala_code_node_ref0 (_tmp710_);
					sym = _tmp711_;
					while (TRUE) {
						ValaSymbol* _tmp712_;
						ValaMethod* _tmp713_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp714_;
						ValaMethod* _tmp715_;
						ValaMethod* _tmp716_;
						ValaSymbol* _tmp718_;
						ValaSymbol* _tmp719_;
						ValaSymbol* _tmp720_;
						ValaSymbol* _tmp721_;
						_tmp712_ = sym;
						_tmp713_ = m;
						if (!(_tmp712_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp713_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp714_ = sym;
						_tmp715_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp714_) ? ((ValaMethod*) _tmp714_) : NULL);
						method = _tmp715_;
						_tmp716_ = method;
						if (_tmp716_ != NULL) {
							ValaMethod* _tmp717_;
							_tmp717_ = method;
							vala_method_set_closure (_tmp717_, TRUE);
						}
						_tmp718_ = sym;
						_tmp719_ = vala_symbol_get_parent_symbol (_tmp718_);
						_tmp720_ = _tmp719_;
						_tmp721_ = _vala_code_node_ref0 (_tmp720_);
						_vala_code_node_unref0 (sym);
						sym = _tmp721_;
						_vala_code_node_unref0 (method);
					}
					_tmp722_ = param;
					vala_parameter_set_captured (_tmp722_, TRUE);
					_tmp723_ = acc;
					_tmp724_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp723_);
					_tmp725_ = _tmp724_;
					vala_block_set_captured (_tmp725_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp726_;
			_tmp726_ = member;
			if (VALA_IS_FIELD (_tmp726_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp727_;
				ValaField* _tmp728_;
				ValaField* _tmp729_;
				ValaSymbolAccessibility _tmp730_;
				ValaSymbolAccessibility _tmp731_;
				ValaField* _tmp732_;
				ValaMemberBinding _tmp733_;
				ValaMemberBinding _tmp734_;
				ValaField* _tmp735_;
				ValaMemberBinding _tmp736_;
				ValaMemberBinding _tmp737_;
				ValaField* _tmp738_;
				ValaDataType* _tmp739_;
				ValaDataType* _tmp740_;
				_tmp727_ = member;
				_tmp728_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp727_, VALA_TYPE_FIELD, ValaField));
				f = _tmp728_;
				_tmp729_ = f;
				_tmp730_ = vala_symbol_get_access ((ValaSymbol*) _tmp729_);
				_tmp731_ = _tmp730_;
				access = _tmp731_;
				_tmp732_ = f;
				_tmp733_ = vala_field_get_binding (_tmp732_);
				_tmp734_ = _tmp733_;
				instance = _tmp734_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp735_ = f;
				_tmp736_ = vala_field_get_binding (_tmp735_);
				_tmp737_ = _tmp736_;
				klass = _tmp737_ == VALA_MEMBER_BINDING_CLASS;
				_tmp738_ = f;
				_tmp739_ = vala_variable_get_variable_type ((ValaVariable*) _tmp738_);
				_tmp740_ = _tmp739_;
				if (VALA_IS_GENERIC_TYPE (_tmp740_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp741_;
				_tmp741_ = member;
				if (VALA_IS_CONSTANT (_tmp741_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp742_;
					ValaConstant* _tmp743_;
					ValaConstant* _tmp744_;
					ValaSymbolAccessibility _tmp745_;
					ValaSymbolAccessibility _tmp746_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp747_;
					ValaSymbol* _tmp748_;
					ValaSymbol* _tmp749_;
					ValaBlock* _tmp750_;
					gboolean _tmp751_ = FALSE;
					ValaBlock* _tmp752_;
					_tmp742_ = member;
					_tmp743_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp742_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp743_;
					_tmp744_ = c;
					_tmp745_ = vala_symbol_get_access ((ValaSymbol*) _tmp744_);
					_tmp746_ = _tmp745_;
					access = _tmp746_;
					_tmp747_ = c;
					_tmp748_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp747_);
					_tmp749_ = _tmp748_;
					_tmp750_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp749_) ? ((ValaBlock*) _tmp749_) : NULL);
					block = _tmp750_;
					_tmp752_ = block;
					if (_tmp752_ != NULL) {
						ValaSemanticAnalyzer* _tmp753_;
						ValaSemanticAnalyzer* _tmp754_;
						ValaBlock* _tmp755_;
						ValaSymbol* _tmp756_;
						ValaSymbol* _tmp757_;
						ValaSemanticAnalyzer* _tmp758_;
						ValaSemanticAnalyzer* _tmp759_;
						ValaSymbol* _tmp760_;
						ValaSymbol* _tmp761_;
						_tmp753_ = vala_code_context_get_analyzer (context);
						_tmp754_ = _tmp753_;
						_tmp755_ = block;
						_tmp756_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp754_, (ValaSymbol*) _tmp755_);
						_tmp757_ = _tmp756_;
						_tmp758_ = vala_code_context_get_analyzer (context);
						_tmp759_ = _tmp758_;
						_tmp760_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp759_);
						_tmp761_ = _tmp760_;
						_tmp751_ = _tmp757_ != _tmp761_;
						_vala_code_node_unref0 (_tmp757_);
					} else {
						_tmp751_ = FALSE;
					}
					if (_tmp751_) {
						ValaSourceReference* _tmp762_;
						ValaSourceReference* _tmp763_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp762_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp763_ = _tmp762_;
						vala_report_error (_tmp763_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp764_;
					_tmp764_ = member;
					if (VALA_IS_METHOD (_tmp764_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp765_;
						ValaMethod* _tmp766_;
						ValaMethod* _tmp767_;
						gboolean _tmp768_;
						gboolean _tmp769_;
						ValaMethod* _tmp871_;
						ValaSymbolAccessibility _tmp872_;
						ValaSymbolAccessibility _tmp873_;
						ValaMethod* _tmp874_;
						ValaMethod* _tmp878_;
						ValaMemberBinding _tmp879_;
						ValaMemberBinding _tmp880_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp899_;
						ValaDataType* _tmp900_;
						ValaDataType* _tmp901_;
						ValaGenericType* _tmp902_;
						gboolean _tmp903_ = FALSE;
						ValaGenericType* _tmp904_;
						_tmp765_ = member;
						_tmp766_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp765_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp766_;
						_tmp767_ = m;
						_tmp768_ = vala_method_get_is_async_callback (_tmp767_);
						_tmp769_ = _tmp768_;
						if (_tmp769_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp770_;
							ValaSemanticAnalyzer* _tmp771_;
							ValaMethod* _tmp772_;
							ValaMethod* _tmp773_;
							ValaMethod* _tmp774_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp775_;
							ValaMethod* _tmp808_;
							ValaSemanticAnalyzer* _tmp809_;
							ValaSemanticAnalyzer* _tmp810_;
							ValaMethod* _tmp811_;
							ValaMethod* _tmp812_;
							ValaMethod* _tmp831_;
							ValaMethod* _tmp832_;
							ValaMethod* _tmp833_;
							ValaSymbol* _tmp834_;
							ValaSymbol* _tmp835_;
							ValaSymbol* _tmp836_;
							_tmp770_ = vala_code_context_get_analyzer (context);
							_tmp771_ = _tmp770_;
							_tmp772_ = vala_semantic_analyzer_get_current_async_method (_tmp771_);
							_tmp773_ = _tmp772_;
							_tmp774_ = _vala_code_node_ref0 (_tmp773_);
							async_method = _tmp774_;
							is_valid_access = FALSE;
							_tmp775_ = async_method;
							if (_tmp775_ != NULL) {
								ValaMethod* _tmp776_;
								ValaMethod* _tmp777_;
								ValaMethod* _tmp778_;
								ValaMethod* _tmp779_;
								gboolean _tmp780_;
								_tmp776_ = m;
								_tmp777_ = async_method;
								_tmp778_ = vala_method_get_callback_method (_tmp777_);
								_tmp779_ = _tmp778_;
								_tmp780_ = _tmp776_ == _tmp779_;
								_vala_code_node_unref0 (_tmp779_);
								if (_tmp780_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp781_ = FALSE;
									ValaMethod* _tmp782_;
									ValaMethod* _tmp783_;
									ValaMethod* _tmp784_;
									_tmp782_ = async_method;
									_tmp783_ = vala_method_get_base_method (_tmp782_);
									_tmp784_ = _tmp783_;
									if (_tmp784_ != NULL) {
										ValaMethod* _tmp785_;
										ValaMethod* _tmp786_;
										ValaMethod* _tmp787_;
										ValaMethod* _tmp788_;
										ValaMethod* _tmp789_;
										ValaMethod* _tmp790_;
										_tmp785_ = m;
										_tmp786_ = async_method;
										_tmp787_ = vala_method_get_base_method (_tmp786_);
										_tmp788_ = _tmp787_;
										_tmp789_ = vala_method_get_callback_method (_tmp788_);
										_tmp790_ = _tmp789_;
										_tmp781_ = _tmp785_ == _tmp790_;
										_vala_code_node_unref0 (_tmp790_);
									} else {
										_tmp781_ = FALSE;
									}
									if (_tmp781_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp791_ = FALSE;
										ValaMethod* _tmp792_;
										ValaMethod* _tmp793_;
										ValaMethod* _tmp794_;
										_tmp792_ = async_method;
										_tmp793_ = vala_method_get_base_interface_method (_tmp792_);
										_tmp794_ = _tmp793_;
										if (_tmp794_ != NULL) {
											ValaMethod* _tmp795_;
											ValaMethod* _tmp796_;
											ValaMethod* _tmp797_;
											ValaMethod* _tmp798_;
											ValaMethod* _tmp799_;
											ValaMethod* _tmp800_;
											_tmp795_ = m;
											_tmp796_ = async_method;
											_tmp797_ = vala_method_get_base_interface_method (_tmp796_);
											_tmp798_ = _tmp797_;
											_tmp799_ = vala_method_get_callback_method (_tmp798_);
											_tmp800_ = _tmp799_;
											_tmp791_ = _tmp795_ == _tmp800_;
											_vala_code_node_unref0 (_tmp800_);
										} else {
											_tmp791_ = FALSE;
										}
										if (_tmp791_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp801_;
								ValaSourceReference* _tmp802_;
								ValaMethod* _tmp803_;
								gchar* _tmp804_;
								gchar* _tmp805_;
								gchar* _tmp806_;
								gchar* _tmp807_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp801_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp802_ = _tmp801_;
								_tmp803_ = m;
								_tmp804_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp803_);
								_tmp805_ = _tmp804_;
								_tmp806_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp805_);
								_tmp807_ = _tmp806_;
								vala_report_error (_tmp802_, _tmp807_);
								_g_free0 (_tmp807_);
								_g_free0 (_tmp805_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp808_ = async_method;
							_tmp809_ = vala_code_context_get_analyzer (context);
							_tmp810_ = _tmp809_;
							_tmp811_ = vala_semantic_analyzer_get_current_method (_tmp810_);
							_tmp812_ = _tmp811_;
							if (_tmp808_ != _tmp812_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp813_;
								ValaSemanticAnalyzer* _tmp814_;
								ValaMethod* _tmp815_;
								ValaMethod* _tmp816_;
								ValaSymbol* _tmp817_;
								ValaMethod* _tmp828_;
								ValaBlock* _tmp829_;
								ValaBlock* _tmp830_;
								_tmp813_ = vala_code_context_get_analyzer (context);
								_tmp814_ = _tmp813_;
								_tmp815_ = vala_semantic_analyzer_get_current_method (_tmp814_);
								_tmp816_ = _tmp815_;
								_tmp817_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp816_);
								sym = _tmp817_;
								while (TRUE) {
									ValaSymbol* _tmp818_;
									ValaMethod* _tmp819_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp820_;
									ValaMethod* _tmp821_;
									ValaMethod* _tmp822_;
									ValaSymbol* _tmp824_;
									ValaSymbol* _tmp825_;
									ValaSymbol* _tmp826_;
									ValaSymbol* _tmp827_;
									_tmp818_ = sym;
									_tmp819_ = async_method;
									if (!(_tmp818_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp819_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp820_ = sym;
									_tmp821_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp820_) ? ((ValaMethod*) _tmp820_) : NULL);
									method = _tmp821_;
									_tmp822_ = method;
									if (_tmp822_ != NULL) {
										ValaMethod* _tmp823_;
										_tmp823_ = method;
										vala_method_set_closure (_tmp823_, TRUE);
									}
									_tmp824_ = sym;
									_tmp825_ = vala_symbol_get_parent_symbol (_tmp824_);
									_tmp826_ = _tmp825_;
									_tmp827_ = _vala_code_node_ref0 (_tmp826_);
									_vala_code_node_unref0 (sym);
									sym = _tmp827_;
									_vala_code_node_unref0 (method);
								}
								_tmp828_ = async_method;
								_tmp829_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp828_);
								_tmp830_ = _tmp829_;
								vala_block_set_captured (_tmp830_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp831_ = async_method;
							_tmp832_ = vala_method_get_callback_method (_tmp831_);
							_vala_code_node_unref0 (m);
							m = _tmp832_;
							_tmp833_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp833_);
							_tmp834_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp835_ = _tmp834_;
							_tmp836_ = _vala_code_node_ref0 (_tmp835_);
							_vala_code_node_unref0 (member);
							member = _tmp836_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp837_;
							ValaMethod* _tmp838_;
							ValaMethod* _tmp839_;
							_tmp837_ = m;
							_tmp838_ = vala_method_get_base_method (_tmp837_);
							_tmp839_ = _tmp838_;
							if (_tmp839_ != NULL) {
								ValaMethod* _tmp840_;
								ValaMethod* _tmp841_;
								ValaMethod* _tmp842_;
								ValaMethod* _tmp843_;
								ValaMethod* _tmp844_;
								ValaSignal* _tmp845_;
								ValaSignal* _tmp846_;
								ValaSymbol* _tmp851_;
								ValaSymbol* _tmp852_;
								ValaSymbol* _tmp853_;
								_tmp840_ = m;
								_tmp841_ = vala_method_get_base_method (_tmp840_);
								_tmp842_ = _tmp841_;
								_tmp843_ = _vala_code_node_ref0 (_tmp842_);
								_vala_code_node_unref0 (m);
								m = _tmp843_;
								_tmp844_ = m;
								_tmp845_ = vala_method_get_signal_reference (_tmp844_);
								_tmp846_ = _tmp845_;
								if (_tmp846_ != NULL) {
									ValaMethod* _tmp847_;
									ValaSignal* _tmp848_;
									ValaSignal* _tmp849_;
									_tmp847_ = m;
									_tmp848_ = vala_method_get_signal_reference (_tmp847_);
									_tmp849_ = _tmp848_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp849_);
								} else {
									ValaMethod* _tmp850_;
									_tmp850_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp850_);
								}
								_tmp851_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp852_ = _tmp851_;
								_tmp853_ = _vala_code_node_ref0 (_tmp852_);
								_vala_code_node_unref0 (member);
								member = _tmp853_;
							} else {
								ValaMethod* _tmp854_;
								ValaMethod* _tmp855_;
								ValaMethod* _tmp856_;
								_tmp854_ = m;
								_tmp855_ = vala_method_get_base_interface_method (_tmp854_);
								_tmp856_ = _tmp855_;
								if (_tmp856_ != NULL) {
									ValaMethod* _tmp857_;
									ValaMethod* _tmp858_;
									ValaMethod* _tmp859_;
									ValaMethod* _tmp860_;
									ValaMethod* _tmp861_;
									ValaSignal* _tmp862_;
									ValaSignal* _tmp863_;
									ValaSymbol* _tmp868_;
									ValaSymbol* _tmp869_;
									ValaSymbol* _tmp870_;
									_tmp857_ = m;
									_tmp858_ = vala_method_get_base_interface_method (_tmp857_);
									_tmp859_ = _tmp858_;
									_tmp860_ = _vala_code_node_ref0 (_tmp859_);
									_vala_code_node_unref0 (m);
									m = _tmp860_;
									_tmp861_ = m;
									_tmp862_ = vala_method_get_signal_reference (_tmp861_);
									_tmp863_ = _tmp862_;
									if (_tmp863_ != NULL) {
										ValaMethod* _tmp864_;
										ValaSignal* _tmp865_;
										ValaSignal* _tmp866_;
										_tmp864_ = m;
										_tmp865_ = vala_method_get_signal_reference (_tmp864_);
										_tmp866_ = _tmp865_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp866_);
									} else {
										ValaMethod* _tmp867_;
										_tmp867_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp867_);
									}
									_tmp868_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp869_ = _tmp868_;
									_tmp870_ = _vala_code_node_ref0 (_tmp869_);
									_vala_code_node_unref0 (member);
									member = _tmp870_;
								}
							}
						}
						_tmp871_ = m;
						_tmp872_ = vala_symbol_get_access ((ValaSymbol*) _tmp871_);
						_tmp873_ = _tmp872_;
						access = _tmp873_;
						_tmp874_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp874_)) {
							ValaMethod* _tmp875_;
							ValaMemberBinding _tmp876_;
							ValaMemberBinding _tmp877_;
							_tmp875_ = m;
							_tmp876_ = vala_method_get_binding (_tmp875_);
							_tmp877_ = _tmp876_;
							instance = _tmp877_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp878_ = m;
						_tmp879_ = vala_method_get_binding (_tmp878_);
						_tmp880_ = _tmp879_;
						klass = _tmp880_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp881_;
							ValaList* _tmp882_;
							gint _param_size = 0;
							ValaList* _tmp883_;
							gint _tmp884_;
							gint _tmp885_;
							gint _param_index = 0;
							_tmp881_ = m;
							_tmp882_ = vala_callable_get_parameters ((ValaCallable*) _tmp881_);
							_param_list = _tmp882_;
							_tmp883_ = _param_list;
							_tmp884_ = vala_collection_get_size ((ValaCollection*) _tmp883_);
							_tmp885_ = _tmp884_;
							_param_size = _tmp885_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp886_;
								gpointer _tmp887_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp888_;
								ValaDataType* _tmp889_;
								ValaDataType* _tmp890_;
								ValaGenericType* _tmp891_;
								gboolean _tmp892_ = FALSE;
								ValaGenericType* _tmp893_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp886_ = _param_list;
								_tmp887_ = vala_list_get (_tmp886_, _param_index);
								param = (ValaParameter*) _tmp887_;
								_tmp888_ = param;
								_tmp889_ = vala_variable_get_variable_type ((ValaVariable*) _tmp888_);
								_tmp890_ = _tmp889_;
								_tmp891_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp890_) ? ((ValaGenericType*) _tmp890_) : NULL);
								generic_type = _tmp891_;
								_tmp893_ = generic_type;
								if (_tmp893_ != NULL) {
									ValaGenericType* _tmp894_;
									ValaTypeParameter* _tmp895_;
									ValaTypeParameter* _tmp896_;
									ValaSymbol* _tmp897_;
									ValaSymbol* _tmp898_;
									_tmp894_ = generic_type;
									_tmp895_ = vala_generic_type_get_type_parameter (_tmp894_);
									_tmp896_ = _tmp895_;
									_tmp897_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp896_);
									_tmp898_ = _tmp897_;
									_tmp892_ = VALA_IS_TYPESYMBOL (_tmp898_);
								} else {
									_tmp892_ = FALSE;
								}
								if (_tmp892_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp899_ = m;
						_tmp900_ = vala_callable_get_return_type ((ValaCallable*) _tmp899_);
						_tmp901_ = _tmp900_;
						_tmp902_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp901_) ? ((ValaGenericType*) _tmp901_) : NULL);
						generic_type = _tmp902_;
						_tmp904_ = generic_type;
						if (_tmp904_ != NULL) {
							ValaGenericType* _tmp905_;
							ValaTypeParameter* _tmp906_;
							ValaTypeParameter* _tmp907_;
							ValaSymbol* _tmp908_;
							ValaSymbol* _tmp909_;
							_tmp905_ = generic_type;
							_tmp906_ = vala_generic_type_get_type_parameter (_tmp905_);
							_tmp907_ = _tmp906_;
							_tmp908_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp907_);
							_tmp909_ = _tmp908_;
							_tmp903_ = VALA_IS_TYPESYMBOL (_tmp909_);
						} else {
							_tmp903_ = FALSE;
						}
						if (_tmp903_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp910_;
						_tmp910_ = member;
						if (VALA_IS_PROPERTY (_tmp910_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp911_;
							ValaProperty* _tmp912_;
							ValaProperty* _tmp913_;
							ValaProperty* _tmp914_;
							ValaProperty* _tmp915_;
							ValaProperty* _tmp916_;
							ValaProperty* _tmp936_;
							ValaSymbolAccessibility _tmp937_;
							ValaSymbolAccessibility _tmp938_;
							gboolean _tmp939_;
							gboolean _tmp940_;
							ValaProperty* _tmp1005_;
							ValaMemberBinding _tmp1006_;
							ValaMemberBinding _tmp1007_;
							ValaProperty* _tmp1008_;
							ValaDataType* _tmp1009_;
							ValaDataType* _tmp1010_;
							_tmp911_ = member;
							_tmp912_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp911_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp912_;
							_tmp913_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp913_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp914_ = prop;
							_tmp915_ = vala_property_get_base_property (_tmp914_);
							_tmp916_ = _tmp915_;
							if (_tmp916_ != NULL) {
								ValaProperty* _tmp917_;
								ValaProperty* _tmp918_;
								ValaProperty* _tmp919_;
								ValaProperty* _tmp920_;
								ValaProperty* _tmp921_;
								ValaSymbol* _tmp922_;
								ValaSymbol* _tmp923_;
								ValaSymbol* _tmp924_;
								_tmp917_ = prop;
								_tmp918_ = vala_property_get_base_property (_tmp917_);
								_tmp919_ = _tmp918_;
								_tmp920_ = _vala_code_node_ref0 (_tmp919_);
								_vala_code_node_unref0 (prop);
								prop = _tmp920_;
								_tmp921_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp921_);
								_tmp922_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp923_ = _tmp922_;
								_tmp924_ = _vala_code_node_ref0 (_tmp923_);
								_vala_code_node_unref0 (member);
								member = _tmp924_;
							} else {
								ValaProperty* _tmp925_;
								ValaProperty* _tmp926_;
								ValaProperty* _tmp927_;
								_tmp925_ = prop;
								_tmp926_ = vala_property_get_base_interface_property (_tmp925_);
								_tmp927_ = _tmp926_;
								if (_tmp927_ != NULL) {
									ValaProperty* _tmp928_;
									ValaProperty* _tmp929_;
									ValaProperty* _tmp930_;
									ValaProperty* _tmp931_;
									ValaProperty* _tmp932_;
									ValaSymbol* _tmp933_;
									ValaSymbol* _tmp934_;
									ValaSymbol* _tmp935_;
									_tmp928_ = prop;
									_tmp929_ = vala_property_get_base_interface_property (_tmp928_);
									_tmp930_ = _tmp929_;
									_tmp931_ = _vala_code_node_ref0 (_tmp930_);
									_vala_code_node_unref0 (prop);
									prop = _tmp931_;
									_tmp932_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp932_);
									_tmp933_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp934_ = _tmp933_;
									_tmp935_ = _vala_code_node_ref0 (_tmp934_);
									_vala_code_node_unref0 (member);
									member = _tmp935_;
								}
							}
							_tmp936_ = prop;
							_tmp937_ = vala_symbol_get_access ((ValaSymbol*) _tmp936_);
							_tmp938_ = _tmp937_;
							access = _tmp938_;
							_tmp939_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp940_ = _tmp939_;
							if (_tmp940_) {
								ValaProperty* _tmp941_;
								ValaPropertyAccessor* _tmp942_;
								ValaPropertyAccessor* _tmp943_;
								ValaProperty* _tmp951_;
								ValaSymbolAccessibility _tmp952_;
								ValaSymbolAccessibility _tmp953_;
								_tmp941_ = prop;
								_tmp942_ = vala_property_get_set_accessor (_tmp941_);
								_tmp943_ = _tmp942_;
								if (_tmp943_ == NULL) {
									ValaSourceReference* _tmp944_;
									ValaSourceReference* _tmp945_;
									ValaProperty* _tmp946_;
									gchar* _tmp947_;
									gchar* _tmp948_;
									gchar* _tmp949_;
									gchar* _tmp950_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp944_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp945_ = _tmp944_;
									_tmp946_ = prop;
									_tmp947_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp946_);
									_tmp948_ = _tmp947_;
									_tmp949_ = g_strdup_printf ("Property `%s' is read-only", _tmp948_);
									_tmp950_ = _tmp949_;
									vala_report_error (_tmp945_, _tmp950_);
									_g_free0 (_tmp950_);
									_g_free0 (_tmp948_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp951_ = prop;
								_tmp952_ = vala_symbol_get_access ((ValaSymbol*) _tmp951_);
								_tmp953_ = _tmp952_;
								if (_tmp953_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp954_;
									ValaPropertyAccessor* _tmp955_;
									ValaPropertyAccessor* _tmp956_;
									ValaSymbolAccessibility _tmp957_;
									ValaSymbolAccessibility _tmp958_;
									_tmp954_ = prop;
									_tmp955_ = vala_property_get_set_accessor (_tmp954_);
									_tmp956_ = _tmp955_;
									_tmp957_ = vala_symbol_get_access ((ValaSymbol*) _tmp956_);
									_tmp958_ = _tmp957_;
									access = _tmp958_;
								} else {
									gboolean _tmp959_ = FALSE;
									ValaProperty* _tmp960_;
									ValaSymbolAccessibility _tmp961_;
									ValaSymbolAccessibility _tmp962_;
									_tmp960_ = prop;
									_tmp961_ = vala_symbol_get_access ((ValaSymbol*) _tmp960_);
									_tmp962_ = _tmp961_;
									if (_tmp962_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp963_;
										ValaPropertyAccessor* _tmp964_;
										ValaPropertyAccessor* _tmp965_;
										ValaSymbolAccessibility _tmp966_;
										ValaSymbolAccessibility _tmp967_;
										_tmp963_ = prop;
										_tmp964_ = vala_property_get_set_accessor (_tmp963_);
										_tmp965_ = _tmp964_;
										_tmp966_ = vala_symbol_get_access ((ValaSymbol*) _tmp965_);
										_tmp967_ = _tmp966_;
										_tmp959_ = _tmp967_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp959_ = FALSE;
									}
									if (_tmp959_) {
										ValaProperty* _tmp968_;
										ValaPropertyAccessor* _tmp969_;
										ValaPropertyAccessor* _tmp970_;
										ValaSymbolAccessibility _tmp971_;
										ValaSymbolAccessibility _tmp972_;
										_tmp968_ = prop;
										_tmp969_ = vala_property_get_set_accessor (_tmp968_);
										_tmp970_ = _tmp969_;
										_tmp971_ = vala_symbol_get_access ((ValaSymbol*) _tmp970_);
										_tmp972_ = _tmp971_;
										access = _tmp972_;
									}
								}
							} else {
								ValaProperty* _tmp973_;
								ValaPropertyAccessor* _tmp974_;
								ValaPropertyAccessor* _tmp975_;
								ValaProperty* _tmp983_;
								ValaSymbolAccessibility _tmp984_;
								ValaSymbolAccessibility _tmp985_;
								_tmp973_ = prop;
								_tmp974_ = vala_property_get_get_accessor (_tmp973_);
								_tmp975_ = _tmp974_;
								if (_tmp975_ == NULL) {
									ValaSourceReference* _tmp976_;
									ValaSourceReference* _tmp977_;
									ValaProperty* _tmp978_;
									gchar* _tmp979_;
									gchar* _tmp980_;
									gchar* _tmp981_;
									gchar* _tmp982_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp976_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp977_ = _tmp976_;
									_tmp978_ = prop;
									_tmp979_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp978_);
									_tmp980_ = _tmp979_;
									_tmp981_ = g_strdup_printf ("Property `%s' is write-only", _tmp980_);
									_tmp982_ = _tmp981_;
									vala_report_error (_tmp977_, _tmp982_);
									_g_free0 (_tmp982_);
									_g_free0 (_tmp980_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp983_ = prop;
								_tmp984_ = vala_symbol_get_access ((ValaSymbol*) _tmp983_);
								_tmp985_ = _tmp984_;
								if (_tmp985_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp986_;
									ValaPropertyAccessor* _tmp987_;
									ValaPropertyAccessor* _tmp988_;
									ValaSymbolAccessibility _tmp989_;
									ValaSymbolAccessibility _tmp990_;
									_tmp986_ = prop;
									_tmp987_ = vala_property_get_get_accessor (_tmp986_);
									_tmp988_ = _tmp987_;
									_tmp989_ = vala_symbol_get_access ((ValaSymbol*) _tmp988_);
									_tmp990_ = _tmp989_;
									access = _tmp990_;
								} else {
									gboolean _tmp991_ = FALSE;
									ValaProperty* _tmp992_;
									ValaSymbolAccessibility _tmp993_;
									ValaSymbolAccessibility _tmp994_;
									_tmp992_ = prop;
									_tmp993_ = vala_symbol_get_access ((ValaSymbol*) _tmp992_);
									_tmp994_ = _tmp993_;
									if (_tmp994_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp995_;
										ValaPropertyAccessor* _tmp996_;
										ValaPropertyAccessor* _tmp997_;
										ValaSymbolAccessibility _tmp998_;
										ValaSymbolAccessibility _tmp999_;
										_tmp995_ = prop;
										_tmp996_ = vala_property_get_get_accessor (_tmp995_);
										_tmp997_ = _tmp996_;
										_tmp998_ = vala_symbol_get_access ((ValaSymbol*) _tmp997_);
										_tmp999_ = _tmp998_;
										_tmp991_ = _tmp999_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp991_ = FALSE;
									}
									if (_tmp991_) {
										ValaProperty* _tmp1000_;
										ValaPropertyAccessor* _tmp1001_;
										ValaPropertyAccessor* _tmp1002_;
										ValaSymbolAccessibility _tmp1003_;
										ValaSymbolAccessibility _tmp1004_;
										_tmp1000_ = prop;
										_tmp1001_ = vala_property_get_get_accessor (_tmp1000_);
										_tmp1002_ = _tmp1001_;
										_tmp1003_ = vala_symbol_get_access ((ValaSymbol*) _tmp1002_);
										_tmp1004_ = _tmp1003_;
										access = _tmp1004_;
									}
								}
							}
							_tmp1005_ = prop;
							_tmp1006_ = vala_property_get_binding (_tmp1005_);
							_tmp1007_ = _tmp1006_;
							instance = _tmp1007_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1008_ = prop;
							_tmp1009_ = vala_property_get_property_type (_tmp1008_);
							_tmp1010_ = _tmp1009_;
							if (VALA_IS_GENERIC_TYPE (_tmp1010_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1011_;
							_tmp1011_ = member;
							if (VALA_IS_SIGNAL (_tmp1011_)) {
								ValaSymbol* _tmp1012_;
								ValaSymbolAccessibility _tmp1013_;
								ValaSymbolAccessibility _tmp1014_;
								instance = TRUE;
								_tmp1012_ = member;
								_tmp1013_ = vala_symbol_get_access (_tmp1012_);
								_tmp1014_ = _tmp1013_;
								access = _tmp1014_;
							} else {
								gboolean _tmp1015_ = FALSE;
								gboolean _tmp1016_;
								_tmp1016_ = self->priv->_creation_member;
								if (!_tmp1016_) {
									ValaSymbol* _tmp1017_;
									_tmp1017_ = member;
									_tmp1015_ = VALA_IS_ERROR_CODE (_tmp1017_);
								} else {
									_tmp1015_ = FALSE;
								}
								if (_tmp1015_) {
									ValaSymbol* _tmp1018_;
									ValaConstant* _tmp1019_;
									ValaConstant* _tmp1020_;
									ValaSymbol* _tmp1021_;
									ValaSymbol* _tmp1022_;
									ValaSymbol* _tmp1023_;
									_tmp1018_ = member;
									_tmp1019_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1018_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1020_ = _tmp1019_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1020_);
									_tmp1021_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1022_ = _tmp1021_;
									_tmp1023_ = _vala_code_node_ref0 (_tmp1022_);
									_vala_code_node_unref0 (member);
									member = _tmp1023_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1024_ = member;
	vala_symbol_set_used (_tmp1024_, TRUE);
	_tmp1025_ = member;
	_tmp1026_ = vala_symbol_get_version (_tmp1025_);
	_tmp1027_ = _tmp1026_;
	_tmp1028_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1029_ = _tmp1028_;
	vala_version_attribute_check (_tmp1027_, _tmp1029_);
	_tmp1031_ = access;
	if (_tmp1031_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1032_;
		ValaSymbol* _tmp1033_;
		ValaSymbol* _tmp1034_;
		_tmp1032_ = member;
		_tmp1033_ = vala_symbol_get_parent_symbol (_tmp1032_);
		_tmp1034_ = _tmp1033_;
		_tmp1030_ = VALA_IS_TYPESYMBOL (_tmp1034_);
	} else {
		_tmp1030_ = FALSE;
	}
	if (_tmp1030_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1035_;
		ValaSymbol* _tmp1036_;
		ValaSymbol* _tmp1037_;
		ValaTypeSymbol* _tmp1038_;
		gboolean in_subtype = FALSE;
		_tmp1035_ = member;
		_tmp1036_ = vala_symbol_get_parent_symbol (_tmp1035_);
		_tmp1037_ = _tmp1036_;
		_tmp1038_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1037_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1038_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1039_;
			ValaSemanticAnalyzer* _tmp1040_;
			ValaSymbol* _tmp1041_;
			ValaSymbol* _tmp1042_;
			ValaSymbol* _tmp1043_;
			_tmp1039_ = vala_code_context_get_analyzer (context);
			_tmp1040_ = _tmp1039_;
			_tmp1041_ = vala_semantic_analyzer_get_current_symbol (_tmp1040_);
			_tmp1042_ = _tmp1041_;
			_tmp1043_ = _vala_code_node_ref0 (_tmp1042_);
			this_symbol = _tmp1043_;
			{
				gboolean _tmp1044_ = FALSE;
				_tmp1044_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1049_;
					ValaSymbol* _tmp1050_;
					ValaTypeSymbol* _tmp1051_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1052_;
					ValaClass* _tmp1053_;
					gboolean _tmp1054_ = FALSE;
					ValaClass* _tmp1055_;
					if (!_tmp1044_) {
						ValaSymbol* _tmp1045_;
						ValaSymbol* _tmp1046_;
						ValaSymbol* _tmp1047_;
						ValaSymbol* _tmp1048_;
						_tmp1045_ = this_symbol;
						_tmp1046_ = vala_symbol_get_parent_symbol (_tmp1045_);
						_tmp1047_ = _tmp1046_;
						_tmp1048_ = _vala_code_node_ref0 (_tmp1047_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1048_;
					}
					_tmp1044_ = FALSE;
					_tmp1049_ = this_symbol;
					if (!(_tmp1049_ != NULL)) {
						break;
					}
					_tmp1050_ = this_symbol;
					_tmp1051_ = target_type;
					if (_tmp1050_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1051_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1052_ = this_symbol;
					_tmp1053_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1052_) ? ((ValaClass*) _tmp1052_) : NULL);
					cl = _tmp1053_;
					_tmp1055_ = cl;
					if (_tmp1055_ != NULL) {
						ValaClass* _tmp1056_;
						ValaTypeSymbol* _tmp1057_;
						_tmp1056_ = cl;
						_tmp1057_ = target_type;
						_tmp1054_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1056_, _tmp1057_);
					} else {
						_tmp1054_ = FALSE;
					}
					if (_tmp1054_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1058_;
			ValaSourceReference* _tmp1059_;
			ValaSymbol* _tmp1060_;
			gchar* _tmp1061_;
			gchar* _tmp1062_;
			gchar* _tmp1063_;
			gchar* _tmp1064_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1058_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1059_ = _tmp1058_;
			_tmp1060_ = member;
			_tmp1061_ = vala_symbol_get_full_name (_tmp1060_);
			_tmp1062_ = _tmp1061_;
			_tmp1063_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1062_);
			_tmp1064_ = _tmp1063_;
			vala_report_error (_tmp1059_, _tmp1064_);
			_g_free0 (_tmp1064_);
			_g_free0 (_tmp1062_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1065_;
		_tmp1065_ = access;
		if (_tmp1065_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1066_;
			ValaSymbol* _tmp1067_;
			ValaSymbol* _tmp1068_;
			ValaSymbol* _tmp1069_;
			gboolean in_target_type = FALSE;
			_tmp1066_ = member;
			_tmp1067_ = vala_symbol_get_parent_symbol (_tmp1066_);
			_tmp1068_ = _tmp1067_;
			_tmp1069_ = _vala_code_node_ref0 (_tmp1068_);
			target_type = _tmp1069_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1070_;
				ValaSemanticAnalyzer* _tmp1071_;
				ValaSymbol* _tmp1072_;
				ValaSymbol* _tmp1073_;
				ValaSymbol* _tmp1074_;
				_tmp1070_ = vala_code_context_get_analyzer (context);
				_tmp1071_ = _tmp1070_;
				_tmp1072_ = vala_semantic_analyzer_get_current_symbol (_tmp1071_);
				_tmp1073_ = _tmp1072_;
				_tmp1074_ = _vala_code_node_ref0 (_tmp1073_);
				this_symbol = _tmp1074_;
				{
					gboolean _tmp1075_ = FALSE;
					_tmp1075_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1080_;
						ValaSymbol* _tmp1081_;
						ValaSymbol* _tmp1082_;
						if (!_tmp1075_) {
							ValaSymbol* _tmp1076_;
							ValaSymbol* _tmp1077_;
							ValaSymbol* _tmp1078_;
							ValaSymbol* _tmp1079_;
							_tmp1076_ = this_symbol;
							_tmp1077_ = vala_symbol_get_parent_symbol (_tmp1076_);
							_tmp1078_ = _tmp1077_;
							_tmp1079_ = _vala_code_node_ref0 (_tmp1078_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1079_;
						}
						_tmp1075_ = FALSE;
						_tmp1080_ = this_symbol;
						if (!(_tmp1080_ != NULL)) {
							break;
						}
						_tmp1081_ = target_type;
						_tmp1082_ = this_symbol;
						if (_tmp1081_ == _tmp1082_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1083_;
				ValaSourceReference* _tmp1084_;
				ValaSymbol* _tmp1085_;
				gchar* _tmp1086_;
				gchar* _tmp1087_;
				gchar* _tmp1088_;
				gchar* _tmp1089_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1083_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1084_ = _tmp1083_;
				_tmp1085_ = member;
				_tmp1086_ = vala_symbol_get_full_name (_tmp1085_);
				_tmp1087_ = _tmp1086_;
				_tmp1088_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1087_);
				_tmp1089_ = _tmp1088_;
				vala_report_error (_tmp1084_, _tmp1089_);
				_g_free0 (_tmp1089_);
				_g_free0 (_tmp1087_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1091_;
		ValaExpression* _tmp1092_;
		_tmp1091_ = vala_member_access_get_inner (self);
		_tmp1092_ = _tmp1091_;
		_tmp1090_ = _tmp1092_ != NULL;
	} else {
		_tmp1090_ = FALSE;
	}
	if (_tmp1090_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1093_;
		ValaExpression* _tmp1094_;
		ValaDataType* _tmp1095_;
		ValaDataType* _tmp1096_;
		ValaDataType* _tmp1097_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1098_;
		ValaExpression* _tmp1099_;
		ValaDataType* _tmp1100_;
		ValaDataType* _tmp1101_;
		ValaPointerType* _tmp1102_;
		ValaPointerType* _tmp1103_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1108_;
		ValaObjectType* _tmp1109_;
		gboolean _tmp1110_ = FALSE;
		gboolean _tmp1111_ = FALSE;
		ValaObjectType* _tmp1112_;
		_tmp1093_ = vala_member_access_get_inner (self);
		_tmp1094_ = _tmp1093_;
		_tmp1095_ = vala_expression_get_value_type (_tmp1094_);
		_tmp1096_ = _tmp1095_;
		_tmp1097_ = _vala_code_node_ref0 (_tmp1096_);
		instance_type = _tmp1097_;
		_tmp1098_ = vala_member_access_get_inner (self);
		_tmp1099_ = _tmp1098_;
		_tmp1100_ = vala_expression_get_value_type (_tmp1099_);
		_tmp1101_ = _tmp1100_;
		_tmp1102_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1101_) ? ((ValaPointerType*) _tmp1101_) : NULL);
		pointer_type = _tmp1102_;
		_tmp1103_ = pointer_type;
		if (_tmp1103_ != NULL) {
			ValaPointerType* _tmp1104_;
			ValaDataType* _tmp1105_;
			ValaDataType* _tmp1106_;
			ValaDataType* _tmp1107_;
			_tmp1104_ = pointer_type;
			_tmp1105_ = vala_pointer_type_get_base_type (_tmp1104_);
			_tmp1106_ = _tmp1105_;
			_tmp1107_ = _vala_code_node_ref0 (_tmp1106_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1107_;
		}
		_tmp1108_ = instance_type;
		_tmp1109_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1108_) ? ((ValaObjectType*) _tmp1108_) : NULL);
		object_type = _tmp1109_;
		_tmp1112_ = object_type;
		if (_tmp1112_ != NULL) {
			ValaObjectType* _tmp1113_;
			ValaObjectTypeSymbol* _tmp1114_;
			ValaObjectTypeSymbol* _tmp1115_;
			_tmp1113_ = object_type;
			_tmp1114_ = vala_object_type_get_type_symbol (_tmp1113_);
			_tmp1115_ = _tmp1114_;
			_tmp1111_ = vala_object_type_symbol_has_type_parameters (_tmp1115_);
		} else {
			_tmp1111_ = FALSE;
		}
		if (_tmp1111_) {
			ValaDataType* _tmp1116_;
			_tmp1116_ = instance_type;
			_tmp1110_ = !vala_data_type_has_type_arguments (_tmp1116_);
		} else {
			_tmp1110_ = FALSE;
		}
		if (_tmp1110_) {
			ValaExpression* _tmp1117_;
			ValaExpression* _tmp1118_;
			ValaSourceReference* _tmp1119_;
			ValaSourceReference* _tmp1120_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1117_ = vala_member_access_get_inner (self);
			_tmp1118_ = _tmp1117_;
			_tmp1119_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1118_);
			_tmp1120_ = _tmp1119_;
			vala_report_error (_tmp1120_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1122_ = !may_access_instance_members;
	} else {
		_tmp1122_ = FALSE;
	}
	if (_tmp1122_) {
		_tmp1121_ = TRUE;
	} else {
		gboolean _tmp1123_ = FALSE;
		if (klass) {
			_tmp1123_ = !may_access_klass_members;
		} else {
			_tmp1123_ = FALSE;
		}
		_tmp1121_ = _tmp1123_;
	}
	if (_tmp1121_) {
		ValaSymbol* _tmp1124_;
		ValaSymbol* _tmp1125_;
		ValaDataType* _tmp1148_;
		ValaDataType* _tmp1149_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1124_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1125_ = _tmp1124_;
		if (VALA_IS_METHOD (_tmp1125_)) {
			ValaSemanticAnalyzer* _tmp1126_;
			ValaSemanticAnalyzer* _tmp1127_;
			ValaSymbol* _tmp1128_;
			ValaSymbol* _tmp1129_;
			gboolean _tmp1130_;
			gboolean _tmp1131_;
			ValaDataType* _tmp1132_;
			ValaDataType* _tmp1133_;
			_tmp1126_ = vala_code_context_get_analyzer (context);
			_tmp1127_ = _tmp1126_;
			_tmp1128_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1129_ = _tmp1128_;
			_tmp1130_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1131_ = _tmp1130_;
			_tmp1132_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1127_, _tmp1129_, _tmp1131_);
			_tmp1133_ = _tmp1132_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1133_);
			_vala_code_node_unref0 (_tmp1133_);
		} else {
			ValaSymbol* _tmp1134_;
			ValaSymbol* _tmp1135_;
			_tmp1134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1135_ = _tmp1134_;
			if (VALA_IS_FIELD (_tmp1135_)) {
				ValaSymbol* _tmp1136_;
				ValaSymbol* _tmp1137_;
				ValaFieldPrototype* _tmp1138_;
				ValaFieldPrototype* _tmp1139_;
				_tmp1136_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1137_ = _tmp1136_;
				_tmp1138_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1137_, VALA_TYPE_FIELD, ValaField));
				_tmp1139_ = _tmp1138_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1139_);
				_vala_code_node_unref0 (_tmp1139_);
			} else {
				ValaSymbol* _tmp1140_;
				ValaSymbol* _tmp1141_;
				_tmp1140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1141_ = _tmp1140_;
				if (VALA_IS_PROPERTY (_tmp1141_)) {
					ValaSymbol* _tmp1142_;
					ValaSymbol* _tmp1143_;
					ValaPropertyPrototype* _tmp1144_;
					ValaPropertyPrototype* _tmp1145_;
					_tmp1142_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1143_ = _tmp1142_;
					_tmp1144_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1143_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1145_ = _tmp1144_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1145_);
					_vala_code_node_unref0 (_tmp1145_);
				} else {
					ValaInvalidType* _tmp1146_;
					ValaInvalidType* _tmp1147_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1146_ = vala_invalid_type_new ();
					_tmp1147_ = _tmp1146_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1147_);
					_vala_code_node_unref0 (_tmp1147_);
				}
			}
		}
		_tmp1148_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1149_ = _tmp1148_;
		if (_tmp1149_ != NULL) {
			ValaDataType* _tmp1150_;
			ValaDataType* _tmp1151_;
			ValaDataType* _tmp1152_;
			ValaDataType* _tmp1153_;
			gboolean _tmp1154_;
			gboolean _tmp1155_;
			_tmp1150_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1151_ = _tmp1150_;
			_tmp1152_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1153_ = _tmp1152_;
			_tmp1154_ = vala_data_type_get_value_owned (_tmp1153_);
			_tmp1155_ = _tmp1154_;
			vala_data_type_set_value_owned (_tmp1151_, _tmp1155_);
		}
	} else {
		gboolean _tmp1156_ = FALSE;
		gboolean _tmp1177_ = FALSE;
		gboolean _tmp1178_ = FALSE;
		gboolean _tmp1179_ = FALSE;
		gboolean _tmp1180_ = FALSE;
		gboolean _tmp1197_ = FALSE;
		gboolean _tmp1198_ = FALSE;
		gboolean _tmp1199_ = FALSE;
		gboolean _tmp1200_ = FALSE;
		gboolean _tmp1201_ = FALSE;
		gboolean _tmp1202_;
		gboolean _tmp1203_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1230_;
		ValaSymbol* _tmp1231_;
		ValaMethod* _tmp1232_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1233_;
		ValaExpression* _tmp1234_;
		ValaMemberAccess* _tmp1235_;
		gboolean _tmp1236_ = FALSE;
		gboolean _tmp1237_ = FALSE;
		gboolean _tmp1238_ = FALSE;
		gboolean _tmp1239_ = FALSE;
		gboolean _tmp1240_ = FALSE;
		ValaMethod* _tmp1241_;
		ValaSemanticAnalyzer* _tmp1278_;
		ValaSemanticAnalyzer* _tmp1279_;
		ValaSymbol* _tmp1280_;
		ValaSymbol* _tmp1281_;
		gboolean _tmp1282_;
		gboolean _tmp1283_;
		ValaDataType* _tmp1284_;
		ValaDataType* _tmp1285_;
		gboolean _tmp1286_ = FALSE;
		ValaExpression* _tmp1287_;
		ValaExpression* _tmp1288_;
		ValaSymbol* _tmp1301_;
		ValaSymbol* _tmp1302_;
		if (instance) {
			ValaExpression* _tmp1157_;
			ValaExpression* _tmp1158_;
			_tmp1157_ = vala_member_access_get_inner (self);
			_tmp1158_ = _tmp1157_;
			_tmp1156_ = _tmp1158_ == NULL;
		} else {
			_tmp1156_ = FALSE;
		}
		if (_tmp1156_) {
			ValaSourceReference* _tmp1159_;
			ValaSourceReference* _tmp1160_;
			ValaMemberAccess* _tmp1161_;
			ValaMemberAccess* _tmp1162_;
			ValaExpression* _tmp1163_;
			ValaExpression* _tmp1164_;
			ValaParameter* _tmp1165_;
			ValaDataType* _tmp1166_;
			ValaDataType* _tmp1167_;
			ValaDataType* _tmp1168_;
			ValaDataType* _tmp1169_;
			ValaExpression* _tmp1170_;
			ValaExpression* _tmp1171_;
			ValaDataType* _tmp1172_;
			ValaDataType* _tmp1173_;
			ValaExpression* _tmp1174_;
			ValaExpression* _tmp1175_;
			ValaParameter* _tmp1176_;
			_tmp1159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1160_ = _tmp1159_;
			_tmp1161_ = vala_member_access_new (NULL, "this", _tmp1160_);
			_tmp1162_ = _tmp1161_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1162_);
			_vala_code_node_unref0 (_tmp1162_);
			_tmp1163_ = vala_member_access_get_inner (self);
			_tmp1164_ = _tmp1163_;
			_tmp1165_ = this_parameter;
			_tmp1166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1165_);
			_tmp1167_ = _tmp1166_;
			_tmp1168_ = vala_data_type_copy (_tmp1167_);
			_tmp1169_ = _tmp1168_;
			vala_expression_set_value_type (_tmp1164_, _tmp1169_);
			_vala_code_node_unref0 (_tmp1169_);
			_tmp1170_ = vala_member_access_get_inner (self);
			_tmp1171_ = _tmp1170_;
			_tmp1172_ = vala_expression_get_value_type (_tmp1171_);
			_tmp1173_ = _tmp1172_;
			vala_data_type_set_value_owned (_tmp1173_, FALSE);
			_tmp1174_ = vala_member_access_get_inner (self);
			_tmp1175_ = _tmp1174_;
			_tmp1176_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1175_, (ValaSymbol*) _tmp1176_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1180_ = !klass;
		} else {
			_tmp1180_ = FALSE;
		}
		if (_tmp1180_) {
			ValaSymbol* _tmp1181_;
			ValaSymbol* _tmp1182_;
			_tmp1181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1182_ = _tmp1181_;
			_tmp1179_ = !VALA_IS_CREATION_METHOD (_tmp1182_);
		} else {
			_tmp1179_ = FALSE;
		}
		if (_tmp1179_) {
			_tmp1178_ = may_access_instance_members;
		} else {
			_tmp1178_ = FALSE;
		}
		if (_tmp1178_) {
			ValaExpression* _tmp1183_;
			ValaExpression* _tmp1184_;
			_tmp1183_ = vala_member_access_get_inner (self);
			_tmp1184_ = _tmp1183_;
			_tmp1177_ = _tmp1184_ != NULL;
		} else {
			_tmp1177_ = FALSE;
		}
		if (_tmp1177_) {
			ValaExpression* _tmp1185_;
			ValaExpression* _tmp1186_;
			ValaSymbol* _tmp1187_;
			ValaSymbol* _tmp1188_;
			_tmp1185_ = vala_member_access_get_inner (self);
			_tmp1186_ = _tmp1185_;
			_tmp1187_ = vala_expression_get_symbol_reference (_tmp1186_);
			_tmp1188_ = _tmp1187_;
			if (VALA_IS_METHOD (_tmp1188_)) {
			} else {
				ValaSourceReference* _tmp1189_;
				ValaSourceReference* _tmp1190_;
				ValaSymbol* _tmp1191_;
				ValaSymbol* _tmp1192_;
				gchar* _tmp1193_;
				gchar* _tmp1194_;
				gchar* _tmp1195_;
				gchar* _tmp1196_;
				_tmp1189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1190_ = _tmp1189_;
				_tmp1191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1192_ = _tmp1191_;
				_tmp1193_ = vala_symbol_get_full_name (_tmp1192_);
				_tmp1194_ = _tmp1193_;
				_tmp1195_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1194_);
				_tmp1196_ = _tmp1195_;
				vala_report_warning (_tmp1190_, _tmp1196_);
				_g_free0 (_tmp1196_);
				_g_free0 (_tmp1194_);
			}
		}
		_tmp1202_ = vala_code_context_get_experimental_non_null (context);
		_tmp1203_ = _tmp1202_;
		if (_tmp1203_) {
			_tmp1201_ = instance;
		} else {
			_tmp1201_ = FALSE;
		}
		if (_tmp1201_) {
			ValaExpression* _tmp1204_;
			ValaExpression* _tmp1205_;
			ValaDataType* _tmp1206_;
			ValaDataType* _tmp1207_;
			gboolean _tmp1208_;
			gboolean _tmp1209_;
			_tmp1204_ = vala_member_access_get_inner (self);
			_tmp1205_ = _tmp1204_;
			_tmp1206_ = vala_expression_get_value_type (_tmp1205_);
			_tmp1207_ = _tmp1206_;
			_tmp1208_ = vala_data_type_get_nullable (_tmp1207_);
			_tmp1209_ = _tmp1208_;
			_tmp1200_ = _tmp1209_;
		} else {
			_tmp1200_ = FALSE;
		}
		if (_tmp1200_) {
			ValaExpression* _tmp1210_;
			ValaExpression* _tmp1211_;
			ValaDataType* _tmp1212_;
			ValaDataType* _tmp1213_;
			_tmp1210_ = vala_member_access_get_inner (self);
			_tmp1211_ = _tmp1210_;
			_tmp1212_ = vala_expression_get_value_type (_tmp1211_);
			_tmp1213_ = _tmp1212_;
			_tmp1199_ = !VALA_IS_POINTER_TYPE (_tmp1213_);
		} else {
			_tmp1199_ = FALSE;
		}
		if (_tmp1199_) {
			ValaExpression* _tmp1214_;
			ValaExpression* _tmp1215_;
			ValaDataType* _tmp1216_;
			ValaDataType* _tmp1217_;
			_tmp1214_ = vala_member_access_get_inner (self);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = vala_expression_get_value_type (_tmp1215_);
			_tmp1217_ = _tmp1216_;
			_tmp1198_ = !VALA_IS_GENERIC_TYPE (_tmp1217_);
		} else {
			_tmp1198_ = FALSE;
		}
		if (_tmp1198_) {
			ValaExpression* _tmp1218_;
			ValaExpression* _tmp1219_;
			ValaDataType* _tmp1220_;
			ValaDataType* _tmp1221_;
			_tmp1218_ = vala_member_access_get_inner (self);
			_tmp1219_ = _tmp1218_;
			_tmp1220_ = vala_expression_get_value_type (_tmp1219_);
			_tmp1221_ = _tmp1220_;
			_tmp1197_ = !VALA_IS_ARRAY_TYPE (_tmp1221_);
		} else {
			_tmp1197_ = FALSE;
		}
		if (_tmp1197_) {
			ValaSourceReference* _tmp1222_;
			ValaSourceReference* _tmp1223_;
			ValaSymbol* _tmp1224_;
			ValaSymbol* _tmp1225_;
			gchar* _tmp1226_;
			gchar* _tmp1227_;
			gchar* _tmp1228_;
			gchar* _tmp1229_;
			_tmp1222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1223_ = _tmp1222_;
			_tmp1224_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1225_ = _tmp1224_;
			_tmp1226_ = vala_symbol_get_full_name (_tmp1225_);
			_tmp1227_ = _tmp1226_;
			_tmp1228_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1227_);
			_tmp1229_ = _tmp1228_;
			vala_report_error (_tmp1223_, _tmp1229_);
			_g_free0 (_tmp1229_);
			_g_free0 (_tmp1227_);
		}
		_tmp1230_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1231_ = _tmp1230_;
		_tmp1232_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1231_) ? ((ValaMethod*) _tmp1231_) : NULL);
		m = _tmp1232_;
		_tmp1233_ = vala_member_access_get_inner (self);
		_tmp1234_ = _tmp1233_;
		_tmp1235_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1234_) ? ((ValaMemberAccess*) _tmp1234_) : NULL);
		inner_ma = _tmp1235_;
		_tmp1241_ = m;
		if (_tmp1241_ != NULL) {
			ValaMethod* _tmp1242_;
			ValaMemberBinding _tmp1243_;
			ValaMemberBinding _tmp1244_;
			_tmp1242_ = m;
			_tmp1243_ = vala_method_get_binding (_tmp1242_);
			_tmp1244_ = _tmp1243_;
			_tmp1240_ = _tmp1244_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1240_ = FALSE;
		}
		if (_tmp1240_) {
			ValaMethod* _tmp1245_;
			ValaSymbol* _tmp1246_;
			ValaSymbol* _tmp1247_;
			_tmp1245_ = m;
			_tmp1246_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1245_);
			_tmp1247_ = _tmp1246_;
			_tmp1239_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1247_);
		} else {
			_tmp1239_ = FALSE;
		}
		if (_tmp1239_) {
			ValaExpression* _tmp1248_;
			ValaExpression* _tmp1249_;
			_tmp1248_ = vala_member_access_get_inner (self);
			_tmp1249_ = _tmp1248_;
			_tmp1238_ = _tmp1249_ != NULL;
		} else {
			_tmp1238_ = FALSE;
		}
		if (_tmp1238_) {
			ValaExpression* _tmp1250_;
			ValaExpression* _tmp1251_;
			ValaDataType* _tmp1252_;
			ValaDataType* _tmp1253_;
			_tmp1250_ = vala_member_access_get_inner (self);
			_tmp1251_ = _tmp1250_;
			_tmp1252_ = vala_expression_get_value_type (_tmp1251_);
			_tmp1253_ = _tmp1252_;
			_tmp1237_ = _tmp1253_ == NULL;
		} else {
			_tmp1237_ = FALSE;
		}
		if (_tmp1237_) {
			ValaMemberAccess* _tmp1254_;
			ValaList* _tmp1255_;
			gint _tmp1256_;
			gint _tmp1257_;
			_tmp1254_ = inner_ma;
			_tmp1255_ = _tmp1254_->priv->type_argument_list;
			_tmp1256_ = vala_collection_get_size ((ValaCollection*) _tmp1255_);
			_tmp1257_ = _tmp1256_;
			_tmp1236_ = _tmp1257_ > 0;
		} else {
			_tmp1236_ = FALSE;
		}
		if (_tmp1236_) {
			ValaExpression* _tmp1258_;
			ValaExpression* _tmp1259_;
			ValaMethod* _tmp1260_;
			ValaSymbol* _tmp1261_;
			ValaSymbol* _tmp1262_;
			ValaObjectType* _tmp1263_;
			ValaObjectType* _tmp1264_;
			_tmp1258_ = vala_member_access_get_inner (self);
			_tmp1259_ = _tmp1258_;
			_tmp1260_ = m;
			_tmp1261_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1260_);
			_tmp1262_ = _tmp1261_;
			_tmp1263_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1262_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1264_ = _tmp1263_;
			vala_expression_set_value_type (_tmp1259_, (ValaDataType*) _tmp1264_);
			_vala_code_node_unref0 (_tmp1264_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1265_;
				ValaList* _tmp1266_;
				ValaList* _tmp1267_;
				gint _type_argument_size = 0;
				ValaList* _tmp1268_;
				gint _tmp1269_;
				gint _tmp1270_;
				gint _type_argument_index = 0;
				_tmp1265_ = inner_ma;
				_tmp1266_ = _tmp1265_->priv->type_argument_list;
				_tmp1267_ = _vala_iterable_ref0 (_tmp1266_);
				_type_argument_list = _tmp1267_;
				_tmp1268_ = _type_argument_list;
				_tmp1269_ = vala_collection_get_size ((ValaCollection*) _tmp1268_);
				_tmp1270_ = _tmp1269_;
				_type_argument_size = _tmp1270_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1271_;
					gpointer _tmp1272_;
					ValaExpression* _tmp1273_;
					ValaExpression* _tmp1274_;
					ValaDataType* _tmp1275_;
					ValaDataType* _tmp1276_;
					ValaDataType* _tmp1277_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1271_ = _type_argument_list;
					_tmp1272_ = vala_list_get (_tmp1271_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1272_;
					_tmp1273_ = vala_member_access_get_inner (self);
					_tmp1274_ = _tmp1273_;
					_tmp1275_ = vala_expression_get_value_type (_tmp1274_);
					_tmp1276_ = _tmp1275_;
					_tmp1277_ = type_argument;
					vala_data_type_add_type_argument (_tmp1276_, _tmp1277_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1278_ = vala_code_context_get_analyzer (context);
		_tmp1279_ = _tmp1278_;
		_tmp1280_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1281_ = _tmp1280_;
		_tmp1282_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1283_ = _tmp1282_;
		_tmp1284_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1279_, _tmp1281_, _tmp1283_);
		_tmp1285_ = _tmp1284_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1285_);
		_vala_code_node_unref0 (_tmp1285_);
		_tmp1287_ = vala_member_access_get_inner (self);
		_tmp1288_ = _tmp1287_;
		if (_tmp1288_ != NULL) {
			ValaDataType* _tmp1289_;
			ValaDataType* _tmp1290_;
			_tmp1289_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1290_ = _tmp1289_;
			_tmp1286_ = _tmp1290_ != NULL;
		} else {
			_tmp1286_ = FALSE;
		}
		if (_tmp1286_) {
			ValaDataType* _tmp1291_;
			ValaDataType* _tmp1292_;
			ValaExpression* _tmp1293_;
			ValaExpression* _tmp1294_;
			ValaDataType* _tmp1295_;
			ValaDataType* _tmp1296_;
			ValaDataType* _tmp1297_;
			ValaDataType* _tmp1298_;
			_tmp1291_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1292_ = _tmp1291_;
			_tmp1293_ = vala_member_access_get_inner (self);
			_tmp1294_ = _tmp1293_;
			_tmp1295_ = vala_expression_get_value_type (_tmp1294_);
			_tmp1296_ = _tmp1295_;
			_tmp1297_ = vala_data_type_get_actual_type (_tmp1292_, _tmp1296_, NULL, (ValaCodeNode*) self);
			_tmp1298_ = _tmp1297_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1298_);
			_vala_code_node_unref0 (_tmp1298_);
		} else {
			ValaDataType* _tmp1299_;
			ValaDataType* _tmp1300_;
			_tmp1299_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1300_ = _tmp1299_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1300_);
		}
		_tmp1301_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1302_ = _tmp1301_;
		if (VALA_IS_METHOD (_tmp1302_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1303_;
			ValaSymbol* _tmp1304_;
			ValaMethod* _tmp1305_;
			ValaDataType* _tmp1306_;
			ValaDataType* _tmp1307_;
			gboolean _tmp1314_ = FALSE;
			_tmp1303_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1304_ = _tmp1303_;
			_tmp1305_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1304_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1305_;
			_tmp1306_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1307_ = _tmp1306_;
			if (_tmp1307_ != NULL) {
				ValaDataType* _tmp1308_;
				ValaDataType* _tmp1309_;
				ValaDataType* _tmp1310_;
				ValaDataType* _tmp1311_;
				gboolean _tmp1312_;
				gboolean _tmp1313_;
				_tmp1308_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1309_ = _tmp1308_;
				_tmp1310_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1311_ = _tmp1310_;
				_tmp1312_ = vala_data_type_get_value_owned (_tmp1311_);
				_tmp1313_ = _tmp1312_;
				vala_data_type_set_value_owned (_tmp1309_, _tmp1313_);
			}
			if (instance) {
				ValaMethod* _tmp1315_;
				ValaSymbol* _tmp1316_;
				ValaSymbol* _tmp1317_;
				_tmp1315_ = method;
				_tmp1316_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1315_);
				_tmp1317_ = _tmp1316_;
				_tmp1314_ = VALA_IS_TYPESYMBOL (_tmp1317_);
			} else {
				_tmp1314_ = FALSE;
			}
			if (_tmp1314_) {
				ValaExpression* _tmp1318_;
				ValaExpression* _tmp1319_;
				ValaMethod* _tmp1320_;
				ValaSymbol* _tmp1321_;
				ValaSymbol* _tmp1322_;
				ValaDataType* _tmp1323_;
				ValaDataType* _tmp1324_;
				ValaExpression* _tmp1325_;
				ValaExpression* _tmp1326_;
				ValaDataType* _tmp1327_;
				ValaDataType* _tmp1328_;
				ValaMethod* _tmp1329_;
				ValaParameter* _tmp1330_;
				ValaParameter* _tmp1331_;
				ValaDataType* _tmp1332_;
				ValaDataType* _tmp1333_;
				gboolean _tmp1334_;
				gboolean _tmp1335_;
				_tmp1318_ = vala_member_access_get_inner (self);
				_tmp1319_ = _tmp1318_;
				_tmp1320_ = method;
				_tmp1321_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1320_);
				_tmp1322_ = _tmp1321_;
				_tmp1323_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1322_);
				_tmp1324_ = _tmp1323_;
				vala_expression_set_target_type (_tmp1319_, _tmp1324_);
				_vala_code_node_unref0 (_tmp1324_);
				_tmp1325_ = vala_member_access_get_inner (self);
				_tmp1326_ = _tmp1325_;
				_tmp1327_ = vala_expression_get_target_type (_tmp1326_);
				_tmp1328_ = _tmp1327_;
				_tmp1329_ = method;
				_tmp1330_ = vala_method_get_this_parameter (_tmp1329_);
				_tmp1331_ = _tmp1330_;
				_tmp1332_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1331_);
				_tmp1333_ = _tmp1332_;
				_tmp1334_ = vala_data_type_get_value_owned (_tmp1333_);
				_tmp1335_ = _tmp1334_;
				vala_data_type_set_value_owned (_tmp1328_, _tmp1335_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1336_;
			ValaSymbol* _tmp1337_;
			_tmp1336_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1337_ = _tmp1336_;
			if (VALA_IS_PROPERTY (_tmp1337_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1338_;
				ValaSymbol* _tmp1339_;
				ValaProperty* _tmp1340_;
				gboolean _tmp1341_ = FALSE;
				_tmp1338_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1339_ = _tmp1338_;
				_tmp1340_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1339_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1340_;
				if (instance) {
					ValaProperty* _tmp1342_;
					ValaSymbol* _tmp1343_;
					ValaSymbol* _tmp1344_;
					_tmp1342_ = prop;
					_tmp1343_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1342_);
					_tmp1344_ = _tmp1343_;
					_tmp1341_ = _tmp1344_ != NULL;
				} else {
					_tmp1341_ = FALSE;
				}
				if (_tmp1341_) {
					ValaExpression* _tmp1345_;
					ValaExpression* _tmp1346_;
					ValaProperty* _tmp1347_;
					ValaSymbol* _tmp1348_;
					ValaSymbol* _tmp1349_;
					ValaDataType* _tmp1350_;
					ValaDataType* _tmp1351_;
					_tmp1345_ = vala_member_access_get_inner (self);
					_tmp1346_ = _tmp1345_;
					_tmp1347_ = prop;
					_tmp1348_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1347_);
					_tmp1349_ = _tmp1348_;
					_tmp1350_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1349_);
					_tmp1351_ = _tmp1350_;
					vala_expression_set_target_type (_tmp1346_, _tmp1351_);
					_vala_code_node_unref0 (_tmp1351_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1352_ = FALSE;
				gboolean _tmp1353_ = FALSE;
				gboolean _tmp1354_ = FALSE;
				ValaSymbol* _tmp1355_;
				ValaSymbol* _tmp1356_;
				_tmp1355_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1356_ = _tmp1355_;
				if (VALA_IS_FIELD (_tmp1356_)) {
					_tmp1354_ = TRUE;
				} else {
					ValaSymbol* _tmp1357_;
					ValaSymbol* _tmp1358_;
					_tmp1357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1358_ = _tmp1357_;
					_tmp1354_ = VALA_IS_SIGNAL (_tmp1358_);
				}
				if (_tmp1354_) {
					_tmp1353_ = instance;
				} else {
					_tmp1353_ = FALSE;
				}
				if (_tmp1353_) {
					ValaSymbol* _tmp1359_;
					ValaSymbol* _tmp1360_;
					ValaSymbol* _tmp1361_;
					ValaSymbol* _tmp1362_;
					_tmp1359_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1360_ = _tmp1359_;
					_tmp1361_ = vala_symbol_get_parent_symbol (_tmp1360_);
					_tmp1362_ = _tmp1361_;
					_tmp1352_ = _tmp1362_ != NULL;
				} else {
					_tmp1352_ = FALSE;
				}
				if (_tmp1352_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1363_;
					ValaSymbol* _tmp1364_;
					ValaSymbol* _tmp1365_;
					ValaSymbol* _tmp1366_;
					ValaDataType* _tmp1367_;
					ValaExpression* _tmp1368_;
					ValaExpression* _tmp1369_;
					ValaDataType* _tmp1370_;
					ValaExpression* _tmp1371_;
					ValaExpression* _tmp1372_;
					ValaDataType* _tmp1373_;
					ValaDataType* _tmp1374_;
					ValaDataType* _tmp1375_;
					ValaDataType* _tmp1376_;
					_tmp1363_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1364_ = _tmp1363_;
					_tmp1365_ = vala_symbol_get_parent_symbol (_tmp1364_);
					_tmp1366_ = _tmp1365_;
					_tmp1367_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1366_);
					parent_type = _tmp1367_;
					_tmp1368_ = vala_member_access_get_inner (self);
					_tmp1369_ = _tmp1368_;
					_tmp1370_ = parent_type;
					_tmp1371_ = vala_member_access_get_inner (self);
					_tmp1372_ = _tmp1371_;
					_tmp1373_ = vala_expression_get_value_type (_tmp1372_);
					_tmp1374_ = _tmp1373_;
					_tmp1375_ = vala_data_type_get_actual_type (_tmp1370_, _tmp1374_, NULL, (ValaCodeNode*) self);
					_tmp1376_ = _tmp1375_;
					vala_expression_set_target_type (_tmp1369_, _tmp1376_);
					_vala_code_node_unref0 (_tmp1376_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1377_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1378_ = _tmp1377_;
	if (_tmp1378_ != NULL) {
		ValaDataType* _tmp1379_;
		ValaDataType* _tmp1380_;
		_tmp1379_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1380_ = _tmp1379_;
		vala_code_node_check ((ValaCodeNode*) _tmp1380_, context);
	}
	_tmp1381_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1382_ = _tmp1381_;
	result = !_tmp1382_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = VALA_IS_ARRAY_TYPE (_tmp55_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp57_) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = VALA_IS_POINTER_INDIRECTION (_tmp63_);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp67_) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (VALA_IS_METHOD (_tmp75_)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = VALA_IS_VARIABLE (_tmp83_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = VALA_IS_ELEMENT_ACCESS (_tmp85_);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaClass* _tmp103_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_METHOD, ValaMethod));
		_tmp100_ = _tmp99_;
		cl = VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp103_ = cl;
		if (_tmp103_ != NULL) {
			ValaClass* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			_tmp104_ = cl;
			_tmp105_ = vala_class_get_is_compact (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp102_ = _tmp106_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp107_;
			_tmp107_ = ma;
			_tmp101_ = _tmp107_ != NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaMemberAccess* _tmp108_;
			ValaMemberAccess* _tmp109_;
			_tmp108_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp108_, TRUE);
			_tmp109_ = ma;
			vala_member_access_check_lvalue_access (_tmp109_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

