/* valagdbusmodule.c generated by valac, the Vala compiler
 * generated from valagdbusmodule.vala, do not modify */

/* valagdbusmodule.vala
 *
 * Copyright (C) 2010-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

static gpointer vala_gd_bus_module_parent_class = NULL;

static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static gboolean vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self,
                                                ValaDataType* type);
static ValaCCodeExpression* vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self,
                                                             ValaDataType* type,
                                                             ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self,
                                                                     ValaDataType* type,
                                                                     ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_get_method_info (ValaGDBusModule* self,
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_signal_info (ValaGDBusModule* self,
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_property_info (ValaGDBusModule* self,
                                                           ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self,
                                                ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self,
                                                  ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);

gchar*
vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol)
{
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	result = _tmp0_;
	return result;
}

gchar*
vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol)
{
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	dbus_name = _tmp0_;
	_tmp1_ = dbus_name;
	if (_tmp1_ != NULL) {
		result = dbus_name;
		return result;
	}
	_tmp2_ = vala_symbol_get_name (symbol);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_lower_case_to_camel_case (_tmp3_);
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}

gint
vala_gd_bus_module_get_dbus_timeout_for_member (ValaSymbol* symbol)
{
	gint result = 0;
	g_return_val_if_fail (symbol != NULL, 0);
	result = vala_code_node_get_attribute_integer ((ValaCodeNode*) symbol, "DBus", "timeout", -1);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

gboolean
vala_gd_bus_module_is_dbus_visible (ValaCodeNode* node)
{
	ValaAttribute* dbus_attribute = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaAttribute* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (node, "DBus");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	dbus_attribute = _tmp1_;
	_tmp4_ = dbus_attribute;
	if (_tmp4_ != NULL) {
		ValaAttribute* _tmp5_;
		_tmp5_ = dbus_attribute;
		_tmp3_ = vala_attribute_has_argument (_tmp5_, "visible");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaAttribute* _tmp6_;
		_tmp6_ = dbus_attribute;
		_tmp2_ = !vala_attribute_get_bool (_tmp6_, "visible", FALSE);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_vala_code_node_unref0 (dbus_attribute);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (dbus_attribute);
	return result;
}

gboolean
vala_gd_bus_module_is_dbus_no_reply (ValaMethod* m)
{
	gboolean result = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "no_reply", FALSE);
	return result;
}

gchar*
vala_gd_bus_module_dbus_result_name (ValaMethod* m)
{
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "DBus", "result", NULL);
	dbus_name = _tmp0_;
	_tmp2_ = dbus_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = dbus_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = dbus_name;
		return result;
	}
	_tmp4_ = g_strdup ("result");
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}

static void
vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGDBusModule * self;
	gchar* edomain_dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaCCodeFile* _tmp2_;
	ValaCCodeFile* _tmp3_;
	ValaCCodeInitializerList* error_entries = NULL;
	ValaCCodeInitializerList* _tmp6_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp38_;
	ValaCCodeDeclaration* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	ValaCCodeInitializerList* _tmp44_;
	ValaCCodeVariableDeclarator* _tmp45_;
	ValaCCodeVariableDeclarator* _tmp46_;
	ValaCCodeDeclaration* _tmp47_;
	ValaCCodeFile* _tmp48_;
	ValaCCodeDeclaration* _tmp49_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunction* _tmp62_;
	gchar* quark_name = NULL;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	ValaCCodeFunction* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	const gchar* _tmp69_;
	ValaCCodeConstant* _tmp70_;
	ValaCCodeConstant* _tmp71_;
	ValaCCodeVariableDeclarator* _tmp72_;
	ValaCCodeVariableDeclarator* _tmp73_;
	ValaCCodeFunctionCall* register_call = NULL;
	ValaCCodeIdentifier* _tmp74_;
	ValaCCodeIdentifier* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* _tmp77_;
	ValaCCodeFunctionCall* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	ValaCCodeConstant* _tmp85_;
	ValaCCodeConstant* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	const gchar* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeUnaryExpression* _tmp91_;
	ValaCCodeUnaryExpression* _tmp92_;
	ValaCCodeFunctionCall* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	ValaCCodeIdentifier* _tmp98_;
	ValaCCodeIdentifier* _tmp99_;
	ValaCCodeFunctionCall* nentries = NULL;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunctionCall* _tmp111_;
	ValaCCodeFunctionCall* _tmp112_;
	ValaCCodeFunction* _tmp113_;
	ValaCCodeFunction* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	const gchar* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeCastExpression* _tmp121_;
	ValaCCodeCastExpression* _tmp122_;
	ValaCCodeFile* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) edomain);
	edomain_dbus_name = _tmp0_;
	_tmp1_ = edomain_dbus_name;
	if (_tmp1_ == NULL) {
		VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_error_domain ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), edomain);
		_g_free0 (edomain_dbus_name);
		return;
	}
	_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp2_, "gio/gio.h", FALSE);
	_tmp3_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp3_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp4_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp5_;
		_tmp5_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp5_);
	}
	_tmp6_ = vala_ccode_initializer_list_new ();
	error_entries = _tmp6_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp7_;
		gint _ecode_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _ecode_index = 0;
		_tmp7_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp7_;
		_tmp8_ = _ecode_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_ecode_size = _tmp10_;
		_ecode_index = -1;
		while (TRUE) {
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			gchar* ecode_dbus_name = NULL;
			ValaErrorCode* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			ValaCCodeInitializerList* error_entry = NULL;
			ValaCCodeInitializerList* _tmp22_;
			ValaCCodeInitializerList* _tmp23_;
			ValaErrorCode* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaCCodeIdentifier* _tmp27_;
			ValaCCodeIdentifier* _tmp28_;
			ValaCCodeInitializerList* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeConstant* _tmp34_;
			ValaCCodeConstant* _tmp35_;
			ValaCCodeInitializerList* _tmp36_;
			ValaCCodeInitializerList* _tmp37_;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp11_ = _ecode_list;
			_tmp12_ = vala_list_get (_tmp11_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp12_;
			_tmp13_ = ecode;
			_tmp14_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) _tmp13_);
			ecode_dbus_name = _tmp14_;
			_tmp15_ = ecode_dbus_name;
			if (_tmp15_ == NULL) {
				ValaErrorCode* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp16_ = ecode;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) -1);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_symbol_lower_case_to_camel_case (_tmp20_);
				_g_free0 (ecode_dbus_name);
				ecode_dbus_name = _tmp21_;
				_g_free0 (_tmp20_);
			}
			_tmp22_ = vala_ccode_initializer_list_new ();
			error_entry = _tmp22_;
			_tmp23_ = error_entry;
			_tmp24_ = ecode;
			_tmp25_ = vala_get_ccode_name ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_ccode_identifier_new (_tmp26_);
			_tmp28_ = _tmp27_;
			vala_ccode_initializer_list_append (_tmp23_, (ValaCCodeExpression*) _tmp28_);
			_vala_ccode_node_unref0 (_tmp28_);
			_g_free0 (_tmp26_);
			_tmp29_ = error_entry;
			_tmp30_ = edomain_dbus_name;
			_tmp31_ = ecode_dbus_name;
			_tmp32_ = g_strdup_printf ("\"%s.%s\"", _tmp30_, _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_constant_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_initializer_list_append (_tmp29_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = error_entries;
			_tmp37_ = error_entry;
			vala_ccode_initializer_list_append (_tmp36_, (ValaCCodeExpression*) _tmp37_);
			_vala_ccode_node_unref0 (error_entry);
			_g_free0 (ecode_dbus_name);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp38_ = vala_ccode_declaration_new ("const GDBusErrorEntry");
	_cdecl_ = _tmp38_;
	_tmp39_ = _cdecl_;
	_tmp40_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp41_, "_entries[]", NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = error_entries;
	_tmp45_ = vala_ccode_variable_declarator_new (_tmp43_, (ValaCCodeExpression*) _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	vala_ccode_declaration_add_declarator (_tmp39_, (ValaCCodeDeclarator*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_tmp47_ = _cdecl_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp47_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp48_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp49_ = _cdecl_;
	vala_ccode_file_add_constant_declaration (_tmp48_, (ValaCCodeNode*) _tmp49_);
	_tmp50_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat (_tmp51_, "quark", NULL);
	_tmp53_ = _tmp52_;
	_g_free0 (_tmp51_);
	quark_fun_name = _tmp53_;
	_tmp54_ = quark_fun_name;
	_tmp55_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_get_ccode_name ((ValaCodeNode*) _tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_function_new (_tmp54_, _tmp59_);
	_tmp61_ = _tmp60_;
	_g_free0 (_tmp59_);
	cquark_fun = _tmp61_;
	_tmp62_ = cquark_fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp62_);
	_tmp63_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp64_ = _tmp63_;
	_tmp65_ = g_strdup_printf ("%squark_volatile", _tmp64_);
	_tmp66_ = _tmp65_;
	_g_free0 (_tmp64_);
	quark_name = _tmp66_;
	_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp68_ = _tmp67_;
	_tmp69_ = quark_name;
	_tmp70_ = vala_ccode_constant_new ("0");
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_ccode_variable_declarator_new (_tmp69_, (ValaCCodeExpression*) _tmp71_, NULL);
	_tmp73_ = _tmp72_;
	vala_ccode_function_add_declaration (_tmp68_, "gsize", (ValaCCodeDeclarator*) _tmp73_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
	_vala_ccode_node_unref0 (_tmp73_);
	_vala_ccode_node_unref0 (_tmp71_);
	_tmp74_ = vala_ccode_identifier_new ("g_dbus_error_register_error_domain");
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp75_);
	_tmp77_ = _tmp76_;
	_vala_ccode_node_unref0 (_tmp75_);
	register_call = _tmp77_;
	_tmp78_ = register_call;
	_tmp79_ = vala_get_ccode_quark_name (edomain);
	_tmp80_ = _tmp79_;
	_tmp81_ = g_strconcat ("\"", _tmp80_, NULL);
	_tmp82_ = _tmp81_;
	_tmp83_ = g_strconcat (_tmp82_, "\"", NULL);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_ccode_constant_new (_tmp84_);
	_tmp86_ = _tmp85_;
	vala_ccode_function_call_add_argument (_tmp78_, (ValaCCodeExpression*) _tmp86_);
	_vala_ccode_node_unref0 (_tmp86_);
	_g_free0 (_tmp84_);
	_g_free0 (_tmp82_);
	_g_free0 (_tmp80_);
	_tmp87_ = register_call;
	_tmp88_ = quark_name;
	_tmp89_ = vala_ccode_identifier_new (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp90_);
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp93_ = register_call;
	_tmp94_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp95_ = _tmp94_;
	_tmp96_ = g_strconcat (_tmp95_, "_entries", NULL);
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_identifier_new (_tmp97_);
	_tmp99_ = _tmp98_;
	vala_ccode_function_call_add_argument (_tmp93_, (ValaCCodeExpression*) _tmp99_);
	_vala_ccode_node_unref0 (_tmp99_);
	_g_free0 (_tmp97_);
	_g_free0 (_tmp95_);
	_tmp100_ = vala_ccode_identifier_new ("G_N_ELEMENTS");
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp101_);
	_tmp103_ = _tmp102_;
	_vala_ccode_node_unref0 (_tmp101_);
	nentries = _tmp103_;
	_tmp104_ = nentries;
	_tmp105_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp106_ = _tmp105_;
	_tmp107_ = g_strconcat (_tmp106_, "_entries", NULL);
	_tmp108_ = _tmp107_;
	_tmp109_ = vala_ccode_identifier_new (_tmp108_);
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_g_free0 (_tmp108_);
	_g_free0 (_tmp106_);
	_tmp111_ = register_call;
	_tmp112_ = nentries;
	vala_ccode_function_call_add_argument (_tmp111_, (ValaCCodeExpression*) _tmp112_);
	_tmp113_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp114_ = _tmp113_;
	_tmp115_ = register_call;
	vala_ccode_function_add_expression (_tmp114_, (ValaCCodeExpression*) _tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = quark_name;
	_tmp119_ = vala_ccode_identifier_new (_tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp120_, "GQuark");
	_tmp122_ = _tmp121_;
	vala_ccode_function_add_return (_tmp117_, (ValaCCodeExpression*) _tmp122_);
	_vala_ccode_node_unref0 (_tmp122_);
	_vala_ccode_node_unref0 (_tmp120_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp123_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp124_ = cquark_fun;
	vala_ccode_file_add_function (_tmp123_, _tmp124_);
	_vala_ccode_node_unref0 (nentries);
	_vala_ccode_node_unref0 (register_call);
	_g_free0 (quark_name);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (error_entries);
	_g_free0 (edomain_dbus_name);
}

static gboolean
vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = vala_data_type_get_data_type (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp2_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = vala_data_type_get_data_type (type);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp2_ = g_strcmp0 (_tmp11_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp11_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = vala_data_type_get_data_type (type);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp1_ = g_strcmp0 (_tmp15_, "GLib.Socket") == 0;
			_g_free0 (_tmp15_);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = vala_data_type_get_data_type (type);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp0_ = g_strcmp0 (_tmp19_, "GLib.FileDescriptorBased") == 0;
			_g_free0 (_tmp19_);
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_gd_bus_module_dbus_method_uses_file_descriptor (ValaGDBusModule* self,
                                                     ValaMethod* method)
{
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (method != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) method);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaParameter* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValaParameter*) _tmp5_;
			_tmp6_ = param;
			_tmp7_ = vala_variable_get_variable_type ((ValaVariable*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (vala_gd_bus_module_is_file_descriptor (self, _tmp8_)) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp9_ = vala_callable_get_return_type ((ValaCallable*) method);
	_tmp10_ = _tmp9_;
	if (vala_gd_bus_module_is_file_descriptor (self, _tmp10_)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static ValaCCodeExpression*
vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self,
                                        ValaDataType* type,
                                        ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_get_fd");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			result = (ValaCCodeExpression*) _result_;
			return result;
		} else {
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp10_ = vala_data_type_get_data_type (type);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp15_;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeFunctionCall* _tmp17_;
				ValaCCodeFunctionCall* _tmp18_;
				ValaCCodeFunctionCall* _tmp19_;
				_tmp15_ = vala_ccode_identifier_new ("g_unix_output_stream_get_fd");
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp16_);
				_tmp18_ = _tmp17_;
				_vala_ccode_node_unref0 (_tmp16_);
				_result_ = _tmp18_;
				_tmp19_ = _result_;
				vala_ccode_function_call_add_argument (_tmp19_, expr);
				result = (ValaCCodeExpression*) _result_;
				return result;
			} else {
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp20_ = vala_data_type_get_data_type (type);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "GLib.Socket") == 0;
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp25_;
					ValaCCodeIdentifier* _tmp26_;
					ValaCCodeFunctionCall* _tmp27_;
					ValaCCodeFunctionCall* _tmp28_;
					ValaCCodeFunctionCall* _tmp29_;
					_tmp25_ = vala_ccode_identifier_new ("g_socket_get_fd");
					_tmp26_ = _tmp25_;
					_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp26_);
					_tmp28_ = _tmp27_;
					_vala_ccode_node_unref0 (_tmp26_);
					_result_ = _tmp28_;
					_tmp29_ = _result_;
					vala_ccode_function_call_add_argument (_tmp29_, expr);
					result = (ValaCCodeExpression*) _result_;
					return result;
				} else {
					ValaTypeSymbol* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gboolean _tmp34_;
					_tmp30_ = vala_data_type_get_data_type (type);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strcmp0 (_tmp33_, "GLib.FileDescriptorBased") == 0;
					_g_free0 (_tmp33_);
					if (_tmp34_) {
						ValaCCodeFunctionCall* _result_ = NULL;
						ValaCCodeIdentifier* _tmp35_;
						ValaCCodeIdentifier* _tmp36_;
						ValaCCodeFunctionCall* _tmp37_;
						ValaCCodeFunctionCall* _tmp38_;
						ValaCCodeFunctionCall* _tmp39_;
						_tmp35_ = vala_ccode_identifier_new ("g_file_descriptor_based_get_fd");
						_tmp36_ = _tmp35_;
						_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
						_tmp38_ = _tmp37_;
						_vala_ccode_node_unref0 (_tmp36_);
						_result_ = _tmp38_;
						_tmp39_ = _result_;
						vala_ccode_function_call_add_argument (_tmp39_, expr);
						result = (ValaCCodeExpression*) _result_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
vala_gd_bus_module_send_dbus_value (ValaGDBusModule* self,
                                    ValaDataType* type,
                                    ValaCCodeExpression* builder_expr,
                                    ValaCCodeExpression* expr,
                                    ValaSymbol* sym)
{
	ValaCCodeExpression* fd = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (builder_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_gd_bus_module_get_file_descriptor (self, type, expr);
	fd = _tmp0_;
	_tmp1_ = fd;
	if (_tmp1_ != NULL) {
		ValaCCodeFunctionCall* fd_append = NULL;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		ValaCCodeFunctionCall* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeExpression* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeConstant* _tmp12_;
		ValaCCodeConstant* _tmp13_;
		ValaCCodeFunctionCall* builder_add = NULL;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeUnaryExpression* _tmp19_;
		ValaCCodeUnaryExpression* _tmp20_;
		ValaCCodeFunctionCall* _tmp21_;
		ValaCCodeConstant* _tmp22_;
		ValaCCodeConstant* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeFunctionCall* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunctionCall* _tmp28_;
		_tmp2_ = vala_ccode_identifier_new ("g_unix_fd_list_append");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		fd_append = _tmp5_;
		_tmp6_ = fd_append;
		_tmp7_ = vala_ccode_identifier_new ("_fd_list");
		_tmp8_ = _tmp7_;
		vala_ccode_function_call_add_argument (_tmp6_, (ValaCCodeExpression*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
		_tmp9_ = fd_append;
		_tmp10_ = fd;
		vala_ccode_function_call_add_argument (_tmp9_, _tmp10_);
		_tmp11_ = fd_append;
		_tmp12_ = vala_ccode_constant_new ("NULL");
		_tmp13_ = _tmp12_;
		vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_tmp14_ = vala_ccode_identifier_new ("g_variant_builder_add");
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		_vala_ccode_node_unref0 (_tmp15_);
		builder_add = _tmp17_;
		_tmp18_ = builder_add;
		_tmp19_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, builder_expr);
		_tmp20_ = _tmp19_;
		vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
		_vala_ccode_node_unref0 (_tmp20_);
		_tmp21_ = builder_add;
		_tmp22_ = vala_ccode_constant_new ("\"h\"");
		_tmp23_ = _tmp22_;
		vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = builder_add;
		_tmp25_ = fd_append;
		vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp25_);
		_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = builder_add;
		vala_ccode_function_add_expression (_tmp27_, (ValaCCodeExpression*) _tmp28_);
		_vala_ccode_node_unref0 (builder_add);
		_vala_ccode_node_unref0 (fd_append);
	} else {
		vala_gvariant_module_write_expression ((ValaGVariantModule*) self, type, builder_expr, expr, sym);
	}
	_vala_ccode_node_unref0 (fd);
}

static ValaCCodeExpression*
vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self,
                                                ValaDataType* type,
                                                ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			ValaCCodeFunctionCall* _tmp10_;
			ValaCCodeConstant* _tmp11_;
			ValaCCodeConstant* _tmp12_;
			ValaCCodeFunctionCall* _tmp13_;
			ValaCCodeCastExpression* _tmp14_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_new");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			_tmp10_ = _result_;
			_tmp11_ = vala_ccode_constant_new ("TRUE");
			_tmp12_ = _tmp11_;
			vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
			_vala_ccode_node_unref0 (_tmp12_);
			_tmp13_ = _result_;
			_tmp14_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp13_, "GUnixInputStream *");
			result = (ValaCCodeExpression*) _tmp14_;
			_vala_ccode_node_unref0 (_result_);
			return result;
		} else {
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp15_ = vala_data_type_get_data_type (type);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp20_;
				ValaCCodeIdentifier* _tmp21_;
				ValaCCodeFunctionCall* _tmp22_;
				ValaCCodeFunctionCall* _tmp23_;
				ValaCCodeFunctionCall* _tmp24_;
				ValaCCodeFunctionCall* _tmp25_;
				ValaCCodeConstant* _tmp26_;
				ValaCCodeConstant* _tmp27_;
				ValaCCodeFunctionCall* _tmp28_;
				ValaCCodeCastExpression* _tmp29_;
				_tmp20_ = vala_ccode_identifier_new ("g_unix_output_stream_new");
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
				_tmp23_ = _tmp22_;
				_vala_ccode_node_unref0 (_tmp21_);
				_result_ = _tmp23_;
				_tmp24_ = _result_;
				vala_ccode_function_call_add_argument (_tmp24_, expr);
				_tmp25_ = _result_;
				_tmp26_ = vala_ccode_constant_new ("TRUE");
				_tmp27_ = _tmp26_;
				vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
				_vala_ccode_node_unref0 (_tmp27_);
				_tmp28_ = _result_;
				_tmp29_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp28_, "GUnixOutputStream *");
				result = (ValaCCodeExpression*) _tmp29_;
				_vala_ccode_node_unref0 (_result_);
				return result;
			} else {
				ValaTypeSymbol* _tmp30_;
				ValaTypeSymbol* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gboolean _tmp34_;
				_tmp30_ = vala_data_type_get_data_type (type);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strcmp0 (_tmp33_, "GLib.Socket") == 0;
				_g_free0 (_tmp33_);
				if (_tmp34_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp35_;
					ValaCCodeIdentifier* _tmp36_;
					ValaCCodeFunctionCall* _tmp37_;
					ValaCCodeFunctionCall* _tmp38_;
					ValaCCodeFunctionCall* _tmp39_;
					ValaCCodeFunctionCall* _tmp40_;
					ValaCCodeConstant* _tmp41_;
					ValaCCodeConstant* _tmp42_;
					_tmp35_ = vala_ccode_identifier_new ("g_socket_new_from_fd");
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
					_tmp38_ = _tmp37_;
					_vala_ccode_node_unref0 (_tmp36_);
					_result_ = _tmp38_;
					_tmp39_ = _result_;
					vala_ccode_function_call_add_argument (_tmp39_, expr);
					_tmp40_ = _result_;
					_tmp41_ = vala_ccode_constant_new ("NULL");
					_tmp42_ = _tmp41_;
					vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
					_vala_ccode_node_unref0 (_tmp42_);
					result = (ValaCCodeExpression*) _result_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
vala_gd_bus_module_receive_dbus_value (ValaGDBusModule* self,
                                       ValaDataType* type,
                                       ValaCCodeExpression* message_expr,
                                       ValaCCodeExpression* iter_expr,
                                       ValaCCodeExpression* target_expr,
                                       ValaSymbol* sym,
                                       ValaCCodeExpression* error_expr,
                                       gboolean* may_fail)
{
	gboolean _vala_may_fail = FALSE;
	ValaCCodeFunctionCall* fd_list = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* fd_var = NULL;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeExpression* stream = NULL;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (message_expr != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (target_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_dbus_message_get_unix_fd_list");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	fd_list = _tmp3_;
	_tmp4_ = fd_list;
	vala_ccode_function_call_add_argument (_tmp4_, message_expr);
	_tmp5_ = vala_ccode_identifier_new ("_fd");
	fd_var = _tmp5_;
	_tmp6_ = fd_var;
	_tmp7_ = vala_gd_bus_module_create_from_file_descriptor (self, type, (ValaCCodeExpression*) _tmp6_);
	stream = _tmp7_;
	_tmp8_ = stream;
	if (_tmp8_ != NULL) {
		ValaCCodeIdentifier* fd_list_var = NULL;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* fd = NULL;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		ValaCCodeFunctionCall* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeFunctionCall* get_fd = NULL;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeFunctionCall* _tmp29_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeUnaryExpression* _tmp32_;
		ValaCCodeUnaryExpression* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeConstant* _tmp35_;
		ValaCCodeConstant* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeUnaryExpression* _tmp40_;
		ValaCCodeUnaryExpression* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunction* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunction* _tmp45_;
		ValaCCodeFunction* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeFunction* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeConstant* _tmp52_;
		ValaCCodeConstant* _tmp53_;
		ValaCCodeBinaryExpression* _tmp54_;
		ValaCCodeBinaryExpression* _tmp55_;
		ValaCCodeFunction* _tmp56_;
		ValaCCodeFunction* _tmp57_;
		ValaCCodeExpression* _tmp58_;
		ValaCCodeFunction* _tmp59_;
		ValaCCodeFunction* _tmp60_;
		ValaCCodeFunction* _tmp61_;
		ValaCCodeFunction* _tmp62_;
		ValaCCodeFunctionCall* set_error = NULL;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunctionCall* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeFunctionCall* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeIdentifier* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeConstant* _tmp75_;
		ValaCCodeConstant* _tmp76_;
		ValaCCodeFunction* _tmp77_;
		ValaCCodeFunction* _tmp78_;
		ValaCCodeFunctionCall* _tmp79_;
		ValaCCodeFunction* _tmp80_;
		ValaCCodeFunction* _tmp81_;
		_tmp9_ = vala_ccode_identifier_new ("_fd_list");
		fd_list_var = _tmp9_;
		_tmp10_ = vala_ccode_identifier_new ("g_unix_fd_list_get");
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_ccode_node_unref0 (_tmp11_);
		fd = _tmp13_;
		_tmp14_ = fd;
		_tmp15_ = fd_list_var;
		vala_ccode_function_call_add_argument (_tmp14_, (ValaCCodeExpression*) _tmp15_);
		_tmp16_ = fd;
		_tmp17_ = vala_ccode_identifier_new ("_fd_index");
		_tmp18_ = _tmp17_;
		vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
		_vala_ccode_node_unref0 (_tmp18_);
		_tmp19_ = fd;
		vala_ccode_function_call_add_argument (_tmp19_, error_expr);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = fd_list_var;
		_tmp23_ = fd_list;
		vala_ccode_function_add_assignment (_tmp21_, (ValaCCodeExpression*) _tmp22_, (ValaCCodeExpression*) _tmp23_);
		_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = fd_list_var;
		vala_ccode_function_open_if (_tmp25_, (ValaCCodeExpression*) _tmp26_);
		_tmp27_ = vala_ccode_identifier_new ("g_variant_iter_next");
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp28_);
		_tmp30_ = _tmp29_;
		_vala_ccode_node_unref0 (_tmp28_);
		get_fd = _tmp30_;
		_tmp31_ = get_fd;
		_tmp32_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr);
		_tmp33_ = _tmp32_;
		vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
		_vala_ccode_node_unref0 (_tmp33_);
		_tmp34_ = get_fd;
		_tmp35_ = vala_ccode_constant_new ("\"h\"");
		_tmp36_ = _tmp35_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = get_fd;
		_tmp38_ = vala_ccode_identifier_new ("_fd_index");
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_vala_ccode_node_unref0 (_tmp39_);
		_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = get_fd;
		vala_ccode_function_add_expression (_tmp43_, (ValaCCodeExpression*) _tmp44_);
		_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = fd_var;
		_tmp48_ = fd;
		vala_ccode_function_add_assignment (_tmp46_, (ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_);
		_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = fd_var;
		_tmp52_ = vala_ccode_constant_new ("0");
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, (ValaCCodeExpression*) _tmp51_, (ValaCCodeExpression*) _tmp53_);
		_tmp55_ = _tmp54_;
		vala_ccode_function_open_if (_tmp50_, (ValaCCodeExpression*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
		_vala_ccode_node_unref0 (_tmp53_);
		_tmp56_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp57_ = _tmp56_;
		_tmp58_ = stream;
		vala_ccode_function_add_assignment (_tmp57_, target_expr, _tmp58_);
		_vala_may_fail = TRUE;
		_tmp59_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp60_ = _tmp59_;
		vala_ccode_function_close (_tmp60_);
		_tmp61_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp62_ = _tmp61_;
		vala_ccode_function_add_else (_tmp62_);
		_tmp63_ = vala_ccode_identifier_new ("g_set_error_literal");
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
		_tmp66_ = _tmp65_;
		_vala_ccode_node_unref0 (_tmp64_);
		set_error = _tmp66_;
		_tmp67_ = set_error;
		vala_ccode_function_call_add_argument (_tmp67_, error_expr);
		_tmp68_ = set_error;
		_tmp69_ = vala_ccode_identifier_new ("G_IO_ERROR");
		_tmp70_ = _tmp69_;
		vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp70_);
		_vala_ccode_node_unref0 (_tmp70_);
		_tmp71_ = set_error;
		_tmp72_ = vala_ccode_identifier_new ("G_IO_ERROR_FAILED");
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_tmp74_ = set_error;
		_tmp75_ = vala_ccode_constant_new ("\"FD List is NULL\"");
		_tmp76_ = _tmp75_;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
		_tmp77_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = set_error;
		vala_ccode_function_add_expression (_tmp78_, (ValaCCodeExpression*) _tmp79_);
		_tmp80_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp81_ = _tmp80_;
		vala_ccode_function_close (_tmp81_);
		_vala_ccode_node_unref0 (set_error);
		_vala_ccode_node_unref0 (get_fd);
		_vala_ccode_node_unref0 (fd);
		_vala_ccode_node_unref0 (fd_list_var);
	} else {
		gboolean _tmp82_ = FALSE;
		vala_gvariant_module_read_expression ((ValaGVariantModule*) self, type, iter_expr, target_expr, sym, error_expr, &_tmp82_);
		_vala_may_fail = _tmp82_;
	}
	_vala_ccode_node_unref0 (stream);
	_vala_ccode_node_unref0 (fd_var);
	_vala_ccode_node_unref0 (fd_list);
	if (may_fail) {
		*may_fail = _vala_may_fail;
	}
}

static ValaCCodeExpression*
vala_gd_bus_module_get_method_info (ValaGDBusModule* self,
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp359_;
	ValaCCodeConstant* _tmp360_;
	ValaCCodeConstant* _tmp361_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp362_;
	gchar* _tmp363_;
	gchar* _tmp364_;
	gchar* _tmp365_;
	gchar* _tmp366_;
	gchar* _tmp367_;
	gchar* _tmp368_;
	ValaCCodeInitializerList* _tmp369_;
	ValaCCodeVariableDeclarator* _tmp370_;
	ValaCCodeVariableDeclarator* _tmp371_;
	ValaCCodeFile* _tmp372_;
	gchar* _tmp373_;
	gchar* _tmp374_;
	gchar* _tmp375_;
	gchar* _tmp376_;
	gchar* _tmp377_;
	gchar* _tmp378_;
	ValaCCodeIdentifier* _tmp379_;
	ValaCCodeExpression* _tmp380_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp1_;
		gint _m_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _m_index = 0;
		_tmp1_ = vala_object_type_symbol_get_methods (sym);
		_m_list = _tmp1_;
		_tmp2_ = _m_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_m_size = _tmp4_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaMethod* _tmp10_;
			ValaMethod* _tmp20_;
			ValaCCodeInitializerList* in_args_info = NULL;
			ValaCCodeInitializerList* _tmp21_;
			ValaCCodeInitializerList* out_args_info = NULL;
			ValaCCodeInitializerList* _tmp22_;
			ValaMethod* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaCCodeInitializerList* _tmp221_;
			ValaCCodeConstant* _tmp222_;
			ValaCCodeConstant* _tmp223_;
			ValaCCodeInitializerList* _tmp224_;
			ValaCCodeConstant* _tmp225_;
			ValaCCodeConstant* _tmp226_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp227_;
			ValaCCodeDeclaration* _tmp228_;
			gchar* _tmp229_;
			gchar* _tmp230_;
			gchar* _tmp231_;
			gchar* _tmp232_;
			gchar* _tmp233_;
			gchar* _tmp234_;
			ValaMethod* _tmp235_;
			const gchar* _tmp236_;
			const gchar* _tmp237_;
			gchar* _tmp238_;
			gchar* _tmp239_;
			gchar* _tmp240_;
			gchar* _tmp241_;
			ValaCCodeInitializerList* _tmp242_;
			ValaCCodeVariableDeclarator* _tmp243_;
			ValaCCodeVariableDeclarator* _tmp244_;
			ValaCCodeDeclaration* _tmp245_;
			ValaCCodeFile* _tmp246_;
			ValaCCodeDeclaration* _tmp247_;
			ValaCCodeDeclaration* _tmp248_;
			ValaCCodeDeclaration* _tmp249_;
			gchar* _tmp250_;
			gchar* _tmp251_;
			gchar* _tmp252_;
			gchar* _tmp253_;
			gchar* _tmp254_;
			gchar* _tmp255_;
			ValaMethod* _tmp256_;
			const gchar* _tmp257_;
			const gchar* _tmp258_;
			gchar* _tmp259_;
			gchar* _tmp260_;
			gchar* _tmp261_;
			gchar* _tmp262_;
			ValaCCodeInitializerList* _tmp263_;
			ValaCCodeVariableDeclarator* _tmp264_;
			ValaCCodeVariableDeclarator* _tmp265_;
			ValaCCodeDeclaration* _tmp266_;
			ValaCCodeFile* _tmp267_;
			ValaCCodeDeclaration* _tmp268_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp269_;
			ValaCCodeInitializerList* _tmp270_;
			ValaCCodeConstant* _tmp271_;
			ValaCCodeConstant* _tmp272_;
			ValaCCodeInitializerList* _tmp273_;
			ValaMethod* _tmp274_;
			gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			ValaCCodeConstant* _tmp279_;
			ValaCCodeConstant* _tmp280_;
			ValaCCodeInitializerList* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			gchar* _tmp287_;
			ValaMethod* _tmp288_;
			const gchar* _tmp289_;
			const gchar* _tmp290_;
			gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			gchar* _tmp294_;
			ValaCCodeIdentifier* _tmp295_;
			ValaCCodeIdentifier* _tmp296_;
			ValaCCodeUnaryExpression* _tmp297_;
			ValaCCodeUnaryExpression* _tmp298_;
			ValaCCodeCastExpression* _tmp299_;
			ValaCCodeCastExpression* _tmp300_;
			ValaCCodeInitializerList* _tmp301_;
			gchar* _tmp302_;
			gchar* _tmp303_;
			gchar* _tmp304_;
			gchar* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			ValaMethod* _tmp308_;
			const gchar* _tmp309_;
			const gchar* _tmp310_;
			gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			gchar* _tmp314_;
			ValaCCodeIdentifier* _tmp315_;
			ValaCCodeIdentifier* _tmp316_;
			ValaCCodeUnaryExpression* _tmp317_;
			ValaCCodeUnaryExpression* _tmp318_;
			ValaCCodeCastExpression* _tmp319_;
			ValaCCodeCastExpression* _tmp320_;
			ValaCCodeInitializerList* _tmp321_;
			ValaCCodeConstant* _tmp322_;
			ValaCCodeConstant* _tmp323_;
			ValaCCodeDeclaration* _tmp324_;
			ValaCCodeDeclaration* _tmp325_;
			gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			gchar* _tmp329_;
			gchar* _tmp330_;
			gchar* _tmp331_;
			ValaMethod* _tmp332_;
			const gchar* _tmp333_;
			const gchar* _tmp334_;
			gchar* _tmp335_;
			gchar* _tmp336_;
			ValaCCodeInitializerList* _tmp337_;
			ValaCCodeVariableDeclarator* _tmp338_;
			ValaCCodeVariableDeclarator* _tmp339_;
			ValaCCodeDeclaration* _tmp340_;
			ValaCCodeFile* _tmp341_;
			ValaCCodeDeclaration* _tmp342_;
			ValaCCodeInitializerList* _tmp343_;
			gchar* _tmp344_;
			gchar* _tmp345_;
			gchar* _tmp346_;
			gchar* _tmp347_;
			gchar* _tmp348_;
			gchar* _tmp349_;
			ValaMethod* _tmp350_;
			const gchar* _tmp351_;
			const gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			ValaCCodeIdentifier* _tmp355_;
			ValaCCodeIdentifier* _tmp356_;
			ValaCCodeUnaryExpression* _tmp357_;
			ValaCCodeUnaryExpression* _tmp358_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp5_ = _m_list;
			_tmp6_ = vala_list_get (_tmp5_, _m_index);
			m = (ValaMethod*) _tmp6_;
			_tmp10_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_CREATION_METHOD)) {
				_tmp9_ = TRUE;
			} else {
				ValaMethod* _tmp11_;
				ValaMemberBinding _tmp12_;
				ValaMemberBinding _tmp13_;
				_tmp11_ = m;
				_tmp12_ = vala_method_get_binding (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp9_ = _tmp13_ != VALA_MEMBER_BINDING_INSTANCE;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				ValaMethod* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = m;
				_tmp15_ = vala_method_get_overrides (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp8_ = _tmp16_;
			}
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				ValaMethod* _tmp17_;
				ValaSymbolAccessibility _tmp18_;
				ValaSymbolAccessibility _tmp19_;
				_tmp17_ = m;
				_tmp18_ = vala_symbol_get_access ((ValaSymbol*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp7_ = _tmp19_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp20_ = m;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp20_)) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp21_ = vala_ccode_initializer_list_new ();
			in_args_info = _tmp21_;
			_tmp22_ = vala_ccode_initializer_list_new ();
			out_args_info = _tmp22_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp23_;
				ValaList* _tmp24_;
				gint _param_size = 0;
				ValaList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _param_index = 0;
				_tmp23_ = m;
				_tmp24_ = vala_callable_get_parameters ((ValaCallable*) _tmp23_);
				_param_list = _tmp24_;
				_tmp25_ = _param_list;
				_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_param_size = _tmp27_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp28_;
					gpointer _tmp29_;
					gboolean _tmp30_ = FALSE;
					ValaParameter* _tmp31_;
					ValaDataType* _tmp32_;
					ValaDataType* _tmp33_;
					gboolean _tmp41_ = FALSE;
					ValaParameter* _tmp42_;
					ValaDataType* _tmp43_;
					ValaDataType* _tmp44_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp52_;
					ValaCCodeInitializerList* _tmp53_;
					ValaCCodeConstant* _tmp54_;
					ValaCCodeConstant* _tmp55_;
					ValaCCodeInitializerList* _tmp56_;
					ValaParameter* _tmp57_;
					const gchar* _tmp58_;
					const gchar* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					ValaCCodeConstant* _tmp62_;
					ValaCCodeConstant* _tmp63_;
					ValaCCodeInitializerList* _tmp64_;
					ValaParameter* _tmp65_;
					ValaDataType* _tmp66_;
					ValaDataType* _tmp67_;
					ValaParameter* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					ValaCCodeConstant* _tmp73_;
					ValaCCodeConstant* _tmp74_;
					ValaCCodeInitializerList* _tmp75_;
					ValaCCodeConstant* _tmp76_;
					ValaCCodeConstant* _tmp77_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp78_;
					ValaCCodeDeclaration* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					ValaMethod* _tmp86_;
					const gchar* _tmp87_;
					const gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					ValaParameter* _tmp93_;
					const gchar* _tmp94_;
					const gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					ValaCCodeInitializerList* _tmp98_;
					ValaCCodeVariableDeclarator* _tmp99_;
					ValaCCodeVariableDeclarator* _tmp100_;
					ValaCCodeDeclaration* _tmp101_;
					ValaCCodeFile* _tmp102_;
					ValaCCodeDeclaration* _tmp103_;
					ValaParameter* _tmp104_;
					ValaParameterDirection _tmp105_;
					ValaParameterDirection _tmp106_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp28_ = _param_list;
					_tmp29_ = vala_list_get (_tmp28_, _param_index);
					param = (ValaParameter*) _tmp29_;
					_tmp31_ = param;
					_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
					_tmp33_ = _tmp32_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp34_;
						ValaDataType* _tmp35_;
						ValaDataType* _tmp36_;
						ValaTypeSymbol* _tmp37_;
						ValaTypeSymbol* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp34_ = param;
						_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) _tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = vala_data_type_get_data_type (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp30_ = g_strcmp0 (_tmp40_, "GLib.Cancellable") == 0;
						_g_free0 (_tmp40_);
					} else {
						_tmp30_ = FALSE;
					}
					if (_tmp30_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp42_ = param;
					_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
					_tmp44_ = _tmp43_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp45_;
						ValaDataType* _tmp46_;
						ValaDataType* _tmp47_;
						ValaTypeSymbol* _tmp48_;
						ValaTypeSymbol* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						_tmp45_ = param;
						_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = vala_data_type_get_data_type (_tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp49_);
						_tmp51_ = _tmp50_;
						_tmp41_ = g_strcmp0 (_tmp51_, "GLib.BusName") == 0;
						_g_free0 (_tmp51_);
					} else {
						_tmp41_ = FALSE;
					}
					if (_tmp41_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp52_ = vala_ccode_initializer_list_new ();
					info = _tmp52_;
					_tmp53_ = info;
					_tmp54_ = vala_ccode_constant_new ("-1");
					_tmp55_ = _tmp54_;
					vala_ccode_initializer_list_append (_tmp53_, (ValaCCodeExpression*) _tmp55_);
					_vala_ccode_node_unref0 (_tmp55_);
					_tmp56_ = info;
					_tmp57_ = param;
					_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = g_strdup_printf ("\"%s\"", _tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = vala_ccode_constant_new (_tmp61_);
					_tmp63_ = _tmp62_;
					vala_ccode_initializer_list_append (_tmp56_, (ValaCCodeExpression*) _tmp63_);
					_vala_ccode_node_unref0 (_tmp63_);
					_g_free0 (_tmp61_);
					_tmp64_ = info;
					_tmp65_ = param;
					_tmp66_ = vala_variable_get_variable_type ((ValaVariable*) _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = param;
					_tmp69_ = vala_data_type_get_type_signature (_tmp67_, (ValaSymbol*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = g_strdup_printf ("\"%s\"", _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_ccode_constant_new (_tmp72_);
					_tmp74_ = _tmp73_;
					vala_ccode_initializer_list_append (_tmp64_, (ValaCCodeExpression*) _tmp74_);
					_vala_ccode_node_unref0 (_tmp74_);
					_g_free0 (_tmp72_);
					_g_free0 (_tmp70_);
					_tmp75_ = info;
					_tmp76_ = vala_ccode_constant_new ("NULL");
					_tmp77_ = _tmp76_;
					vala_ccode_initializer_list_append (_tmp75_, (ValaCCodeExpression*) _tmp77_);
					_vala_ccode_node_unref0 (_tmp77_);
					_tmp78_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp78_;
					_tmp79_ = _cdecl_;
					_tmp80_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_strconcat ("_", _tmp81_, NULL);
					_tmp83_ = _tmp82_;
					_tmp84_ = g_strconcat (_tmp83_, "dbus_arg_info_", NULL);
					_tmp85_ = _tmp84_;
					_tmp86_ = m;
					_tmp87_ = vala_symbol_get_name ((ValaSymbol*) _tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strconcat (_tmp85_, _tmp88_, NULL);
					_tmp90_ = _tmp89_;
					_tmp91_ = g_strconcat (_tmp90_, "_", NULL);
					_tmp92_ = _tmp91_;
					_tmp93_ = param;
					_tmp94_ = vala_symbol_get_name ((ValaSymbol*) _tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = g_strconcat (_tmp92_, _tmp95_, NULL);
					_tmp97_ = _tmp96_;
					_tmp98_ = info;
					_tmp99_ = vala_ccode_variable_declarator_new (_tmp97_, (ValaCCodeExpression*) _tmp98_, NULL);
					_tmp100_ = _tmp99_;
					vala_ccode_declaration_add_declarator (_tmp79_, (ValaCCodeDeclarator*) _tmp100_);
					_vala_ccode_node_unref0 (_tmp100_);
					_g_free0 (_tmp97_);
					_g_free0 (_tmp92_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp85_);
					_g_free0 (_tmp83_);
					_g_free0 (_tmp81_);
					_tmp101_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp101_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp102_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp103_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp102_, (ValaCCodeNode*) _tmp103_);
					_tmp104_ = param;
					_tmp105_ = vala_parameter_get_direction (_tmp104_);
					_tmp106_ = _tmp105_;
					if (_tmp106_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeInitializerList* _tmp107_;
						gchar* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						gchar* _tmp111_;
						gchar* _tmp112_;
						gchar* _tmp113_;
						ValaMethod* _tmp114_;
						const gchar* _tmp115_;
						const gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp120_;
						ValaParameter* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						ValaCCodeIdentifier* _tmp126_;
						ValaCCodeIdentifier* _tmp127_;
						ValaCCodeUnaryExpression* _tmp128_;
						ValaCCodeUnaryExpression* _tmp129_;
						_tmp107_ = in_args_info;
						_tmp108_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp109_ = _tmp108_;
						_tmp110_ = g_strconcat ("_", _tmp109_, NULL);
						_tmp111_ = _tmp110_;
						_tmp112_ = g_strconcat (_tmp111_, "dbus_arg_info_", NULL);
						_tmp113_ = _tmp112_;
						_tmp114_ = m;
						_tmp115_ = vala_symbol_get_name ((ValaSymbol*) _tmp114_);
						_tmp116_ = _tmp115_;
						_tmp117_ = g_strconcat (_tmp113_, _tmp116_, NULL);
						_tmp118_ = _tmp117_;
						_tmp119_ = g_strconcat (_tmp118_, "_", NULL);
						_tmp120_ = _tmp119_;
						_tmp121_ = param;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = g_strconcat (_tmp120_, _tmp123_, NULL);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_ccode_identifier_new (_tmp125_);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp127_);
						_tmp129_ = _tmp128_;
						vala_ccode_initializer_list_append (_tmp107_, (ValaCCodeExpression*) _tmp129_);
						_vala_ccode_node_unref0 (_tmp129_);
						_vala_ccode_node_unref0 (_tmp127_);
						_g_free0 (_tmp125_);
						_g_free0 (_tmp120_);
						_g_free0 (_tmp118_);
						_g_free0 (_tmp113_);
						_g_free0 (_tmp111_);
						_g_free0 (_tmp109_);
					} else {
						ValaCCodeInitializerList* _tmp130_;
						gchar* _tmp131_;
						gchar* _tmp132_;
						gchar* _tmp133_;
						gchar* _tmp134_;
						gchar* _tmp135_;
						gchar* _tmp136_;
						ValaMethod* _tmp137_;
						const gchar* _tmp138_;
						const gchar* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						gchar* _tmp142_;
						gchar* _tmp143_;
						ValaParameter* _tmp144_;
						const gchar* _tmp145_;
						const gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						ValaCCodeIdentifier* _tmp149_;
						ValaCCodeIdentifier* _tmp150_;
						ValaCCodeUnaryExpression* _tmp151_;
						ValaCCodeUnaryExpression* _tmp152_;
						_tmp130_ = out_args_info;
						_tmp131_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp132_ = _tmp131_;
						_tmp133_ = g_strconcat ("_", _tmp132_, NULL);
						_tmp134_ = _tmp133_;
						_tmp135_ = g_strconcat (_tmp134_, "dbus_arg_info_", NULL);
						_tmp136_ = _tmp135_;
						_tmp137_ = m;
						_tmp138_ = vala_symbol_get_name ((ValaSymbol*) _tmp137_);
						_tmp139_ = _tmp138_;
						_tmp140_ = g_strconcat (_tmp136_, _tmp139_, NULL);
						_tmp141_ = _tmp140_;
						_tmp142_ = g_strconcat (_tmp141_, "_", NULL);
						_tmp143_ = _tmp142_;
						_tmp144_ = param;
						_tmp145_ = vala_symbol_get_name ((ValaSymbol*) _tmp144_);
						_tmp146_ = _tmp145_;
						_tmp147_ = g_strconcat (_tmp143_, _tmp146_, NULL);
						_tmp148_ = _tmp147_;
						_tmp149_ = vala_ccode_identifier_new (_tmp148_);
						_tmp150_ = _tmp149_;
						_tmp151_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp150_);
						_tmp152_ = _tmp151_;
						vala_ccode_initializer_list_append (_tmp130_, (ValaCCodeExpression*) _tmp152_);
						_vala_ccode_node_unref0 (_tmp152_);
						_vala_ccode_node_unref0 (_tmp150_);
						_g_free0 (_tmp148_);
						_g_free0 (_tmp143_);
						_g_free0 (_tmp141_);
						_g_free0 (_tmp136_);
						_g_free0 (_tmp134_);
						_g_free0 (_tmp132_);
					}
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp153_ = m;
			_tmp154_ = vala_callable_get_return_type ((ValaCallable*) _tmp153_);
			_tmp155_ = _tmp154_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_VOID_TYPE)) {
				ValaCCodeInitializerList* info = NULL;
				ValaCCodeInitializerList* _tmp156_;
				ValaCCodeInitializerList* _tmp157_;
				ValaCCodeConstant* _tmp158_;
				ValaCCodeConstant* _tmp159_;
				ValaCCodeInitializerList* _tmp160_;
				ValaMethod* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				gchar* _tmp165_;
				ValaCCodeConstant* _tmp166_;
				ValaCCodeConstant* _tmp167_;
				ValaCCodeInitializerList* _tmp168_;
				ValaMethod* _tmp169_;
				ValaDataType* _tmp170_;
				ValaDataType* _tmp171_;
				ValaMethod* _tmp172_;
				gchar* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				ValaCCodeConstant* _tmp177_;
				ValaCCodeConstant* _tmp178_;
				ValaCCodeInitializerList* _tmp179_;
				ValaCCodeConstant* _tmp180_;
				ValaCCodeConstant* _tmp181_;
				ValaCCodeDeclaration* _cdecl_ = NULL;
				ValaCCodeDeclaration* _tmp182_;
				ValaCCodeDeclaration* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				gchar* _tmp188_;
				gchar* _tmp189_;
				ValaMethod* _tmp190_;
				const gchar* _tmp191_;
				const gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				ValaCCodeInitializerList* _tmp197_;
				ValaCCodeVariableDeclarator* _tmp198_;
				ValaCCodeVariableDeclarator* _tmp199_;
				ValaCCodeDeclaration* _tmp200_;
				ValaCCodeFile* _tmp201_;
				ValaCCodeDeclaration* _tmp202_;
				ValaCCodeInitializerList* _tmp203_;
				gchar* _tmp204_;
				gchar* _tmp205_;
				gchar* _tmp206_;
				gchar* _tmp207_;
				gchar* _tmp208_;
				gchar* _tmp209_;
				ValaMethod* _tmp210_;
				const gchar* _tmp211_;
				const gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				gchar* _tmp215_;
				gchar* _tmp216_;
				ValaCCodeIdentifier* _tmp217_;
				ValaCCodeIdentifier* _tmp218_;
				ValaCCodeUnaryExpression* _tmp219_;
				ValaCCodeUnaryExpression* _tmp220_;
				_tmp156_ = vala_ccode_initializer_list_new ();
				info = _tmp156_;
				_tmp157_ = info;
				_tmp158_ = vala_ccode_constant_new ("-1");
				_tmp159_ = _tmp158_;
				vala_ccode_initializer_list_append (_tmp157_, (ValaCCodeExpression*) _tmp159_);
				_vala_ccode_node_unref0 (_tmp159_);
				_tmp160_ = info;
				_tmp161_ = m;
				_tmp162_ = vala_gd_bus_module_dbus_result_name (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = g_strdup_printf ("\"%s\"", _tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = vala_ccode_constant_new (_tmp165_);
				_tmp167_ = _tmp166_;
				vala_ccode_initializer_list_append (_tmp160_, (ValaCCodeExpression*) _tmp167_);
				_vala_ccode_node_unref0 (_tmp167_);
				_g_free0 (_tmp165_);
				_g_free0 (_tmp163_);
				_tmp168_ = info;
				_tmp169_ = m;
				_tmp170_ = vala_callable_get_return_type ((ValaCallable*) _tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = m;
				_tmp173_ = vala_data_type_get_type_signature (_tmp171_, (ValaSymbol*) _tmp172_);
				_tmp174_ = _tmp173_;
				_tmp175_ = g_strdup_printf ("\"%s\"", _tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_ccode_constant_new (_tmp176_);
				_tmp178_ = _tmp177_;
				vala_ccode_initializer_list_append (_tmp168_, (ValaCCodeExpression*) _tmp178_);
				_vala_ccode_node_unref0 (_tmp178_);
				_g_free0 (_tmp176_);
				_g_free0 (_tmp174_);
				_tmp179_ = info;
				_tmp180_ = vala_ccode_constant_new ("NULL");
				_tmp181_ = _tmp180_;
				vala_ccode_initializer_list_append (_tmp179_, (ValaCCodeExpression*) _tmp181_);
				_vala_ccode_node_unref0 (_tmp181_);
				_tmp182_ = vala_ccode_declaration_new ("const GDBusArgInfo");
				_cdecl_ = _tmp182_;
				_tmp183_ = _cdecl_;
				_tmp184_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp185_ = _tmp184_;
				_tmp186_ = g_strconcat ("_", _tmp185_, NULL);
				_tmp187_ = _tmp186_;
				_tmp188_ = g_strconcat (_tmp187_, "dbus_arg_info_", NULL);
				_tmp189_ = _tmp188_;
				_tmp190_ = m;
				_tmp191_ = vala_symbol_get_name ((ValaSymbol*) _tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = g_strconcat (_tmp189_, _tmp192_, NULL);
				_tmp194_ = _tmp193_;
				_tmp195_ = g_strconcat (_tmp194_, "_result", NULL);
				_tmp196_ = _tmp195_;
				_tmp197_ = info;
				_tmp198_ = vala_ccode_variable_declarator_new (_tmp196_, (ValaCCodeExpression*) _tmp197_, NULL);
				_tmp199_ = _tmp198_;
				vala_ccode_declaration_add_declarator (_tmp183_, (ValaCCodeDeclarator*) _tmp199_);
				_vala_ccode_node_unref0 (_tmp199_);
				_g_free0 (_tmp196_);
				_g_free0 (_tmp194_);
				_g_free0 (_tmp189_);
				_g_free0 (_tmp187_);
				_g_free0 (_tmp185_);
				_tmp200_ = _cdecl_;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp200_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp201_ = ((ValaCCodeBaseModule*) self)->cfile;
				_tmp202_ = _cdecl_;
				vala_ccode_file_add_constant_declaration (_tmp201_, (ValaCCodeNode*) _tmp202_);
				_tmp203_ = out_args_info;
				_tmp204_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp205_ = _tmp204_;
				_tmp206_ = g_strconcat ("_", _tmp205_, NULL);
				_tmp207_ = _tmp206_;
				_tmp208_ = g_strconcat (_tmp207_, "dbus_arg_info_", NULL);
				_tmp209_ = _tmp208_;
				_tmp210_ = m;
				_tmp211_ = vala_symbol_get_name ((ValaSymbol*) _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = g_strconcat (_tmp209_, _tmp212_, NULL);
				_tmp214_ = _tmp213_;
				_tmp215_ = g_strconcat (_tmp214_, "_result", NULL);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_ccode_identifier_new (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp218_);
				_tmp220_ = _tmp219_;
				vala_ccode_initializer_list_append (_tmp203_, (ValaCCodeExpression*) _tmp220_);
				_vala_ccode_node_unref0 (_tmp220_);
				_vala_ccode_node_unref0 (_tmp218_);
				_g_free0 (_tmp216_);
				_g_free0 (_tmp214_);
				_g_free0 (_tmp209_);
				_g_free0 (_tmp207_);
				_g_free0 (_tmp205_);
				_vala_ccode_node_unref0 (_cdecl_);
				_vala_ccode_node_unref0 (info);
			}
			_tmp221_ = in_args_info;
			_tmp222_ = vala_ccode_constant_new ("NULL");
			_tmp223_ = _tmp222_;
			vala_ccode_initializer_list_append (_tmp221_, (ValaCCodeExpression*) _tmp223_);
			_vala_ccode_node_unref0 (_tmp223_);
			_tmp224_ = out_args_info;
			_tmp225_ = vala_ccode_constant_new ("NULL");
			_tmp226_ = _tmp225_;
			vala_ccode_initializer_list_append (_tmp224_, (ValaCCodeExpression*) _tmp226_);
			_vala_ccode_node_unref0 (_tmp226_);
			_tmp227_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp227_;
			_tmp228_ = _cdecl_;
			_tmp229_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp230_ = _tmp229_;
			_tmp231_ = g_strconcat ("_", _tmp230_, NULL);
			_tmp232_ = _tmp231_;
			_tmp233_ = g_strconcat (_tmp232_, "dbus_arg_info_", NULL);
			_tmp234_ = _tmp233_;
			_tmp235_ = m;
			_tmp236_ = vala_symbol_get_name ((ValaSymbol*) _tmp235_);
			_tmp237_ = _tmp236_;
			_tmp238_ = g_strconcat (_tmp234_, _tmp237_, NULL);
			_tmp239_ = _tmp238_;
			_tmp240_ = g_strconcat (_tmp239_, "_in[]", NULL);
			_tmp241_ = _tmp240_;
			_tmp242_ = in_args_info;
			_tmp243_ = vala_ccode_variable_declarator_new (_tmp241_, (ValaCCodeExpression*) _tmp242_, NULL);
			_tmp244_ = _tmp243_;
			vala_ccode_declaration_add_declarator (_tmp228_, (ValaCCodeDeclarator*) _tmp244_);
			_vala_ccode_node_unref0 (_tmp244_);
			_g_free0 (_tmp241_);
			_g_free0 (_tmp239_);
			_g_free0 (_tmp234_);
			_g_free0 (_tmp232_);
			_g_free0 (_tmp230_);
			_tmp245_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp245_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp246_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp247_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp246_, (ValaCCodeNode*) _tmp247_);
			_tmp248_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp248_;
			_tmp249_ = _cdecl_;
			_tmp250_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp251_ = _tmp250_;
			_tmp252_ = g_strconcat ("_", _tmp251_, NULL);
			_tmp253_ = _tmp252_;
			_tmp254_ = g_strconcat (_tmp253_, "dbus_arg_info_", NULL);
			_tmp255_ = _tmp254_;
			_tmp256_ = m;
			_tmp257_ = vala_symbol_get_name ((ValaSymbol*) _tmp256_);
			_tmp258_ = _tmp257_;
			_tmp259_ = g_strconcat (_tmp255_, _tmp258_, NULL);
			_tmp260_ = _tmp259_;
			_tmp261_ = g_strconcat (_tmp260_, "_out[]", NULL);
			_tmp262_ = _tmp261_;
			_tmp263_ = out_args_info;
			_tmp264_ = vala_ccode_variable_declarator_new (_tmp262_, (ValaCCodeExpression*) _tmp263_, NULL);
			_tmp265_ = _tmp264_;
			vala_ccode_declaration_add_declarator (_tmp249_, (ValaCCodeDeclarator*) _tmp265_);
			_vala_ccode_node_unref0 (_tmp265_);
			_g_free0 (_tmp262_);
			_g_free0 (_tmp260_);
			_g_free0 (_tmp255_);
			_g_free0 (_tmp253_);
			_g_free0 (_tmp251_);
			_tmp266_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp266_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp267_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp268_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp267_, (ValaCCodeNode*) _tmp268_);
			_tmp269_ = vala_ccode_initializer_list_new ();
			info = _tmp269_;
			_tmp270_ = info;
			_tmp271_ = vala_ccode_constant_new ("-1");
			_tmp272_ = _tmp271_;
			vala_ccode_initializer_list_append (_tmp270_, (ValaCCodeExpression*) _tmp272_);
			_vala_ccode_node_unref0 (_tmp272_);
			_tmp273_ = info;
			_tmp274_ = m;
			_tmp275_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp274_);
			_tmp276_ = _tmp275_;
			_tmp277_ = g_strdup_printf ("\"%s\"", _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_ccode_constant_new (_tmp278_);
			_tmp280_ = _tmp279_;
			vala_ccode_initializer_list_append (_tmp273_, (ValaCCodeExpression*) _tmp280_);
			_vala_ccode_node_unref0 (_tmp280_);
			_g_free0 (_tmp278_);
			_g_free0 (_tmp276_);
			_tmp281_ = info;
			_tmp282_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp283_ = _tmp282_;
			_tmp284_ = g_strconcat ("_", _tmp283_, NULL);
			_tmp285_ = _tmp284_;
			_tmp286_ = g_strconcat (_tmp285_, "dbus_arg_info_", NULL);
			_tmp287_ = _tmp286_;
			_tmp288_ = m;
			_tmp289_ = vala_symbol_get_name ((ValaSymbol*) _tmp288_);
			_tmp290_ = _tmp289_;
			_tmp291_ = g_strconcat (_tmp287_, _tmp290_, NULL);
			_tmp292_ = _tmp291_;
			_tmp293_ = g_strconcat (_tmp292_, "_in", NULL);
			_tmp294_ = _tmp293_;
			_tmp295_ = vala_ccode_identifier_new (_tmp294_);
			_tmp296_ = _tmp295_;
			_tmp297_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp296_);
			_tmp298_ = _tmp297_;
			_tmp299_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp298_, "GDBusArgInfo **");
			_tmp300_ = _tmp299_;
			vala_ccode_initializer_list_append (_tmp281_, (ValaCCodeExpression*) _tmp300_);
			_vala_ccode_node_unref0 (_tmp300_);
			_vala_ccode_node_unref0 (_tmp298_);
			_vala_ccode_node_unref0 (_tmp296_);
			_g_free0 (_tmp294_);
			_g_free0 (_tmp292_);
			_g_free0 (_tmp287_);
			_g_free0 (_tmp285_);
			_g_free0 (_tmp283_);
			_tmp301_ = info;
			_tmp302_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp303_ = _tmp302_;
			_tmp304_ = g_strconcat ("_", _tmp303_, NULL);
			_tmp305_ = _tmp304_;
			_tmp306_ = g_strconcat (_tmp305_, "dbus_arg_info_", NULL);
			_tmp307_ = _tmp306_;
			_tmp308_ = m;
			_tmp309_ = vala_symbol_get_name ((ValaSymbol*) _tmp308_);
			_tmp310_ = _tmp309_;
			_tmp311_ = g_strconcat (_tmp307_, _tmp310_, NULL);
			_tmp312_ = _tmp311_;
			_tmp313_ = g_strconcat (_tmp312_, "_out", NULL);
			_tmp314_ = _tmp313_;
			_tmp315_ = vala_ccode_identifier_new (_tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp316_);
			_tmp318_ = _tmp317_;
			_tmp319_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp318_, "GDBusArgInfo **");
			_tmp320_ = _tmp319_;
			vala_ccode_initializer_list_append (_tmp301_, (ValaCCodeExpression*) _tmp320_);
			_vala_ccode_node_unref0 (_tmp320_);
			_vala_ccode_node_unref0 (_tmp318_);
			_vala_ccode_node_unref0 (_tmp316_);
			_g_free0 (_tmp314_);
			_g_free0 (_tmp312_);
			_g_free0 (_tmp307_);
			_g_free0 (_tmp305_);
			_g_free0 (_tmp303_);
			_tmp321_ = info;
			_tmp322_ = vala_ccode_constant_new ("NULL");
			_tmp323_ = _tmp322_;
			vala_ccode_initializer_list_append (_tmp321_, (ValaCCodeExpression*) _tmp323_);
			_vala_ccode_node_unref0 (_tmp323_);
			_tmp324_ = vala_ccode_declaration_new ("const GDBusMethodInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp324_;
			_tmp325_ = _cdecl_;
			_tmp326_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp327_ = _tmp326_;
			_tmp328_ = g_strconcat ("_", _tmp327_, NULL);
			_tmp329_ = _tmp328_;
			_tmp330_ = g_strconcat (_tmp329_, "dbus_method_info_", NULL);
			_tmp331_ = _tmp330_;
			_tmp332_ = m;
			_tmp333_ = vala_symbol_get_name ((ValaSymbol*) _tmp332_);
			_tmp334_ = _tmp333_;
			_tmp335_ = g_strconcat (_tmp331_, _tmp334_, NULL);
			_tmp336_ = _tmp335_;
			_tmp337_ = info;
			_tmp338_ = vala_ccode_variable_declarator_new (_tmp336_, (ValaCCodeExpression*) _tmp337_, NULL);
			_tmp339_ = _tmp338_;
			vala_ccode_declaration_add_declarator (_tmp325_, (ValaCCodeDeclarator*) _tmp339_);
			_vala_ccode_node_unref0 (_tmp339_);
			_g_free0 (_tmp336_);
			_g_free0 (_tmp331_);
			_g_free0 (_tmp329_);
			_g_free0 (_tmp327_);
			_tmp340_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp340_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp341_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp342_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp341_, (ValaCCodeNode*) _tmp342_);
			_tmp343_ = infos;
			_tmp344_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp345_ = _tmp344_;
			_tmp346_ = g_strconcat ("_", _tmp345_, NULL);
			_tmp347_ = _tmp346_;
			_tmp348_ = g_strconcat (_tmp347_, "dbus_method_info_", NULL);
			_tmp349_ = _tmp348_;
			_tmp350_ = m;
			_tmp351_ = vala_symbol_get_name ((ValaSymbol*) _tmp350_);
			_tmp352_ = _tmp351_;
			_tmp353_ = g_strconcat (_tmp349_, _tmp352_, NULL);
			_tmp354_ = _tmp353_;
			_tmp355_ = vala_ccode_identifier_new (_tmp354_);
			_tmp356_ = _tmp355_;
			_tmp357_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp356_);
			_tmp358_ = _tmp357_;
			vala_ccode_initializer_list_append (_tmp343_, (ValaCCodeExpression*) _tmp358_);
			_vala_ccode_node_unref0 (_tmp358_);
			_vala_ccode_node_unref0 (_tmp356_);
			_g_free0 (_tmp354_);
			_g_free0 (_tmp349_);
			_g_free0 (_tmp347_);
			_g_free0 (_tmp345_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (out_args_info);
			_vala_ccode_node_unref0 (in_args_info);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp359_ = infos;
	_tmp360_ = vala_ccode_constant_new ("NULL");
	_tmp361_ = _tmp360_;
	vala_ccode_initializer_list_append (_tmp359_, (ValaCCodeExpression*) _tmp361_);
	_vala_ccode_node_unref0 (_tmp361_);
	_tmp362_ = vala_ccode_declaration_new ("const GDBusMethodInfo * const");
	_cdecl_ = _tmp362_;
	_tmp363_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp364_ = _tmp363_;
	_tmp365_ = g_strconcat ("_", _tmp364_, NULL);
	_tmp366_ = _tmp365_;
	_tmp367_ = g_strconcat (_tmp366_, "dbus_method_info[]", NULL);
	_tmp368_ = _tmp367_;
	_tmp369_ = infos;
	_tmp370_ = vala_ccode_variable_declarator_new (_tmp368_, (ValaCCodeExpression*) _tmp369_, NULL);
	_tmp371_ = _tmp370_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp371_);
	_vala_ccode_node_unref0 (_tmp371_);
	_g_free0 (_tmp368_);
	_g_free0 (_tmp366_);
	_g_free0 (_tmp364_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp372_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp372_, (ValaCCodeNode*) _cdecl_);
	_tmp373_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp374_ = _tmp373_;
	_tmp375_ = g_strconcat ("_", _tmp374_, NULL);
	_tmp376_ = _tmp375_;
	_tmp377_ = g_strconcat (_tmp376_, "dbus_method_info", NULL);
	_tmp378_ = _tmp377_;
	_tmp379_ = vala_ccode_identifier_new (_tmp378_);
	_tmp380_ = (ValaCCodeExpression*) _tmp379_;
	_g_free0 (_tmp378_);
	_g_free0 (_tmp376_);
	_g_free0 (_tmp374_);
	result = _tmp380_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}

static ValaCCodeExpression*
vala_gd_bus_module_get_signal_info (ValaGDBusModule* self,
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp186_;
	ValaCCodeConstant* _tmp187_;
	ValaCCodeConstant* _tmp188_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp189_;
	gchar* _tmp190_;
	gchar* _tmp191_;
	gchar* _tmp192_;
	gchar* _tmp193_;
	gchar* _tmp194_;
	gchar* _tmp195_;
	ValaCCodeInitializerList* _tmp196_;
	ValaCCodeVariableDeclarator* _tmp197_;
	ValaCCodeVariableDeclarator* _tmp198_;
	ValaCCodeFile* _tmp199_;
	gchar* _tmp200_;
	gchar* _tmp201_;
	gchar* _tmp202_;
	gchar* _tmp203_;
	gchar* _tmp204_;
	gchar* _tmp205_;
	ValaCCodeIdentifier* _tmp206_;
	ValaCCodeExpression* _tmp207_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp1_;
		gint _sig_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _sig_index = 0;
		_tmp1_ = vala_object_type_symbol_get_signals (sym);
		_sig_list = _tmp1_;
		_tmp2_ = _sig_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_sig_size = _tmp4_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSignal* _tmp7_;
			ValaSymbolAccessibility _tmp8_;
			ValaSymbolAccessibility _tmp9_;
			ValaSignal* _tmp10_;
			ValaCCodeInitializerList* args_info = NULL;
			ValaCCodeInitializerList* _tmp11_;
			ValaCCodeInitializerList* _tmp94_;
			ValaCCodeConstant* _tmp95_;
			ValaCCodeConstant* _tmp96_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp97_;
			ValaCCodeDeclaration* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			ValaSignal* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			ValaCCodeInitializerList* _tmp112_;
			ValaCCodeVariableDeclarator* _tmp113_;
			ValaCCodeVariableDeclarator* _tmp114_;
			ValaCCodeDeclaration* _tmp115_;
			ValaCCodeFile* _tmp116_;
			ValaCCodeDeclaration* _tmp117_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp118_;
			ValaCCodeInitializerList* _tmp119_;
			ValaCCodeConstant* _tmp120_;
			ValaCCodeConstant* _tmp121_;
			ValaCCodeInitializerList* _tmp122_;
			ValaSignal* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			ValaCCodeConstant* _tmp128_;
			ValaCCodeConstant* _tmp129_;
			ValaCCodeInitializerList* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			ValaSignal* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			ValaCCodeIdentifier* _tmp142_;
			ValaCCodeIdentifier* _tmp143_;
			ValaCCodeUnaryExpression* _tmp144_;
			ValaCCodeUnaryExpression* _tmp145_;
			ValaCCodeCastExpression* _tmp146_;
			ValaCCodeCastExpression* _tmp147_;
			ValaCCodeInitializerList* _tmp148_;
			ValaCCodeConstant* _tmp149_;
			ValaCCodeConstant* _tmp150_;
			ValaCCodeDeclaration* _tmp151_;
			ValaCCodeDeclaration* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			ValaSignal* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			gchar* _tmp162_;
			gchar* _tmp163_;
			ValaCCodeInitializerList* _tmp164_;
			ValaCCodeVariableDeclarator* _tmp165_;
			ValaCCodeVariableDeclarator* _tmp166_;
			ValaCCodeDeclaration* _tmp167_;
			ValaCCodeFile* _tmp168_;
			ValaCCodeDeclaration* _tmp169_;
			ValaCCodeInitializerList* _tmp170_;
			gchar* _tmp171_;
			gchar* _tmp172_;
			gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
			ValaSignal* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			ValaCCodeIdentifier* _tmp182_;
			ValaCCodeIdentifier* _tmp183_;
			ValaCCodeUnaryExpression* _tmp184_;
			ValaCCodeUnaryExpression* _tmp185_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp5_ = _sig_list;
			_tmp6_ = vala_list_get (_tmp5_, _sig_index);
			sig = (ValaSignal*) _tmp6_;
			_tmp7_ = sig;
			_tmp8_ = vala_symbol_get_access ((ValaSymbol*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp10_ = sig;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp10_)) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp11_ = vala_ccode_initializer_list_new ();
			args_info = _tmp11_;
			{
				ValaList* _param_list = NULL;
				ValaSignal* _tmp12_;
				ValaList* _tmp13_;
				gint _param_size = 0;
				ValaList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _param_index = 0;
				_tmp12_ = sig;
				_tmp13_ = vala_callable_get_parameters ((ValaCallable*) _tmp12_);
				_param_list = _tmp13_;
				_tmp14_ = _param_list;
				_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_param_size = _tmp16_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp17_;
					gpointer _tmp18_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp19_;
					ValaCCodeInitializerList* _tmp20_;
					ValaCCodeConstant* _tmp21_;
					ValaCCodeConstant* _tmp22_;
					ValaCCodeInitializerList* _tmp23_;
					ValaParameter* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					ValaCCodeConstant* _tmp29_;
					ValaCCodeConstant* _tmp30_;
					ValaCCodeInitializerList* _tmp31_;
					ValaParameter* _tmp32_;
					ValaDataType* _tmp33_;
					ValaDataType* _tmp34_;
					ValaParameter* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					ValaCCodeConstant* _tmp40_;
					ValaCCodeConstant* _tmp41_;
					ValaCCodeInitializerList* _tmp42_;
					ValaCCodeConstant* _tmp43_;
					ValaCCodeConstant* _tmp44_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp45_;
					ValaCCodeDeclaration* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					ValaSignal* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					ValaParameter* _tmp60_;
					const gchar* _tmp61_;
					const gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					ValaCCodeInitializerList* _tmp65_;
					ValaCCodeVariableDeclarator* _tmp66_;
					ValaCCodeVariableDeclarator* _tmp67_;
					ValaCCodeDeclaration* _tmp68_;
					ValaCCodeFile* _tmp69_;
					ValaCCodeDeclaration* _tmp70_;
					ValaCCodeInitializerList* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					ValaSignal* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					ValaParameter* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					ValaCCodeIdentifier* _tmp90_;
					ValaCCodeIdentifier* _tmp91_;
					ValaCCodeUnaryExpression* _tmp92_;
					ValaCCodeUnaryExpression* _tmp93_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp17_ = _param_list;
					_tmp18_ = vala_list_get (_tmp17_, _param_index);
					param = (ValaParameter*) _tmp18_;
					_tmp19_ = vala_ccode_initializer_list_new ();
					info = _tmp19_;
					_tmp20_ = info;
					_tmp21_ = vala_ccode_constant_new ("-1");
					_tmp22_ = _tmp21_;
					vala_ccode_initializer_list_append (_tmp20_, (ValaCCodeExpression*) _tmp22_);
					_vala_ccode_node_unref0 (_tmp22_);
					_tmp23_ = info;
					_tmp24_ = param;
					_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strdup_printf ("\"%s\"", _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_ccode_constant_new (_tmp28_);
					_tmp30_ = _tmp29_;
					vala_ccode_initializer_list_append (_tmp23_, (ValaCCodeExpression*) _tmp30_);
					_vala_ccode_node_unref0 (_tmp30_);
					_g_free0 (_tmp28_);
					_tmp31_ = info;
					_tmp32_ = param;
					_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = param;
					_tmp36_ = vala_data_type_get_type_signature (_tmp34_, (ValaSymbol*) _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = g_strdup_printf ("\"%s\"", _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = vala_ccode_constant_new (_tmp39_);
					_tmp41_ = _tmp40_;
					vala_ccode_initializer_list_append (_tmp31_, (ValaCCodeExpression*) _tmp41_);
					_vala_ccode_node_unref0 (_tmp41_);
					_g_free0 (_tmp39_);
					_g_free0 (_tmp37_);
					_tmp42_ = info;
					_tmp43_ = vala_ccode_constant_new ("NULL");
					_tmp44_ = _tmp43_;
					vala_ccode_initializer_list_append (_tmp42_, (ValaCCodeExpression*) _tmp44_);
					_vala_ccode_node_unref0 (_tmp44_);
					_tmp45_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp45_;
					_tmp46_ = _cdecl_;
					_tmp47_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat ("_", _tmp48_, NULL);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strconcat (_tmp50_, "dbus_arg_info_", NULL);
					_tmp52_ = _tmp51_;
					_tmp53_ = sig;
					_tmp54_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp53_, NULL);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strconcat (_tmp52_, _tmp55_, NULL);
					_tmp57_ = _tmp56_;
					_tmp58_ = g_strconcat (_tmp57_, "_", NULL);
					_tmp59_ = _tmp58_;
					_tmp60_ = param;
					_tmp61_ = vala_symbol_get_name ((ValaSymbol*) _tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strconcat (_tmp59_, _tmp62_, NULL);
					_tmp64_ = _tmp63_;
					_tmp65_ = info;
					_tmp66_ = vala_ccode_variable_declarator_new (_tmp64_, (ValaCCodeExpression*) _tmp65_, NULL);
					_tmp67_ = _tmp66_;
					vala_ccode_declaration_add_declarator (_tmp46_, (ValaCCodeDeclarator*) _tmp67_);
					_vala_ccode_node_unref0 (_tmp67_);
					_g_free0 (_tmp64_);
					_g_free0 (_tmp59_);
					_g_free0 (_tmp57_);
					_g_free0 (_tmp55_);
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp48_);
					_tmp68_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp68_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp69_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp70_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp69_, (ValaCCodeNode*) _tmp70_);
					_tmp71_ = args_info;
					_tmp72_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp73_ = _tmp72_;
					_tmp74_ = g_strconcat ("_", _tmp73_, NULL);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp75_, "dbus_arg_info_", NULL);
					_tmp77_ = _tmp76_;
					_tmp78_ = sig;
					_tmp79_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp78_, NULL);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strconcat (_tmp77_, _tmp80_, NULL);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strconcat (_tmp82_, "_", NULL);
					_tmp84_ = _tmp83_;
					_tmp85_ = param;
					_tmp86_ = vala_symbol_get_name ((ValaSymbol*) _tmp85_);
					_tmp87_ = _tmp86_;
					_tmp88_ = g_strconcat (_tmp84_, _tmp87_, NULL);
					_tmp89_ = _tmp88_;
					_tmp90_ = vala_ccode_identifier_new (_tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp91_);
					_tmp93_ = _tmp92_;
					vala_ccode_initializer_list_append (_tmp71_, (ValaCCodeExpression*) _tmp93_);
					_vala_ccode_node_unref0 (_tmp93_);
					_vala_ccode_node_unref0 (_tmp91_);
					_g_free0 (_tmp89_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp77_);
					_g_free0 (_tmp75_);
					_g_free0 (_tmp73_);
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp94_ = args_info;
			_tmp95_ = vala_ccode_constant_new ("NULL");
			_tmp96_ = _tmp95_;
			vala_ccode_initializer_list_append (_tmp94_, (ValaCCodeExpression*) _tmp96_);
			_vala_ccode_node_unref0 (_tmp96_);
			_tmp97_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp97_;
			_tmp98_ = _cdecl_;
			_tmp99_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp100_ = _tmp99_;
			_tmp101_ = g_strconcat ("_", _tmp100_, NULL);
			_tmp102_ = _tmp101_;
			_tmp103_ = g_strconcat (_tmp102_, "dbus_arg_info_", NULL);
			_tmp104_ = _tmp103_;
			_tmp105_ = sig;
			_tmp106_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp105_, NULL);
			_tmp107_ = _tmp106_;
			_tmp108_ = g_strconcat (_tmp104_, _tmp107_, NULL);
			_tmp109_ = _tmp108_;
			_tmp110_ = g_strconcat (_tmp109_, "[]", NULL);
			_tmp111_ = _tmp110_;
			_tmp112_ = args_info;
			_tmp113_ = vala_ccode_variable_declarator_new (_tmp111_, (ValaCCodeExpression*) _tmp112_, NULL);
			_tmp114_ = _tmp113_;
			vala_ccode_declaration_add_declarator (_tmp98_, (ValaCCodeDeclarator*) _tmp114_);
			_vala_ccode_node_unref0 (_tmp114_);
			_g_free0 (_tmp111_);
			_g_free0 (_tmp109_);
			_g_free0 (_tmp107_);
			_g_free0 (_tmp104_);
			_g_free0 (_tmp102_);
			_g_free0 (_tmp100_);
			_tmp115_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp115_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp116_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp117_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp116_, (ValaCCodeNode*) _tmp117_);
			_tmp118_ = vala_ccode_initializer_list_new ();
			info = _tmp118_;
			_tmp119_ = info;
			_tmp120_ = vala_ccode_constant_new ("-1");
			_tmp121_ = _tmp120_;
			vala_ccode_initializer_list_append (_tmp119_, (ValaCCodeExpression*) _tmp121_);
			_vala_ccode_node_unref0 (_tmp121_);
			_tmp122_ = info;
			_tmp123_ = sig;
			_tmp124_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = g_strdup_printf ("\"%s\"", _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_ccode_constant_new (_tmp127_);
			_tmp129_ = _tmp128_;
			vala_ccode_initializer_list_append (_tmp122_, (ValaCCodeExpression*) _tmp129_);
			_vala_ccode_node_unref0 (_tmp129_);
			_g_free0 (_tmp127_);
			_g_free0 (_tmp125_);
			_tmp130_ = info;
			_tmp131_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp132_ = _tmp131_;
			_tmp133_ = g_strconcat ("_", _tmp132_, NULL);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strconcat (_tmp134_, "dbus_arg_info_", NULL);
			_tmp136_ = _tmp135_;
			_tmp137_ = sig;
			_tmp138_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp137_, NULL);
			_tmp139_ = _tmp138_;
			_tmp140_ = g_strconcat (_tmp136_, _tmp139_, NULL);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_ccode_identifier_new (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp145_, "GDBusArgInfo **");
			_tmp147_ = _tmp146_;
			vala_ccode_initializer_list_append (_tmp130_, (ValaCCodeExpression*) _tmp147_);
			_vala_ccode_node_unref0 (_tmp147_);
			_vala_ccode_node_unref0 (_tmp145_);
			_vala_ccode_node_unref0 (_tmp143_);
			_g_free0 (_tmp141_);
			_g_free0 (_tmp139_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			_g_free0 (_tmp132_);
			_tmp148_ = info;
			_tmp149_ = vala_ccode_constant_new ("NULL");
			_tmp150_ = _tmp149_;
			vala_ccode_initializer_list_append (_tmp148_, (ValaCCodeExpression*) _tmp150_);
			_vala_ccode_node_unref0 (_tmp150_);
			_tmp151_ = vala_ccode_declaration_new ("const GDBusSignalInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp151_;
			_tmp152_ = _cdecl_;
			_tmp153_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strconcat ("_", _tmp154_, NULL);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strconcat (_tmp156_, "dbus_signal_info_", NULL);
			_tmp158_ = _tmp157_;
			_tmp159_ = sig;
			_tmp160_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp159_, NULL);
			_tmp161_ = _tmp160_;
			_tmp162_ = g_strconcat (_tmp158_, _tmp161_, NULL);
			_tmp163_ = _tmp162_;
			_tmp164_ = info;
			_tmp165_ = vala_ccode_variable_declarator_new (_tmp163_, (ValaCCodeExpression*) _tmp164_, NULL);
			_tmp166_ = _tmp165_;
			vala_ccode_declaration_add_declarator (_tmp152_, (ValaCCodeDeclarator*) _tmp166_);
			_vala_ccode_node_unref0 (_tmp166_);
			_g_free0 (_tmp163_);
			_g_free0 (_tmp161_);
			_g_free0 (_tmp158_);
			_g_free0 (_tmp156_);
			_g_free0 (_tmp154_);
			_tmp167_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp167_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp168_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp169_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp168_, (ValaCCodeNode*) _tmp169_);
			_tmp170_ = infos;
			_tmp171_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp172_ = _tmp171_;
			_tmp173_ = g_strconcat ("_", _tmp172_, NULL);
			_tmp174_ = _tmp173_;
			_tmp175_ = g_strconcat (_tmp174_, "dbus_signal_info_", NULL);
			_tmp176_ = _tmp175_;
			_tmp177_ = sig;
			_tmp178_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp177_, NULL);
			_tmp179_ = _tmp178_;
			_tmp180_ = g_strconcat (_tmp176_, _tmp179_, NULL);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_ccode_identifier_new (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp183_);
			_tmp185_ = _tmp184_;
			vala_ccode_initializer_list_append (_tmp170_, (ValaCCodeExpression*) _tmp185_);
			_vala_ccode_node_unref0 (_tmp185_);
			_vala_ccode_node_unref0 (_tmp183_);
			_g_free0 (_tmp181_);
			_g_free0 (_tmp179_);
			_g_free0 (_tmp176_);
			_g_free0 (_tmp174_);
			_g_free0 (_tmp172_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (args_info);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp186_ = infos;
	_tmp187_ = vala_ccode_constant_new ("NULL");
	_tmp188_ = _tmp187_;
	vala_ccode_initializer_list_append (_tmp186_, (ValaCCodeExpression*) _tmp188_);
	_vala_ccode_node_unref0 (_tmp188_);
	_tmp189_ = vala_ccode_declaration_new ("const GDBusSignalInfo * const");
	_cdecl_ = _tmp189_;
	_tmp190_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp191_ = _tmp190_;
	_tmp192_ = g_strconcat ("_", _tmp191_, NULL);
	_tmp193_ = _tmp192_;
	_tmp194_ = g_strconcat (_tmp193_, "dbus_signal_info[]", NULL);
	_tmp195_ = _tmp194_;
	_tmp196_ = infos;
	_tmp197_ = vala_ccode_variable_declarator_new (_tmp195_, (ValaCCodeExpression*) _tmp196_, NULL);
	_tmp198_ = _tmp197_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp198_);
	_vala_ccode_node_unref0 (_tmp198_);
	_g_free0 (_tmp195_);
	_g_free0 (_tmp193_);
	_g_free0 (_tmp191_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp199_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp199_, (ValaCCodeNode*) _cdecl_);
	_tmp200_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp201_ = _tmp200_;
	_tmp202_ = g_strconcat ("_", _tmp201_, NULL);
	_tmp203_ = _tmp202_;
	_tmp204_ = g_strconcat (_tmp203_, "dbus_signal_info", NULL);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_ccode_identifier_new (_tmp205_);
	_tmp207_ = (ValaCCodeExpression*) _tmp206_;
	_g_free0 (_tmp205_);
	_g_free0 (_tmp203_);
	_g_free0 (_tmp201_);
	result = _tmp207_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}

static ValaCCodeExpression*
vala_gd_bus_module_get_property_info (ValaGDBusModule* self,
                                      ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp105_;
	ValaCCodeConstant* _tmp106_;
	ValaCCodeConstant* _tmp107_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	ValaCCodeInitializerList* _tmp115_;
	ValaCCodeVariableDeclarator* _tmp116_;
	ValaCCodeVariableDeclarator* _tmp117_;
	ValaCCodeFile* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeExpression* _tmp126_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp1_;
		gint _prop_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prop_index = 0;
		_tmp1_ = vala_object_type_symbol_get_properties (sym);
		_prop_list = _tmp1_;
		_tmp2_ = _prop_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prop_size = _tmp4_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			ValaProperty* _tmp9_;
			ValaMemberBinding _tmp10_;
			ValaMemberBinding _tmp11_;
			ValaProperty* _tmp18_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp19_;
			ValaCCodeInitializerList* _tmp20_;
			ValaCCodeConstant* _tmp21_;
			ValaCCodeConstant* _tmp22_;
			ValaCCodeInitializerList* _tmp23_;
			ValaProperty* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			ValaCCodeConstant* _tmp29_;
			ValaCCodeConstant* _tmp30_;
			ValaCCodeInitializerList* _tmp31_;
			ValaProperty* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			ValaProperty* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			ValaCCodeConstant* _tmp40_;
			ValaCCodeConstant* _tmp41_;
			gboolean _tmp42_ = FALSE;
			ValaProperty* _tmp43_;
			ValaPropertyAccessor* _tmp44_;
			ValaPropertyAccessor* _tmp45_;
			ValaCCodeInitializerList* _tmp67_;
			ValaCCodeConstant* _tmp68_;
			ValaCCodeConstant* _tmp69_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp70_;
			ValaCCodeDeclaration* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			ValaProperty* _tmp78_;
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			ValaCCodeInitializerList* _tmp83_;
			ValaCCodeVariableDeclarator* _tmp84_;
			ValaCCodeVariableDeclarator* _tmp85_;
			ValaCCodeDeclaration* _tmp86_;
			ValaCCodeFile* _tmp87_;
			ValaCCodeDeclaration* _tmp88_;
			ValaCCodeInitializerList* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			ValaProperty* _tmp96_;
			const gchar* _tmp97_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeUnaryExpression* _tmp103_;
			ValaCCodeUnaryExpression* _tmp104_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp5_ = _prop_list;
			_tmp6_ = vala_list_get (_tmp5_, _prop_index);
			prop = (ValaProperty*) _tmp6_;
			_tmp9_ = prop;
			_tmp10_ = vala_property_get_binding (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != VALA_MEMBER_BINDING_INSTANCE) {
				_tmp8_ = TRUE;
			} else {
				ValaProperty* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = prop;
				_tmp13_ = vala_property_get_overrides (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_;
			}
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				ValaProperty* _tmp15_;
				ValaSymbolAccessibility _tmp16_;
				ValaSymbolAccessibility _tmp17_;
				_tmp15_ = prop;
				_tmp16_ = vala_symbol_get_access ((ValaSymbol*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp7_ = _tmp17_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp18_ = prop;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp18_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp19_ = vala_ccode_initializer_list_new ();
			info = _tmp19_;
			_tmp20_ = info;
			_tmp21_ = vala_ccode_constant_new ("-1");
			_tmp22_ = _tmp21_;
			vala_ccode_initializer_list_append (_tmp20_, (ValaCCodeExpression*) _tmp22_);
			_vala_ccode_node_unref0 (_tmp22_);
			_tmp23_ = info;
			_tmp24_ = prop;
			_tmp25_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf ("\"%s\"", _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_ccode_constant_new (_tmp28_);
			_tmp30_ = _tmp29_;
			vala_ccode_initializer_list_append (_tmp23_, (ValaCCodeExpression*) _tmp30_);
			_vala_ccode_node_unref0 (_tmp30_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_tmp31_ = info;
			_tmp32_ = prop;
			_tmp33_ = vala_property_get_property_type (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = prop;
			_tmp36_ = vala_data_type_get_type_signature (_tmp34_, (ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup_printf ("\"%s\"", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_ccode_constant_new (_tmp39_);
			_tmp41_ = _tmp40_;
			vala_ccode_initializer_list_append (_tmp31_, (ValaCCodeExpression*) _tmp41_);
			_vala_ccode_node_unref0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_tmp43_ = prop;
			_tmp44_ = vala_property_get_get_accessor (_tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp45_ != NULL) {
				ValaProperty* _tmp46_;
				ValaPropertyAccessor* _tmp47_;
				ValaPropertyAccessor* _tmp48_;
				_tmp46_ = prop;
				_tmp47_ = vala_property_get_set_accessor (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp42_ = _tmp48_ != NULL;
			} else {
				_tmp42_ = FALSE;
			}
			if (_tmp42_) {
				ValaCCodeInitializerList* _tmp49_;
				ValaCCodeConstant* _tmp50_;
				ValaCCodeConstant* _tmp51_;
				_tmp49_ = info;
				_tmp50_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITA" \
"BLE");
				_tmp51_ = _tmp50_;
				vala_ccode_initializer_list_append (_tmp49_, (ValaCCodeExpression*) _tmp51_);
				_vala_ccode_node_unref0 (_tmp51_);
			} else {
				ValaProperty* _tmp52_;
				ValaPropertyAccessor* _tmp53_;
				ValaPropertyAccessor* _tmp54_;
				_tmp52_ = prop;
				_tmp53_ = vala_property_get_get_accessor (_tmp52_);
				_tmp54_ = _tmp53_;
				if (_tmp54_ != NULL) {
					ValaCCodeInitializerList* _tmp55_;
					ValaCCodeConstant* _tmp56_;
					ValaCCodeConstant* _tmp57_;
					_tmp55_ = info;
					_tmp56_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE");
					_tmp57_ = _tmp56_;
					vala_ccode_initializer_list_append (_tmp55_, (ValaCCodeExpression*) _tmp57_);
					_vala_ccode_node_unref0 (_tmp57_);
				} else {
					ValaProperty* _tmp58_;
					ValaPropertyAccessor* _tmp59_;
					ValaPropertyAccessor* _tmp60_;
					_tmp58_ = prop;
					_tmp59_ = vala_property_get_set_accessor (_tmp58_);
					_tmp60_ = _tmp59_;
					if (_tmp60_ != NULL) {
						ValaCCodeInitializerList* _tmp61_;
						ValaCCodeConstant* _tmp62_;
						ValaCCodeConstant* _tmp63_;
						_tmp61_ = info;
						_tmp62_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE");
						_tmp63_ = _tmp62_;
						vala_ccode_initializer_list_append (_tmp61_, (ValaCCodeExpression*) _tmp63_);
						_vala_ccode_node_unref0 (_tmp63_);
					} else {
						ValaCCodeInitializerList* _tmp64_;
						ValaCCodeConstant* _tmp65_;
						ValaCCodeConstant* _tmp66_;
						_tmp64_ = info;
						_tmp65_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_NONE");
						_tmp66_ = _tmp65_;
						vala_ccode_initializer_list_append (_tmp64_, (ValaCCodeExpression*) _tmp66_);
						_vala_ccode_node_unref0 (_tmp66_);
					}
				}
			}
			_tmp67_ = info;
			_tmp68_ = vala_ccode_constant_new ("NULL");
			_tmp69_ = _tmp68_;
			vala_ccode_initializer_list_append (_tmp67_, (ValaCCodeExpression*) _tmp69_);
			_vala_ccode_node_unref0 (_tmp69_);
			_tmp70_ = vala_ccode_declaration_new ("const GDBusPropertyInfo");
			_cdecl_ = _tmp70_;
			_tmp71_ = _cdecl_;
			_tmp72_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strconcat ("_", _tmp73_, NULL);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strconcat (_tmp75_, "dbus_property_info_", NULL);
			_tmp77_ = _tmp76_;
			_tmp78_ = prop;
			_tmp79_ = vala_symbol_get_name ((ValaSymbol*) _tmp78_);
			_tmp80_ = _tmp79_;
			_tmp81_ = g_strconcat (_tmp77_, _tmp80_, NULL);
			_tmp82_ = _tmp81_;
			_tmp83_ = info;
			_tmp84_ = vala_ccode_variable_declarator_new (_tmp82_, (ValaCCodeExpression*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			vala_ccode_declaration_add_declarator (_tmp71_, (ValaCCodeDeclarator*) _tmp85_);
			_vala_ccode_node_unref0 (_tmp85_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp73_);
			_tmp86_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp86_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp87_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp88_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp87_, (ValaCCodeNode*) _tmp88_);
			_tmp89_ = infos;
			_tmp90_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp91_ = _tmp90_;
			_tmp92_ = g_strconcat ("_", _tmp91_, NULL);
			_tmp93_ = _tmp92_;
			_tmp94_ = g_strconcat (_tmp93_, "dbus_property_info_", NULL);
			_tmp95_ = _tmp94_;
			_tmp96_ = prop;
			_tmp97_ = vala_symbol_get_name ((ValaSymbol*) _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp95_, _tmp98_, NULL);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_ccode_identifier_new (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp102_);
			_tmp104_ = _tmp103_;
			vala_ccode_initializer_list_append (_tmp89_, (ValaCCodeExpression*) _tmp104_);
			_vala_ccode_node_unref0 (_tmp104_);
			_vala_ccode_node_unref0 (_tmp102_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp95_);
			_g_free0 (_tmp93_);
			_g_free0 (_tmp91_);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (info);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp105_ = infos;
	_tmp106_ = vala_ccode_constant_new ("NULL");
	_tmp107_ = _tmp106_;
	vala_ccode_initializer_list_append (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vala_ccode_declaration_new ("const GDBusPropertyInfo * const");
	_cdecl_ = _tmp108_;
	_tmp109_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp110_ = _tmp109_;
	_tmp111_ = g_strconcat ("_", _tmp110_, NULL);
	_tmp112_ = _tmp111_;
	_tmp113_ = g_strconcat (_tmp112_, "dbus_property_info[]", NULL);
	_tmp114_ = _tmp113_;
	_tmp115_ = infos;
	_tmp116_ = vala_ccode_variable_declarator_new (_tmp114_, (ValaCCodeExpression*) _tmp115_, NULL);
	_tmp117_ = _tmp116_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp117_);
	_vala_ccode_node_unref0 (_tmp117_);
	_g_free0 (_tmp114_);
	_g_free0 (_tmp112_);
	_g_free0 (_tmp110_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp118_, (ValaCCodeNode*) _cdecl_);
	_tmp119_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp120_ = _tmp119_;
	_tmp121_ = g_strconcat ("_", _tmp120_, NULL);
	_tmp122_ = _tmp121_;
	_tmp123_ = g_strconcat (_tmp122_, "dbus_property_info", NULL);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new (_tmp124_);
	_tmp126_ = (ValaCCodeExpression*) _tmp125_;
	_g_free0 (_tmp124_);
	_g_free0 (_tmp122_);
	_g_free0 (_tmp120_);
	result = _tmp126_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}

static void
vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self,
                                           ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* info = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeConstant* _tmp1_;
	ValaCCodeConstant* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeUnaryExpression* _tmp12_;
	ValaCCodeCastExpression* _tmp13_;
	ValaCCodeCastExpression* _tmp14_;
	ValaCCodeExpression* _tmp15_;
	ValaCCodeExpression* _tmp16_;
	ValaCCodeUnaryExpression* _tmp17_;
	ValaCCodeUnaryExpression* _tmp18_;
	ValaCCodeCastExpression* _tmp19_;
	ValaCCodeCastExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeExpression* _tmp22_;
	ValaCCodeUnaryExpression* _tmp23_;
	ValaCCodeUnaryExpression* _tmp24_;
	ValaCCodeCastExpression* _tmp25_;
	ValaCCodeCastExpression* _tmp26_;
	ValaCCodeConstant* _tmp27_;
	ValaCCodeConstant* _tmp28_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaCCodeVariableDeclarator* _tmp36_;
	ValaCCodeVariableDeclarator* _tmp37_;
	ValaCCodeFile* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	info = _tmp0_;
	_tmp1_ = vala_ccode_constant_new ("-1");
	_tmp2_ = _tmp1_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp2_);
	_vala_ccode_node_unref0 (_tmp2_);
	_tmp3_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("\"%s\"", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_constant_new (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp8_);
	_vala_ccode_node_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = vala_gd_bus_module_get_method_info (self, sym);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp12_, "GDBusMethodInfo **");
	_tmp14_ = _tmp13_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp12_);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp15_ = vala_gd_bus_module_get_signal_info (self, sym);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp18_, "GDBusSignalInfo **");
	_tmp20_ = _tmp19_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp21_ = vala_gd_bus_module_get_property_info (self, sym);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp24_, "GDBusPropertyInfo **");
	_tmp26_ = _tmp25_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp26_);
	_vala_ccode_node_unref0 (_tmp26_);
	_vala_ccode_node_unref0 (_tmp24_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp27_ = vala_ccode_constant_new ("NULL");
	_tmp28_ = _tmp27_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = vala_ccode_declaration_new ("const GDBusInterfaceInfo");
	_cdecl_ = _tmp29_;
	_tmp30_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("_", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "dbus_interface_info", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_variable_declarator_new (_tmp35_, (ValaCCodeExpression*) info, NULL);
	_tmp37_ = _tmp36_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp38_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp38_, (ValaCCodeNode*) _cdecl_);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (info);
}

ValaCCodeExpression*
vala_gd_bus_module_get_interface_info (ValaGDBusModule* self,
                                       ValaObjectTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "dbus_interface_info", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_identifier_new (_tmp5_);
	_tmp7_ = (ValaCCodeExpression*) _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

static void
vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), cl);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) cl);
}

static void
vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (iface != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_interface ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), iface);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) iface);
}

static void
vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self,
                                             ValaObjectTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	vala_gd_bus_module_declare_interface_info (self, sym);
}

ValaGDBusModule*
vala_gd_bus_module_construct (GType object_type)
{
	ValaGDBusModule* self = NULL;
	self = (ValaGDBusModule*) vala_gvariant_module_construct (object_type);
	return self;
}

ValaGDBusModule*
vala_gd_bus_module_new (void)
{
	return vala_gd_bus_module_construct (VALA_TYPE_GD_BUS_MODULE);
}

static void
vala_gd_bus_module_class_init (ValaGDBusModuleClass * klass,
                               gpointer klass_data)
{
	vala_gd_bus_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gd_bus_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gd_bus_module_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gd_bus_module_real_visit_interface;
}

static void
vala_gd_bus_module_instance_init (ValaGDBusModule * self,
                                  gpointer klass)
{
}

GType
vala_gd_bus_module_get_type (void)
{
	static volatile gsize vala_gd_bus_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gd_bus_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gd_bus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGDBusModule), 0, (GInstanceInitFunc) vala_gd_bus_module_instance_init, NULL };
		GType vala_gd_bus_module_type_id;
		vala_gd_bus_module_type_id = g_type_register_static (VALA_TYPE_GVARIANT_MODULE, "ValaGDBusModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gd_bus_module_type_id__volatile, vala_gd_bus_module_type_id);
	}
	return vala_gd_bus_module_type_id__volatile;
}

