// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use FontFace;
use ffi;
use glib::GString;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct FontFamily(Object<ffi::PangoFontFamily, ffi::PangoFontFamilyClass, FontFamilyClass>);

    match fn {
        get_type => || ffi::pango_font_family_get_type(),
    }
}

pub const NONE_FONT_FAMILY: Option<&FontFamily> = None;

pub trait FontFamilyExt: 'static {
    fn get_name(&self) -> Option<GString>;

    fn is_monospace(&self) -> bool;

    fn list_faces(&self) -> Vec<FontFace>;
}

impl<O: IsA<FontFamily>> FontFamilyExt for O {
    fn get_name(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::pango_font_family_get_name(self.as_ref().to_glib_none().0))
        }
    }

    fn is_monospace(&self) -> bool {
        unsafe {
            from_glib(ffi::pango_font_family_is_monospace(self.as_ref().to_glib_none().0))
        }
    }

    fn list_faces(&self) -> Vec<FontFace> {
        unsafe {
            let mut faces = ptr::null_mut();
            let mut n_faces = mem::uninitialized();
            ffi::pango_font_family_list_faces(self.as_ref().to_glib_none().0, &mut faces, &mut n_faces);
            FromGlibContainer::from_glib_container_num(faces, n_faces as usize)
        }
    }
}

impl fmt::Display for FontFamily {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "FontFamily")
    }
}
