// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Icon;
use MenuModel;
use ffi;
use glib;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib_wrapper! {
    pub struct MenuItem(Object<ffi::GMenuItem, MenuItemClass>);

    match fn {
        get_type => || ffi::g_menu_item_get_type(),
    }
}

impl MenuItem {
    pub fn new<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b str>>>(label: P, detailed_action: Q) -> MenuItem {
        let label = label.into();
        let detailed_action = detailed_action.into();
        unsafe {
            from_glib_full(ffi::g_menu_item_new(label.to_glib_none().0, detailed_action.to_glib_none().0))
        }
    }

    pub fn new_from_model<P: IsA<MenuModel>>(model: &P, item_index: i32) -> MenuItem {
        unsafe {
            from_glib_full(ffi::g_menu_item_new_from_model(model.as_ref().to_glib_none().0, item_index))
        }
    }

    pub fn new_section<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(label: P, section: &Q) -> MenuItem {
        let label = label.into();
        unsafe {
            from_glib_full(ffi::g_menu_item_new_section(label.to_glib_none().0, section.as_ref().to_glib_none().0))
        }
    }

    pub fn new_submenu<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(label: P, submenu: &Q) -> MenuItem {
        let label = label.into();
        unsafe {
            from_glib_full(ffi::g_menu_item_new_submenu(label.to_glib_none().0, submenu.as_ref().to_glib_none().0))
        }
    }

    //pub fn get_attribute(&self, attribute: &str, format_string: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> bool {
    //    unsafe { TODO: call ffi::g_menu_item_get_attribute() }
    //}

    pub fn get_attribute_value<'a, P: Into<Option<&'a glib::VariantTy>>>(&self, attribute: &str, expected_type: P) -> Option<glib::Variant> {
        let expected_type = expected_type.into();
        unsafe {
            from_glib_full(ffi::g_menu_item_get_attribute_value(self.to_glib_none().0, attribute.to_glib_none().0, expected_type.to_glib_none().0))
        }
    }

    pub fn get_link(&self, link: &str) -> Option<MenuModel> {
        unsafe {
            from_glib_full(ffi::g_menu_item_get_link(self.to_glib_none().0, link.to_glib_none().0))
        }
    }

    //pub fn set_action_and_target<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b str>>>(&self, action: P, format_string: Q, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) {
    //    unsafe { TODO: call ffi::g_menu_item_set_action_and_target() }
    //}

    pub fn set_action_and_target_value<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b glib::Variant>>>(&self, action: P, target_value: Q) {
        let action = action.into();
        let target_value = target_value.into();
        unsafe {
            ffi::g_menu_item_set_action_and_target_value(self.to_glib_none().0, action.to_glib_none().0, target_value.to_glib_none().0);
        }
    }

    //pub fn set_attribute<'a, P: Into<Option<&'a str>>>(&self, attribute: &str, format_string: P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) {
    //    unsafe { TODO: call ffi::g_menu_item_set_attribute() }
    //}

    pub fn set_attribute_value<'a, P: Into<Option<&'a glib::Variant>>>(&self, attribute: &str, value: P) {
        let value = value.into();
        unsafe {
            ffi::g_menu_item_set_attribute_value(self.to_glib_none().0, attribute.to_glib_none().0, value.to_glib_none().0);
        }
    }

    pub fn set_detailed_action(&self, detailed_action: &str) {
        unsafe {
            ffi::g_menu_item_set_detailed_action(self.to_glib_none().0, detailed_action.to_glib_none().0);
        }
    }

    pub fn set_icon<P: IsA<Icon>>(&self, icon: &P) {
        unsafe {
            ffi::g_menu_item_set_icon(self.to_glib_none().0, icon.as_ref().to_glib_none().0);
        }
    }

    pub fn set_label<'a, P: Into<Option<&'a str>>>(&self, label: P) {
        let label = label.into();
        unsafe {
            ffi::g_menu_item_set_label(self.to_glib_none().0, label.to_glib_none().0);
        }
    }

    pub fn set_link<'a, P: IsA<MenuModel> + 'a, Q: Into<Option<&'a P>>>(&self, link: &str, model: Q) {
        let model = model.into();
        unsafe {
            ffi::g_menu_item_set_link(self.to_glib_none().0, link.to_glib_none().0, model.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    pub fn set_section<'a, P: IsA<MenuModel> + 'a, Q: Into<Option<&'a P>>>(&self, section: Q) {
        let section = section.into();
        unsafe {
            ffi::g_menu_item_set_section(self.to_glib_none().0, section.map(|p| p.as_ref()).to_glib_none().0);
        }
    }

    pub fn set_submenu<'a, P: IsA<MenuModel> + 'a, Q: Into<Option<&'a P>>>(&self, submenu: Q) {
        let submenu = submenu.into();
        unsafe {
            ffi::g_menu_item_set_submenu(self.to_glib_none().0, submenu.map(|p| p.as_ref()).to_glib_none().0);
        }
    }
}

impl fmt::Display for MenuItem {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "MenuItem")
    }
}
