// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use MenuItem;
use MenuModel;
use ffi;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib_wrapper! {
    pub struct Menu(Object<ffi::GMenu, MenuClass>) @extends MenuModel;

    match fn {
        get_type => || ffi::g_menu_get_type(),
    }
}

impl Menu {
    pub fn new() -> Menu {
        unsafe {
            from_glib_full(ffi::g_menu_new())
        }
    }

    pub fn append<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b str>>>(&self, label: P, detailed_action: Q) {
        let label = label.into();
        let detailed_action = detailed_action.into();
        unsafe {
            ffi::g_menu_append(self.to_glib_none().0, label.to_glib_none().0, detailed_action.to_glib_none().0);
        }
    }

    pub fn append_item(&self, item: &MenuItem) {
        unsafe {
            ffi::g_menu_append_item(self.to_glib_none().0, item.to_glib_none().0);
        }
    }

    pub fn append_section<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(&self, label: P, section: &Q) {
        let label = label.into();
        unsafe {
            ffi::g_menu_append_section(self.to_glib_none().0, label.to_glib_none().0, section.as_ref().to_glib_none().0);
        }
    }

    pub fn append_submenu<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(&self, label: P, submenu: &Q) {
        let label = label.into();
        unsafe {
            ffi::g_menu_append_submenu(self.to_glib_none().0, label.to_glib_none().0, submenu.as_ref().to_glib_none().0);
        }
    }

    pub fn freeze(&self) {
        unsafe {
            ffi::g_menu_freeze(self.to_glib_none().0);
        }
    }

    pub fn insert<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b str>>>(&self, position: i32, label: P, detailed_action: Q) {
        let label = label.into();
        let detailed_action = detailed_action.into();
        unsafe {
            ffi::g_menu_insert(self.to_glib_none().0, position, label.to_glib_none().0, detailed_action.to_glib_none().0);
        }
    }

    pub fn insert_item(&self, position: i32, item: &MenuItem) {
        unsafe {
            ffi::g_menu_insert_item(self.to_glib_none().0, position, item.to_glib_none().0);
        }
    }

    pub fn insert_section<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(&self, position: i32, label: P, section: &Q) {
        let label = label.into();
        unsafe {
            ffi::g_menu_insert_section(self.to_glib_none().0, position, label.to_glib_none().0, section.as_ref().to_glib_none().0);
        }
    }

    pub fn insert_submenu<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(&self, position: i32, label: P, submenu: &Q) {
        let label = label.into();
        unsafe {
            ffi::g_menu_insert_submenu(self.to_glib_none().0, position, label.to_glib_none().0, submenu.as_ref().to_glib_none().0);
        }
    }

    pub fn prepend<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b str>>>(&self, label: P, detailed_action: Q) {
        let label = label.into();
        let detailed_action = detailed_action.into();
        unsafe {
            ffi::g_menu_prepend(self.to_glib_none().0, label.to_glib_none().0, detailed_action.to_glib_none().0);
        }
    }

    pub fn prepend_item(&self, item: &MenuItem) {
        unsafe {
            ffi::g_menu_prepend_item(self.to_glib_none().0, item.to_glib_none().0);
        }
    }

    pub fn prepend_section<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(&self, label: P, section: &Q) {
        let label = label.into();
        unsafe {
            ffi::g_menu_prepend_section(self.to_glib_none().0, label.to_glib_none().0, section.as_ref().to_glib_none().0);
        }
    }

    pub fn prepend_submenu<'a, P: Into<Option<&'a str>>, Q: IsA<MenuModel>>(&self, label: P, submenu: &Q) {
        let label = label.into();
        unsafe {
            ffi::g_menu_prepend_submenu(self.to_glib_none().0, label.to_glib_none().0, submenu.as_ref().to_glib_none().0);
        }
    }

    pub fn remove(&self, position: i32) {
        unsafe {
            ffi::g_menu_remove(self.to_glib_none().0, position);
        }
    }

    pub fn remove_all(&self) {
        unsafe {
            ffi::g_menu_remove_all(self.to_glib_none().0);
        }
    }
}

impl Default for Menu {
    fn default() -> Self {
        Self::new()
    }
}

impl fmt::Display for Menu {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Menu")
    }
}
