// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use OutputStream;
use PollableOutputStream;
use Seekable;
use ffi;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect_raw;
use glib::translate::*;
use glib_ffi;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib_wrapper! {
    pub struct MemoryOutputStream(Object<ffi::GMemoryOutputStream, ffi::GMemoryOutputStreamClass, MemoryOutputStreamClass>) @extends OutputStream, @implements PollableOutputStream, Seekable;

    match fn {
        get_type => || ffi::g_memory_output_stream_get_type(),
    }
}

impl MemoryOutputStream {
    pub fn new_resizable() -> MemoryOutputStream {
        unsafe {
            OutputStream::from_glib_full(ffi::g_memory_output_stream_new_resizable()).unsafe_cast()
        }
    }
}

pub const NONE_MEMORY_OUTPUT_STREAM: Option<&MemoryOutputStream> = None;

pub trait MemoryOutputStreamExt: 'static {
    fn get_data_size(&self) -> usize;

    fn steal_as_bytes(&self) -> Option<glib::Bytes>;

    fn connect_property_data_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<MemoryOutputStream>> MemoryOutputStreamExt for O {
    fn get_data_size(&self) -> usize {
        unsafe {
            ffi::g_memory_output_stream_get_data_size(self.as_ref().to_glib_none().0)
        }
    }

    fn steal_as_bytes(&self) -> Option<glib::Bytes> {
        unsafe {
            from_glib_full(ffi::g_memory_output_stream_steal_as_bytes(self.as_ref().to_glib_none().0))
        }
    }

    fn connect_property_data_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::data-size\0".as_ptr() as *const _,
                Some(transmute(notify_data_size_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

unsafe extern "C" fn notify_data_size_trampoline<P, F: Fn(&P) + 'static>(this: *mut ffi::GMemoryOutputStream, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<MemoryOutputStream> {
    let f: &F = transmute(f);
    f(&MemoryOutputStream::from_glib_borrow(this).unsafe_cast())
}

impl fmt::Display for MemoryOutputStream {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "MemoryOutputStream")
    }
}
