// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use AppInfoCreateFlags;
use AppLaunchContext;
#[cfg(any(feature = "v2_50", feature = "dox"))]
use Cancellable;
use Error;
use File;
use Icon;
use ffi;
#[cfg(feature = "futures")]
#[cfg(any(feature = "v2_50", feature = "dox"))]
use futures_core;
use glib::GString;
use glib::object::IsA;
use glib::translate::*;
#[cfg(any(feature = "v2_50", feature = "dox"))]
use glib_ffi;
#[cfg(any(feature = "v2_50", feature = "dox"))]
use gobject_ffi;
use std;
#[cfg(feature = "futures")]
#[cfg(any(feature = "v2_50", feature = "dox"))]
use std::boxed::Box as Box_;
use std::fmt;
use std::ptr;

glib_wrapper! {
    pub struct AppInfo(Interface<ffi::GAppInfo>);

    match fn {
        get_type => || ffi::g_app_info_get_type(),
    }
}

impl AppInfo {
    pub fn create_from_commandline<'a, P: AsRef<std::ffi::OsStr>, Q: Into<Option<&'a str>>>(commandline: P, application_name: Q, flags: AppInfoCreateFlags) -> Result<AppInfo, Error> {
        let application_name = application_name.into();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_app_info_create_from_commandline(commandline.as_ref().to_glib_none().0, application_name.to_glib_none().0, flags.to_glib(), &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    pub fn get_all() -> Vec<AppInfo> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_app_info_get_all())
        }
    }

    pub fn get_all_for_type(content_type: &str) -> Vec<AppInfo> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_app_info_get_all_for_type(content_type.to_glib_none().0))
        }
    }

    pub fn get_default_for_type(content_type: &str, must_support_uris: bool) -> Option<AppInfo> {
        unsafe {
            from_glib_full(ffi::g_app_info_get_default_for_type(content_type.to_glib_none().0, must_support_uris.to_glib()))
        }
    }

    pub fn get_default_for_uri_scheme(uri_scheme: &str) -> Option<AppInfo> {
        unsafe {
            from_glib_full(ffi::g_app_info_get_default_for_uri_scheme(uri_scheme.to_glib_none().0))
        }
    }

    pub fn get_fallback_for_type(content_type: &str) -> Vec<AppInfo> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_app_info_get_fallback_for_type(content_type.to_glib_none().0))
        }
    }

    pub fn get_recommended_for_type(content_type: &str) -> Vec<AppInfo> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_app_info_get_recommended_for_type(content_type.to_glib_none().0))
        }
    }

    pub fn launch_default_for_uri<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(uri: &str, context: Q) -> Result<(), Error> {
        let context = context.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_launch_default_for_uri(uri.to_glib_none().0, context.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    pub fn launch_default_for_uri_async<'a, 'b, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>, T: FnOnce(Result<(), Error>) + Send + 'static>(uri: &str, context: Q, cancellable: S, callback: T) {
        let context = context.into();
        let cancellable = cancellable.into();
        let user_data: Box<T> = Box::new(callback);
        unsafe extern "C" fn launch_default_for_uri_async_trampoline<T: FnOnce(Result<(), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_launch_default_for_uri_finish(res, &mut error);
            let result = if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) };
            let callback: Box<T> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = launch_default_for_uri_async_trampoline::<T>;
        unsafe {
            ffi::g_app_info_launch_default_for_uri_async(uri.to_glib_none().0, context.map(|p| p.as_ref()).to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    #[cfg(any(feature = "v2_50", feature = "dox"))]
    pub fn launch_default_for_uri_async_future<'a, P: IsA<AppLaunchContext> + Clone + 'static, Q: Into<Option<&'a P>>>(uri: &str, context: Q) -> Box_<futures_core::Future<Item = (), Error = Error>> {
        use GioFuture;
        use fragile::Fragile;

        let uri = String::from(uri);
        let context = context.into();
        let context = context.map(ToOwned::to_owned);
        GioFuture::new(&(), move |_obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            Self::launch_default_for_uri_async(
                 &uri,
                 context.as_ref().map(::std::borrow::Borrow::borrow),
                 Some(&cancellable),
                 move |res| {
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }

    pub fn reset_type_associations(content_type: &str) {
        unsafe {
            ffi::g_app_info_reset_type_associations(content_type.to_glib_none().0);
        }
    }
}

pub const NONE_APP_INFO: Option<&AppInfo> = None;

pub trait AppInfoExt: 'static {
    fn add_supports_type(&self, content_type: &str) -> Result<(), Error>;

    fn can_delete(&self) -> bool;

    fn can_remove_supports_type(&self) -> bool;

    fn delete(&self) -> bool;

    fn dup(&self) -> Option<AppInfo>;

    fn equal<P: IsA<AppInfo>>(&self, appinfo2: &P) -> bool;

    fn get_commandline(&self) -> Option<std::path::PathBuf>;

    fn get_description(&self) -> Option<GString>;

    fn get_display_name(&self) -> Option<GString>;

    fn get_executable(&self) -> Option<std::path::PathBuf>;

    fn get_icon(&self) -> Option<Icon>;

    fn get_id(&self) -> Option<GString>;

    fn get_name(&self) -> Option<GString>;

    fn get_supported_types(&self) -> Vec<GString>;

    fn launch<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, files: &[File], context: Q) -> Result<(), Error>;

    fn launch_uris<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, uris: &[&str], context: Q) -> Result<(), Error>;

    fn remove_supports_type(&self, content_type: &str) -> Result<(), Error>;

    fn set_as_default_for_extension<P: AsRef<std::path::Path>>(&self, extension: P) -> Result<(), Error>;

    fn set_as_default_for_type(&self, content_type: &str) -> Result<(), Error>;

    fn set_as_last_used_for_type(&self, content_type: &str) -> Result<(), Error>;

    fn should_show(&self) -> bool;

    fn supports_files(&self) -> bool;

    fn supports_uris(&self) -> bool;
}

impl<O: IsA<AppInfo>> AppInfoExt for O {
    fn add_supports_type(&self, content_type: &str) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_add_supports_type(self.as_ref().to_glib_none().0, content_type.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn can_delete(&self) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_can_delete(self.as_ref().to_glib_none().0))
        }
    }

    fn can_remove_supports_type(&self) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_can_remove_supports_type(self.as_ref().to_glib_none().0))
        }
    }

    fn delete(&self) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_delete(self.as_ref().to_glib_none().0))
        }
    }

    fn dup(&self) -> Option<AppInfo> {
        unsafe {
            from_glib_full(ffi::g_app_info_dup(self.as_ref().to_glib_none().0))
        }
    }

    fn equal<P: IsA<AppInfo>>(&self, appinfo2: &P) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_equal(self.as_ref().to_glib_none().0, appinfo2.as_ref().to_glib_none().0))
        }
    }

    fn get_commandline(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_commandline(self.as_ref().to_glib_none().0))
        }
    }

    fn get_description(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_description(self.as_ref().to_glib_none().0))
        }
    }

    fn get_display_name(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_display_name(self.as_ref().to_glib_none().0))
        }
    }

    fn get_executable(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_executable(self.as_ref().to_glib_none().0))
        }
    }

    fn get_icon(&self) -> Option<Icon> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_icon(self.as_ref().to_glib_none().0))
        }
    }

    fn get_id(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_id(self.as_ref().to_glib_none().0))
        }
    }

    fn get_name(&self) -> Option<GString> {
        unsafe {
            from_glib_none(ffi::g_app_info_get_name(self.as_ref().to_glib_none().0))
        }
    }

    fn get_supported_types(&self) -> Vec<GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_app_info_get_supported_types(self.as_ref().to_glib_none().0))
        }
    }

    fn launch<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, files: &[File], context: Q) -> Result<(), Error> {
        let context = context.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_launch(self.as_ref().to_glib_none().0, files.to_glib_none().0, context.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn launch_uris<'a, P: IsA<AppLaunchContext> + 'a, Q: Into<Option<&'a P>>>(&self, uris: &[&str], context: Q) -> Result<(), Error> {
        let context = context.into();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_launch_uris(self.as_ref().to_glib_none().0, uris.to_glib_none().0, context.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn remove_supports_type(&self, content_type: &str) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_remove_supports_type(self.as_ref().to_glib_none().0, content_type.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_as_default_for_extension<P: AsRef<std::path::Path>>(&self, extension: P) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_set_as_default_for_extension(self.as_ref().to_glib_none().0, extension.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_as_default_for_type(&self, content_type: &str) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_set_as_default_for_type(self.as_ref().to_glib_none().0, content_type.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_as_last_used_for_type(&self, content_type: &str) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_app_info_set_as_last_used_for_type(self.as_ref().to_glib_none().0, content_type.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn should_show(&self) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_should_show(self.as_ref().to_glib_none().0))
        }
    }

    fn supports_files(&self) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_supports_files(self.as_ref().to_glib_none().0))
        }
    }

    fn supports_uris(&self) -> bool {
        unsafe {
            from_glib(ffi::g_app_info_supports_uris(self.as_ref().to_glib_none().0))
        }
    }
}

impl fmt::Display for AppInfo {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "AppInfo")
    }
}
