// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Error;
use Pixbuf;
use PixbufAnimation;
use PixbufFormat;
use ffi;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect_raw;
use glib::translate::*;
use glib_ffi;
use libc;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct PixbufLoader(Object<ffi::GdkPixbufLoader, ffi::GdkPixbufLoaderClass, PixbufLoaderClass>);

    match fn {
        get_type => || ffi::gdk_pixbuf_loader_get_type(),
    }
}

impl PixbufLoader {
    pub fn new() -> PixbufLoader {
        unsafe {
            from_glib_full(ffi::gdk_pixbuf_loader_new())
        }
    }

    pub fn new_with_mime_type(mime_type: &str) -> Result<PixbufLoader, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gdk_pixbuf_loader_new_with_mime_type(mime_type.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    pub fn new_with_type(image_type: &str) -> Result<PixbufLoader, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gdk_pixbuf_loader_new_with_type(image_type.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }
}

impl Default for PixbufLoader {
    fn default() -> Self {
        Self::new()
    }
}

pub const NONE_PIXBUF_LOADER: Option<&PixbufLoader> = None;

pub trait PixbufLoaderExt: 'static {
    fn close(&self) -> Result<(), Error>;

    fn get_animation(&self) -> Option<PixbufAnimation>;

    fn get_format(&self) -> Option<PixbufFormat>;

    fn get_pixbuf(&self) -> Option<Pixbuf>;

    fn set_size(&self, width: i32, height: i32);

    fn write(&self, buf: &[u8]) -> Result<(), Error>;

    fn write_bytes(&self, buffer: &glib::Bytes) -> Result<(), Error>;

    fn connect_area_prepared<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_area_updated<F: Fn(&Self, i32, i32, i32, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_closed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_size_prepared<F: Fn(&Self, i32, i32) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<PixbufLoader>> PixbufLoaderExt for O {
    fn close(&self) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gdk_pixbuf_loader_close(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn get_animation(&self) -> Option<PixbufAnimation> {
        unsafe {
            from_glib_none(ffi::gdk_pixbuf_loader_get_animation(self.as_ref().to_glib_none().0))
        }
    }

    fn get_format(&self) -> Option<PixbufFormat> {
        unsafe {
            from_glib_none(ffi::gdk_pixbuf_loader_get_format(self.as_ref().to_glib_none().0))
        }
    }

    fn get_pixbuf(&self) -> Option<Pixbuf> {
        unsafe {
            from_glib_none(ffi::gdk_pixbuf_loader_get_pixbuf(self.as_ref().to_glib_none().0))
        }
    }

    fn set_size(&self, width: i32, height: i32) {
        unsafe {
            ffi::gdk_pixbuf_loader_set_size(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn write(&self, buf: &[u8]) -> Result<(), Error> {
        let count = buf.len() as usize;
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gdk_pixbuf_loader_write(self.as_ref().to_glib_none().0, buf.to_glib_none().0, count, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn write_bytes(&self, buffer: &glib::Bytes) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gdk_pixbuf_loader_write_bytes(self.as_ref().to_glib_none().0, buffer.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn connect_area_prepared<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"area-prepared\0".as_ptr() as *const _,
                Some(transmute(area_prepared_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_area_updated<F: Fn(&Self, i32, i32, i32, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"area-updated\0".as_ptr() as *const _,
                Some(transmute(area_updated_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_closed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"closed\0".as_ptr() as *const _,
                Some(transmute(closed_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }

    fn connect_size_prepared<F: Fn(&Self, i32, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"size-prepared\0".as_ptr() as *const _,
                Some(transmute(size_prepared_trampoline::<Self, F> as usize)), Box_::into_raw(f))
        }
    }
}

unsafe extern "C" fn area_prepared_trampoline<P, F: Fn(&P) + 'static>(this: *mut ffi::GdkPixbufLoader, f: glib_ffi::gpointer)
where P: IsA<PixbufLoader> {
    let f: &F = transmute(f);
    f(&PixbufLoader::from_glib_borrow(this).unsafe_cast())
}

unsafe extern "C" fn area_updated_trampoline<P, F: Fn(&P, i32, i32, i32, i32) + 'static>(this: *mut ffi::GdkPixbufLoader, x: libc::c_int, y: libc::c_int, width: libc::c_int, height: libc::c_int, f: glib_ffi::gpointer)
where P: IsA<PixbufLoader> {
    let f: &F = transmute(f);
    f(&PixbufLoader::from_glib_borrow(this).unsafe_cast(), x, y, width, height)
}

unsafe extern "C" fn closed_trampoline<P, F: Fn(&P) + 'static>(this: *mut ffi::GdkPixbufLoader, f: glib_ffi::gpointer)
where P: IsA<PixbufLoader> {
    let f: &F = transmute(f);
    f(&PixbufLoader::from_glib_borrow(this).unsafe_cast())
}

unsafe extern "C" fn size_prepared_trampoline<P, F: Fn(&P, i32, i32) + 'static>(this: *mut ffi::GdkPixbufLoader, width: libc::c_int, height: libc::c_int, f: glib_ffi::gpointer)
where P: IsA<PixbufLoader> {
    let f: &F = transmute(f);
    f(&PixbufLoader::from_glib_borrow(this).unsafe_cast(), width, height)
}

impl fmt::Display for PixbufLoader {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "PixbufLoader")
    }
}
