/* rygel-media-export-root-container.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009-2013 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <rygel-core.h>
#include <rygel-db.h>

#define RYGEL_MEDIA_EXPORT_TYPE_FOLDER_DEFINITION (rygel_media_export_folder_definition_get_type ())
typedef struct _RygelMediaExportFolderDefinition RygelMediaExportFolderDefinition;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;
typedef struct _RygelMediaExportTrackableDbContainerPrivate RygelMediaExportTrackableDbContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_root_container_properties[RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER (rygel_media_export_playlist_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))

typedef struct _RygelMediaExportPlaylistRootContainer RygelMediaExportPlaylistRootContainer;
typedef struct _RygelMediaExportPlaylistRootContainerClass RygelMediaExportPlaylistRootContainerClass;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

struct _RygelMediaExportFolderDefinition {
	gchar* title;
	gchar* definition;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	gint (*count_children) (RygelMediaExportDBContainer* self);
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportTrackableDbContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportTrackableDbContainerPrivate * priv;
};

struct _RygelMediaExportTrackableDbContainerClass {
	RygelMediaExportDBContainerClass parent_class;
	void (*remove_child) (RygelMediaExportTrackableDbContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelMediaExportTrackableDbContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelMediaExportTrackableDbContainer* self);
	void (*set_service_reset_token) (RygelMediaExportTrackableDbContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelMediaExportTrackableDbContainer* self);
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportTrackableDbContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportTrackableDbContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportHarvester* harvester;
	GCancellable* cancellable;
	RygelMediaExportDBContainer* filesystem_container;
	gulong harvester_signal_id;
	gulong filesystem_signal_id;
	gboolean initialized;
};

struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* object;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	gchar** parts;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint parts_length1;
	gint _parts_size_;
	gchar* parent_id;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelMediaObject* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaObject* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp11_;
	RygelMediaContainer* _tmp12_;
	RygelMediaContainer* _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaContainer* _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelMediaExportQueryContainerFactory* factory;
	RygelMediaExportQueryContainerFactory* _tmp18_;
	RygelMediaExportQueryContainer* _vala1_container;
	RygelMediaExportQueryContainerFactory* _tmp19_;
	RygelMediaExportQueryContainer* _tmp20_;
	RygelMediaExportQueryContainer* _tmp21_;
	RygelMediaExportQueryContainer* _tmp22_;
	gchar* tmp_id;
	gchar* _tmp23_;
	gchar** _vala1_parts;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _vala1_parts_length1;
	gint __vala1_parts_size_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	RygelMediaObject* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	RygelMediaObject* _tmp31_;
	RygelMediaObject* _tmp32_;
	RygelMediaObject* _tmp33_;
	RygelMediaObject* _tmp34_;
	RygelMediaObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	RygelMediaObject* _tmp38_;
	RygelMediaExportQueryContainerFactory* _vala1_factory;
	RygelMediaExportQueryContainerFactory* _tmp39_;
	gchar* container_id;
	gchar** _tmp40_;
	gint _tmp40__length1;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	RygelMediaExportQueryContainer* _vala2_container;
	RygelMediaExportQueryContainerFactory* _tmp43_;
	const gchar* _tmp44_;
	RygelMediaExportQueryContainer* _tmp45_;
	RygelMediaExportQueryContainer* _tmp46_;
	RygelMediaObject* _tmp47_;
	RygelMediaExportQueryContainer* _tmp48_;
	GError* _inner_error0_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	gchar* upnp_class;
	RygelRelationalExpression* relational_expression;
	RygelRelationalExpression* _tmp4_;
	RygelRelationalExpression* _tmp5_;
	RygelMediaContainer* _tmp6_;
	RygelRelationalExpression* _tmp7_;
	gconstpointer _tmp8_;
	gchar* _tmp9_;
	RygelMediaContainer* _tmp10_;
	gboolean _tmp11_;
	RygelMediaContainer* _tmp12_;
	RygelMediaObjects* _tmp13_;
	RygelMediaContainer* _tmp14_;
	RygelMediaObjects* _tmp15_;
	RygelMediaObjects* _tmp16_;
	RygelMediaContainer* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	const gchar* _tmp20_;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* _tmp22_;
	gint _object_size;
	RygelMediaObjects* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _object_index;
	RygelMediaObject* object;
	RygelMediaObjects* _tmp26_;
	gpointer _tmp27_;
	RygelMediaObject* _tmp28_;
	const gchar* _tmp29_;
	RygelMediaObjects* _tmp30_;
	guint _tmp31_;
	RygelMediaObjects* _tmp32_;
	RygelMediaObjects* _tmp33_;
	GError* _inner_error0_;
};

static gint RygelMediaExportRootContainer_private_offset;
static gpointer rygel_media_export_root_container_parent_class = NULL;
static RygelMediaExportRootContainer* rygel_media_export_root_container_instance;
static RygelMediaExportRootContainer* rygel_media_export_root_container_instance = NULL;

GType rygel_media_export_folder_definition_get_type (void) G_GNUC_CONST;
RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self,
                                                RygelMediaExportFolderDefinition* dest);
void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportDBContainer, g_object_unref)
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportMediaCache, g_object_unref)
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportTrackableDbContainer, g_object_unref)
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportRootContainer, g_object_unref)
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportHarvester, g_object_unref)
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME N_ ("Files & Folders")
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_SEARCH_CONTAINER_PREFIX RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "upnp:class," RYGEL_MUSIC_ITEM_UPNP_CLASS ","
void rygel_media_export_root_container_ensure_exists (GError** error);
void rygel_media_export_media_cache_ensure_exists (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (void);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type);
RygelMediaExportRootContainer* rygel_media_export_root_container_get_instance (void);
RygelMediaExportDBContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base,
                                                         const gchar* id,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_TRACK_PREFIX "dvd-track"
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PREFIX "dvd"
GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportQueryContainerFactory, g_object_unref)
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportQueryContainer, g_object_unref)
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self,
                                                                                                  const gchar* id,
                                                                                                  const gchar* name);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX "virtual-id:"
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base,
                                                    RygelSearchExpression* expression,
                                                    guint offset,
                                                    guint max_count,
                                                    const gchar* sort_criteria,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self,
                                             RygelSearchExpression* expression,
                                             guint offset,
                                             guint max_count,
                                             const gchar* sort_criteria,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self,
                                                                  GAsyncResult* _res_,
                                                                  guint* total_matches,
                                                                  GError** error);
static void rygel_media_export_root_container_search_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static RygelMediaContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self,
                                                                                    RygelRelationalExpression* expression);
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self,
                                                                           RygelSearchExpression* expression,
                                                                           RygelMediaContainer* * container);
static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_new (void);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_construct (GType object_type);
GType rygel_media_export_playlist_root_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportPlaylistRootContainer, g_object_unref)
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self,
                                                                                                       const gchar* definition_id,
                                                                                                       const gchar* name);
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self,
                                                                                    const gchar* hash);
static gint rygel_media_export_root_container_real_count_children (RygelMediaExportDBContainer* base);
gint rygel_media_export_db_container_count_children (RygelMediaExportDBContainer* self);
static guint32 rygel_media_export_root_container_real_get_system_update_id (RygelMediaExportTrackableDbContainer* base);
guint32 rygel_media_export_trackable_db_container_get_system_update_id (RygelMediaExportTrackableDbContainer* self);
static gboolean __lambda8_ (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_init (RygelMediaExportRootContainer* self,
                                             GError** error);
static gboolean ___lambda8__gsource_func (gpointer self);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self,
                                                    RygelMediaContainer* container,
                                                    GError** error);
RygelMediaExportTrackableDbContainer* rygel_media_export_trackable_db_container_new (const gchar* id,
                                                                                     const gchar* title);
RygelMediaExportTrackableDbContainer* rygel_media_export_trackable_db_container_construct (GType object_type,
                                                                                           const gchar* id,
                                                                                           const gchar* title);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self,
                                                            const gchar* container_id,
                                                            GError** error);
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable,
                                                             GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type,
                                                                   GCancellable* cancellable,
                                                                   GeeArrayList* locations);
static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self);
static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender,
                                                                                                      gpointer self);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self,
                                                  const gchar* id,
                                                  GError** error);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self,
                                                          GError** error);
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self,
                                                      RygelMediaContainer* parent);
static void rygel_media_export_root_container_root_updated (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_on_setting_changed (RygelMediaExportRootContainer* self,
                                                           const gchar* section,
                                                           const gchar* key);
static void _rygel_media_export_root_container_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                                const gchar* section,
                                                                                                const gchar* key,
                                                                                                gpointer self);
#define RYGEL_MEDIA_EXPORT_PLUGIN_NAME "MediaExport"
static void rygel_media_export_root_container_handle_uri_config_change (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_handle_virtual_folder_change (RygelMediaExportRootContainer* self);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self,
                                          GFile* file);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self,
                                            GFile* file,
                                            RygelMediaContainer* parent);
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
static void __lambda9_ (RygelMediaExportRootContainer* self);
static void ___lambda9__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                          RygelMediaContainer* container,
                                                          RygelMediaObject* object,
                                                          RygelObjectEventType event_type,
                                                          gboolean sub_tree_update,
                                                          gpointer self);
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self,
                                                                         const gchar* parent,
                                                                         const gchar* item_class,
                                                                         RygelMediaExportFolderDefinition* definitions,
                                                                         gint definitions_length1,
                                                                         GError** error);
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self,
                                                              RygelMediaContainer* container,
                                                              const gchar* item_class,
                                                              RygelMediaExportFolderDefinition* definition,
                                                              GError** error);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelNullContainer, g_object_unref)
RygelNullContainer* rygel_null_container_new (const gchar* id,
                                              RygelMediaContainer* parent,
                                              const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type,
                                                    const gchar* id,
                                                    RygelMediaContainer* parent,
                                                    const gchar* title);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self,
                                                     const gchar* container_id,
                                                     GError** error);
static void rygel_media_export_root_container_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const RygelMediaExportFolderDefinition VIRTUAL_FOLDERS_DEFAULT[2] = {{N_ ("Year"), "dc:date,?"}, {N_ ("All"), ""}};
const RygelMediaExportFolderDefinition VIRTUAL_FOLDERS_MUSIC[3] = {{N_ ("Artist"), "upnp:artist,?,upnp:album,?"}, {N_ ("Album"), "upnp:album,?"}, {N_ ("Genre"), "dc:genre,?"}};

void
rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self,
                                           RygelMediaExportFolderDefinition* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp1_;
	_tmp2_ = (*self).definition;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).definition);
	(*dest).definition = _tmp3_;
}

void
rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self)
{
	_g_free0 ((*self).title);
	_g_free0 ((*self).definition);
}

RygelMediaExportFolderDefinition*
rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self)
{
	RygelMediaExportFolderDefinition* dup;
	dup = g_new0 (RygelMediaExportFolderDefinition, 1);
	rygel_media_export_folder_definition_copy (self, dup);
	return dup;
}

void
rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self)
{
	rygel_media_export_folder_definition_destroy (self);
	g_free (self);
}

GType
rygel_media_export_folder_definition_get_type (void)
{
	static volatile gsize rygel_media_export_folder_definition_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_folder_definition_type_id__volatile)) {
		GType rygel_media_export_folder_definition_type_id;
		rygel_media_export_folder_definition_type_id = g_boxed_type_register_static ("RygelMediaExportFolderDefinition", (GBoxedCopyFunc) rygel_media_export_folder_definition_dup, (GBoxedFreeFunc) rygel_media_export_folder_definition_free);
		g_once_init_leave (&rygel_media_export_folder_definition_type_id__volatile, rygel_media_export_folder_definition_type_id);
	}
	return rygel_media_export_folder_definition_type_id__volatile;
}

static inline gpointer
rygel_media_export_root_container_get_instance_private (RygelMediaExportRootContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportRootContainer_private_offset);
}

void
rygel_media_export_root_container_ensure_exists (GError** error)
{
	RygelMediaExportRootContainer* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = rygel_media_export_root_container_instance;
	if (_tmp0_ == NULL) {
		RygelMediaExportRootContainer* _tmp1_;
		rygel_media_export_media_cache_ensure_exists (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_tmp1_ = rygel_media_export_root_container_new ();
		_g_object_unref0 (rygel_media_export_root_container_instance);
		rygel_media_export_root_container_instance = _tmp1_;
	}
}

/**
     * Get the single instance of the root container.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMediaExportRootContainer*
rygel_media_export_root_container_get_instance (void)
{
	RygelMediaExportRootContainer* result = NULL;
	RygelMediaExportRootContainer* _tmp0_;
	RygelMediaExportRootContainer* _tmp1_;
	_tmp0_ = rygel_media_export_root_container_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

RygelMediaExportDBContainer*
rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self)
{
	RygelMediaExportDBContainer* result = NULL;
	RygelMediaExportDBContainer* _tmp0_;
	RygelMediaExportDBContainer* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filesystem_container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
}

static void
rygel_media_export_root_container_real_find_object_data_free (gpointer _data)
{
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRootContainerFindObjectData, _data_);
}

static void
rygel_media_export_root_container_real_find_object (RygelMediaContainer* base,
                                                    const gchar* id,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	RygelMediaExportRootContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_export_root_container_real_find_object_co (_data_);
}

static RygelMediaObject*
rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_media_export_root_container_find_object_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_root_container_real_find_object_co (_data_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch33_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch33_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally33;
	__catch33_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally33:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gboolean
rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->id, _data_->cancellable, rygel_media_export_root_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_inner_error0_);
	_data_->object = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->object;
	if (_data_->_tmp1_ != NULL) {
		_data_->result = _data_->object;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_str_has_prefix (_data_->id, RYGEL_MEDIA_EXPORT_DVD_CONTAINER_TRACK_PREFIX)) {
		_data_->_tmp3_ = _data_->_tmp2_ = g_strsplit (_data_->id, ":", 0);
		_data_->parts = _data_->_tmp3_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp2_);
		_data_->_parts_size_ = _data_->parts_length1;
		_data_->_tmp4_ = _data_->parts;
		_data_->_tmp4__length1 = _data_->parts_length1;
		_data_->_tmp5_ = _data_->_tmp4_[1];
		_data_->_tmp6_ = g_strconcat (RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PREFIX ":", _data_->_tmp5_, NULL);
		_data_->parent_id = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->parent_id;
		_data_->_state_ = 2;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_tmp8_, _data_->cancellable, rygel_media_export_root_container_find_object_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp9_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->parent_id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_object_unref0 (_data_->object);
		_data_->object = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->object;
		_data_->_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp11_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp11_) : NULL);
		_data_->container = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->container;
		if (_data_->_tmp13_ != NULL) {
			_data_->_tmp15_ = _data_->container;
			_data_->_state_ = 3;
			rygel_media_container_find_object (_data_->_tmp15_, _data_->id, _data_->cancellable, rygel_media_export_root_container_find_object_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp16_ = rygel_media_container_find_object_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp14_ = _data_->_tmp16_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->container);
				_g_object_unref0 (_data_->_tmp7_);
				_g_free0 (_data_->parent_id);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_data_->object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp17_ = _data_->_tmp14_;
			_data_->_tmp14_ = NULL;
			_data_->result = _data_->_tmp17_;
			_g_object_unref0 (_data_->_tmp14_);
			_g_object_unref0 (_data_->container);
			_g_object_unref0 (_data_->_tmp7_);
			_g_free0 (_data_->parent_id);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->object);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = NULL;
		_g_object_unref0 (_data_->container);
		_g_object_unref0 (_data_->_tmp7_);
		_g_free0 (_data_->parent_id);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->object);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		if (g_str_has_prefix (_data_->id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX)) {
			_data_->_tmp18_ = rygel_media_export_query_container_factory_get_default ();
			_data_->factory = _data_->_tmp18_;
			_data_->_tmp19_ = _data_->factory;
			_data_->_tmp20_ = rygel_media_export_query_container_factory_create_from_hashed_id (_data_->_tmp19_, _data_->id, "");
			_data_->_vala1_container = _data_->_tmp20_;
			_data_->_tmp21_ = _data_->_vala1_container;
			if (_data_->_tmp21_ != NULL) {
				_data_->_tmp22_ = _data_->_vala1_container;
				rygel_media_object_set_parent ((RygelMediaObject*) _data_->_tmp22_, (RygelMediaContainer*) _data_->self);
			}
			_data_->result = (RygelMediaObject*) _data_->_vala1_container;
			_g_object_unref0 (_data_->factory);
			_g_object_unref0 (_data_->object);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			if (g_str_has_prefix (_data_->id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX)) {
				_data_->_tmp23_ = string_replace (_data_->id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX, "");
				_data_->tmp_id = _data_->_tmp23_;
				_data_->_tmp24_ = _data_->tmp_id;
				_data_->_tmp26_ = _data_->_tmp25_ = g_strsplit (_data_->_tmp24_, ":", 0);
				_data_->_vala1_parts = _data_->_tmp26_;
				_data_->_vala1_parts_length1 = _vala_array_length (_data_->_tmp25_);
				_data_->__vala1_parts_size_ = _data_->_vala1_parts_length1;
				_data_->_tmp27_ = _data_->_vala1_parts;
				_data_->_tmp27__length1 = _data_->_vala1_parts_length1;
				if (_data_->_tmp27__length1 != 2) {
					_data_->result = NULL;
					_data_->_vala1_parts = (_vala_array_free (_data_->_vala1_parts, _data_->_vala1_parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->tmp_id);
					_g_object_unref0 (_data_->object);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp29_ = _data_->_vala1_parts;
				_data_->_tmp29__length1 = _data_->_vala1_parts_length1;
				_data_->_tmp30_ = _data_->_tmp29_[1];
				_data_->_state_ = 4;
				RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_tmp30_, _data_->cancellable, rygel_media_export_root_container_find_object_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp31_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp28_ = _data_->_tmp31_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_data_->_vala1_parts = (_vala_array_free (_data_->_vala1_parts, _data_->_vala1_parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->tmp_id);
					_g_object_unref0 (_data_->object);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp32_ = _data_->_tmp28_;
				_data_->_tmp28_ = NULL;
				_g_object_unref0 (_data_->object);
				_data_->object = _data_->_tmp32_;
				_data_->_tmp33_ = _data_->object;
				if (_data_->_tmp33_ == NULL) {
					_data_->result = NULL;
					_g_object_unref0 (_data_->_tmp28_);
					_data_->_vala1_parts = (_vala_array_free (_data_->_vala1_parts, _data_->_vala1_parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->tmp_id);
					_g_object_unref0 (_data_->object);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp34_ = _data_->object;
				_data_->_tmp35_ = _data_->object;
				_data_->_tmp36_ = rygel_media_object_get_id (_data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				rygel_media_object_set_ref_id (_data_->_tmp34_, _data_->_tmp37_);
				_data_->_tmp38_ = _data_->object;
				rygel_media_object_set_id (_data_->_tmp38_, _data_->id);
				_data_->_tmp39_ = rygel_media_export_query_container_factory_get_default ();
				_data_->_vala1_factory = _data_->_tmp39_;
				_data_->_tmp40_ = _data_->_vala1_parts;
				_data_->_tmp40__length1 = _data_->_vala1_parts_length1;
				_data_->_tmp41_ = _data_->_tmp40_[0];
				_data_->_tmp42_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _data_->_tmp41_, NULL);
				_data_->container_id = _data_->_tmp42_;
				_data_->_tmp43_ = _data_->_vala1_factory;
				_data_->_tmp44_ = _data_->container_id;
				_data_->_tmp45_ = rygel_media_export_query_container_factory_create_from_hashed_id (_data_->_tmp43_, _data_->_tmp44_, "");
				_data_->_vala2_container = _data_->_tmp45_;
				_data_->_tmp46_ = _data_->_vala2_container;
				if (_data_->_tmp46_ == NULL) {
					_data_->result = NULL;
					_g_object_unref0 (_data_->_vala2_container);
					_g_free0 (_data_->container_id);
					_g_object_unref0 (_data_->_vala1_factory);
					_g_object_unref0 (_data_->_tmp28_);
					_data_->_vala1_parts = (_vala_array_free (_data_->_vala1_parts, _data_->_vala1_parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->tmp_id);
					_g_object_unref0 (_data_->object);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp47_ = _data_->object;
				_data_->_tmp48_ = _data_->_vala2_container;
				rygel_media_object_set_parent_ref (_data_->_tmp47_, (RygelMediaContainer*) _data_->_tmp48_);
				_g_object_unref0 (_data_->_vala2_container);
				_g_free0 (_data_->container_id);
				_g_object_unref0 (_data_->_vala1_factory);
				_g_object_unref0 (_data_->_tmp28_);
				_data_->_vala1_parts = (_vala_array_free (_data_->_vala1_parts, _data_->_vala1_parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->tmp_id);
			}
		}
	}
	_data_->result = _data_->object;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_root_container_real_search_data_free (gpointer _data)
{
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRootContainerSearchData, _data_);
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base,
                                               RygelSearchExpression* expression,
                                               guint offset,
                                               guint max_count,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	RygelMediaExportRootContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_media_export_root_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_media_export_root_container_real_search_finish (RygelMediaExportDBContainer* base,
                                                      GAsyncResult* _res_,
                                                      guint* total_matches,
                                                      GError** error)
{
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_media_export_root_container_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_root_container_real_search_co (_data_);
}

static gboolean
rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->expression == NULL) {
		_data_->_tmp1_ = 0U;
		_data_->_state_ = 1;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp1_;
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_data_->result = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->query_container = NULL;
	_data_->upnp_class = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->expression, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		_data_->_tmp4_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->expression) : NULL);
		_data_->relational_expression = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->relational_expression;
		_data_->_tmp6_ = rygel_media_export_root_container_search_to_virtual_container (_data_->self, _data_->_tmp5_);
		_g_object_unref0 (_data_->query_container);
		_data_->query_container = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->relational_expression;
		_data_->_tmp8_ = ((RygelSearchExpression*) _data_->_tmp7_)->operand2;
		_data_->_tmp9_ = g_strdup ((const gchar*) _data_->_tmp8_);
		_g_free0 (_data_->upnp_class);
		_data_->upnp_class = _data_->_tmp9_;
		_rygel_search_expression_unref0 (_data_->relational_expression);
	} else {
		_data_->_tmp10_ = NULL;
		_data_->_tmp11_ = rygel_media_export_root_container_is_search_in_virtual_container (_data_->self, _data_->expression, &_data_->_tmp10_);
		_g_object_unref0 (_data_->query_container);
		_data_->query_container = _data_->_tmp10_;
		if (_data_->_tmp11_) {
		}
	}
	_data_->_tmp12_ = _data_->query_container;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp14_ = _data_->query_container;
		_data_->_state_ = 2;
		rygel_media_container_get_children (_data_->_tmp14_, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp15_ = rygel_media_container_get_children_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp13_ = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->query_container);
			_g_object_unref0 (_data_->list);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp16_ = _data_->_tmp13_;
		_data_->_tmp13_ = NULL;
		_g_object_unref0 (_data_->list);
		_data_->list = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->query_container;
		_data_->_tmp18_ = rygel_media_container_get_child_count (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->total_matches = (guint) _data_->_tmp19_;
		_data_->_tmp20_ = _data_->upnp_class;
		if (_data_->_tmp20_ != NULL) {
			{
				_data_->_tmp21_ = _data_->list;
				_data_->_tmp22_ = _g_object_ref0 (_data_->_tmp21_);
				_data_->_object_list = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->_object_list;
				_data_->_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_object_size = _data_->_tmp25_;
				_data_->_object_index = -1;
				while (TRUE) {
					_data_->_object_index = _data_->_object_index + 1;
					if (!(_data_->_object_index < _data_->_object_size)) {
						break;
					}
					_data_->_tmp26_ = _data_->_object_list;
					_data_->_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp26_, _data_->_object_index);
					_data_->object = (RygelMediaObject*) _data_->_tmp27_;
					_data_->_tmp28_ = _data_->object;
					_data_->_tmp29_ = _data_->upnp_class;
					rygel_media_object_set_upnp_class (_data_->_tmp28_, _data_->_tmp29_);
					_g_object_unref0 (_data_->object);
				}
				_g_object_unref0 (_data_->_object_list);
			}
		}
		_data_->result = _data_->list;
		_g_object_unref0 (_data_->_tmp13_);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->query_container);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp31_ = 0U;
		_data_->_state_ = 3;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp32_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_tmp31_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp31_;
		_data_->_tmp30_ = _data_->_tmp32_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->query_container);
			_g_object_unref0 (_data_->list);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp33_ = _data_->_tmp30_;
		_data_->_tmp30_ = NULL;
		_data_->result = _data_->_tmp33_;
		_g_object_unref0 (_data_->_tmp30_);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->query_container);
		_g_object_unref0 (_data_->list);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->query_container);
	_g_object_unref0 (_data_->list);
}

static GeeArrayList*
rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self)
{
	GeeArrayList* result = NULL;
	GeeArrayList* uris = NULL;
	GeeArrayList* actual_uris = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_;
	GeeArrayList* _tmp6_;
	GFile* home_dir = NULL;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	const gchar* pictures_dir = NULL;
	const gchar* _tmp9_;
	const gchar* videos_dir = NULL;
	const gchar* _tmp10_;
	const gchar* music_dir = NULL;
	const gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		GeeArrayList* _tmp1_ = NULL;
		RygelMetaConfig* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		_tmp2_ = config;
		_tmp3_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp2_, "MediaExport", "uris", &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch34_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (uris);
		uris = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* _error_ = NULL;
		GeeArrayList* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (uris);
		uris = _tmp5_;
		_g_error_free0 (_error_);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		_g_object_unref0 (actual_uris);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	_g_object_unref0 (actual_uris);
	actual_uris = _tmp6_;
	_tmp7_ = g_get_home_dir ();
	_tmp8_ = g_file_new_for_path (_tmp7_);
	home_dir = _tmp8_;
	_tmp9_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	pictures_dir = _tmp9_;
	_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	videos_dir = _tmp10_;
	_tmp11_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	music_dir = _tmp11_;
	{
		GeeArrayList* _uri_list = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _uri_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _uri_index = 0;
		_tmp12_ = uris;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_uri_list = _tmp13_;
		_tmp14_ = _uri_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_uri_size = _tmp16_;
		_uri_index = -1;
		while (TRUE) {
			gchar* uri = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			GFile* file = NULL;
			const gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GeeArrayList* _tmp41_;
			GFile* _tmp42_;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp17_ = _uri_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _uri_index);
			uri = (gchar*) _tmp18_;
			_tmp19_ = uri;
			_tmp20_ = g_file_new_for_commandline_arg (_tmp19_);
			file = _tmp20_;
			_tmp21_ = file;
			_tmp22_ = home_dir;
			if (G_LIKELY (!g_file_equal (_tmp21_, _tmp22_))) {
				gchar* actual_uri = NULL;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp29_;
				const gchar* _tmp33_;
				const gchar* _tmp37_;
				GFile* _tmp38_;
				GFile* _tmp39_;
				GFile* _tmp40_;
				_tmp23_ = uri;
				_tmp24_ = g_strdup (_tmp23_);
				actual_uri = _tmp24_;
				_tmp25_ = pictures_dir;
				if (G_LIKELY (_tmp25_ != NULL)) {
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp26_ = actual_uri;
					_tmp27_ = pictures_dir;
					_tmp28_ = string_replace (_tmp26_, "@PICTURES@", _tmp27_);
					_g_free0 (actual_uri);
					actual_uri = _tmp28_;
				}
				_tmp29_ = videos_dir;
				if (G_LIKELY (_tmp29_ != NULL)) {
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp30_ = actual_uri;
					_tmp31_ = videos_dir;
					_tmp32_ = string_replace (_tmp30_, "@VIDEOS@", _tmp31_);
					_g_free0 (actual_uri);
					actual_uri = _tmp32_;
				}
				_tmp33_ = music_dir;
				if (G_LIKELY (_tmp33_ != NULL)) {
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp34_ = actual_uri;
					_tmp35_ = music_dir;
					_tmp36_ = string_replace (_tmp34_, "@MUSIC@", _tmp35_);
					_g_free0 (actual_uri);
					actual_uri = _tmp36_;
				}
				_tmp37_ = actual_uri;
				_tmp38_ = g_file_new_for_commandline_arg (_tmp37_);
				_g_object_unref0 (file);
				file = _tmp38_;
				_tmp39_ = file;
				_tmp40_ = home_dir;
				if (g_file_equal (_tmp39_, _tmp40_)) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_g_free0 (actual_uri);
			}
			_tmp41_ = actual_uris;
			_tmp42_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	result = actual_uris;
	_g_object_unref0 (home_dir);
	_g_object_unref0 (config);
	_g_object_unref0 (uris);
	return result;
}

static RygelMediaContainer*
rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self,
                                                               RygelRelationalExpression* expression)
{
	RygelMediaContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp1_ = ((RygelSearchExpression*) expression)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp1_, "upnp:class") == 0) {
		gconstpointer _tmp2_;
		_tmp2_ = ((RygelSearchExpression*) expression)->op;
		_tmp0_ = ((GUPnPSearchCriteriaOp) ((gintptr) _tmp2_)) == GUPNP_SEARCH_CRITERIA_OP_EQ;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* id = NULL;
		gchar* _tmp3_;
		gconstpointer _tmp4_;
		const gchar* _tmp5_;
		GQuark _tmp7_ = 0U;
		RygelMediaExportQueryContainerFactory* factory = NULL;
		RygelMediaExportQueryContainerFactory* _tmp21_;
		RygelMediaExportQueryContainerFactory* _tmp22_;
		const gchar* _tmp23_;
		RygelMediaExportQueryContainer* _tmp24_;
		_tmp3_ = g_strdup (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_SEARCH_CONTAINER_PREFIX);
		id = _tmp3_;
		_tmp4_ = ((RygelSearchExpression*) expression)->operand2;
		_tmp5_ = (const gchar*) _tmp4_;
		_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
		if (_tmp7_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM)) {
			switch (0) {
				default:
				{
					const gchar* _tmp8_;
					RygelMediaExportFolderDefinition _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp8_ = id;
					_tmp9_ = VIRTUAL_FOLDERS_MUSIC[1];
					_tmp10_ = _tmp9_.definition;
					_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
					_g_free0 (id);
					id = _tmp11_;
					break;
				}
			}
		} else if (_tmp7_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST)) {
			switch (0) {
				default:
				{
					const gchar* _tmp12_;
					RygelMediaExportFolderDefinition _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp12_ = id;
					_tmp13_ = VIRTUAL_FOLDERS_MUSIC[0];
					_tmp14_ = _tmp13_.definition;
					_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
					_g_free0 (id);
					id = _tmp15_;
					break;
				}
			}
		} else if (_tmp7_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_MUSIC_GENRE)) {
			switch (0) {
				default:
				{
					const gchar* _tmp16_;
					RygelMediaExportFolderDefinition _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp16_ = id;
					_tmp17_ = VIRTUAL_FOLDERS_MUSIC[2];
					_tmp18_ = _tmp17_.definition;
					_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
					_g_free0 (id);
					id = _tmp19_;
					break;
				}
			}
		} else if (_tmp7_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_PLAYLIST)) {
			switch (0) {
				default:
				{
					RygelMediaExportPlaylistRootContainer* _tmp20_;
					_tmp20_ = rygel_media_export_playlist_root_container_new ();
					result = (RygelMediaContainer*) _tmp20_;
					_g_free0 (id);
					return result;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = NULL;
					_g_free0 (id);
					return result;
				}
			}
		}
		_tmp21_ = rygel_media_export_query_container_factory_get_default ();
		factory = _tmp21_;
		_tmp22_ = factory;
		_tmp23_ = id;
		_tmp24_ = rygel_media_export_query_container_factory_create_from_description_id (_tmp22_, _tmp23_, "");
		result = (RygelMediaContainer*) _tmp24_;
		_g_object_unref0 (factory);
		_g_free0 (id);
		return result;
	}
	result = NULL;
	return result;
}

/**
     * Check if a passed search expression is a simple search in a virtual
     * container.
     *
     * @param expression the expression to check
     * @param new_id contains the id of the virtual container constructed from
     *               the search
     * @param upnp_class contains the class of the container the search was
     *                   looking in
     * @return true if it was a search in virtual container, false otherwise.
     * @note This works single level only. Enough to satisfy Xbox music
     *       browsing, but may need refinement
     */
static gboolean
rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self,
                                                                  RygelSearchExpression* expression,
                                                                  RygelMediaContainer* * container)
{
	RygelMediaContainer* _vala_container = NULL;
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression = NULL;
	RygelMediaContainer* query_container = NULL;
	RygelLogicalExpression* logical_expression = NULL;
	RygelLogicalExpression* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RygelLogicalExpression* _tmp3_;
	gconstpointer _tmp4_;
	RygelRelationalExpression* left_expression = NULL;
	RygelLogicalExpression* _tmp9_;
	gconstpointer _tmp10_;
	RygelSearchExpression* _tmp11_;
	RygelRelationalExpression* _tmp12_;
	RygelRelationalExpression* right_expression = NULL;
	RygelLogicalExpression* _tmp13_;
	gconstpointer _tmp14_;
	RygelSearchExpression* _tmp15_;
	RygelRelationalExpression* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	RygelMediaContainer* _tmp18_;
	RygelMediaContainer* _tmp19_;
	RygelMediaExportQueryContainerFactory* factory = NULL;
	RygelMediaExportQueryContainerFactory* _tmp27_;
	gchar* plaintext_id = NULL;
	RygelMediaExportQueryContainerFactory* _tmp28_;
	RygelMediaContainer* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* last_argument = NULL;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* escaped_detail = NULL;
	RygelRelationalExpression* _tmp35_;
	gconstpointer _tmp36_;
	gchar* _tmp37_;
	gchar* new_id = NULL;
	RygelRelationalExpression* _tmp38_;
	gconstpointer _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	RygelMediaExportQueryContainerFactory* _tmp43_;
	const gchar* _tmp44_;
	RygelMediaExportQueryContainer* _tmp45_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expression != NULL, FALSE);
	virtual_expression = NULL;
	_g_object_unref0 (_vala_container);
	_vala_container = NULL;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		result = FALSE;
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _vala_container;
		} else {
			_g_object_unref0 (_vala_container);
		}
		return result;
	}
	_tmp0_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) expression) : NULL);
	logical_expression = _tmp0_;
	_tmp3_ = logical_expression;
	_tmp4_ = ((RygelSearchExpression*) _tmp3_)->operand1;
	if (G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp4_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		RygelLogicalExpression* _tmp5_;
		gconstpointer _tmp6_;
		_tmp5_ = logical_expression;
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand2;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp6_, RYGEL_TYPE_RELATIONAL_EXPRESSION);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		RygelLogicalExpression* _tmp7_;
		gconstpointer _tmp8_;
		_tmp7_ = logical_expression;
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->op;
		_tmp1_ = ((RygelLogicalOperator) ((gintptr) _tmp8_)) == RYGEL_LOGICAL_OPERATOR_AND;
	} else {
		_tmp1_ = FALSE;
	}
	if (!_tmp1_) {
		result = FALSE;
		_rygel_search_expression_unref0 (logical_expression);
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _vala_container;
		} else {
			_g_object_unref0 (_vala_container);
		}
		return result;
	}
	_tmp9_ = logical_expression;
	_tmp10_ = ((RygelSearchExpression*) _tmp9_)->operand1;
	_tmp11_ = (RygelSearchExpression*) _tmp10_;
	_tmp12_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp11_) : NULL);
	left_expression = _tmp12_;
	_tmp13_ = logical_expression;
	_tmp14_ = ((RygelSearchExpression*) _tmp13_)->operand2;
	_tmp15_ = (RygelSearchExpression*) _tmp14_;
	_tmp16_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp15_) : NULL);
	right_expression = _tmp16_;
	_tmp17_ = left_expression;
	_tmp18_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp17_);
	_g_object_unref0 (query_container);
	query_container = _tmp18_;
	_tmp19_ = query_container;
	if (_tmp19_ == NULL) {
		RygelRelationalExpression* _tmp20_;
		RygelMediaContainer* _tmp21_;
		RygelMediaContainer* _tmp22_;
		_tmp20_ = right_expression;
		_tmp21_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp20_);
		_g_object_unref0 (query_container);
		query_container = _tmp21_;
		_tmp22_ = query_container;
		if (_tmp22_ != NULL) {
			RygelRelationalExpression* _tmp23_;
			RygelRelationalExpression* _tmp24_;
			_tmp23_ = left_expression;
			_tmp24_ = _rygel_search_expression_ref0 (_tmp23_);
			_rygel_search_expression_unref0 (virtual_expression);
			virtual_expression = _tmp24_;
		} else {
			result = FALSE;
			_rygel_search_expression_unref0 (right_expression);
			_rygel_search_expression_unref0 (left_expression);
			_rygel_search_expression_unref0 (logical_expression);
			_g_object_unref0 (query_container);
			_rygel_search_expression_unref0 (virtual_expression);
			if (container) {
				*container = _vala_container;
			} else {
				_g_object_unref0 (_vala_container);
			}
			return result;
		}
	} else {
		RygelRelationalExpression* _tmp25_;
		RygelRelationalExpression* _tmp26_;
		_tmp25_ = right_expression;
		_tmp26_ = _rygel_search_expression_ref0 (_tmp25_);
		_rygel_search_expression_unref0 (virtual_expression);
		virtual_expression = _tmp26_;
	}
	_tmp27_ = rygel_media_export_query_container_factory_get_default ();
	factory = _tmp27_;
	_tmp28_ = factory;
	_tmp29_ = query_container;
	_tmp30_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = rygel_media_export_query_container_factory_get_virtual_container_definition (_tmp28_, _tmp31_);
	plaintext_id = _tmp32_;
	_tmp33_ = plaintext_id;
	_tmp34_ = string_replace (_tmp33_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	last_argument = _tmp34_;
	_tmp35_ = virtual_expression;
	_tmp36_ = ((RygelSearchExpression*) _tmp35_)->operand2;
	_tmp37_ = g_uri_escape_string ((const gchar*) _tmp36_, "", TRUE);
	escaped_detail = _tmp37_;
	_tmp38_ = virtual_expression;
	_tmp39_ = ((RygelSearchExpression*) _tmp38_)->operand1;
	_tmp40_ = escaped_detail;
	_tmp41_ = last_argument;
	_tmp42_ = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const gchar*) _tmp39_, _tmp40_, _tmp41_);
	new_id = _tmp42_;
	_tmp43_ = factory;
	_tmp44_ = new_id;
	_tmp45_ = rygel_media_export_query_container_factory_create_from_description_id (_tmp43_, _tmp44_, "");
	_g_object_unref0 (_vala_container);
	_vala_container = (RygelMediaContainer*) _tmp45_;
	result = TRUE;
	_g_free0 (new_id);
	_g_free0 (escaped_detail);
	_g_free0 (last_argument);
	_g_free0 (plaintext_id);
	_g_object_unref0 (factory);
	_rygel_search_expression_unref0 (right_expression);
	_rygel_search_expression_unref0 (left_expression);
	_rygel_search_expression_unref0 (logical_expression);
	_g_object_unref0 (query_container);
	_rygel_search_expression_unref0 (virtual_expression);
	if (container) {
		*container = _vala_container;
	} else {
		_g_object_unref0 (_vala_container);
	}
	return result;
}

static gint
rygel_media_export_root_container_real_count_children (RygelMediaExportDBContainer* base)
{
	RygelMediaExportRootContainer * self;
	gint result = 0;
	self = (RygelMediaExportRootContainer*) base;
	if (!self->priv->initialized) {
		result = 0;
		return result;
	} else {
		result = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->count_children ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer));
		return result;
	}
}

/**
     * Create a new root container.
     */
static RygelMediaExportRootContainer*
rygel_media_export_root_container_construct (GType object_type)
{
	RygelMediaExportRootContainer * self = NULL;
	self = (RygelMediaExportRootContainer*) g_object_new (object_type, "id", "0", "title", _ ("@REALNAME@’s media"), "parent", NULL, "child-count", 0, NULL);
	return self;
}

static RygelMediaExportRootContainer*
rygel_media_export_root_container_new (void)
{
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER);
}

static gboolean
__lambda8_ (RygelMediaExportRootContainer* self)
{
	gboolean result = FALSE;
	GError* _inner_error0_ = NULL;
	{
		rygel_media_export_root_container_init (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally35:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp0_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((RygelMediaExportRootContainer*) self);
	return result;
}

static guint32
rygel_media_export_root_container_real_get_system_update_id (RygelMediaExportTrackableDbContainer* base)
{
	RygelMediaExportRootContainer * self;
	guint32 result = 0U;
	guint32 id = 0U;
	self = (RygelMediaExportRootContainer*) base;
	id = RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->get_system_update_id (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	result = id;
	return result;
}

static void
_rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender,
                                                                                                 gpointer self)
{
	rygel_media_export_root_container_on_initial_harvesting_done ((RygelMediaExportRootContainer*) self);
}

static void
_rygel_media_export_root_container_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                           const gchar* section,
                                                                                           const gchar* key,
                                                                                           gpointer self)
{
	rygel_media_export_root_container_on_setting_changed ((RygelMediaExportRootContainer*) self, section, key);
}

static void
rygel_media_export_root_container_init (RygelMediaExportRootContainer* self,
                                        GError** error)
{
	GCancellable* _tmp0_;
	RygelMediaExportMediaCache* _tmp1_;
	GeeArrayList* ids = NULL;
	GCancellable* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	RygelMediaExportHarvester* _tmp15_;
	RygelMediaExportHarvester* _tmp16_;
	gulong _tmp17_;
	RygelMediaExportMediaCache* _tmp43_;
	RygelMediaExportHarvester* _tmp44_;
	RygelMediaExportDBContainer* _tmp45_;
	GeeArrayList* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	RygelMetaConfig* _tmp49_;
	RygelMetaConfig* _tmp50_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->initialized) {
		return;
	}
	self->priv->initialized = TRUE;
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_drop_virtual_folders (_tmp1_);
	{
		RygelMediaExportMediaCache* _tmp2_;
		_tmp2_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_save_container (_tmp2_, (RygelMediaContainer*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch36_g_error;
		}
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		RygelMediaExportTrackableDbContainer* _tmp3_;
		RygelMediaExportDBContainer* _tmp4_;
		RygelMediaExportMediaCache* _tmp5_;
		RygelMediaExportDBContainer* _tmp6_;
		_tmp3_ = rygel_media_export_trackable_db_container_new (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, _ (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME));
		_g_object_unref0 (self->priv->filesystem_container);
		self->priv->filesystem_container = (RygelMediaExportDBContainer*) _tmp3_;
		_tmp4_ = self->priv->filesystem_container;
		rygel_media_object_set_parent ((RygelMediaObject*) _tmp4_, (RygelMediaContainer*) self);
		_tmp5_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp6_ = self->priv->filesystem_container;
		rygel_media_export_media_cache_save_container (_tmp5_, (RygelMediaContainer*) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally37:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		GeeArrayList* _tmp7_ = NULL;
		RygelMediaExportMediaCache* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		_tmp8_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp9_ = rygel_media_export_media_cache_get_child_ids (_tmp8_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch38_rygel_database_database_error;
			}
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (ids);
		ids = _tmp10_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally38;
	__catch38_rygel_database_database_error:
	{
		GError* e = NULL;
		GeeArrayList* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (ids);
		ids = _tmp11_;
		_g_error_free0 (e);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ids);
		return;
	}
	_tmp12_ = self->priv->cancellable;
	_tmp13_ = rygel_media_export_root_container_get_shared_uris (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = rygel_media_export_harvester_new (_tmp12_, _tmp14_);
	_g_object_unref0 (self->priv->harvester);
	self->priv->harvester = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_tmp16_ = self->priv->harvester;
	_tmp17_ = g_signal_connect_object (_tmp16_, "done", (GCallback) _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done, self, 0);
	self->priv->harvester_signal_id = _tmp17_;
	{
		GeeArrayList* _file_list = NULL;
		RygelMediaExportHarvester* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		gint _file_size = 0;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _file_index = 0;
		_tmp18_ = self->priv->harvester;
		_tmp19_ = rygel_media_export_harvester_get_locations (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_file_list = _tmp21_;
		_tmp22_ = _file_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_file_size = _tmp24_;
		_file_index = -1;
		while (TRUE) {
			GFile* file = NULL;
			GeeArrayList* _tmp25_;
			gpointer _tmp26_;
			GeeArrayList* _tmp27_;
			GFile* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp25_ = _file_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _file_index);
			file = (GFile*) _tmp26_;
			_tmp27_ = ids;
			_tmp28_ = file;
			_tmp29_ = rygel_media_export_media_cache_get_id (_tmp28_);
			_tmp30_ = _tmp29_;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp27_, _tmp30_);
			_g_free0 (_tmp30_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	{
		GeeArrayList* _id_list = NULL;
		GeeArrayList* _tmp31_;
		GeeArrayList* _tmp32_;
		gint _id_size = 0;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _id_index = 0;
		_tmp31_ = ids;
		_tmp32_ = _g_object_ref0 (_tmp31_);
		_id_list = _tmp32_;
		_tmp33_ = _id_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_id_size = _tmp35_;
		_id_index = -1;
		while (TRUE) {
			gchar* id = NULL;
			GeeArrayList* _tmp36_;
			gpointer _tmp37_;
			const gchar* _tmp38_;
			_id_index = _id_index + 1;
			if (!(_id_index < _id_size)) {
				break;
			}
			_tmp36_ = _id_list;
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _id_index);
			id = (gchar*) _tmp37_;
			_tmp38_ = id;
			g_debug ("rygel-media-export-root-container.vala:452: ID %s is no longer in the " \
"configuration. Deleting...", _tmp38_);
			{
				RygelMediaExportMediaCache* _tmp39_;
				const gchar* _tmp40_;
				_tmp39_ = ((RygelMediaExportDBContainer*) self)->media_db;
				_tmp40_ = id;
				rygel_media_export_media_cache_remove_by_id (_tmp39_, _tmp40_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch39_rygel_database_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (_id_list);
					_g_object_unref0 (ids);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally39;
			__catch39_rygel_database_database_error:
			{
				GError* _error_ = NULL;
				GError* _tmp41_;
				const gchar* _tmp42_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp41_ = _error_;
				_tmp42_ = _tmp41_->message;
				g_warning (_ ("Failed to remove entry: %s"), _tmp42_);
				_g_error_free0 (_error_);
			}
			__finally39:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (id);
				_g_object_unref0 (_id_list);
				_g_object_unref0 (ids);
				return;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_list);
	}
	_tmp43_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_rebuild_exists_cache (_tmp43_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ids);
		return;
	}
	_tmp44_ = self->priv->harvester;
	_tmp45_ = self->priv->filesystem_container;
	rygel_media_export_harvester_schedule_locations (_tmp44_, (RygelMediaContainer*) _tmp45_);
	_tmp46_ = ids;
	_tmp47_ = gee_collection_get_is_empty ((GeeCollection*) _tmp46_);
	_tmp48_ = _tmp47_;
	if (!_tmp48_) {
		rygel_media_export_root_container_root_updated (self);
	}
	_tmp49_ = rygel_meta_config_get_default ();
	_tmp50_ = _tmp49_;
	g_signal_connect_object ((RygelConfiguration*) _tmp50_, "setting-changed", (GCallback) _rygel_media_export_root_container_on_setting_changed_rygel_configuration_setting_changed, self, 0);
	_g_object_unref0 (_tmp50_);
	_g_object_unref0 (ids);
}

static void
rygel_media_export_root_container_root_updated (RygelMediaExportRootContainer* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	{
		RygelMediaExportMediaCache* _tmp0_;
		_tmp0_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_save_container (_tmp0_, (RygelMediaContainer*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch40_g_error;
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally40:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
rygel_media_export_root_container_on_setting_changed (RygelMediaExportRootContainer* self,
                                                      const gchar* section,
                                                      const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (section, RYGEL_MEDIA_EXPORT_PLUGIN_NAME) != 0) {
		return;
	}
	if (g_strcmp0 (key, "uris") == 0) {
		rygel_media_export_root_container_handle_uri_config_change (self);
	} else {
		if (g_strcmp0 (key, "virtual-folders") == 0) {
			rygel_media_export_root_container_handle_virtual_folder_change (self);
		}
	}
}

static void
rygel_media_export_root_container_handle_uri_config_change (RygelMediaExportRootContainer* self)
{
	GeeArrayList* uris = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* new_uris = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	RygelMediaExportHarvester* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* old_uris = NULL;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	RygelMediaExportHarvester* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	RygelMediaExportHarvester* _tmp30_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeArrayList* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_media_export_root_container_get_shared_uris (self);
	uris = _tmp0_;
	_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	new_uris = _tmp1_;
	_tmp2_ = new_uris;
	_tmp3_ = uris;
	gee_array_list_add_all (_tmp2_, (GeeCollection*) _tmp3_);
	_tmp4_ = new_uris;
	_tmp5_ = self->priv->harvester;
	_tmp6_ = rygel_media_export_harvester_get_locations (_tmp5_);
	_tmp7_ = _tmp6_;
	gee_collection_remove_all ((GeeCollection*) _tmp4_, (GeeCollection*) _tmp7_);
	_tmp8_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	old_uris = _tmp8_;
	_tmp9_ = old_uris;
	_tmp10_ = self->priv->harvester;
	_tmp11_ = rygel_media_export_harvester_get_locations (_tmp10_);
	_tmp12_ = _tmp11_;
	gee_array_list_add_all (_tmp9_, (GeeCollection*) _tmp12_);
	_tmp13_ = old_uris;
	_tmp14_ = uris;
	gee_collection_remove_all ((GeeCollection*) _tmp13_, (GeeCollection*) _tmp14_);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		gint _file_size = 0;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _file_index = 0;
		_tmp15_ = old_uris;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_file_list = _tmp16_;
		_tmp17_ = _file_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_file_size = _tmp19_;
		_file_index = -1;
		while (TRUE) {
			GFile* file = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			RygelMediaExportHarvester* _tmp22_;
			GFile* _tmp23_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp20_ = _file_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _file_index);
			file = (GFile*) _tmp21_;
			_tmp22_ = self->priv->harvester;
			_tmp23_ = file;
			rygel_media_export_harvester_cancel (_tmp22_, _tmp23_);
			{
				RygelMediaExportMediaCache* _tmp24_;
				GFile* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp24_ = ((RygelMediaExportDBContainer*) self)->media_db;
				_tmp25_ = file;
				_tmp26_ = rygel_media_export_media_cache_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				rygel_media_export_media_cache_remove_by_id (_tmp24_, _tmp27_, &_inner_error0_);
				_g_free0 (_tmp27_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch41_rygel_database_database_error;
					}
					_g_object_unref0 (file);
					_g_object_unref0 (_file_list);
					_g_object_unref0 (old_uris);
					_g_object_unref0 (new_uris);
					_g_object_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally41;
			__catch41_rygel_database_database_error:
			{
				GError* _error_ = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = _error_;
				_tmp29_ = _tmp28_->message;
				g_warning (_ ("Failed to remove entry: %s"), _tmp29_);
				_g_error_free0 (_error_);
			}
			__finally41:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (_file_list);
				_g_object_unref0 (old_uris);
				_g_object_unref0 (new_uris);
				_g_object_unref0 (uris);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp30_ = self->priv->harvester;
	_tmp31_ = rygel_media_export_harvester_get_locations (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = old_uris;
	gee_collection_remove_all ((GeeCollection*) _tmp32_, (GeeCollection*) _tmp33_);
	_tmp34_ = new_uris;
	_tmp35_ = gee_collection_get_is_empty ((GeeCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	if (!_tmp36_) {
		RygelMediaExportHarvester* _tmp38_;
		gulong _tmp39_;
		if (self->priv->filesystem_signal_id != ((gulong) 0)) {
			RygelMediaExportDBContainer* _tmp37_;
			_tmp37_ = self->priv->filesystem_container;
			g_signal_handler_disconnect ((GObject*) _tmp37_, self->priv->filesystem_signal_id);
		}
		self->priv->filesystem_signal_id = (gulong) 0;
		_tmp38_ = self->priv->harvester;
		_tmp39_ = g_signal_connect_object (_tmp38_, "done", (GCallback) _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done, self, 0);
		self->priv->harvester_signal_id = _tmp39_;
	}
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp40_;
		GeeArrayList* _tmp41_;
		gint _file_size = 0;
		GeeArrayList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _file_index = 0;
		_tmp40_ = new_uris;
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_file_list = _tmp41_;
		_tmp42_ = _file_list;
		_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_file_size = _tmp44_;
		_file_index = -1;
		while (TRUE) {
			GFile* file = NULL;
			GeeArrayList* _tmp45_;
			gpointer _tmp46_;
			GFile* _tmp47_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp45_ = _file_list;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _file_index);
			file = (GFile*) _tmp46_;
			_tmp47_ = file;
			if (g_file_query_exists (_tmp47_, NULL)) {
				RygelMediaExportHarvester* _tmp48_;
				GeeArrayList* _tmp49_;
				GeeArrayList* _tmp50_;
				GFile* _tmp51_;
				RygelMediaExportHarvester* _tmp52_;
				GFile* _tmp53_;
				RygelMediaExportDBContainer* _tmp54_;
				_tmp48_ = self->priv->harvester;
				_tmp49_ = rygel_media_export_harvester_get_locations (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
				_tmp52_ = self->priv->harvester;
				_tmp53_ = file;
				_tmp54_ = self->priv->filesystem_container;
				rygel_media_export_harvester_schedule (_tmp52_, _tmp53_, (RygelMediaContainer*) _tmp54_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_g_object_unref0 (old_uris);
	_g_object_unref0 (new_uris);
	_g_object_unref0 (uris);
}

static void
rygel_media_export_root_container_handle_virtual_folder_change (RygelMediaExportRootContainer* self)
{
	gboolean virtual_folders = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	virtual_folders = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "virtual-folders", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch42_g_error;
		}
		virtual_folders = _tmp1_;
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally42:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (virtual_folders) {
		rygel_media_export_root_container_add_default_virtual_folders (self);
		_g_object_unref0 (config);
		return;
	} else {
		RygelMediaExportMediaCache* _tmp2_;
		_tmp2_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_drop_virtual_folders (_tmp2_);
	}
	rygel_media_export_root_container_root_updated (self);
	_g_object_unref0 (config);
}

static void
__lambda9_ (RygelMediaExportRootContainer* self)
{
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_export_root_container_root_updated (self);
}

static void
___lambda9__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                     RygelMediaContainer* container,
                                                     RygelMediaObject* object,
                                                     RygelObjectEventType event_type,
                                                     gboolean sub_tree_update,
                                                     gpointer self)
{
	__lambda9_ ((RygelMediaExportRootContainer*) self);
}

static void
rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self)
{
	RygelMediaExportHarvester* _tmp0_;
	RygelMediaExportMediaCache* _tmp1_;
	RygelMediaExportDBContainer* _tmp2_;
	gulong _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->harvester;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->harvester_signal_id);
	self->priv->harvester_signal_id = (gulong) 0;
	_tmp1_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_debug_statistics (_tmp1_);
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_export_root_container_root_updated (self);
	_tmp2_ = self->priv->filesystem_container;
	_tmp3_ = g_signal_connect_object ((RygelMediaContainer*) _tmp2_, "container-updated", (GCallback) ___lambda9__rygel_media_container_container_updated, self, 0);
	self->priv->filesystem_signal_id = _tmp3_;
}

/** Add the default virtual folders,
     * for Music, Pictures, etc,
     * saving them in the cache.
     */
static void
rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self)
{
	gboolean virtual_folders = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	virtual_folders = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		RygelMetaConfig* _tmp2_;
		_tmp2_ = config;
		_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp2_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "virtual-folders", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch43_g_error;
		}
		virtual_folders = _tmp1_;
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally43:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (!virtual_folders) {
		_g_object_unref0 (config);
		return;
	}
	{
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Music"), RYGEL_MUSIC_ITEM_UPNP_CLASS, VIRTUAL_FOLDERS_MUSIC, (gint) G_N_ELEMENTS (VIRTUAL_FOLDERS_MUSIC), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch44_g_error;
		}
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Pictures"), RYGEL_PHOTO_ITEM_UPNP_CLASS, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch44_g_error;
		}
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Videos"), RYGEL_VIDEO_ITEM_UPNP_CLASS, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch44_g_error;
		}
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Playlists"), RYGEL_PLAYLIST_ITEM_UPNP_CLASS, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch44_g_error;
		}
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally44:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (config);
}

/**
     * Add a QueryContainer to the provided container,
     * for the specified UPnP class,
     * with the specified definition,
     * saving it in the cache.
     */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self,
                                                         RygelMediaContainer* container,
                                                         const gchar* item_class,
                                                         RygelMediaExportFolderDefinition* definition,
                                                         GError** error)
{
	gchar* id = NULL;
	RygelMediaExportFolderDefinition _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaExportQueryContainerFactory* factory = NULL;
	RygelMediaExportQueryContainerFactory* _tmp6_;
	RygelMediaExportQueryContainer* query_container = NULL;
	RygelMediaExportQueryContainerFactory* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaExportFolderDefinition _tmp9_;
	const gchar* _tmp10_;
	RygelMediaExportQueryContainer* _tmp11_;
	RygelMediaExportQueryContainer* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (item_class != NULL);
	g_return_if_fail (definition != NULL);
	_tmp0_ = *definition;
	_tmp1_ = _tmp0_.definition;
	_tmp2_ = g_strdup_printf ("%supnp:class,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, item_class, _tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	if (g_str_has_suffix (_tmp3_, ",")) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = id;
		_tmp5_ = string_slice (_tmp4_, (glong) 0, (glong) -1);
		_g_free0 (id);
		id = _tmp5_;
	}
	_tmp6_ = rygel_media_export_query_container_factory_get_default ();
	factory = _tmp6_;
	_tmp7_ = factory;
	_tmp8_ = id;
	_tmp9_ = *definition;
	_tmp10_ = _tmp9_.title;
	_tmp11_ = rygel_media_export_query_container_factory_create_from_description_id (_tmp7_, _tmp8_, _ (_tmp10_));
	query_container = _tmp11_;
	_tmp12_ = query_container;
	_tmp13_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > 0) {
		RygelMediaExportQueryContainer* _tmp15_;
		RygelMediaExportMediaCache* _tmp16_;
		RygelMediaExportQueryContainer* _tmp17_;
		_tmp15_ = query_container;
		rygel_media_object_set_parent ((RygelMediaObject*) _tmp15_, container);
		_tmp16_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp17_ = query_container;
		rygel_media_export_media_cache_save_container (_tmp16_, (RygelMediaContainer*) _tmp17_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (query_container);
			_g_object_unref0 (factory);
			_g_free0 (id);
			return;
		}
	} else {
		RygelMediaExportMediaCache* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp19_ = id;
		rygel_media_export_media_cache_remove_by_id (_tmp18_, _tmp19_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (query_container);
			_g_object_unref0 (factory);
			_g_free0 (id);
			return;
		}
	}
	_g_object_unref0 (query_container);
	_g_object_unref0 (factory);
	_g_free0 (id);
}

/**
     * Add a parent container with child containers for the definitions,
     * saving them in the cache.
     */
static void
rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self,
                                                                    const gchar* parent,
                                                                    const gchar* item_class,
                                                                    RygelMediaExportFolderDefinition* definitions,
                                                                    gint definitions_length1,
                                                                    GError** error)
{
	RygelNullContainer* container = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	RygelNullContainer* _tmp2_;
	RygelNullContainer* _tmp3_;
	RygelMediaExportMediaCache* _tmp4_;
	RygelNullContainer* _tmp5_;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	RygelMediaExportMediaCache* _tmp13_;
	RygelNullContainer* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (item_class != NULL);
	_tmp0_ = g_strconcat ("virtual-parent:", item_class, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_null_container_new (_tmp1_, (RygelMediaContainer*) self, parent);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	container = _tmp3_;
	_tmp4_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp5_ = container;
	rygel_media_export_media_cache_save_container (_tmp4_, (RygelMediaContainer*) _tmp5_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (container);
		return;
	}
	{
		RygelMediaExportFolderDefinition* definition_collection = NULL;
		gint definition_collection_length1 = 0;
		gint _definition_collection_size_ = 0;
		gint definition_it = 0;
		definition_collection = VIRTUAL_FOLDERS_DEFAULT;
		definition_collection_length1 = G_N_ELEMENTS (VIRTUAL_FOLDERS_DEFAULT);
		for (definition_it = 0; definition_it < G_N_ELEMENTS (VIRTUAL_FOLDERS_DEFAULT); definition_it = definition_it + 1) {
			RygelMediaExportFolderDefinition definition = {0};
			definition = definition_collection[definition_it];
			{
				RygelNullContainer* _tmp6_;
				RygelMediaExportFolderDefinition _tmp7_;
				_tmp6_ = container;
				_tmp7_ = definition;
				rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp6_, item_class, &_tmp7_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (container);
					return;
				}
			}
		}
	}
	if (definitions != NULL) {
		{
			RygelMediaExportFolderDefinition* definition_collection = NULL;
			gint definition_collection_length1 = 0;
			gint _definition_collection_size_ = 0;
			gint definition_it = 0;
			definition_collection = definitions;
			definition_collection_length1 = definitions_length1;
			for (definition_it = 0; definition_it < definitions_length1; definition_it = definition_it + 1) {
				RygelMediaExportFolderDefinition _tmp8_ = {0};
				RygelMediaExportFolderDefinition definition = {0};
				rygel_media_export_folder_definition_copy (&definition_collection[definition_it], &_tmp8_);
				definition = _tmp8_;
				{
					RygelNullContainer* _tmp9_;
					RygelMediaExportFolderDefinition _tmp10_;
					_tmp9_ = container;
					_tmp10_ = definition;
					rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp9_, item_class, &_tmp10_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						rygel_media_export_folder_definition_destroy (&definition);
						_g_object_unref0 (container);
						return;
					}
					rygel_media_export_folder_definition_destroy (&definition);
				}
			}
		}
	}
	_tmp13_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp14_ = container;
	_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp12_ = rygel_media_export_media_cache_get_child_count (_tmp13_, _tmp16_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (container);
		return;
	}
	if (_tmp12_ == 0) {
		RygelNullContainer* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = container;
		_tmp18_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp11_ = !g_str_has_prefix (_tmp19_, "virtual-parent:" RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		RygelMediaExportMediaCache* _tmp20_;
		RygelNullContainer* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp21_ = container;
		_tmp22_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp21_);
		_tmp23_ = _tmp22_;
		rygel_media_export_media_cache_remove_by_id (_tmp20_, _tmp23_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (container);
			return;
		}
	} else {
		RygelNullContainer* _tmp24_;
		_tmp24_ = container;
		rygel_media_container_updated ((RygelMediaContainer*) _tmp24_, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	}
	_g_object_unref0 (container);
}

static void
rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass,
                                              gpointer klass_data)
{
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportRootContainer_private_offset);
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_root_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_media_export_root_container_real_find_object_finish;
	((RygelMediaExportDBContainerClass *) klass)->search = (void (*) (RygelMediaExportDBContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_root_container_real_search;
	((RygelMediaExportDBContainerClass *) klass)->search_finish = (RygelMediaObjects* (*) (RygelMediaExportDBContainer*, GAsyncResult*, guint*, GError**)) rygel_media_export_root_container_real_search_finish;
	((RygelMediaExportDBContainerClass *) klass)->count_children = (gint (*) (RygelMediaExportDBContainer*)) rygel_media_export_root_container_real_count_children;
	((RygelMediaExportTrackableDbContainerClass *) klass)->get_system_update_id = (guint32 (*) (RygelMediaExportTrackableDbContainer*)) rygel_media_export_root_container_real_get_system_update_id;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}

static void
rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self,
                                                 gpointer klass)
{
	self->priv = rygel_media_export_root_container_get_instance_private (self);
	self->priv->initialized = FALSE;
}

static void
rygel_media_export_root_container_finalize (GObject * obj)
{
	RygelMediaExportRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->filesystem_container);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}

/**
 * Represents the root container.
 */
GType
rygel_media_export_root_container_get_type (void)
{
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		RygelMediaExportRootContainer_private_offset = g_type_add_instance_private (rygel_media_export_root_container_type_id, sizeof (RygelMediaExportRootContainerPrivate));
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

