/* rygel-connection-manager.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-connection-manager.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <libgupnp/gupnp.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_CONNECTION_MANAGER (rygel_connection_manager_get_type ())
#define RYGEL_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManager))
#define RYGEL_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManagerClass))
#define RYGEL_IS_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONNECTION_MANAGER))
#define RYGEL_IS_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONNECTION_MANAGER))
#define RYGEL_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManagerClass))

typedef struct _RygelConnectionManager RygelConnectionManager;
typedef struct _RygelConnectionManagerClass RygelConnectionManagerClass;
typedef struct _RygelConnectionManagerPrivate RygelConnectionManagerPrivate;
enum  {
	RYGEL_CONNECTION_MANAGER_0_PROPERTY,
	RYGEL_CONNECTION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* rygel_connection_manager_properties[RYGEL_CONNECTION_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelConnectionManager {
	GUPnPService parent_instance;
	RygelConnectionManagerPrivate * priv;
	gchar* sink_protocol_info;
	gchar* connection_ids;
	gchar* source_protocol_info;
	gint rcs_id;
	gint av_transport_id;
	gchar* direction;
};

struct _RygelConnectionManagerClass {
	GUPnPServiceClass parent_class;
	gchar* (*get_current_protocol_info) (RygelConnectionManager* self);
};

static gpointer rygel_connection_manager_parent_class = NULL;

GType rygel_connection_manager_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelConnectionManager, g_object_unref)
#define RYGEL_CONNECTION_MANAGER_UPNP_ID "urn:upnp-org:serviceId:ConnectionManager"
#define RYGEL_CONNECTION_MANAGER_UPNP_TYPE "urn:schemas-upnp-org:service:ConnectionManager:2"
#define RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH "xml/ConnectionManager.xml"
static void rygel_connection_manager_real_constructed (GObject* base);
static void rygel_connection_manager_query_source_protocol_info_cb (RygelConnectionManager* self,
                                                             GUPnPService* cm,
                                                             const gchar* var,
                                                             GValue* val);
static void _rygel_connection_manager_query_source_protocol_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                           const gchar* variable,
                                                                                           GValue* value,
                                                                                           gpointer self);
static void rygel_connection_manager_query_sink_protocol_info_cb (RygelConnectionManager* self,
                                                           GUPnPService* cm,
                                                           const gchar* var,
                                                           GValue* val);
static void _rygel_connection_manager_query_sink_protocol_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                         const gchar* variable,
                                                                                         GValue* value,
                                                                                         gpointer self);
static void rygel_connection_manager_query_current_connection_ids_cb (RygelConnectionManager* self,
                                                               GUPnPService* cm,
                                                               const gchar* var,
                                                               GValue* val);
static void _rygel_connection_manager_query_current_connection_ids_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                             const gchar* variable,
                                                                                             GValue* value,
                                                                                             gpointer self);
static void rygel_connection_manager_get_protocol_info_cb (RygelConnectionManager* self,
                                                    GUPnPService* cm,
                                                    GUPnPServiceAction* action);
static void _rygel_connection_manager_get_protocol_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                  GUPnPServiceAction* action,
                                                                                  gpointer self);
static void rygel_connection_manager_get_current_connection_ids_cb (RygelConnectionManager* self,
                                                             GUPnPService* cm,
                                                             GUPnPServiceAction* action);
static void _rygel_connection_manager_get_current_connection_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                           GUPnPServiceAction* action,
                                                                                           gpointer self);
static void rygel_connection_manager_get_current_connection_info_cb (RygelConnectionManager* self,
                                                              GUPnPService* cm,
                                                              GUPnPServiceAction* action);
static void _rygel_connection_manager_get_current_connection_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                            GUPnPServiceAction* action,
                                                                                            gpointer self);
gchar* rygel_connection_manager_get_current_protocol_info (RygelConnectionManager* self);
static gchar* rygel_connection_manager_real_get_current_protocol_info (RygelConnectionManager* self);
RygelConnectionManager* rygel_connection_manager_new (void);
RygelConnectionManager* rygel_connection_manager_construct (GType object_type);
static void rygel_connection_manager_finalize (GObject * obj);

static void
_rygel_connection_manager_query_source_protocol_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                      const gchar* variable,
                                                                                      GValue* value,
                                                                                      gpointer self)
{
	rygel_connection_manager_query_source_protocol_info_cb ((RygelConnectionManager*) self, _sender, variable, value);
}

static void
_rygel_connection_manager_query_sink_protocol_info_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                    const gchar* variable,
                                                                                    GValue* value,
                                                                                    gpointer self)
{
	rygel_connection_manager_query_sink_protocol_info_cb ((RygelConnectionManager*) self, _sender, variable, value);
}

static void
_rygel_connection_manager_query_current_connection_ids_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                        const gchar* variable,
                                                                                        GValue* value,
                                                                                        gpointer self)
{
	rygel_connection_manager_query_current_connection_ids_cb ((RygelConnectionManager*) self, _sender, variable, value);
}

static void
_rygel_connection_manager_get_protocol_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                             GUPnPServiceAction* action,
                                                                             gpointer self)
{
	rygel_connection_manager_get_protocol_info_cb ((RygelConnectionManager*) self, _sender, action);
}

static void
_rygel_connection_manager_get_current_connection_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                      GUPnPServiceAction* action,
                                                                                      gpointer self)
{
	rygel_connection_manager_get_current_connection_ids_cb ((RygelConnectionManager*) self, _sender, action);
}

static void
_rygel_connection_manager_get_current_connection_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                       GUPnPServiceAction* action,
                                                                                       gpointer self)
{
	rygel_connection_manager_get_current_connection_info_cb ((RygelConnectionManager*) self, _sender, action);
}

static void
rygel_connection_manager_real_constructed (GObject* base)
{
	RygelConnectionManager * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (RygelConnectionManager*) base;
	G_OBJECT_CLASS (rygel_connection_manager_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = g_strdup ("");
	_g_free0 (self->sink_protocol_info);
	self->sink_protocol_info = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->source_protocol_info);
	self->source_protocol_info = _tmp1_;
	_tmp2_ = g_strdup ("0");
	_g_free0 (self->connection_ids);
	self->connection_ids = _tmp2_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SourceProtocolInfo", (GCallback) _rygel_connection_manager_query_source_protocol_info_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SinkProtocolInfo", (GCallback) _rygel_connection_manager_query_sink_protocol_info_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::CurrentConnectionIDs", (GCallback) _rygel_connection_manager_query_current_connection_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetProtocolInfo", (GCallback) _rygel_connection_manager_get_protocol_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentConnectionIDs", (GCallback) _rygel_connection_manager_get_current_connection_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentConnectionInfo", (GCallback) _rygel_connection_manager_get_current_connection_info_cb_gupnp_service_action_invoked, self, 0);
}

static gchar*
rygel_connection_manager_real_get_current_protocol_info (RygelConnectionManager* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

gchar*
rygel_connection_manager_get_current_protocol_info (RygelConnectionManager* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_CONNECTION_MANAGER_GET_CLASS (self)->get_current_protocol_info (self);
}

static void
rygel_connection_manager_query_source_protocol_info_cb (RygelConnectionManager* self,
                                                        GUPnPService* cm,
                                                        const gchar* var,
                                                        GValue* val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = self->source_protocol_info;
	g_value_set_string (val, _tmp0_);
}

static void
rygel_connection_manager_query_sink_protocol_info_cb (RygelConnectionManager* self,
                                                      GUPnPService* cm,
                                                      const gchar* var,
                                                      GValue* val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = self->sink_protocol_info;
	g_value_set_string (val, _tmp0_);
}

static void
rygel_connection_manager_query_current_connection_ids_cb (RygelConnectionManager* self,
                                                          GUPnPService* cm,
                                                          const gchar* var,
                                                          GValue* val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = self->connection_ids;
	g_value_set_string (val, _tmp0_);
}

static void
rygel_connection_manager_get_protocol_info_cb (RygelConnectionManager* self,
                                               GUPnPService* cm,
                                               GUPnPServiceAction* action)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 0)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp0_ = self->source_protocol_info;
	_tmp1_ = self->sink_protocol_info;
	gupnp_service_action_set (action, "Source", G_TYPE_STRING, _tmp0_, "Sink", G_TYPE_STRING, _tmp1_, NULL);
	gupnp_service_action_return (action);
}

static void
rygel_connection_manager_get_current_connection_ids_cb (RygelConnectionManager* self,
                                                        GUPnPService* cm,
                                                        GUPnPServiceAction* action)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 0)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp0_ = self->connection_ids;
	gupnp_service_action_set (action, "ConnectionIDs", G_TYPE_STRING, _tmp0_, NULL);
	gupnp_service_action_return (action);
}

static void
rygel_connection_manager_get_current_connection_info_cb (RygelConnectionManager* self,
                                                         GUPnPService* cm,
                                                         GUPnPServiceAction* action)
{
	gchar* connection_id = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cm != NULL);
	g_return_if_fail (action != NULL);
	gupnp_service_action_get (action, "ConnectionID", G_TYPE_STRING, &_tmp0_, NULL);
	_g_free0 (connection_id);
	connection_id = _tmp0_;
	_tmp3_ = connection_id;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gupnp_service_action_get_argument_count (action) != ((guint) 1);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp5_ = connection_id;
		if (g_strcmp0 (_tmp5_, "0") != 0) {
			const gchar* _tmp6_;
			_tmp6_ = connection_id;
			_tmp4_ = atoi (_tmp6_) == 0;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp1_ = _tmp4_;
	}
	if (_tmp1_) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		_g_free0 (connection_id);
		return;
	}
	_tmp7_ = connection_id;
	if (g_strcmp0 (_tmp7_, "0") != 0) {
		gupnp_service_action_return_error (action, (guint) 706, _ ("Invalid connection reference"));
		_g_free0 (connection_id);
		return;
	}
	_tmp8_ = rygel_connection_manager_get_current_protocol_info (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->direction;
	gupnp_service_action_set (action, "RcsID", G_TYPE_INT, self->rcs_id, "AVTransportID", G_TYPE_INT, self->av_transport_id, "ProtocolInfo", G_TYPE_STRING, _tmp9_, "PeerConnectionManager", G_TYPE_STRING, "", "PeerConnectionID", G_TYPE_INT, -1, "Direction", G_TYPE_STRING, _tmp10_, "Status", G_TYPE_STRING, "OK", NULL);
	_g_free0 (_tmp9_);
	gupnp_service_action_return (action);
	_g_free0 (connection_id);
}

RygelConnectionManager*
rygel_connection_manager_construct (GType object_type)
{
	RygelConnectionManager * self = NULL;
	self = (RygelConnectionManager*) g_object_new (object_type, NULL);
	return self;
}

RygelConnectionManager*
rygel_connection_manager_new (void)
{
	return rygel_connection_manager_construct (RYGEL_TYPE_CONNECTION_MANAGER);
}

static void
rygel_connection_manager_class_init (RygelConnectionManagerClass * klass,
                                     gpointer klass_data)
{
	rygel_connection_manager_parent_class = g_type_class_peek_parent (klass);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_connection_manager_real_constructed;
	((RygelConnectionManagerClass *) klass)->get_current_protocol_info = (gchar* (*) (RygelConnectionManager*)) rygel_connection_manager_real_get_current_protocol_info;
	G_OBJECT_CLASS (klass)->finalize = rygel_connection_manager_finalize;
}

static void
rygel_connection_manager_instance_init (RygelConnectionManager * self,
                                        gpointer klass)
{
}

static void
rygel_connection_manager_finalize (GObject * obj)
{
	RygelConnectionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManager);
	_g_free0 (self->sink_protocol_info);
	_g_free0 (self->connection_ids);
	_g_free0 (self->source_protocol_info);
	_g_free0 (self->direction);
	G_OBJECT_CLASS (rygel_connection_manager_parent_class)->finalize (obj);
}

/**
 * Basic implementation of UPnP ConnectionManager service version 2.
 */
GType
rygel_connection_manager_get_type (void)
{
	static volatile gsize rygel_connection_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_connection_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelConnectionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_connection_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelConnectionManager), 0, (GInstanceInitFunc) rygel_connection_manager_instance_init, NULL };
		GType rygel_connection_manager_type_id;
		rygel_connection_manager_type_id = g_type_register_static (gupnp_service_get_type (), "RygelConnectionManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_connection_manager_type_id__volatile, rygel_connection_manager_type_id);
	}
	return rygel_connection_manager_type_id__volatile;
}

