// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GDKMM_EVENTS_H
#define _GDKMM_EVENTS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/refptr.h>
#include <gdkmm/event.h>
#include <gdkmm/enums.h>
#include <gdkmm/rectangle.h>
#include <gdkmm/types.h>
#include <gdkmm/window.h>

// All subclasses of Gdk::Event.
//
// Keeping the subclasses in a separate file makes it easier to avoid cyclic
// inclusions (where a.h includes b.h, and b.h includes a.h).
// One file per subclass would result in too many small files.

// _WRAP_METHOD() is not useful here. It generates code where the first parameter
// in the call to the C function is gobj() or const_cast<GdkEventSubclass*>(gobj).
// The C functions here require Event::gobj().

namespace Gdk
{
class DeviceTool;
class DragContext;

/** Representing an event sequence.
 * Used to differentiate between multiple touches on multitouch touchscreens.
 * It's a hidden struct. You can test %EventSequence pointers for equality,
 * but you can't do much more with them.
 */
struct EventSequence;

/** Generated when a key is pressed or released.
 *
 * get_event_type() will return Gdk::Event::Type::KEY_PRESS or
 * Gdk::Event::Type::KEY_RELEASE.
 *
 * @newin{3,90}
 */
class EventKey : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventKey;
  using BaseObjectType = GdkEventKey;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventKey* gobj() noexcept { return reinterpret_cast<GdkEventKey*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventKey* gobj() const noexcept { return reinterpret_cast<const GdkEventKey*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventKey* gobj_copy();

private:

  
public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;
  

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;
  

  /**
   * Returns the key that was pressed or released. See the <gdk/gdkkeysyms.h>
   * header file for a complete list of GDK key codes.
   */
  guint get_keyval() const;
  

  /**
   * Returns the raw code of the key that was pressed or released.
   */
  guint16 get_keycode() const;
  

  /** Gets the keyboard low-level scancode of a key event.
   * 
   * This is usually hardware_keycode. On Windows this is the high
   * word of WM_KEY{DOWN,UP} lParam which contains the scancode and
   * some extended flags.
   * 
   * @return The associated keyboard scancode or 0.
   */

  int get_scancode() const;

  /**
   * Returns the keyboard group.
   */
  guint get_key_group() const;
  

  /**
   * Returns @c true if the hardware keycode is mapped to a modifier key.
   */
  bool get_key_is_modifier() const;
  

  // Belong to the base class:
  

};

/** Represents a mouse button press or release event.
 *
 * get_event_type() will return Gdk::Event::Type::BUTTON_PRESS or
 * Gdk::Event::Type::BUTTON_RELEASE.
 *
 * @newin{3,90}
 */
class EventButton : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventButton;
  using BaseObjectType = GdkEventButton;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventButton* gobj() noexcept { return reinterpret_cast<GdkEventButton*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventButton* gobj() const noexcept { return reinterpret_cast<const GdkEventButton*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventButton* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  
  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;

  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */

  bool get_axis(Gdk::AxisUse axis_use, double& value) const;

  /**
   * Returns the number of the button which was pressed or released, numbered
   * from 1 to 5. Normally button 1 is the left mouse button, 2 is the middle
   * button, and 3 is the right button. On 2-button mice, the middle button can
   * often be simulated by pressing both mouse buttons together.
   */
  guint get_button() const;
  

  /** This function returns whether a Gdk::EventButton should trigger a
   * context menu, according to platform conventions. The right mouse
   * button always triggers context menus. Additionally, if
   * Gdk::Keymap::get_modifier_mask() returns a non-0 mask for
   * Gdk::ModifierIntent::CONTEXT_MENU, then the left mouse button will
   * also trigger a context menu if this modifier is pressed.
   * 
   * This function should always be used instead of simply checking for
   * event->button == GDK_BUTTON_SECONDARY.
   * 
   * @return <tt>true</tt> if the event should trigger a context menu.
   */

  bool shall_trigger_context_menu() const;

  
  /** If the event was generated by a device that supports
   * different tools (eg. a tablet), this function will
   * return a Gdk::DeviceTool representing the tool that
   * caused the event. Otherwise, <tt>nullptr</tt> will be returned.
   * 
   * @note the Gdk::DeviceTool<!-- -->s will be constant during
   * the application lifetime, if settings must be stored
   * persistently across runs, see Gdk::DeviceTool::get_serial()
   * 
   * @newin{3,94}
   * 
   * @return The current device tool, or <tt>nullptr</tt>.
   */

  Glib::RefPtr<DeviceTool> get_device_tool();
  
  /** If the event was generated by a device that supports
   * different tools (eg. a tablet), this function will
   * return a Gdk::DeviceTool representing the tool that
   * caused the event. Otherwise, <tt>nullptr</tt> will be returned.
   * 
   * @note the Gdk::DeviceTool<!-- -->s will be constant during
   * the application lifetime, if settings must be stored
   * persistently across runs, see Gdk::DeviceTool::get_serial()
   * 
   * @newin{3,94}
   * 
   * @return The current device tool, or <tt>nullptr</tt>.
   */

  Glib::RefPtr<const DeviceTool> get_device_tool() const;


};

/** Generated when the mouse is scrolled.
 *
 * These events are from button presses for the buttons 4 to 7. Wheel mice are
 * usually configured to generate button press events for buttons 4 and 5 when
 * the wheel is turned.
 *
 * get_event_type() will return Gdk::Event::Type::SCROLL.
 *
 * Some GDK backends can also generate 'smooth' scroll events, which can be
 * recognized by the Gdk::ScrollDirection::SMOOTH scroll direction. For these,
 * scroll deltas can be obtained with get_delta_x() and get_delta_y().
 *
 * @newin{3,90}
 */
class EventScroll : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventScroll;
  using BaseObjectType = GdkEventScroll;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventScroll* gobj() noexcept { return reinterpret_cast<GdkEventScroll*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventScroll* gobj() const noexcept { return reinterpret_cast<const GdkEventScroll*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventScroll* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  
  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;

  
  /** Retrieves the scroll deltas from a Gdk::Event
   * 
   * @param delta_x Return location for X delta.
   * @param delta_y Return location for Y delta.
   * @return <tt>true</tt> if the event contains smooth scroll information.
   */

  bool get_scroll_deltas(double& delta_x, double& delta_y) const;

  /**
   * Returns the direction of the scroll.
   */
  ScrollDirection get_scroll_direction() const;
  

  /** Check whether a scroll event is a stop scroll event. Scroll sequences
   * with smooth scroll information may provide a stop scroll event once the
   * interaction with the device finishes, e.g. by lifting a finger. This
   * stop scroll event is the signal that a widget may trigger kinetic
   * scrolling based on the current velocity.
   * 
   * Stop scroll events always have a a delta of 0/0.
   * 
   * @return <tt>true</tt> if the event is a scroll stop event.
   */

  bool is_scroll_stop_event() const;


};

/** Generated when a mouse pointer is moved.
 *
 * get_event_type() will return Gdk::Event::Type::MOTION_NOTIFY.
 *
 * @newin{3,90}
 */
class EventMotion : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventMotion;
  using BaseObjectType = GdkEventMotion;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventMotion* gobj() noexcept { return reinterpret_cast<GdkEventMotion*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventMotion* gobj() const noexcept { return reinterpret_cast<const GdkEventMotion*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventMotion* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  
  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;

  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */

  bool get_axis(Gdk::AxisUse axis_use, double& value) const;

  
  /** If the event was generated by a device that supports
   * different tools (eg. a tablet), this function will
   * return a Gdk::DeviceTool representing the tool that
   * caused the event. Otherwise, <tt>nullptr</tt> will be returned.
   * 
   * @note the Gdk::DeviceTool<!-- -->s will be constant during
   * the application lifetime, if settings must be stored
   * persistently across runs, see Gdk::DeviceTool::get_serial()
   * 
   * @newin{3,94}
   * 
   * @return The current device tool, or <tt>nullptr</tt>.
   */

  Glib::RefPtr<DeviceTool> get_device_tool();
  
  /** If the event was generated by a device that supports
   * different tools (eg. a tablet), this function will
   * return a Gdk::DeviceTool representing the tool that
   * caused the event. Otherwise, <tt>nullptr</tt> will be returned.
   * 
   * @note the Gdk::DeviceTool<!-- -->s will be constant during
   * the application lifetime, if settings must be stored
   * persistently across runs, see Gdk::DeviceTool::get_serial()
   * 
   * @newin{3,94}
   * 
   * @return The current device tool, or <tt>nullptr</tt>.
   */

  Glib::RefPtr<const DeviceTool> get_device_tool() const;


};

/** Generated during an attached touchscreen is touched.
 *
 * get_event_type() will return one of Gdk::Event::Type::TOUCH_BEGIN,
 * Gdk::Event::Type::TOUCH_UPDATE, Gdk::Event::Type::TOUCH_END or
 * Gdk::Event::Type::TOUCH_CANCEL.
 *
 * Touch events are grouped into sequences by means of the sequence field, which
 * can also be obtained with get_event_sequence(). Each sequence
 * begins with a Gdk::Event::Type::TOUCH_BEGIN event, followed by any number of
 * Gdk::Event::Type::TOUCH_UPDATE events, and ends with a Gdk::Event::Type::TOUCH_END
 * (or Gdk::Event::Type::TOUCH_CANCEL) event. With multitouch devices, there may
 * be several active sequences at the same time.
 *
 * @newin{3,90}
 */
class EventTouch : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTouch;
  using BaseObjectType = GdkEventTouch;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventTouch* gobj() noexcept { return reinterpret_cast<GdkEventTouch*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventTouch* gobj() const noexcept { return reinterpret_cast<const GdkEventTouch*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventTouch* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  
  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;

  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */

  bool get_axis(Gdk::AxisUse axis_use, double& value) const;

  /**
   * Returns the event sequence that the event belongs to
   */
  const EventSequence* get_event_sequence() const;
  

  /**
   * Returns @c true if the event should be used for emulating pointer event.
   */
  bool get_touch_emulating_pointer() const;
  

  //TODO: In other subclasses as well?
  
  /** Returns whether this event is an 'emulated' pointer event (typically
   * from a touch event), as opposed to a real one.
   * 
   * @return <tt>true</tt> if this event is emulated.
   */

  bool get_pointer_emulated() const;


};

/** Generated when the mouse pointer leaves or enters the window.
 *
 * get_event_type() will return one of Gdk::Event::Type::LEAVE_NOTIFY or
 * Gdk::Event::Type::ENTER_NOTIFY.
 *
 * @newin{3,90}
 */
class EventCrossing : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventCrossing;
  using BaseObjectType = GdkEventCrossing;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventCrossing* gobj() noexcept { return reinterpret_cast<GdkEventCrossing*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventCrossing* gobj() const noexcept { return reinterpret_cast<const GdkEventCrossing*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventCrossing* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /*
   * Returns the window that was entered or left.
   */
  //Glib::RefPtr<Gdk::Window> get_subwindow(); //TODO: Remove? There is no corresponding gtk+ function.
  /*
   * Returns the window that was entered or left.
   */
  //Glib::RefPtr<const Gdk::Window> get_subwindow() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  
  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;

  /*** Returns the crossing mode.
   * Gdk::CrossingMode::GTK_GRAB, Gdk::CrossingMode::GTK_UNGRAB, and
   * Gdk::CrossingMode::STATE_CHANGED are always synthesized, never native.
   */
  CrossingMode get_crossing_mode() const;
  

  /**
   * Returns the kind of crossing that has been made.
   */
  NotifyType get_crossing_detail() const;
  

  /*
   * Returns @c true if the window was the focus window, @c false otherwise
   */
  //bool get_focus() const; //TODO: Remove? There is no corresponding gtk+ function.


};

/** Generated when all or part of a window becomes visible and needs to be
 * redrawn.
 *
 * get_event_type() will return one of Gdk::Event::Type::EXPOSE, Gdk::Event::Type::DAMAGE.
 *
 * @newin{3,90}
 */
class EventExpose : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventExpose;
  using BaseObjectType = GdkEventExpose;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventExpose* gobj() noexcept { return reinterpret_cast<GdkEventExpose*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventExpose* gobj() const noexcept { return reinterpret_cast<const GdkEventExpose*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventExpose* gobj_copy();

private:


public:

  /*
   * Returns the bounding box of the region to be redrawn
   */
  //Rectangle get_area() const; //TODO: Remove? There is no corresponding gtk+ function.

  /*
   * Returns the region to be redrawn
   */
  //::Cairo::RefPtr<const ::Cairo::Region> get_region() const; //TODO: Remove? There is no corresponding gtk+ function.

  /*
   * Returns the number of contiguous Gdk::Event::Type::EXPOSE events following this one.
   * The only use for this is "exposure compression", i.e. handling all contiguous
   * Gdk::Event::Type::EXPOSE events in one go, though GDK performs some exposure
   * compression so this is not normally needed.
   */
  //int get_count() const; //TODO: Remove? There is no corresponding gtk+ function.


};

// GdkEventVisibility is deprecated. It's not used in gtk+ 4.

/** Generated when the keyboard focus changes.
 *
 * get_event_type() will return Gdk::Event::Type::FOCUS_CHANGE.
 *
 * @newin{3,90}
 */
class EventFocus : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventFocus;
  using BaseObjectType = GdkEventFocus;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventFocus* gobj() noexcept { return reinterpret_cast<GdkEventFocus*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventFocus* gobj() const noexcept { return reinterpret_cast<const GdkEventFocus*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventFocus* gobj_copy();

private:


public:

  /**
   * @c true if the window gained focus, @c false if lost
   */
  bool get_focus_in() const;
  

};

/** Generated when the position or size of a window changes.
 *
 * get_event_type() will return Gdk::Event::Type::CONFIGURE.
 *
 * @newin{3,90}
 */
class EventConfigure : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventConfigure;
  using BaseObjectType = GdkEventConfigure;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventConfigure* gobj() noexcept { return reinterpret_cast<GdkEventConfigure*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventConfigure* gobj() const noexcept { return reinterpret_cast<const GdkEventConfigure*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventConfigure* gobj_copy();

private:


public:

  /**
   * Extract the event window relative x/y coordinates from an event.
   * @param[out] x_win The new X coordinate of the window, relative to its parent.
   * @param[out] y_win The new Y coordinate of the window, relative to its parent.
   */
  void get_coords(double& x_win, double& y_win) const;

  /*
   * Returns the new width of the window
   */
  /*
   * Returns the new height of the window
   */
  //void get_size(int& width, int& Height) const; //TODO: Remove? There is no corresponding gtk+ function.

  /*
   * Convenience method to access all position and size information at once
   */
  //Gdk::Rectangle get_rect() const; //TODO: Remove? There is no corresponding gtk+ function.


};

/** Generated during Drag-and-Drop (DND) operations.
 *
 * get_event_type() will return one of Gdk::Event::Type::DRAG_ENTER,
 * Gdk::Event::Type::DRAG_LEAVE, Gdk::Event::Type::DRAG_MOTION,
 * Gdk::Event::Type::DRAG_STATUS, Gdk::Event::Type::DROP_START
 * or Gdk::Event::Type::DROP_FINISHED.
 *
 * @newin{3,90}
 */
class EventDND : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventDND;
  using BaseObjectType = GdkEventDND;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventDND* gobj() noexcept { return reinterpret_cast<GdkEventDND*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventDND* gobj() const noexcept { return reinterpret_cast<const GdkEventDND*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventDND* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /** Extract the root window relative x/y coordinates from an event.
   * Only meaningful if get_event_type() returns Gdk::Event::Type::DRAG_MOTION
   * orGdk::Event::Type::DROP_START.
   *
   * @param[out] x_root Location to put root window x coordinate.
   * @param[out] y_root Location to put root window y coordinate.
   */
  void get_root_coords(double& x_root, double& y_root) const;

  /**
   * Returns the drag context.
   */
  Glib::RefPtr<Gdk::DragContext> get_drag_context();
  /**
   * Returns the drag context.
   */
  Glib::RefPtr<const Gdk::DragContext> get_drag_context() const;
  

};

/** Rarely used event. Generated when a stylus has moved in or out of contact
 * with the tablet, or perhaps that the user's finger has moved in or out of
 * contact with a touch screen.
 *
 * This event type will be used pretty rarely. It only is important for XInput
 * aware programs that are drawing their own cursor.
 *
 * get_event_type() will return one of Gdk::Event::Type::PROXIMITY_IN,
 * Gdk::Event::Type::PROXIMITY_OUT.
 *
 * @newin{3,90}
 */
class EventProximity : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventProximity;
  using BaseObjectType = GdkEventProximity;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventProximity* gobj() noexcept { return reinterpret_cast<GdkEventProximity*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventProximity* gobj() const noexcept { return reinterpret_cast<const GdkEventProximity*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventProximity* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;


};

/** Generated when a pointer or keyboard grab is broken. On X11, this happens
 * when the grab window becomes unviewable (i.e. it or one of its ancestors is
 * unmapped), or if the same application grabs the pointer or keyboard again.
 * Note that implicit grabs (which are initiated by button presses) can also
 * cause Gdk::EventGrabBroken events.
 *
 * get_event_type() will return Gdk::Event::Type::GRAB_BROKEN.
 *
 * @newin{3,90}
 */
class EventGrabBroken : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventGrabBroken;
  using BaseObjectType = GdkEventGrabBroken;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventGrabBroken* gobj() noexcept { return reinterpret_cast<GdkEventGrabBroken*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventGrabBroken* gobj() const noexcept { return reinterpret_cast<const GdkEventGrabBroken*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventGrabBroken* gobj_copy();

private:


public:

  /*
   * @c true if a keyboard grab was broken, @c false if a pointer grab was
   * broken.
   */
  //bool is_keyboard() const; //TODO Remove? There is no corresponding gtk+ function.

  /*
   * @c true if the broken grab was implicit.
   */
  //bool is_implicit() const; //TODO Remove? There is no corresponding gtk+ function.

  /** Gets the new grab window if this event is caused by another grab in
   * the same application.
   *
   * @returns If this event is caused by another grab in the same application
   *          then the new grab window, else Glib::RefPtr<Gdk::Window>(nullptr).
   */
  Glib::RefPtr<Gdk::Window> get_grab_window();
  /** Gets the new grab window if this event is caused by another grab in
   * the same application.
   *
   * @returns If this event is caused by another grab in the same application
   *          then the new grab window, else Glib::RefPtr<const Gdk::Window>(nullptr).
   */
  Glib::RefPtr<const Gdk::Window> get_grab_window() const;
  

};

/** Generated during touchpad swipe gestures.
 *
 * get_event_type() will return Gdk::Event::Type::TOUCHPAD_SWIPE.
 *
 * @newin{3,90}
 */
class EventTouchpadSwipe : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTouchpadSwipe;
  using BaseObjectType = GdkEventTouchpadSwipe;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventTouchpadSwipe* gobj() noexcept { return reinterpret_cast<GdkEventTouchpadSwipe*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventTouchpadSwipe* gobj() const noexcept { return reinterpret_cast<const GdkEventTouchpadSwipe*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventTouchpadSwipe* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * Returns the current phase of the gesture.
   */
  TouchpadGesturePhase get_touchpad_gesture_phase() const;
   

  /**
   * Returns the number of fingers triggering the swipe.
   */
  guint get_touchpad_gesture_n_fingers() const;
  

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  /**
   * @param[out] dx The movement delta in the X axis of the swipe focal point.
   * @param[out] dy The movement delta in the Y axis of the swipe focal point.
   */
  void get_touchpad_deltas(double& dx, double& dy) const;
  

  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;


};

/** Generated during touchpad swipe gestures.
 *
 * get_event_type() will return Gdk::Event::Type::TOUCHPAD_PINCH.
 *
 * @newin{3,90}
 */
class EventTouchpadPinch : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTouchpadPinch;
  using BaseObjectType = GdkEventTouchpadPinch;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventTouchpadPinch* gobj() noexcept { return reinterpret_cast<GdkEventTouchpadPinch*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventTouchpadPinch* gobj() const noexcept { return reinterpret_cast<const GdkEventTouchpadPinch*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventTouchpadPinch* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * Returns the current phase of the gesture.
   */
  TouchpadGesturePhase get_touchpad_gesture_phase() const;

  /**
   * Returns the number of fingers triggering the swipe.
   */
  guint get_touchpad_gesture_n_fingers() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  
  /** Extract the event window relative x/y coordinates from an event.
   * 
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   */

  void get_coords(double& x_win, double& y_win) const;

  /**
   * @param[out] dx The movement delta in the X axis of the swipe focal point.
   * @param[out] dy The movement delta in the Y axis of the swipe focal point.
   */
  void get_touchpad_deltas(double& dx, double& dy) const;

  /**
   * Returns the angle change in radians. Negative angles denote counter-
   * clockwise movements.
   */
  double get_touchpad_angle_delta() const;
  

  /**
   * Returns the current scale, relative to that at the time of the
   * corresponding Gdk::TouchpadGesturePhase::BEGIN event.
   */
  double get_touchpad_scale() const;
  

  /** Extract the root window relative x/y coordinates from an event.
   * 
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   */

  void get_root_coords(double& x_root, double& y_root) const;


};

/** Generated during Gdk::InputSource::TABLET_PAD button presses and releases.
 *
 * get_event_type() will return Gdk::Event::Type::PAD_BUTTON_PRESS or
 * Gdk::Event::Type::PAD_BUTTON_RELEASE.
 *
 * @newin{3,90}
 */
class EventPadButton : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventPadButton;
  using BaseObjectType = GdkEventPadButton;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventPadButton* gobj() noexcept { return reinterpret_cast<GdkEventPadButton*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventPadButton* gobj() const noexcept { return reinterpret_cast<const GdkEventPadButton*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventPadButton* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * @param[out] group The pad group the button belongs to.
   *             A Gdk::InputSource::TABLET_PAD device may have one or more groups
   *             containing a set of buttons/rings/strips each.
   * @param[out] mode The current mode of @a group.
   *             Different groups in a Gdk::InputSource::TABLET_PAD device may have
   *             different current modes.
   */
  void get_pad_group_mode(guint& group, guint& mode) const;
  

  /**
   * Returns the pad button that was pressed.
   */
  guint get_pad_button() const;
  

};

/** Generated during Gdk::InputSource::TABLET_PAD interaction with tactile sensors.
 *
 * get_event_type() will return Gdk::Event::Type::PAD_RING or
 * Gdk::Event::Type::PAD_STRIP.
 *
 * @newin{3,90}
 */
class EventPadAxis : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventPadAxis;
  using BaseObjectType = GdkEventPadAxis;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventPadAxis* gobj() noexcept { return reinterpret_cast<GdkEventPadAxis*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventPadAxis* gobj() const noexcept { return reinterpret_cast<const GdkEventPadAxis*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventPadAxis* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * @param[out] group The pad group the button belongs to.
   *             A Gdk::InputSource::TABLET_PAD device may have one or more groups
   *             containing a set of buttons/rings/strips each.
   * @param[out] mode The current mode of @a group.
   *             Different groups in a Gdk::InputSource::TABLET_PAD device may have
   *             different current modes.
   */
  void get_pad_group_mode(guint& group, guint& mode) const;

  /**
   * @param[out] index The number of the strip/ring that was interacted.
   *             This number is 0-indexed.
   * @param[out] value The current value for the given axis.
   */
  void get_pad_axis_value(guint& index, double& value) const;
  

};

/** Generated during Gdk::InputSource::TABLET_PAD mode switches in a group.
 *
 * get_event_type() will return Gdk::Event::Type::PAD_GROUP_MODE.
 *
 * @newin{3,90}
 */
class EventPadGroupMode : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventPadGroupMode;
  using BaseObjectType = GdkEventPadGroupMode;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Provides access to the underlying C instance.
  GdkEventPadGroupMode* gobj() noexcept { return reinterpret_cast<GdkEventPadGroupMode*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventPadGroupMode* gobj() const noexcept { return reinterpret_cast<const GdkEventPadGroupMode*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for unrefing it with g_object_unref().
   * Use when directly setting fields in structs.
   */
  GdkEventPadGroupMode* gobj_copy();

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds.
   */
  guint32 get_time() const;

  /**
   * @param[out] group The pad group the button belongs to.
   *             A Gdk::InputSource::TABLET_PAD device may have one or more groups
   *             containing a set of buttons/rings/strips each.
   * @param[out] mode The current mode of @a group.
   *             Different groups in a Gdk::InputSource::TABLET_PAD device may have
   *             different current modes.
   */
  void get_pad_group_mode(guint& group, guint& mode) const;


};

} // namespace Gdk


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventKey
 */
Glib::RefPtr<Gdk::EventKey> wrap(GdkEventKey* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventButton
 */
Glib::RefPtr<Gdk::EventButton> wrap(GdkEventButton* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventScroll
 */
Glib::RefPtr<Gdk::EventScroll> wrap(GdkEventScroll* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventMotion
 */
Glib::RefPtr<Gdk::EventMotion> wrap(GdkEventMotion* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventTouch
 */
Glib::RefPtr<Gdk::EventTouch> wrap(GdkEventTouch* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventCrossing
 */
Glib::RefPtr<Gdk::EventCrossing> wrap(GdkEventCrossing* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventExpose
 */
Glib::RefPtr<Gdk::EventExpose> wrap(GdkEventExpose* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventFocus
 */
Glib::RefPtr<Gdk::EventFocus> wrap(GdkEventFocus* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventConfigure
 */
Glib::RefPtr<Gdk::EventConfigure> wrap(GdkEventConfigure* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventDND
 */
Glib::RefPtr<Gdk::EventDND> wrap(GdkEventDND* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventProximity
 */
Glib::RefPtr<Gdk::EventProximity> wrap(GdkEventProximity* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventGrabBroken
 */
Glib::RefPtr<Gdk::EventGrabBroken> wrap(GdkEventGrabBroken* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventTouchpadSwipe
 */
Glib::RefPtr<Gdk::EventTouchpadSwipe> wrap(GdkEventTouchpadSwipe* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventTouchpadPinch
 */
Glib::RefPtr<Gdk::EventTouchpadPinch> wrap(GdkEventTouchpadPinch* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventPadButton
 */
Glib::RefPtr<Gdk::EventPadButton> wrap(GdkEventPadButton* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventPadAxis
 */
Glib::RefPtr<Gdk::EventPadAxis> wrap(GdkEventPadAxis* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance.
 *        @c true if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventPadGroupMode
 */
Glib::RefPtr<Gdk::EventPadGroupMode> wrap(GdkEventPadGroupMode* object, bool take_copy = false);

} // namespace Glib


#endif /* _GDKMM_EVENTS_H */

