/* tracker-status.c generated by valac 0.43.90, the Vala compiler
 * generated from tracker-status.vala, do not modify */

/*
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Authors:
 *  Philip Van Hoof <philip@codeminded.be>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-data-update.h"

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
typedef struct _TrackerStatusPrivate TrackerStatusPrivate;

#define TRACKER_STATUS_TYPE_WAIT_CONTEXT (tracker_status_wait_context_get_type ())
#define TRACKER_STATUS_WAIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContext))
#define TRACKER_STATUS_WAIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContextClass))
#define TRACKER_STATUS_IS_WAIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STATUS_TYPE_WAIT_CONTEXT))
#define TRACKER_STATUS_IS_WAIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STATUS_TYPE_WAIT_CONTEXT))
#define TRACKER_STATUS_WAIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContextClass))

typedef struct _TrackerStatusWaitContext TrackerStatusWaitContext;
typedef struct _TrackerStatusWaitContextClass TrackerStatusWaitContextClass;
enum  {
	TRACKER_STATUS_0_PROPERTY,
	TRACKER_STATUS_NUM_PROPERTIES
};
static GParamSpec* tracker_status_properties[TRACKER_STATUS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerStatusWaitContextPrivate TrackerStatusWaitContextPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerStatusWaitData TrackerStatusWaitData;
enum  {
	TRACKER_STATUS_WAIT_CONTEXT_0_PROPERTY,
	TRACKER_STATUS_WAIT_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* tracker_status_wait_context_properties[TRACKER_STATUS_WAIT_CONTEXT_NUM_PROPERTIES];
enum  {
	TRACKER_STATUS_PROGRESS_SIGNAL,
	TRACKER_STATUS_NUM_SIGNALS
};
static guint tracker_status_signals[TRACKER_STATUS_NUM_SIGNALS] = {0};
typedef struct _TrackerStatusWaitReadyData TrackerStatusWaitReadyData;

struct _TrackerStatus {
	GObject parent_instance;
	TrackerStatusPrivate * priv;
};

struct _TrackerStatusClass {
	GObjectClass parent_class;
};

struct _TrackerStatusPrivate {
	gdouble _progress;
	gchar* status;
	guint timer_id;
	GList* wait_list;
};

struct _TrackerStatusWaitContext {
	GObject parent_instance;
	TrackerStatusWaitContextPrivate * priv;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _TrackerStatusWaitContextClass {
	GObjectClass parent_class;
};

struct _TrackerStatusWaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerStatus* self;
	const gchar* _tmp0_;
	TrackerStatusWaitContext* context;
	TrackerStatusWaitContext* _tmp1_;
	TrackerStatusWaitContext* _tmp2_;
	TrackerStatusWaitContext* _tmp3_;
	TrackerStatusWaitContext* _tmp4_;
};

struct _TrackerStatusWaitReadyData {
	GDBusMethodInvocation* _invocation_;
};

static gint TrackerStatus_private_offset;
static gpointer tracker_status_parent_class = NULL;
static gboolean tracker_status_first_time;
static gboolean tracker_status_first_time = TRUE;
static gpointer tracker_status_wait_context_parent_class = NULL;

GType tracker_status_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStatus, g_object_unref)
guint tracker_status_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
static GType tracker_status_wait_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStatusWaitContext, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
#define TRACKER_STATUS_PATH "/org/freedesktop/Tracker1/Status"
#define TRACKER_STATUS_PROGRESS_TIMEOUT_S 5
static gboolean tracker_status_busy_notification_timeout (TrackerStatus* self);
static void tracker_status_callback (TrackerStatus* self,
                              const gchar* status,
                              gdouble progress);
static gboolean _tracker_status_busy_notification_timeout_gsource_func (gpointer self);
TrackerBusyCallback tracker_status_get_callback (TrackerStatus* self,
                                                 gpointer* result_target,
                                                 GDestroyNotify* result_target_destroy_notify);
static void _tracker_status_callback_tracker_busy_callback (const gchar* status,
                                                     gdouble progress,
                                                     gpointer self);
gdouble tracker_status_get_progress (TrackerStatus* self);
gchar* tracker_status_get_status (TrackerStatus* self);
static void tracker_status_wait_data_free (gpointer _data);
void tracker_status_wait (TrackerStatus* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
void tracker_status_wait_finish (TrackerStatus* self,
                                 GAsyncResult* _res_,
                                 GError** error);
static gboolean tracker_status_wait_co (TrackerStatusWaitData* _data_);
static TrackerStatusWaitContext* tracker_status_wait_context_new (void);
static TrackerStatusWaitContext* tracker_status_wait_context_construct (GType object_type);
static gboolean _tracker_status_wait_co_gsource_func (gpointer self);
TrackerStatus* tracker_status_new (void);
TrackerStatus* tracker_status_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void tracker_status_wait_context_finalize (GObject * obj);
static void tracker_status_finalize (GObject * obj);
static void _dbus_tracker_status_get_progress (TrackerStatus* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void _dbus_tracker_status_get_status (TrackerStatus* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_tracker_status_wait (TrackerStatus* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation);
static void _dbus_tracker_status_wait_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_);
static void tracker_status_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* tracker_status_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static gboolean tracker_status_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _dbus_tracker_status_progress (GObject* _sender,
                                    const gchar* status,
                                    gdouble progres,
                                    gpointer* _data);
static void _tracker_status_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_status_dbus_arg_info_get_progress_result = {-1, "result", "d", NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_progress_in[] = {NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_progress_out[] = {&_tracker_status_dbus_arg_info_get_progress_result, NULL};
static const GDBusMethodInfo _tracker_status_dbus_method_info_get_progress = {-1, "GetProgress", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_progress_in), (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_progress_out), NULL};
static const GDBusArgInfo _tracker_status_dbus_arg_info_get_status_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_status_in[] = {NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_get_status_out[] = {&_tracker_status_dbus_arg_info_get_status_result, NULL};
static const GDBusMethodInfo _tracker_status_dbus_method_info_get_status = {-1, "GetStatus", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_status_in), (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_get_status_out), NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_wait_in[] = {NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_wait_out[] = {NULL};
static const GDBusMethodInfo _tracker_status_dbus_method_info_wait = {-1, "Wait", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_wait_in), (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_wait_out), NULL};
static const GDBusMethodInfo * const _tracker_status_dbus_method_info[] = {&_tracker_status_dbus_method_info_get_progress, &_tracker_status_dbus_method_info_get_status, &_tracker_status_dbus_method_info_wait, NULL};
static const GDBusArgInfo _tracker_status_dbus_arg_info_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _tracker_status_dbus_arg_info_progress_progres = {-1, "progres", "d", NULL};
static const GDBusArgInfo * const _tracker_status_dbus_arg_info_progress[] = {&_tracker_status_dbus_arg_info_progress_status, &_tracker_status_dbus_arg_info_progress_progres, NULL};
static const GDBusSignalInfo _tracker_status_dbus_signal_info_progress = {-1, "Progress", (GDBusArgInfo **) (&_tracker_status_dbus_arg_info_progress), NULL};
static const GDBusSignalInfo * const _tracker_status_dbus_signal_info[] = {&_tracker_status_dbus_signal_info_progress, NULL};
static const GDBusPropertyInfo * const _tracker_status_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_status_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Status", (GDBusMethodInfo **) (&_tracker_status_dbus_method_info), (GDBusSignalInfo **) (&_tracker_status_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_status_dbus_property_info), NULL};
static const GDBusInterfaceVTable _tracker_status_dbus_interface_vtable = {tracker_status_dbus_interface_method_call, tracker_status_dbus_interface_get_property, tracker_status_dbus_interface_set_property};

static inline gpointer
tracker_status_get_instance_private (TrackerStatus* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerStatus_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
#line 36 "tracker-status.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 248 "tracker-status.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 36 "tracker-status.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 256 "tracker-status.c"
}

static gboolean
tracker_status_busy_notification_timeout (TrackerStatus* self)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 57 "tracker-status.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "tracker-status.vala"
	_tmp0_ = self->priv->status;
#line 59 "tracker-status.vala"
	g_signal_emit (self, tracker_status_signals[TRACKER_STATUS_PROGRESS_SIGNAL], 0, _tmp0_, self->priv->_progress);
#line 61 "tracker-status.vala"
	self->priv->timer_id = (guint) 0;
#line 63 "tracker-status.vala"
	result = FALSE;
#line 63 "tracker-status.vala"
	return result;
#line 276 "tracker-status.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 75 "tracker-status.vala"
	return self ? g_object_ref (self) : NULL;
#line 284 "tracker-status.c"
}

static gboolean
_tracker_status_busy_notification_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_status_busy_notification_timeout ((TrackerStatus*) self);
#line 88 "tracker-status.vala"
	return result;
#line 294 "tracker-status.c"
}

static void
tracker_status_callback (TrackerStatus* self,
                         const gchar* status,
                         gdouble progress)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp6_;
#line 68 "tracker-status.vala"
	g_return_if_fail (self != NULL);
#line 68 "tracker-status.vala"
	g_return_if_fail (status != NULL);
#line 69 "tracker-status.vala"
	self->priv->_progress = progress;
#line 71 "tracker-status.vala"
	if (progress == ((gdouble) 1)) {
#line 312 "tracker-status.c"
		GList* _tmp1_;
#line 71 "tracker-status.vala"
		_tmp1_ = self->priv->wait_list;
#line 71 "tracker-status.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 318 "tracker-status.c"
	} else {
#line 71 "tracker-status.vala"
		_tmp0_ = FALSE;
#line 322 "tracker-status.c"
	}
#line 71 "tracker-status.vala"
	if (_tmp0_) {
#line 326 "tracker-status.c"
		GList* _tmp2_;
#line 74 "tracker-status.vala"
		self->priv->wait_list = g_list_reverse (self->priv->wait_list);
#line 75 "tracker-status.vala"
		_tmp2_ = self->priv->wait_list;
#line 332 "tracker-status.c"
		{
			GList* context_collection = NULL;
			GList* context_it = NULL;
#line 75 "tracker-status.vala"
			context_collection = _tmp2_;
#line 75 "tracker-status.vala"
			for (context_it = context_collection; context_it != NULL; context_it = context_it->next) {
#line 340 "tracker-status.c"
				TrackerStatusWaitContext* _tmp3_;
				TrackerStatusWaitContext* context = NULL;
#line 75 "tracker-status.vala"
				_tmp3_ = _g_object_ref0 ((TrackerStatusWaitContext*) context_it->data);
#line 75 "tracker-status.vala"
				context = _tmp3_;
#line 347 "tracker-status.c"
				{
					TrackerStatusWaitContext* _tmp4_;
					GSourceFunc _tmp5_;
					gpointer _tmp5__target;
#line 76 "tracker-status.vala"
					_tmp4_ = context;
#line 76 "tracker-status.vala"
					_tmp5_ = _tmp4_->callback;
#line 76 "tracker-status.vala"
					_tmp5__target = _tmp4_->callback_target;
#line 76 "tracker-status.vala"
					_tmp5_ (_tmp5__target);
#line 75 "tracker-status.vala"
					_g_object_unref0 (context);
#line 362 "tracker-status.c"
				}
			}
		}
#line 79 "tracker-status.vala"
		(self->priv->wait_list == NULL) ? NULL : (self->priv->wait_list = (_g_list_free__g_object_unref0_ (self->priv->wait_list), NULL));
#line 79 "tracker-status.vala"
		self->priv->wait_list = NULL;
#line 370 "tracker-status.c"
	}
#line 82 "tracker-status.vala"
	_tmp6_ = self->priv->status;
#line 82 "tracker-status.vala"
	if (g_strcmp0 (status, _tmp6_) != 0) {
#line 376 "tracker-status.c"
		gchar* _tmp7_;
#line 83 "tracker-status.vala"
		_tmp7_ = g_strdup (status);
#line 83 "tracker-status.vala"
		_g_free0 (self->priv->status);
#line 83 "tracker-status.vala"
		self->priv->status = _tmp7_;
#line 384 "tracker-status.c"
	}
#line 86 "tracker-status.vala"
	if (self->priv->timer_id == ((guint) 0)) {
#line 87 "tracker-status.vala"
		if (tracker_status_first_time) {
#line 88 "tracker-status.vala"
			self->priv->timer_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tracker_status_busy_notification_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 89 "tracker-status.vala"
			tracker_status_first_time = FALSE;
#line 394 "tracker-status.c"
		} else {
#line 91 "tracker-status.vala"
			self->priv->timer_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) TRACKER_STATUS_PROGRESS_TIMEOUT_S, _tracker_status_busy_notification_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 398 "tracker-status.c"
		}
	}
#line 95 "tracker-status.vala"
	while (TRUE) {
#line 403 "tracker-status.c"
		GMainContext* _tmp8_;
#line 95 "tracker-status.vala"
		_tmp8_ = g_main_context_default ();
#line 95 "tracker-status.vala"
		if (!g_main_context_iteration (_tmp8_, FALSE)) {
#line 95 "tracker-status.vala"
			break;
#line 411 "tracker-status.c"
		}
	}
}

static void
_tracker_status_callback_tracker_busy_callback (const gchar* status,
                                                gdouble progress,
                                                gpointer self)
{
#line 101 "tracker-status.vala"
	tracker_status_callback ((TrackerStatus*) self, status, progress);
#line 423 "tracker-status.c"
}

TrackerBusyCallback
tracker_status_get_callback (TrackerStatus* self,
                             gpointer* result_target,
                             GDestroyNotify* result_target_destroy_notify)
{
	TrackerBusyCallback result = NULL;
	TrackerBusyCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
#line 100 "tracker-status.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "tracker-status.vala"
	_tmp0_ = _tracker_status_callback_tracker_busy_callback;
#line 101 "tracker-status.vala"
	_tmp0__target = g_object_ref (self);
#line 101 "tracker-status.vala"
	_tmp0__target_destroy_notify = g_object_unref;
#line 101 "tracker-status.vala"
	*result_target = _tmp0__target;
#line 101 "tracker-status.vala"
	*result_target_destroy_notify = _tmp0__target_destroy_notify;
#line 101 "tracker-status.vala"
	result = _tmp0_;
#line 101 "tracker-status.vala"
	return result;
#line 451 "tracker-status.c"
}

gdouble
tracker_status_get_progress (TrackerStatus* self)
{
	gdouble result = 0.0;
#line 104 "tracker-status.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 105 "tracker-status.vala"
	result = self->priv->_progress;
#line 105 "tracker-status.vala"
	return result;
#line 464 "tracker-status.c"
}

gchar*
tracker_status_get_status (TrackerStatus* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 108 "tracker-status.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "tracker-status.vala"
	_tmp0_ = self->priv->status;
#line 109 "tracker-status.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 109 "tracker-status.vala"
	result = _tmp1_;
#line 109 "tracker-status.vala"
	return result;
#line 483 "tracker-status.c"
}

static void
tracker_status_wait_data_free (gpointer _data)
{
	TrackerStatusWaitData* _data_;
	_data_ = _data;
#line 24 "tracker-status.vala"
	_g_object_unref0 (_data_->self);
#line 24 "tracker-status.vala"
	g_slice_free (TrackerStatusWaitData, _data_);
#line 495 "tracker-status.c"
}

void
tracker_status_wait (TrackerStatus* self,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	TrackerStatusWaitData* _data_;
	TrackerStatus* _tmp0_;
#line 24 "tracker-status.vala"
	_data_ = g_slice_new0 (TrackerStatusWaitData);
#line 24 "tracker-status.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "tracker-status.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_status_wait_data_free);
#line 24 "tracker-status.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "tracker-status.vala"
	_data_->self = _tmp0_;
#line 24 "tracker-status.vala"
	tracker_status_wait_co (_data_);
#line 517 "tracker-status.c"
}

void
tracker_status_wait_finish (TrackerStatus* self,
                            GAsyncResult* _res_,
                            GError** error)
{
	TrackerStatusWaitData* _data_;
#line 24 "tracker-status.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "tracker-status.vala"
	if (NULL == _data_) {
#line 24 "tracker-status.vala"
		return;
#line 532 "tracker-status.c"
	}
}

static gboolean
_tracker_status_wait_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_status_wait_co (self);
#line 117 "tracker-status.vala"
	return result;
#line 543 "tracker-status.c"
}

static gboolean
tracker_status_wait_co (TrackerStatusWaitData* _data_)
{
#line 112 "tracker-status.vala"
	switch (_data_->_state_) {
#line 112 "tracker-status.vala"
		case 0:
#line 553 "tracker-status.c"
		goto _state_0;
#line 112 "tracker-status.vala"
		case 1:
#line 557 "tracker-status.c"
		goto _state_1;
		default:
#line 112 "tracker-status.vala"
		g_assert_not_reached ();
#line 562 "tracker-status.c"
	}
	_state_0:
#line 113 "tracker-status.vala"
	_data_->_tmp0_ = _data_->self->priv->status;
#line 113 "tracker-status.vala"
	if (g_strcmp0 (_data_->_tmp0_, "Idle") == 0) {
#line 569 "tracker-status.c"
	} else {
#line 116 "tracker-status.vala"
		_data_->_tmp1_ = tracker_status_wait_context_new ();
#line 116 "tracker-status.vala"
		_data_->context = _data_->_tmp1_;
#line 117 "tracker-status.vala"
		_data_->_tmp2_ = _data_->context;
#line 117 "tracker-status.vala"
		(_data_->_tmp2_->callback_target_destroy_notify == NULL) ? NULL : (_data_->_tmp2_->callback_target_destroy_notify (_data_->_tmp2_->callback_target), NULL);
#line 117 "tracker-status.vala"
		_data_->_tmp2_->callback = NULL;
#line 117 "tracker-status.vala"
		_data_->_tmp2_->callback_target = NULL;
#line 117 "tracker-status.vala"
		_data_->_tmp2_->callback_target_destroy_notify = NULL;
#line 117 "tracker-status.vala"
		_data_->_tmp2_->callback = _tracker_status_wait_co_gsource_func;
#line 117 "tracker-status.vala"
		_data_->_tmp2_->callback_target = _data_;
#line 117 "tracker-status.vala"
		_data_->_tmp2_->callback_target_destroy_notify = NULL;
#line 118 "tracker-status.vala"
		_data_->_tmp3_ = _data_->context;
#line 118 "tracker-status.vala"
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 118 "tracker-status.vala"
		_data_->self->priv->wait_list = g_list_prepend (_data_->self->priv->wait_list, _data_->_tmp4_);
#line 119 "tracker-status.vala"
		_data_->_state_ = 1;
#line 119 "tracker-status.vala"
		return FALSE;
#line 601 "tracker-status.c"
		_state_1:
		;
#line 113 "tracker-status.vala"
		_g_object_unref0 (_data_->context);
#line 606 "tracker-status.c"
	}
#line 112 "tracker-status.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 112 "tracker-status.vala"
	if (_data_->_state_ != 0) {
#line 112 "tracker-status.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 112 "tracker-status.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 616 "tracker-status.c"
		}
	}
#line 112 "tracker-status.vala"
	g_object_unref (_data_->_async_result);
#line 112 "tracker-status.vala"
	return FALSE;
#line 623 "tracker-status.c"
}

TrackerStatus*
tracker_status_construct (GType object_type)
{
	TrackerStatus * self = NULL;
#line 24 "tracker-status.vala"
	self = (TrackerStatus*) g_object_new (object_type, NULL);
#line 24 "tracker-status.vala"
	return self;
#line 634 "tracker-status.c"
}

TrackerStatus*
tracker_status_new (void)
{
#line 24 "tracker-status.vala"
	return tracker_status_construct (TRACKER_TYPE_STATUS);
#line 642 "tracker-status.c"
}

static void
g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_DOUBLE) (gpointer data1, const char* arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "tracker-status.vala"
	g_return_if_fail (n_param_values == 3);
#line 24 "tracker-status.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "tracker-status.vala"
		data1 = closure->data;
#line 24 "tracker-status.vala"
		data2 = param_values->data[0].v_pointer;
#line 667 "tracker-status.c"
	} else {
#line 24 "tracker-status.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "tracker-status.vala"
		data2 = closure->data;
#line 673 "tracker-status.c"
	}
#line 24 "tracker-status.vala"
	callback = (GMarshalFunc_VOID__STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
#line 24 "tracker-status.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_double (param_values + 2), data2);
#line 679 "tracker-status.c"
}

static TrackerStatusWaitContext*
tracker_status_wait_context_construct (GType object_type)
{
	TrackerStatusWaitContext * self = NULL;
#line 29 "tracker-status.vala"
	self = (TrackerStatusWaitContext*) g_object_new (object_type, NULL);
#line 29 "tracker-status.vala"
	return self;
#line 690 "tracker-status.c"
}

static TrackerStatusWaitContext*
tracker_status_wait_context_new (void)
{
#line 29 "tracker-status.vala"
	return tracker_status_wait_context_construct (TRACKER_STATUS_TYPE_WAIT_CONTEXT);
#line 698 "tracker-status.c"
}

static void
tracker_status_wait_context_class_init (TrackerStatusWaitContextClass * klass,
                                        gpointer klass_data)
{
#line 29 "tracker-status.vala"
	tracker_status_wait_context_parent_class = g_type_class_peek_parent (klass);
#line 29 "tracker-status.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_status_wait_context_finalize;
#line 709 "tracker-status.c"
}

static void
tracker_status_wait_context_instance_init (TrackerStatusWaitContext * self,
                                           gpointer klass)
{
}

static void
tracker_status_wait_context_finalize (GObject * obj)
{
	TrackerStatusWaitContext * self;
#line 29 "tracker-status.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STATUS_TYPE_WAIT_CONTEXT, TrackerStatusWaitContext);
#line 30 "tracker-status.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 30 "tracker-status.vala"
	self->callback = NULL;
#line 30 "tracker-status.vala"
	self->callback_target = NULL;
#line 30 "tracker-status.vala"
	self->callback_target_destroy_notify = NULL;
#line 29 "tracker-status.vala"
	G_OBJECT_CLASS (tracker_status_wait_context_parent_class)->finalize (obj);
#line 734 "tracker-status.c"
}

static GType
tracker_status_wait_context_get_type (void)
{
	static volatile gsize tracker_status_wait_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_status_wait_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStatusWaitContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_status_wait_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStatusWaitContext), 0, (GInstanceInitFunc) tracker_status_wait_context_instance_init, NULL };
		GType tracker_status_wait_context_type_id;
		tracker_status_wait_context_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerStatusWaitContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_status_wait_context_type_id__volatile, tracker_status_wait_context_type_id);
	}
	return tracker_status_wait_context_type_id__volatile;
}

static void
tracker_status_class_init (TrackerStatusClass * klass,
                           gpointer klass_data)
{
#line 24 "tracker-status.vala"
	tracker_status_parent_class = g_type_class_peek_parent (klass);
#line 24 "tracker-status.vala"
	g_type_class_adjust_private_offset (klass, &TrackerStatus_private_offset);
#line 24 "tracker-status.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_status_finalize;
#line 760 "tracker-status.c"
	/**
	 * TrackerStatus::progress:
	 * @notifier: the TrackerStatus
	 * @status: store status
	 * @progress: a #gdouble indicating store progress, from 0 to 1.
	 *
	 * the ::progress signal will be emitted by TrackerStatus
	 * to indicate progress about the store process. @status will
	 * contain a translated string with the current status and @progress
	 * will indicate how much has been processed so far.
	 **/
#line 24 "tracker-status.vala"
	tracker_status_signals[TRACKER_STATUS_PROGRESS_SIGNAL] = g_signal_new ("progress", TRACKER_TYPE_STATUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_DOUBLE, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_DOUBLE);
#line 774 "tracker-status.c"
}

static void
tracker_status_instance_init (TrackerStatus * self,
                              gpointer klass)
{
	gchar* _tmp0_;
#line 24 "tracker-status.vala"
	self->priv = tracker_status_get_instance_private (self);
#line 34 "tracker-status.vala"
	_tmp0_ = g_strdup ("Idle");
#line 34 "tracker-status.vala"
	self->priv->status = _tmp0_;
#line 788 "tracker-status.c"
}

static void
tracker_status_finalize (GObject * obj)
{
	TrackerStatus * self;
#line 24 "tracker-status.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STATUS, TrackerStatus);
#line 52 "tracker-status.vala"
	if (self->priv->timer_id != ((guint) 0)) {
#line 53 "tracker-status.vala"
		g_source_remove (self->priv->timer_id);
#line 801 "tracker-status.c"
	}
#line 34 "tracker-status.vala"
	_g_free0 (self->priv->status);
#line 36 "tracker-status.vala"
	(self->priv->wait_list == NULL) ? NULL : (self->priv->wait_list = (_g_list_free__g_object_unref0_ (self->priv->wait_list), NULL));
#line 24 "tracker-status.vala"
	G_OBJECT_CLASS (tracker_status_parent_class)->finalize (obj);
#line 809 "tracker-status.c"
}

GType
tracker_status_get_type (void)
{
	static volatile gsize tracker_status_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStatusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_status_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStatus), 0, (GInstanceInitFunc) tracker_status_instance_init, NULL };
		GType tracker_status_type_id;
		tracker_status_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerStatus", &g_define_type_info, 0);
		g_type_set_qdata (tracker_status_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_status_register_object);
		TrackerStatus_private_offset = g_type_add_instance_private (tracker_status_type_id, sizeof (TrackerStatusPrivate));
		g_once_init_leave (&tracker_status_type_id__volatile, tracker_status_type_id);
	}
	return tracker_status_type_id__volatile;
}

static void
_dbus_tracker_status_get_progress (TrackerStatus* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gdouble result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = tracker_status_get_progress (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_double (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_tracker_status_get_status (TrackerStatus* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = tracker_status_get_status (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_tracker_status_wait (TrackerStatus* self,
                           GVariant* _parameters_,
                           GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	TrackerStatusWaitReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerStatusWaitReadyData);
	_ready_data->_invocation_ = invocation;
	tracker_status_wait (self, (GAsyncReadyCallback) _dbus_tracker_status_wait_ready, _ready_data);
}

static void
_dbus_tracker_status_wait_ready (GObject * source_object,
                                 GAsyncResult * _res_,
                                 gpointer _user_data_)
{
	TrackerStatusWaitReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	tracker_status_wait_finish ((TrackerStatus*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (TrackerStatusWaitReadyData, _ready_data);
}

static void
tracker_status_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetProgress") == 0) {
		_dbus_tracker_status_get_progress (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStatus") == 0) {
		_dbus_tracker_status_get_status (object, parameters, invocation);
	} else if (strcmp (method_name, "Wait") == 0) {
		_dbus_tracker_status_wait (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
tracker_status_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
tracker_status_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_tracker_status_progress (GObject* _sender,
                               const gchar* status,
                               gdouble progres,
                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progres));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Status", "Progress", _arguments, NULL);
}

guint
tracker_status_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_status_dbus_interface_info), &_tracker_status_dbus_interface_vtable, data, _tracker_status_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "progress", (GCallback) _dbus_tracker_status_progress, data);
	return result;
}

static void
_tracker_status_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_status_progress, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

