/* rygel-searchable-container.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;

#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObjectPrivate MediaObjectPrivate;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	gchar* sort_criteria;
	gint child_count;
	gboolean create_mode_enabled;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	MediaObjects* result;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	gint count;
	gint _tmp1_;
	gint _tmp2_;
	MediaObjects* children;
	MediaObjects* _tmp3_;
	guint limit;
	MediaObjects* _child_list;
	MediaObjects* _tmp4_;
	MediaObjects* _tmp5_;
	gint _child_size;
	MediaObjects* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _child_index;
	MediaObject* child;
	MediaObjects* _tmp9_;
	gpointer _tmp10_;
	gboolean _tmp11_;
	MediaObject* _tmp12_;
	MediaObjects* _tmp13_;
	MediaObject* _tmp14_;
	gboolean _tmp15_;
	MediaObjects* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_;
	MediaObjects* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	guint _tmp23_;
	MediaObjects* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	guint child_limit;
	MediaObjects* child_results;
	MediaObjects* _tmp27_;
	MediaObjects* _tmp28_;
	MediaObjects* _tmp29_;
	MediaObjects* _tmp30_;
	MediaObjects* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	MediaObjects* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	MediaObjects* _tmp37_;
	gboolean _tmp38_;
	MediaObjects* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gboolean _tmp42_;
	guint stop;
	gboolean _tmp43_;
	MediaObjects* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	MediaObjects* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	MediaObjects* _tmp50_;
	GeeList* _tmp51_;
	MediaObjects* _tmp52_;
	GError* _inner_error0_;
};

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	MediaObject* result;
	RelationalExpression* expression;
	RelationalExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	MediaObjects* results;
	guint _tmp4_;
	MediaObjects* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gpointer _tmp8_;
	GError* _inner_error0_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	MediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	MediaObjects* _child_list;
	MediaObjects* _tmp1_;
	gint _child_size;
	MediaObjects* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _child_index;
	MediaObject* child;
	MediaObjects* _tmp5_;
	gpointer _tmp6_;
	MediaObject* _tmp7_;
	RygelSearchableContainer* container;
	MediaObject* _tmp8_;
	RygelSearchableContainer* _tmp9_;
	guint tmp;
	MediaObjects* child_result;
	RygelSearchableContainer* _tmp10_;
	guint _tmp11_;
	MediaObjects* _tmp12_;
	MediaObjects* _tmp13_;
	MediaObjects* _tmp14_;
	gboolean _tmp15_;
	MediaObjects* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GError* _inner_error0_;
};

GType media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaObject, g_object_unref)
GType media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaContainer, g_object_unref)
GType search_expression_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchExpression, g_object_unref)
GType media_objects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaObjects, g_object_unref)
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self,
                                        SearchExpression* expression,
                                        guint offset,
                                        guint max_count,
                                        const gchar* sort_criteria,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self,
                                                        GAsyncResult* _res_,
                                                        guint* total_matches,
                                                        GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self,
                                               SearchExpression* expression,
                                               guint offset,
                                               guint max_count,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self,
                                                               GAsyncResult* _res_,
                                                               guint* total_matches,
                                                               GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_check_search_expression (MediaContainer* self,
                                              SearchExpression* expression);
gint media_container_get_all_child_count (MediaContainer* self);
void media_container_get_children (MediaContainer* self,
                                   guint offset,
                                   guint max_count,
                                   const gchar* sort_criteria,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static void rygel_searchable_container_simple_search_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
gboolean search_expression_satisfied_by (SearchExpression* self,
                                         MediaObject* object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self,
                                                    SearchExpression* expression,
                                                    MediaObjects* children,
                                                    guint limit,
                                                    const gchar* sort_criteria,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self,
                                             const gchar* id,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
GType relational_expression_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RelationalExpression, g_object_unref)
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
#define SEARCH_CRITERIA_OP_EQ "="
static void rygel_searchable_container_find_object_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self,
                                                             GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self,
                                                    GeeArrayList* value);

void
rygel_searchable_container_search (RygelSearchableContainer* self,
                                   SearchExpression* expression,
                                   guint offset,
                                   guint max_count,
                                   const gchar* sort_criteria,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
}

MediaObjects*
rygel_searchable_container_search_finish (RygelSearchableContainer* self,
                                          GAsyncResult* _res_,
                                          guint* total_matches,
                                          GError** error)
{
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
}

static void
rygel_searchable_container_simple_search_data_free (gpointer _data)
{
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
rygel_searchable_container_simple_search (RygelSearchableContainer* self,
                                          SearchExpression* expression,
                                          guint offset,
                                          guint max_count,
                                          const gchar* sort_criteria,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	SearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (expression);
	_g_object_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_searchable_container_simple_search_co (_data_);
}

MediaObjects*
rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self,
                                                 GAsyncResult* _res_,
                                                 guint* total_matches,
                                                 GError** error)
{
	MediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void
rygel_searchable_container_simple_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_simple_search_co (_data_);
}

static gboolean
rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	_data_->count = ((MediaContainer*) _data_->self)->child_count;
	media_container_check_search_expression ((MediaContainer*) _data_->self, _data_->expression);
	if (((MediaContainer*) _data_->self)->create_mode_enabled) {
		_data_->_tmp1_ = media_container_get_all_child_count ((MediaContainer*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->count = _data_->_tmp2_;
	}
	_data_->_state_ = 1;
	media_container_get_children ((MediaContainer*) _data_->self, (guint) 0, (guint) _data_->count, _data_->sort_criteria, _data_->cancellable, rygel_searchable_container_simple_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = media_container_get_children_finish ((MediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->children = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_result_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->max_count > ((guint) 0)) {
		_data_->limit = _data_->offset + _data_->max_count;
	} else {
		_data_->limit = (guint) 0;
	}
	{
		_data_->_tmp4_ = _data_->children;
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
		_data_->_child_list = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->_child_list;
		_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_child_size = _data_->_tmp8_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_child_index = _data_->_child_index + 1;
			if (!(_data_->_child_index < _data_->_child_size)) {
				break;
			}
			_data_->_tmp9_ = _data_->_child_list;
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_child_index);
			_data_->child = (MediaObject*) _data_->_tmp10_;
			if (_data_->expression == NULL) {
				_data_->_tmp11_ = TRUE;
			} else {
				_data_->_tmp12_ = _data_->child;
				_data_->_tmp11_ = search_expression_satisfied_by (_data_->expression, _data_->_tmp12_);
			}
			if (_data_->_tmp11_) {
				_data_->_tmp13_ = _data_->_result_;
				_data_->_tmp14_ = _data_->child;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp13_, _data_->_tmp14_);
			}
			if (_data_->limit > ((guint) 0)) {
				_data_->_tmp16_ = _data_->_result_;
				_data_->_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp15_ = ((guint) _data_->_tmp18_) >= _data_->limit;
			} else {
				_data_->_tmp15_ = FALSE;
			}
			if (_data_->_tmp15_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	if (_data_->limit == ((guint) 0)) {
		_data_->_tmp19_ = TRUE;
	} else {
		_data_->_tmp20_ = _data_->_result_;
		_data_->_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp19_ = ((guint) _data_->_tmp22_) < _data_->limit;
	}
	if (_data_->_tmp19_) {
		if (_data_->limit == ((guint) 0)) {
			_data_->_tmp23_ = (guint) 0;
		} else {
			_data_->_tmp24_ = _data_->_result_;
			_data_->_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp23_ = _data_->limit - _data_->_tmp26_;
		}
		_data_->child_limit = _data_->_tmp23_;
		_data_->_tmp27_ = _data_->children;
		_data_->_state_ = 2;
		rygel_searchable_container_search_in_children (_data_->self, _data_->expression, _data_->_tmp27_, _data_->child_limit, _data_->sort_criteria, _data_->cancellable, rygel_searchable_container_simple_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp28_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->child_results = _data_->_tmp28_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->children);
			_g_object_unref0 (_data_->_result_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp29_ = _data_->_result_;
		_data_->_tmp30_ = _data_->child_results;
		gee_array_list_add_all ((GeeArrayList*) _data_->_tmp29_, (GeeCollection*) _data_->_tmp30_);
		_g_object_unref0 (_data_->child_results);
	}
	if (_data_->max_count > ((guint) 0)) {
		_data_->total_matches = (guint) 0;
	} else {
		_data_->_tmp31_ = _data_->_result_;
		_data_->_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->total_matches = (guint) _data_->_tmp33_;
	}
	_data_->_tmp34_ = _data_->_result_;
	_data_->_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp34_);
	_data_->_tmp36_ = _data_->_tmp35_;
	if (_data_->offset >= ((guint) _data_->_tmp36_)) {
		_data_->_tmp37_ = media_objects_new ();
		_data_->result = _data_->_tmp37_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = _data_->_result_;
	_data_->_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp39_);
	_data_->_tmp41_ = _data_->_tmp40_;
	if (_data_->_tmp41_ > 0) {
		if (_data_->max_count > ((guint) 0)) {
			_data_->_tmp42_ = TRUE;
		} else {
			_data_->_tmp42_ = _data_->offset > ((guint) 0);
		}
		_data_->_tmp38_ = _data_->_tmp42_;
	} else {
		_data_->_tmp38_ = FALSE;
	}
	if (_data_->_tmp38_) {
		if (_data_->max_count != ((guint) 0)) {
			_data_->_tmp44_ = _data_->_result_;
			_data_->_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp44_);
			_data_->_tmp46_ = _data_->_tmp45_;
			_data_->_tmp43_ = (_data_->offset + _data_->max_count) <= ((guint) _data_->_tmp46_);
		} else {
			_data_->_tmp43_ = FALSE;
		}
		if (_data_->_tmp43_) {
			_data_->stop = _data_->offset + _data_->max_count;
		} else {
			_data_->_tmp47_ = _data_->_result_;
			_data_->_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp47_);
			_data_->_tmp49_ = _data_->_tmp48_;
			_data_->stop = (guint) _data_->_tmp49_;
		}
		_data_->_tmp50_ = _data_->_result_;
		_data_->_tmp51_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp50_, (gint) _data_->offset, (gint) _data_->stop);
		_data_->_tmp52_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp51_, TYPE_MEDIA_OBJECTS) ? ((MediaObjects*) _data_->_tmp51_) : NULL;
		if (_data_->_tmp52_ == NULL) {
			_g_object_unref0 (_data_->_tmp51_);
		}
		_data_->result = _data_->_tmp52_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->children);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_searchable_container_find_object_data_free (gpointer _data)
{
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
}

void
rygel_searchable_container_find_object (RygelSearchableContainer* self,
                                        const gchar* id,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_searchable_container_find_object_co (_data_);
}

MediaObject*
rygel_searchable_container_find_object_finish (RygelSearchableContainer* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	MediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void
rygel_searchable_container_find_object_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_find_object_co (_data_);
}

static gboolean
rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup (SEARCH_CRITERIA_OP_EQ);
	_g_free0 (((SearchExpression*) _data_->expression)->op);
	((SearchExpression*) _data_->expression)->op = _data_->_tmp1_;
	_data_->_tmp2_ = g_strdup ("@id");
	_g_free0 (((SearchExpression*) _data_->expression)->operand1);
	((SearchExpression*) _data_->expression)->operand1 = _data_->_tmp2_;
	_data_->_tmp3_ = g_strdup (_data_->id);
	_g_free0 (((SearchExpression*) _data_->expression)->operand2);
	((SearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
	_data_->_tmp4_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->self, (SearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->cancellable, rygel_searchable_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp4_;
	_data_->results = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->expression);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->results);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_tmp7_ > 0) {
		_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
		_data_->result = (MediaObject*) _data_->_tmp8_;
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->expression);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->expression);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->results);
	_g_object_unref0 (_data_->expression);
}

static void
rygel_searchable_container_search_in_children_data_free (gpointer _data)
{
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->expression);
	_g_object_unref0 (_data_->children);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
}

static void
rygel_searchable_container_search_in_children (RygelSearchableContainer* self,
                                               SearchExpression* expression,
                                               MediaObjects* children,
                                               guint limit,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	SearchExpression* _tmp1_;
	MediaObjects* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (expression);
	_g_object_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_tmp2_ = _g_object_ref0 (children);
	_g_object_unref0 (_data_->children);
	_data_->children = _tmp2_;
	_data_->limit = limit;
	_tmp3_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_searchable_container_search_in_children_co (_data_);
}

static MediaObjects*
rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	MediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_searchable_container_search_in_children_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_search_in_children_co (_data_);
}

static gboolean
rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _g_object_ref0 (_data_->children);
		_data_->_child_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_child_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_child_size = _data_->_tmp4_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_child_index = _data_->_child_index + 1;
			if (!(_data_->_child_index < _data_->_child_size)) {
				break;
			}
			_data_->_tmp5_ = _data_->_child_list;
			_data_->_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp5_, _data_->_child_index);
			_data_->child = (MediaObject*) _data_->_tmp6_;
			_data_->_tmp7_ = _data_->child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp7_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
				_data_->_tmp8_ = _data_->child;
				_data_->_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp8_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp8_) : NULL);
				_data_->container = _data_->_tmp9_;
				_data_->_tmp10_ = _data_->container;
				_data_->_tmp11_ = 0U;
				_data_->_state_ = 1;
				rygel_searchable_container_search (_data_->_tmp10_, _data_->expression, (guint) 0, _data_->limit, _data_->sort_criteria, _data_->cancellable, rygel_searchable_container_search_in_children_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp12_ = rygel_searchable_container_search_finish (_data_->_tmp10_, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error0_);
				_data_->tmp = _data_->_tmp11_;
				_data_->child_result = _data_->_tmp12_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->container);
					_g_object_unref0 (_data_->child);
					_g_object_unref0 (_data_->_child_list);
					_g_object_unref0 (_data_->_result_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp13_ = _data_->_result_;
				_data_->_tmp14_ = _data_->child_result;
				gee_array_list_add_all ((GeeArrayList*) _data_->_tmp13_, (GeeCollection*) _data_->_tmp14_);
				_g_object_unref0 (_data_->child_result);
				_g_object_unref0 (_data_->container);
			}
			if (_data_->limit > ((guint) 0)) {
				_data_->_tmp16_ = _data_->_result_;
				_data_->_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp15_ = ((guint) _data_->_tmp18_) >= _data_->limit;
			} else {
				_data_->_tmp15_ = FALSE;
			}
			if (_data_->_tmp15_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	_data_->result = _data_->_result_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self,
                                                        GUPnPDIDLLiteContainer* didl_container)
{
	g_return_if_fail (didl_container != NULL);
	{
		GeeArrayList* _search_class_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _search_class_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _search_class_index = 0;
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_search_class_list = _tmp2_;
		_tmp3_ = _search_class_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_search_class_size = _tmp5_;
		_search_class_index = -1;
		while (TRUE) {
			gchar* search_class = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			_search_class_index = _search_class_index + 1;
			if (!(_search_class_index < _search_class_size)) {
				break;
			}
			_tmp6_ = _search_class_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _search_class_index);
			search_class = (gchar*) _tmp7_;
			_tmp8_ = search_class;
			gupnp_didl_lite_container_add_search_class (didl_container, _tmp8_);
			_g_free0 (search_class);
		}
		_g_object_unref0 (_search_class_list);
	}
}

GeeArrayList*
rygel_searchable_container_get_search_classes (RygelSearchableContainer* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
}

void
rygel_searchable_container_set_search_classes (RygelSearchableContainer* self,
                                               GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
}

static void
rygel_searchable_container_default_init (RygelSearchableContainerIface * iface,
                                         gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
 * The base class for searchable containers.
 *
 * Classes that implement this interface can, for instance:
 *
 *  # Allow backends to implement a UPnP Search call using native searching (such as SQL or SPARQL queries).
 *  # Implement searching via the naïve default implementation provided by rygel_searchable_container_simple_search(), which does a recursive tree walk.
 *
 * The search_classes property lists what information this container may be searched
 * for. It is mapped to upnp:searchClass (with includeDerived assumed to be false),
 */
GType
rygel_searchable_container_get_type (void)
{
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_searchable_container_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}

