/* rygel-trackable-container.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-trackable-container.vala, do not modify */

/*
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelTrackableContainerClearData RygelTrackableContainerClearData;
typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())
typedef struct _RygelTrackableContainerAddChildTrackedData RygelTrackableContainerAddChildTrackedData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelTrackableContainerRemoveChildTrackedData RygelTrackableContainerRemoveChildTrackedData;
enum  {
	RYGEL_TRACKABLE_CONTAINER_CHILD_ADDED_SIGNAL,
	RYGEL_TRACKABLE_CONTAINER_CHILD_REMOVED_SIGNAL,
	RYGEL_TRACKABLE_CONTAINER_NUM_SIGNALS
};
static guint rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_NUM_SIGNALS] = {0};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

struct _RygelTrackableContainerClearData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObjects* children;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp4_;
	RygelMediaObjects* _tmp5_;
	gint _child_size;
	RygelMediaObjects* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _child_index;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp9_;
	gpointer _tmp10_;
	RygelMediaObject* _tmp11_;
	GError* _error_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _RygelTrackableContainerAddChildTrackedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObject* object;
	RygelTrackableContainer* trackable;
	RygelTrackableContainer* _tmp0_;
	RygelTrackableContainer* _tmp1_;
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackableContainerRemoveChildTrackedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObject* object;
	RygelTrackableContainer* trackable;
	RygelTrackableContainer* _tmp0_;
	RygelTrackableContainer* _tmp1_;
	gint64 _tmp2_;
};

GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaContainer, g_object_unref)
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
static void rygel_trackable_container_clear_data_free (gpointer _data);
void rygel_trackable_container_clear (RygelTrackableContainer* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void rygel_trackable_container_clear_finish (RygelTrackableContainer* self,
                                             GAsyncResult* _res_);
static gboolean rygel_trackable_container_clear_co (RygelTrackableContainerClearData* _data_);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObjects, g_object_unref)
void rygel_media_container_get_children (RygelMediaContainer* self,
                                         guint offset,
                                         guint max_count,
                                         const gchar* sort_criteria,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
static void rygel_trackable_container_clear_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
void rygel_trackable_container_remove_child_tracked (RygelTrackableContainer* self,
                                                     RygelMediaObject* object,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
void rygel_trackable_container_remove_child_tracked_finish (RygelTrackableContainer* self,
                                                            GAsyncResult* _res_);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_trackable_container_add_child (RygelTrackableContainer* self,
                                          RygelMediaObject* object,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
void rygel_trackable_container_add_child_finish (RygelTrackableContainer* self,
                                                 GAsyncResult* _res_);
static void rygel_trackable_container_add_child_tracked_data_free (gpointer _data);
void rygel_trackable_container_add_child_tracked (RygelTrackableContainer* self,
                                                  RygelMediaObject* object,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
void rygel_trackable_container_add_child_tracked_finish (RygelTrackableContainer* self,
                                                         GAsyncResult* _res_);
static gboolean rygel_trackable_container_add_child_tracked_co (RygelTrackableContainerAddChildTrackedData* _data_);
static void rygel_trackable_container_add_child_tracked_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
void rygel_media_container_updated (RygelMediaContainer* self,
                                    RygelMediaObject* object,
                                    RygelObjectEventType event_type,
                                    gboolean sub_tree_update);
static void rygel_trackable_container_thaw_events (RygelTrackableContainer* self);
void rygel_trackable_container_remove_child (RygelTrackableContainer* self,
                                             RygelMediaObject* object,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
void rygel_trackable_container_remove_child_finish (RygelTrackableContainer* self,
                                                    GAsyncResult* _res_);
static void rygel_trackable_container_remove_child_tracked_data_free (gpointer _data);
static gboolean rygel_trackable_container_remove_child_tracked_co (RygelTrackableContainerRemoveChildTrackedData* _data_);
static void rygel_trackable_container_remove_child_tracked_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSerializer, g_object_unref)
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_http_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPRequest, g_object_unref)
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaResource, g_object_unref)
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPSeekRequest, g_object_unref)
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlaySpeedRequest, g_object_unref)
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPResponseElement, g_object_unref)
GType rygel_data_source_get_type (void) G_GNUC_CONST;
gchar* rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self);
static gchar* rygel_trackable_container_real_get_service_reset_token (RygelTrackableContainer* self);
void rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self,
                                                        const gchar* token);
static void rygel_trackable_container_real_set_service_reset_token (RygelTrackableContainer* self,
                                                             const gchar* token);
guint32 rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self);
static guint32 rygel_trackable_container_real_get_system_update_id (RygelTrackableContainer* self);

static void
rygel_trackable_container_clear_data_free (gpointer _data)
{
	RygelTrackableContainerClearData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackableContainerClearData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
rygel_trackable_container_clear (RygelTrackableContainer* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelTrackableContainerClearData* _data_;
	RygelTrackableContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelTrackableContainerClearData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_trackable_container_clear_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_trackable_container_clear_co (_data_);
}

void
rygel_trackable_container_clear_finish (RygelTrackableContainer* self,
                                        GAsyncResult* _res_)
{
	RygelTrackableContainerClearData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_trackable_container_clear_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	RygelTrackableContainerClearData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_trackable_container_clear_co (_data_);
}

static gboolean
rygel_trackable_container_clear_co (RygelTrackableContainerClearData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_state_ = 1;
		rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) -1, _data_->_tmp1_, NULL, rygel_trackable_container_clear_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->children = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch21_g_error;
		}
		_data_->_tmp3_ = _data_->children;
		if (_data_->_tmp3_ == NULL) {
			_g_object_unref0 (_data_->children);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp4_ = _data_->children;
			_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
			_data_->_child_list = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->_child_list;
			_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_child_size = _data_->_tmp8_;
			_data_->_child_index = -1;
			while (TRUE) {
				_data_->_child_index = _data_->_child_index + 1;
				if (!(_data_->_child_index < _data_->_child_size)) {
					break;
				}
				_data_->_tmp9_ = _data_->_child_list;
				_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_child_index);
				_data_->child = (RygelMediaObject*) _data_->_tmp10_;
				_data_->_tmp11_ = _data_->child;
				_data_->_state_ = 2;
				rygel_trackable_container_remove_child_tracked (_data_->self, _data_->_tmp11_, rygel_trackable_container_clear_ready, _data_);
				return FALSE;
				_state_2:
				rygel_trackable_container_remove_child_tracked_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->child);
			}
			_g_object_unref0 (_data_->_child_list);
		}
		_g_object_unref0 (_data_->children);
	}
	goto __finally21;
	__catch21_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->_error_;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("rygel-trackable-container.vala:49: Failed to clear trackable container" \
" %s: %s", _data_->_tmp13_, _data_->_tmp15_);
		_g_error_free0 (_data_->_error_);
	}
	__finally21:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_trackable_container_add_child (RygelTrackableContainer* self,
                                     RygelMediaObject* object,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->add_child (self, object, _callback_, _user_data_);
}

void
rygel_trackable_container_add_child_finish (RygelTrackableContainer* self,
                                            GAsyncResult* _res_)
{
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->add_child_finish (self, _res_);
}

static void
rygel_trackable_container_add_child_tracked_data_free (gpointer _data)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackableContainerAddChildTrackedData, _data_);
}

void
rygel_trackable_container_add_child_tracked (RygelTrackableContainer* self,
                                             RygelMediaObject* object,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	RygelTrackableContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	_data_ = g_slice_new0 (RygelTrackableContainerAddChildTrackedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_trackable_container_add_child_tracked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_trackable_container_add_child_tracked_co (_data_);
}

void
rygel_trackable_container_add_child_tracked_finish (RygelTrackableContainer* self,
                                                    GAsyncResult* _res_)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Add a child object, emitting the #RygelContainer::container_updated signal
     * with the object.
     * @see rygel_trackable_object_remove_child_tracked()
     *
     * @param object The child item or child container to be added.
     */
static void
rygel_trackable_container_add_child_tracked_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_trackable_container_add_child_tracked_co (_data_);
}

static gboolean
rygel_trackable_container_add_child_tracked_co (RygelTrackableContainerAddChildTrackedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_trackable_container_add_child (_data_->self, _data_->object, rygel_trackable_container_add_child_tracked_ready, _data_);
	return FALSE;
	_state_1:
	rygel_trackable_container_add_child_finish (_data_->self, _data_->_res_);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, _data_->object, RYGEL_OBJECT_EVENT_TYPE_ADDED, FALSE);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->object, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		_data_->_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->object, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->object) : NULL);
		_data_->trackable = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->trackable;
		rygel_trackable_container_thaw_events (_data_->_tmp1_);
		_g_object_unref0 (_data_->trackable);
	}
	g_signal_emit (_data_->self, rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_ADDED_SIGNAL], 0, _data_->object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_trackable_container_remove_child (RygelTrackableContainer* self,
                                        RygelMediaObject* object,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->remove_child (self, object, _callback_, _user_data_);
}

void
rygel_trackable_container_remove_child_finish (RygelTrackableContainer* self,
                                               GAsyncResult* _res_)
{
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->remove_child_finish (self, _res_);
}

static void
rygel_trackable_container_remove_child_tracked_data_free (gpointer _data)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackableContainerRemoveChildTrackedData, _data_);
}

void
rygel_trackable_container_remove_child_tracked (RygelTrackableContainer* self,
                                                RygelMediaObject* object,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	RygelTrackableContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	_data_ = g_slice_new0 (RygelTrackableContainerRemoveChildTrackedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_trackable_container_remove_child_tracked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_trackable_container_remove_child_tracked_co (_data_);
}

void
rygel_trackable_container_remove_child_tracked_finish (RygelTrackableContainer* self,
                                                       GAsyncResult* _res_)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Add a child object, emitting the #RygelContainer::container_updated signal
     * with the object.
     * @see rygel_trackable_object_add_child_tracked()
     *
     * @param object The child item or child container to be added.
     */
static void
rygel_trackable_container_remove_child_tracked_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_trackable_container_remove_child_tracked_co (_data_);
}

static gboolean
rygel_trackable_container_remove_child_tracked_co (RygelTrackableContainerRemoveChildTrackedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->object, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		_data_->_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->object, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->object) : NULL);
		_data_->trackable = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->trackable;
		_data_->_state_ = 1;
		rygel_trackable_container_clear (_data_->_tmp1_, rygel_trackable_container_remove_child_tracked_ready, _data_);
		return FALSE;
		_state_1:
		rygel_trackable_container_clear_finish (_data_->_tmp1_, _data_->_res_);
		_g_object_unref0 (_data_->trackable);
	}
	_data_->_state_ = 2;
	rygel_trackable_container_remove_child (_data_->self, _data_->object, rygel_trackable_container_remove_child_tracked_ready, _data_);
	return FALSE;
	_state_2:
	rygel_trackable_container_remove_child_finish (_data_->self, _data_->_res_);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, _data_->object, RYGEL_OBJECT_EVENT_TYPE_DELETED, FALSE);
	_data_->_tmp2_ = ((RygelMediaContainer*) _data_->self)->total_deleted_child_count;
	((RygelMediaContainer*) _data_->self)->total_deleted_child_count = _data_->_tmp2_ + 1;
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	g_signal_emit (_data_->self, rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_REMOVED_SIGNAL], 0, _data_->object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Used to query the (persisted) service reset token from the plug-in.
     *
     * If a plugin implements PLUGIN_CAPABILITIES_TRACK_CHANGES, it should
     * persist the ServiceResetToken. To do this override this virtual
     * function in the root container implementation and provide the persisted
     * version.
     */
static gchar*
rygel_trackable_container_real_get_service_reset_token (RygelTrackableContainer* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = gupnp_get_uuid ();
	result = _tmp0_;
	return result;
}

gchar*
rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->get_service_reset_token (self);
}

/**
     * Set a new service reset token.
     *
     * If the service reset procedure has to be performed, the content
     * directory service will set the new service reset token.
     *
     * @param token the new service reset token.
     */
static void
rygel_trackable_container_real_set_service_reset_token (RygelTrackableContainer* self,
                                                        const gchar* token)
{
	g_return_if_fail (token != NULL);
}

void
rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self,
                                                   const gchar* token)
{
	g_return_if_fail (self != NULL);
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->set_service_reset_token (self, token);
}

/**
     * Query the current system update ID,
     * used for the UPnP GetSystemUpdateID implementation.
     *
     * This should be overriden by the root container of the back-end
     * implementation. This will only be called once, at service startup, 
     * to discover the cached system Update ID, if any, that was known
     * when the service last shut down.
     *
     * Derived classes may need to delay part of their initialization
     * until this function has been called, doing that initialization in
     * the function override. That can prevent other parts of their 
     * implementation from changing the cached System Update ID before
     * it has been provided.
     *
     * @return the current SystemUpdateID as persisted by the back-end.
     */
static guint32
rygel_trackable_container_real_get_system_update_id (RygelTrackableContainer* self)
{
	guint32 result = 0U;
	result = (guint32) 0;
	return result;
}

guint32
rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self)
{
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->get_system_update_id (self);
}

static void
rygel_trackable_container_thaw_events (RygelTrackableContainer* self)
{
}

static void
rygel_trackable_container_default_init (RygelTrackableContainerIface * iface,
                                        gpointer iface_data)
{
	rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_ADDED_SIGNAL] = g_signal_new ("child-added", RYGEL_TYPE_TRACKABLE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
	rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_REMOVED_SIGNAL] = g_signal_new ("child-removed", RYGEL_TYPE_TRACKABLE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
	iface->get_service_reset_token = rygel_trackable_container_real_get_service_reset_token;
	iface->set_service_reset_token = rygel_trackable_container_real_set_service_reset_token;
	iface->get_system_update_id = rygel_trackable_container_real_get_system_update_id;
}

/**
 * The base class for containers that provide automatic change tracking.
 *
 * Derived classes should implement the add_child() and remove_child()
 * virtual functions to keep track of child items and child containers.
 *
 * Rygel server plugins (See #RygelMediaServer) may then call
 * rygel_trackable_container_add_child_tracked() and
 * rygel_trackable_container_remove_child_tracked() to add and remove
 * items, which will then cause the #RygelContainer::container_updated signal
 * to be emitted.
 */
GType
rygel_trackable_container_get_type (void)
{
	static volatile gsize rygel_trackable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_trackable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackableContainerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_trackable_container_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_trackable_container_type_id;
		rygel_trackable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_trackable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_trackable_container_type_id__volatile, rygel_trackable_container_type_id);
	}
	return rygel_trackable_container_type_id__volatile;
}

