/* rygel-search.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-search.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <rygel-core.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;
typedef struct _RygelSearchPrivate RygelSearchPrivate;
enum  {
	RYGEL_SEARCH_0_PROPERTY,
	RYGEL_SEARCH_NUM_PROPERTIES
};
static GParamSpec* rygel_search_properties[RYGEL_SEARCH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
typedef struct _RygelSearchFetchResultsData RygelSearchFetchResultsData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelSearch {
	RygelMediaQueryAction parent_instance;
	RygelSearchPrivate * priv;
	gchar* search_criteria;
};

struct _RygelSearchClass {
	RygelMediaQueryActionClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchFetchResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearch* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelSearchableContainer* container;
	RygelSearchableContainer* _tmp1_;
	RygelSearchCriteriaParser* parser;
	const gchar* _tmp2_;
	RygelSearchCriteriaParser* _tmp3_;
	RygelSearchCriteriaParser* _tmp4_;
	RygelSearchCriteriaParser* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelSearchableContainer* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* sort_criteria;
	gchar* _tmp13_;
	RygelClientHacks* _tmp14_;
	RygelMediaObjects* _tmp15_;
	RygelClientHacks* _tmp16_;
	RygelSearchableContainer* _tmp17_;
	RygelSearchCriteriaParser* _tmp18_;
	RygelSearchExpression* _tmp19_;
	const gchar* _tmp20_;
	GCancellable* _tmp21_;
	GCancellable* _tmp22_;
	guint _tmp23_;
	RygelMediaObjects* _tmp24_;
	RygelMediaObjects* _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelSearchableContainer* _tmp27_;
	RygelSearchCriteriaParser* _tmp28_;
	RygelSearchExpression* _tmp29_;
	const gchar* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	guint _tmp33_;
	RygelMediaObjects* _tmp34_;
	RygelMediaObjects* _tmp35_;
	GError* _inner_error0_;
};

static gpointer rygel_search_parent_class = NULL;

GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaQueryAction, g_object_unref)
GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObjects, g_object_unref)
GType rygel_media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaContainer, g_object_unref)
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_serializer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSerializer, g_object_unref)
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelClientHacks, g_object_unref)
GType rygel_search_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSearch, g_object_unref)
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelContentDirectory, g_object_unref)
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir,
                               GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type,
                                     RygelContentDirectory* content_dir,
                                     GUPnPServiceAction* action);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type,
                                                           RygelContentDirectory* content_dir,
                                                           GUPnPServiceAction* action);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_search_real_parse_args (RygelMediaQueryAction* base,
                                   GError** error);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self,
                                          GError** error);
GQuark rygel_content_directory_error_quark (void);
static void rygel_search_real_fetch_results_data_free (gpointer _data);
static void rygel_search_real_fetch_results (RygelMediaQueryAction* base,
                                      RygelMediaObject* media_object,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean rygel_search_real_fetch_results_co (RygelSearchFetchResultsData* _data_);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void rygel_value_set_search_expression (GValue* value,
                                        gpointer v_object);
void rygel_value_take_search_expression (GValue* value,
                                         gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSearchExpression, rygel_search_expression_unref)
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSearchCriteriaParser, g_object_unref)
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str,
                                                             GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type,
                                                                   const gchar* str,
                                                                   GError** error);
static void rygel_search_fetch_results_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
void rygel_client_hacks_search (RygelClientHacks* self,
                                RygelSearchableContainer* container,
                                RygelSearchExpression* expression,
                                guint offset,
                                guint max_count,
                                const gchar* sort_criteria,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
RygelMediaObjects* rygel_client_hacks_search_finish (RygelClientHacks* self,
                                                     GAsyncResult* _res_,
                                                     guint* total_matches,
                                                     GError** error);
void rygel_searchable_container_search (RygelSearchableContainer* self,
                                        RygelSearchExpression* expression,
                                        guint offset,
                                        guint max_count,
                                        const gchar* sort_criteria,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self,
                                                             GAsyncResult* _res_,
                                                             guint* total_matches,
                                                             GError** error);
static void rygel_search_real_handle_error (RygelMediaQueryAction* base,
                                     GError* _error_);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self,
                                            GError* _error_);
static void rygel_search_finalize (GObject * obj);

static GUPnPServiceAction*
_vala_GUPnPServiceAction_copy (GUPnPServiceAction* self)
{
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}

static gpointer
__vala_GUPnPServiceAction_copy0 (gpointer self)
{
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

RygelSearch*
rygel_search_construct (GType object_type,
                        RygelContentDirectory* content_dir,
                        GUPnPServiceAction* action)
{
	RygelSearch * self = NULL;
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	_tmp0_ = __vala_GUPnPServiceAction_copy0 (action);
	self = (RygelSearch*) rygel_media_query_action_construct (object_type, content_dir, _tmp0_);
	_tmp1_ = g_strdup ("ContainerID");
	_g_free0 (((RygelMediaQueryAction*) self)->object_id_arg);
	((RygelMediaQueryAction*) self)->object_id_arg = _tmp1_;
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

RygelSearch*
rygel_search_new (RygelContentDirectory* content_dir,
                  GUPnPServiceAction* action)
{
	return rygel_search_construct (RYGEL_TYPE_SEARCH, content_dir, action);
}

static void
rygel_search_real_parse_args (RygelMediaQueryAction* base,
                              GError** error)
{
	RygelSearch * self;
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (RygelSearch*) base;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_search_parent_class)->parse_args (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = ((RygelMediaQueryAction*) self)->action;
	gupnp_service_action_get (_tmp0_, "SearchCriteria", G_TYPE_STRING, &_tmp1_, NULL);
	_g_free0 (self->search_criteria);
	self->search_criteria = _tmp1_;
	_tmp2_ = self->search_criteria;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "No search criteria given");
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = self->search_criteria;
	g_debug ("rygel-search.vala:54: Executing search request: %s", _tmp4_);
}

static void
rygel_search_real_fetch_results_data_free (gpointer _data)
{
	RygelSearchFetchResultsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchFetchResultsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_search_real_fetch_results (RygelMediaQueryAction* base,
                                 RygelMediaObject* media_object,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelSearch * self;
	RygelSearchFetchResultsData* _data_;
	RygelSearch* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = (RygelSearch*) base;
	_data_ = g_slice_new0 (RygelSearchFetchResultsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_search_real_fetch_results_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (media_object);
	_g_object_unref0 (_data_->media_object);
	_data_->media_object = _tmp1_;
	rygel_search_real_fetch_results_co (_data_);
}

static RygelMediaObjects*
rygel_search_real_fetch_results_finish (RygelMediaQueryAction* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	RygelMediaObjects* result;
	RygelSearchFetchResultsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_search_fetch_results_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	RygelSearchFetchResultsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_search_real_fetch_results_co (_data_);
}

static gboolean
rygel_search_real_fetch_results_co (RygelSearchFetchResultsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->media_object, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
		_data_->_tmp0_ = rygel_media_objects_new ();
		_data_->result = _data_->_tmp0_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->media_object, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->media_object) : NULL);
	_data_->container = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->search_criteria;
	_data_->_tmp3_ = rygel_search_criteria_parser_new (_data_->_tmp2_, &_data_->_inner_error0_);
	_data_->parser = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->container);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->parser;
	_data_->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp4_, rygel_search_fetch_results_ready, _data_);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp4_, _data_->_res_);
	_data_->_tmp5_ = _data_->parser;
	_data_->_tmp6_ = _data_->_tmp5_->err;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA, _ ("Invalid search criteria given"));
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->container);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
	_data_->_tmp8_ = _data_->_tmp9_;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp10_ = _data_->container;
		_data_->_tmp11_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp8_ = _data_->_tmp12_;
	}
	_data_->_tmp13_ = g_strdup (_data_->_tmp8_);
	_data_->sort_criteria = _data_->_tmp13_;
	_data_->_tmp14_ = ((RygelMediaQueryAction*) _data_->self)->hacks;
	if (_data_->_tmp14_ != NULL) {
		_data_->_tmp16_ = ((RygelMediaQueryAction*) _data_->self)->hacks;
		_data_->_tmp17_ = _data_->container;
		_data_->_tmp18_ = _data_->parser;
		_data_->_tmp19_ = _data_->_tmp18_->expression;
		_data_->_tmp20_ = _data_->sort_criteria;
		_data_->_tmp21_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = 0U;
		_data_->_state_ = 2;
		rygel_client_hacks_search (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_, ((RygelMediaQueryAction*) _data_->self)->index, ((RygelMediaQueryAction*) _data_->self)->requested_count, _data_->_tmp20_, _data_->_tmp22_, rygel_search_fetch_results_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp24_ = rygel_client_hacks_search_finish (_data_->_tmp16_, _data_->_res_, &_data_->_tmp23_, &_data_->_inner_error0_);
		((RygelMediaQueryAction*) _data_->self)->total_matches = _data_->_tmp23_;
		_data_->_tmp15_ = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->sort_criteria);
			_g_object_unref0 (_data_->parser);
			_g_object_unref0 (_data_->container);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp25_ = _data_->_tmp15_;
		_data_->_tmp15_ = NULL;
		_data_->result = _data_->_tmp25_;
		_g_object_unref0 (_data_->_tmp15_);
		_g_free0 (_data_->sort_criteria);
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->container);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp27_ = _data_->container;
		_data_->_tmp28_ = _data_->parser;
		_data_->_tmp29_ = _data_->_tmp28_->expression;
		_data_->_tmp30_ = _data_->sort_criteria;
		_data_->_tmp31_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = 0U;
		_data_->_state_ = 3;
		rygel_searchable_container_search (_data_->_tmp27_, _data_->_tmp29_, ((RygelMediaQueryAction*) _data_->self)->index, ((RygelMediaQueryAction*) _data_->self)->requested_count, _data_->_tmp30_, _data_->_tmp32_, rygel_search_fetch_results_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp34_ = rygel_searchable_container_search_finish (_data_->_tmp27_, _data_->_res_, &_data_->_tmp33_, &_data_->_inner_error0_);
		((RygelMediaQueryAction*) _data_->self)->total_matches = _data_->_tmp33_;
		_data_->_tmp26_ = _data_->_tmp34_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->sort_criteria);
			_g_object_unref0 (_data_->parser);
			_g_object_unref0 (_data_->container);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp35_ = _data_->_tmp26_;
		_data_->_tmp26_ = NULL;
		_data_->result = _data_->_tmp35_;
		_g_object_unref0 (_data_->_tmp26_);
		_g_free0 (_data_->sort_criteria);
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->container);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->parser);
	_g_object_unref0 (_data_->container);
}

static void
rygel_search_real_handle_error (RygelMediaQueryAction* base,
                                GError* _error_)
{
	RygelSearch * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelSearch*) base;
	_tmp0_ = ((RygelMediaQueryAction*) self)->object_id;
	_tmp1_ = _error_->message;
	g_warning (_ ("Failed to search in “%s”: %s"), _tmp0_, _tmp1_);
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_search_parent_class)->handle_error (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), _error_);
}

static void
rygel_search_class_init (RygelSearchClass * klass,
                         gpointer klass_data)
{
	rygel_search_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaQueryActionClass *) klass)->parse_args = (void (*) (RygelMediaQueryAction*, GError**)) rygel_search_real_parse_args;
	((RygelMediaQueryActionClass *) klass)->fetch_results = (void (*) (RygelMediaQueryAction*, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_search_real_fetch_results;
	((RygelMediaQueryActionClass *) klass)->fetch_results_finish = (RygelMediaObjects* (*) (RygelMediaQueryAction*, GAsyncResult*, GError**)) rygel_search_real_fetch_results_finish;
	((RygelMediaQueryActionClass *) klass)->handle_error = (void (*) (RygelMediaQueryAction*, GError*)) rygel_search_real_handle_error;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_finalize;
}

static void
rygel_search_instance_init (RygelSearch * self,
                            gpointer klass)
{
}

static void
rygel_search_finalize (GObject * obj)
{
	RygelSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SEARCH, RygelSearch);
	_g_free0 (self->search_criteria);
	G_OBJECT_CLASS (rygel_search_parent_class)->finalize (obj);
}

/**
 * Search action implementation.
 */
GType
rygel_search_get_type (void)
{
	static volatile gsize rygel_search_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearch), 0, (GInstanceInitFunc) rygel_search_instance_init, NULL };
		GType rygel_search_type_id;
		rygel_search_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_QUERY_ACTION, "RygelSearch", &g_define_type_info, 0);
		g_once_init_leave (&rygel_search_type_id__volatile, rygel_search_type_id);
	}
	return rygel_search_type_id__volatile;
}

