/* valaelementaccess.c generated by valac, the Vala compiler
 * generated from valaelementaccess.vala, do not modify */

/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaElementAccessPrivate {
	ValaList* indices;
	ValaExpression* _container;
};

static gint ValaElementAccess_private_offset;
static gpointer vala_element_access_parent_class = NULL;

static void vala_element_access_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gchar* vala_element_access_real_to_string (ValaCodeNode* base);
static void vala_element_access_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gboolean vala_element_access_real_is_accessible (ValaExpression* base,
                                                 ValaSymbol* sym);
static void vala_element_access_real_get_error_types (ValaCodeNode* base,
                                               ValaCollection* collection,
                                               ValaSourceReference* source_reference);
static gboolean vala_element_access_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_element_access_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_element_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_element_access_get_instance_private (ValaElementAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaElementAccess_private_offset);
}

void
vala_element_access_append_index (ValaElementAccess* self,
                                  ValaExpression* index)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->indices;
	vala_collection_add ((ValaCollection*) _tmp0_, index);
	vala_code_node_set_parent_node ((ValaCodeNode*) index, (ValaCodeNode*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_element_access_get_indices (ValaElementAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indices;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaElementAccess*
vala_element_access_construct (GType object_type,
                               ValaExpression* container,
                               ValaSourceReference* source_reference)
{
	ValaElementAccess* self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaElementAccess*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_element_access_set_container (self, container);
	return self;
}

ValaElementAccess*
vala_element_access_new (ValaExpression* container,
                         ValaSourceReference* source_reference)
{
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}

static void
vala_element_access_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_element_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_element_access_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}

static gchar*
vala_element_access_real_to_string (ValaCodeNode* base)
{
	ValaElementAccess * self;
	gchar* result = NULL;
	gchar* s = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	self = (ValaElementAccess*) base;
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s[", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	s = _tmp5_;
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _index_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _index_index = 0;
		_tmp6_ = self->priv->indices;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_index_list = _tmp7_;
		_tmp8_ = _index_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_index_size = _tmp10_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp11_ = _index_list;
			_tmp12_ = vala_list_get (_tmp11_, _index_index);
			index = (ValaExpression*) _tmp12_;
			if (first) {
				const gchar* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp13_ = s;
				_tmp14_ = index;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
				_g_free0 (s);
				s = _tmp17_;
				_g_free0 (_tmp16_);
				first = FALSE;
			} else {
				const gchar* _tmp18_;
				ValaExpression* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp18_ = s;
				_tmp19_ = index;
				_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf (", %s", _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp18_, _tmp23_, NULL);
				_g_free0 (s);
				s = _tmp24_;
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp25_ = s;
	_tmp26_ = g_strconcat (_tmp25_, "]", NULL);
	result = _tmp26_;
	_g_free0 (s);
	return result;
}

static void
vala_element_access_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_element_access_set_container (self, new_node);
	}
	_tmp2_ = self->priv->indices;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->indices;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_element_access_real_is_pure (ValaExpression* base)
{
	ValaElementAccess * self;
	gboolean result = FALSE;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	self = (ValaElementAccess*) base;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp5_ = _index_list;
			_tmp6_ = vala_list_get (_tmp5_, _index_index);
			index = (ValaExpression*) _tmp6_;
			_tmp7_ = index;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp8_ = vala_element_access_get_container (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_pure (_tmp9_);
	return result;
}

static gboolean
vala_element_access_real_is_accessible (ValaExpression* base,
                                        ValaSymbol* sym)
{
	ValaElementAccess * self;
	gboolean result = FALSE;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp5_ = _index_list;
			_tmp6_ = vala_list_get (_tmp5_, _index_index);
			index = (ValaExpression*) _tmp6_;
			_tmp7_ = index;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp8_ = vala_element_access_get_container (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_element_access_real_get_error_types (ValaCodeNode* base,
                                          ValaCollection* collection,
                                          ValaSourceReference* source_reference)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp9_, collection, source_reference);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_element_access_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaElementAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp14_ = FALSE;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	gboolean index_int_type_check = FALSE;
	ValaPointerType* pointer_type = NULL;
	ValaExpression* _tmp59_;
	ValaExpression* _tmp60_;
	ValaDataType* _tmp61_;
	ValaDataType* _tmp62_;
	ValaPointerType* _tmp63_;
	ValaExpression* _tmp64_;
	ValaExpression* _tmp65_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	gboolean _tmp277_;
	gboolean _tmp278_;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_element_access_get_container (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_element_access_get_container (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp10_ = vala_element_access_get_container (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "Invalid container expression");
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_element_access_get_container (self);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp17_ = vala_element_access_get_container (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_SIGNAL);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gboolean _tmp25_;
		ValaExpression* detail_expr = NULL;
		ValaList* _tmp28_;
		ValaList* _tmp29_;
		gpointer _tmp30_;
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaSemanticAnalyzer* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		ValaExpression* _tmp38_;
		gboolean _tmp39_ = FALSE;
		ValaExpression* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		_tmp21_ = vala_element_access_get_indices (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_ != 1;
		_vala_iterable_unref0 (_tmp22_);
		if (_tmp25_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Element access with more than one dimension is not supported for signa" \
"ls");
			result = FALSE;
			return result;
		}
		_tmp28_ = vala_element_access_get_indices (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_list_get (_tmp29_, 0);
		_tmp31_ = (ValaExpression*) _tmp30_;
		_vala_iterable_unref0 (_tmp29_);
		detail_expr = _tmp31_;
		_tmp32_ = detail_expr;
		_tmp33_ = vala_code_context_get_analyzer (context);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_->string_type;
		_tmp36_ = vala_data_type_copy (_tmp35_);
		_tmp37_ = _tmp36_;
		vala_expression_set_target_type (_tmp32_, _tmp37_);
		_vala_code_node_unref0 (_tmp37_);
		_tmp38_ = detail_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp38_, context);
		_tmp40_ = detail_expr;
		_tmp41_ = vala_expression_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_NULL_TYPE)) {
			_tmp39_ = TRUE;
		} else {
			ValaExpression* _tmp43_;
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaSemanticAnalyzer* _tmp47_;
			ValaDataType* _tmp48_;
			_tmp43_ = detail_expr;
			_tmp44_ = vala_expression_get_value_type (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_code_context_get_analyzer (context);
			_tmp47_ = _tmp46_;
			_tmp48_ = _tmp47_->string_type;
			_tmp39_ = !vala_data_type_compatible (_tmp45_, _tmp48_);
		}
		if (_tmp39_) {
			ValaExpression* _tmp49_;
			ValaSourceReference* _tmp50_;
			ValaSourceReference* _tmp51_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp49_ = detail_expr;
			_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp49_);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp51_, "only string details are supported");
			result = FALSE;
			_vala_code_node_unref0 (detail_expr);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
	}
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp52_;
		gint _index_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _index_index = 0;
		_tmp52_ = vala_element_access_get_indices (self);
		_index_list = _tmp52_;
		_tmp53_ = _index_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_index_size = _tmp55_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp56_;
			gpointer _tmp57_;
			ValaExpression* _tmp58_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp56_ = _index_list;
			_tmp57_ = vala_list_get (_tmp56_, _index_index);
			index = (ValaExpression*) _tmp57_;
			_tmp58_ = index;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, context);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	index_int_type_check = TRUE;
	_tmp59_ = vala_element_access_get_container (self);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_expression_get_value_type (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp62_) : NULL);
	pointer_type = _tmp63_;
	_tmp64_ = vala_element_access_get_container (self);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_expression_get_value_type (_tmp65_);
	_tmp67_ = _tmp66_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaArrayType* _tmp72_;
		ValaArrayType* _tmp73_;
		ValaDataType* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		gboolean _tmp78_;
		gboolean _tmp79_;
		ValaArrayType* _tmp130_;
		gint _tmp131_;
		gint _tmp132_;
		ValaList* _tmp133_;
		ValaList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gboolean _tmp137_;
		_tmp68_ = vala_element_access_get_container (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_expression_get_value_type (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp72_;
		_tmp73_ = array_type;
		_tmp74_ = vala_array_type_get_element_type (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_data_type_copy (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp77_);
		_vala_code_node_unref0 (_tmp77_);
		_tmp78_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp79_ = _tmp78_;
		if (!_tmp79_) {
			ValaDataType* _tmp80_;
			ValaDataType* _tmp81_;
			_tmp80_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp81_ = _tmp80_;
			vala_data_type_set_value_owned (_tmp81_, FALSE);
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp82_;
			ValaExpression* _tmp83_;
			ValaMemberAccess* _tmp84_;
			gboolean _tmp85_ = FALSE;
			gboolean _tmp86_ = FALSE;
			ValaProfile _tmp87_;
			ValaProfile _tmp88_;
			_tmp82_ = vala_element_access_get_container (self);
			_tmp83_ = _tmp82_;
			_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp83_) : NULL);
			ma = _tmp84_;
			_tmp87_ = vala_code_context_get_profile (context);
			_tmp88_ = _tmp87_;
			if (_tmp88_ == VALA_PROFILE_GOBJECT) {
				ValaMemberAccess* _tmp89_;
				_tmp89_ = ma;
				_tmp86_ = _tmp89_ != NULL;
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				ValaMemberAccess* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				_tmp90_ = ma;
				_tmp91_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp90_);
				_tmp92_ = _tmp91_;
				_tmp85_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_ARRAY_LENGTH_FIELD);
			} else {
				_tmp85_ = FALSE;
			}
			if (_tmp85_) {
				ValaMemberAccess* _tmp93_;
				ValaExpression* _tmp94_;
				ValaExpression* _tmp95_;
				ValaMemberAccess* _tmp96_;
				ValaExpression* _tmp97_;
				ValaExpression* _tmp98_;
				_tmp93_ = ma;
				_tmp94_ = vala_member_access_get_inner (_tmp93_);
				_tmp95_ = _tmp94_;
				vala_expression_set_lvalue (_tmp95_, TRUE);
				_tmp96_ = ma;
				_tmp97_ = vala_member_access_get_inner (_tmp96_);
				_tmp98_ = _tmp97_;
				vala_member_access_check_lvalue_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			} else {
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
				gboolean _tmp103_ = FALSE;
				ValaMemberAccess* _tmp104_;
				_tmp104_ = ma;
				if (_tmp104_ != NULL) {
					ValaMemberAccess* _tmp105_;
					ValaSymbol* _tmp106_;
					ValaSymbol* _tmp107_;
					_tmp105_ = ma;
					_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_FIELD);
				} else {
					_tmp103_ = FALSE;
				}
				if (_tmp103_) {
					ValaMemberAccess* _tmp108_;
					ValaExpression* _tmp109_;
					ValaExpression* _tmp110_;
					_tmp108_ = ma;
					_tmp109_ = vala_member_access_get_inner (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp102_ = _tmp110_ != NULL;
				} else {
					_tmp102_ = FALSE;
				}
				if (_tmp102_) {
					ValaMemberAccess* _tmp111_;
					ValaExpression* _tmp112_;
					ValaExpression* _tmp113_;
					ValaSymbol* _tmp114_;
					ValaSymbol* _tmp115_;
					_tmp111_ = ma;
					_tmp112_ = vala_member_access_get_inner (_tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_expression_get_symbol_reference (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp101_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_VARIABLE);
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaMemberAccess* _tmp116_;
					ValaExpression* _tmp117_;
					ValaExpression* _tmp118_;
					ValaDataType* _tmp119_;
					ValaDataType* _tmp120_;
					_tmp116_ = ma;
					_tmp117_ = vala_member_access_get_inner (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_expression_get_value_type (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp100_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp120_, VALA_TYPE_STRUCT_VALUE_TYPE);
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaMemberAccess* _tmp121_;
					ValaExpression* _tmp122_;
					ValaExpression* _tmp123_;
					ValaDataType* _tmp124_;
					ValaDataType* _tmp125_;
					gboolean _tmp126_;
					gboolean _tmp127_;
					_tmp121_ = ma;
					_tmp122_ = vala_member_access_get_inner (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_expression_get_value_type (_tmp123_);
					_tmp125_ = _tmp124_;
					_tmp126_ = vala_data_type_get_nullable (_tmp125_);
					_tmp127_ = _tmp126_;
					_tmp99_ = !_tmp127_;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaMemberAccess* _tmp128_;
					ValaMemberAccess* _tmp129_;
					_tmp128_ = ma;
					vala_expression_set_lvalue ((ValaExpression*) _tmp128_, TRUE);
					_tmp129_ = ma;
					vala_member_access_check_lvalue_access (_tmp129_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp130_ = array_type;
		_tmp131_ = vala_array_type_get_rank (_tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_element_access_get_indices (self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = _tmp132_ < _tmp136_;
		_vala_iterable_unref0 (_tmp134_);
		if (_tmp137_) {
			ValaSourceReference* _tmp138_;
			ValaSourceReference* _tmp139_;
			ValaList* _tmp140_;
			ValaList* _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaArrayType* _tmp144_;
			gint _tmp145_;
			gint _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_element_access_get_indices (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_collection_get_size ((ValaCollection*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = array_type;
			_tmp145_ = vala_array_type_get_rank (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strdup_printf ("%d extra indices for element access", _tmp143_ - _tmp146_);
			_tmp148_ = _tmp147_;
			vala_report_error (_tmp139_, _tmp148_);
			_g_free0 (_tmp148_);
			_vala_iterable_unref0 (_tmp141_);
		} else {
			ValaArrayType* _tmp149_;
			gint _tmp150_;
			gint _tmp151_;
			ValaList* _tmp152_;
			ValaList* _tmp153_;
			gint _tmp154_;
			gint _tmp155_;
			gboolean _tmp156_;
			_tmp149_ = array_type;
			_tmp150_ = vala_array_type_get_rank (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_element_access_get_indices (self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = _tmp151_ > _tmp155_;
			_vala_iterable_unref0 (_tmp153_);
			if (_tmp156_) {
				ValaSourceReference* _tmp157_;
				ValaSourceReference* _tmp158_;
				ValaArrayType* _tmp159_;
				gint _tmp160_;
				gint _tmp161_;
				ValaList* _tmp162_;
				ValaList* _tmp163_;
				gint _tmp164_;
				gint _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp158_ = _tmp157_;
				_tmp159_ = array_type;
				_tmp160_ = vala_array_type_get_rank (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_element_access_get_indices (self);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = g_strdup_printf ("%d missing indices for element access", _tmp161_ - _tmp165_);
				_tmp167_ = _tmp166_;
				vala_report_error (_tmp158_, _tmp167_);
				_g_free0 (_tmp167_);
				_vala_iterable_unref0 (_tmp163_);
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp168_ = FALSE;
		ValaPointerType* _tmp169_;
		_tmp169_ = pointer_type;
		if (_tmp169_ != NULL) {
			ValaPointerType* _tmp170_;
			ValaDataType* _tmp171_;
			ValaDataType* _tmp172_;
			_tmp170_ = pointer_type;
			_tmp171_ = vala_pointer_type_get_base_type (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp168_ = !vala_data_type_is_reference_type_or_type_parameter (_tmp172_);
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaPointerType* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			ValaDataType* _tmp176_;
			ValaDataType* _tmp177_;
			_tmp173_ = pointer_type;
			_tmp174_ = vala_pointer_type_get_base_type (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp176_ = vala_data_type_copy (_tmp175_);
			_tmp177_ = _tmp176_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp177_);
			_vala_code_node_unref0 (_tmp177_);
		} else {
			gboolean _tmp178_ = FALSE;
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			_tmp179_ = vala_element_access_get_container (self);
			_tmp180_ = _tmp179_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp180_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp181_;
				ValaExpression* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				_tmp181_ = vala_element_access_get_container (self);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_expression_get_symbol_reference (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp178_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp184_, VALA_TYPE_SIGNAL);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaExpression* _tmp185_;
				ValaExpression* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				ValaDataType* _tmp191_;
				ValaDataType* _tmp192_;
				index_int_type_check = FALSE;
				_tmp185_ = vala_element_access_get_container (self);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_expression_get_symbol_reference (_tmp186_);
				_tmp188_ = _tmp187_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp188_);
				_tmp189_ = vala_element_access_get_container (self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_value_type (_tmp190_);
				_tmp192_ = _tmp191_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp192_);
			} else {
				gboolean _tmp193_;
				gboolean _tmp194_;
				ValaSourceReference* _tmp248_;
				ValaSourceReference* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaDataType* _tmp252_;
				ValaDataType* _tmp253_;
				gchar* _tmp254_;
				gchar* _tmp255_;
				gchar* _tmp256_;
				gchar* _tmp257_;
				_tmp193_ = vala_expression_get_lvalue ((ValaExpression*) self);
				_tmp194_ = _tmp193_;
				if (_tmp194_) {
					ValaMethod* set_method = NULL;
					ValaExpression* _tmp195_;
					ValaExpression* _tmp196_;
					ValaDataType* _tmp197_;
					ValaDataType* _tmp198_;
					ValaSymbol* _tmp199_;
					ValaMethod* _tmp200_;
					ValaAssignment* assignment = NULL;
					ValaCodeNode* _tmp201_;
					ValaCodeNode* _tmp202_;
					ValaAssignment* _tmp203_;
					gboolean _tmp204_ = FALSE;
					gboolean _tmp205_ = FALSE;
					ValaMethod* _tmp206_;
					_tmp195_ = vala_element_access_get_container (self);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_expression_get_value_type (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_data_type_get_member (_tmp198_, "set");
					_tmp200_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp199_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp199_) : NULL;
					if (_tmp200_ == NULL) {
						_vala_code_node_unref0 (_tmp199_);
					}
					set_method = _tmp200_;
					_tmp201_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp202_ = _tmp201_;
					_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp202_, VALA_TYPE_ASSIGNMENT) ? ((ValaAssignment*) _tmp202_) : NULL);
					assignment = _tmp203_;
					_tmp206_ = set_method;
					if (_tmp206_ != NULL) {
						ValaMethod* _tmp207_;
						ValaDataType* _tmp208_;
						ValaDataType* _tmp209_;
						_tmp207_ = set_method;
						_tmp208_ = vala_callable_get_return_type ((ValaCallable*) _tmp207_);
						_tmp209_ = _tmp208_;
						_tmp205_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp209_, VALA_TYPE_VOID_TYPE);
					} else {
						_tmp205_ = FALSE;
					}
					if (_tmp205_) {
						ValaAssignment* _tmp210_;
						_tmp210_ = assignment;
						_tmp204_ = _tmp210_ != NULL;
					} else {
						_tmp204_ = FALSE;
					}
					if (_tmp204_) {
						gboolean _tmp211_;
						gboolean _tmp212_;
						_tmp211_ = vala_code_node_get_error ((ValaCodeNode*) self);
						_tmp212_ = _tmp211_;
						result = !_tmp212_;
						_vala_code_node_unref0 (assignment);
						_vala_code_node_unref0 (set_method);
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (set_method);
				} else {
					ValaMethod* get_method = NULL;
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaDataType* _tmp215_;
					ValaDataType* _tmp216_;
					ValaSymbol* _tmp217_;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					_tmp213_ = vala_element_access_get_container (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_value_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_data_type_get_member (_tmp216_, "get");
					_tmp218_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp217_) : NULL;
					if (_tmp218_ == NULL) {
						_vala_code_node_unref0 (_tmp217_);
					}
					get_method = _tmp218_;
					_tmp219_ = get_method;
					if (_tmp219_ != NULL) {
						ValaMethodCall* get_call = NULL;
						ValaExpression* _tmp220_;
						ValaExpression* _tmp221_;
						ValaSourceReference* _tmp222_;
						ValaSourceReference* _tmp223_;
						ValaMemberAccess* _tmp224_;
						ValaMemberAccess* _tmp225_;
						ValaSourceReference* _tmp226_;
						ValaSourceReference* _tmp227_;
						ValaMethodCall* _tmp228_;
						ValaMethodCall* _tmp229_;
						ValaMethodCall* _tmp238_;
						ValaDataType* _tmp239_;
						ValaDataType* _tmp240_;
						ValaMethodCall* _tmp241_;
						ValaDataType* _tmp242_;
						ValaDataType* _tmp243_;
						ValaCodeNode* _tmp244_;
						ValaCodeNode* _tmp245_;
						ValaMethodCall* _tmp246_;
						ValaMethodCall* _tmp247_;
						_tmp220_ = vala_element_access_get_container (self);
						_tmp221_ = _tmp220_;
						_tmp222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp223_ = _tmp222_;
						_tmp224_ = vala_member_access_new (_tmp221_, "get", _tmp223_);
						_tmp225_ = _tmp224_;
						_tmp226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp227_ = _tmp226_;
						_tmp228_ = vala_method_call_new ((ValaExpression*) _tmp225_, _tmp227_);
						_tmp229_ = _tmp228_;
						_vala_code_node_unref0 (_tmp225_);
						get_call = _tmp229_;
						{
							ValaList* _e_list = NULL;
							ValaList* _tmp230_;
							gint _e_size = 0;
							ValaList* _tmp231_;
							gint _tmp232_;
							gint _tmp233_;
							gint _e_index = 0;
							_tmp230_ = vala_element_access_get_indices (self);
							_e_list = _tmp230_;
							_tmp231_ = _e_list;
							_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
							_tmp233_ = _tmp232_;
							_e_size = _tmp233_;
							_e_index = -1;
							while (TRUE) {
								ValaExpression* e = NULL;
								ValaList* _tmp234_;
								gpointer _tmp235_;
								ValaMethodCall* _tmp236_;
								ValaExpression* _tmp237_;
								_e_index = _e_index + 1;
								if (!(_e_index < _e_size)) {
									break;
								}
								_tmp234_ = _e_list;
								_tmp235_ = vala_list_get (_tmp234_, _e_index);
								e = (ValaExpression*) _tmp235_;
								_tmp236_ = get_call;
								_tmp237_ = e;
								vala_method_call_add_argument (_tmp236_, _tmp237_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp238_ = get_call;
						_tmp239_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
						_tmp240_ = _tmp239_;
						vala_expression_set_formal_target_type ((ValaExpression*) _tmp238_, _tmp240_);
						_tmp241_ = get_call;
						_tmp242_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp243_ = _tmp242_;
						vala_expression_set_target_type ((ValaExpression*) _tmp241_, _tmp243_);
						_tmp244_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp245_ = _tmp244_;
						_tmp246_ = get_call;
						vala_code_node_replace_expression (_tmp245_, (ValaExpression*) self, (ValaExpression*) _tmp246_);
						_tmp247_ = get_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
						_vala_code_node_unref0 (get_call);
						_vala_code_node_unref0 (get_method);
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_vala_code_node_unref0 (get_method);
				}
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp249_ = _tmp248_;
				_tmp250_ = vala_element_access_get_container (self);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_value_type (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = vala_code_node_to_string ((ValaCodeNode*) _tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = g_strdup_printf ("The expression `%s' does not denote an array", _tmp255_);
				_tmp257_ = _tmp256_;
				vala_report_error (_tmp249_, _tmp257_);
				_g_free0 (_tmp257_);
				_g_free0 (_tmp255_);
			}
		}
	}
	if (index_int_type_check) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp258_;
			gint _e_size = 0;
			ValaList* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gint _e_index = 0;
			_tmp258_ = vala_element_access_get_indices (self);
			_e_list = _tmp258_;
			_tmp259_ = _e_list;
			_tmp260_ = vala_collection_get_size ((ValaCollection*) _tmp259_);
			_tmp261_ = _tmp260_;
			_e_size = _tmp261_;
			_e_index = -1;
			while (TRUE) {
				ValaExpression* e = NULL;
				ValaList* _tmp262_;
				gpointer _tmp263_;
				ValaExpression* _tmp264_;
				ValaDataType* _tmp265_;
				ValaDataType* _tmp266_;
				gboolean _tmp267_ = FALSE;
				ValaExpression* _tmp268_;
				ValaDataType* _tmp269_;
				ValaDataType* _tmp270_;
				_e_index = _e_index + 1;
				if (!(_e_index < _e_size)) {
					break;
				}
				_tmp262_ = _e_list;
				_tmp263_ = vala_list_get (_tmp262_, _e_index);
				e = (ValaExpression*) _tmp263_;
				_tmp264_ = e;
				_tmp265_ = vala_expression_get_value_type (_tmp264_);
				_tmp266_ = _tmp265_;
				if (_tmp266_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_code_node_unref0 (pointer_type);
					return result;
				}
				_tmp268_ = e;
				_tmp269_ = vala_expression_get_value_type (_tmp268_);
				_tmp270_ = _tmp269_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp270_, VALA_TYPE_INTEGER_TYPE)) {
					_tmp267_ = TRUE;
				} else {
					ValaExpression* _tmp271_;
					ValaDataType* _tmp272_;
					ValaDataType* _tmp273_;
					_tmp271_ = e;
					_tmp272_ = vala_expression_get_value_type (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp267_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp273_, VALA_TYPE_ENUM_VALUE_TYPE);
				}
				if (!_tmp267_) {
					ValaExpression* _tmp274_;
					ValaSourceReference* _tmp275_;
					ValaSourceReference* _tmp276_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp274_ = e;
					_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp274_);
					_tmp276_ = _tmp275_;
					vala_report_error (_tmp276_, "Expression of integer type expected");
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	}
	_tmp277_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp278_ = _tmp277_;
	result = !_tmp278_;
	_vala_code_node_unref0 (pointer_type);
	return result;
}

static void
vala_element_access_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp9_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	vala_code_visitor_visit_element_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _index_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_index_list = _tmp3_;
		_tmp4_ = _index_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_index_size = _tmp6_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp7_ = _index_list;
			_tmp8_ = vala_list_get (_tmp7_, _index_index);
			index = (ValaExpression*) _tmp8_;
			_tmp9_ = index;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}

static void
vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _index_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_index_list = _tmp3_;
		_tmp4_ = _index_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_index_size = _tmp6_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp7_ = _index_list;
			_tmp8_ = vala_list_get (_tmp7_, _index_index);
			index = (ValaExpression*) _tmp8_;
			_tmp9_ = index;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}

ValaExpression*
vala_element_access_get_container (ValaElementAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}

void
vala_element_access_set_container (ValaElementAccess* self,
                                   ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_container);
	self->priv->_container = _tmp0_;
	_tmp1_ = self->priv->_container;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_element_access_class_init (ValaElementAccessClass * klass,
                                gpointer klass_data)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_element_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaElementAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_element_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_element_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_element_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_element_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_element_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_element_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_element_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_used_variables;
}

static void
vala_element_access_instance_init (ValaElementAccess * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_element_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->indices = (ValaList*) _tmp1_;
}

static void
vala_element_access_finalize (ValaCodeNode * obj)
{
	ValaElementAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
	_vala_iterable_unref0 (self->priv->indices);
	_vala_code_node_unref0 (self->priv->_container);
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}

/**
 * Represents an array access expression e.g. "a[1,2]".
 */
GType
vala_element_access_get_type (void)
{
	static volatile gsize vala_element_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_element_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
		GType vala_element_access_type_id;
		vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
		ValaElementAccess_private_offset = g_type_add_instance_private (vala_element_access_type_id, sizeof (ValaElementAccessPrivate));
		g_once_init_leave (&vala_element_access_type_id__volatile, vala_element_access_type_id);
	}
	return vala_element_access_type_id__volatile;
}

