/* rygel-media-container.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *          Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <libsoup/soup.h>

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_PLAYLIST_DATASOURCE (rygel_playlist_datasource_get_type ())
#define RYGEL_PLAYLIST_DATASOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasource))
#define RYGEL_PLAYLIST_DATASOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourceClass))
#define RYGEL_IS_PLAYLIST_DATASOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE))
#define RYGEL_IS_PLAYLIST_DATASOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_DATASOURCE))
#define RYGEL_PLAYLIST_DATASOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourceClass))

typedef struct _RygelPlaylistDatasource RygelPlaylistDatasource;
typedef struct _RygelPlaylistDatasourceClass RygelPlaylistDatasourceClass;
typedef struct _RygelPlaylistDatasourcePrivate RygelPlaylistDatasourcePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())
enum  {
	RYGEL_PLAYLIST_DATASOURCE_0_PROPERTY,
	RYGEL_PLAYLIST_DATASOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_playlist_datasource_properties[RYGEL_PLAYLIST_DATASOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
typedef struct _RygelPlaylistDatasourceGenerateDataData RygelPlaylistDatasourceGenerateDataData;
enum  {
	RYGEL_PLAYLIST_DATASOURCE_DATA_READY_SIGNAL,
	RYGEL_PLAYLIST_DATASOURCE_NUM_SIGNALS
};
static guint rygel_playlist_datasource_signals[RYGEL_PLAYLIST_DATASOURCE_NUM_SIGNALS] = {0};
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
enum  {
	RYGEL_MEDIA_CONTAINER_0_PROPERTY,
	RYGEL_MEDIA_CONTAINER_CHILD_COUNT_PROPERTY,
	RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT_PROPERTY,
	RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY,
	RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED_PROPERTY,
	RYGEL_MEDIA_CONTAINER_SORT_CRITERIA_PROPERTY,
	RYGEL_MEDIA_CONTAINER_OCM_FLAGS_PROPERTY,
	RYGEL_MEDIA_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_NUM_PROPERTIES];

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
enum  {
	RYGEL_MEDIA_CONTAINER_CONTAINER_UPDATED_SIGNAL,
	RYGEL_MEDIA_CONTAINER_SUB_TREE_UPDATES_FINISHED_SIGNAL,
	RYGEL_MEDIA_CONTAINER_NUM_SIGNALS
};
static guint rygel_media_container_signals[RYGEL_MEDIA_CONTAINER_NUM_SIGNALS] = {0};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelPlaylistDatasource {
	GObject parent_instance;
	RygelPlaylistDatasourcePrivate * priv;
};

struct _RygelPlaylistDatasourceClass {
	GObjectClass parent_class;
};

struct _RygelPlaylistDatasourcePrivate {
	RygelMediaContainer* container;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	RygelHTTPServer* server;
	RygelClientHacks* hacks;
	RygelSerializerType playlist_type;
};

typedef enum  {
	RYGEL_DATA_SOURCE_ERROR_GENERAL,
	RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED,
	RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED
} RygelDataSourceError;
#define RYGEL_DATA_SOURCE_ERROR rygel_data_source_error_quark ()
struct _RygelPlaylistDatasourceGenerateDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelPlaylistDatasource* self;
	gchar* sort_criteria;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint count;
	RygelMediaContainer* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaObjects* _tmp9_;
	RygelMediaObjects* _tmp10_;
	RygelSerializer* serializer;
	RygelSerializerType _tmp11_;
	RygelSerializer* _tmp12_;
	RygelMediaObjects* _tmp13_;
	RygelSerializer* _tmp14_;
	RygelHTTPServer* _tmp15_;
	RygelClientHacks* _tmp16_;
	gchar* xml;
	RygelSerializer* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	GError* _tmp23_;
	GError* _tmp24_;
	GError* _error_;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainerPrivate {
	gint _child_count;
	gint _empty_child_count;
	gboolean _create_mode_enabled;
	gchar* _sort_criteria;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

static gint RygelPlaylistDatasource_private_offset;
static gpointer rygel_playlist_datasource_parent_class = NULL;
static RygelDataSourceIface * rygel_playlist_datasource_rygel_data_source_parent_iface = NULL;
static gint RygelMediaContainer_private_offset;
static gpointer rygel_media_container_parent_class = NULL;

GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_playlist_datasource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelPlaylistDatasource* rygel_playlist_datasource_new (RygelSerializerType playlist_type,
                                                        RygelMediaContainer* container,
                                                        RygelHTTPServer* server,
                                                        RygelClientHacks* hacks);
RygelPlaylistDatasource* rygel_playlist_datasource_construct (GType object_type,
                                                              RygelSerializerType playlist_type,
                                                              RygelMediaContainer* container,
                                                              RygelHTTPServer* server,
                                                              RygelClientHacks* hacks);
void rygel_playlist_datasource_generate_data (RygelPlaylistDatasource* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void rygel_playlist_datasource_generate_data_finish (RygelPlaylistDatasource* self,
                                                     GAsyncResult* _res_);
static GeeList* rygel_playlist_datasource_real_preroll (RygelDataSource* base,
                                                 RygelHTTPSeekRequest* seek_request,
                                                 RygelPlaySpeedRequest* playspeed_request,
                                                 GError** error);
GQuark rygel_data_source_error_quark (void);
static void rygel_playlist_datasource_real_start (RygelDataSource* base,
                                           GError** error);
static void ___lambda19_ (RygelPlaylistDatasource* self);
void rygel_data_source_start (RygelDataSource* self,
                              GError** error);
static void ____lambda19__rygel_playlist_datasource_data_ready (RygelPlaylistDatasource* _sender,
                                                         gpointer self);
static gboolean __lambda20_ (RygelPlaylistDatasource* self);
static gboolean ___lambda20__gsource_func (gpointer self);
static void rygel_playlist_datasource_real_freeze (RygelDataSource* base);
static void rygel_playlist_datasource_real_thaw (RygelDataSource* base);
static void rygel_playlist_datasource_real_stop (RygelDataSource* base);
static void rygel_playlist_datasource_generate_data_data_free (gpointer _data);
static void rygel_playlist_datasource_generate_data_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
static gboolean rygel_playlist_datasource_generate_data_co (RygelPlaylistDatasourceGenerateDataData* _data_);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
void rygel_media_container_get_children (RygelMediaContainer* self,
                                         guint offset,
                                         guint max_count,
                                         const gchar* sort_criteria,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void rygel_playlist_datasource_generate_data_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type,
                                             RygelSerializerType type);
void rygel_media_objects_serialize (RygelMediaObjects* self,
                                    RygelSerializer* serializer,
                                    RygelHTTPServer* http_server,
                                    RygelClientHacks* hacks,
                                    GError** error);
gchar* rygel_serializer_get_string (RygelSerializer* self);
static guint8* _vala_array_dup1 (guint8* self,
                          int length);
static void rygel_playlist_datasource_finalize (GObject * obj);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA "+upnp:class,+dc:title"
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".album.musicAlbum"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".person.musicArtist"
#define RYGEL_MEDIA_CONTAINER_MUSIC_GENRE RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".genre.musicGenre"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".playlistContainer"
#define RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA "+upnp:class," "+rygel:originalVolumeNumber," "+upnp:originalTrackNumber," "+dc:title"
#define RYGEL_MEDIA_CONTAINER_DIDL_S_PLAYLIST_RESNAME "didl_s_playlist"
#define RYGEL_MEDIA_CONTAINER_M3U_PLAYLIST_RESNAME "m3u_playlist"
gboolean rygel_media_container_equal_func (RygelMediaContainer* a,
                                           RygelMediaContainer* b);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_container_construct (GType object_type,
                                                      const gchar* id,
                                                      RygelMediaContainer* parent,
                                                      const gchar* title,
                                                      gint child_count);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type,
                                                           const gchar* title,
                                                           gint child_count);
static void rygel_media_container_real_constructed (GObject* base);
void rygel_media_container_set_empty_child_count (RygelMediaContainer* self,
                                                  gint value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self,
                                        const gchar* value);
void rygel_media_container_set_create_mode_enabled (RygelMediaContainer* self,
                                                    gboolean value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self,
                                                 RygelMediaContainer* container,
                                                 RygelMediaContainer* updated_container,
                                                 RygelMediaObject* object,
                                                 RygelObjectEventType event_type,
                                                 gboolean sub_tree_update);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                                          RygelMediaContainer* container,
                                                                                          RygelMediaObject* object,
                                                                                          RygelObjectEventType event_type,
                                                                                          gboolean sub_tree_update,
                                                                                          gpointer self);
static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self,
                                                         RygelMediaContainer* container,
                                                         RygelMediaObject* sub_tree_root);
static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender,
                                                                                                          RygelMediaObject* sub_tree_root,
                                                                                                          gpointer self);
void rygel_media_container_add_playlist_resources (RygelMediaContainer* self);
void rygel_media_container_find_object (RygelMediaContainer* self,
                                        const gchar* id,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
void rygel_media_container_updated (RygelMediaContainer* self,
                                    RygelMediaObject* object,
                                    RygelObjectEventType event_type,
                                    gboolean sub_tree_update);
RygelMediaResource* rygel_media_resource_new (const gchar* name);
RygelMediaResource* rygel_media_resource_construct (GType object_type,
                                                    const gchar* name);
void rygel_media_resource_set_extension (RygelMediaResource* self,
                                         const gchar* value);
void rygel_media_resource_set_mime_type (RygelMediaResource* self,
                                         const gchar* value);
void rygel_media_resource_set_dlna_profile (RygelMediaResource* self,
                                            const gchar* value);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self,
                                          GUPnPDLNAFlags value);
void rygel_media_resource_set_uri (RygelMediaResource* self,
                                   const gchar* value);
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base,
                                                           RygelSerializer* serializer,
                                                           RygelHTTPServer* http_server,
                                                           GError** error);
GUPnPDIDLLiteContainer* rygel_serializer_add_container (RygelSerializer* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void rygel_value_set_search_expression (GValue* value,
                                        gpointer v_object);
void rygel_value_take_search_expression (GValue* value,
                                         gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self,
                                                             GUPnPDIDLLiteContainer* didl_container);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
void rygel_media_object_serialize_resource_list (RygelMediaObject* self,
                                                 GUPnPDIDLLiteObject* didl_object,
                                                 RygelHTTPServer* http_server,
                                                 GError** error);
static RygelDataSource* rygel_media_container_real_create_stream_source_for_resource (RygelMediaObject* base,
                                                                               RygelHTTPRequest* request,
                                                                               RygelMediaResource* resource,
                                                                               GError** error);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
void rygel_media_container_check_search_expression (RygelMediaContainer* self,
                                                    RygelSearchExpression* expression);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_set_child_count (RygelMediaContainer* self,
                                            gint value);
gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self);
gint rygel_media_container_get_all_child_count (RygelMediaContainer* self);
gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self);
void rygel_media_container_set_sort_criteria (RygelMediaContainer* self,
                                              const gchar* value);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure,
                                                               GValue * return_value,
                                                               guint n_param_values,
                                                               const GValue * param_values,
                                                               gpointer invocation_hint,
                                                               gpointer marshal_data);
static void rygel_media_container_finalize (GObject * obj);
static void _vala_rygel_media_container_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_rygel_media_container_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

GType
rygel_object_event_type_get_type (void)
{
	static volatile gsize rygel_object_event_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_event_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_OBJECT_EVENT_TYPE_ADDED, "RYGEL_OBJECT_EVENT_TYPE_ADDED", "added"}, {RYGEL_OBJECT_EVENT_TYPE_MODIFIED, "RYGEL_OBJECT_EVENT_TYPE_MODIFIED", "modified"}, {RYGEL_OBJECT_EVENT_TYPE_DELETED, "RYGEL_OBJECT_EVENT_TYPE_DELETED", "deleted"}, {0, NULL, NULL}};
		GType rygel_object_event_type_type_id;
		rygel_object_event_type_type_id = g_enum_register_static ("RygelObjectEventType", values);
		g_once_init_leave (&rygel_object_event_type_type_id__volatile, rygel_object_event_type_type_id);
	}
	return rygel_object_event_type_type_id__volatile;
}

static inline gpointer
rygel_playlist_datasource_get_instance_private (RygelPlaylistDatasource* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlaylistDatasource_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelPlaylistDatasource*
rygel_playlist_datasource_construct (GType object_type,
                                     RygelSerializerType playlist_type,
                                     RygelMediaContainer* container,
                                     RygelHTTPServer* server,
                                     RygelClientHacks* hacks)
{
	RygelPlaylistDatasource * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelClientHacks* _tmp2_;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	self = (RygelPlaylistDatasource*) g_object_new (object_type, NULL);
	self->priv->playlist_type = playlist_type;
	_tmp0_ = _g_object_ref0 (container);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp0_;
	_tmp1_ = _g_object_ref0 (server);
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp1_;
	_tmp2_ = _g_object_ref0 (hacks);
	_g_object_unref0 (self->priv->hacks);
	self->priv->hacks = _tmp2_;
	rygel_playlist_datasource_generate_data (self, NULL, NULL);
	return self;
}

RygelPlaylistDatasource*
rygel_playlist_datasource_new (RygelSerializerType playlist_type,
                               RygelMediaContainer* container,
                               RygelHTTPServer* server,
                               RygelClientHacks* hacks)
{
	return rygel_playlist_datasource_construct (RYGEL_TYPE_PLAYLIST_DATASOURCE, playlist_type, container, server, hacks);
}

static GeeList*
rygel_playlist_datasource_real_preroll (RygelDataSource* base,
                                        RygelHTTPSeekRequest* seek_request,
                                        RygelPlaySpeedRequest* playspeed_request,
                                        GError** error)
{
	RygelPlaylistDatasource * self;
	GeeList* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelPlaylistDatasource*) base;
	if (seek_request != NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("Seeking not supported"));
		_inner_error_ = _tmp0_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (playspeed_request != NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _ ("Speed not supported"));
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = NULL;
	return result;
}

static void
___lambda19_ (RygelPlaylistDatasource* self)
{
	GError * _inner_error_ = NULL;
	{
		rygel_data_source_start ((RygelDataSource*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}

static void
____lambda19__rygel_playlist_datasource_data_ready (RygelPlaylistDatasource* _sender,
                                                    gpointer self)
{
	___lambda19_ ((RygelPlaylistDatasource*) self);
}

static gboolean
__lambda20_ (RygelPlaylistDatasource* self)
{
	gboolean result = FALSE;
	guint8* _tmp0_;
	gint _tmp0__length1;
	_tmp0_ = self->priv->data;
	_tmp0__length1 = self->priv->data_length1;
	g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp0_, (gint) _tmp0__length1);
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}

static gboolean
___lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda20_ ((RygelPlaylistDatasource*) self);
	return result;
}

static void
rygel_playlist_datasource_real_start (RygelDataSource* base,
                                      GError** error)
{
	RygelPlaylistDatasource * self;
	guint8* _tmp0_;
	gint _tmp0__length1;
	self = (RygelPlaylistDatasource*) base;
	_tmp0_ = self->priv->data;
	_tmp0__length1 = self->priv->data_length1;
	if (_tmp0_ == NULL) {
		g_signal_connect_object (self, "data-ready", (GCallback) ____lambda19__rygel_playlist_datasource_data_ready, self, 0);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda20__gsource_func, g_object_ref (self), g_object_unref);
}

static void
rygel_playlist_datasource_real_freeze (RygelDataSource* base)
{
	RygelPlaylistDatasource * self;
	self = (RygelPlaylistDatasource*) base;
}

static void
rygel_playlist_datasource_real_thaw (RygelDataSource* base)
{
	RygelPlaylistDatasource * self;
	self = (RygelPlaylistDatasource*) base;
}

static void
rygel_playlist_datasource_real_stop (RygelDataSource* base)
{
	RygelPlaylistDatasource * self;
	self = (RygelPlaylistDatasource*) base;
}

static void
rygel_playlist_datasource_generate_data_data_free (gpointer _data)
{
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelPlaylistDatasourceGenerateDataData, _data_);
}

static void
rygel_playlist_datasource_generate_data_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	RygelPlaylistDatasourceGenerateDataData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

void
rygel_playlist_datasource_generate_data (RygelPlaylistDatasource* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	RygelPlaylistDatasourceGenerateDataData* _data_;
	RygelPlaylistDatasource* _tmp0_;
	_data_ = g_slice_new0 (RygelPlaylistDatasourceGenerateDataData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_playlist_datasource_generate_data_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_playlist_datasource_generate_data_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_playlist_datasource_generate_data_co (_data_);
}

void
rygel_playlist_datasource_generate_data_finish (RygelPlaylistDatasource* self,
                                                GAsyncResult* _res_)
{
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_playlist_datasource_generate_data_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_playlist_datasource_generate_data_co (_data_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint8));
}

static gboolean
rygel_playlist_datasource_generate_data_co (RygelPlaylistDatasourceGenerateDataData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->container;
		_data_->_tmp1_ = rygel_media_container_get_sort_criteria (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->sort_criteria = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->container;
		_data_->_tmp5_ = rygel_media_container_get_child_count (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->count = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->self->priv->container;
		_data_->_tmp8_ = _data_->sort_criteria;
		_data_->_state_ = 1;
		rygel_media_container_get_children (_data_->_tmp7_, (guint) 0, (guint) _data_->count, _data_->_tmp8_, NULL, rygel_playlist_datasource_generate_data_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = rygel_media_container_get_children_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->children = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->sort_criteria);
			goto __catch8_g_error;
		}
		_data_->_tmp10_ = _data_->children;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp11_ = _data_->self->priv->playlist_type;
			_data_->_tmp12_ = rygel_serializer_new (_data_->_tmp11_);
			_data_->serializer = _data_->_tmp12_;
			_data_->_tmp13_ = _data_->children;
			_data_->_tmp14_ = _data_->serializer;
			_data_->_tmp15_ = _data_->self->priv->server;
			_data_->_tmp16_ = _data_->self->priv->hacks;
			rygel_media_objects_serialize (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->serializer);
				_g_object_unref0 (_data_->children);
				_g_free0 (_data_->sort_criteria);
				goto __catch8_g_error;
			}
			_data_->_tmp17_ = _data_->serializer;
			_data_->_tmp18_ = rygel_serializer_get_string (_data_->_tmp17_);
			_data_->xml = _data_->_tmp18_;
			_data_->_tmp19_ = _data_->xml;
			_data_->_tmp20_ = string_get_data (_data_->_tmp19_, &_data_->_tmp20__length1);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp21__length1 = _data_->_tmp20__length1;
			_data_->_tmp22_ = (_data_->_tmp21_ != NULL) ? _vala_array_dup1 (_data_->_tmp21_, _data_->_tmp21__length1) : ((gpointer) _data_->_tmp21_);
			_data_->_tmp22__length1 = _data_->_tmp21__length1;
			_data_->self->priv->data = (g_free (_data_->self->priv->data), NULL);
			_data_->self->priv->data = _data_->_tmp22_;
			_data_->self->priv->data_length1 = _data_->_tmp22__length1;
			_data_->self->priv->_data_size_ = _data_->self->priv->data_length1;
			g_signal_emit (_data_->self, rygel_playlist_datasource_signals[RYGEL_PLAYLIST_DATASOURCE_DATA_READY_SIGNAL], 0);
			_g_free0 (_data_->xml);
			_g_object_unref0 (_data_->serializer);
		} else {
			_data_->_tmp23_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _ ("Failed to generate playlist"));
			_data_->_tmp24_ = _data_->_tmp23_;
			g_signal_emit_by_name ((RygelDataSource*) _data_->self, "error", _data_->_tmp24_);
			_g_error_free0 (_data_->_tmp24_);
		}
		_g_object_unref0 (_data_->children);
		_g_free0 (_data_->sort_criteria);
	}
	goto __finally8;
	__catch8_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp25_ = _data_->_error_;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("rygel-media-container.vala:126: Could not generate playlist: %s", _data_->_tmp26_);
		_data_->_tmp27_ = _data_->_error_;
		g_signal_emit_by_name ((RygelDataSource*) _data_->self, "error", _data_->_tmp27_);
		_g_error_free0 (_data_->_error_);
	}
	__finally8:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_playlist_datasource_class_init (RygelPlaylistDatasourceClass * klass)
{
	rygel_playlist_datasource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlaylistDatasource_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_playlist_datasource_finalize;
	rygel_playlist_datasource_signals[RYGEL_PLAYLIST_DATASOURCE_DATA_READY_SIGNAL] = g_signal_new ("data-ready", RYGEL_TYPE_PLAYLIST_DATASOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
rygel_playlist_datasource_rygel_data_source_interface_init (RygelDataSourceIface * iface)
{
	rygel_playlist_datasource_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->preroll = (GeeList* (*) (RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_playlist_datasource_real_preroll;
	iface->start = (void (*) (RygelDataSource*, GError**)) rygel_playlist_datasource_real_start;
	iface->freeze = (void (*) (RygelDataSource*)) rygel_playlist_datasource_real_freeze;
	iface->thaw = (void (*) (RygelDataSource*)) rygel_playlist_datasource_real_thaw;
	iface->stop = (void (*) (RygelDataSource*)) rygel_playlist_datasource_real_stop;
}

static void
rygel_playlist_datasource_instance_init (RygelPlaylistDatasource * self)
{
	self->priv = rygel_playlist_datasource_get_instance_private (self);
}

static void
rygel_playlist_datasource_finalize (GObject * obj)
{
	RygelPlaylistDatasource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasource);
	_g_object_unref0 (self->priv->container);
	self->priv->data = (g_free (self->priv->data), NULL);
	_g_object_unref0 (self->priv->server);
	_g_object_unref0 (self->priv->hacks);
	G_OBJECT_CLASS (rygel_playlist_datasource_parent_class)->finalize (obj);
}

/**
 * Implementation of RygelDataSource to serve generated playlists to a client.
 */
GType
rygel_playlist_datasource_get_type (void)
{
	static volatile gsize rygel_playlist_datasource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playlist_datasource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaylistDatasourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playlist_datasource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaylistDatasource), 0, (GInstanceInitFunc) rygel_playlist_datasource_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_playlist_datasource_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playlist_datasource_type_id;
		rygel_playlist_datasource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaylistDatasource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playlist_datasource_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		RygelPlaylistDatasource_private_offset = g_type_add_instance_private (rygel_playlist_datasource_type_id, sizeof (RygelPlaylistDatasourcePrivate));
		g_once_init_leave (&rygel_playlist_datasource_type_id__volatile, rygel_playlist_datasource_type_id);
	}
	return rygel_playlist_datasource_type_id__volatile;
}

static inline gpointer
rygel_media_container_get_instance_private (RygelMediaContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaContainer_private_offset);
}

gboolean
rygel_media_container_equal_func (RygelMediaContainer* a,
                                  RygelMediaContainer* b)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) b);
	_tmp3_ = _tmp2_;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}

/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelMediaContainer*
rygel_media_container_construct (GType object_type,
                                 const gchar* id,
                                 RygelMediaContainer* parent,
                                 const gchar* title,
                                 gint child_count)
{
	RygelMediaContainer * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "child-count", child_count, NULL);
	return self;
}

/**
     * Create a root media container with the specified details,
     * with no parent container, and with an appropriate ID.
     *
     * @param title See the title property of the #RygelMediaObject.
     * @param child_count The initially-known number of child items.
     */
RygelMediaContainer*
rygel_media_container_construct_root (GType object_type,
                                      const gchar* title,
                                      gint child_count)
{
	RygelMediaContainer * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) g_object_new (object_type, "id", "0", "parent", NULL, "title", title, "child-count", child_count, NULL);
	return self;
}

static void
_rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                                     RygelMediaContainer* container,
                                                                                     RygelMediaObject* object,
                                                                                     RygelObjectEventType event_type,
                                                                                     gboolean sub_tree_update,
                                                                                     gpointer self)
{
	rygel_media_container_on_container_updated ((RygelMediaContainer*) self, _sender, container, object, event_type, sub_tree_update);
}

static void
_rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender,
                                                                                                     RygelMediaObject* sub_tree_root,
                                                                                                     gpointer self)
{
	rygel_media_container_on_sub_tree_updates_finished ((RygelMediaContainer*) self, _sender, sub_tree_root);
}

static void
rygel_media_container_real_constructed (GObject* base)
{
	RygelMediaContainer * self;
	self = (RygelMediaContainer*) base;
	G_OBJECT_CLASS (rygel_media_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject));
	rygel_media_container_set_empty_child_count (self, 0);
	self->update_id = (guint32) 0;
	self->storage_used = (gint64) -1;
	self->total_deleted_child_count = (gint64) 0;
	rygel_media_object_set_upnp_class ((RygelMediaObject*) self, RYGEL_MEDIA_CONTAINER_UPNP_CLASS);
	rygel_media_container_set_create_mode_enabled (self, FALSE);
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
	g_signal_connect_object (self, "sub-tree-updates-finished", (GCallback) _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
	rygel_media_container_add_playlist_resources (self);
}

void
rygel_media_container_get_children (RygelMediaContainer* self,
                                    guint offset,
                                    guint max_count,
                                    const gchar* sort_criteria,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
}

RygelMediaObjects*
rygel_media_container_get_children_finish (RygelMediaContainer* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
}

void
rygel_media_container_find_object (RygelMediaContainer* self,
                                   const gchar* id,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
}

RygelMediaObject*
rygel_media_container_find_object_finish (RygelMediaContainer* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
}

/**
     * This method should be called each time this container is updated.
     *
     * For instance, this should be called if there are metadata changes
     * for this container, if items under it are removed or added, if
     * there are metadata changes to items under it, etc.
     *
     * If sub_tree_update is true then the caller should later emit the 
     * sub_tree_updates_finished signal on the root container of the sub-tree
     * that was updated.
     *
     * It will eventually result in the server emitting a UPnP LastChange event,
     * though that may be for a batch of these calls.
     *
     * See the #RygelMediaContainer::container_updated signal.
     *
     * @param object The object that has changed, or null to mean the container itself.
     * @param event_type This describes what actually happened to the object.
     * @param sub_tree_update Whether the modification is part of a sub-tree update.
     */
void
rygel_media_container_updated (RygelMediaContainer* self,
                               RygelMediaObject* object,
                               RygelObjectEventType event_type,
                               gboolean sub_tree_update)
{
	RygelMediaObject* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (object != NULL) {
		_tmp0_ = object;
	} else {
		_tmp0_ = (RygelMediaObject*) self;
	}
	g_signal_emit (self, rygel_media_container_signals[RYGEL_MEDIA_CONTAINER_CONTAINER_UPDATED_SIGNAL], 0, self, _tmp0_, event_type, sub_tree_update);
}

/**
     * Add playlist resources to the MediaObject resource list
     */
void
rygel_media_container_add_playlist_resources (RygelMediaContainer* self)
{
	g_return_if_fail (self != NULL);
	{
		RygelMediaResource* didl_s_res = NULL;
		RygelMediaResource* _tmp0_;
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		_tmp0_ = rygel_media_resource_new (RYGEL_MEDIA_CONTAINER_DIDL_S_PLAYLIST_RESNAME);
		didl_s_res = _tmp0_;
		rygel_media_resource_set_extension (didl_s_res, "xml");
		rygel_media_resource_set_mime_type (didl_s_res, "text/xml");
		rygel_media_resource_set_dlna_profile (didl_s_res, "DIDL_S");
		rygel_media_resource_set_dlna_flags (didl_s_res, (GUPNP_DLNA_FLAGS_CONNECTION_STALL | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
		rygel_media_resource_set_uri (didl_s_res, "");
		_tmp1_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
		_tmp2_ = _tmp1_;
		gee_collection_add ((GeeCollection*) _tmp2_, didl_s_res);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (didl_s_res);
	}
	{
		RygelMediaResource* m3u_res = NULL;
		RygelMediaResource* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		_tmp3_ = rygel_media_resource_new (RYGEL_MEDIA_CONTAINER_M3U_PLAYLIST_RESNAME);
		m3u_res = _tmp3_;
		rygel_media_resource_set_extension (m3u_res, "m3u");
		rygel_media_resource_set_mime_type (m3u_res, "audio/x-mpegurl");
		rygel_media_resource_set_dlna_profile (m3u_res, NULL);
		rygel_media_resource_set_dlna_flags (m3u_res, (GUPNP_DLNA_FLAGS_CONNECTION_STALL | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
		rygel_media_resource_set_uri (m3u_res, "");
		_tmp4_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
		_tmp5_ = _tmp4_;
		gee_collection_add ((GeeCollection*) _tmp5_, m3u_res);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (m3u_res);
	}
}

static GUPnPDIDLLiteObject*
rygel_media_container_real_serialize (RygelMediaObject* base,
                                      RygelSerializer* serializer,
                                      RygelHTTPServer* http_server,
                                      GError** error)
{
	RygelMediaContainer * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteContainer* didl_container = NULL;
	GUPnPDIDLLiteContainer* _tmp0_;
	GUPnPDIDLLiteContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	GUPnPDIDLLiteContainer* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GUPnPDIDLLiteContainer* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	GUPnPDIDLLiteContainer* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GUPnPDIDLLiteContainer* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gint _tmp51_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = rygel_serializer_add_container (serializer);
	didl_container = _tmp0_;
	_tmp1_ = didl_container;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (didl_container);
		return result;
	}
	_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GUPnPDIDLLiteContainer* _tmp4_;
		RygelMediaContainer* _tmp5_;
		RygelMediaContainer* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = didl_container;
		_tmp5_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp6_);
		_tmp8_ = _tmp7_;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp4_, _tmp8_);
	} else {
		GUPnPDIDLLiteContainer* _tmp9_;
		_tmp9_ = didl_container;
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp9_, "-1");
	}
	_tmp10_ = didl_container;
	_tmp11_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp12_ = _tmp11_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp10_, _tmp12_);
	_tmp13_ = didl_container;
	_tmp14_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	_tmp15_ = _tmp14_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp13_, _tmp15_);
	_tmp16_ = self->priv->_child_count;
	if (_tmp16_ > -1) {
		GUPnPDIDLLiteContainer* _tmp17_;
		gint _tmp18_;
		_tmp17_ = didl_container;
		_tmp18_ = self->priv->_child_count;
		gupnp_didl_lite_container_set_child_count (_tmp17_, _tmp18_);
	}
	_tmp19_ = didl_container;
	_tmp20_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp21_ = _tmp20_;
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp19_, _tmp21_);
	_tmp22_ = didl_container;
	gupnp_didl_lite_container_set_searchable (_tmp22_, G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER));
	_tmp23_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
	_tmp24_ = _tmp23_;
	if (g_strcmp0 (_tmp24_, RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER) == 0) {
		GUPnPDIDLLiteContainer* _tmp25_;
		_tmp25_ = didl_container;
		gupnp_didl_lite_container_set_storage_used (_tmp25_, self->storage_used);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		GUPnPDIDLLiteContainer* _tmp26_;
		GUPnPDIDLLiteContainer* _tmp27_;
		guint _tmp28_;
		guint _tmp29_;
		GUPnPDIDLLiteContainer* _tmp30_;
		_tmp26_ = didl_container;
		gupnp_didl_lite_container_set_container_update_id (_tmp26_, (guint) self->update_id);
		_tmp27_ = didl_container;
		_tmp28_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
		_tmp29_ = _tmp28_;
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp27_, _tmp29_);
		_tmp30_ = didl_container;
		gupnp_didl_lite_container_set_total_deleted_child_count (_tmp30_, (guint) self->total_deleted_child_count);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
		GUPnPDIDLLiteContainer* _tmp31_;
		_tmp31_ = didl_container;
		rygel_searchable_container_serialize_search_parameters (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) self) : NULL, _tmp31_);
	}
	_tmp32_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	_tmp33_ = _tmp32_;
	if (!_tmp33_) {
		GUPnPDIDLLiteContainer* _tmp34_;
		GUPnPDIDLLiteContainer* _tmp35_;
		GUPnPOCMFlags _tmp36_;
		GUPnPOCMFlags _tmp37_;
		RygelWritableContainer* writable = NULL;
		RygelWritableContainer* _tmp38_;
		_tmp34_ = didl_container;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp34_, FALSE);
		_tmp35_ = didl_container;
		_tmp36_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		_tmp37_ = _tmp36_;
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp35_, _tmp37_);
		_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) self) : NULL);
		writable = _tmp38_;
		{
			GeeArrayList* _create_class_list = NULL;
			RygelWritableContainer* _tmp39_;
			GeeArrayList* _tmp40_;
			GeeArrayList* _tmp41_;
			GeeArrayList* _tmp42_;
			gint _create_class_size = 0;
			GeeArrayList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _create_class_index = 0;
			_tmp39_ = writable;
			_tmp40_ = rygel_writable_container_get_create_classes (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_create_class_list = _tmp42_;
			_tmp43_ = _create_class_list;
			_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_create_class_size = _tmp45_;
			_create_class_index = -1;
			while (TRUE) {
				gchar* create_class = NULL;
				GeeArrayList* _tmp46_;
				gpointer _tmp47_;
				GUPnPDIDLLiteContainer* _tmp48_;
				const gchar* _tmp49_;
				_create_class_index = _create_class_index + 1;
				if (!(_create_class_index < _create_class_size)) {
					break;
				}
				_tmp46_ = _create_class_list;
				_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _create_class_index);
				create_class = (gchar*) _tmp47_;
				_tmp48_ = didl_container;
				_tmp49_ = create_class;
				gupnp_didl_lite_container_add_create_class (_tmp48_, _tmp49_);
				_g_free0 (create_class);
			}
			_g_object_unref0 (_create_class_list);
		}
		_g_object_unref0 (writable);
	} else {
		GUPnPDIDLLiteContainer* _tmp50_;
		_tmp50_ = didl_container;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp50_, TRUE);
	}
	_tmp51_ = self->priv->_child_count;
	if (_tmp51_ > 0) {
		GUPnPDIDLLiteContainer* _tmp52_;
		_tmp52_ = didl_container;
		rygel_media_object_serialize_resource_list ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp52_, http_server, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_container);
			return NULL;
		}
	}
	result = (GUPnPDIDLLiteObject*) didl_container;
	return result;
}

static RygelDataSource*
rygel_media_container_real_create_stream_source_for_resource (RygelMediaObject* base,
                                                              RygelHTTPRequest* request,
                                                              RygelMediaResource* resource,
                                                              GError** error)
{
	RygelMediaContainer * self;
	RygelDataSource* result = NULL;
	RygelSerializerType playlist_type = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	RygelSerializerType _tmp6_;
	RygelHTTPServer* _tmp7_;
	RygelClientHacks* _tmp8_;
	RygelPlaylistDatasource* _tmp9_;
	self = (RygelMediaContainer*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = rygel_media_resource_get_name (resource);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_DIDL_S_PLAYLIST_RESNAME)) {
		switch (0) {
			default:
			{
				playlist_type = RYGEL_SERIALIZER_TYPE_DIDL_S;
				break;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_M3U_PLAYLIST_RESNAME)) {
		switch (0) {
			default:
			{
				playlist_type = RYGEL_SERIALIZER_TYPE_M3UEXT;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = rygel_media_resource_get_name (resource);
				_tmp5_ = _tmp4_;
				g_warning (_ ("Unknown MediaContainer resource: %s"), _tmp5_);
				_g_free0 (_tmp5_);
				result = NULL;
				return result;
			}
		}
	}
	_tmp6_ = playlist_type;
	_tmp7_ = request->http_server;
	_tmp8_ = request->hack;
	_tmp9_ = rygel_playlist_datasource_new (_tmp6_, self, _tmp7_, _tmp8_);
	result = (RygelDataSource*) _tmp9_;
	return result;
}

/**
     * The handler for the container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container The container that emitted the signal
     * @param updated_container The container that just got updated
     */
static void
rygel_media_container_on_container_updated (RygelMediaContainer* self,
                                            RygelMediaContainer* container,
                                            RygelMediaContainer* updated_container,
                                            RygelMediaObject* object,
                                            RygelObjectEventType event_type,
                                            gboolean sub_tree_update)
{
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (updated_container != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		RygelMediaContainer* _tmp2_;
		RygelMediaContainer* _tmp3_;
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp3_ = _tmp2_;
		g_signal_emit (_tmp3_, rygel_media_container_signals[RYGEL_MEDIA_CONTAINER_CONTAINER_UPDATED_SIGNAL], 0, updated_container, object, event_type, sub_tree_update);
	}
}

static void
rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self,
                                                    RygelMediaContainer* container,
                                                    RygelMediaObject* sub_tree_root)
{
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sub_tree_root != NULL);
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		RygelMediaContainer* _tmp2_;
		RygelMediaContainer* _tmp3_;
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp3_ = _tmp2_;
		g_signal_emit (_tmp3_, rygel_media_container_signals[RYGEL_MEDIA_CONTAINER_SUB_TREE_UPDATES_FINISHED_SIGNAL], 0, sub_tree_root);
	}
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

void
rygel_media_container_check_search_expression (RygelMediaContainer* self,
                                               RygelSearchExpression* expression)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	rygel_media_container_set_create_mode_enabled (self, FALSE);
	if (expression != NULL) {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_RELATIONAL_EXPRESSION);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		RygelRelationalExpression* relational_exp = NULL;
		RygelRelationalExpression* _tmp1_;
		gboolean _tmp2_ = FALSE;
		RygelRelationalExpression* _tmp3_;
		gconstpointer _tmp4_;
		_tmp1_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) expression) : NULL);
		relational_exp = _tmp1_;
		_tmp3_ = relational_exp;
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->op;
		if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp4_)) == GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM) {
			RygelRelationalExpression* _tmp5_;
			gconstpointer _tmp6_;
			_tmp5_ = relational_exp;
			_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand1;
			_tmp2_ = g_strcmp0 ((const gchar*) _tmp6_, "upnp:createClass") == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			rygel_media_container_set_create_mode_enabled (self, TRUE);
		}
		_rygel_search_expression_unref0 (relational_exp);
	}
}

gint
rygel_media_container_get_child_count (RygelMediaContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_child_count;
	return result;
}

void
rygel_media_container_set_child_count (RygelMediaContainer* self,
                                       gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_container_get_child_count (self) != value) {
		self->priv->_child_count = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_CHILD_COUNT_PROPERTY]);
	}
}

gint
rygel_media_container_get_empty_child_count (RygelMediaContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_empty_child_count;
	return result;
}

void
rygel_media_container_set_empty_child_count (RygelMediaContainer* self,
                                             gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_container_get_empty_child_count (self) != value) {
		self->priv->_empty_child_count = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT_PROPERTY]);
	}
}

gint
rygel_media_container_get_all_child_count (RygelMediaContainer* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_child_count;
	_tmp1_ = self->priv->_empty_child_count;
	result = _tmp0_ + _tmp1_;
	return result;
}

gboolean
rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_create_mode_enabled;
	return result;
}

void
rygel_media_container_set_create_mode_enabled (RygelMediaContainer* self,
                                               gboolean value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_container_get_create_mode_enabled (self) != value) {
		self->priv->_create_mode_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED_PROPERTY]);
	}
}

const gchar*
rygel_media_container_get_sort_criteria (RygelMediaContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sort_criteria;
	result = _tmp0_;
	return result;
}

void
rygel_media_container_set_sort_criteria (RygelMediaContainer* self,
                                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_container_get_sort_criteria (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sort_criteria);
		self->priv->_sort_criteria = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_SORT_CRITERIA_PROPERTY]);
	}
}

static GUPnPOCMFlags
rygel_media_container_real_get_ocm_flags (RygelMediaObject* base)
{
	GUPnPOCMFlags result;
	RygelMediaContainer* self;
	gboolean _tmp0_ = FALSE;
	GUPnPOCMFlags flags = 0;
	gboolean allow_upload = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp5_;
	gboolean allow_deletion = FALSE;
	GUPnPOCMFlags _tmp13_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) base;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER)) {
		_tmp0_ = TRUE;
	} else {
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = rygel_media_object_get_uris ((RygelMediaObject*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_collection_get_is_empty ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	if (_tmp0_) {
		result = GUPNP_OCM_FLAGS_NONE;
		return result;
	}
	flags = GUPNP_OCM_FLAGS_NONE;
	allow_upload = TRUE;
	_tmp5_ = rygel_meta_config_get_default ();
	config = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		RygelMetaConfig* _tmp7_;
		_tmp7_ = config;
		_tmp6_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		allow_upload = _tmp6_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (allow_upload) {
		GUPnPOCMFlags _tmp8_;
		_tmp8_ = flags;
		flags = _tmp8_ | ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE) | GUPNP_OCM_FLAGS_CREATE_CONTAINER);
	}
	allow_deletion = TRUE;
	{
		gboolean _tmp9_ = FALSE;
		RygelMetaConfig* _tmp10_;
		_tmp10_ = config;
		_tmp9_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
		allow_deletion = _tmp9_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (allow_deletion) {
		GUPnPOCMFlags _tmp11_;
		_tmp11_ = flags;
		flags = _tmp11_ | GUPNP_OCM_FLAGS_DESTROYABLE;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
		GUPnPOCMFlags _tmp12_;
		_tmp12_ = flags;
		flags = _tmp12_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
	}
	_tmp13_ = flags;
	result = _tmp13_;
	_g_object_unref0 (config);
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}

static void
rygel_media_container_class_init (RygelMediaContainerClass * klass)
{
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaContainer_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_container_real_constructed;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_media_container_real_serialize;
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = (RygelDataSource* (*) (RygelMediaObject*, RygelHTTPRequest*, RygelMediaResource*, GError**)) rygel_media_container_real_create_stream_source_for_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_container_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_CHILD_COUNT_PROPERTY, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_CHILD_COUNT_PROPERTY] = g_param_spec_int ("child-count", "child-count", "child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT_PROPERTY, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT_PROPERTY] = g_param_spec_int ("empty-child-count", "empty-child-count", "empty-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY] = g_param_spec_int ("all-child-count", "all-child-count", "all-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED_PROPERTY, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED_PROPERTY] = g_param_spec_boolean ("create-mode-enabled", "create-mode-enabled", "create-mode-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_SORT_CRITERIA_PROPERTY, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_SORT_CRITERIA_PROPERTY] = g_param_spec_string ("sort-criteria", "sort-criteria", "sort-criteria", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_OCM_FLAGS_PROPERTY, rygel_media_container_properties[RYGEL_MEDIA_CONTAINER_OCM_FLAGS_PROPERTY] = g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The container_updated signal is emitted if the subtree unter this
	     * container has been modified. The object parameter is set to
	     * the MediaObject that is the source of the container update. Note that
	     * it may even be set to the container itself.
	     *
	     * @see rygel_media_container_updated().
	     *
	     * @param container The child container that has been updated.
	     * @param object The object that has changed. This may be the container itself, or a child item.
	     * @param event_type This describes what actually happened to the object.
	     * @param sub_tree_update Whether the modification is part of a sub-tree update. See the #RygelMediaContainer::sub_tree_updates_finished signal.
	     */
	rygel_media_container_signals[RYGEL_MEDIA_CONTAINER_CONTAINER_UPDATED_SIGNAL] = g_signal_new ("container-updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN, G_TYPE_NONE, 4, RYGEL_TYPE_MEDIA_CONTAINER, RYGEL_TYPE_MEDIA_OBJECT, RYGEL_TYPE_OBJECT_EVENT_TYPE, G_TYPE_BOOLEAN);
	/**
	     * The sub_tree_updates_finished signal is emitted when all of
	     * the sub-tree operations are finished.
	     * See the #RygelMediaContainer::container_updated signal.
	     *
	     * @param sub_tree_root - root of a sub-tree where all operations
	     * were performed.
	     */
	rygel_media_container_signals[RYGEL_MEDIA_CONTAINER_SUB_TREE_UPDATES_FINISHED_SIGNAL] = g_signal_new ("sub-tree-updates-finished", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
}

static void
rygel_media_container_instance_init (RygelMediaContainer * self)
{
	gchar* _tmp0_;
	self->priv = rygel_media_container_get_instance_private (self);
	_tmp0_ = g_strdup (RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA);
	self->priv->_sort_criteria = _tmp0_;
}

static void
rygel_media_container_finalize (GObject * obj)
{
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	_g_free0 (self->priv->_sort_criteria);
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}

/**
 * This is a container (folder) for media items and child containers.
 *
 * It provides a basic serialization implementation (to DIDLLiteWriter).
 *
 * A derived class should provide a working implementation of get_children
 * and should emit the container_updated signal.
 *
 * When used as a root container, you may wish to use the variables, such as
 * REALNAME, in in the title. See the title property of the #RygelMediaObject.
 *
 * If the container should support UPnP search operations then you also implement
 * the #RygelSearchableContainer interface.
 *
 * If the container should be writable, meaning that it allows adding (via upload),
 * removal and editing of items then you should also implement the #RygelWritableContainer
 * interface.
 *
 * If the container should support the change tracking profile of the UPnP
 * ContentDirectory:3 specification then you should also implement the 
 * #RygelTrackableContainer interface.
 *
 * The #RygelSimpleContainer class contains a simple memory-based container
 * implementation, but most real-world uses will require custom container
 * implementations.
 */
GType
rygel_media_container_get_type (void)
{
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		RygelMediaContainer_private_offset = g_type_add_instance_private (rygel_media_container_type_id, sizeof (RygelMediaContainerPrivate));
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}

static void
_vala_rygel_media_container_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_CHILD_COUNT_PROPERTY:
		g_value_set_int (value, rygel_media_container_get_child_count (self));
		break;
		case RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT_PROPERTY:
		g_value_set_int (value, rygel_media_container_get_empty_child_count (self));
		break;
		case RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY:
		g_value_set_int (value, rygel_media_container_get_all_child_count (self));
		break;
		case RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED_PROPERTY:
		g_value_set_boolean (value, rygel_media_container_get_create_mode_enabled (self));
		break;
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA_PROPERTY:
		g_value_set_string (value, rygel_media_container_get_sort_criteria (self));
		break;
		case RYGEL_MEDIA_CONTAINER_OCM_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_container_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_CHILD_COUNT_PROPERTY:
		rygel_media_container_set_child_count (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT_PROPERTY:
		rygel_media_container_set_empty_child_count (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED_PROPERTY:
		rygel_media_container_set_create_mode_enabled (self, g_value_get_boolean (value));
		break;
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA_PROPERTY:
		rygel_media_container_set_sort_criteria (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

