/* rygel-media-resource.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-media-resource.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelMediaResourcePrivate RygelMediaResourcePrivate;
enum  {
	RYGEL_MEDIA_RESOURCE_0_PROPERTY,
	RYGEL_MEDIA_RESOURCE_URI_PROPERTY,
	RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY,
	RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY,
	RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY,
	RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY,
	RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY,
	RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY,
	RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY,
	RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelMediaResource {
	GObject parent_instance;
	RygelMediaResourcePrivate * priv;
	gchar** play_speeds;
	gint play_speeds_length1;
};

struct _RygelMediaResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaResourcePrivate {
	gchar* name;
	gchar* _uri;
	gchar* _import_uri;
	gchar* _extension;
	gint64 _size;
	gint64 _cleartext_size;
	glong _duration;
	gint _bitrate;
	gint _bits_per_sample;
	gint _color_depth;
	gint _width;
	gint _height;
	gint _audio_channels;
	gint _sample_freq;
	gchar* _protocol;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _network;
	GUPnPDLNAConversion _dlna_conversion;
	GUPnPDLNAFlags _dlna_flags;
	GUPnPDLNAOperation _dlna_operation;
};

static gint RygelMediaResource_private_offset;
static gpointer rygel_media_resource_parent_class = NULL;

GType rygel_media_resource_get_type (void) G_GNUC_CONST;
RygelMediaResource* rygel_media_resource_new (const gchar* name);
RygelMediaResource* rygel_media_resource_construct (GType object_type,
                                                    const gchar* name);
RygelMediaResource* rygel_media_resource_new_from_resource (const gchar* name,
                                                            RygelMediaResource* that);
RygelMediaResource* rygel_media_resource_construct_from_resource (GType object_type,
                                                                  const gchar* name,
                                                                  RygelMediaResource* that);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
void rygel_media_resource_set_uri (RygelMediaResource* self,
                                   const gchar* value);
const gchar* rygel_media_resource_get_import_uri (RygelMediaResource* self);
void rygel_media_resource_set_import_uri (RygelMediaResource* self,
                                          const gchar* value);
const gchar* rygel_media_resource_get_extension (RygelMediaResource* self);
void rygel_media_resource_set_extension (RygelMediaResource* self,
                                         const gchar* value);
gint64 rygel_media_resource_get_size (RygelMediaResource* self);
void rygel_media_resource_set_size (RygelMediaResource* self,
                                    gint64 value);
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
void rygel_media_resource_set_cleartext_size (RygelMediaResource* self,
                                              gint64 value);
glong rygel_media_resource_get_duration (RygelMediaResource* self);
void rygel_media_resource_set_duration (RygelMediaResource* self,
                                        glong value);
gint rygel_media_resource_get_bitrate (RygelMediaResource* self);
void rygel_media_resource_set_bitrate (RygelMediaResource* self,
                                       gint value);
gint rygel_media_resource_get_bits_per_sample (RygelMediaResource* self);
void rygel_media_resource_set_bits_per_sample (RygelMediaResource* self,
                                               gint value);
gint rygel_media_resource_get_color_depth (RygelMediaResource* self);
void rygel_media_resource_set_color_depth (RygelMediaResource* self,
                                           gint value);
gint rygel_media_resource_get_width (RygelMediaResource* self);
void rygel_media_resource_set_width (RygelMediaResource* self,
                                     gint value);
gint rygel_media_resource_get_height (RygelMediaResource* self);
void rygel_media_resource_set_height (RygelMediaResource* self,
                                      gint value);
gint rygel_media_resource_get_audio_channels (RygelMediaResource* self);
void rygel_media_resource_set_audio_channels (RygelMediaResource* self,
                                              gint value);
gint rygel_media_resource_get_sample_freq (RygelMediaResource* self);
void rygel_media_resource_set_sample_freq (RygelMediaResource* self,
                                           gint value);
const gchar* rygel_media_resource_get_protocol (RygelMediaResource* self);
void rygel_media_resource_set_protocol (RygelMediaResource* self,
                                        const gchar* value);
const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self);
void rygel_media_resource_set_mime_type (RygelMediaResource* self,
                                         const gchar* value);
const gchar* rygel_media_resource_get_dlna_profile (RygelMediaResource* self);
void rygel_media_resource_set_dlna_profile (RygelMediaResource* self,
                                            const gchar* value);
const gchar* rygel_media_resource_get_network (RygelMediaResource* self);
void rygel_media_resource_set_network (RygelMediaResource* self,
                                       const gchar* value);
static gchar** _vala_array_dup2 (gchar** self,
                          int length);
GUPnPDLNAConversion rygel_media_resource_get_dlna_conversion (RygelMediaResource* self);
void rygel_media_resource_set_dlna_conversion (RygelMediaResource* self,
                                               GUPnPDLNAConversion value);
GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self,
                                          GUPnPDLNAFlags value);
GUPnPDLNAOperation rygel_media_resource_get_dlna_operation (RygelMediaResource* self);
void rygel_media_resource_set_dlna_operation (RygelMediaResource* self,
                                              GUPnPDLNAOperation value);
RygelMediaResource* rygel_media_resource_new_from_didl_lite_resource (const gchar* name,
                                                                      GUPnPDIDLLiteResource* didl_resource);
RygelMediaResource* rygel_media_resource_construct_from_didl_lite_resource (GType object_type,
                                                                            const gchar* name,
                                                                            GUPnPDIDLLiteResource* didl_resource);
static gchar** _vala_array_dup3 (gchar** self,
                          int length);
RygelMediaResource* rygel_media_resource_dup (RygelMediaResource* self);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self,
                                                       GUPnPDIDLLiteResource* didl_resource,
                                                       GHashTable* replacements);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs,
                                              const gchar* source_string);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self,
                                                           GHashTable* replacements);
void rygel_media_resource_set_protocol_info (RygelMediaResource* self,
                                             GUPnPProtocolInfo* pi);
static gchar** _vala_array_dup4 (gchar** self,
                          int length);
gboolean rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_operation_mode_set (RygelMediaResource* self,
                                                          glong flags);
gboolean rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_protocol_flag_set (RygelMediaResource* self,
                                                         glong flags);
gboolean rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_cleartext_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_full_cleartext_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_link_protection_enabled (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_content (RygelMediaResource* self);
gchar* rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self);
gboolean rygel_media_resource_supports_transfer_mode (RygelMediaResource* self,
                                                      const gchar* transfer_mode);
gboolean rygel_media_resource_is_streamable (RygelMediaResource* self);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_media_resource_supports_playspeed (RygelMediaResource* self);
gchar* rygel_media_resource_to_string (RygelMediaResource* self);
static void rygel_media_resource_finalize (GObject * obj);
static void _vala_rygel_media_resource_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_rygel_media_resource_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_media_resource_get_instance_private (RygelMediaResource* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaResource_private_offset);
}

RygelMediaResource*
rygel_media_resource_construct (GType object_type,
                                const gchar* name)
{
	RygelMediaResource * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	return self;
}

RygelMediaResource*
rygel_media_resource_new (const gchar* name)
{
	return rygel_media_resource_construct (RYGEL_TYPE_MEDIA_RESOURCE, name);
}

/**
     * Copy constructor
     */
static gchar**
_vala_array_dup2 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

RygelMediaResource*
rygel_media_resource_construct_from_resource (GType object_type,
                                              const gchar* name,
                                              RygelMediaResource* that)
{
	RygelMediaResource * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	glong _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GUPnPDLNAConversion _tmp20_;
	GUPnPDLNAFlags _tmp21_;
	GUPnPDLNAOperation _tmp22_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (that != NULL, NULL);
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = that->priv->_uri;
	rygel_media_resource_set_uri (self, _tmp1_);
	_tmp2_ = that->priv->_import_uri;
	rygel_media_resource_set_import_uri (self, _tmp2_);
	_tmp3_ = that->priv->_extension;
	rygel_media_resource_set_extension (self, _tmp3_);
	_tmp4_ = that->priv->_size;
	rygel_media_resource_set_size (self, _tmp4_);
	_tmp5_ = that->priv->_cleartext_size;
	rygel_media_resource_set_cleartext_size (self, _tmp5_);
	_tmp6_ = that->priv->_duration;
	rygel_media_resource_set_duration (self, _tmp6_);
	_tmp7_ = that->priv->_bitrate;
	rygel_media_resource_set_bitrate (self, _tmp7_);
	_tmp8_ = that->priv->_bits_per_sample;
	rygel_media_resource_set_bits_per_sample (self, _tmp8_);
	_tmp9_ = that->priv->_color_depth;
	rygel_media_resource_set_color_depth (self, _tmp9_);
	_tmp10_ = that->priv->_width;
	rygel_media_resource_set_width (self, _tmp10_);
	_tmp11_ = that->priv->_height;
	rygel_media_resource_set_height (self, _tmp11_);
	_tmp12_ = that->priv->_audio_channels;
	rygel_media_resource_set_audio_channels (self, _tmp12_);
	_tmp13_ = that->priv->_sample_freq;
	rygel_media_resource_set_sample_freq (self, _tmp13_);
	_tmp14_ = that->priv->_protocol;
	rygel_media_resource_set_protocol (self, _tmp14_);
	_tmp15_ = that->priv->_mime_type;
	rygel_media_resource_set_mime_type (self, _tmp15_);
	_tmp16_ = that->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (self, _tmp16_);
	_tmp17_ = that->priv->_network;
	rygel_media_resource_set_network (self, _tmp17_);
	_tmp18_ = that->play_speeds;
	_tmp18__length1 = that->play_speeds_length1;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup2 (_tmp18_, _tmp18__length1) : ((gpointer) _tmp18_);
	_tmp19__length1 = _tmp18__length1;
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
	self->play_speeds = _tmp19_;
	self->play_speeds_length1 = _tmp19__length1;
	_tmp20_ = that->priv->_dlna_conversion;
	rygel_media_resource_set_dlna_conversion (self, _tmp20_);
	_tmp21_ = that->priv->_dlna_flags;
	rygel_media_resource_set_dlna_flags (self, _tmp21_);
	_tmp22_ = that->priv->_dlna_operation;
	rygel_media_resource_set_dlna_operation (self, _tmp22_);
	return self;
}

RygelMediaResource*
rygel_media_resource_new_from_resource (const gchar* name,
                                        RygelMediaResource* that)
{
	return rygel_media_resource_construct_from_resource (RYGEL_TYPE_MEDIA_RESOURCE, name, that);
}

static gchar**
_vala_array_dup3 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

RygelMediaResource*
rygel_media_resource_construct_from_didl_lite_resource (GType object_type,
                                                        const gchar* name,
                                                        GUPnPDIDLLiteResource* didl_resource)
{
	RygelMediaResource * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	glong _tmp7_;
	glong _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GUPnPProtocolInfo* _tmp23_;
	GUPnPProtocolInfo* _tmp24_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (didl_resource != NULL, NULL);
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = gupnp_didl_lite_resource_get_uri (didl_resource);
	_tmp2_ = _tmp1_;
	rygel_media_resource_set_uri (self, _tmp2_);
	_tmp3_ = gupnp_didl_lite_resource_get_size64 (didl_resource);
	_tmp4_ = _tmp3_;
	rygel_media_resource_set_size (self, _tmp4_);
	_tmp5_ = gupnp_didl_lite_resource_get_cleartext_size (didl_resource);
	_tmp6_ = _tmp5_;
	rygel_media_resource_set_cleartext_size (self, _tmp6_);
	_tmp7_ = gupnp_didl_lite_resource_get_duration (didl_resource);
	_tmp8_ = _tmp7_;
	rygel_media_resource_set_duration (self, _tmp8_);
	_tmp9_ = gupnp_didl_lite_resource_get_bitrate (didl_resource);
	_tmp10_ = _tmp9_;
	rygel_media_resource_set_bitrate (self, _tmp10_);
	_tmp11_ = gupnp_didl_lite_resource_get_bits_per_sample (didl_resource);
	_tmp12_ = _tmp11_;
	rygel_media_resource_set_bits_per_sample (self, _tmp12_);
	_tmp13_ = gupnp_didl_lite_resource_get_color_depth (didl_resource);
	_tmp14_ = _tmp13_;
	rygel_media_resource_set_color_depth (self, _tmp14_);
	_tmp15_ = gupnp_didl_lite_resource_get_width (didl_resource);
	_tmp16_ = _tmp15_;
	rygel_media_resource_set_width (self, _tmp16_);
	_tmp17_ = gupnp_didl_lite_resource_get_height (didl_resource);
	_tmp18_ = _tmp17_;
	rygel_media_resource_set_height (self, _tmp18_);
	_tmp19_ = gupnp_didl_lite_resource_get_audio_channels (didl_resource);
	_tmp20_ = _tmp19_;
	rygel_media_resource_set_audio_channels (self, _tmp20_);
	_tmp21_ = gupnp_didl_lite_resource_get_sample_freq (didl_resource);
	_tmp22_ = _tmp21_;
	rygel_media_resource_set_sample_freq (self, _tmp22_);
	_tmp23_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
	_tmp24_ = _tmp23_;
	if (_tmp24_ != NULL) {
		GUPnPProtocolInfo* _tmp25_;
		GUPnPProtocolInfo* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		GUPnPProtocolInfo* _tmp29_;
		GUPnPProtocolInfo* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		GUPnPProtocolInfo* _tmp33_;
		GUPnPProtocolInfo* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		GUPnPProtocolInfo* _tmp37_;
		GUPnPProtocolInfo* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		GUPnPProtocolInfo* _tmp41_;
		GUPnPProtocolInfo* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		gchar** _tmp44_;
		gint _tmp44__length1;
		gchar** _tmp45_;
		gint _tmp45__length1;
		GUPnPProtocolInfo* _tmp46_;
		GUPnPProtocolInfo* _tmp47_;
		GUPnPDLNAConversion _tmp48_;
		GUPnPDLNAConversion _tmp49_;
		GUPnPProtocolInfo* _tmp50_;
		GUPnPProtocolInfo* _tmp51_;
		GUPnPDLNAFlags _tmp52_;
		GUPnPDLNAFlags _tmp53_;
		GUPnPProtocolInfo* _tmp54_;
		GUPnPProtocolInfo* _tmp55_;
		GUPnPDLNAOperation _tmp56_;
		GUPnPDLNAOperation _tmp57_;
		_tmp25_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp26_ = _tmp25_;
		_tmp27_ = gupnp_protocol_info_get_protocol (_tmp26_);
		_tmp28_ = _tmp27_;
		rygel_media_resource_set_protocol (self, _tmp28_);
		_tmp29_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp30_ = _tmp29_;
		_tmp31_ = gupnp_protocol_info_get_mime_type (_tmp30_);
		_tmp32_ = _tmp31_;
		rygel_media_resource_set_mime_type (self, _tmp32_);
		_tmp33_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp34_ = _tmp33_;
		_tmp35_ = gupnp_protocol_info_get_dlna_profile (_tmp34_);
		_tmp36_ = _tmp35_;
		rygel_media_resource_set_dlna_profile (self, _tmp36_);
		_tmp37_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp38_ = _tmp37_;
		_tmp39_ = gupnp_protocol_info_get_network (_tmp38_);
		_tmp40_ = _tmp39_;
		rygel_media_resource_set_network (self, _tmp40_);
		_tmp41_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp42_ = _tmp41_;
		_tmp43_ = gupnp_protocol_info_get_play_speeds (_tmp42_);
		_tmp43__length1 = _vala_array_length (_tmp43_);
		_tmp44_ = _tmp43_;
		_tmp44__length1 = _tmp43__length1;
		_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup3 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
		_tmp45__length1 = _tmp44__length1;
		self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
		self->play_speeds = _tmp45_;
		self->play_speeds_length1 = _tmp45__length1;
		_tmp46_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp47_ = _tmp46_;
		_tmp48_ = gupnp_protocol_info_get_dlna_conversion (_tmp47_);
		_tmp49_ = _tmp48_;
		rygel_media_resource_set_dlna_conversion (self, _tmp49_);
		_tmp50_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp51_ = _tmp50_;
		_tmp52_ = gupnp_protocol_info_get_dlna_flags (_tmp51_);
		_tmp53_ = _tmp52_;
		rygel_media_resource_set_dlna_flags (self, _tmp53_);
		_tmp54_ = gupnp_didl_lite_resource_get_protocol_info (didl_resource);
		_tmp55_ = _tmp54_;
		_tmp56_ = gupnp_protocol_info_get_dlna_operation (_tmp55_);
		_tmp57_ = _tmp56_;
		rygel_media_resource_set_dlna_operation (self, _tmp57_);
	}
	return self;
}

RygelMediaResource*
rygel_media_resource_new_from_didl_lite_resource (const gchar* name,
                                                  GUPnPDIDLLiteResource* didl_resource)
{
	return rygel_media_resource_construct_from_didl_lite_resource (RYGEL_TYPE_MEDIA_RESOURCE, name, didl_resource);
}

RygelMediaResource*
rygel_media_resource_dup (RygelMediaResource* self)
{
	RygelMediaResource* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaResource* _tmp2_;
	RygelMediaResource* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_resource_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_media_resource_new_from_resource (_tmp1_, self);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
rygel_media_resource_get_name (RygelMediaResource* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GUPnPDIDLLiteResource*
rygel_media_resource_serialize (RygelMediaResource* self,
                                GUPnPDIDLLiteResource* didl_resource,
                                GHashTable* replacements)
{
	GUPnPDIDLLiteResource* result = NULL;
	gint64 _tmp10_;
	gint64 _tmp11_;
	glong _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GUPnPProtocolInfo* _tmp20_;
	GUPnPProtocolInfo* _tmp21_;
	GUPnPDIDLLiteResource* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (didl_resource != NULL, NULL);
	if (replacements == NULL) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->_import_uri;
		if (_tmp0_ != NULL) {
			const gchar* _tmp1_;
			_tmp1_ = self->priv->_import_uri;
			gupnp_didl_lite_resource_set_import_uri (didl_resource, _tmp1_);
		} else {
			const gchar* _tmp2_;
			_tmp2_ = self->priv->_uri;
			gupnp_didl_lite_resource_set_uri (didl_resource, _tmp2_);
		}
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_import_uri;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = self->priv->_import_uri;
			_tmp5_ = rygel_media_object_apply_replacements (replacements, _tmp4_);
			_tmp6_ = _tmp5_;
			gupnp_didl_lite_resource_set_import_uri (didl_resource, _tmp6_);
			_g_free0 (_tmp6_);
		} else {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = self->priv->_uri;
			_tmp8_ = rygel_media_object_apply_replacements (replacements, _tmp7_);
			_tmp9_ = _tmp8_;
			gupnp_didl_lite_resource_set_uri (didl_resource, _tmp9_);
			_g_free0 (_tmp9_);
		}
	}
	_tmp10_ = self->priv->_size;
	gupnp_didl_lite_resource_set_size64 (didl_resource, _tmp10_);
	_tmp11_ = self->priv->_cleartext_size;
	gupnp_didl_lite_resource_set_cleartext_size (didl_resource, _tmp11_);
	_tmp12_ = self->priv->_duration;
	gupnp_didl_lite_resource_set_duration (didl_resource, _tmp12_);
	_tmp13_ = self->priv->_bitrate;
	gupnp_didl_lite_resource_set_bitrate (didl_resource, _tmp13_);
	_tmp14_ = self->priv->_bits_per_sample;
	gupnp_didl_lite_resource_set_bits_per_sample (didl_resource, _tmp14_);
	_tmp15_ = self->priv->_color_depth;
	gupnp_didl_lite_resource_set_color_depth (didl_resource, _tmp15_);
	_tmp16_ = self->priv->_width;
	gupnp_didl_lite_resource_set_width (didl_resource, _tmp16_);
	_tmp17_ = self->priv->_height;
	gupnp_didl_lite_resource_set_height (didl_resource, _tmp17_);
	_tmp18_ = self->priv->_audio_channels;
	gupnp_didl_lite_resource_set_audio_channels (didl_resource, _tmp18_);
	_tmp19_ = self->priv->_sample_freq;
	gupnp_didl_lite_resource_set_sample_freq (didl_resource, _tmp19_);
	_tmp20_ = rygel_media_resource_get_protocol_info (self, NULL);
	_tmp21_ = _tmp20_;
	gupnp_didl_lite_resource_set_protocol_info (didl_resource, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = _g_object_ref0 (didl_resource);
	result = _tmp22_;
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

void
rygel_media_resource_set_protocol_info (RygelMediaResource* self,
                                        GUPnPProtocolInfo* pi)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPDLNAConversion _tmp8_;
	GUPnPDLNAConversion _tmp9_;
	GUPnPDLNAOperation _tmp10_;
	GUPnPDLNAOperation _tmp11_;
	GUPnPDLNAFlags _tmp12_;
	GUPnPDLNAFlags _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pi != NULL);
	_tmp0_ = gupnp_protocol_info_get_protocol (pi);
	_tmp1_ = _tmp0_;
	rygel_media_resource_set_protocol (self, _tmp1_);
	_tmp2_ = gupnp_protocol_info_get_network (pi);
	_tmp3_ = _tmp2_;
	rygel_media_resource_set_network (self, _tmp3_);
	_tmp4_ = gupnp_protocol_info_get_mime_type (pi);
	_tmp5_ = _tmp4_;
	rygel_media_resource_set_mime_type (self, _tmp5_);
	_tmp6_ = gupnp_protocol_info_get_dlna_profile (pi);
	_tmp7_ = _tmp6_;
	rygel_media_resource_set_dlna_profile (self, _tmp7_);
	_tmp8_ = gupnp_protocol_info_get_dlna_conversion (pi);
	_tmp9_ = _tmp8_;
	rygel_media_resource_set_dlna_conversion (self, _tmp9_);
	_tmp10_ = gupnp_protocol_info_get_dlna_operation (pi);
	_tmp11_ = _tmp10_;
	rygel_media_resource_set_dlna_operation (self, _tmp11_);
	_tmp12_ = gupnp_protocol_info_get_dlna_flags (pi);
	_tmp13_ = _tmp12_;
	rygel_media_resource_set_dlna_flags (self, _tmp13_);
	_tmp14_ = gupnp_protocol_info_get_play_speeds (pi);
	_tmp14__length1 = _vala_array_length (_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup4 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp15__length1;
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
	self->play_speeds = _tmp16_;
	self->play_speeds_length1 = _tmp16__length1;
}

GUPnPProtocolInfo*
rygel_media_resource_get_protocol_info (RygelMediaResource* self,
                                        GHashTable* replacements)
{
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* new_pi = NULL;
	GUPnPProtocolInfo* _tmp0_;
	GUPnPProtocolInfo* _tmp1_;
	const gchar* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	const gchar* _tmp4_;
	GUPnPProtocolInfo* _tmp11_;
	const gchar* _tmp12_;
	GUPnPProtocolInfo* _tmp13_;
	GUPnPDLNAConversion _tmp14_;
	GUPnPProtocolInfo* _tmp15_;
	GUPnPDLNAOperation _tmp16_;
	GUPnPProtocolInfo* _tmp17_;
	GUPnPDLNAFlags _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gupnp_protocol_info_new ();
	new_pi = _tmp0_;
	_tmp1_ = new_pi;
	_tmp2_ = self->priv->_protocol;
	gupnp_protocol_info_set_protocol (_tmp1_, _tmp2_);
	_tmp3_ = new_pi;
	_tmp4_ = self->priv->_network;
	gupnp_protocol_info_set_network (_tmp3_, _tmp4_);
	if (replacements == NULL) {
		GUPnPProtocolInfo* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = new_pi;
		_tmp6_ = self->priv->_mime_type;
		gupnp_protocol_info_set_mime_type (_tmp5_, _tmp6_);
	} else {
		GUPnPProtocolInfo* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = new_pi;
		_tmp8_ = self->priv->_mime_type;
		_tmp9_ = rygel_media_object_apply_replacements (replacements, _tmp8_);
		_tmp10_ = _tmp9_;
		gupnp_protocol_info_set_mime_type (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = new_pi;
	_tmp12_ = self->priv->_dlna_profile;
	gupnp_protocol_info_set_dlna_profile (_tmp11_, _tmp12_);
	_tmp13_ = new_pi;
	_tmp14_ = self->priv->_dlna_conversion;
	gupnp_protocol_info_set_dlna_conversion (_tmp13_, _tmp14_);
	_tmp15_ = new_pi;
	_tmp16_ = self->priv->_dlna_operation;
	gupnp_protocol_info_set_dlna_operation (_tmp15_, _tmp16_);
	_tmp17_ = new_pi;
	_tmp18_ = self->priv->_dlna_flags;
	gupnp_protocol_info_set_dlna_flags (_tmp17_, _tmp18_);
	_tmp19_ = self->play_speeds;
	_tmp19__length1 = self->play_speeds_length1;
	if (_tmp19_ != NULL) {
		GUPnPProtocolInfo* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp20_ = new_pi;
		_tmp21_ = self->play_speeds;
		_tmp21__length1 = self->play_speeds_length1;
		gupnp_protocol_info_set_play_speeds (_tmp20_, _tmp21_);
	}
	result = new_pi;
	return result;
}

gboolean
rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_RANGE);
	return result;
}

gboolean
rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_TIMESEEK);
	return result;
}

gboolean
rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BYTE_BASED_SEEK);
	return result;
}

gboolean
rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_TIME_BASED_SEEK);
	return result;
}

gboolean
rygel_media_resource_supports_limited_cleartext_byte_seek (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK);
	return result;
}

gboolean
rygel_media_resource_supports_full_cleartext_byte_seek (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL);
	return result;
}

gboolean
rygel_media_resource_is_link_protection_enabled (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LINK_PROTECTED_CONTENT);
	return result;
}

gboolean
rygel_media_resource_is_dlna_content (RygelMediaResource* self)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_ != NULL;
	return result;
}

gchar*
rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("Streaming");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("Interactive");
		result = _tmp1_;
		return result;
	}
}

gboolean
rygel_media_resource_supports_transfer_mode (RygelMediaResource* self,
                                             const gchar* transfer_mode)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (transfer_mode != NULL, FALSE);
	if (!rygel_media_resource_is_dlna_content (self)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = transfer_mode;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Streaming")))) {
		switch (0) {
			default:
			{
				result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Interactive")))) {
		switch (0) {
			default:
			{
				result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Background")))) {
		switch (0) {
			default:
			{
				result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}

gboolean
rygel_media_resource_is_streamable (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	return result;
}

gboolean
rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) (GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL | GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK));
	return result;
}

gboolean
rygel_media_resource_supports_playspeed (RygelMediaResource* self)
{
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->play_speeds;
	_tmp0__length1 = self->play_speeds_length1;
	result = _tmp0__length1 > 0;
	return result;
}

gboolean
rygel_media_resource_is_dlna_protocol_flag_set (RygelMediaResource* self,
                                                glong flags)
{
	gboolean result = FALSE;
	GUPnPDLNAFlags _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dlna_flags;
	result = (_tmp0_ & flags) != 0;
	return result;
}

gboolean
rygel_media_resource_is_dlna_operation_mode_set (RygelMediaResource* self,
                                                 glong flags)
{
	gboolean result = FALSE;
	GUPnPDLNAOperation _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dlna_operation;
	result = (_tmp0_ & flags) != 0;
	return result;
}

gchar*
rygel_media_resource_to_string (RygelMediaResource* self)
{
	gchar* result = NULL;
	GString* strbuf = NULL;
	const gchar* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp10_;
	glong _tmp17_;
	gint _tmp24_;
	gint _tmp31_;
	gint _tmp38_;
	gint _tmp45_;
	gint _tmp52_;
	gint _tmp59_;
	gint _tmp66_;
	const gchar* _tmp73_;
	const gchar* _tmp78_ = NULL;
	const gchar* _tmp79_;
	GString* _tmp81_;
	GString* _tmp82_;
	GString* _tmp83_;
	const gchar* _tmp84_ = NULL;
	const gchar* _tmp85_;
	GString* _tmp87_;
	GString* _tmp88_;
	GString* _tmp89_;
	const gchar* _tmp90_ = NULL;
	const gchar* _tmp91_;
	GString* _tmp93_;
	GString* _tmp94_;
	GString* _tmp95_;
	GString* _tmp96_;
	GUPnPDLNAFlags _tmp97_;
	GString* _tmp111_;
	GString* _tmp112_;
	GUPnPDLNAConversion _tmp113_;
	GUPnPDLNAOperation _tmp116_;
	gchar** _tmp123_;
	gint _tmp123__length1;
	const gchar* _tmp132_ = NULL;
	const gchar* _tmp133_;
	GString* _tmp135_;
	GString* _tmp136_;
	GString* _tmp137_;
	GString* _tmp138_;
	const gchar* _tmp139_;
	gchar* _tmp140_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_string_new (_tmp0_);
	strbuf = _tmp1_;
	_tmp2_ = strbuf;
	g_string_append_unichar (_tmp2_, (gunichar) '(');
	_tmp3_ = self->priv->_size;
	if (_tmp3_ >= ((gint64) 0)) {
		GString* _tmp4_;
		GString* _tmp5_;
		gint64 _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GString* _tmp9_;
		_tmp4_ = strbuf;
		_tmp5_ = g_string_append (_tmp4_, "size ");
		_tmp6_ = self->priv->_size;
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_string_append (_tmp5_, _tmp8_);
		g_string_append_unichar (_tmp9_, (gunichar) ',');
		_g_free0 (_tmp8_);
	}
	_tmp10_ = self->priv->_cleartext_size;
	if (_tmp10_ >= ((gint64) 0)) {
		GString* _tmp11_;
		GString* _tmp12_;
		gint64 _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GString* _tmp16_;
		_tmp11_ = strbuf;
		_tmp12_ = g_string_append (_tmp11_, "cleartextsize ");
		_tmp13_ = self->priv->_cleartext_size;
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_string_append (_tmp12_, _tmp15_);
		g_string_append_unichar (_tmp16_, (gunichar) ',');
		_g_free0 (_tmp15_);
	}
	_tmp17_ = self->priv->_duration;
	if (_tmp17_ >= ((glong) 0)) {
		GString* _tmp18_;
		GString* _tmp19_;
		glong _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GString* _tmp23_;
		_tmp18_ = strbuf;
		_tmp19_ = g_string_append (_tmp18_, "duration ");
		_tmp20_ = self->priv->_duration;
		_tmp21_ = g_strdup_printf ("%li", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_string_append (_tmp19_, _tmp22_);
		g_string_append_unichar (_tmp23_, (gunichar) ',');
		_g_free0 (_tmp22_);
	}
	_tmp24_ = self->priv->_bitrate;
	if (_tmp24_ >= 0) {
		GString* _tmp25_;
		GString* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GString* _tmp30_;
		_tmp25_ = strbuf;
		_tmp26_ = g_string_append (_tmp25_, "bitrate ");
		_tmp27_ = self->priv->_bitrate;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_string_append (_tmp26_, _tmp29_);
		g_string_append_unichar (_tmp30_, (gunichar) ',');
		_g_free0 (_tmp29_);
	}
	_tmp31_ = self->priv->_bits_per_sample;
	if (_tmp31_ >= 0) {
		GString* _tmp32_;
		GString* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GString* _tmp37_;
		_tmp32_ = strbuf;
		_tmp33_ = g_string_append (_tmp32_, "bits_per_sample ");
		_tmp34_ = self->priv->_bits_per_sample;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_string_append (_tmp33_, _tmp36_);
		g_string_append_unichar (_tmp37_, (gunichar) ',');
		_g_free0 (_tmp36_);
	}
	_tmp38_ = self->priv->_width;
	if (_tmp38_ >= 0) {
		GString* _tmp39_;
		GString* _tmp40_;
		gint _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GString* _tmp44_;
		_tmp39_ = strbuf;
		_tmp40_ = g_string_append (_tmp39_, "width ");
		_tmp41_ = self->priv->_width;
		_tmp42_ = g_strdup_printf ("%i", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_string_append (_tmp40_, _tmp43_);
		g_string_append_unichar (_tmp44_, (gunichar) ',');
		_g_free0 (_tmp43_);
	}
	_tmp45_ = self->priv->_height;
	if (_tmp45_ >= 0) {
		GString* _tmp46_;
		GString* _tmp47_;
		gint _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GString* _tmp51_;
		_tmp46_ = strbuf;
		_tmp47_ = g_string_append (_tmp46_, "height ");
		_tmp48_ = self->priv->_height;
		_tmp49_ = g_strdup_printf ("%i", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_string_append (_tmp47_, _tmp50_);
		g_string_append_unichar (_tmp51_, (gunichar) ',');
		_g_free0 (_tmp50_);
	}
	_tmp52_ = self->priv->_color_depth;
	if (_tmp52_ >= 0) {
		GString* _tmp53_;
		GString* _tmp54_;
		gint _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		GString* _tmp58_;
		_tmp53_ = strbuf;
		_tmp54_ = g_string_append (_tmp53_, "color_depth ");
		_tmp55_ = self->priv->_color_depth;
		_tmp56_ = g_strdup_printf ("%i", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_string_append (_tmp54_, _tmp57_);
		g_string_append_unichar (_tmp58_, (gunichar) ',');
		_g_free0 (_tmp57_);
	}
	_tmp59_ = self->priv->_audio_channels;
	if (_tmp59_ >= 0) {
		GString* _tmp60_;
		GString* _tmp61_;
		gint _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		GString* _tmp65_;
		_tmp60_ = strbuf;
		_tmp61_ = g_string_append (_tmp60_, "audio_channels ");
		_tmp62_ = self->priv->_audio_channels;
		_tmp63_ = g_strdup_printf ("%i", _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_string_append (_tmp61_, _tmp64_);
		g_string_append_unichar (_tmp65_, (gunichar) ',');
		_g_free0 (_tmp64_);
	}
	_tmp66_ = self->priv->_sample_freq;
	if (_tmp66_ >= 0) {
		GString* _tmp67_;
		GString* _tmp68_;
		gint _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		GString* _tmp72_;
		_tmp67_ = strbuf;
		_tmp68_ = g_string_append (_tmp67_, "sample_freq ");
		_tmp69_ = self->priv->_sample_freq;
		_tmp70_ = g_strdup_printf ("%i", _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_string_append (_tmp68_, _tmp71_);
		g_string_append_unichar (_tmp72_, (gunichar) ',');
		_g_free0 (_tmp71_);
	}
	_tmp73_ = self->priv->_network;
	if (_tmp73_ != NULL) {
		GString* _tmp74_;
		GString* _tmp75_;
		const gchar* _tmp76_;
		GString* _tmp77_;
		_tmp74_ = strbuf;
		_tmp75_ = g_string_append (_tmp74_, "network ");
		_tmp76_ = self->priv->_network;
		_tmp77_ = g_string_append (_tmp75_, _tmp76_);
		g_string_append_unichar (_tmp77_, (gunichar) ',');
	}
	_tmp79_ = self->priv->_protocol;
	if (_tmp79_ == NULL) {
		_tmp78_ = "null";
	} else {
		const gchar* _tmp80_;
		_tmp80_ = self->priv->_protocol;
		_tmp78_ = _tmp80_;
	}
	_tmp81_ = strbuf;
	_tmp82_ = g_string_append (_tmp81_, "protocol ");
	_tmp83_ = g_string_append (_tmp82_, _tmp78_);
	g_string_append_unichar (_tmp83_, (gunichar) ',');
	_tmp85_ = self->priv->_mime_type;
	if (_tmp85_ == NULL) {
		_tmp84_ = "null";
	} else {
		const gchar* _tmp86_;
		_tmp86_ = self->priv->_mime_type;
		_tmp84_ = _tmp86_;
	}
	_tmp87_ = strbuf;
	_tmp88_ = g_string_append (_tmp87_, "mime_type ");
	_tmp89_ = g_string_append (_tmp88_, _tmp84_);
	g_string_append_unichar (_tmp89_, (gunichar) ',');
	_tmp91_ = self->priv->_dlna_profile;
	if (_tmp91_ == NULL) {
		_tmp90_ = "null";
	} else {
		const gchar* _tmp92_;
		_tmp92_ = self->priv->_dlna_profile;
		_tmp90_ = _tmp92_;
	}
	_tmp93_ = strbuf;
	_tmp94_ = g_string_append (_tmp93_, "dlna_profile ");
	_tmp95_ = g_string_append (_tmp94_, _tmp90_);
	g_string_append_unichar (_tmp95_, (gunichar) ',');
	_tmp96_ = strbuf;
	_tmp97_ = self->priv->_dlna_flags;
	g_string_append_printf (_tmp96_, "dlna_flags %.8X [", (guint) _tmp97_);
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_SENDER_PACED)) {
		GString* _tmp98_;
		_tmp98_ = strbuf;
		g_string_append (_tmp98_, "sp-flag ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_TIME_BASED_SEEK)) {
		GString* _tmp99_;
		_tmp99_ = strbuf;
		g_string_append (_tmp99_, "lop-time ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BYTE_BASED_SEEK)) {
		GString* _tmp100_;
		_tmp100_ = strbuf;
		g_string_append (_tmp100_, "lop-byte ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_S0_INCREASE)) {
		GString* _tmp101_;
		_tmp101_ = strbuf;
		g_string_append (_tmp101_, "s0-increase ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_SN_INCREASE)) {
		GString* _tmp102_;
		_tmp102_ = strbuf;
		g_string_append (_tmp102_, "sn-increase ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE)) {
		GString* _tmp103_;
		_tmp103_ = strbuf;
		g_string_append (_tmp103_, "streaming ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE)) {
		GString* _tmp104_;
		_tmp104_ = strbuf;
		g_string_append (_tmp104_, "interactive ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE)) {
		GString* _tmp105_;
		_tmp105_ = strbuf;
		g_string_append (_tmp105_, "background ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CONNECTION_STALL)) {
		GString* _tmp106_;
		_tmp106_ = strbuf;
		g_string_append (_tmp106_, "stall ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_DLNA_V15)) {
		GString* _tmp107_;
		_tmp107_ = strbuf;
		g_string_append (_tmp107_, "v1.5 ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LINK_PROTECTED_CONTENT)) {
		GString* _tmp108_;
		_tmp108_ = strbuf;
		g_string_append (_tmp108_, "link-protected ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL)) {
		GString* _tmp109_;
		_tmp109_ = strbuf;
		g_string_append (_tmp109_, "cleartext-full ");
	}
	if (rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK)) {
		GString* _tmp110_;
		_tmp110_ = strbuf;
		g_string_append (_tmp110_, "cleartext-lop ");
	}
	_tmp111_ = strbuf;
	_tmp112_ = strbuf;
	g_string_overwrite (_tmp111_, (gsize) (_tmp112_->len - 1), "],");
	_tmp113_ = self->priv->_dlna_conversion;
	if (_tmp113_ != GUPNP_DLNA_CONVERSION_NONE) {
		GString* _tmp114_;
		GUPnPDLNAConversion _tmp115_;
		_tmp114_ = strbuf;
		_tmp115_ = self->priv->_dlna_conversion;
		g_string_append_printf (_tmp114_, "dlna_conversion %1d,", (gint) _tmp115_);
	}
	_tmp116_ = self->priv->_dlna_operation;
	if (_tmp116_ != GUPNP_DLNA_OPERATION_NONE) {
		GString* _tmp117_;
		GUPnPDLNAOperation _tmp118_;
		GString* _tmp121_;
		GString* _tmp122_;
		_tmp117_ = strbuf;
		_tmp118_ = self->priv->_dlna_operation;
		g_string_append_printf (_tmp117_, "dlna_operation %.2X [", (guint) _tmp118_);
		if (rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_RANGE)) {
			GString* _tmp119_;
			_tmp119_ = strbuf;
			g_string_append (_tmp119_, "byte-seek ");
		}
		if (rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_TIMESEEK)) {
			GString* _tmp120_;
			_tmp120_ = strbuf;
			g_string_append (_tmp120_, "time-seek ");
		}
		_tmp121_ = strbuf;
		_tmp122_ = strbuf;
		g_string_overwrite (_tmp121_, (gsize) (_tmp122_->len - 1), "],");
	}
	_tmp123_ = self->play_speeds;
	_tmp123__length1 = self->play_speeds_length1;
	if (_tmp123_ != NULL) {
		GString* _tmp124_;
		gchar** _tmp125_;
		gint _tmp125__length1;
		GString* _tmp130_;
		GString* _tmp131_;
		_tmp124_ = strbuf;
		g_string_append (_tmp124_, "play_speeds [");
		_tmp125_ = self->play_speeds;
		_tmp125__length1 = self->play_speeds_length1;
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
			speed_collection = _tmp125_;
			speed_collection_length1 = _tmp125__length1;
			for (speed_it = 0; speed_it < _tmp125__length1; speed_it = speed_it + 1) {
				gchar* _tmp126_;
				gchar* speed = NULL;
				_tmp126_ = g_strdup (speed_collection[speed_it]);
				speed = _tmp126_;
				{
					GString* _tmp127_;
					const gchar* _tmp128_;
					GString* _tmp129_;
					_tmp127_ = strbuf;
					_tmp128_ = speed;
					_tmp129_ = g_string_append (_tmp127_, _tmp128_);
					g_string_append_unichar (_tmp129_, (gunichar) ',');
					_g_free0 (speed);
				}
			}
		}
		_tmp130_ = strbuf;
		_tmp131_ = strbuf;
		g_string_overwrite (_tmp130_, (gsize) (_tmp131_->len - 1), "]");
	}
	_tmp133_ = self->priv->_uri;
	if (_tmp133_ == NULL) {
		_tmp132_ = "null";
	} else {
		const gchar* _tmp134_;
		_tmp134_ = self->priv->_uri;
		_tmp132_ = _tmp134_;
	}
	_tmp135_ = strbuf;
	_tmp136_ = g_string_append (_tmp135_, ",uri ");
	g_string_append (_tmp136_, _tmp132_);
	_tmp137_ = strbuf;
	g_string_append_unichar (_tmp137_, (gunichar) ')');
	_tmp138_ = strbuf;
	_tmp139_ = _tmp138_->str;
	_tmp140_ = g_strdup (_tmp139_);
	result = _tmp140_;
	_g_string_free0 (strbuf);
	return result;
}

const gchar*
rygel_media_resource_get_uri (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_uri (RygelMediaResource* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_uri (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_URI_PROPERTY]);
	}
}

const gchar*
rygel_media_resource_get_import_uri (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_import_uri;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_import_uri (RygelMediaResource* self,
                                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_import_uri (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_import_uri);
		self->priv->_import_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY]);
	}
}

const gchar*
rygel_media_resource_get_extension (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_extension (RygelMediaResource* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_extension (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extension);
		self->priv->_extension = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY]);
	}
}

gint64
rygel_media_resource_get_size (RygelMediaResource* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_size;
	return result;
}

void
rygel_media_resource_set_size (RygelMediaResource* self,
                               gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_size (self) != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY]);
	}
}

gint64
rygel_media_resource_get_cleartext_size (RygelMediaResource* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_cleartext_size;
	return result;
}

void
rygel_media_resource_set_cleartext_size (RygelMediaResource* self,
                                         gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_cleartext_size (self) != value) {
		self->priv->_cleartext_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY]);
	}
}

glong
rygel_media_resource_get_duration (RygelMediaResource* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_duration;
	return result;
}

void
rygel_media_resource_set_duration (RygelMediaResource* self,
                                   glong value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_duration (self) != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY]);
	}
}

gint
rygel_media_resource_get_bitrate (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bitrate;
	return result;
}

void
rygel_media_resource_set_bitrate (RygelMediaResource* self,
                                  gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_bitrate (self) != value) {
		self->priv->_bitrate = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY]);
	}
}

gint
rygel_media_resource_get_bits_per_sample (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bits_per_sample;
	return result;
}

void
rygel_media_resource_set_bits_per_sample (RygelMediaResource* self,
                                          gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_bits_per_sample (self) != value) {
		self->priv->_bits_per_sample = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY]);
	}
}

gint
rygel_media_resource_get_color_depth (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color_depth;
	return result;
}

void
rygel_media_resource_set_color_depth (RygelMediaResource* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_color_depth (self) != value) {
		self->priv->_color_depth = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY]);
	}
}

gint
rygel_media_resource_get_width (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

void
rygel_media_resource_set_width (RygelMediaResource* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_width (self) != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY]);
	}
}

gint
rygel_media_resource_get_height (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
	return result;
}

void
rygel_media_resource_set_height (RygelMediaResource* self,
                                 gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_height (self) != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY]);
	}
}

gint
rygel_media_resource_get_audio_channels (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_audio_channels;
	return result;
}

void
rygel_media_resource_set_audio_channels (RygelMediaResource* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_audio_channels (self) != value) {
		self->priv->_audio_channels = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY]);
	}
}

gint
rygel_media_resource_get_sample_freq (RygelMediaResource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sample_freq;
	return result;
}

void
rygel_media_resource_set_sample_freq (RygelMediaResource* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_sample_freq (self) != value) {
		self->priv->_sample_freq = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY]);
	}
}

const gchar*
rygel_media_resource_get_protocol (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_protocol (RygelMediaResource* self,
                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_protocol (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_protocol);
		self->priv->_protocol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY]);
	}
}

const gchar*
rygel_media_resource_get_mime_type (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_mime_type (RygelMediaResource* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_mime_type (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY]);
	}
}

const gchar*
rygel_media_resource_get_dlna_profile (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_dlna_profile (RygelMediaResource* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_dlna_profile (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_dlna_profile);
		self->priv->_dlna_profile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY]);
	}
}

const gchar*
rygel_media_resource_get_network (RygelMediaResource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_network;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_network (RygelMediaResource* self,
                                  const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_network (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_network);
		self->priv->_network = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY]);
	}
}

GUPnPDLNAConversion
rygel_media_resource_get_dlna_conversion (RygelMediaResource* self)
{
	GUPnPDLNAConversion result;
	GUPnPDLNAConversion _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dlna_conversion;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_dlna_conversion (RygelMediaResource* self,
                                          GUPnPDLNAConversion value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_dlna_conversion (self) != value) {
		self->priv->_dlna_conversion = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY]);
	}
}

GUPnPDLNAFlags
rygel_media_resource_get_dlna_flags (RygelMediaResource* self)
{
	GUPnPDLNAFlags result;
	GUPnPDLNAFlags _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dlna_flags;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_dlna_flags (RygelMediaResource* self,
                                     GUPnPDLNAFlags value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_dlna_flags (self) != value) {
		self->priv->_dlna_flags = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY]);
	}
}

GUPnPDLNAOperation
rygel_media_resource_get_dlna_operation (RygelMediaResource* self)
{
	GUPnPDLNAOperation result;
	GUPnPDLNAOperation _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dlna_operation;
	result = _tmp0_;
	return result;
}

void
rygel_media_resource_set_dlna_operation (RygelMediaResource* self,
                                         GUPnPDLNAOperation value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_dlna_operation (self) != value) {
		self->priv->_dlna_operation = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY]);
	}
}

static void
rygel_media_resource_class_init (RygelMediaResourceClass * klass)
{
	rygel_media_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaResource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_resource_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_resource_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_resource_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_URI_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY] = g_param_spec_string ("import-uri", "import-uri", "import-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY] = g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY] = g_param_spec_int64 ("cleartext-size", "cleartext-size", "cleartext-size", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY] = g_param_spec_long ("duration", "duration", "duration", G_MINLONG, G_MAXLONG, (glong) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY] = g_param_spec_int ("bitrate", "bitrate", "bitrate", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY] = g_param_spec_int ("bits-per-sample", "bits-per-sample", "bits-per-sample", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY] = g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY] = g_param_spec_int ("audio-channels", "audio-channels", "audio-channels", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY] = g_param_spec_int ("sample-freq", "sample-freq", "sample-freq", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY] = g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY] = g_param_spec_string ("network", "network", "network", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY] = g_param_spec_flags ("dlna-conversion", "dlna-conversion", "dlna-conversion", gupnp_dlna_conversion_get_type (), GUPNP_DLNA_CONVERSION_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY] = g_param_spec_flags ("dlna-flags", "dlna-flags", "dlna-flags", gupnp_dlna_flags_get_type (), GUPNP_DLNA_FLAGS_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY, rygel_media_resource_properties[RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY] = g_param_spec_flags ("dlna-operation", "dlna-operation", "dlna-operation", gupnp_dlna_operation_get_type (), GUPNP_DLNA_OPERATION_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_media_resource_instance_init (RygelMediaResource * self)
{
	self->priv = rygel_media_resource_get_instance_private (self);
	self->priv->_extension = NULL;
	self->priv->_size = (gint64) -1;
	self->priv->_cleartext_size = (gint64) -1;
	self->priv->_duration = (glong) -1;
	self->priv->_bitrate = -1;
	self->priv->_bits_per_sample = -1;
	self->priv->_color_depth = -1;
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_audio_channels = -1;
	self->priv->_sample_freq = -1;
	self->priv->_protocol = NULL;
	self->priv->_mime_type = NULL;
	self->priv->_dlna_profile = NULL;
	self->priv->_network = NULL;
	self->play_speeds = NULL;
	self->play_speeds_length1 = 0;
	self->priv->_dlna_conversion = GUPNP_DLNA_CONVERSION_NONE;
	self->priv->_dlna_flags = GUPNP_DLNA_FLAGS_NONE;
	self->priv->_dlna_operation = GUPNP_DLNA_OPERATION_NONE;
}

static void
rygel_media_resource_finalize (GObject * obj)
{
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_import_uri);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_protocol);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_network);
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_media_resource_parent_class)->finalize (obj);
}

/**
 * Represents a media resource (Music, Video, Image, etc).
 */
GType
rygel_media_resource_get_type (void)
{
	static volatile gsize rygel_media_resource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_resource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaResource), 0, (GInstanceInitFunc) rygel_media_resource_instance_init, NULL };
		GType rygel_media_resource_type_id;
		rygel_media_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaResource", &g_define_type_info, 0);
		RygelMediaResource_private_offset = g_type_add_instance_private (rygel_media_resource_type_id, sizeof (RygelMediaResourcePrivate));
		g_once_init_leave (&rygel_media_resource_type_id__volatile, rygel_media_resource_type_id);
	}
	return rygel_media_resource_type_id__volatile;
}

static void
_vala_rygel_media_resource_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
	switch (property_id) {
		case RYGEL_MEDIA_RESOURCE_URI_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_uri (self));
		break;
		case RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_import_uri (self));
		break;
		case RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_extension (self));
		break;
		case RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_resource_get_size (self));
		break;
		case RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_resource_get_cleartext_size (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY:
		g_value_set_long (value, rygel_media_resource_get_duration (self));
		break;
		case RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_bitrate (self));
		break;
		case RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_bits_per_sample (self));
		break;
		case RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_color_depth (self));
		break;
		case RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_width (self));
		break;
		case RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_height (self));
		break;
		case RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_audio_channels (self));
		break;
		case RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_sample_freq (self));
		break;
		case RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_protocol (self));
		break;
		case RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_mime_type (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_dlna_profile (self));
		break;
		case RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_network (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY:
		g_value_set_flags (value, rygel_media_resource_get_dlna_conversion (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_resource_get_dlna_flags (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY:
		g_value_set_flags (value, rygel_media_resource_get_dlna_operation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_resource_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
	switch (property_id) {
		case RYGEL_MEDIA_RESOURCE_URI_PROPERTY:
		rygel_media_resource_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY:
		rygel_media_resource_set_import_uri (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY:
		rygel_media_resource_set_extension (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY:
		rygel_media_resource_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY:
		rygel_media_resource_set_cleartext_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY:
		rygel_media_resource_set_duration (self, g_value_get_long (value));
		break;
		case RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY:
		rygel_media_resource_set_bitrate (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY:
		rygel_media_resource_set_bits_per_sample (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY:
		rygel_media_resource_set_color_depth (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY:
		rygel_media_resource_set_width (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY:
		rygel_media_resource_set_height (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY:
		rygel_media_resource_set_audio_channels (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY:
		rygel_media_resource_set_sample_freq (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY:
		rygel_media_resource_set_protocol (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY:
		rygel_media_resource_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY:
		rygel_media_resource_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY:
		rygel_media_resource_set_network (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY:
		rygel_media_resource_set_dlna_conversion (self, g_value_get_flags (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY:
		rygel_media_resource_set_dlna_flags (self, g_value_get_flags (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY:
		rygel_media_resource_set_dlna_operation (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

