/* rygel-image-item.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-image-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelMediaFileItemPrivate RygelMediaFileItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;
typedef struct _RygelImageItemPrivate RygelImageItemPrivate;
enum  {
	RYGEL_IMAGE_ITEM_0_PROPERTY,
	RYGEL_IMAGE_ITEM_WIDTH_PROPERTY,
	RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY,
	RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY,
	RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY,
	RYGEL_IMAGE_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_image_item_properties[RYGEL_IMAGE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaFileItem {
	RygelMediaItem parent_instance;
	RygelMediaFileItemPrivate * priv;
};

struct _RygelMediaFileItemClass {
	RygelMediaItemClass parent_class;
	RygelMediaResource* (*get_primary_resource) (RygelMediaFileItem* self);
	gchar* (*get_extension) (RygelMediaFileItem* self);
	void (*add_engine_resources) (RygelMediaFileItem* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_engine_resources_finish) (RygelMediaFileItem* self, GAsyncResult* _res_);
	void (*add_additional_resources) (RygelMediaFileItem* self, RygelHTTPServer* server);
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelImageItem {
	RygelMediaFileItem parent_instance;
	RygelImageItemPrivate * priv;
};

struct _RygelImageItemClass {
	RygelMediaFileItemClass parent_class;
};

struct _RygelImageItemPrivate {
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

static gint RygelImageItem_private_offset;
static gpointer rygel_image_item_parent_class = NULL;
static RygelVisualItemIface * rygel_image_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_image_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
RygelImageItem* rygel_image_item_new (const gchar* id,
                                      RygelMediaContainer* parent,
                                      const gchar* title,
                                      const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type,
                                            const gchar* id,
                                            RygelMediaContainer* parent,
                                            const gchar* title,
                                            const gchar* upnp_class);
static void rygel_image_item_real_constructed (GObject* base);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self,
                                       GeeArrayList* value);
static void rygel_image_item_real_add_uri (RygelMediaObject* base,
                                    const gchar* uri);
void rygel_media_object_add_uri (RygelMediaObject* self,
                                 const gchar* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                              const gchar* uri);
static RygelMediaResource* rygel_image_item_real_get_primary_resource (RygelMediaFileItem* base);
RygelMediaResource* rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self);
void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                       RygelMediaResource* res);
GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self,
                                          GUPnPDLNAFlags value);
static void rygel_image_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                     RygelHTTPServer* server);
void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self,
                                                     RygelHTTPServer* server);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                                RygelHTTPServer* http_server);
static void rygel_image_item_finalize (GObject * obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void _vala_rygel_image_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self,
                                  gint value);
void rygel_visual_item_set_height (RygelVisualItem* self,
                                   gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self,
                                        gint value);
static void _vala_rygel_image_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
rygel_image_item_get_instance_private (RygelImageItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelImageItem_private_offset);
}

RygelImageItem*
rygel_image_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelImageItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelImageItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelImageItem*
rygel_image_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_image_item_construct (RYGEL_TYPE_IMAGE_ITEM, id, parent, title, upnp_class);
}

static void
rygel_image_item_real_constructed (GObject* base)
{
	RygelImageItem * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (RygelImageItem*) base;
	G_OBJECT_CLASS (rygel_image_item_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
rygel_image_item_real_add_uri (RygelMediaObject* base,
                               const gchar* uri)
{
	RygelImageItem * self;
	self = (RygelImageItem*) base;
	g_return_if_fail (uri != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_image_item_parent_class)->add_uri ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), uri);
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
}

static RygelMediaResource*
rygel_image_item_real_get_primary_resource (RygelMediaFileItem* base)
{
	RygelImageItem * self;
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	GUPnPDLNAFlags _tmp1_;
	GUPnPDLNAFlags _tmp2_;
	self = (RygelImageItem*) base;
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_image_item_parent_class)->get_primary_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	res = _tmp0_;
	rygel_visual_item_set_visual_resource_properties ((RygelVisualItem*) self, res);
	_tmp1_ = rygel_media_resource_get_dlna_flags (res);
	_tmp2_ = _tmp1_;
	rygel_media_resource_set_dlna_flags (res, _tmp2_ | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
	result = res;
	return result;
}

static void
rygel_image_item_real_add_additional_resources (RygelMediaFileItem* base,
                                                RygelHTTPServer* server)
{
	RygelImageItem * self;
	self = (RygelImageItem*) base;
	g_return_if_fail (server != NULL);
	RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_image_item_parent_class)->add_additional_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), server);
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, server);
}

static gint
rygel_image_item_real_get_width (RygelVisualItem* base)
{
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_width;
	return result;
}

static void
rygel_image_item_real_set_width (RygelVisualItem* base,
                                 gint value)
{
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	if (rygel_image_item_real_get_width (base) != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_WIDTH_PROPERTY]);
	}
}

static gint
rygel_image_item_real_get_height (RygelVisualItem* base)
{
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_height;
	return result;
}

static void
rygel_image_item_real_set_height (RygelVisualItem* base,
                                  gint value)
{
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	if (rygel_image_item_real_get_height (base) != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY]);
	}
}

static gint
rygel_image_item_real_get_color_depth (RygelVisualItem* base)
{
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_color_depth;
	return result;
}

static void
rygel_image_item_real_set_color_depth (RygelVisualItem* base,
                                       gint value)
{
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	if (rygel_image_item_real_get_color_depth (base) != value) {
		self->priv->_color_depth = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY]);
	}
}

static GeeArrayList*
rygel_image_item_real_get_thumbnails (RygelVisualItem* base)
{
	GeeArrayList* result;
	RygelImageItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelImageItem*) base;
	_tmp0_ = self->priv->_thumbnails;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_image_item_real_set_thumbnails (RygelVisualItem* base,
                                      GeeArrayList* value)
{
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	if (rygel_image_item_real_get_thumbnails (base) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thumbnails);
		self->priv->_thumbnails = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_image_item_properties[RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY]);
	}
}

static void
rygel_image_item_class_init (RygelImageItemClass * klass)
{
	rygel_image_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelImageItem_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_image_item_real_constructed;
	((RygelMediaObjectClass *) klass)->add_uri = (void (*) (RygelMediaObject*, const gchar*)) rygel_image_item_real_add_uri;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_image_item_real_get_primary_resource;
	((RygelMediaFileItemClass *) klass)->add_additional_resources = (void (*) (RygelMediaFileItem*, RygelHTTPServer*)) rygel_image_item_real_add_additional_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_image_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_image_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_image_item_finalize;
	/**
	     * The width of the image in pixels.
	     * A value of -1 means that the width is unknown and will not, or did not,
	     * appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_WIDTH_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the image in pixels.
	     * A value of -1 means that the height is unknown and will not, or did not,
	     * appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     *The number of bits per pixel used to represent the image resource.
	     * A value of -1 means that the color depth is unknown and will not, or did
	     * not, appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY] = g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Thumbnail pictures to represent the image.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY, rygel_image_item_properties[RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY] = g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_image_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface)
{
	rygel_image_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_image_item_real_get_width;
	iface->set_width = rygel_image_item_real_set_width;
	iface->get_height = rygel_image_item_real_get_height;
	iface->set_height = rygel_image_item_real_set_height;
	iface->get_color_depth = rygel_image_item_real_get_color_depth;
	iface->set_color_depth = rygel_image_item_real_set_color_depth;
	iface->get_thumbnails = rygel_image_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_image_item_real_set_thumbnails;
}

static void
rygel_image_item_instance_init (RygelImageItem * self)
{
	self->priv = rygel_image_item_get_instance_private (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_color_depth = -1;
}

static void
rygel_image_item_finalize (GObject * obj)
{
	RygelImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem);
	_g_object_unref0 (self->priv->_thumbnails);
	G_OBJECT_CLASS (rygel_image_item_parent_class)->finalize (obj);
}

/**
 * Represents an image item.
 */
GType
rygel_image_item_get_type (void)
{
	static volatile gsize rygel_image_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_image_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImageItem), 0, (GInstanceInitFunc) rygel_image_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_image_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_image_item_type_id;
		rygel_image_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_FILE_ITEM, "RygelImageItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_image_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		RygelImageItem_private_offset = g_type_add_instance_private (rygel_image_item_type_id, sizeof (RygelImageItemPrivate));
		g_once_init_leave (&rygel_image_item_type_id__volatile, rygel_image_item_type_id);
	}
	return rygel_image_item_type_id__volatile;
}

static void
_vala_rygel_image_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem);
	switch (property_id) {
		case RYGEL_IMAGE_ITEM_WIDTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_image_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem);
	switch (property_id) {
		case RYGEL_IMAGE_ITEM_WIDTH_PROPERTY:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_HEIGHT_PROPERTY:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_COLOR_DEPTH_PROPERTY:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_THUMBNAILS_PROPERTY:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

