/* rygel-environment-config.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-environment-config.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_ENVIRONMENT_CONFIG (rygel_environment_config_get_type ())
#define RYGEL_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig))
#define RYGEL_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))
#define RYGEL_IS_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_IS_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_ENVIRONMENT_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))

typedef struct _RygelEnvironmentConfig RygelEnvironmentConfig;
typedef struct _RygelEnvironmentConfigClass RygelEnvironmentConfigClass;
typedef struct _RygelEnvironmentConfigPrivate RygelEnvironmentConfigPrivate;
enum  {
	RYGEL_ENVIRONMENT_CONFIG_0_PROPERTY,
	RYGEL_ENVIRONMENT_CONFIG_NUM_PROPERTIES
};
static GParamSpec* rygel_environment_config_properties[RYGEL_ENVIRONMENT_CONFIG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error) G_GNUC_DEPRECATED;
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelEnvironmentConfig {
	GObject parent_instance;
	RygelEnvironmentConfigPrivate * priv;
};

struct _RygelEnvironmentConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static gpointer rygel_environment_config_parent_class = NULL;
static gchar* rygel_environment_config_RYGEL_PREFIX;
static gchar* rygel_environment_config_RYGEL_PREFIX = NULL;
static gchar* rygel_environment_config_TITLE_KEY;
static gchar* rygel_environment_config_TITLE_KEY = NULL;
static gchar* rygel_environment_config_DISABLE_PREFIX;
static gchar* rygel_environment_config_DISABLE_PREFIX = NULL;
static gchar* rygel_environment_config_ENABLED_KEY;
static gchar* rygel_environment_config_ENABLED_KEY = NULL;
static gchar* rygel_environment_config_INTERFACE_ENV;
static gchar* rygel_environment_config_INTERFACE_ENV = NULL;
static gchar* rygel_environment_config_PORT_ENV;
static gchar* rygel_environment_config_PORT_ENV = NULL;
static gchar* rygel_environment_config_TRANSCODING_ENV;
static gchar* rygel_environment_config_TRANSCODING_ENV = NULL;
static gchar* rygel_environment_config_DISALLOW_UPLOAD_ENV;
static gchar* rygel_environment_config_DISALLOW_UPLOAD_ENV = NULL;
static gchar* rygel_environment_config_DISALLOW_DELETION_ENV;
static gchar* rygel_environment_config_DISALLOW_DELETION_ENV = NULL;
static gchar* rygel_environment_config_LOG_LEVELS_ENV;
static gchar* rygel_environment_config_LOG_LEVELS_ENV = NULL;
static gchar* rygel_environment_config_PLUGIN_PATH_ENV;
static gchar* rygel_environment_config_PLUGIN_PATH_ENV = NULL;
static gchar* rygel_environment_config_ENGINE_PATH_ENV;
static gchar* rygel_environment_config_ENGINE_PATH_ENV = NULL;
static gchar* rygel_environment_config_MEDIA_ENGINE_ENV;
static gchar* rygel_environment_config_MEDIA_ENGINE_ENV = NULL;
static RygelEnvironmentConfig* rygel_environment_config_config;
static RygelEnvironmentConfig* rygel_environment_config_config = NULL;
static RygelConfigurationIface * rygel_environment_config_rygel_configuration_parent_iface = NULL;

GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_environment_config_get_type (void) G_GNUC_CONST;
RygelEnvironmentConfig* rygel_environment_config_get_default (void);
RygelEnvironmentConfig* rygel_environment_config_new (void);
RygelEnvironmentConfig* rygel_environment_config_construct (GType object_type);
static gchar* rygel_environment_config_real_get_interface (RygelConfiguration* base,
                                                    GError** error);
static gchar* rygel_environment_config_get_string_variable (RygelEnvironmentConfig* self,
                                                     const gchar* variable,
                                                     GError** error);
static gchar** rygel_environment_config_real_get_interfaces (RygelConfiguration* base,
                                                      GError** error);
static gint rygel_environment_config_real_get_port (RygelConfiguration* base,
                                             GError** error);
static gint rygel_environment_config_get_int_variable (RygelEnvironmentConfig* self,
                                                const gchar* variable,
                                                gint min,
                                                gint max,
                                                GError** error);
static gboolean rygel_environment_config_real_get_transcoding (RygelConfiguration* base,
                                                        GError** error);
static gboolean rygel_environment_config_get_bool_variable (RygelEnvironmentConfig* self,
                                                     const gchar* variable,
                                                     GError** error);
static gboolean rygel_environment_config_real_get_allow_upload (RygelConfiguration* base,
                                                         GError** error);
static gboolean rygel_environment_config_real_get_allow_deletion (RygelConfiguration* base,
                                                           GError** error);
static gchar* rygel_environment_config_real_get_log_levels (RygelConfiguration* base,
                                                     GError** error);
static gchar* rygel_environment_config_real_get_plugin_path (RygelConfiguration* base,
                                                      GError** error);
static gchar* rygel_environment_config_real_get_engine_path (RygelConfiguration* base,
                                                      GError** error);
static gchar* rygel_environment_config_real_get_media_engine (RygelConfiguration* base,
                                                       GError** error);
static gchar* rygel_environment_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                              GError** error);
GQuark rygel_configuration_error_quark (void);
static gchar* rygel_environment_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                              GError** error);
static gchar* rygel_environment_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                                GError** error);
static gboolean rygel_environment_config_real_get_enabled (RygelConfiguration* base,
                                                    const gchar* section,
                                                    GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self,
                                       const gchar* section,
                                       const gchar* key,
                                       GError** error);
static gchar* rygel_environment_config_real_get_title (RygelConfiguration* base,
                                                const gchar* section,
                                                GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self,
                                       const gchar* section,
                                       const gchar* key,
                                       GError** error);
static gchar* rygel_environment_config_real_get_string (RygelConfiguration* base,
                                                 const gchar* section,
                                                 const gchar* key,
                                                 GError** error);
static GeeArrayList* rygel_environment_config_real_get_string_list (RygelConfiguration* base,
                                                             const gchar* section,
                                                             const gchar* key,
                                                             GError** error);
static gint rygel_environment_config_real_get_int (RygelConfiguration* base,
                                            const gchar* section,
                                            const gchar* key,
                                            gint min,
                                            gint max,
                                            GError** error);
static GeeArrayList* rygel_environment_config_real_get_int_list (RygelConfiguration* base,
                                                          const gchar* section,
                                                          const gchar* key,
                                                          GError** error);
static gboolean rygel_environment_config_real_get_bool (RygelConfiguration* base,
                                                 const gchar* section,
                                                 const gchar* key,
                                                 GError** error);
static void rygel_environment_config_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelEnvironmentConfig*
rygel_environment_config_get_default (void)
{
	RygelEnvironmentConfig* result = NULL;
	RygelEnvironmentConfig* _tmp0_;
	RygelEnvironmentConfig* _tmp2_;
	RygelEnvironmentConfig* _tmp3_;
	_tmp0_ = rygel_environment_config_config;
	if (_tmp0_ == NULL) {
		RygelEnvironmentConfig* _tmp1_;
		_tmp1_ = rygel_environment_config_new ();
		_g_object_unref0 (rygel_environment_config_config);
		rygel_environment_config_config = _tmp1_;
	}
	_tmp2_ = rygel_environment_config_config;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
rygel_environment_config_real_get_interface (RygelConfiguration* base,
                                             GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_INTERFACE_ENV;
	_tmp2_ = rygel_environment_config_get_string_variable (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar**
rygel_environment_config_real_get_interfaces (RygelConfiguration* base,
                                              GError** error)
{
	RygelEnvironmentConfig * self;
	gchar** result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_INTERFACE_ENV;
	_tmp2_ = rygel_environment_config_get_string_variable (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp3_ = g_strsplit (_tmp0_, ",", 0);
	result = _tmp4_;
	_g_free0 (_tmp0_);
	return result;
}

static gint
rygel_environment_config_real_get_port (RygelConfiguration* base,
                                        GError** error)
{
	RygelEnvironmentConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_PORT_ENV;
	_tmp0_ = rygel_environment_config_get_int_variable (self, _tmp1_, 0, (gint) G_MAXINT16, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp2_ = -1;
		g_propagate_error (error, _inner_error_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_environment_config_real_get_transcoding (RygelConfiguration* base,
                                               GError** error)
{
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_TRANSCODING_ENV;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp2_;
	}
	result = !_tmp0_;
	return result;
}

static gboolean
rygel_environment_config_real_get_allow_upload (RygelConfiguration* base,
                                                GError** error)
{
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_DISALLOW_UPLOAD_ENV;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp2_;
	}
	result = !_tmp0_;
	return result;
}

static gboolean
rygel_environment_config_real_get_allow_deletion (RygelConfiguration* base,
                                                  GError** error)
{
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_DISALLOW_DELETION_ENV;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp2_;
	}
	result = !_tmp0_;
	return result;
}

static gchar*
rygel_environment_config_real_get_log_levels (RygelConfiguration* base,
                                              GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_LOG_LEVELS_ENV;
	_tmp2_ = rygel_environment_config_get_string_variable (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_environment_config_real_get_plugin_path (RygelConfiguration* base,
                                               GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_PLUGIN_PATH_ENV;
	_tmp2_ = rygel_environment_config_get_string_variable (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_environment_config_real_get_engine_path (RygelConfiguration* base,
                                               GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_ENGINE_PATH_ENV;
	_tmp2_ = rygel_environment_config_get_string_variable (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_environment_config_real_get_media_engine (RygelConfiguration* base,
                                                GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp1_ = rygel_environment_config_MEDIA_ENGINE_ENV;
	_tmp2_ = rygel_environment_config_get_string_variable (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
rygel_environment_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                       GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error_ = _tmp0_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}

static gchar*
rygel_environment_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                       GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error_ = _tmp0_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}

static gchar*
rygel_environment_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                         GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error_ = _tmp0_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}

static gboolean
rygel_environment_config_real_get_enabled (RygelConfiguration* base,
                                           const gchar* section,
                                           GError** error)
{
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp1_ = rygel_environment_config_ENABLED_KEY;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
rygel_environment_config_real_get_title (RygelConfiguration* base,
                                         const gchar* section,
                                         GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp1_ = rygel_environment_config_TITLE_KEY;
	_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch54_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch54_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally54;
	__catch54_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally54:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}

static gchar*
rygel_environment_config_real_get_string (RygelConfiguration* base,
                                          const gchar* section,
                                          const gchar* key,
                                          GError** error)
{
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp2_ = g_strconcat (_tmp1_, "_", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strup (section, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "_", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_strup (key, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_replace (_tmp11_, "-", "_");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = rygel_environment_config_get_string_variable (self, _tmp15_, &_inner_error_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp0_ = _tmp17_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp18_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp18_;
	_g_free0 (_tmp0_);
	return result;
}

static GeeArrayList*
rygel_environment_config_real_get_string_list (RygelConfiguration* base,
                                               const gchar* section,
                                               const gchar* key,
                                               GError** error)
{
	RygelEnvironmentConfig * self;
	GeeArrayList* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	GeeArrayList* value = NULL;
	GeeArrayList* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error_);
	str = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	value = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (str, ",", -1);
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp3_;
		token_collection_length1 = _vala_array_length (_tmp2_);
		for (token_it = 0; token_it < _vala_array_length (_tmp2_); token_it = token_it + 1) {
			gchar* _tmp4_;
			gchar* token = NULL;
			_tmp4_ = g_strdup (token_collection[token_it]);
			token = _tmp4_;
			{
				GeeArrayList* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = value;
				_tmp6_ = token;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = value;
	_g_free0 (str);
	return result;
}

static gint
rygel_environment_config_real_get_int (RygelConfiguration* base,
                                       const gchar* section,
                                       const gchar* key,
                                       gint min,
                                       gint max,
                                       GError** error)
{
	RygelEnvironmentConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gint _tmp16_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp1_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp2_ = g_strconcat (_tmp1_, "_", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strup (section, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "_", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_strup (key, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_replace (_tmp11_, "-", "_");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = rygel_environment_config_get_int_variable (self, _tmp15_, min, max, &_inner_error_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp0_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp17_ = -1;
		g_propagate_error (error, _inner_error_);
		return _tmp17_;
	}
	result = _tmp0_;
	return result;
}

static GeeArrayList*
rygel_environment_config_real_get_int_list (RygelConfiguration* base,
                                            const gchar* section,
                                            const gchar* key,
                                            GError** error)
{
	RygelEnvironmentConfig * self;
	GeeArrayList* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	GeeArrayList* value = NULL;
	GeeArrayList* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error_);
	str = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	value = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (str, ",", -1);
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp3_;
		token_collection_length1 = _vala_array_length (_tmp2_);
		for (token_it = 0; token_it < _vala_array_length (_tmp2_); token_it = token_it + 1) {
			gchar* _tmp4_;
			gchar* token = NULL;
			_tmp4_ = g_strdup (token_collection[token_it]);
			token = _tmp4_;
			{
				GeeArrayList* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = value;
				_tmp6_ = token;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (gpointer) ((gintptr) atoi (_tmp6_)));
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = value;
	_g_free0 (str);
	return result;
}

static gboolean
rygel_environment_config_real_get_bool (RygelConfiguration* base,
                                        const gchar* section,
                                        const gchar* key,
                                        GError** error)
{
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp2_ = g_strconcat (_tmp1_, "_", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strup (section, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "_", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_strup (key, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_replace (_tmp11_, "-", "_");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = rygel_environment_config_get_bool_variable (self, _tmp15_, &_inner_error_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp0_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp17_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
rygel_environment_config_get_string_variable (RygelEnvironmentConfig* self,
                                              const gchar* variable,
                                              GError** error)
{
	gchar* result = NULL;
	gchar* str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable != NULL, NULL);
	_tmp0_ = g_getenv (variable);
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = str;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (str);
		return NULL;
	}
	result = str;
	return result;
}

static gint
rygel_environment_config_get_int_variable (RygelEnvironmentConfig* self,
                                           const gchar* variable,
                                           gint min,
                                           gint max,
                                           GError** error)
{
	gint result = 0;
	gchar* val = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (variable != NULL, 0);
	_tmp0_ = g_getenv (variable);
	_tmp1_ = g_strdup (_tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		gint _tmp4_ = -1;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return _tmp4_;
	}
	_tmp5_ = val;
	result = CLAMP (atoi (_tmp5_), min, max);
	_g_free0 (val);
	return result;
}

static gboolean
rygel_environment_config_get_bool_variable (RygelEnvironmentConfig* self,
                                            const gchar* variable,
                                            GError** error)
{
	gboolean result = FALSE;
	gchar* enabled = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (variable != NULL, FALSE);
	_tmp0_ = g_getenv (variable);
	_tmp1_ = g_strdup (_tmp0_);
	enabled = _tmp1_;
	_tmp2_ = enabled;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (enabled);
		return _tmp4_;
	}
	result = TRUE;
	_g_free0 (enabled);
	return result;
}

RygelEnvironmentConfig*
rygel_environment_config_construct (GType object_type)
{
	RygelEnvironmentConfig * self = NULL;
	self = (RygelEnvironmentConfig*) g_object_new (object_type, NULL);
	return self;
}

RygelEnvironmentConfig*
rygel_environment_config_new (void)
{
	return rygel_environment_config_construct (RYGEL_TYPE_ENVIRONMENT_CONFIG);
}

static void
rygel_environment_config_class_init (RygelEnvironmentConfigClass * klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	rygel_environment_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_environment_config_finalize;
	_tmp0_ = g_strdup ("RYGEL");
	rygel_environment_config_RYGEL_PREFIX = _tmp0_;
	_tmp1_ = g_strdup ("TITLE");
	rygel_environment_config_TITLE_KEY = _tmp1_;
	_tmp2_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp3_ = g_strconcat (_tmp2_, "_DISABLE", NULL);
	rygel_environment_config_DISABLE_PREFIX = _tmp3_;
	_tmp4_ = g_strdup ("ENABLED");
	rygel_environment_config_ENABLED_KEY = _tmp4_;
	_tmp5_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp6_ = g_strconcat (_tmp5_, "_IFACE", NULL);
	rygel_environment_config_INTERFACE_ENV = _tmp6_;
	_tmp7_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp8_ = g_strconcat (_tmp7_, "_PORT", NULL);
	rygel_environment_config_PORT_ENV = _tmp8_;
	_tmp9_ = rygel_environment_config_DISABLE_PREFIX;
	_tmp10_ = g_strconcat (_tmp9_, "_TRANSCODING", NULL);
	rygel_environment_config_TRANSCODING_ENV = _tmp10_;
	_tmp11_ = rygel_environment_config_DISABLE_PREFIX;
	_tmp12_ = g_strconcat (_tmp11_, "_UPLOAD", NULL);
	rygel_environment_config_DISALLOW_UPLOAD_ENV = _tmp12_;
	_tmp13_ = rygel_environment_config_DISABLE_PREFIX;
	_tmp14_ = g_strconcat (_tmp13_, "_DELETION", NULL);
	rygel_environment_config_DISALLOW_DELETION_ENV = _tmp14_;
	_tmp15_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp16_ = g_strconcat (_tmp15_, "_LOG", NULL);
	rygel_environment_config_LOG_LEVELS_ENV = _tmp16_;
	_tmp17_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp18_ = g_strconcat (_tmp17_, "_PLUGIN_PATH", NULL);
	rygel_environment_config_PLUGIN_PATH_ENV = _tmp18_;
	_tmp19_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp20_ = g_strconcat (_tmp19_, "_ENGINE_PATH", NULL);
	rygel_environment_config_ENGINE_PATH_ENV = _tmp20_;
	_tmp21_ = rygel_environment_config_RYGEL_PREFIX;
	_tmp22_ = g_strconcat (_tmp21_, "_MEDIA_ENGINE", NULL);
	rygel_environment_config_MEDIA_ENGINE_ENV = _tmp22_;
}

static void
rygel_environment_config_rygel_configuration_interface_init (RygelConfigurationIface * iface)
{
	rygel_environment_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_interface = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_interface;
	iface->get_interfaces = (gchar** (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_interfaces;
	iface->get_port = (gint (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_port;
	iface->get_transcoding = (gboolean (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_transcoding;
	iface->get_allow_upload = (gboolean (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_plugin_path;
	iface->get_engine_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_engine_path;
	iface->get_media_engine = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_media_engine;
	iface->get_video_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_video_upload_folder;
	iface->get_music_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_music_upload_folder;
	iface->get_picture_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_environment_config_real_get_picture_upload_folder;
	iface->get_enabled = (gboolean (*) (RygelConfiguration*, const gchar*, GError**)) rygel_environment_config_real_get_enabled;
	iface->get_title = (gchar* (*) (RygelConfiguration*, const gchar*, GError**)) rygel_environment_config_real_get_title;
	iface->get_string = (gchar* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_environment_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_environment_config_real_get_string_list;
	iface->get_int = (gint (*) (RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_environment_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_environment_config_real_get_int_list;
	iface->get_bool = (gboolean (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_environment_config_real_get_bool;
}

static void
rygel_environment_config_instance_init (RygelEnvironmentConfig * self)
{
}

static void
rygel_environment_config_finalize (GObject * obj)
{
	RygelEnvironmentConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig);
	G_OBJECT_CLASS (rygel_environment_config_parent_class)->finalize (obj);
}

/**
 * Manages configuration from Environment.
 */
GType
rygel_environment_config_get_type (void)
{
	static volatile gsize rygel_environment_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_environment_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelEnvironmentConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_environment_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelEnvironmentConfig), 0, (GInstanceInitFunc) rygel_environment_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_environment_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_environment_config_type_id;
		rygel_environment_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelEnvironmentConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_environment_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_environment_config_type_id__volatile, rygel_environment_config_type_id);
	}
	return rygel_environment_config_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

