/* abstractqueue.c generated by valac 0.15.0.90-e9553, the Vala compiler
 * generated from abstractqueue.vala, do not modify */

/* abstractqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

typedef void (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	void (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	void (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeAbstractCollection* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*filter) (GeeAbstractCollection* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeAbstractCollection* self, gint offset, gint length);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gboolean (*offer) (GeeAbstractQueue* self, gconstpointer element);
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	gint (*drain) (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeeAbstractQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};


static gpointer gee_abstract_queue_parent_class = NULL;
static GeeQueueIface* gee_abstract_queue_gee_queue_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_abstract_queue_get_type (void) G_GNUC_CONST;
#define GEE_ABSTRACT_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueuePrivate))
enum  {
	GEE_ABSTRACT_QUEUE_DUMMY_PROPERTY,
	GEE_ABSTRACT_QUEUE_G_TYPE,
	GEE_ABSTRACT_QUEUE_G_DUP_FUNC,
	GEE_ABSTRACT_QUEUE_G_DESTROY_FUNC,
	GEE_ABSTRACT_QUEUE_CAPACITY,
	GEE_ABSTRACT_QUEUE_REMAINING_CAPACITY,
	GEE_ABSTRACT_QUEUE_IS_FULL
};
static gboolean gee_abstract_queue_real_add (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_queue_offer (GeeAbstractQueue* self, gconstpointer element);
static gboolean gee_abstract_queue_real_offer (GeeAbstractQueue* self, gconstpointer element);
gpointer gee_abstract_queue_peek (GeeAbstractQueue* self);
static gpointer gee_abstract_queue_real_peek (GeeAbstractQueue* self);
gpointer gee_abstract_queue_poll (GeeAbstractQueue* self);
static gpointer gee_abstract_queue_real_poll (GeeAbstractQueue* self);
gint gee_abstract_queue_drain (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
static gint gee_abstract_queue_real_drain (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
static void _vala_gee_abstract_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_abstract_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_queue_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeAbstractQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (GeeAbstractQueue*) base;
	_tmp0_ = item;
	_tmp1_ = gee_abstract_queue_offer (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_queue_real_offer (GeeAbstractQueue* self, gconstpointer element) {
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_queue_offer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_queue_offer (GeeAbstractQueue* self, gconstpointer element) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->offer (self, element);
}


/**
 * {@inheritDoc}
 */
static gpointer gee_abstract_queue_real_peek (GeeAbstractQueue* self) {
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_queue_peek'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer gee_abstract_queue_peek (GeeAbstractQueue* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->peek (self);
}


/**
 * {@inheritDoc}
 */
static gpointer gee_abstract_queue_real_poll (GeeAbstractQueue* self) {
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_queue_poll'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer gee_abstract_queue_poll (GeeAbstractQueue* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->poll (self);
}


/**
 * {@inheritDoc}
 */
static gint gee_abstract_queue_real_drain (GeeAbstractQueue* self, GeeCollection* recipient, gint amount) {
	gint result = 0;
	gpointer item;
	gint drained;
	g_return_val_if_fail (recipient != NULL, 0);
	item = NULL;
	drained = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		gboolean _tmp5_;
		gboolean _tmp8_;
		GeeCollection* _tmp9_;
		gconstpointer _tmp10_;
		gint _tmp11_;
		_tmp2_ = amount;
		if (_tmp2_ == (-1)) {
			_tmp1_ = TRUE;
		} else {
			gint _tmp3_;
			gint _tmp4_;
			_tmp3_ = amount;
			amount = _tmp3_ - 1;
			_tmp4_ = amount;
			_tmp1_ = _tmp4_ >= 0;
		}
		_tmp5_ = _tmp1_;
		if (_tmp5_) {
			gpointer _tmp6_ = NULL;
			gconstpointer _tmp7_;
			_tmp6_ = gee_abstract_queue_poll (self);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			item = _tmp6_;
			_tmp7_ = item;
			_tmp0_ = _tmp7_ != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp8_ = _tmp0_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = recipient;
		_tmp10_ = item;
		gee_collection_add (_tmp9_, _tmp10_);
		_tmp11_ = drained;
		drained = _tmp11_ + 1;
	}
	result = drained;
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
	return result;
}


gint gee_abstract_queue_drain (GeeAbstractQueue* self, GeeCollection* recipient, gint amount) {
	g_return_val_if_fail (self != NULL, 0);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->drain (self, recipient, amount);
}


GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeAbstractQueue * self = NULL;
	self = (GeeAbstractQueue*) gee_abstract_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->get_capacity (self);
}


gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->get_remaining_capacity (self);
}


gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_ABSTRACT_QUEUE_GET_CLASS (self)->get_is_full (self);
}


static void gee_abstract_queue_class_init (GeeAbstractQueueClass * klass) {
	gee_abstract_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractQueuePrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_abstract_queue_real_add;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->offer = gee_abstract_queue_real_offer;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->peek = gee_abstract_queue_real_peek;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->poll = gee_abstract_queue_real_poll;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->drain = gee_abstract_queue_real_drain;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_abstract_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_abstract_queue_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_QUEUE_CAPACITY, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_QUEUE_REMAINING_CAPACITY, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_QUEUE_IS_FULL, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_abstract_queue_gee_queue_interface_init (GeeQueueIface * iface) {
	gee_abstract_queue_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer = (gboolean (*)(GeeQueue*, gconstpointer)) gee_abstract_queue_offer;
	iface->peek = (gpointer (*)(GeeQueue*)) gee_abstract_queue_peek;
	iface->poll = (gpointer (*)(GeeQueue*)) gee_abstract_queue_poll;
	iface->drain = (gint (*)(GeeQueue*, GeeCollection*, gint)) gee_abstract_queue_drain;
	iface->get_capacity = (gint (*) (GeeQueue *)) gee_abstract_queue_get_capacity;
	iface->get_remaining_capacity = (gint (*) (GeeQueue *)) gee_abstract_queue_get_remaining_capacity;
	iface->get_is_full = (gboolean (*) (GeeQueue *)) gee_abstract_queue_get_is_full;
}


static void gee_abstract_queue_instance_init (GeeAbstractQueue * self) {
	self->priv = GEE_ABSTRACT_QUEUE_GET_PRIVATE (self);
}


/**
 * Skeletal implementation of the {@link Queue} interface.
 *
 * Contains common code shared by all queue implementations.
 *
 * @see PriorityQueue
 */
GType gee_abstract_queue_get_type (void) {
	static volatile gsize gee_abstract_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_abstract_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractQueue), 0, (GInstanceInitFunc) gee_abstract_queue_instance_init, NULL };
		static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_abstract_queue_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_abstract_queue_type_id;
		gee_abstract_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "GeeAbstractQueue", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_queue_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
		g_once_init_leave (&gee_abstract_queue_type_id__volatile, gee_abstract_queue_type_id);
	}
	return gee_abstract_queue_type_id__volatile;
}


static void _vala_gee_abstract_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractQueue * self;
	self = GEE_ABSTRACT_QUEUE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_abstract_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractQueue * self;
	self = GEE_ABSTRACT_QUEUE (object);
	switch (property_id) {
		case GEE_ABSTRACT_QUEUE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_QUEUE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_QUEUE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



