/* contacts-app.c generated by valac 0.15.0.63-4c098, the Vala compiler
 * generated from contacts-app.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <folks/folks-eds.h>
#include <libebook/e-book-client.h>
#include <config.h>
#include <float.h>
#include <math.h>
#include <gtk-notification.h>
#include <contacts-esd-setup.h>


#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _ContactsAppShowIndividualData ContactsAppShowIndividualData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ContactsAppShowByEmailData ContactsAppShowByEmailData;
typedef struct _Block6Data Block6Data;

#define CONTACTS_TYPE_NEW_CONTACT_DIALOG (contacts_new_contact_dialog_get_type ())
#define CONTACTS_NEW_CONTACT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_NEW_CONTACT_DIALOG, ContactsNewContactDialog))
#define CONTACTS_NEW_CONTACT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_NEW_CONTACT_DIALOG, ContactsNewContactDialogClass))
#define CONTACTS_IS_NEW_CONTACT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_NEW_CONTACT_DIALOG))
#define CONTACTS_IS_NEW_CONTACT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_NEW_CONTACT_DIALOG))
#define CONTACTS_NEW_CONTACT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_NEW_CONTACT_DIALOG, ContactsNewContactDialogClass))

typedef struct _ContactsNewContactDialog ContactsNewContactDialog;
typedef struct _ContactsNewContactDialogClass ContactsNewContactDialogClass;
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GtkApplicationWindow* window;
	ContactsStore* contacts_store;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _ContactsAppPrivate {
	ContactsListPane* list_pane;
	ContactsContactPane* contacts_pane;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkEntry* filter_entry;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	ContactsApp * self;
	gchar* id;
	gpointer _async_data_;
};

typedef gboolean (*ContactsStoreContactMatcher) (ContactsContact* c, void* user_data);
struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_primary;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* id;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* contact;
	ContactsContact* _tmp4_;
	ContactsListPane* _tmp5_;
	ContactsContact* _tmp6_;
	ContactsContactPane* _tmp7_;
	ContactsContact* _tmp8_;
	Block2Data* _data2_;
	ContactsApp* _tmp9_;
	GtkApplicationWindow* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkMessageDialog* _tmp13_;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkMessageDialog* _tmp17_;
	GtkMessageDialog* _tmp18_;
};

struct _Block3Data {
	int _ref_count_;
	ContactsApp * self;
	GtkDialog* dialog;
	GtkTreeView* tree_view;
	GtkListStore* store;
};

struct _Block4Data {
	int _ref_count_;
	ContactsApp * self;
	gchar* email_address;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* email_address;
	Block4Data* _data4_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* contact;
	ContactsContact* _tmp4_;
	ContactsListPane* _tmp5_;
	ContactsContact* _tmp6_;
	ContactsContactPane* _tmp7_;
	ContactsContact* _tmp8_;
	Block5Data* _data5_;
	ContactsApp* _tmp9_;
	GtkApplicationWindow* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkMessageDialog* _tmp13_;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkMessageDialog* _tmp17_;
	GtkMessageDialog* _tmp18_;
};

struct _Block6Data {
	int _ref_count_;
	ContactsApp * self;
	GtkOverlay* overlay;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GtkNotification* notification;
	ContactsContact* c;
};


static gpointer contacts_app_parent_class = NULL;
extern ContactsApp* contacts_app_app;
ContactsApp* contacts_app_app = NULL;
static gchar* contacts_app_individual_id;
static gchar* contacts_app_individual_id = NULL;
static gchar* contacts_app_email_address;
static gchar* contacts_app_email_address = NULL;

GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
#define CONTACTS_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_APP, ContactsAppPrivate))
enum  {
	CONTACTS_APP_DUMMY_PROPERTY
};
static gboolean contacts_app_window_delete_event (ContactsApp* self, GdkEventAny* event);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean edit);
static gboolean contacts_app_window_map_event (ContactsApp* self, GdkEventAny* event);
static gboolean contacts_app_window_key_press_event (ContactsApp* self, GdkEventKey* event);
static void contacts_app_selection_changed (ContactsApp* self, ContactsContact* new_selection);
void contacts_app_show_contact (ContactsApp* self, ContactsContact* contact);
void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact, gboolean ignore_change);
static void contacts_app_show_individual_data_free (gpointer _data);
void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean __lambda77_ (Block1Data* _data1_, ContactsContact* c);
static gboolean ___lambda77__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void ___lambda78_ (Block2Data* _data2_, gint id);
static void ____lambda78__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_change_address_book (ContactsApp* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
FolksPersonaStore** contacts_contact_get_eds_address_books (int* result_length1);
gchar* contacts_contact_format_persona_store_name (FolksPersonaStore* store);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void __lambda79_ (Block3Data* _data3_, gint response);
void contacts_store_refresh (ContactsStore* self);
static void ___lambda79__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void contacts_app_show_about (ContactsApp* self);
static void contacts_app_show_by_email_data_free (gpointer _data);
void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean __lambda80_ (Block4Data* _data4_, ContactsContact* c);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
static gboolean ___lambda80__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void ___lambda81_ (Block5Data* _data5_, gint id);
static void ____lambda81__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_app_create_window (ContactsApp* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void __lambda82_ (ContactsApp* self);
static void ___lambda82__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda83_ (ContactsApp* self);
static void ___lambda83__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda84_ (ContactsApp* self);
static void ___lambda84__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static gboolean _contacts_app_window_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _contacts_app_window_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _contacts_app_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void __lambda85_ (ContactsApp* self, GtkToolButton* button);
ContactsNewContactDialog* contacts_new_contact_dialog_new (ContactsStore* contacts_store, GtkWindow* parent);
ContactsNewContactDialog* contacts_new_contact_dialog_construct (GType object_type, ContactsStore* contacts_store, GtkWindow* parent);
GType contacts_new_contact_dialog_get_type (void) G_GNUC_CONST;
static void ___lambda85__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda93_ (ContactsApp* self, GtkToolButton* button);
static void ___lambda93__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda94_ (ContactsApp* self, GtkToolButton* button);
static void ___lambda94__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
static void _contacts_app_selection_changed_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self);
ContactsContactPane* contacts_contact_pane_new (ContactsStore* contacts_store);
ContactsContactPane* contacts_contact_pane_construct (GType object_type, ContactsStore* contacts_store);
static void __lambda95_ (Block6Data* _data6_, ContactsContact* c);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void __lambda96_ (Block7Data* _data7_);
static void ___lambda96__gtk_notification_timed_out (GtkNotification* _sender, gpointer self);
static void __lambda97_ (Block7Data* _data7_);
void contacts_contact_show (ContactsContact* self);
static void ___lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda95__contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self);
static void contacts_app_real_startup (GApplication* base);
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
static void contacts_app_real_activate (GApplication* base);
static void ___lambda98_ (ContactsApp* self);
static void ____lambda98__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
static gboolean ___lambda99_ (ContactsApp* self);
static gboolean ____lambda99__gsource_func (gpointer self);
static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line);
ContactsApp* contacts_app_new (void);
ContactsApp* contacts_app_construct (GType object_type);
static void contacts_app_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry CONTACTS_APP_options[3] = {{"individual", 'i', 0, G_OPTION_ARG_STRING, &contacts_app_individual_id, "Show contact with this individual id", NULL}, {"email", 'e', 0, G_OPTION_ARG_STRING, &contacts_app_email_address, "Show contact with this email address", NULL}, {NULL}};

static gboolean contacts_app_window_delete_event (ContactsApp* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsContactPane* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->contacts_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean contacts_app_window_map_event (ContactsApp* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsListPane* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = _tmp0_->filter_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	result = TRUE;
	return result;
}


static gboolean contacts_app_window_key_press_event (ContactsApp* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey _tmp1_;
	guint _tmp2_;
	guint _tmp3_ = 0U;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.keyval;
	_tmp3_ = gdk_keyval_from_name ("q");
	if (_tmp2_ == _tmp3_) {
		GdkEventKey _tmp4_;
		GdkModifierType _tmp5_;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.state;
		_tmp0_ = (_tmp5_ & GDK_CONTROL_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		ContactsContactPane* _tmp7_;
		GtkApplicationWindow* _tmp8_;
		_tmp7_ = self->priv->contacts_pane;
		contacts_contact_pane_show_contact (_tmp7_, NULL, FALSE);
		_tmp8_ = self->window;
		gtk_widget_destroy ((GtkWidget*) _tmp8_);
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GdkEventKey _tmp11_;
		guint _tmp12_;
		guint _tmp13_ = 0U;
		gboolean _tmp17_;
		gboolean _tmp20_;
		_tmp11_ = *event;
		_tmp12_ = _tmp11_.keyval;
		_tmp13_ = gdk_keyval_from_name ("s");
		if (_tmp12_ == _tmp13_) {
			_tmp10_ = TRUE;
		} else {
			GdkEventKey _tmp14_;
			guint _tmp15_;
			guint _tmp16_ = 0U;
			_tmp14_ = *event;
			_tmp15_ = _tmp14_.keyval;
			_tmp16_ = gdk_keyval_from_name ("f");
			_tmp10_ = _tmp15_ == _tmp16_;
		}
		_tmp17_ = _tmp10_;
		if (_tmp17_) {
			GdkEventKey _tmp18_;
			GdkModifierType _tmp19_;
			_tmp18_ = *event;
			_tmp19_ = _tmp18_.state;
			_tmp9_ = (_tmp19_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp20_ = _tmp9_;
		if (_tmp20_) {
			ContactsListPane* _tmp21_;
			GtkEntry* _tmp22_;
			_tmp21_ = self->priv->list_pane;
			_tmp22_ = _tmp21_->filter_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp22_);
		}
	}
	result = FALSE;
	return result;
}


static void contacts_app_selection_changed (ContactsApp* self, ContactsContact* new_selection) {
	ContactsContactPane* _tmp0_;
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_pane;
	_tmp1_ = new_selection;
	contacts_contact_pane_show_contact (_tmp0_, _tmp1_, FALSE);
}


void contacts_app_show_contact (ContactsApp* self, ContactsContact* contact) {
	ContactsListPane* _tmp0_;
	ContactsContact* _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContact* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = contact;
	contacts_list_pane_select_contact (_tmp0_, _tmp1_, FALSE);
	_tmp2_ = self->priv->contacts_pane;
	_tmp3_ = contact;
	contacts_contact_pane_show_contact (_tmp2_, _tmp3_, FALSE);
}


static void contacts_app_show_individual_data_free (gpointer _data) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	ContactsApp* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (ContactsAppShowIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	contacts_app_show_individual_co (_data_);
}


void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ContactsApp * self;
		self = _data1_->self;
		_g_free0 (_data1_->id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda77_ (Block1Data* _data1_, ContactsContact* c) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _tmp0_->individual;
	_tmp2_ = folks_individual_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->id;
	result = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	return result;
}


static gboolean ___lambda77__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda77_ (self, c);
	return result;
}


static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_individual_co (_data_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsApp * self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->dialog);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda78_ (Block2Data* _data2_, gint id) {
	Block1Data* _data1_;
	ContactsApp * self;
	GtkMessageDialog* _tmp0_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda78__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda78_ (self, response_id);
}


static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->_data1_->id = _data_->_tmp1_;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->self->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp2_, ___lambda77__contacts_store_contact_matcher, _data_->_data1_, contacts_app_show_individual_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = contacts_store_find_contact_finish (_data_->_tmp2_, _data_->_res_);
	_data_->contact = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->contact;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->list_pane;
		_data_->_tmp6_ = _data_->contact;
		contacts_list_pane_select_contact (_data_->_tmp5_, _data_->_tmp6_, FALSE);
		_data_->_tmp7_ = _data_->self->priv->contacts_pane;
		_data_->_tmp8_ = _data_->contact;
		contacts_contact_pane_show_contact (_data_->_tmp7_, _data_->_tmp8_, FALSE);
	} else {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
		_data_->_tmp9_ = contacts_app_app;
		_data_->_tmp10_ = _data_->_tmp9_->window;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("No contact with id %s found");
		_data_->_tmp12_ = _data_->_data1_->id;
		_data_->_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp10_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp11_, _data_->_tmp12_);
		_data_->_tmp14_ = g_object_ref_sink (_data_->_tmp13_);
		_data_->_data2_->dialog = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->_data2_->dialog;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp15_, _data_->_tmp16_);
		_data_->_tmp17_ = _data_->_data2_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp17_);
		_data_->_tmp18_ = _data_->_data2_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp18_, "response", (GCallback) ____lambda78__gtk_dialog_response, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ContactsApp * self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->store);
		_g_object_unref0 (_data3_->tree_view);
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda79_ (Block3Data* _data3_, gint response) {
	ContactsApp * self;
	gint _tmp0_;
	GtkDialog* _tmp13_;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	_tmp0_ = response;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		FolksPersonaStore* selected_store = NULL;
		GtkTreeIter iter2 = {0};
		GtkTreeView* _tmp1_;
		GtkTreeSelection* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		_tmp1_ = _data3_->tree_view;
		_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
		_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
		iter2 = _tmp3_;
		if (_tmp4_) {
			GtkListStore* _tmp5_;
			GtkTreeIter _tmp6_;
			FolksPersonaStore* _tmp7_;
			EdsfPersonaStore* _tmp8_;
			EdsfPersonaStore* e_store;
			ContactsStore* _tmp12_;
			_tmp5_ = _data3_->store;
			_tmp6_ = iter2;
			gtk_tree_model_get ((GtkTreeModel*) _tmp5_, &_tmp6_, 1, &selected_store, -1);
			_tmp7_ = selected_store;
			_tmp8_ = _g_object_ref0 (EDSF_IS_PERSONA_STORE (_tmp7_) ? ((EdsfPersonaStore*) _tmp7_) : NULL);
			e_store = _tmp8_;
			{
				EdsfPersonaStore* _tmp9_;
				ESource* _tmp10_;
				ESource* _tmp11_;
				_tmp9_ = e_store;
				_tmp10_ = edsf_persona_store_get_source (_tmp9_);
				_tmp11_ = _tmp10_;
				e_book_client_set_default_source (_tmp11_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
				g_warning ("contacts-app.vala:153: Failed to set address book");
			}
			__finally0:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e_store);
				_g_object_unref0 (selected_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp12_ = self->contacts_store;
			contacts_store_refresh (_tmp12_);
			_g_object_unref0 (e_store);
		}
		_g_object_unref0 (selected_store);
	}
	_tmp13_ = _data3_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
}


static void ___lambda79__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda79_ (self, response_id);
}


void contacts_app_change_address_book (ContactsApp* self) {
	Block3Data* _data3_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* title;
	GtkApplicationWindow* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkListStore* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkListStore* _tmp12_;
	GtkTreeView* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeSelection* _tmp15_ = NULL;
	GtkTreeViewColumn* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkCellRendererText* renderer;
	GtkTreeViewColumn* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkTreeViewColumn* _tmp24_;
	GtkCellRendererText* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	GtkScrolledWindow* scrolled;
	GtkScrolledWindow* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkTreeView* _tmp34_;
	GtkGrid* _tmp35_;
	GtkGrid* _tmp36_;
	GtkGrid* grid;
	GtkGrid* _tmp37_;
	GtkGrid* _tmp38_;
	const gchar* _tmp39_;
	GtkLabel* _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* l;
	GtkLabel* _tmp42_;
	GtkGrid* _tmp43_;
	GtkLabel* _tmp44_;
	GtkGrid* _tmp45_;
	GtkScrolledWindow* _tmp46_;
	GtkDialog* _tmp47_;
	GtkBox* _tmp48_ = NULL;
	GtkBox* _tmp49_;
	GtkBox* box;
	GtkBox* _tmp50_;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkTreeIter iter = {0};
	gint _tmp53_ = 0;
	FolksPersonaStore** _tmp54_ = NULL;
	GtkDialog* _tmp73_;
	GtkDialog* _tmp74_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _ ("Change Address Book");
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	_tmp2_ = self->window;
	_tmp3_ = _ ("Select");
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons ("", GTK_WINDOW (_tmp2_), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_OK, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_data3_->dialog = _tmp5_;
	_tmp6_ = _data3_->dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp6_, FALSE);
	_tmp7_ = _data3_->dialog;
	gtk_dialog_set_default_response (_tmp7_, (gint) GTK_RESPONSE_OK);
	_tmp8_ = (GtkTreeView*) gtk_tree_view_new ();
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_data3_->tree_view = _tmp9_;
	_tmp10_ = gtk_list_store_new (2, G_TYPE_STRING, FOLKS_TYPE_PERSONA_STORE);
	_data3_->store = _tmp10_;
	_tmp11_ = _data3_->tree_view;
	_tmp12_ = _data3_->store;
	gtk_tree_view_set_model (_tmp11_, (GtkTreeModel*) _tmp12_);
	_tmp13_ = _data3_->tree_view;
	gtk_tree_view_set_headers_visible (_tmp13_, FALSE);
	_tmp14_ = _data3_->tree_view;
	_tmp15_ = gtk_tree_view_get_selection (_tmp14_);
	gtk_tree_selection_set_mode (_tmp15_, GTK_SELECTION_BROWSE);
	_tmp16_ = gtk_tree_view_column_new ();
	_tmp17_ = g_object_ref_sink (_tmp16_);
	column = _tmp17_;
	_tmp18_ = _data3_->tree_view;
	_tmp19_ = column;
	gtk_tree_view_append_column (_tmp18_, _tmp19_);
	_tmp20_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp21_ = g_object_ref_sink (_tmp20_);
	renderer = _tmp21_;
	_tmp22_ = column;
	_tmp23_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, FALSE);
	_tmp24_ = column;
	_tmp25_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, "text", 0);
	_tmp26_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp27_ = g_object_ref_sink (_tmp26_);
	scrolled = _tmp27_;
	_tmp28_ = scrolled;
	gtk_widget_set_size_request ((GtkWidget*) _tmp28_, 340, 300);
	_tmp29_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp29_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp30_ = scrolled;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp30_, TRUE);
	_tmp31_ = scrolled;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = scrolled;
	gtk_scrolled_window_set_shadow_type (_tmp32_, GTK_SHADOW_IN);
	_tmp33_ = scrolled;
	_tmp34_ = _data3_->tree_view;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkGrid*) gtk_grid_new ();
	_tmp36_ = g_object_ref_sink (_tmp35_);
	grid = _tmp36_;
	_tmp37_ = grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp37_, GTK_ORIENTATION_VERTICAL);
	_tmp38_ = grid;
	gtk_grid_set_row_spacing (_tmp38_, (guint) 6);
	_tmp39_ = title;
	_tmp40_ = (GtkLabel*) gtk_label_new (_tmp39_);
	_tmp41_ = g_object_ref_sink (_tmp40_);
	l = _tmp41_;
	_tmp42_ = l;
	gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_START);
	_tmp43_ = grid;
	_tmp44_ = l;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = grid;
	_tmp46_ = scrolled;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = _data3_->dialog;
	_tmp48_ = gtk_dialog_get_content_area (_tmp47_);
	_tmp49_ = _g_object_ref0 (GTK_IS_BOX (_tmp48_) ? ((GtkBox*) _tmp48_) : NULL);
	box = _tmp49_;
	_tmp50_ = box;
	_tmp51_ = grid;
	gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, TRUE, TRUE, (guint) 0);
	_tmp52_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp52_, (guint) 6);
	_tmp54_ = contacts_contact_get_eds_address_books (&_tmp53_);
	{
		FolksPersonaStore** persona_store_collection = NULL;
		gint persona_store_collection_length1 = 0;
		gint _persona_store_collection_size_ = 0;
		gint persona_store_it = 0;
		persona_store_collection = _tmp54_;
		persona_store_collection_length1 = _tmp53_;
		for (persona_store_it = 0; persona_store_it < _tmp53_; persona_store_it = persona_store_it + 1) {
			FolksPersonaStore* _tmp55_;
			FolksPersonaStore* persona_store = NULL;
			_tmp55_ = _g_object_ref0 (persona_store_collection[persona_store_it]);
			persona_store = _tmp55_;
			{
				FolksPersonaStore* _tmp56_;
				gchar* _tmp57_ = NULL;
				gchar* name;
				GtkListStore* _tmp58_;
				GtkTreeIter _tmp59_ = {0};
				GtkListStore* _tmp60_;
				GtkTreeIter _tmp61_;
				const gchar* _tmp62_;
				FolksPersonaStore* _tmp63_;
				FolksPersonaStore* _tmp64_;
				ContactsStore* _tmp65_;
				FolksIndividualAggregator* _tmp66_;
				FolksIndividualAggregator* _tmp67_;
				FolksPersonaStore* _tmp68_;
				FolksPersonaStore* _tmp69_;
				_tmp56_ = persona_store;
				_tmp57_ = contacts_contact_format_persona_store_name (_tmp56_);
				name = _tmp57_;
				_tmp58_ = _data3_->store;
				gtk_list_store_append (_tmp58_, &_tmp59_);
				iter = _tmp59_;
				_tmp60_ = _data3_->store;
				_tmp61_ = iter;
				_tmp62_ = name;
				_tmp63_ = persona_store;
				gtk_list_store_set (_tmp60_, &_tmp61_, 0, _tmp62_, 1, _tmp63_, -1);
				_tmp64_ = persona_store;
				_tmp65_ = self->contacts_store;
				_tmp66_ = contacts_store_get_aggregator (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = folks_individual_aggregator_get_primary_store (_tmp67_);
				_tmp69_ = _tmp68_;
				if (_tmp64_ == _tmp69_) {
					GtkTreeView* _tmp70_;
					GtkTreeSelection* _tmp71_ = NULL;
					GtkTreeIter _tmp72_;
					_tmp70_ = _data3_->tree_view;
					_tmp71_ = gtk_tree_view_get_selection (_tmp70_);
					_tmp72_ = iter;
					gtk_tree_selection_select_iter (_tmp71_, &_tmp72_);
				}
				_g_free0 (name);
				_g_object_unref0 (persona_store);
			}
		}
		persona_store_collection = (_vala_array_free (persona_store_collection, persona_store_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_tmp73_ = _data3_->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp73_);
	_tmp74_ = _data3_->dialog;
	g_signal_connect_data (_tmp74_, "response", (GCallback) ___lambda79__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (l);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_free0 (title);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


void contacts_app_show_about (ContactsApp* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** artists;
	gint artists_length1;
	gint _artists_size_;
	GtkApplicationWindow* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Alexander Larsson <alexl@redhat.com>");
	_tmp1_ = g_strdup ("Erick Pérez Castellanos <erick.red@gmail.com>");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Allan Day <allanpday@gmail.com>");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	artists = _tmp4_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp5_ = self->window;
	_tmp6_ = _ ("Gnome Contacts");
	_tmp7_ = _ ("About Gnome Contacts");
	_tmp8_ = _ ("Contact Management Application");
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "artists", artists, "authors", authors, "program-name", _tmp6_, "title", _tmp7_, "comments", _tmp8_, "copyright", "Copyright 2011 Red Hat, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", "avatar-default", "version", PACKAGE_VERSION, "website", "https://live.gnome.org/Contacts", "wrap-license", TRUE, NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void contacts_app_show_by_email_data_free (gpointer _data) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _data;
	_g_free0 (_data_->email_address);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowByEmailData, _data_);
}


void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	ContactsApp* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (ContactsAppShowByEmailData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_by_email);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_address;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->email_address = _tmp2_;
	contacts_app_show_by_email_co (_data_);
}


void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ContactsApp * self;
		self = _data4_->self;
		_g_free0 (_data4_->email_address);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda80_ (Block4Data* _data4_, ContactsContact* c) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = _data4_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _data4_->email_address;
	_tmp2_ = contacts_contact_has_email (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean ___lambda80__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda80_ (self, c);
	return result;
}


static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_by_email_co (_data_);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ContactsApp * self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->dialog);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static void ___lambda81_ (Block5Data* _data5_, gint id) {
	Block4Data* _data4_;
	ContactsApp * self;
	GtkMessageDialog* _tmp0_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = _data5_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda81__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda81_ (self, response_id);
}


static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->email_address;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->_data4_->email_address = _data_->_tmp1_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->self->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp2_, ___lambda80__contacts_store_contact_matcher, _data_->_data4_, contacts_app_show_by_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = contacts_store_find_contact_finish (_data_->_tmp2_, _data_->_res_);
	_data_->contact = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->contact;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->list_pane;
		_data_->_tmp6_ = _data_->contact;
		contacts_list_pane_select_contact (_data_->_tmp5_, _data_->_tmp6_, FALSE);
		_data_->_tmp7_ = _data_->self->priv->contacts_pane;
		_data_->_tmp8_ = _data_->contact;
		contacts_contact_pane_show_contact (_data_->_tmp7_, _data_->_tmp8_, FALSE);
	} else {
		_data_->_data5_ = g_slice_new0 (Block5Data);
		_data_->_data5_->_ref_count_ = 1;
		_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
		_data_->_tmp9_ = contacts_app_app;
		_data_->_tmp10_ = _data_->_tmp9_->window;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("No contact with email address %s found");
		_data_->_tmp12_ = _data_->_data4_->email_address;
		_data_->_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp10_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp11_, _data_->_tmp12_);
		_data_->_tmp14_ = g_object_ref_sink (_data_->_tmp13_);
		_data_->_data5_->dialog = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->_data5_->dialog;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp15_, _data_->_tmp16_);
		_data_->_tmp17_ = _data_->_data5_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp17_);
		_data_->_tmp18_ = _data_->_data5_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp18_, "response", (GCallback) ____lambda81__gtk_dialog_response, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ContactsApp * self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->overlay);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda82_ (ContactsApp* self) {
	GtkApplicationWindow* _tmp0_;
	_tmp0_ = self->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ___lambda82__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda82_ (self);
}


static void __lambda83_ (ContactsApp* self) {
	contacts_app_show_about (self);
}


static void ___lambda83__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda83_ (self);
}


static void __lambda84_ (ContactsApp* self) {
	contacts_app_change_address_book (self);
}


static void ___lambda84__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda84_ (self);
}


static gboolean _contacts_app_window_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_delete_event (self, event);
	return result;
}


static gboolean _contacts_app_window_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_map_event (self, event);
	return result;
}


static gboolean _contacts_app_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_key_press_event (self, event);
	return result;
}


static void __lambda85_ (ContactsApp* self, GtkToolButton* button) {
	ContactsStore* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	ContactsNewContactDialog* _tmp2_;
	ContactsNewContactDialog* _tmp3_;
	ContactsNewContactDialog* dialog;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->contacts_store;
	_tmp1_ = self->window;
	_tmp2_ = contacts_new_contact_dialog_new (_tmp0_, (GtkWindow*) _tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	dialog = _tmp3_;
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void ___lambda85__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda85_ (self, _sender);
}


static void __lambda93_ (ContactsApp* self, GtkToolButton* button) {
	g_return_if_fail (button != NULL);
}


static void ___lambda93__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda93_ (self, _sender);
}


static void __lambda94_ (ContactsApp* self, GtkToolButton* button) {
	g_return_if_fail (button != NULL);
}


static void ___lambda94__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda94_ (self, _sender);
}


static void _contacts_app_selection_changed_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_app_selection_changed (self, contact);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ContactsApp * self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->notification);
		_g_object_unref0 (_data7_->c);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda96_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	ContactsApp * self;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	ContactsContact* _tmp3_;
	FolksIndividual* _tmp4_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = self->contacts_store;
	_tmp1_ = contacts_store_get_aggregator (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data7_->c;
	_tmp4_ = _tmp3_->individual;
	folks_individual_aggregator_remove_individual (_tmp2_, _tmp4_, NULL, NULL);
}


static void ___lambda96__gtk_notification_timed_out (GtkNotification* _sender, gpointer self) {
	__lambda96_ (self);
}


static void __lambda97_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	ContactsApp * self;
	ContactsContact* _tmp0_;
	ContactsListPane* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContactPane* _tmp3_;
	ContactsContact* _tmp4_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	gtk_notification_dismiss (_data7_->notification);
	_tmp0_ = _data7_->c;
	contacts_contact_show (_tmp0_);
	_tmp1_ = self->priv->list_pane;
	_tmp2_ = _data7_->c;
	contacts_list_pane_select_contact (_tmp1_, _tmp2_, FALSE);
	_tmp3_ = self->priv->contacts_pane;
	_tmp4_ = _data7_->c;
	contacts_contact_pane_show_contact (_tmp3_, _tmp4_, FALSE);
}


static void ___lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda97_ (self);
}


static void __lambda95_ (Block6Data* _data6_, ContactsContact* c) {
	ContactsApp * self;
	Block7Data* _data7_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	GtkNotification* _tmp2_;
	GtkNotification* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* g;
	const gchar* _tmp6_ = NULL;
	ContactsContact* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* msg;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* b;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	gulong _tmp15_ = 0UL;
	gulong id;
	self = _data6_->self;
	g_return_if_fail (c != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->_data6_ = block6_data_ref (_data6_);
	_tmp0_ = c;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data7_->c = _tmp1_;
	_tmp2_ = (GtkNotification*) gtk_notification_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_data7_->notification = _tmp3_;
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	g = _tmp5_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	gtk_container_add ((GtkContainer*) _data7_->notification, (GtkWidget*) g);
	_tmp6_ = _ ("Contact deleted: \"%s\"");
	_tmp7_ = _data7_->c;
	_tmp8_ = contacts_contact_get_display_name (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (_tmp6_, _tmp9_);
	msg = _tmp10_;
	_tmp11_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_UNDO);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	b = _tmp12_;
	_tmp13_ = (GtkLabel*) gtk_label_new (msg);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) b);
	gtk_widget_show_all ((GtkWidget*) _data7_->notification);
	_tmp15_ = g_signal_connect_data (_data7_->notification, "timed-out", (GCallback) ___lambda96__gtk_notification_timed_out, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	id = _tmp15_;
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda97__gtk_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	gtk_overlay_add_overlay (_data6_->overlay, (GtkWidget*) _data7_->notification);
	_g_object_unref0 (b);
	_g_free0 (msg);
	_g_object_unref0 (g);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void ___lambda95__contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self) {
	__lambda95_ (self, contact);
}


static void contacts_app_create_window (ContactsApp* self) {
	Block6Data* _data6_;
	ContactsApp* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* action;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GtkBuilder* _tmp12_;
	GtkBuilder* builder;
	GtkApplicationWindow* _tmp14_;
	GtkApplicationWindow* _tmp15_;
	GtkApplicationWindow* _tmp16_;
	GtkApplicationWindow* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GtkApplicationWindow* _tmp19_;
	GtkApplicationWindow* _tmp20_;
	GtkApplicationWindow* _tmp21_;
	GtkApplicationWindow* _tmp22_;
	GtkApplicationWindow* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* grid;
	GtkToolbar* _tmp26_;
	GtkToolbar* _tmp27_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp28_;
	GtkToolbar* _tmp29_;
	GtkStyleContext* _tmp30_ = NULL;
	GtkToolbar* _tmp31_;
	GtkToolbar* _tmp32_;
	GtkToolbar* _tmp33_;
	const gchar* _tmp34_ = NULL;
	GtkToolButton* _tmp35_;
	GtkToolButton* _tmp36_;
	GtkToolButton* add_button;
	GtkToolbar* _tmp37_;
	GtkToolButton* _tmp38_;
	GtkToolButton* _tmp39_;
	GtkToolButton* select_button;
	GtkToolbar* _tmp40_;
	GtkToolbar* _tmp41_;
	GtkToolbar* _tmp42_;
	GtkToolbar* _tmp43_;
	GtkToolbar* _tmp44_;
	GtkStyleContext* _tmp45_ = NULL;
	GtkToolbar* _tmp46_;
	GtkToolbar* _tmp47_;
	GtkToolbar* _tmp48_;
	GtkToolButton* _tmp49_;
	GtkToolButton* _tmp50_;
	GtkToolButton* share_button;
	GtkToolbar* _tmp51_;
	GtkOverlay* _tmp52_;
	GtkOverlay* _tmp53_;
	GdkRGBA _tmp54_ = {0};
	GdkRGBA transparent;
	GdkRGBA _tmp55_;
	GtkApplicationWindow* _tmp56_;
	ContactsStore* _tmp57_;
	ContactsListPane* _tmp58_;
	ContactsListPane* _tmp59_;
	ContactsListPane* _tmp60_;
	ContactsListPane* _tmp61_;
	ContactsStore* _tmp62_;
	ContactsContactPane* _tmp63_;
	ContactsContactPane* _tmp64_;
	ContactsContactPane* _tmp65_;
	ContactsContactPane* _tmp66_;
	ContactsContactPane* _tmp67_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	{
		GtkCssProvider* _tmp0_;
		GtkCssProvider* provider;
		GdkScreen* _tmp1_ = NULL;
		_tmp0_ = gtk_css_provider_new ();
		provider = _tmp0_;
		gtk_css_provider_load_from_path (provider, PKGDATADIR "/" "gnome-contacts.css", &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (provider);
			goto __catch1_g_error;
		}
		_tmp1_ = gdk_screen_get_default ();
		gtk_style_context_add_provider_for_screen (_tmp1_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (provider);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("contacts-app.vala:210: Failed to load custom CSS");
	}
	__finally1:
	if (_inner_error_ != NULL) {
		block6_data_unref (_data6_);
		_data6_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = _g_object_ref0 (self);
	_g_object_unref0 (contacts_app_app);
	contacts_app_app = _tmp2_;
	_tmp3_ = g_simple_action_new ("quit", NULL);
	action = _tmp3_;
	_tmp4_ = action;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda82__g_simple_action_activate, self, 0);
	_tmp5_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp5_);
	_tmp6_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp6_;
	_tmp7_ = action;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda83__g_simple_action_activate, self, 0);
	_tmp8_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp8_);
	_tmp9_ = g_simple_action_new ("change_book", NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda84__g_simple_action_activate, self, 0);
	_tmp11_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp11_);
	_tmp12_ = gtk_builder_new ();
	builder = _tmp12_;
	gtk_builder_set_translation_domain (builder, GETTEXT_PACKAGE);
	{
		GObject* _tmp13_ = NULL;
		gtk_builder_add_from_string (builder, "<interface>" "  <menu id='app-menu'>" "    <section>" "      <item label='_Change Address Book...' action='app.change_book'/>" "    </section>" "    <section>" "      <item label='_About Contacts' action='app.about'/>" "      <item label='_Quit' action='app.quit' accel='<Primary>q'/>" "    </section>" "  </menu>" "</interface>", (gsize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp13_ = gtk_builder_get_object (builder, "app-menu");
		gtk_application_set_app_menu ((GtkApplication*) self, G_MENU_MODEL (_tmp13_));
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("contacts-app.vala:243: Failed to parsing ui file");
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_object_unref0 (action);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	_tmp15_ = g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->window);
	self->window = _tmp15_;
	_tmp16_ = self->window;
	gtk_window_set_application ((GtkWindow*) _tmp16_, (GtkApplication*) self);
	_tmp17_ = self->window;
	_tmp18_ = _ ("Contacts");
	gtk_window_set_title ((GtkWindow*) _tmp17_, _tmp18_);
	_tmp19_ = self->window;
	gtk_widget_set_size_request ((GtkWidget*) _tmp19_, 745, 510);
	_tmp20_ = self->window;
	gtk_window_set_hide_titlebar_when_maximized ((GtkWindow*) _tmp20_, TRUE);
	_tmp21_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "delete-event", (GCallback) _contacts_app_window_delete_event_gtk_widget_delete_event, self, 0);
	_tmp22_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "map-event", (GCallback) _contacts_app_window_map_event_gtk_widget_map_event, self, 0);
	_tmp23_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp23_, "key-press-event", (GCallback) _contacts_app_window_key_press_event_gtk_widget_key_press_event, self, 0);
	_tmp24_ = (GtkGrid*) gtk_grid_new ();
	_tmp25_ = g_object_ref_sink (_tmp24_);
	grid = _tmp25_;
	_tmp26_ = (GtkToolbar*) gtk_toolbar_new ();
	_tmp27_ = g_object_ref_sink (_tmp26_);
	toolbar = _tmp27_;
	_tmp28_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp28_, GTK_ICON_SIZE_MENU);
	_tmp29_ = toolbar;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, GTK_STYLE_CLASS_MENUBAR);
	_tmp31_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp31_, FALSE);
	_tmp32_ = toolbar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp32_, TRUE);
	_tmp33_ = toolbar;
	gtk_grid_attach (grid, (GtkWidget*) _tmp33_, 0, 0, 1, 1);
	_tmp34_ = _ ("Add...");
	_tmp35_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp34_);
	_tmp36_ = g_object_ref_sink (_tmp35_);
	add_button = _tmp36_;
	gtk_widget_set_margin_left ((GtkWidget*) add_button, 4);
	gtk_tool_item_set_is_important ((GtkToolItem*) add_button, TRUE);
	_tmp37_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) add_button);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda85__gtk_tool_button_clicked, self, 0);
	_tmp38_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	_tmp39_ = g_object_ref_sink (_tmp38_);
	select_button = _tmp39_;
	gtk_tool_button_set_icon_name (select_button, "object-select-symbolic");
	gtk_tool_item_set_is_important ((GtkToolItem*) select_button, FALSE);
	gtk_widget_set_halign ((GtkWidget*) select_button, GTK_ALIGN_END);
	gtk_tool_item_set_expand ((GtkToolItem*) select_button, TRUE);
	_tmp40_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) select_button);
	g_signal_connect_object (select_button, "clicked", (GCallback) ___lambda93__gtk_tool_button_clicked, self, 0);
	_tmp41_ = (GtkToolbar*) gtk_toolbar_new ();
	_tmp42_ = g_object_ref_sink (_tmp41_);
	_g_object_unref0 (toolbar);
	toolbar = _tmp42_;
	_tmp43_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp43_, GTK_ICON_SIZE_MENU);
	_tmp44_ = toolbar;
	_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _tmp44_);
	gtk_style_context_add_class (_tmp45_, GTK_STYLE_CLASS_MENUBAR);
	_tmp46_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp46_, FALSE);
	_tmp47_ = toolbar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp47_, TRUE);
	_tmp48_ = toolbar;
	gtk_grid_attach (grid, (GtkWidget*) _tmp48_, 1, 0, 1, 1);
	_tmp49_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	_tmp50_ = g_object_ref_sink (_tmp49_);
	share_button = _tmp50_;
	gtk_widget_set_margin_right ((GtkWidget*) share_button, 4);
	gtk_tool_button_set_icon_name (share_button, "send-to-symbolic");
	gtk_tool_item_set_is_important ((GtkToolItem*) share_button, FALSE);
	gtk_widget_set_halign ((GtkWidget*) share_button, GTK_ALIGN_END);
	gtk_tool_item_set_expand ((GtkToolItem*) share_button, TRUE);
	_tmp51_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) share_button);
	g_signal_connect_object (share_button, "clicked", (GCallback) ___lambda94__gtk_tool_button_clicked, self, 0);
	_tmp52_ = (GtkOverlay*) gtk_overlay_new ();
	_tmp53_ = g_object_ref_sink (_tmp52_);
	_data6_->overlay = _tmp53_;
	gtk_container_add ((GtkContainer*) _data6_->overlay, (GtkWidget*) grid);
	_tmp54_.red = (gdouble) 0;
	_tmp54_.green = (gdouble) 0;
	_tmp54_.blue = (gdouble) 0;
	_tmp54_.alpha = (gdouble) 0;
	transparent = _tmp54_;
	_tmp55_ = transparent;
	gtk_widget_override_background_color ((GtkWidget*) _data6_->overlay, 0, &_tmp55_);
	_tmp56_ = self->window;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _data6_->overlay);
	_tmp57_ = self->contacts_store;
	_tmp58_ = contacts_list_pane_new (_tmp57_);
	_tmp59_ = g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->list_pane);
	self->priv->list_pane = _tmp59_;
	_tmp60_ = self->priv->list_pane;
	g_signal_connect_object (_tmp60_, "selection-changed", (GCallback) _contacts_app_selection_changed_contacts_list_pane_selection_changed, self, 0);
	_tmp61_ = self->priv->list_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp61_, 0, 1, 1, 1);
	_tmp62_ = self->contacts_store;
	_tmp63_ = contacts_contact_pane_new (_tmp62_);
	_tmp64_ = g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->contacts_pane);
	self->priv->contacts_pane = _tmp64_;
	_tmp65_ = self->priv->contacts_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp65_, TRUE);
	_tmp66_ = self->priv->contacts_pane;
	g_signal_connect_data (_tmp66_, "will-delete", (GCallback) ___lambda95__contacts_contact_pane_will_delete, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp67_ = self->priv->contacts_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp67_, 1, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) _data6_->overlay);
	_g_object_unref0 (share_button);
	_g_object_unref0 (select_button);
	_g_object_unref0 (add_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	_g_object_unref0 (action);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void contacts_app_real_startup (GApplication* base) {
	ContactsApp * self;
	ContactsStore* _tmp0_;
	self = (ContactsApp*) base;
	contacts_ensure_eds_accounts ();
	_tmp0_ = contacts_store_new ();
	_g_object_unref0 (self->contacts_store);
	self->contacts_store = _tmp0_;
	G_APPLICATION_CLASS (contacts_app_parent_class)->startup ((GApplication*) GTK_APPLICATION (self));
}


static void ___lambda98_ (ContactsApp* self) {
	ContactsApp* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	_tmp0_ = contacts_app_app;
	_tmp1_ = _tmp0_->window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
}


static void ____lambda98__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	___lambda98_ (self);
}


static gboolean ___lambda99_ (ContactsApp* self) {
	gboolean result = FALSE;
	ContactsApp* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	_tmp0_ = contacts_app_app;
	_tmp1_ = _tmp0_->window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda99__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda99_ (self);
	return result;
}


static void contacts_app_real_activate (GApplication* base) {
	ContactsApp * self;
	GtkApplicationWindow* _tmp0_;
	self = (ContactsApp*) base;
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		ContactsStore* _tmp1_;
		contacts_app_create_window (self);
		_tmp1_ = self->contacts_store;
		g_signal_connect_object (_tmp1_, "quiescent", (GCallback) ____lambda98__contacts_store_quiescent, self, 0);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda99__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		GtkApplicationWindow* _tmp2_;
		_tmp2_ = self->window;
		gtk_window_present ((GtkWindow*) _tmp2_);
	}
}


static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line) {
	ContactsApp * self;
	gint result = 0;
	GApplicationCommandLine* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _args;
	gint _args_length1;
	gint __args_size_;
	GOptionContext* _tmp4_;
	GOptionContext* context;
	GOptionContext* _tmp5_;
	GOptionContext* _tmp6_;
	GOptionContext* _tmp7_;
	GOptionGroup* _tmp8_ = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (ContactsApp*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = command_line;
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
	args = _tmp2_;
	args_length1 = _tmp1_;
	_args_size_ = args_length1;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_args = _tmp3_;
	_args_length1 = _tmp3__length1;
	__args_size_ = _args_length1;
	_tmp4_ = g_option_context_new ("— contact management");
	context = _tmp4_;
	_tmp5_ = context;
	g_option_context_add_main_entries (_tmp5_, CONTACTS_APP_options, GETTEXT_PACKAGE);
	_tmp6_ = context;
	g_option_context_set_translation_domain (_tmp6_, GETTEXT_PACKAGE);
	_tmp7_ = context;
	_tmp8_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp7_, _tmp8_);
	_g_free0 (contacts_app_individual_id);
	contacts_app_individual_id = NULL;
	_g_free0 (contacts_app_email_address);
	contacts_app_email_address = NULL;
	{
		GOptionContext* _tmp9_;
		_tmp9_ = context;
		g_option_context_parse (_tmp9_, &_args_length1, &_args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_printerr ("Unable to parse: %s\n", _tmp11_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_application_activate ((GApplication*) self);
	_tmp12_ = contacts_app_individual_id;
	if (_tmp12_ != NULL) {
		ContactsApp* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = contacts_app_app;
		_tmp14_ = contacts_app_individual_id;
		contacts_app_show_individual (_tmp13_, _tmp14_, NULL, NULL);
	}
	_tmp15_ = contacts_app_email_address;
	if (_tmp15_ != NULL) {
		ContactsApp* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = contacts_app_app;
		_tmp17_ = contacts_app_email_address;
		contacts_app_show_by_email (_tmp16_, _tmp17_, NULL, NULL);
	}
	result = 0;
	_g_option_context_free0 (context);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ContactsApp* contacts_app_construct (GType object_type) {
	ContactsApp * self = NULL;
	self = (ContactsApp*) g_object_new (object_type, "application-id", "org.gnome.Contacts", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	return self;
}


ContactsApp* contacts_app_new (void) {
	return contacts_app_construct (CONTACTS_TYPE_APP);
}


static void contacts_app_class_init (ContactsAppClass * klass) {
	contacts_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAppPrivate));
	G_APPLICATION_CLASS (klass)->startup = contacts_app_real_startup;
	G_APPLICATION_CLASS (klass)->activate = contacts_app_real_activate;
	G_APPLICATION_CLASS (klass)->command_line = contacts_app_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = contacts_app_finalize;
}


static void contacts_app_instance_init (ContactsApp * self) {
	self->priv = CONTACTS_APP_GET_PRIVATE (self);
}


static void contacts_app_finalize (GObject* obj) {
	ContactsApp * self;
	self = CONTACTS_APP (obj);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->contacts_store);
	_g_object_unref0 (self->priv->list_pane);
	_g_object_unref0 (self->priv->contacts_pane);
	G_OBJECT_CLASS (contacts_app_parent_class)->finalize (obj);
}


GType contacts_app_get_type (void) {
	static volatile gsize contacts_app_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsApp), 0, (GInstanceInitFunc) contacts_app_instance_init, NULL };
		GType contacts_app_type_id;
		contacts_app_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "ContactsApp", &g_define_type_info, 0);
		g_once_init_leave (&contacts_app_type_id__volatile, contacts_app_type_id);
	}
	return contacts_app_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



