/* dconf-update.c generated by valac 0.14.0, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <gvdb-builder.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GvdbItem* get_parent (GHashTable* table, const gchar* name);
GHashTable* read_locks_directory (const gchar* dirname, GError** error);
GHashTable* read_directory (const gchar* dirname, GError** error);
void maybe_update_from_directory (const gchar* dirname, GError** error);
void update_all (const gchar* dirname, GError** error);
void dconf_update (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


GvdbItem* get_parent (GHashTable* table, const gchar* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent = NULL;
	gint end;
	gint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* parent_name;
	GHashTable* _tmp14_;
	const gchar* _tmp15_;
	gconstpointer _tmp16_ = NULL;
	GvdbItem* _tmp17_;
	GvdbItem* _tmp25_;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	end = 0;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				const gchar* _tmp3_;
				gint _tmp4_;
				gchar _tmp5_ = '\0';
				const gchar* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_ = '\0';
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = name;
				_tmp4_ = i;
				_tmp5_ = string_get (_tmp3_, (glong) _tmp4_);
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = name;
				_tmp7_ = i;
				_tmp8_ = string_get (_tmp6_, (glong) (_tmp7_ - 1));
				if (_tmp8_ == '/') {
					gint _tmp9_;
					_tmp9_ = i;
					end = _tmp9_;
				}
			}
		}
	}
	_tmp10_ = end;
	g_assert (_tmp10_ != 0);
	_tmp11_ = name;
	_tmp12_ = end;
	_tmp13_ = string_substring (_tmp11_, (glong) 0, (glong) _tmp12_);
	parent_name = _tmp13_;
	_tmp14_ = table;
	_tmp15_ = parent_name;
	_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
	parent = (GvdbItem*) _tmp16_;
	_tmp17_ = parent;
	if (_tmp17_ == NULL) {
		GHashTable* _tmp18_;
		const gchar* _tmp19_;
		GvdbItem* _tmp20_ = NULL;
		GvdbItem* _tmp21_;
		GHashTable* _tmp22_;
		const gchar* _tmp23_;
		GvdbItem* _tmp24_ = NULL;
		_tmp18_ = table;
		_tmp19_ = parent_name;
		_tmp20_ = gvdb_hash_table_insert (_tmp18_, _tmp19_);
		parent = _tmp20_;
		_tmp21_ = parent;
		_tmp22_ = table;
		_tmp23_ = parent_name;
		_tmp24_ = get_parent (_tmp22_, _tmp23_);
		gvdb_item_set_parent (_tmp21_, _tmp24_);
	}
	_tmp25_ = parent;
	result = _tmp25_;
	_g_free0 (parent_name);
	return result;
}


GHashTable* read_locks_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GDir* dir = NULL;
	GHashTable* _tmp3_;
	GHashTable* table;
	const gchar* name = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	{
		const gchar* _tmp0_;
		GDir* _tmp1_ = NULL;
		GDir* _tmp2_;
		_tmp0_ = dirname;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_dir_close0 (dir);
		dir = _tmp2_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		result = NULL;
		_g_dir_close0 (dir);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (dir);
		return NULL;
	}
	_tmp3_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp3_;
	while (TRUE) {
		GDir* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* filename;
		struct stat buf = {0};
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		struct stat _tmp12_ = {0};
		gint _tmp13_ = 0;
		gboolean _tmp17_;
		gchar* contents = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_ = NULL;
		_tmp4_ = dir;
		_tmp5_ = g_dir_read_name (_tmp4_);
		name = _tmp5_;
		_tmp6_ = name;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = dirname;
		_tmp8_ = name;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		filename = _tmp9_;
		_tmp11_ = filename;
		_tmp13_ = stat (_tmp11_, &_tmp12_);
		buf = _tmp12_;
		if (_tmp13_ < 0) {
			_tmp10_ = TRUE;
		} else {
			struct stat _tmp14_;
			mode_t _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = buf;
			_tmp15_ = _tmp14_.st_mode;
			_tmp16_ = S_ISREG (_tmp15_);
			_tmp10_ = !_tmp16_;
		}
		_tmp17_ = _tmp10_;
		if (_tmp17_) {
			_g_free0 (filename);
			continue;
		}
		_tmp18_ = filename;
		g_file_get_contents (_tmp18_, &_tmp19_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp19_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			_g_free0 (filename);
			_g_hash_table_unref0 (table);
			_g_dir_close0 (dir);
			return NULL;
		}
		_tmp20_ = contents;
		_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "\n", 0);
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp22_;
			line_collection_length1 = _vala_array_length (_tmp21_);
			for (line_it = 0; line_it < _vala_array_length (_tmp21_); line_it = line_it + 1) {
				gchar* _tmp23_;
				gchar* line = NULL;
				_tmp23_ = g_strdup (line_collection[line_it]);
				line = _tmp23_;
				{
					const gchar* _tmp24_;
					gboolean _tmp25_ = FALSE;
					_tmp24_ = line;
					_tmp25_ = g_str_has_prefix (_tmp24_, "/");
					if (_tmp25_) {
						GHashTable* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = table;
						_tmp27_ = line;
						gvdb_hash_table_insert_string (_tmp26_, _tmp27_, "");
					}
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (contents);
		_g_free0 (filename);
	}
	result = table;
	_g_dir_close0 (dir);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GHashTable* read_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* table;
	const gchar* name = NULL;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	GDir* _tmp3_ = NULL;
	GDir* dir;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	GHashTable* _tmp95_ = NULL;
	GHashTable* _tmp96_;
	GHashTable* locks;
	GHashTable* _tmp97_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp0_;
	_tmp1_ = table;
	gvdb_hash_table_insert (_tmp1_, "/");
	_tmp2_ = dirname;
	_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error_);
	dir = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	while (TRUE) {
		GDir* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* filename;
		struct stat buf = {0};
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		struct stat _tmp12_ = {0};
		gint _tmp13_ = 0;
		gboolean _tmp17_;
		GKeyFile* _tmp18_;
		GKeyFile* kf;
		GKeyFile* _tmp25_;
		gsize _tmp26_;
		gchar** _tmp27_ = NULL;
		_tmp4_ = dir;
		_tmp5_ = g_dir_read_name (_tmp4_);
		name = _tmp5_;
		_tmp6_ = name;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = dirname;
		_tmp8_ = name;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		filename = _tmp9_;
		_tmp11_ = filename;
		_tmp13_ = stat (_tmp11_, &_tmp12_);
		buf = _tmp12_;
		if (_tmp13_ < 0) {
			_tmp10_ = TRUE;
		} else {
			struct stat _tmp14_;
			mode_t _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = buf;
			_tmp15_ = _tmp14_.st_mode;
			_tmp16_ = S_ISREG (_tmp15_);
			_tmp10_ = !_tmp16_;
		}
		_tmp17_ = _tmp10_;
		if (_tmp17_) {
			_g_free0 (filename);
			continue;
		}
		_tmp18_ = g_key_file_new ();
		kf = _tmp18_;
		{
			GKeyFile* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = kf;
			_tmp20_ = filename;
			g_key_file_load_from_file (_tmp19_, _tmp20_, G_KEY_FILE_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp21_;
			const gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = stderr;
			_tmp22_ = filename;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			fprintf (_tmp21_, "%s: %s\n", _tmp22_, _tmp24_);
			_g_error_free0 (e);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			continue;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			_g_dir_close0 (dir);
			_g_hash_table_unref0 (table);
			return NULL;
		}
		_tmp25_ = kf;
		_tmp27_ = g_key_file_get_groups (_tmp25_, &_tmp26_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp27_;
			group_collection_length1 = _tmp26_;
			for (group_it = 0; group_it < _tmp26_; group_it = group_it + 1) {
				gchar* _tmp28_;
				gchar* group = NULL;
				_tmp28_ = g_strdup (group_collection[group_it]);
				group = _tmp28_;
				{
					gboolean _tmp29_ = FALSE;
					gboolean _tmp30_ = FALSE;
					const gchar* _tmp31_;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp35_;
					gboolean _tmp38_;
					GKeyFile* _tmp42_;
					const gchar* _tmp43_;
					gsize _tmp44_;
					gchar** _tmp45_ = NULL;
					gchar** _tmp46_;
					gint _tmp46__length1;
					gint __tmp46__size_;
					_tmp31_ = group;
					_tmp32_ = g_str_has_prefix (_tmp31_, "/");
					if (_tmp32_) {
						_tmp30_ = TRUE;
					} else {
						const gchar* _tmp33_;
						gboolean _tmp34_ = FALSE;
						_tmp33_ = group;
						_tmp34_ = g_str_has_suffix (_tmp33_, "/");
						_tmp30_ = _tmp34_;
					}
					_tmp35_ = _tmp30_;
					if (_tmp35_) {
						_tmp29_ = TRUE;
					} else {
						const gchar* _tmp36_;
						gboolean _tmp37_ = FALSE;
						_tmp36_ = group;
						_tmp37_ = string_contains (_tmp36_, "//");
						_tmp29_ = _tmp37_;
					}
					_tmp38_ = _tmp29_;
					if (_tmp38_) {
						FILE* _tmp39_;
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						_tmp39_ = stderr;
						_tmp40_ = filename;
						_tmp41_ = group;
						fprintf (_tmp39_, "%s: ignoring invalid group name: %s\n", _tmp40_, _tmp41_);
						_g_free0 (group);
						continue;
					}
					_tmp42_ = kf;
					_tmp43_ = group;
					_tmp45_ = g_key_file_get_keys (_tmp42_, _tmp43_, &_tmp44_, &_inner_error_);
					_tmp46_ = _tmp45_;
					_tmp46__length1 = _tmp44_;
					__tmp46__size_ = _tmp46__length1;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (kf);
						_g_free0 (filename);
						_g_dir_close0 (dir);
						_g_hash_table_unref0 (table);
						return NULL;
					}
					{
						gchar** key_collection = NULL;
						gint key_collection_length1 = 0;
						gint _key_collection_size_ = 0;
						gint key_it = 0;
						key_collection = _tmp46_;
						key_collection_length1 = _tmp46__length1;
						for (key_it = 0; key_it < _tmp46__length1; key_it = key_it + 1) {
							gchar* _tmp47_;
							gchar* key = NULL;
							_tmp47_ = g_strdup (key_collection[key_it]);
							key = _tmp47_;
							{
								const gchar* _tmp48_;
								gboolean _tmp49_ = FALSE;
								const gchar* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								const gchar* _tmp59_;
								gchar* _tmp60_;
								gchar* _tmp61_;
								gchar* path;
								GHashTable* _tmp62_;
								const gchar* _tmp63_;
								gconstpointer _tmp64_ = NULL;
								GKeyFile* _tmp70_;
								const gchar* _tmp71_;
								const gchar* _tmp72_;
								gchar* _tmp73_ = NULL;
								gchar* text;
								_tmp48_ = key;
								_tmp49_ = string_contains (_tmp48_, "/");
								if (_tmp49_) {
									FILE* _tmp50_;
									const gchar* _tmp51_;
									const gchar* _tmp52_;
									const gchar* _tmp53_;
									_tmp50_ = stderr;
									_tmp51_ = filename;
									_tmp52_ = group;
									_tmp53_ = key;
									fprintf (_tmp50_, "%s: [%s]: ignoring invalid key name: %s\n", _tmp51_, _tmp52_, _tmp53_);
									_g_free0 (key);
									continue;
								}
								_tmp54_ = group;
								_tmp55_ = g_strconcat ("/", _tmp54_, NULL);
								_tmp56_ = _tmp55_;
								_tmp57_ = g_strconcat (_tmp56_, "/", NULL);
								_tmp58_ = _tmp57_;
								_tmp59_ = key;
								_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
								_tmp61_ = _tmp60_;
								_g_free0 (_tmp58_);
								_g_free0 (_tmp56_);
								path = _tmp61_;
								_tmp62_ = table;
								_tmp63_ = path;
								_tmp64_ = g_hash_table_lookup (_tmp62_, _tmp63_);
								if (((GvdbItem*) _tmp64_) != NULL) {
									FILE* _tmp65_;
									const gchar* _tmp66_;
									const gchar* _tmp67_;
									const gchar* _tmp68_;
									const gchar* _tmp69_;
									_tmp65_ = stderr;
									_tmp66_ = filename;
									_tmp67_ = group;
									_tmp68_ = key;
									_tmp69_ = path;
									fprintf (_tmp65_, "%s: [%s]: %s: ignoring duplicate definition of key %s\n", _tmp66_, _tmp67_, _tmp68_, _tmp69_);
									_g_free0 (path);
									_g_free0 (key);
									continue;
								}
								_tmp70_ = kf;
								_tmp71_ = group;
								_tmp72_ = key;
								_tmp73_ = g_key_file_get_value (_tmp70_, _tmp71_, _tmp72_, &_inner_error_);
								text = _tmp73_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								{
									const gchar* _tmp74_;
									GVariant* _tmp75_ = NULL;
									GVariant* value;
									GHashTable* _tmp76_;
									const gchar* _tmp77_;
									GvdbItem* _tmp78_ = NULL;
									GvdbItem* item;
									GvdbItem* _tmp79_;
									GHashTable* _tmp80_;
									const gchar* _tmp81_;
									GvdbItem* _tmp82_ = NULL;
									GvdbItem* _tmp83_;
									GVariant* _tmp84_;
									_tmp74_ = text;
									_tmp75_ = g_variant_parse (NULL, _tmp74_, NULL, NULL, &_inner_error_);
									value = _tmp75_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
											goto __catch3_g_variant_parse_error;
										}
										_g_free0 (text);
										_g_free0 (path);
										_g_free0 (key);
										key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (group);
										group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
										_g_key_file_free0 (kf);
										_g_free0 (filename);
										_g_dir_close0 (dir);
										_g_hash_table_unref0 (table);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
									_tmp76_ = table;
									_tmp77_ = path;
									_tmp78_ = gvdb_hash_table_insert (_tmp76_, _tmp77_);
									item = _tmp78_;
									_tmp79_ = item;
									_tmp80_ = table;
									_tmp81_ = path;
									_tmp82_ = get_parent (_tmp80_, _tmp81_);
									gvdb_item_set_parent (_tmp79_, _tmp82_);
									_tmp83_ = item;
									_tmp84_ = value;
									gvdb_item_set_value (_tmp83_, _tmp84_);
									_g_variant_unref0 (value);
								}
								goto __finally3;
								__catch3_g_variant_parse_error:
								{
									GError* e = NULL;
									FILE* _tmp85_;
									const gchar* _tmp86_;
									const gchar* _tmp87_;
									const gchar* _tmp88_;
									const gchar* _tmp89_;
									GError* _tmp90_;
									const gchar* _tmp91_;
									e = _inner_error_;
									_inner_error_ = NULL;
									_tmp85_ = stderr;
									_tmp86_ = filename;
									_tmp87_ = group;
									_tmp88_ = key;
									_tmp89_ = text;
									_tmp90_ = e;
									_tmp91_ = _tmp90_->message;
									fprintf (_tmp85_, "%s: [%s]: %s: skipping invalid value: %s (%s)\n", _tmp86_, _tmp87_, _tmp88_, _tmp89_, _tmp91_);
									_g_error_free0 (e);
								}
								__finally3:
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (text);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								_g_free0 (text);
								_g_free0 (path);
								_g_free0 (key);
							}
						}
						key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_key_file_free0 (kf);
		_g_free0 (filename);
	}
	_tmp92_ = dirname;
	_tmp93_ = g_strconcat (_tmp92_, "/locks", NULL);
	_tmp94_ = _tmp93_;
	_tmp95_ = read_locks_directory (_tmp94_, &_inner_error_);
	_tmp96_ = _tmp95_;
	_g_free0 (_tmp94_);
	locks = _tmp96_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (dir);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	_tmp97_ = locks;
	if (_tmp97_ != NULL) {
		GHashTable* _tmp98_;
		GvdbItem* _tmp99_ = NULL;
		GvdbItem* item;
		GvdbItem* _tmp100_;
		GHashTable* _tmp101_;
		_tmp98_ = table;
		_tmp99_ = gvdb_hash_table_insert (_tmp98_, ".locks");
		item = _tmp99_;
		_tmp100_ = item;
		_tmp101_ = locks;
		gvdb_item_set_hash_table (_tmp100_, _tmp101_);
	}
	result = table;
	_g_hash_table_unref0 (locks);
	_g_dir_close0 (dir);
	return result;
}


void maybe_update_from_directory (const gchar* dirname, GError** error) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	struct stat _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp1_ = dirname;
	_tmp3_ = stat (_tmp1_, &_tmp2_);
	dir_buf = _tmp2_;
	if (_tmp3_ == 0) {
		struct stat _tmp4_;
		mode_t _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = dir_buf;
		_tmp5_ = _tmp4_.st_mode;
		_tmp6_ = S_ISDIR (_tmp5_);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		struct stat lockdir_buf = {0};
		struct stat file_buf = {0};
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* filename;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		struct stat _tmp17_ = {0};
		gint _tmp18_ = 0;
		gboolean _tmp19_;
		gboolean _tmp24_;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		struct stat _tmp29_ = {0};
		gint _tmp30_ = 0;
		gboolean _tmp35_;
		const gchar* _tmp36_;
		GHashTable* _tmp37_ = NULL;
		GHashTable* table;
		const gchar* _tmp38_;
		gint _tmp39_ = 0;
		gint fd;
		gboolean _tmp40_ = FALSE;
		gint _tmp41_;
		gboolean _tmp43_;
		_tmp8_ = dirname;
		_tmp9_ = dirname;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) 0, (glong) (_tmp11_ - 2));
		filename = _tmp12_;
		_tmp14_ = dirname;
		_tmp15_ = g_strconcat (_tmp14_, "/locks", NULL);
		_tmp16_ = _tmp15_;
		_tmp18_ = stat (_tmp16_, &_tmp17_);
		lockdir_buf = _tmp17_;
		_tmp19_ = _tmp18_ == 0;
		_g_free0 (_tmp16_);
		if (_tmp19_) {
			struct stat _tmp20_;
			time_t _tmp21_;
			struct stat _tmp22_;
			time_t _tmp23_;
			_tmp20_ = lockdir_buf;
			_tmp21_ = _tmp20_.st_mtime;
			_tmp22_ = dir_buf;
			_tmp23_ = _tmp22_.st_mtime;
			_tmp13_ = _tmp21_ > _tmp23_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp24_ = _tmp13_;
		if (_tmp24_) {
			struct stat _tmp25_;
			time_t _tmp26_;
			_tmp25_ = lockdir_buf;
			_tmp26_ = _tmp25_.st_mtime;
			dir_buf.st_mtime = _tmp26_;
		}
		_tmp28_ = filename;
		_tmp30_ = stat (_tmp28_, &_tmp29_);
		file_buf = _tmp29_;
		if (_tmp30_ == 0) {
			struct stat _tmp31_;
			time_t _tmp32_;
			struct stat _tmp33_;
			time_t _tmp34_;
			_tmp31_ = file_buf;
			_tmp32_ = _tmp31_.st_mtime;
			_tmp33_ = dir_buf;
			_tmp34_ = _tmp33_.st_mtime;
			_tmp27_ = _tmp32_ > _tmp34_;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp35_ = _tmp27_;
		if (_tmp35_) {
			_g_free0 (filename);
			return;
		}
		_tmp36_ = dirname;
		_tmp37_ = read_directory (_tmp36_, &_inner_error_);
		table = _tmp37_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		}
		_tmp38_ = filename;
		_tmp39_ = open (_tmp38_, O_WRONLY, (mode_t) 0);
		fd = _tmp39_;
		_tmp41_ = fd;
		if (_tmp41_ < 0) {
			gint _tmp42_;
			_tmp42_ = errno;
			_tmp40_ = _tmp42_ != ENOENT;
		} else {
			_tmp40_ = FALSE;
		}
		_tmp43_ = _tmp40_;
		if (_tmp43_) {
			gint _tmp44_;
			gint saved_error;
			const gchar* _tmp45_;
			gint _tmp46_;
			const gchar* _tmp47_ = NULL;
			GError* _tmp48_;
			_tmp44_ = errno;
			saved_error = _tmp44_;
			_tmp45_ = filename;
			_tmp46_ = saved_error;
			_tmp47_ = g_strerror (_tmp46_);
			_tmp48_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Can not open '%s' for replacement: %s", _tmp45_, _tmp47_);
			_inner_error_ = _tmp48_;
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GHashTable* _tmp49_;
			const gchar* _tmp50_;
			gint _tmp51_;
			_tmp49_ = table;
			_tmp50_ = filename;
			gvdb_table_write_contents (_tmp49_, _tmp50_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __finally4;
			}
			_tmp51_ = fd;
			if (_tmp51_ >= 0) {
				gint _tmp52_;
				_tmp52_ = fd;
				write (_tmp52_, "\0\0\0\0\0\0\0\0", (gsize) 8);
			}
		}
		__finally4:
		{
			gint _tmp53_;
			_tmp53_ = fd;
			if (_tmp53_ >= 0) {
				gint _tmp54_;
				_tmp54_ = fd;
				close (_tmp54_);
			}
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GDBusConnection* _tmp55_ = NULL;
			GDBusConnection* system_bus;
			GDBusConnection* _tmp56_;
			const gchar* _tmp57_;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			GVariant* _tmp62_;
			GVariant* _tmp63_;
			GDBusConnection* _tmp64_;
			_tmp55_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
			system_bus = _tmp55_;
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			_tmp56_ = system_bus;
			_tmp57_ = filename;
			_tmp58_ = g_path_get_basename (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat ("/ca/desrt/dconf/Writer/", _tmp59_, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = g_variant_new ("(s)", "/", NULL);
			_tmp63_ = g_variant_ref_sink (_tmp62_);
			g_dbus_connection_emit_signal (_tmp56_, NULL, _tmp61_, "ca.desrt.dconf.Writer", "WritabilityNotify", _tmp63_, &_inner_error_);
			_g_variant_unref0 (_tmp63_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp59_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch5_g_error;
			}
			_tmp64_ = system_bus;
			g_dbus_connection_flush_sync (_tmp64_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch5_g_error;
			}
			_g_object_unref0 (system_bus);
		}
		goto __finally5;
		__catch5_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const gchar* dirname, GError** error) {
	const gchar* name = NULL;
	const gchar* _tmp0_;
	GDir* _tmp1_ = NULL;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp0_ = dirname;
	_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
	dir = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	while (TRUE) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = g_dir_read_name (dir);
		name = _tmp2_;
		_tmp3_ = name;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = name;
		_tmp5_ = g_str_has_suffix (_tmp4_, ".d");
		if (_tmp5_) {
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				_tmp6_ = dirname;
				_tmp7_ = name;
				_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				maybe_update_from_directory (_tmp9_, &_inner_error_);
				_g_free0 (_tmp9_);
				if (_inner_error_ != NULL) {
					goto __catch6_g_error;
				}
			}
			goto __finally6;
			__catch6_g_error:
			{
				GError* e = NULL;
				FILE* _tmp10_;
				GError* _tmp11_;
				const gchar* _tmp12_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp10_ = stderr;
				_tmp11_ = e;
				_tmp12_ = _tmp11_->message;
				fprintf (_tmp10_, "%s\n", _tmp12_);
				_g_error_free0 (e);
			}
			__finally6:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_dir_close0 (dir);
				return;
			}
		}
	}
	_g_dir_close0 (dir);
}


void dconf_update (gchar** args, int args_length1) {
	GError * _inner_error_ = NULL;
	{
		update_all ("/etc/dconf/db", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "fatal: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



