/* dconf-client.c generated by valac 0.14.0, the Vala compiler
 * generated from dconf-client.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dconf-engine.h>
#include <dconf.h>


#define DCONF_TYPE_CLIENT (dconf_client_get_type ())
#define DCONF_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DCONF_TYPE_CLIENT, DConfClient))
#define DCONF_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DCONF_TYPE_CLIENT, DConfClientClass))
#define DCONF_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DCONF_TYPE_CLIENT))
#define DCONF_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DCONF_TYPE_CLIENT))
#define DCONF_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DCONF_TYPE_CLIENT, DConfClientClass))

typedef struct _DConfClient DConfClient;
typedef struct _DConfClientClass DConfClientClass;
typedef struct _DConfClientPrivate DConfClientPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dconf_engine_free0(var) ((var == NULL) ? NULL : (var = (dconf_engine_free (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DconfClientCallAsyncData DconfClientCallAsyncData;
typedef struct _DconfClientWriteAsyncData DconfClientWriteAsyncData;
typedef struct _DconfClientWatchAsyncData DconfClientWatchAsyncData;
typedef struct _DconfClientUnwatchAsyncData DconfClientUnwatchAsyncData;

typedef void (*DConfWatchFunc) (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag, void* user_data);
struct _DConfClient {
	GObject parent_instance;
	DConfClientPrivate * priv;
};

struct _DConfClientClass {
	GObjectClass parent_class;
};

struct _DConfClientPrivate {
	GDBusConnection* session;
	GDBusConnection* system;
	DConfWatchFunc watch_func;
	gpointer watch_func_target;
	GDestroyNotify watch_func_target_destroy_notify;
	DConfEngine* engine;
};

struct _DconfClientCallAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	DConfEngineMessage dcem;
	gchar* tag;
	GCancellable* cancellable;
	GDBusConnection* connection;
	DConfEngineMessage _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar _tmp2_;
	GDBusConnection* _tmp3_;
	GCancellable* _tmp4_;
	GDBusConnection* _tmp5_;
	GDBusConnection* _tmp6_;
	GDBusConnection* _tmp7_;
	GDBusConnection* _tmp8_;
	DConfEngineMessage _tmp9_;
	gchar* _tmp10_;
	gint _tmp10__length1;
	gchar _tmp11_;
	GDBusConnection* _tmp12_;
	GCancellable* _tmp13_;
	GDBusConnection* _tmp14_;
	GDBusConnection* _tmp15_;
	GDBusConnection* _tmp16_;
	GDBusConnection* _tmp17_;
	DConfEngineMessage _tmp18_;
	GVariant** _tmp19_;
	gint _tmp19__length1;
	GVariant** message_collection;
	gint message_collection_length1;
	gint _message_collection_size_;
	gint message_it;
	GVariant* _tmp20_;
	GVariant* message;
	GDBusConnection* _tmp21_;
	DConfEngineMessage _tmp22_;
	const gchar* _tmp23_;
	DConfEngineMessage _tmp24_;
	const gchar* _tmp25_;
	DConfEngineMessage _tmp26_;
	const gchar* _tmp27_;
	DConfEngineMessage _tmp28_;
	const gchar* _tmp29_;
	GVariant* _tmp30_;
	DConfEngineMessage _tmp31_;
	const GVariantType* _tmp32_;
	GCancellable* _tmp33_;
	GVariant* _tmp34_;
	GVariant* reply;
	DConfEngineMessage _tmp35_;
	const GVariantType* _tmp36_;
	const GVariantType* _tmp37_;
	GVariant* _tmp38_;
	GError * _inner_error_;
};

struct _DconfClientWriteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	gchar* key;
	GVariant* value;
	gchar* tag;
	GCancellable* cancellable;
	gboolean result;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	DConfEngineMessage _tmp3_;
	DConfEngineMessage _tmp4_;
	DConfEngineMessage _tmp5_;
	GCancellable* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_;
};

struct _DconfClientWatchAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	gchar* name;
	GCancellable* cancellable;
	gboolean result;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_;
};

struct _DconfClientUnwatchAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DConfClient* self;
	gchar* name;
	GCancellable* cancellable;
	gboolean result;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	DConfEngineMessage _tmp2_;
	DConfEngineMessage _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_;
};


static gpointer dconf_client_parent_class = NULL;

GType dconf_client_get_type (void) G_GNUC_CONST;
#define DCONF_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DCONF_TYPE_CLIENT, DConfClientPrivate))
enum  {
	DCONF_CLIENT_DUMMY_PROPERTY
};
static void dconf_client_got_signal (DConfClient* self, GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters);
static void dconf_client_call_sync (DConfClient* self, DConfEngineMessage* dcem, gchar** tag, GCancellable* cancellable, GError** error);
static void _dconf_client_got_signal_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
static void dconf_client_call_async_data_free (gpointer _data);
static void dconf_client_call_async (DConfClient* self, DConfEngineMessage* dcem, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void dconf_client_call_finish (DConfClient* self, GAsyncResult* _res_, gchar** tag, GError** error);
static gboolean dconf_client_call_async_co (DconfClientCallAsyncData* _data_);
static void dconf_client_call_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean dconf_client_is_writable (DConfClient* self, const gchar* key);
gboolean dconf_client_write (DConfClient* self, const gchar* key, GVariant* value, gchar** tag, GCancellable* cancellable, GError** error);
static void dconf_client_write_async_data_free (gpointer _data);
void dconf_client_write_async (DConfClient* self, const gchar* key, GVariant* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_write_finish (DConfClient* self, GAsyncResult* _res_, gchar** tag, GError** error);
static gboolean dconf_client_write_async_co (DconfClientWriteAsyncData* _data_);
static void dconf_client_write_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean dconf_client_write_many (DConfClient* self, const gchar* dir, gchar** rels, GVariant** values, int values_length1, gchar** tag, GCancellable* cancellable, GError** error);
GVariant* dconf_client_read (DConfClient* self, const gchar* key);
GVariant* dconf_client_read_default (DConfClient* self, const gchar* key);
GVariant* dconf_client_read_no_default (DConfClient* self, const gchar* key);
gchar** dconf_client_list (DConfClient* self, const gchar* dir, int* result_length1);
gboolean dconf_client_watch (DConfClient* self, const gchar* path, GCancellable* cancellable, GError** error);
static void dconf_client_watch_async_data_free (gpointer _data);
void dconf_client_watch_async (DConfClient* self, const gchar* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_watch_finish (DConfClient* self, GAsyncResult* _res_, GError** error);
static gboolean dconf_client_watch_async_co (DconfClientWatchAsyncData* _data_);
static void dconf_client_watch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean dconf_client_unwatch (DConfClient* self, const gchar* name, GCancellable* cancellable, GError** error);
static void dconf_client_unwatch_async_data_free (gpointer _data);
void dconf_client_unwatch_async (DConfClient* self, const gchar* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dconf_client_unwatch_finish (DConfClient* self, GAsyncResult* _res_, GError** error);
static gboolean dconf_client_unwatch_async_co (DconfClientUnwatchAsyncData* _data_);
static void dconf_client_unwatch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
DConfClient* dconf_client_new (const gchar* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify);
DConfClient* dconf_client_construct (GType object_type, const gchar* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify);
static void dconf_client_finalize (GObject* obj);
gboolean dconf_is_path (const gchar* str, GError** _error_);
gboolean dconf_is_key (const gchar* str, GError** _error_);
gboolean dconf_is_dir (const gchar* str, GError** _error_);
gboolean dconf_is_rel_path (const gchar* str, GError** _error_);
gboolean dconf_is_rel_key (const gchar* str, GError** _error_);
gboolean dconf_is_rel_dir (const gchar* str, GError** _error_);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void dconf_client_got_signal (DConfClient* self, GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters) {
	const gchar* path = NULL;
	const gchar* tag = NULL;
	gchar** items = NULL;
	gint items_length1 = 0;
	gint _items_size_ = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp4_;
	DConfWatchFunc _tmp24_;
	void* _tmp24__target;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp1_ = signal_name;
	if (g_strcmp0 (_tmp1_, "Notify") == 0) {
		GVariant* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = parameters;
		_tmp3_ = g_variant_is_of_type (_tmp2_, (const GVariantType*) "(sass)");
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GVariantIter* iter = NULL;
		GVariant* _tmp5_;
		GVariantIter* _tmp6_;
		gsize _tmp7_ = 0UL;
		gchar** _tmp8_ = NULL;
		_tmp5_ = parameters;
		g_variant_get (_tmp5_, "(&sas&s)", &path, &iter, &tag, NULL);
		_tmp6_ = iter;
		_tmp7_ = g_variant_iter_n_children (_tmp6_);
		_tmp8_ = g_new0 (gchar*, _tmp7_ + 1);
		items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
		items = _tmp8_;
		items_length1 = _tmp7_;
		_items_size_ = items_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					gint _tmp12_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					GVariantIter* _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = items;
					_tmp13__length1 = items_length1;
					if (!(_tmp12_ < _tmp13__length1)) {
						break;
					}
					_tmp14_ = iter;
					_tmp15_ = items;
					_tmp15__length1 = items_length1;
					_tmp16_ = i;
					g_variant_iter_next (_tmp14_, "s", &_tmp15_[_tmp16_], NULL);
				}
			}
		}
		_g_variant_iter_free0 (iter);
	} else {
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		gboolean _tmp21_;
		_tmp18_ = signal_name;
		if (g_strcmp0 (_tmp18_, "WritabilityNotify") == 0) {
			GVariant* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = parameters;
			_tmp20_ = g_variant_is_of_type (_tmp19_, (const GVariantType*) "(s)");
			_tmp17_ = _tmp20_;
		} else {
			_tmp17_ = FALSE;
		}
		_tmp21_ = _tmp17_;
		if (_tmp21_) {
			GVariant* _tmp22_;
			gchar** _tmp23_ = NULL;
			_tmp22_ = parameters;
			g_variant_get (_tmp22_, "(&s)", &path, NULL);
			_tmp23_ = g_new0 (gchar*, 0 + 1);
			items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
			items = _tmp23_;
			items_length1 = 0;
			_items_size_ = items_length1;
			tag = "";
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp24_ = self->priv->watch_func;
	_tmp24__target = self->priv->watch_func_target;
	_tmp25_ = path;
	_tmp26_ = items;
	_tmp26__length1 = items_length1;
	_tmp27_ = tag;
	_tmp24_ (self, _tmp25_, _tmp26_, _tmp26__length1, _tmp27_, _tmp24__target);
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
}


static void _dconf_client_got_signal_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	dconf_client_got_signal (self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void dconf_client_call_sync (DConfClient* self, DConfEngineMessage* dcem, gchar** tag, GCancellable* cancellable, GError** error) {
	gchar* _vala_tag = NULL;
	GDBusConnection* connection = NULL;
	DConfEngineMessage _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar _tmp2_;
	DConfEngineMessage _tmp22_;
	GVariant** _tmp23_;
	gint _tmp23__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dcem != NULL);
	_tmp0_ = *dcem;
	_tmp1_ = _tmp0_.bus_types;
	_tmp1__length1 = _tmp0_.n_messages;
	_tmp2_ = _tmp1_[0];
	if (_tmp2_ == 'e') {
		GDBusConnection* _tmp3_;
		GDBusConnection* _tmp9_;
		GDBusConnection* _tmp10_;
		_tmp3_ = self->priv->session;
		if (_tmp3_ == NULL) {
			GCancellable* _tmp4_;
			GDBusConnection* _tmp5_ = NULL;
			GDBusConnection* _tmp6_;
			DConfWatchFunc _tmp7_;
			void* _tmp7__target;
			_tmp4_ = cancellable;
			_tmp5_ = g_bus_get_sync (G_BUS_TYPE_SESSION, _tmp4_, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				return;
			}
			_g_object_unref0 (self->priv->session);
			self->priv->session = _tmp6_;
			_tmp7_ = self->priv->watch_func;
			_tmp7__target = self->priv->watch_func_target;
			if (_tmp7_ != NULL) {
				GDBusConnection* _tmp8_;
				_tmp8_ = self->priv->session;
				g_dbus_connection_signal_subscribe (_tmp8_, NULL, "ca.desrt.dconf.Writer", NULL, NULL, NULL, G_DBUS_SIGNAL_FLAGS_NO_MATCH_RULE, _dconf_client_got_signal_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
			}
		}
		_tmp9_ = self->priv->session;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (connection);
		connection = _tmp10_;
	} else {
		DConfEngineMessage _tmp11_;
		gchar* _tmp12_;
		gint _tmp12__length1;
		gchar _tmp13_;
		GDBusConnection* _tmp14_;
		GDBusConnection* _tmp20_;
		GDBusConnection* _tmp21_;
		_tmp11_ = *dcem;
		_tmp12_ = _tmp11_.bus_types;
		_tmp12__length1 = _tmp11_.n_messages;
		_tmp13_ = _tmp12_[0];
		g_assert (_tmp13_ == 'y');
		_tmp14_ = self->priv->system;
		if (_tmp14_ == NULL) {
			GCancellable* _tmp15_;
			GDBusConnection* _tmp16_ = NULL;
			GDBusConnection* _tmp17_;
			DConfWatchFunc _tmp18_;
			void* _tmp18__target;
			_tmp15_ = cancellable;
			_tmp16_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, _tmp15_, &_inner_error_);
			_tmp17_ = _tmp16_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				return;
			}
			_g_object_unref0 (self->priv->system);
			self->priv->system = _tmp17_;
			_tmp18_ = self->priv->watch_func;
			_tmp18__target = self->priv->watch_func_target;
			if (_tmp18_ != NULL) {
				GDBusConnection* _tmp19_;
				_tmp19_ = self->priv->system;
				g_dbus_connection_signal_subscribe (_tmp19_, NULL, "ca.desrt.dconf.Writer", NULL, NULL, NULL, G_DBUS_SIGNAL_FLAGS_NO_MATCH_RULE, _dconf_client_got_signal_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
			}
		}
		_tmp20_ = self->priv->system;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (connection);
		connection = _tmp21_;
	}
	_tmp22_ = *dcem;
	_tmp23_ = _tmp22_.parameters;
	_tmp23__length1 = _tmp22_.n_messages;
	{
		GVariant** message_collection = NULL;
		gint message_collection_length1 = 0;
		gint _message_collection_size_ = 0;
		gint message_it = 0;
		message_collection = _tmp23_;
		message_collection_length1 = _tmp23__length1;
		for (message_it = 0; message_it < _tmp23__length1; message_it = message_it + 1) {
			GVariant* _tmp24_;
			GVariant* message = NULL;
			_tmp24_ = _g_variant_ref0 (message_collection[message_it]);
			message = _tmp24_;
			{
				GDBusConnection* _tmp25_;
				DConfEngineMessage _tmp26_;
				const gchar* _tmp27_;
				DConfEngineMessage _tmp28_;
				const gchar* _tmp29_;
				DConfEngineMessage _tmp30_;
				const gchar* _tmp31_;
				DConfEngineMessage _tmp32_;
				const gchar* _tmp33_;
				GVariant* _tmp34_;
				DConfEngineMessage _tmp35_;
				const GVariantType* _tmp36_;
				GCancellable* _tmp37_;
				GVariant* _tmp38_ = NULL;
				GVariant* reply;
				DConfEngineMessage _tmp39_;
				const GVariantType* _tmp40_;
				const GVariantType* _tmp41_;
				gboolean _tmp42_ = FALSE;
				_tmp25_ = connection;
				_tmp26_ = *dcem;
				_tmp27_ = _tmp26_.bus_name;
				_tmp28_ = *dcem;
				_tmp29_ = _tmp28_.object_path;
				_tmp30_ = *dcem;
				_tmp31_ = _tmp30_.interface_name;
				_tmp32_ = *dcem;
				_tmp33_ = _tmp32_.method_name;
				_tmp34_ = message;
				_tmp35_ = *dcem;
				_tmp36_ = _tmp35_.reply_type;
				_tmp37_ = cancellable;
				_tmp38_ = g_dbus_connection_call_sync (_tmp25_, _tmp27_, _tmp29_, _tmp31_, _tmp33_, _tmp34_, _tmp36_, G_DBUS_CALL_FLAGS_NONE, -1, _tmp37_, &_inner_error_);
				reply = _tmp38_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_variant_unref0 (message);
					_g_object_unref0 (connection);
					return;
				}
				_tmp39_ = *dcem;
				_tmp40_ = _tmp39_.reply_type;
				_tmp41_ = G_VARIANT_TYPE_UNIT;
				_tmp42_ = g_variant_type_equal (_tmp40_, _tmp41_);
				if (!_tmp42_) {
					GVariant* _tmp43_;
					_tmp43_ = reply;
					g_variant_get (_tmp43_, "(s)", &_vala_tag, NULL);
				}
				_g_variant_unref0 (reply);
				_g_variant_unref0 (message);
			}
		}
	}
	_g_object_unref0 (connection);
	if (tag) {
		*tag = _vala_tag;
	} else {
		_g_free0 (_vala_tag);
	}
}


static void dconf_client_call_async_data_free (gpointer _data) {
	DconfClientCallAsyncData* _data_;
	_data_ = _data;
	dconf_engine_message_destroy (&_data_->dcem);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DconfClientCallAsyncData, _data_);
}


static void dconf_client_call_async (DConfClient* self, DConfEngineMessage* dcem, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientCallAsyncData* _data_;
	DConfClient* _tmp0_;
	DConfEngineMessage _tmp1_;
	DConfEngineMessage _tmp2_ = {0};
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (DconfClientCallAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_call_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_call_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *dcem;
	dconf_engine_message_copy (&_tmp1_, &_tmp2_);
	_data_->dcem = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	dconf_client_call_async_co (_data_);
}


static void dconf_client_call_finish (DConfClient* self, GAsyncResult* _res_, gchar** tag, GError** error) {
	DconfClientCallAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (tag) {
		*tag = _data_->tag;
	} else {
		_g_free0 (_data_->tag);
	}
	_data_->tag = NULL;
}


static void dconf_client_call_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientCallAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dconf_client_call_async_co (_data_);
}


static gboolean dconf_client_call_async_co (DconfClientCallAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->dcem;
	_data_->_tmp1_ = _data_->_tmp0_.bus_types;
	_data_->_tmp1__length1 = _data_->_tmp0_.n_messages;
	_data_->_tmp2_ = _data_->_tmp1_[0];
	if (_data_->_tmp2_ == 'e') {
		_data_->_tmp3_ = _data_->self->priv->session;
		if (_data_->_tmp3_ == NULL) {
			_data_->_tmp4_ = _data_->cancellable;
			_data_->_state_ = 1;
			g_bus_get (G_BUS_TYPE_SESSION, _data_->_tmp4_, dconf_client_call_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp6_ = _data_->_tmp5_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->connection);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->self->priv->session);
			_data_->self->priv->session = _data_->_tmp6_;
		}
		_data_->_tmp7_ = _data_->self->priv->session;
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_g_object_unref0 (_data_->connection);
		_data_->connection = _data_->_tmp8_;
	} else {
		_data_->_tmp9_ = _data_->dcem;
		_data_->_tmp10_ = _data_->_tmp9_.bus_types;
		_data_->_tmp10__length1 = _data_->_tmp9_.n_messages;
		_data_->_tmp11_ = _data_->_tmp10_[0];
		g_assert (_data_->_tmp11_ == 'y');
		_data_->_tmp12_ = _data_->self->priv->system;
		if (_data_->_tmp12_ == NULL) {
			_data_->_tmp13_ = _data_->cancellable;
			_data_->_state_ = 2;
			g_bus_get (G_BUS_TYPE_SYSTEM, _data_->_tmp13_, dconf_client_call_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp15_ = _data_->_tmp14_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->connection);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->self->priv->system);
			_data_->self->priv->system = _data_->_tmp15_;
		}
		_data_->_tmp16_ = _data_->self->priv->system;
		_data_->_tmp17_ = _g_object_ref0 (_data_->_tmp16_);
		_g_object_unref0 (_data_->connection);
		_data_->connection = _data_->_tmp17_;
	}
	_data_->_tmp18_ = _data_->dcem;
	_data_->_tmp19_ = _data_->_tmp18_.parameters;
	_data_->_tmp19__length1 = _data_->_tmp18_.n_messages;
	{
		_data_->message_collection_length1 = 0;
		_data_->_message_collection_size_ = 0;
		_data_->message_collection = _data_->_tmp19_;
		_data_->message_collection_length1 = _data_->_tmp19__length1;
		_data_->message_it = 0;
		for (_data_->message_it = 0; _data_->message_it < _data_->_tmp19__length1; _data_->message_it = _data_->message_it + 1) {
			_data_->_tmp20_ = _g_variant_ref0 (_data_->message_collection[_data_->message_it]);
			_data_->message = _data_->_tmp20_;
			{
				_data_->_tmp21_ = _data_->connection;
				_data_->_tmp22_ = _data_->dcem;
				_data_->_tmp23_ = _data_->_tmp22_.bus_name;
				_data_->_tmp24_ = _data_->dcem;
				_data_->_tmp25_ = _data_->_tmp24_.object_path;
				_data_->_tmp26_ = _data_->dcem;
				_data_->_tmp27_ = _data_->_tmp26_.interface_name;
				_data_->_tmp28_ = _data_->dcem;
				_data_->_tmp29_ = _data_->_tmp28_.method_name;
				_data_->_tmp30_ = _data_->message;
				_data_->_tmp31_ = _data_->dcem;
				_data_->_tmp32_ = _data_->_tmp31_.reply_type;
				_data_->_tmp33_ = _data_->cancellable;
				_data_->_state_ = 3;
				g_dbus_connection_call (_data_->_tmp21_, _data_->_tmp23_, _data_->_tmp25_, _data_->_tmp27_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp32_, G_DBUS_CALL_FLAGS_NONE, -1, _data_->_tmp33_, dconf_client_call_async_ready, _data_);
				return FALSE;
				_state_3:
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = g_dbus_connection_call_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error_);
				_data_->reply = _data_->_tmp34_;
				if (_data_->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_variant_unref0 (_data_->message);
					_g_object_unref0 (_data_->connection);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp35_ = _data_->dcem;
				_data_->_tmp36_ = _data_->_tmp35_.reply_type;
				_data_->_tmp37_ = G_VARIANT_TYPE_UNIT;
				if (_data_->_tmp36_ != _data_->_tmp37_) {
					_data_->_tmp38_ = _data_->reply;
					g_variant_get (_data_->_tmp38_, "(s)", &_data_->tag, NULL);
				}
				_g_variant_unref0 (_data_->reply);
				_g_variant_unref0 (_data_->message);
			}
		}
	}
	_g_object_unref0 (_data_->connection);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
 * dconf_client_is_writable:
 * @client: a #DConfClient
 * @key: a dconf key
 * Returns: %TRUE is @key is writable
 *
 * Checks if @key is writable (ie: the key has no mandatory setting).
 *
 * This call does not verify that writing to the key will actually be successful.  It only checks for
 * the existence of mandatory keys/locks that might affect writing to @key.  Other issues (such as a
 * full disk or an inability to connect to the bus and start the service) may cause the write to fail.
 **/
gboolean dconf_client_is_writable (DConfClient* self, const gchar* key) {
	gboolean result = FALSE;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->engine;
	_tmp1_ = key;
	_tmp2_ = dconf_engine_is_writable (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * dconf_client_write:
 * @client: a #DConfClient
 * @key: a dconf key
 * @value: (allow-none): a #GVariant, or %NULL
 * @tag: (out) (allow-none): the tag from this write
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a #GError, or %NULL
 * Returns: %TRUE if the write is successful
 *
 * Write a value to the given @key, or reset @key to its default value.
 *
 * If @value is %NULL then @key is reset to its default value (which may
 * be completely unset), otherwise @value becomes the new value.
 *
 * If @tag is non-%NULL then it is set to the unique tag associated with this write.  This is the same
 * tag that appears in change notifications.
 **/
gboolean dconf_client_write (DConfClient* self, const gchar* key, GVariant* value, gchar** tag, GCancellable* cancellable, GError** error) {
	gchar* _vala_tag = NULL;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	if ((&_vala_tag) == NULL) {
		gchar* junk = NULL;
		DConfEngine* _tmp0_;
		const gchar* _tmp1_;
		GVariant* _tmp2_;
		DConfEngineMessage _tmp3_ = {0};
		DConfEngineMessage _tmp4_;
		DConfEngineMessage _tmp5_;
		GCancellable* _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp0_ = self->priv->engine;
		_tmp1_ = key;
		_tmp2_ = value;
		dconf_engine_write (_tmp0_, _tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		_tmp5_ = _tmp4_;
		_tmp6_ = cancellable;
		dconf_client_call_sync (self, &_tmp5_, &_tmp7_, _tmp6_, &_inner_error_);
		_g_free0 (junk);
		junk = _tmp7_;
		dconf_engine_message_destroy (&_tmp5_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		_g_free0 (junk);
	} else {
		DConfEngine* _tmp8_;
		const gchar* _tmp9_;
		GVariant* _tmp10_;
		DConfEngineMessage _tmp11_ = {0};
		DConfEngineMessage _tmp12_;
		DConfEngineMessage _tmp13_;
		GCancellable* _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp8_ = self->priv->engine;
		_tmp9_ = key;
		_tmp10_ = value;
		dconf_engine_write (_tmp8_, _tmp9_, _tmp10_, &_tmp11_, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
		_tmp13_ = _tmp12_;
		_tmp14_ = cancellable;
		dconf_client_call_sync (self, &_tmp13_, &_tmp15_, _tmp14_, &_inner_error_);
		_g_free0 (_vala_tag);
		_vala_tag = _tmp15_;
		dconf_engine_message_destroy (&_tmp13_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	if (tag) {
		*tag = _vala_tag;
	} else {
		_g_free0 (_vala_tag);
	}
	return result;
}


static void dconf_client_write_async_data_free (gpointer _data) {
	DconfClientWriteAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->key);
	_g_variant_unref0 (_data_->value);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DconfClientWriteAsyncData, _data_);
}


void dconf_client_write_async (DConfClient* self, const gchar* key, GVariant* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientWriteAsyncData* _data_;
	DConfClient* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	_data_ = g_slice_new0 (DconfClientWriteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_write_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_write_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = key;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->key = _tmp2_;
	_tmp3_ = value;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_data_->value = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data_->cancellable = _tmp6_;
	dconf_client_write_async_co (_data_);
}


gboolean dconf_client_write_finish (DConfClient* self, GAsyncResult* _res_, gchar** tag, GError** error) {
	gboolean result;
	DconfClientWriteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (tag) {
		*tag = _data_->tag;
	} else {
		_g_free0 (_data_->tag);
	}
	_data_->tag = NULL;
	result = _data_->result;
	return result;
}


/**
 * dconf_client_write_async:
 * @client: a #DConfClient
 * @key: a dconf key
 * @value: (allow-none): a #GVariant, or %NULL
 * @cancellable: a #GCancellable, or %NULL
 * @callback: the function to call when complete
 * @user_data: the user data for @callback
 *
 * Write a value to the given @key, or reset @key to its default value.
 *
 * This is the asynchronous version of dconf_client_write().  You should call
 * dconf_client_write_finish() from @callback to collect the result.
 **/
static void dconf_client_write_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientWriteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dconf_client_write_async_co (_data_);
}


static gboolean dconf_client_write_async_co (DconfClientWriteAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->engine;
	_data_->_tmp1_ = _data_->key;
	_data_->_tmp2_ = _data_->value;
	memset (&_data_->_tmp3_, 0, sizeof (DConfEngineMessage));
	dconf_engine_write (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, &_data_->_tmp3_, &_data_->_inner_error_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->cancellable;
	_data_->_tmp7_ = NULL;
	_data_->_state_ = 1;
	dconf_client_call_async (_data_->self, &_data_->_tmp5_, _data_->_tmp6_, dconf_client_write_async_ready, _data_);
	return FALSE;
	_state_1:
	dconf_client_call_finish (_data_->self, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
	_g_free0 (_data_->tag);
	_data_->tag = _data_->_tmp7_;
	dconf_engine_message_destroy (&_data_->_tmp5_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
 * dconf_client_write_many:
 * @client: a #DConfClient
 * @dir: the dconf directory under which to make the writes
 * @rels: a %NULL-terminated array of relative keys
 * @values: an array of possibly-%NULL #GVariant pointers
 * @n_values: the length of @values, which must be equal to the length of @rels
 * @tag: (out) (allow-none): the tag from this write
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a #GError, or %NULL
 * Returns: %TRUE if the write is successful
 *
 * Write multiple values at once.
 *
 * For each pair of items from @rels and @values, the value is written to the result of concatenating
 * @dir with the relative path.  As with dconf_client_write(), if a given value is %NULL then the effect
 * is that the specified key is reset.
 *
 * If @tag is non-%NULL then it is set to the unique tag associated with this write.  This is the same
 * tag that appears in change notifications.
 **/
gboolean dconf_client_write_many (DConfClient* self, const gchar* dir, gchar** rels, GVariant** values, int values_length1, gchar** tag, GCancellable* cancellable, GError** error) {
	gchar* _vala_tag = NULL;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	if ((&_vala_tag) == NULL) {
		gchar* junk = NULL;
		DConfEngine* _tmp0_;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		GVariant** _tmp3_;
		gint _tmp3__length1;
		DConfEngineMessage _tmp4_ = {0};
		DConfEngineMessage _tmp5_;
		DConfEngineMessage _tmp6_;
		GCancellable* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp0_ = self->priv->engine;
		_tmp1_ = dir;
		_tmp2_ = rels;
		_tmp2__length1 = _vala_array_length (rels);
		_tmp3_ = values;
		_tmp3__length1 = values_length1;
		dconf_engine_write_many (_tmp0_, _tmp1_, (const gchar * const *) _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = cancellable;
		dconf_client_call_sync (self, &_tmp6_, &_tmp8_, _tmp7_, &_inner_error_);
		_g_free0 (junk);
		junk = _tmp8_;
		dconf_engine_message_destroy (&_tmp6_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (junk);
			return FALSE;
		}
		_g_free0 (junk);
	} else {
		DConfEngine* _tmp9_;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		GVariant** _tmp12_;
		gint _tmp12__length1;
		DConfEngineMessage _tmp13_ = {0};
		DConfEngineMessage _tmp14_;
		DConfEngineMessage _tmp15_;
		GCancellable* _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp9_ = self->priv->engine;
		_tmp10_ = dir;
		_tmp11_ = rels;
		_tmp11__length1 = _vala_array_length (rels);
		_tmp12_ = values;
		_tmp12__length1 = values_length1;
		dconf_engine_write_many (_tmp9_, _tmp10_, (const gchar * const *) _tmp11_, _tmp12_, &_tmp13_, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
		_tmp15_ = _tmp14_;
		_tmp16_ = cancellable;
		dconf_client_call_sync (self, &_tmp15_, &_tmp17_, _tmp16_, &_inner_error_);
		_g_free0 (_vala_tag);
		_vala_tag = _tmp17_;
		dconf_engine_message_destroy (&_tmp15_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	if (tag) {
		*tag = _vala_tag;
	} else {
		_g_free0 (_vala_tag);
	}
	return result;
}


/**
 * dconf_client_read:
 * @client: a #DConfClient
 * @key: a valid dconf key
 * Returns: the value corresponding to @key, or %NULL if there is none
 *
 * Reads the value named by @key from dconf.  If no such value exists, %NULL is returned.
 **/
GVariant* dconf_client_read (DConfClient* self, const gchar* key) {
	GVariant* result = NULL;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = key;
	_tmp2_ = dconf_engine_read (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * dconf_client_read_default:
 * @client: a #DConfClient
 * @key: a valid dconf key
 * Returns: the default value corresponding to @key, or %NULL if there is none
 *
 * Reads the value named by @key from any existing default/mandatory databases but ignoring any value
 * set by the user.  The result is as if the named key had just been reset.
 **/
GVariant* dconf_client_read_default (DConfClient* self, const gchar* key) {
	GVariant* result = NULL;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = key;
	_tmp2_ = dconf_engine_read_default (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * dconf_client_read_no_default:
 * @client: a #DConfClient
 * @key: a valid dconf key
 * Returns: the user value corresponding to @key, or %NULL if there is none
 *
 * Reads the value named by @key as set by the user, ignoring any default/mandatory databases.  Normal
 * applications will never want to do this, but it may be useful for administrative or configuration
 * tweaking utilities to have access to this information.
 *
 * Note that in the case of mandatory keys, the result of dconf_client_read_no_default() with a fallback
 * to dconf_client_read_default() is not necessarily the same as the result of a dconf_client_read().
 * This is because the user may have set a value before the key became marked as mandatory, in which
 * case this call will see the user's (otherwise inaccessible) key.
 **/
GVariant* dconf_client_read_no_default (DConfClient* self, const gchar* key) {
	GVariant* result = NULL;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = key;
	_tmp2_ = dconf_engine_read_no_default (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * dconf_client_list:
 * @client: a #DConfClient
 * @dir: a dconf dir
 * @length: the number of items that were returned
 * Returns: (array length=length): the paths located directly below @dir
 *
 * Lists the keys and dirs located directly below @dir.
 *
 * You should free the return result with g_strfreev() when it is no longer needed.
 **/
gchar** dconf_client_list (DConfClient* self, const gchar* dir, int* result_length1) {
	gchar** result = NULL;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = dir;
	_tmp3_ = dconf_engine_list (_tmp0_, _tmp1_, NULL, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


/**
 * dconf_client_watch:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a %NULL #GError, or %NULL
 * Returns: %TRUE on success, else %FALSE with @error set
 *
 * Requests monitoring of a portion of the dconf database.
 *
 * If @path is a key (ie: doesn't end with a slash) then a single key is monitored for changes.  If
 * @path is a dir (ie: sending with a slash) then all keys that have @path as a prefix are monitored.
 *
 * This function blocks until the watch has definitely been established with the bus daemon.  If you
 * would like a non-blocking version of this call, see dconf_client_watch_async().
 **/
gboolean dconf_client_watch (DConfClient* self, const gchar* path, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	DConfEngineMessage _tmp2_ = {0};
	DConfEngineMessage _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->engine;
	_tmp1_ = path;
	dconf_engine_watch (_tmp0_, _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = cancellable;
	dconf_client_call_sync (self, &_tmp3_, NULL, _tmp4_, &_inner_error_);
	dconf_engine_message_destroy (&_tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void dconf_client_watch_async_data_free (gpointer _data) {
	DconfClientWatchAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DconfClientWatchAsyncData, _data_);
}


void dconf_client_watch_async (DConfClient* self, const gchar* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientWatchAsyncData* _data_;
	DConfClient* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (DconfClientWatchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_watch_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_watch_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->name = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	dconf_client_watch_async_co (_data_);
}


gboolean dconf_client_watch_finish (DConfClient* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DconfClientWatchAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
 * dconf_client_watch_async:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @callback: a #GAsyncReadyCallback to call when finished
 * @user_data: a pointer to pass as the last argument to @callback
 *
 * Requests monitoring of a portion of the dconf database.
 *
 * This is the asynchronous version of dconf_client_watch().  You should call
 * dconf_client_watch_finish() from @callback to collect the result.
 **/
static void dconf_client_watch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientWatchAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dconf_client_watch_async_co (_data_);
}


static gboolean dconf_client_watch_async_co (DconfClientWatchAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->engine;
	_data_->_tmp1_ = _data_->name;
	memset (&_data_->_tmp2_, 0, sizeof (DConfEngineMessage));
	dconf_engine_watch (_data_->_tmp0_, _data_->_tmp1_, &_data_->_tmp2_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->cancellable;
	_data_->_state_ = 1;
	dconf_client_call_async (_data_->self, &_data_->_tmp3_, _data_->_tmp4_, dconf_client_watch_async_ready, _data_);
	return FALSE;
	_state_1:
	dconf_client_call_finish (_data_->self, _data_->_res_, NULL, &_data_->_inner_error_);
	dconf_engine_message_destroy (&_data_->_tmp3_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
 * dconf_client_unwatch:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a %NULL #GError, or %NULL
 * Returns: %TRUE on success, else %FALSE with @error set
 *
 * Cancels the effect of a previous call to dconf_client_watch().
 *
 * If the same path has been watched multiple times then only one of the watches is cancelled and the
 * net effect is that the path is still watched.
 *
 * This function blocks until the watch has definitely been removed from the bus daemon.  It is possible
 * that notifications in transit will arrive after this call returns.  For an asynchronous version of
 * this call, see dconf_client_unwatch_async().
 **/
gboolean dconf_client_unwatch (DConfClient* self, const gchar* name, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	DConfEngine* _tmp0_;
	const gchar* _tmp1_;
	DConfEngineMessage _tmp2_ = {0};
	DConfEngineMessage _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->engine;
	_tmp1_ = name;
	dconf_engine_unwatch (_tmp0_, _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = cancellable;
	dconf_client_call_sync (self, &_tmp3_, NULL, _tmp4_, &_inner_error_);
	dconf_engine_message_destroy (&_tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void dconf_client_unwatch_async_data_free (gpointer _data) {
	DconfClientUnwatchAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DconfClientUnwatchAsyncData, _data_);
}


void dconf_client_unwatch_async (DConfClient* self, const gchar* name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DconfClientUnwatchAsyncData* _data_;
	DConfClient* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (DconfClientUnwatchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dconf_client_unwatch_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dconf_client_unwatch_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->name = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	dconf_client_unwatch_async_co (_data_);
}


gboolean dconf_client_unwatch_finish (DConfClient* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DconfClientUnwatchAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
 * dconf_client_unwatch_async:
 * @client: a #DConfClient
 * @path: a dconf path
 * @cancellable: a #GCancellable, or %NULL
 * @callback: a #GAsyncReadyCallback to call when finished
 * @user_data: a pointer to pass as the last argument to @callback
 *
 * Cancels the effect of a previous call to dconf_client_watch().
 *
 * This is the asynchronous version of dconf_client_unwatch().  You should call
 * dconf_client_unwatch_finish() from @callback to collect the result.  No additional notifications will
 * be delivered for this watch after @callback is called.
 **/
static void dconf_client_unwatch_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DconfClientUnwatchAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dconf_client_unwatch_async_co (_data_);
}


static gboolean dconf_client_unwatch_async_co (DconfClientUnwatchAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->engine;
	_data_->_tmp1_ = _data_->name;
	memset (&_data_->_tmp2_, 0, sizeof (DConfEngineMessage));
	dconf_engine_unwatch (_data_->_tmp0_, _data_->_tmp1_, &_data_->_tmp2_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->cancellable;
	_data_->_state_ = 1;
	dconf_client_call_async (_data_->self, &_data_->_tmp3_, _data_->_tmp4_, dconf_client_unwatch_async_ready, _data_);
	return FALSE;
	_state_1:
	dconf_client_call_finish (_data_->self, _data_->_res_, NULL, &_data_->_inner_error_);
	dconf_engine_message_destroy (&_data_->_tmp3_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
 * dconf_client_new:
 * @profile: the dconf profile to use, or %NULL
 * @watch_func: the function to call when changes occur
 * @user_data: the user_data to pass to @watch_func
 * @notify: the function to free @user_data when no longer needed
 * Returns: a new #DConfClient
 *
 * Creates a new #DConfClient for the given context.
 *
 * If @profile is non-%NULL then it specifies the name of the profile to use.  If @profile is %NULL then
 * the DCONF_PROFILE environment variable is consulted.  If that is unset then the default profile of
 * "user" is used.  If a profile named "user" is not installed then the dconf client is setup to access
 * ~/.config/dconf/user.
 **/
DConfClient* dconf_client_construct (GType object_type, const gchar* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify) {
	DConfClient * self = NULL;
	const gchar* _tmp0_;
	DConfEngine* _tmp1_;
	DConfWatchFunc _tmp2_;
	void* _tmp2__target;
	self = (DConfClient*) g_object_new (object_type, NULL);
	_tmp0_ = profile;
	_tmp1_ = dconf_engine_new (_tmp0_);
	_dconf_engine_free0 (self->priv->engine);
	self->priv->engine = _tmp1_;
	_tmp2_ = watch_func;
	_tmp2__target = watch_func_target;
	(self->priv->watch_func_target_destroy_notify == NULL) ? NULL : (self->priv->watch_func_target_destroy_notify (self->priv->watch_func_target), NULL);
	self->priv->watch_func = NULL;
	self->priv->watch_func_target = NULL;
	self->priv->watch_func_target_destroy_notify = NULL;
	self->priv->watch_func = _tmp2_;
	self->priv->watch_func_target = _tmp2__target;
	self->priv->watch_func_target_destroy_notify = NULL;
	(watch_func_target_destroy_notify == NULL) ? NULL : (watch_func_target_destroy_notify (watch_func_target), NULL);
	watch_func = NULL;
	watch_func_target = NULL;
	watch_func_target_destroy_notify = NULL;
	return self;
}


DConfClient* dconf_client_new (const gchar* profile, DConfWatchFunc watch_func, void* watch_func_target, GDestroyNotify watch_func_target_destroy_notify) {
	return dconf_client_construct (DCONF_TYPE_CLIENT, profile, watch_func, watch_func_target, watch_func_target_destroy_notify);
}


static void dconf_client_class_init (DConfClientClass * klass) {
	dconf_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DConfClientPrivate));
	G_OBJECT_CLASS (klass)->finalize = dconf_client_finalize;
}


static void dconf_client_instance_init (DConfClient * self) {
	self->priv = DCONF_CLIENT_GET_PRIVATE (self);
}


static void dconf_client_finalize (GObject* obj) {
	DConfClient * self;
	self = DCONF_CLIENT (obj);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->system);
	(self->priv->watch_func_target_destroy_notify == NULL) ? NULL : (self->priv->watch_func_target_destroy_notify (self->priv->watch_func_target), NULL);
	self->priv->watch_func = NULL;
	self->priv->watch_func_target = NULL;
	self->priv->watch_func_target_destroy_notify = NULL;
	_dconf_engine_free0 (self->priv->engine);
	G_OBJECT_CLASS (dconf_client_parent_class)->finalize (obj);
}


GType dconf_client_get_type (void) {
	static volatile gsize dconf_client_type_id__volatile = 0;
	if (g_once_init_enter (&dconf_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DConfClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfClient), 0, (GInstanceInitFunc) dconf_client_instance_init, NULL };
		GType dconf_client_type_id;
		dconf_client_type_id = g_type_register_static (G_TYPE_OBJECT, "DConfClient", &g_define_type_info, 0);
		g_once_init_leave (&dconf_client_type_id__volatile, dconf_client_type_id);
	}
	return dconf_client_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



