// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_BUFFEREDOUTPUTSTREAM_H
#define _GIOMM_BUFFEREDOUTPUTSTREAM_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2008 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/filteroutputstream.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GBufferedOutputStream GBufferedOutputStream;
typedef struct _GBufferedOutputStreamClass GBufferedOutputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class BufferedOutputStream_Class; } // namespace Gio
namespace Gio
{

/** The buffered output stream implements FilterOutputStream and provides for buffered writes.
 * By default, BufferedOutputStream's buffer size is set at 4 kilobytes, but you 
 * can specify this to the constructor.
 *
 * To get the size of a buffer within a buffered input stream, use get_buffer_size(). 
 * To change the size of a buffered output stream's buffer, use set_buffer_size(). 
 * Note that the buffer's size cannot be reduced below the size of the data within the buffer.
 *
 * @ingroup Streams
 *
 * @newin{2,16}
 */

class BufferedOutputStream : public Gio::FilterOutputStream
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BufferedOutputStream CppObjectType;
  typedef BufferedOutputStream_Class CppClassType;
  typedef GBufferedOutputStream BaseObjectType;
  typedef GBufferedOutputStreamClass BaseClassType;

private:  friend class BufferedOutputStream_Class;
  static CppClassType bufferedoutputstream_class_;

private:
  // noncopyable
  BufferedOutputStream(const BufferedOutputStream&);
  BufferedOutputStream& operator=(const BufferedOutputStream&);

protected:
  explicit BufferedOutputStream(const Glib::ConstructParams& construct_params);
  explicit BufferedOutputStream(GBufferedOutputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BufferedOutputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GBufferedOutputStream*       gobj()       { return reinterpret_cast<GBufferedOutputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GBufferedOutputStream* gobj() const { return reinterpret_cast<GBufferedOutputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GBufferedOutputStream* gobj_copy();

private:

protected:
    explicit BufferedOutputStream(const Glib::RefPtr<OutputStream>& base_stream);

  
  //Note that we rename the size parameter to buffer_size because that is the actual name of the property.
    explicit BufferedOutputStream(const Glib::RefPtr<OutputStream>& base_stream, gsize buffer_size);


public:
  /** Creates a new buffered output stream for a base stream.
   *
   * @param base_stream An InputStream.
   * @result an OutputStream for the given base stream.
	 */
  
  static Glib::RefPtr<BufferedOutputStream> create(const Glib::RefPtr<OutputStream>& base_stream);

  
  /** Creates a new buffered output stream with a given buffer size. 
   *
   * @param base_stream An InputStream.
   * @param size A size.
   * @result an OutputStream with an internal buffer set to size. 
	 */
  static Glib::RefPtr<BufferedOutputStream> create_sized(const Glib::RefPtr<OutputStream>& base_stream, gsize buffer_size);

  
  /** Gets the size of the buffer in the @a stream.
   * @return The current size of the buffer.
   */
  gsize get_buffer_size() const;
  
  /** Sets the size of the internal buffer to @a size.
   * @param size A #gsize.
   */
  void set_buffer_size(gsize size);

  
  /** Sets whether or not the @a stream's buffer should automatically grow.
   * If @a auto_grow is true, then each write will just make the buffer
   * larger, and you must manually flush the buffer to actually write out
   * the data to the underlying stream.
   * @param auto_grow A <tt>bool</tt>.
   */
  void set_auto_grow(bool auto_grow = true);
  
  /** Checks if the buffer automatically grows as data is added.
   * @return <tt>true</tt> if the @a stream's buffer automatically grows,
   * <tt>false</tt> otherwise.
   */
  bool get_auto_grow() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The size of the backend buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_buffer_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The size of the backend buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_buffer_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the buffer should automatically grow.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_auto_grow() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the buffer should automatically grow.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_auto_grow() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::BufferedOutputStream
   */
  Glib::RefPtr<Gio::BufferedOutputStream> wrap(GBufferedOutputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_BUFFEREDOUTPUTSTREAM_H */

