// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GDKMM_ENUMS_H
#define _GDKMM_ENUMS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/value.h>
#include <gdk/gdk.h>


namespace Gdk
{
/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var AxisFlags X
 * X axis is present.
 * 
 *  @var AxisFlags Y
 * Y axis is present.
 * 
 *  @var AxisFlags PRESSURE
 * Pressure axis is present.
 * 
 *  @var AxisFlags XTILT
 * X tilt axis is present.
 * 
 *  @var AxisFlags YTILT
 * Y tilt axis is present.
 * 
 *  @var AxisFlags WHEEL
 * Wheel axis is present.
 * 
 *  @var AxisFlags DISTANCE
 * Distance axis is present.
 * 
 *  @var AxisFlags ROTATION
 * Z-axis rotation is present.
 * 
 *  @var AxisFlags SLIDER
 * Slider axis is present.
 * 
 *  @enum AxisFlags
 * 
 * Flags describing the current capabilities of a device/tool.
 * 
 * @newin{3,22}
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>AxisFlags operator|(AxisFlags, AxisFlags)</tt><br>
 * <tt>AxisFlags operator&(AxisFlags, AxisFlags)</tt><br>
 * <tt>AxisFlags operator^(AxisFlags, AxisFlags)</tt><br>
 * <tt>AxisFlags operator~(AxisFlags)</tt><br>
 * <tt>AxisFlags& operator|=(AxisFlags&, AxisFlags)</tt><br>
 * <tt>AxisFlags& operator&=(AxisFlags&, AxisFlags)</tt><br>
 * <tt>AxisFlags& operator^=(AxisFlags&, AxisFlags)</tt><br>
 */
enum class AxisFlags
{
  X = 0x2,
  Y = 0x4,
  PRESSURE = 0x8,
  XTILT = 0x10,
  YTILT = 0x20,
  WHEEL = 0x40,
  DISTANCE = 0x80,
  ROTATION = 0x100,
  SLIDER = 0x200
};

/** @ingroup gdkmmEnums */
inline AxisFlags operator|(AxisFlags lhs, AxisFlags rhs)
  { return static_cast<AxisFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AxisFlags operator&(AxisFlags lhs, AxisFlags rhs)
  { return static_cast<AxisFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AxisFlags operator^(AxisFlags lhs, AxisFlags rhs)
  { return static_cast<AxisFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline AxisFlags operator~(AxisFlags flags)
  { return static_cast<AxisFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline AxisFlags& operator|=(AxisFlags& lhs, AxisFlags rhs)
  { return (lhs = static_cast<AxisFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline AxisFlags& operator&=(AxisFlags& lhs, AxisFlags rhs)
  { return (lhs = static_cast<AxisFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline AxisFlags& operator^=(AxisFlags& lhs, AxisFlags rhs)
  { return (lhs = static_cast<AxisFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::AxisFlags> : public Glib::Value_Flags<Gdk::AxisFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var AxisUse IGNORE
 * The axis is ignored.
 * 
 *  @var AxisUse X
 * The axis is used as the x axis.
 * 
 *  @var AxisUse Y
 * The axis is used as the y axis.
 * 
 *  @var AxisUse PRESSURE
 * The axis is used for pressure information.
 * 
 *  @var AxisUse XTILT
 * The axis is used for x tilt information.
 * 
 *  @var AxisUse YTILT
 * The axis is used for y tilt information.
 * 
 *  @var AxisUse WHEEL
 * The axis is used for wheel information.
 * 
 *  @var AxisUse DISTANCE
 * The axis is used for pen/tablet distance information. (Since: 3.22).
 * 
 *  @var AxisUse ROTATION
 * The axis is used for pen rotation information. (Since: 3.22).
 * 
 *  @var AxisUse SLIDER
 * The axis is used for pen slider information. (Since: 3.22).
 * 
 *  @var AxisUse LAST
 * A constant equal to the numerically highest axis value.
 * 
 *  @enum AxisUse
 * 
 * An enumeration describing the way in which a device
 * axis (valuator) maps onto the predefined valuator
 * types that GTK+ understands.
 * 
 * Note that the X and Y axes are not really needed; pointer devices
 * report their location via the x/y members of events regardless. Whether
 * X and Y are present as axes depends on the GDK backend.
 *
 * @ingroup gdkmmEnums
 */
enum class AxisUse
{
  IGNORE,
  X,
  Y,
  PRESSURE,
  XTILT,
  YTILT,
  WHEEL,
  DISTANCE,
  ROTATION,
  SLIDER,
  LAST
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::AxisUse> : public Glib::Value_Enum<Gdk::AxisUse>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var CrossingMode NORMAL
 * Crossing because of pointer motion.
 * 
 *  @var CrossingMode GRAB
 * Crossing because a grab is activated.
 * 
 *  @var CrossingMode UNGRAB
 * Crossing because a grab is deactivated.
 * 
 *  @var CrossingMode GTK_GRAB
 * Crossing because a GTK+ grab is activated.
 * 
 *  @var CrossingMode GTK_UNGRAB
 * Crossing because a GTK+ grab is deactivated.
 * 
 *  @var CrossingMode STATE_CHANGED
 * Crossing because a GTK+ widget changed
 * state (e.g. sensitivity).
 * 
 *  @var CrossingMode TOUCH_BEGIN
 * Crossing because a touch sequence has begun,
 * this event is synthetic as the pointer might have not left the window.
 * 
 *  @var CrossingMode TOUCH_END
 * Crossing because a touch sequence has ended,
 * this event is synthetic as the pointer might have not left the window.
 * 
 *  @var CrossingMode DEVICE_SWITCH
 * Crossing because of a device switch (i.e.
 * a mouse taking control of the pointer after a touch device), this event
 * is synthetic as the pointer didn’t leave the window.
 * 
 *  @enum CrossingMode
 * 
 * Specifies the crossing mode for enter and leave events.
 *
 * @ingroup gdkmmEnums
 */
enum class CrossingMode
{
  NORMAL,
  GRAB,
  UNGRAB,
  GTK_GRAB,
  GTK_UNGRAB,
  STATE_CHANGED,
  TOUCH_BEGIN,
  TOUCH_END,
  DEVICE_SWITCH
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::CrossingMode> : public Glib::Value_Enum<Gdk::CrossingMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

//_WRAP_ENUM(FilterReturn, GdkFilterReturn)
/** 
 *  @var NotifyType ANCESTOR
 * The window is entered from an ancestor or
 * left towards an ancestor.
 * 
 *  @var NotifyType VIRTUAL
 * The pointer moves between an ancestor and an
 * inferior of the window.
 * 
 *  @var NotifyType INFERIOR
 * The window is entered from an inferior or
 * left towards an inferior.
 * 
 *  @var NotifyType NONLINEAR
 * The window is entered from or left towards
 * a window which is neither an ancestor nor an inferior.
 * 
 *  @var NotifyType NONLINEAR_VIRTUAL
 * The pointer moves between two windows
 * which are not ancestors of each other and the window is part of
 * the ancestor chain between one of these windows and their least
 * common ancestor.
 * 
 *  @var NotifyType UNKNOWN
 * An unknown type of enter/leave event occurred.
 * 
 *  @enum NotifyType
 * 
 * Specifies the kind of crossing for enter and leave events.
 * 
 * See the X11 protocol specification of LeaveNotify for
 * full details of crossing event generation.
 *
 * @ingroup gdkmmEnums
 */
enum class NotifyType
{
  ANCESTOR,
  VIRTUAL,
  INFERIOR,
  NONLINEAR,
  NONLINEAR_VIRTUAL,
  UNKNOWN
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::NotifyType> : public Glib::Value_Enum<Gdk::NotifyType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

/** 
 *  @var ScrollDirection UP
 * The window is scrolled up.
 * 
 *  @var ScrollDirection DOWN
 * The window is scrolled down.
 * 
 *  @var ScrollDirection LEFT
 * The window is scrolled to the left.
 * 
 *  @var ScrollDirection RIGHT
 * The window is scrolled to the right.
 * 
 *  @var ScrollDirection SMOOTH
 * The scrolling is determined by the delta values
 * in scroll events. See Gdk::Event::get_scroll_deltas(). @newin{3,4}
 * 
 *  @enum ScrollDirection
 * 
 * Specifies the direction for scroll events.
 *
 * @ingroup gdkmmEnums
 */
enum class ScrollDirection
{
  UP,
  DOWN,
  LEFT,
  RIGHT,
  SMOOTH
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::ScrollDirection> : public Glib::Value_Enum<Gdk::ScrollDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{

// GdkEventVisibility is deprecated and not wrapped in gtkmm.
//_WRAP_ENUM(VisibilityState, GdkVisibilityState)
/** 
 *  @var TouchpadGesturePhase BEGIN
 * The gesture has begun.
 * 
 *  @var TouchpadGesturePhase UPDATE
 * The gesture has been updated.
 * 
 *  @var TouchpadGesturePhase END
 * The gesture was finished, changes
 * should be permanently applied.
 * 
 *  @var TouchpadGesturePhase CANCEL
 * The gesture was cancelled, all
 * changes should be undone.
 * 
 *  @enum TouchpadGesturePhase
 * 
 * Specifies the current state of a touchpad gesture. All gestures are
 * guaranteed to begin with an event with phase Gdk::TouchpadGesturePhase::BEGIN,
 * followed by 0 or several events with phase Gdk::TouchpadGesturePhase::UPDATE.
 * 
 * A finished gesture may have 2 possible outcomes, an event with phase
 * Gdk::TouchpadGesturePhase::END will be emitted when the gesture is
 * considered successful, this should be used as the hint to perform any
 * permanent changes.
 * 
 * Cancelled gestures may be so for a variety of reasons, due to hardware
 * or the compositor, or due to the gesture recognition layers hinting the
 * gesture did not finish resolutely (eg. a 3rd finger being added during
 * a pinch gesture). In these cases, the last event will report the phase
 * Gdk::TouchpadGesturePhase::CANCEL, this should be used as a hint
 * to undo any visible/permanent changes that were done throughout the
 * progress of the gesture.
 *
 * @ingroup gdkmmEnums
 */
enum class TouchpadGesturePhase
{
  BEGIN,
  UPDATE,
  END,
  CANCEL
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::TouchpadGesturePhase> : public Glib::Value_Enum<Gdk::TouchpadGesturePhase>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


} //namespace Gdk


#endif /* _GDKMM_ENUMS_H */

