// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GTKMM_IMAGE_H
#define _GTKMM_IMAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/widget.h>
#include <gdkmm/value_cairo.h>
#include <giomm/icon.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkImage = struct _GtkImage;
using GtkImageClass = struct _GtkImageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Image_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{


/** A widget displaying an image.
 *
 * The Gtk::Image widget displays an image. Various kinds of object can be
 * displayed as an image; most typically, you would load a Gdk::Pixbuf ("pixel
 * buffer") from a file, and then display that.
 *
 * The Image widget looks like this:
 * @image html image1.png
 *
 * @ingroup Widgets
 */

class Image : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Image CppObjectType;
  typedef Image_Class CppClassType;
  typedef GtkImage BaseObjectType;
  typedef GtkImageClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Image(Image&& src) noexcept;
  Image& operator=(Image&& src) noexcept;

  // noncopyable
  Image(const Image&) = delete;
  Image& operator=(const Image&) = delete;

  ~Image() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Image_Class;
  static CppClassType image_class_;

protected:
  explicit Image(const Glib::ConstructParams& construct_params);
  explicit Image(GtkImage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkImage*       gobj()       { return reinterpret_cast<GtkImage*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkImage* gobj() const { return reinterpret_cast<GtkImage*>(gobject_); }

private:

public:
  /** @addtogroup gtkmmEnums gtkmm Enums and Flags */

  /** 
   *  @var Type EMPTY
   * There is no image displayed by the widget.
   * 
   *  @var Type ICON_NAME
   * The widget contains a named icon.
   * This image type was added in GTK+ 2.6.
   * 
   *  @var Type GICON
   * The widget contains a Gio::Icon.
   * This image type was added in GTK+ 2.14.
   * 
   *  @var Type SURFACE
   * The widget contains a #cairo_surface_t.
   * This image type was added in GTK+ 3.10.
   * 
   *  @var Type TEXTURE
   * The widget contains a Gdk::Texture.
   * This image type was added in GTK+ 3.94.
   * 
   *  @enum Type
   * 
   * Describes the image data representation used by a Gtk::Image. If you
   * want to get the image from the widget, you can only get the
   * currently-stored representation. e.g.  if the
   * Gtk::Image::get_storage_type() returns Gtk::Image::Type::SURFACE, then you can
   * call Gtk::Image::get_surface().  For empty images, you can request any
   * storage type (call any of the "get" functions), but they will all
   * return <tt>nullptr</tt> values.
   *
   * @ingroup gtkmmEnums
   */
  enum class Type
  {
    EMPTY,
    ICON_NAME,
    GICON,
    SURFACE,
    TEXTURE
  };


  Image();

  /** Creates an Image widget displaying the file @a filename.
   * If the file isn't found or can't be loaded, the resulting Gtk::Image will display a "broken image" icon.
   *
   * If you need to detect failures to load the file, use Gdk::Pixbuf::create_from_file() to load the file yourself,
   * then create the GtkImage from the pixbuf.
   *
   * The storage type (get_storage_type()) of the returned image is not defined.
   * It will be whatever is appropriate for displaying the file.
   */
    explicit Image(const std::string& filename);


  // gtk_image_new_from_pixbuf() does more than just call g_object_new().
  // GtkImage has no "pixbuf" property.
  /** Creates a new Image widget displaying @a pixbuf.
   * Note that this just creates an GtkImage from the pixbuf. The Gtk::Image created will not react to state changes.
   * Should you want that, you should use the default constructor and set_from_icon_name().
   */
  Image(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  

  //We don't wrap gtk_image_new_from_icon_name() to avoid a clash with the from-filename constructor.
  //But we do wrap gtk_image_set_from_icon_name()
  

  /** See the Image::Image(const std::string& file) constructor for details.
   * 
   * @param filename A filename.
   */
  void set(const std::string& filename);
  
  /** See new_from_resource() for details.
   * 
   * @param resource_path A resource path or <tt>nullptr</tt>.
   */
  void set_from_resource(const std::string& resource_path);
  
  /** See the Image::Image(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf) constructor for details.
   * 
   * @param pixbuf A #Gdk::Pixbuf.
   */
  void set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  
  /** See new_from_texture() for details.
   * 
   * @param texture A Gdk::Texture or <tt>nullptr</tt>.
   */
  void set(const Glib::RefPtr<Gdk::Texture>& texture);
  
  /** See new_from_gicon() for details.
   * 
   * @note Before 3.94, this function was taking an extra icon size
   * argument. See set_icon_size() for another way to set
   * the icon size.
   * 
   * @param icon An icon.
   */
  void set(const Glib::RefPtr<const Gio::Icon>& icon);

  
  /** See new_from_surface() for details.
   * 
   * @param surface A cairo_surface_t or <tt>nullptr</tt>.
   */
  void set(const Cairo::RefPtr<Cairo::Surface>& surface);

  
  /** Causes the Image to display an icon from the current icon theme.
   * If the icon name isn't known, a "broken image" icon will be
   * displayed instead.  If the current icon theme is changed, the icon
   * will be updated appropriately.
   * 
   * @newin{2,6}
   * 
   * @param icon_name An icon name or <tt>nullptr</tt>.
   */
  void set_from_icon_name(const Glib::ustring& icon_name);

  
  /** Resets the image to be empty.
   */
  void clear();

  
  /** Gets the type of representation being used by the Gtk::Image
   * to store image data. If the Gtk::Image has no image data,
   * the return value will be Gtk::Image::Type::EMPTY.
   * 
   * @return Image representation being used.
   */
  Type get_storage_type() const;

  
  /** Gets the image #cairo_surface_t being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::SURFACE (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned surface.
   * 
   * @return The displayed surface, or <tt>nullptr</tt> if
   * the image is empty.
   */
  Cairo::RefPtr<Cairo::Surface> get_surface();
  
  /** Gets the image #cairo_surface_t being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::SURFACE (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned surface.
   * 
   * @return The displayed surface, or <tt>nullptr</tt> if
   * the image is empty.
   */
  Cairo::RefPtr<const Cairo::Surface> get_surface() const;

  
  /** Gets the image Gdk::Texture being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::TEXTURE (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned texture.
   * 
   * @return The displayed texture, or <tt>nullptr</tt> if
   * the image is empty.
   */
  Glib::RefPtr<Gdk::Texture> get_texture();
  
  /** Gets the image Gdk::Texture being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::TEXTURE (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned texture.
   * 
   * @return The displayed texture, or <tt>nullptr</tt> if
   * the image is empty.
   */
  Glib::RefPtr<const Gdk::Texture> get_texture() const;

  
  /** Suggests an icon size to the theme for named icons.
   * 
   * @param icon_size The new icon size.
   */
  void set_icon_size(IconSize icon_size);
  
  /** Gets the icon size used by the @a image when rendering icons.
   * 
   * @return The image size used by icons.
   */
  IconSize get_icon_size() const;

  
  /** Gets the Gio::Icon and size being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::GICON (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned Gio::Icon.
   * 
   * @note This function was changed in 3.94 not to use out parameters
   * anymore, but return the GIcon directly. See get_icon_size()
   * for a way to get the icon size.
   * 
   * @return A Gio::Icon, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Gio::Icon> get_gicon();
  
  /** Gets the Gio::Icon and size being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::GICON (see get_storage_type()).
   * The caller of this function does not own a reference to the
   * returned Gio::Icon.
   * 
   * @note This function was changed in 3.94 not to use out parameters
   * anymore, but return the GIcon directly. See get_icon_size()
   * for a way to get the icon size.
   * 
   * @return A Gio::Icon, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Gio::Icon> get_gicon() const;
  
  /** Gets the icon name and size being displayed by the Gtk::Image.
   * The storage type of the image must be Gtk::Image::Type::EMPTY or
   * Gtk::Image::Type::ICON_NAME (see get_storage_type()).
   * The returned string is owned by the Gtk::Image and should not
   * be freed.
   * 
   * @note This function was changed in 3.94 not to use out parameters
   * anymore, but return the icon name directly. See get_icon_size()
   * for a way to get the icon size.
   * 
   * @return The icon name, or <tt>nullptr</tt>.
   */
  Glib::ustring get_icon_name() const;

 
  /** Gets the pixel size used for named icons.
   * 
   * @return The pixel size used for named icons.
   */
  int get_pixel_size() const;
 
  /** Sets the pixel size to use for named icons. If the pixel size is set
   * to a value != -1, it is used instead of the icon size set by
   * set_from_icon_name().
   * 
   * @param pixel_size The new pixel size.
   */
  void set_pixel_size(int pixel_size);

  /** Filename to load and display.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_file() ;

/** Filename to load and display.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_file() const;

  /** Symbolic size to use for icon set or named icon.
   *
   * Default value: Gtk::IconSize::INHERIT
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< IconSize > property_icon_size() ;

/** Symbolic size to use for icon set or named icon.
   *
   * Default value: Gtk::IconSize::INHERIT
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< IconSize > property_icon_size() const;

  /** The "pixel-size" property can be used to specify a fixed size
   * overriding the Gtk::Image::property_icon_size() property for images of type
   * Gtk::Image::Type::ICON_NAME.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_pixel_size() ;

/** The "pixel-size" property can be used to specify a fixed size
   * overriding the Gtk::Image::property_icon_size() property for images of type
   * Gtk::Image::Type::ICON_NAME.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_pixel_size() const;

  /** The name of the icon in the icon theme. If the icon theme is
   * changed, the image will be updated automatically.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;

/** The name of the icon in the icon theme. If the icon theme is
   * changed, the image will be updated automatically.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;

  /** The representation being used for image data.
   *
   * Default value: Gtk::Image::Type::EMPTY
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Type > property_storage_type() const;


  /** The GIcon displayed in the GtkImage. For themed icons,
   * If the icon theme is changed, the image will be updated
   * automatically.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_gicon() ;

/** The GIcon displayed in the GtkImage. For themed icons,
   * If the icon theme is changed, the image will be updated
   * automatically.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_gicon() const;

  /** Whether the icon displayed in the GtkImage will use
   * standard icon names fallback. The value of this property
   * is only relevant for images of type Gtk::Image::Type::ICON_NAME
   * and Gtk::Image::Type::GICON.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_fallback() ;

/** Whether the icon displayed in the GtkImage will use
   * standard icon names fallback. The value of this property
   * is only relevant for images of type Gtk::Image::Type::ICON_NAME
   * and Gtk::Image::Type::GICON.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_fallback() const;

  /** A path to a resource file to display.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::string > property_resource() ;

/** A path to a resource file to display.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_resource() const;

  /** A cairo_surface_t to display.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Cairo::RefPtr<Cairo::Surface> > property_surface() ;

/** A cairo_surface_t to display.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Cairo::RefPtr<Cairo::Surface> > property_surface() const;

  /** A GdkTexture to display.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Texture> > property_texture() ;

/** A GdkTexture to display.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Texture> > property_texture() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} //namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Image::Type> : public Glib::Value_Enum<Gtk::Image::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Image
   */
  Gtk::Image* wrap(GtkImage* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_IMAGE_H */

