/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};


static gpointer vala_method_call_parent_class = NULL;

#define VALA_METHOD_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_CALL, ValaMethodCallPrivate))
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static void vala_method_call_finalize (ValaCodeNode * obj);


/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}


ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* expr = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _expr_index;
			_expr_index = _tmp7_ + 1;
			_tmp8_ = _expr_index;
			_tmp9_ = _expr_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _expr_list;
			_tmp11_ = _expr_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			expr = (ValaExpression*) _tmp12_;
			_tmp13_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	_tmp4_ = index;
	if (_tmp4_ >= 0) {
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) new_node);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaList* _tmp7_;
		gint _tmp8_;
		_tmp7_ = self->priv->argument_list;
		_tmp8_ = index;
		vala_list_set (_tmp7_, _tmp8_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}


static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp12_ = vala_method_call_get_call (self);
	_tmp13_ = _tmp12_;
	result = vala_expression_is_accessible (_tmp13_, sym);
	return result;
}


static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	gboolean gobject_chainup = FALSE;
	ValaExpression* _tmp114_;
	ValaExpression* _tmp115_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaClass* _tmp120_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp239_ = FALSE;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	gboolean _tmp315_ = FALSE;
	gboolean _tmp316_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp331_;
	ValaDataType* _tmp332_;
	ValaList* params = NULL;
	ValaDataType* _tmp333_;
	ValaList* _tmp334_;
	ValaDataType* _tmp335_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp408_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp409_;
	ValaIterator* _tmp410_;
	gboolean _tmp462_ = FALSE;
	ValaDataType* _tmp463_;
	gboolean _tmp488_ = FALSE;
	ValaDataType* _tmp489_;
	ValaDataType* _tmp564_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	ValaDataType* _tmp580_;
	ValaList* _tmp581_;
	ValaDataType* _tmp582_;
	ValaDataType* _tmp583_;
	gboolean may_throw = FALSE;
	ValaDataType* _tmp584_;
	ValaSemanticAnalyzer* _tmp890_;
	ValaSemanticAnalyzer* _tmp891_;
	ValaDataType* _tmp892_;
	ValaList* _tmp893_;
	ValaList* _tmp894_;
	ValaList* _tmp895_;
	gboolean _tmp896_;
	gboolean _tmp897_ = FALSE;
	gboolean _tmp898_ = FALSE;
	ValaCreationMethod* _tmp899_;
	gboolean _tmp928_;
	gboolean _tmp981_;
	gboolean _tmp982_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				ValaAttribute* _tmp99_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp99_ = _tmp98_;
				_tmp91_ = _tmp99_ != NULL;
				_vala_code_node_unref0 (_tmp99_);
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp100_;
				ValaList* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp100_ = vala_method_call_get_argument_list (self);
				args = _tmp100_;
				_tmp101_ = args;
				_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
				_tmp103_ = _tmp102_;
				if (_tmp103_ == 1) {
					ValaList* _tmp104_;
					gpointer _tmp105_;
					ValaExpression* _tmp106_;
					ValaSourceReference* _tmp107_;
					ValaSourceReference* _tmp108_;
					_tmp104_ = args;
					_tmp105_ = vala_list_get (_tmp104_, 0);
					_tmp106_ = (ValaExpression*) _tmp105_;
					_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
					_tmp108_ = _tmp107_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp108_);
					_vala_code_node_unref0 (_tmp106_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp109_ = vala_method_call_get_call (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_expression_get_value_type (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = _vala_code_node_ref0 (_tmp112_);
	mtype = _tmp113_;
	_tmp114_ = vala_method_call_get_call (self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_expression_get_symbol_reference (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = _tmp119_->object_type;
	gobject_chainup = _tmp117_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_SYMBOL, ValaSymbol);
	_tmp121_ = gobject_chainup;
	vala_method_call_set_is_chainup (self, _tmp121_);
	_tmp122_ = gobject_chainup;
	if (!_tmp122_) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_CLASS);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				gboolean _tmp214_;
				_tmp214_ = gobject_chainup;
				if (_tmp214_) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaSymbol* _tmp217_;
					ValaClass* _tmp218_;
					gboolean _tmp219_ = FALSE;
					ValaClass* _tmp220_;
					ValaExpression* _tmp227_;
					ValaExpression* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaSemanticAnalyzer* _tmp230_;
					ValaClass* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaObjectType* _tmp233_;
					ValaExpression* _tmp234_;
					ValaExpression* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					ValaDataType* _tmp238_;
					_tmp215_ = cm;
					_tmp216_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp217_) : NULL);
					cl = _tmp218_;
					_tmp220_ = cl;
					if (_tmp220_ == NULL) {
						_tmp219_ = TRUE;
					} else {
						ValaClass* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaSemanticAnalyzer* _tmp223_;
						ValaClass* _tmp224_;
						_tmp221_ = cl;
						_tmp222_ = vala_code_context_get_analyzer (context);
						_tmp223_ = _tmp222_;
						_tmp224_ = _tmp223_->object_type;
						_tmp219_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp221_, (ValaTypeSymbol*) _tmp224_);
					}
					if (_tmp219_) {
						ValaSourceReference* _tmp225_;
						ValaSourceReference* _tmp226_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp226_ = _tmp225_;
						vala_report_error (_tmp226_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp227_ = vala_method_call_get_call (self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_code_context_get_analyzer (context);
					_tmp230_ = _tmp229_;
					_tmp231_ = _tmp230_->object_type;
					_tmp232_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp231_);
					_tmp233_ = _tmp232_;
					vala_expression_set_value_type (_tmp228_, (ValaDataType*) _tmp233_);
					_vala_code_node_unref0 (_tmp233_);
					_tmp234_ = vala_method_call_get_call (self);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_expression_get_value_type (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _vala_code_node_ref0 (_tmp237_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp238_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp240_ = vala_method_call_get_call (self);
	_tmp241_ = _tmp240_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp241_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp242_ = FALSE;
		gboolean _tmp243_ = FALSE;
		ValaExpression* _tmp244_;
		ValaExpression* _tmp245_;
		ValaSymbol* _tmp246_;
		ValaSymbol* _tmp247_;
		_tmp244_ = vala_method_call_get_call (self);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_expression_get_symbol_reference (_tmp245_);
		_tmp247_ = _tmp246_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			ValaSymbol* _tmp253_;
			_tmp248_ = vala_method_call_get_call (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp252_ = vala_symbol_get_parent_symbol (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp243_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp253_, VALA_TYPE_STRUCT);
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			_tmp242_ = TRUE;
		} else {
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			ValaSymbol* _tmp256_;
			ValaSymbol* _tmp257_;
			_tmp254_ = vala_method_call_get_call (self);
			_tmp255_ = _tmp254_;
			_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_STRUCT);
		}
		_tmp239_ = _tmp242_;
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp258_;
		ValaExpression* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaSymbol* _tmp261_;
		ValaStruct* _tmp262_;
		gboolean _tmp263_ = FALSE;
		gboolean _tmp264_ = FALSE;
		ValaStruct* _tmp265_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp281_;
		ValaObjectCreationExpression* _tmp294_;
		ValaDataType* _tmp295_;
		ValaDataType* _tmp296_;
		ValaSemanticAnalyzer* _tmp297_;
		ValaSemanticAnalyzer* _tmp298_;
		ValaList* _tmp299_;
		ValaCodeNode* _tmp300_;
		ValaCodeNode* _tmp301_;
		ValaObjectCreationExpression* _tmp302_;
		ValaObjectCreationExpression* _tmp303_;
		_tmp258_ = vala_method_call_get_call (self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp261_) : NULL);
		st = _tmp262_;
		_tmp265_ = st;
		if (_tmp265_ != NULL) {
			ValaStruct* _tmp266_;
			ValaMethod* _tmp267_;
			ValaMethod* _tmp268_;
			_tmp266_ = st;
			_tmp267_ = vala_struct_get_default_construction_method (_tmp266_);
			_tmp268_ = _tmp267_;
			_tmp264_ = _tmp268_ == NULL;
		} else {
			_tmp264_ = FALSE;
		}
		if (_tmp264_) {
			gboolean _tmp269_ = FALSE;
			gboolean _tmp270_ = FALSE;
			ValaStruct* _tmp271_;
			_tmp271_ = st;
			if (vala_struct_is_boolean_type (_tmp271_)) {
				_tmp270_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp270_ = vala_struct_is_integer_type (_tmp272_);
			}
			if (_tmp270_) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp273_;
				_tmp273_ = st;
				_tmp269_ = vala_struct_is_floating_type (_tmp273_);
			}
			_tmp263_ = _tmp269_;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			ValaSourceReference* _tmp274_;
			ValaSourceReference* _tmp275_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp275_ = _tmp274_;
			vala_report_error (_tmp275_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp276_ = vala_method_call_get_call (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp279_);
		struct_creation_expression = _tmp280_;
		_tmp281_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp281_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp282_;
			gint _arg_size = 0;
			ValaList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _arg_index = 0;
			_tmp282_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp282_;
			_tmp283_ = _arg_list;
			_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_arg_size = _tmp285_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp286_;
				gint _tmp287_;
				gint _tmp288_;
				ValaExpression* arg = NULL;
				ValaList* _tmp289_;
				gint _tmp290_;
				gpointer _tmp291_;
				ValaObjectCreationExpression* _tmp292_;
				ValaExpression* _tmp293_;
				_tmp286_ = _arg_index;
				_arg_index = _tmp286_ + 1;
				_tmp287_ = _arg_index;
				_tmp288_ = _arg_size;
				if (!(_tmp287_ < _tmp288_)) {
					break;
				}
				_tmp289_ = _arg_list;
				_tmp290_ = _arg_index;
				_tmp291_ = vala_list_get (_tmp289_, _tmp290_);
				arg = (ValaExpression*) _tmp291_;
				_tmp292_ = struct_creation_expression;
				_tmp293_ = arg;
				vala_object_creation_expression_add_argument (_tmp292_, _tmp293_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp294_ = struct_creation_expression;
		_tmp295_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp296_ = _tmp295_;
		vala_expression_set_target_type ((ValaExpression*) _tmp294_, _tmp296_);
		_tmp297_ = vala_code_context_get_analyzer (context);
		_tmp298_ = _tmp297_;
		_tmp299_ = _tmp298_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp299_, (ValaCodeNode*) self);
		_tmp300_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp301_ = _tmp300_;
		_tmp302_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp301_, (ValaExpression*) self, (ValaExpression*) _tmp302_);
		_tmp303_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp303_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp304_ = FALSE;
		gboolean _tmp305_ = FALSE;
		gboolean _tmp306_;
		_tmp306_ = self->priv->_is_chainup;
		if (!_tmp306_) {
			ValaExpression* _tmp307_;
			ValaExpression* _tmp308_;
			_tmp307_ = vala_method_call_get_call (self);
			_tmp308_ = _tmp307_;
			_tmp305_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp308_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp305_ = FALSE;
		}
		if (_tmp305_) {
			ValaExpression* _tmp309_;
			ValaExpression* _tmp310_;
			ValaSymbol* _tmp311_;
			ValaSymbol* _tmp312_;
			_tmp309_ = vala_method_call_get_call (self);
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_expression_get_symbol_reference (_tmp310_);
			_tmp312_ = _tmp311_;
			_tmp304_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp312_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp304_ = FALSE;
		}
		if (_tmp304_) {
			ValaSourceReference* _tmp313_;
			ValaSourceReference* _tmp314_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp314_ = _tmp313_;
			vala_report_error (_tmp314_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp316_ = self->priv->_is_chainup;
	if (!_tmp316_) {
		ValaDataType* _tmp317_;
		_tmp317_ = mtype;
		_tmp315_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp317_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		ValaSourceReference* _tmp318_;
		ValaSourceReference* _tmp319_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp319_ = _tmp318_;
		vala_report_error (_tmp319_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp320_ = FALSE;
		ValaDataType* _tmp321_;
		_tmp321_ = mtype;
		if (_tmp321_ != NULL) {
			ValaDataType* _tmp322_;
			_tmp322_ = mtype;
			_tmp320_ = vala_data_type_is_invokable (_tmp322_);
		} else {
			_tmp320_ = FALSE;
		}
		if (_tmp320_) {
		} else {
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			ValaSymbol* _tmp325_;
			ValaSymbol* _tmp326_;
			_tmp323_ = vala_method_call_get_call (self);
			_tmp324_ = _tmp323_;
			_tmp325_ = vala_expression_get_symbol_reference (_tmp324_);
			_tmp326_ = _tmp325_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp326_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp327_;
				ValaSourceReference* _tmp328_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp328_ = _tmp327_;
				vala_report_error (_tmp328_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp329_;
				ValaSourceReference* _tmp330_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp330_ = _tmp329_;
				vala_report_error (_tmp330_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp331_ = mtype;
	_tmp332_ = vala_data_type_get_return_type (_tmp331_);
	ret_type = _tmp332_;
	_tmp333_ = mtype;
	_tmp334_ = vala_data_type_get_parameters (_tmp333_);
	params = _tmp334_;
	_tmp335_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp335_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp336_;
		ValaMethod* _tmp337_;
		ValaMethod* _tmp338_;
		ValaMethod* _tmp339_;
		gboolean _tmp340_ = FALSE;
		ValaMethod* _tmp341_;
		ValaMethod* _tmp378_;
		_tmp336_ = mtype;
		_tmp337_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp336_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp338_ = _tmp337_;
		_tmp339_ = _vala_code_node_ref0 (_tmp338_);
		m = _tmp339_;
		_tmp341_ = m;
		if (_tmp341_ != NULL) {
			ValaMethod* _tmp342_;
			gboolean _tmp343_;
			gboolean _tmp344_;
			_tmp342_ = m;
			_tmp343_ = vala_method_get_coroutine (_tmp342_);
			_tmp344_ = _tmp343_;
			_tmp340_ = _tmp344_;
		} else {
			_tmp340_ = FALSE;
		}
		if (_tmp340_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp345_;
			ValaExpression* _tmp346_;
			ValaMemberAccess* _tmp347_;
			gboolean _tmp348_;
			_tmp345_ = vala_method_call_get_call (self);
			_tmp346_ = _tmp345_;
			_tmp347_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp346_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp347_;
			_tmp348_ = self->priv->_is_yield_expression;
			if (!_tmp348_) {
				ValaMemberAccess* _tmp349_;
				const gchar* _tmp350_;
				const gchar* _tmp351_;
				_tmp349_ = ma;
				_tmp350_ = vala_member_access_get_member_name (_tmp349_);
				_tmp351_ = _tmp350_;
				if (g_strcmp0 (_tmp351_, "end") != 0) {
					ValaMemberAccess* _tmp352_;
					const gchar* _tmp353_;
					const gchar* _tmp354_;
					ValaMethod* _tmp358_;
					ValaList* _tmp359_;
					ValaVoidType* _tmp360_;
					_tmp352_ = ma;
					_tmp353_ = vala_member_access_get_member_name (_tmp352_);
					_tmp354_ = _tmp353_;
					if (g_strcmp0 (_tmp354_, "begin") != 0) {
						ValaMemberAccess* _tmp355_;
						ValaSourceReference* _tmp356_;
						ValaSourceReference* _tmp357_;
						_tmp355_ = ma;
						_tmp356_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp355_);
						_tmp357_ = _tmp356_;
						vala_report_deprecated (_tmp357_, "implicit .begin is deprecated");
					}
					_tmp358_ = m;
					_tmp359_ = vala_method_get_async_begin_parameters (_tmp358_);
					_vala_iterable_unref0 (params);
					params = _tmp359_;
					_tmp360_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp360_;
				} else {
					ValaMethod* _tmp361_;
					ValaList* _tmp362_;
					_tmp361_ = m;
					_tmp362_ = vala_method_get_async_end_parameters (_tmp361_);
					_vala_iterable_unref0 (params);
					params = _tmp362_;
				}
			} else {
				gboolean _tmp363_ = FALSE;
				ValaMemberAccess* _tmp364_;
				const gchar* _tmp365_;
				const gchar* _tmp366_;
				_tmp364_ = ma;
				_tmp365_ = vala_member_access_get_member_name (_tmp364_);
				_tmp366_ = _tmp365_;
				if (g_strcmp0 (_tmp366_, "begin") == 0) {
					_tmp363_ = TRUE;
				} else {
					ValaMemberAccess* _tmp367_;
					const gchar* _tmp368_;
					const gchar* _tmp369_;
					_tmp367_ = ma;
					_tmp368_ = vala_member_access_get_member_name (_tmp367_);
					_tmp369_ = _tmp368_;
					_tmp363_ = g_strcmp0 (_tmp369_, "end") == 0;
				}
				if (_tmp363_) {
					ValaMemberAccess* _tmp370_;
					ValaSourceReference* _tmp371_;
					ValaSourceReference* _tmp372_;
					ValaMemberAccess* _tmp373_;
					const gchar* _tmp374_;
					const gchar* _tmp375_;
					gchar* _tmp376_;
					gchar* _tmp377_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp370_ = ma;
					_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp370_);
					_tmp372_ = _tmp371_;
					_tmp373_ = ma;
					_tmp374_ = vala_member_access_get_member_name (_tmp373_);
					_tmp375_ = _tmp374_;
					_tmp376_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp375_);
					_tmp377_ = _tmp376_;
					vala_report_error (_tmp372_, _tmp377_);
					_g_free0 (_tmp377_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp378_ = m;
		if (_tmp378_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp379_;
			ValaExpression* _tmp380_;
			ValaMemberAccess* _tmp381_;
			gint n_type_params = 0;
			ValaMethod* _tmp382_;
			ValaList* _tmp383_;
			ValaList* _tmp384_;
			gint _tmp385_;
			gint _tmp386_;
			gint _tmp387_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp388_;
			ValaList* _tmp389_;
			ValaList* _tmp390_;
			gint _tmp391_;
			gint _tmp392_;
			gint _tmp393_;
			gboolean _tmp394_ = FALSE;
			gint _tmp395_;
			_tmp379_ = vala_method_call_get_call (self);
			_tmp380_ = _tmp379_;
			_tmp381_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp380_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp381_;
			_tmp382_ = m;
			_tmp383_ = vala_method_get_type_parameters (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_collection_get_size ((ValaCollection*) _tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = _tmp386_;
			_vala_iterable_unref0 (_tmp384_);
			n_type_params = _tmp387_;
			_tmp388_ = ma;
			_tmp389_ = vala_member_access_get_type_arguments (_tmp388_);
			_tmp390_ = _tmp389_;
			_tmp391_ = vala_collection_get_size ((ValaCollection*) _tmp390_);
			_tmp392_ = _tmp391_;
			_tmp393_ = _tmp392_;
			_vala_iterable_unref0 (_tmp390_);
			n_type_args = _tmp393_;
			_tmp395_ = n_type_args;
			if (_tmp395_ > 0) {
				gint _tmp396_;
				gint _tmp397_;
				_tmp396_ = n_type_args;
				_tmp397_ = n_type_params;
				_tmp394_ = _tmp396_ < _tmp397_;
			} else {
				_tmp394_ = FALSE;
			}
			if (_tmp394_) {
				ValaMemberAccess* _tmp398_;
				ValaSourceReference* _tmp399_;
				ValaSourceReference* _tmp400_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp398_ = ma;
				_tmp399_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp398_);
				_tmp400_ = _tmp399_;
				vala_report_error (_tmp400_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp401_ = FALSE;
				gint _tmp402_;
				_tmp402_ = n_type_args;
				if (_tmp402_ > 0) {
					gint _tmp403_;
					gint _tmp404_;
					_tmp403_ = n_type_args;
					_tmp404_ = n_type_params;
					_tmp401_ = _tmp403_ > _tmp404_;
				} else {
					_tmp401_ = FALSE;
				}
				if (_tmp401_) {
					ValaMemberAccess* _tmp405_;
					ValaSourceReference* _tmp406_;
					ValaSourceReference* _tmp407_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp405_ = ma;
					_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp405_);
					_tmp407_ = _tmp406_;
					vala_report_error (_tmp407_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp408_ = vala_method_call_get_argument_list (self);
	args = _tmp408_;
	_tmp409_ = args;
	_tmp410_ = vala_iterable_iterator ((ValaIterable*) _tmp409_);
	arg_it = _tmp410_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp411_;
		ValaList* _tmp412_;
		gint _param_size = 0;
		ValaList* _tmp413_;
		gint _tmp414_;
		gint _tmp415_;
		gint _param_index = 0;
		_tmp411_ = params;
		_tmp412_ = _vala_iterable_ref0 (_tmp411_);
		_param_list = _tmp412_;
		_tmp413_ = _param_list;
		_tmp414_ = vala_collection_get_size ((ValaCollection*) _tmp413_);
		_tmp415_ = _tmp414_;
		_param_size = _tmp415_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp416_;
			gint _tmp417_;
			gint _tmp418_;
			ValaParameter* param = NULL;
			ValaList* _tmp419_;
			gint _tmp420_;
			gpointer _tmp421_;
			ValaParameter* _tmp422_;
			gboolean _tmp423_;
			gboolean _tmp424_;
			ValaParameter* _tmp425_;
			gboolean _tmp426_;
			gboolean _tmp427_;
			ValaIterator* _tmp445_;
			_tmp416_ = _param_index;
			_param_index = _tmp416_ + 1;
			_tmp417_ = _param_index;
			_tmp418_ = _param_size;
			if (!(_tmp417_ < _tmp418_)) {
				break;
			}
			_tmp419_ = _param_list;
			_tmp420_ = _param_index;
			_tmp421_ = vala_list_get (_tmp419_, _tmp420_);
			param = (ValaParameter*) _tmp421_;
			_tmp422_ = param;
			_tmp423_ = vala_parameter_get_ellipsis (_tmp422_);
			_tmp424_ = _tmp423_;
			if (_tmp424_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp425_ = param;
			_tmp426_ = vala_parameter_get_params_array (_tmp425_);
			_tmp427_ = _tmp426_;
			if (_tmp427_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp428_;
				ValaDataType* _tmp429_;
				ValaDataType* _tmp430_;
				ValaArrayType* _tmp431_;
				_tmp428_ = param;
				_tmp429_ = vala_variable_get_variable_type ((ValaVariable*) _tmp428_);
				_tmp430_ = _tmp429_;
				_tmp431_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp430_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp431_;
				while (TRUE) {
					ValaIterator* _tmp432_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp433_;
					gpointer _tmp434_;
					ValaExpression* _tmp435_;
					ValaArrayType* _tmp436_;
					ValaDataType* _tmp437_;
					ValaDataType* _tmp438_;
					ValaExpression* _tmp439_;
					ValaDataType* _tmp440_;
					ValaDataType* _tmp441_;
					ValaArrayType* _tmp442_;
					gboolean _tmp443_;
					gboolean _tmp444_;
					_tmp432_ = arg_it;
					if (!vala_iterator_next (_tmp432_)) {
						break;
					}
					_tmp433_ = arg_it;
					_tmp434_ = vala_iterator_get (_tmp433_);
					arg = (ValaExpression*) _tmp434_;
					_tmp435_ = arg;
					_tmp436_ = array_type;
					_tmp437_ = vala_array_type_get_element_type (_tmp436_);
					_tmp438_ = _tmp437_;
					vala_expression_set_target_type (_tmp435_, _tmp438_);
					_tmp439_ = arg;
					_tmp440_ = vala_expression_get_target_type (_tmp439_);
					_tmp441_ = _tmp440_;
					_tmp442_ = array_type;
					_tmp443_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp442_);
					_tmp444_ = _tmp443_;
					vala_data_type_set_value_owned (_tmp441_, _tmp444_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp445_ = arg_it;
			if (vala_iterator_next (_tmp445_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp446_;
				gpointer _tmp447_;
				ValaExpression* _tmp448_;
				ValaParameter* _tmp449_;
				ValaDataType* _tmp450_;
				ValaDataType* _tmp451_;
				ValaExpression* _tmp452_;
				ValaExpression* _tmp453_;
				ValaDataType* _tmp454_;
				ValaDataType* _tmp455_;
				ValaDataType* _tmp456_;
				ValaList* _tmp457_;
				ValaDataType* _tmp458_;
				ValaDataType* _tmp459_;
				ValaExpression* _tmp460_;
				ValaExpression* _tmp461_;
				_tmp446_ = arg_it;
				_tmp447_ = vala_iterator_get (_tmp446_);
				arg = (ValaExpression*) _tmp447_;
				_tmp448_ = arg;
				_tmp449_ = param;
				_tmp450_ = vala_variable_get_variable_type ((ValaVariable*) _tmp449_);
				_tmp451_ = _tmp450_;
				vala_expression_set_formal_target_type (_tmp448_, _tmp451_);
				_tmp452_ = arg;
				_tmp453_ = arg;
				_tmp454_ = vala_expression_get_formal_target_type (_tmp453_);
				_tmp455_ = _tmp454_;
				_tmp456_ = target_object_type;
				_tmp457_ = method_type_args;
				_tmp458_ = vala_data_type_get_actual_type (_tmp455_, _tmp456_, _tmp457_, (ValaCodeNode*) self);
				_tmp459_ = _tmp458_;
				vala_expression_set_target_type (_tmp452_, _tmp459_);
				_vala_code_node_unref0 (_tmp459_);
				_tmp460_ = arg;
				_tmp461_ = _vala_code_node_ref0 (_tmp460_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp461_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp463_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp463_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp464_;
		ValaMethod* _tmp465_;
		ValaMethod* _tmp466_;
		ValaAttribute* _tmp467_;
		ValaAttribute* _tmp468_;
		_tmp464_ = mtype;
		_tmp465_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp464_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp466_, "Print");
		_tmp468_ = _tmp467_;
		_tmp462_ = _tmp468_ != NULL;
		_vala_code_node_unref0 (_tmp468_);
	} else {
		_tmp462_ = FALSE;
	}
	if (_tmp462_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp469_;
		ValaSourceReference* _tmp470_;
		ValaTemplate* _tmp471_;
		ValaList* _tmp486_;
		ValaTemplate* _tmp487_;
		_tmp469_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp470_ = _tmp469_;
		_tmp471_ = vala_template_new (_tmp470_);
		template = _tmp471_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp472_;
			ValaList* _tmp473_;
			gint _arg_size = 0;
			ValaList* _tmp474_;
			gint _tmp475_;
			gint _tmp476_;
			gint _arg_index = 0;
			_tmp472_ = self->priv->argument_list;
			_tmp473_ = _vala_iterable_ref0 (_tmp472_);
			_arg_list = _tmp473_;
			_tmp474_ = _arg_list;
			_tmp475_ = vala_collection_get_size ((ValaCollection*) _tmp474_);
			_tmp476_ = _tmp475_;
			_arg_size = _tmp476_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp477_;
				gint _tmp478_;
				gint _tmp479_;
				ValaExpression* arg = NULL;
				ValaList* _tmp480_;
				gint _tmp481_;
				gpointer _tmp482_;
				ValaExpression* _tmp483_;
				ValaTemplate* _tmp484_;
				ValaExpression* _tmp485_;
				_tmp477_ = _arg_index;
				_arg_index = _tmp477_ + 1;
				_tmp478_ = _arg_index;
				_tmp479_ = _arg_size;
				if (!(_tmp478_ < _tmp479_)) {
					break;
				}
				_tmp480_ = _arg_list;
				_tmp481_ = _arg_index;
				_tmp482_ = vala_list_get (_tmp480_, _tmp481_);
				arg = (ValaExpression*) _tmp482_;
				_tmp483_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp483_, NULL);
				_tmp484_ = template;
				_tmp485_ = arg;
				vala_template_add_expression (_tmp484_, _tmp485_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp486_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp486_);
		_tmp487_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp487_);
		_vala_code_node_unref0 (template);
	}
	_tmp489_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp489_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp490_;
		ValaMethod* _tmp491_;
		ValaMethod* _tmp492_;
		gboolean _tmp493_;
		gboolean _tmp494_;
		_tmp490_ = mtype;
		_tmp491_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp490_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_method_get_printf_format (_tmp492_);
		_tmp494_ = _tmp493_;
		_tmp488_ = _tmp494_;
	} else {
		_tmp488_ = FALSE;
	}
	if (_tmp488_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp495_;
		ValaStringLiteral* _tmp544_;
		format_literal = NULL;
		_tmp495_ = last_arg;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp495_, VALA_TYPE_NULL_LITERAL)) {
		} else {
			ValaExpression* _tmp496_;
			_tmp496_ = last_arg;
			if (_tmp496_ != NULL) {
				ValaExpression* _tmp497_;
				ValaStringLiteral* _tmp498_;
				gboolean _tmp499_ = FALSE;
				ValaStringLiteral* _tmp500_;
				_tmp497_ = last_arg;
				_tmp498_ = vala_string_literal_get_format_literal (_tmp497_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp498_;
				_tmp500_ = format_literal;
				if (_tmp500_ == NULL) {
					ValaList* _tmp501_;
					gint _tmp502_;
					gint _tmp503_;
					ValaList* _tmp504_;
					gint _tmp505_;
					gint _tmp506_;
					_tmp501_ = args;
					_tmp502_ = vala_collection_get_size ((ValaCollection*) _tmp501_);
					_tmp503_ = _tmp502_;
					_tmp504_ = params;
					_tmp505_ = vala_collection_get_size ((ValaCollection*) _tmp504_);
					_tmp506_ = _tmp505_;
					_tmp499_ = _tmp503_ == (_tmp506_ - 1);
				} else {
					_tmp499_ = FALSE;
				}
				if (_tmp499_) {
					ValaStringLiteral* _tmp507_;
					ValaStringLiteral* _tmp508_;
					ValaSemanticAnalyzer* _tmp509_;
					ValaSemanticAnalyzer* _tmp510_;
					ValaDataType* _tmp511_;
					ValaDataType* _tmp512_;
					ValaDataType* _tmp513_;
					ValaList* _tmp514_;
					ValaList* _tmp515_;
					gint _tmp516_;
					gint _tmp517_;
					ValaStringLiteral* _tmp518_;
					ValaList* _tmp519_;
					ValaIterator* _tmp520_;
					_tmp507_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp507_;
					_tmp508_ = format_literal;
					_tmp509_ = vala_code_context_get_analyzer (context);
					_tmp510_ = _tmp509_;
					_tmp511_ = _tmp510_->string_type;
					_tmp512_ = vala_data_type_copy (_tmp511_);
					_tmp513_ = _tmp512_;
					vala_expression_set_target_type ((ValaExpression*) _tmp508_, _tmp513_);
					_vala_code_node_unref0 (_tmp513_);
					_tmp514_ = self->priv->argument_list;
					_tmp515_ = args;
					_tmp516_ = vala_collection_get_size ((ValaCollection*) _tmp515_);
					_tmp517_ = _tmp516_;
					_tmp518_ = format_literal;
					vala_list_insert (_tmp514_, _tmp517_ - 1, (ValaExpression*) _tmp518_);
					_tmp519_ = self->priv->argument_list;
					_tmp520_ = vala_iterable_iterator ((ValaIterable*) _tmp519_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp520_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp521_;
						ValaList* _tmp522_;
						gint _param_size = 0;
						ValaList* _tmp523_;
						gint _tmp524_;
						gint _tmp525_;
						gint _param_index = 0;
						_tmp521_ = params;
						_tmp522_ = _vala_iterable_ref0 (_tmp521_);
						_param_list = _tmp522_;
						_tmp523_ = _param_list;
						_tmp524_ = vala_collection_get_size ((ValaCollection*) _tmp523_);
						_tmp525_ = _tmp524_;
						_param_size = _tmp525_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp526_;
							gint _tmp527_;
							gint _tmp528_;
							ValaParameter* param = NULL;
							ValaList* _tmp529_;
							gint _tmp530_;
							gpointer _tmp531_;
							ValaParameter* _tmp532_;
							gboolean _tmp533_;
							gboolean _tmp534_;
							ValaIterator* _tmp535_;
							_tmp526_ = _param_index;
							_param_index = _tmp526_ + 1;
							_tmp527_ = _param_index;
							_tmp528_ = _param_size;
							if (!(_tmp527_ < _tmp528_)) {
								break;
							}
							_tmp529_ = _param_list;
							_tmp530_ = _param_index;
							_tmp531_ = vala_list_get (_tmp529_, _tmp530_);
							param = (ValaParameter*) _tmp531_;
							_tmp532_ = param;
							_tmp533_ = vala_parameter_get_ellipsis (_tmp532_);
							_tmp534_ = _tmp533_;
							if (_tmp534_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp535_ = arg_it;
							vala_iterator_next (_tmp535_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				_tmp536_ = vala_method_call_get_call (self);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp537_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp537_) : NULL);
				ma = _tmp538_;
				_tmp539_ = ma;
				if (_tmp539_ != NULL) {
					ValaMemberAccess* _tmp540_;
					ValaExpression* _tmp541_;
					ValaExpression* _tmp542_;
					ValaStringLiteral* _tmp543_;
					_tmp540_ = ma;
					_tmp541_ = vala_member_access_get_inner (_tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = vala_string_literal_get_format_literal (_tmp542_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp543_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp544_ = format_literal;
		if (_tmp544_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp545_;
			gchar* _tmp546_;
			ValaSemanticAnalyzer* _tmp547_;
			ValaSemanticAnalyzer* _tmp548_;
			const gchar* _tmp549_;
			ValaIterator* _tmp550_;
			ValaSourceReference* _tmp551_;
			ValaSourceReference* _tmp552_;
			_tmp545_ = format_literal;
			_tmp546_ = vala_string_literal_eval (_tmp545_);
			format = _tmp546_;
			_tmp547_ = vala_code_context_get_analyzer (context);
			_tmp548_ = _tmp547_;
			_tmp549_ = format;
			_tmp550_ = arg_it;
			_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp552_ = _tmp551_;
			if (!vala_semantic_analyzer_check_print_format (_tmp548_, _tmp549_, _tmp550_, _tmp552_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp553_;
		gint _arg_size = 0;
		ValaList* _tmp554_;
		gint _tmp555_;
		gint _tmp556_;
		gint _arg_index = 0;
		_tmp553_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp553_;
		_tmp554_ = _arg_list;
		_tmp555_ = vala_collection_get_size ((ValaCollection*) _tmp554_);
		_tmp556_ = _tmp555_;
		_arg_size = _tmp556_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp557_;
			gint _tmp558_;
			gint _tmp559_;
			ValaExpression* arg = NULL;
			ValaList* _tmp560_;
			gint _tmp561_;
			gpointer _tmp562_;
			ValaExpression* _tmp563_;
			_tmp557_ = _arg_index;
			_arg_index = _tmp557_ + 1;
			_tmp558_ = _arg_index;
			_tmp559_ = _arg_size;
			if (!(_tmp558_ < _tmp559_)) {
				break;
			}
			_tmp560_ = _arg_list;
			_tmp561_ = _arg_index;
			_tmp562_ = vala_list_get (_tmp560_, _tmp561_);
			arg = (ValaExpression*) _tmp562_;
			_tmp563_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp563_, context);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp564_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp564_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp565_ = FALSE;
		gboolean _tmp566_ = FALSE;
		ValaCodeNode* _tmp567_;
		ValaCodeNode* _tmp568_;
		_tmp567_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp568_ = _tmp567_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp568_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp569_;
			ValaCodeNode* _tmp570_;
			_tmp569_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp570_ = _tmp569_;
			_tmp566_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp570_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp566_ = FALSE;
		}
		if (_tmp566_) {
			ValaCodeNode* _tmp571_;
			ValaCodeNode* _tmp572_;
			_tmp571_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp572_ = _tmp571_;
			_tmp565_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp572_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp565_ = FALSE;
		}
		if (_tmp565_) {
			ValaSourceReference* _tmp573_;
			ValaSourceReference* _tmp574_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp573_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp574_ = _tmp573_;
			vala_report_error (_tmp574_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp575_ = ret_type;
	_tmp576_ = vala_data_type_copy (_tmp575_);
	_tmp577_ = _tmp576_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp577_);
	_vala_code_node_unref0 (_tmp577_);
	_tmp578_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp579_ = _tmp578_;
	_tmp580_ = target_object_type;
	_tmp581_ = method_type_args;
	_tmp582_ = vala_data_type_get_actual_type (_tmp579_, _tmp580_, _tmp581_, (ValaCodeNode*) self);
	_tmp583_ = _tmp582_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp583_);
	_vala_code_node_unref0 (_tmp583_);
	may_throw = FALSE;
	_tmp584_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp584_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp585_;
		ValaMethod* _tmp586_;
		ValaMethod* _tmp587_;
		ValaMethod* _tmp588_;
		gboolean _tmp589_;
		gboolean _tmp608_ = FALSE;
		gboolean _tmp609_ = FALSE;
		gboolean _tmp610_ = FALSE;
		ValaMethod* _tmp611_;
		ValaMethod* _tmp637_;
		gboolean _tmp638_;
		gboolean _tmp639_;
		ValaMethod* _tmp642_;
		gboolean _tmp643_;
		gboolean _tmp644_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp649_;
		ValaSymbol* _tmp650_;
		ValaSymbol* _tmp651_;
		ValaDynamicSignal* _tmp652_;
		gboolean _tmp653_ = FALSE;
		ValaDynamicSignal* _tmp654_;
		gboolean _tmp701_ = FALSE;
		ValaMethod* _tmp702_;
		gboolean _tmp827_ = FALSE;
		ValaMethod* _tmp828_;
		_tmp585_ = mtype;
		_tmp586_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp585_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp587_ = _tmp586_;
		_tmp588_ = _vala_code_node_ref0 (_tmp587_);
		m = _tmp588_;
		_tmp589_ = self->priv->_is_yield_expression;
		if (_tmp589_) {
			ValaMethod* _tmp590_;
			gboolean _tmp591_;
			gboolean _tmp592_;
			gboolean _tmp595_ = FALSE;
			ValaSemanticAnalyzer* _tmp596_;
			ValaSemanticAnalyzer* _tmp597_;
			ValaMethod* _tmp598_;
			ValaMethod* _tmp599_;
			_tmp590_ = m;
			_tmp591_ = vala_method_get_coroutine (_tmp590_);
			_tmp592_ = _tmp591_;
			if (!_tmp592_) {
				ValaSourceReference* _tmp593_;
				ValaSourceReference* _tmp594_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp594_ = _tmp593_;
				vala_report_error (_tmp594_, "yield expression requires async method");
			}
			_tmp596_ = vala_code_context_get_analyzer (context);
			_tmp597_ = _tmp596_;
			_tmp598_ = vala_semantic_analyzer_get_current_method (_tmp597_);
			_tmp599_ = _tmp598_;
			if (_tmp599_ == NULL) {
				_tmp595_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp600_;
				ValaSemanticAnalyzer* _tmp601_;
				ValaMethod* _tmp602_;
				ValaMethod* _tmp603_;
				gboolean _tmp604_;
				gboolean _tmp605_;
				_tmp600_ = vala_code_context_get_analyzer (context);
				_tmp601_ = _tmp600_;
				_tmp602_ = vala_semantic_analyzer_get_current_method (_tmp601_);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_method_get_coroutine (_tmp603_);
				_tmp605_ = _tmp604_;
				_tmp595_ = !_tmp605_;
			}
			if (_tmp595_) {
				ValaSourceReference* _tmp606_;
				ValaSourceReference* _tmp607_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp606_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp607_ = _tmp606_;
				vala_report_error (_tmp607_, "yield expression not available outside async method");
			}
		}
		_tmp611_ = m;
		if (_tmp611_ != NULL) {
			ValaMethod* _tmp612_;
			gboolean _tmp613_;
			gboolean _tmp614_;
			_tmp612_ = m;
			_tmp613_ = vala_method_get_coroutine (_tmp612_);
			_tmp614_ = _tmp613_;
			_tmp610_ = _tmp614_;
		} else {
			_tmp610_ = FALSE;
		}
		if (_tmp610_) {
			gboolean _tmp615_;
			_tmp615_ = self->priv->_is_yield_expression;
			_tmp609_ = !_tmp615_;
		} else {
			_tmp609_ = FALSE;
		}
		if (_tmp609_) {
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			const gchar* _tmp618_;
			const gchar* _tmp619_;
			_tmp616_ = vala_method_call_get_call (self);
			_tmp617_ = _tmp616_;
			_tmp618_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp617_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp619_ = _tmp618_;
			_tmp608_ = g_strcmp0 (_tmp619_, "end") != 0;
		} else {
			_tmp608_ = FALSE;
		}
		if (_tmp608_) {
		} else {
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp620_;
				ValaList* _tmp621_;
				gint _error_type_size = 0;
				ValaList* _tmp622_;
				gint _tmp623_;
				gint _tmp624_;
				gint _error_type_index = 0;
				_tmp620_ = m;
				_tmp621_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp620_);
				_error_type_list = _tmp621_;
				_tmp622_ = _error_type_list;
				_tmp623_ = vala_collection_get_size ((ValaCollection*) _tmp622_);
				_tmp624_ = _tmp623_;
				_error_type_size = _tmp624_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp625_;
					gint _tmp626_;
					gint _tmp627_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp628_;
					gint _tmp629_;
					gpointer _tmp630_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp631_;
					ValaDataType* _tmp632_;
					ValaDataType* _tmp633_;
					ValaSourceReference* _tmp634_;
					ValaSourceReference* _tmp635_;
					ValaDataType* _tmp636_;
					_tmp625_ = _error_type_index;
					_error_type_index = _tmp625_ + 1;
					_tmp626_ = _error_type_index;
					_tmp627_ = _error_type_size;
					if (!(_tmp626_ < _tmp627_)) {
						break;
					}
					_tmp628_ = _error_type_list;
					_tmp629_ = _error_type_index;
					_tmp630_ = vala_list_get (_tmp628_, _tmp629_);
					error_type = (ValaDataType*) _tmp630_;
					may_throw = TRUE;
					_tmp631_ = error_type;
					_tmp632_ = vala_data_type_copy (_tmp631_);
					call_error_type = _tmp632_;
					_tmp633_ = call_error_type;
					_tmp634_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp635_ = _tmp634_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp633_, _tmp635_);
					_tmp636_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp636_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
		}
		_tmp637_ = m;
		_tmp638_ = vala_method_get_returns_floating_reference (_tmp637_);
		_tmp639_ = _tmp638_;
		if (_tmp639_) {
			ValaDataType* _tmp640_;
			ValaDataType* _tmp641_;
			_tmp640_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp641_ = _tmp640_;
			vala_data_type_set_floating_reference (_tmp641_, TRUE);
		}
		_tmp642_ = m;
		_tmp643_ = vala_method_get_returns_modified_pointer (_tmp642_);
		_tmp644_ = _tmp643_;
		if (_tmp644_) {
			ValaExpression* _tmp645_;
			ValaExpression* _tmp646_;
			ValaExpression* _tmp647_;
			ValaExpression* _tmp648_;
			_tmp645_ = vala_method_call_get_call (self);
			_tmp646_ = _tmp645_;
			_tmp647_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp646_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp648_ = _tmp647_;
			vala_expression_set_lvalue (_tmp648_, TRUE);
		}
		_tmp649_ = m;
		_tmp650_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp649_);
		_tmp651_ = _tmp650_;
		_tmp652_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp651_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp651_) : NULL);
		dynamic_sig = _tmp652_;
		_tmp654_ = dynamic_sig;
		if (_tmp654_ != NULL) {
			ValaDynamicSignal* _tmp655_;
			ValaExpression* _tmp656_;
			ValaExpression* _tmp657_;
			_tmp655_ = dynamic_sig;
			_tmp656_ = vala_dynamic_signal_get_handler (_tmp655_);
			_tmp657_ = _tmp656_;
			_tmp653_ = _tmp657_ != NULL;
		} else {
			_tmp653_ = FALSE;
		}
		if (_tmp653_) {
			ValaDynamicSignal* _tmp658_;
			ValaDynamicSignal* _tmp659_;
			ValaExpression* _tmp660_;
			ValaExpression* _tmp661_;
			ValaDataType* _tmp662_;
			ValaDataType* _tmp663_;
			ValaDataType* _tmp664_;
			ValaDataType* _tmp665_;
			ValaDataType* _tmp666_;
			ValaDataType* _tmp667_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp688_;
			ValaExpression* _tmp689_;
			ValaExpression* _tmp690_;
			ValaDynamicSignal* _tmp691_;
			ValaDynamicSignal* _tmp692_;
			ValaSymbol* _tmp693_;
			ValaSymbol* _tmp694_;
			ValaObjectType* _tmp695_;
			ValaObjectType* _tmp696_;
			ValaDelegate* _tmp697_;
			ValaDelegate* _tmp698_;
			ValaDelegateType* _tmp699_;
			ValaDelegateType* _tmp700_;
			_tmp658_ = dynamic_sig;
			_tmp659_ = dynamic_sig;
			_tmp660_ = vala_dynamic_signal_get_handler (_tmp659_);
			_tmp661_ = _tmp660_;
			_tmp662_ = vala_expression_get_value_type (_tmp661_);
			_tmp663_ = _tmp662_;
			_tmp664_ = vala_data_type_get_return_type (_tmp663_);
			_tmp665_ = _tmp664_;
			_tmp666_ = vala_data_type_copy (_tmp665_);
			_tmp667_ = _tmp666_;
			vala_callable_set_return_type ((ValaCallable*) _tmp658_, _tmp667_);
			_vala_code_node_unref0 (_tmp667_);
			_vala_code_node_unref0 (_tmp665_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp668_;
				ValaExpression* _tmp669_;
				ValaExpression* _tmp670_;
				ValaDataType* _tmp671_;
				ValaDataType* _tmp672_;
				ValaList* _tmp673_;
				gint _param_size = 0;
				ValaList* _tmp674_;
				gint _tmp675_;
				gint _tmp676_;
				gint _param_index = 0;
				_tmp668_ = dynamic_sig;
				_tmp669_ = vala_dynamic_signal_get_handler (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp671_ = vala_expression_get_value_type (_tmp670_);
				_tmp672_ = _tmp671_;
				_tmp673_ = vala_data_type_get_parameters (_tmp672_);
				_param_list = _tmp673_;
				_tmp674_ = _param_list;
				_tmp675_ = vala_collection_get_size ((ValaCollection*) _tmp674_);
				_tmp676_ = _tmp675_;
				_param_size = _tmp676_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp677_;
					gint _tmp678_;
					gint _tmp679_;
					ValaParameter* param = NULL;
					ValaList* _tmp680_;
					gint _tmp681_;
					gpointer _tmp682_;
					gboolean _tmp683_;
					_tmp677_ = _param_index;
					_param_index = _tmp677_ + 1;
					_tmp678_ = _param_index;
					_tmp679_ = _param_size;
					if (!(_tmp678_ < _tmp679_)) {
						break;
					}
					_tmp680_ = _param_list;
					_tmp681_ = _param_index;
					_tmp682_ = vala_list_get (_tmp680_, _tmp681_);
					param = (ValaParameter*) _tmp682_;
					_tmp683_ = first;
					if (_tmp683_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp684_;
						ValaParameter* _tmp685_;
						ValaParameter* _tmp686_;
						ValaParameter* _tmp687_;
						_tmp684_ = dynamic_sig;
						_tmp685_ = param;
						_tmp686_ = vala_parameter_copy (_tmp685_);
						_tmp687_ = _tmp686_;
						vala_callable_add_parameter ((ValaCallable*) _tmp684_, _tmp687_);
						_vala_code_node_unref0 (_tmp687_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp688_ = dynamic_sig;
			_tmp689_ = vala_dynamic_signal_get_handler (_tmp688_);
			_tmp690_ = _tmp689_;
			_tmp691_ = dynamic_sig;
			_tmp692_ = dynamic_sig;
			_tmp693_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp692_);
			_tmp694_ = _tmp693_;
			_tmp695_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp694_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp696_ = _tmp695_;
			_tmp697_ = vala_signal_get_delegate ((ValaSignal*) _tmp691_, (ValaDataType*) _tmp696_, (ValaCodeNode*) self);
			_tmp698_ = _tmp697_;
			_tmp699_ = vala_delegate_type_new (_tmp698_);
			_tmp700_ = _tmp699_;
			vala_expression_set_target_type (_tmp690_, (ValaDataType*) _tmp700_);
			_vala_code_node_unref0 (_tmp700_);
			_vala_code_node_unref0 (_tmp698_);
			_vala_code_node_unref0 (_tmp696_);
		}
		_tmp702_ = m;
		if (_tmp702_ != NULL) {
			ValaMethod* _tmp703_;
			ValaList* _tmp704_;
			ValaList* _tmp705_;
			gint _tmp706_;
			gint _tmp707_;
			_tmp703_ = m;
			_tmp704_ = vala_method_get_type_parameters (_tmp703_);
			_tmp705_ = _tmp704_;
			_tmp706_ = vala_collection_get_size ((ValaCollection*) _tmp705_);
			_tmp707_ = _tmp706_;
			_tmp701_ = _tmp707_ > 0;
			_vala_iterable_unref0 (_tmp705_);
		} else {
			_tmp701_ = FALSE;
		}
		if (_tmp701_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp708_;
			ValaExpression* _tmp709_;
			ValaMemberAccess* _tmp710_;
			ValaMemberAccess* _tmp711_;
			ValaList* _tmp712_;
			ValaList* _tmp713_;
			gint _tmp714_;
			gint _tmp715_;
			gboolean _tmp716_;
			_tmp708_ = vala_method_call_get_call (self);
			_tmp709_ = _tmp708_;
			_tmp710_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp709_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp710_;
			_tmp711_ = ma;
			_tmp712_ = vala_member_access_get_type_arguments (_tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_collection_get_size ((ValaCollection*) _tmp713_);
			_tmp715_ = _tmp714_;
			_tmp716_ = _tmp715_ == 0;
			_vala_iterable_unref0 (_tmp713_);
			if (_tmp716_) {
				ValaList* _tmp790_;
				ValaIterator* _tmp791_;
				ValaDataType* _tmp821_;
				ValaDataType* _tmp822_;
				ValaDataType* _tmp823_;
				ValaList* _tmp824_;
				ValaDataType* _tmp825_;
				ValaDataType* _tmp826_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp717_;
					ValaList* _tmp718_;
					gint _type_param_size = 0;
					ValaList* _tmp719_;
					gint _tmp720_;
					gint _tmp721_;
					gint _type_param_index = 0;
					_tmp717_ = m;
					_tmp718_ = vala_method_get_type_parameters (_tmp717_);
					_type_param_list = _tmp718_;
					_tmp719_ = _type_param_list;
					_tmp720_ = vala_collection_get_size ((ValaCollection*) _tmp719_);
					_tmp721_ = _tmp720_;
					_type_param_size = _tmp721_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp722_;
						gint _tmp723_;
						gint _tmp724_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp725_;
						gint _tmp726_;
						gpointer _tmp727_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp728_;
						ValaIterator* _tmp729_;
						gboolean _tmp768_ = FALSE;
						ValaDataType* _tmp769_;
						ValaDataType* _tmp779_;
						ValaMemberAccess* _tmp788_;
						ValaDataType* _tmp789_;
						_tmp722_ = _type_param_index;
						_type_param_index = _tmp722_ + 1;
						_tmp723_ = _type_param_index;
						_tmp724_ = _type_param_size;
						if (!(_tmp723_ < _tmp724_)) {
							break;
						}
						_tmp725_ = _type_param_list;
						_tmp726_ = _type_param_index;
						_tmp727_ = vala_list_get (_tmp725_, _tmp726_);
						type_param = (ValaTypeParameter*) _tmp727_;
						type_arg = NULL;
						_tmp728_ = args;
						_tmp729_ = vala_iterable_iterator ((ValaIterable*) _tmp728_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp729_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp730_;
							ValaList* _tmp731_;
							gint _param_size = 0;
							ValaList* _tmp732_;
							gint _tmp733_;
							gint _tmp734_;
							gint _param_index = 0;
							_tmp730_ = params;
							_tmp731_ = _vala_iterable_ref0 (_tmp730_);
							_param_list = _tmp731_;
							_tmp732_ = _param_list;
							_tmp733_ = vala_collection_get_size ((ValaCollection*) _tmp732_);
							_tmp734_ = _tmp733_;
							_param_size = _tmp734_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp735_;
								gint _tmp736_;
								gint _tmp737_;
								ValaParameter* param = NULL;
								ValaList* _tmp738_;
								gint _tmp739_;
								gpointer _tmp740_;
								gboolean _tmp741_ = FALSE;
								ValaParameter* _tmp742_;
								gboolean _tmp743_;
								gboolean _tmp744_;
								ValaIterator* _tmp748_;
								_tmp735_ = _param_index;
								_param_index = _tmp735_ + 1;
								_tmp736_ = _param_index;
								_tmp737_ = _param_size;
								if (!(_tmp736_ < _tmp737_)) {
									break;
								}
								_tmp738_ = _param_list;
								_tmp739_ = _param_index;
								_tmp740_ = vala_list_get (_tmp738_, _tmp739_);
								param = (ValaParameter*) _tmp740_;
								_tmp742_ = param;
								_tmp743_ = vala_parameter_get_ellipsis (_tmp742_);
								_tmp744_ = _tmp743_;
								if (_tmp744_) {
									_tmp741_ = TRUE;
								} else {
									ValaParameter* _tmp745_;
									gboolean _tmp746_;
									gboolean _tmp747_;
									_tmp745_ = param;
									_tmp746_ = vala_parameter_get_params_array (_tmp745_);
									_tmp747_ = _tmp746_;
									_tmp741_ = _tmp747_;
								}
								if (_tmp741_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp748_ = arg_it;
								if (vala_iterator_next (_tmp748_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp749_;
									gpointer _tmp750_;
									ValaParameter* _tmp751_;
									ValaDataType* _tmp752_;
									ValaDataType* _tmp753_;
									ValaTypeParameter* _tmp754_;
									ValaExpression* _tmp755_;
									ValaDataType* _tmp756_;
									ValaDataType* _tmp757_;
									ValaDataType* _tmp758_;
									ValaDataType* _tmp759_;
									ValaExpression* _tmp760_;
									ValaExpression* _tmp761_;
									ValaDataType* _tmp762_;
									ValaDataType* _tmp763_;
									ValaDataType* _tmp764_;
									ValaList* _tmp765_;
									ValaDataType* _tmp766_;
									ValaDataType* _tmp767_;
									_tmp749_ = arg_it;
									_tmp750_ = vala_iterator_get (_tmp749_);
									arg = (ValaExpression*) _tmp750_;
									_tmp751_ = param;
									_tmp752_ = vala_variable_get_variable_type ((ValaVariable*) _tmp751_);
									_tmp753_ = _tmp752_;
									_tmp754_ = type_param;
									_tmp755_ = arg;
									_tmp756_ = vala_expression_get_value_type (_tmp755_);
									_tmp757_ = _tmp756_;
									_tmp758_ = vala_data_type_infer_type_argument (_tmp753_, _tmp754_, _tmp757_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp758_;
									_tmp759_ = type_arg;
									if (_tmp759_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp760_ = arg;
									_tmp761_ = arg;
									_tmp762_ = vala_expression_get_formal_target_type (_tmp761_);
									_tmp763_ = _tmp762_;
									_tmp764_ = target_object_type;
									_tmp765_ = method_type_args;
									_tmp766_ = vala_data_type_get_actual_type (_tmp763_, _tmp764_, _tmp765_, (ValaCodeNode*) self);
									_tmp767_ = _tmp766_;
									vala_expression_set_target_type (_tmp760_, _tmp767_);
									_vala_code_node_unref0 (_tmp767_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp769_ = type_arg;
						if (_tmp769_ == NULL) {
							ValaDataType* _tmp770_;
							ValaDataType* _tmp771_;
							_tmp770_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp771_ = _tmp770_;
							_tmp768_ = _tmp771_ != NULL;
						} else {
							_tmp768_ = FALSE;
						}
						if (_tmp768_) {
							ValaMethod* _tmp772_;
							ValaDataType* _tmp773_;
							ValaDataType* _tmp774_;
							ValaTypeParameter* _tmp775_;
							ValaDataType* _tmp776_;
							ValaDataType* _tmp777_;
							ValaDataType* _tmp778_;
							_tmp772_ = m;
							_tmp773_ = vala_callable_get_return_type ((ValaCallable*) _tmp772_);
							_tmp774_ = _tmp773_;
							_tmp775_ = type_param;
							_tmp776_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp777_ = _tmp776_;
							_tmp778_ = vala_data_type_infer_type_argument (_tmp774_, _tmp775_, _tmp777_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp778_;
						}
						_tmp779_ = type_arg;
						if (_tmp779_ == NULL) {
							ValaMemberAccess* _tmp780_;
							ValaSourceReference* _tmp781_;
							ValaSourceReference* _tmp782_;
							ValaTypeParameter* _tmp783_;
							gchar* _tmp784_;
							gchar* _tmp785_;
							gchar* _tmp786_;
							gchar* _tmp787_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp780_ = ma;
							_tmp781_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp780_);
							_tmp782_ = _tmp781_;
							_tmp783_ = type_param;
							_tmp784_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp783_);
							_tmp785_ = _tmp784_;
							_tmp786_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp785_);
							_tmp787_ = _tmp786_;
							vala_report_error (_tmp782_, _tmp787_);
							_g_free0 (_tmp787_);
							_g_free0 (_tmp785_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp788_ = ma;
						_tmp789_ = type_arg;
						vala_member_access_add_type_argument (_tmp788_, _tmp789_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp790_ = args;
				_tmp791_ = vala_iterable_iterator ((ValaIterable*) _tmp790_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp791_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp792_;
					ValaList* _tmp793_;
					gint _param_size = 0;
					ValaList* _tmp794_;
					gint _tmp795_;
					gint _tmp796_;
					gint _param_index = 0;
					_tmp792_ = params;
					_tmp793_ = _vala_iterable_ref0 (_tmp792_);
					_param_list = _tmp793_;
					_tmp794_ = _param_list;
					_tmp795_ = vala_collection_get_size ((ValaCollection*) _tmp794_);
					_tmp796_ = _tmp795_;
					_param_size = _tmp796_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp797_;
						gint _tmp798_;
						gint _tmp799_;
						ValaParameter* param = NULL;
						ValaList* _tmp800_;
						gint _tmp801_;
						gpointer _tmp802_;
						gboolean _tmp803_ = FALSE;
						ValaParameter* _tmp804_;
						gboolean _tmp805_;
						gboolean _tmp806_;
						ValaIterator* _tmp810_;
						_tmp797_ = _param_index;
						_param_index = _tmp797_ + 1;
						_tmp798_ = _param_index;
						_tmp799_ = _param_size;
						if (!(_tmp798_ < _tmp799_)) {
							break;
						}
						_tmp800_ = _param_list;
						_tmp801_ = _param_index;
						_tmp802_ = vala_list_get (_tmp800_, _tmp801_);
						param = (ValaParameter*) _tmp802_;
						_tmp804_ = param;
						_tmp805_ = vala_parameter_get_ellipsis (_tmp804_);
						_tmp806_ = _tmp805_;
						if (_tmp806_) {
							_tmp803_ = TRUE;
						} else {
							ValaParameter* _tmp807_;
							gboolean _tmp808_;
							gboolean _tmp809_;
							_tmp807_ = param;
							_tmp808_ = vala_parameter_get_params_array (_tmp807_);
							_tmp809_ = _tmp808_;
							_tmp803_ = _tmp809_;
						}
						if (_tmp803_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp810_ = arg_it;
						if (vala_iterator_next (_tmp810_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp811_;
							gpointer _tmp812_;
							ValaExpression* _tmp813_;
							ValaExpression* _tmp814_;
							ValaDataType* _tmp815_;
							ValaDataType* _tmp816_;
							ValaDataType* _tmp817_;
							ValaList* _tmp818_;
							ValaDataType* _tmp819_;
							ValaDataType* _tmp820_;
							_tmp811_ = arg_it;
							_tmp812_ = vala_iterator_get (_tmp811_);
							arg = (ValaExpression*) _tmp812_;
							_tmp813_ = arg;
							_tmp814_ = arg;
							_tmp815_ = vala_expression_get_formal_target_type (_tmp814_);
							_tmp816_ = _tmp815_;
							_tmp817_ = target_object_type;
							_tmp818_ = method_type_args;
							_tmp819_ = vala_data_type_get_actual_type (_tmp816_, _tmp817_, _tmp818_, (ValaCodeNode*) self);
							_tmp820_ = _tmp819_;
							vala_expression_set_target_type (_tmp813_, _tmp820_);
							_vala_code_node_unref0 (_tmp820_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp821_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp822_ = _tmp821_;
				_tmp823_ = target_object_type;
				_tmp824_ = method_type_args;
				_tmp825_ = vala_data_type_get_actual_type (_tmp822_, _tmp823_, _tmp824_, (ValaCodeNode*) self);
				_tmp826_ = _tmp825_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp826_);
				_vala_code_node_unref0 (_tmp826_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp828_ = m;
		if (_tmp828_ != NULL) {
			ValaMethod* _tmp829_;
			gboolean _tmp830_;
			gboolean _tmp831_;
			_tmp829_ = m;
			_tmp830_ = vala_method_get_coroutine (_tmp829_);
			_tmp831_ = _tmp830_;
			_tmp827_ = _tmp831_;
		} else {
			_tmp827_ = FALSE;
		}
		if (_tmp827_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp832_;
			ValaExpression* _tmp833_;
			ValaMemberAccess* _tmp834_;
			ValaMemberAccess* _tmp835_;
			const gchar* _tmp836_;
			const gchar* _tmp837_;
			_tmp832_ = vala_method_call_get_call (self);
			_tmp833_ = _tmp832_;
			_tmp834_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp833_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp834_;
			_tmp835_ = ma;
			_tmp836_ = vala_member_access_get_member_name (_tmp835_);
			_tmp837_ = _tmp836_;
			if (g_strcmp0 (_tmp837_, "end") == 0) {
				ValaMethod* _tmp838_;
				ValaMethod* _tmp839_;
				ValaMethod* _tmp840_;
				ValaMethodType* _tmp841_;
				_tmp838_ = m;
				_tmp839_ = vala_method_get_end_method (_tmp838_);
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_method_type_new (_tmp840_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp841_;
				_vala_code_node_unref0 (_tmp840_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp842_;
		_tmp842_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp842_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp843_;
			ValaObjectTypeSymbol* _tmp844_;
			ValaObjectTypeSymbol* _tmp845_;
			ValaClass* _tmp846_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp847_;
			ValaCreationMethod* _tmp848_;
			ValaCreationMethod* _tmp849_;
			ValaCreationMethod* _tmp850_;
			_tmp843_ = mtype;
			_tmp844_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp843_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp845_ = _tmp844_;
			_tmp846_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp845_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp846_;
			_tmp847_ = cl;
			_tmp848_ = vala_class_get_default_construction_method (_tmp847_);
			_tmp849_ = _tmp848_;
			_tmp850_ = _vala_code_node_ref0 (_tmp849_);
			m = _tmp850_;
			{
				ValaList* _error_type_list = NULL;
				ValaCreationMethod* _tmp851_;
				ValaList* _tmp852_;
				gint _error_type_size = 0;
				ValaList* _tmp853_;
				gint _tmp854_;
				gint _tmp855_;
				gint _error_type_index = 0;
				_tmp851_ = m;
				_tmp852_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp851_);
				_error_type_list = _tmp852_;
				_tmp853_ = _error_type_list;
				_tmp854_ = vala_collection_get_size ((ValaCollection*) _tmp853_);
				_tmp855_ = _tmp854_;
				_error_type_size = _tmp855_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp856_;
					gint _tmp857_;
					gint _tmp858_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp859_;
					gint _tmp860_;
					gpointer _tmp861_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp862_;
					ValaDataType* _tmp863_;
					ValaDataType* _tmp864_;
					ValaSourceReference* _tmp865_;
					ValaSourceReference* _tmp866_;
					ValaDataType* _tmp867_;
					_tmp856_ = _error_type_index;
					_error_type_index = _tmp856_ + 1;
					_tmp857_ = _error_type_index;
					_tmp858_ = _error_type_size;
					if (!(_tmp857_ < _tmp858_)) {
						break;
					}
					_tmp859_ = _error_type_list;
					_tmp860_ = _error_type_index;
					_tmp861_ = vala_list_get (_tmp859_, _tmp860_);
					error_type = (ValaDataType*) _tmp861_;
					may_throw = TRUE;
					_tmp862_ = error_type;
					_tmp863_ = vala_data_type_copy (_tmp862_);
					call_error_type = _tmp863_;
					_tmp864_ = call_error_type;
					_tmp865_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp866_ = _tmp865_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp864_, _tmp866_);
					_tmp867_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp867_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp868_;
			_tmp868_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp868_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp869_;
				ValaDelegate* _tmp870_;
				ValaDelegate* _tmp871_;
				ValaDelegate* _tmp872_;
				_tmp869_ = mtype;
				_tmp870_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp869_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp871_ = _tmp870_;
				_tmp872_ = _vala_code_node_ref0 (_tmp871_);
				d = _tmp872_;
				{
					ValaList* _error_type_list = NULL;
					ValaDelegate* _tmp873_;
					ValaList* _tmp874_;
					gint _error_type_size = 0;
					ValaList* _tmp875_;
					gint _tmp876_;
					gint _tmp877_;
					gint _error_type_index = 0;
					_tmp873_ = d;
					_tmp874_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp873_);
					_error_type_list = _tmp874_;
					_tmp875_ = _error_type_list;
					_tmp876_ = vala_collection_get_size ((ValaCollection*) _tmp875_);
					_tmp877_ = _tmp876_;
					_error_type_size = _tmp877_;
					_error_type_index = -1;
					while (TRUE) {
						gint _tmp878_;
						gint _tmp879_;
						gint _tmp880_;
						ValaDataType* error_type = NULL;
						ValaList* _tmp881_;
						gint _tmp882_;
						gpointer _tmp883_;
						ValaDataType* call_error_type = NULL;
						ValaDataType* _tmp884_;
						ValaDataType* _tmp885_;
						ValaDataType* _tmp886_;
						ValaSourceReference* _tmp887_;
						ValaSourceReference* _tmp888_;
						ValaDataType* _tmp889_;
						_tmp878_ = _error_type_index;
						_error_type_index = _tmp878_ + 1;
						_tmp879_ = _error_type_index;
						_tmp880_ = _error_type_size;
						if (!(_tmp879_ < _tmp880_)) {
							break;
						}
						_tmp881_ = _error_type_list;
						_tmp882_ = _error_type_index;
						_tmp883_ = vala_list_get (_tmp881_, _tmp882_);
						error_type = (ValaDataType*) _tmp883_;
						may_throw = TRUE;
						_tmp884_ = error_type;
						_tmp885_ = vala_data_type_copy (_tmp884_);
						call_error_type = _tmp885_;
						_tmp886_ = call_error_type;
						_tmp887_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp888_ = _tmp887_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp886_, _tmp888_);
						_tmp889_ = call_error_type;
						vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp889_);
						_vala_code_node_unref0 (call_error_type);
						_vala_code_node_unref0 (error_type);
					}
					_vala_iterable_unref0 (_error_type_list);
				}
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp890_ = vala_code_context_get_analyzer (context);
	_tmp891_ = _tmp890_;
	_tmp892_ = mtype;
	_tmp893_ = params;
	_tmp894_ = vala_method_call_get_argument_list (self);
	_tmp895_ = _tmp894_;
	_tmp896_ = !vala_semantic_analyzer_check_arguments (_tmp891_, (ValaExpression*) self, _tmp892_, _tmp893_, _tmp895_);
	_vala_iterable_unref0 (_tmp895_);
	if (_tmp896_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp899_ = base_cm;
	if (_tmp899_ != NULL) {
		ValaCreationMethod* _tmp900_;
		_tmp900_ = base_cm;
		_tmp898_ = vala_method_is_variadic ((ValaMethod*) _tmp900_);
	} else {
		_tmp898_ = FALSE;
	}
	if (_tmp898_) {
		ValaList* _tmp901_;
		gint _tmp902_;
		gint _tmp903_;
		ValaCreationMethod* _tmp904_;
		ValaList* _tmp905_;
		ValaList* _tmp906_;
		gint _tmp907_;
		gint _tmp908_;
		_tmp901_ = args;
		_tmp902_ = vala_collection_get_size ((ValaCollection*) _tmp901_);
		_tmp903_ = _tmp902_;
		_tmp904_ = base_cm;
		_tmp905_ = vala_callable_get_parameters ((ValaCallable*) _tmp904_);
		_tmp906_ = _tmp905_;
		_tmp907_ = vala_collection_get_size ((ValaCollection*) _tmp906_);
		_tmp908_ = _tmp907_;
		_tmp897_ = _tmp903_ == _tmp908_;
		_vala_iterable_unref0 (_tmp906_);
	} else {
		_tmp897_ = FALSE;
	}
	if (_tmp897_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp909_;
		ValaList* _tmp910_;
		gint _tmp911_;
		gint _tmp912_;
		gpointer _tmp913_;
		gboolean _tmp914_ = FALSE;
		ValaExpression* _tmp915_;
		ValaDataType* _tmp916_;
		ValaDataType* _tmp917_;
		_tmp909_ = args;
		_tmp910_ = args;
		_tmp911_ = vala_collection_get_size ((ValaCollection*) _tmp910_);
		_tmp912_ = _tmp911_;
		_tmp913_ = vala_list_get (_tmp909_, _tmp912_ - 1);
		this_last_arg = (ValaExpression*) _tmp913_;
		_tmp915_ = this_last_arg;
		_tmp916_ = vala_expression_get_value_type (_tmp915_);
		_tmp917_ = _tmp916_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp917_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp918_;
			ValaDataType* _tmp919_;
			ValaDataType* _tmp920_;
			ValaTypeSymbol* _tmp921_;
			ValaTypeSymbol* _tmp922_;
			ValaSemanticAnalyzer* _tmp923_;
			ValaSemanticAnalyzer* _tmp924_;
			ValaDataType* _tmp925_;
			ValaTypeSymbol* _tmp926_;
			ValaTypeSymbol* _tmp927_;
			_tmp918_ = this_last_arg;
			_tmp919_ = vala_expression_get_value_type (_tmp918_);
			_tmp920_ = _tmp919_;
			_tmp921_ = vala_data_type_get_data_type (_tmp920_);
			_tmp922_ = _tmp921_;
			_tmp923_ = vala_code_context_get_analyzer (context);
			_tmp924_ = _tmp923_;
			_tmp925_ = _tmp924_->va_list_type;
			_tmp926_ = vala_data_type_get_data_type (_tmp925_);
			_tmp927_ = _tmp926_;
			_tmp914_ = _tmp922_ == _tmp927_;
		} else {
			_tmp914_ = FALSE;
		}
		if (_tmp914_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp928_ = may_throw;
	if (_tmp928_) {
		gboolean _tmp929_ = FALSE;
		ValaCodeNode* _tmp930_;
		ValaCodeNode* _tmp931_;
		_tmp930_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp931_ = _tmp930_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp931_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp929_ = TRUE;
		} else {
			ValaCodeNode* _tmp932_;
			ValaCodeNode* _tmp933_;
			_tmp932_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp933_ = _tmp932_;
			_tmp929_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp933_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp929_) {
		} else {
			ValaSemanticAnalyzer* _tmp934_;
			ValaSemanticAnalyzer* _tmp935_;
			ValaSymbol* _tmp936_;
			ValaSymbol* _tmp937_;
			_tmp934_ = vala_code_context_get_analyzer (context);
			_tmp935_ = _tmp934_;
			_tmp936_ = vala_semantic_analyzer_get_current_symbol (_tmp935_);
			_tmp937_ = _tmp936_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp937_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp938_;
				ValaSourceReference* _tmp939_;
				_tmp938_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp939_ = _tmp938_;
				vala_report_error (_tmp939_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp940_;
				ValaCodeNode* _tmp941_;
				ValaCodeNode* _tmp942_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp943_;
				ValaDataType* _tmp944_;
				ValaDataType* _tmp945_;
				ValaDataType* _tmp946_;
				gchar* _tmp947_;
				gchar* _tmp948_;
				ValaSourceReference* _tmp949_;
				ValaSourceReference* _tmp950_;
				ValaLocalVariable* _tmp951_;
				ValaLocalVariable* _tmp952_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp953_;
				ValaSourceReference* _tmp954_;
				ValaSourceReference* _tmp955_;
				ValaDeclarationStatement* _tmp956_;
				ValaSemanticAnalyzer* _tmp957_;
				ValaSemanticAnalyzer* _tmp958_;
				ValaBlock* _tmp959_;
				ValaDeclarationStatement* _tmp960_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp961_;
				ValaDataType* _tmp962_;
				ValaDataType* _tmp963_;
				ValaExpression* _tmp964_;
				ValaLocalVariable* _tmp965_;
				ValaDeclarationStatement* _tmp966_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp967_;
				ValaSemanticAnalyzer* _tmp968_;
				ValaSymbol* _tmp969_;
				ValaSymbol* _tmp970_;
				ValaBlock* _tmp971_;
				ValaBlock* _tmp972_;
				ValaLocalVariable* _tmp973_;
				ValaSemanticAnalyzer* _tmp974_;
				ValaSemanticAnalyzer* _tmp975_;
				ValaBlock* _tmp976_;
				ValaLocalVariable* _tmp977_;
				ValaCodeNode* _tmp978_;
				ValaExpression* _tmp979_;
				ValaExpression* _tmp980_;
				_tmp940_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp941_ = _tmp940_;
				_tmp942_ = _vala_code_node_ref0 (_tmp941_);
				old_parent_node = _tmp942_;
				_tmp943_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp944_ = _tmp943_;
				_tmp945_ = vala_data_type_copy (_tmp944_);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_code_node_get_temp_name ();
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp950_ = _tmp949_;
				_tmp951_ = vala_local_variable_new (_tmp946_, _tmp948_, NULL, _tmp950_);
				_tmp952_ = _tmp951_;
				_g_free0 (_tmp948_);
				_vala_code_node_unref0 (_tmp946_);
				local = _tmp952_;
				_tmp953_ = local;
				_tmp954_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp955_ = _tmp954_;
				_tmp956_ = vala_declaration_statement_new ((ValaSymbol*) _tmp953_, _tmp955_);
				decl = _tmp956_;
				_tmp957_ = vala_code_context_get_analyzer (context);
				_tmp958_ = _tmp957_;
				_tmp959_ = _tmp958_->insert_block;
				_tmp960_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp959_, (ValaStatement*) _tmp960_);
				_tmp961_ = local;
				_tmp962_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp963_ = _tmp962_;
				_tmp964_ = vala_semantic_analyzer_create_temp_access (_tmp961_, _tmp963_);
				temp_access = _tmp964_;
				_tmp965_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp965_, (ValaExpression*) self);
				_tmp966_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp966_, context);
				_tmp967_ = vala_code_context_get_analyzer (context);
				_tmp968_ = _tmp967_;
				_tmp969_ = vala_semantic_analyzer_get_current_symbol (_tmp968_);
				_tmp970_ = _tmp969_;
				_tmp971_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp970_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp971_;
				_tmp972_ = block;
				_tmp973_ = local;
				vala_block_remove_local_variable (_tmp972_, _tmp973_);
				_tmp974_ = vala_code_context_get_analyzer (context);
				_tmp975_ = _tmp974_;
				_tmp976_ = _tmp975_->insert_block;
				_tmp977_ = local;
				vala_block_add_local_variable (_tmp976_, _tmp977_);
				_tmp978_ = old_parent_node;
				_tmp979_ = temp_access;
				vala_code_node_replace_expression (_tmp978_, (ValaExpression*) self, _tmp979_);
				_tmp980_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp980_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp981_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp982_ = _tmp981_;
	result = !_tmp982_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}


static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaExpression* expr = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaExpression* _tmp31_;
			_tmp25_ = _expr_index;
			_expr_index = _tmp25_ + 1;
			_tmp26_ = _expr_index;
			_tmp27_ = _expr_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _expr_list;
			_tmp29_ = _expr_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			expr = (ValaExpression*) _tmp30_;
			_tmp31_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp31_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}


static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		_tmp10_ = format_arg;
		if (_tmp10_ >= 0) {
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp11_ = format_arg;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp9_ = _tmp11_ < _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaStringLiteral* _tmp19_;
			ValaStringLiteral* _tmp20_;
			_tmp15_ = self->priv->argument_list;
			_tmp16_ = format_arg;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_tmp19_ = vala_string_literal_get_format_literal (_tmp18_);
			_tmp20_ = _tmp19_;
			_vala_code_node_unref0 (_tmp18_);
			result = _tmp20_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}


ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_assert;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}


gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_constructv_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}


gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}


static void
vala_method_call_class_init (ValaMethodCallClass * klass)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodCallPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_call_real_get_used_variables;
}


static void
vala_method_call_instance_init (ValaMethodCall * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_CALL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}


static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}



