/* valalambdaexpression.c generated by valac, the Vala compiler
 * generated from valalambdaexpression.vala, do not modify */

/* valalambdaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_LAMBDA_EXPRESSION_0_PROPERTY,
	VALA_LAMBDA_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* vala_lambda_expression_properties[VALA_LAMBDA_EXPRESSION_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaLambdaExpressionPrivate {
	ValaExpression* _expression_body;
	ValaBlock* _statement_body;
	ValaMethod* _method;
	ValaList* parameters;
};


static gpointer vala_lambda_expression_parent_class = NULL;

#define VALA_LAMBDA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionPrivate))
static void vala_lambda_expression_real_accept (ValaCodeNode* base, 
                                         ValaCodeVisitor* visitor);
static void vala_lambda_expression_real_accept_children (ValaCodeNode* base, 
                                                  ValaCodeVisitor* visitor);
static gboolean vala_lambda_expression_real_is_pure (ValaExpression* base);
static gchar* vala_lambda_expression_get_lambda_name (ValaLambdaExpression* self, 
                                               ValaCodeContext* context);
static gboolean vala_lambda_expression_real_check (ValaCodeNode* base, 
                                            ValaCodeContext* context);
static void vala_lambda_expression_real_emit (ValaCodeNode* base, 
                                       ValaCodeGenerator* codegen);
static void vala_lambda_expression_real_get_used_variables (ValaCodeNode* base, 
                                                     ValaCollection* collection);
static void vala_lambda_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new lambda expression.
 *
 * @param expression_body  expression body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct (GType object_type, 
                                  ValaExpression* expression_body, 
                                  ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (expression_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_lambda_expression_set_expression_body (self, expression_body);
	return self;
}


ValaLambdaExpression*
vala_lambda_expression_new (ValaExpression* expression_body, 
                            ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct (VALA_TYPE_LAMBDA_EXPRESSION, expression_body, source_reference);
}


/**
 * Creates a new lambda expression with statement body.
 *
 * @param statement_body   statement body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct_with_statement_body (GType object_type, 
                                                      ValaBlock* statement_body, 
                                                      ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (statement_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_lambda_expression_set_statement_body (self, statement_body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaLambdaExpression*
vala_lambda_expression_new_with_statement_body (ValaBlock* statement_body, 
                                                ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct_with_statement_body (VALA_TYPE_LAMBDA_EXPRESSION, statement_body, source_reference);
}


/**
 * Appends implicitly typed parameter.
 *
 * @param param parameter name
 */
void
vala_lambda_expression_add_parameter (ValaLambdaExpression* self, 
                                      ValaParameter* param)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
}


/**
 * Returns copy of parameter list.
 *
 * @return parameter list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_lambda_expression_get_parameters (ValaLambdaExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_lambda_expression_real_accept (ValaCodeNode* base, 
                                    ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_lambda_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_lambda_expression_real_accept_children (ValaCodeNode* base, 
                                             ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_method;
	if (_tmp0_ == NULL) {
		ValaExpression* _tmp1_;
		_tmp1_ = self->priv->_expression_body;
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = self->priv->_expression_body;
			vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
			_tmp3_ = self->priv->_expression_body;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp3_);
		} else {
			ValaBlock* _tmp4_;
			_tmp4_ = self->priv->_statement_body;
			if (_tmp4_ != NULL) {
				ValaBlock* _tmp5_;
				_tmp5_ = self->priv->_statement_body;
				vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
			}
		}
	} else {
		ValaMethod* _tmp6_;
		_tmp6_ = self->priv->_method;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
	}
}


static gboolean
vala_lambda_expression_real_is_pure (ValaExpression* base)
{
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	result = FALSE;
	return result;
}


static gchar*
vala_lambda_expression_get_lambda_name (ValaLambdaExpression* self, 
                                        ValaCodeContext* context)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ValaSemanticAnalyzer* _tmp0_;
	ValaSemanticAnalyzer* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = vala_code_context_get_analyzer (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->next_lambda_id;
	_tmp3_ = g_strdup_printf ("_lambda%d_", _tmp2_);
	_result_ = _tmp3_;
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->next_lambda_id;
	_tmp5_->next_lambda_id = _tmp6_ + 1;
	result = _result_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_lambda_expression_real_check (ValaCodeNode* base, 
                                   ValaCodeContext* context)
{
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDelegate* cb = NULL;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDelegate* _tmp20_;
	ValaDelegate* _tmp21_;
	ValaDelegate* _tmp22_;
	ValaDataType* return_type = NULL;
	ValaDelegate* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaDataType* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaMethod* _tmp34_;
	ValaMethod* _tmp35_;
	ValaMethod* _tmp36_;
	ValaMethod* _tmp37_;
	ValaVersionAttribute* _tmp38_;
	ValaVersionAttribute* _tmp39_;
	ValaSourceReference* _tmp40_;
	ValaSourceReference* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaDelegate* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	ValaMethod* _tmp89_;
	ValaSemanticAnalyzer* _tmp90_;
	ValaSemanticAnalyzer* _tmp91_;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	ValaScope* _tmp94_;
	ValaScope* _tmp95_;
	ValaList* lambda_params = NULL;
	ValaList* _tmp96_;
	ValaIterator* lambda_param_it = NULL;
	ValaList* _tmp97_;
	ValaIterator* _tmp98_;
	gboolean _tmp99_ = FALSE;
	ValaDelegate* _tmp100_;
	ValaDataType* _tmp101_;
	ValaDataType* _tmp102_;
	ValaIterator* _tmp158_;
	ValaExpression* _tmp176_;
	ValaMethod* _tmp207_;
	ValaBlock* _tmp208_;
	ValaBlock* _tmp209_;
	ValaMethod* _tmp210_;
	ValaScope* _tmp211_;
	ValaScope* _tmp212_;
	ValaMethod* m = NULL;
	ValaSemanticAnalyzer* _tmp213_;
	ValaSemanticAnalyzer* _tmp214_;
	ValaSemanticAnalyzer* _tmp215_;
	ValaSemanticAnalyzer* _tmp216_;
	ValaSymbol* _tmp217_;
	ValaSymbol* _tmp218_;
	ValaMethod* _tmp219_;
	ValaMethod* _tmp220_;
	ValaMethod* _tmp245_;
	ValaMethod* _tmp246_;
	ValaMethod* _tmp247_;
	ValaMethodType* _tmp248_;
	ValaMethodType* _tmp249_;
	ValaDataType* _tmp250_;
	ValaDataType* _tmp251_;
	ValaDataType* _tmp252_;
	ValaDataType* _tmp253_;
	gboolean _tmp254_;
	gboolean _tmp255_;
	gboolean _tmp256_;
	gboolean _tmp257_;
	self = (ValaLambdaExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Cannot convert lambda expression to `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp9_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "lambda expression not allowed in this context");
		}
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_DELEGATE, ValaDelegate));
	cb = _tmp22_;
	_tmp23_ = cb;
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_data_type_get_actual_type (_tmp25_, _tmp27_, NULL, (ValaCodeNode*) self);
	return_type = _tmp28_;
	_tmp29_ = vala_lambda_expression_get_lambda_name (self, context);
	_tmp30_ = _tmp29_;
	_tmp31_ = return_type;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_method_new (_tmp30_, _tmp31_, _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	vala_lambda_expression_set_method (self, _tmp35_);
	_vala_code_node_unref0 (_tmp35_);
	_g_free0 (_tmp30_);
	_tmp36_ = self->priv->_method;
	vala_symbol_set_used ((ValaSymbol*) _tmp36_, TRUE);
	_tmp37_ = self->priv->_method;
	_tmp38_ = vala_symbol_get_version ((ValaSymbol*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp41_ = _tmp40_;
	vala_version_attribute_check (_tmp39_, _tmp41_);
	_tmp43_ = cb;
	_tmp44_ = vala_delegate_get_has_target (_tmp43_);
	_tmp45_ = _tmp44_;
	if (!_tmp45_) {
		_tmp42_ = TRUE;
	} else {
		ValaSemanticAnalyzer* _tmp46_;
		ValaSemanticAnalyzer* _tmp47_;
		_tmp46_ = vala_code_context_get_analyzer (context);
		_tmp47_ = _tmp46_;
		_tmp42_ = !vala_semantic_analyzer_is_in_instance_method (_tmp47_);
	}
	if (_tmp42_) {
		ValaMethod* _tmp48_;
		_tmp48_ = self->priv->_method;
		vala_method_set_binding (_tmp48_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaSymbol* sym = NULL;
		ValaSemanticAnalyzer* _tmp49_;
		ValaSemanticAnalyzer* _tmp50_;
		ValaSymbol* _tmp51_;
		ValaSymbol* _tmp52_;
		ValaSymbol* _tmp53_;
		_tmp49_ = vala_code_context_get_analyzer (context);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_semantic_analyzer_get_current_symbol (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _vala_code_node_ref0 (_tmp52_);
		sym = _tmp53_;
		while (TRUE) {
			ValaMethod* _tmp54_;
			ValaParameter* _tmp55_;
			ValaParameter* _tmp56_;
			ValaSymbol* _tmp57_;
			ValaSymbol* _tmp85_;
			ValaSymbol* _tmp86_;
			ValaSymbol* _tmp87_;
			ValaSymbol* _tmp88_;
			_tmp54_ = self->priv->_method;
			_tmp55_ = vala_method_get_this_parameter (_tmp54_);
			_tmp56_ = _tmp55_;
			if (!(_tmp56_ == NULL)) {
				break;
			}
			_tmp57_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp58_;
				ValaProperty* _tmp59_;
				ValaMethod* _tmp60_;
				ValaProperty* _tmp61_;
				ValaParameter* _tmp62_;
				ValaParameter* _tmp63_;
				_tmp58_ = sym;
				_tmp59_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp59_;
				_tmp60_ = self->priv->_method;
				_tmp61_ = prop;
				_tmp62_ = vala_property_get_this_parameter (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_method_set_this_parameter (_tmp60_, _tmp63_);
				_vala_code_node_unref0 (prop);
			} else {
				ValaSymbol* _tmp64_;
				_tmp64_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_CONSTRUCTOR)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp65_;
					ValaConstructor* _tmp66_;
					ValaMethod* _tmp67_;
					ValaConstructor* _tmp68_;
					ValaParameter* _tmp69_;
					ValaParameter* _tmp70_;
					_tmp65_ = sym;
					_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
					c = _tmp66_;
					_tmp67_ = self->priv->_method;
					_tmp68_ = c;
					_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
					_tmp70_ = _tmp69_;
					vala_method_set_this_parameter (_tmp67_, _tmp70_);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp71_;
					_tmp71_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_DESTRUCTOR)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp72_;
						ValaDestructor* _tmp73_;
						ValaMethod* _tmp74_;
						ValaDestructor* _tmp75_;
						ValaParameter* _tmp76_;
						ValaParameter* _tmp77_;
						_tmp72_ = sym;
						_tmp73_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
						d = _tmp73_;
						_tmp74_ = self->priv->_method;
						_tmp75_ = d;
						_tmp76_ = vala_destructor_get_this_parameter (_tmp75_);
						_tmp77_ = _tmp76_;
						vala_method_set_this_parameter (_tmp74_, _tmp77_);
						_vala_code_node_unref0 (d);
					} else {
						ValaSymbol* _tmp78_;
						_tmp78_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_METHOD)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp79_;
							ValaMethod* _tmp80_;
							ValaMethod* _tmp81_;
							ValaMethod* _tmp82_;
							ValaParameter* _tmp83_;
							ValaParameter* _tmp84_;
							_tmp79_ = sym;
							_tmp80_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp80_;
							_tmp81_ = self->priv->_method;
							_tmp82_ = m;
							_tmp83_ = vala_method_get_this_parameter (_tmp82_);
							_tmp84_ = _tmp83_;
							vala_method_set_this_parameter (_tmp81_, _tmp84_);
							_vala_code_node_unref0 (m);
						}
					}
				}
			}
			_tmp85_ = sym;
			_tmp86_ = vala_symbol_get_parent_symbol (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = _vala_code_node_ref0 (_tmp87_);
			_vala_code_node_unref0 (sym);
			sym = _tmp88_;
		}
		_vala_code_node_unref0 (sym);
	}
	_tmp89_ = self->priv->_method;
	_tmp90_ = vala_code_context_get_analyzer (context);
	_tmp91_ = _tmp90_;
	_tmp92_ = vala_semantic_analyzer_get_current_symbol (_tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_symbol_get_scope (_tmp93_);
	_tmp95_ = _tmp94_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp89_, _tmp95_);
	_tmp96_ = vala_lambda_expression_get_parameters (self);
	lambda_params = _tmp96_;
	_tmp97_ = lambda_params;
	_tmp98_ = vala_iterable_iterator ((ValaIterable*) _tmp97_);
	lambda_param_it = _tmp98_;
	_tmp100_ = cb;
	_tmp101_ = vala_delegate_get_sender_type (_tmp100_);
	_tmp102_ = _tmp101_;
	if (_tmp102_ != NULL) {
		ValaList* _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		ValaDelegate* _tmp106_;
		ValaList* _tmp107_;
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		_tmp103_ = lambda_params;
		_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = cb;
		_tmp107_ = vala_callable_get_parameters ((ValaCallable*) _tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp99_ = _tmp105_ == (_tmp110_ + 1);
		_vala_iterable_unref0 (_tmp108_);
	} else {
		_tmp99_ = FALSE;
	}
	if (_tmp99_) {
		ValaIterator* _tmp111_;
		ValaParameter* lambda_param = NULL;
		ValaIterator* _tmp112_;
		gpointer _tmp113_;
		ValaParameter* _tmp114_;
		ValaDelegate* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		ValaMethod* _tmp118_;
		ValaParameter* _tmp119_;
		_tmp111_ = lambda_param_it;
		vala_iterator_next (_tmp111_);
		_tmp112_ = lambda_param_it;
		_tmp113_ = vala_iterator_get (_tmp112_);
		lambda_param = (ValaParameter*) _tmp113_;
		_tmp114_ = lambda_param;
		_tmp115_ = cb;
		_tmp116_ = vala_delegate_get_sender_type (_tmp115_);
		_tmp117_ = _tmp116_;
		vala_variable_set_variable_type ((ValaVariable*) _tmp114_, _tmp117_);
		_tmp118_ = self->priv->_method;
		_tmp119_ = lambda_param;
		vala_callable_add_parameter ((ValaCallable*) _tmp118_, _tmp119_);
		_vala_code_node_unref0 (lambda_param);
	}
	{
		ValaList* _cb_param_list = NULL;
		ValaDelegate* _tmp120_;
		ValaList* _tmp121_;
		gint _cb_param_size = 0;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _cb_param_index = 0;
		_tmp120_ = cb;
		_tmp121_ = vala_callable_get_parameters ((ValaCallable*) _tmp120_);
		_cb_param_list = _tmp121_;
		_tmp122_ = _cb_param_list;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		_cb_param_size = _tmp124_;
		_cb_param_index = -1;
		while (TRUE) {
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			ValaParameter* cb_param = NULL;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_;
			ValaIterator* _tmp131_;
			ValaParameter* lambda_param = NULL;
			ValaIterator* _tmp132_;
			gpointer _tmp133_;
			ValaParameter* _tmp134_;
			ValaParameterDirection _tmp135_;
			ValaParameterDirection _tmp136_;
			ValaParameter* _tmp137_;
			ValaParameterDirection _tmp138_;
			ValaParameterDirection _tmp139_;
			ValaParameter* _tmp148_;
			ValaParameter* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaMethod* _tmp156_;
			ValaParameter* _tmp157_;
			_tmp125_ = _cb_param_index;
			_cb_param_index = _tmp125_ + 1;
			_tmp126_ = _cb_param_index;
			_tmp127_ = _cb_param_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _cb_param_list;
			_tmp129_ = _cb_param_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			cb_param = (ValaParameter*) _tmp130_;
			_tmp131_ = lambda_param_it;
			if (!vala_iterator_next (_tmp131_)) {
				_vala_code_node_unref0 (cb_param);
				break;
			}
			_tmp132_ = lambda_param_it;
			_tmp133_ = vala_iterator_get (_tmp132_);
			lambda_param = (ValaParameter*) _tmp133_;
			_tmp134_ = lambda_param;
			_tmp135_ = vala_parameter_get_direction (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = cb_param;
			_tmp138_ = vala_parameter_get_direction (_tmp137_);
			_tmp139_ = _tmp138_;
			if (_tmp136_ != _tmp139_) {
				ValaParameter* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				ValaParameter* _tmp143_;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				gchar* _tmp146_;
				gchar* _tmp147_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp140_ = lambda_param;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = lambda_param;
				_tmp144_ = vala_symbol_get_name ((ValaSymbol*) _tmp143_);
				_tmp145_ = _tmp144_;
				_tmp146_ = g_strdup_printf ("direction of parameter `%s' is incompatible with the target delegate", _tmp145_);
				_tmp147_ = _tmp146_;
				vala_report_error (_tmp142_, _tmp147_);
				_g_free0 (_tmp147_);
			}
			_tmp148_ = lambda_param;
			_tmp149_ = cb_param;
			_tmp150_ = vala_variable_get_variable_type ((ValaVariable*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_get_actual_type (_tmp151_, _tmp153_, NULL, (ValaCodeNode*) self);
			_tmp155_ = _tmp154_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp148_, _tmp155_);
			_vala_code_node_unref0 (_tmp155_);
			_tmp156_ = self->priv->_method;
			_tmp157_ = lambda_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp156_, _tmp157_);
			_vala_code_node_unref0 (lambda_param);
			_vala_code_node_unref0 (cb_param);
		}
		_vala_iterable_unref0 (_cb_param_list);
	}
	_tmp158_ = lambda_param_it;
	if (vala_iterator_next (_tmp158_)) {
		ValaSourceReference* _tmp159_;
		ValaSourceReference* _tmp160_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp160_ = _tmp159_;
		vala_report_error (_tmp160_, "lambda expression: too many parameters");
		result = FALSE;
		_vala_iterator_unref0 (lambda_param_it);
		_vala_iterable_unref0 (lambda_params);
		_vala_code_node_unref0 (return_type);
		_vala_code_node_unref0 (cb);
		return result;
	}
	{
		ValaList* _error_type_list = NULL;
		ValaDelegate* _tmp161_;
		ValaList* _tmp162_;
		gint _error_type_size = 0;
		ValaList* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _error_type_index = 0;
		_tmp161_ = cb;
		_tmp162_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp161_);
		_error_type_list = _tmp162_;
		_tmp163_ = _error_type_list;
		_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
		_tmp165_ = _tmp164_;
		_error_type_size = _tmp165_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp166_;
			gint _tmp167_;
			gint _tmp168_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp169_;
			gint _tmp170_;
			gpointer _tmp171_;
			ValaMethod* _tmp172_;
			ValaDataType* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			_tmp166_ = _error_type_index;
			_error_type_index = _tmp166_ + 1;
			_tmp167_ = _error_type_index;
			_tmp168_ = _error_type_size;
			if (!(_tmp167_ < _tmp168_)) {
				break;
			}
			_tmp169_ = _error_type_list;
			_tmp170_ = _error_type_index;
			_tmp171_ = vala_list_get (_tmp169_, _tmp170_);
			error_type = (ValaDataType*) _tmp171_;
			_tmp172_ = self->priv->_method;
			_tmp173_ = error_type;
			_tmp174_ = vala_data_type_copy (_tmp173_);
			_tmp175_ = _tmp174_;
			vala_code_node_add_error_type ((ValaCodeNode*) _tmp172_, _tmp175_);
			_vala_code_node_unref0 (_tmp175_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp176_ = self->priv->_expression_body;
	if (_tmp176_ != NULL) {
		ValaBlock* block = NULL;
		ValaSourceReference* _tmp177_;
		ValaSourceReference* _tmp178_;
		ValaBlock* _tmp179_;
		ValaBlock* _tmp180_;
		ValaScope* _tmp181_;
		ValaScope* _tmp182_;
		ValaMethod* _tmp183_;
		ValaScope* _tmp184_;
		ValaScope* _tmp185_;
		ValaMethod* _tmp186_;
		ValaDataType* _tmp187_;
		ValaDataType* _tmp188_;
		ValaTypeSymbol* _tmp189_;
		ValaTypeSymbol* _tmp190_;
		ValaMethod* _tmp203_;
		ValaBlock* _tmp204_;
		_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_block_new (_tmp178_);
		block = _tmp179_;
		_tmp180_ = block;
		_tmp181_ = vala_symbol_get_scope ((ValaSymbol*) _tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = self->priv->_method;
		_tmp184_ = vala_symbol_get_scope ((ValaSymbol*) _tmp183_);
		_tmp185_ = _tmp184_;
		vala_scope_set_parent_scope (_tmp182_, _tmp185_);
		_tmp186_ = self->priv->_method;
		_tmp187_ = vala_callable_get_return_type ((ValaCallable*) _tmp186_);
		_tmp188_ = _tmp187_;
		_tmp189_ = vala_data_type_get_data_type (_tmp188_);
		_tmp190_ = _tmp189_;
		if (_tmp190_ != NULL) {
			ValaBlock* _tmp191_;
			ValaExpression* _tmp192_;
			ValaSourceReference* _tmp193_;
			ValaSourceReference* _tmp194_;
			ValaReturnStatement* _tmp195_;
			ValaReturnStatement* _tmp196_;
			_tmp191_ = block;
			_tmp192_ = self->priv->_expression_body;
			_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_return_statement_new (_tmp192_, _tmp194_);
			_tmp196_ = _tmp195_;
			vala_block_add_statement (_tmp191_, (ValaStatement*) _tmp196_);
			_vala_code_node_unref0 (_tmp196_);
		} else {
			ValaBlock* _tmp197_;
			ValaExpression* _tmp198_;
			ValaSourceReference* _tmp199_;
			ValaSourceReference* _tmp200_;
			ValaExpressionStatement* _tmp201_;
			ValaExpressionStatement* _tmp202_;
			_tmp197_ = block;
			_tmp198_ = self->priv->_expression_body;
			_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp200_ = _tmp199_;
			_tmp201_ = vala_expression_statement_new (_tmp198_, _tmp200_);
			_tmp202_ = _tmp201_;
			vala_block_add_statement (_tmp197_, (ValaStatement*) _tmp202_);
			_vala_code_node_unref0 (_tmp202_);
		}
		_tmp203_ = self->priv->_method;
		_tmp204_ = block;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp203_, _tmp204_);
		_vala_code_node_unref0 (block);
	} else {
		ValaMethod* _tmp205_;
		ValaBlock* _tmp206_;
		_tmp205_ = self->priv->_method;
		_tmp206_ = self->priv->_statement_body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp205_, _tmp206_);
	}
	_tmp207_ = self->priv->_method;
	_tmp208_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp207_);
	_tmp209_ = _tmp208_;
	_tmp210_ = self->priv->_method;
	_tmp211_ = vala_symbol_get_scope ((ValaSymbol*) _tmp210_);
	_tmp212_ = _tmp211_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp209_, _tmp212_);
	_tmp213_ = vala_code_context_get_analyzer (context);
	_tmp214_ = _tmp213_;
	_tmp215_ = vala_code_context_get_analyzer (context);
	_tmp216_ = _tmp215_;
	_tmp217_ = vala_semantic_analyzer_get_current_symbol (_tmp216_);
	_tmp218_ = _tmp217_;
	_tmp219_ = vala_semantic_analyzer_find_parent_method (_tmp214_, _tmp218_);
	m = _tmp219_;
	_tmp220_ = m;
	if (_tmp220_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaMethod* _tmp221_;
			ValaList* _tmp222_;
			gint _type_param_size = 0;
			ValaList* _tmp223_;
			gint _tmp224_;
			gint _tmp225_;
			gint _type_param_index = 0;
			_tmp221_ = m;
			_tmp222_ = vala_method_get_type_parameters (_tmp221_);
			_type_param_list = _tmp222_;
			_tmp223_ = _type_param_list;
			_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
			_tmp225_ = _tmp224_;
			_type_param_size = _tmp225_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp226_;
				gint _tmp227_;
				gint _tmp228_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp229_;
				gint _tmp230_;
				gpointer _tmp231_;
				ValaMethod* _tmp232_;
				ValaTypeParameter* _tmp233_;
				const gchar* _tmp234_;
				const gchar* _tmp235_;
				ValaTypeParameter* _tmp236_;
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaTypeParameter* _tmp239_;
				ValaTypeParameter* _tmp240_;
				ValaMethod* _tmp241_;
				ValaMethod* _tmp242_;
				ValaBlock* _tmp243_;
				ValaBlock* _tmp244_;
				_tmp226_ = _type_param_index;
				_type_param_index = _tmp226_ + 1;
				_tmp227_ = _type_param_index;
				_tmp228_ = _type_param_size;
				if (!(_tmp227_ < _tmp228_)) {
					break;
				}
				_tmp229_ = _type_param_list;
				_tmp230_ = _type_param_index;
				_tmp231_ = vala_list_get (_tmp229_, _tmp230_);
				type_param = (ValaTypeParameter*) _tmp231_;
				_tmp232_ = self->priv->_method;
				_tmp233_ = type_param;
				_tmp234_ = vala_symbol_get_name ((ValaSymbol*) _tmp233_);
				_tmp235_ = _tmp234_;
				_tmp236_ = type_param;
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp236_);
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_typeparameter_new (_tmp235_, _tmp238_);
				_tmp240_ = _tmp239_;
				vala_method_add_type_parameter (_tmp232_, _tmp240_);
				_vala_code_node_unref0 (_tmp240_);
				_tmp241_ = self->priv->_method;
				vala_method_set_closure (_tmp241_, TRUE);
				_tmp242_ = m;
				_tmp243_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp242_);
				_tmp244_ = _tmp243_;
				vala_block_set_captured (_tmp244_, TRUE);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
	}
	_tmp245_ = self->priv->_method;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp245_);
	_tmp246_ = self->priv->_method;
	vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
	_tmp247_ = self->priv->_method;
	_tmp248_ = vala_method_type_new (_tmp247_);
	_tmp249_ = _tmp248_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp249_);
	_vala_code_node_unref0 (_tmp249_);
	_tmp250_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp251_ = _tmp250_;
	_tmp252_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp253_ = _tmp252_;
	_tmp254_ = vala_data_type_get_value_owned (_tmp253_);
	_tmp255_ = _tmp254_;
	vala_data_type_set_value_owned (_tmp251_, _tmp255_);
	_tmp256_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp257_ = _tmp256_;
	result = !_tmp257_;
	_vala_code_node_unref0 (m);
	_vala_iterator_unref0 (lambda_param_it);
	_vala_iterable_unref0 (lambda_params);
	_vala_code_node_unref0 (return_type);
	_vala_code_node_unref0 (cb);
	return result;
}


static void
vala_lambda_expression_real_emit (ValaCodeNode* base, 
                                  ValaCodeGenerator* codegen)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_lambda_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_lambda_expression_real_get_used_variables (ValaCodeNode* base, 
                                                ValaCollection* collection)
{
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_method;
	_tmp1_ = vala_method_get_closure (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaMethod* _tmp3_;
		_tmp3_ = self->priv->_method;
		vala_method_get_captured_variables (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


ValaExpression*
vala_lambda_expression_get_expression_body (ValaLambdaExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression_body;
	result = _tmp0_;
	return result;
}


void
vala_lambda_expression_set_expression_body (ValaLambdaExpression* self, 
                                            ValaExpression* value)
{
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_expression_body);
	self->priv->_expression_body = _tmp0_;
}


ValaBlock*
vala_lambda_expression_get_statement_body (ValaLambdaExpression* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_statement_body;
	result = _tmp0_;
	return result;
}


void
vala_lambda_expression_set_statement_body (ValaLambdaExpression* self, 
                                           ValaBlock* value)
{
	ValaBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_statement_body);
	self->priv->_statement_body = _tmp0_;
}


ValaMethod*
vala_lambda_expression_get_method (ValaLambdaExpression* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}


void
vala_lambda_expression_set_method (ValaLambdaExpression* self, 
                                   ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_method);
	self->priv->_method = _tmp0_;
}


static void
vala_lambda_expression_class_init (ValaLambdaExpressionClass * klass)
{
	vala_lambda_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_lambda_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaLambdaExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_lambda_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_lambda_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_lambda_expression_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_lambda_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_lambda_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_lambda_expression_real_get_used_variables;
}


static void
vala_lambda_expression_instance_init (ValaLambdaExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_LAMBDA_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void
vala_lambda_expression_finalize (ValaCodeNode * obj)
{
	ValaLambdaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression);
	_vala_code_node_unref0 (self->priv->_expression_body);
	_vala_code_node_unref0 (self->priv->_statement_body);
	_vala_code_node_unref0 (self->priv->_method);
	_vala_iterable_unref0 (self->priv->parameters);
	VALA_CODE_NODE_CLASS (vala_lambda_expression_parent_class)->finalize (obj);
}


/**
 * Represents a lambda expression in the source code. Lambda expressions are
 * anonymous methods with implicitly typed parameters.
 */
GType
vala_lambda_expression_get_type (void)
{
	static volatile gsize vala_lambda_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_lambda_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLambdaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lambda_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLambdaExpression), 0, (GInstanceInitFunc) vala_lambda_expression_instance_init, NULL };
		GType vala_lambda_expression_type_id;
		vala_lambda_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLambdaExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_lambda_expression_type_id__volatile, vala_lambda_expression_type_id);
	}
	return vala_lambda_expression_type_id__volatile;
}



