// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!
#ifndef _GDKMM_EVENTS_H
#define _GDKMM_EVENTS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/refptr.h>
#include <gdkmm/event.h>
#include <gdkmm/enums.h>
#include <gdkmm/rectangle.h>
#include <gdkmm/types.h>
#include <gdkmm/window.h>

// All subclasses of Gdk::Event.
//
// Keeping the subclasses in a separate file makes it easier to avoid cyclic
// inclusions (where a.h includes b.h, and b.h includes a.h).
// One file per subclass would result in too many small files.

namespace Gdk
{
class Device;

/** Representing an event sequence.
 * Used to differentiate between multiple touches on multitouch touchscreens.
 * It's a hidden struct. You can test %EventSequence pointers for equality,
 * but you can't do much more with them.
 */
struct EventSequence;

/** Generated when a key is pressed or released.
 *
 * get_event_type() will return Gdk::Event::Type::KEY_PRESS or
 * Gdk::Event::Type::KEY_RELEASE.
 *
 * @newin{3,90}
 */
class EventKey : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventKey;
  using BaseObjectType = GdkEventKey;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventKey pointer.
   */
  EventKey();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventKey(GdkEventKey* gobject, bool make_a_copy = false);

  void swap(EventKey& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventKey* gobj() noexcept { return reinterpret_cast<GdkEventKey*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventKey* gobj() const noexcept { return reinterpret_cast<const GdkEventKey*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventKey* gobj_copy() const;

private:

  
public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;
  

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;
  

  /**
   * Returns the key that was pressed or released. See the <gdk/gdkkeysyms.h>
   * header file for a complete list of GDK key codes.
   */
  guint get_keyval() const;
  

  /**
   * Returns the raw code of the key that was pressed or released.
   */
  guint16 get_hardware_keycode() const;
  

  /** Gets the keyboard low-level scancode of a key event.
   * 
   * This is usually hardware_keycode. On Windows this is the high
   * word of WM_KEY{DOWN,UP} lParam which contains the scancode and
   * some extended flags.
   * 
   * @newin{3,22}
   * 
   * @return The associated keyboard scancode or 0.
   */

  int get_scancode() const;

  /**
   * Returns the keyboard group
   */
  guint8 get_group() const;

  /**
   * Returns @c true if the hardware keycode is mapped to a modifier key
   */
  bool get_is_modifier() const;

  // Belong to the base class:
  

};

/** Represents a mouse button press or release event.
 *
 * get_event_type() will return one of Gdk::Event::Type::BUTTON_PRESS,
 * Gdk::Event::Type::DOUBLE_BUTTON_PRESS, Gdk::Event::Type::TRIPLE_BUTTON_PRESS
 * or Gdk::Event::Type::BUTTON_RELEASE.
 *
 * Double and triple-clicks result in a sequence of events being received. For
 * double-clicks the order of events will be:
 *
 * @code
 * Gdk::Event::Type::BUTTON_PRESS
 * Gdk::Event::Type::BUTTON_RELEASE
 * Gdk::Event::Type::BUTTON_PRESS
 * Gdk::Event::Type::DOUBLE_BUTTON_PRESS
 * Gdk::Event::Type::BUTTON_RELEASE
 * @endcode
 *
 * Note that the first click is received just like a normal button press, while
 * the second click results in a Gdk::Event::Type::DOUBLE_BUTTON_PRESS being
 * received just after the Gdk::Event::Type::BUTTON_PRESS.
 *
 * Triple-clicks are very similar to double-clicks, except that
 * Gdk::Event::Type::TRIPLE_BUTTON_PRESS is inserted after the third click.
 * The order of the events is:
 *
 * @code
 * Gdk::Event::Type::BUTTON_PRESS
 * Gdk::Event::Type::BUTTON_RELEASE
 * Gdk::Event::Type::BUTTON_PRESS
 * Gdk::Event::Type::DOUBLE_BUTTON_PRESS
 * Gdk::Event::Type::BUTTON_RELEASE
 * Gdk::Event::Type::BUTTON_PRESS
 * Gdk::Event::Type::TRIPLE_BUTTON_PRESS
 * Gdk::Event::Type::BUTTON_RELEASE
 * @endcode
 *
 * For a double click to occur, the second button press must occur within 1/4 of
 * a second of the first. For a triple click to occur, the third button press
 * must also occur within 1/2 second of the first button press.
 *
 * @newin{3,90}
 */
class EventButton : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventButton;
  using BaseObjectType = GdkEventButton;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventButton pointer.
   */
  EventButton();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventButton(GdkEventButton* gobject, bool make_a_copy = false);

  void swap(EventButton& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventButton* gobj() noexcept { return reinterpret_cast<GdkEventButton*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventButton* gobj() const noexcept { return reinterpret_cast<const GdkEventButton*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventButton* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;
  

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the X coordinate of the pointer relative to the root screen.
   */
  double get_root_x() const;
  

  /**
   * Returns the Y coordinate of the pointer relative to the root screen.
   */
  double get_root_y() const;

  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */

  bool get_axis(Gdk::AxisUse axis_use, double& value) const;

  /**
   * Returns the number of the button which was pressed or released, numbered
   * from 1 to 5. Normally button 1 is the left mouse button, 2 is the middle
   * button, and 3 is the right button. On 2-button mice, the middle button can
   * often be simulated by pressing both mouse buttons together
   */
  guint get_button() const;
  

  /**
   * Returns the device where the event originated from.
   */
  Glib::RefPtr<Gdk::Device> get_device();
  Glib::RefPtr<const Gdk::Device> get_device() const;
  

  /** Extracts the click count from an event.
   * @return The click count (0..3).
   */
  guint get_click_count() const;
  

  /** This function returns whether a Gdk::EventButton should trigger a
   * context menu, according to platform conventions. The right mouse
   * button always triggers context menus. Additionally, if
   * Gdk::Keymap::get_modifier_mask() returns a non-0 mask for
   * Gdk::ModifierIntent::CONTEXT_MENU, then the left mouse button will
   * also trigger a context menu if this modifier is pressed.
   * 
   * This function should always be used instead of simply checking for
   * event->button == GDK_BUTTON_SECONDARY.
   * 
   * @newin{3,4}
   * 
   * @return <tt>true</tt> if the event should trigger a context menu.
   */

  bool shall_trigger_context_menu() const;


};

/** Generated when the mouse is scrolled.
 *
 * These events are from button presses for the buttons 4 to 7. Wheel mice are
 * usually configured to generate button press events for buttons 4 and 5 when
 * the wheel is turned.
 *
 * get_event_type() will return Gdk::Event::Type::SCROLL.
 *
 * Some GDK backends can also generate 'smooth' scroll events, which can be
 * recognized by the Gdk::ScrollDirection::SMOOTH scroll direction. For these,
 * scroll deltas can be obtained with get_delta_x() and get_delta_y().
 *
 * @newin{3,90}
 */
class EventScroll : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventScroll;
  using BaseObjectType = GdkEventScroll;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventScroll pointer.
   */
  EventScroll();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventScroll(GdkEventScroll* gobject, bool make_a_copy = false);

  void swap(EventScroll& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventScroll* gobj() noexcept { return reinterpret_cast<GdkEventScroll*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventScroll* gobj() const noexcept { return reinterpret_cast<const GdkEventScroll*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventScroll* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the X coordinate of the pointer relative to the root screen.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root screen.
   */
  double get_root_y() const;

  /**
   * Returns the scroll delta in the X axis. Meaningful only if get_direction()
   * returns Gdk::ScrollDirection::SMOOTH
   */
  double get_delta_x() const;
  

  /**
   * Returns the scroll delta in the Y axis. Meaningful only if get_direction()
   * returns Gdk::ScrollDirection::SMOOTH
   */
  double get_delta_y() const;

  /**
   * Returns the direction of the scroll.
   */
  ScrollDirection get_direction() const;
  

  /** Check whether a scroll event is a stop scroll event. Scroll sequences
   * with smooth scroll information may provide a stop scroll event once the
   * interaction with the device finishes, e.g. by lifting a finger. This
   * stop scroll event is the signal that a widget may trigger kinetic
   * scrolling based on the current velocity.
   * 
   * Stop scroll events always have a a delta of 0/0.
   * 
   * @newin{3,20}
   * 
   * @return <tt>true</tt> if the event is a scroll stop event.
   */

  bool is_scroll_stop_event() const;

  /**
   * Returns the device where the event originated from.
   */
  Glib::RefPtr<Gdk::Device> get_device();
  Glib::RefPtr<const Gdk::Device> get_device() const;


};

/** Generated when a mouse pointer is moved.
 *
 * get_event_type() will return Gdk::Event::Type::MOTION_NOTIFY.
 *
 * @newin{3,90}
 */
class EventMotion : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventMotion;
  using BaseObjectType = GdkEventMotion;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventMotion pointer.
   */
  EventMotion();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventMotion(GdkEventMotion* gobject, bool make_a_copy = false);

  void swap(EventMotion& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventMotion* gobj() noexcept { return reinterpret_cast<GdkEventMotion*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventMotion* gobj() const noexcept { return reinterpret_cast<const GdkEventMotion*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventMotion* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the X coordinate of the pointer relative to the root screen.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root screen.
   */
  double get_root_y() const;

  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */

  bool get_axis(Gdk::AxisUse axis_use, double& value) const;

 
  /**
   * Returns @c true if the event is motion hint.
   *
   * Motion hints are received only if Gdk::EventMask::POINTER_MOTION_HINT_MASK is set.
   * It is used to reduce the number of Gdk::Event::Type::MOTION_NOTIFY events received.
   * Normally a Gdk::Event::Type::MOTION_NOTIFY event is received each time the mouse
   * moves. However, if the application spends a lot of time processing the
   * event (updating the display, for example), it can lag behind the position
   * of the mouse. When using Gdk::EventMask::POINTER_MOTION_HINT_MASK, fewer
   * Gdk::Event::Type::MOTION_NOTIFY events will be sent, some of which are marked as a
   * hint. To receive more motion events after a motion hint event, the
   * application needs to ask for more, by calling request_motions().
   */
  bool get_is_hint() const;

  
  /** Request more motion notifies if @a event is a motion notify hint event.
   * 
   * This function should be used instead of gdk_window_get_pointer() to
   * request further motion notifies, because it also works for extension
   * events where motion notifies are provided for devices other than the
   * core pointer. Coordinate extraction, processing and requesting more
   * motion events from a Gdk::Event::Type::MOTION_NOTIFY event usually works like this:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{2,12}
   */
  void request_motions();

  /**
   * Returns the device where the event originated from.
   */
  Glib::RefPtr<Gdk::Device> get_device();
  Glib::RefPtr<const Gdk::Device> get_device() const;


};

/** Generated during an attached touchscreen is touched.
 *
 * get_event_type() will return one of Gdk::Event::Type::TOUCH_BEGIN,
 * Gdk::Event::Type::TOUCH_UPDATE, Gdk::Event::Type::TOUCH_END or
 * Gdk::Event::Type::TOUCH_CANCEL.
 *
 * Touch events are grouped into sequences by means of the sequence field, which
 * can also be obtained with get_event_sequence(). Each sequence
 * begins with a Gdk::Event::Type::TOUCH_BEGIN event, followed by any number of
 * Gdk::Event::Type::TOUCH_UPDATE events, and ends with a Gdk::Event::Type::TOUCH_END
 * (or Gdk::Event::Type::TOUCH_CANCEL) event. With multitouch devices, there may
 * be several active sequences at the same time.
 *
 * @newin{3,90}
 */
class EventTouch : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTouch;
  using BaseObjectType = GdkEventTouch;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventTouch pointer.
   */
  EventTouch();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventTouch(GdkEventTouch* gobject, bool make_a_copy = false);

  void swap(EventTouch& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventTouch* gobj() noexcept { return reinterpret_cast<GdkEventTouch*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventTouch* gobj() const noexcept { return reinterpret_cast<const GdkEventTouch*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventTouch* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the X coordinate of the pointer relative to the root screen.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root screen.
   */
  double get_root_y() const;

  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * 
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */

  bool get_axis(Gdk::AxisUse axis_use, double& value) const;

 
  /**
   * Returns the event sequence that the event belongs to
   */
  const Gdk::EventSequence* get_event_sequence() const;
  

  /**
   * Returns @c true if the event should be used for emulating pointer event
   */
  bool get_is_emulating_pointer() const;
  

  /**
   * Returns the device where the event originated from.
   */
  Glib::RefPtr<Gdk::Device> get_device();
  Glib::RefPtr<const Gdk::Device> get_device() const;


};

/** Generated when the mouse pointer leaves or enters the window.
 *
 * get_event_type() will return one of Gdk::Event::Type::LEAVE_NOTIFY or
 * Gdk::Event::Type::ENTER_NOTIFY.
 *
 * @newin{3,90}
 */
class EventCrossing : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventCrossing;
  using BaseObjectType = GdkEventCrossing;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventCrossing pointer.
   */
  EventCrossing();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventCrossing(GdkEventCrossing* gobject, bool make_a_copy = false);

  void swap(EventCrossing& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventCrossing* gobj() noexcept { return reinterpret_cast<GdkEventCrossing*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventCrossing* gobj() const noexcept { return reinterpret_cast<const GdkEventCrossing*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventCrossing* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the window that was entered or left
   */
  Glib::RefPtr<Gdk::Window> get_subwindow();
  Glib::RefPtr<const Gdk::Window> get_subwindow() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the X coordinate of the pointer relative to the root screen.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root screen.
   */
  double get_root_y() const;

  /*** Returns the crossing mode.
   * Gdk::CrossingMode::GTK_GRAB, Gdk::CrossingMode::GTK_UNGRAB, and
   * Gdk::CrossingMode::STATE_CHANGED are always synthesized, never native.
   */
  Gdk::CrossingMode get_mode() const;

  /**
   * Returns the kind of crossing that has been made
   */
  Gdk::NotifyType get_detail() const;

  /**
   * Returns @c true if the window was the focus window, @c false otherwise
   */
  bool get_focus() const;


};

/** Generated when all or part of a window becomes visible and needs to be
 * redrawn.
 *
 * get_event_type() will return one of Gdk::Event::Type::EXPOSE, Gdk::Event::Type::DAMAGE.
 *
 * @newin{3,90}
 */
class EventExpose : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventExpose;
  using BaseObjectType = GdkEventExpose;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventExpose pointer.
   */
  EventExpose();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventExpose(GdkEventExpose* gobject, bool make_a_copy = false);

  void swap(EventExpose& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventExpose* gobj() noexcept { return reinterpret_cast<GdkEventExpose*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventExpose* gobj() const noexcept { return reinterpret_cast<const GdkEventExpose*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventExpose* gobj_copy() const;

private:


public:

 
  /**
   * Returns the bounding box of the region to be redrawn
   */
  const Gdk::Rectangle& get_area() const;

 
  /**
   * Returns the region to be redrawn
   */
  ::Cairo::RefPtr<const ::Cairo::Region> get_region() const;

  /**
   * Returns the number of contiguous Gdk::Event::Type::EXPOSE events following this one.
   * The only use for this is "exposure compression", i.e. handling all contiguous
   * Gdk::Event::Type::EXPOSE events in one go, though GDK performs some exposure
   * compression so this is not normally needed.
   */
  int get_count() const;


};

// GdkEventVisibility is deprecated. It's not used in gtk+ 4.

/** Generated when the keyboard focus changes.
 *
 * get_event_type() will return Gdk::Event::Type::FOCUS_CHANGE.
 *
 * @newin{3,90}
 */
class EventFocus : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventFocus;
  using BaseObjectType = GdkEventFocus;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventFocus pointer.
   */
  EventFocus();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventFocus(GdkEventFocus* gobject, bool make_a_copy = false);

  void swap(EventFocus& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventFocus* gobj() noexcept { return reinterpret_cast<GdkEventFocus*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventFocus* gobj() const noexcept { return reinterpret_cast<const GdkEventFocus*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventFocus* gobj_copy() const;

private:


public:

  /**
   * @c true if the window gained focus, @c false if lost
   */
  bool get_focus() const;


};

/** Generated when the position or size of a window changes.
 *
 * get_event_type() will return Gdk::Event::Type::CONFIGURE.
 *
 * @newin{3,90}
 */
class EventConfigure : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventConfigure;
  using BaseObjectType = GdkEventConfigure;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventConfigure pointer.
   */
  EventConfigure();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventConfigure(GdkEventConfigure* gobject, bool make_a_copy = false);

  void swap(EventConfigure& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventConfigure* gobj() noexcept { return reinterpret_cast<GdkEventConfigure*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventConfigure* gobj() const noexcept { return reinterpret_cast<const GdkEventConfigure*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventConfigure* gobj_copy() const;

private:


public:

  /**
   * Returns the new X coordinate of the window, relative to its parent
   */
  int get_x() const;

  /**
   * Returns the new Y coordinate of the window, relative to its parent
   */
  int get_y() const;

  /**
   * Returns the new width of the window
   */
  int get_width() const;

  /**
   * Returns the new height of the window
   */
  int get_height() const;

  /**
   * Convenience method to access all position and size information at once
   */
  Gdk::Rectangle get_rect() const;


};

/** Rarely used event. Generated when a property of a window changes.
 *
 * get_event_type() will return Gdk::Event::Type::PROPERTY_NOTIFY.
 *
 * @newin{3,90}
 */
class EventProperty : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventProperty;
  using BaseObjectType = GdkEventProperty;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventProperty pointer.
   */
  EventProperty();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventProperty(GdkEventProperty* gobject, bool make_a_copy = false);

  void swap(EventProperty& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventProperty* gobj() noexcept { return reinterpret_cast<GdkEventProperty*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventProperty* gobj() const noexcept { return reinterpret_cast<const GdkEventProperty*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventProperty* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the atom indicating the property that was changed
   */
  GdkAtom get_atom() const;

  /**
   * Identifies whether the property was changed (Gdk::PropertyState::NEW_VALUE) or
   * deleted (Gdk::PropertyState::DELETE).
   */
  Gdk::PropertyState get_state() const;


};

/** Rarely used event. Generated when a selection is requested or ownership of a
 * selection is taken over by another client application.
 *
 * get_event_type() will return one of Gdk::Event::Type::SELECTION_CLEAR,
 * Gdk::Event::Type::SELECTION_NOTIFY or Gdk::Event::Type::SELECTION_REQUEST.
 *
 * @newin{3,90}
 */
class EventSelection : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventSelection;
  using BaseObjectType = GdkEventSelection;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventSelection pointer.
   */
  EventSelection();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventSelection(GdkEventSelection* gobject, bool make_a_copy = false);

  void swap(EventSelection& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventSelection* gobj() noexcept { return reinterpret_cast<GdkEventSelection*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventSelection* gobj() const noexcept { return reinterpret_cast<const GdkEventSelection*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventSelection* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the atom identifying the selection
   */
  GdkAtom get_selection() const;

  /**
   * Returns the atom identifying the target to which the selection should be
   * converted
   */
  GdkAtom get_target() const;

  /**
   * Returns the atom identifying the property in which to place the result of
   * the conversion
   */
  GdkAtom get_property() const;

  /**
   * Checks whether there's window on which to place the property. The results
   * are undefined if has_requestor() returns @c false and get_requestor()
   * is called.
   */
  bool has_requestor() const;

  /**
   * Returns the window on which to place the property. The results are
   * undefined if has_requestor() would return @c false before the call.
   */
  Glib::RefPtr<Gdk::Window> get_requestor();
  Glib::RefPtr<const Gdk::Window> get_requestor() const;


};

/** Rarely used event. Generated when the owner of a selection changes. On X11,
 * this information is only available if the X server supports the XFIXES
 * extension.
 *
 * get_event_type() will return Gdk::Event::Type::OWNER_CHANGE.
 *
 * @newin{3,90}
 */
class EventOwnerChange : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventOwnerChange;
  using BaseObjectType = GdkEventOwnerChange;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventOwnerChange pointer.
   */
  EventOwnerChange();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventOwnerChange(GdkEventOwnerChange* gobject, bool make_a_copy = false);

  void swap(EventOwnerChange& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventOwnerChange* gobj() noexcept { return reinterpret_cast<GdkEventOwnerChange*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventOwnerChange* gobj() const noexcept { return reinterpret_cast<const GdkEventOwnerChange*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventOwnerChange* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the time at which the ownership changed
   */
  guint32 get_selection_time() const;

  /**
   * Returns the atom identifying the selection
   */
  GdkAtom get_selection() const;

  /**
   * Returns the reason of the ownership change
   */
  Gdk::OwnerChange get_reason() const;

  /**
   * Checks whether there's new owner of the selection. The results are
   * undefined if has_owner() returns @c false and get_owner() is called.
   */
  bool has_owner() const;

  /**
   * Returns the window which is the new owner of the selection. The results are
   * undefined if has_owner() would return @c false before the call.
   */
  Glib::RefPtr<Gdk::Window> get_owner();
  Glib::RefPtr<const Gdk::Window> get_owner() const;


};

/** Generated during Drag-and-Drop (DND) operations.
 *
 * get_event_type() will return one of Gdk::Event::Type::DRAG_ENTER,
 * Gdk::Event::Type::DRAG_LEAVE, Gdk::Event::Type::DRAG_MOTION,
 * Gdk::Event::Type::DRAG_STATUS, Gdk::Event::Type::DROP_START
 * or Gdk::Event::Type::DROP_FINISHED.
 *
 * @newin{3,90}
 */
class EventDND : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventDND;
  using BaseObjectType = GdkEventDND;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventDND pointer.
   */
  EventDND();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventDND(GdkEventDND* gobject, bool make_a_copy = false);

  void swap(EventDND& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventDND* gobj() noexcept { return reinterpret_cast<GdkEventDND*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventDND* gobj() const noexcept { return reinterpret_cast<const GdkEventDND*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventDND* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the X coordinate of the pointer relative to the root screen. Only
   * meaningful if get_event_type() returns Gdk::Event::Type::DRAG_MOTION or
   * Gdk::Event::Type::DROP_START.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root screen.
   */
  double get_root_y() const;

  /**
   * Returns the drag context
   */
 

  Glib::RefPtr<Gdk::DragContext> get_context();
  Glib::RefPtr<const Gdk::DragContext> get_context() const;


};

/** Rarely used event. Generated when a stylus has moved in or out of contact
 * with the tablet, or perhaps that the user's finger has moved in or out of
 * contact with a touch screen.
 *
 * This event type will be used pretty rarely. It only is important for XInput
 * aware programs that are drawing their own cursor.
 *
 * get_event_type() will return one of Gdk::Event::Type::PROXIMITY_IN,
 * Gdk::Event::Type::PROXIMITY_OUT.
 *
 * @newin{3,90}
 */
class EventProximity : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventProximity;
  using BaseObjectType = GdkEventProximity;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventProximity pointer.
   */
  EventProximity();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventProximity(GdkEventProximity* gobject, bool make_a_copy = false);

  void swap(EventProximity& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventProximity* gobj() noexcept { return reinterpret_cast<GdkEventProximity*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventProximity* gobj() const noexcept { return reinterpret_cast<const GdkEventProximity*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventProximity* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the device where the event originated from.
   */
  Glib::RefPtr<Gdk::Device> get_device();
  Glib::RefPtr<const Gdk::Device> get_device() const;


};

/** Generated when the state of the toplevel window changes.
 *
 * get_event_type() will return Gdk::Event::Type::WINDOW_STATE.
 *
 * @newin{3,90}
 */
class EventWindowState : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventWindowState;
  using BaseObjectType = GdkEventWindowState;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventWindowState pointer.
   */
  EventWindowState();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventWindowState(GdkEventWindowState* gobject, bool make_a_copy = false);

  void swap(EventWindowState& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventWindowState* gobj() noexcept { return reinterpret_cast<GdkEventWindowState*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventWindowState* gobj() const noexcept { return reinterpret_cast<const GdkEventWindowState*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventWindowState* gobj_copy() const;

private:


public:

  /**
   * Returns a bit mask identifying which bits of the state have been changed
   */
  Gdk::Window::State get_mask() const;

  /**
   * Returns the new window state
   */
  Gdk::Window::State get_state() const;


};

/** Generated when a setting is modified.
 *
 * get_event_type() will return Gdk::Event::Type::SETTING.
 *
 * @newin{3,90}
 */
class EventSetting : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventSetting;
  using BaseObjectType = GdkEventSetting;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventSetting pointer.
   */
  EventSetting();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventSetting(GdkEventSetting* gobject, bool make_a_copy = false);

  void swap(EventSetting& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventSetting* gobj() noexcept { return reinterpret_cast<GdkEventSetting*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventSetting* gobj() const noexcept { return reinterpret_cast<const GdkEventSetting*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventSetting* gobj_copy() const;

private:


public:

  /**
   * Specifies what happened to the setting.
   */
  Gdk::SettingAction get_action() const;

  /**
   * Returns the name of the setting
   */
  Glib::ustring get_name() const;


};

/** Generated when a pointer or keyboard grab is broken. On X11, this happens
 * when the grab window becomes unviewable (i.e. it or one of its ancestors is
 * unmapped), or if the same application grabs the pointer or keyboard again.
 * Note that implicit grabs (which are initiated by button presses) can also
 * cause Gdk::EventGrabBroken events.
 *
 * get_event_type() will return Gdk::Event::Type::GRAB_BROKEN.
 *
 * @newin{3,90}
 */
class EventGrabBroken : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventGrabBroken;
  using BaseObjectType = GdkEventGrabBroken;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventGrabBroken pointer.
   */
  EventGrabBroken();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventGrabBroken(GdkEventGrabBroken* gobject, bool make_a_copy = false);

  void swap(EventGrabBroken& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventGrabBroken* gobj() noexcept { return reinterpret_cast<GdkEventGrabBroken*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventGrabBroken* gobj() const noexcept { return reinterpret_cast<const GdkEventGrabBroken*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventGrabBroken* gobj_copy() const;

private:


public:

  /**
   * @c true if a keyboard grab was broken, @c false if a pointer grab was
   * broken
   */
  bool is_keyboard() const;

  /**
   * @c true if the broken grab was implicit.
   */
  bool is_implicit() const;

  /**
   * Checks whether this event was caused by another grab in the same
   * application. In this case, get_grab_window() can be used to acquire the
   * new grab window. The results are undefined if has_grab_window() returns
   * @c false and get_grab_window() is called.
   */
  bool has_grab_window() const;

  /**
   * Returns the new grab window. The results are undefined if
   * has_grab_window() would return @c false before the call.
   */
  Glib::RefPtr<Gdk::Window> get_grab_window();
  Glib::RefPtr<const Gdk::Window> get_grab_window() const;


};

/** Generated during touchpad swipe gestures.
 *
 * get_event_type() will return Gdk::Event::Type::TOUCHPAD_SWIPE.
 *
 * @newin{3,90}
 */
class EventTouchpadSwipe : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTouchpadSwipe;
  using BaseObjectType = GdkEventTouchpadSwipe;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventTouchpadSwipe pointer.
   */
  EventTouchpadSwipe();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventTouchpadSwipe(GdkEventTouchpadSwipe* gobject, bool make_a_copy = false);

  void swap(EventTouchpadSwipe& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventTouchpadSwipe* gobj() noexcept { return reinterpret_cast<GdkEventTouchpadSwipe*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventTouchpadSwipe* gobj() const noexcept { return reinterpret_cast<const GdkEventTouchpadSwipe*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventTouchpadSwipe* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the current phase of the gesture.
   */
  TouchpadGesturePhase get_phase() const;

 
  /**
   * Returns the number of fingers triggering the swipe.
   */
  int get_n_fingers() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the movement delta in the X axis of the swipe focal point.
   */
  double get_dx() const;

  /**
   * Returns the movement delta in the Y axis of the swipe focal point.
   */
  double get_dy() const;

  /**
   * Returns the X coordinate of the pointer relative to the root of the screen.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root of the screen.
   */
  double get_root_y() const;


};

/** Generated during touchpad swipe gestures.
 *
 * get_event_type() will return Gdk::Event::Type::TOUCHPAD_PINCH.
 *
 * @newin{3,90}
 */
class EventTouchpadPinch : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTouchpadPinch;
  using BaseObjectType = GdkEventTouchpadPinch;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventTouchpadPinch pointer.
   */
  EventTouchpadPinch();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventTouchpadPinch(GdkEventTouchpadPinch* gobject, bool make_a_copy = false);

  void swap(EventTouchpadPinch& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventTouchpadPinch* gobj() noexcept { return reinterpret_cast<GdkEventTouchpadPinch*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventTouchpadPinch* gobj() const noexcept { return reinterpret_cast<const GdkEventTouchpadPinch*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventTouchpadPinch* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the current phase of the gesture.
   */
  TouchpadGesturePhase get_phase() const;

  /**
   * Returns the number of fingers triggering the swipe.
   */
  int get_n_fingers() const;

  /**
   * Returns a bit mask representing the state of the modifier keys (e.g.
   * Control, Shift and Alt) and the pointer buttons.
   */
  ModifierType get_state() const;

  /**
   * Returns the X coordinate of the pointer relative to the window.
   */
  double get_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the window.
   */
  double get_y() const;

  /**
   * Returns the movement delta in the X axis of the swipe focal point.
   */
  double get_dx() const;

  /**
   * Returns the movement delta in the Y axis of the swipe focal point.
   */
  double get_dy() const;

  /**
   * Returns the angle change in radians. Negative angles denote counter-
   * clockwise movements.
   */
  double get_angle_delta() const;

  /**
   * Returns the current scale, relative to that at the time of the
   * corresponding Gdk::TouchpadGesturePhase::BEGIN event.
   */
  double get_scale() const;

  /**
   * Returns the X coordinate of the pointer relative to the root of the screen.
   */
  double get_root_x() const;

  /**
   * Returns the Y coordinate of the pointer relative to the root of the screen.
   */
  double get_root_y() const;


};

/** Generated during Gdk::InputSource::TABLET_PAD button presses and releases.
 *
 * get_event_type() will return Gdk::Event::Type::PAD_BUTTON_PRESS or
 * Gdk::Event::Type::PAD_BUTTON_RELEASE.
 *
 * @newin{3,90}
 */
class EventPadButton : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventPadButton;
  using BaseObjectType = GdkEventPadButton;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventPadButton pointer.
   */
  EventPadButton();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventPadButton(GdkEventPadButton* gobject, bool make_a_copy = false);

  void swap(EventPadButton& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventPadButton* gobj() noexcept { return reinterpret_cast<GdkEventPadButton*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventPadButton* gobj() const noexcept { return reinterpret_cast<const GdkEventPadButton*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventPadButton* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the pad group the button belongs to.
   * A Gdk::InputSource::TABLET_PAD device may have one or more groups
   * containing a set of buttons/rings/strips each.
   */
  guint get_group() const;

  /**
   * Returns the pad button that was pressed.
   */
  guint get_button() const;

  /**
   * Returns the current mode of @a group.
   * Different groups in a Gdk::InputSource::TABLET_PAD device may have
   * different current modes.
   */
  guint get_mode() const;


};

/** Generated during Gdk::InputSource::TABLET_PAD interaction with tactile sensors.
 *
 * get_event_type() will return Gdk::Event::Type::PAD_RING or
 * Gdk::Event::Type::PAD_STRIP.
 *
 * @newin{3,90}
 */
class EventPadAxis : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventPadAxis;
  using BaseObjectType = GdkEventPadAxis;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventPadAxis pointer.
   */
  EventPadAxis();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventPadAxis(GdkEventPadAxis* gobject, bool make_a_copy = false);

  void swap(EventPadAxis& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventPadAxis* gobj() noexcept { return reinterpret_cast<GdkEventPadAxis*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventPadAxis* gobj() const noexcept { return reinterpret_cast<const GdkEventPadAxis*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventPadAxis* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the pad group the ring/strip belongs to.
   * A Gdk::InputSource::TABLET_PAD device may have one or more groups
   * containing a set of buttons/rings/strips each.
   */
  guint get_group() const;

  /**
   * Returns the number of strip/ring that was interacted.
   * This number is 0-indexed.
   */
  guint get_index() const;

  /**
   * Returns the current mode of @a group.
   * Different groups in a Gdk::InputSource::TABLET_PAD device may have
   * different current modes.
   */
  guint get_mode() const;

  /**
   * Returns the current value for the given axis.
   */
  double get_value() const;


};

/** Generated during Gdk::InputSource::TABLET_PAD mode switches in a group.
 *
 * get_event_type() will return Gdk::Event::Type::PAD_GROUP_MODE.
 *
 * @newin{3,90}
 */
class EventPadGroupMode : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventPadGroupMode;
  using BaseObjectType = GdkEventPadGroupMode;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEventPadGroupMode pointer.
   */
  EventPadGroupMode();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit EventPadGroupMode(GdkEventPadGroupMode* gobject, bool make_a_copy = false);

  void swap(EventPadGroupMode& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEventPadGroupMode* gobj() noexcept { return reinterpret_cast<GdkEventPadGroupMode*>(Event::gobj()); }

  /// Provides access to the underlying C instance.
  const GdkEventPadGroupMode* gobj() const noexcept { return reinterpret_cast<const GdkEventPadGroupMode*>(Event::gobj()); }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEventPadGroupMode* gobj_copy() const;

private:


public:

  /**
   * Returns the timestamp of the event in milliseconds
   */
  guint32 get_time() const;

  /**
   * Returns the pad group that is switching mode.
   * A Gdk::InputSource::TABLET_PAD device may have one or more groups
   * containing a set of buttons/rings/strips each.
   */
  guint get_group() const;

  /**
   * Returns the new mode of @a group.
   * Different groups in a Gdk::InputSource::TABLET_PAD device may have
   * different current modes.
   */
  guint get_mode() const;


};

} // namespace Gdk


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventKey
 */
inline void swap(EventKey& lhs, EventKey& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventKey
 */
const EventKey& wrap_event(const GdkEventKey*& event);

/** See wrap_event(const GdkEventKey*& event).
 *
 * @relates Gdk::EventKey
 */
EventKey& wrap_event(GdkEventKey*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventKey
 */
Gdk::EventKey wrap(GdkEventKey* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventKey> : public Glib::Value_Boxed<Gdk::EventKey>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventButton
 */
inline void swap(EventButton& lhs, EventButton& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventButton
 */
const EventButton& wrap_event(const GdkEventButton*& event);

/** See wrap_event(const GdkEventButton*& event).
 *
 * @relates Gdk::EventButton
 */
EventButton& wrap_event(GdkEventButton*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventButton
 */
Gdk::EventButton wrap(GdkEventButton* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventButton> : public Glib::Value_Boxed<Gdk::EventButton>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventScroll
 */
inline void swap(EventScroll& lhs, EventScroll& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventScroll
 */
const EventScroll& wrap_event(const GdkEventScroll*& event);

/** See wrap_event(const GdkEventScroll*& event).
 *
 * @relates Gdk::EventScroll
 */
EventScroll& wrap_event(GdkEventScroll*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventScroll
 */
Gdk::EventScroll wrap(GdkEventScroll* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventScroll> : public Glib::Value_Boxed<Gdk::EventScroll>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventMotion
 */
inline void swap(EventMotion& lhs, EventMotion& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventMotion
 */
const EventMotion& wrap_event(const GdkEventMotion*& event);

/** See wrap_event(const GdkEventMotion*& event).
 *
 * @relates Gdk::EventMotion
 */
EventMotion& wrap_event(GdkEventMotion*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventMotion
 */
Gdk::EventMotion wrap(GdkEventMotion* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventMotion> : public Glib::Value_Boxed<Gdk::EventMotion>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventTouch
 */
inline void swap(EventTouch& lhs, EventTouch& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventTouch
 */
const EventTouch& wrap_event(const GdkEventTouch*& event);

/** See wrap_event(const GdkEventTouch*& event).
 *
 * @relates Gdk::EventTouch
 */
EventTouch& wrap_event(GdkEventTouch*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventTouch
 */
Gdk::EventTouch wrap(GdkEventTouch* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventTouch> : public Glib::Value_Boxed<Gdk::EventTouch>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventCrossing
 */
inline void swap(EventCrossing& lhs, EventCrossing& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventCrossing
 */
const EventCrossing& wrap_event(const GdkEventCrossing*& event);

/** See wrap_event(const GdkEventCrossing*& event).
 *
 * @relates Gdk::EventCrossing
 */
EventCrossing& wrap_event(GdkEventCrossing*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventCrossing
 */
Gdk::EventCrossing wrap(GdkEventCrossing* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventCrossing> : public Glib::Value_Boxed<Gdk::EventCrossing>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventExpose
 */
inline void swap(EventExpose& lhs, EventExpose& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventExpose
 */
const EventExpose& wrap_event(const GdkEventExpose*& event);

/** See wrap_event(const GdkEventExpose*& event).
 *
 * @relates Gdk::EventExpose
 */
EventExpose& wrap_event(GdkEventExpose*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventExpose
 */
Gdk::EventExpose wrap(GdkEventExpose* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventExpose> : public Glib::Value_Boxed<Gdk::EventExpose>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventFocus
 */
inline void swap(EventFocus& lhs, EventFocus& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventFocus
 */
const EventFocus& wrap_event(const GdkEventFocus*& event);

/** See wrap_event(const GdkEventFocus*& event).
 *
 * @relates Gdk::EventFocus
 */
EventFocus& wrap_event(GdkEventFocus*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventFocus
 */
Gdk::EventFocus wrap(GdkEventFocus* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventFocus> : public Glib::Value_Boxed<Gdk::EventFocus>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventConfigure
 */
inline void swap(EventConfigure& lhs, EventConfigure& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventConfigure
 */
const EventConfigure& wrap_event(const GdkEventConfigure*& event);

/** See wrap_event(const GdkEventConfigure*& event).
 *
 * @relates Gdk::EventConfigure
 */
EventConfigure& wrap_event(GdkEventConfigure*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventConfigure
 */
Gdk::EventConfigure wrap(GdkEventConfigure* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventConfigure> : public Glib::Value_Boxed<Gdk::EventConfigure>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventProperty
 */
inline void swap(EventProperty& lhs, EventProperty& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventProperty
 */
const EventProperty& wrap_event(const GdkEventProperty*& event);

/** See wrap_event(const GdkEventProperty*& event).
 *
 * @relates Gdk::EventProperty
 */
EventProperty& wrap_event(GdkEventProperty*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventProperty
 */
Gdk::EventProperty wrap(GdkEventProperty* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventProperty> : public Glib::Value_Boxed<Gdk::EventProperty>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventSelection
 */
inline void swap(EventSelection& lhs, EventSelection& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventSelection
 */
const EventSelection& wrap_event(const GdkEventSelection*& event);

/** See wrap_event(const GdkEventSelection*& event).
 *
 * @relates Gdk::EventSelection
 */
EventSelection& wrap_event(GdkEventSelection*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventSelection
 */
Gdk::EventSelection wrap(GdkEventSelection* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventSelection> : public Glib::Value_Boxed<Gdk::EventSelection>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventOwnerChange
 */
inline void swap(EventOwnerChange& lhs, EventOwnerChange& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventOwnerChange
 */
const EventOwnerChange& wrap_event(const GdkEventOwnerChange*& event);

/** See wrap_event(const GdkEventOwnerChange*& event).
 *
 * @relates Gdk::EventOwnerChange
 */
EventOwnerChange& wrap_event(GdkEventOwnerChange*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventOwnerChange
 */
Gdk::EventOwnerChange wrap(GdkEventOwnerChange* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventOwnerChange> : public Glib::Value_Boxed<Gdk::EventOwnerChange>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventDND
 */
inline void swap(EventDND& lhs, EventDND& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventDND
 */
const EventDND& wrap_event(const GdkEventDND*& event);

/** See wrap_event(const GdkEventDND*& event).
 *
 * @relates Gdk::EventDND
 */
EventDND& wrap_event(GdkEventDND*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventDND
 */
Gdk::EventDND wrap(GdkEventDND* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventDND> : public Glib::Value_Boxed<Gdk::EventDND>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventProximity
 */
inline void swap(EventProximity& lhs, EventProximity& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventProximity
 */
const EventProximity& wrap_event(const GdkEventProximity*& event);

/** See wrap_event(const GdkEventProximity*& event).
 *
 * @relates Gdk::EventProximity
 */
EventProximity& wrap_event(GdkEventProximity*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventProximity
 */
Gdk::EventProximity wrap(GdkEventProximity* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventProximity> : public Glib::Value_Boxed<Gdk::EventProximity>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventWindowState
 */
inline void swap(EventWindowState& lhs, EventWindowState& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventWindowState
 */
const EventWindowState& wrap_event(const GdkEventWindowState*& event);

/** See wrap_event(const GdkEventWindowState*& event).
 *
 * @relates Gdk::EventWindowState
 */
EventWindowState& wrap_event(GdkEventWindowState*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventWindowState
 */
Gdk::EventWindowState wrap(GdkEventWindowState* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventWindowState> : public Glib::Value_Boxed<Gdk::EventWindowState>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventSetting
 */
inline void swap(EventSetting& lhs, EventSetting& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventSetting
 */
const EventSetting& wrap_event(const GdkEventSetting*& event);

/** See wrap_event(const GdkEventSetting*& event).
 *
 * @relates Gdk::EventSetting
 */
EventSetting& wrap_event(GdkEventSetting*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventSetting
 */
Gdk::EventSetting wrap(GdkEventSetting* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventSetting> : public Glib::Value_Boxed<Gdk::EventSetting>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventGrabBroken
 */
inline void swap(EventGrabBroken& lhs, EventGrabBroken& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventGrabBroken
 */
const EventGrabBroken& wrap_event(const GdkEventGrabBroken*& event);

/** See wrap_event(const GdkEventGrabBroken*& event).
 *
 * @relates Gdk::EventGrabBroken
 */
EventGrabBroken& wrap_event(GdkEventGrabBroken*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventGrabBroken
 */
Gdk::EventGrabBroken wrap(GdkEventGrabBroken* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventGrabBroken> : public Glib::Value_Boxed<Gdk::EventGrabBroken>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventTouchpadSwipe
 */
inline void swap(EventTouchpadSwipe& lhs, EventTouchpadSwipe& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventTouchpadSwipe
 */
const EventTouchpadSwipe& wrap_event(const GdkEventTouchpadSwipe*& event);

/** See wrap_event(const GdkEventTouchpadSwipe*& event).
 *
 * @relates Gdk::EventTouchpadSwipe
 */
EventTouchpadSwipe& wrap_event(GdkEventTouchpadSwipe*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventTouchpadSwipe
 */
Gdk::EventTouchpadSwipe wrap(GdkEventTouchpadSwipe* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventTouchpadSwipe> : public Glib::Value_Boxed<Gdk::EventTouchpadSwipe>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventTouchpadPinch
 */
inline void swap(EventTouchpadPinch& lhs, EventTouchpadPinch& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventTouchpadPinch
 */
const EventTouchpadPinch& wrap_event(const GdkEventTouchpadPinch*& event);

/** See wrap_event(const GdkEventTouchpadPinch*& event).
 *
 * @relates Gdk::EventTouchpadPinch
 */
EventTouchpadPinch& wrap_event(GdkEventTouchpadPinch*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventTouchpadPinch
 */
Gdk::EventTouchpadPinch wrap(GdkEventTouchpadPinch* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventTouchpadPinch> : public Glib::Value_Boxed<Gdk::EventTouchpadPinch>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventPadButton
 */
inline void swap(EventPadButton& lhs, EventPadButton& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventPadButton
 */
const EventPadButton& wrap_event(const GdkEventPadButton*& event);

/** See wrap_event(const GdkEventPadButton*& event).
 *
 * @relates Gdk::EventPadButton
 */
EventPadButton& wrap_event(GdkEventPadButton*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventPadButton
 */
Gdk::EventPadButton wrap(GdkEventPadButton* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventPadButton> : public Glib::Value_Boxed<Gdk::EventPadButton>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventPadAxis
 */
inline void swap(EventPadAxis& lhs, EventPadAxis& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventPadAxis
 */
const EventPadAxis& wrap_event(const GdkEventPadAxis*& event);

/** See wrap_event(const GdkEventPadAxis*& event).
 *
 * @relates Gdk::EventPadAxis
 */
EventPadAxis& wrap_event(GdkEventPadAxis*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventPadAxis
 */
Gdk::EventPadAxis wrap(GdkEventPadAxis* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventPadAxis> : public Glib::Value_Boxed<Gdk::EventPadAxis>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::EventPadGroupMode
 */
inline void swap(EventPadGroupMode& lhs, EventPadGroupMode& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::EventPadGroupMode
 */
const EventPadGroupMode& wrap_event(const GdkEventPadGroupMode*& event);

/** See wrap_event(const GdkEventPadGroupMode*& event).
 *
 * @relates Gdk::EventPadGroupMode
 */
EventPadGroupMode& wrap_event(GdkEventPadGroupMode*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::EventPadGroupMode
 */
Gdk::EventPadGroupMode wrap(GdkEventPadGroupMode* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::EventPadGroupMode> : public Glib::Value_Boxed<Gdk::EventPadGroupMode>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_EVENTS_H */

