/* valaconstant.c generated by valac, the Vala compiler
 * generated from valaconstant.vala, do not modify */

/* valaconstant.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_CONSTANT_0_PROPERTY,
	VALA_CONSTANT_NUM_PROPERTIES
};
static GParamSpec* vala_constant_properties[VALA_CONSTANT_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaConstantPrivate {
	gboolean lock_used;
	ValaDataType* _data_type;
	ValaExpression* _value;
};


static gpointer vala_constant_parent_class = NULL;
static ValaLockableIface * vala_constant_vala_lockable_parent_iface = NULL;

#define VALA_CONSTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONSTANT, ValaConstantPrivate))
static void vala_constant_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_constant_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_constant_real_get_lock_used (ValaLockable* base);
static void vala_constant_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_constant_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static void vala_constant_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_constant_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean vala_constant_check_const_type (ValaConstant* self, ValaDataType* type, ValaCodeContext* context);
static void vala_constant_finalize (ValaCodeNode * obj);


/**
 * Creates a new constant.
 *
 * @param name             constant name
 * @param type_reference   constant type
 * @param value            constant value
 * @param source_reference reference to source code
 * @return                 newly created constant
 */
ValaConstant* vala_constant_construct (GType object_type, const gchar* name, ValaDataType* type_reference, ValaExpression* value, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaConstant* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaDataType* _tmp3_;
	ValaExpression* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaConstant*) vala_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = type_reference;
	if (_tmp3_ != NULL) {
		ValaDataType* _tmp4_;
		_tmp4_ = type_reference;
		vala_constant_set_type_reference (self, _tmp4_);
	}
	_tmp5_ = value;
	vala_constant_set_value (self, _tmp5_);
	return self;
}


ValaConstant* vala_constant_new (const gchar* name, ValaDataType* type_reference, ValaExpression* value, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_constant_construct (VALA_TYPE_CONSTANT, name, type_reference, value, source_reference, comment);
}


static void vala_constant_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaConstant * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_constant (_tmp0_, self);
}


static void vala_constant_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_constant_get_value (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaCodeVisitor* _tmp7_;
		_tmp5_ = vala_constant_get_value (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
}


static gboolean vala_constant_real_get_lock_used (ValaLockable* base) {
	ValaConstant * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaConstant*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_constant_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaConstant * self;
	gboolean _tmp0_;
	self = (ValaConstant*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


static void vala_constant_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaConstant * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_constant_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_constant_set_value (self, _tmp3_);
	}
}


static void vala_constant_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_constant_set_type_reference (self, _tmp3_);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_constant_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaConstant * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaSymbol* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp31_;
	ValaCodeContext* _tmp32_;
	ValaDataType* _tmp33_;
	ValaDataType* _tmp34_;
	ValaCodeContext* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_;
	gboolean _tmp121_;
	ValaCodeContext* _tmp136_;
	ValaSemanticAnalyzer* _tmp137_;
	ValaSemanticAnalyzer* _tmp138_;
	ValaSourceFile* _tmp139_;
	ValaCodeContext* _tmp140_;
	ValaSemanticAnalyzer* _tmp141_;
	ValaSemanticAnalyzer* _tmp142_;
	ValaSymbol* _tmp143_;
	gboolean _tmp144_;
	gboolean _tmp145_;
	self = (ValaConstant*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp26_ = _tmp25_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_BLOCK)) {
		ValaCodeContext* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		_tmp27_ = context;
		_tmp28_ = vala_code_context_get_analyzer (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_semantic_analyzer_set_current_symbol (_tmp29_, (ValaSymbol*) self);
	}
	_tmp30_ = vala_constant_get_type_reference (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp31_, _tmp32_);
	_tmp33_ = vala_constant_get_type_reference (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = context;
	_tmp36_ = vala_constant_check_const_type (self, _tmp34_, _tmp35_);
	if (!_tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_constant_get_type_reference (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_code_node_to_string ((ValaCodeNode*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strdup_printf ("`%s' not supported as type for constants", _tmp42_);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp38_, _tmp44_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp45_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp46_ = _tmp45_;
	if (!_tmp46_) {
		ValaExpression* _tmp47_;
		ValaExpression* _tmp48_;
		_tmp47_ = vala_constant_get_value (self);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp50_ = _tmp49_;
			vala_report_error (_tmp50_, "A const field requires a value to be provided");
		} else {
			ValaExpression* _tmp51_;
			ValaExpression* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaExpression* _tmp55_;
			ValaExpression* _tmp56_;
			ValaCodeContext* _tmp57_;
			gboolean _tmp58_;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaDataType* _tmp61_;
			ValaDataType* _tmp62_;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			gboolean _tmp65_;
			ValaMethodCall* call = NULL;
			ValaExpression* _tmp80_;
			ValaExpression* _tmp81_;
			ValaMethodCall* _tmp82_;
			ValaMethodCall* _tmp83_;
			ValaExpression* _tmp107_;
			ValaExpression* _tmp108_;
			gboolean _tmp109_;
			_tmp51_ = vala_constant_get_value (self);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_constant_get_type_reference (self);
			_tmp54_ = _tmp53_;
			vala_expression_set_target_type (_tmp52_, _tmp54_);
			_tmp55_ = vala_constant_get_value (self);
			_tmp56_ = _tmp55_;
			_tmp57_ = context;
			_tmp58_ = vala_code_node_check ((ValaCodeNode*) _tmp56_, _tmp57_);
			if (!_tmp58_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp59_ = vala_constant_get_value (self);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_expression_get_value_type (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_constant_get_type_reference (self);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_data_type_compatible (_tmp62_, _tmp64_);
			if (!_tmp65_) {
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_constant_get_value (self);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_code_node_to_string ((ValaCodeNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_constant_get_type_reference (self);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_code_node_to_string ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp73_, _tmp77_);
				_tmp79_ = _tmp78_;
				vala_report_error (_tmp67_, _tmp79_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp73_);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp80_ = vala_constant_get_value (self);
			_tmp81_ = _tmp80_;
			_tmp82_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, VALA_TYPE_METHOD_CALL) ? ((ValaMethodCall*) _tmp81_) : NULL);
			call = _tmp82_;
			_tmp83_ = call;
			if (_tmp83_ != NULL) {
				ValaMethodType* method_type = NULL;
				ValaMethodCall* _tmp84_;
				ValaExpression* _tmp85_;
				ValaExpression* _tmp86_;
				ValaDataType* _tmp87_;
				ValaDataType* _tmp88_;
				ValaMethodType* _tmp89_;
				gboolean _tmp90_ = FALSE;
				ValaMethodType* _tmp91_;
				_tmp84_ = call;
				_tmp85_ = vala_method_call_get_call (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_expression_get_value_type (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp88_) : NULL);
				method_type = _tmp89_;
				_tmp91_ = method_type;
				if (_tmp91_ != NULL) {
					ValaMethodType* _tmp92_;
					ValaMethod* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					_tmp92_ = method_type;
					_tmp93_ = vala_method_type_get_method_symbol (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp94_);
					_tmp96_ = _tmp95_;
					_tmp90_ = g_strcmp0 (_tmp96_, "GLib._") == 0;
					_g_free0 (_tmp96_);
				} else {
					_tmp90_ = FALSE;
				}
				if (_tmp90_) {
					ValaStringLiteral* literal = NULL;
					ValaMethodCall* _tmp97_;
					ValaList* _tmp98_;
					ValaList* _tmp99_;
					gpointer _tmp100_;
					ValaExpression* _tmp101_;
					ValaStringLiteral* _tmp102_;
					ValaStringLiteral* _tmp103_;
					ValaStringLiteral* _tmp104_;
					_tmp97_ = call;
					_tmp98_ = vala_method_call_get_argument_list (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = vala_list_get (_tmp99_, 0);
					_tmp101_ = (ValaExpression*) _tmp100_;
					_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp101_) : NULL;
					if (_tmp102_ == NULL) {
						_vala_code_node_unref0 (_tmp101_);
					}
					_tmp103_ = _tmp102_;
					_vala_iterable_unref0 (_tmp99_);
					literal = _tmp103_;
					_tmp104_ = literal;
					if (_tmp104_ != NULL) {
						ValaStringLiteral* _tmp105_;
						ValaStringLiteral* _tmp106_;
						_tmp105_ = literal;
						vala_constant_set_value (self, (ValaExpression*) _tmp105_);
						_tmp106_ = literal;
						vala_string_literal_set_translate (_tmp106_, TRUE);
					}
					_vala_code_node_unref0 (literal);
				}
				_vala_code_node_unref0 (method_type);
			}
			_tmp107_ = vala_constant_get_value (self);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_expression_is_constant (_tmp108_);
			if (!_tmp109_) {
				ValaExpression* _tmp110_;
				ValaExpression* _tmp111_;
				ValaSourceReference* _tmp112_;
				ValaSourceReference* _tmp113_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp110_ = vala_constant_get_value (self);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp111_);
				_tmp113_ = _tmp112_;
				vala_report_error (_tmp113_, "Value must be constant");
				result = FALSE;
				_vala_code_node_unref0 (call);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (call);
		}
	} else {
		ValaExpression* _tmp114_;
		ValaExpression* _tmp115_;
		_tmp114_ = vala_constant_get_value (self);
		_tmp115_ = _tmp114_;
		if (_tmp115_ != NULL) {
			ValaSourceReference* _tmp116_;
			ValaSourceReference* _tmp117_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp117_ = _tmp116_;
			vala_report_error (_tmp117_, "External constants cannot use values");
		}
	}
	_tmp120_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp121_ = _tmp120_;
	if (!_tmp121_) {
		gboolean _tmp122_;
		gboolean _tmp123_;
		_tmp122_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp123_ = _tmp122_;
		_tmp119_ = !_tmp123_;
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		ValaSymbol* _tmp124_;
		ValaSymbol* _tmp125_;
		_tmp124_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp125_ = _tmp124_;
		_tmp118_ = _tmp125_ != NULL;
		_vala_code_node_unref0 (_tmp125_);
	} else {
		_tmp118_ = FALSE;
	}
	if (_tmp118_) {
		ValaSourceReference* _tmp126_;
		ValaSourceReference* _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		ValaSymbol* _tmp130_;
		ValaSymbol* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp129_ = _tmp128_;
		_tmp130_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_symbol_get_full_name (_tmp131_);
		_tmp133_ = _tmp132_;
		_tmp134_ = g_strdup_printf ("%s hides inherited constant `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp129_, _tmp133_);
		_tmp135_ = _tmp134_;
		vala_report_warning (_tmp127_, _tmp135_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp133_);
		_vala_code_node_unref0 (_tmp131_);
		_g_free0 (_tmp129_);
	}
	_tmp136_ = context;
	_tmp137_ = vala_code_context_get_analyzer (_tmp136_);
	_tmp138_ = _tmp137_;
	_tmp139_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp138_, _tmp139_);
	_tmp140_ = context;
	_tmp141_ = vala_code_context_get_analyzer (_tmp140_);
	_tmp142_ = _tmp141_;
	_tmp143_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp142_, _tmp143_);
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp144_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp145_ = _tmp144_;
	result = !_tmp145_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean vala_constant_check_const_type (ValaConstant* self, ValaDataType* type, ValaCodeContext* context) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_VALUE_TYPE)) {
		result = TRUE;
		return result;
	} else {
		ValaDataType* _tmp1_;
		_tmp1_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp2_;
			ValaArrayType* _tmp3_;
			ValaArrayType* _tmp4_;
			ValaDataType* _tmp5_;
			ValaDataType* _tmp6_;
			ValaCodeContext* _tmp7_;
			gboolean _tmp8_;
			_tmp2_ = type;
			_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp2_) : NULL);
			array_type = _tmp3_;
			_tmp4_ = array_type;
			_tmp5_ = vala_array_type_get_element_type (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = context;
			_tmp8_ = vala_constant_check_const_type (self, _tmp6_, _tmp7_);
			result = _tmp8_;
			_vala_code_node_unref0 (array_type);
			return result;
		} else {
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaCodeContext* _tmp12_;
			ValaSemanticAnalyzer* _tmp13_;
			ValaSemanticAnalyzer* _tmp14_;
			ValaDataType* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			_tmp9_ = type;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = context;
			_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_->string_type;
			_tmp16_ = vala_data_type_get_data_type (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp11_ == _tmp17_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}


ValaDataType* vala_constant_get_type_reference (ValaConstant* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_constant_set_type_reference (ValaConstant* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaExpression* vala_constant_get_value (ValaConstant* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void vala_constant_set_value (ValaConstant* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_value);
	self->priv->_value = _tmp1_;
	_tmp2_ = self->priv->_value;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		_tmp3_ = self->priv->_value;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


static void vala_constant_class_init (ValaConstantClass * klass) {
	vala_constant_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_constant_finalize;
	g_type_class_add_private (klass, sizeof (ValaConstantPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_constant_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_constant_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_constant_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_constant_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_constant_real_check;
}


static void vala_constant_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_constant_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_constant_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_constant_real_set_lock_used;
}


static void vala_constant_instance_init (ValaConstant * self) {
	self->priv = VALA_CONSTANT_GET_PRIVATE (self);
	self->priv->lock_used = FALSE;
}


static void vala_constant_finalize (ValaCodeNode * obj) {
	ValaConstant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CONSTANT, ValaConstant);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_constant_parent_class)->finalize (obj);
}


/**
 * Represents a type member with a constant value.
 */
GType vala_constant_get_type (void) {
	static volatile gsize vala_constant_type_id__volatile = 0;
	if (g_once_init_enter (&vala_constant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConstant), 0, (GInstanceInitFunc) vala_constant_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_constant_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_constant_type_id;
		vala_constant_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaConstant", &g_define_type_info, 0);
		g_type_add_interface_static (vala_constant_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_constant_type_id__volatile, vala_constant_type_id);
	}
	return vala_constant_type_id__volatile;
}



