/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

enum  {
	VALA_CCODE_COMPILER_DUMMY_PROPERTY,
	VALA_CCODE_COMPILER_LAST_PROPERTY
};
static GParamSpec* vala_ccode_compiler_properties[VALA_CCODE_COMPILER_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

static gboolean vala_ccode_compiler_package_exists (const gchar* package_name, const gchar* pkg_config_command);
static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);


ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type) {
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler* vala_ccode_compiler_new (void) {
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


static gboolean vala_ccode_compiler_package_exists (const gchar* package_name, const gchar* pkg_config_command) {
	gboolean result = FALSE;
	gchar* pc = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint exit_status = 0;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (package_name != NULL, FALSE);
	_tmp0_ = pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --exists ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = package_name;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	pc = _tmp5_;
	{
		gint _tmp6_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp6_, &_inner_error_);
		exit_status = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch2_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp7_;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally2;
	__catch2_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		vala_report_error (NULL, _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally2:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp10_;
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1, const gchar* pkg_config_command) {
	gboolean use_pkgconfig = FALSE;
	const gchar* _tmp0_;
	gchar* pc = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* pkgflags = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp40_;
	gchar* cmdline = NULL;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	ValaCodeContext* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	ValaList* source_files = NULL;
	ValaCodeContext* _tmp86_;
	ValaList* _tmp87_;
	ValaList* c_source_files = NULL;
	ValaCodeContext* _tmp111_;
	ValaList* _tmp112_;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar** _tmp138_;
	gint _tmp138__length1;
	ValaCodeContext* _tmp147_;
	gboolean _tmp148_;
	gboolean _tmp149_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	use_pkgconfig = FALSE;
	_tmp0_ = pkg_config_command;
	if (_tmp0_ == NULL) {
		pkg_config_command = "pkg-config";
	}
	_tmp1_ = pkg_config_command;
	_tmp2_ = g_strconcat (_tmp1_, " --cflags", NULL);
	pc = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = vala_code_context_get_compile_only (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = pc;
		_tmp7_ = g_strconcat (_tmp6_, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp7_;
	}
	use_pkgconfig = TRUE;
	_tmp8_ = pc;
	_tmp9_ = g_strconcat (_tmp8_, " gobject-2.0", NULL);
	_g_free0 (pc);
	pc = _tmp9_;
	{
		ValaList* _pkg_list = NULL;
		ValaCodeContext* _tmp10_;
		ValaList* _tmp11_;
		gint _pkg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _pkg_index = 0;
		_tmp10_ = context;
		_tmp11_ = vala_code_context_get_packages (_tmp10_);
		_pkg_list = _tmp11_;
		_tmp12_ = _pkg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_pkg_size = _tmp14_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gchar* pkg = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gboolean _tmp23_;
			_tmp15_ = _pkg_index;
			_pkg_index = _tmp15_ + 1;
			_tmp16_ = _pkg_index;
			_tmp17_ = _pkg_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _pkg_list;
			_tmp19_ = _pkg_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			pkg = (gchar*) _tmp20_;
			_tmp21_ = pkg;
			_tmp22_ = pkg_config_command;
			_tmp23_ = vala_ccode_compiler_package_exists (_tmp21_, _tmp22_);
			if (_tmp23_) {
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				use_pkgconfig = TRUE;
				_tmp24_ = pc;
				_tmp25_ = pkg;
				_tmp26_ = g_strconcat (" ", _tmp25_, NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
				_g_free0 (pc);
				pc = _tmp28_;
				_g_free0 (_tmp27_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp29_ = g_strdup ("");
	pkgflags = _tmp29_;
	_tmp30_ = use_pkgconfig;
	if (_tmp30_) {
		{
			gint exit_status = 0;
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_;
			_tmp31_ = pc;
			g_spawn_command_line_sync (_tmp31_, &_tmp32_, NULL, &_tmp33_, &_inner_error_);
			_g_free0 (pkgflags);
			pkgflags = _tmp32_;
			exit_status = _tmp33_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch3_g_spawn_error;
				}
				_g_free0 (pkgflags);
				_g_free0 (pc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp34_ = exit_status;
			if (_tmp34_ != 0) {
				gint _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp35_ = exit_status;
				_tmp36_ = g_strdup_printf ("pkg-config exited with status %d", _tmp35_);
				_tmp37_ = _tmp36_;
				vala_report_error (NULL, _tmp37_);
				_g_free0 (_tmp37_);
				_g_free0 (pkgflags);
				_g_free0 (pc);
				return;
			}
		}
		goto __finally3;
		__catch3_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp38_;
			const gchar* _tmp39_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp38_ = e;
			_tmp39_ = _tmp38_->message;
			vala_report_error (NULL, _tmp39_);
			_g_error_free0 (e);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp40_ = cc_command;
	if (_tmp40_ == NULL) {
		cc_command = "cc";
	}
	_tmp41_ = cc_command;
	_tmp42_ = g_strdup (_tmp41_);
	cmdline = _tmp42_;
	_tmp43_ = context;
	_tmp44_ = vala_code_context_get_debug (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_) {
		const gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp46_ = cmdline;
		_tmp47_ = g_strconcat (_tmp46_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp47_;
	}
	_tmp48_ = context;
	_tmp49_ = vala_code_context_get_compile_only (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_) {
		const gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp51_ = cmdline;
		_tmp52_ = g_strconcat (_tmp51_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp52_;
	} else {
		ValaCodeContext* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		_tmp53_ = context;
		_tmp54_ = vala_code_context_get_output (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_ != NULL) {
			gchar* output = NULL;
			ValaCodeContext* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gboolean _tmp60_ = FALSE;
			gboolean _tmp61_ = FALSE;
			ValaCodeContext* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			_tmp56_ = context;
			_tmp57_ = vala_code_context_get_output (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strdup (_tmp58_);
			output = _tmp59_;
			_tmp62_ = context;
			_tmp63_ = vala_code_context_get_directory (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ != NULL) {
				ValaCodeContext* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				_tmp65_ = context;
				_tmp66_ = vala_code_context_get_directory (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp61_ = g_strcmp0 (_tmp67_, "") != 0;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaCodeContext* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				gboolean _tmp71_;
				_tmp68_ = context;
				_tmp69_ = vala_code_context_get_output (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_path_is_absolute (_tmp70_);
				_tmp60_ = !_tmp71_;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaCodeContext* _tmp72_;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				ValaCodeContext* _tmp75_;
				const gchar* _tmp76_;
				const gchar* _tmp77_;
				gchar* _tmp78_;
				_tmp72_ = context;
				_tmp73_ = vala_code_context_get_directory (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = context;
				_tmp76_ = vala_code_context_get_output (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strdup_printf ("%s%c%s", _tmp74_, (gint) G_DIR_SEPARATOR, _tmp77_);
				_g_free0 (output);
				output = _tmp78_;
			}
			_tmp79_ = cmdline;
			_tmp80_ = output;
			_tmp81_ = g_shell_quote (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = g_strconcat (" -o ", _tmp82_, NULL);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strconcat (_tmp79_, _tmp84_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp85_;
			_g_free0 (_tmp84_);
			_g_free0 (_tmp82_);
			_g_free0 (output);
		}
	}
	_tmp86_ = context;
	_tmp87_ = vala_code_context_get_source_files (_tmp86_);
	source_files = _tmp87_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp88_;
		ValaList* _tmp89_;
		gint _file_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _file_index = 0;
		_tmp88_ = source_files;
		_tmp89_ = _vala_iterable_ref0 (_tmp88_);
		_file_list = _tmp89_;
		_tmp90_ = _file_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_file_size = _tmp92_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp96_;
			gint _tmp97_;
			gpointer _tmp98_;
			ValaSourceFile* _tmp99_;
			ValaSourceFileType _tmp100_;
			ValaSourceFileType _tmp101_;
			_tmp93_ = _file_index;
			_file_index = _tmp93_ + 1;
			_tmp94_ = _file_index;
			_tmp95_ = _file_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _file_list;
			_tmp97_ = _file_index;
			_tmp98_ = vala_list_get (_tmp96_, _tmp97_);
			file = (ValaSourceFile*) _tmp98_;
			_tmp99_ = file;
			_tmp100_ = vala_source_file_get_file_type (_tmp99_);
			_tmp101_ = _tmp100_;
			if (_tmp101_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp102_;
				ValaSourceFile* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				_tmp102_ = cmdline;
				_tmp103_ = file;
				_tmp104_ = vala_source_file_get_csource_filename (_tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = g_shell_quote (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp108_ = g_strconcat (" ", _tmp107_, NULL);
				_tmp109_ = _tmp108_;
				_tmp110_ = g_strconcat (_tmp102_, _tmp109_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp110_;
				_g_free0 (_tmp109_);
				_g_free0 (_tmp107_);
				_g_free0 (_tmp105_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp111_ = context;
	_tmp112_ = vala_code_context_get_c_source_files (_tmp111_);
	c_source_files = _tmp112_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp113_;
		ValaList* _tmp114_;
		gint _file_size = 0;
		ValaList* _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		gint _file_index = 0;
		_tmp113_ = c_source_files;
		_tmp114_ = _vala_iterable_ref0 (_tmp113_);
		_file_list = _tmp114_;
		_tmp115_ = _file_list;
		_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
		_tmp117_ = _tmp116_;
		_file_size = _tmp117_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			gchar* file = NULL;
			ValaList* _tmp121_;
			gint _tmp122_;
			gpointer _tmp123_;
			const gchar* _tmp124_;
			const gchar* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			_tmp118_ = _file_index;
			_file_index = _tmp118_ + 1;
			_tmp119_ = _file_index;
			_tmp120_ = _file_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _file_list;
			_tmp122_ = _file_index;
			_tmp123_ = vala_list_get (_tmp121_, _tmp122_);
			file = (gchar*) _tmp123_;
			_tmp124_ = cmdline;
			_tmp125_ = file;
			_tmp126_ = g_shell_quote (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = g_strconcat (" ", _tmp127_, NULL);
			_tmp129_ = _tmp128_;
			_tmp130_ = g_strconcat (_tmp124_, _tmp129_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp130_;
			_g_free0 (_tmp129_);
			_g_free0 (_tmp127_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp131_ = cmdline;
	_tmp132_ = pkgflags;
	_tmp133_ = string_strip (_tmp132_);
	_tmp134_ = _tmp133_;
	_tmp135_ = g_strconcat (" ", _tmp134_, NULL);
	_tmp136_ = _tmp135_;
	_tmp137_ = g_strconcat (_tmp131_, _tmp136_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp137_;
	_g_free0 (_tmp136_);
	_g_free0 (_tmp134_);
	_tmp138_ = cc_options;
	_tmp138__length1 = cc_options_length1;
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = _tmp138_;
		cc_option_collection_length1 = _tmp138__length1;
		for (cc_option_it = 0; cc_option_it < _tmp138__length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp139_;
			gchar* cc_option = NULL;
			_tmp139_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp139_;
			{
				const gchar* _tmp140_;
				const gchar* _tmp141_;
				gchar* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				_tmp140_ = cmdline;
				_tmp141_ = cc_option;
				_tmp142_ = g_shell_quote (_tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = g_strconcat (" ", _tmp143_, NULL);
				_tmp145_ = _tmp144_;
				_tmp146_ = g_strconcat (_tmp140_, _tmp145_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp146_;
				_g_free0 (_tmp145_);
				_g_free0 (_tmp143_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp147_ = context;
	_tmp148_ = vala_code_context_get_verbose_mode (_tmp147_);
	_tmp149_ = _tmp148_;
	if (_tmp149_) {
		FILE* _tmp150_;
		const gchar* _tmp151_;
		_tmp150_ = stdout;
		_tmp151_ = cmdline;
		fprintf (_tmp150_, "%s\n", _tmp151_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp152_;
		gint _tmp153_ = 0;
		gint _tmp154_;
		_tmp152_ = cmdline;
		g_spawn_command_line_sync (_tmp152_, NULL, NULL, &_tmp153_, &_inner_error_);
		exit_status = _tmp153_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp154_ = exit_status;
		if (_tmp154_ != 0) {
			gint _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			_tmp155_ = exit_status;
			_tmp156_ = g_strdup_printf ("cc exited with status %d", _tmp155_);
			_tmp157_ = _tmp156_;
			vala_report_error (NULL, _tmp157_);
			_g_free0 (_tmp157_);
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp158_;
		const gchar* _tmp159_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp158_ = e;
		_tmp159_ = _tmp158_->message;
		vala_report_error (NULL, _tmp159_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp160_;
		ValaList* _tmp161_;
		gint _file_size = 0;
		ValaList* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		gint _file_index = 0;
		_tmp160_ = source_files;
		_tmp161_ = _vala_iterable_ref0 (_tmp160_);
		_file_list = _tmp161_;
		_tmp162_ = _file_list;
		_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
		_tmp164_ = _tmp163_;
		_file_size = _tmp164_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp165_;
			gint _tmp166_;
			gint _tmp167_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp168_;
			gint _tmp169_;
			gpointer _tmp170_;
			ValaSourceFile* _tmp171_;
			ValaSourceFileType _tmp172_;
			ValaSourceFileType _tmp173_;
			_tmp165_ = _file_index;
			_file_index = _tmp165_ + 1;
			_tmp166_ = _file_index;
			_tmp167_ = _file_size;
			if (!(_tmp166_ < _tmp167_)) {
				break;
			}
			_tmp168_ = _file_list;
			_tmp169_ = _file_index;
			_tmp170_ = vala_list_get (_tmp168_, _tmp169_);
			file = (ValaSourceFile*) _tmp170_;
			_tmp171_ = file;
			_tmp172_ = vala_source_file_get_file_type (_tmp171_);
			_tmp173_ = _tmp172_;
			if (_tmp173_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaCodeContext* _tmp174_;
				gboolean _tmp175_;
				gboolean _tmp176_;
				_tmp174_ = context;
				_tmp175_ = vala_code_context_get_save_csources (_tmp174_);
				_tmp176_ = _tmp175_;
				if (!_tmp176_) {
					ValaSourceFile* _tmp177_;
					gchar* _tmp178_;
					gchar* _tmp179_;
					_tmp177_ = file;
					_tmp178_ = vala_source_file_get_csource_filename (_tmp177_);
					_tmp179_ = _tmp178_;
					g_unlink (_tmp179_);
					_g_free0 (_tmp179_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void vala_value_ccode_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_ccode_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_ccode_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_ccode_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_ccode_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_ccode_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_ccode_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void vala_value_take_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass) {
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}


static void vala_ccode_compiler_instance_init (ValaCCodeCompiler * self) {
	self->ref_count = 1;
}


static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj) {
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}


/**
 * Interface to the C compiler.
 */
GType vala_ccode_compiler_get_type (void) {
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer vala_ccode_compiler_ref (gpointer instance) {
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_ccode_compiler_unref (gpointer instance) {
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



