/* math-display.c generated by valac 0.36.4, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <atk/atk.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	HistoryView* history;
	GtkSourceView* source_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_name) (CompletionProvider* self);
	GtkSourceCompletionItem* (*create_proposal) (CompletionProvider* self, const gchar* label, const gchar* text, const gchar* details);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	gboolean (*activate_proposal) (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	void (*populate) (CompletionProvider* self, GtkSourceCompletionContext* context);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};


static gpointer math_display_parent_class = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static gpointer variable_completion_provider_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType history_view_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
enum  {
	MATH_DISPLAY_DUMMY_PROPERTY,
	MATH_DISPLAY_EQUATION
};
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
void math_display_handler (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base);
static void _math_display_handler_math_equation_history_signal (MathEquation* _sender, const gchar* answer, Number* number, gint number_base, guint representation_base, gpointer self);
HistoryView* history_view_new (void);
HistoryView* history_view_construct (GType object_type);
static void __lambda6_ (MathDisplay* self, const gchar* ans);
void math_display_insert_text (MathDisplay* self, const gchar* answer);
static void ___lambda6__history_view_answer_clicked (HistoryView* _sender, const gchar* ans, gpointer self);
static void __lambda7_ (MathDisplay* self, const gchar* eq);
void math_display_display_text (MathDisplay* self, const gchar* prev_eq);
static void ___lambda7__history_view_equation_clicked (HistoryView* _sender, const gchar* equation, gpointer self);
static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void math_display_create_autocompletion (MathDisplay* self);
static void __lambda8_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda9_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void math_display_grabfocus (MathDisplay* self);
void math_display_update_history (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base);
void history_view_insert_entry (HistoryView* self, const gchar* equation, Number* answer, gint number_base, guint representation_base);
FunctionCompletionProvider* function_completion_provider_new (void);
FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
GType completion_provider_get_type (void) G_GNUC_CONST;
GType function_completion_provider_get_type (void) G_GNUC_CONST;
MathEquation* math_display_get_equation (MathDisplay* self);
VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation);
GType variable_completion_provider_get_type (void) G_GNUC_CONST;
static gboolean math_display_function_completion_window_visible (MathDisplay* self);
MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1);
gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1);
static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
void math_display_grab_focus (MathDisplay* self);
static void math_display_finalize (GObject * obj);
static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
gchar* completion_provider_get_name (CompletionProvider* self);
static gchar* completion_provider_real_get_name (CompletionProvider* self);
GtkSourceCompletionItem* completion_provider_create_proposal (CompletionProvider* self, const gchar* label, const gchar* text, const gchar* details);
static GtkSourceCompletionItem* completion_provider_real_create_proposal (CompletionProvider* self, const gchar* label, const gchar* text, const gchar* details);
void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
CompletionProvider* completion_provider_new (void);
CompletionProvider* completion_provider_construct (GType object_type);
enum  {
	FUNCTION_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* function_completion_provider_real_get_name (CompletionProvider* base);
static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderPrivate))
enum  {
	VARIABLE_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* variable_completion_provider_real_get_name (CompletionProvider* base);
static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
static void variable_completion_provider_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _math_display_handler_math_equation_history_signal (MathEquation* _sender, const gchar* answer, Number* number, gint number_base, guint representation_base, gpointer self) {
	math_display_handler ((MathDisplay*) self, answer, number, number_base, representation_base);
}


static void __lambda6_ (MathDisplay* self, const gchar* ans) {
	const gchar* _tmp0_;
	g_return_if_fail (ans != NULL);
	_tmp0_ = ans;
	math_display_insert_text (self, _tmp0_);
}


static void ___lambda6__history_view_answer_clicked (HistoryView* _sender, const gchar* ans, gpointer self) {
	__lambda6_ ((MathDisplay*) self, ans);
}


static void __lambda7_ (MathDisplay* self, const gchar* eq) {
	const gchar* _tmp0_;
	g_return_if_fail (eq != NULL);
	_tmp0_ = eq;
	math_display_display_text (self, _tmp0_);
}


static void ___lambda7__history_view_equation_clicked (HistoryView* _sender, const gchar* equation, gpointer self) {
	__lambda7_ ((MathDisplay*) self, equation);
}


static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, event);
	return result;
}


static void __lambda8_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}


static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda8_ ((MathDisplay*) self, pspec);
}


static void __lambda9_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}


static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda9_ ((MathDisplay*) self, pspec);
}


MathDisplay* math_display_construct (GType object_type, MathEquation* equation) {
	MathDisplay * self = NULL;
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp3_;
	HistoryView* _tmp4_;
	HistoryView* _tmp5_;
	HistoryView* _tmp6_;
	HistoryView* _tmp7_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp8_;
	MathEquation* _tmp9_;
	GtkSourceView* _tmp10_;
	GtkSourceView* _tmp11_;
	GtkSourceView* _tmp12_;
	GtkSourceView* _tmp13_;
	GtkSourceView* _tmp14_;
	GtkStyleContext* style_context = NULL;
	GtkSourceView* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkSourceView* _tmp18_;
	GtkSourceView* _tmp19_;
	GtkSourceView* _tmp20_;
	AtkObject* _tmp21_;
	GtkSourceView* _tmp22_;
	GtkSourceView* _tmp23_;
	GtkBox* info_box = NULL;
	GtkBox* _tmp24_;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkTextBuffer* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkStyleContext* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkSpinner* _tmp31_;
	GtkSpinner* _tmp32_;
	GtkSourceView* _tmp33_;
	MathEquation* _tmp34_;
	MathEquation* _tmp35_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	_tmp2_ = self->priv->_equation;
	g_signal_connect_object (_tmp2_, "history-signal", (GCallback) _math_display_handler_math_equation_history_signal, self, 0);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	main_box = _tmp3_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
	_tmp4_ = history_view_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp4_;
	_tmp5_ = self->priv->history;
	g_signal_connect_object (_tmp5_, "answer-clicked", (GCallback) ___lambda6__history_view_answer_clicked, self, 0);
	_tmp6_ = self->priv->history;
	g_signal_connect_object (_tmp6_, "equation-clicked", (GCallback) ___lambda7__history_view_equation_clicked, self, 0);
	_tmp7_ = self->priv->history;
	gtk_container_add ((GtkContainer*) main_box, (GtkWidget*) _tmp7_);
	gtk_widget_show_all ((GtkWidget*) main_box);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp8_);
	scrolled_window = _tmp8_;
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	_tmp9_ = equation;
	_tmp10_ = (GtkSourceView*) gtk_source_view_new_with_buffer ((GtkSourceBuffer*) _tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp10_;
	_tmp11_ = self->priv->source_view;
	gtk_text_view_set_accepts_tab ((GtkTextView*) _tmp11_, FALSE);
	_tmp12_ = self->priv->source_view;
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) _tmp12_, 8);
	_tmp13_ = self->priv->source_view;
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp13_, 2);
	_tmp14_ = self->priv->source_view;
	gtk_text_view_set_justification ((GtkTextView*) _tmp14_, GTK_JUSTIFY_LEFT);
	_tmp15_ = self->priv->source_view;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	style_context = _tmp17_;
	_tmp18_ = self->priv->source_view;
	gtk_buildable_set_name ((GtkBuildable*) _tmp18_, "displayitem");
	_tmp19_ = self->priv->source_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp19_, 20, 20);
	_tmp20_ = self->priv->source_view;
	_tmp21_ = gtk_widget_get_accessible ((GtkWidget*) _tmp20_);
	atk_object_set_role (_tmp21_, ATK_ROLE_EDITBAR);
	_tmp22_ = self->priv->source_view;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
	math_display_create_autocompletion (self);
	gtk_box_pack_start (main_box, (GtkWidget*) scrolled_window, FALSE, FALSE, (guint) 0);
	_tmp23_ = self->priv->source_view;
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp23_);
	gtk_widget_show ((GtkWidget*) scrolled_window);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp24_);
	info_box = _tmp24_;
	gtk_box_pack_start (main_box, (GtkWidget*) info_box, FALSE, TRUE, (guint) 0);
	_tmp25_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp25_);
	info_view = _tmp25_;
	gtk_text_view_set_wrap_mode (info_view, GTK_WRAP_WORD);
	gtk_widget_set_can_focus ((GtkWidget*) info_view, FALSE);
	gtk_text_view_set_editable (info_view, FALSE);
	gtk_box_pack_start (info_box, (GtkWidget*) info_view, TRUE, TRUE, (guint) 0);
	_tmp26_ = gtk_text_view_get_buffer (info_view);
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp27_;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) info_view);
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (style_context);
	style_context = _tmp29_;
	_tmp30_ = style_context;
	gtk_style_context_add_class (_tmp30_, "info-view");
	_tmp31_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp31_;
	_tmp32_ = self->priv->spinner;
	gtk_box_pack_end (info_box, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) info_box);
	gtk_widget_show ((GtkWidget*) info_view);
	_tmp33_ = self->priv->source_view;
	gtk_widget_show ((GtkWidget*) _tmp33_);
	gtk_widget_show ((GtkWidget*) main_box);
	_tmp34_ = equation;
	g_signal_connect_object ((GObject*) _tmp34_, "notify::status", (GCallback) ___lambda8__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	_tmp35_ = equation;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::error-token-end", (GCallback) ___lambda9__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	_g_object_unref0 (style_context);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (main_box);
	return self;
}


MathDisplay* math_display_new (MathEquation* equation) {
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}


void math_display_grabfocus (MathDisplay* self) {
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


void math_display_handler (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base) {
	const gchar* _tmp0_;
	Number* _tmp1_;
	gint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = answer;
	_tmp1_ = number;
	_tmp2_ = number_base;
	_tmp3_ = representation_base;
	math_display_update_history (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void math_display_display_text (MathDisplay* self, const gchar* prev_eq) {
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev_eq != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = prev_eq;
	math_equation_display_selected (_tmp0_, _tmp1_);
}


void math_display_update_history (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base) {
	HistoryView* _tmp0_;
	const gchar* _tmp1_;
	Number* _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = answer;
	_tmp2_ = number;
	_tmp3_ = number_base;
	_tmp4_ = representation_base;
	history_view_insert_entry (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


void math_display_insert_text (MathDisplay* self, const gchar* answer) {
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = answer;
	math_equation_insert_selected (_tmp0_, _tmp1_);
}


static void math_display_create_autocompletion (MathDisplay* self) {
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GtkSourceCompletion* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	{
		GtkSourceCompletion* _tmp3_;
		FunctionCompletionProvider* _tmp4_;
		FunctionCompletionProvider* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		MathEquation* _tmp7_;
		MathEquation* _tmp8_;
		VariableCompletionProvider* _tmp9_;
		VariableCompletionProvider* _tmp10_;
		_tmp3_ = completion;
		_tmp4_ = function_completion_provider_new ();
		_tmp5_ = _tmp4_;
		gtk_source_completion_add_provider (_tmp3_, (GtkSourceCompletionProvider*) _tmp5_, &_inner_error_);
		_g_object_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp6_ = completion;
		_tmp7_ = math_display_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = variable_completion_provider_new (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) _tmp10_, &_inner_error_);
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("math-display.vala:125: Could not add CompletionProvider to source-view");
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (completion);
}


static gboolean math_display_function_completion_window_visible (MathDisplay* self) {
	gboolean result = FALSE;
	GList* providers_list = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = gtk_source_completion_get_providers (_tmp1_);
	providers_list = _tmp2_;
	_tmp3_ = providers_list;
	_tmp4_ = g_list_length (_tmp3_);
	if (_tmp4_ > ((guint) 0)) {
		MathFunction** functions = NULL;
		MathEquation* _tmp5_;
		MathEquation* _tmp6_;
		gint _tmp7_;
		MathFunction** _tmp8_;
		gint functions_length1;
		gint _functions_size_;
		gchar** variables = NULL;
		MathEquation* _tmp9_;
		MathEquation* _tmp10_;
		MathEquation* _tmp11_;
		MathEquation* _tmp12_;
		MathVariables* _tmp13_;
		MathVariables* _tmp14_;
		gint _tmp15_;
		gchar** _tmp16_;
		gint variables_length1;
		gint _variables_size_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		MathFunction** _tmp19_;
		gint _tmp19__length1;
		_tmp5_ = math_display_get_equation (self);
		_tmp6_ = _tmp5_;
		_tmp8_ = function_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp6_, &_tmp7_);
		functions = _tmp8_;
		functions_length1 = _tmp7_;
		_functions_size_ = functions_length1;
		_tmp9_ = math_display_get_equation (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = math_display_get_equation (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = math_equation_get_variables (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp16_ = variable_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp10_, _tmp14_, &_tmp15_);
		variables = _tmp16_;
		variables_length1 = _tmp15_;
		_variables_size_ = variables_length1;
		_tmp19_ = functions;
		_tmp19__length1 = functions_length1;
		if (_tmp19__length1 > 0) {
			_tmp18_ = TRUE;
		} else {
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp20_ = variables;
			_tmp20__length1 = variables_length1;
			_tmp18_ = _tmp20__length1 > 0;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = FALSE;
		}
		result = _tmp17_;
		variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
		functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathDisplay * self;
	gboolean result = FALSE;
	GtkSourceView* _tmp0_;
	GdkEventKey* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (MathDisplay*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = event;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", _tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEventKey_copy0 (gpointer self) {
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}


static void _vala_GdkEventKey_free (GdkEventKey* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint new_keyval = 0U;
	GdkEventKey* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GdkModifierType state = 0;
	GdkEventKey* _tmp9_;
	GdkModifierType _tmp10_;
	guint32 c = 0U;
	GdkEventKey* _tmp11_;
	guint _tmp12_;
	guint32 _tmp13_;
	gboolean _tmp14_ = FALSE;
	GdkEventKey* _tmp15_;
	guint _tmp16_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GdkEventKey* _tmp24_;
	guint _tmp25_;
	gboolean _tmp33_ = FALSE;
	GdkEventKey* _tmp34_;
	guint _tmp35_;
	GdkModifierType _tmp40_;
	GdkModifierType _tmp50_;
	GdkModifierType _tmp73_;
	gboolean _tmp80_ = FALSE;
	GdkModifierType _tmp81_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	new_keyval = (guint) 0;
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	switch (_tmp1_) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = (guint) GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = (guint) GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = (guint) GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = (guint) GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = (guint) GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = (guint) GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = (guint) GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = (guint) GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = (guint) GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = (guint) GDK_KEY_9;
			break;
		}
		case GDK_KEY_KP_Delete:
		{
			new_keyval = (guint) GDK_KEY_period;
			break;
		}
		default:
		break;
	}
	_tmp2_ = new_keyval;
	if (_tmp2_ != ((guint) 0)) {
		GdkEventKey* new_event = NULL;
		GdkEventKey* _tmp3_;
		GdkEventKey* _tmp4_;
		GdkEventKey* _tmp5_;
		guint _tmp6_;
		GdkEventKey* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = event;
		_tmp4_ = __vala_GdkEventKey_copy0 (_tmp3_);
		new_event = _tmp4_;
		_tmp5_ = new_event;
		_tmp6_ = new_keyval;
		_tmp5_->keyval = _tmp6_;
		_tmp7_ = new_event;
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", _tmp7_, &_tmp8_);
		result = _tmp8_;
		__vala_GdkEventKey_free0 (new_event);
		return result;
	}
	_tmp9_ = event;
	_tmp10_ = _tmp9_->state;
	state = _tmp10_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
	_tmp11_ = event;
	_tmp12_ = _tmp11_->keyval;
	_tmp13_ = gdk_keyval_to_unicode (_tmp12_);
	c = _tmp13_;
	_tmp15_ = event;
	_tmp16_ = _tmp15_->keyval;
	if (_tmp16_ == ((guint) GDK_KEY_Return)) {
		_tmp14_ = TRUE;
	} else {
		GdkEventKey* _tmp17_;
		guint _tmp18_;
		_tmp17_ = event;
		_tmp18_ = _tmp17_->keyval;
		_tmp14_ = _tmp18_ == ((guint) GDK_KEY_KP_Enter);
	}
	if (_tmp14_) {
		gboolean _tmp19_;
		MathEquation* _tmp20_;
		MathEquation* _tmp21_;
		_tmp19_ = math_display_function_completion_window_visible (self);
		if (_tmp19_) {
			result = FALSE;
			return result;
		}
		_tmp20_ = math_display_get_equation (self);
		_tmp21_ = _tmp20_;
		math_equation_solve (_tmp21_);
		result = TRUE;
		return result;
	}
	_tmp24_ = event;
	_tmp25_ = _tmp24_->keyval;
	if (_tmp25_ == ((guint) GDK_KEY_Escape)) {
		GdkModifierType _tmp26_;
		_tmp26_ = state;
		_tmp23_ = _tmp26_ == 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		GdkEventKey* _tmp28_;
		guint _tmp29_;
		_tmp28_ = event;
		_tmp29_ = _tmp28_->keyval;
		if (_tmp29_ == ((guint) GDK_KEY_Delete)) {
			GdkModifierType _tmp30_;
			_tmp30_ = state;
			_tmp27_ = _tmp30_ == GDK_SHIFT_MASK;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp22_ = _tmp27_;
	}
	if (_tmp22_) {
		MathEquation* _tmp31_;
		MathEquation* _tmp32_;
		_tmp31_ = math_display_get_equation (self);
		_tmp32_ = _tmp31_;
		math_equation_clear (_tmp32_);
		result = TRUE;
		return result;
	}
	_tmp34_ = event;
	_tmp35_ = _tmp34_->keyval;
	if (_tmp35_ == ((guint) GDK_KEY_KP_Decimal)) {
		_tmp33_ = TRUE;
	} else {
		GdkEventKey* _tmp36_;
		guint _tmp37_;
		_tmp36_ = event;
		_tmp37_ = _tmp36_->keyval;
		_tmp33_ = _tmp37_ == ((guint) GDK_KEY_KP_Separator);
	}
	if (_tmp33_) {
		MathEquation* _tmp38_;
		MathEquation* _tmp39_;
		_tmp38_ = math_display_get_equation (self);
		_tmp39_ = _tmp38_;
		math_equation_insert_numeric_point (_tmp39_);
		result = TRUE;
		return result;
	}
	_tmp40_ = state;
	if (_tmp40_ == 0) {
		guint32 _tmp41_;
		guint32 _tmp44_;
		guint32 _tmp47_;
		_tmp41_ = c;
		if (_tmp41_ == ((guint32) '*')) {
			MathEquation* _tmp42_;
			MathEquation* _tmp43_;
			_tmp42_ = math_display_get_equation (self);
			_tmp43_ = _tmp42_;
			math_equation_insert (_tmp43_, "×");
			result = TRUE;
			return result;
		}
		_tmp44_ = c;
		if (_tmp44_ == ((guint32) '/')) {
			MathEquation* _tmp45_;
			MathEquation* _tmp46_;
			_tmp45_ = math_display_get_equation (self);
			_tmp46_ = _tmp45_;
			math_equation_insert (_tmp46_, "÷");
			result = TRUE;
			return result;
		}
		_tmp47_ = c;
		if (_tmp47_ == ((guint32) '-')) {
			MathEquation* _tmp48_;
			MathEquation* _tmp49_;
			_tmp48_ = math_display_get_equation (self);
			_tmp49_ = _tmp48_;
			math_equation_insert_subtract (_tmp49_);
			result = TRUE;
			return result;
		}
	}
	_tmp50_ = state;
	if (_tmp50_ == GDK_CONTROL_MASK) {
		GdkEventKey* _tmp51_;
		guint _tmp52_;
		_tmp51_ = event;
		_tmp52_ = _tmp51_->keyval;
		switch (_tmp52_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp53_;
				MathEquation* _tmp54_;
				_tmp53_ = math_display_get_equation (self);
				_tmp54_ = _tmp53_;
				math_equation_insert (_tmp54_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp55_;
				MathEquation* _tmp56_;
				_tmp55_ = math_display_get_equation (self);
				_tmp56_ = _tmp55_;
				math_equation_insert (_tmp56_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp57_;
				MathEquation* _tmp58_;
				_tmp57_ = math_display_get_equation (self);
				_tmp58_ = _tmp57_;
				math_equation_insert_exponent (_tmp58_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp59_;
				MathEquation* _tmp60_;
				_tmp59_ = math_display_get_equation (self);
				_tmp60_ = _tmp59_;
				math_equation_factorize (_tmp60_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp61_;
				MathEquation* _tmp62_;
				_tmp61_ = math_display_get_equation (self);
				_tmp62_ = _tmp61_;
				math_equation_insert (_tmp62_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp63_;
				MathEquation* _tmp64_;
				_tmp63_ = math_display_get_equation (self);
				_tmp64_ = _tmp63_;
				math_equation_insert (_tmp64_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp65_;
				MathEquation* _tmp66_;
				_tmp65_ = math_display_get_equation (self);
				_tmp66_ = _tmp65_;
				math_equation_insert (_tmp66_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp67_;
				MathEquation* _tmp68_;
				_tmp67_ = math_display_get_equation (self);
				_tmp68_ = _tmp67_;
				math_equation_insert (_tmp68_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp69_;
				MathEquation* _tmp70_;
				_tmp69_ = math_display_get_equation (self);
				_tmp70_ = _tmp69_;
				math_equation_insert (_tmp70_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp71_;
				MathEquation* _tmp72_;
				_tmp71_ = math_display_get_equation (self);
				_tmp72_ = _tmp71_;
				math_equation_insert (_tmp72_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp73_ = state;
	if (_tmp73_ == GDK_MOD1_MASK) {
		GdkEventKey* _tmp74_;
		guint _tmp75_;
		_tmp74_ = event;
		_tmp75_ = _tmp74_->keyval;
		switch (_tmp75_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp76_;
				MathEquation* _tmp77_;
				_tmp76_ = math_display_get_equation (self);
				_tmp77_ = _tmp76_;
				math_equation_insert (_tmp77_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp78_;
				MathEquation* _tmp79_;
				_tmp78_ = math_display_get_equation (self);
				_tmp79_ = _tmp78_;
				math_equation_insert (_tmp79_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp81_ = state;
	if (_tmp81_ == GDK_CONTROL_MASK) {
		_tmp80_ = TRUE;
	} else {
		MathEquation* _tmp82_;
		MathEquation* _tmp83_;
		NumberMode _tmp84_;
		NumberMode _tmp85_;
		_tmp82_ = math_display_get_equation (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = math_equation_get_number_mode (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp80_ = _tmp85_ == NUMBER_MODE_SUPERSCRIPT;
	}
	if (_tmp80_) {
		MathEquation* _tmp86_;
		MathEquation* _tmp87_;
		gboolean _tmp88_;
		gboolean _tmp89_;
		GdkEventKey* _tmp92_;
		guint _tmp93_;
		_tmp86_ = math_display_get_equation (self);
		_tmp87_ = _tmp86_;
		_tmp88_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp87_);
		_tmp89_ = _tmp88_;
		if (!_tmp89_) {
			MathEquation* _tmp90_;
			MathEquation* _tmp91_;
			_tmp90_ = math_display_get_equation (self);
			_tmp91_ = _tmp90_;
			math_equation_remove_trailing_spaces (_tmp91_);
		}
		_tmp92_ = event;
		_tmp93_ = _tmp92_->keyval;
		switch (_tmp93_) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp94_;
				MathEquation* _tmp95_;
				_tmp94_ = math_display_get_equation (self);
				_tmp95_ = _tmp94_;
				math_equation_insert (_tmp95_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp96_;
				MathEquation* _tmp97_;
				_tmp96_ = math_display_get_equation (self);
				_tmp97_ = _tmp96_;
				math_equation_insert (_tmp97_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp98_;
				MathEquation* _tmp99_;
				_tmp98_ = math_display_get_equation (self);
				_tmp99_ = _tmp98_;
				math_equation_insert (_tmp99_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp100_;
				MathEquation* _tmp101_;
				_tmp100_ = math_display_get_equation (self);
				_tmp101_ = _tmp100_;
				math_equation_insert (_tmp101_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp102_;
				MathEquation* _tmp103_;
				_tmp102_ = math_display_get_equation (self);
				_tmp103_ = _tmp102_;
				math_equation_insert (_tmp103_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp104_;
				MathEquation* _tmp105_;
				_tmp104_ = math_display_get_equation (self);
				_tmp105_ = _tmp104_;
				math_equation_insert (_tmp105_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp106_;
				MathEquation* _tmp107_;
				_tmp106_ = math_display_get_equation (self);
				_tmp107_ = _tmp106_;
				math_equation_insert (_tmp107_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp108_;
				MathEquation* _tmp109_;
				_tmp108_ = math_display_get_equation (self);
				_tmp109_ = _tmp108_;
				math_equation_insert (_tmp109_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp110_;
				MathEquation* _tmp111_;
				_tmp110_ = math_display_get_equation (self);
				_tmp111_ = _tmp110_;
				math_equation_insert (_tmp111_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp112_;
				MathEquation* _tmp113_;
				_tmp112_ = math_display_get_equation (self);
				_tmp113_ = _tmp112_;
				math_equation_insert (_tmp113_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp114_ = FALSE;
		GdkModifierType _tmp115_;
		_tmp115_ = state;
		if (_tmp115_ == GDK_MOD1_MASK) {
			_tmp114_ = TRUE;
		} else {
			MathEquation* _tmp116_;
			MathEquation* _tmp117_;
			NumberMode _tmp118_;
			NumberMode _tmp119_;
			_tmp116_ = math_display_get_equation (self);
			_tmp117_ = _tmp116_;
			_tmp118_ = math_equation_get_number_mode (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp114_ = _tmp119_ == NUMBER_MODE_SUBSCRIPT;
		}
		if (_tmp114_) {
			MathEquation* _tmp120_;
			MathEquation* _tmp121_;
			gboolean _tmp122_;
			gboolean _tmp123_;
			GdkEventKey* _tmp126_;
			guint _tmp127_;
			_tmp120_ = math_display_get_equation (self);
			_tmp121_ = _tmp120_;
			_tmp122_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp121_);
			_tmp123_ = _tmp122_;
			if (!_tmp123_) {
				MathEquation* _tmp124_;
				MathEquation* _tmp125_;
				_tmp124_ = math_display_get_equation (self);
				_tmp125_ = _tmp124_;
				math_equation_remove_trailing_spaces (_tmp125_);
			}
			_tmp126_ = event;
			_tmp127_ = _tmp126_->keyval;
			switch (_tmp127_) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp128_;
					MathEquation* _tmp129_;
					_tmp128_ = math_display_get_equation (self);
					_tmp129_ = _tmp128_;
					math_equation_insert (_tmp129_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp130_;
					MathEquation* _tmp131_;
					_tmp130_ = math_display_get_equation (self);
					_tmp131_ = _tmp130_;
					math_equation_insert (_tmp131_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp132_;
					MathEquation* _tmp133_;
					_tmp132_ = math_display_get_equation (self);
					_tmp133_ = _tmp132_;
					math_equation_insert (_tmp133_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp134_;
					MathEquation* _tmp135_;
					_tmp134_ = math_display_get_equation (self);
					_tmp135_ = _tmp134_;
					math_equation_insert (_tmp135_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp136_;
					MathEquation* _tmp137_;
					_tmp136_ = math_display_get_equation (self);
					_tmp137_ = _tmp136_;
					math_equation_insert (_tmp137_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp138_;
					MathEquation* _tmp139_;
					_tmp138_ = math_display_get_equation (self);
					_tmp139_ = _tmp138_;
					math_equation_insert (_tmp139_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp140_;
					MathEquation* _tmp141_;
					_tmp140_ = math_display_get_equation (self);
					_tmp141_ = _tmp140_;
					math_equation_insert (_tmp141_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp142_;
					MathEquation* _tmp143_;
					_tmp142_ = math_display_get_equation (self);
					_tmp143_ = _tmp142_;
					math_equation_insert (_tmp143_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp144_;
					MathEquation* _tmp145_;
					_tmp144_ = math_display_get_equation (self);
					_tmp145_ = _tmp144_;
					math_equation_insert (_tmp145_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp146_;
					MathEquation* _tmp147_;
					_tmp146_ = math_display_get_equation (self);
					_tmp147_ = _tmp146_;
					math_equation_insert (_tmp147_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void math_display_status_changed_cb (MathDisplay* self) {
	GtkTextBuffer* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_;
	MathEquation* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = self->priv->spinner;
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkSpinner* _tmp13_;
		GtkSpinner* _tmp14_;
		_tmp13_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->spinner;
		gtk_spinner_start (_tmp14_);
	} else {
		gboolean _tmp15_ = FALSE;
		MathEquation* _tmp16_;
		MathEquation* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp16_ = math_display_get_equation (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = math_equation_get_in_solve (_tmp17_);
		_tmp19_ = _tmp18_;
		if (!_tmp19_) {
			GtkSpinner* _tmp20_;
			gboolean _tmp21_;
			_tmp20_ = self->priv->spinner;
			_tmp21_ = gtk_widget_get_visible ((GtkWidget*) _tmp20_);
			_tmp15_ = _tmp21_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GtkSpinner* _tmp22_;
			GtkSpinner* _tmp23_;
			_tmp22_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->spinner;
			gtk_spinner_stop (_tmp23_);
		}
	}
}


static void math_display_error_status_changed_cb (MathDisplay* self) {
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	MathEquation* _tmp4_;
	MathEquation* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_;
	MathEquation* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_;
	MathEquation* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_;
	MathEquation* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	MathEquation* _tmp18_;
	MathEquation* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	MathEquation* _tmp22_;
	MathEquation* _tmp23_;
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}


void math_display_grab_focus (MathDisplay* self) {
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


MathEquation* math_display_get_equation (MathDisplay* self) {
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static void math_display_class_init (MathDisplayClass * klass) {
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) math_display_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_display_instance_init (MathDisplay * self) {
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
}


static void math_display_finalize (GObject * obj) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->source_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}


GType math_display_get_type (void) {
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (gtk_viewport_get_type (), "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gchar* completion_provider_real_get_name (CompletionProvider* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


gchar* completion_provider_get_name (CompletionProvider* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_name (self);
}


static GtkSourceCompletionItem* completion_provider_real_create_proposal (CompletionProvider* self, const gchar* label, const gchar* text, const gchar* details) {
	GtkSourceCompletionItem* result = NULL;
	GtkSourceCompletionItem* proposal = NULL;
	GtkSourceCompletionItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (details != NULL, NULL);
	_tmp0_ = gtk_source_completion_item_new2 ();
	proposal = _tmp0_;
	_tmp1_ = label;
	g_object_set (proposal, "label", _tmp1_, NULL);
	_tmp2_ = text;
	g_object_set (proposal, "text", _tmp2_, NULL);
	_tmp3_ = details;
	g_object_set (proposal, "info", _tmp3_, NULL);
	result = proposal;
	return result;
}


GtkSourceCompletionItem* completion_provider_create_proposal (CompletionProvider* self, const gchar* label, const gchar* text, const gchar* details) {
	g_return_val_if_fail (self != NULL, NULL);
	return COMPLETION_PROVIDER_GET_CLASS (self)->create_proposal (self, label, text, details);
}


void completion_provider_move_iter_to_name_start (GtkTextIter* iter) {
	g_return_if_fail (iter != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gunichar current_char = 0U;
		gunichar _tmp1_;
		gunichar _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = gtk_text_iter_backward_char (iter);
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = gtk_text_iter_get_char (iter);
		current_char = _tmp1_;
		_tmp2_ = current_char;
		_tmp3_ = g_unichar_isalpha (_tmp2_);
		if (!_tmp3_) {
			gtk_text_iter_forward_char (iter);
			break;
		}
	}
}


static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_start_iter (self, context, proposal, iter);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	gboolean result = FALSE;
	gchar* proposed_string = NULL;
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter start_iter = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_;
	gint _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextIter _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextBuffer* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	proposed_string = _tmp1_;
	_tmp2_ = gtk_text_iter_get_buffer (iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	_tmp5_ = gtk_text_iter_get_offset (iter);
	gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp6_, _tmp5_);
	start_iter = _tmp6_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp7_ = buffer;
	_tmp8_ = start_iter;
	gtk_text_buffer_place_cursor (_tmp7_, &_tmp8_);
	_tmp9_ = buffer;
	_tmp10_ = start_iter;
	_tmp11_ = *iter;
	g_signal_emit_by_name (_tmp9_, "delete-range", &_tmp10_, &_tmp11_);
	_tmp12_ = buffer;
	_tmp13_ = proposed_string;
	_tmp14_ = proposed_string;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_text_buffer_insert_at_cursor (_tmp12_, _tmp13_, _tmp16_);
	_tmp17_ = proposed_string;
	_tmp18_ = string_contains (_tmp17_, "()");
	if (_tmp18_) {
		GtkTextBuffer* _tmp19_;
		GtkTextBuffer* _tmp20_;
		GtkTextMark* _tmp21_;
		GtkTextIter _tmp22_ = {0};
		GtkTextBuffer* _tmp23_;
		GtkTextIter _tmp24_;
		_tmp19_ = buffer;
		_tmp20_ = buffer;
		_tmp21_ = gtk_text_buffer_get_insert (_tmp20_);
		gtk_text_buffer_get_iter_at_mark (_tmp19_, &_tmp22_, _tmp21_);
		end = _tmp22_;
		gtk_text_iter_backward_chars (&end, 1);
		_tmp23_ = buffer;
		_tmp24_ = end;
		gtk_text_buffer_place_cursor (_tmp23_, &_tmp24_);
	}
	result = TRUE;
	_g_object_unref0 (buffer);
	_g_free0 (proposed_string);
	return result;
}


gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->activate_proposal (self, proposal, iter);
}


static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
	g_return_if_fail (context != NULL);
}


void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
	g_return_if_fail (self != NULL);
	COMPLETION_PROVIDER_GET_CLASS (self)->populate (self, context);
}


CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	return self;
}


CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_name = (gchar* (*) (CompletionProvider *)) completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->create_proposal = (GtkSourceCompletionItem* (*) (CompletionProvider *, const gchar*, const gchar*, const gchar*)) completion_provider_real_create_proposal;
	((CompletionProviderClass *) klass)->get_start_iter = (gboolean (*) (CompletionProvider *, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
	((CompletionProviderClass *) klass)->activate_proposal = (gboolean (*) (CompletionProvider *, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
	((CompletionProviderClass *) klass)->populate = (void (*) (CompletionProvider *, GtkSourceCompletionContext*)) completion_provider_real_populate;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider *)) completion_provider_get_name;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_get_start_iter;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_activate_proposal;
	iface->populate = (void (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*)) completion_provider_populate;
}


static void completion_provider_instance_init (CompletionProvider * self) {
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gchar* function_completion_provider_real_get_name (CompletionProvider* base) {
	FunctionCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (FunctionCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Functions");
	result = _tmp0_;
	return result;
}


MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1) {
	MathFunction** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	gchar* _tmp11_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp12_;
	MathFunction** functions = NULL;
	gint _tmp13_;
	MathFunction** _tmp14_;
	gint functions_length1;
	gint _functions_size_;
	MathFunction** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	_tmp0_ = text_buffer;
	_tmp1_ = text_buffer;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = text_buffer;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	start_iter = _tmp7_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp8_ = text_buffer;
	_tmp9_ = start_iter;
	_tmp10_ = end_iter;
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
	search_pattern = _tmp11_;
	_tmp12_ = function_manager_get_default_function_manager ();
	function_manager = _tmp12_;
	_tmp14_ = function_manager_functions_eligible_for_autocompletion_for_text (function_manager, search_pattern, &_tmp13_);
	functions = _tmp14_;
	functions_length1 = _tmp13_;
	_functions_size_ = functions_length1;
	_tmp15_ = functions;
	_tmp15__length1 = functions_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_object_unref0 (function_manager);
	_g_free0 (search_pattern);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	FunctionCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	MathFunction** functions = NULL;
	GtkTextBuffer* _tmp5_;
	gint _tmp6_;
	MathFunction** _tmp7_;
	gint functions_length1;
	gint _functions_size_;
	GList* proposals = NULL;
	MathFunction** _tmp8_;
	gint _tmp8__length1;
	GtkSourceCompletionContext* _tmp50_;
	GList* _tmp51_;
	self = (FunctionCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = gtk_text_iter_get_buffer (&iter1);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	text_buffer = _tmp4_;
	_tmp5_ = text_buffer;
	_tmp7_ = function_completion_provider_get_matches_for_completion_at_cursor (_tmp5_, &_tmp6_);
	functions = _tmp7_;
	functions_length1 = _tmp6_;
	_functions_size_ = functions_length1;
	proposals = NULL;
	_tmp8_ = functions;
	_tmp8__length1 = functions_length1;
	if (_tmp8__length1 > 0) {
		MathFunction** _tmp9_;
		gint _tmp9__length1;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp9_ = functions;
		_tmp9__length1 = functions_length1;
		{
			MathFunction** function_collection = NULL;
			gint function_collection_length1 = 0;
			gint _function_collection_size_ = 0;
			gint function_it = 0;
			function_collection = _tmp9_;
			function_collection_length1 = _tmp9__length1;
			for (function_it = 0; function_it < _tmp9__length1; function_it = function_it + 1) {
				MathFunction* _tmp10_;
				MathFunction* function = NULL;
				_tmp10_ = _g_object_ref0 (function_collection[function_it]);
				function = _tmp10_;
				{
					gchar* display_text = NULL;
					MathFunction* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					MathFunction* _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gchar** _tmp16_;
					gint _tmp16__length1;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* details_text = NULL;
					MathFunction* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* label_text = NULL;
					MathFunction* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					MathFunction* _tmp29_;
					gboolean _tmp30_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					GtkSourceCompletionItem* _tmp49_;
					_tmp11_ = function;
					_tmp12_ = math_function_get_name (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = function;
					_tmp15_ = math_function_get_arguments (_tmp14_, &_tmp15__length1);
					_tmp16_ = _tmp15_;
					_tmp16__length1 = _tmp15__length1;
					_tmp17_ = _vala_g_strjoinv (";", _tmp16_, _tmp16__length1);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strdup_printf ("%s(%s)", _tmp13_, _tmp18_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					display_text = _tmp20_;
					_tmp21_ = function;
					_tmp22_ = math_function_get_description (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup_printf ("%s", _tmp23_);
					details_text = _tmp24_;
					_tmp25_ = function;
					_tmp26_ = math_function_get_name (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strconcat (_tmp27_, "()", NULL);
					label_text = _tmp28_;
					_tmp29_ = function;
					_tmp30_ = math_function_is_custom_function (_tmp29_);
					if (_tmp30_) {
						MathFunction* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						MathFunction* _tmp34_;
						gchar** _tmp35_;
						gint _tmp35__length1;
						gchar** _tmp36_;
						gint _tmp36__length1;
						gchar* _tmp37_;
						gchar* _tmp38_;
						MathFunction* _tmp39_;
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						MathFunction* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp31_ = function;
						_tmp32_ = math_function_get_name (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = function;
						_tmp35_ = math_function_get_arguments (_tmp34_, &_tmp35__length1);
						_tmp36_ = _tmp35_;
						_tmp36__length1 = _tmp35__length1;
						_tmp37_ = _vala_g_strjoinv (";", _tmp36_, _tmp36__length1);
						_tmp38_ = _tmp37_;
						_tmp39_ = function;
						_tmp40_ = math_function_get_expression (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = function;
						_tmp43_ = math_function_get_description (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = g_strdup_printf ("%s(%s)=%s\n%s", _tmp33_, _tmp38_, _tmp41_, _tmp44_);
						_g_free0 (details_text);
						details_text = _tmp45_;
						_g_free0 (_tmp38_);
					}
					_tmp46_ = display_text;
					_tmp47_ = label_text;
					_tmp48_ = details_text;
					_tmp49_ = completion_provider_create_proposal ((CompletionProvider*) self, _tmp46_, _tmp47_, _tmp48_);
					proposals = g_list_append (proposals, _tmp49_);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_object_unref0 (function);
				}
			}
		}
	}
	_tmp50_ = context;
	_tmp51_ = proposals;
	gtk_source_completion_context_add_proposals (_tmp50_, (GtkSourceCompletionProvider*) self, _tmp51_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (text_buffer);
}


FunctionCompletionProvider* function_completion_provider_construct (GType object_type) {
	FunctionCompletionProvider * self = NULL;
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
	return self;
}


FunctionCompletionProvider* function_completion_provider_new (void) {
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
}


static void function_completion_provider_class_init (FunctionCompletionProviderClass * klass) {
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_name = (gchar* (*) (CompletionProvider *)) function_completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->populate = (void (*) (CompletionProvider *, GtkSourceCompletionContext*)) function_completion_provider_real_populate;
}


static void function_completion_provider_instance_init (FunctionCompletionProvider * self) {
}


GType function_completion_provider_get_type (void) {
	static volatile gsize function_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&function_completion_provider_type_id__volatile, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__volatile;
}


VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation) {
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	return self;
}


VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation) {
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
}


static gchar* variable_completion_provider_real_get_name (CompletionProvider* base) {
	VariableCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (VariableCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Variables");
	result = _tmp0_;
	return result;
}


gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1) {
	gchar** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	gchar* _tmp11_;
	gchar** math_variables = NULL;
	MathVariables* _tmp12_;
	gint _tmp13_;
	gchar** _tmp14_;
	gint math_variables_length1;
	gint _math_variables_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	_tmp0_ = text_buffer;
	_tmp1_ = text_buffer;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = text_buffer;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	start_iter = _tmp7_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp8_ = text_buffer;
	_tmp9_ = start_iter;
	_tmp10_ = end_iter;
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
	search_pattern = _tmp11_;
	_tmp12_ = variables;
	_tmp14_ = math_variables_variables_eligible_for_autocompletion (_tmp12_, search_pattern, &_tmp13_);
	math_variables = _tmp14_;
	math_variables_length1 = _tmp13_;
	_math_variables_size_ = math_variables_length1;
	_tmp15_ = math_variables;
	_tmp15__length1 = math_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (search_pattern);
	return result;
}


static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	VariableCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	gchar** variables = NULL;
	GtkTextBuffer* _tmp5_;
	MathEquation* _tmp6_;
	MathVariables* _tmp7_;
	MathVariables* _tmp8_;
	gint _tmp9_;
	gchar** _tmp10_;
	gint variables_length1;
	gint _variables_size_;
	GList* proposals = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GtkSourceCompletionContext* _tmp33_;
	GList* _tmp34_;
	self = (VariableCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = gtk_text_iter_get_buffer (&iter1);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	text_buffer = _tmp4_;
	_tmp5_ = text_buffer;
	_tmp6_ = self->priv->_equation;
	_tmp7_ = math_equation_get_variables (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp10_ = variable_completion_provider_get_matches_for_completion_at_cursor (_tmp5_, _tmp8_, &_tmp9_);
	variables = _tmp10_;
	variables_length1 = _tmp9_;
	_variables_size_ = variables_length1;
	proposals = NULL;
	_tmp11_ = variables;
	_tmp11__length1 = variables_length1;
	if (_tmp11__length1 > 0) {
		gchar** _tmp12_;
		gint _tmp12__length1;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp12_ = variables;
		_tmp12__length1 = variables_length1;
		{
			gchar** variable_collection = NULL;
			gint variable_collection_length1 = 0;
			gint _variable_collection_size_ = 0;
			gint variable_it = 0;
			variable_collection = _tmp12_;
			variable_collection_length1 = _tmp12__length1;
			for (variable_it = 0; variable_it < _tmp12__length1; variable_it = variable_it + 1) {
				gchar* _tmp13_;
				gchar* variable = NULL;
				_tmp13_ = g_strdup (variable_collection[variable_it]);
				variable = _tmp13_;
				{
					gchar* display_text = NULL;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* details_text = NULL;
					MathEquation* _tmp16_;
					Serializer* _tmp17_;
					Serializer* _tmp18_;
					MathEquation* _tmp19_;
					MathVariables* _tmp20_;
					MathVariables* _tmp21_;
					const gchar* _tmp22_;
					Number* _tmp23_;
					Number* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* label_text = NULL;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GtkSourceCompletionItem* _tmp32_;
					_tmp14_ = variable;
					_tmp15_ = g_strdup_printf ("%s", _tmp14_);
					display_text = _tmp15_;
					_tmp16_ = self->priv->_equation;
					_tmp17_ = math_equation_get_serializer (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = self->priv->_equation;
					_tmp20_ = math_equation_get_variables (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = variable;
					_tmp23_ = math_variables_get (_tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = serializer_to_string (_tmp18_, _tmp24_);
					_tmp26_ = _tmp25_;
					_g_object_unref0 (_tmp24_);
					details_text = _tmp26_;
					_tmp27_ = variable;
					_tmp28_ = g_strdup (_tmp27_);
					label_text = _tmp28_;
					_tmp29_ = display_text;
					_tmp30_ = label_text;
					_tmp31_ = details_text;
					_tmp32_ = completion_provider_create_proposal ((CompletionProvider*) self, _tmp29_, _tmp30_, _tmp31_);
					proposals = g_list_append (proposals, _tmp32_);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_free0 (variable);
				}
			}
		}
	}
	_tmp33_ = context;
	_tmp34_ = proposals;
	gtk_source_completion_context_add_proposals (_tmp33_, (GtkSourceCompletionProvider*) self, _tmp34_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (text_buffer);
}


static void variable_completion_provider_class_init (VariableCompletionProviderClass * klass) {
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VariableCompletionProviderPrivate));
	((CompletionProviderClass *) klass)->get_name = (gchar* (*) (CompletionProvider *)) variable_completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->populate = (void (*) (CompletionProvider *, GtkSourceCompletionContext*)) variable_completion_provider_real_populate;
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
}


static void variable_completion_provider_instance_init (VariableCompletionProvider * self) {
	self->priv = VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE (self);
}


static void variable_completion_provider_finalize (GObject * obj) {
	VariableCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
	_g_object_unref0 (self->priv->_equation);
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
}


GType variable_completion_provider_get_type (void) {
	static volatile gsize variable_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&variable_completion_provider_type_id__volatile, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



