// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!
#ifndef _ATKMM_RELATION_H
#define _ATKMM_RELATION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkRelation = struct _AtkRelation;
using AtkRelationClass = struct _AtkRelationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class Relation_Class; } // namespace Atk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


class Object;

/** An Atk::Relation describes a relation between an object and one or more other objects.
 * The actual relations that an object has with other objects are defined as an Atk::RelationSet,
 * which is a set of Atk::Relations.
 */

class Relation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Relation;
  using CppClassType = Relation_Class;
  using BaseObjectType = AtkRelation;
  using BaseClassType = AtkRelationClass;

  // noncopyable
  Relation(const Relation&) = delete;
  Relation& operator=(const Relation&) = delete;

private:  friend class Relation_Class;
  static CppClassType relation_class_;

protected:
  explicit Relation(const Glib::ConstructParams& construct_params);
  explicit Relation(AtkRelation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Relation(Relation&& src) noexcept;
  Relation& operator=(Relation&& src) noexcept;

  ~Relation() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkRelation*       gobj()       { return reinterpret_cast<AtkRelation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkRelation* gobj() const { return reinterpret_cast<AtkRelation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkRelation* gobj_copy();

private:


public:
  /** @addtogroup atkmmEnums atkmm Enums and Flags */

  /** 
   *  @var Type NONE
   * Not used, represens "no relationship" or an error condition.
   * 
   *  @var Type CONTROLLED_BY
   * Indicates an object controlled by one or more target objects.
   * 
   *  @var Type CONTROLLER_FOR
   * Indicates an object is an controller for one or more target objects.
   * 
   *  @var Type LABEL_FOR
   * Indicates an object is a label for one or more target objects.
   * 
   *  @var Type LABELLED_BY
   * Indicates an object is labelled by one or more target objects.
   * 
   *  @var Type MEMBER_OF
   * Indicates an object is a member of a group of one or more target objects.
   * 
   *  @var Type NODE_CHILD_OF
   * Indicates an object is a cell in a treetable which is displayed because a cell in the same column is expanded and identifies that cell.
   * 
   *  @var Type FLOWS_TO
   * Indicates that the object has content that flows logically to another
   * AtkObject in a sequential way, (for instance text-flow).
   * 
   *  @var Type FLOWS_FROM
   * Indicates that the object has content that flows logically from
   * another AtkObject in a sequential way, (for instance text-flow).
   * 
   *  @var Type SUBWINDOW_OF
   * Indicates a subwindow attached to a component but otherwise has no connection in  the UI heirarchy to that component.
   * 
   *  @var Type EMBEDS
   * Indicates that the object visually embeds 
   * another object's content, i.e. this object's content flows around 
   * another's content.
   * 
   *  @var Type EMBEDDED_BY
   * Inverse of Atk::RelationType::EMBEDS, indicates that
   * this object's content is visualy embedded in another object.
   * 
   *  @var Type POPUP_FOR
   * Indicates that an object is a popup for another object.
   * 
   *  @var Type PARENT_WINDOW_OF
   * Indicates that an object is a parent window of another object.
   * 
   *  @var Type DESCRIBED_BY
   * Indicates that another object provides descriptive information about this object; more verbose than ATK_RELATION_LABELLED_BY.
   * 
   *  @var Type DESCRIPTION_FOR
   * Indicates that an object provides descriptive information about another object; more verbose than ATK_RELATION_LABEL_FOR.
   * 
   *  @var Type NODE_PARENT_OF
   * Indicates an object is a cell in a treetable and is expanded to display other cells in the same column.
   * 
   *  @var Type LAST_DEFINED
   * Not used, this value indicates the end of the enumeration.
   * 
   *  @enum Type
   * 
   * Describes the type of the relation
   *
   * @ingroup atkmmEnums
   */
  enum class Type
  {
    NONE,
    CONTROLLED_BY,
    CONTROLLER_FOR,
    LABEL_FOR,
    LABELLED_BY,
    MEMBER_OF,
    NODE_CHILD_OF,
    FLOWS_TO,
    FLOWS_FROM,
    SUBWINDOW_OF,
    EMBEDS,
    EMBEDDED_BY,
    POPUP_FOR,
    PARENT_WINDOW_OF,
    DESCRIBED_BY,
    DESCRIPTION_FOR,
    NODE_PARENT_OF,
    LAST_DEFINED
  };


protected:
  explicit Relation(const std::vector<Glib::RefPtr<Atk::Object>>& targets,
                    Relation::Type relationship);

public:
  
  static Glib::RefPtr<Relation> create(const std::vector<Glib::RefPtr<Atk::Object>>& targets, Type relationship =  Type::NONE);


  /** Gets the type of @a relation
   * 
   * @return The type of @a relation.
   */
  Type get_relation_type() const;

  std::vector<Glib::RefPtr<Atk::Object>> get_target();
  std::vector<Glib::RefPtr<const Atk::Object>> get_target() const;
  
  
  /** Adds the specified AtkObject to the target for the relation, if it is
   * not already present.  See also Atk::Object::add_relationship().
   * 
   * 
   * @newin{1,9}
   * 
   * @param target An Atk::Object.
   */
  void add_target(const Glib::RefPtr<Atk::Object>& target);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::Relation::Type> : public Glib::Value_Enum<Atk::Relation::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Relation
   */
  Glib::RefPtr<Atk::Relation> wrap(AtkRelation* object, bool take_copy = false);
}


#endif /* _ATKMM_RELATION_H */

