/* contacts-store.c generated by valac 0.36.4, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <glib/gstdio.h>
#include <gio/gio.h>


#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block28Data Block28Data;
typedef struct _ContactsStoreFindContactData ContactsStoreFindContactData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _ContactsStoreCheckCallCapabilitiesData ContactsStoreCheckCallCapabilitiesData;
typedef struct _ContactsStoreCheckAccountCapsData ContactsStoreCheckAccountCapsData;
enum  {
	CONTACTS_STORE_CHANGED_SIGNAL,
	CONTACTS_STORE_ADDED_SIGNAL,
	CONTACTS_STORE_REMOVED_SIGNAL,
	CONTACTS_STORE_QUIESCENT_SIGNAL,
	CONTACTS_STORE_PREPARED_SIGNAL,
	CONTACTS_STORE_EDS_PERSONA_STORE_CHANGED_SIGNAL,
	CONTACTS_STORE_LAST_SIGNAL
};
static guint contacts_store_signals[CONTACTS_STORE_LAST_SIGNAL] = {0};

struct _ContactsStore {
	GObject parent_instance;
	ContactsStorePrivate * priv;
	GeeHashMap* calling_accounts;
	GeeHashMultiMap* dont_suggest_link;
};

struct _ContactsStoreClass {
	GObjectClass parent_class;
};

struct _ContactsStorePrivate {
	FolksIndividualAggregator* _aggregator;
	FolksBackendStore* _backend_store;
	GeeArrayList* contacts;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

typedef gboolean (*ContactsStoreContactMatcher) (ContactsContact* c, void* user_data);
struct _Block28Data {
	int _ref_count_;
	ContactsStore* self;
	ContactsContact* matched;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	ContactsStoreContactMatcher matcher;
	gpointer matcher_target;
	gpointer _async_data_;
};

struct _ContactsStoreFindContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsStore* self;
	ContactsStoreContactMatcher matcher;
	gpointer matcher_target;
	ContactsContact* result;
	Block28Data* _data28_;
	ContactsStoreContactMatcher _tmp0_;
	void* _tmp0__target;
	GeeArrayList* _c_list;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _c_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _c_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ContactsContact* c;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	ContactsStoreContactMatcher _tmp12_;
	void* _tmp12__target;
	ContactsContact* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gulong id1;
	gulong id2;
	gulong id3;
	gulong _tmp17_;
	gulong _tmp18_;
	gulong _tmp19_;
	gulong _tmp20_;
	gulong _tmp21_;
	gulong _tmp22_;
	ContactsContact* _tmp23_;
	ContactsContact* _tmp24_;
};

struct _ContactsStoreCheckCallCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsStore* self;
	GeeHashMap* _tmp0_;
	TpAccountManager* account_manager;
	TpAccountManager* _tmp1_;
	GList* _tmp2_;
	GList* account_collection;
	GList* account_it;
	TpAccount* _tmp3_;
	TpAccount* account;
	TpAccount* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_;
};

struct _ContactsStoreCheckAccountCapsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsStore* self;
	TpAccount* account;
	GQuark addressing;
	GQuark _tmp0_;
	TpAccount* _tmp1_;
	GQuark _tmp2_;
	gboolean _tmp3_;
	GQuark* features;
	GQuark _tmp4_;
	GQuark* _tmp5_;
	gint features_length1;
	gint _features_size_;
	TpAccount* _tmp6_;
	GQuark* _tmp7_;
	gint _tmp7__length1;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	TpAccount* _tmp10_;
	GQuark _tmp11_;
	gboolean _tmp12_;
	gchar* k;
	TpAccount* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	TpAccount* _tmp17_;
	gboolean _tmp18_;
	TpAccount* _tmp19_;
	gboolean _tmp20_;
	GeeHashMap* _tmp21_;
	const gchar* _tmp22_;
	TpAccount* _tmp23_;
	GeeHashMap* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};


static gpointer contacts_store_parent_class = NULL;

GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
#define CONTACTS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_STORE, ContactsStorePrivate))
enum  {
	CONTACTS_STORE_DUMMY_PROPERTY,
	CONTACTS_STORE_AGGREGATOR,
	CONTACTS_STORE_BACKEND_STORE,
	CONTACTS_STORE_CAN_CALL,
	CONTACTS_STORE_IS_QUIESCENT,
	CONTACTS_STORE_IS_PREPARED
};
void contacts_store_refresh (ContactsStore* self);
void contacts_contact_queue_changed (ContactsContact* self, gboolean is_persona_change);
static gboolean contacts_store_individual_can_replace_at_split (ContactsStore* self, FolksIndividual* new_individual);
static gboolean contacts_store_individual_should_replace_at_join (ContactsStore* self, FolksIndividual* old_individual);
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
static void contacts_store_read_dont_suggest_db (ContactsStore* self);
static void contacts_store_write_dont_suggest_db (ContactsStore* self);
gboolean contacts_store_may_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b);
void contacts_store_add_no_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b);
GeeList* contacts_contact_get_personas_for_display (ContactsContact* self);
static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c);
static void contacts_store_find_contact_data_free (gpointer _data);
void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean contacts_store_find_contact_co (ContactsStoreFindContactData* _data_);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
gboolean contacts_store_get_is_quiescent (ContactsStore* self);
static gboolean _contacts_store_find_contact_co_gsource_func (gpointer self);
static void __lambda10_ (Block28Data* _data28_, ContactsContact* c);
static void ___lambda10__contacts_store_changed (ContactsStore* _sender, ContactsContact* c, gpointer self);
static void __lambda11_ (Block28Data* _data28_, ContactsContact* c);
static void ___lambda11__contacts_store_added (ContactsStore* _sender, ContactsContact* c, gpointer self);
static void __lambda12_ (Block28Data* _data28_);
static void ___lambda12__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona);
GeeCollection* contacts_store_get_contacts (ContactsStore* self);
gboolean contacts_store_is_empty (ContactsStore* self);
gboolean contacts_contact_get_is_hidden (ContactsContact* self);
static void contacts_store_add (ContactsStore* self, ContactsContact* c);
static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self);
static void contacts_store_remove (ContactsStore* self, ContactsContact* c);
static void contacts_store_check_call_capabilities_data_free (gpointer _data);
static void contacts_store_check_call_capabilities (ContactsStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void contacts_store_check_call_capabilities_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean contacts_store_check_call_capabilities_co (ContactsStoreCheckCallCapabilitiesData* _data_);
static void contacts_store_check_call_capabilities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void contacts_store_check_account_caps (ContactsStore* self, TpAccount* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void contacts_store_check_account_caps_finish (ContactsStore* self, GAsyncResult* _res_);
static void _contacts_store_check_account_caps_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _contacts_store_check_account_caps_tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void contacts_store_check_account_caps_data_free (gpointer _data);
static gboolean contacts_store_check_account_caps_co (ContactsStoreCheckAccountCapsData* _data_);
static void contacts_store_check_account_caps_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value);
FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self);
static void contacts_store_set_backend_store (ContactsStore* self, FolksBackendStore* value);
gboolean contacts_store_get_can_call (ContactsStore* self);
gboolean contacts_store_get_is_prepared (ContactsStore* self);
static GObject * contacts_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _contacts_store___lambda13_ (ContactsStore* self, FolksBackend* backend);
static void ___lambda14_ (ContactsStore* self);
static void ____lambda14__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void ___lambda15_ (ContactsStore* self);
static void ____lambda15__folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void __contacts_store___lambda13__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void _contacts_store___lambda16_ (ContactsStore* self, GObject* obj, GParamSpec* pspec);
static gboolean __lambda17_ (ContactsStore* self);
static gboolean ___lambda17__gsource_func (gpointer self);
static void __contacts_store___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _contacts_store___lambda18_ (ContactsStore* self, GObject* obj, GParamSpec* pspec);
static gboolean __lambda19_ (ContactsStore* self);
static gboolean ___lambda19__gsource_func (gpointer self);
static void __contacts_store___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _contacts_store___lambda20_ (ContactsStore* self, GeeMultiMap* changes);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
void contacts_contact_replace_individual (ContactsContact* self, FolksIndividual* new_individual);
static void __contacts_store___lambda20__folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender, GeeMultiMap* changes, gpointer self);
static void contacts_store_finalize (GObject * obj);
static void _vala_contacts_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void contacts_store_refresh (ContactsStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _c_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _c_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _c_index = 0;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_c_list = _tmp1_;
		_tmp2_ = _c_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_c_size = _tmp4_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ContactsContact* c = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ContactsContact* _tmp11_;
			_tmp5_ = _c_index;
			_c_index = _tmp5_ + 1;
			_tmp6_ = _c_index;
			_tmp7_ = _c_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _c_list;
			_tmp9_ = _c_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			c = (ContactsContact*) _tmp10_;
			_tmp11_ = c;
			contacts_contact_queue_changed (_tmp11_, TRUE);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
}


static gboolean contacts_store_individual_can_replace_at_split (ContactsStore* self, FolksIndividual* new_individual) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_individual != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = new_individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			gconstpointer _tmp9_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = g_object_get_data ((GObject*) _tmp8_, "contacts-new-contact");
			if ((gboolean) ((gintptr) _tmp9_)) {
				result = FALSE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = TRUE;
	return result;
}


static gboolean contacts_store_individual_should_replace_at_join (ContactsStore* self, FolksIndividual* old_individual) {
	gboolean result = FALSE;
	ContactsContact* c = NULL;
	FolksIndividual* _tmp0_;
	ContactsContact* _tmp1_;
	gconstpointer _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (old_individual != NULL, FALSE);
	_tmp0_ = old_individual;
	_tmp1_ = contacts_contact_from_individual (_tmp0_);
	c = _tmp1_;
	_tmp2_ = g_object_get_data ((GObject*) c, "contacts-master-at-join");
	result = (gboolean) ((gintptr) _tmp2_);
	_g_object_unref0 (c);
	return result;
}


static void contacts_store_read_dont_suggest_db (ContactsStore* self) {
	GeeHashMultiMap* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->dont_suggest_link;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	{
		gchar* path = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* contents = NULL;
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_build_filename (_tmp1_, "gnome-contacts", "dont_suggest.db", NULL);
		path = _tmp2_;
		_tmp5_ = g_file_get_contents (path, &_tmp4_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp4_;
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (contents);
			_g_free0 (path);
			goto __catch23_g_error;
		}
		if (_tmp3_) {
			gchar** rows = NULL;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint rows_length1;
			gint _rows_size_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp7_ = _tmp6_ = g_strsplit (contents, "\n", 0);
			rows = _tmp7_;
			rows_length1 = _vala_array_length (_tmp6_);
			_rows_size_ = rows_length1;
			_tmp8_ = rows;
			_tmp8__length1 = rows_length1;
			{
				gchar** r_collection = NULL;
				gint r_collection_length1 = 0;
				gint _r_collection_size_ = 0;
				gint r_it = 0;
				r_collection = _tmp8_;
				r_collection_length1 = _tmp8__length1;
				for (r_it = 0; r_it < _tmp8__length1; r_it = r_it + 1) {
					gchar* _tmp9_;
					gchar* r = NULL;
					_tmp9_ = g_strdup (r_collection[r_it]);
					r = _tmp9_;
					{
						gchar** ids = NULL;
						const gchar* _tmp10_;
						gchar** _tmp11_;
						gchar** _tmp12_;
						gint ids_length1;
						gint _ids_size_;
						gchar** _tmp13_;
						gint _tmp13__length1;
						_tmp10_ = r;
						_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
						ids = _tmp12_;
						ids_length1 = _vala_array_length (_tmp11_);
						_ids_size_ = ids_length1;
						_tmp13_ = ids;
						_tmp13__length1 = ids_length1;
						if (_tmp13__length1 == 2) {
							GeeHashMultiMap* _tmp14_;
							gchar** _tmp15_;
							gint _tmp15__length1;
							const gchar* _tmp16_;
							gchar** _tmp17_;
							gint _tmp17__length1;
							const gchar* _tmp18_;
							_tmp14_ = self->dont_suggest_link;
							_tmp15_ = ids;
							_tmp15__length1 = ids_length1;
							_tmp16_ = _tmp15_[0];
							_tmp17_ = ids;
							_tmp17__length1 = ids_length1;
							_tmp18_ = _tmp17_[1];
							gee_multi_map_set ((GeeMultiMap*) _tmp14_, _tmp16_, _tmp18_);
						}
						ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (r);
					}
				}
			}
			rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (contents);
		_g_free0 (path);
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		if (!g_error_matches (_tmp19_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			g_warning ("contacts-store.vala:90: error loading no suggestion db: %s\n", _tmp21_);
		}
		_g_error_free0 (e);
	}
	__finally23:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void contacts_store_write_dont_suggest_db (ContactsStore* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* dir = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* path = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		GString* s = NULL;
		GString* _tmp5_;
		const gchar* _tmp28_;
		GString* _tmp29_;
		const gchar* _tmp30_;
		GString* _tmp31_;
		gssize _tmp32_;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_build_filename (_tmp0_, "gnome-contacts", NULL);
		dir = _tmp1_;
		_tmp2_ = dir;
		g_mkdir_with_parents (_tmp2_, 0700);
		_tmp3_ = dir;
		_tmp4_ = g_build_filename (_tmp3_, "dont_suggest.db", NULL);
		path = _tmp4_;
		_tmp5_ = g_string_new ("");
		s = _tmp5_;
		{
			GeeIterator* _key_it = NULL;
			GeeHashMultiMap* _tmp6_;
			GeeSet* _tmp7_;
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp6_ = self->dont_suggest_link;
			_tmp7_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_key_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				gboolean _tmp12_;
				gchar* key = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				_tmp11_ = _key_it;
				_tmp12_ = gee_iterator_next (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = _key_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				key = (gchar*) _tmp14_;
				{
					GeeIterator* _value_it = NULL;
					GeeHashMultiMap* _tmp15_;
					const gchar* _tmp16_;
					GeeCollection* _tmp17_;
					GeeCollection* _tmp18_;
					GeeIterator* _tmp19_;
					GeeIterator* _tmp20_;
					_tmp15_ = self->dont_suggest_link;
					_tmp16_ = key;
					_tmp17_ = gee_multi_map_get ((GeeMultiMap*) _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
					_tmp20_ = _tmp19_;
					_g_object_unref0 (_tmp18_);
					_value_it = _tmp20_;
					while (TRUE) {
						GeeIterator* _tmp21_;
						gboolean _tmp22_;
						gchar* value = NULL;
						GeeIterator* _tmp23_;
						gpointer _tmp24_;
						GString* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						_tmp21_ = _value_it;
						_tmp22_ = gee_iterator_next (_tmp21_);
						if (!_tmp22_) {
							break;
						}
						_tmp23_ = _value_it;
						_tmp24_ = gee_iterator_get (_tmp23_);
						value = (gchar*) _tmp24_;
						_tmp25_ = s;
						_tmp26_ = key;
						_tmp27_ = value;
						g_string_append_printf (_tmp25_, "%s %s\n", _tmp26_, _tmp27_);
						_g_free0 (value);
					}
					_g_object_unref0 (_value_it);
				}
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		_tmp28_ = path;
		_tmp29_ = s;
		_tmp30_ = _tmp29_->str;
		_tmp31_ = s;
		_tmp32_ = _tmp31_->len;
		g_file_set_contents (_tmp28_, _tmp30_, _tmp32_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_string_free0 (s);
			_g_free0 (path);
			_g_free0 (dir);
			goto __catch24_g_error;
		}
		_g_string_free0 (s);
		_g_free0 (path);
		_g_free0 (dir);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("contacts-store.vala:108: error writing no suggestion db: %s\n", _tmp34_);
		_g_error_free0 (e);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean contacts_store_may_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	{
		GeeIterator* _a_persona_it = NULL;
		ContactsContact* _tmp0_;
		FolksIndividual* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = a;
		_tmp1_ = _tmp0_->individual;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_a_persona_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			FolksPersona* a_persona = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			_tmp5_ = _a_persona_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _a_persona_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			a_persona = (FolksPersona*) _tmp8_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp9_;
				FolksPersona* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp9_ = self->dont_suggest_link;
				_tmp10_ = a_persona;
				_tmp11_ = folks_persona_get_uid (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_multi_map_get ((GeeMultiMap*) _tmp9_, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_no_link_uid_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					gboolean _tmp18_;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp19_;
					gpointer _tmp20_;
					_tmp17_ = _no_link_uid_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _no_link_uid_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					no_link_uid = (gchar*) _tmp20_;
					{
						GeeIterator* _b_persona_it = NULL;
						ContactsContact* _tmp21_;
						FolksIndividual* _tmp22_;
						GeeSet* _tmp23_;
						GeeSet* _tmp24_;
						GeeIterator* _tmp25_;
						_tmp21_ = b;
						_tmp22_ = _tmp21_->individual;
						_tmp23_ = folks_individual_get_personas (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
						_b_persona_it = _tmp25_;
						while (TRUE) {
							GeeIterator* _tmp26_;
							gboolean _tmp27_;
							FolksPersona* b_persona = NULL;
							GeeIterator* _tmp28_;
							gpointer _tmp29_;
							FolksPersona* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							_tmp26_ = _b_persona_it;
							_tmp27_ = gee_iterator_next (_tmp26_);
							if (!_tmp27_) {
								break;
							}
							_tmp28_ = _b_persona_it;
							_tmp29_ = gee_iterator_get (_tmp28_);
							b_persona = (FolksPersona*) _tmp29_;
							_tmp30_ = b_persona;
							_tmp31_ = folks_persona_get_uid (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = no_link_uid;
							if (g_strcmp0 (_tmp32_, _tmp33_) == 0) {
								result = FALSE;
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								return result;
							}
							_g_object_unref0 (b_persona);
						}
						_g_object_unref0 (_b_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (a_persona);
		}
		_g_object_unref0 (_a_persona_it);
	}
	{
		GeeIterator* _b_persona_it = NULL;
		ContactsContact* _tmp34_;
		FolksIndividual* _tmp35_;
		GeeSet* _tmp36_;
		GeeSet* _tmp37_;
		GeeIterator* _tmp38_;
		_tmp34_ = b;
		_tmp35_ = _tmp34_->individual;
		_tmp36_ = folks_individual_get_personas (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
		_b_persona_it = _tmp38_;
		while (TRUE) {
			GeeIterator* _tmp39_;
			gboolean _tmp40_;
			FolksPersona* b_persona = NULL;
			GeeIterator* _tmp41_;
			gpointer _tmp42_;
			_tmp39_ = _b_persona_it;
			_tmp40_ = gee_iterator_next (_tmp39_);
			if (!_tmp40_) {
				break;
			}
			_tmp41_ = _b_persona_it;
			_tmp42_ = gee_iterator_get (_tmp41_);
			b_persona = (FolksPersona*) _tmp42_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp43_;
				FolksPersona* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				GeeCollection* _tmp47_;
				GeeCollection* _tmp48_;
				GeeIterator* _tmp49_;
				GeeIterator* _tmp50_;
				_tmp43_ = self->dont_suggest_link;
				_tmp44_ = b_persona;
				_tmp45_ = folks_persona_get_uid (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = gee_multi_map_get ((GeeMultiMap*) _tmp43_, _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
				_tmp50_ = _tmp49_;
				_g_object_unref0 (_tmp48_);
				_no_link_uid_it = _tmp50_;
				while (TRUE) {
					GeeIterator* _tmp51_;
					gboolean _tmp52_;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp53_;
					gpointer _tmp54_;
					_tmp51_ = _no_link_uid_it;
					_tmp52_ = gee_iterator_next (_tmp51_);
					if (!_tmp52_) {
						break;
					}
					_tmp53_ = _no_link_uid_it;
					_tmp54_ = gee_iterator_get (_tmp53_);
					no_link_uid = (gchar*) _tmp54_;
					{
						GeeIterator* _a_persona_it = NULL;
						ContactsContact* _tmp55_;
						FolksIndividual* _tmp56_;
						GeeSet* _tmp57_;
						GeeSet* _tmp58_;
						GeeIterator* _tmp59_;
						_tmp55_ = a;
						_tmp56_ = _tmp55_->individual;
						_tmp57_ = folks_individual_get_personas (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = gee_iterable_iterator ((GeeIterable*) _tmp58_);
						_a_persona_it = _tmp59_;
						while (TRUE) {
							GeeIterator* _tmp60_;
							gboolean _tmp61_;
							FolksPersona* a_persona = NULL;
							GeeIterator* _tmp62_;
							gpointer _tmp63_;
							FolksPersona* _tmp64_;
							const gchar* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							_tmp60_ = _a_persona_it;
							_tmp61_ = gee_iterator_next (_tmp60_);
							if (!_tmp61_) {
								break;
							}
							_tmp62_ = _a_persona_it;
							_tmp63_ = gee_iterator_get (_tmp62_);
							a_persona = (FolksPersona*) _tmp63_;
							_tmp64_ = a_persona;
							_tmp65_ = folks_persona_get_uid (_tmp64_);
							_tmp66_ = _tmp65_;
							_tmp67_ = no_link_uid;
							if (g_strcmp0 (_tmp66_, _tmp67_) == 0) {
								result = FALSE;
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								return result;
							}
							_g_object_unref0 (a_persona);
						}
						_g_object_unref0 (_a_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (b_persona);
		}
		_g_object_unref0 (_b_persona_it);
	}
	result = TRUE;
	return result;
}


void contacts_store_add_no_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b) {
	FolksPersona* persona1 = NULL;
	ContactsContact* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gpointer* _tmp4_;
	FolksPersona** _tmp5_;
	gint _tmp5__length1;
	FolksPersona* _tmp6_;
	FolksPersona* _tmp7_;
	FolksPersona* _tmp8_;
	FolksPersona* persona2 = NULL;
	ContactsContact* _tmp9_;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	FolksPersona** _tmp14_;
	gint _tmp14__length1;
	FolksPersona* _tmp15_;
	FolksPersona* _tmp16_;
	FolksPersona* _tmp17_;
	GeeHashMultiMap* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = contacts_contact_get_personas_for_display (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = gee_collection_to_array ((GeeCollection*) _tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp2_);
	persona1 = _tmp8_;
	_tmp9_ = b;
	_tmp10_ = contacts_contact_get_personas_for_display (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = gee_collection_to_array ((GeeCollection*) _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp12_;
	_tmp15_ = _tmp14_[0];
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp11_);
	persona2 = _tmp17_;
	_tmp18_ = self->dont_suggest_link;
	_tmp19_ = folks_persona_get_uid (persona1);
	_tmp20_ = _tmp19_;
	_tmp21_ = folks_persona_get_uid (persona2);
	_tmp22_ = _tmp21_;
	gee_multi_map_set ((GeeMultiMap*) _tmp18_, _tmp20_, _tmp22_);
	contacts_store_write_dont_suggest_db (self);
	_g_object_unref0 (persona2);
	_g_object_unref0 (persona1);
}


static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_CHANGED_SIGNAL], 0, _tmp0_);
}


static void contacts_store_find_contact_data_free (gpointer _data) {
	ContactsStoreFindContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreFindContactData, _data_);
}


void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreFindContactData* _data_;
	ContactsStore* _tmp0_;
	ContactsStoreContactMatcher _tmp1_;
	void* _tmp1__target;
	_data_ = g_slice_new0 (ContactsStoreFindContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_store_find_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = matcher;
	_tmp1__target = matcher_target;
	_data_->matcher = _tmp1_;
	_data_->matcher_target = _tmp1__target;
	contacts_store_find_contact_co (_data_);
}


ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsContact* result;
	ContactsStoreFindContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		ContactsStore* self;
		self = _data28_->self;
		(_data28_->callback_target_destroy_notify == NULL) ? NULL : (_data28_->callback_target_destroy_notify (_data28_->callback_target), NULL);
		_data28_->callback = NULL;
		_data28_->callback_target = NULL;
		_data28_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (_data28_->matched);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}


static gboolean _contacts_store_find_contact_co_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_store_find_contact_co (self);
	return result;
}


static void __lambda10_ (Block28Data* _data28_, ContactsContact* c) {
	ContactsStore* self;
	ContactsStoreContactMatcher _tmp0_;
	void* _tmp0__target;
	ContactsContact* _tmp1_;
	gboolean _tmp2_;
	self = _data28_->self;
	g_return_if_fail (c != NULL);
	_tmp0_ = _data28_->matcher;
	_tmp0__target = _data28_->matcher_target;
	_tmp1_ = c;
	_tmp2_ = _tmp0_ (_tmp1_, _tmp0__target);
	if (_tmp2_) {
		ContactsContact* _tmp3_;
		ContactsContact* _tmp4_;
		GSourceFunc _tmp5_;
		void* _tmp5__target;
		_tmp3_ = c;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_data28_->matched);
		_data28_->matched = _tmp4_;
		_tmp5_ = _data28_->callback;
		_tmp5__target = _data28_->callback_target;
		_tmp5_ (_tmp5__target);
	}
}


static void ___lambda10__contacts_store_changed (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	__lambda10_ (self, c);
}


static void __lambda11_ (Block28Data* _data28_, ContactsContact* c) {
	ContactsStore* self;
	ContactsStoreContactMatcher _tmp0_;
	void* _tmp0__target;
	ContactsContact* _tmp1_;
	gboolean _tmp2_;
	self = _data28_->self;
	g_return_if_fail (c != NULL);
	_tmp0_ = _data28_->matcher;
	_tmp0__target = _data28_->matcher_target;
	_tmp1_ = c;
	_tmp2_ = _tmp0_ (_tmp1_, _tmp0__target);
	if (_tmp2_) {
		ContactsContact* _tmp3_;
		ContactsContact* _tmp4_;
		GSourceFunc _tmp5_;
		void* _tmp5__target;
		_tmp3_ = c;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_data28_->matched);
		_data28_->matched = _tmp4_;
		_tmp5_ = _data28_->callback;
		_tmp5__target = _data28_->callback_target;
		_tmp5_ (_tmp5__target);
	}
}


static void ___lambda11__contacts_store_added (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	__lambda11_ (self, c);
}


static void __lambda12_ (Block28Data* _data28_) {
	ContactsStore* self;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
	self = _data28_->self;
	_tmp0_ = _data28_->callback;
	_tmp0__target = _data28_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void ___lambda12__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	__lambda12_ (self);
}


static gboolean contacts_store_find_contact_co (ContactsStoreFindContactData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data28_ = g_slice_new0 (Block28Data);
	_data_->_data28_->_ref_count_ = 1;
	_data_->_data28_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->matcher;
	_data_->_tmp0__target = _data_->matcher_target;
	_data_->_data28_->matcher = _data_->_tmp0_;
	_data_->_data28_->matcher_target = _data_->_tmp0__target;
	_data_->_data28_->_async_data_ = _data_;
	{
		_data_->_tmp1_ = _data_->self->priv->contacts;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_c_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_c_list;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_c_size = _data_->_tmp5_;
		_data_->_c_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_c_index;
			_data_->_c_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_c_index;
			_data_->_tmp8_ = _data_->_c_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_c_list;
			_data_->_tmp10_ = _data_->_c_index;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->c = (ContactsContact*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->_data28_->matcher;
			_data_->_tmp12__target = _data_->_data28_->matcher_target;
			_data_->_tmp13_ = _data_->c;
			_data_->_tmp14_ = _data_->_tmp12_ (_data_->_tmp13_, _data_->_tmp12__target);
			if (_data_->_tmp14_) {
				_data_->result = _data_->c;
				_g_object_unref0 (_data_->_c_list);
				block28_data_unref (_data_->_data28_);
				_data_->_data28_ = NULL;
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (g_task_get_completed (_data_->_async_result) != TRUE) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->c);
		}
		_g_object_unref0 (_data_->_c_list);
	}
	_data_->_tmp15_ = contacts_store_get_is_quiescent (_data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	if (_data_->_tmp16_) {
		_data_->result = NULL;
		block28_data_unref (_data_->_data28_);
		_data_->_data28_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data28_->matched = NULL;
	_data_->_data28_->callback = _contacts_store_find_contact_co_gsource_func;
	_data_->_data28_->callback_target = _data_;
	_data_->_data28_->callback_target_destroy_notify = NULL;
	_data_->_tmp17_ = g_signal_connect_data (_data_->self, "changed", (GCallback) ___lambda10__contacts_store_changed, block28_data_ref (_data_->_data28_), (GClosureNotify) block28_data_unref, 0);
	_data_->id1 = _data_->_tmp17_;
	_data_->_tmp18_ = g_signal_connect_data (_data_->self, "added", (GCallback) ___lambda11__contacts_store_added, block28_data_ref (_data_->_data28_), (GClosureNotify) block28_data_unref, 0);
	_data_->id2 = _data_->_tmp18_;
	_data_->_tmp19_ = g_signal_connect_data (_data_->self, "quiescent", (GCallback) ___lambda12__contacts_store_quiescent, block28_data_ref (_data_->_data28_), (GClosureNotify) block28_data_unref, 0);
	_data_->id3 = _data_->_tmp19_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp20_ = _data_->id1;
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp20_);
	_data_->_tmp21_ = _data_->id2;
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp21_);
	_data_->_tmp22_ = _data_->id3;
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp22_);
	_data_->_tmp23_ = _data_->_data28_->matched;
	_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
	_data_->result = _data_->_tmp24_;
	block28_data_unref (_data_->_data28_);
	_data_->_data28_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	{
		GeeArrayList* _contact_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _contact_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _contact_index = 0;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ContactsContact* contact = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ContactsContact* _tmp11_;
			FolksIndividual* _tmp12_;
			GeeSet* _tmp13_;
			GeeSet* _tmp14_;
			FolksPersona* _tmp15_;
			gboolean _tmp16_;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = _tmp11_->individual;
			_tmp13_ = folks_individual_get_personas (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = persona;
			_tmp16_ = gee_collection_contains ((GeeCollection*) _tmp14_, _tmp15_);
			if (_tmp16_) {
				result = contact;
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = NULL;
	return result;
}


GeeCollection* contacts_store_get_contacts (ContactsStore* self) {
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeCollection*) _tmp2_;
	return result;
}


gboolean contacts_store_is_empty (ContactsStore* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _contact_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _contact_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _contact_index = 0;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ContactsContact* contact = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ContactsContact* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = contacts_contact_get_is_hidden (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				result = FALSE;
				_g_object_unref0 (contact);
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = TRUE;
	return result;
}


static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_store_contact_changed_cb ((ContactsStore*) self, _sender);
}


static void contacts_store_add (ContactsStore* self, ContactsContact* c) {
	GeeArrayList* _tmp0_;
	ContactsContact* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = c;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = c;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self, 0);
	_tmp3_ = c;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_ADDED_SIGNAL], 0, _tmp3_);
}


static void contacts_store_remove (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_;
	guint _tmp1_;
	gint i = 0;
	GeeArrayList* _tmp2_;
	ContactsContact* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_;
	ContactsContact* _tmp22_;
	ContactsContact* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self);
	_tmp2_ = self->priv->contacts;
	_tmp3_ = c;
	_tmp4_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp2_, _tmp3_);
	i = _tmp4_;
	_tmp5_ = i;
	_tmp6_ = self->priv->contacts;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ != (_tmp8_ - 1)) {
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gpointer _tmp15_;
		ContactsContact* _tmp16_;
		_tmp9_ = self->priv->contacts;
		_tmp10_ = i;
		_tmp11_ = self->priv->contacts;
		_tmp12_ = self->priv->contacts;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp14_ - 1);
		_tmp16_ = (ContactsContact*) _tmp15_;
		gee_abstract_list_set ((GeeAbstractList*) _tmp9_, _tmp10_, _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->contacts;
	_tmp18_ = self->priv->contacts;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp17_, _tmp20_ - 1);
	_tmp22_ = (ContactsContact*) _tmp21_;
	_g_object_unref0 (_tmp22_);
	_tmp23_ = c;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_REMOVED_SIGNAL], 0, _tmp23_);
}


static void contacts_store_check_call_capabilities_data_free (gpointer _data) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreCheckCallCapabilitiesData, _data_);
}


static void contacts_store_check_call_capabilities (ContactsStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	ContactsStore* _tmp0_;
	_data_ = g_slice_new0 (ContactsStoreCheckCallCapabilitiesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_store_check_call_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_store_check_call_capabilities_co (_data_);
}


static void contacts_store_check_call_capabilities_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void contacts_store_check_call_capabilities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_store_check_call_capabilities_co (_data_);
}


static void _contacts_store_check_account_caps_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	contacts_store_check_account_caps ((ContactsStore*) self, account, NULL, NULL);
}


static void _contacts_store_check_account_caps_tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	contacts_store_check_account_caps ((ContactsStore*) self, account, NULL, NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean contacts_store_check_call_capabilities_co (ContactsStoreCheckCallCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, tp_account_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_data_->self->calling_accounts);
	_data_->self->calling_accounts = _data_->_tmp0_;
	_data_->_tmp1_ = tp_account_manager_dup ();
	_data_->account_manager = _data_->_tmp1_;
	{
		_data_->_state_ = 1;
		tp_proxy_prepare_async ((TpProxy*) _data_->account_manager, NULL, contacts_store_check_call_capabilities_ready, _data_);
		return FALSE;
		_state_1:
		tp_proxy_prepare_finish ((TpProxy*) _data_->account_manager, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
		g_signal_connect_object (_data_->account_manager, "account-enabled", (GCallback) _contacts_store_check_account_caps_tp_account_manager_account_enabled, _data_->self, 0);
		g_signal_connect_object (_data_->account_manager, "account-disabled", (GCallback) _contacts_store_check_account_caps_tp_account_manager_account_disabled, _data_->self, 0);
		_data_->_tmp2_ = tp_account_manager_dup_valid_accounts (_data_->account_manager);
		{
			_data_->account_collection = _data_->_tmp2_;
			for (_data_->account_it = _data_->account_collection; _data_->account_it != NULL; _data_->account_it = _data_->account_it->next) {
				_data_->_tmp3_ = _g_object_ref0 ((TpAccount*) _data_->account_it->data);
				_data_->account = _data_->_tmp3_;
				{
					_data_->_tmp4_ = _data_->account;
					_data_->_state_ = 2;
					contacts_store_check_account_caps (_data_->self, _data_->_tmp4_, contacts_store_check_call_capabilities_ready, _data_);
					return FALSE;
					_state_2:
					contacts_store_check_account_caps_finish (_data_->self, _data_->_res_);
					_g_object_unref0 (_data_->account);
				}
			}
			__g_list_free__g_object_unref0_0 (_data_->account_collection);
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("contacts-store.vala:334: Unable to check accounts caps %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally25:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->account_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->account_manager);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_store_check_account_caps_data_free (gpointer _data) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreCheckAccountCapsData, _data_);
}


static void contacts_store_check_account_caps (ContactsStore* self, TpAccount* account, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreCheckAccountCapsData* _data_;
	ContactsStore* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	_data_ = g_slice_new0 (ContactsStoreCheckAccountCapsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_store_check_account_caps_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp2_;
	contacts_store_check_account_caps_co (_data_);
}


static void contacts_store_check_account_caps_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void contacts_store_check_account_caps_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_store_check_account_caps_co (_data_);
}


static gboolean contacts_store_check_account_caps_co (ContactsStoreCheckAccountCapsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tp_account_get_feature_quark_addressing ();
	_data_->addressing = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->account;
	_data_->_tmp2_ = _data_->addressing;
	_data_->_tmp3_ = tp_proxy_is_prepared ((TpProxy*) _data_->_tmp1_, _data_->_tmp2_);
	if (!_data_->_tmp3_) {
		_data_->_tmp4_ = _data_->addressing;
		_data_->_tmp5_ = g_new0 (GQuark, 1);
		_data_->_tmp5_[0] = _data_->_tmp4_;
		_data_->features = _data_->_tmp5_;
		_data_->features_length1 = 1;
		_data_->_features_size_ = _data_->features_length1;
		{
			_data_->_tmp6_ = _data_->account;
			_data_->_tmp7_ = _data_->features;
			_data_->_tmp7__length1 = _data_->features_length1;
			_data_->_state_ = 1;
			tp_proxy_prepare_async ((TpProxy*) _data_->_tmp6_, _data_->_tmp7_, contacts_store_check_account_caps_ready, _data_);
			return FALSE;
			_state_1:
			tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch26_g_error;
			}
		}
		goto __finally26;
		__catch26_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			g_warning ("contacts-store.vala:345: Unable to prepare account %s", _data_->_tmp9_);
			_g_error_free0 (_data_->e);
		}
		__finally26:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_data_->features = (g_free (_data_->features), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->features = (g_free (_data_->features), NULL);
	}
	_data_->_tmp10_ = _data_->account;
	_data_->_tmp11_ = _data_->addressing;
	_data_->_tmp12_ = tp_proxy_is_prepared ((TpProxy*) _data_->_tmp10_, _data_->_tmp11_);
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = _data_->account;
		_data_->_tmp14_ = tp_proxy_get_object_path ((TpProxy*) _data_->_tmp13_);
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
		_data_->k = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->account;
		_data_->_tmp18_ = tp_account_is_enabled (_data_->_tmp17_);
		if (_data_->_tmp18_) {
			_data_->_tmp19_ = _data_->account;
			_data_->_tmp20_ = tp_account_associated_with_uri_scheme (_data_->_tmp19_, "tel");
			_data_->_tmp16_ = _data_->_tmp20_;
		} else {
			_data_->_tmp16_ = FALSE;
		}
		if (_data_->_tmp16_) {
			_data_->_tmp21_ = _data_->self->calling_accounts;
			_data_->_tmp22_ = _data_->k;
			_data_->_tmp23_ = _data_->account;
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
		} else {
			_data_->_tmp24_ = _data_->self->calling_accounts;
			_data_->_tmp25_ = _data_->k;
			gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp24_, _data_->_tmp25_, NULL);
		}
		_g_free0 (_data_->k);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


ContactsStore* contacts_store_construct (GType object_type) {
	ContactsStore * self = NULL;
	self = (ContactsStore*) g_object_new (object_type, NULL);
	return self;
}


ContactsStore* contacts_store_new (void) {
	return contacts_store_construct (CONTACTS_TYPE_STORE);
}


FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self) {
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}


static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value) {
	g_return_if_fail (self != NULL);
	if (contacts_store_get_aggregator (self) != value) {
		FolksIndividualAggregator* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_aggregator);
		self->priv->_aggregator = _tmp1_;
		g_object_notify ((GObject *) self, "aggregator");
	}
}


FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self) {
	FolksBackendStore* result;
	FolksBackendStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_store;
	result = _tmp0_;
	return result;
}


static void contacts_store_set_backend_store (ContactsStore* self, FolksBackendStore* value) {
	g_return_if_fail (self != NULL);
	if (contacts_store_get_backend_store (self) != value) {
		FolksBackendStore* _tmp0_;
		FolksBackendStore* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_backend_store);
		self->priv->_backend_store = _tmp1_;
		g_object_notify ((GObject *) self, "backend-store");
	}
}


gboolean contacts_store_get_can_call (ContactsStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->calling_accounts;
	_tmp2_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean contacts_store_get_is_quiescent (ContactsStore* self) {
	gboolean result;
	FolksIndividualAggregator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_is_quiescent (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean contacts_store_get_is_prepared (ContactsStore* self) {
	gboolean result;
	FolksIndividualAggregator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_is_prepared (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void ___lambda14_ (ContactsStore* self) {
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_EDS_PERSONA_STORE_CHANGED_SIGNAL], 0);
}


static void ____lambda14__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	___lambda14_ ((ContactsStore*) self);
}


static void ___lambda15_ (ContactsStore* self) {
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_EDS_PERSONA_STORE_CHANGED_SIGNAL], 0);
}


static void ____lambda15__folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	___lambda15_ ((ContactsStore*) self);
}


static void _contacts_store___lambda13_ (ContactsStore* self, FolksBackend* backend) {
	FolksBackend* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (backend != NULL);
	_tmp0_ = backend;
	_tmp1_ = folks_backend_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "eds") == 0) {
		FolksBackend* _tmp3_;
		FolksBackend* _tmp4_;
		_tmp3_ = backend;
		g_signal_connect_object (_tmp3_, "persona-store-added", (GCallback) ____lambda14__folks_backend_persona_store_added, self, 0);
		_tmp4_ = backend;
		g_signal_connect_object (_tmp4_, "persona-store-removed", (GCallback) ____lambda15__folks_backend_persona_store_removed, self, 0);
	}
}


static void __contacts_store___lambda13__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	_contacts_store___lambda13_ ((ContactsStore*) self, backend);
}


static gboolean __lambda17_ (ContactsStore* self) {
	gboolean result = FALSE;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_QUIESCENT_SIGNAL], 0);
	result = FALSE;
	return result;
}


static gboolean ___lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda17_ ((ContactsStore*) self);
	return result;
}


static void _contacts_store___lambda16_ (ContactsStore* self, GObject* obj, GParamSpec* pspec) {
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, g_object_ref (self), g_object_unref);
}


static void __contacts_store___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_contacts_store___lambda16_ ((ContactsStore*) self, _sender, pspec);
}


static gboolean __lambda19_ (ContactsStore* self) {
	gboolean result = FALSE;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_PREPARED_SIGNAL], 0);
	result = FALSE;
	return result;
}


static gboolean ___lambda19__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda19_ ((ContactsStore*) self);
	return result;
}


static void _contacts_store___lambda18_ (ContactsStore* self, GObject* obj, GParamSpec* pspec) {
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda19__gsource_func, g_object_ref (self), g_object_unref);
}


static void __contacts_store___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_contacts_store___lambda18_ ((ContactsStore*) self, _sender, pspec);
}


static void _contacts_store___lambda20_ (ContactsStore* self, GeeMultiMap* changes) {
	GeeHashMap* replaced_individuals = NULL;
	GeeHashMap* _tmp0_;
	g_return_if_fail (changes != NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	replaced_individuals = _tmp0_;
	{
		GeeIterator* _old_individual_it = NULL;
		GeeMultiMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = changes;
		_tmp2_ = gee_multi_map_get_keys (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_old_individual_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			FolksIndividual* old_individual = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			FolksIndividual* _tmp10_;
			_tmp6_ = _old_individual_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _old_individual_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			old_individual = (FolksIndividual*) _tmp9_;
			_tmp10_ = old_individual;
			if (_tmp10_ == NULL) {
				_g_object_unref0 (old_individual);
				continue;
			}
			{
				GeeIterator* _new_individual_it = NULL;
				GeeMultiMap* _tmp11_;
				FolksIndividual* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp11_ = changes;
				_tmp12_ = old_individual;
				_tmp13_ = gee_multi_map_get (_tmp11_, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_new_individual_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					gboolean _tmp18_;
					FolksIndividual* new_individual = NULL;
					GeeIterator* _tmp19_;
					gpointer _tmp20_;
					FolksIndividual* _tmp21_;
					gboolean _tmp22_ = FALSE;
					GeeHashMap* _tmp23_;
					FolksIndividual* _tmp24_;
					gboolean _tmp25_;
					_tmp17_ = _new_individual_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _new_individual_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					new_individual = (FolksIndividual*) _tmp20_;
					_tmp21_ = new_individual;
					if (_tmp21_ == NULL) {
						_g_object_unref0 (new_individual);
						continue;
					}
					_tmp23_ = replaced_individuals;
					_tmp24_ = new_individual;
					_tmp25_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp23_, _tmp24_);
					if (!_tmp25_) {
						_tmp22_ = TRUE;
					} else {
						FolksIndividual* _tmp26_;
						gboolean _tmp27_;
						_tmp26_ = old_individual;
						_tmp27_ = contacts_store_individual_should_replace_at_join (self, _tmp26_);
						_tmp22_ = _tmp27_;
					}
					if (_tmp22_) {
						GeeHashMap* _tmp28_;
						FolksIndividual* _tmp29_;
						FolksIndividual* _tmp30_;
						_tmp28_ = replaced_individuals;
						_tmp29_ = new_individual;
						_tmp30_ = old_individual;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
					}
					_g_object_unref0 (new_individual);
				}
				_g_object_unref0 (_new_individual_it);
			}
			_g_object_unref0 (old_individual);
		}
		_g_object_unref0 (_old_individual_it);
	}
	{
		GeeIterator* _old_individual_it = NULL;
		GeeMultiMap* _tmp31_;
		GeeSet* _tmp32_;
		GeeSet* _tmp33_;
		GeeIterator* _tmp34_;
		GeeIterator* _tmp35_;
		_tmp31_ = changes;
		_tmp32_ = gee_multi_map_get_keys (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gee_iterable_iterator ((GeeIterable*) _tmp33_);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (_tmp33_);
		_old_individual_it = _tmp35_;
		while (TRUE) {
			GeeIterator* _tmp36_;
			gboolean _tmp37_;
			FolksIndividual* old_individual = NULL;
			GeeIterator* _tmp38_;
			gpointer _tmp39_;
			GeeHashSet* replacements = NULL;
			GeeHashSet* _tmp71_;
			_tmp36_ = _old_individual_it;
			_tmp37_ = gee_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _old_individual_it;
			_tmp39_ = gee_iterator_get (_tmp38_);
			old_individual = (FolksIndividual*) _tmp39_;
			replacements = NULL;
			{
				GeeIterator* _new_individual_it = NULL;
				GeeMultiMap* _tmp40_;
				FolksIndividual* _tmp41_;
				GeeCollection* _tmp42_;
				GeeCollection* _tmp43_;
				GeeIterator* _tmp44_;
				GeeIterator* _tmp45_;
				_tmp40_ = changes;
				_tmp41_ = old_individual;
				_tmp42_ = gee_multi_map_get (_tmp40_, _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = gee_iterable_iterator ((GeeIterable*) _tmp43_);
				_tmp45_ = _tmp44_;
				_g_object_unref0 (_tmp43_);
				_new_individual_it = _tmp45_;
				while (TRUE) {
					GeeIterator* _tmp46_;
					gboolean _tmp47_;
					FolksIndividual* new_individual = NULL;
					GeeIterator* _tmp48_;
					gpointer _tmp49_;
					gboolean _tmp50_ = FALSE;
					gboolean _tmp51_ = FALSE;
					FolksIndividual* _tmp52_;
					_tmp46_ = _new_individual_it;
					_tmp47_ = gee_iterator_next (_tmp46_);
					if (!_tmp47_) {
						break;
					}
					_tmp48_ = _new_individual_it;
					_tmp49_ = gee_iterator_get (_tmp48_);
					new_individual = (FolksIndividual*) _tmp49_;
					_tmp52_ = old_individual;
					if (_tmp52_ != NULL) {
						FolksIndividual* _tmp53_;
						_tmp53_ = new_individual;
						_tmp51_ = _tmp53_ != NULL;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						GeeHashMap* _tmp54_;
						FolksIndividual* _tmp55_;
						gpointer _tmp56_;
						FolksIndividual* _tmp57_;
						FolksIndividual* _tmp58_;
						_tmp54_ = replaced_individuals;
						_tmp55_ = new_individual;
						_tmp56_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp54_, _tmp55_);
						_tmp57_ = (FolksIndividual*) _tmp56_;
						_tmp58_ = old_individual;
						_tmp50_ = _tmp57_ == _tmp58_;
						_g_object_unref0 (_tmp57_);
					} else {
						_tmp50_ = FALSE;
					}
					if (_tmp50_) {
						GeeHashSet* _tmp59_;
						GeeHashSet* _tmp61_;
						FolksIndividual* _tmp62_;
						_tmp59_ = replacements;
						if (_tmp59_ == NULL) {
							GeeHashSet* _tmp60_;
							_tmp60_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
							_g_object_unref0 (replacements);
							replacements = _tmp60_;
						}
						_tmp61_ = replacements;
						_tmp62_ = new_individual;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
					} else {
						FolksIndividual* _tmp63_;
						_tmp63_ = old_individual;
						if (_tmp63_ != NULL) {
							ContactsContact* c = NULL;
							FolksIndividual* _tmp64_;
							ContactsContact* _tmp65_;
							ContactsContact* _tmp66_;
							_tmp64_ = old_individual;
							_tmp65_ = contacts_contact_from_individual (_tmp64_);
							c = _tmp65_;
							_tmp66_ = c;
							contacts_store_remove (self, _tmp66_);
							_g_object_unref0 (c);
						} else {
							FolksIndividual* _tmp67_;
							_tmp67_ = new_individual;
							if (_tmp67_ != NULL) {
								FolksIndividual* _tmp68_;
								ContactsContact* _tmp69_;
								ContactsContact* _tmp70_;
								_tmp68_ = new_individual;
								_tmp69_ = contacts_contact_new (self, _tmp68_);
								_tmp70_ = _tmp69_;
								contacts_store_add (self, _tmp70_);
								_g_object_unref0 (_tmp70_);
							}
						}
					}
					_g_object_unref0 (new_individual);
				}
				_g_object_unref0 (_new_individual_it);
			}
			_tmp71_ = replacements;
			if (_tmp71_ != NULL) {
				FolksIndividual* main_individual = NULL;
				ContactsContact* c = NULL;
				FolksIndividual* _tmp82_;
				ContactsContact* _tmp83_;
				ContactsContact* _tmp84_;
				FolksIndividual* _tmp85_;
				main_individual = NULL;
				{
					GeeIterator* _i_it = NULL;
					GeeHashSet* _tmp72_;
					GeeIterator* _tmp73_;
					_tmp72_ = replacements;
					_tmp73_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp72_);
					_i_it = _tmp73_;
					while (TRUE) {
						GeeIterator* _tmp74_;
						gboolean _tmp75_;
						FolksIndividual* i = NULL;
						GeeIterator* _tmp76_;
						gpointer _tmp77_;
						FolksIndividual* _tmp78_;
						FolksIndividual* _tmp79_;
						FolksIndividual* _tmp80_;
						gboolean _tmp81_;
						_tmp74_ = _i_it;
						_tmp75_ = gee_iterator_next (_tmp74_);
						if (!_tmp75_) {
							break;
						}
						_tmp76_ = _i_it;
						_tmp77_ = gee_iterator_get (_tmp76_);
						i = (FolksIndividual*) _tmp77_;
						_tmp78_ = i;
						_tmp79_ = _g_object_ref0 (_tmp78_);
						_g_object_unref0 (main_individual);
						main_individual = _tmp79_;
						_tmp80_ = i;
						_tmp81_ = contacts_store_individual_can_replace_at_split (self, _tmp80_);
						if (_tmp81_) {
							_g_object_unref0 (i);
							break;
						}
						_g_object_unref0 (i);
					}
					_g_object_unref0 (_i_it);
				}
				_tmp82_ = old_individual;
				_tmp83_ = contacts_contact_from_individual (_tmp82_);
				c = _tmp83_;
				_tmp84_ = c;
				_tmp85_ = main_individual;
				contacts_contact_replace_individual (_tmp84_, _tmp85_);
				{
					GeeIterator* _i_it = NULL;
					GeeHashSet* _tmp86_;
					GeeIterator* _tmp87_;
					_tmp86_ = replacements;
					_tmp87_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp86_);
					_i_it = _tmp87_;
					while (TRUE) {
						GeeIterator* _tmp88_;
						gboolean _tmp89_;
						FolksIndividual* i = NULL;
						GeeIterator* _tmp90_;
						gpointer _tmp91_;
						FolksIndividual* _tmp92_;
						FolksIndividual* _tmp93_;
						_tmp88_ = _i_it;
						_tmp89_ = gee_iterator_next (_tmp88_);
						if (!_tmp89_) {
							break;
						}
						_tmp90_ = _i_it;
						_tmp91_ = gee_iterator_get (_tmp90_);
						i = (FolksIndividual*) _tmp91_;
						_tmp92_ = i;
						_tmp93_ = main_individual;
						if (_tmp92_ != _tmp93_) {
							FolksIndividual* _tmp94_;
							ContactsContact* _tmp95_;
							ContactsContact* _tmp96_;
							_tmp94_ = i;
							_tmp95_ = contacts_contact_new (self, _tmp94_);
							_tmp96_ = _tmp95_;
							contacts_store_add (self, _tmp96_);
							_g_object_unref0 (_tmp96_);
						}
						_g_object_unref0 (i);
					}
					_g_object_unref0 (_i_it);
				}
				_g_object_unref0 (c);
				_g_object_unref0 (main_individual);
			}
			_g_object_unref0 (replacements);
			_g_object_unref0 (old_individual);
		}
		_g_object_unref0 (_old_individual_it);
	}
	_g_object_unref0 (replaced_individuals);
}


static void __contacts_store___lambda20__folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender, GeeMultiMap* changes, gpointer self) {
	_contacts_store___lambda20_ ((ContactsStore*) self, changes);
}


static GObject * contacts_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ContactsStore * self;
	GeeArrayList* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	FolksBackendStore* _tmp2_;
	FolksBackendStore* _tmp3_;
	FolksBackendStore* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	FolksIndividualAggregator* _tmp8_;
	FolksIndividualAggregator* _tmp9_;
	FolksIndividualAggregator* _tmp10_;
	parent_class = G_OBJECT_CLASS (contacts_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_tmp0_ = gee_array_list_new (CONTACTS_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->dont_suggest_link);
	self->dont_suggest_link = _tmp1_;
	contacts_store_read_dont_suggest_db (self);
	_tmp2_ = folks_backend_store_dup ();
	_tmp3_ = _tmp2_;
	contacts_store_set_backend_store (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_backend_store;
	g_signal_connect_object (_tmp4_, "backend-available", (GCallback) __contacts_store___lambda13__folks_backend_store_backend_available, self, 0);
	_tmp5_ = folks_individual_aggregator_dup ();
	_tmp6_ = _tmp5_;
	contacts_store_set_aggregator (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::is-quiescent", (GCallback) __contacts_store___lambda16__g_object_notify, self, 0);
	_tmp8_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::is-prepared", (GCallback) __contacts_store___lambda18__g_object_notify, self, 0);
	_tmp9_ = self->priv->_aggregator;
	g_signal_connect_object (_tmp9_, "individuals-changed-detailed", (GCallback) __contacts_store___lambda20__folks_individual_aggregator_individuals_changed_detailed, self, 0);
	_tmp10_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp10_, NULL, NULL);
	contacts_store_check_call_capabilities (self, NULL, NULL);
	return obj;
}


static void contacts_store_class_init (ContactsStoreClass * klass) {
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_AGGREGATOR, g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_BACKEND_STORE, g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_CAN_CALL, g_param_spec_boolean ("can-call", "can-call", "can-call", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	contacts_store_signals[CONTACTS_STORE_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	contacts_store_signals[CONTACTS_STORE_ADDED_SIGNAL] = g_signal_new ("added", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	contacts_store_signals[CONTACTS_STORE_REMOVED_SIGNAL] = g_signal_new ("removed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	contacts_store_signals[CONTACTS_STORE_QUIESCENT_SIGNAL] = g_signal_new ("quiescent", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	contacts_store_signals[CONTACTS_STORE_PREPARED_SIGNAL] = g_signal_new ("prepared", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	contacts_store_signals[CONTACTS_STORE_EDS_PERSONA_STORE_CHANGED_SIGNAL] = g_signal_new ("eds_persona_store_changed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void contacts_store_instance_init (ContactsStore * self) {
	self->priv = CONTACTS_STORE_GET_PRIVATE (self);
}


static void contacts_store_finalize (GObject * obj) {
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->contacts);
	_g_object_unref0 (self->calling_accounts);
	_g_object_unref0 (self->dont_suggest_link);
	G_OBJECT_CLASS (contacts_store_parent_class)->finalize (obj);
}


GType contacts_store_get_type (void) {
	static volatile gsize contacts_store_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, NULL };
		GType contacts_store_type_id;
		contacts_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsStore", &g_define_type_info, 0);
		g_once_init_leave (&contacts_store_type_id__volatile, contacts_store_type_id);
	}
	return contacts_store_type_id__volatile;
}


static void _vala_contacts_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR:
		g_value_set_object (value, contacts_store_get_aggregator (self));
		break;
		case CONTACTS_STORE_BACKEND_STORE:
		g_value_set_object (value, contacts_store_get_backend_store (self));
		break;
		case CONTACTS_STORE_CAN_CALL:
		g_value_set_boolean (value, contacts_store_get_can_call (self));
		break;
		case CONTACTS_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, contacts_store_get_is_quiescent (self));
		break;
		case CONTACTS_STORE_IS_PREPARED:
		g_value_set_boolean (value, contacts_store_get_is_prepared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR:
		contacts_store_set_aggregator (self, g_value_get_object (value));
		break;
		case CONTACTS_STORE_BACKEND_STORE:
		contacts_store_set_backend_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



