/* currency.c generated by valac 0.36.4, the Vala compiler
 * generated from currency.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include <time.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define TYPE_CURRENCY_MANAGER (currency_manager_get_type ())
#define CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_MANAGER, CurrencyManager))
#define CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))
#define IS_CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_MANAGER))
#define IS_CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_MANAGER))
#define CURRENCY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))

typedef struct _CurrencyManager CurrencyManager;
typedef struct _CurrencyManagerClass CurrencyManagerClass;
typedef struct _CurrencyManagerPrivate CurrencyManagerPrivate;

#define TYPE_CURRENCY (currency_get_type ())
#define CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY, Currency))
#define CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY, CurrencyClass))
#define IS_CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY))
#define IS_CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY))
#define CURRENCY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY, CurrencyClass))

typedef struct _Currency Currency;
typedef struct _CurrencyClass CurrencyClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
typedef struct _CurrencyManagerDownloadFileData CurrencyManagerDownloadFileData;
enum  {
	CURRENCY_MANAGER_UPDATED_SIGNAL,
	CURRENCY_MANAGER_LAST_SIGNAL
};
static guint currency_manager_signals[CURRENCY_MANAGER_LAST_SIGNAL] = {0};
typedef struct _CurrencyPrivate CurrencyPrivate;

struct _CurrencyManager {
	GObject parent_instance;
	CurrencyManagerPrivate * priv;
};

struct _CurrencyManagerClass {
	GObjectClass parent_class;
};

struct _CurrencyManagerPrivate {
	GList* currencies;
};

struct _CurrencyManagerDownloadFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	CurrencyManager* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* dest;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	SoupSession* session;
	SoupSession* _tmp5_;
	SoupMessage* message;
	const gchar* _tmp6_;
	SoupMessage* _tmp7_;
	GInputStream* bodyinput;
	SoupSession* _tmp8_;
	SoupMessage* _tmp9_;
	GInputStream* _tmp10_;
	GFileOutputStream* output;
	GFile* _tmp11_;
	GFileOutputStream* _tmp12_;
	GFileOutputStream* _tmp13_;
	GInputStream* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _Currency {
	GObject parent_instance;
	CurrencyPrivate * priv;
};

struct _CurrencyClass {
	GObjectClass parent_class;
};

struct _CurrencyPrivate {
	Number* value;
	gchar* _name;
	gchar* _display_name;
	gchar* _symbol;
};


extern gboolean downloading_imf_rates;
gboolean downloading_imf_rates = FALSE;
extern gboolean downloading_ecb_rates;
gboolean downloading_ecb_rates = FALSE;
extern gboolean loaded_rates;
gboolean loaded_rates = FALSE;
extern CurrencyManager* default_currency_manager;
CurrencyManager* default_currency_manager = NULL;
static gpointer currency_manager_parent_class = NULL;
static gpointer currency_parent_class = NULL;

GType currency_manager_get_type (void) G_GNUC_CONST;
GType currency_get_type (void) G_GNUC_CONST;
#define CURRENCY_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CURRENCY_MANAGER, CurrencyManagerPrivate))
enum  {
	CURRENCY_MANAGER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
CurrencyManager* currency_manager_get_default (void);
CurrencyManager* currency_manager_new (void);
CurrencyManager* currency_manager_construct (GType object_type);
Currency* currency_new (const gchar* name, const gchar* display_name, const gchar* symbol);
Currency* currency_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* symbol);
static void currency_manager_download_rates (CurrencyManager* self);
GList* currency_manager_get_currencies (CurrencyManager* self);
Currency* currency_manager_get_currency (CurrencyManager* self, const gchar* name);
gchar* currency_get_name (Currency* self);
GType number_get_type (void) G_GNUC_CONST;
Number* currency_get_value (Currency* self);
gboolean number_is_negative (Number* self);
gboolean number_is_zero (Number* self);
static gchar* currency_manager_get_imf_rate_filepath (CurrencyManager* self);
static gchar* currency_manager_get_ecb_rate_filepath (CurrencyManager* self);
static Currency* currency_manager_add_currency (CurrencyManager* self, const gchar* short_name);
static gboolean currency_manager_file_needs_update (CurrencyManager* self, const gchar* filename, gdouble max_age);
static void currency_manager_load_imf_rates (CurrencyManager* self);
static void _g_free0_ (gpointer var);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_reciprocal (Number* self);
void currency_set_value (Currency* self, Number* value);
static void currency_manager_set_ecb_rate (CurrencyManager* self, xmlNode* node, Currency* eur_rate);
Number* number_multiply (Number* self, Number* y);
static void currency_manager_set_ecb_fixed_rate (CurrencyManager* self, const gchar* name, const gchar* value, Currency* eur_rate);
Number* number_divide (Number* self, Number* y);
static void currency_manager_load_ecb_rates (CurrencyManager* self);
static void currency_manager_download_file (CurrencyManager* self, const gchar* uri, const gchar* filename, const gchar* source, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void currency_manager_download_file_finish (CurrencyManager* self, GAsyncResult* _res_);
static gboolean currency_manager_load_rates (CurrencyManager* self);
Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency);
static void currency_manager_download_file_data_free (gpointer _data);
static void currency_manager_download_file_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean currency_manager_download_file_co (CurrencyManagerDownloadFileData* _data_);
static void currency_manager_download_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void currency_manager_finalize (GObject * obj);
#define CURRENCY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CURRENCY, CurrencyPrivate))
enum  {
	CURRENCY_DUMMY_PROPERTY,
	CURRENCY_NAME,
	CURRENCY_DISPLAY_NAME,
	CURRENCY_SYMBOL
};
gchar* currency_get_display_name (Currency* self);
gchar* currency_get_symbol (Currency* self);
static void currency_finalize (GObject * obj);
static void _vala_currency_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CurrencyManager* currency_manager_get_default (void) {
	CurrencyManager* result = NULL;
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp3_;
	CurrencyManager* _tmp4_;
	Currency* _tmp5_;
	CurrencyManager* _tmp6_;
	Currency* _tmp7_;
	CurrencyManager* _tmp8_;
	Currency* _tmp9_;
	CurrencyManager* _tmp10_;
	Currency* _tmp11_;
	CurrencyManager* _tmp12_;
	Currency* _tmp13_;
	CurrencyManager* _tmp14_;
	Currency* _tmp15_;
	CurrencyManager* _tmp16_;
	Currency* _tmp17_;
	CurrencyManager* _tmp18_;
	Currency* _tmp19_;
	CurrencyManager* _tmp20_;
	Currency* _tmp21_;
	CurrencyManager* _tmp22_;
	Currency* _tmp23_;
	CurrencyManager* _tmp24_;
	Currency* _tmp25_;
	CurrencyManager* _tmp26_;
	Currency* _tmp27_;
	CurrencyManager* _tmp28_;
	Currency* _tmp29_;
	CurrencyManager* _tmp30_;
	Currency* _tmp31_;
	CurrencyManager* _tmp32_;
	Currency* _tmp33_;
	CurrencyManager* _tmp34_;
	Currency* _tmp35_;
	CurrencyManager* _tmp36_;
	Currency* _tmp37_;
	CurrencyManager* _tmp38_;
	Currency* _tmp39_;
	CurrencyManager* _tmp40_;
	Currency* _tmp41_;
	CurrencyManager* _tmp42_;
	Currency* _tmp43_;
	CurrencyManager* _tmp44_;
	Currency* _tmp45_;
	CurrencyManager* _tmp46_;
	Currency* _tmp47_;
	CurrencyManager* _tmp48_;
	Currency* _tmp49_;
	CurrencyManager* _tmp50_;
	Currency* _tmp51_;
	CurrencyManager* _tmp52_;
	Currency* _tmp53_;
	CurrencyManager* _tmp54_;
	Currency* _tmp55_;
	CurrencyManager* _tmp56_;
	Currency* _tmp57_;
	CurrencyManager* _tmp58_;
	Currency* _tmp59_;
	CurrencyManager* _tmp60_;
	Currency* _tmp61_;
	CurrencyManager* _tmp62_;
	Currency* _tmp63_;
	CurrencyManager* _tmp64_;
	Currency* _tmp65_;
	CurrencyManager* _tmp66_;
	Currency* _tmp67_;
	CurrencyManager* _tmp68_;
	Currency* _tmp69_;
	CurrencyManager* _tmp70_;
	Currency* _tmp71_;
	CurrencyManager* _tmp72_;
	Currency* _tmp73_;
	CurrencyManager* _tmp74_;
	Currency* _tmp75_;
	CurrencyManager* _tmp76_;
	Currency* _tmp77_;
	CurrencyManager* _tmp78_;
	Currency* _tmp79_;
	CurrencyManager* _tmp80_;
	Currency* _tmp81_;
	CurrencyManager* _tmp82_;
	Currency* _tmp83_;
	CurrencyManager* _tmp84_;
	Currency* _tmp85_;
	CurrencyManager* _tmp86_;
	Currency* _tmp87_;
	CurrencyManager* _tmp88_;
	Currency* _tmp89_;
	CurrencyManager* _tmp90_;
	Currency* _tmp91_;
	CurrencyManager* _tmp92_;
	Currency* _tmp93_;
	CurrencyManager* _tmp94_;
	Currency* _tmp95_;
	CurrencyManager* _tmp96_;
	Currency* _tmp97_;
	CurrencyManager* _tmp98_;
	Currency* _tmp99_;
	CurrencyManager* _tmp100_;
	Currency* _tmp101_;
	CurrencyManager* _tmp102_;
	Currency* _tmp103_;
	CurrencyManager* _tmp104_;
	Currency* _tmp105_;
	CurrencyManager* _tmp106_;
	Currency* _tmp107_;
	CurrencyManager* _tmp108_;
	Currency* _tmp109_;
	CurrencyManager* _tmp110_;
	Currency* _tmp111_;
	CurrencyManager* _tmp112_;
	Currency* _tmp113_;
	CurrencyManager* _tmp114_;
	Currency* _tmp115_;
	CurrencyManager* _tmp116_;
	Currency* _tmp117_;
	CurrencyManager* _tmp118_;
	Currency* _tmp119_;
	CurrencyManager* _tmp120_;
	CurrencyManager* _tmp121_;
	CurrencyManager* _tmp122_;
	_tmp0_ = default_currency_manager;
	if (_tmp0_ != NULL) {
		CurrencyManager* _tmp1_;
		CurrencyManager* _tmp2_;
		_tmp1_ = default_currency_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = currency_manager_new ();
	_g_object_unref0 (default_currency_manager);
	default_currency_manager = _tmp3_;
	_tmp4_ = default_currency_manager;
	_tmp5_ = currency_new ("AED", _ ("UAE Dirham"), "إ.د");
	_tmp4_->priv->currencies = g_list_append (_tmp4_->priv->currencies, _tmp5_);
	_tmp6_ = default_currency_manager;
	_tmp7_ = currency_new ("AUD", _ ("Australian Dollar"), "$");
	_tmp6_->priv->currencies = g_list_append (_tmp6_->priv->currencies, _tmp7_);
	_tmp8_ = default_currency_manager;
	_tmp9_ = currency_new ("BGN", _ ("Bulgarian Lev"), "лв");
	_tmp8_->priv->currencies = g_list_append (_tmp8_->priv->currencies, _tmp9_);
	_tmp10_ = default_currency_manager;
	_tmp11_ = currency_new ("BHD", _ ("Bahraini Dinar"), ".ب.د");
	_tmp10_->priv->currencies = g_list_append (_tmp10_->priv->currencies, _tmp11_);
	_tmp12_ = default_currency_manager;
	_tmp13_ = currency_new ("BND", _ ("Brunei Dollar"), "$");
	_tmp12_->priv->currencies = g_list_append (_tmp12_->priv->currencies, _tmp13_);
	_tmp14_ = default_currency_manager;
	_tmp15_ = currency_new ("BRL", _ ("Brazilian Real"), "R$");
	_tmp14_->priv->currencies = g_list_append (_tmp14_->priv->currencies, _tmp15_);
	_tmp16_ = default_currency_manager;
	_tmp17_ = currency_new ("BWP", _ ("Botswana Pula"), "P");
	_tmp16_->priv->currencies = g_list_append (_tmp16_->priv->currencies, _tmp17_);
	_tmp18_ = default_currency_manager;
	_tmp19_ = currency_new ("CAD", _ ("Canadian Dollar"), "$");
	_tmp18_->priv->currencies = g_list_append (_tmp18_->priv->currencies, _tmp19_);
	_tmp20_ = default_currency_manager;
	_tmp21_ = currency_new ("CFA", _ ("CFA Franc"), "Fr");
	_tmp20_->priv->currencies = g_list_append (_tmp20_->priv->currencies, _tmp21_);
	_tmp22_ = default_currency_manager;
	_tmp23_ = currency_new ("CHF", _ ("Swiss Franc"), "Fr");
	_tmp22_->priv->currencies = g_list_append (_tmp22_->priv->currencies, _tmp23_);
	_tmp24_ = default_currency_manager;
	_tmp25_ = currency_new ("CLP", _ ("Chilean Peso"), "$");
	_tmp24_->priv->currencies = g_list_append (_tmp24_->priv->currencies, _tmp25_);
	_tmp26_ = default_currency_manager;
	_tmp27_ = currency_new ("CNY", _ ("Chinese Yuan"), "¥");
	_tmp26_->priv->currencies = g_list_append (_tmp26_->priv->currencies, _tmp27_);
	_tmp28_ = default_currency_manager;
	_tmp29_ = currency_new ("COP", _ ("Colombian Peso"), "$");
	_tmp28_->priv->currencies = g_list_append (_tmp28_->priv->currencies, _tmp29_);
	_tmp30_ = default_currency_manager;
	_tmp31_ = currency_new ("CZK", _ ("Czech Koruna"), "Kč");
	_tmp30_->priv->currencies = g_list_append (_tmp30_->priv->currencies, _tmp31_);
	_tmp32_ = default_currency_manager;
	_tmp33_ = currency_new ("DKK", _ ("Danish Krone"), "kr");
	_tmp32_->priv->currencies = g_list_append (_tmp32_->priv->currencies, _tmp33_);
	_tmp34_ = default_currency_manager;
	_tmp35_ = currency_new ("DZD", _ ("Algerian Dinar"), "ج.د");
	_tmp34_->priv->currencies = g_list_append (_tmp34_->priv->currencies, _tmp35_);
	_tmp36_ = default_currency_manager;
	_tmp37_ = currency_new ("EEK", _ ("Estonian Kroon"), "KR");
	_tmp36_->priv->currencies = g_list_append (_tmp36_->priv->currencies, _tmp37_);
	_tmp38_ = default_currency_manager;
	_tmp39_ = currency_new ("EUR", _ ("Euro"), "€");
	_tmp38_->priv->currencies = g_list_append (_tmp38_->priv->currencies, _tmp39_);
	_tmp40_ = default_currency_manager;
	_tmp41_ = currency_new ("GBP", _ ("British Pound Sterling"), "£");
	_tmp40_->priv->currencies = g_list_append (_tmp40_->priv->currencies, _tmp41_);
	_tmp42_ = default_currency_manager;
	_tmp43_ = currency_new ("HKD", _ ("Hong Kong Dollar"), "$");
	_tmp42_->priv->currencies = g_list_append (_tmp42_->priv->currencies, _tmp43_);
	_tmp44_ = default_currency_manager;
	_tmp45_ = currency_new ("HRK", _ ("Croatian Kuna"), "kn");
	_tmp44_->priv->currencies = g_list_append (_tmp44_->priv->currencies, _tmp45_);
	_tmp46_ = default_currency_manager;
	_tmp47_ = currency_new ("HUF", _ ("Hungarian Forint"), "Ft");
	_tmp46_->priv->currencies = g_list_append (_tmp46_->priv->currencies, _tmp47_);
	_tmp48_ = default_currency_manager;
	_tmp49_ = currency_new ("IDR", _ ("Indonesian Rupiah"), "Rp");
	_tmp48_->priv->currencies = g_list_append (_tmp48_->priv->currencies, _tmp49_);
	_tmp50_ = default_currency_manager;
	_tmp51_ = currency_new ("ILS", _ ("Israeli New Shekel"), "₪");
	_tmp50_->priv->currencies = g_list_append (_tmp50_->priv->currencies, _tmp51_);
	_tmp52_ = default_currency_manager;
	_tmp53_ = currency_new ("INR", _ ("Indian Rupee"), "₹");
	_tmp52_->priv->currencies = g_list_append (_tmp52_->priv->currencies, _tmp53_);
	_tmp54_ = default_currency_manager;
	_tmp55_ = currency_new ("IRR", _ ("Iranian Rial"), "﷼");
	_tmp54_->priv->currencies = g_list_append (_tmp54_->priv->currencies, _tmp55_);
	_tmp56_ = default_currency_manager;
	_tmp57_ = currency_new ("ISK", _ ("Icelandic Krona"), "kr");
	_tmp56_->priv->currencies = g_list_append (_tmp56_->priv->currencies, _tmp57_);
	_tmp58_ = default_currency_manager;
	_tmp59_ = currency_new ("JPY", _ ("Japanese Yen"), "¥");
	_tmp58_->priv->currencies = g_list_append (_tmp58_->priv->currencies, _tmp59_);
	_tmp60_ = default_currency_manager;
	_tmp61_ = currency_new ("KRW", _ ("South Korean Won"), "₩");
	_tmp60_->priv->currencies = g_list_append (_tmp60_->priv->currencies, _tmp61_);
	_tmp62_ = default_currency_manager;
	_tmp63_ = currency_new ("KWD", _ ("Kuwaiti Dinar"), "ك.د");
	_tmp62_->priv->currencies = g_list_append (_tmp62_->priv->currencies, _tmp63_);
	_tmp64_ = default_currency_manager;
	_tmp65_ = currency_new ("KZT", _ ("Kazakhstani Tenge"), "₸");
	_tmp64_->priv->currencies = g_list_append (_tmp64_->priv->currencies, _tmp65_);
	_tmp66_ = default_currency_manager;
	_tmp67_ = currency_new ("LKR", _ ("Sri Lankan Rupee"), "Rs");
	_tmp66_->priv->currencies = g_list_append (_tmp66_->priv->currencies, _tmp67_);
	_tmp68_ = default_currency_manager;
	_tmp69_ = currency_new ("LYD", _ ("Libyan Dinar"), "د.ل");
	_tmp68_->priv->currencies = g_list_append (_tmp68_->priv->currencies, _tmp69_);
	_tmp70_ = default_currency_manager;
	_tmp71_ = currency_new ("MUR", _ ("Mauritian Rupee"), "Rs");
	_tmp70_->priv->currencies = g_list_append (_tmp70_->priv->currencies, _tmp71_);
	_tmp72_ = default_currency_manager;
	_tmp73_ = currency_new ("MXN", _ ("Mexican Peso"), "$");
	_tmp72_->priv->currencies = g_list_append (_tmp72_->priv->currencies, _tmp73_);
	_tmp74_ = default_currency_manager;
	_tmp75_ = currency_new ("MYR", _ ("Malaysian Ringgit"), "RM");
	_tmp74_->priv->currencies = g_list_append (_tmp74_->priv->currencies, _tmp75_);
	_tmp76_ = default_currency_manager;
	_tmp77_ = currency_new ("NOK", _ ("Norwegian Krone"), "kr");
	_tmp76_->priv->currencies = g_list_append (_tmp76_->priv->currencies, _tmp77_);
	_tmp78_ = default_currency_manager;
	_tmp79_ = currency_new ("NPR", _ ("Nepalese Rupee"), "Rs");
	_tmp78_->priv->currencies = g_list_append (_tmp78_->priv->currencies, _tmp79_);
	_tmp80_ = default_currency_manager;
	_tmp81_ = currency_new ("NZD", _ ("New Zealand Dollar"), "$");
	_tmp80_->priv->currencies = g_list_append (_tmp80_->priv->currencies, _tmp81_);
	_tmp82_ = default_currency_manager;
	_tmp83_ = currency_new ("OMR", _ ("Omani Rial"), "ع.ر.");
	_tmp82_->priv->currencies = g_list_append (_tmp82_->priv->currencies, _tmp83_);
	_tmp84_ = default_currency_manager;
	_tmp85_ = currency_new ("PEN", _ ("Peruvian Nuevo Sol"), "S/.");
	_tmp84_->priv->currencies = g_list_append (_tmp84_->priv->currencies, _tmp85_);
	_tmp86_ = default_currency_manager;
	_tmp87_ = currency_new ("PHP", _ ("Philippine Peso"), "₱");
	_tmp86_->priv->currencies = g_list_append (_tmp86_->priv->currencies, _tmp87_);
	_tmp88_ = default_currency_manager;
	_tmp89_ = currency_new ("PKR", _ ("Pakistani Rupee"), "Rs");
	_tmp88_->priv->currencies = g_list_append (_tmp88_->priv->currencies, _tmp89_);
	_tmp90_ = default_currency_manager;
	_tmp91_ = currency_new ("PLN", _ ("Polish Zloty"), "zł");
	_tmp90_->priv->currencies = g_list_append (_tmp90_->priv->currencies, _tmp91_);
	_tmp92_ = default_currency_manager;
	_tmp93_ = currency_new ("QAR", _ ("Qatari Riyal"), "ق.ر");
	_tmp92_->priv->currencies = g_list_append (_tmp92_->priv->currencies, _tmp93_);
	_tmp94_ = default_currency_manager;
	_tmp95_ = currency_new ("RON", _ ("New Romanian Leu"), "L");
	_tmp94_->priv->currencies = g_list_append (_tmp94_->priv->currencies, _tmp95_);
	_tmp96_ = default_currency_manager;
	_tmp97_ = currency_new ("RUB", _ ("Russian Rouble"), "руб.");
	_tmp96_->priv->currencies = g_list_append (_tmp96_->priv->currencies, _tmp97_);
	_tmp98_ = default_currency_manager;
	_tmp99_ = currency_new ("SAR", _ ("Saudi Riyal"), "س.ر");
	_tmp98_->priv->currencies = g_list_append (_tmp98_->priv->currencies, _tmp99_);
	_tmp100_ = default_currency_manager;
	_tmp101_ = currency_new ("SEK", _ ("Swedish Krona"), "kr");
	_tmp100_->priv->currencies = g_list_append (_tmp100_->priv->currencies, _tmp101_);
	_tmp102_ = default_currency_manager;
	_tmp103_ = currency_new ("SGD", _ ("Singapore Dollar"), "$");
	_tmp102_->priv->currencies = g_list_append (_tmp102_->priv->currencies, _tmp103_);
	_tmp104_ = default_currency_manager;
	_tmp105_ = currency_new ("THB", _ ("Thai Baht"), "฿");
	_tmp104_->priv->currencies = g_list_append (_tmp104_->priv->currencies, _tmp105_);
	_tmp106_ = default_currency_manager;
	_tmp107_ = currency_new ("TND", _ ("Tunisian Dinar"), "ت.د");
	_tmp106_->priv->currencies = g_list_append (_tmp106_->priv->currencies, _tmp107_);
	_tmp108_ = default_currency_manager;
	_tmp109_ = currency_new ("TRY", _ ("New Turkish Lira"), "TL");
	_tmp108_->priv->currencies = g_list_append (_tmp108_->priv->currencies, _tmp109_);
	_tmp110_ = default_currency_manager;
	_tmp111_ = currency_new ("TTD", _ ("T&T Dollar (TTD)"), "$");
	_tmp110_->priv->currencies = g_list_append (_tmp110_->priv->currencies, _tmp111_);
	_tmp112_ = default_currency_manager;
	_tmp113_ = currency_new ("USD", _ ("US Dollar"), "$");
	_tmp112_->priv->currencies = g_list_append (_tmp112_->priv->currencies, _tmp113_);
	_tmp114_ = default_currency_manager;
	_tmp115_ = currency_new ("UYU", _ ("Uruguayan Peso"), "$");
	_tmp114_->priv->currencies = g_list_append (_tmp114_->priv->currencies, _tmp115_);
	_tmp116_ = default_currency_manager;
	_tmp117_ = currency_new ("VEF", _ ("Venezuelan Bolívar"), "Bs F");
	_tmp116_->priv->currencies = g_list_append (_tmp116_->priv->currencies, _tmp117_);
	_tmp118_ = default_currency_manager;
	_tmp119_ = currency_new ("ZAR", _ ("South African Rand"), "R");
	_tmp118_->priv->currencies = g_list_append (_tmp118_->priv->currencies, _tmp119_);
	_tmp120_ = default_currency_manager;
	currency_manager_download_rates (_tmp120_);
	_tmp121_ = default_currency_manager;
	_tmp122_ = _g_object_ref0 (_tmp121_);
	result = _tmp122_;
	return result;
}


GList* currency_manager_get_currencies (CurrencyManager* self) {
	GList* result = NULL;
	GList* r = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				Currency* _tmp3_;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}


Currency* currency_manager_get_currency (CurrencyManager* self, const gchar* name) {
	Currency* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				const gchar* _tmp2_;
				Currency* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = name;
				_tmp3_ = c;
				_tmp4_ = currency_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp2_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					Number* value = NULL;
					Currency* _tmp8_;
					Number* _tmp9_;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					Number* _tmp12_;
					_tmp8_ = c;
					_tmp9_ = currency_get_value (_tmp8_);
					value = _tmp9_;
					_tmp12_ = value;
					if (_tmp12_ == NULL) {
						_tmp11_ = TRUE;
					} else {
						Number* _tmp13_;
						gboolean _tmp14_;
						_tmp13_ = value;
						_tmp14_ = number_is_negative (_tmp13_);
						_tmp11_ = _tmp14_;
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						Number* _tmp15_;
						gboolean _tmp16_;
						_tmp15_ = value;
						_tmp16_ = number_is_zero (_tmp15_);
						_tmp10_ = _tmp16_;
					}
					if (_tmp10_) {
						result = NULL;
						_g_object_unref0 (value);
						_g_object_unref0 (c);
						return result;
					} else {
						result = c;
						_g_object_unref0 (value);
						return result;
					}
					_g_object_unref0 (value);
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* currency_manager_get_imf_rate_filepath (CurrencyManager* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "rms_five.xls", NULL);
	result = _tmp1_;
	return result;
}


static gchar* currency_manager_get_ecb_rate_filepath (CurrencyManager* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "eurofxref-daily.xml", NULL);
	result = _tmp1_;
	return result;
}


static Currency* currency_manager_add_currency (CurrencyManager* self, const gchar* short_name) {
	Currency* result = NULL;
	GList* _tmp0_;
	const gchar* _tmp8_;
	Currency* c = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	Currency* _tmp12_;
	Currency* _tmp13_;
	Currency* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (short_name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = c;
				_tmp3_ = currency_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = short_name;
				_tmp7_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp7_) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	_tmp8_ = short_name;
	g_warning ("currency.vala:134: Currency %s is not in the currency table", _tmp8_);
	_tmp9_ = short_name;
	_tmp10_ = short_name;
	_tmp11_ = short_name;
	_tmp12_ = currency_new (_tmp9_, _tmp10_, _tmp11_);
	c = _tmp12_;
	_tmp13_ = c;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	self->priv->currencies = g_list_append (self->priv->currencies, _tmp14_);
	result = c;
	return result;
}


static gboolean currency_manager_file_needs_update (CurrencyManager* self, const gchar* filename, gdouble max_age) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	struct stat buf = {0};
	const gchar* _tmp2_;
	struct stat _tmp3_ = {0};
	gint _tmp4_;
	time_t modify_time = 0;
	struct stat _tmp5_;
	time_t _tmp6_;
	time_t now = 0;
	time_t _tmp7_;
	time_t _tmp8_;
	time_t _tmp9_;
	gdouble _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_IS_REGULAR);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	memset (&buf, 0, sizeof (struct stat));
	_tmp2_ = filename;
	_tmp4_ = stat (_tmp2_, &_tmp3_);
	buf = _tmp3_;
	if (_tmp4_ == -1) {
		result = TRUE;
		return result;
	}
	_tmp5_ = buf;
	_tmp6_ = _tmp5_.st_mtime;
	modify_time = _tmp6_;
	_tmp7_ = time (NULL);
	now = _tmp7_;
	_tmp8_ = now;
	_tmp9_ = modify_time;
	_tmp10_ = max_age;
	if (((gdouble) (_tmp8_ - _tmp9_)) > _tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchug (_tmp1_);
	result = _result_;
	return result;
}


static void currency_manager_load_imf_rates (CurrencyManager* self) {
	GHashTable* name_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GHashTable* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GHashTable* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GHashTable* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GHashTable* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GHashTable* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GHashTable* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GHashTable* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	GHashTable* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GHashTable* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GHashTable* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	GHashTable* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GHashTable* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	GHashTable* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GHashTable* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GHashTable* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	GHashTable* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	GHashTable* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GHashTable* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	GHashTable* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GHashTable* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	GHashTable* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	GHashTable* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	GHashTable* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GHashTable* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	GHashTable* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	GHashTable* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	GHashTable* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	GHashTable* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	GHashTable* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	GHashTable* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	GHashTable* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	GHashTable* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	GHashTable* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	GHashTable* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	GHashTable* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	GHashTable* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	GHashTable* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	GHashTable* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	GHashTable* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	GHashTable* _tmp153_;
	gchar* _tmp154_;
	gchar* _tmp155_;
	gchar* filename = NULL;
	gchar* _tmp156_;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp161_;
	gchar** _tmp162_;
	gchar** _tmp163_;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data = FALSE;
	gchar** _tmp164_;
	gint _tmp164__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = name_map;
	_tmp4_ = g_strdup ("Euro");
	_tmp5_ = g_strdup ("EUR");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = name_map;
	_tmp7_ = g_strdup ("Japanese Yen");
	_tmp8_ = g_strdup ("JPY");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = name_map;
	_tmp10_ = g_strdup ("U.K. Pound Sterling");
	_tmp11_ = g_strdup ("GBP");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = name_map;
	_tmp13_ = g_strdup ("U.S. Dollar");
	_tmp14_ = g_strdup ("USD");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = name_map;
	_tmp16_ = g_strdup ("Algerian Dinar");
	_tmp17_ = g_strdup ("DZD");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = name_map;
	_tmp19_ = g_strdup ("Australian Dollar");
	_tmp20_ = g_strdup ("AUD");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = name_map;
	_tmp22_ = g_strdup ("Bahrain Dinar");
	_tmp23_ = g_strdup ("BHD");
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = name_map;
	_tmp25_ = g_strdup ("Botswana Pula");
	_tmp26_ = g_strdup ("BWP");
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = name_map;
	_tmp28_ = g_strdup ("Brazilian Real");
	_tmp29_ = g_strdup ("BRL");
	g_hash_table_insert (_tmp27_, _tmp28_, _tmp29_);
	_tmp30_ = name_map;
	_tmp31_ = g_strdup ("Brunei Dollar");
	_tmp32_ = g_strdup ("BND");
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
	_tmp33_ = name_map;
	_tmp34_ = g_strdup ("Canadian Dollar");
	_tmp35_ = g_strdup ("CAD");
	g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = name_map;
	_tmp37_ = g_strdup ("Chilean Peso");
	_tmp38_ = g_strdup ("CLP");
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = name_map;
	_tmp40_ = g_strdup ("Chinese Yuan");
	_tmp41_ = g_strdup ("CNY");
	g_hash_table_insert (_tmp39_, _tmp40_, _tmp41_);
	_tmp42_ = name_map;
	_tmp43_ = g_strdup ("Colombian Peso");
	_tmp44_ = g_strdup ("COP");
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp44_);
	_tmp45_ = name_map;
	_tmp46_ = g_strdup ("Czech Koruna");
	_tmp47_ = g_strdup ("CZK");
	g_hash_table_insert (_tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = name_map;
	_tmp49_ = g_strdup ("Danish Krone");
	_tmp50_ = g_strdup ("DKK");
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp50_);
	_tmp51_ = name_map;
	_tmp52_ = g_strdup ("Hungarian Forint");
	_tmp53_ = g_strdup ("HUF");
	g_hash_table_insert (_tmp51_, _tmp52_, _tmp53_);
	_tmp54_ = name_map;
	_tmp55_ = g_strdup ("Icelandic Krona");
	_tmp56_ = g_strdup ("ISK");
	g_hash_table_insert (_tmp54_, _tmp55_, _tmp56_);
	_tmp57_ = name_map;
	_tmp58_ = g_strdup ("Indian Rupee");
	_tmp59_ = g_strdup ("INR");
	g_hash_table_insert (_tmp57_, _tmp58_, _tmp59_);
	_tmp60_ = name_map;
	_tmp61_ = g_strdup ("Indonesian Rupiah");
	_tmp62_ = g_strdup ("IDR");
	g_hash_table_insert (_tmp60_, _tmp61_, _tmp62_);
	_tmp63_ = name_map;
	_tmp64_ = g_strdup ("Iranian Rial");
	_tmp65_ = g_strdup ("IRR");
	g_hash_table_insert (_tmp63_, _tmp64_, _tmp65_);
	_tmp66_ = name_map;
	_tmp67_ = g_strdup ("Israeli New Sheqel");
	_tmp68_ = g_strdup ("ILS");
	g_hash_table_insert (_tmp66_, _tmp67_, _tmp68_);
	_tmp69_ = name_map;
	_tmp70_ = g_strdup ("Kazakhstani Tenge");
	_tmp71_ = g_strdup ("KZT");
	g_hash_table_insert (_tmp69_, _tmp70_, _tmp71_);
	_tmp72_ = name_map;
	_tmp73_ = g_strdup ("Korean Won");
	_tmp74_ = g_strdup ("KRW");
	g_hash_table_insert (_tmp72_, _tmp73_, _tmp74_);
	_tmp75_ = name_map;
	_tmp76_ = g_strdup ("Kuwaiti Dinar");
	_tmp77_ = g_strdup ("KWD");
	g_hash_table_insert (_tmp75_, _tmp76_, _tmp77_);
	_tmp78_ = name_map;
	_tmp79_ = g_strdup ("Libyan Dinar");
	_tmp80_ = g_strdup ("LYD");
	g_hash_table_insert (_tmp78_, _tmp79_, _tmp80_);
	_tmp81_ = name_map;
	_tmp82_ = g_strdup ("Malaysian Ringgit");
	_tmp83_ = g_strdup ("MYR");
	g_hash_table_insert (_tmp81_, _tmp82_, _tmp83_);
	_tmp84_ = name_map;
	_tmp85_ = g_strdup ("Mauritian Rupee");
	_tmp86_ = g_strdup ("MUR");
	g_hash_table_insert (_tmp84_, _tmp85_, _tmp86_);
	_tmp87_ = name_map;
	_tmp88_ = g_strdup ("Mexican Peso");
	_tmp89_ = g_strdup ("MXN");
	g_hash_table_insert (_tmp87_, _tmp88_, _tmp89_);
	_tmp90_ = name_map;
	_tmp91_ = g_strdup ("Nepalese Rupee");
	_tmp92_ = g_strdup ("NPR");
	g_hash_table_insert (_tmp90_, _tmp91_, _tmp92_);
	_tmp93_ = name_map;
	_tmp94_ = g_strdup ("New Zealand Dollar");
	_tmp95_ = g_strdup ("NZD");
	g_hash_table_insert (_tmp93_, _tmp94_, _tmp95_);
	_tmp96_ = name_map;
	_tmp97_ = g_strdup ("Norwegian Krone");
	_tmp98_ = g_strdup ("NOK");
	g_hash_table_insert (_tmp96_, _tmp97_, _tmp98_);
	_tmp99_ = name_map;
	_tmp100_ = g_strdup ("Rial Omani");
	_tmp101_ = g_strdup ("OMR");
	g_hash_table_insert (_tmp99_, _tmp100_, _tmp101_);
	_tmp102_ = name_map;
	_tmp103_ = g_strdup ("Pakistani Rupee");
	_tmp104_ = g_strdup ("PKR");
	g_hash_table_insert (_tmp102_, _tmp103_, _tmp104_);
	_tmp105_ = name_map;
	_tmp106_ = g_strdup ("Nuevo Sol");
	_tmp107_ = g_strdup ("PEN");
	g_hash_table_insert (_tmp105_, _tmp106_, _tmp107_);
	_tmp108_ = name_map;
	_tmp109_ = g_strdup ("Philippine Peso");
	_tmp110_ = g_strdup ("PHP");
	g_hash_table_insert (_tmp108_, _tmp109_, _tmp110_);
	_tmp111_ = name_map;
	_tmp112_ = g_strdup ("Polish Zloty");
	_tmp113_ = g_strdup ("PLN");
	g_hash_table_insert (_tmp111_, _tmp112_, _tmp113_);
	_tmp114_ = name_map;
	_tmp115_ = g_strdup ("Qatar Riyal");
	_tmp116_ = g_strdup ("QAR");
	g_hash_table_insert (_tmp114_, _tmp115_, _tmp116_);
	_tmp117_ = name_map;
	_tmp118_ = g_strdup ("Russian Ruble");
	_tmp119_ = g_strdup ("RUB");
	g_hash_table_insert (_tmp117_, _tmp118_, _tmp119_);
	_tmp120_ = name_map;
	_tmp121_ = g_strdup ("Saudi Arabian Riyal");
	_tmp122_ = g_strdup ("SAR");
	g_hash_table_insert (_tmp120_, _tmp121_, _tmp122_);
	_tmp123_ = name_map;
	_tmp124_ = g_strdup ("Singapore Dollar");
	_tmp125_ = g_strdup ("SGD");
	g_hash_table_insert (_tmp123_, _tmp124_, _tmp125_);
	_tmp126_ = name_map;
	_tmp127_ = g_strdup ("South African Rand");
	_tmp128_ = g_strdup ("ZAR");
	g_hash_table_insert (_tmp126_, _tmp127_, _tmp128_);
	_tmp129_ = name_map;
	_tmp130_ = g_strdup ("Sri Lanka Rupee");
	_tmp131_ = g_strdup ("LKR");
	g_hash_table_insert (_tmp129_, _tmp130_, _tmp131_);
	_tmp132_ = name_map;
	_tmp133_ = g_strdup ("Swedish Krona");
	_tmp134_ = g_strdup ("SEK");
	g_hash_table_insert (_tmp132_, _tmp133_, _tmp134_);
	_tmp135_ = name_map;
	_tmp136_ = g_strdup ("Swiss Franc");
	_tmp137_ = g_strdup ("CHF");
	g_hash_table_insert (_tmp135_, _tmp136_, _tmp137_);
	_tmp138_ = name_map;
	_tmp139_ = g_strdup ("Thai Baht");
	_tmp140_ = g_strdup ("THB");
	g_hash_table_insert (_tmp138_, _tmp139_, _tmp140_);
	_tmp141_ = name_map;
	_tmp142_ = g_strdup ("Trinidad And Tobago Dollar");
	_tmp143_ = g_strdup ("TTD");
	g_hash_table_insert (_tmp141_, _tmp142_, _tmp143_);
	_tmp144_ = name_map;
	_tmp145_ = g_strdup ("Tunisian Dinar");
	_tmp146_ = g_strdup ("TND");
	g_hash_table_insert (_tmp144_, _tmp145_, _tmp146_);
	_tmp147_ = name_map;
	_tmp148_ = g_strdup ("U.A.E. Dirham");
	_tmp149_ = g_strdup ("AED");
	g_hash_table_insert (_tmp147_, _tmp148_, _tmp149_);
	_tmp150_ = name_map;
	_tmp151_ = g_strdup ("Peso Uruguayo");
	_tmp152_ = g_strdup ("UYU");
	g_hash_table_insert (_tmp150_, _tmp151_, _tmp152_);
	_tmp153_ = name_map;
	_tmp154_ = g_strdup ("Bolivar Fuerte");
	_tmp155_ = g_strdup ("VEF");
	g_hash_table_insert (_tmp153_, _tmp154_, _tmp155_);
	_tmp156_ = currency_manager_get_imf_rate_filepath (self);
	filename = _tmp156_;
	{
		const gchar* _tmp157_;
		gchar* _tmp158_ = NULL;
		_tmp157_ = filename;
		g_file_get_contents (_tmp157_, &_tmp158_, NULL, &_inner_error_);
		_g_free0 (data);
		data = _tmp158_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp159_;
		const gchar* _tmp160_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp159_ = e;
		_tmp160_ = _tmp159_->message;
		g_warning ("currency.vala:224: Failed to read exchange rates: %s", _tmp160_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (filename);
		_g_hash_table_unref0 (name_map);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_free0 (filename);
		_g_hash_table_unref0 (name_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp161_ = data;
	_tmp163_ = _tmp162_ = g_strsplit (_tmp161_, "\n", 0);
	lines = _tmp163_;
	lines_length1 = _vala_array_length (_tmp162_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp164_ = lines;
	_tmp164__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp164_;
		line_collection_length1 = _tmp164__length1;
		for (line_it = 0; line_it < _tmp164__length1; line_it = line_it + 1) {
			gchar* _tmp165_;
			gchar* line = NULL;
			_tmp165_ = g_strdup (line_collection[line_it]);
			line = _tmp165_;
			{
				const gchar* _tmp166_;
				gchar* _tmp167_;
				const gchar* _tmp168_;
				gboolean _tmp170_;
				gchar** tokens = NULL;
				const gchar* _tmp171_;
				gchar** _tmp172_;
				gchar** _tmp173_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp174_;
				gint _tmp174__length1;
				const gchar* _tmp175_;
				_tmp166_ = line;
				_tmp167_ = string_chug (_tmp166_);
				_g_free0 (line);
				line = _tmp167_;
				_tmp168_ = line;
				if (g_strcmp0 (_tmp168_, "") == 0) {
					gboolean _tmp169_;
					_tmp169_ = in_data;
					if (!_tmp169_) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				_tmp170_ = in_data;
				if (!_tmp170_) {
					_g_free0 (line);
					continue;
				}
				_tmp171_ = line;
				_tmp173_ = _tmp172_ = g_strsplit (_tmp171_, "\t", 0);
				tokens = _tmp173_;
				tokens_length1 = _vala_array_length (_tmp172_);
				_tokens_size_ = tokens_length1;
				_tmp174_ = tokens;
				_tmp174__length1 = tokens_length1;
				_tmp175_ = _tmp174_[0];
				if (g_strcmp0 (_tmp175_, "Currency") != 0) {
					gint value_index = 0;
					gint _tmp185_;
					gchar** _tmp186_;
					gint _tmp186__length1;
					{
						gboolean _tmp176_ = FALSE;
						value_index = 1;
						_tmp176_ = TRUE;
						while (TRUE) {
							gint _tmp178_;
							gchar** _tmp179_;
							gint _tmp179__length1;
							gchar* value = NULL;
							gchar** _tmp180_;
							gint _tmp180__length1;
							gint _tmp181_;
							const gchar* _tmp182_;
							gchar* _tmp183_;
							const gchar* _tmp184_;
							if (!_tmp176_) {
								gint _tmp177_;
								_tmp177_ = value_index;
								value_index = _tmp177_ + 1;
							}
							_tmp176_ = FALSE;
							_tmp178_ = value_index;
							_tmp179_ = tokens;
							_tmp179__length1 = tokens_length1;
							if (!(_tmp178_ < _tmp179__length1)) {
								break;
							}
							_tmp180_ = tokens;
							_tmp180__length1 = tokens_length1;
							_tmp181_ = value_index;
							_tmp182_ = _tmp180_[_tmp181_];
							_tmp183_ = string_chug (_tmp182_);
							value = _tmp183_;
							_tmp184_ = value;
							if (g_strcmp0 (_tmp184_, "") != 0) {
								_g_free0 (value);
								break;
							}
							_g_free0 (value);
						}
					}
					_tmp185_ = value_index;
					_tmp186_ = tokens;
					_tmp186__length1 = tokens_length1;
					if (_tmp185_ < _tmp186__length1) {
						gchar* symbol = NULL;
						GHashTable* _tmp187_;
						gchar** _tmp188_;
						gint _tmp188__length1;
						const gchar* _tmp189_;
						gconstpointer _tmp190_;
						gchar* _tmp191_;
						const gchar* _tmp192_;
						_tmp187_ = name_map;
						_tmp188_ = tokens;
						_tmp188__length1 = tokens_length1;
						_tmp189_ = _tmp188_[0];
						_tmp190_ = g_hash_table_lookup (_tmp187_, _tmp189_);
						_tmp191_ = g_strdup ((const gchar*) _tmp190_);
						symbol = _tmp191_;
						_tmp192_ = symbol;
						if (_tmp192_ != NULL) {
							Currency* c = NULL;
							const gchar* _tmp193_;
							Currency* _tmp194_;
							Number* value = NULL;
							gchar** _tmp195_;
							gint _tmp195__length1;
							gint _tmp196_;
							const gchar* _tmp197_;
							Number* _tmp198_;
							gboolean _tmp199_ = FALSE;
							Currency* _tmp200_;
							_tmp193_ = symbol;
							_tmp194_ = currency_manager_get_currency (self, _tmp193_);
							c = _tmp194_;
							_tmp195_ = tokens;
							_tmp195__length1 = tokens_length1;
							_tmp196_ = value_index;
							_tmp197_ = _tmp195_[_tmp196_];
							_tmp198_ = mp_set_from_string (_tmp197_, 10);
							value = _tmp198_;
							_tmp200_ = c;
							if (_tmp200_ == NULL) {
								Number* _tmp201_;
								_tmp201_ = value;
								_tmp199_ = _tmp201_ != NULL;
							} else {
								_tmp199_ = FALSE;
							}
							if (_tmp199_) {
								gchar** _tmp202_;
								gint _tmp202__length1;
								gint _tmp203_;
								const gchar* _tmp204_;
								const gchar* _tmp205_;
								const gchar* _tmp206_;
								Currency* _tmp207_;
								Number* _tmp208_;
								Number* _tmp209_;
								Currency* _tmp210_;
								_tmp202_ = tokens;
								_tmp202__length1 = tokens_length1;
								_tmp203_ = value_index;
								_tmp204_ = _tmp202_[_tmp203_];
								_tmp205_ = symbol;
								g_debug ("currency.vala:270: Using IMF rate of %s for %s", _tmp204_, _tmp205_);
								_tmp206_ = symbol;
								_tmp207_ = currency_manager_add_currency (self, _tmp206_);
								_g_object_unref0 (c);
								c = _tmp207_;
								_tmp208_ = value;
								_tmp209_ = number_reciprocal (_tmp208_);
								_g_object_unref0 (value);
								value = _tmp209_;
								_tmp210_ = c;
								if (_tmp210_ != NULL) {
									Currency* _tmp211_;
									Number* _tmp212_;
									_tmp211_ = c;
									_tmp212_ = value;
									currency_set_value (_tmp211_, _tmp212_);
								}
							}
							_g_object_unref0 (value);
							_g_object_unref0 (c);
						} else {
							gchar** _tmp213_;
							gint _tmp213__length1;
							const gchar* _tmp214_;
							_tmp213_ = tokens;
							_tmp213__length1 = tokens_length1;
							_tmp214_ = _tmp213_[0];
							g_warning ("currency.vala:278: Unknown currency '%s'", _tmp214_);
						}
						_g_free0 (symbol);
					}
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_free0 (filename);
	_g_hash_table_unref0 (name_map);
}


static void currency_manager_set_ecb_rate (CurrencyManager* self, xmlNode* node, Currency* eur_rate) {
	gchar* name = NULL;
	gchar* value = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (eur_rate != NULL);
	name = NULL;
	value = NULL;
	{
		xmlAttr* attribute = NULL;
		xmlNode* _tmp0_;
		xmlAttr* _tmp1_;
		_tmp0_ = node;
		_tmp1_ = _tmp0_->properties;
		attribute = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_;
				xmlNode* n = NULL;
				xmlAttr* _tmp6_;
				xmlAttr* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp2_) {
					xmlAttr* _tmp3_;
					xmlAttr* _tmp4_;
					_tmp3_ = attribute;
					_tmp4_ = _tmp3_->next;
					attribute = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = attribute;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = attribute;
				n = (xmlNode*) _tmp6_;
				_tmp7_ = attribute;
				_tmp8_ = _tmp7_->name;
				if (g_strcmp0 (_tmp8_, "currency") == 0) {
					xmlNode* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = n;
					_tmp10_ = (gchar*) xmlNodeGetContent (_tmp9_);
					_g_free0 (name);
					name = _tmp10_;
				} else {
					xmlAttr* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = attribute;
					_tmp12_ = _tmp11_->name;
					if (g_strcmp0 (_tmp12_, "rate") == 0) {
						xmlNode* _tmp13_;
						gchar* _tmp14_;
						_tmp13_ = n;
						_tmp14_ = (gchar*) xmlNodeGetContent (_tmp13_);
						_g_free0 (value);
						value = _tmp14_;
					}
				}
			}
		}
	}
	_tmp17_ = name;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		_tmp18_ = value;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_;
		Currency* _tmp20_;
		Currency* _tmp21_;
		_tmp19_ = name;
		_tmp20_ = currency_manager_get_currency (self, _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_ == NULL;
		_g_object_unref0 (_tmp21_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		Currency* c = NULL;
		const gchar* _tmp24_;
		Currency* _tmp25_;
		Number* r = NULL;
		const gchar* _tmp26_;
		Number* _tmp27_;
		Number* v = NULL;
		Currency* _tmp28_;
		Number* _tmp29_;
		Number* _tmp30_;
		Number* _tmp31_;
		Number* _tmp32_;
		Currency* _tmp33_;
		Number* _tmp34_;
		_tmp22_ = value;
		_tmp23_ = name;
		g_debug ("currency.vala:300: Using ECB rate of %s for %s", _tmp22_, _tmp23_);
		_tmp24_ = name;
		_tmp25_ = currency_manager_add_currency (self, _tmp24_);
		c = _tmp25_;
		_tmp26_ = value;
		_tmp27_ = mp_set_from_string (_tmp26_, 10);
		r = _tmp27_;
		_tmp28_ = eur_rate;
		_tmp29_ = currency_get_value (_tmp28_);
		v = _tmp29_;
		_tmp30_ = v;
		_tmp31_ = r;
		_tmp32_ = number_multiply (_tmp30_, _tmp31_);
		_g_object_unref0 (v);
		v = _tmp32_;
		_tmp33_ = c;
		_tmp34_ = v;
		currency_set_value (_tmp33_, _tmp34_);
		_g_object_unref0 (v);
		_g_object_unref0 (r);
		_g_object_unref0 (c);
	}
	_g_free0 (value);
	_g_free0 (name);
}


static void currency_manager_set_ecb_fixed_rate (CurrencyManager* self, const gchar* name, const gchar* value, Currency* eur_rate) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Currency* c = NULL;
	const gchar* _tmp2_;
	Currency* _tmp3_;
	Number* r = NULL;
	const gchar* _tmp4_;
	Number* _tmp5_;
	Number* v = NULL;
	Currency* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (eur_rate != NULL);
	_tmp0_ = value;
	_tmp1_ = name;
	g_debug ("currency.vala:311: Using ECB fixed rate of %s for %s", _tmp0_, _tmp1_);
	_tmp2_ = name;
	_tmp3_ = currency_manager_add_currency (self, _tmp2_);
	c = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = mp_set_from_string (_tmp4_, 10);
	r = _tmp5_;
	_tmp6_ = eur_rate;
	_tmp7_ = currency_get_value (_tmp6_);
	v = _tmp7_;
	_tmp8_ = v;
	_tmp9_ = number_divide (_tmp8_, r);
	_g_object_unref0 (v);
	v = _tmp9_;
	_tmp10_ = v;
	currency_set_value (c, _tmp10_);
	_g_object_unref0 (v);
	_g_object_unref0 (r);
	_g_object_unref0 (c);
}


static void currency_manager_load_ecb_rates (CurrencyManager* self) {
	Currency* eur_rate = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	Currency* _tmp2_;
	Currency* _tmp3_;
	gchar* filename = NULL;
	gchar* _tmp4_;
	xmlDoc* document = NULL;
	const gchar* _tmp5_;
	xmlDoc* _tmp6_;
	xmlDoc* _tmp7_;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp9_;
	xmlXPathContext* _tmp10_;
	xmlXPathContext* _tmp11_;
	xmlXPathContext* _tmp12_;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp13_;
	xmlXPathObject* _tmp14_;
	xmlXPathObject* _tmp15_;
	gint _tmp16_ = 0;
	xmlXPathObject* _tmp17_;
	xmlNodeSet* _tmp18_;
	gint len = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = currency_manager_get_currency (self, "EUR");
	eur_rate = _tmp0_;
	_tmp1_ = eur_rate;
	if (_tmp1_ == NULL) {
		g_warning ("currency.vala:325: Cannot use ECB rates as don't have EUR rate");
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp2_ = eur_rate;
	currency_manager_set_ecb_fixed_rate (self, "EEK", "0.06391", _tmp2_);
	_tmp3_ = eur_rate;
	currency_manager_set_ecb_fixed_rate (self, "CFA", "0.152449", _tmp3_);
	xmlInitParser ();
	_tmp4_ = currency_manager_get_ecb_rate_filepath (self);
	filename = _tmp4_;
	_tmp5_ = filename;
	_tmp6_ = xmlReadFile (_tmp5_, NULL, 0);
	document = _tmp6_;
	_tmp7_ = document;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = filename;
		g_warning ("currency.vala:338: Couldn't parse ECB rate file %s", _tmp8_);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp9_ = document;
	_tmp10_ = xmlXPathNewContext (_tmp9_);
	xpath_ctx = _tmp10_;
	_tmp11_ = xpath_ctx;
	if (_tmp11_ == NULL) {
		g_warning ("currency.vala:345: Couldn't create XPath context");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp12_ = xpath_ctx;
	xmlXPathRegisterNs (_tmp12_, (xmlChar*) "xref", (xmlChar*) "http://www.ecb.int/vocabulary/2002-08-01/eurofxref");
	_tmp13_ = xpath_ctx;
	_tmp14_ = xmlXPathEvalExpression ((xmlChar*) "//xref:Cube[@currency][@rate]", _tmp13_);
	xpath_obj = _tmp14_;
	_tmp15_ = xpath_obj;
	if (_tmp15_ == NULL) {
		g_warning ("currency.vala:353: Couldn't create XPath object");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp17_ = xpath_obj;
	_tmp18_ = _tmp17_->nodesetval;
	if (_tmp18_ != NULL) {
		xmlXPathObject* _tmp19_;
		xmlNodeSet* _tmp20_;
		gint _tmp21_;
		_tmp19_ = xpath_obj;
		_tmp20_ = _tmp19_->nodesetval;
		_tmp21_ = xmlXPathNodeSetGetLength (_tmp20_);
		_tmp16_ = _tmp21_;
	} else {
		_tmp16_ = 0;
	}
	len = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_;
				gint _tmp25_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp26_;
				xmlNodeSet* _tmp27_;
				gint _tmp28_;
				xmlNode* _tmp29_;
				xmlNode* _tmp30_;
				xmlElementType _tmp31_;
				xmlNode* _tmp34_;
				xmlElementType _tmp35_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = len;
				if (!(_tmp24_ < _tmp25_)) {
					break;
				}
				_tmp26_ = xpath_obj;
				_tmp27_ = _tmp26_->nodesetval;
				_tmp28_ = i;
				_tmp29_ = xmlXPathNodeSetItem (_tmp27_, _tmp28_);
				node = _tmp29_;
				_tmp30_ = node;
				_tmp31_ = _tmp30_->type;
				if (_tmp31_ == XML_ELEMENT_NODE) {
					xmlNode* _tmp32_;
					Currency* _tmp33_;
					_tmp32_ = node;
					_tmp33_ = eur_rate;
					currency_manager_set_ecb_rate (self, _tmp32_, _tmp33_);
				}
				_tmp34_ = node;
				_tmp35_ = _tmp34_->type;
				if (_tmp35_ != XML_NAMESPACE_DECL) {
					node = NULL;
				}
			}
		}
	}
	xmlCleanupParser ();
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_free0 (filename);
	_g_object_unref0 (eur_rate);
}


static void currency_manager_download_rates (CurrencyManager* self) {
	gchar* path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = currency_manager_get_imf_rate_filepath (self);
	path = _tmp0_;
	_tmp2_ = downloading_imf_rates;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = path;
		_tmp4_ = currency_manager_file_needs_update (self, _tmp3_, (gdouble) (((60 * 60) * 24) * 7));
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_;
		downloading_imf_rates = TRUE;
		g_debug ("currency.vala:379: Downloading rates from the IMF...");
		_tmp5_ = path;
		currency_manager_download_file (self, "https://www.imf.org/external/np/fin/data/rms_five.aspx?tsvflag=Y", _tmp5_, "IMF", NULL, NULL);
	}
	_tmp6_ = currency_manager_get_ecb_rate_filepath (self);
	_g_free0 (path);
	path = _tmp6_;
	_tmp8_ = downloading_ecb_rates;
	if (!_tmp8_) {
		const gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = path;
		_tmp10_ = currency_manager_file_needs_update (self, _tmp9_, (gdouble) (((60 * 60) * 24) * 7));
		_tmp7_ = _tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp11_;
		downloading_ecb_rates = TRUE;
		g_debug ("currency.vala:386: Downloading rates from the ECB...");
		_tmp11_ = path;
		currency_manager_download_file (self, "https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml", _tmp11_, "ECB", NULL, NULL);
	}
	_g_free0 (path);
}


static gboolean currency_manager_load_rates (CurrencyManager* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GList* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = loaded_rates;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = downloading_imf_rates;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = downloading_ecb_rates;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	currency_manager_load_imf_rates (self);
	currency_manager_load_ecb_rates (self);
	_tmp4_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp4_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp5_;
			Currency* c = NULL;
			_tmp5_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				Currency* _tmp7_;
				Number* _tmp8_;
				Number* _tmp9_;
				gboolean _tmp10_;
				_tmp7_ = c;
				_tmp8_ = currency_get_value (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_ == NULL;
				_g_object_unref0 (_tmp9_);
				if (_tmp10_) {
					_tmp6_ = TRUE;
				} else {
					Currency* _tmp11_;
					Number* _tmp12_;
					Number* _tmp13_;
					gboolean _tmp14_;
					_tmp11_ = c;
					_tmp12_ = currency_get_value (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = number_is_zero (_tmp13_);
					_tmp6_ = _tmp14_;
					_g_object_unref0 (_tmp13_);
				}
				if (_tmp6_) {
					Currency* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp15_ = c;
					_tmp16_ = currency_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = _tmp17_;
					g_warning ("currency.vala:408: Currency %s is not provided by IMF or ECB", _tmp18_);
					_g_free0 (_tmp18_);
				}
				_g_object_unref0 (c);
			}
		}
	}
	g_debug ("currency.vala:410: Rates loaded");
	loaded_rates = TRUE;
	g_signal_emit (self, currency_manager_signals[CURRENCY_MANAGER_UPDATED_SIGNAL], 0);
	result = TRUE;
	return result;
}


Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency) {
	Number* result = NULL;
	gboolean _tmp0_;
	Currency* c = NULL;
	const gchar* _tmp1_;
	Currency* _tmp2_;
	Currency* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (currency != NULL, NULL);
	currency_manager_download_rates (self);
	_tmp0_ = currency_manager_load_rates (self);
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = currency;
	_tmp2_ = currency_manager_get_currency (self, _tmp1_);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		Currency* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = c;
		_tmp5_ = currency_get_value (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (c);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (c);
		return result;
	}
	_g_object_unref0 (c);
}


static void currency_manager_download_file_data_free (gpointer _data) {
	CurrencyManagerDownloadFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (CurrencyManagerDownloadFileData, _data_);
}


static void currency_manager_download_file_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	CurrencyManagerDownloadFileData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void currency_manager_download_file (CurrencyManager* self, const gchar* uri, const gchar* filename, const gchar* source, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CurrencyManagerDownloadFileData* _data_;
	CurrencyManager* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_data_ = g_slice_new0 (CurrencyManagerDownloadFileData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, currency_manager_download_file_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, currency_manager_download_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	_tmp3_ = filename;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp4_;
	_tmp5_ = source;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->source);
	_data_->source = _tmp6_;
	currency_manager_download_file_co (_data_);
}


static void currency_manager_download_file_finish (CurrencyManager* self, GAsyncResult* _res_) {
	CurrencyManagerDownloadFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void currency_manager_download_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	CurrencyManagerDownloadFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	currency_manager_download_file_co (_data_);
}


static gboolean currency_manager_download_file_co (CurrencyManagerDownloadFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->filename;
	_data_->_tmp1_ = g_path_get_dirname (_data_->_tmp0_);
	_data_->directory = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp2_, 0755);
	_data_->_tmp3_ = _data_->filename;
	_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
	_data_->dest = _data_->_tmp4_;
	_data_->_tmp5_ = soup_session_new ();
	_data_->session = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->uri;
	_data_->_tmp7_ = soup_message_new ("GET", _data_->_tmp6_);
	_data_->message = _data_->_tmp7_;
	{
		_data_->_tmp8_ = _data_->session;
		_data_->_tmp9_ = _data_->message;
		_data_->_state_ = 1;
		soup_session_send_async (_data_->_tmp8_, _data_->_tmp9_, NULL, currency_manager_download_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = soup_session_send_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
		_data_->bodyinput = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp11_ = _data_->dest;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp11_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, currency_manager_download_file_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp12_ = g_file_replace_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		_data_->output = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->bodyinput);
			goto __catch1_g_error;
		}
		_data_->_tmp13_ = _data_->output;
		_data_->_tmp14_ = _data_->bodyinput;
		_data_->_state_ = 3;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp13_, _data_->_tmp14_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, NULL, currency_manager_download_file_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->bodyinput);
			goto __catch1_g_error;
		}
		_data_->_tmp15_ = _data_->source;
		if (g_strcmp0 (_data_->_tmp15_, "IMF") == 0) {
			downloading_imf_rates = FALSE;
		} else {
			downloading_ecb_rates = FALSE;
		}
		currency_manager_load_rates (_data_->self);
		_data_->_tmp16_ = _data_->source;
		g_debug ("currency.vala:455: %s rates updated", _data_->_tmp16_);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->bodyinput);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = _data_->source;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("currency.vala:459: Couldn't download %s currency rate file: %s", _data_->_tmp17_, _data_->_tmp19_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->dest);
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->dest);
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


CurrencyManager* currency_manager_construct (GType object_type) {
	CurrencyManager * self = NULL;
	self = (CurrencyManager*) g_object_new (object_type, NULL);
	return self;
}


CurrencyManager* currency_manager_new (void) {
	return currency_manager_construct (TYPE_CURRENCY_MANAGER);
}


static void currency_manager_class_init (CurrencyManagerClass * klass) {
	currency_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CurrencyManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = currency_manager_finalize;
	currency_manager_signals[CURRENCY_MANAGER_UPDATED_SIGNAL] = g_signal_new ("updated", TYPE_CURRENCY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void currency_manager_instance_init (CurrencyManager * self) {
	self->priv = CURRENCY_MANAGER_GET_PRIVATE (self);
}


static void currency_manager_finalize (GObject * obj) {
	CurrencyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY_MANAGER, CurrencyManager);
	__g_list_free__g_object_unref0_0 (self->priv->currencies);
	G_OBJECT_CLASS (currency_manager_parent_class)->finalize (obj);
}


GType currency_manager_get_type (void) {
	static volatile gsize currency_manager_type_id__volatile = 0;
	if (g_once_init_enter (&currency_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CurrencyManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CurrencyManager), 0, (GInstanceInitFunc) currency_manager_instance_init, NULL };
		GType currency_manager_type_id;
		currency_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CurrencyManager", &g_define_type_info, 0);
		g_once_init_leave (&currency_manager_type_id__volatile, currency_manager_type_id);
	}
	return currency_manager_type_id__volatile;
}


Currency* currency_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* symbol) {
	Currency * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (Currency*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp3_;
	_tmp4_ = symbol;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_symbol);
	self->priv->_symbol = _tmp5_;
	return self;
}


Currency* currency_new (const gchar* name, const gchar* display_name, const gchar* symbol) {
	return currency_construct (TYPE_CURRENCY, name, display_name, symbol);
}


void currency_set_value (Currency* self, Number* value) {
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->value);
	self->priv->value = _tmp1_;
}


Number* currency_get_value (Currency* self) {
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_name (Currency* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_display_name (Currency* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_symbol (Currency* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void currency_class_init (CurrencyClass * klass) {
	currency_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CurrencyPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_currency_get_property;
	G_OBJECT_CLASS (klass)->finalize = currency_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_SYMBOL, g_param_spec_string ("symbol", "symbol", "symbol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void currency_instance_init (Currency * self) {
	self->priv = CURRENCY_GET_PRIVATE (self);
}


static void currency_finalize (GObject * obj) {
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY, Currency);
	_g_object_unref0 (self->priv->value);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_symbol);
	G_OBJECT_CLASS (currency_parent_class)->finalize (obj);
}


GType currency_get_type (void) {
	static volatile gsize currency_type_id__volatile = 0;
	if (g_once_init_enter (&currency_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CurrencyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Currency), 0, (GInstanceInitFunc) currency_instance_init, NULL };
		GType currency_type_id;
		currency_type_id = g_type_register_static (G_TYPE_OBJECT, "Currency", &g_define_type_info, 0);
		g_once_init_leave (&currency_type_id__volatile, currency_type_id);
	}
	return currency_type_id__volatile;
}


static void _vala_currency_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY, Currency);
	switch (property_id) {
		case CURRENCY_NAME:
		g_value_take_string (value, currency_get_name (self));
		break;
		case CURRENCY_DISPLAY_NAME:
		g_value_take_string (value, currency_get_display_name (self));
		break;
		case CURRENCY_SYMBOL:
		g_value_take_string (value, currency_get_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



