/* query.c generated by valac 0.29.3.10-b87a, the Vala compiler
 * generated from query.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_QUERY (folks_query_get_type ())
#define FOLKS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_QUERY, FolksQuery))
#define FOLKS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_QUERY, FolksQueryClass))
#define FOLKS_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_QUERY))
#define FOLKS_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_QUERY))
#define FOLKS_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_QUERY, FolksQueryClass))

typedef struct _FolksQuery FolksQuery;
typedef struct _FolksQueryClass FolksQueryClass;
typedef struct _FolksQueryPrivate FolksQueryPrivate;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;

struct _FolksQuery {
	GObject parent_instance;
	FolksQueryPrivate * priv;
};

struct _FolksQueryClass {
	GObjectClass parent_class;
	guint (*is_match) (FolksQuery* self, FolksIndividual* individual);
	gchar** (*get_match_fields) (FolksQuery* self, int* result_length1);
	void (*set_match_fields) (FolksQuery* self, gchar** value, int value_length1);
};

struct _FolksQueryPrivate {
	gchar** _match_fields;
	gint _match_fields_length1;
	gint __match_fields_size_;
};


static gpointer folks_query_parent_class = NULL;

GType folks_query_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_QUERY, FolksQueryPrivate))
enum  {
	FOLKS_QUERY_DUMMY_PROPERTY,
	FOLKS_QUERY_MATCH_FIELDS
};
static gchar** _vala_array_dup4 (gchar** self, int length);
guint folks_query_is_match (FolksQuery* self, FolksIndividual* individual);
static guint folks_query_real_is_match (FolksQuery* self, FolksIndividual* individual);
FolksQuery* folks_query_construct (GType object_type);
gchar** folks_query_get_match_fields (FolksQuery* self, int* result_length1);
static void folks_query_set_match_fields (FolksQuery* self, gchar** value, int value_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
static void folks_query_finalize (GObject* obj);
static void _vala_folks_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* FOLKS_QUERY_MATCH_FIELDS_NAMES[4] = {"alias", "full-name", "nickname", "structured-name"};
const gchar* FOLKS_QUERY_MATCH_FIELDS_ADDRESSES[6] = {"email-addresses", "im-addresses", "phone-numbers", "postal-addresses", "web-service-addresses", "urls"};
const gchar* FOLKS_QUERY_MATCH_FIELDS_MISC[3] = {"groups", "roles", "notes"};

static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


/**
   * Determines whether a given {@link Individual} matches this query.
   *
   * This returns a match strength, which is on an arbitrary scale which is not
   * part of libfolks’ public API. These strengths should not be stored by user
   * applications, or examined numerically — they should only be used for
   * pairwise strength comparisons.
   *
   * This function is intended to be used in the {@link SearchView}
   * implementation only. Use {@link SearchView.individuals} to retrieve search
   * results.
   *
   * @param individual an {@link Individual} to match against
   * @return a positive integer if the individual matches this query, or zero
   *   if they do not match; higher numbers indicate a better match
   * @since 0.11.0
   */
static guint folks_query_real_is_match (FolksQuery* self, FolksIndividual* individual) {
	g_critical ("Type `%s' does not implement abstract method `folks_query_is_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint folks_query_is_match (FolksQuery* self, FolksIndividual* individual) {
	g_return_val_if_fail (self != NULL, 0U);
	return FOLKS_QUERY_GET_CLASS (self)->is_match (self, individual);
}


FolksQuery* folks_query_construct (GType object_type) {
	FolksQuery * self = NULL;
	self = (FolksQuery*) g_object_new (object_type, NULL);
	return self;
}


gchar** folks_query_get_match_fields (FolksQuery* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_QUERY_GET_CLASS (self)->get_match_fields (self, result_length1);
}


static gchar** folks_query_real_get_match_fields (FolksQuery* base, int* result_length1) {
	gchar** result;
	FolksQuery* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = base;
	_tmp0_ = self->priv->_match_fields;
	_tmp0__length1 = self->priv->_match_fields_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static void folks_query_set_match_fields (FolksQuery* self, gchar** value, int value_length1) {
	g_return_if_fail (self != NULL);
	FOLKS_QUERY_GET_CLASS (self)->set_match_fields (self, value, value_length1);
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void folks_query_real_set_match_fields (FolksQuery* base, gchar** value, int value_length1) {
	FolksQuery* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = base;
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_match_fields = (_vala_array_free (self->priv->_match_fields, self->priv->_match_fields_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_match_fields = _tmp1_;
	self->priv->_match_fields_length1 = _tmp1__length1;
	self->priv->__match_fields_size_ = self->priv->_match_fields_length1;
	g_object_notify ((GObject *) self, "match-fields");
}


static void folks_query_class_init (FolksQueryClass * klass) {
	folks_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksQueryPrivate));
	((FolksQueryClass *) klass)->is_match = folks_query_real_is_match;
	FOLKS_QUERY_CLASS (klass)->get_match_fields = folks_query_real_get_match_fields;
	FOLKS_QUERY_CLASS (klass)->set_match_fields = folks_query_real_set_match_fields;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_query_finalize;
	/**
	   * The names of the fields to match within
	   *
	   * The names of valid fields are available via
	   * {@link PersonaStore.detail_key}.
	   *
	   * The ordering of the fields determines the order they are checked for
	   * matches, which can have performance implications (these should ideally be
	   * ordered from most- to least-likely to match).
	   *
	   * Also note that more fields (particularly rarely-matched fields) will
	   * negatively impact performance, so only include important fields.
	   *
	   * Default value is {@link Query.MATCH_FIELDS_NAMES}.
	   *
	   * @since 0.11.0
	   * @see PersonaDetail
	   * @see PersonaStore.detail_key
	   * @see Query.MATCH_FIELDS_NAMES
	   * @see Query.MATCH_FIELDS_ADDRESSES
	   * @see Query.MATCH_FIELDS_MISC
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_QUERY_MATCH_FIELDS, g_param_spec_boxed ("match-fields", "match-fields", "match-fields", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void folks_query_instance_init (FolksQuery * self) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self->priv = FOLKS_QUERY_GET_PRIVATE (self);
	_tmp0_ = (FOLKS_QUERY_MATCH_FIELDS_NAMES != NULL) ? _vala_array_dup4 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES)) : ((gpointer) FOLKS_QUERY_MATCH_FIELDS_NAMES);
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
	self->priv->_match_fields = _tmp0_;
	self->priv->_match_fields_length1 = _tmp0__length1;
	self->priv->__match_fields_size_ = self->priv->_match_fields_length1;
}


static void folks_query_finalize (GObject* obj) {
	FolksQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_QUERY, FolksQuery);
	self->priv->_match_fields = (_vala_array_free (self->priv->_match_fields, self->priv->_match_fields_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (folks_query_parent_class)->finalize (obj);
}


/**
 * A contact query.
 *
 * If any properties of the query change such that matches may change, the
 * {@link GLib.Object.notify} signal will be emitted, potentially without a
 * detail string. Views which are using this query should re-evaluate their
 * matches on receiving this signal.
 *
 * @see SearchView
 * @since 0.11.0
 */
GType folks_query_get_type (void) {
	static volatile gsize folks_query_type_id__volatile = 0;
	if (g_once_init_enter (&folks_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksQuery), 0, (GInstanceInitFunc) folks_query_instance_init, NULL };
		GType folks_query_type_id;
		folks_query_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksQuery", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_query_type_id__volatile, folks_query_type_id);
	}
	return folks_query_type_id__volatile;
}


static void _vala_folks_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_QUERY, FolksQuery);
	switch (property_id) {
		case FOLKS_QUERY_MATCH_FIELDS:
		{
			int length;
			g_value_set_boxed (value, folks_query_get_match_fields (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_QUERY, FolksQuery);
	switch (property_id) {
		case FOLKS_QUERY_MATCH_FIELDS:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			folks_query_set_match_fields (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



