/* function-manager.c generated by valac 0.32.0, the Vala compiler
 * generated from function-manager.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define TYPE_FUNCTION_MANAGER (function_manager_get_type ())
#define FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_MANAGER, FunctionManager))
#define FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_MANAGER, FunctionManagerClass))
#define IS_FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_MANAGER))
#define IS_FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_MANAGER))
#define FUNCTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_MANAGER, FunctionManagerClass))

typedef struct _FunctionManager FunctionManager;
typedef struct _FunctionManagerClass FunctionManagerClass;
typedef struct _FunctionManagerPrivate FunctionManagerPrivate;

#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_BUILT_IN_MATH_FUNCTION (built_in_math_function_get_type ())
#define BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunction))
#define BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))
#define IS_BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILT_IN_MATH_FUNCTION))
#define IS_BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILT_IN_MATH_FUNCTION))
#define BUILT_IN_MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))

typedef struct _BuiltInMathFunction BuiltInMathFunction;
typedef struct _BuiltInMathFunctionClass BuiltInMathFunctionClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

struct _FunctionManager {
	GObject parent_instance;
	FunctionManagerPrivate * priv;
};

struct _FunctionManagerClass {
	GObjectClass parent_class;
};

struct _FunctionManagerPrivate {
	gchar* file_name;
	GHashTable* functions;
	Serializer* serializer;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;


extern FunctionManager* default_function_manager;
FunctionManager* default_function_manager = NULL;
static gpointer function_manager_parent_class = NULL;

GType function_manager_get_type (void) G_GNUC_CONST;
GType math_function_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define FUNCTION_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FUNCTION_MANAGER, FunctionManagerPrivate))
enum  {
	FUNCTION_MANAGER_DUMMY_PROPERTY
};
FunctionManager* function_manager_new (void);
FunctionManager* function_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_radix (Serializer* self, gunichar radix);
static void function_manager_reload_functions (FunctionManager* self);
FunctionManager* function_manager_get_default_function_manager (void);
static void function_manager_reload_custom_functions (FunctionManager* self);
static void function_manager_reload_builtin_functions (FunctionManager* self);
static gboolean function_manager_add (FunctionManager* self, MathFunction* new_function);
BuiltInMathFunction* built_in_math_function_new (const gchar* function_name, const gchar* description);
BuiltInMathFunction* built_in_math_function_construct (GType object_type, const gchar* function_name, const gchar* description);
GType built_in_math_function_get_type (void) G_GNUC_CONST;
static MathFunction* function_manager_parse_function_from_string (FunctionManager* self, const gchar* data);
const gchar* math_function_get_name (MathFunction* self);
MathFunction* math_function_new (const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
MathFunction* math_function_construct (GType object_type, const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
static void function_manager_save (FunctionManager* self);
gboolean math_function_is_custom_function (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self, int* result_length1);
const gchar* math_function_get_expression (MathFunction* self);
const gchar* math_function_get_description (MathFunction* self);
static gchar** function_manager_array_sort_string (FunctionManager* self, gchar** array, int array_length1, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** function_manager_get_names (FunctionManager* self, int* result_length1);
MathFunction* function_manager_get (FunctionManager* self, const gchar* name);
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
gboolean function_manager_add_function_with_properties (FunctionManager* self, const gchar* name, const gchar* arguments, const gchar* description, Parser* root_parser);
gboolean math_function_validate (MathFunction* self, Parser* root_parser);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
void function_manager_delete (FunctionManager* self, const gchar* name);
gboolean function_manager_is_function_defined (FunctionManager* self, const gchar* name);
gint sub_atoi (const gchar* data);
GType number_get_type (void) G_GNUC_CONST;
Number* function_manager_evaluate_function (FunctionManager* self, const gchar* name, Number** arguments, int arguments_length1, Parser* parser);
static Number** _vala_array_dup2 (Number** self, int length);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
static void _vala_array_add3 (Number*** array, int* length, int* size, Number* value);
Number* math_function_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
static MathFunction** function_manager_array_sort_math_function (FunctionManager* self, MathFunction** array, int array_length1, int* result_length1);
static MathFunction** _vala_array_dup3 (MathFunction** self, int length);
MathFunction** function_manager_functions_eligible_for_autocompletion_for_text (FunctionManager* self, const gchar* display_text, int* result_length1);
static void _vala_array_add4 (MathFunction*** array, int* length, int* size, MathFunction* value);
static void function_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


FunctionManager* function_manager_construct (GType object_type) {
	FunctionManager * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	self = (FunctionManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->functions);
	self->priv->functions = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-calculator", "custom-functions", NULL);
	_g_free0 (self->priv->file_name);
	self->priv->file_name = _tmp4_;
	_tmp5_ = serializer_new (DISPLAY_FORMAT_SCIENTIFIC, 10, 50);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp5_;
	_tmp6_ = self->priv->serializer;
	serializer_set_radix (_tmp6_, (gunichar) '.');
	function_manager_reload_functions (self);
	return self;
}


FunctionManager* function_manager_new (void) {
	return function_manager_construct (TYPE_FUNCTION_MANAGER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FunctionManager* function_manager_get_default_function_manager (void) {
	FunctionManager* result = NULL;
	FunctionManager* _tmp0_ = NULL;
	FunctionManager* _tmp2_ = NULL;
	FunctionManager* _tmp3_ = NULL;
	_tmp0_ = default_function_manager;
	if (_tmp0_ == NULL) {
		FunctionManager* _tmp1_ = NULL;
		_tmp1_ = function_manager_new ();
		_g_object_unref0 (default_function_manager);
		default_function_manager = _tmp1_;
	}
	_tmp2_ = default_function_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void function_manager_reload_functions (FunctionManager* self) {
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->functions;
	g_hash_table_remove_all (_tmp0_);
	function_manager_reload_custom_functions (self);
	function_manager_reload_builtin_functions (self);
}


static void function_manager_reload_builtin_functions (FunctionManager* self) {
	BuiltInMathFunction* _tmp0_ = NULL;
	BuiltInMathFunction* _tmp1_ = NULL;
	BuiltInMathFunction* _tmp2_ = NULL;
	BuiltInMathFunction* _tmp3_ = NULL;
	BuiltInMathFunction* _tmp4_ = NULL;
	BuiltInMathFunction* _tmp5_ = NULL;
	BuiltInMathFunction* _tmp6_ = NULL;
	BuiltInMathFunction* _tmp7_ = NULL;
	BuiltInMathFunction* _tmp8_ = NULL;
	BuiltInMathFunction* _tmp9_ = NULL;
	BuiltInMathFunction* _tmp10_ = NULL;
	BuiltInMathFunction* _tmp11_ = NULL;
	BuiltInMathFunction* _tmp12_ = NULL;
	BuiltInMathFunction* _tmp13_ = NULL;
	BuiltInMathFunction* _tmp14_ = NULL;
	BuiltInMathFunction* _tmp15_ = NULL;
	BuiltInMathFunction* _tmp16_ = NULL;
	BuiltInMathFunction* _tmp17_ = NULL;
	BuiltInMathFunction* _tmp18_ = NULL;
	BuiltInMathFunction* _tmp19_ = NULL;
	BuiltInMathFunction* _tmp20_ = NULL;
	BuiltInMathFunction* _tmp21_ = NULL;
	BuiltInMathFunction* _tmp22_ = NULL;
	BuiltInMathFunction* _tmp23_ = NULL;
	BuiltInMathFunction* _tmp24_ = NULL;
	BuiltInMathFunction* _tmp25_ = NULL;
	BuiltInMathFunction* _tmp26_ = NULL;
	BuiltInMathFunction* _tmp27_ = NULL;
	BuiltInMathFunction* _tmp28_ = NULL;
	BuiltInMathFunction* _tmp29_ = NULL;
	BuiltInMathFunction* _tmp30_ = NULL;
	BuiltInMathFunction* _tmp31_ = NULL;
	BuiltInMathFunction* _tmp32_ = NULL;
	BuiltInMathFunction* _tmp33_ = NULL;
	BuiltInMathFunction* _tmp34_ = NULL;
	BuiltInMathFunction* _tmp35_ = NULL;
	BuiltInMathFunction* _tmp36_ = NULL;
	BuiltInMathFunction* _tmp37_ = NULL;
	BuiltInMathFunction* _tmp38_ = NULL;
	BuiltInMathFunction* _tmp39_ = NULL;
	BuiltInMathFunction* _tmp40_ = NULL;
	BuiltInMathFunction* _tmp41_ = NULL;
	BuiltInMathFunction* _tmp42_ = NULL;
	BuiltInMathFunction* _tmp43_ = NULL;
	BuiltInMathFunction* _tmp44_ = NULL;
	BuiltInMathFunction* _tmp45_ = NULL;
	BuiltInMathFunction* _tmp46_ = NULL;
	BuiltInMathFunction* _tmp47_ = NULL;
	BuiltInMathFunction* _tmp48_ = NULL;
	BuiltInMathFunction* _tmp49_ = NULL;
	BuiltInMathFunction* _tmp50_ = NULL;
	BuiltInMathFunction* _tmp51_ = NULL;
	BuiltInMathFunction* _tmp52_ = NULL;
	BuiltInMathFunction* _tmp53_ = NULL;
	BuiltInMathFunction* _tmp54_ = NULL;
	BuiltInMathFunction* _tmp55_ = NULL;
	BuiltInMathFunction* _tmp56_ = NULL;
	BuiltInMathFunction* _tmp57_ = NULL;
	BuiltInMathFunction* _tmp58_ = NULL;
	BuiltInMathFunction* _tmp59_ = NULL;
	BuiltInMathFunction* _tmp60_ = NULL;
	BuiltInMathFunction* _tmp61_ = NULL;
	BuiltInMathFunction* _tmp62_ = NULL;
	BuiltInMathFunction* _tmp63_ = NULL;
	BuiltInMathFunction* _tmp64_ = NULL;
	BuiltInMathFunction* _tmp65_ = NULL;
	BuiltInMathFunction* _tmp66_ = NULL;
	BuiltInMathFunction* _tmp67_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = built_in_math_function_new ("log", "Logarithm");
	_tmp1_ = _tmp0_;
	function_manager_add (self, (MathFunction*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = built_in_math_function_new ("ln", "Natural logarithm");
	_tmp3_ = _tmp2_;
	function_manager_add (self, (MathFunction*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = built_in_math_function_new ("sqrt", "Square root");
	_tmp5_ = _tmp4_;
	function_manager_add (self, (MathFunction*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = built_in_math_function_new ("abs", "Absolute value");
	_tmp7_ = _tmp6_;
	function_manager_add (self, (MathFunction*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = built_in_math_function_new ("sgn", "Signum");
	_tmp9_ = _tmp8_;
	function_manager_add (self, (MathFunction*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = built_in_math_function_new ("arg", "Argument");
	_tmp11_ = _tmp10_;
	function_manager_add (self, (MathFunction*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = built_in_math_function_new ("conj", "Conjugate");
	_tmp13_ = _tmp12_;
	function_manager_add (self, (MathFunction*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = built_in_math_function_new ("int", "Integer");
	_tmp15_ = _tmp14_;
	function_manager_add (self, (MathFunction*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = built_in_math_function_new ("frac", "Fraction");
	_tmp17_ = _tmp16_;
	function_manager_add (self, (MathFunction*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = built_in_math_function_new ("floor", "Floor");
	_tmp19_ = _tmp18_;
	function_manager_add (self, (MathFunction*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = built_in_math_function_new ("ceil", "Ceiling");
	_tmp21_ = _tmp20_;
	function_manager_add (self, (MathFunction*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = built_in_math_function_new ("round", "Round");
	_tmp23_ = _tmp22_;
	function_manager_add (self, (MathFunction*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = built_in_math_function_new ("re", "Real");
	_tmp25_ = _tmp24_;
	function_manager_add (self, (MathFunction*) _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = built_in_math_function_new ("im", "Imaginary");
	_tmp27_ = _tmp26_;
	function_manager_add (self, (MathFunction*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = built_in_math_function_new ("sin", "Sine");
	_tmp29_ = _tmp28_;
	function_manager_add (self, (MathFunction*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = built_in_math_function_new ("cos", "Cosine");
	_tmp31_ = _tmp30_;
	function_manager_add (self, (MathFunction*) _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = built_in_math_function_new ("tan", "Tangent");
	_tmp33_ = _tmp32_;
	function_manager_add (self, (MathFunction*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = built_in_math_function_new ("asin", "Arc sine");
	_tmp35_ = _tmp34_;
	function_manager_add (self, (MathFunction*) _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = built_in_math_function_new ("acos", "Arc cosine");
	_tmp37_ = _tmp36_;
	function_manager_add (self, (MathFunction*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = built_in_math_function_new ("atan", "Arc tangent");
	_tmp39_ = _tmp38_;
	function_manager_add (self, (MathFunction*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = built_in_math_function_new ("sin⁻¹", "Inverse sine");
	_tmp41_ = _tmp40_;
	function_manager_add (self, (MathFunction*) _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = built_in_math_function_new ("cos⁻¹", "Inverse cosine");
	_tmp43_ = _tmp42_;
	function_manager_add (self, (MathFunction*) _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = built_in_math_function_new ("tan⁻¹", "Inverse tangent");
	_tmp45_ = _tmp44_;
	function_manager_add (self, (MathFunction*) _tmp45_);
	_g_object_unref0 (_tmp45_);
	_tmp46_ = built_in_math_function_new ("sinh", "Hyperbolic sine");
	_tmp47_ = _tmp46_;
	function_manager_add (self, (MathFunction*) _tmp47_);
	_g_object_unref0 (_tmp47_);
	_tmp48_ = built_in_math_function_new ("cosh", "Hyperbolic cosine");
	_tmp49_ = _tmp48_;
	function_manager_add (self, (MathFunction*) _tmp49_);
	_g_object_unref0 (_tmp49_);
	_tmp50_ = built_in_math_function_new ("tanh", "Hyperbolic tangent");
	_tmp51_ = _tmp50_;
	function_manager_add (self, (MathFunction*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = built_in_math_function_new ("sinh⁻¹", "Hyperbolic arcsine");
	_tmp53_ = _tmp52_;
	function_manager_add (self, (MathFunction*) _tmp53_);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = built_in_math_function_new ("cosh⁻¹", "Hyperbolic arccosine");
	_tmp55_ = _tmp54_;
	function_manager_add (self, (MathFunction*) _tmp55_);
	_g_object_unref0 (_tmp55_);
	_tmp56_ = built_in_math_function_new ("tanh⁻¹", "Hyperbolic arctangent");
	_tmp57_ = _tmp56_;
	function_manager_add (self, (MathFunction*) _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = built_in_math_function_new ("asinh", "Inverse hyperbolic sine");
	_tmp59_ = _tmp58_;
	function_manager_add (self, (MathFunction*) _tmp59_);
	_g_object_unref0 (_tmp59_);
	_tmp60_ = built_in_math_function_new ("acosh", "Inverse hyperbolic cosine");
	_tmp61_ = _tmp60_;
	function_manager_add (self, (MathFunction*) _tmp61_);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = built_in_math_function_new ("atanh", "Inverse hyperbolic tangent");
	_tmp63_ = _tmp62_;
	function_manager_add (self, (MathFunction*) _tmp63_);
	_g_object_unref0 (_tmp63_);
	_tmp64_ = built_in_math_function_new ("ones", "One's complement");
	_tmp65_ = _tmp64_;
	function_manager_add (self, (MathFunction*) _tmp65_);
	_g_object_unref0 (_tmp65_);
	_tmp66_ = built_in_math_function_new ("twos", "Two's complement");
	_tmp67_ = _tmp66_;
	function_manager_add (self, (MathFunction*) _tmp67_);
	_g_object_unref0 (_tmp67_);
}


static void function_manager_reload_custom_functions (FunctionManager* self) {
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->file_name;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
		_g_free0 (data);
		data = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_free0 (data);
		return;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = data;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
	lines = _tmp4_;
	lines_length1 = _vala_array_length (_tmp3_);
	_lines_size_ = lines_length1;
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < _tmp5__length1; line_it = line_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* line = NULL;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				MathFunction* function = NULL;
				const gchar* _tmp7_ = NULL;
				MathFunction* _tmp8_ = NULL;
				MathFunction* _tmp9_ = NULL;
				_tmp7_ = line;
				_tmp8_ = function_manager_parse_function_from_string (self, _tmp7_);
				function = _tmp8_;
				_tmp9_ = function;
				if (_tmp9_ != NULL) {
					GHashTable* _tmp10_ = NULL;
					MathFunction* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					MathFunction* _tmp15_ = NULL;
					MathFunction* _tmp16_ = NULL;
					_tmp10_ = self->priv->functions;
					_tmp11_ = function;
					_tmp12_ = math_function_get_name (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strdup (_tmp13_);
					_tmp15_ = function;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					g_hash_table_insert (_tmp10_, _tmp14_, _tmp16_);
				}
				_g_object_unref0 (function);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static MathFunction* function_manager_parse_function_from_string (FunctionManager* self, const gchar* data) {
	MathFunction* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint i = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* left = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* right = NULL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gchar* expression = NULL;
	gchar* _tmp19_ = NULL;
	gchar* description = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gchar* name = NULL;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* argument_list = NULL;
	const gchar* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar** arguments = NULL;
	const gchar* _tmp57_ = NULL;
	gchar** _tmp58_ = NULL;
	gchar** _tmp59_ = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	const gchar* _tmp60_ = NULL;
	gchar** _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	MathFunction* _tmp64_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = data;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = data;
	_tmp2_ = string_index_of_char (_tmp1_, (gunichar) '=', 0);
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ < 0) {
		result = NULL;
		return result;
	}
	_tmp4_ = data;
	_tmp5_ = i;
	_tmp6_ = string_substring (_tmp4_, (glong) 0, (glong) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_strip (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	left = _tmp9_;
	_tmp10_ = data;
	_tmp11_ = i;
	_tmp12_ = string_substring (_tmp10_, (glong) (_tmp11_ + 1), (glong) -1);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_strip (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	right = _tmp15_;
	_tmp17_ = left;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = right;
		_tmp16_ = _tmp18_ == NULL;
	}
	if (_tmp16_) {
		result = NULL;
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp19_ = g_strdup ("");
	expression = _tmp19_;
	_tmp20_ = g_strdup ("");
	description = _tmp20_;
	_tmp21_ = right;
	_tmp22_ = string_index_of_char (_tmp21_, (gunichar) '@', 0);
	i = _tmp22_;
	_tmp23_ = i;
	if (_tmp23_ < 0) {
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp24_ = right;
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (expression);
		expression = _tmp25_;
	} else {
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		_tmp26_ = right;
		_tmp27_ = i;
		_tmp28_ = string_substring (_tmp26_, (glong) 0, (glong) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = string_strip (_tmp29_);
		_g_free0 (expression);
		expression = _tmp30_;
		_g_free0 (_tmp29_);
		_tmp31_ = right;
		_tmp32_ = i;
		_tmp33_ = string_substring (_tmp31_, (glong) (_tmp32_ + 1), (glong) -1);
		_tmp34_ = _tmp33_;
		_tmp35_ = string_strip (_tmp34_);
		_g_free0 (description);
		description = _tmp35_;
		_g_free0 (_tmp34_);
	}
	_tmp36_ = expression;
	if (_tmp36_ == NULL) {
		result = NULL;
		_g_free0 (description);
		_g_free0 (expression);
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp37_ = left;
	_tmp38_ = string_index_of_char (_tmp37_, (gunichar) '(', 0);
	i = _tmp38_;
	_tmp39_ = i;
	if (_tmp39_ < 0) {
		result = NULL;
		_g_free0 (description);
		_g_free0 (expression);
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp40_ = left;
	_tmp41_ = i;
	_tmp42_ = string_substring (_tmp40_, (glong) 0, (glong) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = string_strip (_tmp43_);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp43_);
	name = _tmp45_;
	_tmp46_ = left;
	_tmp47_ = i;
	_tmp48_ = string_substring (_tmp46_, (glong) (_tmp47_ + 1), (glong) -1);
	_tmp49_ = _tmp48_;
	_tmp50_ = string_strip (_tmp49_);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	argument_list = _tmp51_;
	_tmp53_ = name;
	if (_tmp53_ == NULL) {
		_tmp52_ = TRUE;
	} else {
		const gchar* _tmp54_ = NULL;
		_tmp54_ = argument_list;
		_tmp52_ = _tmp54_ == NULL;
	}
	if (_tmp52_) {
		result = NULL;
		_g_free0 (argument_list);
		_g_free0 (name);
		_g_free0 (description);
		_g_free0 (expression);
		_g_free0 (right);
		_g_free0 (left);
		return result;
	}
	_tmp55_ = argument_list;
	_tmp56_ = string_replace (_tmp55_, ")", "");
	_g_free0 (argument_list);
	argument_list = _tmp56_;
	_tmp57_ = argument_list;
	_tmp59_ = _tmp58_ = g_strsplit_set (_tmp57_, ";", 0);
	arguments = _tmp59_;
	arguments_length1 = _vala_array_length (_tmp58_);
	_arguments_size_ = arguments_length1;
	_tmp60_ = name;
	_tmp61_ = arguments;
	_tmp61__length1 = arguments_length1;
	_tmp62_ = expression;
	_tmp63_ = description;
	_tmp64_ = math_function_new (_tmp60_, _tmp61_, _tmp61__length1, _tmp62_, _tmp63_);
	result = _tmp64_;
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (argument_list);
	_g_free0 (name);
	_g_free0 (description);
	_g_free0 (expression);
	_g_free0 (right);
	_g_free0 (left);
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void function_manager_save (FunctionManager* self) {
	gchar* data = NULL;
	gchar* _tmp0_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_ = NULL;
	gchar* name = NULL;
	MathFunction* math_function = NULL;
	gchar* dir = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	data = _tmp0_;
	_tmp1_ = self->priv->functions;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gchar* _tmp5_ = NULL;
		MathFunction* _tmp6_ = NULL;
		MathFunction* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
		MathFunction* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		MathFunction* _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		MathFunction* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		MathFunction* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		_g_free0 (name);
		_tmp5_ = g_strdup (_tmp2_);
		name = _tmp5_;
		_g_object_unref0 (math_function);
		_tmp6_ = _g_object_ref0 (_tmp3_);
		math_function = _tmp6_;
		if (!_tmp4_) {
			break;
		}
		_tmp7_ = math_function;
		_tmp8_ = math_function_is_custom_function (_tmp7_);
		if (!_tmp8_) {
			continue;
		}
		_tmp9_ = data;
		_tmp10_ = math_function;
		_tmp11_ = math_function_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = math_function;
		_tmp14_ = math_function_get_arguments (_tmp13_, &_tmp14__length1);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _tmp14__length1;
		_tmp16_ = _vala_g_strjoinv (";", _tmp15_, _tmp15__length1);
		_tmp17_ = _tmp16_;
		_tmp18_ = math_function;
		_tmp19_ = math_function_get_expression (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = math_function;
		_tmp22_ = math_function_get_description (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("%s(%s)=%s@%s\n", _tmp12_, _tmp17_, _tmp20_, _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp9_, _tmp25_, NULL);
		_g_free0 (data);
		data = _tmp26_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp17_);
	}
	_tmp27_ = self->priv->file_name;
	_tmp28_ = g_path_get_dirname (_tmp27_);
	dir = _tmp28_;
	g_mkdir_with_parents (dir, 0700);
	{
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		_tmp29_ = self->priv->file_name;
		_tmp30_ = data;
		g_file_set_contents (_tmp29_, _tmp30_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (dir);
			_g_object_unref0 (math_function);
			_g_free0 (name);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (dir);
		_g_object_unref0 (math_function);
		_g_free0 (name);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (dir);
	_g_object_unref0 (math_function);
	_g_free0 (name);
	_g_free0 (data);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** function_manager_array_sort_string (FunctionManager* self, gchar** array, int array_length1, int* result_length1) {
	gchar** result = NULL;
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	gint j = 0;
	gchar* tmp = NULL;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gchar** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	swapped = TRUE;
	_tmp1_ = array;
	_tmp1__length1 = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	_tmp3_ = _tmp1_[_tmp2__length1 - 1];
	if (_tmp3_ == NULL) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	j = _tmp0_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		_tmp4_ = swapped;
		if (!_tmp4_) {
			break;
		}
		swapped = FALSE;
		_tmp5_ = j;
		j = _tmp5_ + 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint _tmp8_ = 0;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					const gchar* _tmp13_ = NULL;
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = array;
					_tmp9__length1 = array_length1;
					_tmp10_ = j;
					if (!(_tmp8_ < (_tmp9__length1 - _tmp10_))) {
						break;
					}
					_tmp11_ = array;
					_tmp11__length1 = array_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					_tmp14_ = array;
					_tmp14__length1 = array_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_ + 1];
					if (g_strcmp0 (_tmp13_, _tmp16_) < 0) {
						gchar** _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						gint _tmp18_ = 0;
						const gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						gchar** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gint _tmp22_ = 0;
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						const gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						gint _tmp29_ = 0;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						_tmp17_ = array;
						_tmp17__length1 = array_length1;
						_tmp18_ = i;
						_tmp19_ = _tmp17_[_tmp18_];
						_tmp20_ = g_strdup (_tmp19_);
						_g_free0 (tmp);
						tmp = _tmp20_;
						_tmp21_ = array;
						_tmp21__length1 = array_length1;
						_tmp22_ = i;
						_tmp23_ = array;
						_tmp23__length1 = array_length1;
						_tmp24_ = i;
						_tmp25_ = _tmp23_[_tmp24_ + 1];
						_tmp26_ = g_strdup (_tmp25_);
						_g_free0 (_tmp21_[_tmp22_]);
						_tmp21_[_tmp22_] = _tmp26_;
						_tmp27_ = _tmp21_[_tmp22_];
						_tmp28_ = array;
						_tmp28__length1 = array_length1;
						_tmp29_ = i;
						_tmp30_ = tmp;
						_tmp31_ = g_strdup (_tmp30_);
						_g_free0 (_tmp28_[_tmp29_ + 1]);
						_tmp28_[_tmp29_ + 1] = _tmp31_;
						_tmp32_ = _tmp28_[_tmp29_ + 1];
						swapped = TRUE;
					}
				}
			}
		}
	}
	_tmp33_ = array;
	_tmp33__length1 = array_length1;
	_tmp34_ = (_tmp33_ != NULL) ? _vala_array_dup1 (_tmp33_, _tmp33__length1) : ((gpointer) _tmp33_);
	_tmp34__length1 = _tmp33__length1;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp34__length1;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_free0 (tmp);
	return result;
}


gchar** function_manager_get_names (FunctionManager* self, int* result_length1) {
	gchar** result = NULL;
	gchar** names = NULL;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar** _tmp2_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_ = NULL;
	gint i = 0;
	gchar* name = NULL;
	MathFunction* definition = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gchar** _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->functions;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = g_new0 (gchar*, (_tmp1_ + 1) + 1);
	names = _tmp2_;
	names_length1 = _tmp1_ + 1;
	_names_size_ = names_length1;
	_tmp3_ = self->priv->functions;
	g_hash_table_iter_init (&iter, _tmp3_);
	i = 0;
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_ = NULL;
		MathFunction* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
		_g_free0 (name);
		_tmp7_ = g_strdup (_tmp4_);
		name = _tmp7_;
		_g_object_unref0 (definition);
		_tmp8_ = _g_object_ref0 (_tmp5_);
		definition = _tmp8_;
		if (!_tmp6_) {
			break;
		}
		_tmp9_ = names;
		_tmp9__length1 = names_length1;
		_tmp10_ = i;
		_tmp11_ = name;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp9_[_tmp10_]);
		_tmp9_[_tmp10_] = _tmp12_;
		_tmp13_ = _tmp9_[_tmp10_];
		_tmp14_ = i;
		i = _tmp14_ + 1;
	}
	_tmp15_ = names;
	_tmp15__length1 = names_length1;
	_tmp16_ = i;
	_g_free0 (_tmp15_[_tmp16_]);
	_tmp15_[_tmp16_] = NULL;
	_tmp17_ = _tmp15_[_tmp16_];
	_tmp18_ = names;
	_tmp18__length1 = names_length1;
	_tmp20_ = function_manager_array_sort_string (self, _tmp18_, _tmp18__length1, &_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _tmp19_;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	_g_object_unref0 (definition);
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean function_manager_add (FunctionManager* self, MathFunction* new_function) {
	gboolean result = FALSE;
	MathFunction* existing_function = NULL;
	MathFunction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	MathFunction* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	MathFunction* _tmp5_ = NULL;
	MathFunction* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_function != NULL, FALSE);
	_tmp0_ = new_function;
	_tmp1_ = math_function_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = function_manager_get (self, _tmp2_);
	existing_function = _tmp3_;
	_tmp5_ = existing_function;
	if (_tmp5_ != NULL) {
		MathFunction* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = existing_function;
		_tmp7_ = math_function_is_custom_function (_tmp6_);
		_tmp4_ = !_tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = FALSE;
		_g_object_unref0 (existing_function);
		return result;
	}
	_tmp8_ = existing_function;
	if (_tmp8_ != NULL) {
		GHashTable* _tmp9_ = NULL;
		MathFunction* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		MathFunction* _tmp14_ = NULL;
		MathFunction* _tmp15_ = NULL;
		_tmp9_ = self->priv->functions;
		_tmp10_ = new_function;
		_tmp11_ = math_function_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = new_function;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		g_hash_table_replace (_tmp9_, _tmp13_, _tmp15_);
	} else {
		GHashTable* _tmp16_ = NULL;
		MathFunction* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		MathFunction* _tmp21_ = NULL;
		MathFunction* _tmp22_ = NULL;
		_tmp16_ = self->priv->functions;
		_tmp17_ = new_function;
		_tmp18_ = math_function_get_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = new_function;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		g_hash_table_insert (_tmp16_, _tmp20_, _tmp22_);
	}
	result = TRUE;
	_g_object_unref0 (existing_function);
	return result;
}


gboolean function_manager_add_function_with_properties (FunctionManager* self, const gchar* name, const gchar* arguments, const gchar* description, Parser* root_parser) {
	gboolean result = FALSE;
	gchar* function_string = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	MathFunction* new_function = NULL;
	const gchar* _tmp11_ = NULL;
	MathFunction* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	MathFunction* _tmp14_ = NULL;
	gboolean is_function_added = FALSE;
	MathFunction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (arguments != NULL, FALSE);
	g_return_val_if_fail (description != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = g_strconcat (_tmp0_, "(", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = arguments;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, ")=", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = description;
	_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	function_string = _tmp10_;
	_tmp11_ = function_string;
	_tmp12_ = function_manager_parse_function_from_string (self, _tmp11_);
	new_function = _tmp12_;
	_tmp14_ = new_function;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		MathFunction* _tmp15_ = NULL;
		Parser* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp15_ = new_function;
		_tmp16_ = root_parser;
		_tmp17_ = math_function_validate (_tmp15_, _tmp16_);
		_tmp13_ = _tmp17_ == FALSE;
	}
	if (_tmp13_) {
		Parser* _tmp18_ = NULL;
		_tmp18_ = root_parser;
		parser_set_error (_tmp18_, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		result = FALSE;
		_g_object_unref0 (new_function);
		_g_free0 (function_string);
		return result;
	}
	_tmp19_ = new_function;
	_tmp20_ = function_manager_add (self, _tmp19_);
	is_function_added = _tmp20_;
	_tmp21_ = is_function_added;
	if (_tmp21_) {
		function_manager_save (self);
	}
	result = is_function_added;
	_g_object_unref0 (new_function);
	_g_free0 (function_string);
	return result;
}


MathFunction* function_manager_get (FunctionManager* self, const gchar* name) {
	MathFunction* result = NULL;
	MathFunction* function = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	MathFunction* _tmp3_ = NULL;
	MathFunction* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	MathFunction* _tmp10_ = NULL;
	MathFunction* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->functions;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((MathFunction*) _tmp2_);
	function = _tmp3_;
	_tmp4_ = function;
	if (_tmp4_ != NULL) {
		result = function;
		return result;
	}
	_tmp5_ = self->priv->functions;
	_tmp6_ = name;
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_hash_table_lookup (_tmp5_, _tmp8_);
	_tmp10_ = _g_object_ref0 ((MathFunction*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	result = _tmp11_;
	_g_object_unref0 (function);
	return result;
}


void function_manager_delete (FunctionManager* self, const gchar* name) {
	MathFunction* function = NULL;
	const gchar* _tmp0_ = NULL;
	MathFunction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	MathFunction* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = function_manager_get (self, _tmp0_);
	function = _tmp1_;
	_tmp3_ = function;
	if (_tmp3_ != NULL) {
		MathFunction* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = function;
		_tmp5_ = math_function_is_custom_function (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GHashTable* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = self->priv->functions;
		_tmp7_ = name;
		g_hash_table_remove (_tmp6_, _tmp7_);
		function_manager_save (self);
	}
	_g_object_unref0 (function);
}


gboolean function_manager_is_function_defined (FunctionManager* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GHashTable* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	lower_name = _tmp1_;
	_tmp3_ = lower_name;
	_tmp4_ = g_str_has_prefix (_tmp3_, "log");
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = lower_name;
		_tmp6_ = string_substring (_tmp5_, (glong) 3, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = sub_atoi (_tmp7_);
		_tmp2_ = _tmp8_ >= 0;
		_g_free0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_free0 (lower_name);
		return result;
	}
	_tmp10_ = self->priv->functions;
	_tmp11_ = name;
	_tmp12_ = g_hash_table_contains (_tmp10_, _tmp11_);
	if (_tmp12_) {
		_tmp9_ = TRUE;
	} else {
		GHashTable* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = self->priv->functions;
		_tmp14_ = lower_name;
		_tmp15_ = g_hash_table_contains (_tmp13_, _tmp14_);
		_tmp9_ = _tmp15_;
	}
	result = _tmp9_;
	_g_free0 (lower_name);
	return result;
}


static Number** _vala_array_dup2 (Number** self, int length) {
	Number** result;
	int i;
	result = g_new0 (Number*, length + 1);
	for (i = 0; i < length; i++) {
		Number* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add3 (Number*** array, int* length, int* size, Number* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Number*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


Number* function_manager_evaluate_function (FunctionManager* self, const gchar* name, Number** arguments, int arguments_length1, Parser* parser) {
	Number* result = NULL;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Number** args = NULL;
	Number** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Number** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MathFunction* function = NULL;
	const gchar* _tmp20_ = NULL;
	MathFunction* _tmp21_ = NULL;
	MathFunction* _tmp22_ = NULL;
	MathFunction* _tmp24_ = NULL;
	Number** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	Parser* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	lower_name = _tmp1_;
	_tmp2_ = arguments;
	_tmp2__length1 = arguments_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	args = _tmp3_;
	args_length1 = _tmp3__length1;
	_args_size_ = args_length1;
	_tmp5_ = lower_name;
	_tmp6_ = g_str_has_prefix (_tmp5_, "log");
	if (_tmp6_) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp7_ = lower_name;
		_tmp8_ = string_substring (_tmp7_, (glong) 3, (glong) -1);
		_tmp9_ = _tmp8_;
		_tmp10_ = sub_atoi (_tmp9_);
		_tmp4_ = _tmp10_ > 0;
		_g_free0 (_tmp9_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Number* log_base = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		_tmp11_ = lower_name;
		_tmp12_ = string_substring (_tmp11_, (glong) 3, (glong) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = sub_atoi (_tmp13_);
		_tmp15_ = number_new_integer ((gint64) _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp13_);
		log_base = _tmp16_;
		_tmp17_ = args;
		_tmp17__length1 = args_length1;
		_tmp18_ = log_base;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp19_);
		name = "log";
		_g_object_unref0 (log_base);
	}
	_tmp20_ = name;
	_tmp21_ = function_manager_get (self, _tmp20_);
	function = _tmp21_;
	_tmp22_ = function;
	if (_tmp22_ == NULL) {
		Parser* _tmp23_ = NULL;
		_tmp23_ = parser;
		parser_set_error (_tmp23_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
		result = NULL;
		_g_object_unref0 (function);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (lower_name);
		return result;
	}
	_tmp24_ = function;
	_tmp25_ = args;
	_tmp25__length1 = args_length1;
	_tmp26_ = parser;
	_tmp27_ = math_function_evaluate (_tmp24_, _tmp25_, _tmp25__length1, _tmp26_);
	result = _tmp27_;
	_g_object_unref0 (function);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (lower_name);
	return result;
}


static MathFunction** _vala_array_dup3 (MathFunction** self, int length) {
	MathFunction** result;
	int i;
	result = g_new0 (MathFunction*, length + 1);
	for (i = 0; i < length; i++) {
		MathFunction* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static MathFunction** function_manager_array_sort_math_function (FunctionManager* self, MathFunction** array, int array_length1, int* result_length1) {
	MathFunction** result = NULL;
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	MathFunction** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	MathFunction** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	MathFunction* _tmp3_ = NULL;
	gint j = 0;
	MathFunction* tmp = NULL;
	MathFunction** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	MathFunction** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	MathFunction** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	swapped = TRUE;
	_tmp1_ = array;
	_tmp1__length1 = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	_tmp3_ = _tmp1_[_tmp2__length1 - 1];
	if (_tmp3_ == NULL) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	j = _tmp0_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		_tmp4_ = swapped;
		if (!_tmp4_) {
			break;
		}
		swapped = FALSE;
		_tmp5_ = j;
		j = _tmp5_ + 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint _tmp8_ = 0;
					MathFunction** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					MathFunction** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					MathFunction* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					MathFunction** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					MathFunction* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = array;
					_tmp9__length1 = array_length1;
					_tmp10_ = j;
					if (!(_tmp8_ < (_tmp9__length1 - _tmp10_))) {
						break;
					}
					_tmp11_ = array;
					_tmp11__length1 = array_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					_tmp14_ = math_function_get_name (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = array;
					_tmp16__length1 = array_length1;
					_tmp17_ = i;
					_tmp18_ = _tmp16_[_tmp17_ + 1];
					_tmp19_ = math_function_get_name (_tmp18_);
					_tmp20_ = _tmp19_;
					if (g_strcmp0 (_tmp15_, _tmp20_) > 0) {
						MathFunction** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gint _tmp22_ = 0;
						MathFunction* _tmp23_ = NULL;
						MathFunction* _tmp24_ = NULL;
						MathFunction** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						MathFunction** _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						gint _tmp28_ = 0;
						MathFunction* _tmp29_ = NULL;
						MathFunction* _tmp30_ = NULL;
						MathFunction* _tmp31_ = NULL;
						MathFunction** _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp33_ = 0;
						MathFunction* _tmp34_ = NULL;
						MathFunction* _tmp35_ = NULL;
						MathFunction* _tmp36_ = NULL;
						_tmp21_ = array;
						_tmp21__length1 = array_length1;
						_tmp22_ = i;
						_tmp23_ = _tmp21_[_tmp22_];
						_tmp24_ = _g_object_ref0 (_tmp23_);
						_g_object_unref0 (tmp);
						tmp = _tmp24_;
						_tmp25_ = array;
						_tmp25__length1 = array_length1;
						_tmp26_ = i;
						_tmp27_ = array;
						_tmp27__length1 = array_length1;
						_tmp28_ = i;
						_tmp29_ = _tmp27_[_tmp28_ + 1];
						_tmp30_ = _g_object_ref0 (_tmp29_);
						_g_object_unref0 (_tmp25_[_tmp26_]);
						_tmp25_[_tmp26_] = _tmp30_;
						_tmp31_ = _tmp25_[_tmp26_];
						_tmp32_ = array;
						_tmp32__length1 = array_length1;
						_tmp33_ = i;
						_tmp34_ = tmp;
						_tmp35_ = _g_object_ref0 (_tmp34_);
						_g_object_unref0 (_tmp32_[_tmp33_ + 1]);
						_tmp32_[_tmp33_ + 1] = _tmp35_;
						_tmp36_ = _tmp32_[_tmp33_ + 1];
						swapped = TRUE;
					}
				}
			}
		}
	}
	_tmp37_ = array;
	_tmp37__length1 = array_length1;
	_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup3 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
	_tmp38__length1 = _tmp37__length1;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = _tmp38__length1;
	if (result_length1) {
		*result_length1 = _tmp39__length1;
	}
	result = _tmp39_;
	_g_object_unref0 (tmp);
	return result;
}


static void _vala_array_add4 (MathFunction*** array, int* length, int* size, MathFunction* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (MathFunction*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


MathFunction** function_manager_functions_eligible_for_autocompletion_for_text (FunctionManager* self, const gchar* display_text, int* result_length1) {
	MathFunction** result = NULL;
	MathFunction** eligible_functions = NULL;
	MathFunction** _tmp0_ = NULL;
	gint eligible_functions_length1 = 0;
	gint _eligible_functions_size_ = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* display_text_case_insensitive = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp7_ = NULL;
	gchar* function_name = NULL;
	MathFunction* function = NULL;
	MathFunction** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	MathFunction** _tmp23_ = NULL;
	MathFunction** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display_text != NULL, NULL);
	_tmp0_ = g_new0 (MathFunction*, 0 + 1);
	eligible_functions = _tmp0_;
	eligible_functions_length1 = 0;
	_eligible_functions_size_ = eligible_functions_length1;
	_tmp1_ = display_text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= 1) {
		MathFunction** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = eligible_functions;
		_tmp4__length1 = eligible_functions_length1;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = display_text;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
	display_text_case_insensitive = _tmp6_;
	_tmp7_ = self->priv->functions;
	g_hash_table_iter_init (&iter, _tmp7_);
	while (TRUE) {
		gconstpointer _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_ = NULL;
		MathFunction* _tmp12_ = NULL;
		gchar* function_name_case_insensitive = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp10_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp8_), (gpointer*) (&_tmp9_));
		_g_free0 (function_name);
		_tmp11_ = g_strdup (_tmp8_);
		function_name = _tmp11_;
		_g_object_unref0 (function);
		_tmp12_ = _g_object_ref0 (_tmp9_);
		function = _tmp12_;
		if (!_tmp10_) {
			break;
		}
		_tmp13_ = function_name;
		_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
		function_name_case_insensitive = _tmp14_;
		_tmp15_ = function_name_case_insensitive;
		_tmp16_ = display_text_case_insensitive;
		_tmp17_ = g_str_has_prefix (_tmp15_, _tmp16_);
		if (_tmp17_) {
			MathFunction** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			MathFunction* _tmp19_ = NULL;
			MathFunction* _tmp20_ = NULL;
			_tmp18_ = eligible_functions;
			_tmp18__length1 = eligible_functions_length1;
			_tmp19_ = function;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_vala_array_add4 (&eligible_functions, &eligible_functions_length1, &_eligible_functions_size_, _tmp20_);
		}
		_g_free0 (function_name_case_insensitive);
	}
	_tmp21_ = eligible_functions;
	_tmp21__length1 = eligible_functions_length1;
	_tmp23_ = function_manager_array_sort_math_function (self, _tmp21_, _tmp21__length1, &_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp24__length1 = _tmp22_;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	_g_object_unref0 (function);
	_g_free0 (function_name);
	_g_free0 (display_text_case_insensitive);
	eligible_functions = (_vala_array_free (eligible_functions, eligible_functions_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static void function_manager_class_init (FunctionManagerClass * klass) {
	function_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FunctionManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = function_manager_finalize;
}


static void function_manager_instance_init (FunctionManager * self) {
	self->priv = FUNCTION_MANAGER_GET_PRIVATE (self);
}


static void function_manager_finalize (GObject* obj) {
	FunctionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_MANAGER, FunctionManager);
	_g_free0 (self->priv->file_name);
	_g_hash_table_unref0 (self->priv->functions);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (function_manager_parent_class)->finalize (obj);
}


GType function_manager_get_type (void) {
	static volatile gsize function_manager_type_id__volatile = 0;
	if (g_once_init_enter (&function_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionManager), 0, (GInstanceInitFunc) function_manager_instance_init, NULL };
		GType function_manager_type_id;
		function_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FunctionManager", &g_define_type_info, 0);
		g_once_init_leave (&function_manager_type_id__volatile, function_manager_type_id);
	}
	return function_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



