/* number.c generated by valac 0.32.0.13-d82f, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */

#include <glib.h>
#include <glib-object.h>
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
};

struct _NumberClass {
	GObjectClass parent_class;
};

struct _NumberPrivate {
	__mpfr_struct _re_num;
	__mpfr_struct _im_num;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
static gulong number__precision;
static gulong number__precision = (gulong) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
#define NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NUMBER, NumberPrivate))
enum  {
	NUMBER_DUMMY_PROPERTY
};
static void number_get_re_num (Number* self, __mpfr_struct* result);
static void number_get_im_num (Number* self, __mpfr_struct* result);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
gulong number_get_precision (void);
static void number_set_re_num (Number* self, __mpfr_struct* value);
static void number_set_im_num (Number* self, __mpfr_struct* value);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
Number* number_new_mpfloat (__mpfr_struct* value);
Number* number_construct_mpfloat (GType object_type, __mpfr_struct* value);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_multiply (Number* self, Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_zero (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
void number_check_flags (void);
const gchar* number_get_error (void);
void number_set_error (const gchar* value);
gboolean number_equals (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
Number* number_abs (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_add (Number* self, Number* y);
Number* number_sqrt (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_divide (Number* self, Number* y);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_subtract (Number* self, Number* y);
static Number* number_from_radians (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
static Number* number_copy (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
static Number* number_reciprocal_real (Number* self);
Number* number_epowy (Number* self);
static Number* number_epowy_real (Number* self);
Number* number_xpowy (Number* self, Number* y);
static Number* number_pwr (Number* self, Number* y);
Number* number_root (Number* self, gint64 n);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_ln (Number* self);
static Number* number_root_real (Number* self, gint64 n);
static Number* number_ln_real (Number* self);
Number* number_logarithm (Number* self, gint64 n);
Number* number_factorial (Number* self);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_add_real (Number* self, Number* y);
Number* number_multiply_real (Number* self, Number* y);
Number* number_modulus_divide (Number* self, Number* y);
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* number_sin_real (Number* self, AngleUnit unit);
Number* number_cosh (Number* self);
static Number* number_cos_real (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_tan (Number* self, AngleUnit unit);
static Number* number_to_radians (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self, Number* y);
static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen);
static gint __lambda4_ (Number* self, gint v1, gint v2);
static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_or (Number* self, Number* y);
static gint __lambda5_ (Number* self, gint v1, gint v2);
static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_xor (Number* self, Number* y);
static gint __lambda6_ (Number* self, gint v1, gint v2);
static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_not (Number* self, gint wordlen);
static gint __lambda7_ (Number* self, gint v1, gint v2);
static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_mask (Number* self, Number* x, gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_shift (Number* self, gint count);
Number* number_ones_complement (Number* self, gint wordlen);
static gint __lambda8_ (Number* self, gint v1, gint v2);
static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_twos_complement (Number* self, gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self, guint64 n);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Number* number_new (void);
Number* number_construct (GType object_type);
static gint number_hex_to_int (Number* self, gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gchar* serializer_to_string (Serializer* self, Number* x);
void number_set_precision (gulong value);
static void number_finalize (GObject* obj);
static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c, gint number_base);
gboolean mp_is_overflow (Number* x, gint wordlen);


GType angle_unit_get_type (void) {
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number* number_construct_integer (GType object_type, gint64 value) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	gint64 _tmp2_ = 0LL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = value;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_si (&tmp, (glong) _tmp2_, MPFR_RNDN);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp3_);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_get_precision ();
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = _tmp4_;
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = tmp2;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp6_);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 303 "number.c"
}


Number* number_new_integer (gint64 value) {
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_integer (TYPE_NUMBER, value);
#line 310 "number.c"
}


Number* number_construct_unsigned_integer (GType object_type, guint64 x) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	guint64 _tmp2_ = 0ULL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = x;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp, (gulong) _tmp2_, MPFR_RNDN);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp3_);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_get_precision ();
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = _tmp4_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = tmp2;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp6_);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 355 "number.c"
}


Number* number_new_unsigned_integer (guint64 x) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_unsigned_integer (TYPE_NUMBER, x);
#line 362 "number.c"
}


Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = denominator;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_ < ((gint64) 0)) {
#line 375 "number.c"
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = numerator;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		numerator = -_tmp1_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = denominator;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		denominator = -_tmp2_;
#line 386 "number.c"
	}
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = numerator;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) number_construct_integer (object_type, _tmp3_);
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = denominator;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp4_ != ((gint64) 1)) {
#line 396 "number.c"
		__mpfr_struct tmp = {0};
		__mpfr_struct _tmp5_ = {0};
		__mpfr_struct _tmp6_ = {0};
		gint64 _tmp7_ = 0LL;
		__mpfr_struct _tmp8_ = {0};
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = self->priv->_re_num;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp = _tmp5_;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = self->priv->_re_num;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = denominator;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		mpfr_div_si (&tmp, &_tmp6_, (glong) _tmp7_, MPFR_RNDN);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = tmp;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_re_num (self, &_tmp8_);
#line 416 "number.c"
	}
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 420 "number.c"
}


Number* number_new_fraction (gint64 numerator, gint64 denominator) {
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
#line 427 "number.c"
}


Number* number_construct_mpfloat (GType object_type, __mpfr_struct* value) {
	Number * self = NULL;
	__mpfr_struct _tmp0_ = {0};
	__mpfr_struct tmp = {0};
	gulong _tmp1_ = 0UL;
	gulong _tmp2_ = 0UL;
	__mpfr_struct _tmp3_ = {0};
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = *value;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp0_);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_get_precision ();
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp2_);
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp3_);
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 460 "number.c"
}


Number* number_new_mpfloat (__mpfr_struct* value) {
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_mpfloat (TYPE_NUMBER, value);
#line 467 "number.c"
}


Number* number_construct_double (GType object_type, gdouble value) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	gdouble _tmp2_ = 0.0;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = value;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_d (&tmp, _tmp2_, MPFR_RNDN);
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp3_);
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_get_precision ();
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = _tmp4_;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = tmp2;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp6_);
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 512 "number.c"
}


Number* number_new_double (gdouble value) {
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_double (TYPE_NUMBER, value);
#line 519 "number.c"
}


Number* number_construct_complex (GType object_type, Number* x, Number* y) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	Number* _tmp2_ = NULL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp5_ = 0UL;
	gulong _tmp6_ = 0UL;
	Number* _tmp7_ = NULL;
	__mpfr_struct _tmp8_ = {0};
	__mpfr_struct _tmp9_ = {0};
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = x;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = _tmp2_->priv->_re_num;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set (&tmp, &_tmp3_, MPFR_RNDN);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = tmp;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp4_);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_get_precision ();
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = _tmp5_;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp6_);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = y;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_->priv->_re_num;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set (&tmp2, &_tmp8_, MPFR_RNDN);
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = tmp2;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp9_);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 577 "number.c"
}


Number* number_new_complex (Number* x, Number* y) {
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_complex (TYPE_NUMBER, x, y);
#line 584 "number.c"
}


Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit) {
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	AngleUnit _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Number* y = NULL;
	Number* _tmp3_ = NULL;
	AngleUnit _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (theta != NULL, NULL);
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = theta;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = unit;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_cos (_tmp0_, _tmp1_);
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	x = _tmp2_;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = theta;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = unit;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_sin (_tmp3_, _tmp4_);
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	y = _tmp5_;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = r;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_multiply (x, _tmp6_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = r;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = number_multiply (y, _tmp9_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = _tmp10_;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) number_construct_complex (object_type, _tmp8_, _tmp11_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp11_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp8_);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (y);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (x);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 648 "number.c"
}


Number* number_new_polar (Number* r, Number* theta, AngleUnit unit) {
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
#line 655 "number.c"
}


Number* number_construct_eulers (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct tmp3 = {0};
	gulong _tmp6_ = 0UL;
	gulong _tmp7_ = 0UL;
	__mpfr_struct _tmp8_ = {0};
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_get_precision ();
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = _tmp2_;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp3_);
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 1, MPFR_RNDN);
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = tmp2;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_exp (&tmp, &_tmp4_, MPFR_RNDN);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp5_);
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_get_precision ();
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = _tmp6_;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp3, (mpfr_prec_t) _tmp7_);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp3, (gulong) 0, MPFR_RNDN);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = tmp3;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp8_);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 711 "number.c"
}


Number* number_new_eulers (void) {
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_eulers (TYPE_NUMBER);
#line 718 "number.c"
}


Number* number_construct_i (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_get_precision ();
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = _tmp2_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp3_);
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 1, MPFR_RNDN);
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = tmp;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp4_);
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp2;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp5_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 760 "number.c"
}


Number* number_new_i (void) {
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_i (TYPE_NUMBER);
#line 767 "number.c"
}


Number* number_construct_pi (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_const_pi (&tmp, MPFR_RNDN);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = tmp;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (self, &_tmp2_);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_get_precision ();
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp4_);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp2;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (self, &_tmp5_);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 809 "number.c"
}


Number* number_new_pi (void) {
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_pi (TYPE_NUMBER);
#line 816 "number.c"
}


Number* number_construct_random (GType object_type) {
	Number * self = NULL;
	gdouble _tmp0_ = 0.0;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = g_random_double ();
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) number_construct_double (object_type, _tmp0_);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 829 "number.c"
}


Number* number_new_random (void) {
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct_random (TYPE_NUMBER);
#line 836 "number.c"
}


gint64 number_to_integer (Number* self) {
	gint64 result = 0LL;
	__mpfr_struct _tmp0_ = {0};
	glong _tmp1_ = 0L;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_get_si (&_tmp0_, MPFR_RNDN);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = (gint64) _tmp1_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 854 "number.c"
}


guint64 number_to_unsigned_integer (Number* self) {
	guint64 result = 0ULL;
	__mpfr_struct _tmp0_ = {0};
	gulong _tmp1_ = 0UL;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, 0ULL);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_get_ui (&_tmp0_, MPFR_RNDN);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = (guint64) _tmp1_;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 872 "number.c"
}


gfloat number_to_float (Number* self) {
	gfloat result = 0.0F;
	__mpfr_struct _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_get_flt (&_tmp0_, MPFR_RNDN);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp1_;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 890 "number.c"
}


gdouble number_to_double (Number* self) {
	gdouble result = 0.0;
	__mpfr_struct _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_get_d (&_tmp0_, MPFR_RNDN);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp1_;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 908 "number.c"
}


gboolean number_is_zero (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = self->priv->_re_num;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = mpfr_zero_p (&_tmp1_);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp2_) {
#line 925 "number.c"
		__mpfr_struct _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = self->priv->_im_num;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = mpfr_zero_p (&_tmp3_);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp4_;
#line 934 "number.c"
	} else {
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = FALSE;
#line 938 "number.c"
	}
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 944 "number.c"
}


gboolean number_is_negative (Number* self) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_sgn (&_tmp0_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp1_ < 0;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 962 "number.c"
}


gboolean number_is_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct _tmp1_ = {0};
	gint _tmp2_ = 0;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = FALSE;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 981 "number.c"
	}
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = self->priv->_re_num;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = mpfr_integer_p (&_tmp1_);
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp2_ != 0;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 991 "number.c"
}


gboolean number_is_positive_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = FALSE;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1008 "number.c"
	} else {
		gboolean _tmp1_ = FALSE;
		__mpfr_struct _tmp2_ = {0};
		gint _tmp3_ = 0;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = self->priv->_re_num;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = mpfr_sgn (&_tmp2_);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp3_ >= 0) {
#line 1019 "number.c"
			gboolean _tmp4_ = FALSE;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp4_ = number_is_integer (self);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp1_ = _tmp4_;
#line 1025 "number.c"
		} else {
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp1_ = FALSE;
#line 1029 "number.c"
		}
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp1_;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1035 "number.c"
	}
}


gboolean number_is_natural (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = FALSE;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1053 "number.c"
	} else {
		gboolean _tmp1_ = FALSE;
		__mpfr_struct _tmp2_ = {0};
		gint _tmp3_ = 0;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = self->priv->_re_num;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = mpfr_sgn (&_tmp2_);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp3_ > 0) {
#line 1064 "number.c"
			gboolean _tmp4_ = FALSE;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp4_ = number_is_integer (self);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp1_ = _tmp4_;
#line 1070 "number.c"
		} else {
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp1_ = FALSE;
#line 1074 "number.c"
		}
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp1_;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1080 "number.c"
	}
}


gboolean number_is_complex (Number* self) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_im_num;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_zero_p (&_tmp0_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = !_tmp1_;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1099 "number.c"
}


void number_check_flags (void) {
	gint _tmp0_ = 0;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = mpfr_underflow_p ();
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_ != 0) {
#line 1109 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Underflow error");
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 1121 "number.c"
	} else {
		gint _tmp4_ = 0;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = mpfr_overflow_p ();
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp4_ != 0) {
#line 1128 "number.c"
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp5_ = number_get_error ();
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp6_ = _tmp5_;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp7_ = _ ("Overflow error");
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			number_set_error (_tmp7_);
#line 1140 "number.c"
		}
	}
}


gboolean number_equals (Number* self, Number* y) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	Number* _tmp1_ = NULL;
	__mpfr_struct _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, FALSE);
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = y;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_->priv->_re_num;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = mpfr_equal_p (&_tmp0_, &_tmp2_);
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp3_;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1168 "number.c"
}


gint number_compare (Number* self, Number* y) {
	gint result = 0;
	__mpfr_struct _tmp0_ = {0};
	Number* _tmp1_ = NULL;
	__mpfr_struct _tmp2_ = {0};
	gint _tmp3_ = 0;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, 0);
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = y;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_->priv->_re_num;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = mpfr_cmp (&_tmp0_, &_tmp2_);
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp3_;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1194 "number.c"
}


Number* number_sgn (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	__mpfr_struct _tmp0_ = {0};
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = mpfr_sgn (&_tmp0_);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_new_integer ((gint64) _tmp1_);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp2_;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1218 "number.c"
}


Number* number_invert_sign (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	__mpfr_struct tmp_im = {0};
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct _tmp6_ = {0};
	__mpfr_struct _tmp7_ = {0};
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_neg (&tmp, &_tmp2_, MPFR_RNDN);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = z->priv->_im_num;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp_im = _tmp5_;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = self->priv->_im_num;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_neg (&tmp_im, &_tmp6_, MPFR_RNDN);
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = tmp_im;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (z, &_tmp7_);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1269 "number.c"
}


Number* number_abs (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 1282 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* z = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_real_component (self);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_real = _tmp1_;
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_im = _tmp2_;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = x_real;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = x_real;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_real);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_real = _tmp5_;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = x_im;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = x_im;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_im);
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_im = _tmp8_;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = x_real;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = x_im;
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_add (_tmp9_, _tmp10_);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp11_;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = z;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_sqrt (_tmp12_);
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp13_;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_im);
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_real);
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1349 "number.c"
	} else {
		__mpfr_struct tmp = {0};
		gulong _tmp14_ = 0UL;
		gulong _tmp15_ = 0UL;
		__mpfr_struct _tmp16_ = {0};
		Number* z = NULL;
		__mpfr_struct _tmp17_ = {0};
		Number* _tmp18_ = NULL;
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = number_get_precision ();
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = _tmp14_;
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		mpfr_init2 (&tmp, (mpfr_prec_t) _tmp15_);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = self->priv->_re_num;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		mpfr_abs (&tmp, &_tmp16_, MPFR_RNDN);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = tmp;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_new_mpfloat (&_tmp17_);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp18_;
#line 304 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = z;
#line 304 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1378 "number.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self ? g_object_ref (self) : NULL;
#line 1386 "number.c"
}


Number* number_arg (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_real = NULL;
	Number* _tmp5_ = NULL;
	Number* x_im = NULL;
	Number* _tmp6_ = NULL;
	Number* pi = NULL;
	Number* _tmp7_ = NULL;
	Number* z = NULL;
	Number* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	Number* _tmp43_ = NULL;
	AngleUnit _tmp44_ = 0;
	Number* _tmp45_ = NULL;
#line 309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 1411 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Argument not defined for zero");
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp4_;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 1430 "number.c"
	}
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_real_component (self);
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	x_real = _tmp5_;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_imaginary_component (self);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	x_im = _tmp6_;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_new_pi ();
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	pi = _tmp7_;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = x_im;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = number_is_zero (_tmp8_);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp9_) {
#line 1450 "number.c"
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = x_real;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_is_negative (_tmp10_);
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp11_) {
#line 1459 "number.c"
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp12_ = pi;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (z);
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			z = _tmp13_;
#line 1470 "number.c"
		} else {
			Number* _tmp14_ = NULL;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp14_ = number_new_integer ((gint64) 0);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp14_;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (z);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (pi);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (x_im);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (x_real);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 1487 "number.c"
		}
	} else {
		Number* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = x_real;
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = number_is_zero (_tmp15_);
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp16_) {
#line 1498 "number.c"
			Number* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp17_ = x_im;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp18_ = number_is_negative (_tmp17_);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (_tmp18_) {
#line 1507 "number.c"
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp19_ = pi;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp20_ = number_divide_integer (_tmp19_, (gint64) -2);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp20_;
#line 1518 "number.c"
			} else {
				Number* _tmp21_ = NULL;
				Number* _tmp22_ = NULL;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp21_ = pi;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp22_ = number_divide_integer (_tmp21_, (gint64) 2);
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp22_;
#line 1530 "number.c"
			}
		} else {
			Number* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp23_ = x_real;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp24_ = number_is_negative (_tmp23_);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (_tmp24_) {
#line 1541 "number.c"
				Number* _tmp25_ = NULL;
				Number* _tmp26_ = NULL;
				Number* _tmp27_ = NULL;
				Number* _tmp28_ = NULL;
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp25_ = x_im;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp26_ = x_real;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp27_ = number_divide (_tmp25_, _tmp26_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp27_;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp28_ = z;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp29_ = number_atan (_tmp28_, ANGLE_UNIT_RADIANS);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp29_;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp30_ = x_im;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp31_ = number_is_negative (_tmp30_);
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				if (_tmp31_) {
#line 1573 "number.c"
					Number* _tmp32_ = NULL;
					Number* _tmp33_ = NULL;
					Number* _tmp34_ = NULL;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp32_ = z;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp33_ = pi;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp34_ = number_subtract (_tmp32_, _tmp33_);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_g_object_unref0 (z);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					z = _tmp34_;
#line 1587 "number.c"
				} else {
					Number* _tmp35_ = NULL;
					Number* _tmp36_ = NULL;
					Number* _tmp37_ = NULL;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp35_ = z;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp36_ = pi;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp37_ = number_add (_tmp35_, _tmp36_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_g_object_unref0 (z);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					z = _tmp37_;
#line 1602 "number.c"
				}
			} else {
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp38_ = x_im;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp39_ = x_real;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp40_ = number_divide (_tmp38_, _tmp39_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp40_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp41_ = z;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp42_ = number_atan (_tmp41_, ANGLE_UNIT_RADIANS);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp42_;
#line 1628 "number.c"
			}
		}
	}
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp43_ = z;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp44_ = unit;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp45_ = number_from_radians (_tmp43_, _tmp44_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp45_;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (z);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (pi);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (x_im);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (x_real);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1650 "number.c"
}


Number* number_conjugate (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	Number* _tmp3_ = NULL;
	__mpfr_struct tmp2 = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_im_num;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_neg (&tmp, &_tmp2_, MPFR_RNDN);
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_copy (self);
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp3_;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = z->priv->_im_num;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp2 = _tmp4_;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&tmp2);
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (z, &_tmp5_);
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1695 "number.c"
}


Number* number_real_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_copy (self);
#line 370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = z->priv->_im_num;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp1_;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&tmp);
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_get_precision ();
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = _tmp2_;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp3_);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = tmp;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (z, &_tmp4_);
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1736 "number.c"
}


Number* number_imaginary_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_copy (self);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp1_;
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&tmp);
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = z->priv->_im_num;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp2_);
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_get_precision ();
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp4_);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (z, &_tmp5_);
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1782 "number.c"
}


Number* number_integer_component (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_trunc (&tmp, &_tmp2_);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1817 "number.c"
}


Number* number_fractional_component (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_frac (&tmp, &_tmp2_, MPFR_RNDN);
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1852 "number.c"
}


Number* number_fractional_part (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
#line 411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_floor (self);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_subtract (self, _tmp1_);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = _tmp2_;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp1_);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp3_;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1878 "number.c"
}


Number* number_floor (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_floor (&tmp, &_tmp2_);
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1913 "number.c"
}


Number* number_ceiling (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_ceil (&tmp, &_tmp2_);
#line 430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1948 "number.c"
}


Number* number_round (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 438 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 438 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_round (&tmp, &_tmp2_);
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 1983 "number.c"
}


Number* number_reciprocal (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 1996 "number.c"
		Number* real_x = NULL;
		Number* _tmp1_ = NULL;
		Number* im_x = NULL;
		Number* _tmp2_ = NULL;
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* t2 = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* z = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_real_component (self);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_x = _tmp1_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_x = _tmp2_;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = real_x;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = real_x;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t1 = _tmp5_;
#line 453 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = im_x;
#line 453 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = im_x;
#line 453 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
#line 453 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t2 = _tmp8_;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = t1;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = t2;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_add (_tmp9_, _tmp10_);
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t1);
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t1 = _tmp11_;
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = t1;
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_reciprocal_real (_tmp12_);
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp13_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = number_conjugate (self);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = _tmp14_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = z;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = number_multiply (_tmp15_, _tmp16_);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = _tmp17_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp15_);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp18_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t2);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t1);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_x);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_x);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2086 "number.c"
	} else {
		Number* _tmp19_ = NULL;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = number_reciprocal_real (self);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp19_;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2095 "number.c"
	}
}


Number* number_epowy (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 463 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 2110 "number.c"
		Number* _tmp1_ = NULL;
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp1_;
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2118 "number.c"
	}
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_is_complex (self);
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp2_) {
#line 2124 "number.c"
		Number* x_real = NULL;
		Number* _tmp3_ = NULL;
		Number* theta = NULL;
		Number* _tmp4_ = NULL;
		Number* r = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_real_component (self);
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_real = _tmp3_;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_imaginary_component (self);
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		theta = _tmp4_;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = x_real;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = number_epowy_real (_tmp5_);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		r = _tmp6_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = r;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = theta;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = number_new_polar (_tmp7_, _tmp8_, ANGLE_UNIT_RADIANS);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp9_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (r);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (theta);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_real);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2165 "number.c"
	} else {
		Number* _tmp10_ = NULL;
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_epowy_real (self);
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp10_;
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2174 "number.c"
	}
}


Number* number_xpowy (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Number* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	Number* t = NULL;
	Number* t2 = NULL;
	Number* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp44_ = 0UL;
	gulong _tmp45_ = 0UL;
	Number* _tmp46_ = NULL;
	__mpfr_struct _tmp47_ = {0};
	Number* _tmp48_ = NULL;
	__mpfr_struct _tmp49_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp50_ = {0};
	Number* _tmp51_ = NULL;
	__mpfr_struct tmp2 = {0};
	Number* _tmp52_ = NULL;
	__mpfr_struct _tmp53_ = {0};
	gulong _tmp54_ = 0UL;
	gulong _tmp55_ = 0UL;
	Number* _tmp56_ = NULL;
	__mpfr_struct _tmp57_ = {0};
	Number* _tmp58_ = NULL;
	__mpfr_struct _tmp59_ = {0};
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_zero (self);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_) {
#line 2220 "number.c"
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_negative (_tmp2_);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp3_;
#line 2229 "number.c"
	} else {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = FALSE;
#line 2233 "number.c"
	}
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 2237 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_get_error ();
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _tmp4_;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _ ("The power of zero is undefined for a negative exponent");
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp6_);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_new_integer ((gint64) 0);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp7_;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2256 "number.c"
	}
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = number_is_zero (self);
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp9_) {
#line 2262 "number.c"
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = y;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_is_zero (_tmp10_);
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = _tmp11_;
#line 2271 "number.c"
	} else {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = FALSE;
#line 2275 "number.c"
	}
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp8_) {
#line 2279 "number.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = number_get_error ();
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = _tmp12_;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = _ ("Zero raised to zero is undefined");
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp14_);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_new_integer ((gint64) 0);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp15_;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2298 "number.c"
	}
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = number_is_complex (self);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp17_) {
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = TRUE;
#line 2306 "number.c"
	} else {
		Number* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = y;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = number_is_complex (_tmp18_);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = _tmp19_;
#line 2316 "number.c"
	}
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp16_) {
#line 2320 "number.c"
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = y;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = number_pwr (self, _tmp20_);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp21_;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2331 "number.c"
	}
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp22_ = y;
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp23_ = number_is_integer (_tmp22_);
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp23_) {
#line 2339 "number.c"
		Number* reciprocal = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		Number* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = y;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = number_reciprocal (_tmp24_);
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		reciprocal = _tmp25_;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp27_ = reciprocal;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = number_is_integer (_tmp27_);
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp28_) {
#line 2358 "number.c"
			Number* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp29_ = reciprocal;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp30_ = number_is_negative (_tmp29_);
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp26_ = !_tmp30_;
#line 2367 "number.c"
		} else {
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp26_ = FALSE;
#line 2371 "number.c"
		}
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp26_) {
#line 2375 "number.c"
			Number* _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			Number* _tmp33_ = NULL;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp31_ = reciprocal;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp32_ = number_to_integer (_tmp31_);
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp33_ = number_root (self, _tmp32_);
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp33_;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (reciprocal);
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 2391 "number.c"
		} else {
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp34_ = y;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp35_ = number_pwr (self, _tmp34_);
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp35_;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (reciprocal);
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 2405 "number.c"
		}
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (reciprocal);
#line 2409 "number.c"
	}
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp36_ = y;
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp37_ = number_is_negative (_tmp36_);
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp37_) {
#line 2417 "number.c"
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp38_ = number_reciprocal (self);
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp38_;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp39_ = y;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp40_ = number_invert_sign (_tmp39_);
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t2);
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t2 = _tmp40_;
#line 2435 "number.c"
	} else {
		Number* _tmp41_ = NULL;
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp41_ = _g_object_ref0 (self);
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp41_;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp42_ = y;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp43_ = _g_object_ref0 (_tmp42_);
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t2);
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t2 = _tmp43_;
#line 2454 "number.c"
	}
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp44_ = number_get_precision ();
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp45_ = _tmp44_;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp45_);
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp46_ = t;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp47_ = _tmp46_->priv->_re_num;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp48_ = t2;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp49_ = _tmp48_->priv->_re_num;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_pow (&tmp, &_tmp47_, &_tmp49_, MPFR_RNDN);
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp50_ = tmp;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp51_ = number_new_mpfloat (&_tmp50_);
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp51_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp52_ = z;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp53_ = _tmp52_->priv->_im_num;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp2 = _tmp53_;
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&tmp2);
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp54_ = number_get_precision ();
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp55_ = _tmp54_;
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp55_);
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp56_ = t;
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp57_ = _tmp56_->priv->_im_num;
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set (&tmp, &_tmp57_, MPFR_RNDN);
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp58_ = z;
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp59_ = tmp;
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (_tmp58_, &_tmp59_);
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t2);
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t);
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 2512 "number.c"
}


Number* number_xpowy_integer (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	Number* t = NULL;
	gint64 _tmp14_ = 0LL;
	__mpfr_struct tmp = {0};
	gulong _tmp18_ = 0UL;
	gulong _tmp19_ = 0UL;
	Number* _tmp20_ = NULL;
	__mpfr_struct _tmp21_ = {0};
	gint64 _tmp22_ = 0LL;
	Number* z = NULL;
	__mpfr_struct _tmp23_ = {0};
	Number* _tmp24_ = NULL;
	__mpfr_struct tmp2 = {0};
	Number* _tmp25_ = NULL;
	__mpfr_struct _tmp26_ = {0};
	gulong _tmp27_ = 0UL;
	gulong _tmp28_ = 0UL;
	Number* _tmp29_ = NULL;
	__mpfr_struct _tmp30_ = {0};
	Number* _tmp31_ = NULL;
	__mpfr_struct _tmp32_ = {0};
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_zero (self);
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_) {
#line 2548 "number.c"
		gint64 _tmp2_ = 0LL;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = n;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp2_ < ((gint64) 0);
#line 2554 "number.c"
	} else {
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = FALSE;
#line 2558 "number.c"
	}
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 2562 "number.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_get_error ();
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = _tmp3_;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _ ("The power of zero is undefined for a negative exponent");
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp5_);
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = number_new_integer ((gint64) 0);
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp6_;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2581 "number.c"
	}
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_is_zero (self);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp8_) {
#line 2587 "number.c"
		gint64 _tmp9_ = 0LL;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = n;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = _tmp9_ == ((gint64) 0);
#line 2593 "number.c"
	} else {
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = FALSE;
#line 2597 "number.c"
	}
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp7_) {
#line 2601 "number.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_get_error ();
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = _tmp10_;
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = _ ("Zero raised to zero is undefined");
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp12_);
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_new_integer ((gint64) 0);
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp13_;
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2620 "number.c"
	}
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = n;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp14_ < ((gint64) 0)) {
#line 2626 "number.c"
		Number* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_reciprocal (self);
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp15_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = n;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		n = -_tmp16_;
#line 2639 "number.c"
	} else {
		Number* _tmp17_ = NULL;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = _g_object_ref0 (self);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp17_;
#line 2648 "number.c"
	}
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp18_ = number_get_precision ();
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp19_ = _tmp18_;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp19_);
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp20_ = t;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp21_ = _tmp20_->priv->_re_num;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp22_ = n;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_pow_si (&tmp, &_tmp21_, (glong) _tmp22_, MPFR_RNDN);
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp23_ = tmp;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp24_ = number_new_mpfloat (&_tmp23_);
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp24_;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp25_ = z;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp26_ = _tmp25_->priv->_im_num;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp2 = _tmp26_;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&tmp2);
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp27_ = number_get_precision ();
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp28_ = _tmp27_;
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp28_);
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp29_ = t;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp30_ = _tmp29_->priv->_im_num;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set (&tmp, &_tmp30_, MPFR_RNDN);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp31_ = z;
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp32_ = tmp;
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (_tmp31_, &_tmp32_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 2702 "number.c"
}


static Number* number_pwr (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 2726 "number.c"
		Number* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		Number* _tmp6_ = NULL;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = y;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_is_negative (_tmp1_);
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp2_) {
#line 2736 "number.c"
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp3_ = number_get_error ();
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp4_ = _tmp3_;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp5_ = _ ("The power of zero is undefined for a negative exponent");
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			number_set_error (_tmp5_);
#line 2748 "number.c"
		}
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = number_new_integer ((gint64) 0);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp6_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2756 "number.c"
	}
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = y;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_is_zero (_tmp7_);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp8_) {
#line 2764 "number.c"
		Number* _tmp9_ = NULL;
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = number_new_integer ((gint64) 1);
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp9_;
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2772 "number.c"
	}
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = y;
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = number_ln (self);
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = _tmp11_;
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = number_multiply (_tmp10_, _tmp12_);
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = _tmp13_;
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = number_epowy (_tmp14_);
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = _tmp15_;
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp14_);
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp12_);
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp16_;
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 2796 "number.c"
}


Number* number_root (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_is_complex (self);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp2_) {
#line 2811 "number.c"
		gboolean _tmp3_ = FALSE;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_negative (self);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = _tmp3_;
#line 2817 "number.c"
	} else {
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = FALSE;
#line 2821 "number.c"
	}
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_) {
#line 2825 "number.c"
		gint64 _tmp4_ = 0LL;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = n;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = (_tmp4_ % 2) == ((gint64) 1);
#line 2831 "number.c"
	} else {
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = FALSE;
#line 2835 "number.c"
	}
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 2839 "number.c"
		Number* z = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_abs (self);
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp5_;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = z;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = n;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_root_real (_tmp6_, _tmp7_);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp8_;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = z;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_invert_sign (_tmp9_);
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp10_;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = z;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 2873 "number.c"
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = number_is_complex (self);
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp12_) {
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp11_ = TRUE;
#line 2883 "number.c"
		} else {
			gboolean _tmp13_ = FALSE;
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp13_ = number_is_negative (self);
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp11_ = _tmp13_;
#line 2890 "number.c"
		}
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp11_) {
#line 2894 "number.c"
			Number* r = NULL;
			Number* _tmp14_ = NULL;
			Number* theta = NULL;
			Number* _tmp15_ = NULL;
			Number* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
#line 618 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp14_ = number_abs (self);
#line 618 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			r = _tmp14_;
#line 619 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp15_ = number_arg (self, ANGLE_UNIT_RADIANS);
#line 619 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			theta = _tmp15_;
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp16_ = r;
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp17_ = n;
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp18_ = number_root_real (_tmp16_, _tmp17_);
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (r);
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			r = _tmp18_;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp19_ = theta;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp20_ = n;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp21_ = number_divide_integer (_tmp19_, _tmp20_);
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (theta);
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			theta = _tmp21_;
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp22_ = r;
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp23_ = theta;
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp24_ = number_new_polar (_tmp22_, _tmp23_, ANGLE_UNIT_RADIANS);
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp24_;
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (theta);
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (r);
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 2950 "number.c"
		} else {
			gint64 _tmp25_ = 0LL;
			Number* _tmp26_ = NULL;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp25_ = n;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp26_ = number_root_real (self, _tmp25_);
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp26_;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 2962 "number.c"
		}
	}
}


Number* number_sqrt (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
#line 630 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_root (self, (gint64) 2);
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 2979 "number.c"
}


Number* number_ln (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 639 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 639 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 2994 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Logarithm of zero is undefined");
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 643 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 643 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp4_;
#line 643 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3013 "number.c"
	}
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_is_complex (self);
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp6_) {
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = TRUE;
#line 3021 "number.c"
	} else {
		gboolean _tmp7_ = FALSE;
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_is_negative (self);
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _tmp7_;
#line 3028 "number.c"
	}
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp5_) {
#line 3032 "number.c"
		Number* r = NULL;
		Number* _tmp8_ = NULL;
		Number* theta = NULL;
		Number* _tmp9_ = NULL;
		Number* z_real = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_abs (self);
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		r = _tmp8_;
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = number_arg (self, ANGLE_UNIT_RADIANS);
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		theta = _tmp9_;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = r;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_ln_real (_tmp10_);
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_real = _tmp11_;
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = z_real;
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = theta;
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = number_new_complex (_tmp12_, _tmp13_);
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp14_;
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_real);
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (theta);
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (r);
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3073 "number.c"
	} else {
		Number* _tmp15_ = NULL;
#line 665 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_ln_real (self);
#line 665 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp15_;
#line 665 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3082 "number.c"
	}
}


Number* number_logarithm (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	gint64 _tmp5_ = 0LL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 3106 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Logarithm of zero is undefined");
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp4_;
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3125 "number.c"
	}
#line 680 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = n;
#line 680 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_new_integer (_tmp5_);
#line 680 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	t1 = _tmp6_;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_ln (self);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = t1;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = number_ln (_tmp9_);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = _tmp10_;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = number_divide (_tmp8_, _tmp11_);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = _tmp12_;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp11_);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp8_);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp13_;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t1);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 3157 "number.c"
}


Number* number_factorial (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint64 value = 0LL;
	gint64 _tmp20_ = 0LL;
	Number* z = NULL;
	Number* _tmp21_ = NULL;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 3175 "number.c"
		Number* _tmp1_ = NULL;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp1_;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3183 "number.c"
	}
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_is_natural (self);
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp2_) {
#line 3189 "number.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		Number* tmp = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		__mpfr_struct tmp2 = {0};
		gulong _tmp14_ = 0UL;
		gulong _tmp15_ = 0UL;
		Number* _tmp16_ = NULL;
		__mpfr_struct _tmp17_ = {0};
		__mpfr_struct _tmp18_ = {0};
		Number* _tmp19_ = NULL;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_is_negative (self);
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp4_) {
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp3_ = TRUE;
#line 3210 "number.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp5_ = number_is_complex (self);
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp3_ = _tmp5_;
#line 3217 "number.c"
		}
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp3_) {
#line 3221 "number.c"
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp6_ = number_get_error ();
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp7_ = _tmp6_;
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp8_ = _ ("Factorial is only defined for non-negative real numbers");
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			number_set_error (_tmp8_);
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp9_ = number_new_integer ((gint64) 0);
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp9_;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 3240 "number.c"
		}
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_new_integer ((gint64) 1);
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = _tmp10_;
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = number_add (self, _tmp11_);
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = _tmp12_;
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp11_);
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp = _tmp13_;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = number_get_precision ();
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = _tmp14_;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp15_);
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = tmp;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = _tmp16_->priv->_re_num;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		mpfr_gamma (&tmp2, &_tmp17_, MPFR_RNDN);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = tmp2;
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = number_new_mpfloat (&_tmp18_);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp19_;
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (tmp);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3276 "number.c"
	}
#line 711 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp20_ = number_to_integer (self);
#line 711 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	value = _tmp20_;
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp21_ = _g_object_ref0 (self);
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp21_;
#line 3286 "number.c"
	{
		gint i = 0;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		i = 2;
#line 3291 "number.c"
		{
			gboolean _tmp22_ = FALSE;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp22_ = TRUE;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			while (TRUE) {
#line 3298 "number.c"
				gint _tmp24_ = 0;
				gint64 _tmp25_ = 0LL;
				Number* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				Number* _tmp28_ = NULL;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				if (!_tmp22_) {
#line 3306 "number.c"
					gint _tmp23_ = 0;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp23_ = i;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					i = _tmp23_ + 1;
#line 3312 "number.c"
				}
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp22_ = FALSE;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp24_ = i;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp25_ = value;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				if (!(((gint64) _tmp24_) < _tmp25_)) {
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					break;
#line 3324 "number.c"
				}
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp26_ = z;
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp27_ = i;
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp28_ = number_multiply_integer (_tmp26_, (gint64) _tmp27_);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_g_object_unref0 (z);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				z = _tmp28_;
#line 3336 "number.c"
			}
		}
	}
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 3344 "number.c"
}


Number* number_add (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_complex (self);
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_) {
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 3362 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_complex (_tmp2_);
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp3_;
#line 3372 "number.c"
	}
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 3376 "number.c"
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_real_component (self);
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_x = _tmp4_;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_imaginary_component (self);
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_x = _tmp5_;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = y;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_real_component (_tmp6_);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_y = _tmp7_;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = y;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_y = _tmp9_;
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = real_x;
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = real_y;
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = number_add_real (_tmp10_, _tmp11_);
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_z);
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_z = _tmp12_;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = im_x;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = im_y;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_add_real (_tmp13_, _tmp14_);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_z);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_z = _tmp15_;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = real_z;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = im_z;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_new_complex (_tmp16_, _tmp17_);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp18_;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_y);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_y);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_x);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_x);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_z);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_z);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3460 "number.c"
	} else {
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = y;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = number_add_real (self, _tmp19_);
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp20_;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3472 "number.c"
	}
}


Number* number_add_real (Number* self, Number* y) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* _tmp3_ = NULL;
	__mpfr_struct _tmp4_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp5_ = {0};
	Number* _tmp6_ = NULL;
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 743 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 743 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = y;
#line 743 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_->priv->_re_num;
#line 743 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_add (&tmp, &_tmp2_, &_tmp4_, MPFR_RNDN);
#line 744 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 744 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_new_mpfloat (&_tmp5_);
#line 744 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp6_;
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 3516 "number.c"
}


Number* number_subtract (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = y;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_invert_sign (_tmp0_);
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_add (self, _tmp2_);
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp2_);
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp4_;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 3547 "number.c"
}


Number* number_multiply (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 755 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 755 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_complex (self);
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_) {
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 3565 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_complex (_tmp2_);
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp3_;
#line 3575 "number.c"
	}
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 3579 "number.c"
		Number* t1 = NULL;
		Number* t2 = NULL;
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_real_component (self);
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_x = _tmp4_;
#line 762 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_imaginary_component (self);
#line 762 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_x = _tmp5_;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = y;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_real_component (_tmp6_);
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_y = _tmp7_;
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = y;
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_y = _tmp9_;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = real_x;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = real_y;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = number_multiply_real (_tmp10_, _tmp11_);
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t1);
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t1 = _tmp12_;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = im_x;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = im_y;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_multiply_real (_tmp13_, _tmp14_);
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t2);
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t2 = _tmp15_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = t1;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = t2;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_subtract (_tmp16_, _tmp17_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_z);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		real_z = _tmp18_;
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = real_x;
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = im_y;
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = number_multiply_real (_tmp19_, _tmp20_);
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t1);
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t1 = _tmp21_;
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = im_x;
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp23_ = real_y;
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = number_multiply_real (_tmp22_, _tmp23_);
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t2);
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t2 = _tmp24_;
#line 772 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = t1;
#line 772 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp26_ = t2;
#line 772 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp27_ = number_add (_tmp25_, _tmp26_);
#line 772 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_z);
#line 772 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		im_z = _tmp27_;
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = real_z;
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp29_ = im_z;
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = number_new_complex (_tmp28_, _tmp29_);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp30_;
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_y);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_y);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_x);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_x);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (im_z);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (real_z);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t2);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t1);
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3721 "number.c"
	} else {
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp31_ = y;
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp32_ = number_multiply_real (self, _tmp31_);
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp32_;
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3733 "number.c"
	}
}


Number* number_multiply_real (Number* self, Number* y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	Number* _tmp3_ = NULL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 783 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 783 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp1_;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = y;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_->priv->_re_num;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_mul (&tmp, &_tmp2_, &_tmp4_, MPFR_RNDN);
#line 785 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 785 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp5_);
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 3776 "number.c"
}


Number* number_multiply_integer (Number* self, gint64 y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	__mpfr_struct _tmp4_ = {0};
#line 790 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 793 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 793 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp1_;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = y;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_mul_si (&tmp, &_tmp2_, (glong) _tmp3_, MPFR_RNDN);
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = tmp;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp4_);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 3813 "number.c"
}


Number* number_divide (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp52_ = 0UL;
	gulong _tmp53_ = 0UL;
	__mpfr_struct _tmp54_ = {0};
	Number* _tmp55_ = NULL;
	__mpfr_struct _tmp56_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp57_ = {0};
	Number* _tmp58_ = NULL;
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = y;
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_zero (_tmp0_);
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_) {
#line 3842 "number.c"
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_get_error ();
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _tmp2_;
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = _ ("Division by zero is undefined");
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp4_);
#line 806 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_new_integer ((gint64) 0);
#line 806 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp5_;
#line 806 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 3861 "number.c"
	}
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_is_complex (self);
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp7_) {
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = TRUE;
#line 3869 "number.c"
	} else {
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = y;
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = number_is_complex (_tmp8_);
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _tmp9_;
#line 3879 "number.c"
	}
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp6_) {
#line 3883 "number.c"
		Number* a = NULL;
		Number* _tmp10_ = NULL;
		Number* b = NULL;
		Number* _tmp11_ = NULL;
		Number* c = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* d = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* tmp = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* tmp_2 = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* z_1 = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* z_2 = NULL;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* z = NULL;
		Number* _tmp49_ = NULL;
		Number* _tmp50_ = NULL;
		Number* _tmp51_ = NULL;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_real_component (self);
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		a = _tmp10_;
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_imaginary_component (self);
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		b = _tmp11_;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = y;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_real_component (_tmp12_);
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		c = _tmp13_;
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = y;
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_imaginary_component (_tmp14_);
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		d = _tmp15_;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = a;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = c;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = _tmp18_;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = b;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = d;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = number_multiply (_tmp20_, _tmp21_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp23_ = _tmp22_;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = number_add (_tmp19_, _tmp23_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = _tmp24_;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp23_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp19_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp = _tmp25_;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp26_ = c;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp27_ = number_xpowy_integer (_tmp26_, (gint64) 2);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = _tmp27_;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp29_ = d;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = number_xpowy_integer (_tmp29_, (gint64) 2);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp31_ = _tmp30_;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp32_ = number_add (_tmp28_, _tmp31_);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp33_ = _tmp32_;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp31_);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp28_);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp_2 = _tmp33_;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp34_ = tmp;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp35_ = tmp_2;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp36_ = number_divide (_tmp34_, _tmp35_);
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_1 = _tmp36_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp37_ = b;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp38_ = c;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp39_ = number_multiply (_tmp37_, _tmp38_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp40_ = _tmp39_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp41_ = a;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp42_ = d;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp43_ = number_multiply (_tmp41_, _tmp42_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp44_ = _tmp43_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp45_ = number_subtract (_tmp40_, _tmp44_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (tmp);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp = _tmp45_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp44_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp40_);
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp46_ = tmp;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp47_ = tmp_2;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp48_ = number_divide (_tmp46_, _tmp47_);
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_2 = _tmp48_;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp49_ = z_1;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp50_ = z_2;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp51_ = number_new_complex (_tmp49_, _tmp50_);
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp51_;
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = z;
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_2);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_1);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (tmp_2);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (tmp);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (d);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (c);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (b);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (a);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4073 "number.c"
	}
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp52_ = number_get_precision ();
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp53_ = _tmp52_;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp53_);
#line 828 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp54_ = self->priv->_re_num;
#line 828 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp55_ = y;
#line 828 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp56_ = _tmp55_->priv->_re_num;
#line 828 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_div (&tmp, &_tmp54_, &_tmp56_, MPFR_RNDN);
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp57_ = tmp;
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp58_ = number_new_mpfloat (&_tmp57_);
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp58_;
#line 830 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 830 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 4099 "number.c"
}


Number* number_divide_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
#line 834 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = y;
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_new_integer (_tmp0_);
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_divide (self, _tmp2_);
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp2_);
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp4_;
#line 836 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 4128 "number.c"
}


Number* number_modulus_divide (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* t2 = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* z = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gint _tmp23_ = 0;
#line 840 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 840 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_integer (self);
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp1_) {
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 4165 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_integer (_tmp2_);
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = !_tmp3_;
#line 4175 "number.c"
	}
#line 842 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 4179 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_get_error ();
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _tmp4_;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _ ("Modulus division is only defined for integers");
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp6_);
#line 846 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_new_integer ((gint64) 0);
#line 846 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp7_;
#line 846 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4198 "number.c"
	}
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = y;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = number_divide (self, _tmp8_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = _tmp9_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = number_floor (_tmp10_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = _tmp11_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp10_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	t1 = _tmp12_;
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = t1;
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = y;
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = number_multiply (_tmp13_, _tmp14_);
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	t2 = _tmp15_;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = t2;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = number_subtract (self, _tmp16_);
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp17_;
#line 853 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp18_ = number_new_integer ((gint64) 0);
#line 853 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t1);
#line 853 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	t1 = _tmp18_;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp21_ = y;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp22_ = t1;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp23_ = number_compare (_tmp21_, _tmp22_);
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp23_ < 0) {
#line 4242 "number.c"
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		gint _tmp26_ = 0;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = z;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = t1;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp26_ = number_compare (_tmp24_, _tmp25_);
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = _tmp26_ > 0;
#line 4254 "number.c"
	} else {
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = FALSE;
#line 4258 "number.c"
	}
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp20_) {
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = TRUE;
#line 4264 "number.c"
	} else {
		gboolean _tmp27_ = FALSE;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		gint _tmp30_ = 0;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = y;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp29_ = t1;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = number_compare (_tmp28_, _tmp29_);
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp30_ > 0) {
#line 4278 "number.c"
			Number* _tmp31_ = NULL;
			Number* _tmp32_ = NULL;
			gint _tmp33_ = 0;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp31_ = z;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp32_ = t1;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp33_ = number_compare (_tmp31_, _tmp32_);
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp27_ = _tmp33_ < 0;
#line 4290 "number.c"
		} else {
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp27_ = FALSE;
#line 4294 "number.c"
		}
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = _tmp27_;
#line 4298 "number.c"
	}
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp19_) {
#line 4302 "number.c"
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp34_ = z;
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp35_ = y;
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp36_ = number_add (_tmp34_, _tmp35_);
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp36_;
#line 4316 "number.c"
	}
#line 857 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 857 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t2);
#line 857 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t1);
#line 857 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 4326 "number.c"
}


Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod) {
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* exp_value = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* ans = NULL;
	Number* _tmp7_ = NULL;
	Number* two = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	Number* _tmp36_ = NULL;
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (exp != NULL, NULL);
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (mod != NULL, NULL);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_copy (self);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	base_value = _tmp0_;
#line 864 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = exp;
#line 864 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_is_negative (_tmp1_);
#line 864 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp2_) {
#line 4362 "number.c"
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = base_value;
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_reciprocal (_tmp3_);
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (base_value);
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		base_value = _tmp4_;
#line 4373 "number.c"
	}
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = exp;
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_abs (_tmp5_);
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	exp_value = _tmp6_;
#line 867 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_new_integer ((gint64) 1);
#line 867 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	ans = _tmp7_;
#line 868 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_new_integer ((gint64) 2);
#line 868 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	two = _tmp8_;
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 4391 "number.c"
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean is_even = FALSE;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = exp_value;
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_is_zero (_tmp9_);
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!(!_tmp10_)) {
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 4420 "number.c"
		}
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = exp_value;
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = two;
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_modulus_divide (_tmp11_, _tmp12_);
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = _tmp13_;
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_is_zero (_tmp14_);
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = _tmp15_;
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp14_);
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		is_even = _tmp16_;
#line 872 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = is_even;
#line 872 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!_tmp17_) {
#line 4442 "number.c"
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			Number* _tmp20_ = NULL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp18_ = ans;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp19_ = base_value;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp20_ = number_multiply (_tmp18_, _tmp19_);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (ans);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			ans = _tmp20_;
#line 875 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp21_ = ans;
#line 875 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp22_ = mod;
#line 875 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp23_ = number_modulus_divide (_tmp21_, _tmp22_);
#line 875 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (ans);
#line 875 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			ans = _tmp23_;
#line 4469 "number.c"
		}
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = base_value;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = base_value;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (base_value);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		base_value = _tmp26_;
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp27_ = base_value;
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = mod;
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp29_ = number_modulus_divide (_tmp27_, _tmp28_);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (base_value);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		base_value = _tmp29_;
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = exp_value;
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp32_ = _tmp31_;
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp33_ = number_floor (_tmp32_);
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (exp_value);
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		exp_value = _tmp33_;
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp32_);
#line 4505 "number.c"
	}
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp34_ = ans;
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp35_ = mod;
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp36_ = number_modulus_divide (_tmp34_, _tmp35_);
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp36_;
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (two);
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (ans);
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (exp_value);
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (base_value);
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 4525 "number.c"
}


Number* number_sin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 885 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 887 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 887 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 4538 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
#line 889 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_real_component (self);
#line 889 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_real = _tmp1_;
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_im = _tmp2_;
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = x_real;
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = unit;
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_sin_real (_tmp3_, _tmp4_);
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_real = _tmp5_;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = x_im;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_cosh (_tmp6_);
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp7_;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = z_real;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = t;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_real);
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_real = _tmp10_;
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = x_real;
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = unit;
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_cos_real (_tmp11_, _tmp12_);
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_im = _tmp13_;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = x_im;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_sinh (_tmp14_);
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp15_;
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = z_im;
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = t;
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_im);
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_im = _tmp18_;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = z_real;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = z_im;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = number_new_complex (_tmp19_, _tmp20_);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp21_;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_im);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_real);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_im);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_real);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4643 "number.c"
	} else {
		AngleUnit _tmp22_ = 0;
		Number* _tmp23_ = NULL;
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = unit;
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp23_ = number_sin_real (self, _tmp22_);
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp23_;
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4655 "number.c"
	}
}


Number* number_cos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 907 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 909 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_complex (self);
#line 909 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 4669 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
#line 911 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_real_component (self);
#line 911 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_real = _tmp1_;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		x_im = _tmp2_;
#line 914 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = x_real;
#line 914 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = unit;
#line 914 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_cos_real (_tmp3_, _tmp4_);
#line 914 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_real = _tmp5_;
#line 915 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = x_im;
#line 915 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_cosh (_tmp6_);
#line 915 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp7_;
#line 916 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = z_real;
#line 916 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = t;
#line 916 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 916 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_real);
#line 916 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_real = _tmp10_;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = x_real;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = unit;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = number_sin_real (_tmp11_, _tmp12_);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_im = _tmp13_;
#line 919 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp14_ = x_im;
#line 919 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_sinh (_tmp14_);
#line 919 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 919 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		t = _tmp15_;
#line 920 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = z_im;
#line 920 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = t;
#line 920 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 920 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_im);
#line 920 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_im = _tmp18_;
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = z_im;
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = number_invert_sign (_tmp19_);
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_im);
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z_im = _tmp20_;
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = z_real;
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = z_im;
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp23_ = number_new_complex (_tmp21_, _tmp22_);
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp23_;
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_im);
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z_real);
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_im);
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_real);
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4784 "number.c"
	} else {
		AngleUnit _tmp24_ = 0;
		Number* _tmp25_ = NULL;
#line 926 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = unit;
#line 926 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = number_cos_real (self, _tmp24_);
#line 926 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp25_;
#line 926 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4796 "number.c"
	}
}


Number* number_tan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* check = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp19_ = 0UL;
	gulong _tmp20_ = 0UL;
	Number* _tmp21_ = NULL;
	__mpfr_struct _tmp22_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp23_ = {0};
	Number* _tmp24_ = NULL;
#line 930 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 933 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = unit;
#line 933 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_to_radians (self, _tmp0_);
#line 933 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	x_radians = _tmp1_;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = x_radians;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_new_pi ();
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_divide_integer (_tmp4_, (gint64) 2);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = _tmp5_;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_subtract (_tmp2_, _tmp6_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = number_new_pi ();
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = _tmp9_;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = number_divide (_tmp8_, _tmp10_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = _tmp11_;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp10_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp8_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp6_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp4_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	check = _tmp12_;
#line 936 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = check;
#line 936 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = number_is_integer (_tmp13_);
#line 936 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp14_) {
#line 4874 "number.c"
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = number_get_error ();
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = _tmp15_;
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp17_ = _ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)");
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp17_);
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = number_new_integer ((gint64) 0);
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp18_;
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (check);
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (x_radians);
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 4897 "number.c"
	}
#line 943 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp19_ = number_get_precision ();
#line 943 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp20_ = _tmp19_;
#line 943 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp20_);
#line 944 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp21_ = x_radians;
#line 944 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp22_ = _tmp21_->priv->_re_num;
#line 944 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_tan (&tmp, &_tmp22_, MPFR_RNDN);
#line 945 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp23_ = tmp;
#line 945 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp24_ = number_new_mpfloat (&_tmp23_);
#line 945 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp24_;
#line 946 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 946 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (check);
#line 946 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (x_radians);
#line 946 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 4925 "number.c"
}


Number* number_asin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	AngleUnit _tmp18_ = 0;
	Number* _tmp19_ = NULL;
#line 950 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_ > 0;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp2_);
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp4_) {
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 4962 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_new_integer ((gint64) -1);
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _tmp5_;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp7_ < 0;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp6_);
#line 4977 "number.c"
	}
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 4981 "number.c"
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 955 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_get_error ();
#line 955 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = _tmp8_;
#line 955 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = _ ("Inverse sine is undefined for values outside [-1, 1]");
#line 955 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp10_);
#line 956 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_new_integer ((gint64) 0);
#line 956 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp11_;
#line 956 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 5000 "number.c"
	}
#line 959 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = number_get_precision ();
#line 959 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = _tmp12_;
#line 959 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
#line 960 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = self->priv->_re_num;
#line 960 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_asin (&tmp, &_tmp14_, MPFR_RNDN);
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = tmp;
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = number_new_mpfloat (&_tmp15_);
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp16_;
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = z;
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp18_ = unit;
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp19_ = number_from_radians (_tmp17_, _tmp18_);
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp19_;
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (z);
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5030 "number.c"
}


Number* number_acos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	AngleUnit _tmp18_ = 0;
	Number* _tmp19_ = NULL;
#line 966 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_ > 0;
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp2_);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp4_) {
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 5067 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_new_integer ((gint64) -1);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _tmp5_;
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp7_ < 0;
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp6_);
#line 5082 "number.c"
	}
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 5086 "number.c"
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 971 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_get_error ();
#line 971 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = _tmp8_;
#line 971 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = _ ("Inverse cosine is undefined for values outside [-1, 1]");
#line 971 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp10_);
#line 972 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_new_integer ((gint64) 0);
#line 972 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp11_;
#line 972 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 5105 "number.c"
	}
#line 975 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = number_get_precision ();
#line 975 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = _tmp12_;
#line 975 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
#line 976 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = self->priv->_re_num;
#line 976 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_acos (&tmp, &_tmp14_, MPFR_RNDN);
#line 977 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = tmp;
#line 977 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = number_new_mpfloat (&_tmp15_);
#line 977 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp16_;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = z;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp18_ = unit;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp19_ = number_from_radians (_tmp17_, _tmp18_);
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp19_;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (z);
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5135 "number.c"
}


Number* number_atan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	AngleUnit _tmp5_ = 0;
	Number* _tmp6_ = NULL;
#line 982 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 985 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 985 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_atan (&tmp, &_tmp2_, MPFR_RNDN);
#line 986 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 986 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 986 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = unit;
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_from_radians (z, _tmp5_);
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp6_;
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (z);
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5178 "number.c"
}


Number* number_sinh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 991 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 993 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 993 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 993 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 994 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 994 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_sinh (&tmp, &_tmp2_, MPFR_RNDN);
#line 995 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 995 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 995 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 996 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 996 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5213 "number.c"
}


Number* number_cosh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1000 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1002 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 1002 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 1002 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1003 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1003 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_cosh (&tmp, &_tmp2_, MPFR_RNDN);
#line 1004 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 1004 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1004 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 1005 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1005 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5248 "number.c"
}


Number* number_tanh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1011 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 1011 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 1011 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1012 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1012 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_tanh (&tmp, &_tmp2_, MPFR_RNDN);
#line 1013 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 1013 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1013 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 1014 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1014 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5283 "number.c"
}


Number* number_asinh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1018 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1021 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1021 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_asinh (&tmp, &_tmp2_, MPFR_RNDN);
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 1023 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1023 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5318 "number.c"
}


Number* number_acosh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	__mpfr_struct tmp = {0};
	gulong _tmp7_ = 0UL;
	gulong _tmp8_ = 0UL;
	__mpfr_struct _tmp9_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp10_ = {0};
	Number* _tmp11_ = NULL;
#line 1027 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1030 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_new_integer ((gint64) 1);
#line 1030 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	t = _tmp0_;
#line 1031 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = t;
#line 1031 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_compare (self, _tmp1_);
#line 1031 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp2_ < 0) {
#line 5347 "number.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
#line 1034 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_get_error ();
#line 1034 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = _tmp3_;
#line 1034 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _ ("Inverse hyperbolic cosine is undefined for values less than one");
#line 1034 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp5_);
#line 1035 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = number_new_integer ((gint64) 0);
#line 1035 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp6_;
#line 1035 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (t);
#line 1035 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 5368 "number.c"
	}
#line 1038 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_get_precision ();
#line 1038 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 1038 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp8_);
#line 1039 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = self->priv->_re_num;
#line 1039 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_acosh (&tmp, &_tmp9_, MPFR_RNDN);
#line 1040 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = tmp;
#line 1040 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = number_new_mpfloat (&_tmp10_);
#line 1040 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp11_;
#line 1041 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1041 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t);
#line 1041 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5392 "number.c"
}


Number* number_atanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
#line 1045 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_ >= 0;
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp2_);
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp4_) {
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 5426 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = number_new_integer ((gint64) -1);
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _tmp5_;
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp7_ <= 0;
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp6_);
#line 5441 "number.c"
	}
#line 1048 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 5445 "number.c"
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 1051 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = number_get_error ();
#line 1051 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = _tmp8_;
#line 1051 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = _ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]");
#line 1051 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp10_);
#line 1052 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = number_new_integer ((gint64) 0);
#line 1052 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp11_;
#line 1052 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 5464 "number.c"
	}
#line 1055 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = number_get_precision ();
#line 1055 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = _tmp12_;
#line 1055 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
#line 1056 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = self->priv->_re_num;
#line 1056 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_atanh (&tmp, &_tmp14_, MPFR_RNDN);
#line 1057 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = tmp;
#line 1057 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = number_new_mpfloat (&_tmp15_);
#line 1057 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp16_;
#line 1058 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1058 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5486 "number.c"
}


static gint __lambda4_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = v1;
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = v2;
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_ & _tmp1_;
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5502 "number.c"
}


static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5511 "number.c"
}


Number* number_and (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1062 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1062 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1064 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1064 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp1_) {
#line 1064 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 5531 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1065 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 1065 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1065 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = !_tmp3_;
#line 5541 "number.c"
	}
#line 1064 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 5545 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1068 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_get_error ();
#line 1068 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _tmp4_;
#line 1068 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _ ("Boolean AND is only defined for positive integers");
#line 1068 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp6_);
#line 5557 "number.c"
	}
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = y;
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda4__bitwise_func, self, 0);
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp8_;
#line 1071 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5567 "number.c"
}


static gint __lambda5_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = v1;
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = v2;
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_ | _tmp1_;
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5583 "number.c"
}


static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5592 "number.c"
}


Number* number_or (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp1_) {
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 5612 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = !_tmp3_;
#line 5622 "number.c"
	}
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 5626 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1080 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_get_error ();
#line 1080 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _tmp4_;
#line 1080 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _ ("Boolean OR is only defined for positive integers");
#line 1080 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp6_);
#line 5638 "number.c"
	}
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = y;
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda5__bitwise_func, self, 0);
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp8_;
#line 1083 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5648 "number.c"
}


static gint __lambda6_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = v1;
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = v2;
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_ ^ _tmp1_;
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5664 "number.c"
}


static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5673 "number.c"
}


Number* number_xor (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1087 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1087 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp1_) {
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = TRUE;
#line 5693 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = y;
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = !_tmp3_;
#line 5703 "number.c"
	}
#line 1089 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 5707 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_get_error ();
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp5_ = _tmp4_;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = _ ("Boolean XOR is only defined for positive integers");
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp6_);
#line 5719 "number.c"
	}
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = y;
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda6__bitwise_func, self, 0);
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp8_;
#line 1095 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5729 "number.c"
}


static gint __lambda7_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = v1;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_ ^ 0xF;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5742 "number.c"
}


static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5751 "number.c"
}


Number* number_not (Number* self, gint wordlen) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_positive_integer (self);
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp0_) {
#line 5769 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Boolean NOT is only defined for positive integers");
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 5781 "number.c"
	}
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_integer ((gint64) 0);
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = _tmp4_;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = wordlen;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = number_bitwise (self, _tmp5_, ___lambda7__bitwise_func, self, _tmp6_);
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp5_);
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp8_;
#line 1107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 5799 "number.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 5822 "number.c"
		glong _tmp4_ = 0L;
#line 1297 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 5830 "number.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 5842 "number.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 5866 "number.c"
		glong _tmp2_ = 0L;
#line 1308 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 5872 "number.c"
	} else {
#line 1308 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 5876 "number.c"
	}
#line 1308 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 5880 "number.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 5892 "number.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 5902 "number.c"
	}
#line 1315 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 5908 "number.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 5922 "number.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 5932 "number.c"
	}
#line 1321 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 5938 "number.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 5947 "number.c"
	}
#line 1324 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 5967 "number.c"
}


Number* number_mask (Number* self, Number* x, gint wordlen) {
	Number* result = NULL;
	gchar* text = NULL;
	Number* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint offset = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
#line 1111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 1114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = x;
#line 1114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_to_hex_string (_tmp0_);
#line 1114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	text = _tmp1_;
#line 1115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = text;
#line 1115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = strlen (_tmp2_);
#line 1115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 1115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	len = _tmp4_;
#line 1116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = wordlen;
#line 1116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	offset = _tmp5_ / 4;
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = len;
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = offset;
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp7_ > _tmp8_) {
#line 6019 "number.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp9_ = len;
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = offset;
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = ((gint) _tmp9_) - _tmp10_;
#line 6028 "number.c"
	} else {
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = 0;
#line 6032 "number.c"
	}
#line 1117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	offset = _tmp6_;
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = text;
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = offset;
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = string_substring (_tmp11_, (glong) _tmp12_, (glong) -1);
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = _tmp13_;
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = mp_set_from_string (_tmp14_, 16);
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = _tmp15_;
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (_tmp14_);
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp16_;
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (text);
#line 1118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6056 "number.c"
}


Number* number_shift (Number* self, gint count) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp5_ = 0;
#line 1122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_integer (self);
#line 1124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp0_) {
#line 6070 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 1127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 1127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Shift is only possible on integer values");
#line 1127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 1128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp4_;
#line 1128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 6089 "number.c"
	}
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = count;
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp5_ >= 0) {
#line 6095 "number.c"
		gint multiplier = 0;
		gint _tmp11_ = 0;
		Number* _tmp12_ = NULL;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		multiplier = 1;
#line 6101 "number.c"
		{
			gint i = 0;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			i = 0;
#line 6106 "number.c"
			{
				gboolean _tmp6_ = FALSE;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp6_ = TRUE;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				while (TRUE) {
#line 6113 "number.c"
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!_tmp6_) {
#line 6119 "number.c"
						gint _tmp7_ = 0;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp7_ = i;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						i = _tmp7_ + 1;
#line 6125 "number.c"
					}
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp6_ = FALSE;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp8_ = i;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp9_ = count;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!(_tmp8_ < _tmp9_)) {
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						break;
#line 6137 "number.c"
					}
#line 1135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp10_ = multiplier;
#line 1135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					multiplier = _tmp10_ * 2;
#line 6143 "number.c"
				}
			}
		}
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = multiplier;
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = number_multiply_integer (self, (gint64) _tmp11_);
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp12_;
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 6155 "number.c"
	} else {
		gint multiplier = 0;
		gint _tmp18_ = 0;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
#line 1140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		multiplier = 1;
#line 6165 "number.c"
		{
			gint i = 0;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			i = 0;
#line 6170 "number.c"
			{
				gboolean _tmp13_ = FALSE;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp13_ = TRUE;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				while (TRUE) {
#line 6177 "number.c"
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!_tmp13_) {
#line 6183 "number.c"
						gint _tmp14_ = 0;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp14_ = i;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						i = _tmp14_ + 1;
#line 6189 "number.c"
					}
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp13_ = FALSE;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp15_ = i;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp16_ = count;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!(_tmp15_ < (-_tmp16_))) {
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						break;
#line 6201 "number.c"
					}
#line 1142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp17_ = multiplier;
#line 1142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					multiplier = _tmp17_ * 2;
#line 6207 "number.c"
				}
			}
		}
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = multiplier;
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = number_divide_integer (self, (gint64) _tmp18_);
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = _tmp19_;
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = number_floor (_tmp20_);
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = _tmp21_;
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp20_);
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp22_;
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 6227 "number.c"
	}
}


static gint __lambda8_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = v1;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = v2;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_ ^ _tmp1_;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6244 "number.c"
}


static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6253 "number.c"
}


Number* number_ones_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
#line 1148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = wordlen;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, _tmp2_);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = wordlen;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_not (_tmp4_, _tmp5_);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = _tmp6_;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp4_);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp1_);
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp7_;
#line 1150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6293 "number.c"
}


Number* number_twos_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = wordlen;
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_ones_complement (self, _tmp0_);
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_new_integer ((gint64) 1);
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_add (_tmp2_, _tmp4_);
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = _tmp5_;
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp4_);
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp2_);
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp6_;
#line 1156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6330 "number.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 6337 "number.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_list_free (self);
#line 6346 "number.c"
}


GList* number_factorize (Number* self) {
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	guint64 num = 0ULL;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	guint64 _tmp13_ = 0ULL;
	Number* int_max = NULL;
	guint64 _tmp14_ = 0ULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* divisor = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp37_ = NULL;
	Number* root = NULL;
	Number* _tmp38_ = NULL;
	Number* _tmp39_ = NULL;
	Number* _tmp60_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp67_ = FALSE;
#line 1160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	factors = NULL;
#line 1164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_abs (self);
#line 1164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	value = _tmp0_;
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = value;
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_is_zero (_tmp1_);
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp2_) {
#line 6398 "number.c"
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = value;
#line 1168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		factors = g_list_append (factors, _tmp4_);
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = factors;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (value);
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 6413 "number.c"
	}
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = value;
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_new_integer ((gint64) 1);
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = _tmp6_;
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = number_equals (_tmp5_, _tmp7_);
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = _tmp8_;
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp7_);
#line 1172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp9_) {
#line 6429 "number.c"
		Number* _tmp10_ = NULL;
#line 1174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = _g_object_ref0 (self);
#line 1174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		factors = g_list_append (factors, _tmp10_);
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = factors;
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (value);
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 6441 "number.c"
	}
#line 1180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	num = (guint64) 1;
#line 1181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = num;
#line 1181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	num = _tmp11_ << 63;
#line 1182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = num;
#line 1182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = num;
#line 1182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	num = _tmp12_ + (_tmp13_ - 1);
#line 1183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = num;
#line 1183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = number_new_unsigned_integer (_tmp14_);
#line 1183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	int_max = _tmp15_;
#line 1185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = value;
#line 1185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = int_max;
#line 1185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp18_ = number_compare (_tmp16_, _tmp17_);
#line 1185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp18_ <= 0) {
#line 6469 "number.c"
		GList* factors_int64 = NULL;
		Number* _tmp19_ = NULL;
		guint64 _tmp20_ = 0ULL;
		GList* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 1187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = value;
#line 1187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = number_to_unsigned_integer (_tmp19_);
#line 1187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = number_factorize_uint64 (self, _tmp20_);
#line 1187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		factors_int64 = _tmp21_;
#line 1188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = number_is_negative (self);
#line 1188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp22_) {
#line 6487 "number.c"
			GList* _tmp23_ = NULL;
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			Number* _tmp26_ = NULL;
#line 1189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp23_ = factors_int64;
#line 1189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp24_ = factors_int64;
#line 1189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp25_ = _tmp24_->data;
#line 1189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp26_ = number_invert_sign ((Number*) _tmp25_);
#line 1189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp23_->data);
#line 1189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp23_->data = _tmp26_;
#line 6504 "number.c"
		}
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = factors_int64;
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (int_max);
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (value);
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		__g_list_free__g_object_unref0_0 (factors);
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 6516 "number.c"
	}
#line 1193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp27_ = number_new_integer ((gint64) 2);
#line 1193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	divisor = _tmp27_;
#line 1194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 6524 "number.c"
		Number* tmp = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
#line 1196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = value;
#line 1196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp29_ = divisor;
#line 1196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = number_divide (_tmp28_, _tmp29_);
#line 1196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp = _tmp30_;
#line 1197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp31_ = tmp;
#line 1197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp32_ = number_is_integer (_tmp31_);
#line 1197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp32_) {
#line 6545 "number.c"
			Number* _tmp33_ = NULL;
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
#line 1199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp33_ = tmp;
#line 1199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 1199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (value);
#line 1199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			value = _tmp34_;
#line 1200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp35_ = divisor;
#line 1200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 1200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			factors = g_list_append (factors, _tmp36_);
#line 6564 "number.c"
		} else {
#line 1203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (tmp);
#line 1203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 6570 "number.c"
		}
#line 1194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (tmp);
#line 6574 "number.c"
	}
#line 1206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp37_ = number_new_integer ((gint64) 3);
#line 1206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (divisor);
#line 1206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	divisor = _tmp37_;
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp38_ = value;
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp39_ = number_sqrt (_tmp38_);
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	root = _tmp39_;
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 6590 "number.c"
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		Number* tmp = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp40_ = divisor;
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp41_ = root;
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp42_ = number_compare (_tmp40_, _tmp41_);
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!(_tmp42_ <= 0)) {
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 6610 "number.c"
		}
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp43_ = value;
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp44_ = divisor;
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp45_ = number_divide (_tmp43_, _tmp44_);
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		tmp = _tmp45_;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp46_ = tmp;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp47_ = number_is_integer (_tmp46_);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp47_) {
#line 6626 "number.c"
			Number* _tmp48_ = NULL;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp48_ = tmp;
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp49_ = _g_object_ref0 (_tmp48_);
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (value);
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			value = _tmp49_;
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp50_ = value;
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp51_ = number_sqrt (_tmp50_);
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (root);
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			root = _tmp51_;
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp52_ = divisor;
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			factors = g_list_append (factors, _tmp53_);
#line 6655 "number.c"
		} else {
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp54_ = divisor;
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp55_ = number_new_integer ((gint64) 2);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp56_ = _tmp55_;
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp57_ = number_add (_tmp54_, _tmp56_);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (tmp);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			tmp = _tmp57_;
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp56_);
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp58_ = tmp;
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (divisor);
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			divisor = _tmp59_;
#line 6685 "number.c"
		}
#line 1208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (tmp);
#line 6689 "number.c"
	}
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp60_ = value;
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp61_ = number_new_integer ((gint64) 1);
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp62_ = _tmp61_;
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp63_ = number_compare (_tmp60_, _tmp62_);
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp64_ = _tmp63_ > 0;
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp62_);
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp64_) {
#line 6705 "number.c"
		Number* _tmp65_ = NULL;
		Number* _tmp66_ = NULL;
#line 1225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp65_ = value;
#line 1225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp66_ = _g_object_ref0 (_tmp65_);
#line 1225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		factors = g_list_append (factors, _tmp66_);
#line 6714 "number.c"
	}
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp67_ = number_is_negative (self);
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp67_) {
#line 6720 "number.c"
		GList* _tmp68_ = NULL;
		GList* _tmp69_ = NULL;
		gconstpointer _tmp70_ = NULL;
		Number* _tmp71_ = NULL;
#line 1228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp68_ = factors;
#line 1228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp69_ = factors;
#line 1228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp70_ = _tmp69_->data;
#line 1228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp71_ = number_invert_sign ((Number*) _tmp70_);
#line 1228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp68_->data);
#line 1228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp68_->data = _tmp71_;
#line 6737 "number.c"
	}
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = factors;
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (root);
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (divisor);
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (int_max);
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (value);
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6751 "number.c"
}


GList* number_factorize_uint64 (Number* self, guint64 n) {
	GList* result = NULL;
	GList* factors = NULL;
	guint64 _tmp14_ = 0ULL;
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	factors = NULL;
#line 1236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 6765 "number.c"
		guint64 _tmp0_ = 0ULL;
		guint64 _tmp1_ = 0ULL;
		Number* _tmp2_ = NULL;
#line 1236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = n;
#line 1236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!((_tmp0_ % 2) == ((guint64) 0))) {
#line 1236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 6775 "number.c"
		}
#line 1238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = n;
#line 1238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		n = _tmp1_ / 2;
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = number_new_unsigned_integer ((guint64) 2);
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		factors = g_list_append (factors, _tmp2_);
#line 6785 "number.c"
	}
	{
		guint64 divisor = 0ULL;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		divisor = (guint64) 3;
#line 6791 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp3_ = TRUE;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			while (TRUE) {
#line 6798 "number.c"
				guint64 _tmp5_ = 0ULL;
				guint64 _tmp6_ = 0ULL;
				guint64 _tmp7_ = 0ULL;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				if (!_tmp3_) {
#line 6804 "number.c"
					guint64 _tmp4_ = 0ULL;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp4_ = divisor;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					divisor = _tmp4_ + 2;
#line 6810 "number.c"
				}
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp3_ = FALSE;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp5_ = divisor;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp6_ = n;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp7_ = divisor;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				if (!(_tmp5_ <= (_tmp6_ / _tmp7_))) {
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					break;
#line 6824 "number.c"
				}
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				while (TRUE) {
#line 6828 "number.c"
					guint64 _tmp8_ = 0ULL;
					guint64 _tmp9_ = 0ULL;
					guint64 _tmp10_ = 0ULL;
					guint64 _tmp11_ = 0ULL;
					guint64 _tmp12_ = 0ULL;
					Number* _tmp13_ = NULL;
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp8_ = n;
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp9_ = divisor;
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!((_tmp8_ % _tmp9_) == ((guint64) 0))) {
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						break;
#line 6843 "number.c"
					}
#line 1246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp10_ = n;
#line 1246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp11_ = divisor;
#line 1246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					n = _tmp10_ / _tmp11_;
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp12_ = divisor;
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp13_ = number_new_unsigned_integer (_tmp12_);
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					factors = g_list_append (factors, _tmp13_);
#line 6857 "number.c"
				}
			}
		}
	}
#line 1251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = n;
#line 1251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp14_ > ((guint64) 1)) {
#line 6866 "number.c"
		guint64 _tmp15_ = 0ULL;
		Number* _tmp16_ = NULL;
#line 1252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp15_ = n;
#line 1252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = number_new_unsigned_integer (_tmp15_);
#line 1252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		factors = g_list_append (factors, _tmp16_);
#line 6875 "number.c"
	}
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = factors;
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6881 "number.c"
}


static Number* number_copy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp1_ = 0UL;
	gulong _tmp2_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct _tmp6_ = {0};
	__mpfr_struct _tmp7_ = {0};
	__mpfr_struct _tmp8_ = {0};
#line 1256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_new ();
#line 1258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 1259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_get_precision ();
#line 1259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = _tmp1_;
#line 1259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp2_);
#line 1260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_get_precision ();
#line 1260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 1260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp4_);
#line 1261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = self->priv->_re_num;
#line 1261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set (&tmp, &_tmp5_, MPFR_RNDN);
#line 1262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = self->priv->_im_num;
#line 1262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set (&tmp2, &_tmp6_, MPFR_RNDN);
#line 1263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = tmp;
#line 1263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp7_);
#line 1264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = tmp2;
#line 1264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_im_num (z, &_tmp8_);
#line 1265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6937 "number.c"
}


static Number* number_epowy_real (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	__mpfr_struct _tmp3_ = {0};
#line 1268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_copy (self);
#line 1270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 1271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 1271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp1_;
#line 1272 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1272 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_exp (&tmp, &_tmp2_, MPFR_RNDN);
#line 1273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 1273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp3_);
#line 1274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 6971 "number.c"
}


static Number* number_root_real (Number* self, gint64 n) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	__mpfr_struct _tmp4_ = {0};
#line 1277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_copy (self);
#line 1279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp0_;
#line 1280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 1280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp1_;
#line 1281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = n;
#line 1281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_root (&tmp, &_tmp2_, (gulong) _tmp3_, MPFR_RNDN);
#line 1282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = tmp;
#line 1282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp4_);
#line 1283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7008 "number.c"
}


static Number* number_ln_real (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_get_precision ();
#line 1288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 1288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_log (&tmp, &_tmp2_, MPFR_RNDN);
#line 1290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = tmp;
#line 1290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp4_;
#line 1291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7043 "number.c"
}


static Number* number_reciprocal_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp5_ = 0UL;
	gulong _tmp6_ = 0UL;
	__mpfr_struct _tmp7_ = {0};
	__mpfr_struct _tmp8_ = {0};
	Number* z = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	__mpfr_struct _tmp11_ = {0};
	Number* _tmp12_ = NULL;
	__mpfr_struct _tmp13_ = {0};
#line 1294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 7067 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp1_ = number_get_error ();
#line 1299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = _tmp1_;
#line 1299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = _ ("Reciprocal of zero is undefined");
#line 1299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error (_tmp3_);
#line 1300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp4_;
#line 1300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 7086 "number.c"
	}
#line 1303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_get_precision ();
#line 1303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = _tmp5_;
#line 1303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp6_);
#line 1304 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_set_ui (&tmp, (gulong) 1, MPFR_RNDN);
#line 1305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = tmp;
#line 1305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = self->priv->_re_num;
#line 1305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_div (&tmp, &_tmp7_, &_tmp8_, MPFR_RNDN);
#line 1306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = number_copy (self);
#line 1306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp9_;
#line 1307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = z;
#line 1307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = _tmp10_->priv->_re_num;
#line 1307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&_tmp11_);
#line 1308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp12_ = z;
#line 1308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = tmp;
#line 1308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (_tmp12_, &_tmp13_);
#line 1309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7122 "number.c"
}


static Number* number_from_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
#line 1313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = unit;
#line 1315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	switch (_tmp0_) {
#line 7135 "number.c"
		default:
#line 1315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		case ANGLE_UNIT_RADIANS:
#line 7139 "number.c"
		{
			Number* _tmp1_ = NULL;
#line 1319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp1_ = _g_object_ref0 (self);
#line 1319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp1_;
#line 1319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 7148 "number.c"
		}
#line 1315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		case ANGLE_UNIT_DEGREES:
#line 7152 "number.c"
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp2_ = number_multiply_integer (self, (gint64) 180);
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp3_ = _tmp2_;
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp4_ = number_new_pi ();
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp5_ = _tmp4_;
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp6_ = number_divide (_tmp3_, _tmp5_);
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp7_ = _tmp6_;
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp5_);
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp3_);
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp7_;
#line 1322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 7180 "number.c"
		}
#line 1315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		case ANGLE_UNIT_GRADIANS:
#line 7184 "number.c"
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp8_ = number_multiply_integer (self, (gint64) 200);
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp9_ = _tmp8_;
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp10_ = number_new_pi ();
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp11_ = _tmp10_;
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp12_ = number_divide (_tmp9_, _tmp11_);
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp13_ = _tmp12_;
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp11_);
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp9_);
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp13_;
#line 1325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 7212 "number.c"
		}
	}
}


static Number* number_to_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
#line 1330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = unit;
#line 1332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	switch (_tmp0_) {
#line 7227 "number.c"
		default:
#line 1332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		case ANGLE_UNIT_RADIANS:
#line 7231 "number.c"
		{
			Number* _tmp1_ = NULL;
#line 1336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp1_ = _g_object_ref0 (self);
#line 1336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp1_;
#line 1336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 7240 "number.c"
		}
#line 1332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		case ANGLE_UNIT_DEGREES:
#line 7244 "number.c"
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp2_ = number_new_pi ();
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp3_ = _tmp2_;
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp4_ = number_multiply (self, _tmp3_);
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp5_ = _tmp4_;
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp6_ = number_divide_integer (_tmp5_, (gint64) 180);
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp7_ = _tmp6_;
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp5_);
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp3_);
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp7_;
#line 1339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 7272 "number.c"
		}
#line 1332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		case ANGLE_UNIT_GRADIANS:
#line 7276 "number.c"
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp8_ = number_new_pi ();
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp9_ = _tmp8_;
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp10_ = number_multiply (self, _tmp9_);
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp11_ = _tmp10_;
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 200);
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp13_ = _tmp12_;
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp11_);
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp9_);
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = _tmp13_;
#line 1342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 7304 "number.c"
		}
	}
}


static Number* number_sin_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* z = NULL;
	Number* _tmp2_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 1346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = unit;
#line 1348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_to_radians (self, _tmp0_);
#line 1348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	x_radians = _tmp1_;
#line 1349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_new_integer ((gint64) 0);
#line 1349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp2_;
#line 1350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = z->priv->_re_num;
#line 1350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	tmp = _tmp3_;
#line 1351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = x_radians->priv->_re_num;
#line 1351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_sin (&tmp, &_tmp4_, MPFR_RNDN);
#line 1352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 1352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_set_re_num (z, &_tmp5_);
#line 1353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (x_radians);
#line 1353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7351 "number.c"
}


static Number* number_cos_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp5_ = {0};
	Number* _tmp6_ = NULL;
#line 1356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = unit;
#line 1358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = number_to_radians (self, _tmp0_);
#line 1358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	x_radians = _tmp1_;
#line 1359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_get_precision ();
#line 1359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = _tmp2_;
#line 1359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp3_);
#line 1360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = x_radians->priv->_re_num;
#line 1360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_cos (&tmp, &_tmp4_, MPFR_RNDN);
#line 1361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = tmp;
#line 1361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_new_mpfloat (&_tmp5_);
#line 1361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp6_;
#line 1362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (x_radians);
#line 1362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7397 "number.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 7415 "number.c"
}


static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen) {
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_ = NULL;
	gchar* text2 = NULL;
	Number* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint offset1 = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint offset2 = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint offset_out = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gchar* text_out = NULL;
	gint _tmp26_ = 0;
	gchar* _tmp27_ = NULL;
	gint text_out_length1 = 0;
	gint _text_out_size_ = 0;
	gchar* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	Number* _tmp55_ = NULL;
#line 1365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_to_hex_string (self);
#line 1367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	text1 = _tmp0_;
#line 1368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = y;
#line 1368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = number_to_hex_string (_tmp1_);
#line 1368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	text2 = _tmp2_;
#line 1369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = text1;
#line 1369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = strlen (_tmp3_);
#line 1369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = _tmp4_;
#line 1369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	offset1 = _tmp5_ - 1;
#line 1370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = text2;
#line 1370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = strlen (_tmp6_);
#line 1370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 1370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	offset2 = _tmp8_ - 1;
#line 1371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = wordlen;
#line 1371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	offset_out = (_tmp9_ / 4) - 1;
#line 1372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = offset_out;
#line 1372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp10_ <= 0) {
#line 7485 "number.c"
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp12_ = offset1;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp13_ = offset2;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp12_ > _tmp13_) {
#line 7495 "number.c"
			gint _tmp14_ = 0;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp14_ = offset1;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp11_ = _tmp14_;
#line 7501 "number.c"
		} else {
			gint _tmp15_ = 0;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp15_ = offset2;
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp11_ = _tmp15_;
#line 7508 "number.c"
		}
#line 1373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		offset_out = _tmp11_;
#line 7512 "number.c"
	}
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = offset_out;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp17_ > 0) {
#line 7518 "number.c"
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = offset_out;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = offset1;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp19_ < _tmp20_) {
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp18_ = TRUE;
#line 7530 "number.c"
		} else {
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp21_ = offset_out;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp22_ = offset2;
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp18_ = _tmp21_ < _tmp22_;
#line 7540 "number.c"
		}
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = _tmp18_;
#line 7544 "number.c"
	} else {
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp16_ = FALSE;
#line 7548 "number.c"
	}
#line 1374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp16_) {
#line 7552 "number.c"
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
#line 1376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp23_ = number_get_error ();
#line 1376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp24_ = _tmp23_;
#line 1376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_set_error ("Overflow. Try a bigger word size");
#line 1377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = number_new_integer ((gint64) 0);
#line 1377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp25_;
#line 1377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_free0 (text2);
#line 1377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_free0 (text1);
#line 1377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 7572 "number.c"
	}
#line 1380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp26_ = offset_out;
#line 1380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp27_ = g_new0 (gchar, _tmp26_ + 1);
#line 1380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	text_out = _tmp27_;
#line 1380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	text_out_length1 = _tmp26_ + 1;
#line 1380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_text_out_size_ = text_out_length1;
#line 7584 "number.c"
	{
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gchar _tmp30_ = '\0';
		gboolean _tmp31_ = FALSE;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_ = text_out;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28__length1 = text_out_length1;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp29_ = offset_out;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp28_[_tmp29_ + 1] = '\0';
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = _tmp28_[_tmp29_ + 1];
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp31_ = TRUE;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		while (TRUE) {
#line 7605 "number.c"
			gint _tmp33_ = 0;
			gint v1 = 0;
			gint v2 = 0;
#line 1386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
#line 7611 "number.c"
			gint _tmp34_ = 0;
			gint _tmp40_ = 0;
			gchar* _tmp46_ = NULL;
			gint _tmp46__length1 = 0;
			gint _tmp47_ = 0;
			BitwiseFunc _tmp48_ = NULL;
			void* _tmp48__target = NULL;
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gchar _tmp52_ = '\0';
			gchar _tmp53_ = '\0';
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (!_tmp31_) {
#line 7626 "number.c"
				gint _tmp32_ = 0;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp32_ = offset_out;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				offset_out = _tmp32_ - 1;
#line 7632 "number.c"
			}
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp31_ = FALSE;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp33_ = offset_out;
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (!(_tmp33_ >= 0)) {
#line 1383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				break;
#line 7642 "number.c"
			}
#line 1385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			v1 = 0;
#line 1385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			v2 = 0;
#line 1388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp34_ = offset1;
#line 1388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (_tmp34_ >= 0) {
#line 7652 "number.c"
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
#line 1390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp35_ = text1;
#line 1390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp36_ = offset1;
#line 1390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 1390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp38_ = number_hex_to_int (self, _tmp37_);
#line 1390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				v1 = _tmp38_;
#line 1391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp39_ = offset1;
#line 1391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				offset1 = _tmp39_ - 1;
#line 7672 "number.c"
			}
#line 1393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp40_ = offset2;
#line 1393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (_tmp40_ >= 0) {
#line 7678 "number.c"
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gchar _tmp43_ = '\0';
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
#line 1395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp41_ = text2;
#line 1395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp42_ = offset2;
#line 1395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp43_ = string_get (_tmp41_, (glong) _tmp42_);
#line 1395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp44_ = number_hex_to_int (self, _tmp43_);
#line 1395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				v2 = _tmp44_;
#line 1396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp45_ = offset2;
#line 1396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				offset2 = _tmp45_ - 1;
#line 7698 "number.c"
			}
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp46_ = text_out;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp46__length1 = text_out_length1;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp47_ = offset_out;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp48_ = bitwise_operator;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp48__target = bitwise_operator_target;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp49_ = v1;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp50_ = v2;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp51_ = _tmp48_ (_tmp49_, _tmp50_, _tmp48__target);
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp52_ = digits[_tmp51_];
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp46_[_tmp47_] = _tmp52_;
#line 1398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp53_ = _tmp46_[_tmp47_];
#line 7722 "number.c"
		}
	}
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp54_ = text_out;
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp54__length1 = text_out_length1;
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp55_ = mp_set_from_string ((const gchar*) _tmp54_, 16);
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp55_;
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	text_out = (g_free (text_out), NULL);
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (text2);
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (text1);
#line 1401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7741 "number.c"
}


static gint number_hex_to_int (Number* self, gchar digit) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp4_ = FALSE;
	gchar _tmp5_ = '\0';
	gboolean _tmp8_ = FALSE;
	gchar _tmp9_ = '\0';
#line 1404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = digit;
#line 1406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_ >= '0') {
#line 7759 "number.c"
		gchar _tmp2_ = '\0';
#line 1406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = digit;
#line 1406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = _tmp2_ <= '9';
#line 7765 "number.c"
	} else {
#line 1406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp0_ = FALSE;
#line 7769 "number.c"
	}
#line 1406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp0_) {
#line 7773 "number.c"
		gchar _tmp3_ = '\0';
#line 1407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = digit;
#line 1407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = (gint) (_tmp3_ - '0');
#line 1407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 7781 "number.c"
	}
#line 1408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = digit;
#line 1408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp5_ >= 'A') {
#line 7787 "number.c"
		gchar _tmp6_ = '\0';
#line 1408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = digit;
#line 1408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = _tmp6_ <= 'F';
#line 7793 "number.c"
	} else {
#line 1408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = FALSE;
#line 7797 "number.c"
	}
#line 1408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp4_) {
#line 7801 "number.c"
		gchar _tmp7_ = '\0';
#line 1409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp7_ = digit;
#line 1409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = (_tmp7_ - 'A') + 10;
#line 1409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 7809 "number.c"
	}
#line 1410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = digit;
#line 1410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp9_ >= 'a') {
#line 7815 "number.c"
		gchar _tmp10_ = '\0';
#line 1410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = digit;
#line 1410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = _tmp10_ <= 'f';
#line 7821 "number.c"
	} else {
#line 1410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = FALSE;
#line 7825 "number.c"
	}
#line 1410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp8_) {
#line 7829 "number.c"
		gchar _tmp11_ = '\0';
#line 1411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp11_ = digit;
#line 1411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = (_tmp11_ - 'a') + 10;
#line 1411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 7837 "number.c"
	}
#line 1412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = 0;
#line 1412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7843 "number.c"
}


static gchar* number_to_hex_string (Number* self) {
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
#line 1417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	serializer = _tmp0_;
#line 1418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = serializer_to_string (serializer, self);
#line 1418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp1_;
#line 1418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (serializer);
#line 1418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7866 "number.c"
}


Number* number_construct (GType object_type) {
	Number * self = NULL;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return self;
#line 7876 "number.c"
}


Number* number_new (void) {
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return number_construct (TYPE_NUMBER);
#line 7883 "number.c"
}


static void number_get_re_num (Number* self, __mpfr_struct* result) {
	__mpfr_struct _tmp0_ = {0};
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	*result = _tmp0_;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return;
#line 7897 "number.c"
}


static void number_set_re_num (Number* self, __mpfr_struct* value) {
	__mpfr_struct _tmp0_ = {0};
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = *value;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self->priv->_re_num = _tmp0_;
#line 7909 "number.c"
}


static void number_get_im_num (Number* self, __mpfr_struct* result) {
	__mpfr_struct _tmp0_ = {0};
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_im_num;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	*result = _tmp0_;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return;
#line 7923 "number.c"
}


static void number_set_im_num (Number* self, __mpfr_struct* value) {
	__mpfr_struct _tmp0_ = {0};
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = *value;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self->priv->_im_num = _tmp0_;
#line 7935 "number.c"
}


gulong number_get_precision (void) {
	gulong result;
	gulong _tmp0_ = 0UL;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number__precision;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7948 "number.c"
}


void number_set_precision (gulong value) {
	gulong _tmp0_ = 0UL;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = value;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number__precision = _tmp0_;
#line 7958 "number.c"
}


const gchar* number_get_error (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number__error;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp0_;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 7971 "number.c"
}


void number_set_error (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = value;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (number__error);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number__error = _tmp1_;
#line 7986 "number.c"
}


static void number_class_init (NumberClass * klass) {
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_type_class_add_private (klass, sizeof (NumberPrivate));
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
#line 8001 "number.c"
}


static void number_instance_init (Number * self) {
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self->priv = NUMBER_GET_PRIVATE (self);
#line 8008 "number.c"
}


static void number_finalize (GObject* obj) {
	Number * self;
	__mpfr_struct _tmp0_ = {0};
	__mpfr_struct _tmp1_ = {0};
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
#line 167 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 167 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&_tmp0_);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = self->priv->_im_num;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	mpfr_clear (&_tmp1_);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
#line 8028 "number.c"
}


GType number_get_type (void) {
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	switch (property_id) {
#line 8049 "number.c"
		default:
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		break;
#line 8055 "number.c"
	}
}


static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	switch (property_id) {
#line 8065 "number.c"
		default:
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		break;
#line 8071 "number.c"
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1007 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1008 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1008 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1008 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1008 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1010 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1010 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 8097 "number.c"
		gchar* _tmp4_ = NULL;
#line 1011 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1011 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1011 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 8105 "number.c"
	} else {
#line 1013 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = -1;
#line 1013 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 8111 "number.c"
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1105 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1106 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1106 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1106 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1107 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1107 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 8134 "number.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1108 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1108 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1108 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		if (c) {
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8149 "number.c"
		}
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 8153 "number.c"
	} else {
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		if (c) {
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8161 "number.c"
		}
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 8165 "number.c"
	}
#line 1105 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (c) {
#line 1105 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 8171 "number.c"
	}
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 1144 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1145 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1145 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (0 < _tmp0_) {
#line 8186 "number.c"
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
#line 1146 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp1_ = *index;
#line 1146 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
#line 1146 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp2_ - ((gchar*) self));
#line 1147 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1147 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
#line 1147 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_vala_c = _tmp4_;
#line 1148 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1148 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		if (c) {
#line 1148 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8209 "number.c"
		}
#line 1148 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 8213 "number.c"
	} else {
#line 1150 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1151 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1151 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		if (c) {
#line 1151 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8223 "number.c"
		}
#line 1151 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 8227 "number.c"
	}
#line 1144 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (c) {
#line 1144 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 8233 "number.c"
	}
}


Number* mp_set_from_string (const gchar* str, gint default_base) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	static const gunichar base_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
#line 8244 "number.c"
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp7_ = 0;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp24_ = 0;
	gboolean negate = FALSE;
	const gchar* _tmp26_ = NULL;
	gunichar _tmp27_ = 0U;
	gunichar _tmp28_ = 0U;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
#line 1490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	static const gunichar fractions[] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
#line 1491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	static const gint numerators[] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
#line 1492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	static const gint denominators[] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
#line 8264 "number.c"
	gboolean has_fraction = FALSE;
	const gchar* _tmp54_ = NULL;
	gunichar _tmp55_ = 0U;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gboolean _tmp108_ = FALSE;
#line 1427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 1429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = str;
#line 1429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
#line 1429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp1_ >= 0) {
#line 8281 "number.c"
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
#line 1430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp2_ = str;
#line 1430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp3_ = set_from_sexagesimal (_tmp2_);
#line 1430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = _tmp3_;
#line 1430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 8292 "number.c"
	}
#line 1434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	index = 0;
#line 1436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 8298 "number.c"
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
#line 1436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp4_ = str;
#line 1436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
#line 1436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		c = _tmp5_;
#line 1436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!_tmp6_) {
#line 1436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 8312 "number.c"
		}
	}
#line 1437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = index;
#line 1437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	end = _tmp7_;
#line 1438 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	number_base = 0;
#line 1439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	base_multiplier = 1;
#line 1440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 8325 "number.c"
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gint value = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 1440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp8_ = str;
#line 1440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
#line 1440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		c = _tmp9_;
#line 1440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!_tmp10_) {
#line 1440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 8346 "number.c"
		}
#line 1442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		value = -1;
#line 8350 "number.c"
		{
			gint i = 0;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			i = 0;
#line 8355 "number.c"
			{
				gboolean _tmp11_ = FALSE;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp11_ = TRUE;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				while (TRUE) {
#line 8362 "number.c"
					gint _tmp13_ = 0;
					gunichar _tmp14_ = 0U;
					gint _tmp15_ = 0;
					gunichar _tmp16_ = 0U;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!_tmp11_) {
#line 8369 "number.c"
						gint _tmp12_ = 0;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp12_ = i;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						i = _tmp12_ + 1;
#line 8375 "number.c"
					}
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp11_ = FALSE;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp13_ = i;
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!(_tmp13_ < G_N_ELEMENTS (base_digits))) {
#line 1443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						break;
#line 8385 "number.c"
					}
#line 1445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp14_ = c;
#line 1445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp15_ = i;
#line 1445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp16_ = base_digits[_tmp15_];
#line 1445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (_tmp14_ == _tmp16_) {
#line 8395 "number.c"
						gint _tmp17_ = 0;
#line 1447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp17_ = i;
#line 1447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						value = _tmp17_;
#line 1448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						break;
#line 8403 "number.c"
					}
				}
			}
		}
#line 1451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp18_ = value;
#line 1451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp18_ < 0) {
#line 1452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 8414 "number.c"
		}
#line 1454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp19_ = index;
#line 1454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		end = _tmp19_;
#line 1455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp20_ = number_base;
#line 1455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp21_ = value;
#line 1455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp22_ = base_multiplier;
#line 1455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_base = _tmp20_ + (_tmp21_ * _tmp22_);
#line 1456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp23_ = base_multiplier;
#line 1456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		base_multiplier = _tmp23_ * 10;
#line 8432 "number.c"
	}
#line 1458 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp24_ = base_multiplier;
#line 1458 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp24_ == 1) {
#line 8438 "number.c"
		gint _tmp25_ = 0;
#line 1459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp25_ = default_base;
#line 1459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		number_base = _tmp25_;
#line 8444 "number.c"
	}
#line 1462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	negate = FALSE;
#line 1463 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	index = 0;
#line 1464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp26_ = str;
#line 1464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	string_get_next_char (_tmp26_, &index, &_tmp27_);
#line 1464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	c = _tmp27_;
#line 1465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp28_ = c;
#line 1465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp28_ == ((gunichar) '+')) {
#line 1466 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		negate = FALSE;
#line 8462 "number.c"
	} else {
		gboolean _tmp29_ = FALSE;
		gunichar _tmp30_ = 0U;
#line 1467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp30_ = c;
#line 1467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp30_ == ((gunichar) '-')) {
#line 1467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp29_ = TRUE;
#line 8472 "number.c"
		} else {
			gunichar _tmp31_ = 0U;
#line 1467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp31_ = c;
#line 1467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp29_ = _tmp31_ == 8722U;
#line 8479 "number.c"
		}
#line 1467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp29_) {
#line 1468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			negate = TRUE;
#line 8485 "number.c"
		} else {
			const gchar* _tmp32_ = NULL;
			gunichar _tmp33_ = 0U;
#line 1470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp32_ = str;
#line 1470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			string_get_prev_char (_tmp32_, &index, &_tmp33_);
#line 1470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			c = _tmp33_;
#line 8495 "number.c"
		}
	}
#line 1473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp34_ = number_new_integer ((gint64) 0);
#line 1473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	z = _tmp34_;
#line 1475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	while (TRUE) {
#line 8504 "number.c"
		const gchar* _tmp35_ = NULL;
		gunichar _tmp36_ = 0U;
		gboolean _tmp37_ = FALSE;
		gint i = 0;
		gunichar _tmp38_ = 0U;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
#line 1475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp35_ = str;
#line 1475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp37_ = string_get_next_char (_tmp35_, &index, &_tmp36_);
#line 1475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		c = _tmp36_;
#line 1475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (!_tmp37_) {
#line 1475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 8533 "number.c"
		}
#line 1477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp38_ = c;
#line 1477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp39_ = number_base;
#line 1477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp40_ = char_val (_tmp38_, _tmp39_);
#line 1477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		i = _tmp40_;
#line 1478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp41_ = i;
#line 1478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp42_ = number_base;
#line 1478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp41_ > _tmp42_) {
#line 1479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			result = NULL;
#line 1479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (z);
#line 1479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			return result;
#line 8555 "number.c"
		}
#line 1480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp43_ = i;
#line 1480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp43_ < 0) {
#line 8561 "number.c"
			const gchar* _tmp44_ = NULL;
			gunichar _tmp45_ = 0U;
#line 1482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp44_ = str;
#line 1482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			string_get_prev_char (_tmp44_, &index, &_tmp45_);
#line 1482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			c = _tmp45_;
#line 1483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			break;
#line 8572 "number.c"
		}
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp46_ = z;
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp47_ = number_base;
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp48_ = number_multiply_integer (_tmp46_, (gint64) _tmp47_);
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp49_ = _tmp48_;
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp50_ = i;
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp51_ = number_new_integer ((gint64) _tmp50_);
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp52_ = _tmp51_;
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp53_ = number_add (_tmp49_, _tmp52_);
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp53_;
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp52_);
#line 1486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (_tmp49_);
#line 8598 "number.c"
	}
#line 1493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	has_fraction = FALSE;
#line 1494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp54_ = str;
#line 1494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp56_ = string_get_next_char (_tmp54_, &index, &_tmp55_);
#line 1494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	c = _tmp55_;
#line 1494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp56_) {
#line 8610 "number.c"
		gunichar _tmp74_ = 0U;
		{
			gint i = 0;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			i = 0;
#line 8616 "number.c"
			{
				gboolean _tmp57_ = FALSE;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp57_ = TRUE;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				while (TRUE) {
#line 8623 "number.c"
					gint _tmp59_ = 0;
					gunichar _tmp60_ = 0U;
					gint _tmp61_ = 0;
					gunichar _tmp62_ = 0U;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!_tmp57_) {
#line 8630 "number.c"
						gint _tmp58_ = 0;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp58_ = i;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						i = _tmp58_ + 1;
#line 8636 "number.c"
					}
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp57_ = FALSE;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp59_ = i;
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (!(_tmp59_ < G_N_ELEMENTS (fractions))) {
#line 1496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						break;
#line 8646 "number.c"
					}
#line 1498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp60_ = c;
#line 1498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp61_ = i;
#line 1498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					_tmp62_ = fractions[_tmp61_];
#line 1498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
					if (_tmp60_ == _tmp62_) {
#line 8656 "number.c"
						Number* fraction = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
						Number* _tmp67_ = NULL;
						Number* _tmp68_ = NULL;
						Number* _tmp69_ = NULL;
						Number* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gunichar _tmp72_ = 0U;
						gboolean _tmp73_ = FALSE;
#line 1500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp63_ = i;
#line 1500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp64_ = numerators[_tmp63_];
#line 1500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp65_ = i;
#line 1500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp66_ = denominators[_tmp65_];
#line 1500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp67_ = number_new_fraction ((gint64) _tmp64_, (gint64) _tmp66_);
#line 1500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						fraction = _tmp67_;
#line 1501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp68_ = z;
#line 1501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp69_ = fraction;
#line 1501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp70_ = number_add (_tmp68_, _tmp69_);
#line 1501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_g_object_unref0 (z);
#line 1501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						z = _tmp70_;
#line 1504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp71_ = str;
#line 1504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_tmp73_ = string_get_next_char (_tmp71_, &index, &_tmp72_);
#line 1504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						c = _tmp72_;
#line 1504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						if (!_tmp73_) {
#line 1505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							result = z;
#line 1505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							_g_object_unref0 (fraction);
#line 1505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							return result;
#line 8705 "number.c"
						} else {
#line 1507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							result = NULL;
#line 1507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							_g_object_unref0 (fraction);
#line 1507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							_g_object_unref0 (z);
#line 1507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
							return result;
#line 8715 "number.c"
						}
#line 1498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
						_g_object_unref0 (fraction);
#line 8719 "number.c"
					}
				}
			}
		}
#line 1512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp74_ = c;
#line 1512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		if (_tmp74_ == ((gunichar) '.')) {
#line 1513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			has_fraction = TRUE;
#line 8730 "number.c"
		} else {
			const gchar* _tmp75_ = NULL;
			gunichar _tmp76_ = 0U;
#line 1515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp75_ = str;
#line 1515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			string_get_prev_char (_tmp75_, &index, &_tmp76_);
#line 1515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			c = _tmp76_;
#line 8740 "number.c"
		}
	}
#line 1519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp77_ = has_fraction;
#line 1519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp77_) {
#line 8747 "number.c"
		Number* numerator = NULL;
		Number* _tmp78_ = NULL;
		Number* denominator = NULL;
		Number* _tmp79_ = NULL;
		Number* _tmp100_ = NULL;
		Number* _tmp101_ = NULL;
		Number* _tmp102_ = NULL;
		Number* _tmp103_ = NULL;
		Number* _tmp104_ = NULL;
		Number* _tmp105_ = NULL;
#line 1521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp78_ = number_new_integer ((gint64) 0);
#line 1521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		numerator = _tmp78_;
#line 1522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp79_ = number_new_integer ((gint64) 1);
#line 1522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		denominator = _tmp79_;
#line 1524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		while (TRUE) {
#line 8768 "number.c"
			const gchar* _tmp80_ = NULL;
			gunichar _tmp81_ = 0U;
			gboolean _tmp82_ = FALSE;
			gint i = 0;
			gunichar _tmp83_ = 0U;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			Number* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			Number* _tmp91_ = NULL;
			Number* _tmp92_ = NULL;
			gint _tmp93_ = 0;
			Number* _tmp94_ = NULL;
			Number* _tmp95_ = NULL;
			gint _tmp96_ = 0;
			Number* _tmp97_ = NULL;
			Number* _tmp98_ = NULL;
			Number* _tmp99_ = NULL;
#line 1524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp80_ = str;
#line 1524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp82_ = string_get_next_char (_tmp80_, &index, &_tmp81_);
#line 1524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			c = _tmp81_;
#line 1524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (!_tmp82_) {
#line 1524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				break;
#line 8798 "number.c"
			}
#line 1526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp83_ = c;
#line 1526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp84_ = number_base;
#line 1526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp85_ = char_val (_tmp83_, _tmp84_);
#line 1526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			i = _tmp85_;
#line 1527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp86_ = i;
#line 1527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			if (_tmp86_ < 0) {
#line 8812 "number.c"
				const gchar* _tmp87_ = NULL;
				gunichar _tmp88_ = 0U;
#line 1529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				_tmp87_ = str;
#line 1529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				string_get_prev_char (_tmp87_, &index, &_tmp88_);
#line 1529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				c = _tmp88_;
#line 1530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
				break;
#line 8823 "number.c"
			}
#line 1533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp89_ = denominator;
#line 1533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp90_ = number_base;
#line 1533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp91_ = number_multiply_integer (_tmp89_, (gint64) _tmp90_);
#line 1533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (denominator);
#line 1533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			denominator = _tmp91_;
#line 1534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp92_ = numerator;
#line 1534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp93_ = number_base;
#line 1534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp94_ = number_multiply_integer (_tmp92_, (gint64) _tmp93_);
#line 1534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (numerator);
#line 1534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			numerator = _tmp94_;
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp95_ = numerator;
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp96_ = i;
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp97_ = number_new_integer ((gint64) _tmp96_);
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp98_ = _tmp97_;
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_tmp99_ = number_add (_tmp95_, _tmp98_);
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (numerator);
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			numerator = _tmp99_;
#line 1535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
			_g_object_unref0 (_tmp98_);
#line 8861 "number.c"
		}
#line 1538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp100_ = numerator;
#line 1538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp101_ = denominator;
#line 1538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp102_ = number_divide (_tmp100_, _tmp101_);
#line 1538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (numerator);
#line 1538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		numerator = _tmp102_;
#line 1539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp103_ = z;
#line 1539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp104_ = numerator;
#line 1539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp105_ = number_add (_tmp103_, _tmp104_);
#line 1539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 1539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp105_;
#line 1519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (denominator);
#line 1519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (numerator);
#line 8887 "number.c"
	}
#line 1542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp106_ = index;
#line 1542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp107_ = end;
#line 1542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp106_ != _tmp107_) {
#line 1543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 1543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 8901 "number.c"
	}
#line 1545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp108_ = negate;
#line 1545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp108_) {
#line 8907 "number.c"
		Number* _tmp109_ = NULL;
		Number* _tmp110_ = NULL;
#line 1546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp109_ = z;
#line 1546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_tmp110_ = number_invert_sign (_tmp109_);
#line 1546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (z);
#line 1546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		z = _tmp110_;
#line 8918 "number.c"
	}
#line 1548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = z;
#line 1548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 8924 "number.c"
}


gint char_val (gunichar c, gint number_base) {
	gint result = 0;
	gunichar _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gint value = 0;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 1553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = c;
#line 1553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = g_unichar_isxdigit (_tmp0_);
#line 1553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (!_tmp1_) {
#line 1554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = -1;
#line 1554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 8947 "number.c"
	}
#line 1556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = c;
#line 1556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = g_unichar_xdigit_value (_tmp2_);
#line 1556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	value = _tmp3_;
#line 1558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = value;
#line 1558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = number_base;
#line 1558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp4_ >= _tmp5_) {
#line 1559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = -1;
#line 1559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 8965 "number.c"
	}
#line 1561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = value;
#line 1561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 8971 "number.c"
}


Number* set_from_sexagesimal (const gchar* str) {
	Number* result = NULL;
	gint degree_index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Number* degrees = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint minute_start = 0;
	gint _tmp10_ = 0;
	gunichar c = 0U;
	const gchar* _tmp11_ = NULL;
	gunichar _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	gint minute_index = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Number* minutes = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	Number* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	gint second_start = 0;
	gint _tmp34_ = 0;
	const gchar* _tmp35_ = NULL;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar _tmp39_ = '\0';
	gint second_index = 0;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	Number* seconds = NULL;
	const gchar* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	Number* _tmp50_ = NULL;
	Number* _tmp51_ = NULL;
	Number* _tmp52_ = NULL;
	Number* _tmp53_ = NULL;
	Number* _tmp54_ = NULL;
	Number* _tmp55_ = NULL;
	Number* _tmp56_ = NULL;
	Number* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	gunichar _tmp59_ = 0U;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gchar _tmp62_ = '\0';
#line 1564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 1566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = str;
#line 1566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
#line 1566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	degree_index = _tmp1_;
#line 1567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = degree_index;
#line 1567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp2_ < 0) {
#line 1568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9065 "number.c"
	}
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = str;
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = degree_index;
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) _tmp4_);
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = _tmp5_;
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp7_ = mp_set_from_string (_tmp6_, 10);
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp8_ = _tmp7_;
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (_tmp6_);
#line 1569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	degrees = _tmp8_;
#line 1570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp9_ = degrees;
#line 1570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp9_ == NULL) {
#line 1571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (degrees);
#line 1571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9093 "number.c"
	}
#line 1572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp10_ = degree_index;
#line 1572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	minute_start = _tmp10_;
#line 1574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp11_ = str;
#line 1574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	string_get_next_char (_tmp11_, &minute_start, &_tmp12_);
#line 1574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	c = _tmp12_;
#line 1576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp13_ = str;
#line 1576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp14_ = minute_start;
#line 1576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 1576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp15_ == '\0') {
#line 1577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = degrees;
#line 1577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9117 "number.c"
	}
#line 1578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp16_ = str;
#line 1578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp17_ = minute_start;
#line 1578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp18_ = string_index_of_char (_tmp16_, (gunichar) '\'', _tmp17_);
#line 1578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	minute_index = _tmp18_;
#line 1579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp19_ = minute_index;
#line 1579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp19_ < 0) {
#line 1580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (degrees);
#line 1580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9137 "number.c"
	}
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp20_ = str;
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp21_ = minute_start;
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp22_ = minute_index;
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp23_ = minute_start;
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp24_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp25_ = _tmp24_;
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp26_ = mp_set_from_string (_tmp25_, 10);
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp27_ = _tmp26_;
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (_tmp25_);
#line 1581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	minutes = _tmp27_;
#line 1582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp28_ = minutes;
#line 1582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp28_ == NULL) {
#line 1583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (minutes);
#line 1583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (degrees);
#line 1583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9171 "number.c"
	}
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp29_ = degrees;
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp30_ = minutes;
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 60);
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp32_ = _tmp31_;
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp33_ = number_add (_tmp29_, _tmp32_);
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (degrees);
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	degrees = _tmp33_;
#line 1584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp32_);
#line 1585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp34_ = minute_index;
#line 1585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	second_start = _tmp34_;
#line 1586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp35_ = str;
#line 1586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
#line 1586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	c = _tmp36_;
#line 1588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp37_ = str;
#line 1588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp38_ = second_start;
#line 1588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
#line 1588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp39_ == '\0') {
#line 1589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = degrees;
#line 1589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (minutes);
#line 1589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9213 "number.c"
	}
#line 1590 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp40_ = str;
#line 1590 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp41_ = second_start;
#line 1590 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp42_ = string_index_of_char (_tmp40_, (gunichar) '"', _tmp41_);
#line 1590 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	second_index = _tmp42_;
#line 1591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp43_ = second_index;
#line 1591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp43_ < 0) {
#line 1592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (minutes);
#line 1592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (degrees);
#line 1592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9235 "number.c"
	}
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp44_ = str;
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp45_ = second_start;
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp46_ = second_index;
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp47_ = second_start;
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp48_ = string_substring (_tmp44_, (glong) _tmp45_, (glong) (_tmp46_ - _tmp47_));
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp49_ = _tmp48_;
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp50_ = mp_set_from_string (_tmp49_, 10);
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp51_ = _tmp50_;
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_free0 (_tmp49_);
#line 1593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	seconds = _tmp51_;
#line 1594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp52_ = seconds;
#line 1594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp52_ == NULL) {
#line 1595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (seconds);
#line 1595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (minutes);
#line 1595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (degrees);
#line 1595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9271 "number.c"
	}
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp53_ = degrees;
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp54_ = seconds;
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp55_ = number_divide_integer (_tmp54_, (gint64) 3600);
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp56_ = _tmp55_;
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp57_ = number_add (_tmp53_, _tmp56_);
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (degrees);
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	degrees = _tmp57_;
#line 1596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp56_);
#line 1597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp58_ = str;
#line 1597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	string_get_next_char (_tmp58_, &second_index, &_tmp59_);
#line 1597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	c = _tmp59_;
#line 1600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp60_ = str;
#line 1600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp61_ = second_index;
#line 1600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp62_ = string_get (_tmp60_, (glong) _tmp61_);
#line 1600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	if (_tmp62_ == '\0') {
#line 1601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = degrees;
#line 1601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (seconds);
#line 1601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (minutes);
#line 1601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9311 "number.c"
	} else {
#line 1603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		result = NULL;
#line 1603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (seconds);
#line 1603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (minutes);
#line 1603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		_g_object_unref0 (degrees);
#line 1603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
		return result;
#line 9323 "number.c"
	}
#line 1564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (seconds);
#line 1564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (minutes);
#line 1564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (degrees);
#line 9331 "number.c"
}


gboolean mp_is_overflow (Number* x, gint wordlen) {
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 1607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	g_return_val_if_fail (x != NULL, FALSE);
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp0_ = number_new_integer ((gint64) 2);
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp1_ = _tmp0_;
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp2_ = wordlen;
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp3_ = number_xpowy_integer (_tmp1_, (gint64) _tmp2_);
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp4_ = _tmp3_;
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (_tmp1_);
#line 1609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	t2 = _tmp4_;
#line 1610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp5_ = x;
#line 1610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_tmp6_ = number_compare (t2, _tmp5_);
#line 1610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	result = _tmp6_ > 0;
#line 1610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	_g_object_unref0 (t2);
#line 1610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/lib/number.vala"
	return result;
#line 9371 "number.c"
}



