/* kf-persona.c generated by valac 0.14.0, the Vala compiler
 * generated from kf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_BACKENDS_KF_TYPE_PERSONA (folks_backends_kf_persona_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersona))
#define FOLKS_BACKENDS_KF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))

typedef struct _FolksBackendsKfPersona FolksBackendsKfPersona;
typedef struct _FolksBackendsKfPersonaClass FolksBackendsKfPersonaClass;
typedef struct _FolksBackendsKfPersonaPrivate FolksBackendsKfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
typedef struct _FolksBackendsKfPersonaChangeAliasData FolksBackendsKfPersonaChangeAliasData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsKfPersonaChangeImAddressesData FolksBackendsKfPersonaChangeImAddressesData;
typedef struct _FolksBackendsKfPersonaChangeWebServiceAddressesData FolksBackendsKfPersonaChangeWebServiceAddressesData;

struct _FolksBackendsKfPersona {
	FolksPersona parent_instance;
	FolksBackendsKfPersonaPrivate * priv;
};

struct _FolksBackendsKfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksBackendsKfPersonaPrivate {
	GKeyFile* _key_file;
	GeeHashMultiMap* _im_addresses;
	GeeHashMultiMap* _web_service_addresses;
	gchar* _alias;
};

struct _FolksBackendsKfPersonaChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersona* self;
	gchar* alias;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GKeyFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FolksPersonaStore* _tmp10_;
	FolksPersonaStore* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
};

struct _FolksBackendsKfPersonaChangeImAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersona* self;
	GeeMultiMap* im_addresses;
	GeeHashMultiMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _protocol1_it;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	gchar* protocol1;
	GKeyFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* e1;
	GeeHashMultiMap* _tmp13_;
	GeeHashMultiMap* new_im_addresses;
	GeeMultiMap* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _tmp18_;
	GeeIterator* _protocol2_it;
	GeeIterator* _tmp19_;
	gboolean _tmp20_;
	GeeIterator* _tmp21_;
	gpointer _tmp22_;
	gchar* protocol2;
	GeeMultiMap* _tmp23_;
	const gchar* _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* addresses;
	GeeHashSet* _tmp26_;
	GeeHashSet* normalised_addresses;
	GeeCollection* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _im_fd_it;
	GeeIterator* _tmp29_;
	gboolean _tmp30_;
	GeeIterator* _tmp31_;
	gpointer _tmp32_;
	FolksImFieldDetails* im_fd;
	gchar* normalised_address;
	FolksImFieldDetails* _tmp33_;
	gconstpointer _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError* e2;
	const gchar* _tmp39_;
	FolksImFieldDetails* _tmp40_;
	gconstpointer _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GError* _tmp44_;
	const gchar* _tmp45_;
	GError* _tmp46_;
	GeeHashSet* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	FolksImFieldDetails* _tmp50_;
	FolksImFieldDetails* new_im_fd;
	GeeHashMultiMap* _tmp51_;
	const gchar* _tmp52_;
	FolksImFieldDetails* _tmp53_;
	GeeHashSet* _tmp54_;
	gint _tmp55_;
	gpointer* _tmp56_;
	gchar** addrs;
	gint addrs_length1;
	gint _addrs_size_;
	GeeHashSet* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GKeyFile* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	FolksPersonaStore* _tmp66_;
	FolksPersonaStore* _tmp67_;
	GeeHashMultiMap* _tmp68_;
	GeeHashMultiMap* _tmp69_;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaChangeWebServiceAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersona* self;
	GeeMultiMap* web_service_addresses;
	GeeHashMultiMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _web_service1_it;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	gchar* web_service1;
	GKeyFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* e;
	GeeHashMultiMap* _tmp15_;
	GeeHashMultiMap* new_web_service_addresses;
	GeeMultiMap* _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	GeeIterator* _web_service2_it;
	GeeIterator* _tmp21_;
	gboolean _tmp22_;
	GeeIterator* _tmp23_;
	gpointer _tmp24_;
	gchar* web_service2;
	GeeMultiMap* _tmp25_;
	const gchar* _tmp26_;
	GeeCollection* _tmp27_;
	GeeCollection* ws_fds;
	gchar** _tmp28_;
	gchar** addrs;
	gint addrs_length1;
	gint _addrs_size_;
	GeeCollection* _tmp29_;
	GeeIterator* _tmp30_;
	GeeIterator* _ws_fd1_it;
	GeeIterator* _tmp31_;
	gboolean _tmp32_;
	GeeIterator* _tmp33_;
	gpointer _tmp34_;
	FolksWebServiceFieldDetails* ws_fd1;
	gchar** _tmp35_;
	gint _tmp35__length1;
	FolksWebServiceFieldDetails* _tmp36_;
	gconstpointer _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GKeyFile* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	GeeCollection* _tmp47_;
	GeeIterator* _tmp48_;
	GeeIterator* _ws_fd2_it;
	GeeIterator* _tmp49_;
	gboolean _tmp50_;
	GeeIterator* _tmp51_;
	gpointer _tmp52_;
	FolksWebServiceFieldDetails* ws_fd2;
	GeeHashMultiMap* _tmp53_;
	const gchar* _tmp54_;
	FolksWebServiceFieldDetails* _tmp55_;
	FolksPersonaStore* _tmp56_;
	FolksPersonaStore* _tmp57_;
	GeeHashMultiMap* _tmp58_;
	GeeHashMultiMap* _tmp59_;
	GError * _inner_error_;
};


static gpointer folks_backends_kf_persona_parent_class = NULL;
static FolksAliasDetailsIface* folks_backends_kf_persona_folks_alias_details_parent_iface = NULL;
static FolksImDetailsIface* folks_backends_kf_persona_folks_im_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* folks_backends_kf_persona_folks_web_service_details_parent_iface = NULL;

GType folks_backends_kf_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaPrivate))
enum  {
	FOLKS_BACKENDS_KF_PERSONA_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_BACKENDS_KF_PERSONA_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_KF_PERSONA_ALIAS,
	FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES,
	FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES
};
static void folks_backends_kf_persona_real_change_alias_data_free (gpointer _data);
static void folks_backends_kf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_real_change_alias_co (FolksBackendsKfPersonaChangeAliasData* _data_);
GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_);
static void folks_backends_kf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_kf_persona_real_change_im_addresses_data_free (gpointer _data);
static void folks_backends_kf_persona_real_change_im_addresses (FolksImDetails* base, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_real_change_im_addresses_co (FolksBackendsKfPersonaChangeImAddressesData* _data_);
static void folks_backends_kf_persona_change_im_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_kf_persona_real_change_web_service_addresses_data_free (gpointer _data);
static void folks_backends_kf_persona_real_change_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_real_change_web_service_addresses_co (FolksBackendsKfPersonaChangeWebServiceAddressesData* _data_);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void folks_backends_kf_persona_change_web_service_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key);
static void folks_backends_kf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void folks_backends_kf_persona_finalize (GObject* obj);
static void _vala_folks_backends_kf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_kf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* FOLKS_BACKENDS_KF_PERSONA__linkable_properties[2] = {"im-addresses", "web-service-addresses"};
static const gchar* FOLKS_BACKENDS_KF_PERSONA__writeable_properties[3] = {"alias", "im-addresses", "web-service-addresses"};

static void folks_backends_kf_persona_real_change_alias_data_free (gpointer _data) {
	FolksBackendsKfPersonaChangeAliasData* _data_;
	_data_ = _data;
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaChangeAliasData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_kf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersona * self;
	FolksBackendsKfPersonaChangeAliasData* _data_;
	FolksBackendsKfPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (FolksBackendsKfPersona*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_real_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_real_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = alias;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->alias = _tmp2_;
	folks_backends_kf_persona_real_change_alias_co (_data_);
}


static void folks_backends_kf_persona_real_change_alias_finish (FolksAliasDetails* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaChangeAliasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void folks_backends_kf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaChangeAliasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_real_change_alias_co (_data_);
}


static gboolean folks_backends_kf_persona_real_change_alias_co (FolksBackendsKfPersonaChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->alias;
	if (_data_->_tmp0_ == NULL) {
		_data_->alias = "";
	}
	_data_->_tmp1_ = _data_->self->priv->_alias;
	_data_->_tmp2_ = _data_->alias;
	if (g_strcmp0 (_data_->_tmp1_, _data_->_tmp2_) == 0) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = folks_persona_get_uid ((FolksPersona*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->alias;
	g_debug ("kf-persona.vala:100: Setting alias of Kf.Persona '%s' to '%s'.", _data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->self->priv->_key_file;
	_data_->_tmp7_ = folks_persona_get_display_id ((FolksPersona*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->alias;
	g_key_file_set_string (_data_->_tmp6_, _data_->_tmp8_, "__alias", _data_->_tmp9_);
	_data_->_tmp10_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_state_ = 1;
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_data_->_tmp11_), folks_backends_kf_persona_change_alias_ready, _data_);
	return FALSE;
	_state_1:
	folks_backends_kf_persona_store_save_key_file_finish (FOLKS_BACKENDS_KF_PERSONA_STORE (_data_->_tmp11_), _data_->_res_);
	_data_->_tmp12_ = _data_->alias;
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_g_free0 (_data_->self->priv->_alias);
	_data_->self->priv->_alias = _data_->_tmp13_;
	g_object_notify ((GObject*) _data_->self, "alias");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_real_change_im_addresses_data_free (gpointer _data) {
	FolksBackendsKfPersonaChangeImAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->im_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaChangeImAddressesData, _data_);
}


static void folks_backends_kf_persona_real_change_im_addresses (FolksImDetails* base, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersona * self;
	FolksBackendsKfPersonaChangeImAddressesData* _data_;
	FolksBackendsKfPersona* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	self = (FolksBackendsKfPersona*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaChangeImAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_real_change_im_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_real_change_im_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = im_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->im_addresses = _tmp2_;
	folks_backends_kf_persona_real_change_im_addresses_co (_data_);
}


static void folks_backends_kf_persona_real_change_im_addresses_finish (FolksImDetails* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaChangeImAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void folks_backends_kf_persona_change_im_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaChangeImAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_real_change_im_addresses_co (_data_);
}


static gboolean folks_backends_kf_persona_real_change_im_addresses_co (FolksBackendsKfPersonaChangeImAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_im_addresses;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gee_multi_map_get_keys ((GeeMultiMap*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp2_);
		_data_->_protocol1_it = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_protocol1_it;
			_data_->_tmp6_ = FALSE;
			_data_->_tmp6_ = gee_iterator_next (_data_->_tmp5_);
			if (!_data_->_tmp6_) {
				break;
			}
			_data_->_tmp7_ = _data_->_protocol1_it;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->protocol1 = (gchar*) _data_->_tmp8_;
			{
				_data_->_tmp9_ = _data_->self->priv->_key_file;
				_data_->_tmp10_ = folks_persona_get_display_id ((FolksPersona*) _data_->self);
				_data_->_tmp11_ = _data_->_tmp10_;
				_data_->_tmp12_ = _data_->protocol1;
				g_key_file_remove_key (_data_->_tmp9_, _data_->_tmp11_, _data_->_tmp12_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					if (_data_->_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					_g_free0 (_data_->protocol1);
					_g_object_unref0 (_data_->_protocol1_it);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			goto __finally1;
			__catch1_g_key_file_error:
			{
				_data_->e1 = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_g_error_free0 (_data_->e1);
			}
			__finally1:
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_free0 (_data_->protocol1);
					_g_object_unref0 (_data_->_protocol1_it);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_free0 (_data_->protocol1);
					_g_object_unref0 (_data_->_protocol1_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_free0 (_data_->protocol1);
		}
		_g_object_unref0 (_data_->_protocol1_it);
	}
	_data_->_tmp13_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_data_->new_im_addresses = _data_->_tmp13_;
	{
		_data_->_tmp14_ = _data_->im_addresses;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = gee_multi_map_get_keys (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_g_object_unref0 (_data_->_tmp16_);
		_data_->_protocol2_it = _data_->_tmp18_;
		while (TRUE) {
			_data_->_tmp19_ = _data_->_protocol2_it;
			_data_->_tmp20_ = FALSE;
			_data_->_tmp20_ = gee_iterator_next (_data_->_tmp19_);
			if (!_data_->_tmp20_) {
				break;
			}
			_data_->_tmp21_ = _data_->_protocol2_it;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = gee_iterator_get (_data_->_tmp21_);
			_data_->protocol2 = (gchar*) _data_->_tmp22_;
			_data_->_tmp23_ = _data_->im_addresses;
			_data_->_tmp24_ = _data_->protocol2;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = gee_multi_map_get (_data_->_tmp23_, _data_->_tmp24_);
			_data_->addresses = _data_->_tmp25_;
			_data_->_tmp26_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
			_data_->normalised_addresses = _data_->_tmp26_;
			{
				_data_->_tmp27_ = _data_->addresses;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp27_);
				_data_->_im_fd_it = _data_->_tmp28_;
				while (TRUE) {
					_data_->_tmp29_ = _data_->_im_fd_it;
					_data_->_tmp30_ = FALSE;
					_data_->_tmp30_ = gee_iterator_next (_data_->_tmp29_);
					if (!_data_->_tmp30_) {
						break;
					}
					_data_->_tmp31_ = _data_->_im_fd_it;
					_data_->_tmp32_ = NULL;
					_data_->_tmp32_ = gee_iterator_get (_data_->_tmp31_);
					_data_->im_fd = (FolksImFieldDetails*) _data_->_tmp32_;
					{
						_data_->_tmp33_ = _data_->im_fd;
						_data_->_tmp34_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data_->_tmp33_);
						_data_->_tmp35_ = _data_->_tmp34_;
						_data_->_tmp36_ = _data_->protocol2;
						_data_->_tmp37_ = NULL;
						_data_->_tmp37_ = folks_im_details_normalise_im_address ((const gchar*) _data_->_tmp35_, _data_->_tmp36_, &_data_->_inner_error_);
						_data_->_tmp38_ = _data_->_tmp37_;
						if (_data_->_inner_error_ != NULL) {
							if (_data_->_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
								goto __catch2_folks_im_details_error;
							}
							_g_free0 (_data_->normalised_address);
							_g_object_unref0 (_data_->im_fd);
							_g_object_unref0 (_data_->_im_fd_it);
							_g_object_unref0 (_data_->normalised_addresses);
							_g_object_unref0 (_data_->addresses);
							_g_free0 (_data_->protocol2);
							_g_object_unref0 (_data_->_protocol2_it);
							_g_object_unref0 (_data_->new_im_addresses);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
							g_clear_error (&_data_->_inner_error_);
							return FALSE;
						}
						_g_free0 (_data_->normalised_address);
						_data_->normalised_address = _data_->_tmp38_;
					}
					goto __finally2;
					__catch2_folks_im_details_error:
					{
						_data_->e2 = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_data_->_tmp39_ = NULL;
						_data_->_tmp39_ = _ ("Invalid IM address ‘%s’ for protocol ‘%s’: %s");
						_data_->_tmp40_ = _data_->im_fd;
						_data_->_tmp41_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data_->_tmp40_);
						_data_->_tmp42_ = _data_->_tmp41_;
						_data_->_tmp43_ = _data_->protocol2;
						_data_->_tmp44_ = _data_->e2;
						_data_->_tmp45_ = _data_->_tmp44_->message;
						_data_->_tmp46_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_INVALID_VALUE, _data_->_tmp39_, (const gchar*) _data_->_tmp42_, _data_->_tmp43_, _data_->_tmp45_);
						_data_->_inner_error_ = _data_->_tmp46_;
						_g_error_free0 (_data_->e2);
						goto __finally2;
					}
					__finally2:
					if (_data_->_inner_error_ != NULL) {
						if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
							g_error_free (_data_->_inner_error_);
							_g_free0 (_data_->normalised_address);
							_g_object_unref0 (_data_->im_fd);
							_g_object_unref0 (_data_->_im_fd_it);
							_g_object_unref0 (_data_->normalised_addresses);
							_g_object_unref0 (_data_->addresses);
							_g_free0 (_data_->protocol2);
							_g_object_unref0 (_data_->_protocol2_it);
							_g_object_unref0 (_data_->new_im_addresses);
							if (_data_->_state_ == 0) {
								g_simple_async_result_complete_in_idle (_data_->_async_result);
							} else {
								g_simple_async_result_complete (_data_->_async_result);
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						} else {
							_g_free0 (_data_->normalised_address);
							_g_object_unref0 (_data_->im_fd);
							_g_object_unref0 (_data_->_im_fd_it);
							_g_object_unref0 (_data_->normalised_addresses);
							_g_object_unref0 (_data_->addresses);
							_g_free0 (_data_->protocol2);
							_g_object_unref0 (_data_->_protocol2_it);
							_g_object_unref0 (_data_->new_im_addresses);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
							g_clear_error (&_data_->_inner_error_);
							return FALSE;
						}
					}
					_data_->_tmp47_ = _data_->normalised_addresses;
					_data_->_tmp48_ = _data_->normalised_address;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp47_, _data_->_tmp48_);
					_data_->_tmp49_ = _data_->normalised_address;
					_data_->_tmp50_ = folks_im_field_details_new (_data_->_tmp49_, NULL);
					_data_->new_im_fd = _data_->_tmp50_;
					_data_->_tmp51_ = _data_->new_im_addresses;
					_data_->_tmp52_ = _data_->protocol2;
					_data_->_tmp53_ = _data_->new_im_fd;
					gee_multi_map_set ((GeeMultiMap*) _data_->_tmp51_, _data_->_tmp52_, _data_->_tmp53_);
					_g_object_unref0 (_data_->new_im_fd);
					_g_free0 (_data_->normalised_address);
					_g_object_unref0 (_data_->im_fd);
				}
				_g_object_unref0 (_data_->_im_fd_it);
			}
			_data_->_tmp54_ = _data_->normalised_addresses;
			_data_->_tmp55_ = 0;
			_data_->_tmp56_ = NULL;
			_data_->_tmp56_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _data_->_tmp54_, &_data_->_tmp55_);
			_data_->addrs = (gchar**) _data_->_tmp56_;
			_data_->addrs_length1 = _data_->_tmp55_;
			_data_->_addrs_size_ = _data_->addrs_length1;
			_data_->_tmp57_ = _data_->normalised_addresses;
			_data_->_tmp58_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp57_);
			_data_->_tmp59_ = _data_->_tmp58_;
			_data_->addrs_length1 = _data_->_tmp59_;
			_data_->_tmp60_ = _data_->addrs_length1;
			_data_->_tmp61_ = _data_->self->priv->_key_file;
			_data_->_tmp62_ = folks_persona_get_display_id ((FolksPersona*) _data_->self);
			_data_->_tmp63_ = _data_->_tmp62_;
			_data_->_tmp64_ = _data_->protocol2;
			_data_->_tmp65_ = _data_->addrs;
			_data_->_tmp65__length1 = _data_->addrs_length1;
			g_key_file_set_string_list (_data_->_tmp61_, _data_->_tmp63_, _data_->_tmp64_, (const gchar* const*) _data_->_tmp65_, _data_->_tmp65__length1);
			_data_->addrs = (_vala_array_free (_data_->addrs, _data_->addrs_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->normalised_addresses);
			_g_object_unref0 (_data_->addresses);
			_g_free0 (_data_->protocol2);
		}
		_g_object_unref0 (_data_->_protocol2_it);
	}
	_data_->_tmp66_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp67_ = _data_->_tmp66_;
	_data_->_state_ = 1;
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_data_->_tmp67_), folks_backends_kf_persona_change_im_addresses_ready, _data_);
	return FALSE;
	_state_1:
	folks_backends_kf_persona_store_save_key_file_finish (FOLKS_BACKENDS_KF_PERSONA_STORE (_data_->_tmp67_), _data_->_res_);
	_data_->_tmp68_ = _data_->new_im_addresses;
	_data_->_tmp69_ = _g_object_ref0 (_data_->_tmp68_);
	_g_object_unref0 (_data_->self->priv->_im_addresses);
	_data_->self->priv->_im_addresses = _data_->_tmp69_;
	g_object_notify ((GObject*) _data_->self, "im-addresses");
	_g_object_unref0 (_data_->new_im_addresses);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_real_change_web_service_addresses_data_free (gpointer _data) {
	FolksBackendsKfPersonaChangeWebServiceAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->web_service_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaChangeWebServiceAddressesData, _data_);
}


static void folks_backends_kf_persona_real_change_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersona * self;
	FolksBackendsKfPersonaChangeWebServiceAddressesData* _data_;
	FolksBackendsKfPersona* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	self = (FolksBackendsKfPersona*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaChangeWebServiceAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_real_change_web_service_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_real_change_web_service_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = web_service_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->web_service_addresses = _tmp2_;
	folks_backends_kf_persona_real_change_web_service_addresses_co (_data_);
}


static void folks_backends_kf_persona_real_change_web_service_addresses_finish (FolksWebServiceDetails* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaChangeWebServiceAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void folks_backends_kf_persona_change_web_service_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaChangeWebServiceAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_real_change_web_service_addresses_co (_data_);
}


static gboolean folks_backends_kf_persona_real_change_web_service_addresses_co (FolksBackendsKfPersonaChangeWebServiceAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_web_service_addresses;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gee_multi_map_get_keys ((GeeMultiMap*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp2_);
		_data_->_web_service1_it = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_web_service1_it;
			_data_->_tmp6_ = FALSE;
			_data_->_tmp6_ = gee_iterator_next (_data_->_tmp5_);
			if (!_data_->_tmp6_) {
				break;
			}
			_data_->_tmp7_ = _data_->_web_service1_it;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->web_service1 = (gchar*) _data_->_tmp8_;
			{
				_data_->_tmp9_ = _data_->self->priv->_key_file;
				_data_->_tmp10_ = folks_persona_get_display_id ((FolksPersona*) _data_->self);
				_data_->_tmp11_ = _data_->_tmp10_;
				_data_->_tmp12_ = _data_->web_service1;
				_data_->_tmp13_ = g_strconcat ("web-service.", _data_->_tmp12_, NULL);
				_data_->_tmp14_ = _data_->_tmp13_;
				g_key_file_remove_key (_data_->_tmp9_, _data_->_tmp11_, _data_->_tmp14_, &_data_->_inner_error_);
				_g_free0 (_data_->_tmp14_);
				if (_data_->_inner_error_ != NULL) {
					if (_data_->_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch3_g_key_file_error;
					}
					_g_free0 (_data_->web_service1);
					_g_object_unref0 (_data_->_web_service1_it);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			goto __finally3;
			__catch3_g_key_file_error:
			{
				_data_->e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_g_error_free0 (_data_->e);
			}
			__finally3:
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_free0 (_data_->web_service1);
					_g_object_unref0 (_data_->_web_service1_it);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_free0 (_data_->web_service1);
					_g_object_unref0 (_data_->_web_service1_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_g_free0 (_data_->web_service1);
		}
		_g_object_unref0 (_data_->_web_service1_it);
	}
	_data_->_tmp15_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_data_->new_web_service_addresses = _data_->_tmp15_;
	{
		_data_->_tmp16_ = _data_->web_service_addresses;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_multi_map_get_keys (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_object_unref0 (_data_->_tmp18_);
		_data_->_web_service2_it = _data_->_tmp20_;
		while (TRUE) {
			_data_->_tmp21_ = _data_->_web_service2_it;
			_data_->_tmp22_ = FALSE;
			_data_->_tmp22_ = gee_iterator_next (_data_->_tmp21_);
			if (!_data_->_tmp22_) {
				break;
			}
			_data_->_tmp23_ = _data_->_web_service2_it;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = gee_iterator_get (_data_->_tmp23_);
			_data_->web_service2 = (gchar*) _data_->_tmp24_;
			_data_->_tmp25_ = _data_->web_service_addresses;
			_data_->_tmp26_ = _data_->web_service2;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = gee_multi_map_get (_data_->_tmp25_, _data_->_tmp26_);
			_data_->ws_fds = _data_->_tmp27_;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = g_new0 (gchar*, 0 + 1);
			_data_->addrs = _data_->_tmp28_;
			_data_->addrs_length1 = 0;
			_data_->_addrs_size_ = _data_->addrs_length1;
			{
				_data_->_tmp29_ = _data_->ws_fds;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp29_);
				_data_->_ws_fd1_it = _data_->_tmp30_;
				while (TRUE) {
					_data_->_tmp31_ = _data_->_ws_fd1_it;
					_data_->_tmp32_ = FALSE;
					_data_->_tmp32_ = gee_iterator_next (_data_->_tmp31_);
					if (!_data_->_tmp32_) {
						break;
					}
					_data_->_tmp33_ = _data_->_ws_fd1_it;
					_data_->_tmp34_ = NULL;
					_data_->_tmp34_ = gee_iterator_get (_data_->_tmp33_);
					_data_->ws_fd1 = (FolksWebServiceFieldDetails*) _data_->_tmp34_;
					_data_->_tmp35_ = _data_->addrs;
					_data_->_tmp35__length1 = _data_->addrs_length1;
					_data_->_tmp36_ = _data_->ws_fd1;
					_data_->_tmp37_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data_->_tmp36_);
					_data_->_tmp38_ = _data_->_tmp37_;
					_data_->_tmp39_ = g_strdup ((const gchar*) _data_->_tmp38_);
					_vala_array_add1 (&_data_->addrs, &_data_->addrs_length1, &_data_->_addrs_size_, _data_->_tmp39_);
					_g_object_unref0 (_data_->ws_fd1);
				}
				_g_object_unref0 (_data_->_ws_fd1_it);
			}
			_data_->_tmp40_ = _data_->self->priv->_key_file;
			_data_->_tmp41_ = folks_persona_get_display_id ((FolksPersona*) _data_->self);
			_data_->_tmp42_ = _data_->_tmp41_;
			_data_->_tmp43_ = _data_->web_service2;
			_data_->_tmp44_ = g_strconcat ("web-service.", _data_->_tmp43_, NULL);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp46_ = _data_->addrs;
			_data_->_tmp46__length1 = _data_->addrs_length1;
			g_key_file_set_string_list (_data_->_tmp40_, _data_->_tmp42_, _data_->_tmp45_, (const gchar* const*) _data_->_tmp46_, _data_->_tmp46__length1);
			_g_free0 (_data_->_tmp45_);
			{
				_data_->_tmp47_ = _data_->ws_fds;
				_data_->_tmp48_ = NULL;
				_data_->_tmp48_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp47_);
				_data_->_ws_fd2_it = _data_->_tmp48_;
				while (TRUE) {
					_data_->_tmp49_ = _data_->_ws_fd2_it;
					_data_->_tmp50_ = FALSE;
					_data_->_tmp50_ = gee_iterator_next (_data_->_tmp49_);
					if (!_data_->_tmp50_) {
						break;
					}
					_data_->_tmp51_ = _data_->_ws_fd2_it;
					_data_->_tmp52_ = NULL;
					_data_->_tmp52_ = gee_iterator_get (_data_->_tmp51_);
					_data_->ws_fd2 = (FolksWebServiceFieldDetails*) _data_->_tmp52_;
					_data_->_tmp53_ = _data_->new_web_service_addresses;
					_data_->_tmp54_ = _data_->web_service2;
					_data_->_tmp55_ = _data_->ws_fd2;
					gee_multi_map_set ((GeeMultiMap*) _data_->_tmp53_, _data_->_tmp54_, _data_->_tmp55_);
					_g_object_unref0 (_data_->ws_fd2);
				}
				_g_object_unref0 (_data_->_ws_fd2_it);
			}
			_data_->addrs = (_vala_array_free (_data_->addrs, _data_->addrs_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->ws_fds);
			_g_free0 (_data_->web_service2);
		}
		_g_object_unref0 (_data_->_web_service2_it);
	}
	_data_->_tmp56_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp57_ = _data_->_tmp56_;
	_data_->_state_ = 1;
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_data_->_tmp57_), folks_backends_kf_persona_change_web_service_addresses_ready, _data_);
	return FALSE;
	_state_1:
	folks_backends_kf_persona_store_save_key_file_finish (FOLKS_BACKENDS_KF_PERSONA_STORE (_data_->_tmp57_), _data_->_res_);
	_data_->_tmp58_ = _data_->new_web_service_addresses;
	_data_->_tmp59_ = _g_object_ref0 (_data_->_tmp58_);
	_g_object_unref0 (_data_->self->priv->_web_service_addresses);
	_data_->self->priv->_web_service_addresses = _data_->_tmp59_;
	g_object_notify ((GObject*) _data_->self, "web-service-addresses");
	_g_object_unref0 (_data_->new_web_service_addresses);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the Persona given by the group `uid` in the key file `key_file`.
   */
static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key) {
	guint result;
	result = folks_abstract_field_details_hash (key);
	return result;
}


FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store) {
	FolksBackendsKfPersona * self = NULL;
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* iid;
	FolksPersonaStore* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* uid;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	FolksPersonaStore* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GKeyFile* _tmp20_;
	GeeHashMultiMap* _tmp21_;
	GeeHashMultiMap* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = id;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	iid = _tmp7_;
	_tmp8_ = store;
	_tmp9_ = folks_persona_store_get_id (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = id;
	_tmp12_ = folks_persona_build_uid ("key-file", _tmp10_, _tmp11_);
	uid = _tmp12_;
	_tmp13_ = id;
	_tmp14_ = iid;
	_tmp15_ = uid;
	_tmp16_ = store;
	self = (FolksBackendsKfPersona*) g_object_new (object_type, "display-id", _tmp13_, "iid", _tmp14_, "uid", _tmp15_, "store", _tmp16_, "is-user", FALSE, NULL);
	_tmp17_ = uid;
	_tmp18_ = iid;
	_tmp19_ = id;
	g_debug ("kf-persona.vala:272: Adding key-file Persona '%s' (IID '%s', group '%s" \
"')", _tmp17_, _tmp18_, _tmp19_);
	_tmp20_ = key_file;
	self->priv->_key_file = _tmp20_;
	_tmp21_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, _folks_abstract_field_details_hash_ghash_func, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp21_;
	_tmp22_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = _tmp22_;
	{
		GKeyFile* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gsize _tmp26_;
		gchar** _tmp27_ = NULL;
		gchar** keys;
		gint keys_length1;
		gint _keys_size_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		_tmp23_ = self->priv->_key_file;
		_tmp24_ = folks_persona_get_display_id ((FolksPersona*) self);
		_tmp25_ = _tmp24_;
		_tmp27_ = g_key_file_get_keys (_tmp23_, _tmp25_, &_tmp26_, &_inner_error_);
		keys = _tmp27_;
		keys_length1 = _tmp26_;
		_keys_size_ = keys_length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			_g_free0 (uid);
			_g_free0 (iid);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp28_ = keys;
		_tmp28__length1 = keys_length1;
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp28_;
			key_collection_length1 = _tmp28__length1;
			for (key_it = 0; key_it < _tmp28__length1; key_it = key_it + 1) {
				const gchar* key = NULL;
				key = key_collection[key_it];
				{
					const gchar* _tmp29_;
					const gchar* _tmp39_;
					gchar** _tmp40_;
					gchar** _tmp41_ = NULL;
					gchar** decomposed_key;
					gint decomposed_key_length1;
					gint _decomposed_key_size_;
					gboolean _tmp42_ = FALSE;
					gchar** _tmp43_;
					gint _tmp43__length1;
					gboolean _tmp46_;
					const gchar* _tmp62_;
					const gchar* protocol;
					GKeyFile* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					const gchar* _tmp66_;
					gsize _tmp67_;
					gchar** _tmp68_ = NULL;
					gchar** im_addresses;
					gint im_addresses_length1;
					gint _im_addresses_size_;
					gchar** _tmp69_;
					gint _tmp69__length1;
					_tmp29_ = key;
					if (g_strcmp0 (_tmp29_, "__alias") == 0) {
						GKeyFile* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_ = NULL;
						gchar* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp38_;
						_tmp30_ = self->priv->_key_file;
						_tmp31_ = folks_persona_get_display_id ((FolksPersona*) self);
						_tmp32_ = _tmp31_;
						_tmp33_ = key;
						_tmp34_ = g_key_file_get_string (_tmp30_, _tmp32_, _tmp33_, &_inner_error_);
						_tmp35_ = _tmp34_;
						if (_inner_error_ != NULL) {
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error_->domain == G_KEY_FILE_ERROR) {
								goto __catch4_g_key_file_error;
							}
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (uid);
							_g_free0 (iid);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_free0 (self->priv->_alias);
						self->priv->_alias = _tmp35_;
						_tmp36_ = self->priv->_alias;
						if (_tmp36_ == NULL) {
							gchar* _tmp37_;
							_tmp37_ = g_strdup ("");
							_g_free0 (self->priv->_alias);
							self->priv->_alias = _tmp37_;
						}
						_tmp38_ = self->priv->_alias;
						g_debug ("kf-persona.vala:301:     Loaded alias '%s'.", _tmp38_);
						continue;
					}
					_tmp39_ = key;
					_tmp41_ = _tmp40_ = g_strsplit (_tmp39_, ".", 2);
					decomposed_key = _tmp41_;
					decomposed_key_length1 = _vala_array_length (_tmp40_);
					_decomposed_key_size_ = decomposed_key_length1;
					_tmp43_ = decomposed_key;
					_tmp43__length1 = decomposed_key_length1;
					if (_tmp43__length1 == 2) {
						gchar** _tmp44_;
						gint _tmp44__length1;
						const gchar* _tmp45_;
						_tmp44_ = decomposed_key;
						_tmp44__length1 = decomposed_key_length1;
						_tmp45_ = _tmp44_[0];
						_tmp42_ = g_strcmp0 (_tmp45_, "web-service") == 0;
					} else {
						_tmp42_ = FALSE;
					}
					_tmp46_ = _tmp42_;
					if (_tmp46_) {
						gchar** _tmp47_;
						gint _tmp47__length1;
						const gchar* _tmp48_;
						const gchar* web_service;
						GKeyFile* _tmp49_;
						const gchar* _tmp50_;
						const gchar* _tmp51_;
						const gchar* _tmp52_;
						gsize _tmp53_;
						gchar** _tmp54_ = NULL;
						gchar** web_service_addresses;
						gint web_service_addresses_length1;
						gint _web_service_addresses_size_;
						gchar** _tmp55_;
						gint _tmp55__length1;
						_tmp47_ = decomposed_key;
						_tmp47__length1 = decomposed_key_length1;
						_tmp48_ = _tmp47_[1];
						web_service = _tmp48_;
						_tmp49_ = self->priv->_key_file;
						_tmp50_ = folks_persona_get_display_id ((FolksPersona*) self);
						_tmp51_ = _tmp50_;
						_tmp52_ = web_service;
						_tmp54_ = g_key_file_get_string_list (_tmp49_, _tmp51_, _tmp52_, &_tmp53_, &_inner_error_);
						web_service_addresses = _tmp54_;
						web_service_addresses_length1 = _tmp53_;
						_web_service_addresses_size_ = web_service_addresses_length1;
						if (_inner_error_ != NULL) {
							decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error_->domain == G_KEY_FILE_ERROR) {
								goto __catch4_g_key_file_error;
							}
							decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (uid);
							_g_free0 (iid);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp55_ = web_service_addresses;
						_tmp55__length1 = web_service_addresses_length1;
						{
							gchar** web_service_address_collection = NULL;
							gint web_service_address_collection_length1 = 0;
							gint _web_service_address_collection_size_ = 0;
							gint web_service_address_it = 0;
							web_service_address_collection = _tmp55_;
							web_service_address_collection_length1 = _tmp55__length1;
							for (web_service_address_it = 0; web_service_address_it < _tmp55__length1; web_service_address_it = web_service_address_it + 1) {
								gchar* _tmp56_;
								gchar* web_service_address = NULL;
								_tmp56_ = g_strdup (web_service_address_collection[web_service_address_it]);
								web_service_address = _tmp56_;
								{
									GeeHashMultiMap* _tmp57_;
									const gchar* _tmp58_;
									const gchar* _tmp59_;
									FolksWebServiceFieldDetails* _tmp60_;
									FolksWebServiceFieldDetails* _tmp61_;
									_tmp57_ = self->priv->_web_service_addresses;
									_tmp58_ = web_service;
									_tmp59_ = web_service_address;
									_tmp60_ = folks_web_service_field_details_new (_tmp59_, NULL);
									_tmp61_ = _tmp60_;
									gee_multi_map_set ((GeeMultiMap*) _tmp57_, _tmp58_, _tmp61_);
									_g_object_unref0 (_tmp61_);
									_g_free0 (web_service_address);
								}
							}
						}
						web_service_addresses = (_vala_array_free (web_service_addresses, web_service_addresses_length1, (GDestroyNotify) g_free), NULL);
						decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
						continue;
					}
					_tmp62_ = key;
					protocol = _tmp62_;
					_tmp63_ = self->priv->_key_file;
					_tmp64_ = folks_persona_get_display_id ((FolksPersona*) self);
					_tmp65_ = _tmp64_;
					_tmp66_ = protocol;
					_tmp68_ = g_key_file_get_string_list (_tmp63_, _tmp65_, _tmp66_, &_tmp67_, &_inner_error_);
					im_addresses = _tmp68_;
					im_addresses_length1 = _tmp67_;
					_im_addresses_size_ = im_addresses_length1;
					if (_inner_error_ != NULL) {
						decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch4_g_key_file_error;
						}
						decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (uid);
						_g_free0 (iid);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp69_ = im_addresses;
					_tmp69__length1 = im_addresses_length1;
					{
						gchar** im_address_collection = NULL;
						gint im_address_collection_length1 = 0;
						gint _im_address_collection_size_ = 0;
						gint im_address_it = 0;
						im_address_collection = _tmp69_;
						im_address_collection_length1 = _tmp69__length1;
						for (im_address_it = 0; im_address_it < _tmp69__length1; im_address_it = im_address_it + 1) {
							gchar* _tmp70_;
							gchar* im_address = NULL;
							_tmp70_ = g_strdup (im_address_collection[im_address_it]);
							im_address = _tmp70_;
							{
								gchar* address = NULL;
								const gchar* _tmp77_;
								FolksImFieldDetails* _tmp78_;
								FolksImFieldDetails* im_fd;
								GeeHashMultiMap* _tmp79_;
								const gchar* _tmp80_;
								FolksImFieldDetails* _tmp81_;
								{
									const gchar* _tmp71_;
									const gchar* _tmp72_;
									gchar* _tmp73_ = NULL;
									gchar* _tmp74_;
									_tmp71_ = im_address;
									_tmp72_ = protocol;
									_tmp73_ = folks_im_details_normalise_im_address (_tmp71_, _tmp72_, &_inner_error_);
									_tmp74_ = _tmp73_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
											goto __catch5_folks_im_details_error;
										}
										_g_free0 (address);
										_g_free0 (im_address);
										im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
										decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (uid);
										_g_free0 (iid);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
									_g_free0 (address);
									address = _tmp74_;
								}
								goto __finally5;
								__catch5_folks_im_details_error:
								{
									GError* e = NULL;
									GError* _tmp75_;
									const gchar* _tmp76_;
									e = _inner_error_;
									_inner_error_ = NULL;
									_tmp75_ = e;
									_tmp76_ = _tmp75_->message;
									g_warning ("kf-persona.vala:339: %s", _tmp76_);
									_g_error_free0 (e);
									_g_free0 (address);
									_g_free0 (im_address);
									continue;
								}
								__finally5:
								if (_inner_error_ != NULL) {
									_g_free0 (address);
									_g_free0 (im_address);
									im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
									decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch4_g_key_file_error;
									}
									_g_free0 (address);
									_g_free0 (im_address);
									im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
									decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (uid);
									_g_free0 (iid);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp77_ = address;
								_tmp78_ = folks_im_field_details_new (_tmp77_, NULL);
								im_fd = _tmp78_;
								_tmp79_ = self->priv->_im_addresses;
								_tmp80_ = protocol;
								_tmp81_ = im_fd;
								gee_multi_map_set ((GeeMultiMap*) _tmp79_, _tmp80_, _tmp81_);
								_g_object_unref0 (im_fd);
								_g_free0 (address);
								_g_free0 (im_address);
							}
						}
					}
					im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
					decomposed_key = (_vala_array_free (decomposed_key, decomposed_key_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp82_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp82_ = e;
		if (!g_error_matches (_tmp82_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			const gchar* _tmp83_ = NULL;
			GError* _tmp84_;
			const gchar* _tmp85_;
			_tmp83_ = _ ("Couldn't load data from key file: %s");
			_tmp84_ = e;
			_tmp85_ = _tmp84_->message;
			g_warning (_tmp83_, _tmp85_);
		}
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (uid);
		_g_free0 (iid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (uid);
	_g_free0 (iid);
	return self;
}


FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store) {
	return folks_backends_kf_persona_construct (FOLKS_BACKENDS_KF_TYPE_PERSONA, key_file, id, store);
}


/**
   * {@inheritDoc}
   */
static void folks_backends_kf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksBackendsKfPersona * self;
	const gchar* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "im-addresses") == 0) {
		{
			GeeHashMultiMap* _tmp1_;
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_;
			GeeIterator* _protocol_it;
			_tmp1_ = self->priv->_im_addresses;
			_tmp2_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_protocol_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				gboolean _tmp7_ = FALSE;
				GeeIterator* _tmp8_;
				gpointer _tmp9_ = NULL;
				gchar* protocol;
				GeeHashMultiMap* _tmp10_;
				const gchar* _tmp11_;
				GeeCollection* _tmp12_ = NULL;
				GeeCollection* im_addresses;
				_tmp6_ = _protocol_it;
				_tmp7_ = gee_iterator_next (_tmp6_);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = _protocol_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				protocol = (gchar*) _tmp9_;
				_tmp10_ = self->priv->_im_addresses;
				_tmp11_ = protocol;
				_tmp12_ = gee_multi_map_get ((GeeMultiMap*) _tmp10_, _tmp11_);
				im_addresses = _tmp12_;
				{
					GeeCollection* _tmp13_;
					GeeIterator* _tmp14_ = NULL;
					GeeIterator* _im_fd_it;
					_tmp13_ = im_addresses;
					_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
					_im_fd_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_;
						gboolean _tmp16_ = FALSE;
						GeeIterator* _tmp17_;
						gpointer _tmp18_ = NULL;
						FolksImFieldDetails* im_fd;
						FolksPersonaLinkablePropertyCallback _tmp19_;
						void* _tmp19__target;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						FolksImFieldDetails* _tmp23_;
						gconstpointer _tmp24_;
						const gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp15_ = _im_fd_it;
						_tmp16_ = gee_iterator_next (_tmp15_);
						if (!_tmp16_) {
							break;
						}
						_tmp17_ = _im_fd_it;
						_tmp18_ = gee_iterator_get (_tmp17_);
						im_fd = (FolksImFieldDetails*) _tmp18_;
						_tmp19_ = callback;
						_tmp19__target = callback_target;
						_tmp20_ = protocol;
						_tmp21_ = g_strconcat (_tmp20_, ":", NULL);
						_tmp22_ = _tmp21_;
						_tmp23_ = im_fd;
						_tmp24_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strconcat (_tmp22_, (const gchar*) _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						_tmp19_ (_tmp27_, _tmp19__target);
						_g_free0 (_tmp27_);
						_g_free0 (_tmp22_);
						_g_object_unref0 (im_fd);
					}
					_g_object_unref0 (_im_fd_it);
				}
				_g_object_unref0 (im_addresses);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
	} else {
		const gchar* _tmp28_;
		_tmp28_ = prop_name;
		if (g_strcmp0 (_tmp28_, "web-service-addresses") == 0) {
			{
				GeeMultiMap* _tmp29_;
				GeeMultiMap* _tmp30_;
				GeeSet* _tmp31_ = NULL;
				GeeSet* _tmp32_;
				GeeIterator* _tmp33_ = NULL;
				GeeIterator* _tmp34_;
				GeeIterator* _web_service_it;
				_tmp29_ = folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self);
				_tmp30_ = _tmp29_;
				_tmp31_ = gee_multi_map_get_keys (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
				_tmp34_ = _tmp33_;
				_g_object_unref0 (_tmp32_);
				_web_service_it = _tmp34_;
				while (TRUE) {
					GeeIterator* _tmp35_;
					gboolean _tmp36_ = FALSE;
					GeeIterator* _tmp37_;
					gpointer _tmp38_ = NULL;
					gchar* web_service;
					GeeHashMultiMap* _tmp39_;
					const gchar* _tmp40_;
					GeeCollection* _tmp41_ = NULL;
					GeeCollection* web_service_addresses;
					_tmp35_ = _web_service_it;
					_tmp36_ = gee_iterator_next (_tmp35_);
					if (!_tmp36_) {
						break;
					}
					_tmp37_ = _web_service_it;
					_tmp38_ = gee_iterator_get (_tmp37_);
					web_service = (gchar*) _tmp38_;
					_tmp39_ = self->priv->_web_service_addresses;
					_tmp40_ = web_service;
					_tmp41_ = gee_multi_map_get ((GeeMultiMap*) _tmp39_, _tmp40_);
					web_service_addresses = _tmp41_;
					{
						GeeCollection* _tmp42_;
						GeeIterator* _tmp43_ = NULL;
						GeeIterator* _ws_fd_it;
						_tmp42_ = web_service_addresses;
						_tmp43_ = gee_iterable_iterator ((GeeIterable*) _tmp42_);
						_ws_fd_it = _tmp43_;
						while (TRUE) {
							GeeIterator* _tmp44_;
							gboolean _tmp45_ = FALSE;
							GeeIterator* _tmp46_;
							gpointer _tmp47_ = NULL;
							FolksWebServiceFieldDetails* ws_fd;
							FolksPersonaLinkablePropertyCallback _tmp48_;
							void* _tmp48__target;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							FolksWebServiceFieldDetails* _tmp52_;
							gconstpointer _tmp53_;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							_tmp44_ = _ws_fd_it;
							_tmp45_ = gee_iterator_next (_tmp44_);
							if (!_tmp45_) {
								break;
							}
							_tmp46_ = _ws_fd_it;
							_tmp47_ = gee_iterator_get (_tmp46_);
							ws_fd = (FolksWebServiceFieldDetails*) _tmp47_;
							_tmp48_ = callback;
							_tmp48__target = callback_target;
							_tmp49_ = web_service;
							_tmp50_ = g_strconcat (_tmp49_, ":", NULL);
							_tmp51_ = _tmp50_;
							_tmp52_ = ws_fd;
							_tmp53_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = g_strconcat (_tmp51_, (const gchar*) _tmp54_, NULL);
							_tmp56_ = _tmp55_;
							_tmp48_ (_tmp56_, _tmp48__target);
							_g_free0 (_tmp56_);
							_g_free0 (_tmp51_);
							_g_object_unref0 (ws_fd);
						}
						_g_object_unref0 (_ws_fd_it);
					}
					_g_object_unref0 (web_service_addresses);
					_g_free0 (web_service);
				}
				_g_object_unref0 (_web_service_it);
			}
		} else {
			const gchar* _tmp57_;
			FolksPersonaLinkablePropertyCallback _tmp58_;
			void* _tmp58__target;
			_tmp57_ = prop_name;
			_tmp58_ = callback;
			_tmp58__target = callback_target;
			FOLKS_PERSONA_CLASS (folks_backends_kf_persona_parent_class)->linkable_property_to_links (FOLKS_PERSONA (self), _tmp57_, _tmp58_, _tmp58__target);
		}
	}
}


static gchar** folks_backends_kf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsKfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_KF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_KF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** folks_backends_kf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsKfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_KF_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_KF_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static const gchar* folks_backends_kf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	FolksBackendsKfPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = self->priv->_alias;
	result = _tmp0_;
	return result;
}


static void folks_backends_kf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	FolksBackendsKfPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = value;
	folks_alias_details_change_alias ((FolksAliasDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* folks_backends_kf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	FolksBackendsKfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void folks_backends_kf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	FolksBackendsKfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* folks_backends_kf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	FolksBackendsKfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = self->priv->_web_service_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void folks_backends_kf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	FolksBackendsKfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = value;
	folks_web_service_details_change_web_service_addresses ((FolksWebServiceDetails*) self, _tmp0_, NULL, NULL);
}


static void folks_backends_kf_persona_class_init (FolksBackendsKfPersonaClass * klass) {
	folks_backends_kf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_backends_kf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_backends_kf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = folks_backends_kf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_kf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_persona_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.1.15
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_ALIAS, "alias");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
}


static void folks_backends_kf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	folks_backends_kf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_alias = (void (*)(FolksAliasDetails*, const gchar*, GError**)) folks_backends_kf_persona_real_change_alias;
	iface->change_alias_finish = folks_backends_kf_persona_real_change_alias_finish;
	iface->get_alias = folks_backends_kf_persona_real_get_alias;
	iface->set_alias = folks_backends_kf_persona_real_set_alias;
}


static void folks_backends_kf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	folks_backends_kf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_im_addresses = (void (*)(FolksImDetails*, GeeMultiMap*, GError**)) folks_backends_kf_persona_real_change_im_addresses;
	iface->change_im_addresses_finish = folks_backends_kf_persona_real_change_im_addresses_finish;
	iface->get_im_addresses = folks_backends_kf_persona_real_get_im_addresses;
	iface->set_im_addresses = folks_backends_kf_persona_real_set_im_addresses;
}


static void folks_backends_kf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	folks_backends_kf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_web_service_addresses = (void (*)(FolksWebServiceDetails*, GeeMultiMap*, GError**)) folks_backends_kf_persona_real_change_web_service_addresses;
	iface->change_web_service_addresses_finish = folks_backends_kf_persona_real_change_web_service_addresses_finish;
	iface->get_web_service_addresses = folks_backends_kf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = folks_backends_kf_persona_real_set_web_service_addresses;
}


static void folks_backends_kf_persona_instance_init (FolksBackendsKfPersona * self) {
	gchar* _tmp0_;
	self->priv = FOLKS_BACKENDS_KF_PERSONA_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_alias = _tmp0_;
}


static void folks_backends_kf_persona_finalize (GObject* obj) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (obj);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_web_service_addresses);
	_g_free0 (self->priv->_alias);
	G_OBJECT_CLASS (folks_backends_kf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_persona_get_type (void) {
	static volatile gsize folks_backends_kf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfPersona), 0, (GInstanceInitFunc) folks_backends_kf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_backends_kf_persona_type_id;
		folks_backends_kf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsKfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&folks_backends_kf_persona_type_id__volatile, folks_backends_kf_persona_type_id);
	}
	return folks_backends_kf_persona_type_id__volatile;
}


static void _vala_folks_backends_kf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_KF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_KF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_kf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



