// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/unixfdlist.h>
#include <giomm/private/unixfdlist_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gunixfdlist.h>

namespace Gio
{

UnixFDList::UnixFDList(const Glib::ArrayHandle<int>& fds)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(unixfdlist_class_.init(), "fds",fds.data(),"n_fds",fds.size(), static_cast<char*>(0)))
{}

const Glib::ArrayHandle<int> UnixFDList::peek_fds() const
{
  int length = 0;
  const int* fds = g_unix_fd_list_peek_fds(const_cast<GUnixFDList*>(gobj()),
    &length);
  // (length - 1) is used because the array is terminated with a -1.
  return Glib::ArrayHandle<int>(fds, length - 1, Glib::OWNERSHIP_NONE);
}

Glib::ArrayHandle<int> UnixFDList::steal_fds()
{
  int length = 0;
  const int* fds = g_unix_fd_list_steal_fds(gobj(), &length);
  // (length - 1) is used because the array is terminated with a -1.
  return Glib::ArrayHandle<int>(fds, length - 1, Glib::OWNERSHIP_DEEP);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::UnixFDList> wrap(GUnixFDList* object, bool take_copy)
{
  return Glib::RefPtr<Gio::UnixFDList>( dynamic_cast<Gio::UnixFDList*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& UnixFDList_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &UnixFDList_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_unix_fd_list_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void UnixFDList_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* UnixFDList_Class::wrap_new(GObject* object)
{
  return new UnixFDList((GUnixFDList*)object);
}


/* The implementation: */

GUnixFDList* UnixFDList::gobj_copy()
{
  reference();
  return gobj();
}

UnixFDList::UnixFDList(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

UnixFDList::UnixFDList(GUnixFDList* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


UnixFDList::~UnixFDList()
{}


UnixFDList::CppClassType UnixFDList::unixfdlist_class_; // initialize static member

GType UnixFDList::get_type()
{
  return unixfdlist_class_.init().get_type();
}


GType UnixFDList::get_base_type()
{
  return g_unix_fd_list_get_type();
}


UnixFDList::UnixFDList()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(unixfdlist_class_.init()))
{
  

}

UnixFDList::UnixFDList(const Glib::ArrayHandle<int>& fds, int n_fds)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(unixfdlist_class_.init(), "fds", fds.data(), "n_fds", n_fds, static_cast<char*>(0)))
{
  

}

Glib::RefPtr<UnixFDList> UnixFDList::create()
{
  return Glib::RefPtr<UnixFDList>( new UnixFDList() );
}

Glib::RefPtr<UnixFDList> UnixFDList::create(const Glib::ArrayHandle<int>& fds)
{
  return Glib::RefPtr<UnixFDList>( new UnixFDList(fds) );
}

Glib::RefPtr<UnixFDList> UnixFDList::create(const Glib::ArrayHandle<int>& fds, int n_fds)
{
  return Glib::RefPtr<UnixFDList>( new UnixFDList(fds, n_fds) );
}

int UnixFDList::get_length() const
{
  return g_unix_fd_list_get_length(const_cast<GUnixFDList*>(gobj()));
}

int UnixFDList::get(int index) const
{
  GError* gerror = 0;
  int retvalue = g_unix_fd_list_get(const_cast<GUnixFDList*>(gobj()), index, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

int UnixFDList::append(int fd)
{
  GError* gerror = 0;
  int retvalue = g_unix_fd_list_append(gobj(), fd, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}


} // namespace Gio


